; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,CHECK-RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVKB,CHECK-ZVKB32
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvkb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVKB,CHECK-ZVKB64

declare <vscale x 1 x i8> @llvm.vp.and.nxv1i8(<vscale x 1 x i8>, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)
declare <vscale x 1 x i8> @llvm.vp.xor.nxv1i8(<vscale x 1 x i8>, <vscale x 1 x i8>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i8> @vandn_vv_vp_nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i8> @llvm.vp.xor.nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> splat (i8 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i8> @llvm.vp.and.nxv1i8(<vscale x 1 x i8> %not.a, <vscale x 1 x i8> %b, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i8> %x
}

define <vscale x 1 x i8> @vandn_vv_vp_swapped_nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i8> @llvm.vp.xor.nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> splat (i8 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i8> @llvm.vp.and.nxv1i8(<vscale x 1 x i8> %b, <vscale x 1 x i8> %not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i8> %x
}

define <vscale x 1 x i8> @vandn_vx_vp_nxv1i8(i8 %a, <vscale x 1 x i8> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv1i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i8 %a, -1
  %head.not.a = insertelement <vscale x 1 x i8> poison, i8 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 1 x i8> %head.not.a, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i8> @llvm.vp.and.nxv1i8(<vscale x 1 x i8> %b, <vscale x 1 x i8> %splat.not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i8> %x
}

declare <vscale x 2 x i8> @llvm.vp.and.nxv2i8(<vscale x 2 x i8>, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)
declare <vscale x 2 x i8> @llvm.vp.xor.nxv2i8(<vscale x 2 x i8>, <vscale x 2 x i8>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i8> @vandn_vv_vp_nxv2i8(<vscale x 2 x i8> %a, <vscale x 2 x i8> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i8> @llvm.vp.xor.nxv2i8(<vscale x 2 x i8> %a, <vscale x 2 x i8> splat (i8 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i8> @llvm.vp.and.nxv2i8(<vscale x 2 x i8> %not.a, <vscale x 2 x i8> %b, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i8> %x
}

define <vscale x 2 x i8> @vandn_vv_vp_swapped_nxv2i8(<vscale x 2 x i8> %a, <vscale x 2 x i8> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i8> @llvm.vp.xor.nxv2i8(<vscale x 2 x i8> %a, <vscale x 2 x i8> splat (i8 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i8> @llvm.vp.and.nxv2i8(<vscale x 2 x i8> %b, <vscale x 2 x i8> %not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i8> %x
}

define <vscale x 2 x i8> @vandn_vx_vp_nxv2i8(i8 %a, <vscale x 2 x i8> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv2i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i8 %a, -1
  %head.not.a = insertelement <vscale x 2 x i8> poison, i8 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 2 x i8> %head.not.a, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i8> @llvm.vp.and.nxv2i8(<vscale x 2 x i8> %b, <vscale x 2 x i8> %splat.not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i8> %x
}

declare <vscale x 4 x i8> @llvm.vp.and.nxv4i8(<vscale x 4 x i8>, <vscale x 4 x i8>, <vscale x 4 x i1>, i32)
declare <vscale x 4 x i8> @llvm.vp.xor.nxv4i8(<vscale x 4 x i8>, <vscale x 4 x i8>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i8> @vandn_vv_vp_nxv4i8(<vscale x 4 x i8> %a, <vscale x 4 x i8> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i8> @llvm.vp.xor.nxv4i8(<vscale x 4 x i8> %a, <vscale x 4 x i8> splat (i8 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i8> @llvm.vp.and.nxv4i8(<vscale x 4 x i8> %not.a, <vscale x 4 x i8> %b, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i8> %x
}

define <vscale x 4 x i8> @vandn_vv_vp_swapped_nxv4i8(<vscale x 4 x i8> %a, <vscale x 4 x i8> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i8> @llvm.vp.xor.nxv4i8(<vscale x 4 x i8> %a, <vscale x 4 x i8> splat (i8 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i8> @llvm.vp.and.nxv4i8(<vscale x 4 x i8> %b, <vscale x 4 x i8> %not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i8> %x
}

define <vscale x 4 x i8> @vandn_vx_vp_nxv4i8(i8 %a, <vscale x 4 x i8> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv4i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i8 %a, -1
  %head.not.a = insertelement <vscale x 4 x i8> poison, i8 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 4 x i8> %head.not.a, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i8> @llvm.vp.and.nxv4i8(<vscale x 4 x i8> %b, <vscale x 4 x i8> %splat.not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i8> %x
}

declare <vscale x 8 x i8> @llvm.vp.and.nxv8i8(<vscale x 8 x i8>, <vscale x 8 x i8>, <vscale x 8 x i1>, i32)
declare <vscale x 8 x i8> @llvm.vp.xor.nxv8i8(<vscale x 8 x i8>, <vscale x 8 x i8>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i8> @vandn_vv_vp_nxv8i8(<vscale x 8 x i8> %a, <vscale x 8 x i8> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i8> @llvm.vp.xor.nxv8i8(<vscale x 8 x i8> %a, <vscale x 8 x i8> splat (i8 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i8> @llvm.vp.and.nxv8i8(<vscale x 8 x i8> %not.a, <vscale x 8 x i8> %b, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i8> %x
}

define <vscale x 8 x i8> @vandn_vv_vp_swapped_nxv8i8(<vscale x 8 x i8> %a, <vscale x 8 x i8> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i8> @llvm.vp.xor.nxv8i8(<vscale x 8 x i8> %a, <vscale x 8 x i8> splat (i8 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i8> @llvm.vp.and.nxv8i8(<vscale x 8 x i8> %b, <vscale x 8 x i8> %not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i8> %x
}

define <vscale x 8 x i8> @vandn_vx_vp_nxv8i8(i8 %a, <vscale x 8 x i8> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv8i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i8 %a, -1
  %head.not.a = insertelement <vscale x 8 x i8> poison, i8 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 8 x i8> %head.not.a, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i8> @llvm.vp.and.nxv8i8(<vscale x 8 x i8> %b, <vscale x 8 x i8> %splat.not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i8> %x
}

declare <vscale x 16 x i8> @llvm.vp.and.nxv16i8(<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i1>, i32)
declare <vscale x 16 x i8> @llvm.vp.xor.nxv16i8(<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i8> @vandn_vv_vp_nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 16 x i8> @llvm.vp.xor.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> splat (i8 -1), <vscale x 16 x i1> %mask, i32 %evl)
  %x = call <vscale x 16 x i8> @llvm.vp.and.nxv16i8(<vscale x 16 x i8> %not.a, <vscale x 16 x i8> %b, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i8> %x
}

define <vscale x 16 x i8> @vandn_vv_vp_swapped_nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 16 x i8> @llvm.vp.xor.nxv16i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> splat (i8 -1), <vscale x 16 x i1> %mask, i32 %evl)
  %x = call <vscale x 16 x i8> @llvm.vp.and.nxv16i8(<vscale x 16 x i8> %b, <vscale x 16 x i8> %not.a, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i8> %x
}

define <vscale x 16 x i8> @vandn_vx_vp_nxv16i8(i8 %a, <vscale x 16 x i8> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv16i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i8 %a, -1
  %head.not.a = insertelement <vscale x 16 x i8> poison, i8 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 16 x i8> %head.not.a, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %x = call <vscale x 16 x i8> @llvm.vp.and.nxv16i8(<vscale x 16 x i8> %b, <vscale x 16 x i8> %splat.not.a, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i8> %x
}

declare <vscale x 32 x i8> @llvm.vp.and.nxv32i8(<vscale x 32 x i8>, <vscale x 32 x i8>, <vscale x 32 x i1>, i32)
declare <vscale x 32 x i8> @llvm.vp.xor.nxv32i8(<vscale x 32 x i8>, <vscale x 32 x i8>, <vscale x 32 x i1>, i32)

define <vscale x 32 x i8> @vandn_vv_vp_nxv32i8(<vscale x 32 x i8> %a, <vscale x 32 x i8> %b, <vscale x 32 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 32 x i8> @llvm.vp.xor.nxv32i8(<vscale x 32 x i8> %a, <vscale x 32 x i8> splat (i8 -1), <vscale x 32 x i1> %mask, i32 %evl)
  %x = call <vscale x 32 x i8> @llvm.vp.and.nxv32i8(<vscale x 32 x i8> %not.a, <vscale x 32 x i8> %b, <vscale x 32 x i1> %mask, i32 %evl)
  ret <vscale x 32 x i8> %x
}

define <vscale x 32 x i8> @vandn_vv_vp_swapped_nxv32i8(<vscale x 32 x i8> %a, <vscale x 32 x i8> %b, <vscale x 32 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 32 x i8> @llvm.vp.xor.nxv32i8(<vscale x 32 x i8> %a, <vscale x 32 x i8> splat (i8 -1), <vscale x 32 x i1> %mask, i32 %evl)
  %x = call <vscale x 32 x i8> @llvm.vp.and.nxv32i8(<vscale x 32 x i8> %b, <vscale x 32 x i8> %not.a, <vscale x 32 x i1> %mask, i32 %evl)
  ret <vscale x 32 x i8> %x
}

define <vscale x 32 x i8> @vandn_vx_vp_nxv32i8(i8 %a, <vscale x 32 x i8> %b, <vscale x 32 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv32i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i8 %a, -1
  %head.not.a = insertelement <vscale x 32 x i8> poison, i8 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 32 x i8> %head.not.a, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %x = call <vscale x 32 x i8> @llvm.vp.and.nxv32i8(<vscale x 32 x i8> %b, <vscale x 32 x i8> %splat.not.a, <vscale x 32 x i1> %mask, i32 %evl)
  ret <vscale x 32 x i8> %x
}

declare <vscale x 64 x i8> @llvm.vp.and.nxv64i8(<vscale x 64 x i8>, <vscale x 64 x i8>, <vscale x 64 x i1>, i32)
declare <vscale x 64 x i8> @llvm.vp.xor.nxv64i8(<vscale x 64 x i8>, <vscale x 64 x i8>, <vscale x 64 x i1>, i32)

define <vscale x 64 x i8> @vandn_vv_vp_nxv64i8(<vscale x 64 x i8> %a, <vscale x 64 x i8> %b, <vscale x 64 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 64 x i8> @llvm.vp.xor.nxv64i8(<vscale x 64 x i8> %a, <vscale x 64 x i8> splat (i8 -1), <vscale x 64 x i1> %mask, i32 %evl)
  %x = call <vscale x 64 x i8> @llvm.vp.and.nxv64i8(<vscale x 64 x i8> %not.a, <vscale x 64 x i8> %b, <vscale x 64 x i1> %mask, i32 %evl)
  ret <vscale x 64 x i8> %x
}

define <vscale x 64 x i8> @vandn_vv_vp_swapped_nxv64i8(<vscale x 64 x i8> %a, <vscale x 64 x i8> %b, <vscale x 64 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 64 x i8> @llvm.vp.xor.nxv64i8(<vscale x 64 x i8> %a, <vscale x 64 x i8> splat (i8 -1), <vscale x 64 x i1> %mask, i32 %evl)
  %x = call <vscale x 64 x i8> @llvm.vp.and.nxv64i8(<vscale x 64 x i8> %b, <vscale x 64 x i8> %not.a, <vscale x 64 x i1> %mask, i32 %evl)
  ret <vscale x 64 x i8> %x
}

define <vscale x 64 x i8> @vandn_vx_vp_nxv64i8(i8 %a, <vscale x 64 x i8> %b, <vscale x 64 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv64i8:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e8, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i8 %a, -1
  %head.not.a = insertelement <vscale x 64 x i8> poison, i8 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 64 x i8> %head.not.a, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %x = call <vscale x 64 x i8> @llvm.vp.and.nxv64i8(<vscale x 64 x i8> %b, <vscale x 64 x i8> %splat.not.a, <vscale x 64 x i1> %mask, i32 %evl)
  ret <vscale x 64 x i8> %x
}

declare <vscale x 1 x i16> @llvm.vp.and.nxv1i16(<vscale x 1 x i16>, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)
declare <vscale x 1 x i16> @llvm.vp.xor.nxv1i16(<vscale x 1 x i16>, <vscale x 1 x i16>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i16> @vandn_vv_vp_nxv1i16(<vscale x 1 x i16> %a, <vscale x 1 x i16> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i16> @llvm.vp.xor.nxv1i16(<vscale x 1 x i16> %a, <vscale x 1 x i16> splat (i16 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i16> @llvm.vp.and.nxv1i16(<vscale x 1 x i16> %not.a, <vscale x 1 x i16> %b, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i16> %x
}

define <vscale x 1 x i16> @vandn_vv_vp_swapped_nxv1i16(<vscale x 1 x i16> %a, <vscale x 1 x i16> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i16> @llvm.vp.xor.nxv1i16(<vscale x 1 x i16> %a, <vscale x 1 x i16> splat (i16 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i16> @llvm.vp.and.nxv1i16(<vscale x 1 x i16> %b, <vscale x 1 x i16> %not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i16> %x
}

define <vscale x 1 x i16> @vandn_vx_vp_nxv1i16(i16 %a, <vscale x 1 x i16> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv1i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i16 %a, -1
  %head.not.a = insertelement <vscale x 1 x i16> poison, i16 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 1 x i16> %head.not.a, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i16> @llvm.vp.and.nxv1i16(<vscale x 1 x i16> %b, <vscale x 1 x i16> %splat.not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i16> %x
}

declare <vscale x 2 x i16> @llvm.vp.and.nxv2i16(<vscale x 2 x i16>, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)
declare <vscale x 2 x i16> @llvm.vp.xor.nxv2i16(<vscale x 2 x i16>, <vscale x 2 x i16>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i16> @vandn_vv_vp_nxv2i16(<vscale x 2 x i16> %a, <vscale x 2 x i16> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i16> @llvm.vp.xor.nxv2i16(<vscale x 2 x i16> %a, <vscale x 2 x i16> splat (i16 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i16> @llvm.vp.and.nxv2i16(<vscale x 2 x i16> %not.a, <vscale x 2 x i16> %b, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i16> %x
}

define <vscale x 2 x i16> @vandn_vv_vp_swapped_nxv2i16(<vscale x 2 x i16> %a, <vscale x 2 x i16> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i16> @llvm.vp.xor.nxv2i16(<vscale x 2 x i16> %a, <vscale x 2 x i16> splat (i16 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i16> @llvm.vp.and.nxv2i16(<vscale x 2 x i16> %b, <vscale x 2 x i16> %not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i16> %x
}

define <vscale x 2 x i16> @vandn_vx_vp_nxv2i16(i16 %a, <vscale x 2 x i16> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv2i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i16 %a, -1
  %head.not.a = insertelement <vscale x 2 x i16> poison, i16 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 2 x i16> %head.not.a, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i16> @llvm.vp.and.nxv2i16(<vscale x 2 x i16> %b, <vscale x 2 x i16> %splat.not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i16> %x
}

declare <vscale x 4 x i16> @llvm.vp.and.nxv4i16(<vscale x 4 x i16>, <vscale x 4 x i16>, <vscale x 4 x i1>, i32)
declare <vscale x 4 x i16> @llvm.vp.xor.nxv4i16(<vscale x 4 x i16>, <vscale x 4 x i16>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i16> @vandn_vv_vp_nxv4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i16> @llvm.vp.xor.nxv4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> splat (i16 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i16> @llvm.vp.and.nxv4i16(<vscale x 4 x i16> %not.a, <vscale x 4 x i16> %b, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i16> %x
}

define <vscale x 4 x i16> @vandn_vv_vp_swapped_nxv4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i16> @llvm.vp.xor.nxv4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> splat (i16 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i16> @llvm.vp.and.nxv4i16(<vscale x 4 x i16> %b, <vscale x 4 x i16> %not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i16> %x
}

define <vscale x 4 x i16> @vandn_vx_vp_nxv4i16(i16 %a, <vscale x 4 x i16> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv4i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i16 %a, -1
  %head.not.a = insertelement <vscale x 4 x i16> poison, i16 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 4 x i16> %head.not.a, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i16> @llvm.vp.and.nxv4i16(<vscale x 4 x i16> %b, <vscale x 4 x i16> %splat.not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i16> %x
}

declare <vscale x 8 x i16> @llvm.vp.and.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i1>, i32)
declare <vscale x 8 x i16> @llvm.vp.xor.nxv8i16(<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i16> @vandn_vv_vp_nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i16> @llvm.vp.xor.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> splat (i16 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i16> @llvm.vp.and.nxv8i16(<vscale x 8 x i16> %not.a, <vscale x 8 x i16> %b, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i16> %x
}

define <vscale x 8 x i16> @vandn_vv_vp_swapped_nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i16> @llvm.vp.xor.nxv8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> splat (i16 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i16> @llvm.vp.and.nxv8i16(<vscale x 8 x i16> %b, <vscale x 8 x i16> %not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i16> %x
}

define <vscale x 8 x i16> @vandn_vx_vp_nxv8i16(i16 %a, <vscale x 8 x i16> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv8i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i16 %a, -1
  %head.not.a = insertelement <vscale x 8 x i16> poison, i16 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 8 x i16> %head.not.a, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i16> @llvm.vp.and.nxv8i16(<vscale x 8 x i16> %b, <vscale x 8 x i16> %splat.not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i16> %x
}

declare <vscale x 16 x i16> @llvm.vp.and.nxv16i16(<vscale x 16 x i16>, <vscale x 16 x i16>, <vscale x 16 x i1>, i32)
declare <vscale x 16 x i16> @llvm.vp.xor.nxv16i16(<vscale x 16 x i16>, <vscale x 16 x i16>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i16> @vandn_vv_vp_nxv16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 16 x i16> @llvm.vp.xor.nxv16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> splat (i16 -1), <vscale x 16 x i1> %mask, i32 %evl)
  %x = call <vscale x 16 x i16> @llvm.vp.and.nxv16i16(<vscale x 16 x i16> %not.a, <vscale x 16 x i16> %b, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i16> %x
}

define <vscale x 16 x i16> @vandn_vv_vp_swapped_nxv16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 16 x i16> @llvm.vp.xor.nxv16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> splat (i16 -1), <vscale x 16 x i1> %mask, i32 %evl)
  %x = call <vscale x 16 x i16> @llvm.vp.and.nxv16i16(<vscale x 16 x i16> %b, <vscale x 16 x i16> %not.a, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i16> %x
}

define <vscale x 16 x i16> @vandn_vx_vp_nxv16i16(i16 %a, <vscale x 16 x i16> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv16i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i16 %a, -1
  %head.not.a = insertelement <vscale x 16 x i16> poison, i16 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 16 x i16> %head.not.a, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %x = call <vscale x 16 x i16> @llvm.vp.and.nxv16i16(<vscale x 16 x i16> %b, <vscale x 16 x i16> %splat.not.a, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i16> %x
}

declare <vscale x 32 x i16> @llvm.vp.and.nxv32i16(<vscale x 32 x i16>, <vscale x 32 x i16>, <vscale x 32 x i1>, i32)
declare <vscale x 32 x i16> @llvm.vp.xor.nxv32i16(<vscale x 32 x i16>, <vscale x 32 x i16>, <vscale x 32 x i1>, i32)

define <vscale x 32 x i16> @vandn_vv_vp_nxv32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> %b, <vscale x 32 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 32 x i16> @llvm.vp.xor.nxv32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> splat (i16 -1), <vscale x 32 x i1> %mask, i32 %evl)
  %x = call <vscale x 32 x i16> @llvm.vp.and.nxv32i16(<vscale x 32 x i16> %not.a, <vscale x 32 x i16> %b, <vscale x 32 x i1> %mask, i32 %evl)
  ret <vscale x 32 x i16> %x
}

define <vscale x 32 x i16> @vandn_vv_vp_swapped_nxv32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> %b, <vscale x 32 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 32 x i16> @llvm.vp.xor.nxv32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> splat (i16 -1), <vscale x 32 x i1> %mask, i32 %evl)
  %x = call <vscale x 32 x i16> @llvm.vp.and.nxv32i16(<vscale x 32 x i16> %b, <vscale x 32 x i16> %not.a, <vscale x 32 x i1> %mask, i32 %evl)
  ret <vscale x 32 x i16> %x
}

define <vscale x 32 x i16> @vandn_vx_vp_nxv32i16(i16 %a, <vscale x 32 x i16> %b, <vscale x 32 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv32i16:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i16 %a, -1
  %head.not.a = insertelement <vscale x 32 x i16> poison, i16 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 32 x i16> %head.not.a, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %x = call <vscale x 32 x i16> @llvm.vp.and.nxv32i16(<vscale x 32 x i16> %b, <vscale x 32 x i16> %splat.not.a, <vscale x 32 x i1> %mask, i32 %evl)
  ret <vscale x 32 x i16> %x
}

declare <vscale x 1 x i32> @llvm.vp.and.nxv1i32(<vscale x 1 x i32>, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)
declare <vscale x 1 x i32> @llvm.vp.xor.nxv1i32(<vscale x 1 x i32>, <vscale x 1 x i32>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i32> @vandn_vv_vp_nxv1i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i32> @llvm.vp.xor.nxv1i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> splat (i32 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i32> @llvm.vp.and.nxv1i32(<vscale x 1 x i32> %not.a, <vscale x 1 x i32> %b, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i32> %x
}

define <vscale x 1 x i32> @vandn_vv_vp_swapped_nxv1i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i32> @llvm.vp.xor.nxv1i32(<vscale x 1 x i32> %a, <vscale x 1 x i32> splat (i32 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i32> @llvm.vp.and.nxv1i32(<vscale x 1 x i32> %b, <vscale x 1 x i32> %not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i32> %x
}

define <vscale x 1 x i32> @vandn_vx_vp_nxv1i32(i32 %a, <vscale x 1 x i32> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv1i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i32 %a, -1
  %head.not.a = insertelement <vscale x 1 x i32> poison, i32 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 1 x i32> %head.not.a, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i32> @llvm.vp.and.nxv1i32(<vscale x 1 x i32> %b, <vscale x 1 x i32> %splat.not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i32> %x
}

declare <vscale x 2 x i32> @llvm.vp.and.nxv2i32(<vscale x 2 x i32>, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)
declare <vscale x 2 x i32> @llvm.vp.xor.nxv2i32(<vscale x 2 x i32>, <vscale x 2 x i32>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i32> @vandn_vv_vp_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i32> @llvm.vp.xor.nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> splat (i32 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i32> @llvm.vp.and.nxv2i32(<vscale x 2 x i32> %not.a, <vscale x 2 x i32> %b, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i32> %x
}

define <vscale x 2 x i32> @vandn_vv_vp_swapped_nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i32> @llvm.vp.xor.nxv2i32(<vscale x 2 x i32> %a, <vscale x 2 x i32> splat (i32 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i32> @llvm.vp.and.nxv2i32(<vscale x 2 x i32> %b, <vscale x 2 x i32> %not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i32> %x
}

define <vscale x 2 x i32> @vandn_vx_vp_nxv2i32(i32 %a, <vscale x 2 x i32> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv2i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i32 %a, -1
  %head.not.a = insertelement <vscale x 2 x i32> poison, i32 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 2 x i32> %head.not.a, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i32> @llvm.vp.and.nxv2i32(<vscale x 2 x i32> %b, <vscale x 2 x i32> %splat.not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i32> %x
}

declare <vscale x 4 x i32> @llvm.vp.and.nxv4i32(<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i1>, i32)
declare <vscale x 4 x i32> @llvm.vp.xor.nxv4i32(<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i32> @vandn_vv_vp_nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i32> @llvm.vp.xor.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> splat (i32 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i32> @llvm.vp.and.nxv4i32(<vscale x 4 x i32> %not.a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i32> %x
}

define <vscale x 4 x i32> @vandn_vv_vp_swapped_nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i32> @llvm.vp.xor.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> splat (i32 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i32> @llvm.vp.and.nxv4i32(<vscale x 4 x i32> %b, <vscale x 4 x i32> %not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i32> %x
}

define <vscale x 4 x i32> @vandn_vx_vp_nxv4i32(i32 %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv4i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i32 %a, -1
  %head.not.a = insertelement <vscale x 4 x i32> poison, i32 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 4 x i32> %head.not.a, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i32> @llvm.vp.and.nxv4i32(<vscale x 4 x i32> %b, <vscale x 4 x i32> %splat.not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i32> %x
}

declare <vscale x 8 x i32> @llvm.vp.and.nxv8i32(<vscale x 8 x i32>, <vscale x 8 x i32>, <vscale x 8 x i1>, i32)
declare <vscale x 8 x i32> @llvm.vp.xor.nxv8i32(<vscale x 8 x i32>, <vscale x 8 x i32>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i32> @vandn_vv_vp_nxv8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i32> @llvm.vp.xor.nxv8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> splat (i32 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i32> @llvm.vp.and.nxv8i32(<vscale x 8 x i32> %not.a, <vscale x 8 x i32> %b, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i32> %x
}

define <vscale x 8 x i32> @vandn_vv_vp_swapped_nxv8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i32> @llvm.vp.xor.nxv8i32(<vscale x 8 x i32> %a, <vscale x 8 x i32> splat (i32 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i32> @llvm.vp.and.nxv8i32(<vscale x 8 x i32> %b, <vscale x 8 x i32> %not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i32> %x
}

define <vscale x 8 x i32> @vandn_vx_vp_nxv8i32(i32 %a, <vscale x 8 x i32> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv8i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i32 %a, -1
  %head.not.a = insertelement <vscale x 8 x i32> poison, i32 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 8 x i32> %head.not.a, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i32> @llvm.vp.and.nxv8i32(<vscale x 8 x i32> %b, <vscale x 8 x i32> %splat.not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i32> %x
}

declare <vscale x 16 x i32> @llvm.vp.and.nxv16i32(<vscale x 16 x i32>, <vscale x 16 x i32>, <vscale x 16 x i1>, i32)
declare <vscale x 16 x i32> @llvm.vp.xor.nxv16i32(<vscale x 16 x i32>, <vscale x 16 x i32>, <vscale x 16 x i1>, i32)

define <vscale x 16 x i32> @vandn_vv_vp_nxv16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 16 x i32> @llvm.vp.xor.nxv16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> splat (i32 -1), <vscale x 16 x i1> %mask, i32 %evl)
  %x = call <vscale x 16 x i32> @llvm.vp.and.nxv16i32(<vscale x 16 x i32> %not.a, <vscale x 16 x i32> %b, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i32> %x
}

define <vscale x 16 x i32> @vandn_vv_vp_swapped_nxv16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 16 x i32> @llvm.vp.xor.nxv16i32(<vscale x 16 x i32> %a, <vscale x 16 x i32> splat (i32 -1), <vscale x 16 x i1> %mask, i32 %evl)
  %x = call <vscale x 16 x i32> @llvm.vp.and.nxv16i32(<vscale x 16 x i32> %b, <vscale x 16 x i32> %not.a, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i32> %x
}

define <vscale x 16 x i32> @vandn_vx_vp_nxv16i32(i32 %a, <vscale x 16 x i32> %b, <vscale x 16 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vx_vp_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vx_vp_nxv16i32:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = xor i32 %a, -1
  %head.not.a = insertelement <vscale x 16 x i32> poison, i32 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 16 x i32> %head.not.a, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %x = call <vscale x 16 x i32> @llvm.vp.and.nxv16i32(<vscale x 16 x i32> %b, <vscale x 16 x i32> %splat.not.a, <vscale x 16 x i1> %mask, i32 %evl)
  ret <vscale x 16 x i32> %x
}

declare <vscale x 1 x i64> @llvm.vp.and.nxv1i64(<vscale x 1 x i64>, <vscale x 1 x i64>, <vscale x 1 x i1>, i32)
declare <vscale x 1 x i64> @llvm.vp.xor.nxv1i64(<vscale x 1 x i64>, <vscale x 1 x i64>, <vscale x 1 x i1>, i32)

define <vscale x 1 x i64> @vandn_vv_vp_nxv1i64(<vscale x 1 x i64> %a, <vscale x 1 x i64> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv1i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i64> @llvm.vp.xor.nxv1i64(<vscale x 1 x i64> %a, <vscale x 1 x i64> splat (i64 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i64> @llvm.vp.and.nxv1i64(<vscale x 1 x i64> %not.a, <vscale x 1 x i64> %b, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i64> %x
}

define <vscale x 1 x i64> @vandn_vv_vp_swapped_nxv1i64(<vscale x 1 x i64> %a, <vscale x 1 x i64> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv1i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v9, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 1 x i64> @llvm.vp.xor.nxv1i64(<vscale x 1 x i64> %a, <vscale x 1 x i64> splat (i64 -1), <vscale x 1 x i1> %mask, i32 %evl)
  %x = call <vscale x 1 x i64> @llvm.vp.and.nxv1i64(<vscale x 1 x i64> %b, <vscale x 1 x i64> %not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i64> %x
}

define <vscale x 1 x i64> @vandn_vx_vp_nxv1i64(i64 %a, <vscale x 1 x i64> %b, <vscale x 1 x i1> %mask, i32 zeroext %evl) {
; CHECK-RV32-LABEL: vandn_vx_vp_nxv1i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v9, (a0), zero
; CHECK-RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-RV32-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_vp_nxv1i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_vp_nxv1i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v9, (a0), zero
; CHECK-ZVKB32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; CHECK-ZVKB32-NEXT:    vand.vv v8, v8, v9, v0.t
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_vp_nxv1i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB64-NEXT:    ret
  %not.a = xor i64 %a, -1
  %head.not.a = insertelement <vscale x 1 x i64> poison, i64 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 1 x i64> %head.not.a, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i64> @llvm.vp.and.nxv1i64(<vscale x 1 x i64> %b, <vscale x 1 x i64> %splat.not.a, <vscale x 1 x i1> %mask, i32 %evl)
  ret <vscale x 1 x i64> %x
}

declare <vscale x 2 x i64> @llvm.vp.and.nxv2i64(<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i1>, i32)
declare <vscale x 2 x i64> @llvm.vp.xor.nxv2i64(<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i1>, i32)

define <vscale x 2 x i64> @vandn_vv_vp_nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v10, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv2i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i64> @llvm.vp.xor.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> splat (i64 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i64> @llvm.vp.and.nxv2i64(<vscale x 2 x i64> %not.a, <vscale x 2 x i64> %b, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i64> %x
}

define <vscale x 2 x i64> @vandn_vv_vp_swapped_nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv2i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v10, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 2 x i64> @llvm.vp.xor.nxv2i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> splat (i64 -1), <vscale x 2 x i1> %mask, i32 %evl)
  %x = call <vscale x 2 x i64> @llvm.vp.and.nxv2i64(<vscale x 2 x i64> %b, <vscale x 2 x i64> %not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i64> %x
}

define <vscale x 2 x i64> @vandn_vx_vp_nxv2i64(i64 %a, <vscale x 2 x i64> %b, <vscale x 2 x i1> %mask, i32 zeroext %evl) {
; CHECK-RV32-LABEL: vandn_vx_vp_nxv2i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v10, (a0), zero
; CHECK-RV32-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-RV32-NEXT:    vand.vv v8, v8, v10, v0.t
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_vp_nxv2i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_vp_nxv2i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v10, (a0), zero
; CHECK-ZVKB32-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; CHECK-ZVKB32-NEXT:    vand.vv v8, v8, v10, v0.t
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_vp_nxv2i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB64-NEXT:    ret
  %not.a = xor i64 %a, -1
  %head.not.a = insertelement <vscale x 2 x i64> poison, i64 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 2 x i64> %head.not.a, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %x = call <vscale x 2 x i64> @llvm.vp.and.nxv2i64(<vscale x 2 x i64> %b, <vscale x 2 x i64> %splat.not.a, <vscale x 2 x i1> %mask, i32 %evl)
  ret <vscale x 2 x i64> %x
}

declare <vscale x 4 x i64> @llvm.vp.and.nxv4i64(<vscale x 4 x i64>, <vscale x 4 x i64>, <vscale x 4 x i1>, i32)
declare <vscale x 4 x i64> @llvm.vp.xor.nxv4i64(<vscale x 4 x i64>, <vscale x 4 x i64>, <vscale x 4 x i1>, i32)

define <vscale x 4 x i64> @vandn_vv_vp_nxv4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v12, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv4i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i64> @llvm.vp.xor.nxv4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> splat (i64 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i64> @llvm.vp.and.nxv4i64(<vscale x 4 x i64> %not.a, <vscale x 4 x i64> %b, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i64> %x
}

define <vscale x 4 x i64> @vandn_vv_vp_swapped_nxv4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv4i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v12, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 4 x i64> @llvm.vp.xor.nxv4i64(<vscale x 4 x i64> %a, <vscale x 4 x i64> splat (i64 -1), <vscale x 4 x i1> %mask, i32 %evl)
  %x = call <vscale x 4 x i64> @llvm.vp.and.nxv4i64(<vscale x 4 x i64> %b, <vscale x 4 x i64> %not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i64> %x
}

define <vscale x 4 x i64> @vandn_vx_vp_nxv4i64(i64 %a, <vscale x 4 x i64> %b, <vscale x 4 x i1> %mask, i32 zeroext %evl) {
; CHECK-RV32-LABEL: vandn_vx_vp_nxv4i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v12, (a0), zero
; CHECK-RV32-NEXT:    vsetvli zero, a2, e64, m4, ta, ma
; CHECK-RV32-NEXT:    vand.vv v8, v8, v12, v0.t
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_vp_nxv4i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_vp_nxv4i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v12, (a0), zero
; CHECK-ZVKB32-NEXT:    vsetvli zero, a2, e64, m4, ta, ma
; CHECK-ZVKB32-NEXT:    vand.vv v8, v8, v12, v0.t
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_vp_nxv4i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB64-NEXT:    ret
  %not.a = xor i64 %a, -1
  %head.not.a = insertelement <vscale x 4 x i64> poison, i64 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 4 x i64> %head.not.a, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %x = call <vscale x 4 x i64> @llvm.vp.and.nxv4i64(<vscale x 4 x i64> %b, <vscale x 4 x i64> %splat.not.a, <vscale x 4 x i1> %mask, i32 %evl)
  ret <vscale x 4 x i64> %x
}

declare <vscale x 8 x i64> @llvm.vp.and.nxv8i64(<vscale x 8 x i64>, <vscale x 8 x i64>, <vscale x 8 x i1>, i32)
declare <vscale x 8 x i64> @llvm.vp.xor.nxv8i64(<vscale x 8 x i64>, <vscale x 8 x i64>, <vscale x 8 x i1>, i32)

define <vscale x 8 x i64> @vandn_vv_vp_nxv8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v8, v16, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_nxv8i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i64> @llvm.vp.xor.nxv8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> splat (i64 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i64> @llvm.vp.and.nxv8i64(<vscale x 8 x i64> %not.a, <vscale x 8 x i64> %b, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i64> %x
}

define <vscale x 8 x i64> @vandn_vv_vp_swapped_nxv8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-LABEL: vandn_vv_vp_swapped_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vnot.v v8, v8, v0.t
; CHECK-NEXT:    vand.vv v8, v16, v8, v0.t
; CHECK-NEXT:    ret
;
; CHECK-ZVKB-LABEL: vandn_vv_vp_swapped_nxv8i64:
; CHECK-ZVKB:       # %bb.0:
; CHECK-ZVKB-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-ZVKB-NEXT:    vandn.vv v8, v16, v8, v0.t
; CHECK-ZVKB-NEXT:    ret
  %not.a = call <vscale x 8 x i64> @llvm.vp.xor.nxv8i64(<vscale x 8 x i64> %a, <vscale x 8 x i64> splat (i64 -1), <vscale x 8 x i1> %mask, i32 %evl)
  %x = call <vscale x 8 x i64> @llvm.vp.and.nxv8i64(<vscale x 8 x i64> %b, <vscale x 8 x i64> %not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i64> %x
}

define <vscale x 8 x i64> @vandn_vx_vp_nxv8i64(i64 %a, <vscale x 8 x i64> %b, <vscale x 8 x i1> %mask, i32 zeroext %evl) {
; CHECK-RV32-LABEL: vandn_vx_vp_nxv8i64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -16
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-RV32-NEXT:    not a0, a0
; CHECK-RV32-NEXT:    not a1, a1
; CHECK-RV32-NEXT:    sw a1, 12(sp)
; CHECK-RV32-NEXT:    sw a0, 8(sp)
; CHECK-RV32-NEXT:    addi a0, sp, 8
; CHECK-RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-RV32-NEXT:    vlse64.v v16, (a0), zero
; CHECK-RV32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; CHECK-RV32-NEXT:    addi sp, sp, 16
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: vandn_vx_vp_nxv8i64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    not a0, a0
; CHECK-RV64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-RV64-NEXT:    ret
;
; CHECK-ZVKB32-LABEL: vandn_vx_vp_nxv8i64:
; CHECK-ZVKB32:       # %bb.0:
; CHECK-ZVKB32-NEXT:    addi sp, sp, -16
; CHECK-ZVKB32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-ZVKB32-NEXT:    not a0, a0
; CHECK-ZVKB32-NEXT:    not a1, a1
; CHECK-ZVKB32-NEXT:    sw a1, 12(sp)
; CHECK-ZVKB32-NEXT:    sw a0, 8(sp)
; CHECK-ZVKB32-NEXT:    addi a0, sp, 8
; CHECK-ZVKB32-NEXT:    vsetvli a1, zero, e64, m8, ta, ma
; CHECK-ZVKB32-NEXT:    vlse64.v v16, (a0), zero
; CHECK-ZVKB32-NEXT:    vsetvli zero, a2, e64, m8, ta, ma
; CHECK-ZVKB32-NEXT:    vand.vv v8, v8, v16, v0.t
; CHECK-ZVKB32-NEXT:    addi sp, sp, 16
; CHECK-ZVKB32-NEXT:    ret
;
; CHECK-ZVKB64-LABEL: vandn_vx_vp_nxv8i64:
; CHECK-ZVKB64:       # %bb.0:
; CHECK-ZVKB64-NEXT:    vsetvli zero, a1, e64, m8, ta, ma
; CHECK-ZVKB64-NEXT:    vandn.vx v8, v8, a0, v0.t
; CHECK-ZVKB64-NEXT:    ret
  %not.a = xor i64 %a, -1
  %head.not.a = insertelement <vscale x 8 x i64> poison, i64 %not.a, i32 0
  %splat.not.a = shufflevector <vscale x 8 x i64> %head.not.a, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %x = call <vscale x 8 x i64> @llvm.vp.and.nxv8i64(<vscale x 8 x i64> %b, <vscale x 8 x i64> %splat.not.a, <vscale x 8 x i1> %mask, i32 %evl)
  ret <vscale x 8 x i64> %x
}
