; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 < %s | FileCheck -check-prefix=GFX12 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx940 < %s | FileCheck -check-prefix=GFX940 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx90a < %s | FileCheck -check-prefix=GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=gfx908 < %s | FileCheck -check-prefix=GFX908 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tonga < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=hawaii < %s | FileCheck -check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -mcpu=tahiti < %s | FileCheck -check-prefix=GFX6 %s

; --------------------------------------------------------------------
; float
; --------------------------------------------------------------------

define float @global_agent_atomic_fadd_ret_f32(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB0_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB0_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB0_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB0_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB0_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB0_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float %val syncscope("agent") seq_cst
  ret float %result
}

define float @global_agent_atomic_fadd_ret_f32__offset12b_pos(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB1_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB1_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB1_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB1_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB1_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB1_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret float %result
}

define float @global_agent_atomic_fadd_ret_f32__offset12b_neg(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB2_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB2_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB2_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v0, v[3:4], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v3
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, -1, v4, vcc
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v0
; GFX7-NEXT:    v_add_f32_e32 v5, v6, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, v5
; GFX7-NEXT:    v_mov_b32_e32 v1, v6
; GFX7-NEXT:    buffer_atomic_cmpswap v[0:1], v[3:4], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB2_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v0, v[3:4], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v3
; GFX6-NEXT:    v_addc_u32_e32 v4, vcc, -1, v4, vcc
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:  .LBB2_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v0
; GFX6-NEXT:    v_add_f32_e32 v5, v6, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v5
; GFX6-NEXT:    v_mov_b32_e32 v1, v6
; GFX6-NEXT:    buffer_atomic_cmpswap v[0:1], v[3:4], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB2_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 -512
  %result = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret float %result
}

define void @global_agent_atomic_fadd_noret_f32(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v[0:1], v2, off scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB3_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB3_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB3_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB3_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB3_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr addrspace(1) %ptr, float %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f32__offset12b_pos(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB4_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB4_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB4_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB4_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB4_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f32__offset12b_neg(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB5_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB5_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB5_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:  .LBB5_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB5_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 -512
  %unused = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret void
}

define float @global_system_atomic_fadd_ret_f32__offset12b_pos(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB6_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB6_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB6_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB6_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB6_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB6_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB6_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB6_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB6_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, float %val seq_cst
  ret float %result
}

define void @global_system_atomic_fadd_noret_f32__offset12b_pos(ptr addrspace(1) %ptr, float %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off offset:2044
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB7_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB7_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB7_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB7_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB7_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB7_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB7_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB7_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB7_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, float %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; float with ftz/daz
; --------------------------------------------------------------------

define float @global_agent_atomic_fadd_ret_f32__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB8_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB8_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB8_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB8_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f32__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB8_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB8_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(1) %ptr, float %val syncscope("agent") seq_cst
  ret float %result
}

define float @global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB9_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB9_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB9_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB9_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB9_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB9_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret float %result
}

define float @global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB10_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:-2048 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB10_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB10_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v0, v[3:4], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v3
; GFX7-NEXT:    v_addc_u32_e32 v4, vcc, -1, v4, vcc
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v6, v0
; GFX7-NEXT:    v_add_f32_e32 v5, v6, v2
; GFX7-NEXT:    v_mov_b32_e32 v0, v5
; GFX7-NEXT:    v_mov_b32_e32 v1, v6
; GFX7-NEXT:    buffer_atomic_cmpswap v[0:1], v[3:4], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB10_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f32__offset12b_neg__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v0, v[3:4], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, 0xfffff800, v3
; GFX6-NEXT:    v_addc_u32_e32 v4, vcc, -1, v4, vcc
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:  .LBB10_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v0
; GFX6-NEXT:    v_add_f32_e32 v5, v6, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v5
; GFX6-NEXT:    v_mov_b32_e32 v1, v6
; GFX6-NEXT:    buffer_atomic_cmpswap v[0:1], v[3:4], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB10_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 -512
  %result = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret float %result
}

define void @global_agent_atomic_fadd_noret_f32__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v[0:1], v2, off scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB11_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB11_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB11_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f32__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB11_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB11_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr addrspace(1) %ptr, float %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB12_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB12_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB12_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB12_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB12_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB13_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:-2048
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB13_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB13_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f32__offset12b_neg__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:  .LBB13_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB13_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 -512
  %unused = atomicrmw fadd ptr addrspace(1) %gep, float %val syncscope("agent") seq_cst
  ret void
}

define float @global_system_atomic_fadd_ret_f32__offset12b_pos__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB14_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_add_f32 v0, v[0:1], v2, off offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB14_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB14_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB14_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB14_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB14_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB14_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_ret_f32__offset12b_pos__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB14_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[3:4], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB14_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, float %val seq_cst
  ret float %result
}

define void @global_system_atomic_fadd_noret_f32__offset12b_pos__ftz(ptr addrspace(1) %ptr, float %val) #1 {
; GFX12-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off offset:2044
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB15_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_add_f32 v[0:1], v2, off offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB15_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB15_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f32_e32 v4, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB15_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB15_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB15_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB15_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_noret_f32__offset12b_pos__ftz:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB15_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f32_e32 v3, v4, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB15_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr float, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, float %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; double
; --------------------------------------------------------------------

define double @global_agent_atomic_fadd_ret_f64(ptr addrspace(1) %ptr, double %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[4:5], v[0:1], off
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB16_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f64 v[0:1], v[0:1], v[2:3], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[4:5], v[0:1], off
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB16_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[4:5], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB16_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f64 v[0:1], v[0:1], v[2:3], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dwordx2 v[4:5], v[0:1], off
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB16_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[4:5], v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB16_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v4
; GFX8-NEXT:    v_mov_b32_e32 v1, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_mov_b32_e32 v7, v1
; GFX7-NEXT:    v_mov_b32_e32 v6, v0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[6:7], s[4:7], 0 addr64
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v11, v1
; GFX7-NEXT:    v_mov_b32_e32 v10, v0
; GFX7-NEXT:    v_add_f64 v[8:9], v[10:11], v[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v8
; GFX7-NEXT:    v_mov_b32_e32 v1, v9
; GFX7-NEXT:    v_mov_b32_e32 v2, v10
; GFX7-NEXT:    v_mov_b32_e32 v3, v11
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[6:7], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[10:11]
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB16_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_mov_b32_e32 v7, v1
; GFX6-NEXT:    v_mov_b32_e32 v6, v0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dwordx2 v[0:1], v[6:7], s[4:7], 0 addr64
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB16_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v11, v1
; GFX6-NEXT:    v_mov_b32_e32 v10, v0
; GFX6-NEXT:    v_add_f64 v[8:9], v[10:11], v[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v8
; GFX6-NEXT:    v_mov_b32_e32 v1, v9
; GFX6-NEXT:    v_mov_b32_e32 v2, v10
; GFX6-NEXT:    v_mov_b32_e32 v3, v11
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[6:7], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[10:11]
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB16_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(1) %ptr, double %val syncscope("agent") seq_cst
  ret double %result
}

define double @global_agent_atomic_fadd_ret_f64__offset12b_pos(ptr addrspace(1) %ptr, double %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[4:5], v[0:1], off offset:2040
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:2040 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB17_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f64 v[0:1], v[0:1], v[2:3], off offset:2040 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[4:5], v[0:1], off offset:2040
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:2040 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB17_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[4:5], v[0:1], off offset:2040
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:2040 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB17_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f64 v[0:1], v[0:1], v[2:3], off offset:2040 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dwordx2 v[4:5], v[0:1], off offset:2040
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:2040 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB17_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7f8, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[4:5]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v9, v1
; GFX8-NEXT:    v_mov_b32_e32 v8, v0
; GFX8-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB17_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_mov_b32_e32 v7, v1
; GFX7-NEXT:    v_mov_b32_e32 v6, v0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[6:7], s[4:7], 0 addr64 offset:2040
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v11, v1
; GFX7-NEXT:    v_mov_b32_e32 v10, v0
; GFX7-NEXT:    v_add_f64 v[8:9], v[10:11], v[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v8
; GFX7-NEXT:    v_mov_b32_e32 v1, v9
; GFX7-NEXT:    v_mov_b32_e32 v2, v10
; GFX7-NEXT:    v_mov_b32_e32 v3, v11
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[6:7], s[4:7], 0 addr64 offset:2040 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[10:11]
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB17_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_mov_b32_e32 v7, v1
; GFX6-NEXT:    v_mov_b32_e32 v6, v0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dwordx2 v[0:1], v[6:7], s[4:7], 0 addr64 offset:2040
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB17_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v11, v1
; GFX6-NEXT:    v_mov_b32_e32 v10, v0
; GFX6-NEXT:    v_add_f64 v[8:9], v[10:11], v[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v8
; GFX6-NEXT:    v_mov_b32_e32 v1, v9
; GFX6-NEXT:    v_mov_b32_e32 v2, v10
; GFX6-NEXT:    v_mov_b32_e32 v3, v11
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[6:7], s[4:7], 0 addr64 offset:2040 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[10:11]
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB17_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(1) %ptr, i64 255
  %result = atomicrmw fadd ptr addrspace(1) %gep, double %val syncscope("agent") seq_cst
  ret double %result
}

define double @global_agent_atomic_fadd_ret_f64__offset12b_neg(ptr addrspace(1) %ptr, double %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[4:5], v[0:1], off offset:-2048
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB18_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f64 v[0:1], v[0:1], v[2:3], off offset:-2048 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[4:5], v[0:1], off offset:-2048
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB18_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_dual_mov_b32 v0, v4 :: v_dual_mov_b32 v1, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[4:5], v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB18_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v4
; GFX10-NEXT:    v_mov_b32_e32 v1, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f64 v[0:1], v[0:1], v[2:3], off offset:-2048 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dwordx2 v[4:5], v[0:1], off offset:-2048
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:-2048 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB18_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v4
; GFX908-NEXT:    v_mov_b32_e32 v1, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[0:1], v[4:5]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v9, v1
; GFX8-NEXT:    v_mov_b32_e32 v8, v0
; GFX8-NEXT:    v_add_f64 v[6:7], v[8:9], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[0:1], v[4:5], v[6:9] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[8:9]
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB18_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    v_mov_b32_e32 v7, v1
; GFX7-NEXT:    v_mov_b32_e32 v6, v0
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dwordx2 v[0:1], v[6:7], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v6, vcc, 0xfffff800, v6
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    v_addc_u32_e32 v7, vcc, -1, v7, vcc
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v11, v1
; GFX7-NEXT:    v_mov_b32_e32 v10, v0
; GFX7-NEXT:    v_add_f64 v[8:9], v[10:11], v[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v0, v8
; GFX7-NEXT:    v_mov_b32_e32 v1, v9
; GFX7-NEXT:    v_mov_b32_e32 v2, v10
; GFX7-NEXT:    v_mov_b32_e32 v3, v11
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[6:7], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[10:11]
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB18_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f64__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    v_mov_b32_e32 v7, v1
; GFX6-NEXT:    v_mov_b32_e32 v6, v0
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dwordx2 v[0:1], v[6:7], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v6, vcc, 0xfffff800, v6
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    v_addc_u32_e32 v7, vcc, -1, v7, vcc
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:  .LBB18_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v11, v1
; GFX6-NEXT:    v_mov_b32_e32 v10, v0
; GFX6-NEXT:    v_add_f64 v[8:9], v[10:11], v[4:5]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v0, v8
; GFX6-NEXT:    v_mov_b32_e32 v1, v9
; GFX6-NEXT:    v_mov_b32_e32 v2, v10
; GFX6-NEXT:    v_mov_b32_e32 v3, v11
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[0:3], v[6:7], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[0:1], v[10:11]
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB18_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(1) %ptr, i64 -256
  %result = atomicrmw fadd ptr addrspace(1) %gep, double %val syncscope("agent") seq_cst
  ret double %result
}

define void @global_agent_atomic_fadd_noret_f64(ptr addrspace(1) %ptr, double %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[6:7], v[0:1], off
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB19_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f64 v[0:1], v[2:3], off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[6:7], v[0:1], off
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB19_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[6:7], v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB19_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f64 v[0:1], v[2:3], off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dwordx2 v[6:7], v[0:1], off
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB19_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB19_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dwordx2 v[6:7], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v11, v7
; GFX7-NEXT:    v_mov_b32_e32 v10, v6
; GFX7-NEXT:    v_mov_b32_e32 v9, v5
; GFX7-NEXT:    v_mov_b32_e32 v8, v4
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[8:11], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[8:9], v[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v8
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v7, v9
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB19_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dwordx2 v[6:7], v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB19_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v11, v7
; GFX6-NEXT:    v_mov_b32_e32 v10, v6
; GFX6-NEXT:    v_mov_b32_e32 v9, v5
; GFX6-NEXT:    v_mov_b32_e32 v8, v4
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[8:11], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[8:9], v[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v6, v8
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v7, v9
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB19_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr addrspace(1) %ptr, double %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f64__offset12b_pos(ptr addrspace(1) %ptr, double %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[6:7], v[0:1], off offset:2040
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:2040 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB20_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f64 v[0:1], v[2:3], off offset:2040
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[6:7], v[0:1], off offset:2040
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:2040 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB20_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[6:7], v[0:1], off offset:2040
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:2040 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB20_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f64 v[0:1], v[2:3], off offset:2040
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dwordx2 v[6:7], v[0:1], off offset:2040
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:2040 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB20_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7f8, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB20_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dwordx2 v[6:7], v[0:1], s[4:7], 0 addr64 offset:2040
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v11, v7
; GFX7-NEXT:    v_mov_b32_e32 v10, v6
; GFX7-NEXT:    v_mov_b32_e32 v9, v5
; GFX7-NEXT:    v_mov_b32_e32 v8, v4
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[8:11], v[0:1], s[4:7], 0 addr64 offset:2040 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[8:9], v[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v8
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v7, v9
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB20_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dwordx2 v[6:7], v[0:1], s[4:7], 0 addr64 offset:2040
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB20_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v11, v7
; GFX6-NEXT:    v_mov_b32_e32 v10, v6
; GFX6-NEXT:    v_mov_b32_e32 v9, v5
; GFX6-NEXT:    v_mov_b32_e32 v8, v4
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[8:11], v[0:1], s[4:7], 0 addr64 offset:2040 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[8:9], v[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v6, v8
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v7, v9
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB20_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(1) %ptr, i64 255
  %unused = atomicrmw fadd ptr addrspace(1) %gep, double %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f64__offset12b_neg(ptr addrspace(1) %ptr, double %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b64 v[6:7], v[0:1], off offset:-2048
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f64_e32 v[4:5], v[6:7], v[2:3]
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX12-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB21_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_add_f64 v[0:1], v[2:3], off offset:-2048
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[6:7], v[0:1], off offset:-2048
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b64 v[4:5], v[0:1], v[4:7], off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX11-NEXT:    v_dual_mov_b32 v7, v5 :: v_dual_mov_b32 v6, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB21_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dwordx2 v[6:7], v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[4:5], v[6:7]
; GFX10-NEXT:    v_mov_b32_e32 v7, v5
; GFX10-NEXT:    v_mov_b32_e32 v6, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB21_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f64 v[0:1], v[2:3], off offset:-2048
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dwordx2 v[6:7], v[0:1], off offset:-2048
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX908-NEXT:    global_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7], off offset:-2048 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v7, v5
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v6, v4
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB21_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dwordx2 v[6:7], v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX8-NEXT:    flat_atomic_cmpswap_x2 v[4:5], v[0:1], v[4:7] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[4:5], v[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v7, v5
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v6, v4
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB21_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dwordx2 v[6:7], v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX7-NEXT:    v_mov_b32_e32 v11, v7
; GFX7-NEXT:    v_mov_b32_e32 v10, v6
; GFX7-NEXT:    v_mov_b32_e32 v9, v5
; GFX7-NEXT:    v_mov_b32_e32 v8, v4
; GFX7-NEXT:    buffer_atomic_cmpswap_x2 v[8:11], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u64_e32 vcc, v[8:9], v[6:7]
; GFX7-NEXT:    v_mov_b32_e32 v6, v8
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v7, v9
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB21_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f64__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dwordx2 v[6:7], v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:  .LBB21_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_add_f64 v[4:5], v[6:7], v[2:3]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v11, v7
; GFX6-NEXT:    v_mov_b32_e32 v10, v6
; GFX6-NEXT:    v_mov_b32_e32 v9, v5
; GFX6-NEXT:    v_mov_b32_e32 v8, v4
; GFX6-NEXT:    buffer_atomic_cmpswap_x2 v[8:11], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[8:9], v[6:7]
; GFX6-NEXT:    v_mov_b32_e32 v6, v8
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v7, v9
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB21_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr double, ptr addrspace(1) %ptr, i64 -256
  %unused = atomicrmw fadd ptr addrspace(1) %gep, double %val syncscope("agent") seq_cst
  ret void
}

; --------------------------------------------------------------------
; half
; --------------------------------------------------------------------

define half @global_agent_atomic_fadd_ret_f16(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB22_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    global_load_dword v4, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB22_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB22_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB22_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v4, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB22_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB22_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB22_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v5
; GFX7-NEXT:    v_not_b32_e32 v7, v2
; GFX7-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v5, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v3, v4, v7
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v2
; GFX7-NEXT:    v_mov_b32_e32 v2, v3
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    buffer_atomic_cmpswap v[2:3], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB22_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v5, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v5
; GFX6-NEXT:    v_not_b32_e32 v7, v2
; GFX6-NEXT:  .LBB22_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v5, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v3, v4, v7
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v5, v2
; GFX6-NEXT:    v_or_b32_e32 v3, v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v2, v3
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    buffer_atomic_cmpswap v[2:3], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB22_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v5, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(1) %ptr, half %val syncscope("agent") seq_cst
  ret half %result
}

define half @global_agent_atomic_fadd_ret_f16__offset12b_pos(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB23_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[6:7], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_load_dword v4, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v6
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB23_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB23_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB23_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v4, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB23_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB23_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB23_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v6
; GFX7-NEXT:    v_not_b32_e32 v8, v2
; GFX7-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, v3, v8
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB23_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v6
; GFX6-NEXT:    v_not_b32_e32 v8, v2
; GFX6-NEXT:  .LBB23_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, v3, v8
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB23_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 1023
  %result = atomicrmw fadd ptr addrspace(1) %gep, half %val syncscope("agent") seq_cst
  ret half %result
}

define half @global_agent_atomic_fadd_ret_f16__offset12b_neg(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB24_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[6:7], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_load_dword v4, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v6
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB24_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB24_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB24_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v4, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB24_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB24_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB24_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v6
; GFX7-NEXT:    v_not_b32_e32 v8, v2
; GFX7-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, v3, v8
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB24_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v6
; GFX6-NEXT:    v_not_b32_e32 v8, v2
; GFX6-NEXT:  .LBB24_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, v3, v8
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB24_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 -1024
  %result = atomicrmw fadd ptr addrspace(1) %gep, half %val syncscope("agent") seq_cst
  ret half %result
 }

define void @global_agent_atomic_fadd_noret_f16(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v3, v0
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB25_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB25_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v3, v0
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB25_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB25_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB25_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB25_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB25_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xffff, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_not_b32_e32 v6, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v2, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX7-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v2, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX7-NEXT:    v_mov_b32_e32 v8, v4
; GFX7-NEXT:    v_mov_b32_e32 v7, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB25_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v2
; GFX6-NEXT:    v_and_b32_e32 v2, 3, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 3, v2
; GFX6-NEXT:    v_lshl_b32_e32 v3, 0xffff, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_not_b32_e32 v6, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:  .LBB25_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, v2, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX6-NEXT:    v_add_f32_e32 v3, v3, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v2, v3
; GFX6-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX6-NEXT:    v_mov_b32_e32 v8, v4
; GFX6-NEXT:    v_mov_b32_e32 v7, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB25_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr addrspace(1) %ptr, half %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f16__offset12b_pos(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB26_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB26_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB26_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB26_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB26_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB26_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB26_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX7-NEXT:    v_not_b32_e32 v6, v2
; GFX7-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB26_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX6-NEXT:    v_not_b32_e32 v6, v2
; GFX6-NEXT:  .LBB26_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB26_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 1023
  %unused = atomicrmw fadd ptr addrspace(1) %gep, half %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_f16__offset12b_neg(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB27_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB27_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB27_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB27_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB27_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB27_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB27_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX7-NEXT:    v_not_b32_e32 v6, v2
; GFX7-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB27_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX6-NEXT:    v_not_b32_e32 v6, v2
; GFX6-NEXT:  .LBB27_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB27_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 -1024
  %unused = atomicrmw fadd ptr addrspace(1) %gep, half %val syncscope("agent") seq_cst
  ret void
}

define half @global_agent_atomic_fadd_ret_f16__offset12b_pos__align4(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off offset:2046
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB28_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_mov_b32 s2, 0xffff0000
; GFX940-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX940-NEXT:    v_and_or_b32 v4, v5, s2, v3
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB28_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2046
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB28_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX10-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2046 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB28_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX90A-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX90A-NEXT:    v_and_or_b32 v4, v5, s6, v3
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB28_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX908-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX908-NEXT:    v_and_or_b32 v3, v4, s6, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB28_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f16_e32 v0, v1, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB28_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v2
; GFX7-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v3
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB28_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v4
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_f16__offset12b_pos__align4:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v2
; GFX6-NEXT:  .LBB28_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v3
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB28_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v4
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 1023
  %result = atomicrmw fadd ptr addrspace(1) %gep, half %val syncscope("agent") seq_cst, align 4
  ret half %result
}

define void @global_agent_atomic_fadd_noret_f16__offset12b__align4_pos(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off offset:2046
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB29_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v5, v[0:1], off offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    s_mov_b32 s2, 0xffff0000
; GFX940-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX940-NEXT:    v_and_or_b32 v4, v5, s2, v3
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB29_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off offset:2046
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB29_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:2046
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX10-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2046 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB29_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX90A-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_add_f16_e32 v3, v5, v2
; GFX90A-NEXT:    v_and_or_b32 v4, v5, s6, v3
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB29_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v4, v[0:1], off offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    s_mov_b32 s6, 0xffff0000
; GFX908-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX908-NEXT:    v_and_or_b32 v3, v4, s6, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB29_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f16_e32 v3, v4, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v4
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB29_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX7-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v3
; GFX7-NEXT:    v_mov_b32_e32 v5, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB29_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_f16__offset12b__align4_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v2
; GFX6-NEXT:  .LBB29_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v6, v3
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB29_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 1023
  %unused = atomicrmw fadd ptr addrspace(1) %gep, half %val syncscope("agent") seq_cst, align 4
  ret void
}

define half @global_system_atomic_fadd_ret_f16__offset12b_pos(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB30_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[6:7], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_load_dword v4, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v6
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v4
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB30_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB30_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX10-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB30_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v4, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v4
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB30_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v7, v4
; GFX908-NEXT:    v_lshrrev_b32_e32 v4, v3, v7
; GFX908-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX908-NEXT:    v_and_or_b32 v6, v7, v5, v4
; GFX908-NEXT:    global_atomic_cmpswap v4, v[0:1], v[6:7], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v7
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB30_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v4
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX8-NEXT:    v_add_f16_e32 v5, v5, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB30_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v6
; GFX7-NEXT:    v_not_b32_e32 v8, v2
; GFX7-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, v3, v8
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB30_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_ret_f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v6
; GFX6-NEXT:    v_not_b32_e32 v8, v2
; GFX6-NEXT:  .LBB30_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, v3, v8
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB30_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 1023
  %result = atomicrmw fadd ptr addrspace(1) %gep, half %val seq_cst
  ret half %result
}

define void @global_system_atomic_fadd_noret_f16__offset12b_pos(ptr addrspace(1) %ptr, half %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX12-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB31_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX940-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB31_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB31_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX10-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB31_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_e32 v4, v3, v5
; GFX90A-NEXT:    v_add_f16_e32 v4, v4, v2
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, v3, v4
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB31_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX908-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB31_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX8-NEXT:    v_add_f16_e32 v3, v3, v2
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB31_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX7-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX7-NEXT:    v_not_b32_e32 v6, v2
; GFX7-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB31_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_noret_f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v2
; GFX6-NEXT:    v_lshl_b32_e32 v2, 0xffff, v4
; GFX6-NEXT:    v_not_b32_e32 v6, v2
; GFX6-NEXT:  .LBB31_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v3, v6
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB31_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr half, ptr addrspace(1) %ptr, i64 1023
  %unused = atomicrmw fadd ptr addrspace(1) %gep, half %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; bfloat
; --------------------------------------------------------------------

define bfloat @global_agent_atomic_fadd_ret_bf16(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB32_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB32_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB32_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB32_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB32_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v5, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB32_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB32_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xffff, v5
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v6, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX7-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v5, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v3, v4, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_or_b32_e32 v3, v3, v2
; GFX7-NEXT:    v_mov_b32_e32 v2, v3
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    buffer_atomic_cmpswap v[2:3], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB32_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v5, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX6-NEXT:    v_lshl_b32_e32 v3, 0xffff, v5
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v6, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX6-NEXT:  .LBB32_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v5, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v7
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_and_b32_e32 v3, v4, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v5, v2
; GFX6-NEXT:    v_or_b32_e32 v3, v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v2, v3
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    buffer_atomic_cmpswap v[2:3], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB32_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v5, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(1) %ptr, bfloat %val syncscope("agent") seq_cst
  ret bfloat %result
}

define bfloat @global_agent_atomic_fadd_ret_bf16__offset12b_pos(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB33_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB33_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB33_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB33_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB33_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v5, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB33_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB33_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v6
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v7, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX7-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v4, v3, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB33_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v4, 0xffff, v6
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v7, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX6-NEXT:  .LBB33_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v8
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, v3, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB33_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 1023
  %result = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val syncscope("agent") seq_cst
  ret bfloat %result
}

define bfloat @global_agent_atomic_fadd_ret_bf16__offset12b_neg(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB34_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB34_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB34_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB34_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB34_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v5, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB34_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB34_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v6
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v7, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX7-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v4, v3, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB34_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v4, 0xffff, v6
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v7, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX6-NEXT:  .LBB34_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v8
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, v3, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB34_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 -1024
  %result = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val syncscope("agent") seq_cst
  ret bfloat %result
 }

define void @global_agent_atomic_fadd_noret_bf16(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    global_load_b32 v4, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v6, v3
; GFX12-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX12-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB35_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v3, v0
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v6, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v4, v3, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX940-NEXT:    v_bfe_u32 v7, v4, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX940-NEXT:    v_add3_u32 v7, v7, v4, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v4, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v5, v4
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB35_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v3, v0 :: v_dual_lshlrev_b32 v2, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v6, v3
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX11-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB35_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v3, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v3, v5, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v6, v3
; GFX10-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v3, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB35_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v6, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v4, v3, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v4, v4, v2
; GFX90A-NEXT:    v_bfe_u32 v7, v4, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v4
; GFX90A-NEXT:    v_add3_u32 v7, v7, v4, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX90A-NEXT:    v_cndmask_b32_e32 v4, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v4, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v4, v5, v6, v4
; GFX90A-NEXT:    global_atomic_cmpswap v4, v[0:1], v[4:5], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v5, v4
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB35_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v3, v0
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v4, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX908-NEXT:    v_not_b32_e32 v6, v3
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v3, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX908-NEXT:    v_cndmask_b32_e32 v3, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v3, v4, v6, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB35_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, v0
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v3, v5, s4
; GFX8-NEXT:    v_not_b32_e32 v6, v3
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v5, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX8-NEXT:    v_bfe_u32 v8, v3, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v3
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX8-NEXT:    v_lshlrev_b32_sdwa v3, v5, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB35_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX7-NEXT:    v_lshl_b32_e32 v3, 0xffff, v5
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v6, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX7-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX7-NEXT:    v_mov_b32_e32 v8, v4
; GFX7-NEXT:    v_mov_b32_e32 v7, v3
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v4
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v4, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB35_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v4, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 3, v3
; GFX6-NEXT:    v_lshl_b32_e32 v3, 0xffff, v5
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v6, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:  .LBB35_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, v5, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v4, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, v5, v3
; GFX6-NEXT:    v_or_b32_e32 v3, v7, v3
; GFX6-NEXT:    v_mov_b32_e32 v8, v4
; GFX6-NEXT:    v_mov_b32_e32 v7, v3
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v4
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v4, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB35_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr addrspace(1) %ptr, bfloat %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_bf16__offset12b_pos(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX12-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v5, v5
; GFX12-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX12-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB36_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v3, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v4, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX940-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v7, v7, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB36_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v5, v5
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB36_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v5, v5
; GFX10-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB36_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB36_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB36_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX8-NEXT:    v_not_b32_e32 v5, v5
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX8-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB36_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v5, v5
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX7-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB36_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v5, v5
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX6-NEXT:  .LBB36_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB36_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 1023
  %unused = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_bf16__offset12b_neg(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX12-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v5, v5
; GFX12-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX12-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB37_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_movk_i32 s0, 0xf800
; GFX940-NEXT:    s_mov_b32 s1, -1
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v3, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v4, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX940-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v7, v7, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB37_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v5, v5
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB37_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v5, v5
; GFX10-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB37_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB37_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0xfffff800, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB37_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX8-NEXT:    v_not_b32_e32 v5, v5
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX8-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB37_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v5, v5
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX7-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB37_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v5, v5
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX6-NEXT:  .LBB37_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB37_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 -1024
  %unused = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val syncscope("agent") seq_cst
  ret void
}

define bfloat @global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off offset:2046
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX12-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB38_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:    s_mov_b32 s3, 0xffff0000
; GFX940-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX940-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX940-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX940-NEXT:    v_add3_u32 v4, v4, v3, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v3, v4, v6, vcc
; GFX940-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX940-NEXT:    v_and_or_b32 v4, v5, s3, v3
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB38_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v0, v3
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2046
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB38_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX10-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_add3_u32 v5, v5, v3, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX10-NEXT:    v_and_or_b32 v3, 0xffff0000, v4, v3
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2046 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB38_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX90A-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX90A-NEXT:    v_bfe_u32 v4, v3, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX90A-NEXT:    v_add3_u32 v4, v4, v3, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e32 v3, v4, v6, vcc
; GFX90A-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX90A-NEXT:    v_and_or_b32 v4, v5, s7, v3
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[4:5], off offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB38_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX908-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v2
; GFX908-NEXT:    v_bfe_u32 v5, v3, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v3
; GFX908-NEXT:    v_add3_u32 v5, v5, v3, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX908-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX908-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX908-NEXT:    v_and_or_b32 v3, v4, s7, v3
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB38_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_bfe_u32 v5, v0, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, v5, v0
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, 0x7fff, v5
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v7, vcc
; GFX8-NEXT:    v_or_b32_sdwa v5, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB38_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX7-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB38_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_bf16__offset12b_pos__align4:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX6-NEXT:  .LBB38_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB38_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v4
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 1023
  %result = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val syncscope("agent") seq_cst, align 4
  ret bfloat %result
}

define void @global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off offset:2046
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX12-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v5, v5, v2, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_and_or_b32 v2, 0xffff0000, v3, v2
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off offset:2046 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB39_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:    s_mov_b32 s3, 0xffff0000
; GFX940-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX940-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v5, v5, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX940-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    v_and_or_b32 v2, v3, s3, v2
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2046 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB39_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2046
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v5, v5, v2, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_and_or_b32 v2, 0xffff0000, v3, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off offset:2046 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB39_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v5, v5, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc_lo
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_or_b32 v2, 0xffff0000, v3, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2046 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB39_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX90A-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v5, v5, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX90A-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2046 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB39_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2046
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:    s_mov_b32 s7, 0xffff0000
; GFX908-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_bfe_u32 v5, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v6, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v5, v5, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v5, v6, vcc
; GFX908-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    v_and_or_b32 v2, v3, s7, v2
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2046 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB39_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_bfe_u32 v6, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v2
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, 0x7fff, v6
; GFX8-NEXT:    v_or_b32_e32 v7, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v6, v7, vcc
; GFX8-NEXT:    v_or_b32_sdwa v2, v5, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB39_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX7-NEXT:    v_mov_b32_e32 v6, v3
; GFX7-NEXT:    v_mov_b32_e32 v5, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v5
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB39_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_bf16__offset12b__align4_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64 offset:2046
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX6-NEXT:  .LBB39_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v5, v2
; GFX6-NEXT:    v_mov_b32_e32 v6, v3
; GFX6-NEXT:    v_mov_b32_e32 v5, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[5:6], v[0:1], s[4:7], 0 addr64 offset:2046 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v5
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB39_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 1023
  %unused = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val syncscope("agent") seq_cst, align 4
  ret void
}

define bfloat @global_system_atomic_fadd_ret_bf16__offset12b_pos(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX12-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    global_load_b32 v5, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX12-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v4, v4
; GFX12-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v6, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX12-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX12-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX12-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB40_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v5, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v3, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v4, v3, s0
; GFX940-NEXT:    v_not_b32_e32 v4, v4
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX940-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX940-NEXT:    v_add3_u32 v6, v6, v5, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB40_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX11-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    global_load_b32 v5, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX11-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v4, v4
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, v3, v6
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, v3, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v5, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB40_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v3, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX10-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    global_load_dword v5, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX10-NEXT:    v_lshlrev_b32_e64 v4, v3, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v4, v4
; GFX10-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v5
; GFX10-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v5, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB40_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX90A-NEXT:    global_load_dword v5, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX90A-NEXT:    v_not_b32_e32 v4, v4
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v5, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v5, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v6, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v6, v7, v4, v5
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v5, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v7
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB40_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v3, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX908-NEXT:    global_load_dword v5, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX908-NEXT:    v_not_b32_e32 v4, v4
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v5
; GFX908-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v5, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v5, v6, v4, v5
; GFX908-NEXT:    global_atomic_cmpswap v5, v[0:1], v[5:6], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB40_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v3
; GFX8-NEXT:    flat_load_dword v5, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v3, 3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 3, v3
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v4, v3, s4
; GFX8-NEXT:    v_not_b32_e32 v4, v4
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v5
; GFX8-NEXT:    v_lshrrev_b32_sdwa v5, v3, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v5
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v6, v4
; GFX8-NEXT:    v_lshlrev_b32_sdwa v5, v3, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v5, v7, v5
; GFX8-NEXT:    flat_atomic_cmpswap v5, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v5, v6
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB40_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v4, 0xffff, v6
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v7, v4
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX7-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v8
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v4, v3, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_mov_b32_e32 v5, v3
; GFX7-NEXT:    v_mov_b32_e32 v4, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB40_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_ret_bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v4, 0xffff, v6
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v7, v4
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX6-NEXT:  .LBB40_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v6, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v8
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, v3, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v6, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_mov_b32_e32 v5, v3
; GFX6-NEXT:    v_mov_b32_e32 v4, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[4:5], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v4, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v4
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB40_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, v6, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 1023
  %result = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val seq_cst
  ret bfloat %result
}

define void @global_system_atomic_fadd_noret_bf16__offset12b_pos(ptr addrspace(1) %ptr, bfloat %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX12-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX12-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX12-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX12-NEXT:    s_mov_b32 s0, 0
; GFX12-NEXT:    global_load_b32 v3, v[0:1], off
; GFX12-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX12-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_not_b32_e32 v5, v5
; GFX12-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX12-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX12-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX12-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX12-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX12-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX12-NEXT:    v_mov_b32_e32 v3, v2
; GFX12-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_cbranch_execnz .LBB41_1
; GFX12-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX12-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b64 s[0:1], 0x7fe
; GFX940-NEXT:    v_lshl_add_u64 v[4:5], v[0:1], 0, s[0:1]
; GFX940-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX940-NEXT:    v_mov_b32_e32 v1, v5
; GFX940-NEXT:    global_load_dword v3, v[0:1], off
; GFX940-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX940-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX940-NEXT:    s_mov_b32 s0, 0xffff
; GFX940-NEXT:    v_lshlrev_b32_e64 v5, v4, s0
; GFX940-NEXT:    v_not_b32_e32 v5, v5
; GFX940-NEXT:    s_mov_b64 s[0:1], 0
; GFX940-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX940-NEXT:    s_movk_i32 s2, 0x7fff
; GFX940-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX940-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX940-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX940-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX940-NEXT:    v_add3_u32 v7, v7, v2, s2
; GFX940-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX940-NEXT:    s_nop 1
; GFX940-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX940-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX940-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX940-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v3, v2
; GFX940-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_cbranch_execnz .LBB41_1
; GFX940-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX940-NEXT:    s_or_b64 exec, exec, s[0:1]
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX11-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX11-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX11-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_not_b32_e32 v5, v5
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX11-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB41_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, 0x7fe, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX10-NEXT:    v_lshlrev_b32_e64 v5, v4, 0xffff
; GFX10-NEXT:    v_not_b32_e32 v5, v5
; GFX10-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB41_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX90A-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX90A-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off
; GFX90A-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX90A-NEXT:    v_not_b32_e32 v5, v5
; GFX90A-NEXT:    s_mov_b64 s[4:5], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX90A-NEXT:    s_movk_i32 s6, 0x7fff
; GFX90A-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX90A-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX90A-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_cbranch_execnz .LBB41_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    v_add_co_u32_e32 v4, vcc, 0x7fe, v0
; GFX908-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX908-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX908-NEXT:    s_mov_b32 s4, 0xffff
; GFX908-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX908-NEXT:    v_not_b32_e32 v5, v5
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX908-NEXT:    s_movk_i32 s6, 0x7fff
; GFX908-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s6
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX908-NEXT:    v_cndmask_b32_e32 v2, v7, v8, vcc
; GFX908-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX908-NEXT:    v_and_or_b32 v2, v3, v5, v2
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB41_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0x7fe, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX8-NEXT:    s_mov_b32 s4, 0xffff
; GFX8-NEXT:    v_lshlrev_b32_e64 v5, v4, s4
; GFX8-NEXT:    v_not_b32_e32 v5, v5
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX8-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v4, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX8-NEXT:    v_bfe_u32 v8, v2, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; GFX8-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; GFX8-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX8-NEXT:    v_lshlrev_b32_sdwa v2, v4, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB41_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX7-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_not_b32_e32 v5, v5
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX7-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX7-NEXT:    v_mov_b32_e32 v8, v3
; GFX7-NEXT:    v_mov_b32_e32 v7, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v3, v7
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB41_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_noret_bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0x7fe, v0
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v0, -4, v4
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v3, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_and_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 3, v4
; GFX6-NEXT:    v_lshl_b32_e32 v5, 0xffff, v4
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_not_b32_e32 v5, v5
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX6-NEXT:  .LBB41_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, v4, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v6
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, v3, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, v4, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v7, v2
; GFX6-NEXT:    v_mov_b32_e32 v8, v3
; GFX6-NEXT:    v_mov_b32_e32 v7, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v3
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v3, v7
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB41_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr bfloat, ptr addrspace(1) %ptr, i64 1023
  %unused = atomicrmw fadd ptr addrspace(1) %gep, bfloat %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; <2 x half>
; --------------------------------------------------------------------

define <2 x half> @global_agent_atomic_fadd_ret_v2f16(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB42_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB42_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB42_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    v_add_f16_sdwa v3, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB42_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX7-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX7-NEXT:    v_mov_b32_e32 v9, v7
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    buffer_atomic_cmpswap v[8:9], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB42_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_v2f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX6-NEXT:  .LBB42_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX6-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX6-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX6-NEXT:    v_mov_b32_e32 v9, v7
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    buffer_atomic_cmpswap v[8:9], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB42_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v2
; GFX6-NEXT:    v_mov_b32_e32 v1, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(1) %ptr, <2 x half> %val syncscope("agent") seq_cst
  ret <2 x half> %result
}

define <2 x half> @global_agent_atomic_fadd_ret_v2f16__offset12b_pos(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB43_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB43_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB43_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f16_sdwa v0, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v1, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB43_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX7-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX7-NEXT:    v_mov_b32_e32 v9, v7
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    buffer_atomic_cmpswap v[8:9], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB43_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX6-NEXT:  .LBB43_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX6-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX6-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX6-NEXT:    v_mov_b32_e32 v9, v7
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    buffer_atomic_cmpswap v[8:9], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB43_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v2
; GFX6-NEXT:    v_mov_b32_e32 v1, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, <2 x half> %val syncscope("agent") seq_cst
  ret <2 x half> %result
}

define <2 x half> @global_agent_atomic_fadd_ret_v2f16__offset12b_neg(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:-2048 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:-2048
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB44_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB44_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:-2048 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB44_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f16_sdwa v0, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v1, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB44_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v6, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v2
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v0, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v0
; GFX7-NEXT:    v_mov_b32_e32 v9, v7
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    buffer_atomic_cmpswap v[8:9], v[4:5], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB44_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_v2f16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v6, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v2
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v6
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:  .LBB44_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX6-NEXT:    v_or_b32_e32 v7, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX6-NEXT:    v_or_b32_e32 v6, v8, v0
; GFX6-NEXT:    v_mov_b32_e32 v9, v7
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    buffer_atomic_cmpswap v[8:9], v[4:5], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB44_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(1) %ptr, i64 -512
  %result = atomicrmw fadd ptr addrspace(1) %gep, <2 x half> %val syncscope("agent") seq_cst
  ret <2 x half> %result
}

define void @global_agent_atomic_fadd_noret_v2f16(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB45_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB45_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v3, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB45_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB45_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_v2f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX6-NEXT:  .LBB45_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX6-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX6-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB45_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr addrspace(1) %ptr, <2 x half> %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_v2f16__offset12b_pos(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB46_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB46_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:2044
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:2044
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v3, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB46_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB46_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX6-NEXT:  .LBB46_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX6-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX6-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB46_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, <2 x half> %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_v2f16__offset12b_neg(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:-2048
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off offset:-2048
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB47_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:-2048
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB47_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:-2048
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:-2048
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v3, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB47_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB47_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_v2f16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX6-NEXT:  .LBB47_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX6-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX6-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB47_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(1) %ptr, i64 -512
  %unused = atomicrmw fadd ptr addrspace(1) %gep, <2 x half> %val syncscope("agent") seq_cst
  ret void
}

define <2 x half> @global_system_atomic_fadd_ret_v2f16__offset12b_pos(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB48_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB48_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_pk_add_f16 v0, v[0:1], v2, off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB48_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, v0
; GFX8-NEXT:    v_add_f16_sdwa v0, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v1, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v5, v0
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[0:1] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v1
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB48_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX7-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX7-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX7-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX7-NEXT:    v_mov_b32_e32 v9, v7
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    buffer_atomic_cmpswap v[8:9], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v8
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB48_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v2
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_ret_v2f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX6-NEXT:  .LBB48_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v7
; GFX6-NEXT:    v_or_b32_e32 v7, v2, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX6-NEXT:    v_or_b32_e32 v6, v8, v2
; GFX6-NEXT:    v_mov_b32_e32 v9, v7
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    buffer_atomic_cmpswap v[8:9], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v8
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v7
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB48_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v2
; GFX6-NEXT:    v_mov_b32_e32 v1, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, <2 x half> %val seq_cst
  ret <2 x half> %result
}

define void @global_system_atomic_fadd_noret_v2f16__offset12b_pos(ptr addrspace(1) %ptr, <2 x half> %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:2044 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v4, v[0:1], off offset:2044
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[3:4], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX11-NEXT:    v_mov_b32_e32 v4, v3
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_execnz .LBB49_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, v3
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB49_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_pk_add_f16 v[0:1], v2, off offset:2044
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v4, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[4:5], 0
; GFX908-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_pk_add_f16 v3, v4, v2
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[3:4], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX908-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX908-NEXT:    v_mov_b32_e32 v4, v3
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_cbranch_execnz .LBB49_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[4:5], 0
; GFX8-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_add_f16_sdwa v3, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-NEXT:    v_add_f16_e32 v5, v4, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[3:4] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v4
; GFX8-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX8-NEXT:    v_mov_b32_e32 v4, v3
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_cbranch_execnz .LBB49_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX7-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX7-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX7-NEXT:    v_mov_b32_e32 v8, v6
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB49_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_noret_v2f16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v6, v2
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v5
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v6
; GFX6-NEXT:  .LBB49_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX6-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX6-NEXT:    v_cvt_f32_f16_e32 v6, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v7, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_cvt_f16_f32_e32 v8, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX6-NEXT:    v_or_b32_e32 v6, v4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX6-NEXT:    v_or_b32_e32 v5, v7, v4
; GFX6-NEXT:    v_mov_b32_e32 v8, v6
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    buffer_atomic_cmpswap v[7:8], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 16, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v4, v7
; GFX6-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v7, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB49_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x half>, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, <2 x half> %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; <2 x bfloat>
; --------------------------------------------------------------------

define <2 x bfloat> @global_agent_atomic_fadd_ret_v2bf16(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[5:6], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB50_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB50_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[6:7], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB50_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB50_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v3
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v3, 16
; GFX8-NEXT:    flat_atomic_cmpswap v3, v[0:1], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB50_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX7-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v3
; GFX7-NEXT:    v_mov_b32_e32 v6, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB50_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_v2bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX6-NEXT:  .LBB50_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v3
; GFX6-NEXT:    v_mov_b32_e32 v6, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB50_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %result = atomicrmw fadd ptr addrspace(1) %ptr, <2 x bfloat> %val syncscope("agent") seq_cst
  ret <2 x bfloat> %result
}

define <2 x bfloat> @global_agent_atomic_fadd_ret_v2bf16__offset12b_pos(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off offset:2044 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[5:6], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB51_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB51_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[6:7], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB51_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB51_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v0
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v0, 16
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB51_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX7-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v3
; GFX7-NEXT:    v_mov_b32_e32 v6, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB51_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX6-NEXT:  .LBB51_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v3
; GFX6-NEXT:    v_mov_b32_e32 v6, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB51_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, <2 x bfloat> %val syncscope("agent") seq_cst
  ret <2 x bfloat> %result
}

define <2 x bfloat> @global_agent_atomic_fadd_ret_v2bf16__offset12b_neg(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off offset:-2048 th:TH_ATOMIC_RETURN scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off offset:-2048 sc0
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:-2048
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[5:6], off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB52_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB52_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[6:7], off offset:-2048 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB52_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off offset:-2048 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB52_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v0
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v0, 16
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB52_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v6, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX7-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v0, v0, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v1
; GFX7-NEXT:    v_mov_b32_e32 v6, v0
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[4:5], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB52_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_ret_v2bf16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v6, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0xfffff800, v0
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, -1, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX6-NEXT:  .LBB52_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX6-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v0, v0, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v1
; GFX6-NEXT:    v_mov_b32_e32 v6, v0
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[4:5], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v1
; GFX6-NEXT:    v_and_b32_e32 v1, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB52_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %ptr, i64 -512
  %result = atomicrmw fadd ptr addrspace(1) %gep, <2 x bfloat> %val syncscope("agent") seq_cst
  ret <2 x bfloat> %result
}

define void @global_agent_atomic_fadd_noret_v2bf16(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB53_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB53_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB53_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB53_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB53_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB53_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_v2bf16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:  .LBB53_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB53_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %unused = atomicrmw fadd ptr addrspace(1) %ptr, <2 x bfloat> %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_v2bf16__offset12b_pos(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off offset:2044 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off offset:2044
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB54_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB54_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB54_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB54_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB54_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB54_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:  .LBB54_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB54_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, <2 x bfloat> %val syncscope("agent") seq_cst
  ret void
}

define void @global_agent_atomic_fadd_noret_v2bf16__offset12b_neg(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off offset:-2048 scope:SCOPE_DEV
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_DEV
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off offset:-2048
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:-2048
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off offset:-2048 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB55_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:-2048 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB55_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:-2048 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB55_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:-2048
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:-2048 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB55_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xfffff800, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB55_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_movk_i32 s4, 0xf800
; GFX7-NEXT:    s_mov_b32 s5, -1
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX7-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB55_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_agent_atomic_fadd_noret_v2bf16__offset12b_neg:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_movk_i32 s4, 0xf800
; GFX6-NEXT:    s_mov_b32 s5, -1
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0xfffff800, v0
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, -1, v1, vcc
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:  .LBB55_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB55_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %ptr, i64 -512
  %unused = atomicrmw fadd ptr addrspace(1) %gep, <2 x bfloat> %val syncscope("agent") seq_cst
  ret void
}

define <2 x bfloat> @global_system_atomic_fadd_ret_v2bf16__offset12b_pos(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off offset:2044 th:TH_ATOMIC_RETURN scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v0, v[0:1], v2, off offset:2044 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v6, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX11-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX11-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX11-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX11-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v3, v[0:1], v[5:6], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB56_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v6, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX10-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX10-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX10-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v3
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_add3_u32 v7, v7, v3, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v3, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v5, v5, v3, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v3, v6
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB56_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v7
; GFX90A-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX90A-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX90A-NEXT:    v_bfe_u32 v6, v3, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX90A-NEXT:    v_add3_u32 v6, v6, v3, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX90A-NEXT:    v_cndmask_b32_e64 v3, v6, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v6, v5, v3, s9
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v3, v[0:1], v[6:7], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v7
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB56_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_mov_b32_e32 v6, v3
; GFX908-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX908-NEXT:    v_add_f32_e32 v3, v3, v4
; GFX908-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX908-NEXT:    v_bfe_u32 v7, v3, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v3
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX908-NEXT:    v_add3_u32 v7, v7, v3, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v5, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v3, v3
; GFX908-NEXT:    v_cndmask_b32_e64 v3, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v5, v5, v3, s9
; GFX908-NEXT:    global_atomic_cmpswap v3, v[0:1], v[5:6], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v6
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB56_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v0, v3
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v4, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[3:4]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX8-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v6, v0
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_add_f32_e32 v5, v5, v2
; GFX8-NEXT:    v_bfe_u32 v7, v0, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v0
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX8-NEXT:    v_alignbit_b32 v5, v5, v0, 16
; GFX8-NEXT:    flat_atomic_cmpswap v0, v[3:4], v[5:6] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v0, v6
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB56_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX7-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX7-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v3
; GFX7-NEXT:    v_mov_b32_e32 v6, v2
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB56_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_ret_v2bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v6, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX6-NEXT:    v_and_b32_e32 v5, 0xffff0000, v6
; GFX6-NEXT:  .LBB56_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v5
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v4
; GFX6-NEXT:    v_alignbit_b32 v3, v2, v3, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v2, v2, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v3
; GFX6-NEXT:    v_mov_b32_e32 v6, v2
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v3
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB56_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    v_mov_b32_e32 v0, v3
; GFX6-NEXT:    v_mov_b32_e32 v1, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %ptr, i64 511
  %result = atomicrmw fadd ptr addrspace(1) %gep, <2 x bfloat> %val seq_cst
  ret <2 x bfloat> %result
}

define void @global_system_atomic_fadd_noret_v2bf16__offset12b_pos(ptr addrspace(1) %ptr, <2 x bfloat> %val) #0 {
; GFX12-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_wb scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off offset:2044 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    global_inv scope:SCOPE_SYS
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    buffer_wbl2 sc0 sc1
; GFX940-NEXT:    global_atomic_pk_add_bf16 v[0:1], v2, off offset:2044 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    buffer_inv sc0 sc1
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v3, v[0:1], off offset:2044
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-NEXT:    s_mov_b32 s1, 0
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x1
; GFX11-NEXT:    .p2align 6
; GFX11-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX11-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX11-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX11-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX11-NEXT:    v_cmp_u_f32_e64 s0, v2, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    global_atomic_cmpswap_b32 v2, v[0:1], v[2:3], off offset:2044 glc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    buffer_gl1_inv
; GFX11-NEXT:    buffer_gl0_inv
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_mov_b32_e32 v3, v2
; GFX11-NEXT:    s_or_b32 s1, vcc_lo, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_cbranch_execnz .LBB57_1
; GFX11-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX11-NEXT:    s_set_inst_prefetch_distance 0x2
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX10-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX10-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX10-NEXT:    v_bfe_u32 v8, v6, 16, 1
; GFX10-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX10-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_add3_u32 v7, v7, v2, 0x7fff
; GFX10-NEXT:    v_add3_u32 v8, v8, v6, 0x7fff
; GFX10-NEXT:    v_cmp_u_f32_e64 s4, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v8, v10, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v7, v9, s4
; GFX10-NEXT:    v_perm_b32 v2, v6, v2, 0x7060302
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2044 glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    buffer_gl1_inv
; GFX10-NEXT:    buffer_gl0_inv
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_mov_b32_e32 v3, v2
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB57_1
; GFX10-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX90A-NEXT:    s_mov_b64 s[6:7], 0
; GFX90A-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX90A-NEXT:    s_movk_i32 s8, 0x7fff
; GFX90A-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX90A-NEXT:    s_mov_b32 s9, 0x7060302
; GFX90A-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX90A-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX90A-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX90A-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX90A-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX90A-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX90A-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX90A-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX90A-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX90A-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX90A-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX90A-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX90A-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX90A-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX90A-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX90A-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX90A-NEXT:    buffer_wbl2
; GFX90A-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2044 glc
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    buffer_invl2
; GFX90A-NEXT:    buffer_wbinvl1
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX90A-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX90A-NEXT:    v_mov_b32_e32 v3, v2
; GFX90A-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_cbranch_execnz .LBB57_1
; GFX90A-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX90A-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX908-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX908-NEXT:    global_load_dword v3, v[0:1], off offset:2044
; GFX908-NEXT:    s_mov_b64 s[6:7], 0
; GFX908-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX908-NEXT:    s_movk_i32 s8, 0x7fff
; GFX908-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX908-NEXT:    s_mov_b32 s9, 0x7060302
; GFX908-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX908-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX908-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX908-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX908-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX908-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX908-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX908-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX908-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX908-NEXT:    v_add3_u32 v7, v7, v2, s8
; GFX908-NEXT:    v_add3_u32 v9, v9, v6, s8
; GFX908-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX908-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX908-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX908-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX908-NEXT:    v_perm_b32 v2, v6, v2, s9
; GFX908-NEXT:    global_atomic_cmpswap v2, v[0:1], v[2:3], off offset:2044 glc
; GFX908-NEXT:    s_waitcnt vmcnt(0)
; GFX908-NEXT:    buffer_wbinvl1
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX908-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX908-NEXT:    v_mov_b32_e32 v3, v2
; GFX908-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_cbranch_execnz .LBB57_1
; GFX908-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX908-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX908-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0x7fc, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    s_mov_b64 s[6:7], 0
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX8-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX8-NEXT:    v_add_f32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_f32_e32 v6, v6, v5
; GFX8-NEXT:    v_bfe_u32 v7, v2, 16, 1
; GFX8-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v2
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, 0x7fff, v7
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; GFX8-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; GFX8-NEXT:    v_cmp_u_f32_e64 s[4:5], v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, v7, v8, s[4:5]
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; GFX8-NEXT:    v_alignbit_b32 v2, v6, v2, 16
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    buffer_wbinvl1
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[6:7], vcc, s[6:7]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_cbranch_execnz .LBB57_1
; GFX8-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX8-NEXT:    s_or_b64 exec, exec, s[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    s_mov_b32 s7, 0xf000
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    s_mov_b32 s5, s6
; GFX7-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    s_mov_b64 s[8:9], 0
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX7-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX7-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX7-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX7-NEXT:    v_mov_b32_e32 v7, v5
; GFX7-NEXT:    v_mov_b32_e32 v6, v4
; GFX7-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    buffer_wbinvl1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX7-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_cbranch_execnz .LBB57_1
; GFX7-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX7-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-LABEL: global_system_atomic_fadd_noret_v2bf16__offset12b_pos:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s6, 0
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s4, s6
; GFX6-NEXT:    s_mov_b32 s5, s6
; GFX6-NEXT:    buffer_load_dword v5, v[0:1], s[4:7], 0 addr64 offset:2044
; GFX6-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX6-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX6-NEXT:    s_mov_b64 s[8:9], 0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX6-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:  .LBB57_1: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX6-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_and_b32_e32 v7, 0xffff0000, v4
; GFX6-NEXT:    v_and_b32_e32 v6, 0xffff0000, v5
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_add_f32_e32 v7, v7, v3
; GFX6-NEXT:    v_add_f32_e32 v6, v6, v2
; GFX6-NEXT:    v_alignbit_b32 v5, v4, v5, 16
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 16, v7
; GFX6-NEXT:    v_alignbit_b32 v4, v4, v6, 16
; GFX6-NEXT:    v_mov_b32_e32 v7, v5
; GFX6-NEXT:    v_mov_b32_e32 v6, v4
; GFX6-NEXT:    buffer_atomic_cmpswap v[6:7], v[0:1], s[4:7], 0 addr64 offset:2044 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    buffer_wbinvl1
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v6, v5
; GFX6-NEXT:    v_and_b32_e32 v4, 0xffff0000, v6
; GFX6-NEXT:    s_or_b64 s[8:9], vcc, s[8:9]
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_cbranch_execnz .LBB57_1
; GFX6-NEXT:  ; %bb.2: ; %atomicrmw.end
; GFX6-NEXT:    s_or_b64 exec, exec, s[8:9]
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr <2 x bfloat>, ptr addrspace(1) %ptr, i64 511
  %unused = atomicrmw fadd ptr addrspace(1) %gep, <2 x bfloat> %val seq_cst
  ret void
}

; --------------------------------------------------------------------
; misc
; --------------------------------------------------------------------

define amdgpu_kernel void @infer_as_before_atomic(ptr addrspace(4) %arg) #1 {
; GFX12-LABEL: infer_as_before_atomic:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_mov_b32 s0, exec_lo
; GFX12-NEXT:    s_mov_b32 s1, exec_lo
; GFX12-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX12-NEXT:    s_cbranch_execz .LBB58_2
; GFX12-NEXT:  ; %bb.1:
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX12-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    global_atomic_add_f32 v0, v1, s[2:3] scope:SCOPE_DEV
; GFX12-NEXT:  .LBB58_2:
; GFX12-NEXT:    s_nop 0
; GFX12-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX12-NEXT:    s_endpgm
;
; GFX940-LABEL: infer_as_before_atomic:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_mov_b64 s[0:1], exec
; GFX940-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX940-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX940-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX940-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX940-NEXT:    s_cbranch_execz .LBB58_2
; GFX940-NEXT:  ; %bb.1:
; GFX940-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX940-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    global_atomic_add_f32 v0, v1, s[2:3]
; GFX940-NEXT:  .LBB58_2:
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: infer_as_before_atomic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    s_mov_b32 s1, exec_lo
; GFX11-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmpx_eq_u32_e32 0, v0
; GFX11-NEXT:    s_cbranch_execz .LBB58_2
; GFX11-NEXT:  ; %bb.1:
; GFX11-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX11-NEXT:    s_bcnt1_i32_b32 s0, s0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_atomic_add_f32 v0, v1, s[2:3]
; GFX11-NEXT:  .LBB58_2:
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
;
; GFX10-LABEL: infer_as_before_atomic:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_mov_b32 s5, exec_lo
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_mbcnt_lo_u32_b32 v0, s5, 0
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX10-NEXT:    s_cbranch_execz .LBB58_3
; GFX10-NEXT:  ; %bb.1:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX10-NEXT:    s_bcnt1_i32_b32 s3, s5
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    v_cvt_f32_ubyte0_e32 v2, s3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-NEXT:  .LBB58_2: ; %atomicrmw.start
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX10-NEXT:    global_atomic_cmpswap v0, v3, v[0:1], s[0:1] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_cmp_eq_u32_e32 vcc_lo, v0, v1
; GFX10-NEXT:    v_mov_b32_e32 v1, v0
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB58_2
; GFX10-NEXT:  .LBB58_3:
; GFX10-NEXT:    s_endpgm
;
; GFX90A-LABEL: infer_as_before_atomic:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_mov_b64 s[0:1], exec
; GFX90A-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX90A-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX90A-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX90A-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX90A-NEXT:    s_cbranch_execz .LBB58_2
; GFX90A-NEXT:  ; %bb.1:
; GFX90A-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX90A-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX90A-NEXT:    v_mov_b32_e32 v0, 0
; GFX90A-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX90A-NEXT:    s_waitcnt lgkmcnt(0)
; GFX90A-NEXT:    global_atomic_add_f32 v0, v1, s[2:3]
; GFX90A-NEXT:  .LBB58_2:
; GFX90A-NEXT:    s_endpgm
;
; GFX908-LABEL: infer_as_before_atomic:
; GFX908:       ; %bb.0:
; GFX908-NEXT:    s_mov_b64 s[0:1], exec
; GFX908-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX908-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX908-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX908-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX908-NEXT:    s_cbranch_execz .LBB58_2
; GFX908-NEXT:  ; %bb.1:
; GFX908-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX908-NEXT:    s_bcnt1_i32_b64 s0, s[0:1]
; GFX908-NEXT:    v_mov_b32_e32 v0, 0
; GFX908-NEXT:    v_cvt_f32_ubyte0_e32 v1, s0
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX908-NEXT:    s_waitcnt lgkmcnt(0)
; GFX908-NEXT:    global_atomic_add_f32 v0, v1, s[2:3]
; GFX908-NEXT:  .LBB58_2:
; GFX908-NEXT:    s_endpgm
;
; GFX8-LABEL: infer_as_before_atomic:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_mov_b64 s[0:1], exec
; GFX8-NEXT:    v_mbcnt_lo_u32_b32 v0, s0, 0
; GFX8-NEXT:    v_mbcnt_hi_u32_b32 v0, s1, v0
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX8-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX8-NEXT:    s_cbranch_execz .LBB58_3
; GFX8-NEXT:  ; %bb.1:
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NEXT:    s_bcnt1_i32_b64 s5, s[0:1]
; GFX8-NEXT:    s_mov_b64 s[0:1], 0
; GFX8-NEXT:    v_cvt_f32_ubyte0_e32 v4, s5
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_load_dword s4, s[2:3], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, s4
; GFX8-NEXT:  .LBB58_2: ; %atomicrmw.start
; GFX8-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX8-NEXT:    v_add_f32_e32 v2, v3, v4
; GFX8-NEXT:    flat_atomic_cmpswap v2, v[0:1], v[2:3] glc
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_cmp_eq_u32_e32 vcc, v2, v3
; GFX8-NEXT:    s_or_b64 s[0:1], vcc, s[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v3, v2
; GFX8-NEXT:    s_andn2_b64 exec, exec, s[0:1]
; GFX8-NEXT:    s_cbranch_execnz .LBB58_2
; GFX8-NEXT:  .LBB58_3:
; GFX8-NEXT:    s_endpgm
;
; GFX7-LABEL: infer_as_before_atomic:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_mov_b64 s[4:5], exec
; GFX7-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s4, 0
; GFX7-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s5, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX7-NEXT:    s_cbranch_execz .LBB58_3
; GFX7-NEXT:  ; %bb.1:
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX7-NEXT:    s_bcnt1_i32_b64 s6, s[4:5]
; GFX7-NEXT:    s_mov_b64 s[4:5], 0
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    v_cvt_f32_ubyte0_e32 v2, s6
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s2
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:  .LBB58_2: ; %atomicrmw.start
; GFX7-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX7-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX7-NEXT:    v_mov_b32_e32 v4, v1
; GFX7-NEXT:    v_mov_b32_e32 v3, v0
; GFX7-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX7-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX7-NEXT:    s_cbranch_execnz .LBB58_2
; GFX7-NEXT:  .LBB58_3:
; GFX7-NEXT:    s_endpgm
;
; GFX6-LABEL: infer_as_before_atomic:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_mov_b64 s[4:5], exec
; GFX6-NEXT:    v_mbcnt_lo_u32_b32_e64 v0, s4, 0
; GFX6-NEXT:    v_mbcnt_hi_u32_b32_e32 v0, s5, v0
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX6-NEXT:    s_and_saveexec_b64 s[0:1], vcc
; GFX6-NEXT:    s_cbranch_execz .LBB58_3
; GFX6-NEXT:  ; %bb.1:
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[2:3], 0x0
; GFX6-NEXT:    s_bcnt1_i32_b64 s6, s[4:5]
; GFX6-NEXT:    s_mov_b64 s[4:5], 0
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    v_cvt_f32_ubyte0_e32 v2, s6
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:  .LBB58_2: ; %atomicrmw.start
; GFX6-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX6-NEXT:    v_add_f32_e32 v0, v1, v2
; GFX6-NEXT:    s_waitcnt expcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, v1
; GFX6-NEXT:    v_mov_b32_e32 v3, v0
; GFX6-NEXT:    buffer_atomic_cmpswap v[3:4], off, s[0:3], 0 glc
; GFX6-NEXT:    s_waitcnt vmcnt(0)
; GFX6-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v1
; GFX6-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GFX6-NEXT:    v_mov_b32_e32 v1, v3
; GFX6-NEXT:    s_andn2_b64 exec, exec, s[4:5]
; GFX6-NEXT:    s_cbranch_execnz .LBB58_2
; GFX6-NEXT:  .LBB58_3:
; GFX6-NEXT:    s_endpgm
  %load = load ptr, ptr addrspace(4) %arg
  %v = atomicrmw fadd ptr %load, float 1.0 syncscope("agent-one-as") monotonic, align 4
  ret void
}

attributes #0 = { nounwind "amdgpu-unsafe-fp-atomics"="true" }
attributes #1 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" "amdgpu-unsafe-fp-atomics"="true" }
