/********************************************************************************/
/*										*/
/*			     TPM Size Checks					*/
/*			     Written by Ken Goldman				*/
/*		       IBM Thomas J. Watson Research Center			*/
/*            $Id: TableMarshalData.c 1628 2020-05-27 19:35:29Z kgoldman $	*/
/*										*/
/*  Licenses and Notices							*/
/*										*/
/*  1. Copyright Licenses:							*/
/*										*/
/*  - Trusted Computing Group (TCG) grants to the user of the source code in	*/
/*    this specification (the "Source Code") a worldwide, irrevocable, 		*/
/*    nonexclusive, royalty free, copyright license to reproduce, create 	*/
/*    derivative works, distribute, display and perform the Source Code and	*/
/*    derivative works thereof, and to grant others the rights granted herein.	*/
/*										*/
/*  - The TCG grants to the user of the other parts of the specification 	*/
/*    (other than the Source Code) the rights to reproduce, distribute, 	*/
/*    display, and perform the specification solely for the purpose of 		*/
/*    developing products based on such documents.				*/
/*										*/
/*  2. Source Code Distribution Conditions:					*/
/*										*/
/*  - Redistributions of Source Code must retain the above copyright licenses, 	*/
/*    this list of conditions and the following disclaimers.			*/
/*										*/
/*  - Redistributions in binary form must reproduce the above copyright 	*/
/*    licenses, this list of conditions	and the following disclaimers in the 	*/
/*    documentation and/or other materials provided with the distribution.	*/
/*										*/
/*  3. Disclaimers:								*/
/*										*/
/*  - THE COPYRIGHT LICENSES SET FORTH ABOVE DO NOT REPRESENT ANY FORM OF	*/
/*  LICENSE OR WAIVER, EXPRESS OR IMPLIED, BY ESTOPPEL OR OTHERWISE, WITH	*/
/*  RESPECT TO PATENT RIGHTS HELD BY TCG MEMBERS (OR OTHER THIRD PARTIES)	*/
/*  THAT MAY BE NECESSARY TO IMPLEMENT THIS SPECIFICATION OR OTHERWISE.		*/
/*  Contact TCG Administration (admin@trustedcomputinggroup.org) for 		*/
/*  information on specification licensing rights available through TCG 	*/
/*  membership agreements.							*/
/*										*/
/*  - THIS SPECIFICATION IS PROVIDED "AS IS" WITH NO EXPRESS OR IMPLIED 	*/
/*    WARRANTIES WHATSOEVER, INCLUDING ANY WARRANTY OF MERCHANTABILITY OR 	*/
/*    FITNESS FOR A PARTICULAR PURPOSE, ACCURACY, COMPLETENESS, OR 		*/
/*    NONINFRINGEMENT OF INTELLECTUAL PROPERTY RIGHTS, OR ANY WARRANTY 		*/
/*    OTHERWISE ARISING OUT OF ANY PROPOSAL, SPECIFICATION OR SAMPLE.		*/
/*										*/
/*  - Without limitation, TCG and its members and licensors disclaim all 	*/
/*    liability, including liability for infringement of any proprietary 	*/
/*    rights, relating to use of information in this specification and to the	*/
/*    implementation of this specification, and TCG disclaims all liability for	*/
/*    cost of procurement of substitute goods or services, lost profits, loss 	*/
/*    of use, loss of data or any incidental, consequential, direct, indirect, 	*/
/*    or special damages, whether under contract, tort, warranty or otherwise, 	*/
/*    arising in any way out of use or reliance upon this specification or any 	*/
/*    information herein.							*/
/*										*/
/*  (c) Copyright IBM Corp. and others, 2019 - 2020				*/
/*										*/
/********************************************************************************/

/* 9.10.8.2	TableMarshalData.c */
/* This file contains the data initializer used for the table-driven marshaling code. */

#include "Tpm.h"
#if TABLE_DRIVEN_MARSHAL
#include "TableMarshal.h"
#include "Marshal.h"

/* The array marshaling table */

ArrayMarshal_mst   ArrayLookupTable[] = {
    ARRAY_MARSHAL_ENTRY(UINT8),
    ARRAY_MARSHAL_ENTRY(TPM_CC),
    ARRAY_MARSHAL_ENTRY(TPMA_CC),
    ARRAY_MARSHAL_ENTRY(TPM_ALG_ID),
    ARRAY_MARSHAL_ENTRY(TPM_HANDLE),
    ARRAY_MARSHAL_ENTRY(TPM2B_DIGEST),
    ARRAY_MARSHAL_ENTRY(TPMT_HA),
    ARRAY_MARSHAL_ENTRY(TPMS_PCR_SELECTION),
    ARRAY_MARSHAL_ENTRY(TPMS_ALG_PROPERTY),
    ARRAY_MARSHAL_ENTRY(TPMS_TAGGED_PROPERTY),
    ARRAY_MARSHAL_ENTRY(TPMS_TAGGED_PCR_SELECT),
    ARRAY_MARSHAL_ENTRY(TPM_ECC_CURVE),
    ARRAY_MARSHAL_ENTRY(TPMS_TAGGED_POLICY),
    ARRAY_MARSHAL_ENTRY(TPMS_ACT_DATA),
    ARRAY_MARSHAL_ENTRY(TPMS_AC_OUTPUT)};

/* The main marshaling structure */

MarshalData_st MarshalData = {
    // UINT8_DATA
    {UINT_MTYPE, 0},
    // UINT16_DATA
    {UINT_MTYPE, 1},
    // UINT32_DATA
    {UINT_MTYPE, 2},
    // UINT64_DATA
    {UINT_MTYPE, 3},
    // INT8_DATA
    {UINT_MTYPE, 0 + IS_SIGNED},
    // INT16_DATA
    {UINT_MTYPE, 1 + IS_SIGNED},
    // INT32_DATA
    {UINT_MTYPE, 2 + IS_SIGNED},
    // INT64_DATA
    {UINT_MTYPE, 3 + IS_SIGNED},
    // UINT0_DATA
    {NULL_MTYPE, 0},
    // TPM_ECC_CURVE_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_CURVE,
     {TPM_ECC_NONE,
      RANGE(1, 32, UINT16),
      (UINT32)((ECC_NIST_P192 << 0) | (ECC_NIST_P224 << 1) | (ECC_NIST_P256 << 2) |
	       (ECC_NIST_P384 << 3) | (ECC_NIST_P521 << 4) | (ECC_BN_P256 << 15)  |
	       (ECC_BN_P638 << 16)  | (ECC_SM2_P256 << 31))}},
    // TPM_CLOCK_ADJUST_DATA
    {MIN_MAX_MTYPE, ONE_BYTES|IS_SIGNED, (UINT8)TPM_RC_VALUE,
     {RANGE(TPM_CLOCK_COARSE_SLOWER, TPM_CLOCK_COARSE_FASTER, INT8)}},
    // TPM_EO_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(TPM_EO_EQ, TPM_EO_BITCLEAR, UINT16)}},
    // TPM_SU_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE, 2,
     {TPM_SU_CLEAR, TPM_SU_STATE}},
    // TPM_SE_DATA
    {TABLE_MTYPE, ONE_BYTES, (UINT8)TPM_RC_VALUE, 3,
     {TPM_SE_HMAC, TPM_SE_POLICY, TPM_SE_TRIAL}},
    // TPM_CAP_DATA
    {VALUES_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 1, 1,
     {RANGE(TPM_CAP_ALGS, TPM_CAP_ACT, UINT32),
      TPM_CAP_VENDOR_PROPERTY}},
    // TPMA_ALGORITHM_DATA
    {ATTRIBUTES_MTYPE, FOUR_BYTES, 0xFFFFF8F0},
    // TPMA_OBJECT_DATA
    {ATTRIBUTES_MTYPE, FOUR_BYTES, 0xFFF0F309},
    // TPMA_SESSION_DATA
    {ATTRIBUTES_MTYPE, ONE_BYTES, 0x00000018},
    // TPMA_ACT_DATA
    {ATTRIBUTES_MTYPE, FOUR_BYTES, 0xFFFFFFFC},
    // TPMI_YES_NO_DATA
    {TABLE_MTYPE, ONE_BYTES, (UINT8)TPM_RC_VALUE, 2,
     {NO, YES}},
    // TPMI_DH_OBJECT_DATA
    {VALUES_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 2, 0,
     {TPM_RH_NULL,
      RANGE(TRANSIENT_FIRST, TRANSIENT_LAST, UINT32),
      RANGE(PERSISTENT_FIRST, PERSISTENT_LAST, UINT32)}},
    // TPMI_DH_PARENT_DATA
    {VALUES_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 2, 3,
     {TPM_RH_NULL,
      RANGE(TRANSIENT_FIRST, TRANSIENT_LAST, UINT32),
      RANGE(PERSISTENT_FIRST, PERSISTENT_LAST, UINT32),
      TPM_RH_OWNER, TPM_RH_ENDORSEMENT, TPM_RH_PLATFORM}},
    // TPMI_DH_PERSISTENT_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(PERSISTENT_FIRST, PERSISTENT_LAST, UINT32)}},
    // TPMI_DH_ENTITY_DATA
    {VALUES_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 5, 4,
     {TPM_RH_NULL,
      RANGE(TRANSIENT_FIRST, TRANSIENT_LAST, UINT32),
      RANGE(PERSISTENT_FIRST, PERSISTENT_LAST, UINT32),
      RANGE(NV_INDEX_FIRST, NV_INDEX_LAST, UINT32),
      RANGE(PCR_FIRST, PCR_LAST, UINT32),
      RANGE(TPM_RH_AUTH_00, TPM_RH_AUTH_FF, UINT32),
      TPM_RH_OWNER, TPM_RH_LOCKOUT, TPM_RH_ENDORSEMENT, TPM_RH_PLATFORM}},
    // TPMI_DH_PCR_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE,
     {TPM_RH_NULL,
      RANGE(PCR_FIRST, PCR_LAST, UINT32)}},
    // TPMI_SH_AUTH_SESSION_DATA
    {VALUES_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 2, 0,
     {TPM_RS_PW,
      RANGE(HMAC_SESSION_FIRST, HMAC_SESSION_LAST, UINT32),
      RANGE(POLICY_SESSION_FIRST, POLICY_SESSION_LAST, UINT32)}},
    // TPMI_SH_HMAC_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(HMAC_SESSION_FIRST, HMAC_SESSION_LAST, UINT32)}},
    // TPMI_SH_POLICY_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(POLICY_SESSION_FIRST, POLICY_SESSION_LAST, UINT32)}},
    // TPMI_DH_CONTEXT_DATA
    {VALUES_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 3, 0,
     {RANGE(HMAC_SESSION_FIRST, HMAC_SESSION_LAST, UINT32),
      RANGE(POLICY_SESSION_FIRST, POLICY_SESSION_LAST, UINT32),
      RANGE(TRANSIENT_FIRST, TRANSIENT_LAST, UINT32)}},
    // TPMI_DH_SAVED_DATA
    {VALUES_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 2, 3,
     {RANGE(HMAC_SESSION_FIRST, HMAC_SESSION_LAST, UINT32),
      RANGE(POLICY_SESSION_FIRST, POLICY_SESSION_LAST, UINT32),
      0x80000000, 0x80000001, 0x80000002}},
    // TPMI_RH_HIERARCHY_DATA
    {TABLE_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 3,
     {TPM_RH_NULL,
      TPM_RH_OWNER, TPM_RH_ENDORSEMENT, TPM_RH_PLATFORM}},
    // TPMI_RH_ENABLES_DATA
    {TABLE_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 4,
     {TPM_RH_NULL,
      TPM_RH_OWNER, TPM_RH_ENDORSEMENT, TPM_RH_PLATFORM, TPM_RH_PLATFORM_NV}},
    // TPMI_RH_HIERARCHY_AUTH_DATA
    {TABLE_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 4,
     {TPM_RH_OWNER, TPM_RH_LOCKOUT, TPM_RH_ENDORSEMENT, TPM_RH_PLATFORM}},
    // TPMI_RH_HIERARCHY_POLICY_DATA
    {VALUES_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 1, 4,
     {RANGE(TPM_RH_ACT_0, TPM_RH_ACT_F, UINT32),
      TPM_RH_OWNER, TPM_RH_LOCKOUT, TPM_RH_ENDORSEMENT, TPM_RH_PLATFORM}},
    // TPMI_RH_PLATFORM_DATA
    {TABLE_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 1,
     {TPM_RH_PLATFORM}},
    // TPMI_RH_OWNER_DATA
    {TABLE_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 1,
     {TPM_RH_NULL,
      TPM_RH_OWNER}},
    // TPMI_RH_ENDORSEMENT_DATA
    {TABLE_MTYPE, FOUR_BYTES|TAKES_NULL, (UINT8)TPM_RC_VALUE, 1,
     {TPM_RH_NULL,
      TPM_RH_ENDORSEMENT}},
    // TPMI_RH_PROVISION_DATA
    {TABLE_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 2,
     {TPM_RH_OWNER, TPM_RH_PLATFORM}},
    // TPMI_RH_CLEAR_DATA
    {TABLE_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 2,
     {TPM_RH_LOCKOUT, TPM_RH_PLATFORM}},
    // TPMI_RH_NV_AUTH_DATA
    {VALUES_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 1, 2,
     {RANGE(NV_INDEX_FIRST, NV_INDEX_LAST, UINT32),
      TPM_RH_OWNER, TPM_RH_PLATFORM}},
    // TPMI_RH_LOCKOUT_DATA
    {TABLE_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 1,
     {TPM_RH_LOCKOUT}},
    // TPMI_RH_NV_INDEX_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(NV_INDEX_FIRST, NV_INDEX_LAST, UINT32)}},
    // TPMI_RH_AC_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(AC_FIRST, AC_LAST, UINT32)}},
    // TPMI_RH_ACT_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(TPM_RH_ACT_0, TPM_RH_ACT_F, UINT32)}},
    // TPMI_ALG_HASH_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_HASH,
     {TPM_ALG_NULL,
      RANGE(4, 41, UINT16),
      (UINT32)((ALG_SHA1 << 0)   | (ALG_SHA256 << 7) | (ALG_SHA384 << 8) |
	       (ALG_SHA512 << 9) | (ALG_SM3_256 << 14)),
      (UINT32)((ALG_SHA3_256 << 3)|(ALG_SHA3_384 << 4)|(ALG_SHA3_512 << 5))}},
    // TPMI_ALG_ASYM_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_ASYMMETRIC,
     {TPM_ALG_NULL,
      RANGE(1, 35, UINT16),
      (UINT32)((ALG_RSA << 0)),
      (UINT32)((ALG_ECC << 2))}},
    // TPMI_ALG_SYM_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_SYMMETRIC,
     {TPM_ALG_NULL,
      RANGE(3, 38, UINT16),
      (UINT32)((ALG_TDES << 0)|(ALG_AES << 3)|(ALG_XOR << 7)|(ALG_SM4 << 16)),
      (UINT32)((ALG_CAMELLIA << 3))}},
    // TPMI_ALG_SYM_OBJECT_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_SYMMETRIC,
     {TPM_ALG_NULL,
      RANGE(3, 38, UINT16),
      ((ALG_TDES << 0)|(ALG_AES << 3)|(ALG_SM4 << 16)),
      ((ALG_CAMELLIA << 3))}},
    // TPMI_ALG_SYM_MODE_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_MODE,
     {TPM_ALG_NULL,
      RANGE(63, 68, UINT16),
      (UINT32)((ALG_CMAC << 0) | (ALG_CTR << 1)  | (ALG_OFB << 2) |
	       (ALG_CBC << 3) | (ALG_CFB << 4)  | (ALG_ECB << 5))}},
    // TPMI_ALG_KDF_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_KDF,
     {TPM_ALG_NULL,
      RANGE(7, 34, UINT16),
      (UINT32)((ALG_MGF1 << 0)            | (ALG_KDF1_SP800_56A << 25) |
	       (ALG_KDF2 << 26)           | (ALG_KDF1_SP800_108 << 27))}},
    // TPMI_ALG_SIG_SCHEME_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_SCHEME,
     {TPM_ALG_NULL,
      RANGE(5, 28, UINT16),
      (UINT32)((ALG_HMAC << 0)    | (ALG_RSASSA << 15) | (ALG_RSAPSS << 17) |
	       (ALG_ECDSA << 19)  | (ALG_ECDAA << 21)  | (ALG_SM2 << 22)    |
	       (ALG_ECSCHNORR << 23))}},
    // TPMI_ECC_KEY_EXCHANGE_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_SCHEME,
     {TPM_ALG_NULL,
      RANGE(25, 29, UINT16),
      (UINT32)((ALG_ECDH << 0)|(ALG_SM2 << 2)|(ALG_ECMQV << 4))}},
    // TPMI_ST_COMMAND_TAG_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_BAD_TAG, 2,
     {TPM_ST_NO_SESSIONS, TPM_ST_SESSIONS}},
    // TPMI_ALG_MAC_SCHEME_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_SYMMETRIC,
     {TPM_ALG_NULL,
      RANGE(4, 63, UINT16),
      (UINT32)((ALG_SHA1 << 0)   | (ALG_SHA256 << 7) | (ALG_SHA384 << 8) |
	       (ALG_SHA512 << 9) | (ALG_SM3_256 << 14)),
      (UINT32)((ALG_SHA3_256 << 3) | (ALG_SHA3_384 << 4) | (ALG_SHA3_512 << 5) |
	       (ALG_CMAC << 27))}},
    // TPMI_ALG_CIPHER_MODE_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_MODE,
     {TPM_ALG_NULL,
      RANGE(64, 68, UINT16),
      (UINT32)((ALG_CTR << 0) | (ALG_OFB << 1) | (ALG_CBC << 2) | (ALG_CFB << 3) |
	       (ALG_ECB << 4))}},
    // TPMS_EMPTY_DATA
    {STRUCTURE_MTYPE, 1,
     {SET_ELEMENT_TYPE(SIMPLE_STYPE), UINT0_MARSHAL_REF, 0}},
    // TPMS_ALGORITHM_DESCRIPTION_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPM_ALG_ID_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DESCRIPTION, alg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMA_ALGORITHM_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DESCRIPTION, attributes))}},
    // TPMU_HA_DATA
    {9, IS_ARRAY_UNION, (UINT16)(offsetof(TPMU_HA_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_SHA1,     (UINT32)TPM_ALG_SHA256,   (UINT32)TPM_ALG_SHA384,
      (UINT32)TPM_ALG_SHA512,   (UINT32)TPM_ALG_SM3_256,  (UINT32)TPM_ALG_SHA3_256,
      (UINT32)TPM_ALG_SHA3_384, (UINT32)TPM_ALG_SHA3_512, (UINT32)TPM_ALG_NULL},
     {(UINT16)(SHA1_DIGEST_SIZE),     (UINT16)(SHA256_DIGEST_SIZE),
      (UINT16)(SHA384_DIGEST_SIZE),   (UINT16)(SHA512_DIGEST_SIZE),
      (UINT16)(SM3_256_DIGEST_SIZE),  (UINT16)(SHA3_256_DIGEST_SIZE),
      (UINT16)(SHA3_384_DIGEST_SIZE), (UINT16)(SHA3_512_DIGEST_SIZE),
      (UINT16)(0)}
    },
    // TPMT_HA_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_HA, hashAlg)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_HA_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_HA, digest))}},
    // TPM2B_DIGEST_DATA
    {TPM2B_MTYPE, Type00_MARSHAL_REF},
    // TPM2B_DATA_DATA
    {TPM2B_MTYPE, Type01_MARSHAL_REF},
    // TPM2B_EVENT_DATA
    {TPM2B_MTYPE, Type02_MARSHAL_REF},
    // TPM2B_MAX_BUFFER_DATA
    {TPM2B_MTYPE, Type03_MARSHAL_REF},
    // TPM2B_MAX_NV_BUFFER_DATA
    {TPM2B_MTYPE, Type04_MARSHAL_REF},
    // TPM2B_TIMEOUT_DATA
    {TPM2B_MTYPE, Type05_MARSHAL_REF},
    // TPM2B_IV_DATA
    {TPM2B_MTYPE, Type06_MARSHAL_REF},
    // NULL_UNION_DATA
    {0},
    // TPM2B_NAME_DATA
    {TPM2B_MTYPE, Type07_MARSHAL_REF},
    // TPMS_PCR_SELECT_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    Type08_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_PCR_SELECT, sizeofSelect)),
	    SET_ELEMENT_TYPE(ARRAY_STYPE)|SET_ELEMENT_NUMBER(0),
	    UINT8_ARRAY_MARSHAL_INDEX,
	    (UINT16)(offsetof(TPMS_PCR_SELECT, pcrSelect))}},
    // TPMS_PCR_SELECTION_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_PCR_SELECTION, hash)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    Type08_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_PCR_SELECTION, sizeofSelect)),
	    SET_ELEMENT_TYPE(ARRAY_STYPE)|SET_ELEMENT_NUMBER(1),
	    UINT8_ARRAY_MARSHAL_INDEX,
	    (UINT16)(offsetof(TPMS_PCR_SELECTION, pcrSelect))}},
    // TPMT_TK_CREATION_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    Type10_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_CREATION, tag)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_RH_HIERARCHY_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMT_TK_CREATION, hierarchy)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_CREATION, digest))}},
    // TPMT_TK_VERIFIED_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    Type11_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_VERIFIED, tag)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_RH_HIERARCHY_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMT_TK_VERIFIED, hierarchy)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_VERIFIED, digest))}},
    // TPMT_TK_AUTH_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    Type12_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_AUTH, tag)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_RH_HIERARCHY_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMT_TK_AUTH, hierarchy)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_AUTH, digest))}},
    // TPMT_TK_HASHCHECK_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    Type13_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_HASHCHECK, tag)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_RH_HIERARCHY_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMT_TK_HASHCHECK, hierarchy)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_TK_HASHCHECK, digest))}},
    // TPMS_ALG_PROPERTY_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPM_ALG_ID_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALG_PROPERTY, alg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMA_ALGORITHM_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALG_PROPERTY, algProperties))}},
    // TPMS_TAGGED_PROPERTY_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPM_PT_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TAGGED_PROPERTY, property)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TAGGED_PROPERTY, value))}},
    // TPMS_TAGGED_PCR_SELECT_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPM_PT_PCR_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TAGGED_PCR_SELECT, tag)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    Type08_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TAGGED_PCR_SELECT, sizeofSelect)),
	    SET_ELEMENT_TYPE(ARRAY_STYPE)|SET_ELEMENT_NUMBER(1),
	    UINT8_ARRAY_MARSHAL_INDEX,
	    (UINT16)(offsetof(TPMS_TAGGED_PCR_SELECT, pcrSelect))}},
    // TPMS_TAGGED_POLICY_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPM_HANDLE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TAGGED_POLICY, handle)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_HA_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TAGGED_POLICY, policyHash))}},
    // TPMS_ACT_DATA_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPM_HANDLE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ACT_DATA, handle)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ACT_DATA, timeout)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMA_ACT_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ACT_DATA, attributes))}},
    // TPML_CC_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_CC, commandCodes)),
     Type15_MARSHAL_REF,
     TPM_CC_ARRAY_MARSHAL_INDEX},
    // TPML_CCA_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_CCA, commandAttributes)),
     Type15_MARSHAL_REF,
     TPMA_CC_ARRAY_MARSHAL_INDEX},
    // TPML_ALG_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_ALG, algorithms)),
     Type17_MARSHAL_REF,
     TPM_ALG_ID_ARRAY_MARSHAL_INDEX},
    // TPML_HANDLE_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_HANDLE, handle)),
     Type18_MARSHAL_REF,
     TPM_HANDLE_ARRAY_MARSHAL_INDEX},
    // TPML_DIGEST_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_DIGEST, digests)),
     Type19_MARSHAL_REF,
     TPM2B_DIGEST_ARRAY_MARSHAL_INDEX},
    // TPML_DIGEST_VALUES_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_DIGEST_VALUES, digests)),
     Type20_MARSHAL_REF,
     TPMT_HA_ARRAY_MARSHAL_INDEX},
    // TPML_PCR_SELECTION_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_PCR_SELECTION, pcrSelections)),
     Type20_MARSHAL_REF,
     TPMS_PCR_SELECTION_ARRAY_MARSHAL_INDEX},
    // TPML_ALG_PROPERTY_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_ALG_PROPERTY, algProperties)),
     Type22_MARSHAL_REF,
     TPMS_ALG_PROPERTY_ARRAY_MARSHAL_INDEX},
    // TPML_TAGGED_TPM_PROPERTY_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_TAGGED_TPM_PROPERTY, tpmProperty)),
     Type23_MARSHAL_REF,
     TPMS_TAGGED_PROPERTY_ARRAY_MARSHAL_INDEX},
    // TPML_TAGGED_PCR_PROPERTY_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_TAGGED_PCR_PROPERTY, pcrProperty)),
     Type24_MARSHAL_REF,
     TPMS_TAGGED_PCR_SELECT_ARRAY_MARSHAL_INDEX},
    // TPML_ECC_CURVE_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_ECC_CURVE, eccCurves)),
     Type25_MARSHAL_REF,
     TPM_ECC_CURVE_ARRAY_MARSHAL_INDEX},
    // TPML_TAGGED_POLICY_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_TAGGED_POLICY, policies)),
     Type26_MARSHAL_REF,
     TPMS_TAGGED_POLICY_ARRAY_MARSHAL_INDEX},
    // TPML_ACT_DATA_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_ACT_DATA, actData)),
     Type27_MARSHAL_REF,
     TPMS_ACT_DATA_ARRAY_MARSHAL_INDEX},
    // TPMU_CAPABILITIES_DATA
    {11, 0, (UINT16)(offsetof(TPMU_CAPABILITIES_mst, marshalingTypes)),
     {(UINT32)TPM_CAP_ALGS,           (UINT32)TPM_CAP_HANDLES,
      (UINT32)TPM_CAP_COMMANDS,       (UINT32)TPM_CAP_PP_COMMANDS,
      (UINT32)TPM_CAP_AUDIT_COMMANDS, (UINT32)TPM_CAP_PCRS,
      (UINT32)TPM_CAP_TPM_PROPERTIES, (UINT32)TPM_CAP_PCR_PROPERTIES,
      (UINT32)TPM_CAP_ECC_CURVES,     (UINT32)TPM_CAP_AUTH_POLICIES,
      (UINT32)TPM_CAP_ACT},
     {(UINT16)(TPML_ALG_PROPERTY_MARSHAL_REF),
      (UINT16)(TPML_HANDLE_MARSHAL_REF),
      (UINT16)(TPML_CCA_MARSHAL_REF),
      (UINT16)(TPML_CC_MARSHAL_REF),
      (UINT16)(TPML_CC_MARSHAL_REF),
      (UINT16)(TPML_PCR_SELECTION_MARSHAL_REF),
      (UINT16)(TPML_TAGGED_TPM_PROPERTY_MARSHAL_REF),
      (UINT16)(TPML_TAGGED_PCR_PROPERTY_MARSHAL_REF),
      (UINT16)(TPML_ECC_CURVE_MARSHAL_REF),
      (UINT16)(TPML_TAGGED_POLICY_MARSHAL_REF),
      (UINT16)(TPML_ACT_DATA_MARSHAL_REF)}
    },
    // TPMS_CAPABILITY_DATA_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPM_CAP_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CAPABILITY_DATA, capability)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_CAPABILITIES_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CAPABILITY_DATA, data))}},
    // TPMS_CLOCK_INFO_DATA
    {STRUCTURE_MTYPE, 4, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(EIGHT_BYTES),
	    UINT64_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CLOCK_INFO, clock)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CLOCK_INFO, resetCount)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CLOCK_INFO, restartCount)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    TPMI_YES_NO_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CLOCK_INFO, safe))}},
    // TPMS_TIME_INFO_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(EIGHT_BYTES),
	    UINT64_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TIME_INFO, time)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMS_CLOCK_INFO_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TIME_INFO, clockInfo))}},
    // TPMS_TIME_ATTEST_INFO_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMS_TIME_INFO_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TIME_ATTEST_INFO, time)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(EIGHT_BYTES),
	    UINT64_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_TIME_ATTEST_INFO, firmwareVersion))}},
    // TPMS_CERTIFY_INFO_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CERTIFY_INFO, name)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CERTIFY_INFO, qualifiedName))}},
    // TPMS_QUOTE_INFO_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPML_PCR_SELECTION_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_QUOTE_INFO, pcrSelect)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_QUOTE_INFO, pcrDigest))}},
    // TPMS_COMMAND_AUDIT_INFO_DATA
    {STRUCTURE_MTYPE, 4, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(EIGHT_BYTES),
	    UINT64_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_COMMAND_AUDIT_INFO, auditCounter)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPM_ALG_ID_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_COMMAND_AUDIT_INFO, digestAlg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_COMMAND_AUDIT_INFO, auditDigest)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_COMMAND_AUDIT_INFO, commandDigest))}},
    // TPMS_SESSION_AUDIT_INFO_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    TPMI_YES_NO_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SESSION_AUDIT_INFO, exclusiveSession)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SESSION_AUDIT_INFO, sessionDigest))}},
    // TPMS_CREATION_INFO_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_INFO, objectName)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_INFO, creationHash))}},
    // TPMS_NV_CERTIFY_INFO_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_CERTIFY_INFO, indexName)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    UINT16_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_CERTIFY_INFO, offset)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_MAX_NV_BUFFER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_CERTIFY_INFO, nvContents))}},
    // TPMS_NV_DIGEST_CERTIFY_INFO_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_DIGEST_CERTIFY_INFO, indexName)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_DIGEST_CERTIFY_INFO, nvDigest))}},
    // TPMI_ST_ATTEST_DATA
    {VALUES_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE, 1, 1,
     {RANGE(TPM_ST_ATTEST_NV, TPM_ST_ATTEST_CREATION, UINT16),
      TPM_ST_ATTEST_NV_DIGEST}},
    // TPMU_ATTEST_DATA
    {8, 0, (UINT16)(offsetof(TPMU_ATTEST_mst, marshalingTypes)),
     {(UINT32)TPM_ST_ATTEST_CERTIFY,       (UINT32)TPM_ST_ATTEST_CREATION,
      (UINT32)TPM_ST_ATTEST_QUOTE,         (UINT32)TPM_ST_ATTEST_COMMAND_AUDIT,
      (UINT32)TPM_ST_ATTEST_SESSION_AUDIT, (UINT32)TPM_ST_ATTEST_TIME,
      (UINT32)TPM_ST_ATTEST_NV,            (UINT32)TPM_ST_ATTEST_NV_DIGEST},
     {(UINT16)(TPMS_CERTIFY_INFO_MARSHAL_REF),
      (UINT16)(TPMS_CREATION_INFO_MARSHAL_REF),
      (UINT16)(TPMS_QUOTE_INFO_MARSHAL_REF),
      (UINT16)(TPMS_COMMAND_AUDIT_INFO_MARSHAL_REF),
      (UINT16)(TPMS_SESSION_AUDIT_INFO_MARSHAL_REF),
      (UINT16)(TPMS_TIME_ATTEST_INFO_MARSHAL_REF),
      (UINT16)(TPMS_NV_CERTIFY_INFO_MARSHAL_REF),
      (UINT16)(TPMS_NV_DIGEST_CERTIFY_INFO_MARSHAL_REF)}
    },
    // TPMS_ATTEST_DATA
    {STRUCTURE_MTYPE, 7, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPM_CONSTANTS32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ATTEST, magic)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ST_ATTEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ATTEST, type)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ATTEST, qualifiedSigner)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DATA_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ATTEST, extraData)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMS_CLOCK_INFO_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ATTEST, clockInfo)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(EIGHT_BYTES),
	    UINT64_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ATTEST, firmwareVersion)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(1),
	    TPMU_ATTEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ATTEST, attested))}},
    // TPM2B_ATTEST_DATA
    {TPM2B_MTYPE, Type28_MARSHAL_REF},
    // TPMS_AUTH_COMMAND_DATA
    {STRUCTURE_MTYPE, 4, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_SH_AUTH_SESSION_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_AUTH_COMMAND, sessionHandle)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NONCE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AUTH_COMMAND, nonce)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    TPMA_SESSION_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AUTH_COMMAND, sessionAttributes)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_AUTH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AUTH_COMMAND, hmac))}},
    // TPMS_AUTH_RESPONSE_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NONCE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AUTH_RESPONSE, nonce)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    TPMA_SESSION_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AUTH_RESPONSE, sessionAttributes)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_AUTH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AUTH_RESPONSE, hmac))}},
    // TPMI_TDES_KEY_BITS_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE, 1,
     {128*TDES_128}},
    // TPMI_AES_KEY_BITS_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE, 3,
     {192*AES_192, 128*AES_128, 256*AES_256}},
    // TPMI_SM4_KEY_BITS_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE, 1,
     {128*SM4_128}},
    // TPMI_CAMELLIA_KEY_BITS_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE, 3,
     {192*CAMELLIA_192, 128*CAMELLIA_128, 256*CAMELLIA_256}},
    // TPMU_SYM_KEY_BITS_DATA
    {6, 0, (UINT16)(offsetof(TPMU_SYM_KEY_BITS_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_TDES,     (UINT32)TPM_ALG_AES,      (UINT32)TPM_ALG_SM4,
      (UINT32)TPM_ALG_CAMELLIA, (UINT32)TPM_ALG_XOR,      (UINT32)TPM_ALG_NULL},
     {(UINT16)(TPMI_TDES_KEY_BITS_MARSHAL_REF),
      (UINT16)(TPMI_AES_KEY_BITS_MARSHAL_REF),
      (UINT16)(TPMI_SM4_KEY_BITS_MARSHAL_REF),
      (UINT16)(TPMI_CAMELLIA_KEY_BITS_MARSHAL_REF),
      (UINT16)(TPMI_ALG_HASH_MARSHAL_REF),
      (UINT16)(UINT0_MARSHAL_REF)}
    },
    // TPMU_SYM_MODE_DATA
    {6, 0, (UINT16)(offsetof(TPMU_SYM_MODE_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_TDES,     (UINT32)TPM_ALG_AES,      (UINT32)TPM_ALG_SM4,
      (UINT32)TPM_ALG_CAMELLIA, (UINT32)TPM_ALG_XOR,      (UINT32)TPM_ALG_NULL},
     {(UINT16)(TPMI_ALG_SYM_MODE_MARSHAL_REF|NULL_FLAG),
      (UINT16)(TPMI_ALG_SYM_MODE_MARSHAL_REF|NULL_FLAG),
      (UINT16)(TPMI_ALG_SYM_MODE_MARSHAL_REF|NULL_FLAG),
      (UINT16)(TPMI_ALG_SYM_MODE_MARSHAL_REF|NULL_FLAG),
      (UINT16)(UINT0_MARSHAL_REF),
      (UINT16)(UINT0_MARSHAL_REF)}
    },
    // TPMT_SYM_DEF_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_SYM_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SYM_DEF, algorithm)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SYM_KEY_BITS_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SYM_DEF, keyBits)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SYM_MODE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SYM_DEF, mode))}},
    // TPMT_SYM_DEF_OBJECT_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_SYM_OBJECT_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SYM_DEF_OBJECT, algorithm)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SYM_KEY_BITS_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SYM_DEF_OBJECT, keyBits)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SYM_MODE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SYM_DEF_OBJECT, mode))}},
    // TPM2B_SYM_KEY_DATA
    {TPM2B_MTYPE, Type29_MARSHAL_REF},
    // TPMS_SYMCIPHER_PARMS_DATA
    {STRUCTURE_MTYPE, 1, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_SYM_DEF_OBJECT_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SYMCIPHER_PARMS, sym))}},
    // TPM2B_LABEL_DATA
    {TPM2B_MTYPE, Type30_MARSHAL_REF},
    // TPMS_DERIVE_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_LABEL_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_DERIVE, label)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_LABEL_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_DERIVE, context))}},
    // TPM2B_DERIVE_DATA
    {TPM2B_MTYPE, Type31_MARSHAL_REF},
    // TPM2B_SENSITIVE_DATA_DATA
    {TPM2B_MTYPE, Type32_MARSHAL_REF},
    // TPMS_SENSITIVE_CREATE_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_AUTH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SENSITIVE_CREATE, userAuth)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_SENSITIVE_DATA_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SENSITIVE_CREATE, data))}},
    // TPM2B_SENSITIVE_CREATE_DATA
    {TPM2BS_MTYPE,
     (UINT8)(offsetof(TPM2B_SENSITIVE_CREATE, sensitive))|SIZE_EQUAL,
     UINT16_MARSHAL_REF,
     TPMS_SENSITIVE_CREATE_MARSHAL_REF},
    // TPMS_SCHEME_HASH_DATA
    {STRUCTURE_MTYPE, 1, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SCHEME_HASH, hashAlg))}},
    // TPMS_SCHEME_ECDAA_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SCHEME_ECDAA, hashAlg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    UINT16_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SCHEME_ECDAA, count))}},
    // TPMI_ALG_KEYEDHASH_SCHEME_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_VALUE,
     {TPM_ALG_NULL,
      RANGE(5, 10, UINT16),
      (UINT32)((ALG_HMAC << 0) | (ALG_XOR << 5))}},
    // TPMS_SCHEME_XOR_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SCHEME_XOR, hashAlg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_KDF_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_SCHEME_XOR, kdf))}},
    // TPMU_SCHEME_KEYEDHASH_DATA
    {3, 0, (UINT16)(offsetof(TPMU_SCHEME_KEYEDHASH_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_HMAC, (UINT32)TPM_ALG_XOR, (UINT32)TPM_ALG_NULL},
     {(UINT16)(TPMS_SCHEME_HMAC_MARSHAL_REF),
      (UINT16)(TPMS_SCHEME_XOR_MARSHAL_REF),
      (UINT16)(UINT0_MARSHAL_REF)}
    },
    // TPMT_KEYEDHASH_SCHEME_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_KEYEDHASH_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_KEYEDHASH_SCHEME, scheme)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SCHEME_KEYEDHASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_KEYEDHASH_SCHEME, details))}},
    // TPMU_SIG_SCHEME_DATA
    {8, 0, (UINT16)(offsetof(TPMU_SIG_SCHEME_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_ECDAA,     (UINT32)TPM_ALG_RSASSA,
      (UINT32)TPM_ALG_RSAPSS,    (UINT32)TPM_ALG_ECDSA,
      (UINT32)TPM_ALG_SM2,       (UINT32)TPM_ALG_ECSCHNORR,
      (UINT32)TPM_ALG_HMAC,      (UINT32)TPM_ALG_NULL},
     {(UINT16)(TPMS_SIG_SCHEME_ECDAA_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_RSASSA_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_RSAPSS_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_ECDSA_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_SM2_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_ECSCHNORR_MARSHAL_REF),
      (UINT16)(TPMS_SCHEME_HMAC_MARSHAL_REF),
      (UINT16)(UINT0_MARSHAL_REF)}
    },
    // TPMT_SIG_SCHEME_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_SIG_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SIG_SCHEME, scheme)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SIG_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SIG_SCHEME, details))}},
    // TPMU_KDF_SCHEME_DATA
    {5, 0, (UINT16)(offsetof(TPMU_KDF_SCHEME_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_MGF1,           (UINT32)TPM_ALG_KDF1_SP800_56A,
      (UINT32)TPM_ALG_KDF2,           (UINT32)TPM_ALG_KDF1_SP800_108,
      (UINT32)TPM_ALG_NULL},
     {(UINT16)(TPMS_SCHEME_MGF1_MARSHAL_REF),
      (UINT16)(TPMS_SCHEME_KDF1_SP800_56A_MARSHAL_REF),
      (UINT16)(TPMS_SCHEME_KDF2_MARSHAL_REF),
      (UINT16)(TPMS_SCHEME_KDF1_SP800_108_MARSHAL_REF),
      (UINT16)(UINT0_MARSHAL_REF)}
    },
    // TPMT_KDF_SCHEME_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_KDF_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_KDF_SCHEME, scheme)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_KDF_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_KDF_SCHEME, details))}},
    // TPMI_ALG_ASYM_SCHEME_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_VALUE,
     {TPM_ALG_NULL,
      RANGE(20, 29, UINT16),
      (UINT32)((ALG_RSASSA << 0)    | (ALG_RSAES << 1)     | (ALG_RSAPSS << 2)    |
	       (ALG_OAEP << 3)      | (ALG_ECDSA << 4)     | (ALG_ECDH << 5)      |
	       (ALG_ECDAA << 6)     | (ALG_SM2 << 7)       | (ALG_ECSCHNORR << 8) |
	       (ALG_ECMQV << 9))}},
    // TPMU_ASYM_SCHEME_DATA
    {11, 0, (UINT16)(offsetof(TPMU_ASYM_SCHEME_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_ECDH,      (UINT32)TPM_ALG_ECMQV,
      (UINT32)TPM_ALG_ECDAA,     (UINT32)TPM_ALG_RSASSA,
      (UINT32)TPM_ALG_RSAPSS,    (UINT32)TPM_ALG_ECDSA,
      (UINT32)TPM_ALG_SM2,       (UINT32)TPM_ALG_ECSCHNORR,
      (UINT32)TPM_ALG_RSAES,     (UINT32)TPM_ALG_OAEP,
      (UINT32)TPM_ALG_NULL},
     {(UINT16)(TPMS_KEY_SCHEME_ECDH_MARSHAL_REF),
      (UINT16)(TPMS_KEY_SCHEME_ECMQV_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_ECDAA_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_RSASSA_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_RSAPSS_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_ECDSA_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_SM2_MARSHAL_REF),
      (UINT16)(TPMS_SIG_SCHEME_ECSCHNORR_MARSHAL_REF),
      (UINT16)(TPMS_ENC_SCHEME_RSAES_MARSHAL_REF),
      (UINT16)(TPMS_ENC_SCHEME_OAEP_MARSHAL_REF),
      (UINT16)(UINT0_MARSHAL_REF)}
    },
    // TPMI_ALG_RSA_SCHEME_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_VALUE,
     {TPM_ALG_NULL,
      RANGE(20, 23, UINT16),
      ((ALG_RSASSA << 0)|(ALG_RSAES << 1)|(ALG_RSAPSS << 2)|(ALG_OAEP << 3))}},
    // TPMT_RSA_SCHEME_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_RSA_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_RSA_SCHEME, scheme)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_ASYM_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_RSA_SCHEME, details))}},
    // TPMI_ALG_RSA_DECRYPT_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_VALUE,
     {TPM_ALG_NULL,
      RANGE(21, 23, UINT16),
      (UINT32)((ALG_RSAES << 0) | (ALG_OAEP << 2))}},
    // TPMT_RSA_DECRYPT_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_RSA_DECRYPT_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_RSA_DECRYPT, scheme)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_ASYM_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_RSA_DECRYPT, details))}},
    // TPM2B_PUBLIC_KEY_RSA_DATA
    {TPM2B_MTYPE, Type33_MARSHAL_REF},
    // TPMI_RSA_KEY_BITS_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_VALUE, 3,
     {3072*RSA_3072, 1024*RSA_1024, 2048*RSA_2048}},
    // TPM2B_PRIVATE_KEY_RSA_DATA
    {TPM2B_MTYPE, Type34_MARSHAL_REF},
    // TPM2B_ECC_PARAMETER_DATA
    {TPM2B_MTYPE, Type35_MARSHAL_REF},
    // TPMS_ECC_POINT_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ECC_POINT, x)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ECC_POINT, y))}},
    // TPM2B_ECC_POINT_DATA
    {TPM2BS_MTYPE,
     (UINT8)(offsetof(TPM2B_ECC_POINT, point))|SIZE_EQUAL,
     UINT16_MARSHAL_REF,
     TPMS_ECC_POINT_MARSHAL_REF},
    // TPMI_ALG_ECC_SCHEME_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|TAKES_NULL|HAS_BITS, (UINT8)TPM_RC_SCHEME,
     {TPM_ALG_NULL,
      RANGE(24, 29, UINT16),
      (UINT32)((ALG_ECDSA << 0)     | (ALG_ECDH << 1)      | (ALG_ECDAA << 2)     |
	       (ALG_SM2 << 3)       | (ALG_ECSCHNORR << 4) | (ALG_ECMQV << 5))}},
    // TPMI_ECC_CURVE_DATA
    {MIN_MAX_MTYPE, TWO_BYTES | HAS_BITS, (UINT8)TPM_RC_CURVE,
     {RANGE(1, 32, UINT16),
      (UINT32)((ECC_NIST_P192 << 0) | (ECC_NIST_P224 << 1) | (ECC_NIST_P256 << 2) |
	       (ECC_NIST_P384 << 3) | (ECC_NIST_P521 << 4) | (ECC_BN_P256 << 15)  |
	       (ECC_BN_P638 << 16)  | (ECC_SM2_P256 << 31))}},
    // TPMT_ECC_SCHEME_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_ECC_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_ECC_SCHEME, scheme)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_ASYM_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_ECC_SCHEME, details))}},
    // TPMS_ALGORITHM_DETAIL_ECC_DATA
    {STRUCTURE_MTYPE, 11, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPM_ECC_CURVE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, curveID)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    UINT16_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, keySize)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_KDF_SCHEME_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, kdf)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_ECC_SCHEME_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, sign)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, p)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, a)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, b)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, gX)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, gY)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, n)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ALGORITHM_DETAIL_ECC, h))}},
    // TPMS_SIGNATURE_RSA_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SIGNATURE_RSA, hash)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_PUBLIC_KEY_RSA_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SIGNATURE_RSA, sig))}},
    // TPMS_SIGNATURE_ECC_DATA
    {STRUCTURE_MTYPE, 3, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SIGNATURE_ECC, hash)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SIGNATURE_ECC, signatureR)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_ECC_PARAMETER_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_SIGNATURE_ECC, signatureS))}},
    // TPMU_SIGNATURE_DATA
    {8, 0, (UINT16)(offsetof(TPMU_SIGNATURE_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_ECDAA,     (UINT32)TPM_ALG_RSASSA,
      (UINT32)TPM_ALG_RSAPSS,    (UINT32)TPM_ALG_ECDSA,
      (UINT32)TPM_ALG_SM2,       (UINT32)TPM_ALG_ECSCHNORR,
      (UINT32)TPM_ALG_HMAC,      (UINT32)TPM_ALG_NULL},
     {(UINT16)(TPMS_SIGNATURE_ECDAA_MARSHAL_REF),
      (UINT16)(TPMS_SIGNATURE_RSASSA_MARSHAL_REF),
      (UINT16)(TPMS_SIGNATURE_RSAPSS_MARSHAL_REF),
      (UINT16)(TPMS_SIGNATURE_ECDSA_MARSHAL_REF),
      (UINT16)(TPMS_SIGNATURE_SM2_MARSHAL_REF),
      (UINT16)(TPMS_SIGNATURE_ECSCHNORR_MARSHAL_REF),
      (UINT16)(TPMT_HA_MARSHAL_REF),
      (UINT16)(UINT0_MARSHAL_REF)}
    },
    // TPMT_SIGNATURE_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_SIG_SCHEME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SIGNATURE, sigAlg)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SIGNATURE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SIGNATURE, signature))}},
    // TPMU_ENCRYPTED_SECRET_DATA
    {4, IS_ARRAY_UNION, (UINT16)(offsetof(TPMU_ENCRYPTED_SECRET_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_ECC,       (UINT32)TPM_ALG_RSA,
      (UINT32)TPM_ALG_SYMCIPHER, (UINT32)TPM_ALG_KEYEDHASH},
     {(UINT16)(sizeof(TPMS_ECC_POINT)), (UINT16)(MAX_RSA_KEY_BYTES),
      (UINT16)(sizeof(TPM2B_DIGEST)),   (UINT16)(sizeof(TPM2B_DIGEST))}
    },
    // TPM2B_ENCRYPTED_SECRET_DATA
    {TPM2B_MTYPE, Type36_MARSHAL_REF},
    // TPMI_ALG_PUBLIC_DATA
    {MIN_MAX_MTYPE, TWO_BYTES|HAS_BITS, (UINT8)TPM_RC_TYPE,
     {RANGE(1, 37, UINT16),
      (UINT32)((ALG_RSA << 0)|(ALG_KEYEDHASH << 7)),
      (UINT32)((ALG_ECC << 2)|(ALG_SYMCIPHER << 4))}},
    // TPMU_PUBLIC_ID_DATA
    {4, 0, (UINT16)(offsetof(TPMU_PUBLIC_ID_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_KEYEDHASH, (UINT32)TPM_ALG_SYMCIPHER,
      (UINT32)TPM_ALG_RSA,       (UINT32)TPM_ALG_ECC},
     {(UINT16)(TPM2B_DIGEST_MARSHAL_REF),
      (UINT16)(TPM2B_DIGEST_MARSHAL_REF),
      (UINT16)(TPM2B_PUBLIC_KEY_RSA_MARSHAL_REF),
      (UINT16)(TPMS_ECC_POINT_MARSHAL_REF)}
    },
    // TPMS_KEYEDHASH_PARMS_DATA
    {STRUCTURE_MTYPE, 1, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_KEYEDHASH_SCHEME_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_KEYEDHASH_PARMS, scheme))}},
    // TPMS_RSA_PARMS_DATA
    {STRUCTURE_MTYPE, 4, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_SYM_DEF_OBJECT_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_RSA_PARMS, symmetric)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_RSA_SCHEME_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_RSA_PARMS, scheme)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_RSA_KEY_BITS_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_RSA_PARMS, keyBits)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_RSA_PARMS, exponent))}},
    // TPMS_ECC_PARMS_DATA
    {STRUCTURE_MTYPE, 4, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_SYM_DEF_OBJECT_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_ECC_PARMS, symmetric)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_ECC_SCHEME_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_ECC_PARMS, scheme)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ECC_CURVE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_ECC_PARMS, curveID)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPMT_KDF_SCHEME_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_ECC_PARMS, kdf))}},
    // TPMU_PUBLIC_PARMS_DATA
    {4, 0, (UINT16)(offsetof(TPMU_PUBLIC_PARMS_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_KEYEDHASH, (UINT32)TPM_ALG_SYMCIPHER,
      (UINT32)TPM_ALG_RSA,       (UINT32)TPM_ALG_ECC},
     {(UINT16)(TPMS_KEYEDHASH_PARMS_MARSHAL_REF),
      (UINT16)(TPMS_SYMCIPHER_PARMS_MARSHAL_REF),
      (UINT16)(TPMS_RSA_PARMS_MARSHAL_REF),
      (UINT16)(TPMS_ECC_PARMS_MARSHAL_REF)}
    },
    // TPMT_PUBLIC_PARMS_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_PUBLIC_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC_PARMS, type)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_PUBLIC_PARMS_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC_PARMS, parameters))}},
    // TPMT_PUBLIC_DATA
    {STRUCTURE_MTYPE, 6, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_PUBLIC_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC, type)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES)|ELEMENT_PROPAGATE,
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC, nameAlg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMA_OBJECT_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC, objectAttributes)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC, authPolicy)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_PUBLIC_PARMS_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC, parameters)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_PUBLIC_ID_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_PUBLIC, unique))}},
    // TPM2B_PUBLIC_DATA
    {TPM2BS_MTYPE,
     (UINT8)(offsetof(TPM2B_PUBLIC, publicArea))|SIZE_EQUAL|ELEMENT_PROPAGATE,
     UINT16_MARSHAL_REF,
     TPMT_PUBLIC_MARSHAL_REF},
    // TPM2B_TEMPLATE_DATA
    {TPM2B_MTYPE, Type37_MARSHAL_REF},
    // TPM2B_PRIVATE_VENDOR_SPECIFIC_DATA
    {TPM2B_MTYPE, Type38_MARSHAL_REF},
    // TPMU_SENSITIVE_COMPOSITE_DATA
    {4, 0, (UINT16)(offsetof(TPMU_SENSITIVE_COMPOSITE_mst, marshalingTypes)),
     {(UINT32)TPM_ALG_RSA,       (UINT32)TPM_ALG_ECC,
      (UINT32)TPM_ALG_KEYEDHASH, (UINT32)TPM_ALG_SYMCIPHER},
     {(UINT16)(TPM2B_PRIVATE_KEY_RSA_MARSHAL_REF),
      (UINT16)(TPM2B_ECC_PARAMETER_MARSHAL_REF),
      (UINT16)(TPM2B_SENSITIVE_DATA_MARSHAL_REF),
      (UINT16)(TPM2B_SYM_KEY_MARSHAL_REF)}
    },
    // TPMT_SENSITIVE_DATA
    {STRUCTURE_MTYPE, 4, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_PUBLIC_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SENSITIVE, sensitiveType)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_AUTH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SENSITIVE, authValue)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SENSITIVE, seedValue)),
	    SET_ELEMENT_TYPE(UNION_STYPE)|SET_ELEMENT_NUMBER(0),
	    TPMU_SENSITIVE_COMPOSITE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMT_SENSITIVE, sensitive))}},
    // TPM2B_SENSITIVE_DATA
    {TPM2BS_MTYPE,
     (UINT8)(offsetof(TPM2B_SENSITIVE, sensitiveArea)),
     UINT16_MARSHAL_REF,
     TPMT_SENSITIVE_MARSHAL_REF},
    // TPM2B_PRIVATE_DATA
    {TPM2B_MTYPE, Type39_MARSHAL_REF},
    // TPM2B_ID_OBJECT_DATA
    {TPM2B_MTYPE, Type40_MARSHAL_REF},
    // TPMS_NV_PIN_COUNTER_PARAMETERS_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_PIN_COUNTER_PARAMETERS, pinCount)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_PIN_COUNTER_PARAMETERS, pinLimit))}},
    // TPMA_NV_DATA
    {ATTRIBUTES_MTYPE, FOUR_BYTES, 0x01F00300},
    // TPMS_NV_PUBLIC_DATA
    {STRUCTURE_MTYPE, 5, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_RH_NV_INDEX_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_PUBLIC, nvIndex)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPMI_ALG_HASH_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_PUBLIC, nameAlg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMA_NV_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_PUBLIC, attributes)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_PUBLIC, authPolicy)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    Type41_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_NV_PUBLIC, dataSize))}},
    // TPM2B_NV_PUBLIC_DATA
    {TPM2BS_MTYPE,
     (UINT8)(offsetof(TPM2B_NV_PUBLIC, nvPublic))|SIZE_EQUAL,
     UINT16_MARSHAL_REF,
     TPMS_NV_PUBLIC_MARSHAL_REF},
    // TPM2B_CONTEXT_SENSITIVE_DATA
    {TPM2B_MTYPE, Type42_MARSHAL_REF},
    // TPMS_CONTEXT_DATA_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CONTEXT_DATA, integrity)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_CONTEXT_SENSITIVE_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CONTEXT_DATA, encrypted))}},
    // TPM2B_CONTEXT_DATA_DATA
    {TPM2B_MTYPE, Type43_MARSHAL_REF},
    // TPMS_CONTEXT_DATA
    {STRUCTURE_MTYPE, 4, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(EIGHT_BYTES),
	    UINT64_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CONTEXT, sequence)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_DH_SAVED_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CONTEXT, savedHandle)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPMI_RH_HIERARCHY_MARSHAL_REF|NULL_FLAG,
	    (UINT16)(offsetof(TPMS_CONTEXT, hierarchy)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_CONTEXT_DATA_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CONTEXT, contextBlob))}},
    // TPMS_CREATION_DATA_DATA
    {STRUCTURE_MTYPE, 7, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPML_PCR_SELECTION_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_DATA, pcrSelect)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DIGEST_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_DATA, pcrDigest)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(ONE_BYTES),
	    TPMA_LOCALITY_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_DATA, locality)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(TWO_BYTES),
	    TPM_ALG_ID_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_DATA, parentNameAlg)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_DATA, parentName)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_NAME_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_DATA, parentQualifiedName)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE),
	    TPM2B_DATA_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_CREATION_DATA, outsideInfo))}},
    // TPM2B_CREATION_DATA_DATA
    {TPM2BS_MTYPE,
     (UINT8)(offsetof(TPM2B_CREATION_DATA, creationData))|SIZE_EQUAL,
     UINT16_MARSHAL_REF,
     TPMS_CREATION_DATA_MARSHAL_REF},
    // TPM_AT_DATA
    {TABLE_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_VALUE, 4,
     {TPM_AT_ANY, TPM_AT_ERROR, TPM_AT_PV1, TPM_AT_VEND}},
    // TPMS_AC_OUTPUT_DATA
    {STRUCTURE_MTYPE, 2, {
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    TPM_AT_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AC_OUTPUT, tag)),
	    SET_ELEMENT_TYPE(SIMPLE_STYPE)|SET_ELEMENT_SIZE(FOUR_BYTES),
	    UINT32_MARSHAL_REF,
	    (UINT16)(offsetof(TPMS_AC_OUTPUT, data))}},
    // TPML_AC_CAPABILITIES_DATA
    {LIST_MTYPE,
     (UINT8)(offsetof(TPML_AC_CAPABILITIES, acCapabilities)),
     Type44_MARSHAL_REF,
     TPMS_AC_OUTPUT_ARRAY_MARSHAL_INDEX},
    // Type00_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMU_HA), UINT16)}},
    // Type01_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMT_HA), UINT16)}},
    // Type02_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, 1024, UINT16)}},
    // Type03_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_DIGEST_BUFFER, UINT16)}},
    // Type04_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_NV_BUFFER_SIZE, UINT16)}},
    // Type05_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(UINT64), UINT16)}},
    // Type06_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_SYM_BLOCK_SIZE, UINT16)}},
    // Type07_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMU_NAME), UINT16)}},
    // Type08_DATA
    {MIN_MAX_MTYPE, ONE_BYTES, (UINT8)TPM_RC_VALUE,
     {RANGE(PCR_SELECT_MIN, PCR_SELECT_MAX, UINT8)}},
    // Type10_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_TAG, 1,
     {TPM_ST_CREATION}},
    // Type11_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_TAG, 1,
     {TPM_ST_VERIFIED}},
    // Type12_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_TAG, 2,
     {TPM_ST_AUTH_SECRET, TPM_ST_AUTH_SIGNED}},
    // Type13_DATA
    {TABLE_MTYPE, TWO_BYTES, (UINT8)TPM_RC_TAG, 1,
     {TPM_ST_HASHCHECK}},
    // Type15_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_CAP_CC, UINT32)}},
    // Type17_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_ALG_LIST_SIZE, UINT32)}},
    // Type18_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_CAP_HANDLES, UINT32)}},
    // Type19_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(2, 8, UINT32)}},
    // Type20_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, HASH_COUNT, UINT32)}},
    // Type22_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_CAP_ALGS, UINT32)}},
    // Type23_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_TPM_PROPERTIES, UINT32)}},
    // Type24_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_PCR_PROPERTIES, UINT32)}},
    // Type25_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_ECC_CURVES, UINT32)}},
    // Type26_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_TAGGED_POLICIES, UINT32)}},
    // Type27_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_ACT_DATA, UINT32)}},
    // Type28_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMS_ATTEST), UINT16)}},
    // Type29_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_SYM_KEY_BYTES, UINT16)}},
    // Type30_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, LABEL_MAX_BUFFER, UINT16)}},
    // Type31_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMS_DERIVE), UINT16)}},
    // Type32_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMU_SENSITIVE_CREATE), UINT16)}},
    // Type33_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_RSA_KEY_BYTES, UINT16)}},
    // Type34_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, RSA_PRIVATE_SIZE, UINT16)}},
    // Type35_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_ECC_KEY_BYTES, UINT16)}},
    // Type36_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMU_ENCRYPTED_SECRET), UINT16)}},
    // Type37_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMT_PUBLIC), UINT16)}},
    // Type38_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, PRIVATE_VENDOR_SPECIFIC_BYTES, UINT16)}},
    // Type39_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(_PRIVATE), UINT16)}},
    // Type40_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMS_ID_OBJECT), UINT16)}},
    // Type41_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_NV_INDEX_SIZE, UINT16)}},
    // Type42_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_CONTEXT_SIZE, UINT16)}},
    // Type43_DATA
    {MIN_MAX_MTYPE, TWO_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, sizeof(TPMS_CONTEXT_DATA), UINT16)}},
    // Type44_DATA
    {MIN_MAX_MTYPE, FOUR_BYTES, (UINT8)TPM_RC_SIZE,
     {RANGE(0, MAX_AC_CAPABILITIES, UINT32)}}
};
#endif // TABLE_DRIVEN_MARSHAL
