/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// StorageProfileLister helps list StorageProfiles.
// All objects returned here must be treated as read-only.
type StorageProfileLister interface {
	// List lists all StorageProfiles in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.StorageProfile, err error)
	// Get retrieves the StorageProfile from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.StorageProfile, error)
	StorageProfileListerExpansion
}

// storageProfileLister implements the StorageProfileLister interface.
type storageProfileLister struct {
	listers.ResourceIndexer[*v1beta1.StorageProfile]
}

// NewStorageProfileLister returns a new StorageProfileLister.
func NewStorageProfileLister(indexer cache.Indexer) StorageProfileLister {
	return &storageProfileLister{listers.New[*v1beta1.StorageProfile](indexer, v1beta1.Resource("storageprofile"))}
}
