# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RoaRequest
from aliyunsdkelasticsearch.endpoint import endpoint_data

class ListTagResourcesRequest(RoaRequest):

	def __init__(self):
		RoaRequest.__init__(self, 'elasticsearch', '2017-06-13', 'ListTagResources','elasticsearch')
		self.set_uri_pattern('/openapi/tags')
		self.set_method('GET')

		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())

	def get_Size(self): # integer
		return self.get_query_params().get('Size')

	def set_Size(self, Size):  # integer
		self.add_query_param('Size', Size)
	def get_NextToken(self): # string
		return self.get_query_params().get('NextToken')

	def set_NextToken(self, NextToken):  # string
		self.add_query_param('NextToken', NextToken)
	def get_Page(self): # integer
		return self.get_query_params().get('Page')

	def set_Page(self, Page):  # integer
		self.add_query_param('Page', Page)
	def get_ResourceType(self): # string
		return self.get_query_params().get('ResourceType')

	def set_ResourceType(self, ResourceType):  # string
		self.add_query_param('ResourceType', ResourceType)
	def get_ResourceIds(self): # string
		return self.get_query_params().get('ResourceIds')

	def set_ResourceIds(self, ResourceIds):  # string
		self.add_query_param('ResourceIds', ResourceIds)
	def get_Tags(self): # string
		return self.get_query_params().get('Tags')

	def set_Tags(self, Tags):  # string
		self.add_query_param('Tags', Tags)
