/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletUnitClient;
import com.meterware.servletunit.ServletUnitHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;

class ServletUnitWebResponse
extends WebResponse {
    private ServletUnitHttpResponse _response;

    ServletUnitWebResponse(ServletUnitClient client, String target, URL url, HttpServletResponse response, boolean throwExceptionOnError) throws IOException {
        super(client, target, url);
        this._response = (ServletUnitHttpResponse)response;
        if (this.getResponseCode() < 400 || !throwExceptionOnError) {
            this.defineRawInputStream(new ByteArrayInputStream(this._response.getContents()));
            if (this.getContentType().startsWith("text")) {
                this.loadResponseText();
            }
        }
    }

    ServletUnitWebResponse(ServletUnitClient client, String target, URL url, HttpServletResponse response) throws IOException {
        this(client, target, url, response, true);
    }

    public int getResponseCode() {
        return this._response.getStatus();
    }

    public String getResponseMessage() {
        return this._response.getMessage();
    }

    public String[] getHeaderFieldNames() {
        return this._response.getHeaderFieldNames();
    }

    public String getHeaderField(String fieldName) {
        return this._response.getHeaderField(fieldName);
    }

    public String[] getHeaderFields(String fieldName) {
        return this._response.getHeaderFields(fieldName);
    }

    public String toString() {
        return "[ _response = " + this._response + "]";
    }
}

