/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsse;

import com.ibm.jsse.JSSEContext;
import com.ibm.jsse.JSSESecureKey;
import com.ibm.jsse.JSSESessionContext;
import com.ibm.sslite.c;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

final class JSSESession
implements SSLSession {
    private Hashtable table = new Hashtable();
    private JSSESessionContext sessionContext;
    long accessTime;
    long creationTime;
    byte[] id;
    c ssliteSession;
    JSSESession next;

    public String toString() {
        return "SSLSession[" + this.getPeerHost() + ", " + this.getCipherSuite() + "]";
    }

    public void removeValue(String string) {
        JSSESecureKey jSSESecureKey = new JSSESecureKey(string);
        Object v2 = this.table.remove(jSSESecureKey);
        if (v2 instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)v2).valueUnbound(sSLSessionBindingEvent);
        }
    }

    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        JSSESecureKey jSSESecureKey = new JSSESecureKey(string);
        Object object2 = this.table.put(jSSESecureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    public void invalidate() {
        this.sessionContext.remove(this);
    }

    public String[] getValueNames() {
        Vector<Object> vector = new Vector<Object>();
        Object object = JSSESecureKey.getCurrentSecurityContext();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            JSSESecureKey jSSESecureKey = (JSSESecureKey)enumeration.nextElement();
            if (!object.equals(jSSESecureKey.getSecurityContext())) continue;
            vector.addElement(jSSESecureKey.getAppKey());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getValue(String string) {
        JSSESecureKey jSSESecureKey = new JSSESecureKey(string);
        return this.table.get(jSSESecureKey);
    }

    public SSLSessionContext getSessionContext() {
        return this.sessionContext;
    }

    public String getPeerHost() {
        return this.ssliteSession.d().getHostName();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        X509Certificate[] x509CertificateArray = JSSEContext.getChain(this.ssliteSession.e());
        if (x509CertificateArray == null) {
            throw new SSLPeerUnverifiedException("no certificate");
        }
        return x509CertificateArray;
    }

    public long getLastAccessedTime() {
        return this.accessTime;
    }

    public byte[] getId() {
        return this.ssliteSession.g();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getCipherSuite() {
        return this.ssliteSession.b();
    }

    JSSESession(c c2, JSSESessionContext jSSESessionContext) {
        this.sessionContext = jSSESessionContext;
        this.creationTime = this.accessTime = System.currentTimeMillis();
        this.ssliteSession = c2;
    }
}

