/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.latest;

import fr.jayasoft.ivy.ArtifactInfo;
import fr.jayasoft.ivy.latest.AbstractLatestStrategy;
import java.util.Comparator;
import java.util.Date;

public class LatestLexicographicStrategy
extends AbstractLatestStrategy {
    private static Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            String rev1 = (String)o1;
            String rev2 = (String)o2;
            if (rev1.startsWith("latest")) {
                return 1;
            }
            if (rev1.endsWith("+") && rev2.startsWith(rev1.substring(0, rev1.length() - 1))) {
                return 1;
            }
            if (rev2.startsWith("latest")) {
                return -1;
            }
            if (rev2.endsWith("+") && rev1.startsWith(rev2.substring(0, rev2.length() - 1))) {
                return -1;
            }
            return rev1.compareTo(rev2);
        }
    };

    public LatestLexicographicStrategy() {
        this.setName("latest-lexico");
    }

    public ArtifactInfo findLatest(ArtifactInfo[] artifacts, Date date) {
        if (artifacts == null) {
            return null;
        }
        ArtifactInfo found = null;
        for (int i = 0; i < artifacts.length; ++i) {
            long lastModified;
            ArtifactInfo art = artifacts[i];
            if (found != null && COMPARATOR.compare(art.getRevision(), found.getRevision()) <= 0 || date != null && (lastModified = art.getLastModified()) > date.getTime()) continue;
            found = art;
        }
        return found;
    }
}

