/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.session;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Lorg/islandoftex/arara/core/session/ClassLoading;", "", "()V", "loadClass", "Lkotlin/Pair;", "Lorg/islandoftex/arara/core/session/ClassLoading$ClassLoadingStatus;", "Ljava/lang/Class;", "file", "Ljava/io/File;", "name", "", "loadObject", "ClassLoadingStatus", "core"})
public final class ClassLoading {
    @NotNull
    public static final ClassLoading INSTANCE;

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoadingStatus, Class<?>> loadClass(@NotNull File file2, @NotNull String name) {
        ClassLoadingStatus classLoadingStatus;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(name, "name");
        Class value = Object.class;
        if (!file2.exists()) {
            classLoadingStatus = ClassLoadingStatus.FILE_NOT_FOUND;
        } else {
            ClassLoadingStatus classLoadingStatus2;
            try {
                URLClassLoader classloader = new URLClassLoader(new URL[]{file2.toURI().toURL()}, ClassLoading.class.getClassLoader());
                Class<?> clazz = Class.forName(name, true, classloader);
                Intrinsics.checkNotNullExpressionValue(clazz, "Class.forName(name, true, classloader)");
                value = clazz;
                classLoadingStatus2 = ClassLoadingStatus.SUCCESS;
            }
            catch (MalformedURLException _) {
                classLoadingStatus2 = ClassLoadingStatus.MALFORMED_URL;
            }
            catch (ClassNotFoundException _) {
                classLoadingStatus2 = ClassLoadingStatus.CLASS_NOT_FOUND;
            }
            classLoadingStatus = classLoadingStatus2;
        }
        ClassLoadingStatus status = classLoadingStatus;
        return TuplesKt.to(status, value);
    }

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoadingStatus, Object> loadObject(@NotNull File file2, @NotNull String name) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair<ClassLoadingStatus, Class<?>> pair2 = ClassLoading.loadClass(file2, name);
        ClassLoadingStatus status = pair2.getFirst();
        Object value = new Object();
        if (status == ClassLoadingStatus.SUCCESS) {
            try {
                Object obj = pair2.getSecond().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNullExpressionValue(obj, "pair.second.getDeclaredConstructor().newInstance()");
                value = obj;
            }
            catch (IllegalAccessException _) {
                status = ClassLoadingStatus.ILLEGAL_ACCESS;
            }
            catch (InstantiationException _) {
                status = ClassLoadingStatus.INSTANTIATION_EXCEPTION;
            }
            catch (InvocationTargetException _) {
                status = ClassLoadingStatus.INSTANTIATION_EXCEPTION;
            }
        }
        return TuplesKt.to(status, value);
    }

    private ClassLoading() {
    }

    static {
        ClassLoading classLoading;
        INSTANCE = classLoading = new ClassLoading();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/islandoftex/arara/core/session/ClassLoading$ClassLoadingStatus;", "", "(Ljava/lang/String;I)V", "SUCCESS", "FILE_NOT_FOUND", "MALFORMED_URL", "CLASS_NOT_FOUND", "ILLEGAL_ACCESS", "INSTANTIATION_EXCEPTION", "core"})
    public static final class ClassLoadingStatus
    extends Enum<ClassLoadingStatus> {
        public static final /* enum */ ClassLoadingStatus SUCCESS;
        public static final /* enum */ ClassLoadingStatus FILE_NOT_FOUND;
        public static final /* enum */ ClassLoadingStatus MALFORMED_URL;
        public static final /* enum */ ClassLoadingStatus CLASS_NOT_FOUND;
        public static final /* enum */ ClassLoadingStatus ILLEGAL_ACCESS;
        public static final /* enum */ ClassLoadingStatus INSTANTIATION_EXCEPTION;
        private static final /* synthetic */ ClassLoadingStatus[] $VALUES;

        static {
            ClassLoadingStatus[] classLoadingStatusArray = new ClassLoadingStatus[6];
            ClassLoadingStatus[] classLoadingStatusArray2 = classLoadingStatusArray;
            classLoadingStatusArray[0] = SUCCESS = new ClassLoadingStatus();
            classLoadingStatusArray[1] = FILE_NOT_FOUND = new ClassLoadingStatus();
            classLoadingStatusArray[2] = MALFORMED_URL = new ClassLoadingStatus();
            classLoadingStatusArray[3] = CLASS_NOT_FOUND = new ClassLoadingStatus();
            classLoadingStatusArray[4] = ILLEGAL_ACCESS = new ClassLoadingStatus();
            classLoadingStatusArray[5] = INSTANTIATION_EXCEPTION = new ClassLoadingStatus();
            $VALUES = classLoadingStatusArray;
        }

        public static ClassLoadingStatus[] values() {
            return (ClassLoadingStatus[])$VALUES.clone();
        }

        public static ClassLoadingStatus valueOf(String string) {
            return Enum.valueOf(ClassLoadingStatus.class, string);
        }
    }
}

