// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.
// Code generated by mockery v1.0.0
package contracts

import (
	"github.com/aws/amazon-ssm-agent/agent/contracts"
	mock "github.com/stretchr/testify/mock"
)

// MockICoreModule is an autogenerated mock type for the ICoreModule type
type ICoreModule struct {
	mock.Mock
}

// ModuleExecute provides a mock function with given fields: _a0
func (_m *ICoreModule) ModuleExecute() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ModuleName provides a mock function with given fields:
func (_m *ICoreModule) ModuleName() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// ModuleRequestStop provides a mock function with given fields: stopType
func (_m *ICoreModule) ModuleRequestStop(stopType contracts.StopType) error {
	ret := _m.Called(stopType)

	var r0 error
	if rf, ok := ret.Get(0).(func(contracts.StopType) error); ok {
		r0 = rf(stopType)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
