# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgentRegistrationKeyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the agent registration key name - primary or secondary.
    """

    PRIMARY = "primary"
    SECONDARY = "secondary"

class AutomationAccountState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets status of account.
    """

    OK = "Ok"
    UNAVAILABLE = "Unavailable"
    SUSPENDED = "Suspended"

class AutomationKeyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Automation key name.
    """

    PRIMARY = "Primary"
    SECONDARY = "Secondary"

class AutomationKeyPermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Automation key permissions.
    """

    READ = "Read"
    FULL = "Full"

class ContentSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the content source type.
    """

    EMBEDDED_CONTENT = "embeddedContent"
    URI = "uri"

class CountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    STATUS = "status"
    NODECONFIGURATION = "nodeconfiguration"

class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DscConfigurationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the state of the configuration.
    """

    NEW = "New"
    EDIT = "Edit"
    PUBLISHED = "Published"

class EncryptionKeySourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Encryption Key Source
    """

    MICROSOFT_AUTOMATION = "Microsoft.Automation"
    MICROSOFT_KEYVAULT = "Microsoft.Keyvault"

class GraphRunbookType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Runbook Type
    """

    GRAPH_POWER_SHELL = "GraphPowerShell"
    GRAPH_POWER_SHELL_WORKFLOW = "GraphPowerShellWorkflow"

class GroupTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the HybridWorkerGroup.
    """

    USER = "User"
    SYSTEM = "System"

class HttpStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    CONTINUE_ENUM = "Continue"
    SWITCHING_PROTOCOLS = "SwitchingProtocols"
    OK = "OK"
    CREATED = "Created"
    ACCEPTED = "Accepted"
    NON_AUTHORITATIVE_INFORMATION = "NonAuthoritativeInformation"
    NO_CONTENT = "NoContent"
    RESET_CONTENT = "ResetContent"
    PARTIAL_CONTENT = "PartialContent"
    MULTIPLE_CHOICES = "MultipleChoices"
    AMBIGUOUS = "Ambiguous"
    MOVED_PERMANENTLY = "MovedPermanently"
    MOVED = "Moved"
    FOUND = "Found"
    REDIRECT = "Redirect"
    SEE_OTHER = "SeeOther"
    REDIRECT_METHOD = "RedirectMethod"
    NOT_MODIFIED = "NotModified"
    USE_PROXY = "UseProxy"
    UNUSED = "Unused"
    TEMPORARY_REDIRECT = "TemporaryRedirect"
    REDIRECT_KEEP_VERB = "RedirectKeepVerb"
    BAD_REQUEST = "BadRequest"
    UNAUTHORIZED = "Unauthorized"
    PAYMENT_REQUIRED = "PaymentRequired"
    FORBIDDEN = "Forbidden"
    NOT_FOUND = "NotFound"
    METHOD_NOT_ALLOWED = "MethodNotAllowed"
    NOT_ACCEPTABLE = "NotAcceptable"
    PROXY_AUTHENTICATION_REQUIRED = "ProxyAuthenticationRequired"
    REQUEST_TIMEOUT = "RequestTimeout"
    CONFLICT = "Conflict"
    GONE = "Gone"
    LENGTH_REQUIRED = "LengthRequired"
    PRECONDITION_FAILED = "PreconditionFailed"
    REQUEST_ENTITY_TOO_LARGE = "RequestEntityTooLarge"
    REQUEST_URI_TOO_LONG = "RequestUriTooLong"
    UNSUPPORTED_MEDIA_TYPE = "UnsupportedMediaType"
    REQUESTED_RANGE_NOT_SATISFIABLE = "RequestedRangeNotSatisfiable"
    EXPECTATION_FAILED = "ExpectationFailed"
    UPGRADE_REQUIRED = "UpgradeRequired"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    NOT_IMPLEMENTED = "NotImplemented"
    BAD_GATEWAY = "BadGateway"
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    GATEWAY_TIMEOUT = "GatewayTimeout"
    HTTP_VERSION_NOT_SUPPORTED = "HttpVersionNotSupported"

class JobProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the resource.
    """

    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    SUSPENDED = "Suspended"
    PROCESSING = "Processing"

class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the status of the job.
    """

    NEW = "New"
    ACTIVATING = "Activating"
    RUNNING = "Running"
    COMPLETED = "Completed"
    FAILED = "Failed"
    STOPPED = "Stopped"
    BLOCKED = "Blocked"
    SUSPENDED = "Suspended"
    DISCONNECTED = "Disconnected"
    SUSPENDING = "Suspending"
    STOPPING = "Stopping"
    RESUMING = "Resuming"
    REMOVING = "Removing"

class JobStreamType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the stream type.
    """

    PROGRESS = "Progress"
    OUTPUT = "Output"
    WARNING = "Warning"
    ERROR = "Error"
    DEBUG = "Debug"
    VERBOSE = "Verbose"
    ANY = "Any"

class LinuxUpdateClasses(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update classifications included in the software update configuration.
    """

    UNCLASSIFIED = "Unclassified"
    CRITICAL = "Critical"
    SECURITY = "Security"
    OTHER = "Other"

class ModuleProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the provisioning state of the module.
    """

    CREATED = "Created"
    CREATING = "Creating"
    STARTING_IMPORT_MODULE_RUNBOOK = "StartingImportModuleRunbook"
    RUNNING_IMPORT_MODULE_RUNBOOK = "RunningImportModuleRunbook"
    CONTENT_RETRIEVED = "ContentRetrieved"
    CONTENT_DOWNLOADED = "ContentDownloaded"
    CONTENT_VALIDATED = "ContentValidated"
    CONNECTION_TYPE_IMPORTED = "ConnectionTypeImported"
    CONTENT_STORED = "ContentStored"
    MODULE_DATA_STORED = "ModuleDataStored"
    ACTIVITIES_STORED = "ActivitiesStored"
    MODULE_IMPORT_RUNBOOK_COMPLETE = "ModuleImportRunbookComplete"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    UPDATING = "Updating"

class OperatingSystemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target operating system for the software update configuration.
    """

    WINDOWS = "Windows"
    LINUX = "Linux"

class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the job.
    """

    COMPLETED = "Completed"
    FAILED = "Failed"
    RUNNING = "Running"

class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"

class RunbookState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the state of the runbook.
    """

    NEW = "New"
    EDIT = "Edit"
    PUBLISHED = "Published"

class RunbookTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the type of the runbook.
    """

    SCRIPT = "Script"
    GRAPH = "Graph"
    POWER_SHELL_WORKFLOW = "PowerShellWorkflow"
    POWER_SHELL = "PowerShell"
    GRAPH_POWER_SHELL_WORKFLOW = "GraphPowerShellWorkflow"
    GRAPH_POWER_SHELL = "GraphPowerShell"
    PYTHON2 = "Python2"
    PYTHON3 = "Python3"

class ScheduleDay(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Day of the occurrence. Must be one of monday, tuesday, wednesday, thursday, friday, saturday,
    sunday.
    """

    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"

class ScheduleFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the frequency of the schedule.
    """

    ONE_TIME = "OneTime"
    DAY = "Day"
    HOUR = "Hour"
    WEEK = "Week"
    MONTH = "Month"
    #: The minimum allowed interval for Minute schedules is 15 minutes.
    MINUTE = "Minute"

class SkuNameEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the SKU name of the account.
    """

    FREE = "Free"
    BASIC = "Basic"

class SourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The source type. Must be one of VsoGit, VsoTfvc, GitHub.
    """

    VSO_GIT = "VsoGit"
    VSO_TFVC = "VsoTfvc"
    GIT_HUB = "GitHub"

class StreamType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the sync job stream.
    """

    ERROR = "Error"
    OUTPUT = "Output"

class SyncType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sync type.
    """

    PARTIAL_SYNC = "PartialSync"
    FULL_SYNC = "FullSync"

class TagOperators(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Filter VMs by Any or All specified tags.
    """

    ALL = "All"
    ANY = "Any"

class TokenType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The token type. Must be either PersonalAccessToken or Oauth.
    """

    PERSONAL_ACCESS_TOKEN = "PersonalAccessToken"
    OAUTH = "Oauth"

class WindowsUpdateClasses(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update classification included in the software update configuration. A comma separated string
    with required values
    """

    UNCLASSIFIED = "Unclassified"
    CRITICAL = "Critical"
    SECURITY = "Security"
    UPDATE_ROLLUP = "UpdateRollup"
    FEATURE_PACK = "FeaturePack"
    SERVICE_PACK = "ServicePack"
    DEFINITION = "Definition"
    TOOLS = "Tools"
    UPDATES = "Updates"

class WorkerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the HybridWorker.
    """

    HYBRID_V1 = "HybridV1"
    HYBRID_V2 = "HybridV2"
