/*
 *  sbl - Braille-display support for linux
 *  Author: Marco Skambraks <marco@skammel.de>
 * sbl based on brltty
 * special thanks to the Brltty-Team
 * Nicolas Pitre <nico@cam.org>
 * Stphane Doyon <s.doyon@videotron.ca>
 * Nikhil Nair <nn201@cus.cam.ac.uk>
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#include "../brl.h"
struct brlinfo fhpdevs[] = {
  {"el40s", "Braillex EL-40s", 40, 0, 0, 0, B57600},
  {"el66s", "Braillex EL-66s", 66, 0, 0, 0, B57600},
  {"el80s", "Braillex EL-80s", 80, 0, 0, 0, B57600},
  {"el2ds", "Braillex EL-2ds", 80, 20, 0, 20, B57600},
  {"trio", "Braillex Trio", 40, 0, 0, 0, B115200},
  {"el20c", "Braillex EL-20c", 20, 0, 0, 0, B57600},
  {"el40c", "Braillex EL-40c", 40, 0, 0, 0, B57600},
  {"el60c", "Braillex EL-60c", 60, 0, 0, 0, B57600},
  {"el80c", "Braillex EL-80c", 80, 0, 0, 0, B57600}
};

#define C_SERIES_BEGIN 5
#define C_SERIES_END 8

static int devnr = 0;

#define BRLCOLS	fhpdevs[devnr].cols
#define BRLROWS	1

#define FULLNAME	fhpdevs[devnr].fullname

#define BAUDRATE fhpdevs[devnr].baud

/* codes used in protocoll */
#define cSTX 02
#define cETX 03
#define cIdSend 'C'
#define cIdReceive 'K'
#define cIdInit 'A'
#define PRESSED 1

/* number of status cells */
#define PMSC fhpdevs[devnr].st_cells

/* offset within data structure */
#define offsetHorizontal fhpdevs[devnr].offhor
#define offsetVertical   fhpdevs[devnr].offvert
/* additional offset - use internal table */
#define offsetTable      512
