#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include "libbrld.h"

static int brld_connected = 0;

static int conn_select (int read);

static int event_mode = 0;

static int brld_cmd (char *cmd, char *result);

static int sockID = -1;

static fd_set read_set, write_set;

static struct timeval conn_timeout;

brld_interface brld = {
  brld_open, brld_reg, brld_close, brld_getkey, brld_write, brld_reset,
  brld_getname, brld_getalias, brld_getxy, brld_cursor, brld_attrtbl,
  brld_texttbl, brld_seteventmode, brld_unseteventmode
};

int brld_open (char *host, int port)
{
  struct hostent *hp, *gethostbyname ();

  struct sockaddr_in sad;       /* inet socket */

  struct sockaddr_un sFile;     /* unix socket */

  memset ((char *) &sad, 0, sizeof (sad));
  memset ((char *) &sFile, 0, sizeof (sFile));

  /* if port 0 - use unix socket */
  if (!port)
   {
     sFile.sun_family = AF_UNIX;
     strcpy (sFile.sun_path, BRLD_SOCK_NAME);
   }
  else
   {
     sad.sin_family = AF_INET;                  /*--TCP family-----*/
     if (strlen (host))
       hp = gethostbyname (host);
     else
       hp = gethostbyname ("localhost");
     memcpy (&sad.sin_addr, hp->h_addr, hp->h_length);
     sad.sin_port = htons (port);
   }                            /* else - inet socket */

  sockID = -1;
  if ((sockID = socket (port ? AF_INET : AF_UNIX, SOCK_STREAM, 0)) < 0)
    return BRLD_NO_CONN;

  if (connect
      (sockID, port ? (struct sockaddr *) &sad : (struct sockaddr *) &sFile,
       port ? sizeof (sad) : sizeof (sFile)) < 0)
   {
     if (sockID >= 0)
       close (sockID);
     sockID = -1;
     return BRLD_NO_CONN;
   }

  brld_connected = 1;
  FD_ZERO (&read_set);
  FD_ZERO (&write_set);
  FD_SET (sockID, &read_set);
  FD_SET (sockID, &write_set);

  return sockID;
}

int brld_reg (int type, char *authkey)
{
  char cmdstr[MAX_MSG_LEN] = "";

  char str[MAX_MSG_LEN] = "";

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;

  memset (str, 0, sizeof (str));
  sprintf (cmdstr, "reg %02d %s", type, authkey);
  if ((ret = brld_cmd (cmdstr, str)))
    return ret;
  if (strcmp (str, "OK\r\n"))
    return BRLD_CMD_ERR;

  return 0;

}

void brld_close ()
{

  if (brld_connected)
   {
     send (sockID, "quit", 5, 0);
     usleep (1000);
   }
  if (sockID >= 0)
   {
     FD_CLR (sockID, &read_set);
     FD_CLR (sockID, &write_set);
     FD_ZERO (&read_set);
     FD_ZERO (&write_set);
     close (sockID);
   }
  sockID = -1;
  brld_connected = 0;

}

static int brld_cmd (char *cmd, char *result)
{
  int cnt = 0;

  char tmpstr[MAX_MSG_LEN];

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;

  memset (tmpstr, 0, sizeof (tmpstr));
  if ((ret = conn_select (0)))
    return ret;
  if (send (sockID, cmd, strlen (cmd) + 1, MSG_DONTWAIT) < 0)
   {
     brld_connected = 0;
     brld_close ();
     return BRLD_NO_CONN;
   }

/* give the server time to response */
  if ((ret = conn_select (1)))
    return ret;
  cnt = recv (sockID, tmpstr, 50, MSG_DONTWAIT);
  if (cnt > 0)
   {
     tmpstr[cnt] = 0;
     strcpy (result, tmpstr);

     if (!strncmp (result, "error", 5))
       return BRLD_CMD_ERR;
     else
       return 0;
   }

  brld_connected = 0;
  brld_close ();
  return BRLD_NO_CONN;

}

int brld_reset ()
{
  char str[MAX_MSG_LEN] = "";

  int ret = 0;

  if ((ret = brld_cmd ("reset", str)))
    return ret;
  if (strcmp (str, "OK\r\n"))
    return BRLD_CMD_ERR;

  return 0;
}

int brld_getkey (int *pressed)
{

  char str[MAX_MSG_LEN] = "";

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;
  if (!event_mode)
   {
     if ((ret = brld_cmd ("getkey", str)))
       return ret;

     if (strlen (str) < 8)
       return BRLD_CMD_ERR;
   }
  else
   {
     if ((ret = conn_select (1)))
       return ret;
     if (recv (sockID, str, 10, MSG_DONTWAIT) < 1)
      {
        brld_connected = 0;
        brld_close ();
        return BRLD_NO_CONN;
      }
   }

  *pressed = atoi (str + 4);
  str[3] = 0;
  return atoi (str);
}

int brld_getxy (int *x, int *y)
{

  char str[MAX_MSG_LEN];

  int ret = 0;

  *x = 0;
  *y = 0;

  if ((ret = brld_cmd ("getxy", str)))
    return ret;

  if (strlen (str) < 7)
    return BRLD_CMD_ERR;

  *y = atoi (str + 3);
  str[3] = 0;
  *x = atoi (str);
  return 0;
}

int brld_getname (char *name)
{

  char str[MAX_MSG_LEN] = "";

  int ret = 0;

  if ((ret = brld_cmd ("getname", str)))
    return ret;

  if (strlen (str) > 1)
   {
     str[strlen (str) - 2] = 0;
     strcpy (name, str);
     return 0;
   }

  return BRLD_CMD_ERR;

}

int brld_getalias (char *alias)
{

  char str[MAX_MSG_LEN] = "";

  int ret = 0;

  if ((ret = brld_cmd ("getalias", str)))
    return ret;

  if (strlen (str) > 1)
   {
     str[strlen (str) - 2] = 0;
     strcpy (alias, str);
     return 0;
   }

  return BRLD_CMD_ERR;

}

int brld_write (int csrpos, char *text, char *attr)
{
  char cmd[MAX_MSG_LEN] = "";

  unsigned int attrlen = 0;

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;
  if (attr)
   {
     attrlen = strlen (attr);
     if (attrlen != strlen (text))
       attrlen = 0;
   }

  sprintf (cmd, "write %03d %03zd %02d %s%s", csrpos, strlen (text),
           attrlen ? 1 : 0, text, attrlen ? attr : "");

  if ((ret = conn_select (0)))
    return ret;

  if (send (sockID, cmd, strlen (cmd) + 1, MSG_DONTWAIT) < 0)
   {
     brld_connected = 0;
     brld_close ();
     return BRLD_NO_CONN;
   }
  return 0;
}

int brld_cursor (int form)
{
  char str[MAX_MSG_LEN];

  char cmd_str[MAX_MSG_LEN];

  int ret = 0;

  memset (str, 0, sizeof (str));
  memset (cmd_str, 0, sizeof (cmd_str));
  if (!brld_connected)
    return BRLD_NO_CONN;
  sprintf (cmd_str, "cursor %02d", form);

  if ((ret = brld_cmd (cmd_str, str)))
    return ret;
  if (strcmp (str, "OK\r\n"))
    return BRLD_CMD_ERR;

  return 0;
}

int brld_attrtbl ()
{
  char str[MAX_MSG_LEN];

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;
  memset (str, 0, sizeof (str));

  if ((ret = brld_cmd ("attrtbl", str)))
    return ret;

  if (strcmp (str, "OK\r\n"))
    return BRLD_CMD_ERR;

  return 0;
}

int brld_texttbl ()
{
  char str[MAX_MSG_LEN];

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;
  memset (str, 0, sizeof (str));

  if ((ret = brld_cmd ("texttbl", str)))
    return ret;

  if (strcmp (str, "OK\r\n"))
    return BRLD_CMD_ERR;

  return 0;
}

int brld_seteventmode ()
{
  char str[20] = "";

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;

  memset (str, 0, sizeof (str));
  if ((ret = brld_cmd ("seteventmode", str)))
    return ret;

  event_mode = 1;
  return 0;
}

int brld_unseteventmode ()
{

  char str[10] = "";

  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;

  if ((ret = brld_cmd ("unseteventmode", str)))
    return ret;

  event_mode = 0;
  return 0;
}

static int conn_select (int read)
{
  int ret = 0;

  if (!brld_connected)
    return BRLD_NO_CONN;
  conn_timeout.tv_sec = BRLD_CLIENT_TIMEOUT;
  conn_timeout.tv_usec = 0;

  if (read)
    ret = select (sockID + 1, &read_set, NULL, NULL, &conn_timeout);
  else
    ret = select (sockID + 1, NULL, &write_set, NULL, &conn_timeout);

  switch (ret)
   {
   case 0:
     return BRLD_TIMEOUT;
   case -1:
     return BRLD_NO_CONN;
   default:
     return 0;
   }

}
