/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// DataVolumeLister helps list DataVolumes.
// All objects returned here must be treated as read-only.
type DataVolumeLister interface {
	// List lists all DataVolumes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.DataVolume, err error)
	// DataVolumes returns an object that can list and get DataVolumes.
	DataVolumes(namespace string) DataVolumeNamespaceLister
	DataVolumeListerExpansion
}

// dataVolumeLister implements the DataVolumeLister interface.
type dataVolumeLister struct {
	listers.ResourceIndexer[*v1beta1.DataVolume]
}

// NewDataVolumeLister returns a new DataVolumeLister.
func NewDataVolumeLister(indexer cache.Indexer) DataVolumeLister {
	return &dataVolumeLister{listers.New[*v1beta1.DataVolume](indexer, v1beta1.Resource("datavolume"))}
}

// DataVolumes returns an object that can list and get DataVolumes.
func (s *dataVolumeLister) DataVolumes(namespace string) DataVolumeNamespaceLister {
	return dataVolumeNamespaceLister{listers.NewNamespaced[*v1beta1.DataVolume](s.ResourceIndexer, namespace)}
}

// DataVolumeNamespaceLister helps list and get DataVolumes.
// All objects returned here must be treated as read-only.
type DataVolumeNamespaceLister interface {
	// List lists all DataVolumes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.DataVolume, err error)
	// Get retrieves the DataVolume from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.DataVolume, error)
	DataVolumeNamespaceListerExpansion
}

// dataVolumeNamespaceLister implements the DataVolumeNamespaceLister
// interface.
type dataVolumeNamespaceLister struct {
	listers.ResourceIndexer[*v1beta1.DataVolume]
}
