/* doclet.c generated by valac, the Vala compiler
 * generated from doclet.vala, do not modify */

/* doclet.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valadoc.h>
#include <glib/gstdio.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GTKDOC_TYPE_DIRECTOR (gtkdoc_director_get_type ())
#define GTKDOC_DIRECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_DIRECTOR, GtkdocDirector))
#define GTKDOC_DIRECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_DIRECTOR, GtkdocDirectorClass))
#define GTKDOC_IS_DIRECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_DIRECTOR))
#define GTKDOC_IS_DIRECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_DIRECTOR))
#define GTKDOC_DIRECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_DIRECTOR, GtkdocDirectorClass))

typedef struct _GtkdocDirector GtkdocDirector;
typedef struct _GtkdocDirectorClass GtkdocDirectorClass;
typedef struct _GtkdocDirectorPrivate GtkdocDirectorPrivate;

#define GTKDOC_TYPE_GENERATOR (gtkdoc_generator_get_type ())
#define GTKDOC_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GENERATOR, GtkdocGenerator))
#define GTKDOC_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GENERATOR, GtkdocGeneratorClass))
#define GTKDOC_IS_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GENERATOR))
#define GTKDOC_IS_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GENERATOR))
#define GTKDOC_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GENERATOR, GtkdocGeneratorClass))

typedef struct _GtkdocGenerator GtkdocGenerator;
typedef struct _GtkdocGeneratorClass GtkdocGeneratorClass;
enum  {
	GTKDOC_DIRECTOR_0_PROPERTY,
	GTKDOC_DIRECTOR_NUM_PROPERTIES
};
static GParamSpec* gtkdoc_director_properties[GTKDOC_DIRECTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GtkdocGeneratorPrivate GtkdocGeneratorPrivate;

#define GTKDOC_DBUS_TYPE_INTERFACE (gtkdoc_dbus_interface_get_type ())
#define GTKDOC_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface))
#define GTKDOC_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))
#define GTKDOC_DBUS_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))

typedef struct _GtkdocDBusInterface GtkdocDBusInterface;
typedef struct _GtkdocDBusInterfaceClass GtkdocDBusInterfaceClass;
typedef struct _GtkdocDBusInterfacePrivate GtkdocDBusInterfacePrivate;

#define GTKDOC_DBUS_TYPE_MEMBER (gtkdoc_dbus_member_get_type ())
#define GTKDOC_DBUS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember))
#define GTKDOC_DBUS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))
#define GTKDOC_DBUS_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))

typedef struct _GtkdocDBusMember GtkdocDBusMember;
typedef struct _GtkdocDBusMemberClass GtkdocDBusMemberClass;
#define _gtkdoc_dbus_interface_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_interface_unref (var), NULL)))

struct _GtkdocDirector {
	GObject parent_instance;
	GtkdocDirectorPrivate * priv;
};

struct _GtkdocDirectorClass {
	GObjectClass parent_class;
};

struct _GtkdocDirectorPrivate {
	ValadocErrorReporter* reporter;
	ValadocSettings* settings;
	ValadocApiTree* tree;
	GtkdocGenerator* generator;
	gchar** vala_headers;
	gint vala_headers_length1;
	gint _vala_headers_size_;
	gchar** c_headers;
	gint c_headers_length1;
	gint _c_headers_size_;
};

struct _GtkdocGenerator {
	ValadocApiVisitor parent_instance;
	GtkdocGeneratorPrivate * priv;
	ValaList* dbus_interfaces;
};

struct _GtkdocGeneratorClass {
	ValadocApiVisitorClass parent_class;
};

struct _GtkdocDBusInterface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GtkdocDBusInterfacePrivate * priv;
	gchar* package_name;
	gchar* name;
	gchar* purpose;
	gchar* description;
	ValaList* methods;
	ValaList* signals;
};

struct _GtkdocDBusInterfaceClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusInterface *self);
};


extern gboolean gtkdoc_config_nohtml;
gboolean gtkdoc_config_nohtml = FALSE;
extern gchar** gtkdoc_config_library_filenames;
gchar** gtkdoc_config_library_filenames = NULL;
extern gchar** gtkdoc_config_ignore_headers;
gchar** gtkdoc_config_ignore_headers = NULL;
extern gchar** gtkdoc_config_source_files;
gchar** gtkdoc_config_source_files = NULL;
extern gchar* gtkdoc_config_deprecated_guards;
gchar* gtkdoc_config_deprecated_guards = NULL;
extern gchar* gtkdoc_config_ignore_decorators;
gchar* gtkdoc_config_ignore_decorators = NULL;
static gpointer gtkdoc_director_parent_class = NULL;
static ValadocDocletIface * gtkdoc_director_valadoc_doclet_parent_iface = NULL;

gboolean gtkdoc_config_parse (gchar** rargs, int rargs_length1, ValadocErrorReporter* reporter);
static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value);
GType gtkdoc_director_get_type (void) G_GNUC_CONST;
GType gtkdoc_generator_get_type (void) G_GNUC_CONST;
#define GTKDOC_DIRECTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKDOC_TYPE_DIRECTOR, GtkdocDirectorPrivate))
static gchar** gtkdoc_director_combine_string_arrays (gchar** a, int a_length1, gchar** b, int b_length1, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value);
static void gtkdoc_director_real_process (ValadocDoclet* base, ValadocSettings* settings, ValadocApiTree* tree, ValadocErrorReporter* reporter);
static gboolean gtkdoc_director_prepare_files (GtkdocDirector* self, gchar** files, int files_length1, const gchar* comments_dir);
static gboolean gtkdoc_director_scan (GtkdocDirector* self, const gchar* output_dir, gchar** headers, int headers_length1);
GtkdocGenerator* gtkdoc_generator_new (void);
GtkdocGenerator* gtkdoc_generator_construct (GType object_type);
gboolean gtkdoc_generator_execute (GtkdocGenerator* self, ValadocSettings* settings, ValadocApiTree* tree, ValadocErrorReporter* reporter);
static gboolean gtkdoc_director_scangobj (GtkdocDirector* self);
static gboolean gtkdoc_director_mkdb (GtkdocDirector* self);
static gboolean gtkdoc_director_mkhtml (GtkdocDirector* self);
static void gtkdoc_director_prepare_c_file (GtkdocDirector* self, const gchar* filename, const gchar* comments_dir);
gboolean gtkdoc_is_generated_by_vala (const gchar* filename);
static void gtkdoc_director_prepare_h_file (GtkdocDirector* self, const gchar* filename);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add12 (gchar** * array, int* length, int* size, gchar* value);
gboolean gtkdoc_package_exists (const gchar* package_name, ValadocErrorReporter* reporter);
static void _vala_array_add13 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add14 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add15 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add16 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add17 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add18 (gchar** * array, int* length, int* size, gchar* value);
gpointer gtkdoc_dbus_interface_ref (gpointer instance);
void gtkdoc_dbus_interface_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gtkdoc_dbus_value_set_interface (GValue* value, gpointer v_object);
void gtkdoc_dbus_value_take_interface (GValue* value, gpointer v_object);
gpointer gtkdoc_dbus_value_get_interface (const GValue* value);
GType gtkdoc_dbus_interface_get_type (void) G_GNUC_CONST;
gchar* gtkdoc_to_docbook_id (const gchar* name);
gpointer gtkdoc_dbus_member_ref (gpointer instance);
void gtkdoc_dbus_member_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_member (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gtkdoc_dbus_value_set_member (GValue* value, gpointer v_object);
void gtkdoc_dbus_value_take_member (GValue* value, gpointer v_object);
gpointer gtkdoc_dbus_value_get_member (const GValue* value);
GType gtkdoc_dbus_member_get_type (void) G_GNUC_CONST;
GtkdocDirector* gtkdoc_director_new (void);
GtkdocDirector* gtkdoc_director_construct (GType object_type);
static void gtkdoc_director_finalize (GObject * obj);
GType register_plugin (ValadocModuleLoader* module_loader);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry GTKDOC_CONFIG_options[7] = {{"library", 'l', 0, G_OPTION_ARG_FILENAME_ARRAY, &gtkdoc_config_library_filenames, "Shared library path", "FILENAME"}, {"ignore-headers", 'x', 0, G_OPTION_ARG_FILENAME_ARRAY, &gtkdoc_config_ignore_headers, "A list of header files to not scan", "FILES"}, {"deprecated-guards", 'd', 0, G_OPTION_ARG_STRING, &gtkdoc_config_deprecated_guards, "A |-separated list of symbols used as deprecation guards", "GUARDS"}, {"ignore-decorators", (gchar) 0, 0, G_OPTION_ARG_STRING, &gtkdoc_config_ignore_decorators, "A |-separated list of addition decorators in declarations that should " \
"be ignored", "DECS"}, {"no-html", (gchar) 0, 0, G_OPTION_ARG_NONE, &gtkdoc_config_nohtml, "Disable HTML generation", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &gtkdoc_config_source_files, NULL, "FILE..."}, {NULL}};

static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gboolean gtkdoc_config_parse (gchar** rargs, int rargs_length1, ValadocErrorReporter* reporter) {
	gboolean result = FALSE;
	gchar** args = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (reporter != NULL, FALSE);
	_tmp0_ = g_strdup ("gtkdoc");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	args = _tmp1_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp2_ = rargs;
	_tmp2__length1 = rargs_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp2_;
		arg_collection_length1 = _tmp2__length1;
		for (arg_it = 0; arg_it < _tmp2__length1; arg_it = arg_it + 1) {
			gchar* _tmp3_;
			gchar* arg = NULL;
			_tmp3_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp3_;
			{
				gchar** _tmp4_;
				gint _tmp4__length1;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = args;
				_tmp4__length1 = args_length1;
				_tmp5_ = arg;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp6_);
				_g_free0 (arg);
			}
		}
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp7_;
		GOptionContext* _tmp8_;
		GOptionContext* _tmp9_;
		gchar** gtkdoc_args = NULL;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gint gtkdoc_args_length1;
		gint _gtkdoc_args_size_;
		GOptionContext* _tmp11_;
		_tmp7_ = g_option_context_new ("- Vala GTK-Doc");
		opt_context = _tmp7_;
		_tmp8_ = opt_context;
		g_option_context_set_help_enabled (_tmp8_, TRUE);
		_tmp9_ = opt_context;
		g_option_context_add_main_entries (_tmp9_, GTKDOC_CONFIG_options, NULL);
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		gtkdoc_args = _tmp10_;
		gtkdoc_args_length1 = _tmp10__length1;
		_gtkdoc_args_size_ = gtkdoc_args_length1;
		_tmp11_ = opt_context;
		g_option_context_parse (_tmp11_, &gtkdoc_args_length1, &gtkdoc_args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp12_ = FALSE;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp12_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = reporter;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		valadoc_error_reporter_simple_error (_tmp13_, "GtkDoc", "%s\n" \
"Run '-X --help' to see a full list of available command line options.", _tmp15_);
		result = FALSE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp16_ = FALSE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp16_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				gchar* realheader = NULL;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = gtkdoc_config_ignore_headers;
				_tmp20__length1 = _vala_array_length (gtkdoc_config_ignore_headers);
				if (!(_tmp19_ < _tmp20__length1)) {
					break;
				}
				_tmp21_ = gtkdoc_config_ignore_headers;
				_tmp21__length1 = _vala_array_length (gtkdoc_config_ignore_headers);
				_tmp22_ = i;
				_tmp23_ = _tmp21_[_tmp22_];
				_tmp24_ = valadoc_realpath (_tmp23_);
				realheader = _tmp24_;
				_tmp25_ = realheader;
				if (_tmp25_ != NULL) {
					gchar** _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					_tmp26_ = gtkdoc_config_ignore_headers;
					_tmp26__length1 = _vala_array_length (gtkdoc_config_ignore_headers);
					_tmp27_ = i;
					_tmp28_ = realheader;
					_tmp29_ = g_strdup (_tmp28_);
					_g_free0 (_tmp26_[_tmp27_]);
					_tmp26_[_tmp27_] = _tmp29_;
					_tmp30_ = _tmp26_[_tmp27_];
				}
				_g_free0 (realheader);
			}
		}
	}
	result = TRUE;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** gtkdoc_director_combine_string_arrays (gchar** a, int a_length1, gchar** b, int b_length1, int* result_length1) {
	gchar** result = NULL;
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	_tmp0_ = a;
	_tmp0__length1 = a_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_result_ = _tmp1_;
	_result__length1 = _tmp1__length1;
	__result__size_ = _result__length1;
	_tmp2_ = b;
	_tmp2__length1 = b_length1;
	{
		gchar** e_collection = NULL;
		gint e_collection_length1 = 0;
		gint _e_collection_size_ = 0;
		gint e_it = 0;
		e_collection = _tmp2_;
		e_collection_length1 = _tmp2__length1;
		for (e_it = 0; e_it < _tmp2__length1; e_it = e_it + 1) {
			gchar* _tmp3_;
			gchar* e = NULL;
			_tmp3_ = g_strdup (e_collection[e_it]);
			e = _tmp3_;
			{
				gchar** _tmp4_;
				gint _tmp4__length1;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp4_ = _result_;
				_tmp4__length1 = _result__length1;
				_tmp5_ = e;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add4 (&_result_, &_result__length1, &__result__size_, _tmp6_);
				_g_free0 (e);
			}
		}
	}
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _valadoc_api_tree_ref0 (gpointer self) {
	return self ? valadoc_api_tree_ref (self) : NULL;
}


static void gtkdoc_director_real_process (ValadocDoclet* base, ValadocSettings* settings, ValadocApiTree* tree, ValadocErrorReporter* reporter) {
	GtkdocDirector * self;
	ValadocSettings* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	ValadocErrorReporter* _tmp2_;
	gboolean _tmp3_;
	ValadocSettings* _tmp4_;
	ValadocSettings* _tmp5_;
	ValadocErrorReporter* _tmp6_;
	ValadocErrorReporter* _tmp7_;
	ValadocApiTree* _tmp8_;
	ValadocApiTree* _tmp9_;
	gchar* ccomments_dir = NULL;
	ValadocSettings* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* cscan_dir = NULL;
	ValadocSettings* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	ValadocSettings* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar** files = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	ValadocApiTree* _tmp21_;
	ValaCollection* _tmp22_;
	ValaCollection* _tmp23_;
	gint _tmp24_;
	gpointer* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gint _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	gboolean _tmp32_;
	gchar** all_headers = NULL;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	gchar** _tmp36_;
	gint all_headers_length1;
	gint _all_headers_size_;
	ValadocSettings* _tmp37_;
	const gchar* _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gboolean _tmp40_;
	const gchar* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gboolean _tmp43_;
	const gchar* _tmp44_;
	ValadocSettings* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	ValadocSettings* _tmp51_;
	const gchar* _tmp52_;
	ValadocSettings* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	GtkdocGenerator* _tmp59_;
	GtkdocGenerator* _tmp60_;
	ValadocSettings* _tmp61_;
	ValadocApiTree* _tmp62_;
	ValadocErrorReporter* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
	gboolean _tmp66_;
	gboolean _tmp67_;
	self = (GtkdocDirector*) base;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp0_ = settings;
	_tmp1_ = _tmp0_->pluginargs;
	_tmp1__length1 = _tmp0_->pluginargs_length1;
	_tmp2_ = reporter;
	_tmp3_ = gtkdoc_config_parse (_tmp1_, _tmp1__length1, _tmp2_);
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = settings;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp5_;
	_tmp6_ = reporter;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp7_;
	_tmp8_ = tree;
	_tmp9_ = _valadoc_api_tree_ref0 (_tmp8_);
	_valadoc_api_tree_unref0 (self->priv->tree);
	self->priv->tree = _tmp9_;
	_tmp10_ = settings;
	_tmp11_ = _tmp10_->path;
	_tmp12_ = g_build_filename (_tmp11_, "ccomments", NULL);
	ccomments_dir = _tmp12_;
	_tmp13_ = settings;
	_tmp14_ = _tmp13_->path;
	_tmp15_ = g_build_filename (_tmp14_, "cscan", NULL);
	cscan_dir = _tmp15_;
	_tmp16_ = settings;
	_tmp17_ = _tmp16_->path;
	g_mkdir_with_parents (_tmp17_, 0755);
	_tmp18_ = ccomments_dir;
	g_mkdir_with_parents (_tmp18_, 0755);
	_tmp19_ = cscan_dir;
	g_mkdir_with_parents (_tmp19_, 0755);
	_tmp20_ = gtkdoc_config_source_files;
	_tmp20__length1 = _vala_array_length (gtkdoc_config_source_files);
	_tmp21_ = tree;
	_tmp22_ = valadoc_api_tree_get_external_c_files (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp25_ = vala_collection_to_array (_tmp23_, &_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp26__length1 = _tmp24_;
	_tmp28_ = gtkdoc_director_combine_string_arrays (_tmp20_, _tmp20__length1, _tmp26_, _tmp24_, &_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp29__length1 = _tmp27_;
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (_tmp23_);
	files = _tmp29_;
	files_length1 = _tmp29__length1;
	_files_size_ = files_length1;
	_tmp30_ = files;
	_tmp30__length1 = files_length1;
	_tmp31_ = ccomments_dir;
	_tmp32_ = gtkdoc_director_prepare_files (self, _tmp30_, _tmp30__length1, _tmp31_);
	if (!_tmp32_) {
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cscan_dir);
		_g_free0 (ccomments_dir);
		return;
	}
	_tmp33_ = self->priv->vala_headers;
	_tmp33__length1 = self->priv->vala_headers_length1;
	_tmp34_ = self->priv->c_headers;
	_tmp34__length1 = self->priv->c_headers_length1;
	_tmp36_ = gtkdoc_director_combine_string_arrays (_tmp33_, _tmp33__length1, _tmp34_, _tmp34__length1, &_tmp35_);
	all_headers = _tmp36_;
	all_headers_length1 = _tmp35_;
	_all_headers_size_ = all_headers_length1;
	_tmp37_ = settings;
	_tmp38_ = _tmp37_->path;
	_tmp39_ = all_headers;
	_tmp39__length1 = all_headers_length1;
	_tmp40_ = gtkdoc_director_scan (self, _tmp38_, _tmp39_, _tmp39__length1);
	if (!_tmp40_) {
		all_headers = (_vala_array_free (all_headers, all_headers_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cscan_dir);
		_g_free0 (ccomments_dir);
		return;
	}
	_tmp41_ = cscan_dir;
	_tmp42_ = self->priv->c_headers;
	_tmp42__length1 = self->priv->c_headers_length1;
	_tmp43_ = gtkdoc_director_scan (self, _tmp41_, _tmp42_, _tmp42__length1);
	if (!_tmp43_) {
		all_headers = (_vala_array_free (all_headers, all_headers_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cscan_dir);
		_g_free0 (ccomments_dir);
		return;
	}
	_tmp44_ = cscan_dir;
	_tmp45_ = settings;
	_tmp46_ = _tmp45_->pkg_name;
	_tmp47_ = g_strdup_printf ("%s-sections.txt", _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_build_filename (_tmp44_, _tmp48_, NULL);
	_tmp50_ = _tmp49_;
	_tmp51_ = settings;
	_tmp52_ = _tmp51_->path;
	_tmp53_ = settings;
	_tmp54_ = _tmp53_->pkg_name;
	_tmp55_ = g_strdup_printf ("%s-sections.txt", _tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_build_filename (_tmp52_, _tmp56_, NULL);
	_tmp58_ = _tmp57_;
	g_rename (_tmp50_, _tmp58_);
	_g_free0 (_tmp58_);
	_g_free0 (_tmp56_);
	_g_free0 (_tmp50_);
	_g_free0 (_tmp48_);
	_tmp59_ = gtkdoc_generator_new ();
	_g_object_unref0 (self->priv->generator);
	self->priv->generator = _tmp59_;
	_tmp60_ = self->priv->generator;
	_tmp61_ = settings;
	_tmp62_ = tree;
	_tmp63_ = reporter;
	_tmp64_ = gtkdoc_generator_execute (_tmp60_, _tmp61_, _tmp62_, _tmp63_);
	if (!_tmp64_) {
		all_headers = (_vala_array_free (all_headers, all_headers_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cscan_dir);
		_g_free0 (ccomments_dir);
		return;
	}
	_tmp65_ = gtkdoc_director_scangobj (self);
	if (!_tmp65_) {
		all_headers = (_vala_array_free (all_headers, all_headers_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cscan_dir);
		_g_free0 (ccomments_dir);
		return;
	}
	_tmp66_ = gtkdoc_director_mkdb (self);
	if (!_tmp66_) {
		all_headers = (_vala_array_free (all_headers, all_headers_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cscan_dir);
		_g_free0 (ccomments_dir);
		return;
	}
	_tmp67_ = gtkdoc_director_mkhtml (self);
	if (!_tmp67_) {
		all_headers = (_vala_array_free (all_headers, all_headers_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cscan_dir);
		_g_free0 (ccomments_dir);
		return;
	}
	all_headers = (_vala_array_free (all_headers, all_headers_length1, (GDestroyNotify) g_free), NULL);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cscan_dir);
	_g_free0 (ccomments_dir);
}


static void gtkdoc_director_prepare_c_file (GtkdocDirector* self, const gchar* filename, const gchar* comments_dir) {
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (comments_dir != NULL);
	_tmp0_ = filename;
	_tmp1_ = gtkdoc_is_generated_by_vala (_tmp0_);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = filename;
	_tmp3_ = comments_dir;
	_tmp4_ = filename;
	_tmp5_ = g_path_get_basename (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (_tmp3_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_copy_file (_tmp2_, _tmp8_);
	_tmp10_ = !_tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	if (_tmp10_) {
		ValadocErrorReporter* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = self->priv->reporter;
		_tmp12_ = filename;
		valadoc_error_reporter_simple_error (_tmp11_, "GtkDoc", "Can't copy '%s'", _tmp12_);
	}
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void gtkdoc_director_prepare_h_file (GtkdocDirector* self, const gchar* filename) {
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	_tmp1_ = gtkdoc_config_ignore_headers;
	_tmp1__length1 = _vala_array_length (gtkdoc_config_ignore_headers);
	if (_vala_string_array_contains (_tmp1_, _tmp1__length1, _tmp0_)) {
		return;
	}
	_tmp2_ = filename;
	_tmp3_ = gtkdoc_is_generated_by_vala (_tmp2_);
	if (_tmp3_) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->vala_headers;
		_tmp4__length1 = self->priv->vala_headers_length1;
		_tmp5_ = filename;
		_tmp6_ = g_strdup (_tmp5_);
		_vala_array_add5 (&self->priv->vala_headers, &self->priv->vala_headers_length1, &self->priv->_vala_headers_size_, _tmp6_);
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = self->priv->c_headers;
		_tmp7__length1 = self->priv->c_headers_length1;
		_tmp8_ = filename;
		_tmp9_ = g_strdup (_tmp8_);
		_vala_array_add6 (&self->priv->c_headers, &self->priv->c_headers_length1, &self->priv->_c_headers_size_, _tmp9_);
	}
}


static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean gtkdoc_director_prepare_files (GtkdocDirector* self, gchar** files, int files_length1, const gchar* comments_dir) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** prepared = NULL;
	gchar** _tmp2_;
	gint prepared_length1;
	gint _prepared_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValadocErrorReporter* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (comments_dir != NULL, FALSE);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->vala_headers = (_vala_array_free (self->priv->vala_headers, self->priv->vala_headers_length1, (GDestroyNotify) g_free), NULL);
	self->priv->vala_headers = _tmp0_;
	self->priv->vala_headers_length1 = 0;
	self->priv->_vala_headers_size_ = self->priv->vala_headers_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->c_headers = (_vala_array_free (self->priv->c_headers, self->priv->c_headers_length1, (GDestroyNotify) g_free), NULL);
	self->priv->c_headers = _tmp1_;
	self->priv->c_headers_length1 = 0;
	self->priv->_c_headers_size_ = self->priv->c_headers_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	prepared = _tmp2_;
	prepared_length1 = 0;
	_prepared_size_ = prepared_length1;
	_tmp3_ = files;
	_tmp3__length1 = files_length1;
	{
		gchar** relative_filename_collection = NULL;
		gint relative_filename_collection_length1 = 0;
		gint _relative_filename_collection_size_ = 0;
		gint relative_filename_it = 0;
		relative_filename_collection = _tmp3_;
		relative_filename_collection_length1 = _tmp3__length1;
		for (relative_filename_it = 0; relative_filename_it < _tmp3__length1; relative_filename_it = relative_filename_it + 1) {
			gchar* _tmp4_;
			gchar* relative_filename = NULL;
			_tmp4_ = g_strdup (relative_filename_collection[relative_filename_it]);
			relative_filename = _tmp4_;
			{
				gchar* filename = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_;
				const gchar* _tmp16_;
				gboolean _tmp17_;
				_tmp5_ = relative_filename;
				_tmp6_ = valadoc_realpath (_tmp5_);
				filename = _tmp6_;
				_tmp7_ = filename;
				_tmp8_ = prepared;
				_tmp8__length1 = prepared_length1;
				if (_vala_string_array_contains (_tmp8_, _tmp8__length1, _tmp7_)) {
					_g_free0 (filename);
					_g_free0 (relative_filename);
					continue;
				}
				_tmp9_ = prepared;
				_tmp9__length1 = prepared_length1;
				_tmp10_ = filename;
				_tmp11_ = g_strdup (_tmp10_);
				_vala_array_add7 (&prepared, &prepared_length1, &_prepared_size_, _tmp11_);
				_tmp12_ = filename;
				_tmp13_ = g_file_test (_tmp12_, G_FILE_TEST_EXISTS);
				if (!_tmp13_) {
					ValadocErrorReporter* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = self->priv->reporter;
					_tmp15_ = relative_filename;
					valadoc_error_reporter_simple_error (_tmp14_, "GtkDoc", "'%s' not found", _tmp15_);
					_g_free0 (filename);
					_g_free0 (relative_filename);
					continue;
				}
				_tmp16_ = filename;
				_tmp17_ = g_str_has_suffix (_tmp16_, ".c");
				if (_tmp17_) {
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp18_ = filename;
					_tmp19_ = comments_dir;
					gtkdoc_director_prepare_c_file (self, _tmp18_, _tmp19_);
				} else {
					const gchar* _tmp20_;
					gboolean _tmp21_;
					_tmp20_ = filename;
					_tmp21_ = g_str_has_suffix (_tmp20_, ".h");
					if (_tmp21_) {
						const gchar* _tmp22_;
						_tmp22_ = filename;
						gtkdoc_director_prepare_h_file (self, _tmp22_);
					} else {
						ValadocErrorReporter* _tmp23_;
						const gchar* _tmp24_;
						_tmp23_ = self->priv->reporter;
						_tmp24_ = relative_filename;
						valadoc_error_reporter_simple_error (_tmp23_, "GtkDoc", "'%s' is not a supported source file type. Only .h, and .c files are su" \
"pported.", _tmp24_);
					}
				}
				_g_free0 (filename);
				_g_free0 (relative_filename);
			}
		}
	}
	_tmp25_ = self->priv->vala_headers;
	_tmp25__length1 = self->priv->vala_headers_length1;
	if (_tmp25__length1 <= 0) {
		ValadocErrorReporter* _tmp26_;
		_tmp26_ = self->priv->reporter;
		valadoc_error_reporter_simple_error (_tmp26_, "GtkDoc", "No vala header found");
	}
	_tmp27_ = self->priv->reporter;
	_tmp28_ = valadoc_error_reporter_get_errors (_tmp27_);
	_tmp29_ = _tmp28_;
	result = _tmp29_ == 0;
	prepared = (_vala_array_free (prepared, prepared_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add9 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add10 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add11 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add12 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean gtkdoc_director_scan (GtkdocDirector* self, const gchar* output_dir, gchar** headers, int headers_length1) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** args = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValadocSettings* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp17_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (output_dir != NULL, FALSE);
	_tmp0_ = headers;
	_tmp0__length1 = headers_length1;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = g_strdup ("gtkdoc-scan");
	_tmp2_ = g_strdup ("--module");
	_tmp3_ = self->priv->settings;
	_tmp4_ = _tmp3_->pkg_name;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_strdup ("--output-dir");
	_tmp7_ = output_dir;
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = g_strdup ("--rebuild-sections");
	_tmp10_ = g_strdup ("--rebuild-types");
	_tmp11_ = g_new0 (gchar*, 7 + 1);
	_tmp11_[0] = _tmp1_;
	_tmp11_[1] = _tmp2_;
	_tmp11_[2] = _tmp5_;
	_tmp11_[3] = _tmp6_;
	_tmp11_[4] = _tmp8_;
	_tmp11_[5] = _tmp9_;
	_tmp11_[6] = _tmp10_;
	args = _tmp11_;
	args_length1 = 7;
	_args_size_ = args_length1;
	_tmp12_ = headers;
	_tmp12__length1 = headers_length1;
	{
		gchar** header_collection = NULL;
		gint header_collection_length1 = 0;
		gint _header_collection_size_ = 0;
		gint header_it = 0;
		header_collection = _tmp12_;
		header_collection_length1 = _tmp12__length1;
		for (header_it = 0; header_it < _tmp12__length1; header_it = header_it + 1) {
			gchar* _tmp13_;
			gchar* header = NULL;
			_tmp13_ = g_strdup (header_collection[header_it]);
			header = _tmp13_;
			{
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = args;
				_tmp14__length1 = args_length1;
				_tmp15_ = header;
				_tmp16_ = g_strdup (_tmp15_);
				_vala_array_add8 (&args, &args_length1, &_args_size_, _tmp16_);
				_g_free0 (header);
			}
		}
	}
	_tmp17_ = gtkdoc_config_deprecated_guards;
	if (_tmp17_ != NULL) {
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		_tmp19_ = g_strdup ("--deprecated-guards");
		_vala_array_add9 (&args, &args_length1, &_args_size_, _tmp19_);
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = gtkdoc_config_deprecated_guards;
		_tmp22_ = g_strdup (_tmp21_);
		_vala_array_add10 (&args, &args_length1, &_args_size_, _tmp22_);
	}
	_tmp23_ = gtkdoc_config_ignore_decorators;
	if (_tmp23_ != NULL) {
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp24_ = args;
		_tmp24__length1 = args_length1;
		_tmp25_ = g_strdup ("--ignore-decorators");
		_vala_array_add11 (&args, &args_length1, &_args_size_, _tmp25_);
		_tmp26_ = args;
		_tmp26__length1 = args_length1;
		_tmp27_ = gtkdoc_config_ignore_decorators;
		_tmp28_ = g_strdup (_tmp27_);
		_vala_array_add12 (&args, &args_length1, &_args_size_, _tmp28_);
	}
	{
		ValadocSettings* _tmp29_;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gint _tmp31__length1;
		_tmp29_ = self->priv->settings;
		_tmp30_ = _tmp29_->path;
		_tmp31_ = args;
		_tmp31__length1 = args_length1;
		g_spawn_sync (_tmp30_, _tmp31_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp32_;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = self->priv->reporter;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		valadoc_error_reporter_simple_error (_tmp32_, "gtkdoc-scan", "%s", _tmp34_);
		result = FALSE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp35_ = FALSE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp35_;
	}
	result = TRUE;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_array_add13 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add14 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add15 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add16 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add17 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void _vala_array_add18 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean gtkdoc_director_scangobj (GtkdocDirector* self) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GString* library_paths = NULL;
	GString* _tmp1_;
	GString* library_dirs = NULL;
	GString* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** pc = NULL;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint pc_length1;
	gint _pc_size_;
	gchar** pc_cflags = NULL;
	gchar** _tmp40_;
	gint pc_cflags_length1;
	gint _pc_cflags_size_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar* _tmp47_;
	gchar** pc_libs = NULL;
	gchar** _tmp48_;
	gint pc_libs_length1;
	gint _pc_libs_size_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar** _tmp54_;
	gint _tmp54__length1;
	gchar* _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtkdoc_config_library_filenames;
	_tmp0__length1 = _vala_array_length (gtkdoc_config_library_filenames);
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = g_string_new ("");
	library_paths = _tmp1_;
	_tmp2_ = g_string_new ("");
	library_dirs = _tmp2_;
	_tmp3_ = gtkdoc_config_library_filenames;
	_tmp3__length1 = _vala_array_length (gtkdoc_config_library_filenames);
	{
		gchar** library_collection = NULL;
		gint library_collection_length1 = 0;
		gint _library_collection_size_ = 0;
		gint library_it = 0;
		library_collection = _tmp3_;
		library_collection_length1 = _tmp3__length1;
		for (library_it = 0; library_it < _tmp3__length1; library_it = library_it + 1) {
			gchar* _tmp4_;
			gchar* library = NULL;
			_tmp4_ = g_strdup (library_collection[library_it]);
			library = _tmp4_;
			{
				gchar* so_path = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* name = NULL;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				GString* _tmp9_;
				const gchar* _tmp10_;
				GString* _tmp11_;
				const gchar* _tmp12_;
				GString* _tmp13_;
				GString* _tmp14_;
				_tmp5_ = library;
				_tmp6_ = valadoc_realpath (_tmp5_);
				so_path = _tmp6_;
				_tmp7_ = so_path;
				_tmp8_ = g_path_get_dirname (_tmp7_);
				name = _tmp8_;
				_tmp9_ = library_dirs;
				_tmp10_ = name;
				g_string_append (_tmp9_, _tmp10_);
				_tmp11_ = library_paths;
				_tmp12_ = so_path;
				g_string_append (_tmp11_, _tmp12_);
				_tmp13_ = library_paths;
				g_string_append_c (_tmp13_, ' ');
				_tmp14_ = library_dirs;
				g_string_append_c (_tmp14_, ':');
				_g_free0 (name);
				_g_free0 (so_path);
				_g_free0 (library);
			}
		}
	}
	_tmp15_ = g_strdup ("pkg-config");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	pc = _tmp16_;
	pc_length1 = 1;
	_pc_size_ = pc_length1;
	{
		ValaIterator* _package_it = NULL;
		ValadocApiTree* _tmp17_;
		ValaCollection* _tmp18_;
		ValaCollection* _tmp19_;
		ValaIterator* _tmp20_;
		ValaIterator* _tmp21_;
		_tmp17_ = self->priv->tree;
		_tmp18_ = valadoc_api_tree_get_package_list (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_iterable_iterator ((ValaIterable*) _tmp19_);
		_tmp21_ = _tmp20_;
		_vala_iterable_unref0 (_tmp19_);
		_package_it = _tmp21_;
		while (TRUE) {
			ValaIterator* _tmp22_;
			gboolean _tmp23_;
			ValadocApiPackage* package = NULL;
			ValaIterator* _tmp24_;
			gpointer _tmp25_;
			gboolean _tmp26_ = FALSE;
			ValadocApiPackage* _tmp27_;
			gboolean _tmp28_;
			gboolean _tmp29_;
			_tmp22_ = _package_it;
			_tmp23_ = vala_iterator_next (_tmp22_);
			if (!_tmp23_) {
				break;
			}
			_tmp24_ = _package_it;
			_tmp25_ = vala_iterator_get (_tmp24_);
			package = (ValadocApiPackage*) _tmp25_;
			_tmp27_ = package;
			_tmp28_ = valadoc_api_package_get_is_package (_tmp27_);
			_tmp29_ = _tmp28_;
			if (_tmp29_) {
				ValadocApiPackage* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				ValadocErrorReporter* _tmp33_;
				gboolean _tmp34_;
				_tmp30_ = package;
				_tmp31_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = self->priv->reporter;
				_tmp34_ = gtkdoc_package_exists (_tmp32_, _tmp33_);
				_tmp26_ = _tmp34_;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				gchar** _tmp35_;
				gint _tmp35__length1;
				ValadocApiPackage* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp35_ = pc;
				_tmp35__length1 = pc_length1;
				_tmp36_ = package;
				_tmp37_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strdup (_tmp38_);
				_vala_array_add13 (&pc, &pc_length1, &_pc_size_, _tmp39_);
			}
			_g_object_unref0 (package);
		}
		_vala_iterator_unref0 (_package_it);
	}
	_tmp40_ = g_new0 (gchar*, 0 + 1);
	pc_cflags = _tmp40_;
	pc_cflags_length1 = 0;
	_pc_cflags_size_ = pc_cflags_length1;
	_tmp41_ = pc;
	_tmp41__length1 = pc_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp41_;
		name_collection_length1 = _tmp41__length1;
		for (name_it = 0; name_it < _tmp41__length1; name_it = name_it + 1) {
			gchar* _tmp42_;
			gchar* name = NULL;
			_tmp42_ = g_strdup (name_collection[name_it]);
			name = _tmp42_;
			{
				gchar** _tmp43_;
				gint _tmp43__length1;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp43_ = pc_cflags;
				_tmp43__length1 = pc_cflags_length1;
				_tmp44_ = name;
				_tmp45_ = g_strdup (_tmp44_);
				_vala_array_add14 (&pc_cflags, &pc_cflags_length1, &_pc_cflags_size_, _tmp45_);
				_g_free0 (name);
			}
		}
	}
	_tmp46_ = pc_cflags;
	_tmp46__length1 = pc_cflags_length1;
	_tmp47_ = g_strdup ("--cflags");
	_vala_array_add15 (&pc_cflags, &pc_cflags_length1, &_pc_cflags_size_, _tmp47_);
	_tmp48_ = g_new0 (gchar*, 0 + 1);
	pc_libs = _tmp48_;
	pc_libs_length1 = 0;
	_pc_libs_size_ = pc_libs_length1;
	_tmp49_ = pc;
	_tmp49__length1 = pc_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp49_;
		name_collection_length1 = _tmp49__length1;
		for (name_it = 0; name_it < _tmp49__length1; name_it = name_it + 1) {
			gchar* _tmp50_;
			gchar* name = NULL;
			_tmp50_ = g_strdup (name_collection[name_it]);
			name = _tmp50_;
			{
				gchar** _tmp51_;
				gint _tmp51__length1;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				_tmp51_ = pc_libs;
				_tmp51__length1 = pc_libs_length1;
				_tmp52_ = name;
				_tmp53_ = g_strdup (_tmp52_);
				_vala_array_add16 (&pc_libs, &pc_libs_length1, &_pc_libs_size_, _tmp53_);
				_g_free0 (name);
			}
		}
	}
	_tmp54_ = pc_libs;
	_tmp54__length1 = pc_libs_length1;
	_tmp55_ = g_strdup ("--libs");
	_vala_array_add17 (&pc_libs, &pc_libs_length1, &_pc_libs_size_, _tmp55_);
	{
		gchar* stderr_buf = NULL;
		gint status = 0;
		gchar* cflags = NULL;
		gchar** _tmp56_;
		gint _tmp56__length1;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* libs = NULL;
		gchar** _tmp65_;
		gint _tmp65__length1;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_;
		const gchar* _tmp72_;
		gchar* _tmp73_;
		gchar** args = NULL;
		gchar* _tmp74_;
		gchar* _tmp75_;
		ValadocSettings* _tmp76_;
		const gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		ValadocSettings* _tmp80_;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		ValadocSettings* _tmp84_;
		const gchar* _tmp85_;
		gchar* _tmp86_;
		gchar** _tmp87_;
		gint args_length1;
		gint _args_size_;
		const gchar* _tmp88_ = NULL;
		const gchar* _tmp89_;
		const gchar* _tmp90_ = NULL;
		const gchar* _tmp91_;
		const gchar* _tmp92_ = NULL;
		const gchar* _tmp93_;
		gchar** env = NULL;
		const gchar* _tmp94_;
		gchar* _tmp95_;
		const gchar* _tmp96_;
		GString* _tmp97_;
		const gchar* _tmp98_;
		gchar* _tmp99_;
		GString* _tmp100_;
		const gchar* _tmp101_;
		gchar* _tmp102_;
		gchar** _tmp103_;
		gint env_length1;
		gint _env_size_;
		gchar** _tmp104_;
		gchar** _tmp105_;
		ValadocSettings* _tmp117_;
		const gchar* _tmp118_;
		gchar** _tmp119_;
		gint _tmp119__length1;
		gchar** _tmp120_;
		gint _tmp120__length1;
		_tmp56_ = pc_cflags;
		_tmp56__length1 = pc_cflags_length1;
		g_spawn_sync (NULL, _tmp56_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp57_, &_tmp58_, &_tmp59_, &_inner_error_);
		_g_free0 (cflags);
		cflags = _tmp57_;
		_g_free0 (stderr_buf);
		stderr_buf = _tmp58_;
		status = _tmp59_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (cflags);
			_g_free0 (stderr_buf);
			goto __catch2_g_error;
		}
		_tmp60_ = status;
		if (_tmp60_ != 0) {
			ValadocErrorReporter* _tmp61_;
			const gchar* _tmp62_;
			_tmp61_ = self->priv->reporter;
			_tmp62_ = stderr_buf;
			valadoc_error_reporter_simple_error (_tmp61_, "GtkDoc", "pkg-config cflags error: %s", _tmp62_);
			result = FALSE;
			_g_free0 (cflags);
			_g_free0 (stderr_buf);
			pc_libs = (_vala_array_free (pc_libs, pc_libs_length1, (GDestroyNotify) g_free), NULL);
			pc_cflags = (_vala_array_free (pc_cflags, pc_cflags_length1, (GDestroyNotify) g_free), NULL);
			pc = (_vala_array_free (pc, pc_length1, (GDestroyNotify) g_free), NULL);
			_g_string_free0 (library_dirs);
			_g_string_free0 (library_paths);
			return result;
		}
		_tmp63_ = cflags;
		_tmp64_ = string_strip (_tmp63_);
		_g_free0 (cflags);
		cflags = _tmp64_;
		_tmp65_ = pc_libs;
		_tmp65__length1 = pc_libs_length1;
		g_spawn_sync (NULL, _tmp65_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp66_, &_tmp67_, &_tmp68_, &_inner_error_);
		_g_free0 (libs);
		libs = _tmp66_;
		_g_free0 (stderr_buf);
		stderr_buf = _tmp67_;
		status = _tmp68_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (libs);
			_g_free0 (cflags);
			_g_free0 (stderr_buf);
			goto __catch2_g_error;
		}
		_tmp69_ = status;
		if (_tmp69_ != 0) {
			ValadocErrorReporter* _tmp70_;
			const gchar* _tmp71_;
			_tmp70_ = self->priv->reporter;
			_tmp71_ = stderr_buf;
			valadoc_error_reporter_simple_error (_tmp70_, "GtkDoc", "pkg-config libs error: %s", _tmp71_);
			result = FALSE;
			_g_free0 (libs);
			_g_free0 (cflags);
			_g_free0 (stderr_buf);
			pc_libs = (_vala_array_free (pc_libs, pc_libs_length1, (GDestroyNotify) g_free), NULL);
			pc_cflags = (_vala_array_free (pc_cflags, pc_cflags_length1, (GDestroyNotify) g_free), NULL);
			pc = (_vala_array_free (pc, pc_length1, (GDestroyNotify) g_free), NULL);
			_g_string_free0 (library_dirs);
			_g_string_free0 (library_paths);
			return result;
		}
		_tmp72_ = libs;
		_tmp73_ = string_strip (_tmp72_);
		_g_free0 (libs);
		libs = _tmp73_;
		_tmp74_ = g_strdup ("gtkdoc-scangobj");
		_tmp75_ = g_strdup ("--module");
		_tmp76_ = self->priv->settings;
		_tmp77_ = _tmp76_->pkg_name;
		_tmp78_ = g_strdup (_tmp77_);
		_tmp79_ = g_strdup ("--types");
		_tmp80_ = self->priv->settings;
		_tmp81_ = _tmp80_->pkg_name;
		_tmp82_ = g_strdup_printf ("%s.types", _tmp81_);
		_tmp83_ = g_strdup ("--output-dir");
		_tmp84_ = self->priv->settings;
		_tmp85_ = _tmp84_->path;
		_tmp86_ = g_strdup (_tmp85_);
		_tmp87_ = g_new0 (gchar*, 7 + 1);
		_tmp87_[0] = _tmp74_;
		_tmp87_[1] = _tmp75_;
		_tmp87_[2] = _tmp78_;
		_tmp87_[3] = _tmp79_;
		_tmp87_[4] = _tmp82_;
		_tmp87_[5] = _tmp83_;
		_tmp87_[6] = _tmp86_;
		args = _tmp87_;
		args_length1 = 7;
		_args_size_ = args_length1;
		_tmp89_ = g_getenv ("CFLAGS");
		_tmp88_ = _tmp89_;
		if (_tmp88_ == NULL) {
			_tmp88_ = "";
		}
		_tmp91_ = g_getenv ("LDFLAGS");
		_tmp90_ = _tmp91_;
		if (_tmp90_ == NULL) {
			_tmp90_ = "";
		}
		_tmp93_ = g_getenv ("LD_LIBRARY_PATH");
		_tmp92_ = _tmp93_;
		if (_tmp92_ == NULL) {
			_tmp92_ = "";
		}
		_tmp94_ = cflags;
		_tmp95_ = g_strdup_printf ("CFLAGS=%s %s", _tmp94_, _tmp88_);
		_tmp96_ = libs;
		_tmp97_ = library_paths;
		_tmp98_ = _tmp97_->str;
		_tmp99_ = g_strdup_printf ("LDFLAGS=%s %s %s", _tmp96_, _tmp98_, _tmp90_);
		_tmp100_ = library_dirs;
		_tmp101_ = _tmp100_->str;
		_tmp102_ = g_strdup_printf ("LD_LIBRARY_PATH=%s%s", _tmp101_, _tmp92_);
		_tmp103_ = g_new0 (gchar*, 3 + 1);
		_tmp103_[0] = _tmp95_;
		_tmp103_[1] = _tmp99_;
		_tmp103_[2] = _tmp102_;
		env = _tmp103_;
		env_length1 = 3;
		_env_size_ = env_length1;
		_tmp105_ = _tmp104_ = g_listenv ();
		{
			gchar** evar_collection = NULL;
			gint evar_collection_length1 = 0;
			gint _evar_collection_size_ = 0;
			gint evar_it = 0;
			evar_collection = _tmp105_;
			evar_collection_length1 = _vala_array_length (_tmp104_);
			for (evar_it = 0; evar_it < _vala_array_length (_tmp104_); evar_it = evar_it + 1) {
				gchar* _tmp106_;
				gchar* evar = NULL;
				_tmp106_ = g_strdup (evar_collection[evar_it]);
				evar = _tmp106_;
				{
					gboolean _tmp107_ = FALSE;
					gboolean _tmp108_ = FALSE;
					const gchar* _tmp109_;
					_tmp109_ = evar;
					if (g_strcmp0 (_tmp109_, "CFLAGS") != 0) {
						const gchar* _tmp110_;
						_tmp110_ = evar;
						_tmp108_ = g_strcmp0 (_tmp110_, "LDFLAGS") != 0;
					} else {
						_tmp108_ = FALSE;
					}
					if (_tmp108_) {
						const gchar* _tmp111_;
						_tmp111_ = evar;
						_tmp107_ = g_strcmp0 (_tmp111_, "LD_LIBRARY_PATH") != 0;
					} else {
						_tmp107_ = FALSE;
					}
					if (_tmp107_) {
						gchar** _tmp112_;
						gint _tmp112__length1;
						const gchar* _tmp113_;
						const gchar* _tmp114_;
						const gchar* _tmp115_;
						gchar* _tmp116_;
						_tmp112_ = env;
						_tmp112__length1 = env_length1;
						_tmp113_ = evar;
						_tmp114_ = evar;
						_tmp115_ = g_getenv (_tmp114_);
						_tmp116_ = g_strdup_printf ("%s=%s", _tmp113_, _tmp115_);
						_vala_array_add18 (&env, &env_length1, &_env_size_, _tmp116_);
					}
					_g_free0 (evar);
				}
			}
			evar_collection = (_vala_array_free (evar_collection, evar_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp117_ = self->priv->settings;
		_tmp118_ = _tmp117_->path;
		_tmp119_ = args;
		_tmp119__length1 = args_length1;
		_tmp120_ = env;
		_tmp120__length1 = env_length1;
		g_spawn_sync (_tmp118_, _tmp119_, _tmp120_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (libs);
			_g_free0 (cflags);
			_g_free0 (stderr_buf);
			goto __catch2_g_error;
		}
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (libs);
		_g_free0 (cflags);
		_g_free0 (stderr_buf);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp121_;
		GError* _tmp122_;
		const gchar* _tmp123_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp121_ = self->priv->reporter;
		_tmp122_ = e;
		_tmp123_ = _tmp122_->message;
		valadoc_error_reporter_simple_error (_tmp121_, "gtkdoc-scangobj", "%s", _tmp123_);
		result = FALSE;
		_g_error_free0 (e);
		pc_libs = (_vala_array_free (pc_libs, pc_libs_length1, (GDestroyNotify) g_free), NULL);
		pc_cflags = (_vala_array_free (pc_cflags, pc_cflags_length1, (GDestroyNotify) g_free), NULL);
		pc = (_vala_array_free (pc, pc_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (library_dirs);
		_g_string_free0 (library_paths);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp124_ = FALSE;
		pc_libs = (_vala_array_free (pc_libs, pc_libs_length1, (GDestroyNotify) g_free), NULL);
		pc_cflags = (_vala_array_free (pc_cflags, pc_cflags_length1, (GDestroyNotify) g_free), NULL);
		pc = (_vala_array_free (pc, pc_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (library_dirs);
		_g_string_free0 (library_paths);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp124_;
	}
	result = TRUE;
	pc_libs = (_vala_array_free (pc_libs, pc_libs_length1, (GDestroyNotify) g_free), NULL);
	pc_cflags = (_vala_array_free (pc_cflags, pc_cflags_length1, (GDestroyNotify) g_free), NULL);
	pc = (_vala_array_free (pc, pc_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (library_dirs);
	_g_string_free0 (library_paths);
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gboolean gtkdoc_director_mkdb (GtkdocDirector* self) {
	gboolean result = FALSE;
	gchar* main_file = NULL;
	ValadocSettings* _tmp0_;
	const gchar* _tmp1_;
	ValadocSettings* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* code_dir = NULL;
	ValadocSettings* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean must_update_main_file = FALSE;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	gchar** args = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValadocSettings* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	ValadocSettings* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	ValadocSettings* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp1_ = _tmp0_->path;
	_tmp2_ = self->priv->settings;
	_tmp3_ = _tmp2_->pkg_name;
	_tmp4_ = g_strdup_printf ("%s-docs.xml", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp1_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	main_file = _tmp7_;
	_tmp8_ = self->priv->settings;
	_tmp9_ = _tmp8_->path;
	_tmp10_ = g_build_filename (_tmp9_, "ccomments", NULL);
	code_dir = _tmp10_;
	_tmp11_ = main_file;
	_tmp12_ = g_file_test (_tmp11_, G_FILE_TEST_EXISTS);
	must_update_main_file = !_tmp12_;
	_tmp13_ = g_strdup ("gtkdoc-mkdb");
	_tmp14_ = g_strdup ("--module");
	_tmp15_ = self->priv->settings;
	_tmp16_ = _tmp15_->pkg_name;
	_tmp17_ = g_strdup (_tmp16_);
	_tmp18_ = g_strdup ("--source-dir");
	_tmp19_ = code_dir;
	_tmp20_ = g_strdup (_tmp19_);
	_tmp21_ = g_strdup ("--output-format");
	_tmp22_ = g_strdup ("xml");
	_tmp23_ = g_strdup ("--sgml-mode");
	_tmp24_ = g_strdup ("--main-sgml-file");
	_tmp25_ = self->priv->settings;
	_tmp26_ = _tmp25_->pkg_name;
	_tmp27_ = g_strdup_printf ("%s-docs.xml", _tmp26_);
	_tmp28_ = g_strdup ("--name-space");
	_tmp29_ = self->priv->settings;
	_tmp30_ = _tmp29_->pkg_name;
	_tmp31_ = g_strdup (_tmp30_);
	_tmp32_ = g_new0 (gchar*, 12 + 1);
	_tmp32_[0] = _tmp13_;
	_tmp32_[1] = _tmp14_;
	_tmp32_[2] = _tmp17_;
	_tmp32_[3] = _tmp18_;
	_tmp32_[4] = _tmp20_;
	_tmp32_[5] = _tmp21_;
	_tmp32_[6] = _tmp22_;
	_tmp32_[7] = _tmp23_;
	_tmp32_[8] = _tmp24_;
	_tmp32_[9] = _tmp27_;
	_tmp32_[10] = _tmp28_;
	_tmp32_[11] = _tmp31_;
	args = _tmp32_;
	args_length1 = 12;
	_args_size_ = args_length1;
	{
		ValadocSettings* _tmp33_;
		const gchar* _tmp34_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		_tmp33_ = self->priv->settings;
		_tmp34_ = _tmp33_->path;
		_tmp35_ = args;
		_tmp35__length1 = args_length1;
		g_spawn_sync (_tmp34_, _tmp35_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = self->priv->reporter;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		valadoc_error_reporter_simple_error (_tmp36_, "gtkdoc-mkdb", "%s", _tmp38_);
		result = FALSE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (code_dir);
		_g_free0 (main_file);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp39_ = FALSE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (code_dir);
		_g_free0 (main_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp39_;
	}
	_tmp40_ = must_update_main_file;
	if (_tmp40_) {
		gchar* contents = NULL;
		ValadocSettings* _tmp48_;
		const gchar* _tmp49_;
		const gchar* _tmp54_;
		ValadocSettings* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		GtkdocGenerator* _tmp60_;
		ValaList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		{
			const gchar* _tmp41_;
			gchar* _tmp42_ = NULL;
			_tmp41_ = main_file;
			g_file_get_contents (_tmp41_, &_tmp42_, NULL, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp42_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			ValadocErrorReporter* _tmp43_;
			const gchar* _tmp44_;
			GError* _tmp45_;
			const gchar* _tmp46_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp43_ = self->priv->reporter;
			_tmp44_ = main_file;
			_tmp45_ = e;
			_tmp46_ = _tmp45_->message;
			valadoc_error_reporter_simple_error (_tmp43_, "GtkDoc", "Error while reading main file '%s' contents: %s", _tmp44_, _tmp46_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (contents);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (code_dir);
			_g_free0 (main_file);
			return result;
		}
		__finally4:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp47_ = FALSE;
			_g_free0 (contents);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (code_dir);
			_g_free0 (main_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp47_;
		}
		_tmp48_ = self->priv->settings;
		_tmp49_ = _tmp48_->pkg_version;
		if (_tmp49_ != NULL) {
			const gchar* _tmp50_;
			ValadocSettings* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp50_ = contents;
			_tmp51_ = self->priv->settings;
			_tmp52_ = _tmp51_->pkg_version;
			_tmp53_ = string_replace (_tmp50_, "[VERSION]", _tmp52_);
			_g_free0 (contents);
			contents = _tmp53_;
		}
		_tmp54_ = contents;
		_tmp55_ = self->priv->settings;
		_tmp56_ = _tmp55_->pkg_name;
		_tmp57_ = g_strdup_printf ("%s API Reference", _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = string_replace (_tmp54_, "[Insert title here]", _tmp58_);
		_g_free0 (contents);
		contents = _tmp59_;
		_g_free0 (_tmp58_);
		_tmp60_ = self->priv->generator;
		_tmp61_ = _tmp60_->dbus_interfaces;
		_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		if (_tmp63_ > 0) {
			GString* builder = NULL;
			GString* _tmp64_;
			GString* _tmp65_;
			ValadocSettings* _tmp66_;
			const gchar* _tmp67_;
			gchar* hierarchy_file = NULL;
			ValadocSettings* _tmp85_;
			const gchar* _tmp86_;
			ValadocSettings* _tmp87_;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			const gchar* _tmp93_;
			gboolean _tmp94_;
			_tmp64_ = g_string_new ("");
			builder = _tmp64_;
			_tmp65_ = builder;
			_tmp66_ = self->priv->settings;
			_tmp67_ = _tmp66_->pkg_name;
			g_string_append_printf (_tmp65_, "\n<chapter>\n<title>%s D-Bus API Reference</title>\n", _tmp67_);
			{
				ValaList* _iface_list = NULL;
				GtkdocGenerator* _tmp68_;
				ValaList* _tmp69_;
				ValaList* _tmp70_;
				gint _iface_size = 0;
				ValaList* _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				gint _iface_index = 0;
				_tmp68_ = self->priv->generator;
				_tmp69_ = _tmp68_->dbus_interfaces;
				_tmp70_ = _vala_iterable_ref0 (_tmp69_);
				_iface_list = _tmp70_;
				_tmp71_ = _iface_list;
				_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
				_tmp73_ = _tmp72_;
				_iface_size = _tmp73_;
				_iface_index = -1;
				while (TRUE) {
					gint _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
					GtkdocDBusInterface* iface = NULL;
					ValaList* _tmp77_;
					gint _tmp78_;
					gpointer _tmp79_;
					GString* _tmp80_;
					GtkdocDBusInterface* _tmp81_;
					const gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					_tmp74_ = _iface_index;
					_iface_index = _tmp74_ + 1;
					_tmp75_ = _iface_index;
					_tmp76_ = _iface_size;
					if (!(_tmp75_ < _tmp76_)) {
						break;
					}
					_tmp77_ = _iface_list;
					_tmp78_ = _iface_index;
					_tmp79_ = vala_list_get (_tmp77_, _tmp78_);
					iface = (GtkdocDBusInterface*) _tmp79_;
					_tmp80_ = builder;
					_tmp81_ = iface;
					_tmp82_ = _tmp81_->name;
					_tmp83_ = gtkdoc_to_docbook_id (_tmp82_);
					_tmp84_ = _tmp83_;
					g_string_append_printf (_tmp80_, "<xi:include href=\"xml/%s.xml\"/>\n", _tmp84_);
					_g_free0 (_tmp84_);
					_gtkdoc_dbus_interface_unref0 (iface);
				}
				_vala_iterable_unref0 (_iface_list);
			}
			_tmp85_ = self->priv->settings;
			_tmp86_ = _tmp85_->path;
			_tmp87_ = self->priv->settings;
			_tmp88_ = _tmp87_->pkg_name;
			_tmp89_ = g_strdup_printf ("%s.hierarchy", _tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = g_build_filename (_tmp86_, _tmp90_, NULL);
			_tmp92_ = _tmp91_;
			_g_free0 (_tmp90_);
			hierarchy_file = _tmp92_;
			_tmp93_ = hierarchy_file;
			_tmp94_ = g_file_test (_tmp93_, G_FILE_TEST_EXISTS);
			if (_tmp94_) {
				GString* _tmp95_;
				const gchar* _tmp96_;
				GString* _tmp97_;
				const gchar* _tmp98_;
				gchar* _tmp99_;
				_tmp95_ = builder;
				g_string_append (_tmp95_, "</chapter>\n<chapter id=\"object-tree\">");
				_tmp96_ = contents;
				_tmp97_ = builder;
				_tmp98_ = _tmp97_->str;
				_tmp99_ = string_replace (_tmp96_, "<chapter id=\"object-tree\">", _tmp98_);
				_g_free0 (contents);
				contents = _tmp99_;
			} else {
				GString* _tmp100_;
				const gchar* _tmp101_;
				GString* _tmp102_;
				const gchar* _tmp103_;
				gchar* _tmp104_;
				_tmp100_ = builder;
				g_string_append (_tmp100_, "</chapter>\n<index id=\"api-index-full\">");
				_tmp101_ = contents;
				_tmp102_ = builder;
				_tmp103_ = _tmp102_->str;
				_tmp104_ = string_replace (_tmp101_, "<index id=\"api-index-full\">", _tmp103_);
				_g_free0 (contents);
				contents = _tmp104_;
			}
			_g_free0 (hierarchy_file);
			_g_string_free0 (builder);
		}
		{
			const gchar* _tmp105_;
			const gchar* _tmp106_;
			_tmp105_ = main_file;
			_tmp106_ = contents;
			g_file_set_contents (_tmp105_, _tmp106_, (gssize) -1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* e = NULL;
			ValadocErrorReporter* _tmp107_;
			const gchar* _tmp108_;
			GError* _tmp109_;
			const gchar* _tmp110_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp107_ = self->priv->reporter;
			_tmp108_ = main_file;
			_tmp109_ = e;
			_tmp110_ = _tmp109_->message;
			valadoc_error_reporter_simple_error (_tmp107_, "GtkDoc", "Error while writing main file '%s' contents: %s", _tmp108_, _tmp110_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (contents);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (code_dir);
			_g_free0 (main_file);
			return result;
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp111_ = FALSE;
			_g_free0 (contents);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (code_dir);
			_g_free0 (main_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp111_;
		}
		_g_free0 (contents);
	}
	result = TRUE;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (code_dir);
	_g_free0 (main_file);
	return result;
}


static gboolean gtkdoc_director_mkhtml (GtkdocDirector* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar* html_dir = NULL;
	ValadocSettings* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtkdoc_config_nohtml;
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = _tmp1_->path;
	_tmp3_ = g_build_filename (_tmp2_, "html", NULL);
	html_dir = _tmp3_;
	_tmp4_ = html_dir;
	g_mkdir_with_parents (_tmp4_, 0755);
	{
		const gchar* _tmp5_;
		gchar* _tmp6_;
		ValadocSettings* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		ValadocSettings* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		_tmp5_ = html_dir;
		_tmp6_ = g_strdup ("gtkdoc-mkhtml");
		_tmp7_ = self->priv->settings;
		_tmp8_ = _tmp7_->pkg_name;
		_tmp9_ = g_strdup (_tmp8_);
		_tmp10_ = self->priv->settings;
		_tmp11_ = _tmp10_->pkg_name;
		_tmp12_ = g_strdup_printf ("../%s-docs.xml", _tmp11_);
		_tmp13_ = g_new0 (gchar*, 3 + 1);
		_tmp13_[0] = _tmp6_;
		_tmp13_[1] = _tmp9_;
		_tmp13_[2] = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 3;
		g_spawn_sync (_tmp5_, _tmp14_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error_);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = self->priv->reporter;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		valadoc_error_reporter_simple_error (_tmp15_, "gtkdoc-mkhtml", "%s", _tmp17_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (html_dir);
		return result;
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		_g_free0 (html_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	{
		ValadocSettings* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		ValadocSettings* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp19_ = self->priv->settings;
		_tmp20_ = _tmp19_->path;
		_tmp21_ = g_strdup ("gtkdoc-fixxref");
		_tmp22_ = g_strdup ("--module");
		_tmp23_ = self->priv->settings;
		_tmp24_ = _tmp23_->pkg_name;
		_tmp25_ = g_strdup (_tmp24_);
		_tmp26_ = g_strdup ("--module-dir");
		_tmp27_ = html_dir;
		_tmp28_ = g_strdup (_tmp27_);
		_tmp29_ = g_strdup ("--html-dir");
		_tmp30_ = html_dir;
		_tmp31_ = g_strdup (_tmp30_);
		_tmp32_ = g_new0 (gchar*, 7 + 1);
		_tmp32_[0] = _tmp21_;
		_tmp32_[1] = _tmp22_;
		_tmp32_[2] = _tmp25_;
		_tmp32_[3] = _tmp26_;
		_tmp32_[4] = _tmp28_;
		_tmp32_[5] = _tmp29_;
		_tmp32_[6] = _tmp31_;
		_tmp33_ = _tmp32_;
		_tmp33__length1 = 7;
		g_spawn_sync (_tmp20_, _tmp33_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL, NULL, &_inner_error_);
		_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp34_;
		GError* _tmp35_;
		const gchar* _tmp36_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp34_ = self->priv->reporter;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		valadoc_error_reporter_simple_error (_tmp34_, "gtkdoc-fixxref", "%s", _tmp36_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (html_dir);
		return result;
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp37_ = FALSE;
		_g_free0 (html_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp37_;
	}
	result = TRUE;
	_g_free0 (html_dir);
	return result;
}


GtkdocDirector* gtkdoc_director_construct (GType object_type) {
	GtkdocDirector * self = NULL;
	self = (GtkdocDirector*) g_object_new (object_type, NULL);
	return self;
}


GtkdocDirector* gtkdoc_director_new (void) {
	return gtkdoc_director_construct (GTKDOC_TYPE_DIRECTOR);
}


static void gtkdoc_director_class_init (GtkdocDirectorClass * klass) {
	gtkdoc_director_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkdocDirectorPrivate));
	G_OBJECT_CLASS (klass)->finalize = gtkdoc_director_finalize;
}


static void gtkdoc_director_valadoc_doclet_interface_init (ValadocDocletIface * iface) {
	gtkdoc_director_valadoc_doclet_parent_iface = g_type_interface_peek_parent (iface);
	iface->process = (void (*) (ValadocDoclet *, ValadocSettings*, ValadocApiTree*, ValadocErrorReporter*)) gtkdoc_director_real_process;
}


static void gtkdoc_director_instance_init (GtkdocDirector * self) {
	self->priv = GTKDOC_DIRECTOR_GET_PRIVATE (self);
}


static void gtkdoc_director_finalize (GObject * obj) {
	GtkdocDirector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_DIRECTOR, GtkdocDirector);
	_g_object_unref0 (self->priv->reporter);
	_g_object_unref0 (self->priv->settings);
	_valadoc_api_tree_unref0 (self->priv->tree);
	_g_object_unref0 (self->priv->generator);
	self->priv->vala_headers = (_vala_array_free (self->priv->vala_headers, self->priv->vala_headers_length1, (GDestroyNotify) g_free), NULL);
	self->priv->c_headers = (_vala_array_free (self->priv->c_headers, self->priv->c_headers_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (gtkdoc_director_parent_class)->finalize (obj);
}


GType gtkdoc_director_get_type (void) {
	static volatile gsize gtkdoc_director_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_director_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocDirectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_director_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocDirector), 0, (GInstanceInitFunc) gtkdoc_director_instance_init, NULL };
		static const GInterfaceInfo valadoc_doclet_info = { (GInterfaceInitFunc) gtkdoc_director_valadoc_doclet_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gtkdoc_director_type_id;
		gtkdoc_director_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkdocDirector", &g_define_type_info, 0);
		g_type_add_interface_static (gtkdoc_director_type_id, VALADOC_TYPE_DOCLET, &valadoc_doclet_info);
		g_once_init_leave (&gtkdoc_director_type_id__volatile, gtkdoc_director_type_id);
	}
	return gtkdoc_director_type_id__volatile;
}


GType register_plugin (ValadocModuleLoader* module_loader) {
	GType result = 0UL;
	g_return_val_if_fail (module_loader != NULL, 0UL);
	result = GTKDOC_TYPE_DIRECTOR;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



