// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/tauri-apps/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

#[cfg(feature = "v2_18")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_18")))]
use crate::AutomationSession;
#[cfg(feature = "v2_26")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
use crate::GeolocationManager;
#[cfg(feature = "v2_34")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_34")))]
use crate::MemoryPressureSettings;
#[cfg(feature = "v2_4")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
use crate::ProcessModel;
#[cfg(feature = "v2_16")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
use crate::SecurityOrigin;
#[cfg(feature = "v2_28")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
use crate::UserMessage;
#[cfg(feature = "v2_10")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
use crate::WebsiteDataManager;
use crate::{
  CacheModel, CookieManager, Download, FaviconDatabase, Plugin, SecurityManager, TLSErrorsPolicy,
  URISchemeRequest,
};
use glib::{
  prelude::*,
  signal::{connect_raw, SignalHandlerId},
  translate::*,
};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "WebKitWebContext")]
    pub struct WebContext(Object<ffi::WebKitWebContext, ffi::WebKitWebContextClass>);

    match fn {
        type_ => || ffi::webkit_web_context_get_type(),
    }
}

impl WebContext {
  pub const NONE: Option<&'static WebContext> = None;

  #[cfg(feature = "v2_8")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_8")))]
  #[doc(alias = "webkit_web_context_new")]
  pub fn new() -> WebContext {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::webkit_web_context_new()) }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  #[doc(alias = "webkit_web_context_new_ephemeral")]
  pub fn new_ephemeral() -> WebContext {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::webkit_web_context_new_ephemeral()) }
  }

  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  #[doc(alias = "webkit_web_context_new_with_website_data_manager")]
  #[doc(alias = "new_with_website_data_manager")]
  pub fn with_website_data_manager(manager: &impl IsA<WebsiteDataManager>) -> WebContext {
    skip_assert_initialized!();
    unsafe {
      from_glib_full(ffi::webkit_web_context_new_with_website_data_manager(
        manager.as_ref().to_glib_none().0,
      ))
    }
  }

  // rustdoc-stripper-ignore-next
  /// Creates a new builder-pattern struct instance to construct [`WebContext`] objects.
  ///
  /// This method returns an instance of [`WebContextBuilder`](crate::builders::WebContextBuilder) which can be used to create [`WebContext`] objects.
  pub fn builder() -> WebContextBuilder {
    WebContextBuilder::new()
  }

  #[doc(alias = "webkit_web_context_get_default")]
  #[doc(alias = "get_default")]
  #[allow(clippy::should_implement_trait)]
  pub fn default() -> Option<WebContext> {
    assert_initialized_main_thread!();
    unsafe { from_glib_none(ffi::webkit_web_context_get_default()) }
  }
}

#[cfg(feature = "v2_8")]
#[cfg_attr(docsrs, doc(cfg(feature = "v2_8")))]
impl Default for WebContext {
  fn default() -> Self {
    Self::new()
  }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`WebContext`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct WebContextBuilder {
  builder: glib::object::ObjectBuilder<'static, WebContext>,
}

impl WebContextBuilder {
  fn new() -> Self {
    Self {
      builder: glib::object::Object::builder(),
    }
  }

  #[cfg(feature = "v2_8")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_8")))]
  #[cfg_attr(feature = "v2_10", deprecated = "Since 2.10")]
  pub fn local_storage_directory(self, local_storage_directory: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("local-storage-directory", local_storage_directory.into()),
    }
  }

  #[cfg(feature = "v2_34")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_34")))]
  pub fn memory_pressure_settings(self, memory_pressure_settings: &MemoryPressureSettings) -> Self {
    Self {
      builder: self
        .builder
        .property("memory-pressure-settings", memory_pressure_settings),
    }
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  pub fn process_swap_on_cross_site_navigation_enabled(
    self,
    process_swap_on_cross_site_navigation_enabled: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "process-swap-on-cross-site-navigation-enabled",
        process_swap_on_cross_site_navigation_enabled,
      ),
    }
  }

  #[cfg(feature = "v2_38")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_38")))]
  pub fn time_zone_override(self, time_zone_override: impl Into<glib::GString>) -> Self {
    Self {
      builder: self
        .builder
        .property("time-zone-override", time_zone_override.into()),
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  pub fn use_system_appearance_for_scrollbars(
    self,
    use_system_appearance_for_scrollbars: bool,
  ) -> Self {
    Self {
      builder: self.builder.property(
        "use-system-appearance-for-scrollbars",
        use_system_appearance_for_scrollbars,
      ),
    }
  }

  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  pub fn website_data_manager(self, website_data_manager: &impl IsA<WebsiteDataManager>) -> Self {
    Self {
      builder: self.builder.property(
        "website-data-manager",
        website_data_manager.clone().upcast(),
      ),
    }
  }

  // rustdoc-stripper-ignore-next
  /// Build the [`WebContext`].
  #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
  pub fn build(self) -> WebContext {
    self.builder.build()
  }
}

mod sealed {
  pub trait Sealed {}
  impl<T: super::IsA<super::WebContext>> Sealed for T {}
}

pub trait WebContextExt: IsA<WebContext> + sealed::Sealed + 'static {
  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  #[doc(alias = "webkit_web_context_add_path_to_sandbox")]
  fn add_path_to_sandbox(&self, path: impl AsRef<std::path::Path>, read_only: bool) {
    unsafe {
      ffi::webkit_web_context_add_path_to_sandbox(
        self.as_ref().to_glib_none().0,
        path.as_ref().to_glib_none().0,
        read_only.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_6")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_6")))]
  #[doc(alias = "webkit_web_context_allow_tls_certificate_for_host")]
  fn allow_tls_certificate_for_host(
    &self,
    certificate: &impl IsA<gio::TlsCertificate>,
    host: &str,
  ) {
    unsafe {
      ffi::webkit_web_context_allow_tls_certificate_for_host(
        self.as_ref().to_glib_none().0,
        certificate.as_ref().to_glib_none().0,
        host.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_web_context_clear_cache")]
  fn clear_cache(&self) {
    unsafe {
      ffi::webkit_web_context_clear_cache(self.as_ref().to_glib_none().0);
    }
  }

  #[doc(alias = "webkit_web_context_download_uri")]
  fn download_uri(&self, uri: &str) -> Option<Download> {
    unsafe {
      from_glib_full(ffi::webkit_web_context_download_uri(
        self.as_ref().to_glib_none().0,
        uri.to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_get_cache_model")]
  #[doc(alias = "get_cache_model")]
  fn cache_model(&self) -> CacheModel {
    unsafe {
      from_glib(ffi::webkit_web_context_get_cache_model(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_get_cookie_manager")]
  #[doc(alias = "get_cookie_manager")]
  fn cookie_manager(&self) -> Option<CookieManager> {
    unsafe {
      from_glib_none(ffi::webkit_web_context_get_cookie_manager(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_get_favicon_database")]
  #[doc(alias = "get_favicon_database")]
  fn favicon_database(&self) -> Option<FaviconDatabase> {
    unsafe {
      from_glib_none(ffi::webkit_web_context_get_favicon_database(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_get_favicon_database_directory")]
  #[doc(alias = "get_favicon_database_directory")]
  fn favicon_database_directory(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_web_context_get_favicon_database_directory(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  #[doc(alias = "webkit_web_context_get_geolocation_manager")]
  #[doc(alias = "get_geolocation_manager")]
  fn geolocation_manager(&self) -> Option<GeolocationManager> {
    unsafe {
      from_glib_none(ffi::webkit_web_context_get_geolocation_manager(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_get_plugins")]
  #[doc(alias = "get_plugins")]
  fn plugins<P: FnOnce(Result<Vec<Plugin>, glib::Error>) + 'static>(
    &self,
    cancellable: Option<&impl IsA<gio::Cancellable>>,
    callback: P,
  ) {
    let main_context = glib::MainContext::ref_thread_default();
    let is_main_context_owner = main_context.is_owner();
    let has_acquired_main_context = (!is_main_context_owner)
      .then(|| main_context.acquire().ok())
      .flatten();
    assert!(
      is_main_context_owner || has_acquired_main_context.is_some(),
      "Async operations only allowed if the thread is owning the MainContext"
    );

    let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
      Box_::new(glib::thread_guard::ThreadGuard::new(callback));
    unsafe extern "C" fn plugins_trampoline<
      P: FnOnce(Result<Vec<Plugin>, glib::Error>) + 'static,
    >(
      _source_object: *mut glib::gobject_ffi::GObject,
      res: *mut gio::ffi::GAsyncResult,
      user_data: glib::ffi::gpointer,
    ) {
      let mut error = std::ptr::null_mut();
      let ret =
        ffi::webkit_web_context_get_plugins_finish(_source_object as *mut _, res, &mut error);
      let result = if error.is_null() {
        Ok(FromGlibPtrContainer::from_glib_full(ret))
      } else {
        Err(from_glib_full(error))
      };
      let callback: Box_<glib::thread_guard::ThreadGuard<P>> = Box_::from_raw(user_data as *mut _);
      let callback: P = callback.into_inner();
      callback(result);
    }
    let callback = plugins_trampoline::<P>;
    unsafe {
      ffi::webkit_web_context_get_plugins(
        self.as_ref().to_glib_none().0,
        cancellable.map(|p| p.as_ref()).to_glib_none().0,
        Some(callback),
        Box_::into_raw(user_data) as *mut _,
      );
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]

  fn plugins_future(
    &self,
  ) -> Pin<Box_<dyn std::future::Future<Output = Result<Vec<Plugin>, glib::Error>> + 'static>> {
    Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
      obj.plugins(Some(cancellable), move |res| {
        send.resolve(res);
      });
    }))
  }

  #[cfg_attr(feature = "v2_40", deprecated = "Since 2.40")]
  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_get_process_model")]
  #[doc(alias = "get_process_model")]
  fn process_model(&self) -> ProcessModel {
    unsafe {
      from_glib(ffi::webkit_web_context_get_process_model(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  #[doc(alias = "webkit_web_context_get_sandbox_enabled")]
  #[doc(alias = "get_sandbox_enabled")]
  fn is_sandbox_enabled(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_web_context_get_sandbox_enabled(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_get_security_manager")]
  #[doc(alias = "get_security_manager")]
  fn security_manager(&self) -> Option<SecurityManager> {
    unsafe {
      from_glib_none(ffi::webkit_web_context_get_security_manager(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_get_spell_checking_enabled")]
  #[doc(alias = "get_spell_checking_enabled")]
  fn is_spell_checking_enabled(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_web_context_get_spell_checking_enabled(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_get_spell_checking_languages")]
  #[doc(alias = "get_spell_checking_languages")]
  fn spell_checking_languages(&self) -> Vec<glib::GString> {
    unsafe {
      FromGlibPtrContainer::from_glib_none(ffi::webkit_web_context_get_spell_checking_languages(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_38")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_38")))]
  #[doc(alias = "webkit_web_context_get_time_zone_override")]
  #[doc(alias = "get_time_zone_override")]
  fn time_zone_override(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_web_context_get_time_zone_override(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_get_tls_errors_policy")]
  #[doc(alias = "get_tls_errors_policy")]
  fn tls_errors_policy(&self) -> TLSErrorsPolicy {
    unsafe {
      from_glib(ffi::webkit_web_context_get_tls_errors_policy(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  #[doc(alias = "webkit_web_context_get_use_system_appearance_for_scrollbars")]
  #[doc(alias = "get_use_system_appearance_for_scrollbars")]
  fn uses_system_appearance_for_scrollbars(&self) -> bool {
    unsafe {
      from_glib(
        ffi::webkit_web_context_get_use_system_appearance_for_scrollbars(
          self.as_ref().to_glib_none().0,
        ),
      )
    }
  }

  #[cfg_attr(feature = "v2_26", deprecated = "Since 2.26")]
  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_get_web_process_count_limit")]
  #[doc(alias = "get_web_process_count_limit")]
  fn web_process_count_limit(&self) -> u32 {
    unsafe { ffi::webkit_web_context_get_web_process_count_limit(self.as_ref().to_glib_none().0) }
  }

  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  #[doc(alias = "webkit_web_context_get_website_data_manager")]
  #[doc(alias = "get_website_data_manager")]
  fn website_data_manager(&self) -> Option<WebsiteDataManager> {
    unsafe {
      from_glib_none(ffi::webkit_web_context_get_website_data_manager(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  #[doc(alias = "webkit_web_context_initialize_notification_permissions")]
  fn initialize_notification_permissions(
    &self,
    allowed_origins: &[&SecurityOrigin],
    disallowed_origins: &[&SecurityOrigin],
  ) {
    unsafe {
      ffi::webkit_web_context_initialize_notification_permissions(
        self.as_ref().to_glib_none().0,
        allowed_origins.to_glib_none().0,
        disallowed_origins.to_glib_none().0,
      );
    }
  }

  #[cfg(feature = "v2_18")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_18")))]
  #[doc(alias = "webkit_web_context_is_automation_allowed")]
  fn is_automation_allowed(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_web_context_is_automation_allowed(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  #[doc(alias = "webkit_web_context_is_ephemeral")]
  fn is_ephemeral(&self) -> bool {
    unsafe {
      from_glib(ffi::webkit_web_context_is_ephemeral(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[doc(alias = "webkit_web_context_prefetch_dns")]
  fn prefetch_dns(&self, hostname: &str) {
    unsafe {
      ffi::webkit_web_context_prefetch_dns(
        self.as_ref().to_glib_none().0,
        hostname.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_web_context_register_uri_scheme")]
  fn register_uri_scheme<P: Fn(&URISchemeRequest) + 'static>(&self, scheme: &str, callback: P) {
    let callback_data: Box_<P> = Box_::new(callback);
    unsafe extern "C" fn callback_func<P: Fn(&URISchemeRequest) + 'static>(
      request: *mut ffi::WebKitURISchemeRequest,
      user_data: glib::ffi::gpointer,
    ) {
      let request = from_glib_borrow(request);
      let callback: &P = &*(user_data as *mut _);
      (*callback)(&request)
    }
    let callback = Some(callback_func::<P> as _);
    unsafe extern "C" fn user_data_destroy_func_func<P: Fn(&URISchemeRequest) + 'static>(
      data: glib::ffi::gpointer,
    ) {
      let _callback: Box_<P> = Box_::from_raw(data as *mut _);
    }
    let destroy_call4 = Some(user_data_destroy_func_func::<P> as _);
    let super_callback0: Box_<P> = callback_data;
    unsafe {
      ffi::webkit_web_context_register_uri_scheme(
        self.as_ref().to_glib_none().0,
        scheme.to_glib_none().0,
        callback,
        Box_::into_raw(super_callback0) as *mut _,
        destroy_call4,
      );
    }
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  #[doc(alias = "webkit_web_context_send_message_to_all_extensions")]
  fn send_message_to_all_extensions(&self, message: &impl IsA<UserMessage>) {
    unsafe {
      ffi::webkit_web_context_send_message_to_all_extensions(
        self.as_ref().to_glib_none().0,
        message.as_ref().to_glib_none().0,
      );
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_set_additional_plugins_directory")]
  fn set_additional_plugins_directory(&self, directory: &str) {
    unsafe {
      ffi::webkit_web_context_set_additional_plugins_directory(
        self.as_ref().to_glib_none().0,
        directory.to_glib_none().0,
      );
    }
  }

  #[cfg(feature = "v2_18")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_18")))]
  #[doc(alias = "webkit_web_context_set_automation_allowed")]
  fn set_automation_allowed(&self, allowed: bool) {
    unsafe {
      ffi::webkit_web_context_set_automation_allowed(
        self.as_ref().to_glib_none().0,
        allowed.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_web_context_set_cache_model")]
  fn set_cache_model(&self, cache_model: CacheModel) {
    unsafe {
      ffi::webkit_web_context_set_cache_model(
        self.as_ref().to_glib_none().0,
        cache_model.into_glib(),
      );
    }
  }

  #[cfg_attr(feature = "v2_10", deprecated = "Since 2.10")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_set_disk_cache_directory")]
  fn set_disk_cache_directory(&self, directory: &str) {
    unsafe {
      ffi::webkit_web_context_set_disk_cache_directory(
        self.as_ref().to_glib_none().0,
        directory.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_web_context_set_favicon_database_directory")]
  fn set_favicon_database_directory(&self, path: Option<&str>) {
    unsafe {
      ffi::webkit_web_context_set_favicon_database_directory(
        self.as_ref().to_glib_none().0,
        path.to_glib_none().0,
      );
    }
  }

  #[doc(alias = "webkit_web_context_set_preferred_languages")]
  fn set_preferred_languages(&self, languages: &[&str]) {
    unsafe {
      ffi::webkit_web_context_set_preferred_languages(
        self.as_ref().to_glib_none().0,
        languages.to_glib_none().0,
      );
    }
  }

  #[cfg_attr(feature = "v2_40", deprecated = "Since 2.40")]
  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_set_process_model")]
  fn set_process_model(&self, process_model: ProcessModel) {
    unsafe {
      ffi::webkit_web_context_set_process_model(
        self.as_ref().to_glib_none().0,
        process_model.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_26")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_26")))]
  #[doc(alias = "webkit_web_context_set_sandbox_enabled")]
  fn set_sandbox_enabled(&self, enabled: bool) {
    unsafe {
      ffi::webkit_web_context_set_sandbox_enabled(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_web_context_set_spell_checking_enabled")]
  fn set_spell_checking_enabled(&self, enabled: bool) {
    unsafe {
      ffi::webkit_web_context_set_spell_checking_enabled(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_web_context_set_spell_checking_languages")]
  fn set_spell_checking_languages(&self, languages: &[&str]) {
    unsafe {
      ffi::webkit_web_context_set_spell_checking_languages(
        self.as_ref().to_glib_none().0,
        languages.to_glib_none().0,
      );
    }
  }

  #[cfg_attr(feature = "v2_32", deprecated = "Since 2.32")]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_set_tls_errors_policy")]
  fn set_tls_errors_policy(&self, policy: TLSErrorsPolicy) {
    unsafe {
      ffi::webkit_web_context_set_tls_errors_policy(
        self.as_ref().to_glib_none().0,
        policy.into_glib(),
      );
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  #[doc(alias = "webkit_web_context_set_use_system_appearance_for_scrollbars")]
  fn set_use_system_appearance_for_scrollbars(&self, enabled: bool) {
    unsafe {
      ffi::webkit_web_context_set_use_system_appearance_for_scrollbars(
        self.as_ref().to_glib_none().0,
        enabled.into_glib(),
      );
    }
  }

  #[doc(alias = "webkit_web_context_set_web_extensions_directory")]
  fn set_web_extensions_directory(&self, directory: &str) {
    unsafe {
      ffi::webkit_web_context_set_web_extensions_directory(
        self.as_ref().to_glib_none().0,
        directory.to_glib_none().0,
      );
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "webkit_web_context_set_web_extensions_initialization_user_data")]
  fn set_web_extensions_initialization_user_data(&self, user_data: &glib::Variant) {
    unsafe {
      ffi::webkit_web_context_set_web_extensions_initialization_user_data(
        self.as_ref().to_glib_none().0,
        user_data.to_glib_none().0,
      );
    }
  }

  #[cfg_attr(feature = "v2_26", deprecated = "Since 2.26")]
  #[cfg(feature = "v2_10")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_10")))]
  #[allow(deprecated)]
  #[doc(alias = "webkit_web_context_set_web_process_count_limit")]
  fn set_web_process_count_limit(&self, limit: u32) {
    unsafe {
      ffi::webkit_web_context_set_web_process_count_limit(self.as_ref().to_glib_none().0, limit);
    }
  }

  #[cfg_attr(feature = "v2_10", deprecated = "Since 2.10")]
  #[cfg(feature = "v2_8")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_8")))]
  #[doc(alias = "local-storage-directory")]
  fn local_storage_directory(&self) -> Option<glib::GString> {
    ObjectExt::property(self.as_ref(), "local-storage-directory")
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  #[doc(alias = "process-swap-on-cross-site-navigation-enabled")]
  fn is_process_swap_on_cross_site_navigation_enabled(&self) -> bool {
    ObjectExt::property(
      self.as_ref(),
      "process-swap-on-cross-site-navigation-enabled",
    )
  }

  #[cfg(feature = "v2_18")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_18")))]
  #[doc(alias = "automation-started")]
  fn connect_automation_started<F: Fn(&Self, &AutomationSession) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn automation_started_trampoline<
      P: IsA<WebContext>,
      F: Fn(&P, &AutomationSession) + 'static,
    >(
      this: *mut ffi::WebKitWebContext,
      session: *mut ffi::WebKitAutomationSession,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(
        WebContext::from_glib_borrow(this).unsafe_cast_ref(),
        &from_glib_borrow(session),
      )
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"automation-started\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          automation_started_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[doc(alias = "download-started")]
  fn connect_download_started<F: Fn(&Self, &Download) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn download_started_trampoline<
      P: IsA<WebContext>,
      F: Fn(&P, &Download) + 'static,
    >(
      this: *mut ffi::WebKitWebContext,
      download: *mut ffi::WebKitDownload,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(
        WebContext::from_glib_borrow(this).unsafe_cast_ref(),
        &from_glib_borrow(download),
      )
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"download-started\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          download_started_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_16")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_16")))]
  #[doc(alias = "initialize-notification-permissions")]
  fn connect_initialize_notification_permissions<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn initialize_notification_permissions_trampoline<
      P: IsA<WebContext>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitWebContext,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(WebContext::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"initialize-notification-permissions\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          initialize_notification_permissions_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_4")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_4")))]
  #[doc(alias = "initialize-web-extensions")]
  fn connect_initialize_web_extensions<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn initialize_web_extensions_trampoline<
      P: IsA<WebContext>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitWebContext,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(WebContext::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"initialize-web-extensions\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          initialize_web_extensions_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_28")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_28")))]
  #[doc(alias = "user-message-received")]
  fn connect_user_message_received<F: Fn(&Self, &UserMessage) -> bool + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn user_message_received_trampoline<
      P: IsA<WebContext>,
      F: Fn(&P, &UserMessage) -> bool + 'static,
    >(
      this: *mut ffi::WebKitWebContext,
      message: *mut ffi::WebKitUserMessage,
      f: glib::ffi::gpointer,
    ) -> glib::ffi::gboolean {
      let f: &F = &*(f as *const F);
      f(
        WebContext::from_glib_borrow(this).unsafe_cast_ref(),
        &from_glib_borrow(message),
      )
      .into_glib()
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"user-message-received\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          user_message_received_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }

  #[cfg(feature = "v2_30")]
  #[cfg_attr(docsrs, doc(cfg(feature = "v2_30")))]
  #[doc(alias = "use-system-appearance-for-scrollbars")]
  fn connect_use_system_appearance_for_scrollbars_notify<F: Fn(&Self) + 'static>(
    &self,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn notify_use_system_appearance_for_scrollbars_trampoline<
      P: IsA<WebContext>,
      F: Fn(&P) + 'static,
    >(
      this: *mut ffi::WebKitWebContext,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(WebContext::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::use-system-appearance-for-scrollbars\0".as_ptr() as *const _,
        Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
          notify_use_system_appearance_for_scrollbars_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }
}

impl<O: IsA<WebContext>> WebContextExt for O {}
