use crate::inc::inc::BigFloatInc;

// e^x, x = 0.000..0.999
pub(crate) const EXP_VALUES: [BigFloatInc; 1000] = [
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [762, 1563, 5831, 9930, 5753, 6805, 3416, 6708, 16, 5, 1001],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2624, 7141, 6994, 7315, 958, 5558, 2667, 4000, 133, 20, 1002],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8727, 5331, 20, 3489, 4091, 1293, 260, 3377, 450, 45, 1003],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6796, 6786, 6225, 3258, 7975, 5880, 8723, 7341, 1067, 80, 1004],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8755, 734, 6858, 1240, 6241, 8356, 633, 9401, 2085, 125, 1005],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3970, 7663, 1480, 738, 4542, 5558, 8648, 4064, 3605, 180, 1006],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6270, 7260, 3738, 9413, 31, 3160, 5552, 6848, 5726, 245, 1007],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2482, 7461, 3184, 6086, 3614, 7207, 4311, 4273, 8550, 320, 1008],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7451, 4057, 7427, 3118, 481, 6257, 8140, 3867, 2177, 406, 1009],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3622, 3807, 6003, 9028, 5456, 4216, 575, 4168, 6708, 501, 1010],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4549, 5717, 6670, 6227, 683, 3988, 5560, 4719, 2244, 607, 1011],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9679, 213, 6970, 9099, 4178, 2016, 7543, 6077, 8886, 722, 1012],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7716, 6692, 9716, 8045, 8812, 3841, 1580, 9809, 6735, 848, 1013],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9786, 7563, 1455, 5630, 2260, 759, 3453, 8492, 5893, 984, 1014],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [976, 1913, 8868, 1564, 9497, 7683, 9792, 5718, 6461, 1130, 1015],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6703, 5463, 730, 4009, 412, 2327, 8217, 6094, 8540, 1286, 1016],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4527, 8344, 3540, 5496, 6138, 5779, 7476, 5240, 2232, 1453, 1017],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7137, 3529, 8618, 2803, 8696, 4608, 7609, 9793, 7638, 1629, 1018],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3173, 5615, 8784, 1203, 9580, 4566, 109, 7408, 4861, 1816, 1019],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5090, 5303, 5143, 4831, 3920, 6014, 8101, 6755, 4002, 2013, 1020],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5302, 8704, 617, 6358, 7876, 1159, 6529, 7528, 5163, 2220, 1021],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4799, 8069, 8473, 792, 7933, 3217, 2350, 438, 8447, 2437, 1022],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8502, 5246, 2903, 56, 1791, 7587, 4745, 7217, 3954, 2665, 1023],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1557, 3078, 6742, 6983, 1566, 5151, 5335, 621, 1789, 2903, 1024],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1781, 4881, 602, 9643, 1029, 7802, 8406, 4428, 2052, 3151, 1025],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6861, 589, 228, 9292, 9637, 6292, 1151, 3442, 4847, 3409, 1026],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4904, 4236, 6937, 7966, 7142, 517, 3915, 3489, 276, 3678, 1027],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2480, 8248, 1953, 4603, 3576, 2323, 453, 1425, 8442, 3956, 1028],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2284, 6210, 1652, 1746, 440, 956, 8202, 5130, 9447, 4245, 1029],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [251, 2905, 9813, 8311, 9953, 1243, 8556, 3516, 3395, 4545, 1030],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [691, 9907, 7485, 7555, 246, 4620, 7157, 6522, 388, 4855, 1031],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5906, 5055, 3804, 3351, 5400, 3086, 4195, 5118, 530, 5175, 1032],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3230, 845, 4839, 2143, 282, 6226, 4715, 1305, 3924, 5505, 1033],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1332, 5190, 5326, 2478, 1142, 1360, 8941, 8117, 672, 5846, 1034],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2106, 3093, 2886, 8881, 3971, 6960, 2601, 9623, 879, 6197, 1035],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1342, 5432, 9279, 2020, 3661, 9414, 7274, 923, 4649, 6558, 1036],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5662, 9273, 1642, 2620, 8021, 3249, 737, 8157, 2083, 6930, 1037],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3967, 3840, 1789, 2410, 1774, 4921, 7325, 8497, 3287, 7312, 1038],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6804, 2501, 7067, 1634, 6649, 261, 8308, 157, 8365, 7704, 1039],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9770, 4082, 5474, 9168, 4757, 5704, 2267, 2388, 7419, 8107, 1040],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1610, 2680, 4397, 8249, 3463, 3377, 5493, 5479, 554, 8521, 1041],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6119, 7456, 256, 8138, 993, 174, 2384, 763, 7875, 8944, 1042],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6235, 4277, 9367, 9728, 3084, 907, 5861, 612, 9485, 9378, 1043],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7571, 403, 2429, 1247, 1997, 5646, 7792, 8443, 5488, 9823, 1044],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5824, 3034, 352, 8689, 264, 1344, 9427, 8716, 5990, 278, 1046],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4476, 4805, 1759, 4613, 2605, 7859, 1838, 6937, 1095, 744, 1047],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8855, 9305, 6782, 8273, 442, 8475, 6381, 9655, 907, 1220, 1048],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8230, 5638, 2106, 9909, 4552, 5021, 5156, 4470, 5532, 1706, 1049],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2149, 5765, 3053, 2288, 2382, 7705, 1484, 28, 5074, 2203, 1050],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8213, 174, 4522, 3356, 7636, 9751, 396, 6024, 9637, 2710, 1051],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8284, 1137, 8415, 5054, 787, 6964, 9128, 3203, 9328, 3228, 1052],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6785, 869, 5718, 5090, 194, 2304, 7628, 3364, 4251, 3757, 1053],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2971, 5475, 1454, 645, 4582, 5600, 9074, 9355, 4511, 4296, 1054],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2194, 5317, 5435, 5722, 8676, 8489, 405, 5080, 215, 4846, 1055],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3344, 9, 6120, 7070, 4847, 4694, 2858, 5494, 1467, 5406, 1056],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8246, 4905, 4269, 7370, 4658, 5743, 2516, 6611, 8373, 5976, 1057],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8108, 1914, 2739, 8688, 5282, 2242, 872, 5500, 1039, 6558, 1058],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6780, 802, 4146, 4034, 6798, 797, 5396, 287, 9571, 7149, 1059],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9952, 2909, 4840, 282, 7432, 6698, 118, 159, 4074, 7752, 1060],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2604, 8428, 7232, 1683, 4877, 2468, 6222, 5359, 4654, 8365, 1061],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7910, 9212, 8860, 9771, 2872, 2383, 2643, 7195, 1418, 8989, 1062],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4546, 7782, 1466, 2608, 3289, 3071, 6685, 8033, 4472, 9623, 1063],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8453, 5118, 2799, 4071, 5023, 294, 4643, 1305, 3923, 268, 1065],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6887, 808, 3898, 2267, 2077, 2020, 2436, 1505, 9876, 923, 1066],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6841, 5962, 1462, 5126, 4244, 7889, 6254, 4192, 2438, 1590, 1067],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7217, 1548, 4859, 877, 4904, 5187, 3214, 5993, 1716, 2267, 1068],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5013, 5085, 6727, 1374, 1478, 1424, 2023, 4600, 7817, 2954, 1069],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [29, 4337, 1573, 7157, 5181, 3629, 3657, 8774, 847, 3653, 1070],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [86, 572, 4738, 4740, 7756, 4472, 2050, 8346, 914, 4362, 1071],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9590, 5574, 1460, 8891, 3949, 5310, 4790, 4216, 8125, 5081, 1072],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1261, 3077, 9211, 5602, 9570, 6270, 3829, 8357, 2586, 5812, 1073],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [994, 2544, 2999, 5147, 6020, 3483, 6203, 3813, 4406, 6553, 1074],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3848, 7061, 9986, 8936, 3276, 3557, 4761, 4703, 3691, 7305, 1075],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [869, 4060, 3620, 9026, 4367, 5418, 8908, 6219, 549, 8068, 1076],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3070, 6447, 5860, 4888, 5461, 9613, 5356, 4631, 5088, 8841, 1077],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2550, 4024, 6318, 8666, 6759, 5185, 8888, 7283, 7415, 9625, 1078],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9562, 6680, 6659, 7403, 468, 4231, 3128, 2600, 7639, 420, 1080],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9943, 2734, 5079, 8830, 3186, 4244, 1329, 83, 5867, 1226, 1081],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1117, 5187, 6664, 6132, 1139, 8360, 7166, 314, 2207, 2043, 1082],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7136, 198, 8850, 6748, 7758, 3598, 5544, 4958, 6767, 2870, 1083],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [969, 8779, 4805, 677, 4191, 7224, 3410, 6760, 9656, 3708, 1084],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9778, 7029, 9505, 4996, 4400, 1323, 587, 9549, 982, 4558, 1085],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7445, 5440, 1501, 3354, 7607, 5711, 605, 8238, 854, 5418, 1086],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8188, 8432, 6309, 2047, 1896, 9279, 1557, 8826, 9380, 6288, 1087],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5992, 9134, 3114, 8046, 3904, 9879, 6955, 8398, 6669, 7170, 1088],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [872, 2578, 3661, 8845, 592, 2874, 6602, 5128, 2830, 8063, 1089],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5481, 9406, 9278, 9482, 176, 8440, 7471, 8277, 7971, 8966, 1090],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7226, 4030, 7621, 8333, 403, 7748, 4604, 8197, 2202, 9881, 1091],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1596, 5316, 3655, 470, 3425, 8122, 2009, 6330, 5632, 806, 1093],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5199, 1846, 8601, 5448, 7623, 7289, 3578, 5210, 8370, 1742, 1094],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5954, 4369, 4852, 5347, 7835, 6827, 4011, 8465, 525, 2690, 1095],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5586, 2328, 3515, 8770, 6501, 4920, 9753, 816, 2208, 3648, 1096],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6224, 7987, 3264, 7339, 9376, 8532, 9940, 8081, 3526, 4617, 1097],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6334, 1690, 4069, 2943, 515, 5110, 7360, 7173, 4591, 5597, 1098],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7463, 9982, 6359, 6708, 2357, 3915, 9418, 6102, 5512, 6588, 1099],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8607, 4140, 4985, 4303, 7822, 7112, 9119, 3978, 6399, 7590, 1100],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8402, 5376, 7388, 6815, 2420, 707, 6060, 1010, 7362, 8603, 1101],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2212, 6791, 6665, 2037, 5500, 5448, 7427, 8507, 8510, 9627, 1102],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8067, 1267, 2326, 7589, 828, 7813, 9015, 8881, 9955, 662, 1104],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5472, 8224, 4666, 4902, 7826, 1170, 6248, 5647, 1807, 1709, 1105],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [751, 9996, 2765, 1698, 5859, 7248, 5212, 3423, 4176, 2766, 1106],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9203, 1450, 1376, 218, 5107, 8000, 3708, 7933, 7172, 3834, 1107],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4551, 7486, 8754, 9139, 8627, 7994, 2303, 6007, 907, 4914, 1108],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5985, 9056, 6117, 8819, 1338, 7429, 5401, 5582, 5491, 6004, 1109],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8038, 749, 454, 2272, 2746, 5883, 2322, 5705, 1035, 7106, 1110],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5801, 8750, 6520, 8139, 1361, 6922, 8392, 6530, 7650, 8218, 1111],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8901, 1219, 1705, 6819, 9851, 3657, 6046, 9325, 5447, 9342, 1112],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1748, 5589, 9904, 6921, 1072, 5384, 5938, 6467, 4538, 477, 1114],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7269, 9896, 8648, 6354, 6263, 5390, 8068, 1447, 5034, 1623, 1115],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8239, 9176, 8389, 529, 7769, 73, 2915, 8871, 7045, 2780, 1116],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1976, 5381, 5433, 9558, 9786, 9449, 2581, 4458, 685, 3949, 1117],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2745, 5087, 1665, 6767, 1745, 9186, 1955, 5045, 6064, 5128, 1118],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7271, 1537, 6422, 2495, 30, 4258, 9874, 8585, 3294, 6319, 1119],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2377, 9176, 117, 9929, 4894, 4347, 305, 4153, 2488, 7521, 1120],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5594, 8330, 7170, 3661, 516, 1092, 3538, 1938, 3757, 8734, 1121],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4001, 418, 9116, 6827, 7258, 7296, 7384, 3254, 7213, 9958, 1122],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [551, 3341, 9413, 8953, 6344, 8221, 8393, 536, 2969, 1194, 1124],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5170, 4983, 1301, 4214, 8245, 5056, 3074, 7342, 1136, 2441, 1125],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8866, 2549, 1205, 8509, 7219, 696, 9132, 8352, 1828, 3699, 1126],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2865, 734, 4847, 3748, 5569, 7926, 6714, 9375, 5157, 4968, 1127],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2181, 8800, 3655, 8917, 2281, 133, 9672, 7343, 1236, 6249, 1128],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4462, 5413, 7709, 9951, 1876, 4653, 6823, 318, 178, 7541, 1129],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2926, 5125, 822, 4150, 384, 8870, 3239, 7489, 2094, 8844, 1130],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2518, 2122, 6131, 9820, 6516, 9174, 1534, 9175, 7099, 158, 1132],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5031, 2565, 9387, 8117, 7227, 2900, 3168, 6826, 5306, 1484, 1133],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7914, 1922, 5005, 1565, 7971, 3348, 9760, 3024, 6828, 2821, 1134],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8090, 2717, 9702, 2609, 9117, 8011, 4417, 1486, 1778, 4170, 1135],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7778, 5980, 3401, 5715, 1103, 116, 3071, 7060, 269, 5530, 1136],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [707, 2721, 148, 7993, 2037, 3589, 5822, 5731, 2416, 6901, 1137],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6522, 8883, 6425, 6189, 2602, 1571, 8306, 4621, 8332, 8283, 1138],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7401, 1136, 3886, 2028, 4247, 8580, 3059, 1990, 8131, 9677, 1139],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2846, 8959, 1658, 3433, 7787, 6447, 906, 7235, 1926, 1083, 1141],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8746, 4329, 3750, 6070, 673, 4135, 2349, 894, 9833, 2499, 1142],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7257, 4461, 3329, 7930, 2325, 1549, 8976, 4646, 1964, 3928, 1143],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3124, 4339, 1832, 9352, 8071, 7467, 4876, 1314, 8435, 5367, 1144],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2781, 2547, 782, 1983, 3371, 1689, 8071, 4861, 9359, 6818, 1145],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2220, 4836, 2122, 2666, 1142, 1523, 1949, 398, 4852, 8281, 1146],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [850, 5517, 2947, 2184, 6162, 2732, 6721, 4178, 5027, 9755, 1147],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2013, 412, 7095, 4156, 1645, 5047, 881, 3605, 0, 1241, 1149],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8898, 3977, 3615, 6211, 4257, 2356, 2681, 7227, 9885, 2737, 1150],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6851, 9721, 5213, 3837, 4967, 7702, 1614, 4744, 4798, 4246, 1151],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3280, 5793, 3053, 7085, 4284, 3184, 9916, 7004, 4853, 5766, 1152],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [377, 2661, 2610, 1522, 1586, 4890, 4068, 6010, 166, 7298, 1153],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1867, 1672, 3503, 7599, 9375, 2970, 6322, 4913, 852, 8841, 1154],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4218, 6318, 9398, 6828, 4482, 6973, 6228, 8021, 7026, 395, 1156],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2801, 7307, 7361, 8947, 9348, 6544, 2181, 796, 8805, 1961, 1157],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1972, 5214, 4652, 1539, 7714, 7626, 2972, 9855, 6302, 3539, 1158],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9026, 832, 313, 2437, 160, 4252, 9357, 2973, 9636, 5128, 1159],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2528, 7948, 4452, 5623, 6132, 6062, 5632, 9085, 8920, 6729, 1160],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5294, 6175, 5517, 3316, 214, 1662, 1226, 8283, 4272, 8342, 1161],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3393, 9414, 743, 466, 1587, 7919, 2297, 1820, 5808, 9966, 1162],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1738, 2799, 3284, 3024, 6770, 5339, 3351, 2112, 3643, 1602, 1164],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9070, 1171, 7102, 8085, 6894, 9620, 8859, 2737, 7894, 3249, 1165],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8646, 8526, 3733, 2336, 1924, 9505, 4899, 8439, 8677, 4908, 1166],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4011, 5313, 9590, 5225, 5404, 1052, 800, 5125, 6110, 6579, 1167],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8394, 6066, 4920, 4879, 4483, 8441, 799, 9869, 308, 8262, 1168],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6690, 4297, 2293, 8021, 1108, 1422, 5720, 913, 1390, 9956, 1169],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5425, 365, 24, 95, 1479, 9534, 4645, 7669, 9470, 1661, 1171],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6872, 2571, 992, 8349, 1989, 3207, 6620, 717, 4668, 3379, 1172],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4794, 368, 6579, 8919, 1086, 1861, 2350, 1810, 7099, 5108, 1173],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2167, 8098, 5832, 8906, 7605, 9122, 5923, 3871, 6881, 6849, 1174],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9713, 4135, 8488, 6101, 7352, 5276, 6540, 999, 4132, 8602, 1175],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4995, 406, 4207, 2413, 847, 7067, 250, 8467, 8968, 366, 1177],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6882, 9407, 6621, 2140, 6331, 4967, 1709, 2722, 1509, 2143, 1178],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8747, 1462, 6812, 3110, 3309, 8038, 5940, 1390, 1871, 3931, 1179],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8684, 9399, 4153, 7291, 3075, 6485, 113, 3276, 172, 5731, 1180],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8743, 1946, 703, 7868, 3849, 2042, 5330, 8361, 6530, 7542, 1181],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9076, 8024, 6044, 1916, 9325, 6291, 8425, 7810, 1064, 9366, 1182],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6964, 6608, 729, 1743, 616, 7043, 3779, 3969, 3892, 1201, 1184],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6298, 4533, 5944, 3692, 2764, 2885, 5140, 365, 5132, 3048, 1185],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6514, 1138, 2982, 778, 8152, 6035, 7458, 1711, 4902, 4907, 1186],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8182, 8711, 6576, 4850, 350, 3599, 8736, 3905, 3321, 6778, 1187],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [968, 8450, 9530, 5232, 3115, 7356, 1884, 4032, 508, 8661, 1188],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1449, 3690, 701, 3801, 429, 2205, 6595, 362, 6582, 555, 1190],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5339, 857, 2870, 1397, 4672, 3365, 1222, 2358, 1661, 2462, 1191],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4960, 5161, 9925, 7249, 1195, 2474, 4678, 669, 5865, 4380, 1192],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9090, 858, 2928, 1736, 8761, 2682, 8339, 7138, 9312, 6310, 1193],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3043, 1525, 877, 3384, 6490, 2882, 7964, 4800, 2123, 8253, 1194],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8848, 263, 3369, 3476, 9174, 1170, 5625, 7883, 4416, 207, 1196],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8224, 9868, 7947, 6004, 3973, 7682, 1648, 1810, 6312, 2173, 1197],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9788, 7191, 4052, 7035, 2737, 6902, 6571, 3199, 7929, 4151, 1198],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1292, 5933, 7411, 5804, 5368, 9581, 3105, 9868, 9387, 6141, 1199],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8428, 3601, 3024, 78, 846, 4374, 8117, 830, 808, 8144, 1200],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8989, 2726, 1087, 479, 3732, 9315, 4615, 6301, 2309, 158, 1202],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4572, 1378, 8095, 2650, 5169, 3262, 3757, 7695, 4012, 2184, 1203],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7815, 9397, 4728, 2265, 8587, 7415, 6857, 7629, 6037, 4222, 1204],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8670, 9092, 2972, 6034, 1532, 7042, 7419, 9924, 8504, 6272, 1205],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2542, 7464, 7281, 2041, 6240, 3519, 3170, 9605, 1534, 8335, 1206],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5649, 7597, 8738, 4911, 2765, 6825, 8111, 2901, 5248, 409, 1208],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3459, 8639, 7330, 5542, 9703, 8584, 4582, 7251, 9765, 2495, 1209],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8551, 9522, 6158, 1420, 8725, 5806, 5334, 1299, 5208, 4594, 1210],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8912, 9117, 3164, 1866, 367, 5419, 5615, 4900, 1696, 6705, 1211],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8292, 8761, 1472, 2978, 9723, 9731, 5270, 9119, 9351, 8827, 1212],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5210, 3643, 9516, 9536, 1888, 2947, 853, 6233, 8295, 962, 1214],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1703, 7359, 7679, 5736, 8226, 8832, 7744, 9730, 8648, 3109, 1215],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1198, 9096, 267, 3314, 5727, 9687, 2292, 4316, 533, 5269, 1216],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5372, 6348, 1399, 4480, 2959, 6714, 3956, 5908, 4070, 7440, 1217],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1351, 1127, 2185, 8029, 7306, 1924, 7466, 1642, 9382, 9623, 1218],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1365, 1082, 5708, 106, 9417, 1696, 4994, 9872, 6589, 1819, 1220],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5809, 307, 7417, 6396, 1994, 2107, 8339, 169, 5816, 4027, 1221],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9639, 5247, 3191, 9934, 1292, 6158, 1121, 3327, 7182, 6247, 1222],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2246, 3633, 7365, 8368, 876, 3025, 991, 1358, 811, 8480, 1223],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9628, 1626, 249, 6338, 8448, 9442, 1847, 7499, 6824, 724, 1225],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7804, 8859, 1225, 2638, 7752, 3354, 6073, 6210, 5345, 2981, 1226],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8920, 6001, 1428, 8126, 8790, 9946, 6775, 3177, 6496, 5250, 1227],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8768, 287, 1616, 8780, 818, 189, 48, 5312, 399, 7532, 1228],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7018, 9459, 8521, 9066, 3794, 2006, 7234, 752, 7178, 9825, 1229],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6250, 6920, 9176, 3753, 5205, 4202, 7213, 8867, 6954, 2131, 1231],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7078, 9156, 112, 1559, 400, 3259, 8692, 254, 9853, 4449, 1232],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8530, 6260, 9725, 1562, 5807, 3132, 2511, 6743, 5995, 6780, 1233],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5151, 1402, 234, 3145, 5624, 8173, 3962, 1394, 5506, 9123, 1234],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7840, 8408, 3688, 2333, 3818, 9289, 5121, 8503, 8507, 1478, 1236],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9667, 1941, 7400, 1918, 4491, 3475, 7189, 3600, 5124, 3846, 1237],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1409, 7587, 1285, 9463, 4911, 6837, 2846, 3452, 5479, 6226, 1238],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4100, 8074, 6300, 6463, 6740, 1228, 8624, 6061, 9696, 8618, 1239],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3736, 9724, 2830, 3414, 2214, 4625, 7280, 671, 7900, 1023, 1241],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7632, 8421, 4295, 9359, 3296, 5364, 195, 7764, 213, 3441, 1242],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1153, 2158, 7979, 762, 3036, 368, 9775, 9061, 6761, 5870, 1243],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6440, 610, 6127, 3139, 9609, 7478, 1867, 7531, 7668, 8312, 1244],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7026, 3754, 9624, 9926, 4782, 2026, 8195, 7380, 3058, 767, 1246],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5268, 4037, 8187, 6512, 9749, 7756, 8793, 4064, 3056, 3234, 1247],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1026, 4791, 9222, 3218, 2553, 2243, 4469, 4283, 7786, 5713, 1248],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7829, 8917, 6665, 9349, 2556, 6903, 9263, 5983, 7373, 8205, 1249],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [584, 8239, 5713, 1190, 8652, 1750, 2935, 8362, 1942, 710, 1251],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4530, 2505, 3985, 78, 9159, 5003, 3449, 1864, 1619, 3227, 1252],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1453, 1874, 9066, 2382, 2612, 7674, 9484, 8186, 6527, 5756, 1253],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7209, 9568, 1417, 1450, 9879, 3264, 2948, 279, 6794, 8298, 1254],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9218, 3536, 5277, 2271, 9307, 2699, 1506, 2344, 2543, 853, 1256],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [997, 8758, 3539, 2874, 7850, 4610, 1125, 9839, 3900, 3420, 1257],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2800, 8660, 930, 2190, 2376, 1107, 8628, 9477, 992, 6000, 1258],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9134, 1074, 8391, 2459, 6614, 9155, 4258, 9231, 3944, 8592, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3114, 1676, 6016, 5093, 455, 7692, 4264, 8329, 2882, 1197, 1261],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2409, 1771, 7701, 2324, 9578, 594, 3487, 7261, 7932, 3814, 1262],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [812, 185, 3589, 3005, 4627, 5644, 7966, 7777, 9220, 6444, 1263],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6857, 1368, 2360, 9484, 437, 9593, 7560, 2891, 6873, 9087, 1264],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [144, 3489, 322, 3712, 7054, 9474, 8574, 6879, 1016, 1743, 1266],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [257, 1421, 4271, 4535, 5556, 278, 6403, 5283, 1777, 4411, 1267],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5341, 2233, 6433, 4592, 2971, 9113, 8184, 4910, 9282, 7091, 1268],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5074, 9976, 8842, 4313, 1812, 5989, 5473, 3836, 3658, 9785, 1269],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3427, 1627, 7724, 2277, 1051, 1344, 6916, 1404, 5032, 2491, 1271],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7891, 1776, 2474, 5590, 6601, 440, 947, 8229, 3530, 5210, 1272],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2382, 1677, 5422, 1048, 656, 4761, 8494, 6194, 9281, 7941, 1273],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5352, 8358, 4521, 7642, 491, 527, 5699, 8459, 2411, 686, 1275],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [281, 705, 8548, 3440, 8628, 4471, 6645, 9454, 3048, 3443, 1276],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2587, 1362, 314, 5126, 7498, 6991, 6106, 4886, 1320, 6213, 1277],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [521, 7668, 5167, 6384, 3060, 2804, 2301, 1738, 7354, 8995, 1278],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3316, 6204, 6938, 2053, 3061, 9241, 9662, 8269, 1277, 1791, 1280],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1759, 3198, 9103, 8370, 6929, 2303, 1623, 4021, 3219, 4599, 1281],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7459, 1725, 2842, 5889, 5567, 606, 3407, 9811, 3306, 7420, 1282],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2809, 8336, 3645, 624, 568, 7342, 4840, 7741, 1668, 254, 1284],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8231, 6421, 2080, 791, 3691, 388, 3173, 1195, 8433, 3100, 1285],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8567, 1057, 256, 1095, 8690, 692, 5909, 4840, 3728, 5960, 1286],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7750, 596, 1603, 3963, 8877, 9057, 3656, 4630, 7683, 8832, 1287],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5742, 6577, 6040, 7364, 5094, 1457, 2987, 7804, 426, 1718, 1289],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1009, 1473, 3887, 1968, 43, 3014, 9305, 2889, 2087, 4616, 1290],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4362, 4050, 8484, 6356, 6211, 762, 9737, 9703, 2793, 7527, 1291],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9491, 1243, 8119, 7846, 5931, 5333, 6026, 9353, 2675, 451, 1293],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6467, 7247, 1222, 8194, 3376, 1680, 7447, 4237, 1862, 3388, 1294],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1082, 7365, 3934, 8077, 9610, 8982, 3725, 8048, 482, 6338, 1295],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [900, 8170, 4966, 1788, 3088, 9856, 7979, 5771, 8666, 9300, 1296],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9863, 9994, 8481, 4012, 9295, 8991, 9666, 3689, 6543, 2276, 1298],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2617, 8343, 710, 3975, 4521, 1363, 7547, 9381, 4242, 5265, 1299],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6691, 6873, 9696, 8567, 38, 125, 2660, 1724, 1895, 8267, 1300],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2013, 473, 9460, 5387, 4275, 4332, 1312, 894, 9630, 1281, 1302],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3536, 3249, 9689, 8880, 1852, 6617, 8080, 8368, 7577, 4309, 1303],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7590, 1236, 9626, 8072, 9668, 942, 8825, 6927, 5868, 7350, 1304],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4945, 312, 69, 2630, 1502, 575, 3718, 654, 4633, 404, 1306],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3141, 3509, 454, 5280, 3919, 6393, 284, 4936, 4001, 3471, 1307],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5881, 7345, 8997, 2941, 7565, 5677, 6456, 6466, 4104, 6551, 1308],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7022, 5473, 3240, 6262, 9226, 1498, 3639, 3247, 5073, 9644, 1309],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4151, 5487, 6512, 7670, 1363, 2843, 9791, 4587, 7038, 2750, 1311],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7056, 2113, 3402, 1536, 7109, 5602, 2518, 1108, 131, 5870, 1312],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7009, 4930, 5052, 6570, 44, 4563, 2179, 4739, 4482, 9002, 1313],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6938, 6886, 3838, 261, 9377, 6516, 5004, 8724, 223, 2148, 1315],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5655, 6242, 7732, 7888, 2442, 4638, 6229, 7621, 7486, 5306, 1316],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8975, 4737, 8541, 4536, 7786, 4244, 3239, 7303, 6402, 8478, 1317],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8941, 6337, 6488, 7531, 3369, 83, 8729, 4958, 7103, 1663, 1319],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2291, 4646, 7668, 8881, 5784, 5267, 3873, 9095, 9720, 4861, 1320],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3285, 8318, 2277, 2612, 7661, 2000, 1514, 9539, 4386, 8073, 1321],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8177, 3803, 1858, 364, 1773, 4215, 9356, 7436, 1233, 1298, 1323],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [385, 1899, 4859, 301, 1674, 2260, 3181, 5257, 393, 4536, 1324],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3554, 5821, 3566, 9231, 6, 9771, 69, 6792, 1998, 7787, 1325],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8407, 573, 3895, 5924, 6955, 2850, 1642, 7157, 6181, 1051, 1327],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4750, 4146, 4871, 4921, 2632, 1697, 7307, 2794, 3075, 4329, 1328],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8660, 961, 9186, 4655, 8517, 4808, 7527, 1473, 2812, 7620, 1329],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4593, 1075, 2377, 1510, 4390, 5899, 7097, 2291, 5525, 924, 1331],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6970, 4254, 8630, 2483, 8525, 3657, 8434, 5675, 1347, 4242, 1332],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3370, 1903, 8537, 3480, 248, 4483, 4881, 3384, 412, 7573, 1333],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4563, 5350, 1285, 7852, 5279, 8328, 4026, 8508, 2852, 917, 1335],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7069, 8870, 3659, 755, 5625, 7789, 1033, 5472, 8802, 4274, 1336],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [502, 2953, 3982, 9142, 7102, 565, 1985, 35, 8395, 7645, 1337],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1182, 2558, 4001, 4761, 8935, 5432, 7240, 9293, 1763, 1030, 1339],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3921, 4259, 9089, 8482, 1160, 1858, 4808, 1681, 9043, 4427, 1340],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3677, 7535, 461, 8538, 6963, 3390, 3728, 6971, 366, 7839, 1341],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6619, 7113, 6112, 2907, 8359, 4963, 7471, 6276, 5868, 1263, 1343],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9628, 304, 3572, 7135, 5000, 4240, 7349, 2052, 5683, 4701, 1344],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4256, 9280, 1302, 3271, 7228, 7137, 5939, 8097, 9944, 8152, 1345],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5321, 6589, 659, 3493, 5811, 7663, 523, 9554, 8787, 1617, 1347],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2916, 7349, 960, 3226, 2183, 2201, 6538, 2910, 2347, 5096, 1348],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2997, 378, 733, 3280, 4313, 8374, 1039, 6003, 757, 8588, 1349],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6101, 3817, 2987, 8688, 4701, 8629, 6183, 8015, 4153, 2093, 1351],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8214, 4334, 6079, 3549, 8337, 8667, 2715, 9482, 2670, 5612, 1352],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4277, 5197, 9007, 6277, 9797, 864, 3477, 2288, 6444, 9144, 1353],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6906, 7511, 5751, 8255, 30, 2810, 6923, 9671, 5608, 2690, 1355],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [652, 124, 2453, 985, 4701, 1101, 657, 6224, 300, 6250, 1356],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1077, 6978, 8986, 2450, 7337, 534, 4974, 7892, 654, 9823, 1357],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [774, 7901, 8060, 2548, 1876, 8816, 6421, 1980, 6807, 3409, 1359],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6955, 4889, 5752, 143, 549, 6940, 1373, 7150, 8893, 7009, 1360],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5231, 594, 2919, 559, 4412, 5363, 9614, 3421, 7050, 623, 1362],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4413, 4435, 2839, 2143, 5187, 6115, 7941, 2177, 1413, 4251, 1363],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1235, 7489, 2561, 3954, 8430, 976, 3778, 6161, 2118, 7892, 1364],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6543, 1507, 9682, 3640, 9411, 5864, 8800, 9479, 9302, 1546, 1366],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4665, 1711, 8733, 5205, 4448, 1562, 2580, 7605, 3102, 5215, 1367],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5647, 287, 8220, 603, 1806, 924, 6237, 7375, 3654, 8897, 1368],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8057, 3497, 6955, 7022, 7625, 2699, 6109, 6996, 1095, 2593, 1370],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6673, 9751, 3183, 3244, 3731, 2108, 7434, 6042, 5562, 6302, 1371],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7111, 4185, 8676, 3703, 5512, 8302, 8044, 5458, 7192, 25, 1373],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6656, 9318, 9253, 7767, 9460, 8857, 2078, 7561, 6122, 3762, 1374],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6374, 1523, 9979, 4348, 1306, 1426, 3702, 6039, 2490, 7513, 1375],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3022, 9259, 4529, 8281, 7067, 2687, 845, 5957, 6433, 1277, 1377],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1726, 2057, 1233, 4914, 707, 4743, 8954, 3753, 8089, 5055, 1378],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1908, 2316, 171, 3142, 3456, 9078, 4755, 7246, 7595, 8847, 1379],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8436, 1842, 4121, 4617, 1246, 8244, 33, 5630, 5090, 2653, 1381],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8756, 3692, 8427, 8162, 8069, 5384, 5422, 9479, 711, 6473, 1382],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6244, 5557, 8944, 3468, 4457, 1756, 4212, 751, 4598, 306, 1384],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2889, 9849, 782, 7012, 1654, 2371, 6168, 2784, 6887, 4153, 1385],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9814, 3125, 1718, 5786, 3450, 9906, 1364, 302, 7718, 8014, 1386],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6371, 9485, 929, 918, 8997, 7016, 4032, 9412, 7228, 1889, 1388],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9801, 6930, 4463, 3550, 1345, 7189, 6418, 7610, 5558, 5778, 1389],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4395, 3688, 1882, 9531, 7804, 4274, 2662, 3780, 2846, 9681, 1390],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2989, 8998, 2512, 7470, 9622, 843, 2684, 8194, 9230, 3597, 1392],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4592, 2036, 3200, 6617, 9864, 5495, 6087, 2516, 4851, 7528, 1393],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7073, 2930, 1356, 6798, 9773, 9266, 6076, 9803, 9846, 1472, 1395],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8801, 9730, 6304, 2332, 5268, 1273, 3387, 4505, 4357, 5431, 1396],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8385, 3390, 7565, 5460, 6637, 3731, 228, 2467, 8522, 9403, 1397],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1718, 9693, 26, 2335, 5884, 6490, 4244, 930, 2481, 3390, 1399],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2812, 6024, 2321, 6116, 7559, 1220, 2486, 8535, 6373, 7390, 1400],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7303, 9867, 5604, 7145, 333, 5396, 5395, 5320, 340, 1405, 1402],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9596, 8552, 5082, 9573, 7939, 6209, 808, 2726, 4521, 5433, 1403],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3436, 7142, 5740, 7222, 9533, 4564, 7968, 3593, 9056, 9475, 1404],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9946, 2969, 6802, 8854, 904, 9278, 1553, 2169, 4086, 3532, 1406],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [554, 908, 6520, 4424, 9386, 1637, 5722, 4102, 9751, 7602, 1407],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1239, 4018, 207, 9339, 6704, 458, 8165, 6450, 6192, 1687, 1409],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9146, 3776, 309, 3220, 5423, 7768, 4179, 7678, 3550, 5786, 1410],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2667, 722, 8275, 3211, 6033, 5274, 753, 7659, 1966, 9899, 1411],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9810, 3974, 4669, 9473, 3161, 1744, 662, 7677, 1581, 4026, 1413],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8020, 7537, 7128, 2195, 766, 1445, 6583, 428, 2537, 8167, 1414],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2256, 1904, 6334, 5269, 7600, 3782, 5222, 23, 4974, 2322, 1416],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9704, 549, 9209, 1638, 5653, 4280, 1455, 1986, 9034, 6491, 1417],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8809, 2836, 7243, 9398, 5661, 7039, 2482, 3257, 4859, 675, 1419],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4879, 937, 7544, 5875, 5233, 8822, 1998, 2195, 2591, 4873, 1420],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2956, 5903, 6394, 9251, 6507, 4902, 4376, 8577, 2371, 9085, 1421],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9470, 9790, 1390, 3788, 1725, 6819, 8863, 3601, 4343, 3311, 1423],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7606, 6608, 390, 5393, 6475, 2181, 3796, 9888, 8647, 7551, 1424],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6033, 2891, 5444, 9143, 1824, 6665, 823, 1480, 5428, 1806, 1426],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4563, 6872, 9653, 9473, 7943, 8338, 9149, 3844, 4826, 6075, 1427],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5136, 2610, 6685, 7050, 3276, 4469, 9787, 3876, 6985, 358, 1429],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7201, 3794, 8808, 3913, 4721, 943, 9827, 9897, 2047, 4656, 1430],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4402, 7048, 2295, 277, 5716, 4450, 6720, 1658, 157, 8968, 1431],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9588, 7663, 1435, 2456, 551, 7569, 2577, 340, 1456, 3294, 1433],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8705, 9937, 7027, 1759, 4661, 6899, 8479, 8555, 6087, 7634, 1434],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3861, 6125, 4960, 8841, 2073, 4387, 8803, 351, 4196, 1989, 1436],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6855, 8699, 8358, 6977, 2634, 1978, 5563, 1209, 5924, 6358, 1437],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8722, 7489, 6024, 1040, 3049, 9751, 2764, 8046, 1415, 742, 1439],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6176, 6389, 3802, 6571, 7226, 7669, 775, 9217, 814, 5140, 1440],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9137, 7736, 7574, 5357, 2843, 1097, 707, 4516, 4265, 9552, 1441],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8660, 5703, 435, 276, 2479, 221, 8813, 5177, 1911, 3979, 1443],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4073, 9562, 5978, 2911, 9120, 3526, 902, 3879, 3897, 8420, 1444],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9635, 8320, 8464, 2612, 7270, 5467, 6765, 4739, 367, 2876, 1446],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8319, 4566, 2961, 5192, 2335, 8475, 4615, 3324, 1466, 7346, 1447],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7952, 3242, 8585, 3471, 2414, 9453, 5544, 6644, 7338, 1830, 1449],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8338, 9054, 18, 295, 8050, 900, 7993, 3158, 8129, 6329, 1450],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6971, 6891, 1063, 7509, 6960, 6808, 2233, 2775, 3983, 843, 1452],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8542, 1242, 3710, 1772, 2205, 3474, 4872, 6852, 5045, 5371, 1453],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8420, 8346, 1850, 9875, 3691, 5379, 3360, 8201, 1461, 9914, 1454],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4932, 2364, 5247, 2600, 4392, 6277, 523, 1086, 3377, 4471, 1456],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6576, 7836, 1745, 6996, 4065, 5633, 9103, 1225, 937, 9043, 1457],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7250, 9998, 9236, 2307, 4765, 563, 6316, 5796, 4287, 3629, 1459],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5851, 9940, 8811, 4741, 3839, 3419, 8422, 3431, 3574, 8230, 1460],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5092, 5141, 2496, 700, 1609, 5163, 5315, 4224, 8943, 2845, 1462],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4123, 5315, 8476, 7182, 2350, 4678, 5121, 9728, 540, 7476, 1463],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9050, 3689, 9662, 1680, 8682, 4162, 8814, 2959, 8513, 2120, 1465],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3958, 8363, 3706, 2125, 902, 752, 4847, 8398, 3006, 6780, 1466],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6931, 882, 279, 301, 4302, 4514, 3795, 1989, 4168, 1454, 1468],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7899, 4857, 728, 9622, 8927, 2969, 3018, 1144, 2144, 6143, 1469],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1057, 4496, 2626, 286, 7741, 2275, 1331, 4743, 7081, 846, 1471],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [397, 4091, 3570, 1613, 585, 5227, 3695, 3135, 9127, 5564, 1472],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4512, 3380, 1740, 2831, 2844, 6218, 5921, 8141, 8428, 297, 1474],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [265, 6353, 1829, 9721, 9137, 3313, 9387, 3054, 5133, 5045, 1475],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2036, 7458, 1089, 5387, 3876, 7574, 5770, 2642, 9388, 9807, 1476],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1734, 4552, 8440, 8979, 1968, 9785, 1797, 3147, 1341, 4585, 1478],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2904, 9393, 7160, 6514, 4450, 4736, 4005, 2288, 1140, 9377, 1479],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4864, 4483, 5993, 2967, 5275, 3200, 3517, 9264, 8932, 4183, 1481],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1010, 4704, 2112, 4649, 6988, 1755, 837, 4753, 4867, 9005, 1482],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2248, 4924, 35, 5447, 4483, 603, 655, 914, 9092, 3841, 1484],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6263, 9696, 1022, 9906, 7516, 9527, 6668, 1389, 1755, 8693, 1485],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6488, 6628, 5828, 309, 4143, 2144, 6421, 1306, 3005, 3559, 1487],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7009, 29, 7959, 3928, 8710, 8588, 6149, 7277, 2990, 8440, 1488],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6812, 7159, 3171, 461, 9548, 6790, 5654, 7402, 1860, 3336, 1490],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2828, 643, 2228, 8372, 2952, 2485, 3178, 1270, 9764, 8246, 1491],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2790, 7310, 6496, 2418, 1579, 8106, 301, 9960, 6849, 3172, 1493],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3913, 2421, 8626, 3082, 6820, 715, 6856, 6042, 3267, 8113, 1494],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4276, 3593, 2041, 1980, 6259, 9114, 5846, 3582, 9166, 3068, 1496],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6478, 4985, 2510, 5560, 8762, 284, 8396, 8138, 4695, 8039, 1497],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9919, 4770, 1658, 2597, 1280, 5313, 8696, 6766, 5, 3025, 1499],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6060, 5481, 5393, 9083, 2910, 4945, 8983, 8019, 5245, 8025, 1500],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5514, 9443, 9260, 7215, 3288, 4921, 4519, 1950, 566, 3041, 1502],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7862, 7715, 7357, 3204, 3845, 1240, 8595, 111, 6117, 8071, 1503],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5308, 5294, 1426, 1671, 1999, 5506, 7544, 5559, 2048, 3117, 1505],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7218, 960, 2017, 2424, 9826, 502, 5776, 2853, 8511, 8177, 1506],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2168, 213, 4250, 8457, 267, 6152, 817, 8058, 5655, 3253, 1508],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3676, 8975, 6957, 2080, 5435, 5999, 8377, 8744, 3632, 8344, 1509],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2715, 1975, 6207, 9225, 3075, 4386, 7420, 3993, 2593, 3450, 1511],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1563, 5228, 2941, 145, 8774, 4449, 5257, 4394, 2688, 8571, 1512],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8905, 5305, 420, 7988, 2963, 7110, 2652, 2048, 4069, 3707, 1514],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5818, 5048, 1089, 5074, 3347, 1190, 8944, 568, 6887, 8858, 1515],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [403, 1122, 5486, 159, 4818, 4821, 7179, 5084, 1293, 4025, 1517],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2210, 9008, 8907, 8547, 500, 8287, 9267, 2239, 7440, 9206, 1518],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8425, 3390, 6112, 622, 9044, 8453, 1145, 196, 5479, 4403, 1520],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9057, 7836, 1737, 3237, 4800, 4944, 7959, 8633, 5561, 9615, 1521],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2828, 3677, 6007, 2429, 9063, 8200, 9260, 8753, 7840, 4842, 1523],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1065, 7201, 3348, 5140, 2038, 9593, 4219, 3279, 2468, 85, 1525],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6462, 8006, 7722, 2020, 6751, 3723, 6852, 6456, 9596, 5342, 1526],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [198, 584, 4749, 3040, 7612, 3079, 1261, 4057, 9378, 615, 1528],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2230, 8132, 9337, 2448, 7891, 5187, 6895, 3378, 1966, 5904, 1529],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7639, 7147, 842, 9738, 1865, 2420, 3822, 3247, 7513, 1207, 1531],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7623, 2624, 8227, 8599, 8948, 4608, 8015, 4018, 6172, 6526, 1532],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7436, 1708, 8053, 6493, 8614, 4617, 6659, 7579, 8096, 1860, 1534],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9951, 578, 1051, 3350, 6486, 7027, 3467, 7349, 3439, 7210, 1535],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2560, 6254, 1584, 9144, 3465, 85, 4017, 8281, 2354, 2575, 1537],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7770, 3336, 1580, 6613, 1329, 1073, 1097, 6865, 4995, 7955, 1538],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7474, 8730, 9730, 7248, 9741, 5248, 75, 1127, 1516, 3351, 1540],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9492, 1812, 1411, 5918, 1175, 8513, 4277, 632, 2070, 8762, 1541],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5501, 5070, 8342, 2039, 1770, 3954, 383, 6487, 6811, 4188, 1543],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2577, 9017, 3328, 3213, 7686, 2428, 3836, 1338, 5895, 9630, 1544],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7452, 1445, 8251, 542, 8069, 7328, 4271, 9377, 9474, 5087, 1546],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2979, 528, 6969, 3674, 7264, 3690, 958, 6340, 7705, 560, 1548],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1665, 802, 3042, 7756, 480, 1801, 8255, 9508, 741, 6049, 1549],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3513, 182, 9572, 4160, 8632, 5452, 1084, 7714, 8738, 1552, 1551],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1753, 8535, 9496, 1916, 9646, 5007, 420, 1336, 1851, 7072, 1552],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1526, 3460, 3972, 7344, 5063, 5419, 8792, 2305, 234, 2607, 1554],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4118, 3487, 8873, 5457, 2318, 9370, 5804, 4107, 4043, 8157, 1555],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3684, 8456, 9890, 8250, 4619, 5681, 3671, 1779, 3434, 3723, 1557],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1702, 7332, 308, 2056, 1927, 3148, 2766, 1915, 8562, 9304, 1558],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1285, 3005, 7587, 8784, 8054, 9955, 7188, 2666, 9583, 4901, 1560],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8535, 3054, 784, 4018, 499, 8834, 346, 3744, 6653, 514, 1562],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8211, 1433, 6191, 8641, 1142, 8104, 551, 6418, 9928, 6142, 1563],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8579, 1517, 9088, 33, 7542, 8774, 6632, 3521, 9565, 1786, 1565],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7224, 7118, 1122, 3721, 6074, 7843, 3564, 9451, 5719, 7446, 1566],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6128, 5702, 1535, 6932, 9774, 7959, 8111, 168, 8549, 3121, 1568],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4403, 9325, 2509, 1636, 5258, 3605, 4487, 3202, 8209, 8812, 1569],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8623, 8631, 655, 6437, 4692, 3949, 29, 7649, 4857, 4519, 1571],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1802, 3018, 4587, 4149, 348, 2535, 891, 4175, 8651, 241, 1573],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2887, 1039, 9375, 5011, 822, 3954, 7748, 5018, 9747, 5979, 1574],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8630, 2185, 9198, 4305, 9604, 7666, 1520, 3991, 8303, 1733, 1576],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1042, 6206, 6754, 7677, 8221, 9124, 9110, 6477, 4476, 7503, 1577],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9788, 1799, 9079, 7705, 7776, 8351, 9157, 9440, 8424, 3288, 1579],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9226, 7614, 1649, 1243, 4260, 6144, 7806, 1419, 306, 9090, 1580],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9992, 3673, 3505, 8798, 4603, 8046, 4493, 2533, 278, 4907, 1582],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2717, 4710, 3168, 4736, 2013, 6256, 7748, 4481, 8499, 739, 1584],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8322, 9366, 6232, 364, 698, 9625, 1009, 547, 5128, 6588, 1585],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8387, 392, 8482, 1072, 1699, 1905, 8459, 5595, 322, 2453, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8055, 483, 1429, 3602, 3100, 8404, 868, 6080, 4241, 8333, 1588],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4386, 7641, 8474, 267, 9485, 1206, 1467, 39, 7044, 4229, 1590],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5201, 7509, 7859, 3551, 7093, 3119, 1818, 7101, 8888, 141, 1592],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7076, 7589, 1819, 6939, 2719, 500, 7719, 8484, 9934, 6069, 1593],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1936, 5519, 8555, 6213, 5977, 5128, 5110, 7000, 341, 2014, 1595],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4026, 4705, 3686, 9660, 6151, 5279, 6006, 7052, 268, 7974, 1596],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4042, 9194, 9812, 5768, 6448, 6156, 4437, 4640, 9875, 3949, 1598],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7157, 551, 5868, 3114, 46, 9845, 2410, 7360, 9321, 9941, 1599],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [88, 420, 1454, 9100, 3950, 4945, 5886, 4406, 8767, 5949, 1601],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [72, 5356, 4853, 2234, 8247, 6046, 768, 6574, 8372, 1973, 1603],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5827, 3606, 6562, 6569, 9944, 3198, 8914, 6258, 8297, 8013, 1604],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4822, 2326, 2844, 6870, 2210, 1544, 4157, 7460, 8702, 4069, 1606],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1279, 3227, 5962, 9042, 1388, 1269, 8347, 5782, 9748, 141, 1608],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5296, 432, 9555, 2329, 5801, 8036, 7406, 8436, 1595, 6230, 1609],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2650, 4456, 9414, 7800, 1938, 4058, 7403, 4240, 4405, 2334, 1611],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3560, 2754, 2175, 1731, 5252, 9968, 636, 3623, 8338, 8454, 1612],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [689, 7909, 7771, 2627, 4360, 7661, 1744, 8623, 3555, 4591, 1614],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6758, 4025, 6769, 6879, 9105, 4249, 3821, 2893, 219, 744, 1616],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6796, 4064, 1791, 359, 4497, 7310, 4555, 1700, 8490, 6912, 1617],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3179, 9701, 4360, 1757, 4190, 1573, 2383, 1927, 8530, 3097, 1619],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7284, 7057, 5849, 8035, 8775, 7220, 2654, 2074, 501, 9299, 1620],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2331, 6099, 5312, 3121, 5756, 9953, 3821, 2261, 4565, 5516, 1622],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3318, 3700, 9402, 7900, 9712, 2988, 3638, 4229, 884, 1750, 1624],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1297, 2327, 2063, 2654, 2782, 1152, 5376, 1341, 9621, 7999, 1625],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [797, 8411, 6236, 2395, 7186, 7222, 4060, 8585, 937, 4266, 1627],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4829, 7384, 8462, 1092, 3174, 697, 2720, 2574, 4997, 548, 1629],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8944, 8332, 2279, 2500, 7369, 9134, 8650, 1548, 1962, 6847, 1630],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9913, 5978, 149, 3345, 8131, 2241, 9701, 5378, 1995, 3162, 1632],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2212, 1920, 8807, 8876, 6175, 8865, 568, 5565, 5260, 9493, 1633],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1210, 7986, 2245, 1345, 321, 7054, 9116, 5239, 1920, 5841, 1635],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3326, 7789, 2857, 8821, 9862, 7347, 2703, 9170, 2138, 2205, 1637],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1153, 3416, 7662, 4949, 6710, 9468, 4532, 3758, 6079, 8585, 1638],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6481, 9637, 6274, 9713, 2050, 2563, 15, 7044, 3905, 4982, 1640],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [510, 8056, 3713, 7142, 3943, 9172, 3149, 8705, 5781, 1395, 1642],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5323, 3029, 7851, 8104, 3885, 3084, 2921, 61, 1872, 7825, 1643],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9453, 1252, 2027, 4918, 2026, 1238, 9712, 4072, 2340, 4271, 1645],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9766, 6746, 1927, 9494, 2349, 9841, 1732, 5345, 7351, 733, 1647],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7761, 1653, 6357, 8141, 787, 4865, 1468, 128, 7070, 7212, 1648],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1267, 891, 8190, 3978, 866, 7084, 2139, 6319, 1660, 3708, 1650],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8666, 8584, 8982, 2182, 3139, 1821, 4183, 3464, 1288, 220, 1652],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2175, 4089, 2976, 4044, 6302, 3566, 1746, 2760, 6118, 6748, 1653],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7333, 9376, 8248, 3011, 9539, 5631, 9199, 7054, 6315, 3293, 1655],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4401, 9591, 9450, 9627, 7290, 5008, 7664, 850, 2046, 9855, 1656],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6358, 6114, 2910, 2479, 9301, 2592, 1559, 305, 3475, 6433, 1658],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [24, 9294, 6137, 9041, 438, 8943, 5159, 3232, 768, 3028, 1660],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3498, 1583, 5250, 3597, 6454, 5736, 9178, 9105, 4091, 9639, 1661],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3530, 1285, 1119, 9266, 3485, 3091, 7358, 9058, 3611, 6267, 1663],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9190, 8593, 3804, 7622, 788, 2916, 3084, 5886, 9494, 2911, 1665],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1941, 3222, 951, 2418, 7820, 8458, 6011, 4047, 1906, 9573, 1666],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1599, 76, 5311, 3560, 8477, 216, 8711, 9666, 1013, 6251, 1668],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6775, 825, 5631, 3778, 6945, 8376, 3327, 535, 6984, 2945, 1670],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [203, 2264, 138, 3323, 1282, 1949, 8262, 6112, 9983, 9656, 1671],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2037, 8922, 9330, 7626, 2530, 4767, 4862, 7529, 179, 6385, 1673],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4036, 5529, 1422, 9108, 8816, 8513, 4136, 7587, 7739, 3129, 1675],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8564, 390, 6440, 7247, 5567, 2945, 3481, 762, 2831, 9891, 1676],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6483, 8855, 696, 740, 4648, 3480, 3424, 3205, 5621, 6669, 1678],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2153, 3165, 9329, 1902, 6894, 6317, 4388, 2744, 6278, 3464, 1680],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3452, 308, 8166, 6666, 4194, 1255, 3469, 8886, 4969, 276, 1682],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4283, 6735, 4933, 3365, 8947, 2375, 1228, 2818, 1864, 7105, 1683],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7157, 7730, 1376, 220, 399, 6765, 8507, 7408, 7129, 3950, 1685],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [608, 7562, 160, 4882, 9055, 1434, 3257, 7211, 934, 813, 1687],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9749, 1385, 1464, 9680, 2030, 8617, 7379, 8463, 3447, 7692, 1688],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3587, 9632, 2153, 3331, 3890, 9596, 3594, 9091, 4837, 4588, 1690],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1740, 1448, 3748, 3825, 9222, 7250, 2316, 8708, 5273, 1501, 1692],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1355, 1516, 2539, 8020, 4869, 7471, 8550, 8618, 4924, 8431, 1693],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5277, 6195, 4993, 1173, 1430, 9625, 8806, 1819, 3960, 5378, 1695],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6258, 395, 2729, 4238, 5332, 6234, 8029, 3001, 2549, 2342, 1697],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6493, 5440, 3047, 8253, 4486, 2041, 6544, 8550, 861, 9323, 1698],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5146, 1276, 2393, 3596, 2197, 2624, 7021, 6549, 9067, 6320, 1700],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8855, 7558, 576, 7253, 5724, 2738, 1457, 6781, 7336, 3335, 1702],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2317, 5995, 2737, 3604, 7582, 4551, 8172, 727, 5839, 367, 1704],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4671, 5723, 3501, 3557, 9348, 5939, 8825, 1574, 4745, 7416, 1705],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7511, 7512, 3553, 3181, 9476, 9018, 5445, 4211, 4225, 4482, 1707],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4895, 3967, 2922, 6341, 8290, 9078, 7481, 5232, 4450, 1565, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1151, 5986, 7912, 6202, 5055, 4092, 8867, 2940, 5591, 8665, 1710],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2905, 7940, 230, 7900, 3713, 4969, 5104, 7347, 7818, 5782, 1712],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9179, 7755, 7981, 9147, 5595, 6724, 363, 175, 1304, 2917, 1714],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4644, 2248, 9642, 7149, 9114, 734, 4601, 4858, 6218, 68, 1716],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2632, 9948, 4734, 8827, 8164, 8252, 692, 6547, 2733, 7237, 1717],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4116, 515, 9833, 7177, 2664, 5349, 1586, 2106, 1021, 4423, 1719],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4114, 680, 6969, 9501, 6388, 9457, 7469, 118, 1253, 1626, 1721],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1217, 3883, 4945, 3302, 8958, 7689, 2956, 887, 3601, 8846, 1722],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [970, 1996, 4030, 2916, 569, 7097, 4289, 6435, 8237, 6083, 1724],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [298, 7152, 2861, 4348, 9766, 7045, 6560, 509, 5335, 3338, 1726],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4466, 2775, 5007, 7429, 6281, 3884, 948, 8581, 5065, 610, 1728],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7001, 8775, 3654, 3261, 2687, 8068, 1972, 7847, 7602, 7899, 1729],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5461, 1845, 8639, 998, 333, 3919, 4767, 7233, 3118, 5206, 1731],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1409, 7028, 2883, 1373, 6767, 2191, 2368, 7395, 1786, 2530, 1733],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8158, 5737, 8008, 4968, 3564, 5618, 3020, 719, 3780, 9871, 1734],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1525, 17, 4116, 1173, 5220, 7605, 7502, 1325, 9272, 7229, 1736],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4739, 3681, 9601, 8936, 1492, 4256, 6467, 5069, 8436, 4605, 1738],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5343, 9494, 6399, 3004, 7321, 9890, 7799, 9542, 1446, 1999, 1740],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1, 1376, 7692, 9171, 6165, 6240, 3994, 4075, 8477, 9409, 1741],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9592, 9722, 2252, 9341, 4370, 5487, 9547, 9737, 9701, 6837, 1743],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5553, 9950, 6016, 1776, 5875, 7322, 8367, 9342, 5294, 4283, 1745],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6206, 629, 883, 3949, 8343, 200, 1205, 7446, 5430, 1746, 1747],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4408, 8761, 7325, 4791, 3530, 6962, 3095, 349, 284, 9227, 1748],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1114, 7492, 5205, 18, 6435, 4997, 825, 6101, 29, 6725, 1750],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8802, 454, 644, 8455, 9543, 1129, 410, 4499, 4842, 4240, 1752],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6416, 6018, 501, 9080, 216, 1390, 4593, 7091, 4897, 1773, 1754],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6419, 9396, 4578, 7709, 1009, 5858, 361, 7179, 370, 9324, 1755],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [326, 4263, 4042, 8986, 4482, 8748, 6478, 9816, 1436, 6892, 1757],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9123, 1465, 7837, 3585, 5798, 3911, 1035, 1815, 8272, 4477, 1759],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5339, 5392, 2217, 2322, 8159, 5929, 9016, 1742, 1052, 2081, 1761],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2968, 6615, 7428, 8179, 7902, 6981, 9888, 9927, 9952, 9701, 1762],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3508, 5761, 5597, 4179, 7816, 9651, 5201, 8459, 5150, 7340, 1764],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8410, 8050, 814, 9486, 9003, 5859, 6211, 1189, 6822, 4996, 1766],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8522, 9154, 2144, 8238, 3392, 2089, 1516, 3735, 5143, 2670, 1768],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3216, 9778, 9023, 5300, 733, 1087, 4714, 3479, 291, 362, 1770],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6839, 9609, 2476, 478, 5709, 214, 2077, 9574, 2442, 8071, 1771],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6075, 5784, 1293, 7732, 2537, 6625, 241, 2941, 1775, 5798, 1773],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1332, 7190, 6386, 8626, 6221, 9445, 3918, 6273, 8465, 3542, 1775],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [564, 1576, 5850, 9586, 1362, 9137, 3620, 4038, 2691, 1305, 1777],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9227, 4482, 4735, 635, 1239, 4216, 3405, 2478, 4630, 9085, 1778],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2207, 5303, 4462, 9082, 1609, 5509, 8638, 9612, 4459, 6883, 1780],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9997, 6920, 4422, 5176, 5493, 8121, 3774, 5240, 2358, 4699, 1782],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5988, 6349, 261, 8057, 6933, 1296, 155, 940, 8504, 2532, 1784],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8369, 5874, 7257, 9422, 3557, 6344, 3822, 73, 3075, 384, 1786],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3890, 6699, 1025, 9227, 9502, 2815, 3356, 7786, 6249, 8253, 1787],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7236, 9059, 9553, 2417, 2073, 3105, 7722, 1010, 8207, 6140, 1789],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1725, 4916, 8555, 8273, 7275, 5652, 4143, 8466, 9125, 4045, 1791],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9341, 5627, 4731, 4282, 1164, 6933, 5986, 662, 9185, 1968, 1793],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [32, 6693, 7382, 4764, 5713, 2403, 667, 9900, 8563, 9909, 1794],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6008, 765, 6668, 595, 9731, 6592, 7572, 272, 7442, 7868, 1796],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3934, 3588, 5651, 424, 7112, 2510, 6003, 7669, 5998, 5845, 1798],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3096, 531, 2229, 5772, 6525, 554, 3131, 9776, 4413, 3840, 1800],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1177, 1752, 5436, 2298, 8426, 7097, 1976, 6077, 2867, 1853, 1802],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6487, 3319, 7957, 7408, 7074, 2933, 9404, 7856, 1539, 9884, 1803],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7421, 7591, 2623, 218, 7053, 1759, 4134, 8202, 610, 7933, 1805],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [372, 4026, 5103, 3741, 5558, 8879, 4773, 2004, 261, 6000, 1807],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9362, 6216, 7931, 1031, 3564, 304, 7867, 5959, 671, 4085, 1809],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [186, 8376, 2702, 6886, 737, 2433, 5960, 8572, 2022, 2188, 1811],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9382, 3872, 8047, 4671, 813, 2493, 5688, 156, 4496, 309, 1813],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9193, 3887, 1532, 3832, 5924, 9921, 5876, 2836, 8272, 8448, 1814],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1558, 6451, 4610, 7728, 206, 8869, 5664, 550, 3533, 6606, 1816],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3487, 4419, 2138, 3659, 4803, 2005, 2642, 9051, 459, 4782, 1818],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1930, 4840, 2913, 7221, 8202, 5811, 1008, 5908, 9234, 2975, 1820],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2388, 3382, 6451, 1628, 7668, 7536, 9748, 508, 39, 1188, 1822],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1059, 1699, 5307, 9217, 9325, 4001, 826, 4062, 3055, 9418, 1823],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8043, 4145, 3325, 7155, 6300, 2436, 7396, 9597, 8465, 7666, 1825],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2003, 2133, 111, 2352, 6107, 3524, 2034, 1970, 6453, 5933, 1827],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2746, 7945, 2793, 1767, 328, 6845, 4986, 7859, 7199, 4218, 1829],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3472, 4612, 5, 3731, 1433, 8890, 2435, 5773, 888, 2522, 1831],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4341, 7022, 2324, 3567, 3420, 3842, 4786, 6048, 7702, 843, 1833],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7324, 9307, 804, 2752, 4784, 7293, 4967, 853, 7825, 9183, 1834],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9543, 8789, 3390, 5060, 4154, 3089, 6756, 4189, 1439, 7542, 1836],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [784, 41, 955, 5684, 766, 3483, 3115, 1893, 8729, 5918, 1838],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9946, 6886, 3491, 156, 3771, 2779, 4553, 1637, 9878, 4313, 1840],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2670, 591, 5996, 9102, 6215, 4655, 7500, 2933, 5070, 2727, 1842],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6611, 8147, 6218, 2391, 1376, 3341, 2704, 7134, 4489, 1159, 1844],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8536, 562, 6504, 2181, 942, 8840, 3642, 7433, 8320, 9609, 1845],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2648, 9878, 3142, 8678, 6418, 6381, 4956, 8869, 6747, 8078, 1847],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8310, 7627, 3155, 5154, 6931, 281, 899, 8327, 9955, 6565, 1849],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1041, 9975, 4373, 9946, 8475, 2400, 3805, 4538, 8129, 5071, 1851],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5863, 2631, 4549, 2761, 1498, 5383, 2579, 8085, 1453, 3596, 1853],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [556, 3581, 3554, 707, 5536, 860, 1201, 1401, 114, 2139, 1855],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2020, 2259, 4355, 6038, 1504, 2808, 7248, 8772, 4295, 700, 1857],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4219, 7534, 8277, 2680, 4060, 6235, 441, 6342, 4184, 9280, 1858],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8758, 1556, 3326, 2207, 8329, 1398, 1205, 2108, 9966, 7878, 1860],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6569, 2675, 6264, 2075, 7143, 3721, 9246, 5928, 1826, 6496, 1862],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3142, 2842, 5369, 9650, 6781, 9606, 2154, 9523, 9951, 5131, 1864],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7387, 4039, 6916, 4817, 1080, 8327, 4019, 6472, 4528, 3786, 1866],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9723, 3114, 445, 1881, 5620, 183, 4065, 2222, 5743, 2459, 1868],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8202, 3627, 1774, 7939, 5585, 1111, 5304, 4085, 3782, 1151, 1870],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6052, 7348, 4830, 73, 2734, 3927, 3213, 1242, 8833, 9861, 1871],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4049, 824, 106, 7474, 8786, 6397, 4423, 4743, 1082, 8591, 1873],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5987, 3406, 5565, 7094, 4429, 6323, 5430, 7511, 717, 7339, 1875],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3890, 9029, 1955, 2586, 4967, 3817, 1324, 4343, 7926, 6105, 1877],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1934, 766, 5697, 6126, 5556, 973, 4537, 1910, 2896, 4891, 1879],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7532, 1736, 6074, 1359, 818, 9105, 3609, 8763, 5814, 3695, 1881],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [685, 8184, 6703, 3005, 5494, 3746, 1978, 5331, 6870, 2518, 1883],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5884, 5175, 1750, 4814, 4707, 7603, 6776, 3924, 6251, 1360, 1885],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [533, 3769, 2920, 2428, 4246, 1639, 7661, 8737, 4145, 221, 1887],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [919, 532, 1785, 1433, 3191, 4488, 5651, 5849, 742, 9101, 1888],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1682, 6358, 1634, 3384, 3074, 380, 1992, 3226, 6230, 7999, 1890],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1512, 4233, 2147, 3978, 9652, 5769, 7031, 722, 798, 6917, 1892],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6229, 1824, 7211, 7759, 5258, 4855, 9121, 84, 4635, 5853, 1894],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7746, 7417, 9936, 2858, 1591, 4178, 3533, 4951, 7930, 4808, 1896],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8345, 7701, 8161, 7267, 4680, 6490, 1395, 855, 874, 3783, 1898],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5559, 3969, 7630, 5079, 5679, 4083, 8648, 5225, 3655, 2776, 1900],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9861, 1925, 7822, 6982, 3003, 1762, 5018, 7391, 6464, 1788, 1902],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2808, 5647, 6550, 4106, 3258, 9658, 3010, 8580, 9491, 819, 1904],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2410, 9955, 3603, 8117, 274, 6071, 6924, 1922, 2927, 9870, 1905],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2611, 6678, 701, 3233, 3487, 526, 1880, 2453, 6961, 8939, 1907],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8154, 7382, 4905, 7631, 8781, 7243, 2871, 7112, 1784, 8028, 1909],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7169, 7838, 5593, 2544, 6849, 9202, 3836, 4748, 7588, 7135, 1911],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4208, 514, 1555, 7213, 5986, 2996, 6744, 6119, 4563, 6262, 1913],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [684, 8609, 5331, 6820, 8192, 4669, 701, 3896, 2901, 5408, 1915],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3284, 3280, 7372, 8557, 9316, 6723, 1081, 2661, 2793, 4573, 1917],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [54, 8435, 3872, 8116, 5933, 6487, 8669, 8913, 4430, 3757, 1919],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2634, 9085, 539, 5173, 3524, 6040, 8826, 1070, 8006, 2960, 1921],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1554, 6880, 1253, 1844, 2465, 3882, 674, 9468, 3710, 2183, 1923],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1005, 1627, 7324, 2669, 240, 8541, 6298, 6362, 1737, 1425, 1925],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8857, 8547, 1440, 8449, 215, 4309, 9972, 5934, 2278, 686, 1927],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7442, 4212, 2466, 9217, 9230, 9301, 7395, 4290, 5526, 9966, 1928],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6650, 6444, 5042, 3841, 8187, 6031, 4959, 9462, 1673, 9266, 1930],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7853, 4122, 3886, 5150, 1744, 4687, 9023, 1411, 914, 8585, 1932],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [152, 5058, 9167, 196, 5151, 9312, 5216, 2031, 3440, 7923, 1934],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6787, 3391, 9186, 5233, 8176, 7080, 7757, 5146, 9445, 7280, 1936],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9433, 9737, 2607, 4250, 8035, 851, 8790, 6517, 9123, 6657, 1938],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4365, 4974, 7851, 8508, 5128, 5209, 7742, 3841, 2668, 6054, 1940],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2180, 1497, 5167, 2456, 7365, 6172, 704, 6754, 273, 5470, 1942],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7543, 7036, 936, 8665, 756, 4772, 9823, 6830, 2133, 4905, 1944],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1502, 4682, 7478, 1123, 5928, 4687, 2719, 7591, 8442, 4359, 1946],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6498, 5180, 8993, 2267, 2112, 4141, 1921, 4498, 9395, 3833, 1948],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5916, 103, 9315, 4602, 2155, 2238, 4321, 4961, 5186, 3327, 1950],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7229, 4910, 4072, 2694, 3992, 9952, 647, 8339, 6010, 2840, 1952],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5875, 633, 3207, 5662, 6001, 5949, 4961, 5939, 2063, 2373, 1954],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [451, 8631, 4114, 4157, 5602, 7444, 4165, 1023, 3540, 1925, 1956],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6317, 8851, 5893, 9131, 2397, 6286, 7540, 8805, 635, 1497, 1958],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9448, 1832, 6256, 2561, 9128, 466, 6295, 6457, 3546, 1088, 1960],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [844, 3151, 9872, 2664, 5648, 1250, 3138, 3108, 2468, 699, 1962],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3080, 4338, 5661, 8078, 3100, 6116, 1870, 9847, 7596, 329, 1964],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9445, 9764, 6447, 6974, 7415, 7712, 6995, 9725, 9128, 9979, 1965],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5150, 5154, 3289, 8183, 3223, 9019, 3349, 7759, 7260, 9649, 1967],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1028, 9921, 4650, 2096, 1238, 4911, 5752, 929, 2189, 9339, 1969],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5154, 3127, 3665, 9464, 4117, 323, 8676, 8185, 4110, 9048, 1971],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [62, 5356, 1382, 6183, 7796, 5212, 5935, 447, 3223, 8777, 1973],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7262, 4970, 6769, 1826, 7225, 6511, 397, 606, 9723, 8525, 1975],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2482, 2925, 2075, 9023, 7448, 7273, 3709, 3526, 3808, 8294, 1977],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1520, 172, 2019, 9831, 2909, 3206, 6048, 6049, 5676, 8082, 1979],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5042, 1527, 4275, 4053, 9841, 6788, 5887, 6994, 5525, 7890, 1981],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7982, 8085, 4316, 2960, 8593, 9174, 9787, 7159, 3553, 7718, 1983],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [374, 391, 7413, 195, 4711, 72, 2203, 9326, 9958, 7565, 1985],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3276, 6809, 2246, 9724, 9563, 5806, 5308, 8257, 4939, 7433, 1987],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2822, 4999, 2204, 8582, 3305, 5758, 8849, 703, 8695, 7320, 1989],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7293, 8919, 70, 9913, 4930, 7375, 7, 5403, 1423, 7228, 1991],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7709, 2111, 8007, 9343, 6176, 9964, 3288, 3082, 3324, 7155, 1993],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1420, 7471, 5896, 5200, 8011, 7450, 430, 6461, 4596, 7102, 1995],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7060, 8564, 6154, 384, 432, 312, 329, 252, 5440, 7069, 1997],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7846, 657, 918, 969, 8296, 6884, 8985, 1163, 6054, 7056, 1999],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9870, 4650, 7307, 3736, 7897, 4240, 9475, 7902, 6638, 7063, 2001],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2327, 440, 7582, 1987, 995, 8834, 1932, 1175, 7394, 7090, 2003],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2617, 8889, 3027, 6024, 5004, 7119, 3559, 3688, 8520, 7137, 2005],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8789, 1426, 3140, 1780, 53, 6341, 8651, 153, 218, 7205, 2007],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2353, 9745, 5016, 8136, 5612, 5691, 8645, 7288, 2687, 7292, 2009],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [396, 2381, 2069, 557, 1418, 8044, 2186, 3818, 6130, 7399, 2011],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5424, 17, 6527, 5830, 9388, 2454, 5216, 476, 747, 7527, 2013],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3559, 1772, 7366, 9905, 5280, 7639, 1077, 10, 6739, 7674, 2015],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3992, 1873, 4957, 8117, 804, 6623, 645, 7179, 4307, 7842, 2017],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7522, 36, 6926, 4499, 8949, 2765, 2472, 8759, 3654, 8030, 2019],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4982, 345, 7590, 4416, 7282, 7365, 2955, 3544, 4982, 8238, 2021],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2557, 6034, 7262, 2428, 5995, 9038, 6527, 2347, 8492, 8466, 2023],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3557, 9617, 9286, 5151, 9490, 5079, 5862, 8004, 4386, 8715, 2025],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3153, 4343, 3642, 6915, 2324, 5008, 2103, 5374, 2868, 8984, 2027],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5378, 7892, 8341, 4257, 2341, 6493, 5113, 1341, 4140, 9273, 2029],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2755, 7251, 5792, 3784, 5855, 3871, 3743, 4819, 8404, 9582, 2031],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [226, 2321, 3212, 6624, 1771, 9452, 6119, 6750, 5864, 9912, 2033],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6392, 7446, 6647, 1718, 3554, 7814, 9956, 109, 6724, 262, 2036],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2851, 3942, 9963, 9455, 9985, 3301, 2883, 9906, 1185, 633, 2038],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8792, 1048, 6286, 6751, 7696, 916, 2795, 3184, 9454, 1023, 2040],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9690, 6700, 3070, 4595, 466, 814, 8224, 9026, 1732, 1435, 2042],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7704, 5120, 6534, 9356, 2350, 6605, 8729, 8556, 8225, 1866, 2044],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2688, 2708, 334, 9779, 3710, 7670, 5309, 4939, 9137, 2318, 2046],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7442, 1119, 814, 2623, 1270, 5685, 832, 3384, 4672, 2791, 2048],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4592, 67, 960, 1363, 5366, 5566, 488, 1146, 5035, 3284, 2050],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7623, 6598, 1559, 4213, 9603, 1041, 2263, 7529, 430, 3798, 2052],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5113, 9957, 5412, 85, 167, 5046, 7429, 3887, 1064, 4332, 2054],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4818, 4338, 3386, 3882, 4097, 5150, 1062, 3628, 7141, 4886, 2056],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4712, 5916, 4483, 5812, 7883, 4231, 2572, 2211, 8867, 5461, 2058],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7913, 4770, 948, 3231, 9780, 6582, 6259, 7154, 6447, 6057, 2060],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2253, 7392, 8962, 7837, 1310, 9673, 1889, 8034, 88, 6674, 2062],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9779, 5419, 1189, 5963, 5472, 1762, 5290, 6486, 9996, 7310, 2064],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9361, 638, 4902, 5140, 1223, 5578, 8964, 6210, 6377, 7968, 2066],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [998, 2119, 4569, 6229, 5883, 8255, 2731, 2971, 9438, 8646, 2068],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3895, 5322, 6615, 7030, 9153, 7754, 4382, 4598, 9385, 9345, 2070],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5263, 3297, 2893, 656, 4514, 5955, 358, 992, 6426, 65, 2073],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5847, 8691, 4675, 9892, 5834, 8637, 6449, 4122, 767, 806, 2075],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [741, 9952, 7380, 7444, 9098, 2557, 8516, 8033, 2616, 1567, 2077],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4288, 1332, 4651, 1310, 1204, 9825, 3226, 8844, 2181, 2349, 2079],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3175, 9603, 5941, 4594, 9897, 9783, 8821, 4749, 9670, 3151, 2081],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2372, 8140, 1708, 9898, 948, 8615, 5893, 6025, 5290, 3975, 2083],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7259, 2776, 2135, 9983, 770, 6858, 8190, 5027, 9250, 4819, 2085],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8614, 1073, 6838, 8773, 4752, 5066, 3439, 6196, 1758, 5685, 2087],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6773, 3248, 2030, 9911, 3669, 7802, 4190, 6056, 3023, 6571, 2089],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6428, 4990, 6361, 4066, 2606, 6179, 8683, 3220, 3254, 7478, 2091],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4082, 8197, 5420, 1035, 8917, 9161, 1731, 8392, 2659, 8406, 2093],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [660, 8140, 6232, 8337, 7842, 3831, 5631, 4364, 1449, 9355, 2095],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6315, 4111, 5754, 4618, 6480, 4827, 1087, 6026, 9832, 324, 2098],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2260, 3221, 361, 3638, 8903, 3169, 8164, 360, 8019, 1315, 2100],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6612, 2374, 5766, 3040, 7320, 4678, 7254, 6450, 6218, 2327, 2102],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8005, 3128, 8125, 1468, 6257, 8195, 69, 5478, 4641, 3360, 2104],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [256, 4410, 6856, 7909, 8843, 3817, 653, 727, 3498, 4414, 2106],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8498, 2418, 7716, 8487, 6388, 1356, 6412, 7586, 2998, 5489, 2108],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4641, 7858, 975, 8254, 4526, 9228, 9170, 3551, 3354, 6585, 2110],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8734, 1562, 4321, 8886, 1326, 3991, 6247, 8226, 4775, 7702, 2112],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5130, 7583, 3817, 7638, 4858, 734, 1548, 3325, 7474, 8840, 2114],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4916, 134, 9561, 8370, 9819, 4536, 6685, 2674, 1661, 0, 2117],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4317, 7304, 6345, 2092, 4938, 3199, 2116, 2217, 7548, 1180, 2119],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2674, 9530, 4887, 2143, 4979, 1467, 8301, 11, 5347, 2382, 2121],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3769, 5623, 7103, 8006, 3297, 6953, 6884, 6236, 5269, 3605, 2123],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [325, 8597, 1175, 1738, 2996, 7970, 1897, 3191, 7528, 4849, 2125],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [323, 8565, 329, 2192, 6865, 3490, 980, 5298, 2335, 6115, 2127],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9849, 9522, 5285, 4611, 8409, 5439, 6625, 9105, 9903, 7401, 2129],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3718, 23, 6414, 6763, 8378, 3538, 7445, 3289, 446, 8710, 2131],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6420, 6050, 9986, 7656, 3354, 2908, 9457, 8655, 4175, 39, 2134],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [999, 3654, 6186, 1001, 5070, 4646, 7392, 8141, 1305, 1390, 2136],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [936, 1514, 7417, 2979, 1263, 9594, 6024, 6818, 2049, 2762, 2138],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4233, 687, 6978, 2613, 1010, 5500, 1522, 1894, 6621, 4155, 2140],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7187, 2193, 3468, 3063, 9602, 7800, 2818, 2714, 5234, 5570, 2142],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6976, 7696, 8800, 3582, 179, 4228, 3006, 765, 8103, 7006, 2144],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8421, 4205, 1030, 4636, 1464, 3456, 752, 9676, 5441, 8464, 2146],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5488, 7586, 1166, 2832, 3086, 8008, 1733, 5220, 7465, 9943, 2148],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2869, 8178, 9798, 7920, 2118, 1630, 96, 5318, 4388, 1444, 2151],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8012, 2925, 8949, 1102, 6612, 1349, 9932, 38, 6426, 2966, 2153],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5832, 3702, 1580, 2376, 4035, 4435, 6782, 1603, 3793, 4510, 2155],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6462, 8297, 271, 4600, 4700, 470, 9158, 4385, 6705, 6075, 2157],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1438, 4116, 2685, 3400, 2390, 8755, 83, 4915, 5378, 7662, 2159],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7630, 351, 9632, 5018, 6561, 1255, 8664, 1877, 28, 9271, 2161],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5734, 9785, 7199, 8727, 2654, 1312, 1669, 6121, 870, 901, 2164],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1538, 8388, 3027, 6506, 9199, 8325, 5143, 653, 8122, 2552, 2166],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4090, 8015, 4176, 358, 2558, 8636, 6037, 647, 1999, 4226, 2168],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2184, 1847, 6149, 6914, 2319, 2809, 3857, 3442, 2718, 5921, 2170],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [92, 1823, 5607, 9880, 2518, 9550, 2337, 8545, 496, 7638, 2172],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9319, 3189, 9676, 3448, 6014, 6459, 1140, 7634, 5551, 9376, 2174],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3622, 9581, 8997, 4026, 1537, 7847, 7567, 4559, 8100, 1136, 2177],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4557, 6309, 6766, 3558, 5090, 9823, 8301, 5347, 8360, 2918, 2179],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [509, 2817, 8910, 5369, 9542, 2884, 1166, 8201, 6549, 4722, 2181],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6189, 2201, 8621, 2841, 8452, 2209, 6906, 3501, 2886, 6548, 2183],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9571, 4958, 9116, 2369, 2317, 5884, 993, 3813, 7588, 8395, 2185],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [383, 185, 9510, 4984, 7635, 1274, 5452, 3882, 874, 265, 2188],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5113, 3212, 7944, 5747, 1341, 9767, 704, 643, 2963, 2156, 2190],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2414, 7218, 1804, 6581, 5364, 88, 7444, 3215, 4073, 4069, 2192],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7036, 3458, 5288, 6607, 8242, 432, 8521, 2911, 4424, 6004, 2194],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6482, 957, 8409, 4332, 2913, 9607, 860, 3235, 4235, 7961, 2196],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6654, 9105, 7489, 8180, 1994, 7420, 7396, 9883, 3725, 9940, 2198],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3099, 2276, 4347, 5957, 4057, 4528, 9026, 752, 3116, 1941, 2201],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5379, 2072, 8950, 9839, 6589, 1964, 6592, 5936, 2625, 3964, 2203],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [216, 1549, 7799, 1448, 3549, 564, 2881, 7730, 2474, 6009, 2205],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1241, 3768, 7293, 1514, 7594, 511, 4648, 632, 2884, 8076, 2207],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4486, 9293, 7847, 595, 9296, 1225, 4661, 1347, 4074, 165, 2210],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2422, 8753, 590, 1275, 7824, 1806, 3768, 8787, 6265, 2276, 2212],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8810, 4760, 4467, 8284, 9812, 2261, 2986, 4074, 9680, 4409, 2214],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9304, 4104, 8055, 1083, 5322, 5735, 5612, 542, 4539, 6565, 2216],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6258, 4765, 8136, 3597, 2013, 1959, 9358, 3740, 1063, 8743, 2218],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6425, 439, 7077, 8096, 875, 2148, 8503, 1434, 9475, 942, 2221],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1252, 6445, 4564, 4624, 9052, 5561, 6074, 3608, 9996, 3164, 2223],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6341, 7053, 7675, 3950, 7531, 7953, 6045, 2467, 2849, 5409, 2225],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9149, 2923, 8275, 773, 3687, 2128, 5559, 2440, 8256, 7675, 2227],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3939, 3629, 261, 4851, 877, 832, 7170, 181, 6440, 9964, 2229],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2365, 9497, 3272, 907, 9526, 2196, 1113, 4573, 7623, 2275, 2232],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [351, 6538, 6515, 3587, 6343, 7961, 7591, 6726, 2029, 4609, 2234],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5106, 9997, 8872, 1402, 570, 4692, 9088, 9986, 9881, 6964, 2236],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8270, 4515, 2245, 3591, 8355, 8224, 2698, 9932, 1403, 9343, 2238],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7818, 9429, 7089, 6099, 8612, 1556, 2487, 4378, 6819, 1743, 2241],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5950, 4904, 5644, 7507, 5934, 6404, 1864, 3379, 6352, 4166, 2243],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5773, 186, 2761, 2685, 8382, 8656, 5989, 9230, 226, 6612, 2245],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4119, 6756, 304, 1334, 200, 7945, 4191, 6471, 8667, 9079, 2247],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [462, 1782, 2603, 301, 1759, 1555, 2415, 1886, 1899, 1570, 2250],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2874, 6322, 1562, 2742, 1260, 2906, 5688, 4507, 146, 4083, 2252],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4046, 5815, 5148, 3816, 4989, 4818, 613, 5618, 3634, 6618, 2254],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3269, 9639, 6528, 1697, 5151, 7799, 7879, 8752, 2588, 9176, 2256],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6870, 874, 8080, 4247, 6569, 3568, 4798, 9701, 7234, 1756, 2259],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5646, 4795, 9683, 5804, 5786, 4049, 7860, 6510, 7798, 4359, 2261],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2859, 4295, 9531, 5151, 8353, 6053, 5317, 9486, 4505, 6985, 2263],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8388, 5201, 3478, 4922, 2356, 1882, 9785, 1195, 7583, 9633, 2265],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6237, 2815, 1517, 4462, 8487, 6069, 867, 6470, 7256, 2304, 2268],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [646, 9625, 3135, 2533, 9225, 8500, 7806, 2405, 3753, 4998, 2270],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2940, 9943, 3278, 3238, 1959, 4120, 2153, 8368, 7299, 7714, 2272],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9760, 9649, 3745, 8186, 3152, 9467, 459, 5993, 8123, 453, 2275],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3155, 2636, 7729, 233, 2911, 6261, 6997, 9188, 6451, 3215, 2277],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [979, 1356, 4627, 9137, 1590, 2262, 6495, 4138, 2512, 6000, 2279],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7623, 7864, 5327, 7182, 2360, 9637, 6900, 9303, 6532, 8807, 2281],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [487, 6302, 2118, 3306, 5893, 1059, 2167, 5424, 8741, 1637, 2284],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8195, 4270, 9737, 7463, 5654, 3766, 5057, 5522, 9366, 4490, 2286],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6608, 1498, 2581, 2991, 4528, 1806, 9977, 4904, 8636, 7366, 2288],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7674, 514, 5684, 3529, 5797, 6701, 5826, 1164, 6780, 265, 2291],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5241, 7548, 1956, 2731, 3793, 6756, 8876, 4182, 4026, 3187, 2293],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2642, 7197, 3759, 9455, 1801, 5239, 5667, 6132, 604, 6132, 2295],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2656, 1665, 1812, 8543, 7110, 7666, 5930, 1479, 6744, 9099, 2297],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1438, 2184, 7585, 7531, 5369, 8420, 5533, 6985, 2674, 2090, 2300],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8128, 4108, 5798, 2863, 8731, 6924, 9447, 1709, 8626, 5103, 2302],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9261, 7838, 763, 5286, 4533, 3615, 4737, 7012, 4828, 8140, 2304],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7255, 9305, 3662, 3244, 3584, 5929, 3575, 6555, 1512, 1200, 2307],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4303, 7213, 7190, 5167, 9407, 4545, 6279, 6305, 8908, 4282, 2309],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8535, 9517, 9375, 6661, 2113, 109, 4370, 4537, 7247, 7388, 2311],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4741, 108, 45, 6768, 2862, 662, 3655, 1834, 6760, 517, 2314],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3616, 3342, 1811, 8655, 7192, 24, 7335, 1091, 7678, 3669, 2316],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5595, 9935, 3362, 4407, 7800, 7343, 9131, 7518, 232, 6845, 2318],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1339, 2001, 7126, 957, 9665, 8050, 6440, 8641, 4655, 43, 2321],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7962, 7568, 7277, 4752, 2731, 6455, 3506, 4304, 1179, 3265, 2323],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5822, 8460, 8969, 6402, 9672, 204, 4621, 6672, 35, 6510, 2325],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4728, 7872, 7152, 3431, 8580, 6849, 7344, 234, 1457, 9778, 2327],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4998, 891, 5404, 9284, 2747, 2736, 5752, 1805, 5676, 3069, 2330],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4485, 7775, 3795, 32, 2035, 4467, 3700, 527, 2926, 6384, 2332],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5951, 3617, 2389, 6723, 2628, 3160, 8119, 7872, 3439, 9722, 2334],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3708, 981, 6004, 1119, 4344, 1736, 2327, 7647, 7450, 3083, 2337],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9980, 3003, 9257, 5637, 6937, 5472, 9368, 5990, 5192, 6468, 2339],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7102, 1261, 1556, 4698, 9237, 6051, 5375, 1381, 6899, 9876, 2341],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3469, 4763, 2992, 4421, 7234, 9343, 2952, 4636, 2804, 3308, 2344],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2106, 7001, 7453, 704, 9608, 7149, 4585, 8914, 3142, 6763, 2346],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4614, 6386, 2442, 2181, 1508, 3149, 6071, 9719, 8148, 241, 2349],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8032, 9457, 65, 4452, 9750, 3273, 9974, 4901, 8057, 3743, 2351],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5835, 4621, 4598, 5300, 4929, 756, 9105, 4660, 3103, 7269, 2353],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5516, 8663, 3396, 7364, 8301, 6075, 21, 1547, 3522, 818, 2356],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5992, 6176, 4385, 4993, 3635, 2043, 6555, 464, 9549, 4390, 2358],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [966, 8535, 9774, 5771, 6581, 4260, 3359, 8674, 1419, 7987, 2360],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2516, 9475, 7230, 4461, 6467, 7185, 9482, 5794, 9370, 1606, 2363],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [92, 6624, 1778, 7948, 7776, 6042, 1964, 3806, 3637, 5250, 2365],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3023, 5273, 9877, 4170, 933, 4813, 9455, 7050, 4456, 8917, 2367],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1304, 2400, 7228, 6014, 4369, 540, 5860, 2237, 2065, 2608, 2370],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8491, 5083, 7, 2751, 2222, 4190, 4004, 8442, 6699, 6322, 2372],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5552, 9748, 1717, 6881, 4365, 8297, 9326, 7111, 8597, 60, 2375],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5577, 3082, 1226, 3154, 7857, 1640, 3592, 2065, 7996, 3822, 2377],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8269, 4789, 8636, 9149, 1243, 1180, 8630, 9496, 5132, 7608, 2379],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2685, 8318, 1432, 3150, 5547, 1494, 97, 7978, 245, 1418, 2382],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2759, 1642, 1092, 5086, 8124, 1958, 1262, 8460, 3572, 5251, 2384],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8327, 3127, 7606, 183, 7974, 1895, 6816, 4276, 5352, 9108, 2386],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [102, 748, 3815, 2544, 3440, 3943, 6705, 1145, 5823, 2989, 2389],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9231, 8287, 1099, 7323, 5649, 5873, 9988, 7171, 5223, 6894, 2391],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [932, 2476, 1045, 5428, 3397, 1103, 8718, 2849, 3793, 823, 2394],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [23, 6333, 2592, 3779, 7589, 8134, 1844, 1065, 1771, 4776, 2396],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4659, 8285, 9674, 7162, 5733, 9164, 9146, 7097, 9396, 8752, 2398],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [986, 3711, 9269, 4621, 9370, 8101, 5182, 8624, 6909, 2753, 2401],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3444, 5999, 3402, 4150, 9716, 8233, 3267, 5720, 4550, 6778, 2403],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7829, 1279, 291, 4249, 9204, 9778, 9474, 861, 2559, 827, 2406],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9315, 3290, 9166, 9655, 8991, 7566, 6659, 8929, 1175, 4900, 2408],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [505, 8737, 279, 1329, 4916, 9088, 8508, 7209, 641, 8997, 2410],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1456, 5276, 6261, 7545, 6775, 3151, 3613, 5397, 1197, 3118, 2413],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4972, 2846, 3762, 3816, 8227, 9387, 9564, 5597, 3084, 7263, 2415],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7425, 8099, 5774, 4221, 6990, 8847, 7077, 2330, 6544, 1432, 2418],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1056, 2281, 6028, 5781, 7467, 5928, 4133, 2530, 1818, 5626, 2420],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7570, 5692, 8495, 599, 300, 1875, 150, 5550, 9148, 9843, 2422],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [204, 9712, 8660, 7787, 5792, 91, 176, 3163, 8777, 4085, 2425],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6230, 7549, 342, 8623, 562, 3515, 9107, 9565, 946, 8352, 2427],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4135, 1797, 4372, 4023, 9185, 4282, 5930, 1380, 5900, 2642, 2430],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6933, 3956, 5342, 3276, 5033, 5943, 7987, 7656, 3879, 6957, 2432],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5900, 3958, 2266, 7052, 6933, 8449, 5267, 9874, 5128, 1296, 2435],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1063, 5785, 857, 6091, 690, 6179, 4721, 1946, 9891, 5659, 2437],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6674, 4894, 2055, 9609, 6954, 9223, 4599, 220, 8410, 47, 2440],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7798, 9520, 6388, 4426, 9354, 8192, 8817, 3481, 929, 4460, 2442],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2252, 7799, 68, 7131, 9231, 2772, 1342, 2956, 7693, 8896, 2444],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9750, 6753, 9845, 7255, 5776, 4286, 604, 2311, 8946, 3357, 2447],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2762, 4449, 3412, 9510, 2778, 2498, 3936, 7659, 4932, 7843, 2449],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9203, 8895, 4473, 7561, 5667, 6907, 2031, 7561, 5897, 2353, 2452],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5136, 3610, 797, 782, 4954, 2776, 3432, 3026, 2086, 6888, 2454],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2864, 763, 4081, 8735, 4633, 2135, 9037, 7516, 3743, 1447, 2457],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7723, 5421, 7069, 6024, 6563, 12, 6638, 6949, 1115, 6031, 2459],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6407, 3874, 984, 2496, 4270, 6132, 5477, 9698, 4447, 639, 2462],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8202, 1782, 248, 679, 2113, 2328, 834, 6597, 3986, 5272, 2464],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4443, 3797, 7127, 3804, 8171, 5915, 8629, 940, 9978, 9929, 2466],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3504, 1067, 2023, 3782, 1692, 9273, 61, 8490, 2668, 4612, 2469],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8436, 868, 1655, 9159, 8394, 5872, 6263, 7471, 2305, 9319, 2471],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5489, 8397, 3521, 8375, 9389, 3013, 2983, 8582, 9135, 4050, 2474],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1684, 2833, 7231, 3554, 1944, 1500, 5293, 4990, 3406, 8807, 2476],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5275, 2150, 8280, 4702, 2787, 2511, 2320, 2339, 5365, 3588, 2479],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [702, 6060, 4564, 3503, 7125, 1914, 2003, 8748, 5259, 8394, 2481],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9733, 6870, 7518, 9967, 9009, 2265, 5873, 4816, 3338, 3225, 2484],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6617, 102, 5750, 4004, 1181, 2744, 3860, 3625, 9849, 8080, 2486],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8063, 2091, 7048, 7577, 4982, 7272, 9123, 739, 5041, 2961, 2489],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6103, 538, 2633, 1518, 3430, 1070, 2908, 4212, 9162, 7866, 2491],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [178, 6395, 3656, 4294, 3002, 5886, 9423, 4583, 2462, 2797, 2494],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9492, 5286, 2717, 8129, 2203, 4161, 751, 4888, 5190, 7752, 2496],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4235, 2917, 1162, 829, 7441, 2369, 1774, 652, 7596, 2732, 2499],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1110, 8805, 5171, 9556, 9248, 3789, 5131, 9900, 9928, 7737, 2501],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3148, 4003, 9235, 5591, 4391, 950, 6199, 3156, 2439, 2768, 2504],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5316, 1881, 4030, 6885, 1864, 8005, 8095, 3445, 5377, 7823, 2506],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8154, 2927, 6632, 7942, 3322, 3285, 6712, 6297, 8993, 2903, 2509],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4774, 9162, 4302, 4335, 956, 2279, 5767, 9748, 3538, 8009, 2511],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9152, 5983, 9011, 1902, 8350, 1289, 1887, 4344, 9264, 3139, 2514],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3961, 6963, 8793, 8542, 2357, 2023, 9712, 3141, 6421, 8295, 2516],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7069, 3665, 4676, 9403, 6540, 7354, 7026, 1713, 5261, 3476, 2519],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1904, 9432, 9172, 4303, 9228, 8527, 9914, 8147, 6035, 8682, 2521],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7884, 5203, 5420, 9361, 1769, 4037, 7941, 3052, 8997, 3913, 2524],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5916, 1924, 6351, 3105, 5071, 443, 9358, 9557, 4397, 9170, 2526],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9298, 8463, 2526, 844, 5021, 5378, 6334, 3317, 2490, 4452, 2529],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5830, 5029, 7365, 9740, 9937, 2986, 215, 2513, 3527, 9759, 2531],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3758, 9027, 1630, 979, 5694, 2061, 6801, 7854, 7761, 5091, 2534],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [445, 5695, 7685, 4576, 6695, 7121, 1656, 2585, 5447, 449, 2537],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7003, 7697, 812, 6862, 3430, 2690, 5442, 2481, 6837, 5832, 2539],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2900, 2497, 2839, 405, 9831, 1021, 9272, 5857, 2185, 1241, 2542],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4390, 689, 5536, 1287, 6219, 3534, 97, 3568, 1746, 6675, 2544],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6196, 2871, 1290, 9054, 6160, 6200, 6114, 9007, 5773, 2134, 2547],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2891, 2978, 30, 537, 8075, 9149, 2199, 8117, 4522, 7619, 2549],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [206, 6718, 8310, 9982, 4995, 739, 5368, 9384, 8247, 3129, 2552],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7847, 9955, 3030, 4605, 8431, 6345, 257, 3847, 7204, 8665, 2554],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1674, 2178, 2944, 6824, 4802, 2131, 4641, 5094, 1647, 4227, 2557],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5063, 9079, 624, 2082, 5505, 4044, 4961, 9271, 1832, 9814, 2559],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3346, 8820, 892, 4265, 4180, 2304, 1892, 5080, 8016, 5426, 2562],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [652, 2682, 4054, 9434, 7342, 1629, 5926, 3782, 454, 1065, 2565],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1133, 310, 9217, 2802, 7066, 7464, 2986, 9203, 9402, 6728, 2567],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7065, 6283, 103, 3721, 6989, 8459, 66, 7732, 5118, 2418, 2570],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4499, 859, 9218, 8866, 5468, 5462, 892, 8326, 7858, 8133, 2572],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2081, 7155, 2182, 4912, 2267, 7277, 1612, 2513, 7880, 3874, 2575],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3504, 7344, 9051, 8669, 7735, 3446, 6514, 4393, 5440, 9641, 2577],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7991, 5581, 202, 5160, 6016, 4317, 3763, 643, 797, 5434, 2580],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7215, 8304, 8024, 2169, 6370, 8642, 1171, 516, 4208, 1252, 2583],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7291, 7692, 9353, 3768, 9301, 8980, 1989, 5846, 5931, 7096, 2585],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9577, 9986, 4966, 4890, 6736, 5151, 724, 1051, 6226, 2966, 2588],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9639, 2282, 9279, 4530, 8090, 6000, 8983, 3133, 5350, 8862, 2590],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1831, 3812, 3681, 6383, 6638, 9738, 1345, 1686, 3563, 4784, 2593],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1327, 6929, 9092, 2823, 3198, 3107, 1257, 8890, 1123, 732, 2596],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3090, 9763, 5796, 1145, 6711, 9636, 6951, 9521, 8291, 6705, 2598],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5319, 4516, 347, 9806, 3909, 7248, 7400, 952, 5327, 2705, 2601],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3834, 21, 9337, 7247, 2845, 5467, 8284, 3153, 2489, 8731, 2603],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6047, 3940, 7490, 6591, 7646, 2499, 7994, 8696, 38, 4783, 2606],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8050, 3173, 2449, 6215, 4481, 2439, 3656, 2757, 8236, 860, 2609],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2869, 2312, 657, 8948, 1298, 2860, 7184, 3117, 7342, 6964, 2611],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3467, 982, 8036, 1349, 6517, 3056, 1357, 169, 7618, 3094, 2614],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9020, 5851, 6068, 9331, 4450, 3194, 5923, 6914, 9324, 9250, 2616],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1518, 1331, 9105, 7250, 7862, 4628, 3729, 8971, 2723, 5433, 2619],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6762, 1744, 3114, 4582, 644, 1655, 6878, 4573, 8077, 1641, 2622],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5520, 4551, 855, 7371, 6246, 4951, 2909, 4575, 5647, 7876, 2624],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1895, 9607, 5011, 935, 90, 6977, 1009, 2452, 5696, 4137, 2627],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2959, 9679, 857, 5726, 6812, 9583, 8245, 4304, 8486, 424, 2630],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3811, 6869, 5523, 9900, 5829, 4110, 5827, 8861, 4280, 6738, 2632],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8639, 3523, 4057, 58, 1310, 4217, 5392, 7480, 3342, 3078, 2635],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2620, 3395, 5762, 5725, 5288, 1721, 5322, 4152, 5935, 9444, 2637],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8715, 4085, 441, 3613, 5287, 5706, 7080, 5503, 2322, 5837, 2640],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4706, 8754, 6216, 4420, 423, 5156, 1580, 798, 2768, 2256, 2643],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6871, 8630, 1781, 8044, 2637, 5386, 5576, 1940, 7536, 8701, 2645],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2056, 6993, 9804, 2497, 2307, 8535, 8083, 3478, 6891, 5173, 2648],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4780, 5485, 8550, 7709, 144, 8375, 6823, 2606, 1098, 1672, 2651],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4822, 9789, 9659, 7611, 9936, 9710, 4695, 9166, 421, 8197, 2653],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4022, 483, 5756, 2660, 9311, 2632, 6276, 5651, 5127, 4748, 2656],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6586, 7650, 6726, 100, 8380, 1882, 4342, 7209, 5480, 1326, 2659],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9900, 2957, 3000, 972, 8748, 1604, 6424, 1643, 1747, 7931, 2661],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8892, 8794, 3012, 1061, 8039, 5742, 1383, 9417, 4192, 4562, 2664],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6176, 1475, 5746, 7754, 7739, 4350, 6017, 3654, 3084, 1220, 2667],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4068, 406, 3329, 6095, 4827, 6083, 1689, 145, 8688, 7904, 2669],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [676, 1277, 9173, 5273, 306, 7132, 988, 7345, 1270, 4616, 2672],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6344, 2974, 118, 1361, 440, 6872, 4412, 6380, 1099, 1354, 2675],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9885, 2388, 3054, 3319, 9139, 490, 7080, 1049, 8442, 8118, 2677],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7693, 1728, 4164, 7243, 2630, 8861, 5467, 7826, 3565, 4910, 2680],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5987, 989, 9290, 8402, 204, 5928, 4176, 5862, 6738, 1728, 2683],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9374, 6541, 4189, 2026, 7518, 3876, 2721, 6989, 8228, 8573, 2685],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4048, 1958, 1157, 1892, 1601, 6351, 2350, 5722, 8304, 5445, 2688],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2932, 2180, 1397, 710, 9404, 9987, 2890, 9262, 7234, 2344, 2691],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8353, 9082, 8715, 8018, 4396, 4537, 9619, 7498, 5288, 9270, 2693],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9050, 9423, 7853, 9900, 8423, 1838, 162, 3013, 2735, 6223, 2696],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6420, 3552, 8706, 277, 8705, 3918, 1420, 1079, 9844, 3202, 2699],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [2683, 816, 4618, 5900, 2560, 483, 6523, 9668, 6884, 209, 2702],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8029, 928, 8030, 6422, 5140, 6070, 1806, 9452, 4127, 7243, 2704],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8341, 7829, 9373, 7190, 8125, 7137, 3821, 3802, 1843, 4304, 2707],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9309, 7215, 4932, 5580, 72, 9349, 6366, 8796, 301, 1392, 2710],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8165, 2394, 6343, 1940, 1777, 5335, 7549, 3219, 9774, 8506, 2712],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [7834, 7487, 8690, 3452, 2733, 3198, 6873, 8566, 531, 5649, 2715],
    },
];

// e^x, x = 1,10,100
pub(crate) const EXP_VALUES2: [BigFloatInc; 3] = [
    BigFloatInc {
        m: [2471, 7757, 6249, 3526, 7471, 6028, 2353, 9045, 2845, 2818, 2718],
        n: 44,
        sign: 1,
        e: -43,
    },
    BigFloatInc {
        m: [3513, 6635, 2443, 5284, 64, 9579, 6516, 671, 7948, 6465, 2202],
        n: 44,
        sign: 1,
        e: -39,
    },
    BigFloatInc {
        m: [1119, 7361, 1358, 5800, 5551, 1262, 4484, 6135, 4181, 1171, 2688],
        n: 44,
        sign: 1,
        e: 0,
    },
];
