# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AvailabilityStatus(_serialization.Model):
    """availabilityStatus of a resource.

    :ivar id: Azure Resource Manager Identity for the availabilityStatuses resource.
    :vartype id: str
    :ivar name: current.
    :vartype name: str
    :ivar type: Microsoft.ResourceHealth/AvailabilityStatuses.
    :vartype type: str
    :ivar location: Azure Resource Manager geo location of the resource.
    :vartype location: str
    :ivar properties: Properties of availability state.
    :vartype properties:
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStatusProperties
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AvailabilityStatusProperties"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        location: Optional[str] = None,
        properties: Optional["_models.AvailabilityStatusProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Azure Resource Manager Identity for the availabilityStatuses resource.
        :paramtype id: str
        :keyword name: current.
        :paramtype name: str
        :keyword type: Microsoft.ResourceHealth/AvailabilityStatuses.
        :paramtype type: str
        :keyword location: Azure Resource Manager geo location of the resource.
        :paramtype location: str
        :keyword properties: Properties of availability state.
        :paramtype properties:
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStatusProperties
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.location = location
        self.properties = properties


class AvailabilityStatusListResult(_serialization.Model):
    """The List availabilityStatus operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of availabilityStatuses. Required.
    :vartype value: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStatus]
    :ivar next_link: The URI to fetch the next page of availabilityStatuses. Call ListNext() with
     this URI to fetch the next page of availabilityStatuses.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailabilityStatus]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AvailabilityStatus"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of availabilityStatuses. Required.
        :paramtype value:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStatus]
        :keyword next_link: The URI to fetch the next page of availabilityStatuses. Call ListNext()
         with this URI to fetch the next page of availabilityStatuses.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailabilityStatusProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties of availability state.

    :ivar availability_state: Availability status of the resource. When it is null, this
     availabilityStatus object represents an availability impacting event. Known values are:
     "Available", "Unavailable", "Degraded", and "Unknown".
    :vartype availability_state: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStateValues
    :ivar title: Title description of the availability status.
    :vartype title: str
    :ivar summary: Summary description of the availability status.
    :vartype summary: str
    :ivar detailed_status: Details of the availability status.
    :vartype detailed_status: str
    :ivar reason_type: When the resource's availabilityState is Unavailable, it describes where the
     health impacting event was originated. Examples are planned, unplanned, user initiated or an
     outage etc.
    :vartype reason_type: str
    :ivar context: When an event is created, it can either be triggered by a customer or the
     platform of the resource and this field will illustrate that. This field is connected to the
     category field in this object.
    :vartype context: str
    :ivar category: When a context field is set to Platform, this field will reflect if the event
     was planned or unplanned. If the context field does not have a value of Platform, then this
     field will be ignored.
    :vartype category: str
    :ivar article_id: The Article Id.
    :vartype article_id: str
    :ivar root_cause_attribution_time: When the resource's availabilityState is Unavailable, it
     provides the Timestamp for when the health impacting event was received.
    :vartype root_cause_attribution_time: ~datetime.datetime
    :ivar health_event_type: In case of an availability impacting event, it describes when the
     health impacting event was originated. Examples are Lifecycle, Downtime, Fault Analysis etc.
    :vartype health_event_type: str
    :ivar health_event_cause: In case of an availability impacting event, it describes where the
     health impacting event was originated. Examples are PlatformInitiated, UserInitiated etc.
    :vartype health_event_cause: str
    :ivar health_event_category: In case of an availability impacting event, it describes the
     category of a PlatformInitiated health impacting event. Examples are Planned, Unplanned etc.
    :vartype health_event_category: str
    :ivar health_event_id: It is a unique Id that identifies the event.
    :vartype health_event_id: str
    :ivar resolution_eta: When the resource's availabilityState is Unavailable and the reasonType
     is not User Initiated, it provides the date and time for when the issue is expected to be
     resolved.
    :vartype resolution_eta: ~datetime.datetime
    :ivar occured_time: Timestamp for when last change in health status occurred.
    :vartype occured_time: ~datetime.datetime
    :ivar reason_chronicity: Chronicity of the availability transition. Known values are:
     "Transient" and "Persistent".
    :vartype reason_chronicity: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ReasonChronicityTypes
    :ivar reported_time: Timestamp for when the health was last checked.
    :vartype reported_time: ~datetime.datetime
    :ivar recently_resolved: An annotation describing a change in the availabilityState to
     Available from Unavailable with a reasonType of type Unplanned.
    :vartype recently_resolved:
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStatusPropertiesRecentlyResolved
    :ivar recommended_actions: Lists actions the user can take based on the current
     availabilityState of the resource.
    :vartype recommended_actions:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.RecommendedAction]
    :ivar service_impacting_events: Lists the service impacting events that may be affecting the
     health of the resource.
    :vartype service_impacting_events:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ServiceImpactingEvent]
    """

    _attribute_map = {
        "availability_state": {"key": "availabilityState", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "summary": {"key": "summary", "type": "str"},
        "detailed_status": {"key": "detailedStatus", "type": "str"},
        "reason_type": {"key": "reasonType", "type": "str"},
        "context": {"key": "context", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "article_id": {"key": "articleId", "type": "str"},
        "root_cause_attribution_time": {"key": "rootCauseAttributionTime", "type": "iso-8601"},
        "health_event_type": {"key": "healthEventType", "type": "str"},
        "health_event_cause": {"key": "healthEventCause", "type": "str"},
        "health_event_category": {"key": "healthEventCategory", "type": "str"},
        "health_event_id": {"key": "healthEventId", "type": "str"},
        "resolution_eta": {"key": "resolutionETA", "type": "iso-8601"},
        "occured_time": {"key": "occuredTime", "type": "iso-8601"},
        "reason_chronicity": {"key": "reasonChronicity", "type": "str"},
        "reported_time": {"key": "reportedTime", "type": "iso-8601"},
        "recently_resolved": {"key": "recentlyResolved", "type": "AvailabilityStatusPropertiesRecentlyResolved"},
        "recommended_actions": {"key": "recommendedActions", "type": "[RecommendedAction]"},
        "service_impacting_events": {"key": "serviceImpactingEvents", "type": "[ServiceImpactingEvent]"},
    }

    def __init__(
        self,
        *,
        availability_state: Optional[Union[str, "_models.AvailabilityStateValues"]] = None,
        title: Optional[str] = None,
        summary: Optional[str] = None,
        detailed_status: Optional[str] = None,
        reason_type: Optional[str] = None,
        context: Optional[str] = None,
        category: Optional[str] = None,
        article_id: Optional[str] = None,
        root_cause_attribution_time: Optional[datetime.datetime] = None,
        health_event_type: Optional[str] = None,
        health_event_cause: Optional[str] = None,
        health_event_category: Optional[str] = None,
        health_event_id: Optional[str] = None,
        resolution_eta: Optional[datetime.datetime] = None,
        occured_time: Optional[datetime.datetime] = None,
        reason_chronicity: Optional[Union[str, "_models.ReasonChronicityTypes"]] = None,
        reported_time: Optional[datetime.datetime] = None,
        recently_resolved: Optional["_models.AvailabilityStatusPropertiesRecentlyResolved"] = None,
        recommended_actions: Optional[List["_models.RecommendedAction"]] = None,
        service_impacting_events: Optional[List["_models.ServiceImpactingEvent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword availability_state: Availability status of the resource. When it is null, this
         availabilityStatus object represents an availability impacting event. Known values are:
         "Available", "Unavailable", "Degraded", and "Unknown".
        :paramtype availability_state: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStateValues
        :keyword title: Title description of the availability status.
        :paramtype title: str
        :keyword summary: Summary description of the availability status.
        :paramtype summary: str
        :keyword detailed_status: Details of the availability status.
        :paramtype detailed_status: str
        :keyword reason_type: When the resource's availabilityState is Unavailable, it describes where
         the health impacting event was originated. Examples are planned, unplanned, user initiated or
         an outage etc.
        :paramtype reason_type: str
        :keyword context: When an event is created, it can either be triggered by a customer or the
         platform of the resource and this field will illustrate that. This field is connected to the
         category field in this object.
        :paramtype context: str
        :keyword category: When a context field is set to Platform, this field will reflect if the
         event was planned or unplanned. If the context field does not have a value of Platform, then
         this field will be ignored.
        :paramtype category: str
        :keyword article_id: The Article Id.
        :paramtype article_id: str
        :keyword root_cause_attribution_time: When the resource's availabilityState is Unavailable, it
         provides the Timestamp for when the health impacting event was received.
        :paramtype root_cause_attribution_time: ~datetime.datetime
        :keyword health_event_type: In case of an availability impacting event, it describes when the
         health impacting event was originated. Examples are Lifecycle, Downtime, Fault Analysis etc.
        :paramtype health_event_type: str
        :keyword health_event_cause: In case of an availability impacting event, it describes where the
         health impacting event was originated. Examples are PlatformInitiated, UserInitiated etc.
        :paramtype health_event_cause: str
        :keyword health_event_category: In case of an availability impacting event, it describes the
         category of a PlatformInitiated health impacting event. Examples are Planned, Unplanned etc.
        :paramtype health_event_category: str
        :keyword health_event_id: It is a unique Id that identifies the event.
        :paramtype health_event_id: str
        :keyword resolution_eta: When the resource's availabilityState is Unavailable and the
         reasonType is not User Initiated, it provides the date and time for when the issue is expected
         to be resolved.
        :paramtype resolution_eta: ~datetime.datetime
        :keyword occured_time: Timestamp for when last change in health status occurred.
        :paramtype occured_time: ~datetime.datetime
        :keyword reason_chronicity: Chronicity of the availability transition. Known values are:
         "Transient" and "Persistent".
        :paramtype reason_chronicity: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ReasonChronicityTypes
        :keyword reported_time: Timestamp for when the health was last checked.
        :paramtype reported_time: ~datetime.datetime
        :keyword recently_resolved: An annotation describing a change in the availabilityState to
         Available from Unavailable with a reasonType of type Unplanned.
        :paramtype recently_resolved:
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStatusPropertiesRecentlyResolved
        :keyword recommended_actions: Lists actions the user can take based on the current
         availabilityState of the resource.
        :paramtype recommended_actions:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.RecommendedAction]
        :keyword service_impacting_events: Lists the service impacting events that may be affecting the
         health of the resource.
        :paramtype service_impacting_events:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ServiceImpactingEvent]
        """
        super().__init__(**kwargs)
        self.availability_state = availability_state
        self.title = title
        self.summary = summary
        self.detailed_status = detailed_status
        self.reason_type = reason_type
        self.context = context
        self.category = category
        self.article_id = article_id
        self.root_cause_attribution_time = root_cause_attribution_time
        self.health_event_type = health_event_type
        self.health_event_cause = health_event_cause
        self.health_event_category = health_event_category
        self.health_event_id = health_event_id
        self.resolution_eta = resolution_eta
        self.occured_time = occured_time
        self.reason_chronicity = reason_chronicity
        self.reported_time = reported_time
        self.recently_resolved = recently_resolved
        self.recommended_actions = recommended_actions
        self.service_impacting_events = service_impacting_events


class AvailabilityStatusPropertiesRecentlyResolved(_serialization.Model):
    """An annotation describing a change in the availabilityState to Available from Unavailable with a
    reasonType of type Unplanned.

    :ivar unavailable_occured_time: Timestamp for when the availabilityState changed to
     Unavailable.
    :vartype unavailable_occured_time: ~datetime.datetime
    :ivar resolved_time: Timestamp when the availabilityState changes to Available.
    :vartype resolved_time: ~datetime.datetime
    :ivar unavailable_summary: Brief description of cause of the resource becoming unavailable.
    :vartype unavailable_summary: str
    """

    _attribute_map = {
        "unavailable_occured_time": {"key": "unavailableOccuredTime", "type": "iso-8601"},
        "resolved_time": {"key": "resolvedTime", "type": "iso-8601"},
        "unavailable_summary": {"key": "unavailableSummary", "type": "str"},
    }

    def __init__(
        self,
        *,
        unavailable_occured_time: Optional[datetime.datetime] = None,
        resolved_time: Optional[datetime.datetime] = None,
        unavailable_summary: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unavailable_occured_time: Timestamp for when the availabilityState changed to
         Unavailable.
        :paramtype unavailable_occured_time: ~datetime.datetime
        :keyword resolved_time: Timestamp when the availabilityState changes to Available.
        :paramtype resolved_time: ~datetime.datetime
        :keyword unavailable_summary: Brief description of cause of the resource becoming unavailable.
        :paramtype unavailable_summary: str
        """
        super().__init__(**kwargs)
        self.unavailable_occured_time = unavailable_occured_time
        self.resolved_time = resolved_time
        self.unavailable_summary = unavailable_summary


class EmergingIssueImpact(_serialization.Model):
    """Object of the emerging issue impact on services and regions.

    :ivar id: The impacted service id.
    :vartype id: str
    :ivar name: The impacted service name.
    :vartype name: str
    :ivar regions: The list of impacted regions for corresponding emerging issues.
    :vartype regions: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ImpactedRegion]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "regions": {"key": "regions", "type": "[ImpactedRegion]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        regions: Optional[List["_models.ImpactedRegion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The impacted service id.
        :paramtype id: str
        :keyword name: The impacted service name.
        :paramtype name: str
        :keyword regions: The list of impacted regions for corresponding emerging issues.
        :paramtype regions: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ImpactedRegion]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.regions = regions


class EmergingIssueListResult(_serialization.Model):
    """The list of emerging issues.

    :ivar value: The list of emerging issues.
    :vartype value:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EmergingIssuesGetResult]
    :ivar next_link: The link used to get the next page of emerging issues.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EmergingIssuesGetResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EmergingIssuesGetResult"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of emerging issues.
        :paramtype value:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EmergingIssuesGetResult]
        :keyword next_link: The link used to get the next page of emerging issues.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class EmergingIssuesGetResult(ProxyResource):
    """The Get EmergingIssues operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SystemData
    :ivar refresh_timestamp: Timestamp for when last time refreshed for ongoing emerging issue.
    :vartype refresh_timestamp: ~datetime.datetime
    :ivar status_banners: The list of emerging issues of banner type.
    :vartype status_banners:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.StatusBanner]
    :ivar status_active_events: The list of emerging issues of active event type.
    :vartype status_active_events:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.StatusActiveEvent]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "refresh_timestamp": {"key": "properties.refreshTimestamp", "type": "iso-8601"},
        "status_banners": {"key": "properties.statusBanners", "type": "[StatusBanner]"},
        "status_active_events": {"key": "properties.statusActiveEvents", "type": "[StatusActiveEvent]"},
    }

    def __init__(
        self,
        *,
        refresh_timestamp: Optional[datetime.datetime] = None,
        status_banners: Optional[List["_models.StatusBanner"]] = None,
        status_active_events: Optional[List["_models.StatusActiveEvent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword refresh_timestamp: Timestamp for when last time refreshed for ongoing emerging issue.
        :paramtype refresh_timestamp: ~datetime.datetime
        :keyword status_banners: The list of emerging issues of banner type.
        :paramtype status_banners:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.StatusBanner]
        :keyword status_active_events: The list of emerging issues of active event type.
        :paramtype status_active_events:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.StatusActiveEvent]
        """
        super().__init__(**kwargs)
        self.refresh_timestamp = refresh_timestamp
        self.status_banners = status_banners
        self.status_active_events = status_active_events


class ErrorResponse(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class Event(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Service health event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SystemData
    :ivar event_type: Type of event. Known values are: "ServiceIssue", "PlannedMaintenance",
     "HealthAdvisory", "RCA", "EmergingIssues", and "SecurityAdvisory".
    :vartype event_type: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventTypeValues
    :ivar event_sub_type: Sub type of the event. Currently used to determine retirement
     communications for health advisory events. "Retirement"
    :vartype event_sub_type: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventSubTypeValues
    :ivar event_source: Source of event. Known values are: "ResourceHealth" and "ServiceHealth".
    :vartype event_source: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventSourceValues
    :ivar status: Current status of event. Known values are: "Active" and "Resolved".
    :vartype status: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventStatusValues
    :ivar title: Title text of event.
    :vartype title: str
    :ivar summary: Summary text of event.
    :vartype summary: str
    :ivar header: Header text of event.
    :vartype header: str
    :ivar level: Level of insight. Known values are: "Critical" and "Warning".
    :vartype level: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.LevelValues
    :ivar event_level: Level of event. Known values are: "Critical", "Error", "Warning", and
     "Informational".
    :vartype event_level: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventLevelValues
    :ivar external_incident_id: The id of the Incident.
    :vartype external_incident_id: str
    :ivar reason: The reason for the Incident.
    :vartype reason: str
    :ivar article: Article of event.
    :vartype article: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesArticle
    :ivar links: Useful links of event.
    :vartype links: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Link]
    :ivar impact_start_time: It provides the Timestamp for when the health impacting event started.
    :vartype impact_start_time: ~datetime.datetime
    :ivar impact_mitigation_time: It provides the Timestamp for when the health impacting event
     resolved.
    :vartype impact_mitigation_time: ~datetime.datetime
    :ivar impact: List services impacted by the service health event.
    :vartype impact: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Impact]
    :ivar recommended_actions: Recommended actions of event.
    :vartype recommended_actions:
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesRecommendedActions
    :ivar faqs: Frequently asked questions for the service health event.
    :vartype faqs: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Faq]
    :ivar is_hir: It provides information if the event is High incident rate event or not.
    :vartype is_hir: bool
    :ivar enable_microsoft_support: Tells if we want to enable or disable Microsoft Support for
     this event.
    :vartype enable_microsoft_support: bool
    :ivar description: Contains the communication message for the event, that could include
     summary, root cause and other details.
    :vartype description: str
    :ivar platform_initiated: Is true if the event is platform initiated.
    :vartype platform_initiated: bool
    :ivar enable_chat_with_us: Tells if we want to enable or disable Microsoft Support for this
     event.
    :vartype enable_chat_with_us: bool
    :ivar priority: Priority level of the event. Has value from 0 to 23. 0 is the highest priority.
     Service issue events have higher priority followed by planned maintenance and health advisory.
     Critical events have higher priority followed by error, warning and informational. Furthermore,
     active events have higher priority than resolved.
    :vartype priority: int
    :ivar last_update_time: It provides the Timestamp for when the health impacting event was last
     updated.
    :vartype last_update_time: ~datetime.datetime
    :ivar hir_stage: Stage for HIR Document.
    :vartype hir_stage: str
    :ivar additional_information: Additional information.
    :vartype additional_information:
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesAdditionalInformation
    :ivar duration: duration in seconds.
    :vartype duration: int
    :ivar impact_type: The type of the impact.
    :vartype impact_type: str
    :ivar maintenance_id: Unique identifier for planned maintenance event.
    :vartype maintenance_id: str
    :ivar maintenance_type: The type of planned maintenance event.
    :vartype maintenance_type: str
    :ivar arg_query: Azure Resource Graph query to fetch the affected resources from their existing
     Azure Resource Graph locations.
    :vartype arg_query: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "event_type": {"key": "properties.eventType", "type": "str"},
        "event_sub_type": {"key": "properties.eventSubType", "type": "str"},
        "event_source": {"key": "properties.eventSource", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "summary": {"key": "properties.summary", "type": "str"},
        "header": {"key": "properties.header", "type": "str"},
        "level": {"key": "properties.level", "type": "str"},
        "event_level": {"key": "properties.eventLevel", "type": "str"},
        "external_incident_id": {"key": "properties.externalIncidentId", "type": "str"},
        "reason": {"key": "properties.reason", "type": "str"},
        "article": {"key": "properties.article", "type": "EventPropertiesArticle"},
        "links": {"key": "properties.links", "type": "[Link]"},
        "impact_start_time": {"key": "properties.impactStartTime", "type": "iso-8601"},
        "impact_mitigation_time": {"key": "properties.impactMitigationTime", "type": "iso-8601"},
        "impact": {"key": "properties.impact", "type": "[Impact]"},
        "recommended_actions": {"key": "properties.recommendedActions", "type": "EventPropertiesRecommendedActions"},
        "faqs": {"key": "properties.faqs", "type": "[Faq]"},
        "is_hir": {"key": "properties.isHIR", "type": "bool"},
        "enable_microsoft_support": {"key": "properties.enableMicrosoftSupport", "type": "bool"},
        "description": {"key": "properties.description", "type": "str"},
        "platform_initiated": {"key": "properties.platformInitiated", "type": "bool"},
        "enable_chat_with_us": {"key": "properties.enableChatWithUs", "type": "bool"},
        "priority": {"key": "properties.priority", "type": "int"},
        "last_update_time": {"key": "properties.lastUpdateTime", "type": "iso-8601"},
        "hir_stage": {"key": "properties.hirStage", "type": "str"},
        "additional_information": {
            "key": "properties.additionalInformation",
            "type": "EventPropertiesAdditionalInformation",
        },
        "duration": {"key": "properties.duration", "type": "int"},
        "impact_type": {"key": "properties.impactType", "type": "str"},
        "maintenance_id": {"key": "properties.maintenanceId", "type": "str"},
        "maintenance_type": {"key": "properties.maintenanceType", "type": "str"},
        "arg_query": {"key": "properties.argQuery", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        event_type: Optional[Union[str, "_models.EventTypeValues"]] = None,
        event_sub_type: Optional[Union[str, "_models.EventSubTypeValues"]] = None,
        event_source: Optional[Union[str, "_models.EventSourceValues"]] = None,
        status: Optional[Union[str, "_models.EventStatusValues"]] = None,
        title: Optional[str] = None,
        summary: Optional[str] = None,
        header: Optional[str] = None,
        level: Optional[Union[str, "_models.LevelValues"]] = None,
        event_level: Optional[Union[str, "_models.EventLevelValues"]] = None,
        external_incident_id: Optional[str] = None,
        reason: Optional[str] = None,
        article: Optional["_models.EventPropertiesArticle"] = None,
        links: Optional[List["_models.Link"]] = None,
        impact_start_time: Optional[datetime.datetime] = None,
        impact_mitigation_time: Optional[datetime.datetime] = None,
        impact: Optional[List["_models.Impact"]] = None,
        recommended_actions: Optional["_models.EventPropertiesRecommendedActions"] = None,
        faqs: Optional[List["_models.Faq"]] = None,
        is_hir: Optional[bool] = None,
        enable_microsoft_support: Optional[bool] = None,
        description: Optional[str] = None,
        platform_initiated: Optional[bool] = None,
        enable_chat_with_us: Optional[bool] = None,
        priority: Optional[int] = None,
        last_update_time: Optional[datetime.datetime] = None,
        hir_stage: Optional[str] = None,
        additional_information: Optional["_models.EventPropertiesAdditionalInformation"] = None,
        duration: Optional[int] = None,
        impact_type: Optional[str] = None,
        maintenance_id: Optional[str] = None,
        maintenance_type: Optional[str] = None,
        arg_query: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword event_type: Type of event. Known values are: "ServiceIssue", "PlannedMaintenance",
         "HealthAdvisory", "RCA", "EmergingIssues", and "SecurityAdvisory".
        :paramtype event_type: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventTypeValues
        :keyword event_sub_type: Sub type of the event. Currently used to determine retirement
         communications for health advisory events. "Retirement"
        :paramtype event_sub_type: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventSubTypeValues
        :keyword event_source: Source of event. Known values are: "ResourceHealth" and "ServiceHealth".
        :paramtype event_source: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventSourceValues
        :keyword status: Current status of event. Known values are: "Active" and "Resolved".
        :paramtype status: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventStatusValues
        :keyword title: Title text of event.
        :paramtype title: str
        :keyword summary: Summary text of event.
        :paramtype summary: str
        :keyword header: Header text of event.
        :paramtype header: str
        :keyword level: Level of insight. Known values are: "Critical" and "Warning".
        :paramtype level: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.LevelValues
        :keyword event_level: Level of event. Known values are: "Critical", "Error", "Warning", and
         "Informational".
        :paramtype event_level: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventLevelValues
        :keyword external_incident_id: The id of the Incident.
        :paramtype external_incident_id: str
        :keyword reason: The reason for the Incident.
        :paramtype reason: str
        :keyword article: Article of event.
        :paramtype article:
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesArticle
        :keyword links: Useful links of event.
        :paramtype links: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Link]
        :keyword impact_start_time: It provides the Timestamp for when the health impacting event
         started.
        :paramtype impact_start_time: ~datetime.datetime
        :keyword impact_mitigation_time: It provides the Timestamp for when the health impacting event
         resolved.
        :paramtype impact_mitigation_time: ~datetime.datetime
        :keyword impact: List services impacted by the service health event.
        :paramtype impact: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Impact]
        :keyword recommended_actions: Recommended actions of event.
        :paramtype recommended_actions:
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesRecommendedActions
        :keyword faqs: Frequently asked questions for the service health event.
        :paramtype faqs: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Faq]
        :keyword is_hir: It provides information if the event is High incident rate event or not.
        :paramtype is_hir: bool
        :keyword enable_microsoft_support: Tells if we want to enable or disable Microsoft Support for
         this event.
        :paramtype enable_microsoft_support: bool
        :keyword description: Contains the communication message for the event, that could include
         summary, root cause and other details.
        :paramtype description: str
        :keyword platform_initiated: Is true if the event is platform initiated.
        :paramtype platform_initiated: bool
        :keyword enable_chat_with_us: Tells if we want to enable or disable Microsoft Support for this
         event.
        :paramtype enable_chat_with_us: bool
        :keyword priority: Priority level of the event. Has value from 0 to 23. 0 is the highest
         priority. Service issue events have higher priority followed by planned maintenance and health
         advisory. Critical events have higher priority followed by error, warning and informational.
         Furthermore, active events have higher priority than resolved.
        :paramtype priority: int
        :keyword last_update_time: It provides the Timestamp for when the health impacting event was
         last updated.
        :paramtype last_update_time: ~datetime.datetime
        :keyword hir_stage: Stage for HIR Document.
        :paramtype hir_stage: str
        :keyword additional_information: Additional information.
        :paramtype additional_information:
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesAdditionalInformation
        :keyword duration: duration in seconds.
        :paramtype duration: int
        :keyword impact_type: The type of the impact.
        :paramtype impact_type: str
        :keyword maintenance_id: Unique identifier for planned maintenance event.
        :paramtype maintenance_id: str
        :keyword maintenance_type: The type of planned maintenance event.
        :paramtype maintenance_type: str
        :keyword arg_query: Azure Resource Graph query to fetch the affected resources from their
         existing Azure Resource Graph locations.
        :paramtype arg_query: str
        """
        super().__init__(**kwargs)
        self.event_type = event_type
        self.event_sub_type = event_sub_type
        self.event_source = event_source
        self.status = status
        self.title = title
        self.summary = summary
        self.header = header
        self.level = level
        self.event_level = event_level
        self.external_incident_id = external_incident_id
        self.reason = reason
        self.article = article
        self.links = links
        self.impact_start_time = impact_start_time
        self.impact_mitigation_time = impact_mitigation_time
        self.impact = impact
        self.recommended_actions = recommended_actions
        self.faqs = faqs
        self.is_hir = is_hir
        self.enable_microsoft_support = enable_microsoft_support
        self.description = description
        self.platform_initiated = platform_initiated
        self.enable_chat_with_us = enable_chat_with_us
        self.priority = priority
        self.last_update_time = last_update_time
        self.hir_stage = hir_stage
        self.additional_information = additional_information
        self.duration = duration
        self.impact_type = impact_type
        self.maintenance_id = maintenance_id
        self.maintenance_type = maintenance_type
        self.arg_query = arg_query


class EventImpactedResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Impacted resource for an event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SystemData
    :ivar target_resource_type: Resource type within Microsoft cloud.
    :vartype target_resource_type: str
    :ivar target_resource_id: Identity for resource within Microsoft cloud.
    :vartype target_resource_id: str
    :ivar target_region: Impacted resource region name.
    :vartype target_region: str
    :ivar resource_name: Resource name of the impacted resource.
    :vartype resource_name: str
    :ivar resource_group: Resource group name of the impacted resource.
    :vartype resource_group: str
    :ivar status: Status of the impacted resource.
    :vartype status: str
    :ivar maintenance_start_time: Start time of maintenance for the impacted resource.
    :vartype maintenance_start_time: str
    :ivar maintenance_end_time: End time of maintenance for the impacted resource.
    :vartype maintenance_end_time: str
    :ivar info: Additional information.
    :vartype info: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.KeyValueItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "target_resource_type": {"readonly": True},
        "target_resource_id": {"readonly": True},
        "target_region": {"readonly": True},
        "resource_name": {"readonly": True},
        "resource_group": {"readonly": True},
        "status": {"readonly": True},
        "maintenance_start_time": {"readonly": True},
        "maintenance_end_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "target_resource_type": {"key": "properties.targetResourceType", "type": "str"},
        "target_resource_id": {"key": "properties.targetResourceId", "type": "str"},
        "target_region": {"key": "properties.targetRegion", "type": "str"},
        "resource_name": {"key": "properties.resourceName", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "maintenance_start_time": {"key": "properties.maintenanceStartTime", "type": "str"},
        "maintenance_end_time": {"key": "properties.maintenanceEndTime", "type": "str"},
        "info": {"key": "properties.info", "type": "[KeyValueItem]"},
    }

    def __init__(self, *, info: Optional[List["_models.KeyValueItem"]] = None, **kwargs: Any) -> None:
        """
        :keyword info: Additional information.
        :paramtype info: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.KeyValueItem]
        """
        super().__init__(**kwargs)
        self.target_resource_type = None
        self.target_resource_id = None
        self.target_region = None
        self.resource_name = None
        self.resource_group = None
        self.status = None
        self.maintenance_start_time = None
        self.maintenance_end_time = None
        self.info = info


class EventImpactedResourceListResult(_serialization.Model):
    """The List of eventImpactedResources operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of eventImpactedResources. Required.
    :vartype value:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventImpactedResource]
    :ivar next_link: The URI to fetch the next page of events. Call ListNext() with this URI to
     fetch the next page of impacted resource.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EventImpactedResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.EventImpactedResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of eventImpactedResources. Required.
        :paramtype value:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventImpactedResource]
        :keyword next_link: The URI to fetch the next page of events. Call ListNext() with this URI to
         fetch the next page of impacted resource.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventPropertiesAdditionalInformation(_serialization.Model):
    """Additional information.

    :ivar message: Additional information Message.
    :vartype message: str
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword message: Additional information Message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.message = message


class EventPropertiesArticle(_serialization.Model):
    """Article of event.

    :ivar article_content: Article content of event.
    :vartype article_content: str
    :ivar article_id: Article Id.
    :vartype article_id: str
    :ivar parameters: It provides a map of parameter name and value.
    :vartype parameters: JSON
    """

    _attribute_map = {
        "article_content": {"key": "articleContent", "type": "str"},
        "article_id": {"key": "articleId", "type": "str"},
        "parameters": {"key": "parameters", "type": "object"},
    }

    def __init__(
        self,
        *,
        article_content: Optional[str] = None,
        article_id: Optional[str] = None,
        parameters: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword article_content: Article content of event.
        :paramtype article_content: str
        :keyword article_id: Article Id.
        :paramtype article_id: str
        :keyword parameters: It provides a map of parameter name and value.
        :paramtype parameters: JSON
        """
        super().__init__(**kwargs)
        self.article_content = article_content
        self.article_id = article_id
        self.parameters = parameters


class EventPropertiesRecommendedActions(_serialization.Model):
    """Recommended actions of event.

    :ivar message: Recommended action title for the service health event.
    :vartype message: str
    :ivar actions: Recommended actions for the service health event.
    :vartype actions:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesRecommendedActionsItem]
    :ivar locale_code: Recommended action locale for the service health event.
    :vartype locale_code: str
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "actions": {"key": "actions", "type": "[EventPropertiesRecommendedActionsItem]"},
        "locale_code": {"key": "localeCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        actions: Optional[List["_models.EventPropertiesRecommendedActionsItem"]] = None,
        locale_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message: Recommended action title for the service health event.
        :paramtype message: str
        :keyword actions: Recommended actions for the service health event.
        :paramtype actions:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventPropertiesRecommendedActionsItem]
        :keyword locale_code: Recommended action locale for the service health event.
        :paramtype locale_code: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.actions = actions
        self.locale_code = locale_code


class EventPropertiesRecommendedActionsItem(_serialization.Model):
    """Recommended action for the service health event.

    :ivar group_id: Recommended action group Id for the service health event.
    :vartype group_id: int
    :ivar action_text: Recommended action text.
    :vartype action_text: str
    """

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "int"},
        "action_text": {"key": "actionText", "type": "str"},
    }

    def __init__(self, *, group_id: Optional[int] = None, action_text: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword group_id: Recommended action group Id for the service health event.
        :paramtype group_id: int
        :keyword action_text: Recommended action text.
        :paramtype action_text: str
        """
        super().__init__(**kwargs)
        self.group_id = group_id
        self.action_text = action_text


class Events(_serialization.Model):
    """The List events operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of event. Required.
    :vartype value: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Event]
    :ivar next_link: The URI to fetch the next page of events. Call ListNext() with this URI to
     fetch the next page of events.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Event]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Event"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of event. Required.
        :paramtype value: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Event]
        :keyword next_link: The URI to fetch the next page of events. Call ListNext() with this URI to
         fetch the next page of events.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Faq(_serialization.Model):
    """Frequently asked question for the service health event.

    :ivar question: FAQ question for the service health event.
    :vartype question: str
    :ivar answer: FAQ answer for the service health event.
    :vartype answer: str
    :ivar locale_code: FAQ locale for the service health event.
    :vartype locale_code: str
    """

    _attribute_map = {
        "question": {"key": "question", "type": "str"},
        "answer": {"key": "answer", "type": "str"},
        "locale_code": {"key": "localeCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        question: Optional[str] = None,
        answer: Optional[str] = None,
        locale_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword question: FAQ question for the service health event.
        :paramtype question: str
        :keyword answer: FAQ answer for the service health event.
        :paramtype answer: str
        :keyword locale_code: FAQ locale for the service health event.
        :paramtype locale_code: str
        """
        super().__init__(**kwargs)
        self.question = question
        self.answer = answer
        self.locale_code = locale_code


class Impact(_serialization.Model):
    """Azure service impacted by the service health event.

    :ivar impacted_service: Impacted service name.
    :vartype impacted_service: str
    :ivar impacted_regions: List regions impacted by the service health event.
    :vartype impacted_regions:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ImpactedServiceRegion]
    """

    _attribute_map = {
        "impacted_service": {"key": "impactedService", "type": "str"},
        "impacted_regions": {"key": "impactedRegions", "type": "[ImpactedServiceRegion]"},
    }

    def __init__(
        self,
        *,
        impacted_service: Optional[str] = None,
        impacted_regions: Optional[List["_models.ImpactedServiceRegion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword impacted_service: Impacted service name.
        :paramtype impacted_service: str
        :keyword impacted_regions: List regions impacted by the service health event.
        :paramtype impacted_regions:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ImpactedServiceRegion]
        """
        super().__init__(**kwargs)
        self.impacted_service = impacted_service
        self.impacted_regions = impacted_regions


class ImpactedRegion(_serialization.Model):
    """Object of impacted region.

    :ivar id: The impacted region id.
    :vartype id: str
    :ivar name: The impacted region name.
    :vartype name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The impacted region id.
        :paramtype id: str
        :keyword name: The impacted region name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name


class ImpactedResourceStatus(ProxyResource):
    """impactedResource with health status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SystemData
    :ivar availability_state: Impacted resource status of the resource. Known values are:
     "Available", "Unavailable", "Degraded", and "Unknown".
    :vartype availability_state: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStateValues
    :ivar title: Title description of the impacted resource status.
    :vartype title: str
    :ivar summary: Summary description of the impacted resource status.
    :vartype summary: str
    :ivar reason_type: When the resource's availabilityState is Unavailable, it describes where the
     health impacting event was originated. Known values are: "Unplanned", "Planned", and
     "UserInitiated".
    :vartype reason_type: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ReasonTypeValues
    :ivar occurred_time: Timestamp for when last change in health status occurred.
    :vartype occurred_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "summary": {"key": "properties.summary", "type": "str"},
        "reason_type": {"key": "properties.reasonType", "type": "str"},
        "occurred_time": {"key": "properties.occurredTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        availability_state: Optional[Union[str, "_models.AvailabilityStateValues"]] = None,
        title: Optional[str] = None,
        summary: Optional[str] = None,
        reason_type: Optional[Union[str, "_models.ReasonTypeValues"]] = None,
        occurred_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword availability_state: Impacted resource status of the resource. Known values are:
         "Available", "Unavailable", "Degraded", and "Unknown".
        :paramtype availability_state: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.AvailabilityStateValues
        :keyword title: Title description of the impacted resource status.
        :paramtype title: str
        :keyword summary: Summary description of the impacted resource status.
        :paramtype summary: str
        :keyword reason_type: When the resource's availabilityState is Unavailable, it describes where
         the health impacting event was originated. Known values are: "Unplanned", "Planned", and
         "UserInitiated".
        :paramtype reason_type: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ReasonTypeValues
        :keyword occurred_time: Timestamp for when last change in health status occurred.
        :paramtype occurred_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.availability_state = availability_state
        self.title = title
        self.summary = summary
        self.reason_type = reason_type
        self.occurred_time = occurred_time


class ImpactedServiceRegion(_serialization.Model):
    """Azure region impacted by the service health event.

    :ivar impacted_region: Impacted region name.
    :vartype impacted_region: str
    :ivar status: Current status of event in the region. Known values are: "Active" and "Resolved".
    :vartype status: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventStatusValues
    :ivar impacted_subscriptions: List subscription impacted by the service health event.
    :vartype impacted_subscriptions: list[str]
    :ivar impacted_tenants: List tenant impacted by the service health event.
    :vartype impacted_tenants: list[str]
    :ivar last_update_time: It provides the Timestamp for when the last update for the service
     health event.
    :vartype last_update_time: ~datetime.datetime
    :ivar updates: List of updates for given service health event.
    :vartype updates: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Update]
    """

    _attribute_map = {
        "impacted_region": {"key": "impactedRegion", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "impacted_subscriptions": {"key": "impactedSubscriptions", "type": "[str]"},
        "impacted_tenants": {"key": "impactedTenants", "type": "[str]"},
        "last_update_time": {"key": "lastUpdateTime", "type": "iso-8601"},
        "updates": {"key": "updates", "type": "[Update]"},
    }

    def __init__(
        self,
        *,
        impacted_region: Optional[str] = None,
        status: Optional[Union[str, "_models.EventStatusValues"]] = None,
        impacted_subscriptions: Optional[List[str]] = None,
        impacted_tenants: Optional[List[str]] = None,
        last_update_time: Optional[datetime.datetime] = None,
        updates: Optional[List["_models.Update"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword impacted_region: Impacted region name.
        :paramtype impacted_region: str
        :keyword status: Current status of event in the region. Known values are: "Active" and
         "Resolved".
        :paramtype status: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EventStatusValues
        :keyword impacted_subscriptions: List subscription impacted by the service health event.
        :paramtype impacted_subscriptions: list[str]
        :keyword impacted_tenants: List tenant impacted by the service health event.
        :paramtype impacted_tenants: list[str]
        :keyword last_update_time: It provides the Timestamp for when the last update for the service
         health event.
        :paramtype last_update_time: ~datetime.datetime
        :keyword updates: List of updates for given service health event.
        :paramtype updates: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Update]
        """
        super().__init__(**kwargs)
        self.impacted_region = impacted_region
        self.status = status
        self.impacted_subscriptions = impacted_subscriptions
        self.impacted_tenants = impacted_tenants
        self.last_update_time = last_update_time
        self.updates = updates


class KeyValueItem(_serialization.Model):
    """Key value tuple.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key: Key of tuple.
    :vartype key: str
    :ivar value: Value of tuple.
    :vartype value: str
    """

    _validation = {
        "key": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.key = None
        self.value = None


class Link(_serialization.Model):
    """Useful links for service health event.

    :ivar type: Type of link. Known values are: "Button" and "Hyperlink".
    :vartype type: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.LinkTypeValues
    :ivar display_text: Display text of link.
    :vartype display_text: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.LinkDisplayText
    :ivar extension_name: It provides the name of portal extension to produce link for given
     service health event.
    :vartype extension_name: str
    :ivar blade_name: It provides the name of portal extension blade to produce link for given
     service health event.
    :vartype blade_name: str
    :ivar parameters: It provides a map of parameter name and value for portal extension blade to
     produce lik for given service health event.
    :vartype parameters: JSON
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "display_text": {"key": "displayText", "type": "LinkDisplayText"},
        "extension_name": {"key": "extensionName", "type": "str"},
        "blade_name": {"key": "bladeName", "type": "str"},
        "parameters": {"key": "parameters", "type": "object"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.LinkTypeValues"]] = None,
        display_text: Optional["_models.LinkDisplayText"] = None,
        extension_name: Optional[str] = None,
        blade_name: Optional[str] = None,
        parameters: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of link. Known values are: "Button" and "Hyperlink".
        :paramtype type: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.LinkTypeValues
        :keyword display_text: Display text of link.
        :paramtype display_text: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.LinkDisplayText
        :keyword extension_name: It provides the name of portal extension to produce link for given
         service health event.
        :paramtype extension_name: str
        :keyword blade_name: It provides the name of portal extension blade to produce link for given
         service health event.
        :paramtype blade_name: str
        :keyword parameters: It provides a map of parameter name and value for portal extension blade
         to produce lik for given service health event.
        :paramtype parameters: JSON
        """
        super().__init__(**kwargs)
        self.type = type
        self.display_text = display_text
        self.extension_name = extension_name
        self.blade_name = blade_name
        self.parameters = parameters


class LinkDisplayText(_serialization.Model):
    """Display text of link.

    :ivar value: Display text of link.
    :vartype value: str
    :ivar localized_value: Localized display text of link.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Display text of link.
        :paramtype value: str
        :keyword localized_value: Localized display text of link.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class MetadataEntity(ProxyResource):
    """The metadata entity contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SystemData
    :ivar display_name: The display name.
    :vartype display_name: str
    :ivar depends_on: The list of keys on which this entity depends on.
    :vartype depends_on: list[str]
    :ivar applicable_scenarios: The list of scenarios applicable to this metadata entity.
    :vartype applicable_scenarios: list[str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Scenario]
    :ivar supported_values: The list of supported values.
    :vartype supported_values:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.MetadataSupportedValueDetail]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "depends_on": {"key": "properties.dependsOn", "type": "[str]"},
        "applicable_scenarios": {"key": "properties.applicableScenarios", "type": "[str]"},
        "supported_values": {"key": "properties.supportedValues", "type": "[MetadataSupportedValueDetail]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        depends_on: Optional[List[str]] = None,
        applicable_scenarios: Optional[List[Union[str, "_models.Scenario"]]] = None,
        supported_values: Optional[List["_models.MetadataSupportedValueDetail"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The display name.
        :paramtype display_name: str
        :keyword depends_on: The list of keys on which this entity depends on.
        :paramtype depends_on: list[str]
        :keyword applicable_scenarios: The list of scenarios applicable to this metadata entity.
        :paramtype applicable_scenarios: list[str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Scenario]
        :keyword supported_values: The list of supported values.
        :paramtype supported_values:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.MetadataSupportedValueDetail]
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.depends_on = depends_on
        self.applicable_scenarios = applicable_scenarios
        self.supported_values = supported_values


class MetadataEntityListResult(_serialization.Model):
    """The list of metadata entities.

    :ivar value: The list of metadata entities.
    :vartype value: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.MetadataEntity]
    :ivar next_link: The link used to get the next page of metadata.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MetadataEntity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.MetadataEntity"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of metadata entities.
        :paramtype value: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.MetadataEntity]
        :keyword next_link: The link used to get the next page of metadata.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MetadataSupportedValueDetail(_serialization.Model):
    """The metadata supported value detail.

    :ivar id: The id.
    :vartype id: str
    :ivar display_name: The display name.
    :vartype display_name: str
    :ivar resource_types: The list of associated resource types.
    :vartype resource_types: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "resource_types": {"key": "resourceTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        resource_types: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The id.
        :paramtype id: str
        :keyword display_name: The display name.
        :paramtype display_name: str
        :keyword resource_types: The list of associated resource types.
        :paramtype resource_types: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.resource_types = resource_types


class Operation(_serialization.Model):
    """Operation available in the Microsoft.ResourceHealth resource provider.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Properties of the operation.
    :vartype display: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Properties of the operation.
        :paramtype display: ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """Properties of the operation.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Lists the operations response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of operations available in the Microsoft.ResourceHealth resource provider.
     Required.
    :vartype value: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Operation]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: List["_models.Operation"], **kwargs: Any) -> None:
        """
        :keyword value: List of operations available in the Microsoft.ResourceHealth resource provider.
         Required.
        :paramtype value: list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class RecommendedAction(_serialization.Model):
    """Lists actions the user can take based on the current availabilityState of the resource.

    :ivar action: Recommended action.
    :vartype action: str
    :ivar action_url: Link to the action.
    :vartype action_url: str
    :ivar action_url_comment: the comment for the Action.
    :vartype action_url_comment: str
    :ivar action_url_text: Substring of action, it describes which text should host the action URL.
    :vartype action_url_text: str
    """

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "action_url": {"key": "actionUrl", "type": "str"},
        "action_url_comment": {"key": "_ActionUrl\\.Comment", "type": "str"},
        "action_url_text": {"key": "actionUrlText", "type": "str"},
    }

    def __init__(
        self,
        *,
        action: Optional[str] = None,
        action_url: Optional[str] = None,
        action_url_comment: Optional[str] = None,
        action_url_text: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action: Recommended action.
        :paramtype action: str
        :keyword action_url: Link to the action.
        :paramtype action_url: str
        :keyword action_url_comment: the comment for the Action.
        :paramtype action_url_comment: str
        :keyword action_url_text: Substring of action, it describes which text should host the action
         URL.
        :paramtype action_url_text: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.action_url = action_url
        self.action_url_comment = action_url_comment
        self.action_url_text = action_url_text


class ServiceImpactingEvent(_serialization.Model):
    """Lists the service impacting events that may be affecting the health of the resource.

    :ivar event_start_time: Timestamp for when the event started.
    :vartype event_start_time: ~datetime.datetime
    :ivar event_status_last_modified_time: Timestamp for when event was submitted/detected.
    :vartype event_status_last_modified_time: ~datetime.datetime
    :ivar correlation_id: Correlation id for the event.
    :vartype correlation_id: str
    :ivar status: Status of the service impacting event.
    :vartype status:
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ServiceImpactingEventStatus
    :ivar incident_properties: Properties of the service impacting event.
    :vartype incident_properties:
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ServiceImpactingEventIncidentProperties
    """

    _attribute_map = {
        "event_start_time": {"key": "eventStartTime", "type": "iso-8601"},
        "event_status_last_modified_time": {"key": "eventStatusLastModifiedTime", "type": "iso-8601"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "status": {"key": "status", "type": "ServiceImpactingEventStatus"},
        "incident_properties": {"key": "incidentProperties", "type": "ServiceImpactingEventIncidentProperties"},
    }

    def __init__(
        self,
        *,
        event_start_time: Optional[datetime.datetime] = None,
        event_status_last_modified_time: Optional[datetime.datetime] = None,
        correlation_id: Optional[str] = None,
        status: Optional["_models.ServiceImpactingEventStatus"] = None,
        incident_properties: Optional["_models.ServiceImpactingEventIncidentProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword event_start_time: Timestamp for when the event started.
        :paramtype event_start_time: ~datetime.datetime
        :keyword event_status_last_modified_time: Timestamp for when event was submitted/detected.
        :paramtype event_status_last_modified_time: ~datetime.datetime
        :keyword correlation_id: Correlation id for the event.
        :paramtype correlation_id: str
        :keyword status: Status of the service impacting event.
        :paramtype status:
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ServiceImpactingEventStatus
        :keyword incident_properties: Properties of the service impacting event.
        :paramtype incident_properties:
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.ServiceImpactingEventIncidentProperties
        """
        super().__init__(**kwargs)
        self.event_start_time = event_start_time
        self.event_status_last_modified_time = event_status_last_modified_time
        self.correlation_id = correlation_id
        self.status = status
        self.incident_properties = incident_properties


class ServiceImpactingEventIncidentProperties(_serialization.Model):
    """Properties of the service impacting event.

    :ivar title: Title of the incident.
    :vartype title: str
    :ivar service: Service impacted by the event.
    :vartype service: str
    :ivar region: Region impacted by the event.
    :vartype region: str
    :ivar incident_type: Type of Event.
    :vartype incident_type: str
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "service": {"key": "service", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "incident_type": {"key": "incidentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        service: Optional[str] = None,
        region: Optional[str] = None,
        incident_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: Title of the incident.
        :paramtype title: str
        :keyword service: Service impacted by the event.
        :paramtype service: str
        :keyword region: Region impacted by the event.
        :paramtype region: str
        :keyword incident_type: Type of Event.
        :paramtype incident_type: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.service = service
        self.region = region
        self.incident_type = incident_type


class ServiceImpactingEventStatus(_serialization.Model):
    """Status of the service impacting event.

    :ivar value: Current status of the event.
    :vartype value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Current status of the event.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class StatusActiveEvent(_serialization.Model):
    """Active event type of emerging issue.

    :ivar title: The active event title.
    :vartype title: str
    :ivar description: The details of active event.
    :vartype description: str
    :ivar tracking_id: The tracking id of this active event.
    :vartype tracking_id: str
    :ivar start_time: The impact start time on this active event.
    :vartype start_time: ~datetime.datetime
    :ivar cloud: The cloud type of this active event.
    :vartype cloud: str
    :ivar severity: The severity level of this active event. Known values are: "Information",
     "Warning", and "Error".
    :vartype severity: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SeverityValues
    :ivar stage: The stage of this active event. Known values are: "Active", "Resolve", and
     "Archived".
    :vartype stage: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.StageValues
    :ivar published: The boolean value of this active event if published or not.
    :vartype published: bool
    :ivar last_modified_time: The last time modified on this banner.
    :vartype last_modified_time: ~datetime.datetime
    :ivar impacts: The list of emerging issues impacts.
    :vartype impacts:
     list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EmergingIssueImpact]
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "cloud": {"key": "cloud", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "stage": {"key": "stage", "type": "str"},
        "published": {"key": "published", "type": "bool"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
        "impacts": {"key": "impacts", "type": "[EmergingIssueImpact]"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        description: Optional[str] = None,
        tracking_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        cloud: Optional[str] = None,
        severity: Optional[Union[str, "_models.SeverityValues"]] = None,
        stage: Optional[Union[str, "_models.StageValues"]] = None,
        published: Optional[bool] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        impacts: Optional[List["_models.EmergingIssueImpact"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: The active event title.
        :paramtype title: str
        :keyword description: The details of active event.
        :paramtype description: str
        :keyword tracking_id: The tracking id of this active event.
        :paramtype tracking_id: str
        :keyword start_time: The impact start time on this active event.
        :paramtype start_time: ~datetime.datetime
        :keyword cloud: The cloud type of this active event.
        :paramtype cloud: str
        :keyword severity: The severity level of this active event. Known values are: "Information",
         "Warning", and "Error".
        :paramtype severity: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.SeverityValues
        :keyword stage: The stage of this active event. Known values are: "Active", "Resolve", and
         "Archived".
        :paramtype stage: str or ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.StageValues
        :keyword published: The boolean value of this active event if published or not.
        :paramtype published: bool
        :keyword last_modified_time: The last time modified on this banner.
        :paramtype last_modified_time: ~datetime.datetime
        :keyword impacts: The list of emerging issues impacts.
        :paramtype impacts:
         list[~azure.mgmt.resourcehealth.v2023_10_01_preview.models.EmergingIssueImpact]
        """
        super().__init__(**kwargs)
        self.title = title
        self.description = description
        self.tracking_id = tracking_id
        self.start_time = start_time
        self.cloud = cloud
        self.severity = severity
        self.stage = stage
        self.published = published
        self.last_modified_time = last_modified_time
        self.impacts = impacts


class StatusBanner(_serialization.Model):
    """Banner type of emerging issue.

    :ivar title: The banner title.
    :vartype title: str
    :ivar message: The details of banner.
    :vartype message: str
    :ivar cloud: The cloud type of this banner.
    :vartype cloud: str
    :ivar last_modified_time: The last time modified on this banner.
    :vartype last_modified_time: ~datetime.datetime
    """

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "cloud": {"key": "cloud", "type": "str"},
        "last_modified_time": {"key": "lastModifiedTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        message: Optional[str] = None,
        cloud: Optional[str] = None,
        last_modified_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: The banner title.
        :paramtype title: str
        :keyword message: The details of banner.
        :paramtype message: str
        :keyword cloud: The cloud type of this banner.
        :paramtype cloud: str
        :keyword last_modified_time: The last time modified on this banner.
        :paramtype last_modified_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.title = title
        self.message = message
        self.cloud = cloud
        self.last_modified_time = last_modified_time


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.resourcehealth.v2023_10_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Update(_serialization.Model):
    """Update for service health event.

    :ivar summary: Summary text for the given update for the service health event.
    :vartype summary: str
    :ivar update_date_time: It provides the Timestamp for the given update for the service health
     event.
    :vartype update_date_time: ~datetime.datetime
    """

    _attribute_map = {
        "summary": {"key": "summary", "type": "str"},
        "update_date_time": {"key": "updateDateTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, summary: Optional[str] = None, update_date_time: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword summary: Summary text for the given update for the service health event.
        :paramtype summary: str
        :keyword update_date_time: It provides the Timestamp for the given update for the service
         health event.
        :paramtype update_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.summary = summary
        self.update_date_time = update_date_time
