# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ColumnDataType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Data type of a column in a table.
    """

    STRING = "string"
    INTEGER = "integer"
    NUMBER = "number"
    BOOLEAN = "boolean"
    OBJECT = "object"

class FacetSortOrder(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The sorting order by the selected column (count by default).
    """

    ASC = "asc"
    DESC = "desc"

class ResultFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Defines in which format query result returned.
    """

    TABLE = "table"
    OBJECT_ARRAY = "objectArray"

class ResultTruncated(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates whether the query results are truncated.
    """

    TRUE = "true"
    FALSE = "false"
