# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class Baseline(msrest.serialization.Model):
    """The baseline values for a single sensitivity value.

    All required parameters must be populated in order to send to Azure.

    :ivar sensitivity: Required. the sensitivity of the baseline. Possible values include: "Low",
     "Medium", "High".
    :vartype sensitivity: str or ~$(python-base-namespace).v2017_11_01_preview.models.Sensitivity
    :ivar low_thresholds: Required. The low thresholds of the baseline.
    :vartype low_thresholds: list[float]
    :ivar high_thresholds: Required. The high thresholds of the baseline.
    :vartype high_thresholds: list[float]
    :ivar timestamps: the array of timestamps of the baselines.
    :vartype timestamps: list[~datetime.datetime]
    """

    _validation = {
        'sensitivity': {'required': True},
        'low_thresholds': {'required': True},
        'high_thresholds': {'required': True},
    }

    _attribute_map = {
        'sensitivity': {'key': 'sensitivity', 'type': 'str'},
        'low_thresholds': {'key': 'lowThresholds', 'type': '[float]'},
        'high_thresholds': {'key': 'highThresholds', 'type': '[float]'},
        'timestamps': {'key': 'timestamps', 'type': '[iso-8601]'},
    }

    def __init__(
        self,
        *,
        sensitivity: Union[str, "Sensitivity"],
        low_thresholds: List[float],
        high_thresholds: List[float],
        timestamps: Optional[List[datetime.datetime]] = None,
        **kwargs
    ):
        """
        :keyword sensitivity: Required. the sensitivity of the baseline. Possible values include:
         "Low", "Medium", "High".
        :paramtype sensitivity: str or ~$(python-base-namespace).v2017_11_01_preview.models.Sensitivity
        :keyword low_thresholds: Required. The low thresholds of the baseline.
        :paramtype low_thresholds: list[float]
        :keyword high_thresholds: Required. The high thresholds of the baseline.
        :paramtype high_thresholds: list[float]
        :keyword timestamps: the array of timestamps of the baselines.
        :paramtype timestamps: list[~datetime.datetime]
        """
        super(Baseline, self).__init__(**kwargs)
        self.sensitivity = sensitivity
        self.low_thresholds = low_thresholds
        self.high_thresholds = high_thresholds
        self.timestamps = timestamps


class BaselineMetadataValue(msrest.serialization.Model):
    """Represents a baseline metadata value.

    :ivar name: the name of the metadata.
    :vartype name: ~$(python-base-namespace).v2017_11_01_preview.models.LocalizableString
    :ivar value: the value of the metadata.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional["LocalizableString"] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: the name of the metadata.
        :paramtype name: ~$(python-base-namespace).v2017_11_01_preview.models.LocalizableString
        :keyword value: the value of the metadata.
        :paramtype value: str
        """
        super(BaselineMetadataValue, self).__init__(**kwargs)
        self.name = name
        self.value = value


class BaselineResponse(msrest.serialization.Model):
    """The response to a baseline query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: the metric baseline Id.
    :vartype id: str
    :ivar type: the resource type of the baseline resource.
    :vartype type: str
    :ivar name: the name and the display name of the metric, i.e. it is localizable string.
    :vartype name: ~$(python-base-namespace).v2017_11_01_preview.models.LocalizableString
    :ivar timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in.  This may
     be adjusted in the future and returned back from what was originally requested.  This is not
     present if a metadata request was made.
    :vartype interval: ~datetime.timedelta
    :ivar aggregation: The aggregation type of the metric.
    :vartype aggregation: str
    :ivar timestamps: the array of timestamps of the baselines.
    :vartype timestamps: list[~datetime.datetime]
    :ivar baseline: the baseline values for each sensitivity.
    :vartype baseline: list[~$(python-base-namespace).v2017_11_01_preview.models.Baseline]
    :ivar metadata: the baseline metadata values.
    :vartype metadata:
     list[~$(python-base-namespace).v2017_11_01_preview.models.BaselineMetadataValue]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'timespan': {'key': 'properties.timespan', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'duration'},
        'aggregation': {'key': 'properties.aggregation', 'type': 'str'},
        'timestamps': {'key': 'properties.timestamps', 'type': '[iso-8601]'},
        'baseline': {'key': 'properties.baseline', 'type': '[Baseline]'},
        'metadata': {'key': 'properties.metadata', 'type': '[BaselineMetadataValue]'},
    }

    def __init__(
        self,
        *,
        timespan: Optional[str] = None,
        interval: Optional[datetime.timedelta] = None,
        aggregation: Optional[str] = None,
        timestamps: Optional[List[datetime.datetime]] = None,
        baseline: Optional[List["Baseline"]] = None,
        metadata: Optional[List["BaselineMetadataValue"]] = None,
        **kwargs
    ):
        """
        :keyword timespan: The timespan for which the data was retrieved. Its value consists of two
         datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
         from what was originally requested.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in.  This
         may be adjusted in the future and returned back from what was originally requested.  This is
         not present if a metadata request was made.
        :paramtype interval: ~datetime.timedelta
        :keyword aggregation: The aggregation type of the metric.
        :paramtype aggregation: str
        :keyword timestamps: the array of timestamps of the baselines.
        :paramtype timestamps: list[~datetime.datetime]
        :keyword baseline: the baseline values for each sensitivity.
        :paramtype baseline: list[~$(python-base-namespace).v2017_11_01_preview.models.Baseline]
        :keyword metadata: the baseline metadata values.
        :paramtype metadata:
         list[~$(python-base-namespace).v2017_11_01_preview.models.BaselineMetadataValue]
        """
        super(BaselineResponse, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.timespan = timespan
        self.interval = interval
        self.aggregation = aggregation
        self.timestamps = timestamps
        self.baseline = baseline
        self.metadata = metadata


class CalculateBaselineResponse(msrest.serialization.Model):
    """The response to a calculate baseline call.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. the resource type of the baseline resource.
    :vartype type: str
    :ivar timestamps: the array of timestamps of the baselines.
    :vartype timestamps: list[~datetime.datetime]
    :ivar baseline: Required. the baseline values for each sensitivity.
    :vartype baseline: list[~$(python-base-namespace).v2017_11_01_preview.models.Baseline]
    """

    _validation = {
        'type': {'required': True},
        'baseline': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'timestamps': {'key': 'timestamps', 'type': '[iso-8601]'},
        'baseline': {'key': 'baseline', 'type': '[Baseline]'},
    }

    def __init__(
        self,
        *,
        type: str,
        baseline: List["Baseline"],
        timestamps: Optional[List[datetime.datetime]] = None,
        **kwargs
    ):
        """
        :keyword type: Required. the resource type of the baseline resource.
        :paramtype type: str
        :keyword timestamps: the array of timestamps of the baselines.
        :paramtype timestamps: list[~datetime.datetime]
        :keyword baseline: Required. the baseline values for each sensitivity.
        :paramtype baseline: list[~$(python-base-namespace).v2017_11_01_preview.models.Baseline]
        """
        super(CalculateBaselineResponse, self).__init__(**kwargs)
        self.type = type
        self.timestamps = timestamps
        self.baseline = baseline


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the invariant value.
    :vartype value: str
    :ivar localized_value: the locale specific value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. the invariant value.
        :paramtype value: str
        :keyword localized_value: the locale specific value.
        :paramtype localized_value: str
        """
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class TimeSeriesInformation(msrest.serialization.Model):
    """The time series info needed for calculating the baseline.

    All required parameters must be populated in order to send to Azure.

    :ivar sensitivities: Required. the list of sensitivities for calculating the baseline.
    :vartype sensitivities: list[str]
    :ivar values: Required. The metric values to calculate the baseline.
    :vartype values: list[float]
    :ivar timestamps: the array of timestamps of the baselines.
    :vartype timestamps: list[~datetime.datetime]
    """

    _validation = {
        'sensitivities': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'sensitivities': {'key': 'sensitivities', 'type': '[str]'},
        'values': {'key': 'values', 'type': '[float]'},
        'timestamps': {'key': 'timestamps', 'type': '[iso-8601]'},
    }

    def __init__(
        self,
        *,
        sensitivities: List[str],
        values: List[float],
        timestamps: Optional[List[datetime.datetime]] = None,
        **kwargs
    ):
        """
        :keyword sensitivities: Required. the list of sensitivities for calculating the baseline.
        :paramtype sensitivities: list[str]
        :keyword values: Required. The metric values to calculate the baseline.
        :paramtype values: list[float]
        :keyword timestamps: the array of timestamps of the baselines.
        :paramtype timestamps: list[~datetime.datetime]
        """
        super(TimeSeriesInformation, self).__init__(**kwargs)
        self.sensitivities = sensitivities
        self.values = values
        self.timestamps = timestamps
