// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssmiface provides an interface to enable mocking the Amazon Simple Systems Management Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssmiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ssm"
)

// SSMAPI provides an interface to enable mocking the
// ssm.SSM service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Simple Systems Management Service.
//	func myFunc(svc ssmiface.SSMAPI) bool {
//	    // Make svc.AddAccessGrant request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := ssm.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSSMClient struct {
//	    ssmiface.SSMAPI
//	}
//	func (m *mockSSMClient) AddAccessGrant(input *ssm.AddAccessGrantInput) (*ssm.AddAccessGrantOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSSMClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SSMAPI interface {
	AddAccessGrant(*ssm.AddAccessGrantInput) (*ssm.AddAccessGrantOutput, error)
	AddAccessGrantWithContext(aws.Context, *ssm.AddAccessGrantInput, ...request.Option) (*ssm.AddAccessGrantOutput, error)
	AddAccessGrantRequest(*ssm.AddAccessGrantInput) (*request.Request, *ssm.AddAccessGrantOutput)

	AddEventsForExploreSsmActions(*ssm.AddEventsForExploreSsmActionsInput) (*ssm.AddEventsForExploreSsmActionsOutput, error)
	AddEventsForExploreSsmActionsWithContext(aws.Context, *ssm.AddEventsForExploreSsmActionsInput, ...request.Option) (*ssm.AddEventsForExploreSsmActionsOutput, error)
	AddEventsForExploreSsmActionsRequest(*ssm.AddEventsForExploreSsmActionsInput) (*request.Request, *ssm.AddEventsForExploreSsmActionsOutput)

	AddTagsToResource(*ssm.AddTagsToResourceInput) (*ssm.AddTagsToResourceOutput, error)
	AddTagsToResourceWithContext(aws.Context, *ssm.AddTagsToResourceInput, ...request.Option) (*ssm.AddTagsToResourceOutput, error)
	AddTagsToResourceRequest(*ssm.AddTagsToResourceInput) (*request.Request, *ssm.AddTagsToResourceOutput)

	AssignResource(*ssm.AssignResourceInput) (*ssm.AssignResourceOutput, error)
	AssignResourceWithContext(aws.Context, *ssm.AssignResourceInput, ...request.Option) (*ssm.AssignResourceOutput, error)
	AssignResourceRequest(*ssm.AssignResourceInput) (*request.Request, *ssm.AssignResourceOutput)

	AssociateOpsItemRelatedItem(*ssm.AssociateOpsItemRelatedItemInput) (*ssm.AssociateOpsItemRelatedItemOutput, error)
	AssociateOpsItemRelatedItemWithContext(aws.Context, *ssm.AssociateOpsItemRelatedItemInput, ...request.Option) (*ssm.AssociateOpsItemRelatedItemOutput, error)
	AssociateOpsItemRelatedItemRequest(*ssm.AssociateOpsItemRelatedItemInput) (*request.Request, *ssm.AssociateOpsItemRelatedItemOutput)

	CancelCommand(*ssm.CancelCommandInput) (*ssm.CancelCommandOutput, error)
	CancelCommandWithContext(aws.Context, *ssm.CancelCommandInput, ...request.Option) (*ssm.CancelCommandOutput, error)
	CancelCommandRequest(*ssm.CancelCommandInput) (*request.Request, *ssm.CancelCommandOutput)

	CancelMaintenanceWindowExecution(*ssm.CancelMaintenanceWindowExecutionInput) (*ssm.CancelMaintenanceWindowExecutionOutput, error)
	CancelMaintenanceWindowExecutionWithContext(aws.Context, *ssm.CancelMaintenanceWindowExecutionInput, ...request.Option) (*ssm.CancelMaintenanceWindowExecutionOutput, error)
	CancelMaintenanceWindowExecutionRequest(*ssm.CancelMaintenanceWindowExecutionInput) (*request.Request, *ssm.CancelMaintenanceWindowExecutionOutput)

	CreateActivation(*ssm.CreateActivationInput) (*ssm.CreateActivationOutput, error)
	CreateActivationWithContext(aws.Context, *ssm.CreateActivationInput, ...request.Option) (*ssm.CreateActivationOutput, error)
	CreateActivationRequest(*ssm.CreateActivationInput) (*request.Request, *ssm.CreateActivationOutput)

	CreateAssociation(*ssm.CreateAssociationInput) (*ssm.CreateAssociationOutput, error)
	CreateAssociationWithContext(aws.Context, *ssm.CreateAssociationInput, ...request.Option) (*ssm.CreateAssociationOutput, error)
	CreateAssociationRequest(*ssm.CreateAssociationInput) (*request.Request, *ssm.CreateAssociationOutput)

	CreateAssociationBatch(*ssm.CreateAssociationBatchInput) (*ssm.CreateAssociationBatchOutput, error)
	CreateAssociationBatchWithContext(aws.Context, *ssm.CreateAssociationBatchInput, ...request.Option) (*ssm.CreateAssociationBatchOutput, error)
	CreateAssociationBatchRequest(*ssm.CreateAssociationBatchInput) (*request.Request, *ssm.CreateAssociationBatchOutput)

	CreateDocument(*ssm.CreateDocumentInput) (*ssm.CreateDocumentOutput, error)
	CreateDocumentWithContext(aws.Context, *ssm.CreateDocumentInput, ...request.Option) (*ssm.CreateDocumentOutput, error)
	CreateDocumentRequest(*ssm.CreateDocumentInput) (*request.Request, *ssm.CreateDocumentOutput)

	CreateMaintenanceWindow(*ssm.CreateMaintenanceWindowInput) (*ssm.CreateMaintenanceWindowOutput, error)
	CreateMaintenanceWindowWithContext(aws.Context, *ssm.CreateMaintenanceWindowInput, ...request.Option) (*ssm.CreateMaintenanceWindowOutput, error)
	CreateMaintenanceWindowRequest(*ssm.CreateMaintenanceWindowInput) (*request.Request, *ssm.CreateMaintenanceWindowOutput)

	CreateOpsItem(*ssm.CreateOpsItemInput) (*ssm.CreateOpsItemOutput, error)
	CreateOpsItemWithContext(aws.Context, *ssm.CreateOpsItemInput, ...request.Option) (*ssm.CreateOpsItemOutput, error)
	CreateOpsItemRequest(*ssm.CreateOpsItemInput) (*request.Request, *ssm.CreateOpsItemOutput)

	CreateOpsItemGroup(*ssm.CreateOpsItemGroupInput) (*ssm.CreateOpsItemGroupOutput, error)
	CreateOpsItemGroupWithContext(aws.Context, *ssm.CreateOpsItemGroupInput, ...request.Option) (*ssm.CreateOpsItemGroupOutput, error)
	CreateOpsItemGroupRequest(*ssm.CreateOpsItemGroupInput) (*request.Request, *ssm.CreateOpsItemGroupOutput)

	CreateOpsMetadata(*ssm.CreateOpsMetadataInput) (*ssm.CreateOpsMetadataOutput, error)
	CreateOpsMetadataWithContext(aws.Context, *ssm.CreateOpsMetadataInput, ...request.Option) (*ssm.CreateOpsMetadataOutput, error)
	CreateOpsMetadataRequest(*ssm.CreateOpsMetadataInput) (*request.Request, *ssm.CreateOpsMetadataOutput)

	CreatePatchBaseline(*ssm.CreatePatchBaselineInput) (*ssm.CreatePatchBaselineOutput, error)
	CreatePatchBaselineWithContext(aws.Context, *ssm.CreatePatchBaselineInput, ...request.Option) (*ssm.CreatePatchBaselineOutput, error)
	CreatePatchBaselineRequest(*ssm.CreatePatchBaselineInput) (*request.Request, *ssm.CreatePatchBaselineOutput)

	CreateResourceDataSync(*ssm.CreateResourceDataSyncInput) (*ssm.CreateResourceDataSyncOutput, error)
	CreateResourceDataSyncWithContext(aws.Context, *ssm.CreateResourceDataSyncInput, ...request.Option) (*ssm.CreateResourceDataSyncOutput, error)
	CreateResourceDataSyncRequest(*ssm.CreateResourceDataSyncInput) (*request.Request, *ssm.CreateResourceDataSyncOutput)

	DeleteActivation(*ssm.DeleteActivationInput) (*ssm.DeleteActivationOutput, error)
	DeleteActivationWithContext(aws.Context, *ssm.DeleteActivationInput, ...request.Option) (*ssm.DeleteActivationOutput, error)
	DeleteActivationRequest(*ssm.DeleteActivationInput) (*request.Request, *ssm.DeleteActivationOutput)

	DeleteAssociation(*ssm.DeleteAssociationInput) (*ssm.DeleteAssociationOutput, error)
	DeleteAssociationWithContext(aws.Context, *ssm.DeleteAssociationInput, ...request.Option) (*ssm.DeleteAssociationOutput, error)
	DeleteAssociationRequest(*ssm.DeleteAssociationInput) (*request.Request, *ssm.DeleteAssociationOutput)

	DeleteCommands(*ssm.DeleteCommandsInput) (*ssm.DeleteCommandsOutput, error)
	DeleteCommandsWithContext(aws.Context, *ssm.DeleteCommandsInput, ...request.Option) (*ssm.DeleteCommandsOutput, error)
	DeleteCommandsRequest(*ssm.DeleteCommandsInput) (*request.Request, *ssm.DeleteCommandsOutput)

	DeleteDocument(*ssm.DeleteDocumentInput) (*ssm.DeleteDocumentOutput, error)
	DeleteDocumentWithContext(aws.Context, *ssm.DeleteDocumentInput, ...request.Option) (*ssm.DeleteDocumentOutput, error)
	DeleteDocumentRequest(*ssm.DeleteDocumentInput) (*request.Request, *ssm.DeleteDocumentOutput)

	DeleteInventory(*ssm.DeleteInventoryInput) (*ssm.DeleteInventoryOutput, error)
	DeleteInventoryWithContext(aws.Context, *ssm.DeleteInventoryInput, ...request.Option) (*ssm.DeleteInventoryOutput, error)
	DeleteInventoryRequest(*ssm.DeleteInventoryInput) (*request.Request, *ssm.DeleteInventoryOutput)

	DeleteMaintenanceWindow(*ssm.DeleteMaintenanceWindowInput) (*ssm.DeleteMaintenanceWindowOutput, error)
	DeleteMaintenanceWindowWithContext(aws.Context, *ssm.DeleteMaintenanceWindowInput, ...request.Option) (*ssm.DeleteMaintenanceWindowOutput, error)
	DeleteMaintenanceWindowRequest(*ssm.DeleteMaintenanceWindowInput) (*request.Request, *ssm.DeleteMaintenanceWindowOutput)

	DeleteOpsItem(*ssm.DeleteOpsItemInput) (*ssm.DeleteOpsItemOutput, error)
	DeleteOpsItemWithContext(aws.Context, *ssm.DeleteOpsItemInput, ...request.Option) (*ssm.DeleteOpsItemOutput, error)
	DeleteOpsItemRequest(*ssm.DeleteOpsItemInput) (*request.Request, *ssm.DeleteOpsItemOutput)

	DeleteOpsMetadata(*ssm.DeleteOpsMetadataInput) (*ssm.DeleteOpsMetadataOutput, error)
	DeleteOpsMetadataWithContext(aws.Context, *ssm.DeleteOpsMetadataInput, ...request.Option) (*ssm.DeleteOpsMetadataOutput, error)
	DeleteOpsMetadataRequest(*ssm.DeleteOpsMetadataInput) (*request.Request, *ssm.DeleteOpsMetadataOutput)

	DeleteParameter(*ssm.DeleteParameterInput) (*ssm.DeleteParameterOutput, error)
	DeleteParameterWithContext(aws.Context, *ssm.DeleteParameterInput, ...request.Option) (*ssm.DeleteParameterOutput, error)
	DeleteParameterRequest(*ssm.DeleteParameterInput) (*request.Request, *ssm.DeleteParameterOutput)

	DeleteParameters(*ssm.DeleteParametersInput) (*ssm.DeleteParametersOutput, error)
	DeleteParametersWithContext(aws.Context, *ssm.DeleteParametersInput, ...request.Option) (*ssm.DeleteParametersOutput, error)
	DeleteParametersRequest(*ssm.DeleteParametersInput) (*request.Request, *ssm.DeleteParametersOutput)

	DeletePatchBaseline(*ssm.DeletePatchBaselineInput) (*ssm.DeletePatchBaselineOutput, error)
	DeletePatchBaselineWithContext(aws.Context, *ssm.DeletePatchBaselineInput, ...request.Option) (*ssm.DeletePatchBaselineOutput, error)
	DeletePatchBaselineRequest(*ssm.DeletePatchBaselineInput) (*request.Request, *ssm.DeletePatchBaselineOutput)

	DeleteResourceDataSync(*ssm.DeleteResourceDataSyncInput) (*ssm.DeleteResourceDataSyncOutput, error)
	DeleteResourceDataSyncWithContext(aws.Context, *ssm.DeleteResourceDataSyncInput, ...request.Option) (*ssm.DeleteResourceDataSyncOutput, error)
	DeleteResourceDataSyncRequest(*ssm.DeleteResourceDataSyncInput) (*request.Request, *ssm.DeleteResourceDataSyncOutput)

	DeleteResourcePolicy(*ssm.DeleteResourcePolicyInput) (*ssm.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *ssm.DeleteResourcePolicyInput, ...request.Option) (*ssm.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*ssm.DeleteResourcePolicyInput) (*request.Request, *ssm.DeleteResourcePolicyOutput)

	DeregisterManagedInstance(*ssm.DeregisterManagedInstanceInput) (*ssm.DeregisterManagedInstanceOutput, error)
	DeregisterManagedInstanceWithContext(aws.Context, *ssm.DeregisterManagedInstanceInput, ...request.Option) (*ssm.DeregisterManagedInstanceOutput, error)
	DeregisterManagedInstanceRequest(*ssm.DeregisterManagedInstanceInput) (*request.Request, *ssm.DeregisterManagedInstanceOutput)

	DeregisterPatchBaselineForPatchGroup(*ssm.DeregisterPatchBaselineForPatchGroupInput) (*ssm.DeregisterPatchBaselineForPatchGroupOutput, error)
	DeregisterPatchBaselineForPatchGroupWithContext(aws.Context, *ssm.DeregisterPatchBaselineForPatchGroupInput, ...request.Option) (*ssm.DeregisterPatchBaselineForPatchGroupOutput, error)
	DeregisterPatchBaselineForPatchGroupRequest(*ssm.DeregisterPatchBaselineForPatchGroupInput) (*request.Request, *ssm.DeregisterPatchBaselineForPatchGroupOutput)

	DeregisterTargetFromMaintenanceWindow(*ssm.DeregisterTargetFromMaintenanceWindowInput) (*ssm.DeregisterTargetFromMaintenanceWindowOutput, error)
	DeregisterTargetFromMaintenanceWindowWithContext(aws.Context, *ssm.DeregisterTargetFromMaintenanceWindowInput, ...request.Option) (*ssm.DeregisterTargetFromMaintenanceWindowOutput, error)
	DeregisterTargetFromMaintenanceWindowRequest(*ssm.DeregisterTargetFromMaintenanceWindowInput) (*request.Request, *ssm.DeregisterTargetFromMaintenanceWindowOutput)

	DeregisterTaskFromMaintenanceWindow(*ssm.DeregisterTaskFromMaintenanceWindowInput) (*ssm.DeregisterTaskFromMaintenanceWindowOutput, error)
	DeregisterTaskFromMaintenanceWindowWithContext(aws.Context, *ssm.DeregisterTaskFromMaintenanceWindowInput, ...request.Option) (*ssm.DeregisterTaskFromMaintenanceWindowOutput, error)
	DeregisterTaskFromMaintenanceWindowRequest(*ssm.DeregisterTaskFromMaintenanceWindowInput) (*request.Request, *ssm.DeregisterTaskFromMaintenanceWindowOutput)

	DescribeActivations(*ssm.DescribeActivationsInput) (*ssm.DescribeActivationsOutput, error)
	DescribeActivationsWithContext(aws.Context, *ssm.DescribeActivationsInput, ...request.Option) (*ssm.DescribeActivationsOutput, error)
	DescribeActivationsRequest(*ssm.DescribeActivationsInput) (*request.Request, *ssm.DescribeActivationsOutput)

	DescribeActivationsPages(*ssm.DescribeActivationsInput, func(*ssm.DescribeActivationsOutput, bool) bool) error
	DescribeActivationsPagesWithContext(aws.Context, *ssm.DescribeActivationsInput, func(*ssm.DescribeActivationsOutput, bool) bool, ...request.Option) error

	DescribeAssociation(*ssm.DescribeAssociationInput) (*ssm.DescribeAssociationOutput, error)
	DescribeAssociationWithContext(aws.Context, *ssm.DescribeAssociationInput, ...request.Option) (*ssm.DescribeAssociationOutput, error)
	DescribeAssociationRequest(*ssm.DescribeAssociationInput) (*request.Request, *ssm.DescribeAssociationOutput)

	DescribeAssociationExecutionTargets(*ssm.DescribeAssociationExecutionTargetsInput) (*ssm.DescribeAssociationExecutionTargetsOutput, error)
	DescribeAssociationExecutionTargetsWithContext(aws.Context, *ssm.DescribeAssociationExecutionTargetsInput, ...request.Option) (*ssm.DescribeAssociationExecutionTargetsOutput, error)
	DescribeAssociationExecutionTargetsRequest(*ssm.DescribeAssociationExecutionTargetsInput) (*request.Request, *ssm.DescribeAssociationExecutionTargetsOutput)

	DescribeAssociationExecutionTargetsPages(*ssm.DescribeAssociationExecutionTargetsInput, func(*ssm.DescribeAssociationExecutionTargetsOutput, bool) bool) error
	DescribeAssociationExecutionTargetsPagesWithContext(aws.Context, *ssm.DescribeAssociationExecutionTargetsInput, func(*ssm.DescribeAssociationExecutionTargetsOutput, bool) bool, ...request.Option) error

	DescribeAssociationExecutions(*ssm.DescribeAssociationExecutionsInput) (*ssm.DescribeAssociationExecutionsOutput, error)
	DescribeAssociationExecutionsWithContext(aws.Context, *ssm.DescribeAssociationExecutionsInput, ...request.Option) (*ssm.DescribeAssociationExecutionsOutput, error)
	DescribeAssociationExecutionsRequest(*ssm.DescribeAssociationExecutionsInput) (*request.Request, *ssm.DescribeAssociationExecutionsOutput)

	DescribeAssociationExecutionsPages(*ssm.DescribeAssociationExecutionsInput, func(*ssm.DescribeAssociationExecutionsOutput, bool) bool) error
	DescribeAssociationExecutionsPagesWithContext(aws.Context, *ssm.DescribeAssociationExecutionsInput, func(*ssm.DescribeAssociationExecutionsOutput, bool) bool, ...request.Option) error

	DescribeAutomationActions(*ssm.DescribeAutomationActionsInput) (*ssm.DescribeAutomationActionsOutput, error)
	DescribeAutomationActionsWithContext(aws.Context, *ssm.DescribeAutomationActionsInput, ...request.Option) (*ssm.DescribeAutomationActionsOutput, error)
	DescribeAutomationActionsRequest(*ssm.DescribeAutomationActionsInput) (*request.Request, *ssm.DescribeAutomationActionsOutput)

	DescribeAutomationExecutionParameters(*ssm.DescribeAutomationExecutionParametersInput) (*ssm.DescribeAutomationExecutionParametersOutput, error)
	DescribeAutomationExecutionParametersWithContext(aws.Context, *ssm.DescribeAutomationExecutionParametersInput, ...request.Option) (*ssm.DescribeAutomationExecutionParametersOutput, error)
	DescribeAutomationExecutionParametersRequest(*ssm.DescribeAutomationExecutionParametersInput) (*request.Request, *ssm.DescribeAutomationExecutionParametersOutput)

	DescribeAutomationExecutions(*ssm.DescribeAutomationExecutionsInput) (*ssm.DescribeAutomationExecutionsOutput, error)
	DescribeAutomationExecutionsWithContext(aws.Context, *ssm.DescribeAutomationExecutionsInput, ...request.Option) (*ssm.DescribeAutomationExecutionsOutput, error)
	DescribeAutomationExecutionsRequest(*ssm.DescribeAutomationExecutionsInput) (*request.Request, *ssm.DescribeAutomationExecutionsOutput)

	DescribeAutomationExecutionsPages(*ssm.DescribeAutomationExecutionsInput, func(*ssm.DescribeAutomationExecutionsOutput, bool) bool) error
	DescribeAutomationExecutionsPagesWithContext(aws.Context, *ssm.DescribeAutomationExecutionsInput, func(*ssm.DescribeAutomationExecutionsOutput, bool) bool, ...request.Option) error

	DescribeAutomationStepExecutions(*ssm.DescribeAutomationStepExecutionsInput) (*ssm.DescribeAutomationStepExecutionsOutput, error)
	DescribeAutomationStepExecutionsWithContext(aws.Context, *ssm.DescribeAutomationStepExecutionsInput, ...request.Option) (*ssm.DescribeAutomationStepExecutionsOutput, error)
	DescribeAutomationStepExecutionsRequest(*ssm.DescribeAutomationStepExecutionsInput) (*request.Request, *ssm.DescribeAutomationStepExecutionsOutput)

	DescribeAutomationStepExecutionsPages(*ssm.DescribeAutomationStepExecutionsInput, func(*ssm.DescribeAutomationStepExecutionsOutput, bool) bool) error
	DescribeAutomationStepExecutionsPagesWithContext(aws.Context, *ssm.DescribeAutomationStepExecutionsInput, func(*ssm.DescribeAutomationStepExecutionsOutput, bool) bool, ...request.Option) error

	DescribeAvailablePatches(*ssm.DescribeAvailablePatchesInput) (*ssm.DescribeAvailablePatchesOutput, error)
	DescribeAvailablePatchesWithContext(aws.Context, *ssm.DescribeAvailablePatchesInput, ...request.Option) (*ssm.DescribeAvailablePatchesOutput, error)
	DescribeAvailablePatchesRequest(*ssm.DescribeAvailablePatchesInput) (*request.Request, *ssm.DescribeAvailablePatchesOutput)

	DescribeAvailablePatchesPages(*ssm.DescribeAvailablePatchesInput, func(*ssm.DescribeAvailablePatchesOutput, bool) bool) error
	DescribeAvailablePatchesPagesWithContext(aws.Context, *ssm.DescribeAvailablePatchesInput, func(*ssm.DescribeAvailablePatchesOutput, bool) bool, ...request.Option) error

	DescribeDocument(*ssm.DescribeDocumentInput) (*ssm.DescribeDocumentOutput, error)
	DescribeDocumentWithContext(aws.Context, *ssm.DescribeDocumentInput, ...request.Option) (*ssm.DescribeDocumentOutput, error)
	DescribeDocumentRequest(*ssm.DescribeDocumentInput) (*request.Request, *ssm.DescribeDocumentOutput)

	DescribeDocumentInternal(*ssm.DescribeDocumentInternalInput) (*ssm.DescribeDocumentInternalOutput, error)
	DescribeDocumentInternalWithContext(aws.Context, *ssm.DescribeDocumentInternalInput, ...request.Option) (*ssm.DescribeDocumentInternalOutput, error)
	DescribeDocumentInternalRequest(*ssm.DescribeDocumentInternalInput) (*request.Request, *ssm.DescribeDocumentInternalOutput)

	DescribeDocumentParameters(*ssm.DescribeDocumentParametersInput) (*ssm.DescribeDocumentParametersOutput, error)
	DescribeDocumentParametersWithContext(aws.Context, *ssm.DescribeDocumentParametersInput, ...request.Option) (*ssm.DescribeDocumentParametersOutput, error)
	DescribeDocumentParametersRequest(*ssm.DescribeDocumentParametersInput) (*request.Request, *ssm.DescribeDocumentParametersOutput)

	DescribeDocumentPermission(*ssm.DescribeDocumentPermissionInput) (*ssm.DescribeDocumentPermissionOutput, error)
	DescribeDocumentPermissionWithContext(aws.Context, *ssm.DescribeDocumentPermissionInput, ...request.Option) (*ssm.DescribeDocumentPermissionOutput, error)
	DescribeDocumentPermissionRequest(*ssm.DescribeDocumentPermissionInput) (*request.Request, *ssm.DescribeDocumentPermissionOutput)

	DescribeDocumentSchema(*ssm.DescribeDocumentSchemaInput) (*ssm.DescribeDocumentSchemaOutput, error)
	DescribeDocumentSchemaWithContext(aws.Context, *ssm.DescribeDocumentSchemaInput, ...request.Option) (*ssm.DescribeDocumentSchemaOutput, error)
	DescribeDocumentSchemaRequest(*ssm.DescribeDocumentSchemaInput) (*request.Request, *ssm.DescribeDocumentSchemaOutput)

	DescribeDocumentStepSchema(*ssm.DescribeDocumentStepSchemaInput) (*ssm.DescribeDocumentStepSchemaOutput, error)
	DescribeDocumentStepSchemaWithContext(aws.Context, *ssm.DescribeDocumentStepSchemaInput, ...request.Option) (*ssm.DescribeDocumentStepSchemaOutput, error)
	DescribeDocumentStepSchemaRequest(*ssm.DescribeDocumentStepSchemaInput) (*request.Request, *ssm.DescribeDocumentStepSchemaOutput)

	DescribeDocumentSteps(*ssm.DescribeDocumentStepsInput) (*ssm.DescribeDocumentStepsOutput, error)
	DescribeDocumentStepsWithContext(aws.Context, *ssm.DescribeDocumentStepsInput, ...request.Option) (*ssm.DescribeDocumentStepsOutput, error)
	DescribeDocumentStepsRequest(*ssm.DescribeDocumentStepsInput) (*request.Request, *ssm.DescribeDocumentStepsOutput)

	DescribeEffectiveInstanceAssociations(*ssm.DescribeEffectiveInstanceAssociationsInput) (*ssm.DescribeEffectiveInstanceAssociationsOutput, error)
	DescribeEffectiveInstanceAssociationsWithContext(aws.Context, *ssm.DescribeEffectiveInstanceAssociationsInput, ...request.Option) (*ssm.DescribeEffectiveInstanceAssociationsOutput, error)
	DescribeEffectiveInstanceAssociationsRequest(*ssm.DescribeEffectiveInstanceAssociationsInput) (*request.Request, *ssm.DescribeEffectiveInstanceAssociationsOutput)

	DescribeEffectiveInstanceAssociationsPages(*ssm.DescribeEffectiveInstanceAssociationsInput, func(*ssm.DescribeEffectiveInstanceAssociationsOutput, bool) bool) error
	DescribeEffectiveInstanceAssociationsPagesWithContext(aws.Context, *ssm.DescribeEffectiveInstanceAssociationsInput, func(*ssm.DescribeEffectiveInstanceAssociationsOutput, bool) bool, ...request.Option) error

	DescribeEffectivePatchesForPatchBaseline(*ssm.DescribeEffectivePatchesForPatchBaselineInput) (*ssm.DescribeEffectivePatchesForPatchBaselineOutput, error)
	DescribeEffectivePatchesForPatchBaselineWithContext(aws.Context, *ssm.DescribeEffectivePatchesForPatchBaselineInput, ...request.Option) (*ssm.DescribeEffectivePatchesForPatchBaselineOutput, error)
	DescribeEffectivePatchesForPatchBaselineRequest(*ssm.DescribeEffectivePatchesForPatchBaselineInput) (*request.Request, *ssm.DescribeEffectivePatchesForPatchBaselineOutput)

	DescribeEffectivePatchesForPatchBaselinePages(*ssm.DescribeEffectivePatchesForPatchBaselineInput, func(*ssm.DescribeEffectivePatchesForPatchBaselineOutput, bool) bool) error
	DescribeEffectivePatchesForPatchBaselinePagesWithContext(aws.Context, *ssm.DescribeEffectivePatchesForPatchBaselineInput, func(*ssm.DescribeEffectivePatchesForPatchBaselineOutput, bool) bool, ...request.Option) error

	DescribeInstanceAssociationsStatus(*ssm.DescribeInstanceAssociationsStatusInput) (*ssm.DescribeInstanceAssociationsStatusOutput, error)
	DescribeInstanceAssociationsStatusWithContext(aws.Context, *ssm.DescribeInstanceAssociationsStatusInput, ...request.Option) (*ssm.DescribeInstanceAssociationsStatusOutput, error)
	DescribeInstanceAssociationsStatusRequest(*ssm.DescribeInstanceAssociationsStatusInput) (*request.Request, *ssm.DescribeInstanceAssociationsStatusOutput)

	DescribeInstanceAssociationsStatusPages(*ssm.DescribeInstanceAssociationsStatusInput, func(*ssm.DescribeInstanceAssociationsStatusOutput, bool) bool) error
	DescribeInstanceAssociationsStatusPagesWithContext(aws.Context, *ssm.DescribeInstanceAssociationsStatusInput, func(*ssm.DescribeInstanceAssociationsStatusOutput, bool) bool, ...request.Option) error

	DescribeInstanceInformation(*ssm.DescribeInstanceInformationInput) (*ssm.DescribeInstanceInformationOutput, error)
	DescribeInstanceInformationWithContext(aws.Context, *ssm.DescribeInstanceInformationInput, ...request.Option) (*ssm.DescribeInstanceInformationOutput, error)
	DescribeInstanceInformationRequest(*ssm.DescribeInstanceInformationInput) (*request.Request, *ssm.DescribeInstanceInformationOutput)

	DescribeInstanceInformationPages(*ssm.DescribeInstanceInformationInput, func(*ssm.DescribeInstanceInformationOutput, bool) bool) error
	DescribeInstanceInformationPagesWithContext(aws.Context, *ssm.DescribeInstanceInformationInput, func(*ssm.DescribeInstanceInformationOutput, bool) bool, ...request.Option) error

	DescribeInstancePatchStates(*ssm.DescribeInstancePatchStatesInput) (*ssm.DescribeInstancePatchStatesOutput, error)
	DescribeInstancePatchStatesWithContext(aws.Context, *ssm.DescribeInstancePatchStatesInput, ...request.Option) (*ssm.DescribeInstancePatchStatesOutput, error)
	DescribeInstancePatchStatesRequest(*ssm.DescribeInstancePatchStatesInput) (*request.Request, *ssm.DescribeInstancePatchStatesOutput)

	DescribeInstancePatchStatesPages(*ssm.DescribeInstancePatchStatesInput, func(*ssm.DescribeInstancePatchStatesOutput, bool) bool) error
	DescribeInstancePatchStatesPagesWithContext(aws.Context, *ssm.DescribeInstancePatchStatesInput, func(*ssm.DescribeInstancePatchStatesOutput, bool) bool, ...request.Option) error

	DescribeInstancePatchStatesForPatchGroup(*ssm.DescribeInstancePatchStatesForPatchGroupInput) (*ssm.DescribeInstancePatchStatesForPatchGroupOutput, error)
	DescribeInstancePatchStatesForPatchGroupWithContext(aws.Context, *ssm.DescribeInstancePatchStatesForPatchGroupInput, ...request.Option) (*ssm.DescribeInstancePatchStatesForPatchGroupOutput, error)
	DescribeInstancePatchStatesForPatchGroupRequest(*ssm.DescribeInstancePatchStatesForPatchGroupInput) (*request.Request, *ssm.DescribeInstancePatchStatesForPatchGroupOutput)

	DescribeInstancePatchStatesForPatchGroupPages(*ssm.DescribeInstancePatchStatesForPatchGroupInput, func(*ssm.DescribeInstancePatchStatesForPatchGroupOutput, bool) bool) error
	DescribeInstancePatchStatesForPatchGroupPagesWithContext(aws.Context, *ssm.DescribeInstancePatchStatesForPatchGroupInput, func(*ssm.DescribeInstancePatchStatesForPatchGroupOutput, bool) bool, ...request.Option) error

	DescribeInstancePatches(*ssm.DescribeInstancePatchesInput) (*ssm.DescribeInstancePatchesOutput, error)
	DescribeInstancePatchesWithContext(aws.Context, *ssm.DescribeInstancePatchesInput, ...request.Option) (*ssm.DescribeInstancePatchesOutput, error)
	DescribeInstancePatchesRequest(*ssm.DescribeInstancePatchesInput) (*request.Request, *ssm.DescribeInstancePatchesOutput)

	DescribeInstancePatchesPages(*ssm.DescribeInstancePatchesInput, func(*ssm.DescribeInstancePatchesOutput, bool) bool) error
	DescribeInstancePatchesPagesWithContext(aws.Context, *ssm.DescribeInstancePatchesInput, func(*ssm.DescribeInstancePatchesOutput, bool) bool, ...request.Option) error

	DescribeInstanceProperties(*ssm.DescribeInstancePropertiesInput) (*ssm.DescribeInstancePropertiesOutput, error)
	DescribeInstancePropertiesWithContext(aws.Context, *ssm.DescribeInstancePropertiesInput, ...request.Option) (*ssm.DescribeInstancePropertiesOutput, error)
	DescribeInstancePropertiesRequest(*ssm.DescribeInstancePropertiesInput) (*request.Request, *ssm.DescribeInstancePropertiesOutput)

	DescribeInstancePropertiesPages(*ssm.DescribeInstancePropertiesInput, func(*ssm.DescribeInstancePropertiesOutput, bool) bool) error
	DescribeInstancePropertiesPagesWithContext(aws.Context, *ssm.DescribeInstancePropertiesInput, func(*ssm.DescribeInstancePropertiesOutput, bool) bool, ...request.Option) error

	DescribeInventoryDeletions(*ssm.DescribeInventoryDeletionsInput) (*ssm.DescribeInventoryDeletionsOutput, error)
	DescribeInventoryDeletionsWithContext(aws.Context, *ssm.DescribeInventoryDeletionsInput, ...request.Option) (*ssm.DescribeInventoryDeletionsOutput, error)
	DescribeInventoryDeletionsRequest(*ssm.DescribeInventoryDeletionsInput) (*request.Request, *ssm.DescribeInventoryDeletionsOutput)

	DescribeInventoryDeletionsPages(*ssm.DescribeInventoryDeletionsInput, func(*ssm.DescribeInventoryDeletionsOutput, bool) bool) error
	DescribeInventoryDeletionsPagesWithContext(aws.Context, *ssm.DescribeInventoryDeletionsInput, func(*ssm.DescribeInventoryDeletionsOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindowExecutionTaskInvocations(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput) (*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error)
	DescribeMaintenanceWindowExecutionTaskInvocationsWithContext(aws.Context, *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput, ...request.Option) (*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput, error)
	DescribeMaintenanceWindowExecutionTaskInvocationsRequest(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput) (*request.Request, *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput)

	DescribeMaintenanceWindowExecutionTaskInvocationsPages(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput, func(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput, bool) bool) error
	DescribeMaintenanceWindowExecutionTaskInvocationsPagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowExecutionTaskInvocationsInput, func(*ssm.DescribeMaintenanceWindowExecutionTaskInvocationsOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindowExecutionTasks(*ssm.DescribeMaintenanceWindowExecutionTasksInput) (*ssm.DescribeMaintenanceWindowExecutionTasksOutput, error)
	DescribeMaintenanceWindowExecutionTasksWithContext(aws.Context, *ssm.DescribeMaintenanceWindowExecutionTasksInput, ...request.Option) (*ssm.DescribeMaintenanceWindowExecutionTasksOutput, error)
	DescribeMaintenanceWindowExecutionTasksRequest(*ssm.DescribeMaintenanceWindowExecutionTasksInput) (*request.Request, *ssm.DescribeMaintenanceWindowExecutionTasksOutput)

	DescribeMaintenanceWindowExecutionTasksPages(*ssm.DescribeMaintenanceWindowExecutionTasksInput, func(*ssm.DescribeMaintenanceWindowExecutionTasksOutput, bool) bool) error
	DescribeMaintenanceWindowExecutionTasksPagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowExecutionTasksInput, func(*ssm.DescribeMaintenanceWindowExecutionTasksOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindowExecutions(*ssm.DescribeMaintenanceWindowExecutionsInput) (*ssm.DescribeMaintenanceWindowExecutionsOutput, error)
	DescribeMaintenanceWindowExecutionsWithContext(aws.Context, *ssm.DescribeMaintenanceWindowExecutionsInput, ...request.Option) (*ssm.DescribeMaintenanceWindowExecutionsOutput, error)
	DescribeMaintenanceWindowExecutionsRequest(*ssm.DescribeMaintenanceWindowExecutionsInput) (*request.Request, *ssm.DescribeMaintenanceWindowExecutionsOutput)

	DescribeMaintenanceWindowExecutionsPages(*ssm.DescribeMaintenanceWindowExecutionsInput, func(*ssm.DescribeMaintenanceWindowExecutionsOutput, bool) bool) error
	DescribeMaintenanceWindowExecutionsPagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowExecutionsInput, func(*ssm.DescribeMaintenanceWindowExecutionsOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindowSchedule(*ssm.DescribeMaintenanceWindowScheduleInput) (*ssm.DescribeMaintenanceWindowScheduleOutput, error)
	DescribeMaintenanceWindowScheduleWithContext(aws.Context, *ssm.DescribeMaintenanceWindowScheduleInput, ...request.Option) (*ssm.DescribeMaintenanceWindowScheduleOutput, error)
	DescribeMaintenanceWindowScheduleRequest(*ssm.DescribeMaintenanceWindowScheduleInput) (*request.Request, *ssm.DescribeMaintenanceWindowScheduleOutput)

	DescribeMaintenanceWindowSchedulePages(*ssm.DescribeMaintenanceWindowScheduleInput, func(*ssm.DescribeMaintenanceWindowScheduleOutput, bool) bool) error
	DescribeMaintenanceWindowSchedulePagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowScheduleInput, func(*ssm.DescribeMaintenanceWindowScheduleOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindowTargets(*ssm.DescribeMaintenanceWindowTargetsInput) (*ssm.DescribeMaintenanceWindowTargetsOutput, error)
	DescribeMaintenanceWindowTargetsWithContext(aws.Context, *ssm.DescribeMaintenanceWindowTargetsInput, ...request.Option) (*ssm.DescribeMaintenanceWindowTargetsOutput, error)
	DescribeMaintenanceWindowTargetsRequest(*ssm.DescribeMaintenanceWindowTargetsInput) (*request.Request, *ssm.DescribeMaintenanceWindowTargetsOutput)

	DescribeMaintenanceWindowTargetsPages(*ssm.DescribeMaintenanceWindowTargetsInput, func(*ssm.DescribeMaintenanceWindowTargetsOutput, bool) bool) error
	DescribeMaintenanceWindowTargetsPagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowTargetsInput, func(*ssm.DescribeMaintenanceWindowTargetsOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindowTasks(*ssm.DescribeMaintenanceWindowTasksInput) (*ssm.DescribeMaintenanceWindowTasksOutput, error)
	DescribeMaintenanceWindowTasksWithContext(aws.Context, *ssm.DescribeMaintenanceWindowTasksInput, ...request.Option) (*ssm.DescribeMaintenanceWindowTasksOutput, error)
	DescribeMaintenanceWindowTasksRequest(*ssm.DescribeMaintenanceWindowTasksInput) (*request.Request, *ssm.DescribeMaintenanceWindowTasksOutput)

	DescribeMaintenanceWindowTasksPages(*ssm.DescribeMaintenanceWindowTasksInput, func(*ssm.DescribeMaintenanceWindowTasksOutput, bool) bool) error
	DescribeMaintenanceWindowTasksPagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowTasksInput, func(*ssm.DescribeMaintenanceWindowTasksOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindows(*ssm.DescribeMaintenanceWindowsInput) (*ssm.DescribeMaintenanceWindowsOutput, error)
	DescribeMaintenanceWindowsWithContext(aws.Context, *ssm.DescribeMaintenanceWindowsInput, ...request.Option) (*ssm.DescribeMaintenanceWindowsOutput, error)
	DescribeMaintenanceWindowsRequest(*ssm.DescribeMaintenanceWindowsInput) (*request.Request, *ssm.DescribeMaintenanceWindowsOutput)

	DescribeMaintenanceWindowsPages(*ssm.DescribeMaintenanceWindowsInput, func(*ssm.DescribeMaintenanceWindowsOutput, bool) bool) error
	DescribeMaintenanceWindowsPagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowsInput, func(*ssm.DescribeMaintenanceWindowsOutput, bool) bool, ...request.Option) error

	DescribeMaintenanceWindowsForTarget(*ssm.DescribeMaintenanceWindowsForTargetInput) (*ssm.DescribeMaintenanceWindowsForTargetOutput, error)
	DescribeMaintenanceWindowsForTargetWithContext(aws.Context, *ssm.DescribeMaintenanceWindowsForTargetInput, ...request.Option) (*ssm.DescribeMaintenanceWindowsForTargetOutput, error)
	DescribeMaintenanceWindowsForTargetRequest(*ssm.DescribeMaintenanceWindowsForTargetInput) (*request.Request, *ssm.DescribeMaintenanceWindowsForTargetOutput)

	DescribeMaintenanceWindowsForTargetPages(*ssm.DescribeMaintenanceWindowsForTargetInput, func(*ssm.DescribeMaintenanceWindowsForTargetOutput, bool) bool) error
	DescribeMaintenanceWindowsForTargetPagesWithContext(aws.Context, *ssm.DescribeMaintenanceWindowsForTargetInput, func(*ssm.DescribeMaintenanceWindowsForTargetOutput, bool) bool, ...request.Option) error

	DescribeOpsItems(*ssm.DescribeOpsItemsInput) (*ssm.DescribeOpsItemsOutput, error)
	DescribeOpsItemsWithContext(aws.Context, *ssm.DescribeOpsItemsInput, ...request.Option) (*ssm.DescribeOpsItemsOutput, error)
	DescribeOpsItemsRequest(*ssm.DescribeOpsItemsInput) (*request.Request, *ssm.DescribeOpsItemsOutput)

	DescribeOpsItemsPages(*ssm.DescribeOpsItemsInput, func(*ssm.DescribeOpsItemsOutput, bool) bool) error
	DescribeOpsItemsPagesWithContext(aws.Context, *ssm.DescribeOpsItemsInput, func(*ssm.DescribeOpsItemsOutput, bool) bool, ...request.Option) error

	DescribeParameters(*ssm.DescribeParametersInput) (*ssm.DescribeParametersOutput, error)
	DescribeParametersWithContext(aws.Context, *ssm.DescribeParametersInput, ...request.Option) (*ssm.DescribeParametersOutput, error)
	DescribeParametersRequest(*ssm.DescribeParametersInput) (*request.Request, *ssm.DescribeParametersOutput)

	DescribeParametersPages(*ssm.DescribeParametersInput, func(*ssm.DescribeParametersOutput, bool) bool) error
	DescribeParametersPagesWithContext(aws.Context, *ssm.DescribeParametersInput, func(*ssm.DescribeParametersOutput, bool) bool, ...request.Option) error

	DescribePatchBaselines(*ssm.DescribePatchBaselinesInput) (*ssm.DescribePatchBaselinesOutput, error)
	DescribePatchBaselinesWithContext(aws.Context, *ssm.DescribePatchBaselinesInput, ...request.Option) (*ssm.DescribePatchBaselinesOutput, error)
	DescribePatchBaselinesRequest(*ssm.DescribePatchBaselinesInput) (*request.Request, *ssm.DescribePatchBaselinesOutput)

	DescribePatchBaselinesPages(*ssm.DescribePatchBaselinesInput, func(*ssm.DescribePatchBaselinesOutput, bool) bool) error
	DescribePatchBaselinesPagesWithContext(aws.Context, *ssm.DescribePatchBaselinesInput, func(*ssm.DescribePatchBaselinesOutput, bool) bool, ...request.Option) error

	DescribePatchGroupState(*ssm.DescribePatchGroupStateInput) (*ssm.DescribePatchGroupStateOutput, error)
	DescribePatchGroupStateWithContext(aws.Context, *ssm.DescribePatchGroupStateInput, ...request.Option) (*ssm.DescribePatchGroupStateOutput, error)
	DescribePatchGroupStateRequest(*ssm.DescribePatchGroupStateInput) (*request.Request, *ssm.DescribePatchGroupStateOutput)

	DescribePatchGroups(*ssm.DescribePatchGroupsInput) (*ssm.DescribePatchGroupsOutput, error)
	DescribePatchGroupsWithContext(aws.Context, *ssm.DescribePatchGroupsInput, ...request.Option) (*ssm.DescribePatchGroupsOutput, error)
	DescribePatchGroupsRequest(*ssm.DescribePatchGroupsInput) (*request.Request, *ssm.DescribePatchGroupsOutput)

	DescribePatchGroupsPages(*ssm.DescribePatchGroupsInput, func(*ssm.DescribePatchGroupsOutput, bool) bool) error
	DescribePatchGroupsPagesWithContext(aws.Context, *ssm.DescribePatchGroupsInput, func(*ssm.DescribePatchGroupsOutput, bool) bool, ...request.Option) error

	DescribePatchProperties(*ssm.DescribePatchPropertiesInput) (*ssm.DescribePatchPropertiesOutput, error)
	DescribePatchPropertiesWithContext(aws.Context, *ssm.DescribePatchPropertiesInput, ...request.Option) (*ssm.DescribePatchPropertiesOutput, error)
	DescribePatchPropertiesRequest(*ssm.DescribePatchPropertiesInput) (*request.Request, *ssm.DescribePatchPropertiesOutput)

	DescribePatchPropertiesPages(*ssm.DescribePatchPropertiesInput, func(*ssm.DescribePatchPropertiesOutput, bool) bool) error
	DescribePatchPropertiesPagesWithContext(aws.Context, *ssm.DescribePatchPropertiesInput, func(*ssm.DescribePatchPropertiesOutput, bool) bool, ...request.Option) error

	DescribeSessions(*ssm.DescribeSessionsInput) (*ssm.DescribeSessionsOutput, error)
	DescribeSessionsWithContext(aws.Context, *ssm.DescribeSessionsInput, ...request.Option) (*ssm.DescribeSessionsOutput, error)
	DescribeSessionsRequest(*ssm.DescribeSessionsInput) (*request.Request, *ssm.DescribeSessionsOutput)

	DescribeSessionsPages(*ssm.DescribeSessionsInput, func(*ssm.DescribeSessionsOutput, bool) bool) error
	DescribeSessionsPagesWithContext(aws.Context, *ssm.DescribeSessionsInput, func(*ssm.DescribeSessionsOutput, bool) bool, ...request.Option) error

	DisassociateOpsItemRelatedItem(*ssm.DisassociateOpsItemRelatedItemInput) (*ssm.DisassociateOpsItemRelatedItemOutput, error)
	DisassociateOpsItemRelatedItemWithContext(aws.Context, *ssm.DisassociateOpsItemRelatedItemInput, ...request.Option) (*ssm.DisassociateOpsItemRelatedItemOutput, error)
	DisassociateOpsItemRelatedItemRequest(*ssm.DisassociateOpsItemRelatedItemInput) (*request.Request, *ssm.DisassociateOpsItemRelatedItemOutput)

	ExecuteApi(*ssm.ExecuteApiInput) (*ssm.ExecuteApiOutput, error)
	ExecuteApiWithContext(aws.Context, *ssm.ExecuteApiInput, ...request.Option) (*ssm.ExecuteApiOutput, error)
	ExecuteApiRequest(*ssm.ExecuteApiInput) (*request.Request, *ssm.ExecuteApiOutput)

	ExploreSsmActions(*ssm.ExploreSsmActionsInput) (*ssm.ExploreSsmActionsOutput, error)
	ExploreSsmActionsWithContext(aws.Context, *ssm.ExploreSsmActionsInput, ...request.Option) (*ssm.ExploreSsmActionsOutput, error)
	ExploreSsmActionsRequest(*ssm.ExploreSsmActionsInput) (*request.Request, *ssm.ExploreSsmActionsOutput)

	GetAccessToken(*ssm.GetAccessTokenInput) (*ssm.GetAccessTokenOutput, error)
	GetAccessTokenWithContext(aws.Context, *ssm.GetAccessTokenInput, ...request.Option) (*ssm.GetAccessTokenOutput, error)
	GetAccessTokenRequest(*ssm.GetAccessTokenInput) (*request.Request, *ssm.GetAccessTokenOutput)

	GetAutomationAction(*ssm.GetAutomationActionInput) (*ssm.GetAutomationActionOutput, error)
	GetAutomationActionWithContext(aws.Context, *ssm.GetAutomationActionInput, ...request.Option) (*ssm.GetAutomationActionOutput, error)
	GetAutomationActionRequest(*ssm.GetAutomationActionInput) (*request.Request, *ssm.GetAutomationActionOutput)

	GetAutomationExecution(*ssm.GetAutomationExecutionInput) (*ssm.GetAutomationExecutionOutput, error)
	GetAutomationExecutionWithContext(aws.Context, *ssm.GetAutomationExecutionInput, ...request.Option) (*ssm.GetAutomationExecutionOutput, error)
	GetAutomationExecutionRequest(*ssm.GetAutomationExecutionInput) (*request.Request, *ssm.GetAutomationExecutionOutput)

	GetCalendar(*ssm.GetCalendarInput) (*ssm.GetCalendarOutput, error)
	GetCalendarWithContext(aws.Context, *ssm.GetCalendarInput, ...request.Option) (*ssm.GetCalendarOutput, error)
	GetCalendarRequest(*ssm.GetCalendarInput) (*request.Request, *ssm.GetCalendarOutput)

	GetCalendarState(*ssm.GetCalendarStateInput) (*ssm.GetCalendarStateOutput, error)
	GetCalendarStateWithContext(aws.Context, *ssm.GetCalendarStateInput, ...request.Option) (*ssm.GetCalendarStateOutput, error)
	GetCalendarStateRequest(*ssm.GetCalendarStateInput) (*request.Request, *ssm.GetCalendarStateOutput)

	GetCommandInteractiveToken(*ssm.GetCommandInteractiveTokenInput) (*ssm.GetCommandInteractiveTokenOutput, error)
	GetCommandInteractiveTokenWithContext(aws.Context, *ssm.GetCommandInteractiveTokenInput, ...request.Option) (*ssm.GetCommandInteractiveTokenOutput, error)
	GetCommandInteractiveTokenRequest(*ssm.GetCommandInteractiveTokenInput) (*request.Request, *ssm.GetCommandInteractiveTokenOutput)

	GetCommandInvocation(*ssm.GetCommandInvocationInput) (*ssm.GetCommandInvocationOutput, error)
	GetCommandInvocationWithContext(aws.Context, *ssm.GetCommandInvocationInput, ...request.Option) (*ssm.GetCommandInvocationOutput, error)
	GetCommandInvocationRequest(*ssm.GetCommandInvocationInput) (*request.Request, *ssm.GetCommandInvocationOutput)

	GetConnectionStatus(*ssm.GetConnectionStatusInput) (*ssm.GetConnectionStatusOutput, error)
	GetConnectionStatusWithContext(aws.Context, *ssm.GetConnectionStatusInput, ...request.Option) (*ssm.GetConnectionStatusOutput, error)
	GetConnectionStatusRequest(*ssm.GetConnectionStatusInput) (*request.Request, *ssm.GetConnectionStatusOutput)

	GetDefaultPatchBaseline(*ssm.GetDefaultPatchBaselineInput) (*ssm.GetDefaultPatchBaselineOutput, error)
	GetDefaultPatchBaselineWithContext(aws.Context, *ssm.GetDefaultPatchBaselineInput, ...request.Option) (*ssm.GetDefaultPatchBaselineOutput, error)
	GetDefaultPatchBaselineRequest(*ssm.GetDefaultPatchBaselineInput) (*request.Request, *ssm.GetDefaultPatchBaselineOutput)

	GetDeployablePatchSnapshotForInstance(*ssm.GetDeployablePatchSnapshotForInstanceInput) (*ssm.GetDeployablePatchSnapshotForInstanceOutput, error)
	GetDeployablePatchSnapshotForInstanceWithContext(aws.Context, *ssm.GetDeployablePatchSnapshotForInstanceInput, ...request.Option) (*ssm.GetDeployablePatchSnapshotForInstanceOutput, error)
	GetDeployablePatchSnapshotForInstanceRequest(*ssm.GetDeployablePatchSnapshotForInstanceInput) (*request.Request, *ssm.GetDeployablePatchSnapshotForInstanceOutput)

	GetDocument(*ssm.GetDocumentInput) (*ssm.GetDocumentOutput, error)
	GetDocumentWithContext(aws.Context, *ssm.GetDocumentInput, ...request.Option) (*ssm.GetDocumentOutput, error)
	GetDocumentRequest(*ssm.GetDocumentInput) (*request.Request, *ssm.GetDocumentOutput)

	GetDocumentInternal(*ssm.GetDocumentInternalInput) (*ssm.GetDocumentInternalOutput, error)
	GetDocumentInternalWithContext(aws.Context, *ssm.GetDocumentInternalInput, ...request.Option) (*ssm.GetDocumentInternalOutput, error)
	GetDocumentInternalRequest(*ssm.GetDocumentInternalInput) (*request.Request, *ssm.GetDocumentInternalOutput)

	GetExecutionPreview(*ssm.GetExecutionPreviewInput) (*ssm.GetExecutionPreviewOutput, error)
	GetExecutionPreviewWithContext(aws.Context, *ssm.GetExecutionPreviewInput, ...request.Option) (*ssm.GetExecutionPreviewOutput, error)
	GetExecutionPreviewRequest(*ssm.GetExecutionPreviewInput) (*request.Request, *ssm.GetExecutionPreviewOutput)

	GetInventory(*ssm.GetInventoryInput) (*ssm.GetInventoryOutput, error)
	GetInventoryWithContext(aws.Context, *ssm.GetInventoryInput, ...request.Option) (*ssm.GetInventoryOutput, error)
	GetInventoryRequest(*ssm.GetInventoryInput) (*request.Request, *ssm.GetInventoryOutput)

	GetInventoryPages(*ssm.GetInventoryInput, func(*ssm.GetInventoryOutput, bool) bool) error
	GetInventoryPagesWithContext(aws.Context, *ssm.GetInventoryInput, func(*ssm.GetInventoryOutput, bool) bool, ...request.Option) error

	GetInventorySchema(*ssm.GetInventorySchemaInput) (*ssm.GetInventorySchemaOutput, error)
	GetInventorySchemaWithContext(aws.Context, *ssm.GetInventorySchemaInput, ...request.Option) (*ssm.GetInventorySchemaOutput, error)
	GetInventorySchemaRequest(*ssm.GetInventorySchemaInput) (*request.Request, *ssm.GetInventorySchemaOutput)

	GetInventorySchemaPages(*ssm.GetInventorySchemaInput, func(*ssm.GetInventorySchemaOutput, bool) bool) error
	GetInventorySchemaPagesWithContext(aws.Context, *ssm.GetInventorySchemaInput, func(*ssm.GetInventorySchemaOutput, bool) bool, ...request.Option) error

	GetMaintenanceWindow(*ssm.GetMaintenanceWindowInput) (*ssm.GetMaintenanceWindowOutput, error)
	GetMaintenanceWindowWithContext(aws.Context, *ssm.GetMaintenanceWindowInput, ...request.Option) (*ssm.GetMaintenanceWindowOutput, error)
	GetMaintenanceWindowRequest(*ssm.GetMaintenanceWindowInput) (*request.Request, *ssm.GetMaintenanceWindowOutput)

	GetMaintenanceWindowExecution(*ssm.GetMaintenanceWindowExecutionInput) (*ssm.GetMaintenanceWindowExecutionOutput, error)
	GetMaintenanceWindowExecutionWithContext(aws.Context, *ssm.GetMaintenanceWindowExecutionInput, ...request.Option) (*ssm.GetMaintenanceWindowExecutionOutput, error)
	GetMaintenanceWindowExecutionRequest(*ssm.GetMaintenanceWindowExecutionInput) (*request.Request, *ssm.GetMaintenanceWindowExecutionOutput)

	GetMaintenanceWindowExecutionTask(*ssm.GetMaintenanceWindowExecutionTaskInput) (*ssm.GetMaintenanceWindowExecutionTaskOutput, error)
	GetMaintenanceWindowExecutionTaskWithContext(aws.Context, *ssm.GetMaintenanceWindowExecutionTaskInput, ...request.Option) (*ssm.GetMaintenanceWindowExecutionTaskOutput, error)
	GetMaintenanceWindowExecutionTaskRequest(*ssm.GetMaintenanceWindowExecutionTaskInput) (*request.Request, *ssm.GetMaintenanceWindowExecutionTaskOutput)

	GetMaintenanceWindowExecutionTaskInvocation(*ssm.GetMaintenanceWindowExecutionTaskInvocationInput) (*ssm.GetMaintenanceWindowExecutionTaskInvocationOutput, error)
	GetMaintenanceWindowExecutionTaskInvocationWithContext(aws.Context, *ssm.GetMaintenanceWindowExecutionTaskInvocationInput, ...request.Option) (*ssm.GetMaintenanceWindowExecutionTaskInvocationOutput, error)
	GetMaintenanceWindowExecutionTaskInvocationRequest(*ssm.GetMaintenanceWindowExecutionTaskInvocationInput) (*request.Request, *ssm.GetMaintenanceWindowExecutionTaskInvocationOutput)

	GetMaintenanceWindowTask(*ssm.GetMaintenanceWindowTaskInput) (*ssm.GetMaintenanceWindowTaskOutput, error)
	GetMaintenanceWindowTaskWithContext(aws.Context, *ssm.GetMaintenanceWindowTaskInput, ...request.Option) (*ssm.GetMaintenanceWindowTaskOutput, error)
	GetMaintenanceWindowTaskRequest(*ssm.GetMaintenanceWindowTaskInput) (*request.Request, *ssm.GetMaintenanceWindowTaskOutput)

	GetManifest(*ssm.GetManifestInput) (*ssm.GetManifestOutput, error)
	GetManifestWithContext(aws.Context, *ssm.GetManifestInput, ...request.Option) (*ssm.GetManifestOutput, error)
	GetManifestRequest(*ssm.GetManifestInput) (*request.Request, *ssm.GetManifestOutput)

	GetOpsItem(*ssm.GetOpsItemInput) (*ssm.GetOpsItemOutput, error)
	GetOpsItemWithContext(aws.Context, *ssm.GetOpsItemInput, ...request.Option) (*ssm.GetOpsItemOutput, error)
	GetOpsItemRequest(*ssm.GetOpsItemInput) (*request.Request, *ssm.GetOpsItemOutput)

	GetOpsItemGroup(*ssm.GetOpsItemGroupInput) (*ssm.GetOpsItemGroupOutput, error)
	GetOpsItemGroupWithContext(aws.Context, *ssm.GetOpsItemGroupInput, ...request.Option) (*ssm.GetOpsItemGroupOutput, error)
	GetOpsItemGroupRequest(*ssm.GetOpsItemGroupInput) (*request.Request, *ssm.GetOpsItemGroupOutput)

	GetOpsMetadata(*ssm.GetOpsMetadataInput) (*ssm.GetOpsMetadataOutput, error)
	GetOpsMetadataWithContext(aws.Context, *ssm.GetOpsMetadataInput, ...request.Option) (*ssm.GetOpsMetadataOutput, error)
	GetOpsMetadataRequest(*ssm.GetOpsMetadataInput) (*request.Request, *ssm.GetOpsMetadataOutput)

	GetOpsSummary(*ssm.GetOpsSummaryInput) (*ssm.GetOpsSummaryOutput, error)
	GetOpsSummaryWithContext(aws.Context, *ssm.GetOpsSummaryInput, ...request.Option) (*ssm.GetOpsSummaryOutput, error)
	GetOpsSummaryRequest(*ssm.GetOpsSummaryInput) (*request.Request, *ssm.GetOpsSummaryOutput)

	GetOpsSummaryPages(*ssm.GetOpsSummaryInput, func(*ssm.GetOpsSummaryOutput, bool) bool) error
	GetOpsSummaryPagesWithContext(aws.Context, *ssm.GetOpsSummaryInput, func(*ssm.GetOpsSummaryOutput, bool) bool, ...request.Option) error

	GetParameter(*ssm.GetParameterInput) (*ssm.GetParameterOutput, error)
	GetParameterWithContext(aws.Context, *ssm.GetParameterInput, ...request.Option) (*ssm.GetParameterOutput, error)
	GetParameterRequest(*ssm.GetParameterInput) (*request.Request, *ssm.GetParameterOutput)

	GetParameterHistory(*ssm.GetParameterHistoryInput) (*ssm.GetParameterHistoryOutput, error)
	GetParameterHistoryWithContext(aws.Context, *ssm.GetParameterHistoryInput, ...request.Option) (*ssm.GetParameterHistoryOutput, error)
	GetParameterHistoryRequest(*ssm.GetParameterHistoryInput) (*request.Request, *ssm.GetParameterHistoryOutput)

	GetParameterHistoryPages(*ssm.GetParameterHistoryInput, func(*ssm.GetParameterHistoryOutput, bool) bool) error
	GetParameterHistoryPagesWithContext(aws.Context, *ssm.GetParameterHistoryInput, func(*ssm.GetParameterHistoryOutput, bool) bool, ...request.Option) error

	GetParameterMetadataInternal(*ssm.GetParameterMetadataInternalInput) (*ssm.GetParameterMetadataInternalOutput, error)
	GetParameterMetadataInternalWithContext(aws.Context, *ssm.GetParameterMetadataInternalInput, ...request.Option) (*ssm.GetParameterMetadataInternalOutput, error)
	GetParameterMetadataInternalRequest(*ssm.GetParameterMetadataInternalInput) (*request.Request, *ssm.GetParameterMetadataInternalOutput)

	GetParameters(*ssm.GetParametersInput) (*ssm.GetParametersOutput, error)
	GetParametersWithContext(aws.Context, *ssm.GetParametersInput, ...request.Option) (*ssm.GetParametersOutput, error)
	GetParametersRequest(*ssm.GetParametersInput) (*request.Request, *ssm.GetParametersOutput)

	GetParametersByPath(*ssm.GetParametersByPathInput) (*ssm.GetParametersByPathOutput, error)
	GetParametersByPathWithContext(aws.Context, *ssm.GetParametersByPathInput, ...request.Option) (*ssm.GetParametersByPathOutput, error)
	GetParametersByPathRequest(*ssm.GetParametersByPathInput) (*request.Request, *ssm.GetParametersByPathOutput)

	GetParametersByPathPages(*ssm.GetParametersByPathInput, func(*ssm.GetParametersByPathOutput, bool) bool) error
	GetParametersByPathPagesWithContext(aws.Context, *ssm.GetParametersByPathInput, func(*ssm.GetParametersByPathOutput, bool) bool, ...request.Option) error

	GetPatchBaseline(*ssm.GetPatchBaselineInput) (*ssm.GetPatchBaselineOutput, error)
	GetPatchBaselineWithContext(aws.Context, *ssm.GetPatchBaselineInput, ...request.Option) (*ssm.GetPatchBaselineOutput, error)
	GetPatchBaselineRequest(*ssm.GetPatchBaselineInput) (*request.Request, *ssm.GetPatchBaselineOutput)

	GetPatchBaselineForPatchGroup(*ssm.GetPatchBaselineForPatchGroupInput) (*ssm.GetPatchBaselineForPatchGroupOutput, error)
	GetPatchBaselineForPatchGroupWithContext(aws.Context, *ssm.GetPatchBaselineForPatchGroupInput, ...request.Option) (*ssm.GetPatchBaselineForPatchGroupOutput, error)
	GetPatchBaselineForPatchGroupRequest(*ssm.GetPatchBaselineForPatchGroupInput) (*request.Request, *ssm.GetPatchBaselineForPatchGroupOutput)

	GetResourcePolicies(*ssm.GetResourcePoliciesInput) (*ssm.GetResourcePoliciesOutput, error)
	GetResourcePoliciesWithContext(aws.Context, *ssm.GetResourcePoliciesInput, ...request.Option) (*ssm.GetResourcePoliciesOutput, error)
	GetResourcePoliciesRequest(*ssm.GetResourcePoliciesInput) (*request.Request, *ssm.GetResourcePoliciesOutput)

	GetResourcePoliciesPages(*ssm.GetResourcePoliciesInput, func(*ssm.GetResourcePoliciesOutput, bool) bool) error
	GetResourcePoliciesPagesWithContext(aws.Context, *ssm.GetResourcePoliciesInput, func(*ssm.GetResourcePoliciesOutput, bool) bool, ...request.Option) error

	GetResourcePolicyInternal(*ssm.GetResourcePolicyInternalInput) (*ssm.GetResourcePolicyInternalOutput, error)
	GetResourcePolicyInternalWithContext(aws.Context, *ssm.GetResourcePolicyInternalInput, ...request.Option) (*ssm.GetResourcePolicyInternalOutput, error)
	GetResourcePolicyInternalRequest(*ssm.GetResourcePolicyInternalInput) (*request.Request, *ssm.GetResourcePolicyInternalOutput)

	GetServiceSetting(*ssm.GetServiceSettingInput) (*ssm.GetServiceSettingOutput, error)
	GetServiceSettingWithContext(aws.Context, *ssm.GetServiceSettingInput, ...request.Option) (*ssm.GetServiceSettingOutput, error)
	GetServiceSettingRequest(*ssm.GetServiceSettingInput) (*request.Request, *ssm.GetServiceSettingOutput)

	GetServiceSettingInternal(*ssm.GetServiceSettingInternalInput) (*ssm.GetServiceSettingInternalOutput, error)
	GetServiceSettingInternalWithContext(aws.Context, *ssm.GetServiceSettingInternalInput, ...request.Option) (*ssm.GetServiceSettingInternalOutput, error)
	GetServiceSettingInternalRequest(*ssm.GetServiceSettingInternalInput) (*request.Request, *ssm.GetServiceSettingInternalOutput)

	LabelParameterVersion(*ssm.LabelParameterVersionInput) (*ssm.LabelParameterVersionOutput, error)
	LabelParameterVersionWithContext(aws.Context, *ssm.LabelParameterVersionInput, ...request.Option) (*ssm.LabelParameterVersionOutput, error)
	LabelParameterVersionRequest(*ssm.LabelParameterVersionInput) (*request.Request, *ssm.LabelParameterVersionOutput)

	ListAssociationVersions(*ssm.ListAssociationVersionsInput) (*ssm.ListAssociationVersionsOutput, error)
	ListAssociationVersionsWithContext(aws.Context, *ssm.ListAssociationVersionsInput, ...request.Option) (*ssm.ListAssociationVersionsOutput, error)
	ListAssociationVersionsRequest(*ssm.ListAssociationVersionsInput) (*request.Request, *ssm.ListAssociationVersionsOutput)

	ListAssociationVersionsPages(*ssm.ListAssociationVersionsInput, func(*ssm.ListAssociationVersionsOutput, bool) bool) error
	ListAssociationVersionsPagesWithContext(aws.Context, *ssm.ListAssociationVersionsInput, func(*ssm.ListAssociationVersionsOutput, bool) bool, ...request.Option) error

	ListAssociations(*ssm.ListAssociationsInput) (*ssm.ListAssociationsOutput, error)
	ListAssociationsWithContext(aws.Context, *ssm.ListAssociationsInput, ...request.Option) (*ssm.ListAssociationsOutput, error)
	ListAssociationsRequest(*ssm.ListAssociationsInput) (*request.Request, *ssm.ListAssociationsOutput)

	ListAssociationsPages(*ssm.ListAssociationsInput, func(*ssm.ListAssociationsOutput, bool) bool) error
	ListAssociationsPagesWithContext(aws.Context, *ssm.ListAssociationsInput, func(*ssm.ListAssociationsOutput, bool) bool, ...request.Option) error

	ListCalendarEvents(*ssm.ListCalendarEventsInput) (*ssm.ListCalendarEventsOutput, error)
	ListCalendarEventsWithContext(aws.Context, *ssm.ListCalendarEventsInput, ...request.Option) (*ssm.ListCalendarEventsOutput, error)
	ListCalendarEventsRequest(*ssm.ListCalendarEventsInput) (*request.Request, *ssm.ListCalendarEventsOutput)

	ListCommandInvocations(*ssm.ListCommandInvocationsInput) (*ssm.ListCommandInvocationsOutput, error)
	ListCommandInvocationsWithContext(aws.Context, *ssm.ListCommandInvocationsInput, ...request.Option) (*ssm.ListCommandInvocationsOutput, error)
	ListCommandInvocationsRequest(*ssm.ListCommandInvocationsInput) (*request.Request, *ssm.ListCommandInvocationsOutput)

	ListCommandInvocationsPages(*ssm.ListCommandInvocationsInput, func(*ssm.ListCommandInvocationsOutput, bool) bool) error
	ListCommandInvocationsPagesWithContext(aws.Context, *ssm.ListCommandInvocationsInput, func(*ssm.ListCommandInvocationsOutput, bool) bool, ...request.Option) error

	ListCommands(*ssm.ListCommandsInput) (*ssm.ListCommandsOutput, error)
	ListCommandsWithContext(aws.Context, *ssm.ListCommandsInput, ...request.Option) (*ssm.ListCommandsOutput, error)
	ListCommandsRequest(*ssm.ListCommandsInput) (*request.Request, *ssm.ListCommandsOutput)

	ListCommandsPages(*ssm.ListCommandsInput, func(*ssm.ListCommandsOutput, bool) bool) error
	ListCommandsPagesWithContext(aws.Context, *ssm.ListCommandsInput, func(*ssm.ListCommandsOutput, bool) bool, ...request.Option) error

	ListComplianceItems(*ssm.ListComplianceItemsInput) (*ssm.ListComplianceItemsOutput, error)
	ListComplianceItemsWithContext(aws.Context, *ssm.ListComplianceItemsInput, ...request.Option) (*ssm.ListComplianceItemsOutput, error)
	ListComplianceItemsRequest(*ssm.ListComplianceItemsInput) (*request.Request, *ssm.ListComplianceItemsOutput)

	ListComplianceItemsPages(*ssm.ListComplianceItemsInput, func(*ssm.ListComplianceItemsOutput, bool) bool) error
	ListComplianceItemsPagesWithContext(aws.Context, *ssm.ListComplianceItemsInput, func(*ssm.ListComplianceItemsOutput, bool) bool, ...request.Option) error

	ListComplianceSummaries(*ssm.ListComplianceSummariesInput) (*ssm.ListComplianceSummariesOutput, error)
	ListComplianceSummariesWithContext(aws.Context, *ssm.ListComplianceSummariesInput, ...request.Option) (*ssm.ListComplianceSummariesOutput, error)
	ListComplianceSummariesRequest(*ssm.ListComplianceSummariesInput) (*request.Request, *ssm.ListComplianceSummariesOutput)

	ListComplianceSummariesPages(*ssm.ListComplianceSummariesInput, func(*ssm.ListComplianceSummariesOutput, bool) bool) error
	ListComplianceSummariesPagesWithContext(aws.Context, *ssm.ListComplianceSummariesInput, func(*ssm.ListComplianceSummariesOutput, bool) bool, ...request.Option) error

	ListConsumerAccounts(*ssm.ListConsumerAccountsInput) (*ssm.ListConsumerAccountsOutput, error)
	ListConsumerAccountsWithContext(aws.Context, *ssm.ListConsumerAccountsInput, ...request.Option) (*ssm.ListConsumerAccountsOutput, error)
	ListConsumerAccountsRequest(*ssm.ListConsumerAccountsInput) (*request.Request, *ssm.ListConsumerAccountsOutput)

	ListDocumentMetadataHistory(*ssm.ListDocumentMetadataHistoryInput) (*ssm.ListDocumentMetadataHistoryOutput, error)
	ListDocumentMetadataHistoryWithContext(aws.Context, *ssm.ListDocumentMetadataHistoryInput, ...request.Option) (*ssm.ListDocumentMetadataHistoryOutput, error)
	ListDocumentMetadataHistoryRequest(*ssm.ListDocumentMetadataHistoryInput) (*request.Request, *ssm.ListDocumentMetadataHistoryOutput)

	ListDocumentVersions(*ssm.ListDocumentVersionsInput) (*ssm.ListDocumentVersionsOutput, error)
	ListDocumentVersionsWithContext(aws.Context, *ssm.ListDocumentVersionsInput, ...request.Option) (*ssm.ListDocumentVersionsOutput, error)
	ListDocumentVersionsRequest(*ssm.ListDocumentVersionsInput) (*request.Request, *ssm.ListDocumentVersionsOutput)

	ListDocumentVersionsPages(*ssm.ListDocumentVersionsInput, func(*ssm.ListDocumentVersionsOutput, bool) bool) error
	ListDocumentVersionsPagesWithContext(aws.Context, *ssm.ListDocumentVersionsInput, func(*ssm.ListDocumentVersionsOutput, bool) bool, ...request.Option) error

	ListDocuments(*ssm.ListDocumentsInput) (*ssm.ListDocumentsOutput, error)
	ListDocumentsWithContext(aws.Context, *ssm.ListDocumentsInput, ...request.Option) (*ssm.ListDocumentsOutput, error)
	ListDocumentsRequest(*ssm.ListDocumentsInput) (*request.Request, *ssm.ListDocumentsOutput)

	ListDocumentsPages(*ssm.ListDocumentsInput, func(*ssm.ListDocumentsOutput, bool) bool) error
	ListDocumentsPagesWithContext(aws.Context, *ssm.ListDocumentsInput, func(*ssm.ListDocumentsOutput, bool) bool, ...request.Option) error

	ListInstanceAssociations(*ssm.ListInstanceAssociationsInput) (*ssm.ListInstanceAssociationsOutput, error)
	ListInstanceAssociationsWithContext(aws.Context, *ssm.ListInstanceAssociationsInput, ...request.Option) (*ssm.ListInstanceAssociationsOutput, error)
	ListInstanceAssociationsRequest(*ssm.ListInstanceAssociationsInput) (*request.Request, *ssm.ListInstanceAssociationsOutput)

	ListInventoryEntries(*ssm.ListInventoryEntriesInput) (*ssm.ListInventoryEntriesOutput, error)
	ListInventoryEntriesWithContext(aws.Context, *ssm.ListInventoryEntriesInput, ...request.Option) (*ssm.ListInventoryEntriesOutput, error)
	ListInventoryEntriesRequest(*ssm.ListInventoryEntriesInput) (*request.Request, *ssm.ListInventoryEntriesOutput)

	ListNodes(*ssm.ListNodesInput) (*ssm.ListNodesOutput, error)
	ListNodesWithContext(aws.Context, *ssm.ListNodesInput, ...request.Option) (*ssm.ListNodesOutput, error)
	ListNodesRequest(*ssm.ListNodesInput) (*request.Request, *ssm.ListNodesOutput)

	ListNodesPages(*ssm.ListNodesInput, func(*ssm.ListNodesOutput, bool) bool) error
	ListNodesPagesWithContext(aws.Context, *ssm.ListNodesInput, func(*ssm.ListNodesOutput, bool) bool, ...request.Option) error

	ListNodesSummary(*ssm.ListNodesSummaryInput) (*ssm.ListNodesSummaryOutput, error)
	ListNodesSummaryWithContext(aws.Context, *ssm.ListNodesSummaryInput, ...request.Option) (*ssm.ListNodesSummaryOutput, error)
	ListNodesSummaryRequest(*ssm.ListNodesSummaryInput) (*request.Request, *ssm.ListNodesSummaryOutput)

	ListNodesSummaryPages(*ssm.ListNodesSummaryInput, func(*ssm.ListNodesSummaryOutput, bool) bool) error
	ListNodesSummaryPagesWithContext(aws.Context, *ssm.ListNodesSummaryInput, func(*ssm.ListNodesSummaryOutput, bool) bool, ...request.Option) error

	ListOpsItemEvents(*ssm.ListOpsItemEventsInput) (*ssm.ListOpsItemEventsOutput, error)
	ListOpsItemEventsWithContext(aws.Context, *ssm.ListOpsItemEventsInput, ...request.Option) (*ssm.ListOpsItemEventsOutput, error)
	ListOpsItemEventsRequest(*ssm.ListOpsItemEventsInput) (*request.Request, *ssm.ListOpsItemEventsOutput)

	ListOpsItemEventsPages(*ssm.ListOpsItemEventsInput, func(*ssm.ListOpsItemEventsOutput, bool) bool) error
	ListOpsItemEventsPagesWithContext(aws.Context, *ssm.ListOpsItemEventsInput, func(*ssm.ListOpsItemEventsOutput, bool) bool, ...request.Option) error

	ListOpsItemRelatedItems(*ssm.ListOpsItemRelatedItemsInput) (*ssm.ListOpsItemRelatedItemsOutput, error)
	ListOpsItemRelatedItemsWithContext(aws.Context, *ssm.ListOpsItemRelatedItemsInput, ...request.Option) (*ssm.ListOpsItemRelatedItemsOutput, error)
	ListOpsItemRelatedItemsRequest(*ssm.ListOpsItemRelatedItemsInput) (*request.Request, *ssm.ListOpsItemRelatedItemsOutput)

	ListOpsItemRelatedItemsPages(*ssm.ListOpsItemRelatedItemsInput, func(*ssm.ListOpsItemRelatedItemsOutput, bool) bool) error
	ListOpsItemRelatedItemsPagesWithContext(aws.Context, *ssm.ListOpsItemRelatedItemsInput, func(*ssm.ListOpsItemRelatedItemsOutput, bool) bool, ...request.Option) error

	ListOpsMetadata(*ssm.ListOpsMetadataInput) (*ssm.ListOpsMetadataOutput, error)
	ListOpsMetadataWithContext(aws.Context, *ssm.ListOpsMetadataInput, ...request.Option) (*ssm.ListOpsMetadataOutput, error)
	ListOpsMetadataRequest(*ssm.ListOpsMetadataInput) (*request.Request, *ssm.ListOpsMetadataOutput)

	ListOpsMetadataPages(*ssm.ListOpsMetadataInput, func(*ssm.ListOpsMetadataOutput, bool) bool) error
	ListOpsMetadataPagesWithContext(aws.Context, *ssm.ListOpsMetadataInput, func(*ssm.ListOpsMetadataOutput, bool) bool, ...request.Option) error

	ListResourceComplianceSummaries(*ssm.ListResourceComplianceSummariesInput) (*ssm.ListResourceComplianceSummariesOutput, error)
	ListResourceComplianceSummariesWithContext(aws.Context, *ssm.ListResourceComplianceSummariesInput, ...request.Option) (*ssm.ListResourceComplianceSummariesOutput, error)
	ListResourceComplianceSummariesRequest(*ssm.ListResourceComplianceSummariesInput) (*request.Request, *ssm.ListResourceComplianceSummariesOutput)

	ListResourceComplianceSummariesPages(*ssm.ListResourceComplianceSummariesInput, func(*ssm.ListResourceComplianceSummariesOutput, bool) bool) error
	ListResourceComplianceSummariesPagesWithContext(aws.Context, *ssm.ListResourceComplianceSummariesInput, func(*ssm.ListResourceComplianceSummariesOutput, bool) bool, ...request.Option) error

	ListResourceDataSync(*ssm.ListResourceDataSyncInput) (*ssm.ListResourceDataSyncOutput, error)
	ListResourceDataSyncWithContext(aws.Context, *ssm.ListResourceDataSyncInput, ...request.Option) (*ssm.ListResourceDataSyncOutput, error)
	ListResourceDataSyncRequest(*ssm.ListResourceDataSyncInput) (*request.Request, *ssm.ListResourceDataSyncOutput)

	ListResourceDataSyncPages(*ssm.ListResourceDataSyncInput, func(*ssm.ListResourceDataSyncOutput, bool) bool) error
	ListResourceDataSyncPagesWithContext(aws.Context, *ssm.ListResourceDataSyncInput, func(*ssm.ListResourceDataSyncOutput, bool) bool, ...request.Option) error

	ListResourcesSupportPolicy(*ssm.ListResourcesSupportPolicyInput) (*ssm.ListResourcesSupportPolicyOutput, error)
	ListResourcesSupportPolicyWithContext(aws.Context, *ssm.ListResourcesSupportPolicyInput, ...request.Option) (*ssm.ListResourcesSupportPolicyOutput, error)
	ListResourcesSupportPolicyRequest(*ssm.ListResourcesSupportPolicyInput) (*request.Request, *ssm.ListResourcesSupportPolicyOutput)

	ListServiceSettingsInternal(*ssm.ListServiceSettingsInternalInput) (*ssm.ListServiceSettingsInternalOutput, error)
	ListServiceSettingsInternalWithContext(aws.Context, *ssm.ListServiceSettingsInternalInput, ...request.Option) (*ssm.ListServiceSettingsInternalOutput, error)
	ListServiceSettingsInternalRequest(*ssm.ListServiceSettingsInternalInput) (*request.Request, *ssm.ListServiceSettingsInternalOutput)

	ListSharedResources(*ssm.ListSharedResourcesInput) (*ssm.ListSharedResourcesOutput, error)
	ListSharedResourcesWithContext(aws.Context, *ssm.ListSharedResourcesInput, ...request.Option) (*ssm.ListSharedResourcesOutput, error)
	ListSharedResourcesRequest(*ssm.ListSharedResourcesInput) (*request.Request, *ssm.ListSharedResourcesOutput)

	ListTagsForResource(*ssm.ListTagsForResourceInput) (*ssm.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *ssm.ListTagsForResourceInput, ...request.Option) (*ssm.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*ssm.ListTagsForResourceInput) (*request.Request, *ssm.ListTagsForResourceOutput)

	LockServiceLinkedRole(*ssm.LockServiceLinkedRoleInput) (*ssm.LockServiceLinkedRoleOutput, error)
	LockServiceLinkedRoleWithContext(aws.Context, *ssm.LockServiceLinkedRoleInput, ...request.Option) (*ssm.LockServiceLinkedRoleOutput, error)
	LockServiceLinkedRoleRequest(*ssm.LockServiceLinkedRoleInput) (*request.Request, *ssm.LockServiceLinkedRoleOutput)

	ModifyDocumentPermission(*ssm.ModifyDocumentPermissionInput) (*ssm.ModifyDocumentPermissionOutput, error)
	ModifyDocumentPermissionWithContext(aws.Context, *ssm.ModifyDocumentPermissionInput, ...request.Option) (*ssm.ModifyDocumentPermissionOutput, error)
	ModifyDocumentPermissionRequest(*ssm.ModifyDocumentPermissionInput) (*request.Request, *ssm.ModifyDocumentPermissionOutput)

	PutCalendar(*ssm.PutCalendarInput) (*ssm.PutCalendarOutput, error)
	PutCalendarWithContext(aws.Context, *ssm.PutCalendarInput, ...request.Option) (*ssm.PutCalendarOutput, error)
	PutCalendarRequest(*ssm.PutCalendarInput) (*request.Request, *ssm.PutCalendarOutput)

	PutComplianceItems(*ssm.PutComplianceItemsInput) (*ssm.PutComplianceItemsOutput, error)
	PutComplianceItemsWithContext(aws.Context, *ssm.PutComplianceItemsInput, ...request.Option) (*ssm.PutComplianceItemsOutput, error)
	PutComplianceItemsRequest(*ssm.PutComplianceItemsInput) (*request.Request, *ssm.PutComplianceItemsOutput)

	PutConfigurePackageResult(*ssm.PutConfigurePackageResultInput) (*ssm.PutConfigurePackageResultOutput, error)
	PutConfigurePackageResultWithContext(aws.Context, *ssm.PutConfigurePackageResultInput, ...request.Option) (*ssm.PutConfigurePackageResultOutput, error)
	PutConfigurePackageResultRequest(*ssm.PutConfigurePackageResultInput) (*request.Request, *ssm.PutConfigurePackageResultOutput)

	PutInventory(*ssm.PutInventoryInput) (*ssm.PutInventoryOutput, error)
	PutInventoryWithContext(aws.Context, *ssm.PutInventoryInput, ...request.Option) (*ssm.PutInventoryOutput, error)
	PutInventoryRequest(*ssm.PutInventoryInput) (*request.Request, *ssm.PutInventoryOutput)

	PutParameter(*ssm.PutParameterInput) (*ssm.PutParameterOutput, error)
	PutParameterWithContext(aws.Context, *ssm.PutParameterInput, ...request.Option) (*ssm.PutParameterOutput, error)
	PutParameterRequest(*ssm.PutParameterInput) (*request.Request, *ssm.PutParameterOutput)

	PutResourcePolicy(*ssm.PutResourcePolicyInput) (*ssm.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *ssm.PutResourcePolicyInput, ...request.Option) (*ssm.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*ssm.PutResourcePolicyInput) (*request.Request, *ssm.PutResourcePolicyOutput)

	RegisterDefaultPatchBaseline(*ssm.RegisterDefaultPatchBaselineInput) (*ssm.RegisterDefaultPatchBaselineOutput, error)
	RegisterDefaultPatchBaselineWithContext(aws.Context, *ssm.RegisterDefaultPatchBaselineInput, ...request.Option) (*ssm.RegisterDefaultPatchBaselineOutput, error)
	RegisterDefaultPatchBaselineRequest(*ssm.RegisterDefaultPatchBaselineInput) (*request.Request, *ssm.RegisterDefaultPatchBaselineOutput)

	RegisterManagedInstance(*ssm.RegisterManagedInstanceInput) (*ssm.RegisterManagedInstanceOutput, error)
	RegisterManagedInstanceWithContext(aws.Context, *ssm.RegisterManagedInstanceInput, ...request.Option) (*ssm.RegisterManagedInstanceOutput, error)
	RegisterManagedInstanceRequest(*ssm.RegisterManagedInstanceInput) (*request.Request, *ssm.RegisterManagedInstanceOutput)

	RegisterPatchBaselineForPatchGroup(*ssm.RegisterPatchBaselineForPatchGroupInput) (*ssm.RegisterPatchBaselineForPatchGroupOutput, error)
	RegisterPatchBaselineForPatchGroupWithContext(aws.Context, *ssm.RegisterPatchBaselineForPatchGroupInput, ...request.Option) (*ssm.RegisterPatchBaselineForPatchGroupOutput, error)
	RegisterPatchBaselineForPatchGroupRequest(*ssm.RegisterPatchBaselineForPatchGroupInput) (*request.Request, *ssm.RegisterPatchBaselineForPatchGroupOutput)

	RegisterTargetWithMaintenanceWindow(*ssm.RegisterTargetWithMaintenanceWindowInput) (*ssm.RegisterTargetWithMaintenanceWindowOutput, error)
	RegisterTargetWithMaintenanceWindowWithContext(aws.Context, *ssm.RegisterTargetWithMaintenanceWindowInput, ...request.Option) (*ssm.RegisterTargetWithMaintenanceWindowOutput, error)
	RegisterTargetWithMaintenanceWindowRequest(*ssm.RegisterTargetWithMaintenanceWindowInput) (*request.Request, *ssm.RegisterTargetWithMaintenanceWindowOutput)

	RegisterTaskWithMaintenanceWindow(*ssm.RegisterTaskWithMaintenanceWindowInput) (*ssm.RegisterTaskWithMaintenanceWindowOutput, error)
	RegisterTaskWithMaintenanceWindowWithContext(aws.Context, *ssm.RegisterTaskWithMaintenanceWindowInput, ...request.Option) (*ssm.RegisterTaskWithMaintenanceWindowOutput, error)
	RegisterTaskWithMaintenanceWindowRequest(*ssm.RegisterTaskWithMaintenanceWindowInput) (*request.Request, *ssm.RegisterTaskWithMaintenanceWindowOutput)

	RemoveTagsFromResource(*ssm.RemoveTagsFromResourceInput) (*ssm.RemoveTagsFromResourceOutput, error)
	RemoveTagsFromResourceWithContext(aws.Context, *ssm.RemoveTagsFromResourceInput, ...request.Option) (*ssm.RemoveTagsFromResourceOutput, error)
	RemoveTagsFromResourceRequest(*ssm.RemoveTagsFromResourceInput) (*request.Request, *ssm.RemoveTagsFromResourceOutput)

	RequestManagedInstanceRoleToken(*ssm.RequestManagedInstanceRoleTokenInput) (*ssm.RequestManagedInstanceRoleTokenOutput, error)
	RequestManagedInstanceRoleTokenWithContext(aws.Context, *ssm.RequestManagedInstanceRoleTokenInput, ...request.Option) (*ssm.RequestManagedInstanceRoleTokenOutput, error)
	RequestManagedInstanceRoleTokenRequest(*ssm.RequestManagedInstanceRoleTokenInput) (*request.Request, *ssm.RequestManagedInstanceRoleTokenOutput)

	ResetServiceSetting(*ssm.ResetServiceSettingInput) (*ssm.ResetServiceSettingOutput, error)
	ResetServiceSettingWithContext(aws.Context, *ssm.ResetServiceSettingInput, ...request.Option) (*ssm.ResetServiceSettingOutput, error)
	ResetServiceSettingRequest(*ssm.ResetServiceSettingInput) (*request.Request, *ssm.ResetServiceSettingOutput)

	ResumeSession(*ssm.ResumeSessionInput) (*ssm.ResumeSessionOutput, error)
	ResumeSessionWithContext(aws.Context, *ssm.ResumeSessionInput, ...request.Option) (*ssm.ResumeSessionOutput, error)
	ResumeSessionRequest(*ssm.ResumeSessionInput) (*request.Request, *ssm.ResumeSessionOutput)

	SendAutomationSignal(*ssm.SendAutomationSignalInput) (*ssm.SendAutomationSignalOutput, error)
	SendAutomationSignalWithContext(aws.Context, *ssm.SendAutomationSignalInput, ...request.Option) (*ssm.SendAutomationSignalOutput, error)
	SendAutomationSignalRequest(*ssm.SendAutomationSignalInput) (*request.Request, *ssm.SendAutomationSignalOutput)

	SendCommand(*ssm.SendCommandInput) (*ssm.SendCommandOutput, error)
	SendCommandWithContext(aws.Context, *ssm.SendCommandInput, ...request.Option) (*ssm.SendCommandOutput, error)
	SendCommandRequest(*ssm.SendCommandInput) (*request.Request, *ssm.SendCommandOutput)

	StartAccessRequest(*ssm.StartAccessRequestInput) (*ssm.StartAccessRequestOutput, error)
	StartAccessRequestWithContext(aws.Context, *ssm.StartAccessRequestInput, ...request.Option) (*ssm.StartAccessRequestOutput, error)
	StartAccessRequestRequest(*ssm.StartAccessRequestInput) (*request.Request, *ssm.StartAccessRequestOutput)

	StartAssociationsOnce(*ssm.StartAssociationsOnceInput) (*ssm.StartAssociationsOnceOutput, error)
	StartAssociationsOnceWithContext(aws.Context, *ssm.StartAssociationsOnceInput, ...request.Option) (*ssm.StartAssociationsOnceOutput, error)
	StartAssociationsOnceRequest(*ssm.StartAssociationsOnceInput) (*request.Request, *ssm.StartAssociationsOnceOutput)

	StartAutomationExecution(*ssm.StartAutomationExecutionInput) (*ssm.StartAutomationExecutionOutput, error)
	StartAutomationExecutionWithContext(aws.Context, *ssm.StartAutomationExecutionInput, ...request.Option) (*ssm.StartAutomationExecutionOutput, error)
	StartAutomationExecutionRequest(*ssm.StartAutomationExecutionInput) (*request.Request, *ssm.StartAutomationExecutionOutput)

	StartChangeRequestExecution(*ssm.StartChangeRequestExecutionInput) (*ssm.StartChangeRequestExecutionOutput, error)
	StartChangeRequestExecutionWithContext(aws.Context, *ssm.StartChangeRequestExecutionInput, ...request.Option) (*ssm.StartChangeRequestExecutionOutput, error)
	StartChangeRequestExecutionRequest(*ssm.StartChangeRequestExecutionInput) (*request.Request, *ssm.StartChangeRequestExecutionOutput)

	StartExecutionPreview(*ssm.StartExecutionPreviewInput) (*ssm.StartExecutionPreviewOutput, error)
	StartExecutionPreviewWithContext(aws.Context, *ssm.StartExecutionPreviewInput, ...request.Option) (*ssm.StartExecutionPreviewOutput, error)
	StartExecutionPreviewRequest(*ssm.StartExecutionPreviewInput) (*request.Request, *ssm.StartExecutionPreviewOutput)

	StartSession(*ssm.StartSessionInput) (*ssm.StartSessionOutput, error)
	StartSessionWithContext(aws.Context, *ssm.StartSessionInput, ...request.Option) (*ssm.StartSessionOutput, error)
	StartSessionRequest(*ssm.StartSessionInput) (*request.Request, *ssm.StartSessionOutput)

	StopAutomationExecution(*ssm.StopAutomationExecutionInput) (*ssm.StopAutomationExecutionOutput, error)
	StopAutomationExecutionWithContext(aws.Context, *ssm.StopAutomationExecutionInput, ...request.Option) (*ssm.StopAutomationExecutionOutput, error)
	StopAutomationExecutionRequest(*ssm.StopAutomationExecutionInput) (*request.Request, *ssm.StopAutomationExecutionOutput)

	TerminateSession(*ssm.TerminateSessionInput) (*ssm.TerminateSessionOutput, error)
	TerminateSessionWithContext(aws.Context, *ssm.TerminateSessionInput, ...request.Option) (*ssm.TerminateSessionOutput, error)
	TerminateSessionRequest(*ssm.TerminateSessionInput) (*request.Request, *ssm.TerminateSessionOutput)

	UnlabelParameterVersion(*ssm.UnlabelParameterVersionInput) (*ssm.UnlabelParameterVersionOutput, error)
	UnlabelParameterVersionWithContext(aws.Context, *ssm.UnlabelParameterVersionInput, ...request.Option) (*ssm.UnlabelParameterVersionOutput, error)
	UnlabelParameterVersionRequest(*ssm.UnlabelParameterVersionInput) (*request.Request, *ssm.UnlabelParameterVersionOutput)

	UnlockServiceLinkedRole(*ssm.UnlockServiceLinkedRoleInput) (*ssm.UnlockServiceLinkedRoleOutput, error)
	UnlockServiceLinkedRoleWithContext(aws.Context, *ssm.UnlockServiceLinkedRoleInput, ...request.Option) (*ssm.UnlockServiceLinkedRoleOutput, error)
	UnlockServiceLinkedRoleRequest(*ssm.UnlockServiceLinkedRoleInput) (*request.Request, *ssm.UnlockServiceLinkedRoleOutput)

	UpdateAssociation(*ssm.UpdateAssociationInput) (*ssm.UpdateAssociationOutput, error)
	UpdateAssociationWithContext(aws.Context, *ssm.UpdateAssociationInput, ...request.Option) (*ssm.UpdateAssociationOutput, error)
	UpdateAssociationRequest(*ssm.UpdateAssociationInput) (*request.Request, *ssm.UpdateAssociationOutput)

	UpdateAssociationStatus(*ssm.UpdateAssociationStatusInput) (*ssm.UpdateAssociationStatusOutput, error)
	UpdateAssociationStatusWithContext(aws.Context, *ssm.UpdateAssociationStatusInput, ...request.Option) (*ssm.UpdateAssociationStatusOutput, error)
	UpdateAssociationStatusRequest(*ssm.UpdateAssociationStatusInput) (*request.Request, *ssm.UpdateAssociationStatusOutput)

	UpdateDocument(*ssm.UpdateDocumentInput) (*ssm.UpdateDocumentOutput, error)
	UpdateDocumentWithContext(aws.Context, *ssm.UpdateDocumentInput, ...request.Option) (*ssm.UpdateDocumentOutput, error)
	UpdateDocumentRequest(*ssm.UpdateDocumentInput) (*request.Request, *ssm.UpdateDocumentOutput)

	UpdateDocumentDefaultVersion(*ssm.UpdateDocumentDefaultVersionInput) (*ssm.UpdateDocumentDefaultVersionOutput, error)
	UpdateDocumentDefaultVersionWithContext(aws.Context, *ssm.UpdateDocumentDefaultVersionInput, ...request.Option) (*ssm.UpdateDocumentDefaultVersionOutput, error)
	UpdateDocumentDefaultVersionRequest(*ssm.UpdateDocumentDefaultVersionInput) (*request.Request, *ssm.UpdateDocumentDefaultVersionOutput)

	UpdateDocumentMetadata(*ssm.UpdateDocumentMetadataInput) (*ssm.UpdateDocumentMetadataOutput, error)
	UpdateDocumentMetadataWithContext(aws.Context, *ssm.UpdateDocumentMetadataInput, ...request.Option) (*ssm.UpdateDocumentMetadataOutput, error)
	UpdateDocumentMetadataRequest(*ssm.UpdateDocumentMetadataInput) (*request.Request, *ssm.UpdateDocumentMetadataOutput)

	UpdateInstanceAssociationStatus(*ssm.UpdateInstanceAssociationStatusInput) (*ssm.UpdateInstanceAssociationStatusOutput, error)
	UpdateInstanceAssociationStatusWithContext(aws.Context, *ssm.UpdateInstanceAssociationStatusInput, ...request.Option) (*ssm.UpdateInstanceAssociationStatusOutput, error)
	UpdateInstanceAssociationStatusRequest(*ssm.UpdateInstanceAssociationStatusInput) (*request.Request, *ssm.UpdateInstanceAssociationStatusOutput)

	UpdateInstanceInformation(*ssm.UpdateInstanceInformationInput) (*ssm.UpdateInstanceInformationOutput, error)
	UpdateInstanceInformationWithContext(aws.Context, *ssm.UpdateInstanceInformationInput, ...request.Option) (*ssm.UpdateInstanceInformationOutput, error)
	UpdateInstanceInformationRequest(*ssm.UpdateInstanceInformationInput) (*request.Request, *ssm.UpdateInstanceInformationOutput)

	UpdateMaintenanceWindow(*ssm.UpdateMaintenanceWindowInput) (*ssm.UpdateMaintenanceWindowOutput, error)
	UpdateMaintenanceWindowWithContext(aws.Context, *ssm.UpdateMaintenanceWindowInput, ...request.Option) (*ssm.UpdateMaintenanceWindowOutput, error)
	UpdateMaintenanceWindowRequest(*ssm.UpdateMaintenanceWindowInput) (*request.Request, *ssm.UpdateMaintenanceWindowOutput)

	UpdateMaintenanceWindowTarget(*ssm.UpdateMaintenanceWindowTargetInput) (*ssm.UpdateMaintenanceWindowTargetOutput, error)
	UpdateMaintenanceWindowTargetWithContext(aws.Context, *ssm.UpdateMaintenanceWindowTargetInput, ...request.Option) (*ssm.UpdateMaintenanceWindowTargetOutput, error)
	UpdateMaintenanceWindowTargetRequest(*ssm.UpdateMaintenanceWindowTargetInput) (*request.Request, *ssm.UpdateMaintenanceWindowTargetOutput)

	UpdateMaintenanceWindowTask(*ssm.UpdateMaintenanceWindowTaskInput) (*ssm.UpdateMaintenanceWindowTaskOutput, error)
	UpdateMaintenanceWindowTaskWithContext(aws.Context, *ssm.UpdateMaintenanceWindowTaskInput, ...request.Option) (*ssm.UpdateMaintenanceWindowTaskOutput, error)
	UpdateMaintenanceWindowTaskRequest(*ssm.UpdateMaintenanceWindowTaskInput) (*request.Request, *ssm.UpdateMaintenanceWindowTaskOutput)

	UpdateManagedInstancePublicKey(*ssm.UpdateManagedInstancePublicKeyInput) (*ssm.UpdateManagedInstancePublicKeyOutput, error)
	UpdateManagedInstancePublicKeyWithContext(aws.Context, *ssm.UpdateManagedInstancePublicKeyInput, ...request.Option) (*ssm.UpdateManagedInstancePublicKeyOutput, error)
	UpdateManagedInstancePublicKeyRequest(*ssm.UpdateManagedInstancePublicKeyInput) (*request.Request, *ssm.UpdateManagedInstancePublicKeyOutput)

	UpdateManagedInstanceRole(*ssm.UpdateManagedInstanceRoleInput) (*ssm.UpdateManagedInstanceRoleOutput, error)
	UpdateManagedInstanceRoleWithContext(aws.Context, *ssm.UpdateManagedInstanceRoleInput, ...request.Option) (*ssm.UpdateManagedInstanceRoleOutput, error)
	UpdateManagedInstanceRoleRequest(*ssm.UpdateManagedInstanceRoleInput) (*request.Request, *ssm.UpdateManagedInstanceRoleOutput)

	UpdateOpsItem(*ssm.UpdateOpsItemInput) (*ssm.UpdateOpsItemOutput, error)
	UpdateOpsItemWithContext(aws.Context, *ssm.UpdateOpsItemInput, ...request.Option) (*ssm.UpdateOpsItemOutput, error)
	UpdateOpsItemRequest(*ssm.UpdateOpsItemInput) (*request.Request, *ssm.UpdateOpsItemOutput)

	UpdateOpsMetadata(*ssm.UpdateOpsMetadataInput) (*ssm.UpdateOpsMetadataOutput, error)
	UpdateOpsMetadataWithContext(aws.Context, *ssm.UpdateOpsMetadataInput, ...request.Option) (*ssm.UpdateOpsMetadataOutput, error)
	UpdateOpsMetadataRequest(*ssm.UpdateOpsMetadataInput) (*request.Request, *ssm.UpdateOpsMetadataOutput)

	UpdateParameterDataInternal(*ssm.UpdateParameterDataInternalInput) (*ssm.UpdateParameterDataInternalOutput, error)
	UpdateParameterDataInternalWithContext(aws.Context, *ssm.UpdateParameterDataInternalInput, ...request.Option) (*ssm.UpdateParameterDataInternalOutput, error)
	UpdateParameterDataInternalRequest(*ssm.UpdateParameterDataInternalInput) (*request.Request, *ssm.UpdateParameterDataInternalOutput)

	UpdatePatchBaseline(*ssm.UpdatePatchBaselineInput) (*ssm.UpdatePatchBaselineOutput, error)
	UpdatePatchBaselineWithContext(aws.Context, *ssm.UpdatePatchBaselineInput, ...request.Option) (*ssm.UpdatePatchBaselineOutput, error)
	UpdatePatchBaselineRequest(*ssm.UpdatePatchBaselineInput) (*request.Request, *ssm.UpdatePatchBaselineOutput)

	UpdateResourceDataSync(*ssm.UpdateResourceDataSyncInput) (*ssm.UpdateResourceDataSyncOutput, error)
	UpdateResourceDataSyncWithContext(aws.Context, *ssm.UpdateResourceDataSyncInput, ...request.Option) (*ssm.UpdateResourceDataSyncOutput, error)
	UpdateResourceDataSyncRequest(*ssm.UpdateResourceDataSyncInput) (*request.Request, *ssm.UpdateResourceDataSyncOutput)

	UpdateResourceSharingStateV2(*ssm.UpdateResourceSharingStateV2Input) (*ssm.UpdateResourceSharingStateV2Output, error)
	UpdateResourceSharingStateV2WithContext(aws.Context, *ssm.UpdateResourceSharingStateV2Input, ...request.Option) (*ssm.UpdateResourceSharingStateV2Output, error)
	UpdateResourceSharingStateV2Request(*ssm.UpdateResourceSharingStateV2Input) (*request.Request, *ssm.UpdateResourceSharingStateV2Output)

	UpdateServiceSetting(*ssm.UpdateServiceSettingInput) (*ssm.UpdateServiceSettingOutput, error)
	UpdateServiceSettingWithContext(aws.Context, *ssm.UpdateServiceSettingInput, ...request.Option) (*ssm.UpdateServiceSettingOutput, error)
	UpdateServiceSettingRequest(*ssm.UpdateServiceSettingInput) (*request.Request, *ssm.UpdateServiceSettingOutput)

	UpdateServiceSettingInternal(*ssm.UpdateServiceSettingInternalInput) (*ssm.UpdateServiceSettingInternalOutput, error)
	UpdateServiceSettingInternalWithContext(aws.Context, *ssm.UpdateServiceSettingInternalInput, ...request.Option) (*ssm.UpdateServiceSettingInternalOutput, error)
	UpdateServiceSettingInternalRequest(*ssm.UpdateServiceSettingInternalInput) (*request.Request, *ssm.UpdateServiceSettingInternalOutput)

	ValidateResourceSharing(*ssm.ValidateResourceSharingInput) (*ssm.ValidateResourceSharingOutput, error)
	ValidateResourceSharingWithContext(aws.Context, *ssm.ValidateResourceSharingInput, ...request.Option) (*ssm.ValidateResourceSharingOutput, error)
	ValidateResourceSharingRequest(*ssm.ValidateResourceSharingInput) (*request.Request, *ssm.ValidateResourceSharingOutput)

	WaitUntilCommandExecuted(*ssm.GetCommandInvocationInput) error
	WaitUntilCommandExecutedWithContext(aws.Context, *ssm.GetCommandInvocationInput, ...request.WaiterOption) error
}

var _ SSMAPI = (*ssm.SSM)(nil)
