# For z13 and above.
# RUN: llvm-mc -triple s390x-linux-gnu -mcpu=z13 -show-encoding %s \
# RUN:   | FileCheck %s
# RUN: llvm-mc -triple s390x-linux-gnu -mcpu=arch11 -show-encoding %s \
# RUN:   | FileCheck %s

#CHECK: cdpt	%f0, 0(1), 0                # encoding: [0xed,0x00,0x00,0x00,0x00,0xae]
#CHECK: cdpt	%f15, 0(1), 0               # encoding: [0xed,0x00,0x00,0x00,0xf0,0xae]
#CHECK: cdpt	%f0, 0(1), 15               # encoding: [0xed,0x00,0x00,0x00,0x0f,0xae]
#CHECK: cdpt	%f0, 0(1,%r1), 0            # encoding: [0xed,0x00,0x10,0x00,0x00,0xae]
#CHECK: cdpt	%f0, 0(1,%r15), 0           # encoding: [0xed,0x00,0xf0,0x00,0x00,0xae]
#CHECK: cdpt	%f0, 4095(1,%r1), 0         # encoding: [0xed,0x00,0x1f,0xff,0x00,0xae]
#CHECK: cdpt	%f0, 4095(1,%r15), 0        # encoding: [0xed,0x00,0xff,0xff,0x00,0xae]
#CHECK: cdpt	%f0, 0(256,%r1), 0          # encoding: [0xed,0xff,0x10,0x00,0x00,0xae]
#CHECK: cdpt	%f0, 0(256,%r15), 0         # encoding: [0xed,0xff,0xf0,0x00,0x00,0xae]

	cdpt	%f0, 0(1), 0
	cdpt	%f15, 0(1), 0
	cdpt	%f0, 0(1), 15
	cdpt	%f0, 0(1,%r1), 0
	cdpt	%f0, 0(1,%r15), 0
	cdpt	%f0, 4095(1,%r1), 0
	cdpt	%f0, 4095(1,%r15), 0
	cdpt	%f0, 0(256,%r1), 0
	cdpt	%f0, 0(256,%r15), 0

#CHECK: cpdt	%f0, 0(1), 0                # encoding: [0xed,0x00,0x00,0x00,0x00,0xac]
#CHECK: cpdt	%f15, 0(1), 0               # encoding: [0xed,0x00,0x00,0x00,0xf0,0xac]
#CHECK: cpdt	%f0, 0(1), 15               # encoding: [0xed,0x00,0x00,0x00,0x0f,0xac]
#CHECK: cpdt	%f0, 0(1,%r1), 0            # encoding: [0xed,0x00,0x10,0x00,0x00,0xac]
#CHECK: cpdt	%f0, 0(1,%r15), 0           # encoding: [0xed,0x00,0xf0,0x00,0x00,0xac]
#CHECK: cpdt	%f0, 4095(1,%r1), 0         # encoding: [0xed,0x00,0x1f,0xff,0x00,0xac]
#CHECK: cpdt	%f0, 4095(1,%r15), 0        # encoding: [0xed,0x00,0xff,0xff,0x00,0xac]
#CHECK: cpdt	%f0, 0(256,%r1), 0          # encoding: [0xed,0xff,0x10,0x00,0x00,0xac]
#CHECK: cpdt	%f0, 0(256,%r15), 0         # encoding: [0xed,0xff,0xf0,0x00,0x00,0xac]

	cpdt	%f0, 0(1), 0
	cpdt	%f15, 0(1), 0
	cpdt	%f0, 0(1), 15
	cpdt	%f0, 0(1,%r1), 0
	cpdt	%f0, 0(1,%r15), 0
	cpdt	%f0, 4095(1,%r1), 0
	cpdt	%f0, 4095(1,%r15), 0
	cpdt	%f0, 0(256,%r1), 0
	cpdt	%f0, 0(256,%r15), 0

#CHECK: cpxt	%f0, 0(1), 0                # encoding: [0xed,0x00,0x00,0x00,0x00,0xad]
#CHECK: cpxt	%f13, 0(1), 0               # encoding: [0xed,0x00,0x00,0x00,0xd0,0xad]
#CHECK: cpxt	%f0, 0(1), 15               # encoding: [0xed,0x00,0x00,0x00,0x0f,0xad]
#CHECK: cpxt	%f0, 0(1,%r1), 0            # encoding: [0xed,0x00,0x10,0x00,0x00,0xad]
#CHECK: cpxt	%f0, 0(1,%r15), 0           # encoding: [0xed,0x00,0xf0,0x00,0x00,0xad]
#CHECK: cpxt	%f0, 4095(1,%r1), 0         # encoding: [0xed,0x00,0x1f,0xff,0x00,0xad]
#CHECK: cpxt	%f0, 4095(1,%r15), 0        # encoding: [0xed,0x00,0xff,0xff,0x00,0xad]
#CHECK: cpxt	%f0, 0(256,%r1), 0          # encoding: [0xed,0xff,0x10,0x00,0x00,0xad]
#CHECK: cpxt	%f0, 0(256,%r15), 0         # encoding: [0xed,0xff,0xf0,0x00,0x00,0xad]

	cpxt	%f0, 0(1), 0
	cpxt	%f13, 0(1), 0
	cpxt	%f0, 0(1), 15
	cpxt	%f0, 0(1,%r1), 0
	cpxt	%f0, 0(1,%r15), 0
	cpxt	%f0, 4095(1,%r1), 0
	cpxt	%f0, 4095(1,%r15), 0
	cpxt	%f0, 0(256,%r1), 0
	cpxt	%f0, 0(256,%r15), 0

#CHECK: cxpt	%f0, 0(1), 0                # encoding: [0xed,0x00,0x00,0x00,0x00,0xaf]
#CHECK: cxpt	%f13, 0(1), 0               # encoding: [0xed,0x00,0x00,0x00,0xd0,0xaf]
#CHECK: cxpt	%f0, 0(1), 15               # encoding: [0xed,0x00,0x00,0x00,0x0f,0xaf]
#CHECK: cxpt	%f0, 0(1,%r1), 0            # encoding: [0xed,0x00,0x10,0x00,0x00,0xaf]
#CHECK: cxpt	%f0, 0(1,%r15), 0           # encoding: [0xed,0x00,0xf0,0x00,0x00,0xaf]
#CHECK: cxpt	%f0, 4095(1,%r1), 0         # encoding: [0xed,0x00,0x1f,0xff,0x00,0xaf]
#CHECK: cxpt	%f0, 4095(1,%r15), 0        # encoding: [0xed,0x00,0xff,0xff,0x00,0xaf]
#CHECK: cxpt	%f0, 0(256,%r1), 0          # encoding: [0xed,0xff,0x10,0x00,0x00,0xaf]
#CHECK: cxpt	%f0, 0(256,%r15), 0         # encoding: [0xed,0xff,0xf0,0x00,0x00,0xaf]

	cxpt	%f0, 0(1), 0
	cxpt	%f13, 0(1), 0
	cxpt	%f0, 0(1), 15
	cxpt	%f0, 0(1,%r1), 0
	cxpt	%f0, 0(1,%r15), 0
	cxpt	%f0, 4095(1,%r1), 0
	cxpt	%f0, 4095(1,%r15), 0
	cxpt	%f0, 0(256,%r1), 0
	cxpt	%f0, 0(256,%r15), 0

#CHECK: lcbb    %r0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x27]
#CHECK: lcbb    %r0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x27]
#CHECK: lcbb    %r0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x27]
#CHECK: lcbb    %r0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x27]
#CHECK: lcbb    %r0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x27]
#CHECK: lcbb    %r15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x27]
#CHECK: lcbb    %r2, 1383(%r3,%r4), 8   # encoding: [0xe7,0x23,0x45,0x67,0x80,0x27]

	lcbb	%r0, 0, 0
	lcbb	%r0, 0, 15
	lcbb	%r0, 4095, 0
	lcbb	%r0, 0(%r15), 0
	lcbb	%r0, 0(%r15,%r1), 0
	lcbb	%r15, 0, 0
	lcbb	%r2, 1383(%r3,%r4), 8

#CHECK: llzrgf  %r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x3a]
#CHECK: llzrgf  %r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x3a]
#CHECK: llzrgf  %r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x3a]
#CHECK: llzrgf  %r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x3a]
#CHECK: llzrgf  %r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x3a]
#CHECK: llzrgf  %r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x3a]
#CHECK: llzrgf  %r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x3a]
#CHECK: llzrgf  %r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x3a]
#CHECK: llzrgf  %r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x3a]
#CHECK: llzrgf  %r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x3a]

	llzrgf	%r0, -524288
	llzrgf	%r0, -1
	llzrgf	%r0, 0
	llzrgf	%r0, 1
	llzrgf	%r0, 524287
	llzrgf	%r0, 0(%r1)
	llzrgf	%r0, 0(%r15)
	llzrgf	%r0, 524287(%r1,%r15)
	llzrgf	%r0, 524287(%r15,%r1)
	llzrgf	%r15, 0

#CHECK: lochi  %r11, 42, 0    # encoding: [0xec,0xb0,0x00,0x2a,0x00,0x42]
#CHECK: lochio %r11, 42       # encoding: [0xec,0xb1,0x00,0x2a,0x00,0x42]
#CHECK: lochih %r11, 42       # encoding: [0xec,0xb2,0x00,0x2a,0x00,0x42]
#CHECK: lochinle %r11, 42     # encoding: [0xec,0xb3,0x00,0x2a,0x00,0x42]
#CHECK: lochil %r11, -1       # encoding: [0xec,0xb4,0xff,0xff,0x00,0x42]
#CHECK: lochinhe %r11, 42     # encoding: [0xec,0xb5,0x00,0x2a,0x00,0x42]
#CHECK: lochilh %r11, -1      # encoding: [0xec,0xb6,0xff,0xff,0x00,0x42]
#CHECK: lochine %r11, 0       # encoding: [0xec,0xb7,0x00,0x00,0x00,0x42]
#CHECK: lochie %r11, 0        # encoding: [0xec,0xb8,0x00,0x00,0x00,0x42]
#CHECK: lochinlh %r11, 42     # encoding: [0xec,0xb9,0x00,0x2a,0x00,0x42]
#CHECK: lochihe %r11, 255     # encoding: [0xec,0xba,0x00,0xff,0x00,0x42]
#CHECK: lochinl %r11, 255     # encoding: [0xec,0xbb,0x00,0xff,0x00,0x42]
#CHECK: lochile %r11, 32767   # encoding: [0xec,0xbc,0x7f,0xff,0x00,0x42]
#CHECK: lochinh %r11, 32767   # encoding: [0xec,0xbd,0x7f,0xff,0x00,0x42]
#CHECK: lochino %r11, 32512   # encoding: [0xec,0xbe,0x7f,0x00,0x00,0x42]
#CHECK: lochi %r11, 32512, 15 # encoding: [0xec,0xbf,0x7f,0x00,0x00,0x42]

        lochi  %r11, 42, 0
        lochio %r11, 42
        lochih %r11, 42
        lochinle %r11, 42
        lochil %r11, -1
        lochinhe %r11, 42
        lochilh %r11, -1
        lochine %r11, 0
        lochie %r11, 0
        lochinlh %r11, 42
        lochihe %r11, 255
        lochinl %r11, 255
        lochile %r11, 32767
        lochinh %r11, 32767
        lochino %r11, 32512
        lochi %r11, 32512, 15

#CHECK: lochim %r10, 2766   # encoding: [0xec,0xa4,0x0a,0xce,0x00,0x42]
#CHECK: lochinm %r11, 6862  # encoding: [0xec,0xbb,0x1a,0xce,0x00,0x42]
#CHECK: lochip %r12, 10958  # encoding: [0xec,0xc2,0x2a,0xce,0x00,0x42]
#CHECK: lochiz %r13, 15054  # encoding: [0xec,0xd8,0x3a,0xce,0x00,0x42]
#CHECK: lochinp %r14, 19150 # encoding: [0xec,0xed,0x4a,0xce,0x00,0x42]
#CHECK: lochinz %r15, 23246 # encoding: [0xec,0xf7,0x5a,0xce,0x00,0x42]
        lochim %r10, 2766
        lochinm %r11, 6862
        lochip %r12, 10958
        lochiz %r13, 15054
        lochinp %r14, 19150
        lochinz %r15, 23246

#CHECK: locghi  %r11, 42, 0    # encoding: [0xec,0xb0,0x00,0x2a,0x00,0x46]
#CHECK: locghio %r11, 42       # encoding: [0xec,0xb1,0x00,0x2a,0x00,0x46]
#CHECK: locghih %r11, 42       # encoding: [0xec,0xb2,0x00,0x2a,0x00,0x46]
#CHECK: locghinle %r11, 42     # encoding: [0xec,0xb3,0x00,0x2a,0x00,0x46]
#CHECK: locghil %r11, -1       # encoding: [0xec,0xb4,0xff,0xff,0x00,0x46]
#CHECK: locghinhe %r11, 42     # encoding: [0xec,0xb5,0x00,0x2a,0x00,0x46]
#CHECK: locghilh %r11, -1      # encoding: [0xec,0xb6,0xff,0xff,0x00,0x46]
#CHECK: locghine %r11, 0       # encoding: [0xec,0xb7,0x00,0x00,0x00,0x46]
#CHECK: locghie %r11, 0        # encoding: [0xec,0xb8,0x00,0x00,0x00,0x46]
#CHECK: locghinlh %r11, 42     # encoding: [0xec,0xb9,0x00,0x2a,0x00,0x46]
#CHECK: locghihe %r11, 255     # encoding: [0xec,0xba,0x00,0xff,0x00,0x46]
#CHECK: locghinl %r11, 255     # encoding: [0xec,0xbb,0x00,0xff,0x00,0x46]
#CHECK: locghile %r11, 32767   # encoding: [0xec,0xbc,0x7f,0xff,0x00,0x46]
#CHECK: locghinh %r11, 32767   # encoding: [0xec,0xbd,0x7f,0xff,0x00,0x46]
#CHECK: locghino %r11, 32512   # encoding: [0xec,0xbe,0x7f,0x00,0x00,0x46]
#CHECK: locghi %r11, 32512, 15 # encoding: [0xec,0xbf,0x7f,0x00,0x00,0x46]

        locghi  %r11, 42, 0
        locghio %r11, 42
        locghih %r11, 42
        locghinle %r11, 42
        locghil %r11, -1
        locghinhe %r11, 42
        locghilh %r11, -1
        locghine %r11, 0
        locghie %r11, 0
        locghinlh %r11, 42
        locghihe %r11, 255
        locghinl %r11, 255
        locghile %r11, 32767
        locghinh %r11, 32767
        locghino %r11, 32512
        locghi %r11, 32512, 15

#CHECK: locghim %r10, 2766   # encoding: [0xec,0xa4,0x0a,0xce,0x00,0x46]
#CHECK: locghinm %r11, 6862  # encoding: [0xec,0xbb,0x1a,0xce,0x00,0x46]
#CHECK: locghip %r12, 10958  # encoding: [0xec,0xc2,0x2a,0xce,0x00,0x46]
#CHECK: locghiz %r13, 15054  # encoding: [0xec,0xd8,0x3a,0xce,0x00,0x46]
#CHECK: locghinp %r14, 19150 # encoding: [0xec,0xed,0x4a,0xce,0x00,0x46]
#CHECK: locghinz %r15, 23246 # encoding: [0xec,0xf7,0x5a,0xce,0x00,0x46]
        locghim %r10, 2766
        locghinm %r11, 6862
        locghip %r12, 10958
        locghiz %r13, 15054
        locghinp %r14, 19150
        locghinz %r15, 23246

#CHECK: lochhi  %r11, 42, 0    # encoding: [0xec,0xb0,0x00,0x2a,0x00,0x4e]
#CHECK: lochhio %r11, 42       # encoding: [0xec,0xb1,0x00,0x2a,0x00,0x4e]
#CHECK: lochhih %r11, 42       # encoding: [0xec,0xb2,0x00,0x2a,0x00,0x4e]
#CHECK: lochhinle %r11, 42     # encoding: [0xec,0xb3,0x00,0x2a,0x00,0x4e]
#CHECK: lochhil %r11, -1       # encoding: [0xec,0xb4,0xff,0xff,0x00,0x4e]
#CHECK: lochhinhe %r11, 42     # encoding: [0xec,0xb5,0x00,0x2a,0x00,0x4e]
#CHECK: lochhilh %r11, -1      # encoding: [0xec,0xb6,0xff,0xff,0x00,0x4e]
#CHECK: lochhine %r11, 0       # encoding: [0xec,0xb7,0x00,0x00,0x00,0x4e]
#CHECK: lochhie %r11, 0        # encoding: [0xec,0xb8,0x00,0x00,0x00,0x4e]
#CHECK: lochhinlh %r11, 42     # encoding: [0xec,0xb9,0x00,0x2a,0x00,0x4e]
#CHECK: lochhihe %r11, 255     # encoding: [0xec,0xba,0x00,0xff,0x00,0x4e]
#CHECK: lochhinl %r11, 255     # encoding: [0xec,0xbb,0x00,0xff,0x00,0x4e]
#CHECK: lochhile %r11, 32767   # encoding: [0xec,0xbc,0x7f,0xff,0x00,0x4e]
#CHECK: lochhinh %r11, 32767   # encoding: [0xec,0xbd,0x7f,0xff,0x00,0x4e]
#CHECK: lochhino %r11, 32512   # encoding: [0xec,0xbe,0x7f,0x00,0x00,0x4e]
#CHECK: lochhi %r11, 32512, 15 # encoding: [0xec,0xbf,0x7f,0x00,0x00,0x4e]

        lochhi  %r11, 42, 0
        lochhio %r11, 42
        lochhih %r11, 42
        lochhinle %r11, 42
        lochhil %r11, -1
        lochhinhe %r11, 42
        lochhilh %r11, -1
        lochhine %r11, 0
        lochhie %r11, 0
        lochhinlh %r11, 42
        lochhihe %r11, 255
        lochhinl %r11, 255
        lochhile %r11, 32767
        lochhinh %r11, 32767
        lochhino %r11, 32512
        lochhi %r11, 32512, 15

#CHECK: lochhim %r10, 2766   # encoding: [0xec,0xa4,0x0a,0xce,0x00,0x4e]
#CHECK: lochhinm %r11, 6862  # encoding: [0xec,0xbb,0x1a,0xce,0x00,0x4e]
#CHECK: lochhip %r12, 10958  # encoding: [0xec,0xc2,0x2a,0xce,0x00,0x4e]
#CHECK: lochhiz %r13, 15054  # encoding: [0xec,0xd8,0x3a,0xce,0x00,0x4e]
#CHECK: lochhinp %r14, 19150 # encoding: [0xec,0xed,0x4a,0xce,0x00,0x4e]
#CHECK: lochhinz %r15, 23246 # encoding: [0xec,0xf7,0x5a,0xce,0x00,0x4e]
        lochhim %r10, 2766
        lochhinm %r11, 6862
        lochhip %r12, 10958
        lochhiz %r13, 15054
        lochhinp %r14, 19150
        lochhinz %r15, 23246

#CHECK: locfh   %r0, 0, 0               # encoding: [0xeb,0x00,0x00,0x00,0x00,0xe0]
#CHECK: locfh   %r0, 0, 15              # encoding: [0xeb,0x0f,0x00,0x00,0x00,0xe0]
#CHECK: locfh   %r0, -524288, 0         # encoding: [0xeb,0x00,0x00,0x00,0x80,0xe0]
#CHECK: locfh   %r0, 524287, 0          # encoding: [0xeb,0x00,0x0f,0xff,0x7f,0xe0]
#CHECK: locfh   %r0, 0(%r1), 0          # encoding: [0xeb,0x00,0x10,0x00,0x00,0xe0]
#CHECK: locfh   %r0, 0(%r15), 0         # encoding: [0xeb,0x00,0xf0,0x00,0x00,0xe0]
#CHECK: locfh   %r15, 0, 0              # encoding: [0xeb,0xf0,0x00,0x00,0x00,0xe0]
#CHECK: locfh   %r1, 4095(%r2), 3       # encoding: [0xeb,0x13,0x2f,0xff,0x00,0xe0]

	locfh	%r0, 0, 0
	locfh	%r0, 0, 15
	locfh	%r0, -524288, 0
	locfh	%r0, 524287, 0
	locfh	%r0, 0(%r1), 0
	locfh	%r0, 0(%r15), 0
	locfh	%r15, 0, 0
	locfh	%r1, 4095(%r2), 3

#CHECK: locfho   %r1, 2(%r3)            # encoding: [0xeb,0x11,0x30,0x02,0x00,0xe0]
#CHECK: locfhh   %r1, 2(%r3)            # encoding: [0xeb,0x12,0x30,0x02,0x00,0xe0]
#CHECK: locfhp   %r1, 2(%r3)            # encoding: [0xeb,0x12,0x30,0x02,0x00,0xe0]
#CHECK: locfhnle %r1, 2(%r3)            # encoding: [0xeb,0x13,0x30,0x02,0x00,0xe0]
#CHECK: locfhl   %r1, 2(%r3)            # encoding: [0xeb,0x14,0x30,0x02,0x00,0xe0]
#CHECK: locfhm   %r1, 2(%r3)            # encoding: [0xeb,0x14,0x30,0x02,0x00,0xe0]
#CHECK: locfhnhe %r1, 2(%r3)            # encoding: [0xeb,0x15,0x30,0x02,0x00,0xe0]
#CHECK: locfhlh  %r1, 2(%r3)            # encoding: [0xeb,0x16,0x30,0x02,0x00,0xe0]
#CHECK: locfhne  %r1, 2(%r3)            # encoding: [0xeb,0x17,0x30,0x02,0x00,0xe0]
#CHECK: locfhnz  %r1, 2(%r3)            # encoding: [0xeb,0x17,0x30,0x02,0x00,0xe0]
#CHECK: locfhe   %r1, 2(%r3)            # encoding: [0xeb,0x18,0x30,0x02,0x00,0xe0]
#CHECK: locfhz   %r1, 2(%r3)            # encoding: [0xeb,0x18,0x30,0x02,0x00,0xe0]
#CHECK: locfhnlh %r1, 2(%r3)            # encoding: [0xeb,0x19,0x30,0x02,0x00,0xe0]
#CHECK: locfhhe  %r1, 2(%r3)            # encoding: [0xeb,0x1a,0x30,0x02,0x00,0xe0]
#CHECK: locfhnl  %r1, 2(%r3)            # encoding: [0xeb,0x1b,0x30,0x02,0x00,0xe0]
#CHECK: locfhnm  %r1, 2(%r3)            # encoding: [0xeb,0x1b,0x30,0x02,0x00,0xe0]
#CHECK: locfhle  %r1, 2(%r3)            # encoding: [0xeb,0x1c,0x30,0x02,0x00,0xe0]
#CHECK: locfhnh  %r1, 2(%r3)            # encoding: [0xeb,0x1d,0x30,0x02,0x00,0xe0]
#CHECK: locfhnp  %r1, 2(%r3)            # encoding: [0xeb,0x1d,0x30,0x02,0x00,0xe0]
#CHECK: locfhno  %r1, 2(%r3)            # encoding: [0xeb,0x1e,0x30,0x02,0x00,0xe0]

	locfho   %r1, 2(%r3)
	locfhh   %r1, 2(%r3)
	locfhp   %r1, 2(%r3)
	locfhnle %r1, 2(%r3)
	locfhl   %r1, 2(%r3)
	locfhm   %r1, 2(%r3)
	locfhnhe %r1, 2(%r3)
	locfhlh  %r1, 2(%r3)
	locfhne  %r1, 2(%r3)
	locfhnz  %r1, 2(%r3)
	locfhe   %r1, 2(%r3)
	locfhz   %r1, 2(%r3)
	locfhnlh %r1, 2(%r3)
	locfhhe  %r1, 2(%r3)
	locfhnl  %r1, 2(%r3)
	locfhnm  %r1, 2(%r3)
	locfhle  %r1, 2(%r3)
	locfhnh  %r1, 2(%r3)
	locfhnp  %r1, 2(%r3)
	locfhno  %r1, 2(%r3)

#CHECK: locfhr  %r1, %r2, 0             # encoding: [0xb9,0xe0,0x00,0x12]
#CHECK: locfhr  %r1, %r2, 15            # encoding: [0xb9,0xe0,0xf0,0x12]

	locfhr	%r1, %r2, 0
	locfhr	%r1, %r2, 15

#CHECK: locfhro   %r1, %r3              # encoding: [0xb9,0xe0,0x10,0x13]
#CHECK: locfhrh   %r1, %r3              # encoding: [0xb9,0xe0,0x20,0x13]
#CHECK: locfhrp   %r1, %r3              # encoding: [0xb9,0xe0,0x20,0x13]
#CHECK: locfhrnle %r1, %r3              # encoding: [0xb9,0xe0,0x30,0x13]
#CHECK: locfhrl   %r1, %r3              # encoding: [0xb9,0xe0,0x40,0x13]
#CHECK: locfhrm   %r1, %r3              # encoding: [0xb9,0xe0,0x40,0x13]
#CHECK: locfhrnhe %r1, %r3              # encoding: [0xb9,0xe0,0x50,0x13]
#CHECK: locfhrlh  %r1, %r3              # encoding: [0xb9,0xe0,0x60,0x13]
#CHECK: locfhrne  %r1, %r3              # encoding: [0xb9,0xe0,0x70,0x13]
#CHECK: locfhrnz  %r1, %r3              # encoding: [0xb9,0xe0,0x70,0x13]
#CHECK: locfhre   %r1, %r3              # encoding: [0xb9,0xe0,0x80,0x13]
#CHECK: locfhrz   %r1, %r3              # encoding: [0xb9,0xe0,0x80,0x13]
#CHECK: locfhrnlh %r1, %r3              # encoding: [0xb9,0xe0,0x90,0x13]
#CHECK: locfhrhe  %r1, %r3              # encoding: [0xb9,0xe0,0xa0,0x13]
#CHECK: locfhrnl  %r1, %r3              # encoding: [0xb9,0xe0,0xb0,0x13]
#CHECK: locfhrnm  %r1, %r3              # encoding: [0xb9,0xe0,0xb0,0x13]
#CHECK: locfhrle  %r1, %r3              # encoding: [0xb9,0xe0,0xc0,0x13]
#CHECK: locfhrnh  %r1, %r3              # encoding: [0xb9,0xe0,0xd0,0x13]
#CHECK: locfhrnp  %r1, %r3              # encoding: [0xb9,0xe0,0xd0,0x13]
#CHECK: locfhrno  %r1, %r3              # encoding: [0xb9,0xe0,0xe0,0x13]

	locfhro   %r1, %r3
	locfhrh   %r1, %r3
	locfhrp   %r1, %r3
	locfhrnle %r1, %r3
	locfhrl   %r1, %r3
	locfhrm   %r1, %r3
	locfhrnhe %r1, %r3
	locfhrlh  %r1, %r3
	locfhrne  %r1, %r3
	locfhrnz  %r1, %r3
	locfhre   %r1, %r3
	locfhrz   %r1, %r3
	locfhrnlh %r1, %r3
	locfhrhe  %r1, %r3
	locfhrnl  %r1, %r3
	locfhrnm  %r1, %r3
	locfhrle  %r1, %r3
	locfhrnh  %r1, %r3
	locfhrnp  %r1, %r3
	locfhrno  %r1, %r3

#CHECK: lzrf    %r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x3b]
#CHECK: lzrf    %r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x3b]
#CHECK: lzrf    %r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x3b]
#CHECK: lzrf    %r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x3b]
#CHECK: lzrf    %r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x3b]
#CHECK: lzrf    %r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x3b]
#CHECK: lzrf    %r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x3b]
#CHECK: lzrf    %r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x3b]
#CHECK: lzrf    %r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x3b]
#CHECK: lzrf    %r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x3b]

	lzrf	%r0, -524288
	lzrf	%r0, -1
	lzrf	%r0, 0
	lzrf	%r0, 1
	lzrf	%r0, 524287
	lzrf	%r0, 0(%r1)
	lzrf	%r0, 0(%r15)
	lzrf	%r0, 524287(%r1,%r15)
	lzrf	%r0, 524287(%r15,%r1)
	lzrf	%r15, 0

#CHECK: lzrg    %r0, -524288            # encoding: [0xe3,0x00,0x00,0x00,0x80,0x2a]
#CHECK: lzrg    %r0, -1                 # encoding: [0xe3,0x00,0x0f,0xff,0xff,0x2a]
#CHECK: lzrg    %r0, 0                  # encoding: [0xe3,0x00,0x00,0x00,0x00,0x2a]
#CHECK: lzrg    %r0, 1                  # encoding: [0xe3,0x00,0x00,0x01,0x00,0x2a]
#CHECK: lzrg    %r0, 524287             # encoding: [0xe3,0x00,0x0f,0xff,0x7f,0x2a]
#CHECK: lzrg    %r0, 0(%r1)             # encoding: [0xe3,0x00,0x10,0x00,0x00,0x2a]
#CHECK: lzrg    %r0, 0(%r15)            # encoding: [0xe3,0x00,0xf0,0x00,0x00,0x2a]
#CHECK: lzrg    %r0, 524287(%r1,%r15)   # encoding: [0xe3,0x01,0xff,0xff,0x7f,0x2a]
#CHECK: lzrg    %r0, 524287(%r15,%r1)   # encoding: [0xe3,0x0f,0x1f,0xff,0x7f,0x2a]
#CHECK: lzrg    %r15, 0                 # encoding: [0xe3,0xf0,0x00,0x00,0x00,0x2a]

	lzrg	%r0, -524288
	lzrg	%r0, -1
	lzrg	%r0, 0
	lzrg	%r0, 1
	lzrg	%r0, 524287
	lzrg	%r0, 0(%r1)
	lzrg	%r0, 0(%r15)
	lzrg	%r0, 524287(%r1,%r15)
	lzrg	%r0, 524287(%r15,%r1)
	lzrg	%r15, 0

#CHECK: stocfh  %r0, 0, 0               # encoding: [0xeb,0x00,0x00,0x00,0x00,0xe1]
#CHECK: stocfh  %r0, 0, 15              # encoding: [0xeb,0x0f,0x00,0x00,0x00,0xe1]
#CHECK: stocfh  %r0, -524288, 0         # encoding: [0xeb,0x00,0x00,0x00,0x80,0xe1]
#CHECK: stocfh  %r0, 524287, 0          # encoding: [0xeb,0x00,0x0f,0xff,0x7f,0xe1]
#CHECK: stocfh  %r0, 0(%r1), 0          # encoding: [0xeb,0x00,0x10,0x00,0x00,0xe1]
#CHECK: stocfh  %r0, 0(%r15), 0         # encoding: [0xeb,0x00,0xf0,0x00,0x00,0xe1]
#CHECK: stocfh  %r15, 0, 0              # encoding: [0xeb,0xf0,0x00,0x00,0x00,0xe1]
#CHECK: stocfh  %r1, 4095(%r2), 3       # encoding: [0xeb,0x13,0x2f,0xff,0x00,0xe1]

	stocfh	%r0, 0, 0
	stocfh	%r0, 0, 15
	stocfh	%r0, -524288, 0
	stocfh	%r0, 524287, 0
	stocfh	%r0, 0(%r1), 0
	stocfh	%r0, 0(%r15), 0
	stocfh	%r15, 0, 0
	stocfh	%r1, 4095(%r2), 3

#CHECK: stocfho   %r1, 2(%r3)           # encoding: [0xeb,0x11,0x30,0x02,0x00,0xe1]
#CHECK: stocfhh   %r1, 2(%r3)           # encoding: [0xeb,0x12,0x30,0x02,0x00,0xe1]
#CHECK: stocfhp   %r1, 2(%r3)           # encoding: [0xeb,0x12,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnle %r1, 2(%r3)           # encoding: [0xeb,0x13,0x30,0x02,0x00,0xe1]
#CHECK: stocfhl   %r1, 2(%r3)           # encoding: [0xeb,0x14,0x30,0x02,0x00,0xe1]
#CHECK: stocfhm   %r1, 2(%r3)           # encoding: [0xeb,0x14,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnhe %r1, 2(%r3)           # encoding: [0xeb,0x15,0x30,0x02,0x00,0xe1]
#CHECK: stocfhlh  %r1, 2(%r3)           # encoding: [0xeb,0x16,0x30,0x02,0x00,0xe1]
#CHECK: stocfhne  %r1, 2(%r3)           # encoding: [0xeb,0x17,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnz  %r1, 2(%r3)           # encoding: [0xeb,0x17,0x30,0x02,0x00,0xe1]
#CHECK: stocfhe   %r1, 2(%r3)           # encoding: [0xeb,0x18,0x30,0x02,0x00,0xe1]
#CHECK: stocfhz   %r1, 2(%r3)           # encoding: [0xeb,0x18,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnlh %r1, 2(%r3)           # encoding: [0xeb,0x19,0x30,0x02,0x00,0xe1]
#CHECK: stocfhhe  %r1, 2(%r3)           # encoding: [0xeb,0x1a,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnl  %r1, 2(%r3)           # encoding: [0xeb,0x1b,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnm  %r1, 2(%r3)           # encoding: [0xeb,0x1b,0x30,0x02,0x00,0xe1]
#CHECK: stocfhle  %r1, 2(%r3)           # encoding: [0xeb,0x1c,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnh  %r1, 2(%r3)           # encoding: [0xeb,0x1d,0x30,0x02,0x00,0xe1]
#CHECK: stocfhnp  %r1, 2(%r3)           # encoding: [0xeb,0x1d,0x30,0x02,0x00,0xe1]
#CHECK: stocfhno  %r1, 2(%r3)           # encoding: [0xeb,0x1e,0x30,0x02,0x00,0xe1]

	stocfho   %r1, 2(%r3)
	stocfhh   %r1, 2(%r3)
	stocfhp   %r1, 2(%r3)
	stocfhnle %r1, 2(%r3)
	stocfhl   %r1, 2(%r3)
	stocfhm   %r1, 2(%r3)
	stocfhnhe %r1, 2(%r3)
	stocfhlh  %r1, 2(%r3)
	stocfhne  %r1, 2(%r3)
	stocfhnz  %r1, 2(%r3)
	stocfhe   %r1, 2(%r3)
	stocfhz   %r1, 2(%r3)
	stocfhnlh %r1, 2(%r3)
	stocfhhe  %r1, 2(%r3)
	stocfhnl  %r1, 2(%r3)
	stocfhnm  %r1, 2(%r3)
	stocfhle  %r1, 2(%r3)
	stocfhnh  %r1, 2(%r3)
	stocfhnp  %r1, 2(%r3)
	stocfhno  %r1, 2(%r3)

#CHECK: ppno	%r2, %r2                # encoding: [0xb9,0x3c,0x00,0x22]
#CHECK: ppno	%r2, %r14               # encoding: [0xb9,0x3c,0x00,0x2e]
#CHECK: ppno	%r14, %r2               # encoding: [0xb9,0x3c,0x00,0xe2]
#CHECK: ppno	%r6, %r10               # encoding: [0xb9,0x3c,0x00,0x6a]

	ppno	%r2, %r2
	ppno	%r2, %r14
	ppno	%r14, %r2
	ppno	%r6, %r10

#CHECK: va      %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf3]
#CHECK: va      %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf3]
#CHECK: va      %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf3]
#CHECK: va      %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf3]
#CHECK: va      %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf3]
#CHECK: va      %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xf3]

	va	%v0, %v0, %v0, 0
	va	%v0, %v0, %v0, 15
	va	%v0, %v0, %v31, 0
	va	%v0, %v31, %v0, 0
	va	%v31, %v0, %v0, 0
	va	%v18, %v3, %v20, 11

#CHECK: vab     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf3]
#CHECK: vab     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf3]
#CHECK: vab     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf3]
#CHECK: vab     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf3]
#CHECK: vab     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf3]

	vab	%v0, %v0, %v0
	vab	%v0, %v0, %v31
	vab	%v0, %v31, %v0
	vab	%v31, %v0, %v0
	vab	%v18, %v3, %v20

#CHECK: vac     %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xbb]
#CHECK: vac     %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xbb]
#CHECK: vac     %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xbb]
#CHECK: vac     %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xbb]
#CHECK: vac     %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xbb]
#CHECK: vac     %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xbb]
#CHECK: vac     %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xbb]

	vac	%v0, %v0, %v0, %v0, 0
	vac	%v0, %v0, %v0, %v0, 15
	vac	%v0, %v0, %v0, %v31, 0
	vac	%v0, %v0, %v31, %v0, 0
	vac	%v0, %v31, %v0, %v0, 0
	vac	%v31, %v0, %v0, %v0, 0
	vac	%v13, %v17, %v21, %v25, 11

#CHECK: vacc    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf1]
#CHECK: vacc    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf1]
#CHECK: vacc    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf1]
#CHECK: vacc    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf1]
#CHECK: vacc    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf1]
#CHECK: vacc    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xf1]

	vacc	%v0, %v0, %v0, 0
	vacc	%v0, %v0, %v0, 15
	vacc	%v0, %v0, %v31, 0
	vacc	%v0, %v31, %v0, 0
	vacc	%v31, %v0, %v0, 0
	vacc	%v18, %v3, %v20, 11

#CHECK: vaccb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf1]
#CHECK: vaccb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf1]
#CHECK: vaccb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf1]
#CHECK: vaccb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf1]
#CHECK: vaccb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf1]

	vaccb	%v0, %v0, %v0
	vaccb	%v0, %v0, %v31
	vaccb	%v0, %v31, %v0
	vaccb	%v31, %v0, %v0
	vaccb	%v18, %v3, %v20

#CHECK: vaccc   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb9]
#CHECK: vaccc   %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xb9]
#CHECK: vaccc   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xb9]
#CHECK: vaccc   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb9]
#CHECK: vaccc   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb9]
#CHECK: vaccc   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb9]
#CHECK: vaccc   %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xb9]

	vaccc	%v0, %v0, %v0, %v0, 0
	vaccc	%v0, %v0, %v0, %v0, 15
	vaccc	%v0, %v0, %v0, %v31, 0
	vaccc	%v0, %v0, %v31, %v0, 0
	vaccc	%v0, %v31, %v0, %v0, 0
	vaccc	%v31, %v0, %v0, %v0, 0
	vaccc	%v13, %v17, %v21, %v25, 11

#CHECK: vacccq  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0xb9]
#CHECK: vacccq  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0xb9]
#CHECK: vacccq  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0xb9]
#CHECK: vacccq  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0xb9]
#CHECK: vacccq  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0xb9]
#CHECK: vacccq  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0xb9]

	vacccq	%v0, %v0, %v0, %v0
	vacccq	%v0, %v0, %v0, %v31
	vacccq	%v0, %v0, %v31, %v0
	vacccq	%v0, %v31, %v0, %v0
	vacccq	%v31, %v0, %v0, %v0
	vacccq	%v13, %v17, %v21, %v25

#CHECK: vaccf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf1]
#CHECK: vaccf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf1]
#CHECK: vaccf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf1]
#CHECK: vaccf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf1]
#CHECK: vaccf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf1]

	vaccf	%v0, %v0, %v0
	vaccf	%v0, %v0, %v31
	vaccf	%v0, %v31, %v0
	vaccf	%v31, %v0, %v0
	vaccf	%v18, %v3, %v20

#CHECK: vaccg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf1]
#CHECK: vaccg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf1]
#CHECK: vaccg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf1]
#CHECK: vaccg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf1]
#CHECK: vaccg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf1]

	vaccg	%v0, %v0, %v0
	vaccg	%v0, %v0, %v31
	vaccg	%v0, %v31, %v0
	vaccg	%v31, %v0, %v0
	vaccg	%v18, %v3, %v20

#CHECK: vacch   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf1]
#CHECK: vacch   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf1]
#CHECK: vacch   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf1]
#CHECK: vacch   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf1]
#CHECK: vacch   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf1]

	vacch	%v0, %v0, %v0
	vacch	%v0, %v0, %v31
	vacch	%v0, %v31, %v0
	vacch	%v31, %v0, %v0
	vacch	%v18, %v3, %v20

#CHECK: vaccq   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf1]
#CHECK: vaccq   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf1]
#CHECK: vaccq   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf1]
#CHECK: vaccq   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf1]
#CHECK: vaccq   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf1]

	vaccq	%v0, %v0, %v0
	vaccq	%v0, %v0, %v31
	vaccq	%v0, %v31, %v0
	vaccq	%v31, %v0, %v0
	vaccq	%v18, %v3, %v20

#CHECK: vacq    %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0xbb]
#CHECK: vacq    %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0xbb]
#CHECK: vacq    %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0xbb]
#CHECK: vacq    %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0xbb]
#CHECK: vacq    %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0xbb]
#CHECK: vacq    %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0xbb]

	vacq	%v0, %v0, %v0, %v0
	vacq	%v0, %v0, %v0, %v31
	vacq	%v0, %v0, %v31, %v0
	vacq	%v0, %v31, %v0, %v0
	vacq	%v31, %v0, %v0, %v0
	vacq	%v13, %v17, %v21, %v25

#CHECK: vaf     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf3]
#CHECK: vaf     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf3]
#CHECK: vaf     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf3]
#CHECK: vaf     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf3]
#CHECK: vaf     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf3]

	vaf	%v0, %v0, %v0
	vaf	%v0, %v0, %v31
	vaf	%v0, %v31, %v0
	vaf	%v31, %v0, %v0
	vaf	%v18, %v3, %v20

#CHECK: vag     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf3]
#CHECK: vag     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf3]
#CHECK: vag     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf3]
#CHECK: vag     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf3]
#CHECK: vag     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf3]

	vag	%v0, %v0, %v0
	vag	%v0, %v0, %v31
	vag	%v0, %v31, %v0
	vag	%v31, %v0, %v0
	vag	%v18, %v3, %v20

#CHECK: vah     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf3]
#CHECK: vah     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf3]
#CHECK: vah     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf3]
#CHECK: vah     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf3]
#CHECK: vah     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf3]

	vah	%v0, %v0, %v0
	vah	%v0, %v0, %v31
	vah	%v0, %v31, %v0
	vah	%v31, %v0, %v0
	vah	%v18, %v3, %v20

#CHECK: vaq     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf3]
#CHECK: vaq     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf3]
#CHECK: vaq     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf3]
#CHECK: vaq     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf3]
#CHECK: vaq     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf3]

	vaq	%v0, %v0, %v0
	vaq	%v0, %v0, %v31
	vaq	%v0, %v31, %v0
	vaq	%v31, %v0, %v0
	vaq	%v18, %v3, %v20

#CHECK: vavg    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf2]
#CHECK: vavg    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf2]
#CHECK: vavg    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf2]
#CHECK: vavg    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf2]
#CHECK: vavg    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf2]
#CHECK: vavg    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xf2]

	vavg	%v0, %v0, %v0, 0
	vavg	%v0, %v0, %v0, 15
	vavg	%v0, %v0, %v31, 0
	vavg	%v0, %v31, %v0, 0
	vavg	%v31, %v0, %v0, 0
	vavg	%v18, %v3, %v20, 11

#CHECK: vavgb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf2]
#CHECK: vavgb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf2]
#CHECK: vavgb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf2]
#CHECK: vavgb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf2]
#CHECK: vavgb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf2]

	vavgb	%v0, %v0, %v0
	vavgb	%v0, %v0, %v31
	vavgb	%v0, %v31, %v0
	vavgb	%v31, %v0, %v0
	vavgb	%v18, %v3, %v20

#CHECK: vavgf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf2]
#CHECK: vavgf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf2]
#CHECK: vavgf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf2]
#CHECK: vavgf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf2]
#CHECK: vavgf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf2]

	vavgf	%v0, %v0, %v0
	vavgf	%v0, %v0, %v31
	vavgf	%v0, %v31, %v0
	vavgf	%v31, %v0, %v0
	vavgf	%v18, %v3, %v20

#CHECK: vavgg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf2]
#CHECK: vavgg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf2]
#CHECK: vavgg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf2]
#CHECK: vavgg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf2]
#CHECK: vavgg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf2]

	vavgg	%v0, %v0, %v0
	vavgg	%v0, %v0, %v31
	vavgg	%v0, %v31, %v0
	vavgg	%v31, %v0, %v0
	vavgg	%v18, %v3, %v20

#CHECK: vavgh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf2]
#CHECK: vavgh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf2]
#CHECK: vavgh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf2]
#CHECK: vavgh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf2]
#CHECK: vavgh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf2]

	vavgh	%v0, %v0, %v0
	vavgh	%v0, %v0, %v31
	vavgh	%v0, %v31, %v0
	vavgh	%v31, %v0, %v0
	vavgh	%v18, %v3, %v20

#CHECK: vavgl   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf0]
#CHECK: vavgl   %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf0]
#CHECK: vavgl   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf0]
#CHECK: vavgl   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf0]
#CHECK: vavgl   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf0]
#CHECK: vavgl   %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xf0]

	vavgl	%v0, %v0, %v0, 0
	vavgl	%v0, %v0, %v0, 15
	vavgl	%v0, %v0, %v31, 0
	vavgl	%v0, %v31, %v0, 0
	vavgl	%v31, %v0, %v0, 0
	vavgl	%v18, %v3, %v20, 11

#CHECK: vavglb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf0]
#CHECK: vavglb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf0]
#CHECK: vavglb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf0]
#CHECK: vavglb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf0]
#CHECK: vavglb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf0]

	vavglb	%v0, %v0, %v0
	vavglb	%v0, %v0, %v31
	vavglb	%v0, %v31, %v0
	vavglb	%v31, %v0, %v0
	vavglb	%v18, %v3, %v20

#CHECK: vavglf  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf0]
#CHECK: vavglf  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf0]
#CHECK: vavglf  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf0]
#CHECK: vavglf  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf0]
#CHECK: vavglf  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf0]

	vavglf	%v0, %v0, %v0
	vavglf	%v0, %v0, %v31
	vavglf	%v0, %v31, %v0
	vavglf	%v31, %v0, %v0
	vavglf	%v18, %v3, %v20

#CHECK: vavglg  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf0]
#CHECK: vavglg  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf0]
#CHECK: vavglg  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf0]
#CHECK: vavglg  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf0]
#CHECK: vavglg  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf0]

	vavglg	%v0, %v0, %v0
	vavglg	%v0, %v0, %v31
	vavglg	%v0, %v31, %v0
	vavglg	%v31, %v0, %v0
	vavglg	%v18, %v3, %v20

#CHECK: vavglh  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf0]
#CHECK: vavglh  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf0]
#CHECK: vavglh  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf0]
#CHECK: vavglh  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf0]
#CHECK: vavglh  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf0]

	vavglh	%v0, %v0, %v0
	vavglh	%v0, %v0, %v31
	vavglh	%v0, %v31, %v0
	vavglh	%v31, %v0, %v0
	vavglh	%v18, %v3, %v20

#CHECK: vcdg    %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc3]
#CHECK: vcdg    %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc3]
#CHECK: vcdg    %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc3]
#CHECK: vcdg    %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc3]
#CHECK: vcdg    %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc3]
#CHECK: vcdg    %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc3]
#CHECK: vcdg    %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc3]
#CHECK: vcdg    %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc3]

	vcdg	%v0, %v0, 0, 0, 0
	vcdg	%v0, %v0, 15, 0, 0
	vcdg	%v0, %v0, 0, 0, 15
	vcdg	%v0, %v0, 0, 4, 0
	vcdg	%v0, %v0, 0, 12, 0
	vcdg	%v0, %v31, 0, 0, 0
	vcdg	%v31, %v0, 0, 0, 0
	vcdg	%v14, %v17, 11, 4, 10

#CHECK: vcdgb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x30,0xc3]
#CHECK: vcdgb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xc3]
#CHECK: vcdgb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x30,0xc3]
#CHECK: vcdgb   %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc3]
#CHECK: vcdgb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xc3]
#CHECK: vcdgb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xc3]
#CHECK: vcdgb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x34,0xc3]

	vcdgb	%v0, %v0, 0, 0
	vcdgb	%v0, %v0, 0, 15
	vcdgb	%v0, %v0, 4, 0
	vcdgb	%v0, %v0, 12, 0
	vcdgb	%v0, %v31, 0, 0
	vcdgb	%v31, %v0, 0, 0
	vcdgb	%v14, %v17, 4, 10

#CHECK: vcdlg   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc1]
#CHECK: vcdlg   %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc1]
#CHECK: vcdlg   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc1]
#CHECK: vcdlg   %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc1]
#CHECK: vcdlg   %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc1]
#CHECK: vcdlg   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc1]
#CHECK: vcdlg   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc1]
#CHECK: vcdlg   %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc1]

	vcdlg	%v0, %v0, 0, 0, 0
	vcdlg	%v0, %v0, 15, 0, 0
	vcdlg	%v0, %v0, 0, 0, 15
	vcdlg	%v0, %v0, 0, 4, 0
	vcdlg	%v0, %v0, 0, 12, 0
	vcdlg	%v0, %v31, 0, 0, 0
	vcdlg	%v31, %v0, 0, 0, 0
	vcdlg	%v14, %v17, 11, 4, 10

#CHECK: vcdlgb  %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x30,0xc1]
#CHECK: vcdlgb  %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xc1]
#CHECK: vcdlgb  %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x30,0xc1]
#CHECK: vcdlgb  %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc1]
#CHECK: vcdlgb  %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xc1]
#CHECK: vcdlgb  %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xc1]
#CHECK: vcdlgb  %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x34,0xc1]

	vcdlgb	%v0, %v0, 0, 0
	vcdlgb	%v0, %v0, 0, 15
	vcdlgb	%v0, %v0, 4, 0
	vcdlgb	%v0, %v0, 12, 0
	vcdlgb	%v0, %v31, 0, 0
	vcdlgb	%v31, %v0, 0, 0
	vcdlgb	%v14, %v17, 4, 10

#CHECK: vceq    %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf8]
#CHECK: vceq    %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf8]
#CHECK: vceq    %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xf8]
#CHECK: vceq    %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf8]
#CHECK: vceq    %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf8]
#CHECK: vceq    %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf8]
#CHECK: vceq    %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x90,0xba,0xf8]

	vceq	%v0, %v0, %v0, 0, 0
	vceq	%v0, %v0, %v0, 15, 0
	vceq	%v0, %v0, %v0, 0, 15
	vceq	%v0, %v0, %v31, 0, 0
	vceq	%v0, %v31, %v0, 0, 0
	vceq	%v31, %v0, %v0, 0, 0
	vceq	%v18, %v3, %v20, 11, 9

#CHECK: vceqb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf8]
#CHECK: vceqb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf8]
#CHECK: vceqb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf8]
#CHECK: vceqb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf8]
#CHECK: vceqb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf8]
#CHECK: vceqbs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x04,0xf8]

	vceqb	%v0, %v0, %v0
	vceqb	%v0, %v0, %v31
	vceqb	%v0, %v31, %v0
	vceqb	%v31, %v0, %v0
	vceqb	%v18, %v3, %v20
	vceqbs	%v5, %v22, %v7

#CHECK: vceqf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf8]
#CHECK: vceqf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf8]
#CHECK: vceqf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf8]
#CHECK: vceqf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf8]
#CHECK: vceqf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf8]
#CHECK: vceqfs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x24,0xf8]

	vceqf	%v0, %v0, %v0
	vceqf	%v0, %v0, %v31
	vceqf	%v0, %v31, %v0
	vceqf	%v31, %v0, %v0
	vceqf	%v18, %v3, %v20
	vceqfs	%v5, %v22, %v7

#CHECK: vceqg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf8]
#CHECK: vceqg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf8]
#CHECK: vceqg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf8]
#CHECK: vceqg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf8]
#CHECK: vceqg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf8]
#CHECK: vceqgs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x34,0xf8]

	vceqg	%v0, %v0, %v0
	vceqg	%v0, %v0, %v31
	vceqg	%v0, %v31, %v0
	vceqg	%v31, %v0, %v0
	vceqg	%v18, %v3, %v20
	vceqgs	%v5, %v22, %v7

#CHECK: vceqh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf8]
#CHECK: vceqh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf8]
#CHECK: vceqh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf8]
#CHECK: vceqh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf8]
#CHECK: vceqh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf8]
#CHECK: vceqhs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x14,0xf8]

	vceqh	%v0, %v0, %v0
	vceqh	%v0, %v0, %v31
	vceqh	%v0, %v31, %v0
	vceqh	%v31, %v0, %v0
	vceqh	%v18, %v3, %v20
	vceqhs	%v5, %v22, %v7

#CHECK: vcgd    %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc2]
#CHECK: vcgd    %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc2]
#CHECK: vcgd    %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc2]
#CHECK: vcgd    %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc2]
#CHECK: vcgd    %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc2]
#CHECK: vcgd    %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc2]
#CHECK: vcgd    %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc2]
#CHECK: vcgd    %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc2]

	vcgd	%v0, %v0, 0, 0, 0
	vcgd	%v0, %v0, 15, 0, 0
	vcgd	%v0, %v0, 0, 0, 15
	vcgd	%v0, %v0, 0, 4, 0
	vcgd	%v0, %v0, 0, 12, 0
	vcgd	%v0, %v31, 0, 0, 0
	vcgd	%v31, %v0, 0, 0, 0
	vcgd	%v14, %v17, 11, 4, 10

#CHECK: vcgdb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x30,0xc2]
#CHECK: vcgdb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xc2]
#CHECK: vcgdb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x30,0xc2]
#CHECK: vcgdb   %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc2]
#CHECK: vcgdb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xc2]
#CHECK: vcgdb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xc2]
#CHECK: vcgdb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x34,0xc2]

	vcgdb	%v0, %v0, 0, 0
	vcgdb	%v0, %v0, 0, 15
	vcgdb	%v0, %v0, 4, 0
	vcgdb	%v0, %v0, 12, 0
	vcgdb	%v0, %v31, 0, 0
	vcgdb	%v31, %v0, 0, 0
	vcgdb	%v14, %v17, 4, 10

#CHECK: vch     %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfb]
#CHECK: vch     %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xfb]
#CHECK: vch     %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xfb]
#CHECK: vch     %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfb]
#CHECK: vch     %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfb]
#CHECK: vch     %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfb]
#CHECK: vch     %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x90,0xba,0xfb]

	vch	%v0, %v0, %v0, 0, 0
	vch	%v0, %v0, %v0, 15, 0
	vch	%v0, %v0, %v0, 0, 15
	vch	%v0, %v0, %v31, 0, 0
	vch	%v0, %v31, %v0, 0, 0
	vch	%v31, %v0, %v0, 0, 0
	vch	%v18, %v3, %v20, 11, 9

#CHECK: vchb    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfb]
#CHECK: vchb    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfb]
#CHECK: vchb    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfb]
#CHECK: vchb    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfb]
#CHECK: vchb    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xfb]
#CHECK: vchbs   %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x04,0xfb]

	vchb	%v0, %v0, %v0
	vchb	%v0, %v0, %v31
	vchb	%v0, %v31, %v0
	vchb	%v31, %v0, %v0
	vchb	%v18, %v3, %v20
	vchbs	%v5, %v22, %v7

#CHECK: vchf    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xfb]
#CHECK: vchf    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xfb]
#CHECK: vchf    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xfb]
#CHECK: vchf    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xfb]
#CHECK: vchf    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xfb]
#CHECK: vchfs   %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x24,0xfb]

	vchf	%v0, %v0, %v0
	vchf	%v0, %v0, %v31
	vchf	%v0, %v31, %v0
	vchf	%v31, %v0, %v0
	vchf	%v18, %v3, %v20
	vchfs	%v5, %v22, %v7

#CHECK: vchg    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xfb]
#CHECK: vchg    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xfb]
#CHECK: vchg    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xfb]
#CHECK: vchg    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xfb]
#CHECK: vchg    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xfb]
#CHECK: vchgs   %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x34,0xfb]

	vchg	%v0, %v0, %v0
	vchg	%v0, %v0, %v31
	vchg	%v0, %v31, %v0
	vchg	%v31, %v0, %v0
	vchg	%v18, %v3, %v20
	vchgs	%v5, %v22, %v7

#CHECK: vchh    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xfb]
#CHECK: vchh    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xfb]
#CHECK: vchh    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xfb]
#CHECK: vchh    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xfb]
#CHECK: vchh    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xfb]
#CHECK: vchhs   %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x14,0xfb]

	vchh	%v0, %v0, %v0
	vchh	%v0, %v0, %v31
	vchh	%v0, %v31, %v0
	vchh	%v31, %v0, %v0
	vchh	%v18, %v3, %v20
	vchhs	%v5, %v22, %v7

#CHECK: vchl    %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf9]
#CHECK: vchl    %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf9]
#CHECK: vchl    %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xf9]
#CHECK: vchl    %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf9]
#CHECK: vchl    %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf9]
#CHECK: vchl    %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf9]
#CHECK: vchl    %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x90,0xba,0xf9]

	vchl	%v0, %v0, %v0, 0, 0
	vchl	%v0, %v0, %v0, 15, 0
	vchl	%v0, %v0, %v0, 0, 15
	vchl	%v0, %v0, %v31, 0, 0
	vchl	%v0, %v31, %v0, 0, 0
	vchl	%v31, %v0, %v0, 0, 0
	vchl	%v18, %v3, %v20, 11, 9

#CHECK: vchlb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf9]
#CHECK: vchlb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf9]
#CHECK: vchlb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf9]
#CHECK: vchlb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf9]
#CHECK: vchlb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf9]
#CHECK: vchlbs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x04,0xf9]

	vchlb	%v0, %v0, %v0
	vchlb	%v0, %v0, %v31
	vchlb	%v0, %v31, %v0
	vchlb	%v31, %v0, %v0
	vchlb	%v18, %v3, %v20
	vchlbs	%v5, %v22, %v7

#CHECK: vchlf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf9]
#CHECK: vchlf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf9]
#CHECK: vchlf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf9]
#CHECK: vchlf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf9]
#CHECK: vchlf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf9]
#CHECK: vchlfs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x24,0xf9]

	vchlf	%v0, %v0, %v0
	vchlf	%v0, %v0, %v31
	vchlf	%v0, %v31, %v0
	vchlf	%v31, %v0, %v0
	vchlf	%v18, %v3, %v20
	vchlfs	%v5, %v22, %v7

#CHECK: vchlg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf9]
#CHECK: vchlg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf9]
#CHECK: vchlg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf9]
#CHECK: vchlg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf9]
#CHECK: vchlg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf9]
#CHECK: vchlgs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x34,0xf9]

	vchlg	%v0, %v0, %v0
	vchlg	%v0, %v0, %v31
	vchlg	%v0, %v31, %v0
	vchlg	%v31, %v0, %v0
	vchlg	%v18, %v3, %v20
	vchlgs	%v5, %v22, %v7

#CHECK: vchlh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf9]
#CHECK: vchlh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf9]
#CHECK: vchlh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf9]
#CHECK: vchlh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf9]
#CHECK: vchlh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf9]
#CHECK: vchlhs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x14,0xf9]

	vchlh	%v0, %v0, %v0
	vchlh	%v0, %v0, %v31
	vchlh	%v0, %v31, %v0
	vchlh	%v31, %v0, %v0
	vchlh	%v18, %v3, %v20
	vchlhs	%v5, %v22, %v7

#CHECK: vcksm   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x66]
#CHECK: vcksm   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x66]
#CHECK: vcksm   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x66]
#CHECK: vcksm   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x66]
#CHECK: vcksm   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x66]

	vcksm	%v0, %v0, %v0
	vcksm	%v0, %v0, %v31
	vcksm	%v0, %v31, %v0
	vcksm	%v31, %v0, %v0
	vcksm	%v18, %v3, %v20

#CHECK: vclgd   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc0]
#CHECK: vclgd   %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc0]
#CHECK: vclgd   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc0]
#CHECK: vclgd   %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc0]
#CHECK: vclgd   %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc0]
#CHECK: vclgd   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc0]
#CHECK: vclgd   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc0]
#CHECK: vclgd   %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc0]

	vclgd	%v0, %v0, 0, 0, 0
	vclgd	%v0, %v0, 15, 0, 0
	vclgd	%v0, %v0, 0, 0, 15
	vclgd	%v0, %v0, 0, 4, 0
	vclgd	%v0, %v0, 0, 12, 0
	vclgd	%v0, %v31, 0, 0, 0
	vclgd	%v31, %v0, 0, 0, 0
	vclgd	%v14, %v17, 11, 4, 10

#CHECK: vclgdb  %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x30,0xc0]
#CHECK: vclgdb  %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xc0]
#CHECK: vclgdb  %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x30,0xc0]
#CHECK: vclgdb  %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc0]
#CHECK: vclgdb  %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xc0]
#CHECK: vclgdb  %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xc0]
#CHECK: vclgdb  %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x34,0xc0]

	vclgdb	%v0, %v0, 0, 0
	vclgdb	%v0, %v0, 0, 15
	vclgdb	%v0, %v0, 4, 0
	vclgdb	%v0, %v0, 12, 0
	vclgdb	%v0, %v31, 0, 0
	vclgdb	%v31, %v0, 0, 0
	vclgdb	%v14, %v17, 4, 10

#CHECK: vclz    %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x53]
#CHECK: vclz    %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x53]
#CHECK: vclz    %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x53]
#CHECK: vclz    %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x53]
#CHECK: vclz    %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x53]
#CHECK: vclz    %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x53]
#CHECK: vclz    %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0x53]

	vclz	%v0, %v0, 0
	vclz	%v0, %v0, 15
	vclz	%v0, %v15, 0
	vclz	%v0, %v31, 0
	vclz	%v15, %v0, 0
	vclz	%v31, %v0, 0
	vclz	%v14, %v17, 11

#CHECK: vclzb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0x53]
#CHECK: vclzb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x53]
#CHECK: vclzb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x53]
#CHECK: vclzb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x53]
#CHECK: vclzb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x53]
#CHECK: vclzb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0x53]

	vclzb	%v0, %v0
	vclzb	%v0, %v15
	vclzb	%v0, %v31
	vclzb	%v15, %v0
	vclzb	%v31, %v0
	vclzb	%v14, %v17

#CHECK: vclzf   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0x53]
#CHECK: vclzf   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x53]
#CHECK: vclzf   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x53]
#CHECK: vclzf   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x53]
#CHECK: vclzf   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x53]
#CHECK: vclzf   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0x53]

	vclzf	%v0, %v0
	vclzf	%v0, %v15
	vclzf	%v0, %v31
	vclzf	%v15, %v0
	vclzf	%v31, %v0
	vclzf	%v14, %v17

#CHECK: vclzg   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0x53]
#CHECK: vclzg   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x53]
#CHECK: vclzg   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x53]
#CHECK: vclzg   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x53]
#CHECK: vclzg   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x53]
#CHECK: vclzg   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0x53]

	vclzg	%v0, %v0
	vclzg	%v0, %v15
	vclzg	%v0, %v31
	vclzg	%v15, %v0
	vclzg	%v31, %v0
	vclzg	%v14, %v17

#CHECK: vclzh   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0x53]
#CHECK: vclzh   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x53]
#CHECK: vclzh   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x53]
#CHECK: vclzh   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x53]
#CHECK: vclzh   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x53]
#CHECK: vclzh   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0x53]

	vclzh	%v0, %v0
	vclzh	%v0, %v15
	vclzh	%v0, %v31
	vclzh	%v15, %v0
	vclzh	%v31, %v0
	vclzh	%v14, %v17

#CHECK: vctz    %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x52]
#CHECK: vctz    %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x52]
#CHECK: vctz    %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x52]
#CHECK: vctz    %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x52]
#CHECK: vctz    %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x52]
#CHECK: vctz    %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x52]
#CHECK: vctz    %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0x52]

	vctz	%v0, %v0, 0
	vctz	%v0, %v0, 15
	vctz	%v0, %v15, 0
	vctz	%v0, %v31, 0
	vctz	%v15, %v0, 0
	vctz	%v31, %v0, 0
	vctz	%v14, %v17, 11

#CHECK: vctzb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0x52]
#CHECK: vctzb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x52]
#CHECK: vctzb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x52]
#CHECK: vctzb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x52]
#CHECK: vctzb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x52]
#CHECK: vctzb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0x52]

	vctzb	%v0, %v0
	vctzb	%v0, %v15
	vctzb	%v0, %v31
	vctzb	%v15, %v0
	vctzb	%v31, %v0
	vctzb	%v14, %v17

#CHECK: vctzf   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0x52]
#CHECK: vctzf   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x52]
#CHECK: vctzf   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x52]
#CHECK: vctzf   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x52]
#CHECK: vctzf   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x52]
#CHECK: vctzf   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0x52]

	vctzf	%v0, %v0
	vctzf	%v0, %v15
	vctzf	%v0, %v31
	vctzf	%v15, %v0
	vctzf	%v31, %v0
	vctzf	%v14, %v17

#CHECK: vctzg   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0x52]
#CHECK: vctzg   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x52]
#CHECK: vctzg   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x52]
#CHECK: vctzg   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x52]
#CHECK: vctzg   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x52]
#CHECK: vctzg   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0x52]

	vctzg	%v0, %v0
	vctzg	%v0, %v15
	vctzg	%v0, %v31
	vctzg	%v15, %v0
	vctzg	%v31, %v0
	vctzg	%v14, %v17

#CHECK: vctzh   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0x52]
#CHECK: vctzh   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x52]
#CHECK: vctzh   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x52]
#CHECK: vctzh   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x52]
#CHECK: vctzh   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x52]
#CHECK: vctzh   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0x52]

	vctzh	%v0, %v0
	vctzh	%v0, %v15
	vctzh	%v0, %v31
	vctzh	%v15, %v0
	vctzh	%v31, %v0
	vctzh	%v14, %v17

#CHECK: vec     %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xdb]
#CHECK: vec     %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xdb]
#CHECK: vec     %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xdb]
#CHECK: vec     %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xdb]
#CHECK: vec     %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xdb]
#CHECK: vec     %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xdb]
#CHECK: vec     %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xdb]

	vec	%v0, %v0, 0
	vec	%v0, %v0, 15
	vec	%v0, %v15, 0
	vec	%v0, %v31, 0
	vec	%v15, %v0, 0
	vec	%v31, %v0, 0
	vec	%v14, %v17, 11

#CHECK: vecb    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xdb]
#CHECK: vecb    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xdb]
#CHECK: vecb    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xdb]
#CHECK: vecb    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xdb]
#CHECK: vecb    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xdb]
#CHECK: vecb    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xdb]

	vecb	%v0, %v0
	vecb	%v0, %v15
	vecb	%v0, %v31
	vecb	%v15, %v0
	vecb	%v31, %v0
	vecb	%v14, %v17

#CHECK: vecf    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xdb]
#CHECK: vecf    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xdb]
#CHECK: vecf    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xdb]
#CHECK: vecf    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xdb]
#CHECK: vecf    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xdb]
#CHECK: vecf    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xdb]

	vecf	%v0, %v0
	vecf	%v0, %v15
	vecf	%v0, %v31
	vecf	%v15, %v0
	vecf	%v31, %v0
	vecf	%v14, %v17

#CHECK: vecg    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xdb]
#CHECK: vecg    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xdb]
#CHECK: vecg    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xdb]
#CHECK: vecg    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xdb]
#CHECK: vecg    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xdb]
#CHECK: vecg    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xdb]

	vecg	%v0, %v0
	vecg	%v0, %v15
	vecg	%v0, %v31
	vecg	%v15, %v0
	vecg	%v31, %v0
	vecg	%v14, %v17

#CHECK: vech    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xdb]
#CHECK: vech    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xdb]
#CHECK: vech    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xdb]
#CHECK: vech    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xdb]
#CHECK: vech    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xdb]
#CHECK: vech    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xdb]

	vech	%v0, %v0
	vech	%v0, %v15
	vech	%v0, %v31
	vech	%v15, %v0
	vech	%v31, %v0
	vech	%v14, %v17

#CHECK: vecl    %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd9]
#CHECK: vecl    %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xd9]
#CHECK: vecl    %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd9]
#CHECK: vecl    %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd9]
#CHECK: vecl    %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd9]
#CHECK: vecl    %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd9]
#CHECK: vecl    %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xd9]

	vecl	%v0, %v0, 0
	vecl	%v0, %v0, 15
	vecl	%v0, %v15, 0
	vecl	%v0, %v31, 0
	vecl	%v15, %v0, 0
	vecl	%v31, %v0, 0
	vecl	%v14, %v17, 11

#CHECK: veclb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd9]
#CHECK: veclb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd9]
#CHECK: veclb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd9]
#CHECK: veclb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd9]
#CHECK: veclb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd9]
#CHECK: veclb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xd9]

	veclb	%v0, %v0
	veclb	%v0, %v15
	veclb	%v0, %v31
	veclb	%v15, %v0
	veclb	%v31, %v0
	veclb	%v14, %v17

#CHECK: veclf   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xd9]
#CHECK: veclf   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xd9]
#CHECK: veclf   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xd9]
#CHECK: veclf   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xd9]
#CHECK: veclf   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xd9]
#CHECK: veclf   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xd9]

	veclf	%v0, %v0
	veclf	%v0, %v15
	veclf	%v0, %v31
	veclf	%v15, %v0
	veclf	%v31, %v0
	veclf	%v14, %v17

#CHECK: veclg   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xd9]
#CHECK: veclg   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xd9]
#CHECK: veclg   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xd9]
#CHECK: veclg   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xd9]
#CHECK: veclg   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xd9]
#CHECK: veclg   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xd9]

	veclg	%v0, %v0
	veclg	%v0, %v15
	veclg	%v0, %v31
	veclg	%v15, %v0
	veclg	%v31, %v0
	veclg	%v14, %v17

#CHECK: veclh   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xd9]
#CHECK: veclh   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xd9]
#CHECK: veclh   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xd9]
#CHECK: veclh   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xd9]
#CHECK: veclh   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xd9]
#CHECK: veclh   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xd9]

	veclh	%v0, %v0
	veclh	%v0, %v15
	veclh	%v0, %v31
	veclh	%v15, %v0
	veclh	%v31, %v0
	veclh	%v14, %v17

#CHECK: verim   %v0, %v0, %v0, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0x00,0x72]
#CHECK: verim   %v0, %v0, %v0, 0, 15   # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x72]
#CHECK: verim   %v0, %v0, %v0, 255, 0  # encoding: [0xe7,0x00,0x00,0xff,0x00,0x72]
#CHECK: verim   %v0, %v0, %v31, 0, 0   # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x72]
#CHECK: verim   %v0, %v31, %v0, 0, 0   # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x72]
#CHECK: verim   %v31, %v0, %v0, 0, 0   # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x72]
#CHECK: verim   %v13, %v17, %v21, 121, 11 # encoding: [0xe7,0xd1,0x50,0x79,0xb6,0x72]

	verim	%v0, %v0, %v0, 0, 0
	verim	%v0, %v0, %v0, 0, 15
	verim	%v0, %v0, %v0, 255, 0
	verim	%v0, %v0, %v31, 0, 0
	verim	%v0, %v31, %v0, 0, 0
	verim	%v31, %v0, %v0, 0, 0
	verim 	%v13, %v17, %v21, 0x79, 11

#CHECK: verimb  %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x72]
#CHECK: verimb  %v0, %v0, %v0, 255      # encoding: [0xe7,0x00,0x00,0xff,0x00,0x72]
#CHECK: verimb  %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x72]
#CHECK: verimb  %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x72]
#CHECK: verimb  %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x72]
#CHECK: verimb  %v13, %v17, %v21, 121   # encoding: [0xe7,0xd1,0x50,0x79,0x06,0x72]

	verimb	%v0, %v0, %v0, 0
	verimb	%v0, %v0, %v0, 255
	verimb	%v0, %v0, %v31, 0
	verimb	%v0, %v31, %v0, 0
	verimb	%v31, %v0, %v0, 0
	verimb 	%v13, %v17, %v21, 0x79

#CHECK: verimf  %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0x72]
#CHECK: verimf  %v0, %v0, %v0, 255      # encoding: [0xe7,0x00,0x00,0xff,0x20,0x72]
#CHECK: verimf  %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x72]
#CHECK: verimf  %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x72]
#CHECK: verimf  %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x72]
#CHECK: verimf  %v13, %v17, %v21, 121   # encoding: [0xe7,0xd1,0x50,0x79,0x26,0x72]

	verimf	%v0, %v0, %v0, 0
	verimf	%v0, %v0, %v0, 255
	verimf	%v0, %v0, %v31, 0
	verimf	%v0, %v31, %v0, 0
	verimf	%v31, %v0, %v0, 0
	verimf 	%v13, %v17, %v21, 0x79

#CHECK: verimg  %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x30,0x72]
#CHECK: verimg  %v0, %v0, %v0, 255      # encoding: [0xe7,0x00,0x00,0xff,0x30,0x72]
#CHECK: verimg  %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x72]
#CHECK: verimg  %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x72]
#CHECK: verimg  %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x72]
#CHECK: verimg  %v13, %v17, %v21, 121   # encoding: [0xe7,0xd1,0x50,0x79,0x36,0x72]

	verimg	%v0, %v0, %v0, 0
	verimg	%v0, %v0, %v0, 255
	verimg	%v0, %v0, %v31, 0
	verimg	%v0, %v31, %v0, 0
	verimg	%v31, %v0, %v0, 0
	verimg 	%v13, %v17, %v21, 0x79

#CHECK: verimh  %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x10,0x72]
#CHECK: verimh  %v0, %v0, %v0, 255      # encoding: [0xe7,0x00,0x00,0xff,0x10,0x72]
#CHECK: verimh  %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x72]
#CHECK: verimh  %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x72]
#CHECK: verimh  %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x72]
#CHECK: verimh  %v13, %v17, %v21, 121   # encoding: [0xe7,0xd1,0x50,0x79,0x16,0x72]

	verimh	%v0, %v0, %v0, 0
	verimh	%v0, %v0, %v0, 255
	verimh	%v0, %v0, %v31, 0
	verimh	%v0, %v31, %v0, 0
	verimh	%v31, %v0, %v0, 0
	verimh 	%v13, %v17, %v21, 0x79

#CHECK: verll   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0x33]
#CHECK: verll   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x33]
#CHECK: verll   %v0, %v0, 4095, 0       # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x33]
#CHECK: verll   %v0, %v0, 0(%r15), 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x33]
#CHECK: verll   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x33]
#CHECK: verll   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x33]
#CHECK: verll   %v14, %v17, 1074(%r5), 11  # encoding: [0xe7,0xe1,0x54,0x32,0xb4,0x33]

	verll	%v0, %v0, 0, 0
	verll	%v0, %v0, 0, 15
	verll	%v0, %v0, 4095, 0
	verll	%v0, %v0, 0(%r15), 0
	verll	%v0, %v31, 0, 0
	verll	%v31, %v0, 0, 0
	verll	%v14, %v17, 1074(%r5), 11

#CHECK: verllb  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x33]
#CHECK: verllb  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x33]
#CHECK: verllb  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x33]
#CHECK: verllb  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x33]
#CHECK: verllb  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x33]
#CHECK: verllb  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x04,0x33]

	verllb	%v0, %v0, 0
	verllb	%v0, %v0, 4095
	verllb	%v0, %v0, 0(%r15)
	verllb	%v0, %v31, 0
	verllb	%v31, %v0, 0
	verllb	%v14, %v17, 1074(%r5)

#CHECK: verllf  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x33]
#CHECK: verllf  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x33]
#CHECK: verllf  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x33]
#CHECK: verllf  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x33]
#CHECK: verllf  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x33]
#CHECK: verllf  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x24,0x33]

	verllf	%v0, %v0, 0
	verllf	%v0, %v0, 4095
	verllf	%v0, %v0, 0(%r15)
	verllf	%v0, %v31, 0
	verllf	%v31, %v0, 0
	verllf	%v14, %v17, 1074(%r5)

#CHECK: verllg  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x33]
#CHECK: verllg  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x33]
#CHECK: verllg  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x33]
#CHECK: verllg  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x33]
#CHECK: verllg  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x33]
#CHECK: verllg  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x34,0x33]

	verllg	%v0, %v0, 0
	verllg	%v0, %v0, 4095
	verllg	%v0, %v0, 0(%r15)
	verllg	%v0, %v31, 0
	verllg	%v31, %v0, 0
	verllg	%v14, %v17, 1074(%r5)

#CHECK: verllh  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x10,0x33]
#CHECK: verllh  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x33]
#CHECK: verllh  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x33]
#CHECK: verllh  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x33]
#CHECK: verllh  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x33]
#CHECK: verllh  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x14,0x33]

	verllh	%v0, %v0, 0
	verllh	%v0, %v0, 4095
	verllh	%v0, %v0, 0(%r15)
	verllh	%v0, %v31, 0
	verllh	%v31, %v0, 0
	verllh	%v14, %v17, 1074(%r5)

#CHECK: verllv  %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x73]
#CHECK: verllv  %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x73]
#CHECK: verllv  %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x73]
#CHECK: verllv  %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x73]
#CHECK: verllv  %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x73]
#CHECK: verllv  %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x73]

	verllv	%v0, %v0, %v0, 0
	verllv	%v0, %v0, %v0, 15
	verllv	%v0, %v0, %v31, 0
	verllv	%v0, %v31, %v0, 0
	verllv	%v31, %v0, %v0, 0
	verllv	%v18, %v3, %v20, 11

#CHECK: verllvb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x73]
#CHECK: verllvb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x73]
#CHECK: verllvb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x73]
#CHECK: verllvb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x73]
#CHECK: verllvb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x73]

	verllvb	%v0, %v0, %v0
	verllvb	%v0, %v0, %v31
	verllvb	%v0, %v31, %v0
	verllvb	%v31, %v0, %v0
	verllvb	%v18, %v3, %v20

#CHECK: verllvf %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x73]
#CHECK: verllvf %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x73]
#CHECK: verllvf %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x73]
#CHECK: verllvf %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x73]
#CHECK: verllvf %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x73]

	verllvf	%v0, %v0, %v0
	verllvf	%v0, %v0, %v31
	verllvf	%v0, %v31, %v0
	verllvf	%v31, %v0, %v0
	verllvf	%v18, %v3, %v20

#CHECK: verllvg %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x73]
#CHECK: verllvg %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x73]
#CHECK: verllvg %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x73]
#CHECK: verllvg %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x73]
#CHECK: verllvg %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x73]

	verllvg	%v0, %v0, %v0
	verllvg	%v0, %v0, %v31
	verllvg	%v0, %v31, %v0
	verllvg	%v31, %v0, %v0
	verllvg	%v18, %v3, %v20

#CHECK: verllvh %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x73]
#CHECK: verllvh %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x73]
#CHECK: verllvh %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x73]
#CHECK: verllvh %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x73]
#CHECK: verllvh %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x73]

	verllvh	%v0, %v0, %v0
	verllvh	%v0, %v0, %v31
	verllvh	%v0, %v31, %v0
	verllvh	%v31, %v0, %v0
	verllvh	%v18, %v3, %v20

#CHECK: vesl    %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0x30]
#CHECK: vesl    %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x30]
#CHECK: vesl    %v0, %v0, 4095, 0       # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x30]
#CHECK: vesl    %v0, %v0, 0(%r15), 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x30]
#CHECK: vesl    %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x30]
#CHECK: vesl    %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x30]
#CHECK: vesl    %v14, %v17, 1074(%r5), 11 # encoding: [0xe7,0xe1,0x54,0x32,0xb4,0x30]

	vesl	%v0, %v0, 0, 0
	vesl	%v0, %v0, 0, 15
	vesl	%v0, %v0, 4095, 0
	vesl	%v0, %v0, 0(%r15), 0
	vesl	%v0, %v31, 0, 0
	vesl	%v31, %v0, 0, 0
	vesl	%v14, %v17, 1074(%r5), 11

#CHECK: veslb   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x30]
#CHECK: veslb   %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x30]
#CHECK: veslb   %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x30]
#CHECK: veslb   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x30]
#CHECK: veslb   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x30]
#CHECK: veslb   %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x04,0x30]

	veslb	%v0, %v0, 0
	veslb	%v0, %v0, 4095
	veslb	%v0, %v0, 0(%r15)
	veslb	%v0, %v31, 0
	veslb	%v31, %v0, 0
	veslb	%v14, %v17, 1074(%r5)

#CHECK: veslf   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x30]
#CHECK: veslf   %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x30]
#CHECK: veslf   %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x30]
#CHECK: veslf   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x30]
#CHECK: veslf   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x30]
#CHECK: veslf   %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x24,0x30]

	veslf	%v0, %v0, 0
	veslf	%v0, %v0, 4095
	veslf	%v0, %v0, 0(%r15)
	veslf	%v0, %v31, 0
	veslf	%v31, %v0, 0
	veslf	%v14, %v17, 1074(%r5)

#CHECK: veslg   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x30]
#CHECK: veslg   %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x30]
#CHECK: veslg   %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x30]
#CHECK: veslg   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x30]
#CHECK: veslg   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x30]
#CHECK: veslg   %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x34,0x30]

	veslg	%v0, %v0, 0
	veslg	%v0, %v0, 4095
	veslg	%v0, %v0, 0(%r15)
	veslg	%v0, %v31, 0
	veslg	%v31, %v0, 0
	veslg	%v14, %v17, 1074(%r5)

#CHECK: veslh   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x10,0x30]
#CHECK: veslh   %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x30]
#CHECK: veslh   %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x30]
#CHECK: veslh   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x30]
#CHECK: veslh   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x30]
#CHECK: veslh   %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x14,0x30]

	veslh	%v0, %v0, 0
	veslh	%v0, %v0, 4095
	veslh	%v0, %v0, 0(%r15)
	veslh	%v0, %v31, 0
	veslh	%v31, %v0, 0
	veslh	%v14, %v17, 1074(%r5)

#CHECK: veslv   %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x70]
#CHECK: veslv   %v0, %v0, %v0, 15      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x70]
#CHECK: veslv   %v0, %v0, %v31, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x70]
#CHECK: veslv   %v0, %v31, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x70]
#CHECK: veslv   %v31, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x70]
#CHECK: veslv   %v18, %v3, %v20, 11    # encoding: [0xe7,0x23,0x40,0x00,0xba,0x70]

	veslv	%v0, %v0, %v0, 0
	veslv	%v0, %v0, %v0, 15
	veslv	%v0, %v0, %v31, 0
	veslv	%v0, %v31, %v0, 0
	veslv	%v31, %v0, %v0, 0
	veslv	%v18, %v3, %v20, 11

#CHECK: veslvb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x70]
#CHECK: veslvb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x70]
#CHECK: veslvb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x70]
#CHECK: veslvb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x70]
#CHECK: veslvb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x70]

	veslvb	%v0, %v0, %v0
	veslvb	%v0, %v0, %v31
	veslvb	%v0, %v31, %v0
	veslvb	%v31, %v0, %v0
	veslvb	%v18, %v3, %v20

#CHECK: veslvf  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x70]
#CHECK: veslvf  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x70]
#CHECK: veslvf  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x70]
#CHECK: veslvf  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x70]
#CHECK: veslvf  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x70]

	veslvf	%v0, %v0, %v0
	veslvf	%v0, %v0, %v31
	veslvf	%v0, %v31, %v0
	veslvf	%v31, %v0, %v0
	veslvf	%v18, %v3, %v20

#CHECK: veslvg  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x70]
#CHECK: veslvg  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x70]
#CHECK: veslvg  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x70]
#CHECK: veslvg  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x70]
#CHECK: veslvg  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x70]

	veslvg	%v0, %v0, %v0
	veslvg	%v0, %v0, %v31
	veslvg	%v0, %v31, %v0
	veslvg	%v31, %v0, %v0
	veslvg	%v18, %v3, %v20

#CHECK: veslvh  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x70]
#CHECK: veslvh  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x70]
#CHECK: veslvh  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x70]
#CHECK: veslvh  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x70]
#CHECK: veslvh  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x70]

	veslvh	%v0, %v0, %v0
	veslvh	%v0, %v0, %v31
	veslvh	%v0, %v31, %v0
	veslvh	%v31, %v0, %v0
	veslvh	%v18, %v3, %v20

#CHECK: vesra   %v0, %v0, 0, 0         # encoding: [0xe7,0x00,0x00,0x00,0x00,0x3a]
#CHECK: vesra   %v0, %v0, 0, 15        # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x3a]
#CHECK: vesra   %v0, %v0, 4095, 0      # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x3a]
#CHECK: vesra   %v0, %v0, 0(%r15), 0   # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x3a]
#CHECK: vesra   %v0, %v31, 0, 0        # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x3a]
#CHECK: vesra   %v31, %v0, 0, 0        # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x3a]
#CHECK: vesra   %v14, %v17, 1074(%r5), 11 # encoding: [0xe7,0xe1,0x54,0x32,0xb4,0x3a]

	vesra	%v0, %v0, 0, 0
	vesra	%v0, %v0, 0, 15
	vesra	%v0, %v0, 4095, 0
	vesra	%v0, %v0, 0(%r15), 0
	vesra	%v0, %v31, 0, 0
	vesra	%v31, %v0, 0, 0
	vesra	%v14, %v17, 1074(%r5), 11

#CHECK: vesrab  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x3a]
#CHECK: vesrab  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x3a]
#CHECK: vesrab  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x3a]
#CHECK: vesrab  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x3a]
#CHECK: vesrab  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x3a]
#CHECK: vesrab  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x04,0x3a]

	vesrab	%v0, %v0, 0
	vesrab	%v0, %v0, 4095
	vesrab	%v0, %v0, 0(%r15)
	vesrab	%v0, %v31, 0
	vesrab	%v31, %v0, 0
	vesrab	%v14, %v17, 1074(%r5)

#CHECK: vesraf  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x3a]
#CHECK: vesraf  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x3a]
#CHECK: vesraf  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x3a]
#CHECK: vesraf  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x3a]
#CHECK: vesraf  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x3a]
#CHECK: vesraf  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x24,0x3a]

	vesraf	%v0, %v0, 0
	vesraf	%v0, %v0, 4095
	vesraf	%v0, %v0, 0(%r15)
	vesraf	%v0, %v31, 0
	vesraf	%v31, %v0, 0
	vesraf	%v14, %v17, 1074(%r5)

#CHECK: vesrag  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x3a]
#CHECK: vesrag  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x3a]
#CHECK: vesrag  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x3a]
#CHECK: vesrag  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x3a]
#CHECK: vesrag  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x3a]
#CHECK: vesrag  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x34,0x3a]

	vesrag	%v0, %v0, 0
	vesrag	%v0, %v0, 4095
	vesrag	%v0, %v0, 0(%r15)
	vesrag	%v0, %v31, 0
	vesrag	%v31, %v0, 0
	vesrag	%v14, %v17, 1074(%r5)

#CHECK: vesrah  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x10,0x3a]
#CHECK: vesrah  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x3a]
#CHECK: vesrah  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x3a]
#CHECK: vesrah  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x3a]
#CHECK: vesrah  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x3a]
#CHECK: vesrah  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x14,0x3a]

	vesrah	%v0, %v0, 0
	vesrah	%v0, %v0, 4095
	vesrah	%v0, %v0, 0(%r15)
	vesrah	%v0, %v31, 0
	vesrah	%v31, %v0, 0
	vesrah	%v14, %v17, 1074(%r5)

#CHECK: vesrav  %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x7a]
#CHECK: vesrav  %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x7a]
#CHECK: vesrav  %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x7a]
#CHECK: vesrav  %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x7a]
#CHECK: vesrav  %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x7a]
#CHECK: vesrav  %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x7a]

	vesrav	%v0, %v0, %v0, 0
	vesrav	%v0, %v0, %v0, 15
	vesrav	%v0, %v0, %v31, 0
	vesrav	%v0, %v31, %v0, 0
	vesrav	%v31, %v0, %v0, 0
	vesrav	%v18, %v3, %v20, 11

#CHECK: vesravb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x7a]
#CHECK: vesravb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x7a]
#CHECK: vesravb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x7a]
#CHECK: vesravb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x7a]
#CHECK: vesravb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x7a]

	vesravb	%v0, %v0, %v0
	vesravb	%v0, %v0, %v31
	vesravb	%v0, %v31, %v0
	vesravb	%v31, %v0, %v0
	vesravb	%v18, %v3, %v20

#CHECK: vesravf %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x7a]
#CHECK: vesravf %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x7a]
#CHECK: vesravf %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x7a]
#CHECK: vesravf %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x7a]
#CHECK: vesravf %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x7a]

	vesravf	%v0, %v0, %v0
	vesravf	%v0, %v0, %v31
	vesravf	%v0, %v31, %v0
	vesravf	%v31, %v0, %v0
	vesravf	%v18, %v3, %v20

#CHECK: vesravg %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x7a]
#CHECK: vesravg %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x7a]
#CHECK: vesravg %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x7a]
#CHECK: vesravg %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x7a]
#CHECK: vesravg %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x7a]

	vesravg	%v0, %v0, %v0
	vesravg	%v0, %v0, %v31
	vesravg	%v0, %v31, %v0
	vesravg	%v31, %v0, %v0
	vesravg	%v18, %v3, %v20

#CHECK: vesravh %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x7a]
#CHECK: vesravh %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x7a]
#CHECK: vesravh %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x7a]
#CHECK: vesravh %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x7a]
#CHECK: vesravh %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x7a]

	vesravh	%v0, %v0, %v0
	vesravh	%v0, %v0, %v31
	vesravh	%v0, %v31, %v0
	vesravh	%v31, %v0, %v0
	vesravh	%v18, %v3, %v20

#CHECK: vesrl   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0x38]
#CHECK: vesrl   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x38]
#CHECK: vesrl   %v0, %v0, 4095, 0       # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x38]
#CHECK: vesrl   %v0, %v0, 0(%r15), 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x38]
#CHECK: vesrl   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x38]
#CHECK: vesrl   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x38]
#CHECK: vesrl   %v14, %v17, 1074(%r5), 11 # encoding: [0xe7,0xe1,0x54,0x32,0xb4,0x38]

	vesrl	%v0, %v0, 0, 0
	vesrl	%v0, %v0, 0, 15
	vesrl	%v0, %v0, 4095, 0
	vesrl	%v0, %v0, 0(%r15), 0
	vesrl	%v0, %v31, 0, 0
	vesrl	%v31, %v0, 0, 0
	vesrl	%v14, %v17, 1074(%r5), 11

#CHECK: vesrlb  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x38]
#CHECK: vesrlb  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x38]
#CHECK: vesrlb  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x38]
#CHECK: vesrlb  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x38]
#CHECK: vesrlb  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x38]
#CHECK: vesrlb  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x04,0x38]

	vesrlb	%v0, %v0, 0
	vesrlb	%v0, %v0, 4095
	vesrlb	%v0, %v0, 0(%r15)
	vesrlb	%v0, %v31, 0
	vesrlb	%v31, %v0, 0
	vesrlb	%v14, %v17, 1074(%r5)

#CHECK: vesrlf  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x38]
#CHECK: vesrlf  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x38]
#CHECK: vesrlf  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x38]
#CHECK: vesrlf  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x38]
#CHECK: vesrlf  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x38]
#CHECK: vesrlf  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x24,0x38]

	vesrlf	%v0, %v0, 0
	vesrlf	%v0, %v0, 4095
	vesrlf	%v0, %v0, 0(%r15)
	vesrlf	%v0, %v31, 0
	vesrlf	%v31, %v0, 0
	vesrlf	%v14, %v17, 1074(%r5)

#CHECK: vesrlg  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x38]
#CHECK: vesrlg  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x38]
#CHECK: vesrlg  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x38]
#CHECK: vesrlg  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x38]
#CHECK: vesrlg  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x38]
#CHECK: vesrlg  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x34,0x38]

	vesrlg	%v0, %v0, 0
	vesrlg	%v0, %v0, 4095
	vesrlg	%v0, %v0, 0(%r15)
	vesrlg	%v0, %v31, 0
	vesrlg	%v31, %v0, 0
	vesrlg	%v14, %v17, 1074(%r5)

#CHECK: vesrlh  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x10,0x38]
#CHECK: vesrlh  %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x38]
#CHECK: vesrlh  %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x38]
#CHECK: vesrlh  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x38]
#CHECK: vesrlh  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x38]
#CHECK: vesrlh  %v14, %v17, 1074(%r5)   # encoding: [0xe7,0xe1,0x54,0x32,0x14,0x38]

	vesrlh	%v0, %v0, 0
	vesrlh	%v0, %v0, 4095
	vesrlh	%v0, %v0, 0(%r15)
	vesrlh	%v0, %v31, 0
	vesrlh	%v31, %v0, 0
	vesrlh	%v14, %v17, 1074(%r5)

#CHECK: vesrlv  %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x78]
#CHECK: vesrlv  %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x78]
#CHECK: vesrlv  %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x78]
#CHECK: vesrlv  %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x78]
#CHECK: vesrlv  %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x78]
#CHECK: vesrlv  %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x78]

	vesrlv	%v0, %v0, %v0, 0
	vesrlv	%v0, %v0, %v0, 15
	vesrlv	%v0, %v0, %v31, 0
	vesrlv	%v0, %v31, %v0, 0
	vesrlv	%v31, %v0, %v0, 0
	vesrlv	%v18, %v3, %v20, 11

#CHECK: vesrlvb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x78]
#CHECK: vesrlvb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x78]
#CHECK: vesrlvb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x78]
#CHECK: vesrlvb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x78]
#CHECK: vesrlvb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x78]

	vesrlvb	%v0, %v0, %v0
	vesrlvb	%v0, %v0, %v31
	vesrlvb	%v0, %v31, %v0
	vesrlvb	%v31, %v0, %v0
	vesrlvb	%v18, %v3, %v20

#CHECK: vesrlvf %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x78]
#CHECK: vesrlvf %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x78]
#CHECK: vesrlvf %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x78]
#CHECK: vesrlvf %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x78]
#CHECK: vesrlvf %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x78]

	vesrlvf	%v0, %v0, %v0
	vesrlvf	%v0, %v0, %v31
	vesrlvf	%v0, %v31, %v0
	vesrlvf	%v31, %v0, %v0
	vesrlvf	%v18, %v3, %v20

#CHECK: vesrlvg %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x78]
#CHECK: vesrlvg %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x78]
#CHECK: vesrlvg %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x78]
#CHECK: vesrlvg %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x78]
#CHECK: vesrlvg %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x78]

	vesrlvg	%v0, %v0, %v0
	vesrlvg	%v0, %v0, %v31
	vesrlvg	%v0, %v31, %v0
	vesrlvg	%v31, %v0, %v0
	vesrlvg	%v18, %v3, %v20

#CHECK: vesrlvh %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x78]
#CHECK: vesrlvh %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x78]
#CHECK: vesrlvh %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x78]
#CHECK: vesrlvh %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x78]
#CHECK: vesrlvh %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x78]

	vesrlvh	%v0, %v0, %v0
	vesrlvh	%v0, %v0, %v31
	vesrlvh	%v0, %v31, %v0
	vesrlvh	%v31, %v0, %v0
	vesrlvh	%v18, %v3, %v20

#CHECK: vfa     %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xe3]
#CHECK: vfa     %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xe3]
#CHECK: vfa     %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xe3]
#CHECK: vfa     %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xe3]
#CHECK: vfa     %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xe3]
#CHECK: vfa     %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xe3]
#CHECK: vfa     %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x09,0xba,0xe3]

	vfa	%v0, %v0, %v0, 0, 0
	vfa	%v0, %v0, %v0, 15, 0
	vfa	%v0, %v0, %v0, 0, 15
	vfa	%v0, %v0, %v31, 0, 0
	vfa	%v0, %v31, %v0, 0, 0
	vfa	%v31, %v0, %v0, 0, 0
	vfa	%v18, %v3, %v20, 11, 9

#CHECK: vfadb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xe3]
#CHECK: vfadb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xe3]
#CHECK: vfadb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xe3]
#CHECK: vfadb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xe3]
#CHECK: vfadb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xe3]

	vfadb	%v0, %v0, %v0
	vfadb	%v0, %v0, %v31
	vfadb	%v0, %v31, %v0
	vfadb	%v31, %v0, %v0
	vfadb	%v18, %v3, %v20

#CHECK: vfae    %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x82]
#CHECK: vfae    %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x82]
#CHECK: vfae    %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x82]
#CHECK: vfae    %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x82]
#CHECK: vfae    %v0, %v0, %v0, 0, 12    # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x82]
#CHECK: vfae    %v0, %v0, %v15, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x82]
#CHECK: vfae    %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x82]
#CHECK: vfae    %v0, %v15, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x82]
#CHECK: vfae    %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x82]
#CHECK: vfae    %v15, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x82]
#CHECK: vfae    %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x82]
#CHECK: vfae    %v18, %v3, %v20, 11, 4  # encoding: [0xe7,0x23,0x40,0x40,0xba,0x82]
#CHECK: vfae    %v18, %v3, %v20, 0, 15  # encoding: [0xe7,0x23,0x40,0xf0,0x0a,0x82]

	vfae	%v0, %v0, %v0, 0
	vfae	%v0, %v0, %v0, 15
	vfae	%v0, %v0, %v0, 0, 0
	vfae	%v0, %v0, %v0, 15, 0
	vfae	%v0, %v0, %v0, 0, 12
	vfae	%v0, %v0, %v15, 0
	vfae	%v0, %v0, %v31, 0
	vfae	%v0, %v15, %v0, 0
	vfae	%v0, %v31, %v0, 0
	vfae	%v15, %v0, %v0, 0
	vfae	%v31, %v0, %v0, 0
	vfae	%v18, %v3, %v20, 11, 4
	vfae	%v18, %v3, %v20, 0, 15

#CHECK: vfaeb   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x82]
#CHECK: vfaeb   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x82]
#CHECK: vfaeb   %v0, %v0, %v0, 12       # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x82]
#CHECK: vfaeb   %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x82]
#CHECK: vfaeb   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x82]
#CHECK: vfaeb   %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x82]
#CHECK: vfaeb   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x82]
#CHECK: vfaeb   %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x82]
#CHECK: vfaeb   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x82]
#CHECK: vfaeb   %v18, %v3, %v20, 4      # encoding: [0xe7,0x23,0x40,0x40,0x0a,0x82]
#CHECK: vfaeb   %v18, %v3, %v20, 15     # encoding: [0xe7,0x23,0x40,0xf0,0x0a,0x82]
#CHECK: vfaebs  %v18, %v3, %v20, 8      # encoding: [0xe7,0x23,0x40,0x90,0x0a,0x82]
#CHECK: vfaezb  %v18, %v3, %v20, 4      # encoding: [0xe7,0x23,0x40,0x60,0x0a,0x82]
#CHECK: vfaezbs %v18, %v3, %v20, 8      # encoding: [0xe7,0x23,0x40,0xb0,0x0a,0x82]
#CHECK: vfaezbs %v18, %v3, %v20, 15     # encoding: [0xe7,0x23,0x40,0xf0,0x0a,0x82]

	vfaeb	%v0, %v0, %v0
	vfaeb	%v0, %v0, %v0, 0
	vfaeb	%v0, %v0, %v0, 12
	vfaeb	%v0, %v0, %v15
	vfaeb	%v0, %v0, %v31
	vfaeb	%v0, %v15, %v0
	vfaeb	%v0, %v31, %v0
	vfaeb	%v15, %v0, %v0
	vfaeb	%v31, %v0, %v0
	vfaeb	%v18, %v3, %v20, 4
	vfaeb	%v18, %v3, %v20, 15
	vfaebs	%v18, %v3, %v20, 8
	vfaezb	%v18, %v3, %v20, 4
	vfaezbs	%v18, %v3, %v20, 8
	vfaezbs	%v18, %v3, %v20, 15

#CHECK: vfaef   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0x82]
#CHECK: vfaef   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0x82]
#CHECK: vfaef   %v0, %v0, %v0, 12       # encoding: [0xe7,0x00,0x00,0xc0,0x20,0x82]
#CHECK: vfaef   %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x82]
#CHECK: vfaef   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x82]
#CHECK: vfaef   %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x82]
#CHECK: vfaef   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x82]
#CHECK: vfaef   %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x82]
#CHECK: vfaef   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x82]
#CHECK: vfaef   %v18, %v3, %v20, 4      # encoding: [0xe7,0x23,0x40,0x40,0x2a,0x82]
#CHECK: vfaef   %v18, %v3, %v20, 15     # encoding: [0xe7,0x23,0x40,0xf0,0x2a,0x82]
#CHECK: vfaefs  %v18, %v3, %v20, 8      # encoding: [0xe7,0x23,0x40,0x90,0x2a,0x82]
#CHECK: vfaezf  %v18, %v3, %v20, 4      # encoding: [0xe7,0x23,0x40,0x60,0x2a,0x82]
#CHECK: vfaezfs %v18, %v3, %v20, 8      # encoding: [0xe7,0x23,0x40,0xb0,0x2a,0x82]
#CHECK: vfaezfs %v18, %v3, %v20, 15     # encoding: [0xe7,0x23,0x40,0xf0,0x2a,0x82]

	vfaef	%v0, %v0, %v0
	vfaef	%v0, %v0, %v0, 0
	vfaef	%v0, %v0, %v0, 12
	vfaef	%v0, %v0, %v15
	vfaef	%v0, %v0, %v31
	vfaef	%v0, %v15, %v0
	vfaef	%v0, %v31, %v0
	vfaef	%v15, %v0, %v0
	vfaef	%v31, %v0, %v0
	vfaef	%v18, %v3, %v20, 4
	vfaef	%v18, %v3, %v20, 15
	vfaefs	%v18, %v3, %v20, 8
	vfaezf	%v18, %v3, %v20, 4
	vfaezfs	%v18, %v3, %v20, 8
	vfaezfs	%v18, %v3, %v20, 15

#CHECK: vfaeh   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x10,0x82]
#CHECK: vfaeh   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x10,0x82]
#CHECK: vfaeh   %v0, %v0, %v0, 12       # encoding: [0xe7,0x00,0x00,0xc0,0x10,0x82]
#CHECK: vfaeh   %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x82]
#CHECK: vfaeh   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x82]
#CHECK: vfaeh   %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x82]
#CHECK: vfaeh   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x82]
#CHECK: vfaeh   %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x82]
#CHECK: vfaeh   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x82]
#CHECK: vfaeh   %v18, %v3, %v20, 4      # encoding: [0xe7,0x23,0x40,0x40,0x1a,0x82]
#CHECK: vfaeh   %v18, %v3, %v20, 15     # encoding: [0xe7,0x23,0x40,0xf0,0x1a,0x82]
#CHECK: vfaehs  %v18, %v3, %v20, 8      # encoding: [0xe7,0x23,0x40,0x90,0x1a,0x82]
#CHECK: vfaezh  %v18, %v3, %v20, 4      # encoding: [0xe7,0x23,0x40,0x60,0x1a,0x82]
#CHECK: vfaezhs %v18, %v3, %v20, 8      # encoding: [0xe7,0x23,0x40,0xb0,0x1a,0x82]
#CHECK: vfaezhs %v18, %v3, %v20, 15     # encoding: [0xe7,0x23,0x40,0xf0,0x1a,0x82]

	vfaeh	%v0, %v0, %v0
	vfaeh	%v0, %v0, %v0, 0
	vfaeh	%v0, %v0, %v0, 12
	vfaeh	%v0, %v0, %v15
	vfaeh	%v0, %v0, %v31
	vfaeh	%v0, %v15, %v0
	vfaeh	%v0, %v31, %v0
	vfaeh	%v15, %v0, %v0
	vfaeh	%v31, %v0, %v0
	vfaeh	%v18, %v3, %v20, 4
	vfaeh	%v18, %v3, %v20, 15
	vfaehs	%v18, %v3, %v20, 8
	vfaezh	%v18, %v3, %v20, 4
	vfaezhs	%v18, %v3, %v20, 8
	vfaezhs	%v18, %v3, %v20, 15

#CHECK: vfce    %v0, %v0, %v0, 0, 0, 0  # encoding: [0xe7,0x00,0x00,0x00,0x00,0xe8]
#CHECK: vfce    %v0, %v0, %v0, 15, 0, 0 # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xe8]
#CHECK: vfce    %v0, %v0, %v0, 0, 15, 0 # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xe8]
#CHECK: vfce    %v0, %v0, %v0, 0, 0, 15 # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xe8]
#CHECK: vfce    %v0, %v0, %v31, 0, 0, 0 # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xe8]
#CHECK: vfce    %v0, %v31, %v0, 0, 0, 0 # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xe8]
#CHECK: vfce    %v31, %v0, %v0, 0, 0, 0 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xe8]
#CHECK: vfce    %v18, %v3, %v20, 11, 9, 7 # encoding: [0xe7,0x23,0x40,0x79,0xba,0xe8]

	vfce	%v0, %v0, %v0, 0, 0, 0
	vfce	%v0, %v0, %v0, 15, 0, 0
	vfce	%v0, %v0, %v0, 0, 15, 0
	vfce	%v0, %v0, %v0, 0, 0, 15
	vfce	%v0, %v0, %v31, 0, 0, 0
	vfce	%v0, %v31, %v0, 0, 0, 0
	vfce	%v31, %v0, %v0, 0, 0, 0
	vfce	%v18, %v3, %v20, 11, 9, 7

#CHECK: vfcedb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xe8]
#CHECK: vfcedb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xe8]
#CHECK: vfcedb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xe8]
#CHECK: vfcedb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xe8]
#CHECK: vfcedb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xe8]

	vfcedb	%v0, %v0, %v0
	vfcedb	%v0, %v0, %v31
	vfcedb	%v0, %v31, %v0
	vfcedb	%v31, %v0, %v0
	vfcedb	%v18, %v3, %v20

#CHECK: vfcedbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x10,0x30,0xe8]
#CHECK: vfcedbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x10,0x32,0xe8]
#CHECK: vfcedbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x10,0x34,0xe8]
#CHECK: vfcedbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x10,0x38,0xe8]
#CHECK: vfcedbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x10,0x3a,0xe8]

	vfcedbs	%v0, %v0, %v0
	vfcedbs	%v0, %v0, %v31
	vfcedbs	%v0, %v31, %v0
	vfcedbs	%v31, %v0, %v0
	vfcedbs	%v18, %v3, %v20

#CHECK: vfch    %v0, %v0, %v0, 0, 0, 0  # encoding: [0xe7,0x00,0x00,0x00,0x00,0xeb]
#CHECK: vfch    %v0, %v0, %v0, 15, 0, 0 # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xeb]
#CHECK: vfch    %v0, %v0, %v0, 0, 15, 0 # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xeb]
#CHECK: vfch    %v0, %v0, %v0, 0, 0, 15 # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xeb]
#CHECK: vfch    %v0, %v0, %v31, 0, 0, 0 # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xeb]
#CHECK: vfch    %v0, %v31, %v0, 0, 0, 0 # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xeb]
#CHECK: vfch    %v31, %v0, %v0, 0, 0, 0 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xeb]
#CHECK: vfch    %v18, %v3, %v20, 11, 9, 7 # encoding: [0xe7,0x23,0x40,0x79,0xba,0xeb]

	vfch	%v0, %v0, %v0, 0, 0, 0
	vfch	%v0, %v0, %v0, 15, 0, 0
	vfch	%v0, %v0, %v0, 0, 15, 0
	vfch	%v0, %v0, %v0, 0, 0, 15
	vfch	%v0, %v0, %v31, 0, 0, 0
	vfch	%v0, %v31, %v0, 0, 0, 0
	vfch	%v31, %v0, %v0, 0, 0, 0
	vfch	%v18, %v3, %v20, 11, 9, 7

#CHECK: vfchdb  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xeb]
#CHECK: vfchdb  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xeb]
#CHECK: vfchdb  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xeb]
#CHECK: vfchdb  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xeb]
#CHECK: vfchdb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xeb]

	vfchdb	%v0, %v0, %v0
	vfchdb	%v0, %v0, %v31
	vfchdb	%v0, %v31, %v0
	vfchdb	%v31, %v0, %v0
	vfchdb	%v18, %v3, %v20

#CHECK: vfchdbs %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x10,0x30,0xeb]
#CHECK: vfchdbs %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x10,0x32,0xeb]
#CHECK: vfchdbs %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x10,0x34,0xeb]
#CHECK: vfchdbs %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x10,0x38,0xeb]
#CHECK: vfchdbs %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x10,0x3a,0xeb]

	vfchdbs	%v0, %v0, %v0
	vfchdbs	%v0, %v0, %v31
	vfchdbs	%v0, %v31, %v0
	vfchdbs	%v31, %v0, %v0
	vfchdbs	%v18, %v3, %v20

#CHECK: vfche   %v0, %v0, %v0, 0, 0, 0  # encoding: [0xe7,0x00,0x00,0x00,0x00,0xea]
#CHECK: vfche   %v0, %v0, %v0, 15, 0, 0 # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xea]
#CHECK: vfche   %v0, %v0, %v0, 0, 15, 0 # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xea]
#CHECK: vfche   %v0, %v0, %v0, 0, 0, 15 # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xea]
#CHECK: vfche   %v0, %v0, %v31, 0, 0, 0 # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xea]
#CHECK: vfche   %v0, %v31, %v0, 0, 0, 0 # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xea]
#CHECK: vfche   %v31, %v0, %v0, 0, 0, 0 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xea]
#CHECK: vfche   %v18, %v3, %v20, 11, 9, 7 # encoding: [0xe7,0x23,0x40,0x79,0xba,0xea]

	vfche	%v0, %v0, %v0, 0, 0, 0
	vfche	%v0, %v0, %v0, 15, 0, 0
	vfche	%v0, %v0, %v0, 0, 15, 0
	vfche	%v0, %v0, %v0, 0, 0, 15
	vfche	%v0, %v0, %v31, 0, 0, 0
	vfche	%v0, %v31, %v0, 0, 0, 0
	vfche	%v31, %v0, %v0, 0, 0, 0
	vfche	%v18, %v3, %v20, 11, 9, 7

#CHECK: vfchedb %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xea]
#CHECK: vfchedb %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xea]
#CHECK: vfchedb %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xea]
#CHECK: vfchedb %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xea]
#CHECK: vfchedb %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xea]

	vfchedb	%v0, %v0, %v0
	vfchedb	%v0, %v0, %v31
	vfchedb	%v0, %v31, %v0
	vfchedb	%v31, %v0, %v0
	vfchedb	%v18, %v3, %v20

#CHECK: vfchedbs %v0, %v0, %v0          # encoding: [0xe7,0x00,0x00,0x10,0x30,0xea]
#CHECK: vfchedbs %v0, %v0, %v31         # encoding: [0xe7,0x00,0xf0,0x10,0x32,0xea]
#CHECK: vfchedbs %v0, %v31, %v0         # encoding: [0xe7,0x0f,0x00,0x10,0x34,0xea]
#CHECK: vfchedbs %v31, %v0, %v0         # encoding: [0xe7,0xf0,0x00,0x10,0x38,0xea]
#CHECK: vfchedbs %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x10,0x3a,0xea]

	vfchedbs %v0, %v0, %v0
	vfchedbs %v0, %v0, %v31
	vfchedbs %v0, %v31, %v0
	vfchedbs %v31, %v0, %v0
	vfchedbs %v18, %v3, %v20

#CHECK: vfd     %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xe5]
#CHECK: vfd     %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xe5]
#CHECK: vfd     %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xe5]
#CHECK: vfd     %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xe5]
#CHECK: vfd     %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xe5]
#CHECK: vfd     %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xe5]
#CHECK: vfd     %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x09,0xba,0xe5]

	vfd	%v0, %v0, %v0, 0, 0
	vfd	%v0, %v0, %v0, 15, 0
	vfd	%v0, %v0, %v0, 0, 15
	vfd	%v0, %v0, %v31, 0, 0
	vfd	%v0, %v31, %v0, 0, 0
	vfd	%v31, %v0, %v0, 0, 0
	vfd	%v18, %v3, %v20, 11, 9

#CHECK: vfddb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xe5]
#CHECK: vfddb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xe5]
#CHECK: vfddb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xe5]
#CHECK: vfddb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xe5]
#CHECK: vfddb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xe5]

	vfddb	%v0, %v0, %v0
	vfddb	%v0, %v0, %v31
	vfddb	%v0, %v31, %v0
	vfddb	%v31, %v0, %v0
	vfddb	%v18, %v3, %v20

#CHECK: vfee    %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x80]
#CHECK: vfee    %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x80]
#CHECK: vfee    %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x80]
#CHECK: vfee    %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x80]
#CHECK: vfee    %v0, %v0, %v0, 0, 12    # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x80]
#CHECK: vfee    %v0, %v0, %v15, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x80]
#CHECK: vfee    %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x80]
#CHECK: vfee    %v0, %v15, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x80]
#CHECK: vfee    %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x80]
#CHECK: vfee    %v15, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x80]
#CHECK: vfee    %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x80]
#CHECK: vfee    %v18, %v3, %v20, 11, 4  # encoding: [0xe7,0x23,0x40,0x40,0xba,0x80]
#CHECK: vfee    %v18, %v3, %v20, 0, 15  # encoding: [0xe7,0x23,0x40,0xf0,0x0a,0x80]

	vfee	%v0, %v0, %v0, 0
	vfee	%v0, %v0, %v0, 15
	vfee	%v0, %v0, %v0, 0, 0
	vfee	%v0, %v0, %v0, 15, 0
	vfee	%v0, %v0, %v0, 0, 12
	vfee	%v0, %v0, %v15, 0
	vfee	%v0, %v0, %v31, 0
	vfee	%v0, %v15, %v0, 0
	vfee	%v0, %v31, %v0, 0
	vfee	%v15, %v0, %v0, 0
	vfee	%v31, %v0, %v0, 0
	vfee	%v18, %v3, %v20, 11, 4
	vfee	%v18, %v3, %v20, 0, 15

#CHECK: vfeeb   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x80]
#CHECK: vfeeb   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x80]
#CHECK: vfeeb   %v0, %v0, %v0, 12       # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x80]
#CHECK: vfeeb   %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x80]
#CHECK: vfeeb   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x80]
#CHECK: vfeeb   %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x80]
#CHECK: vfeeb   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x80]
#CHECK: vfeeb   %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x80]
#CHECK: vfeeb   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x80]
#CHECK: vfeeb   %v18, %v3, %v20, 0      # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x80]
#CHECK: vfeebs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x04,0x80]
#CHECK: vfeezb  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x20,0x0a,0x80]
#CHECK: vfeezbs %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x30,0x04,0x80]

	vfeeb	%v0, %v0, %v0
	vfeeb	%v0, %v0, %v0, 0
	vfeeb	%v0, %v0, %v0, 12
	vfeeb	%v0, %v0, %v15
	vfeeb	%v0, %v0, %v31
	vfeeb	%v0, %v15, %v0
	vfeeb	%v0, %v31, %v0
	vfeeb	%v15, %v0, %v0
	vfeeb	%v31, %v0, %v0
	vfeeb	%v18, %v3, %v20
	vfeebs	%v5, %v22, %v7
	vfeezb	%v18, %v3, %v20
	vfeezbs	%v5, %v22, %v7

#CHECK: vfeef   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0x80]
#CHECK: vfeef   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x20,0x80]
#CHECK: vfeef   %v0, %v0, %v0, 12       # encoding: [0xe7,0x00,0x00,0xc0,0x20,0x80]
#CHECK: vfeef   %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x80]
#CHECK: vfeef   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x80]
#CHECK: vfeef   %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x80]
#CHECK: vfeef   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x80]
#CHECK: vfeef   %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x80]
#CHECK: vfeef   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x80]
#CHECK: vfeef   %v18, %v3, %v20, 0      # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x80]
#CHECK: vfeefs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x24,0x80]
#CHECK: vfeezf  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x20,0x2a,0x80]
#CHECK: vfeezfs %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x30,0x24,0x80]

	vfeef	%v0, %v0, %v0
	vfeef	%v0, %v0, %v0, 0
	vfeef	%v0, %v0, %v0, 12
	vfeef	%v0, %v0, %v15
	vfeef	%v0, %v0, %v31
	vfeef	%v0, %v15, %v0
	vfeef	%v0, %v31, %v0
	vfeef	%v15, %v0, %v0
	vfeef	%v31, %v0, %v0
	vfeef	%v18, %v3, %v20
	vfeefs	%v5, %v22, %v7
	vfeezf	%v18, %v3, %v20
	vfeezfs	%v5, %v22, %v7

#CHECK: vfeeh   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x10,0x80]
#CHECK: vfeeh   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x10,0x80]
#CHECK: vfeeh   %v0, %v0, %v0, 12       # encoding: [0xe7,0x00,0x00,0xc0,0x10,0x80]
#CHECK: vfeeh   %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x80]
#CHECK: vfeeh   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x80]
#CHECK: vfeeh   %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x80]
#CHECK: vfeeh   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x80]
#CHECK: vfeeh   %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x80]
#CHECK: vfeeh   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x80]
#CHECK: vfeeh   %v18, %v3, %v20, 0      # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x80]
#CHECK: vfeehs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x14,0x80]
#CHECK: vfeezh  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x20,0x1a,0x80]
#CHECK: vfeezhs %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x30,0x14,0x80]

	vfeeh	%v0, %v0, %v0
	vfeeh	%v0, %v0, %v0, 0
	vfeeh	%v0, %v0, %v0, 12
	vfeeh	%v0, %v0, %v15
	vfeeh	%v0, %v0, %v31
	vfeeh	%v0, %v15, %v0
	vfeeh	%v0, %v31, %v0
	vfeeh	%v15, %v0, %v0
	vfeeh	%v31, %v0, %v0
	vfeeh	%v18, %v3, %v20
	vfeehs	%v5, %v22, %v7
	vfeezh	%v18, %v3, %v20
	vfeezhs	%v5, %v22, %v7

#CHECK: vfene   %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x81]
#CHECK: vfene   %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x81]
#CHECK: vfene   %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x81]
#CHECK: vfene   %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x81]
#CHECK: vfene   %v0, %v0, %v0, 0, 12    # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x81]
#CHECK: vfene   %v0, %v0, %v15, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x81]
#CHECK: vfene   %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x81]
#CHECK: vfene   %v0, %v15, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x81]
#CHECK: vfene   %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x81]
#CHECK: vfene   %v15, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x81]
#CHECK: vfene   %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x81]
#CHECK: vfene   %v18, %v3, %v20, 11, 4  # encoding: [0xe7,0x23,0x40,0x40,0xba,0x81]
#CHECK: vfene   %v18, %v3, %v20, 0, 15  # encoding: [0xe7,0x23,0x40,0xf0,0x0a,0x81]

	vfene	%v0, %v0, %v0, 0
	vfene	%v0, %v0, %v0, 15
	vfene	%v0, %v0, %v0, 0, 0
	vfene	%v0, %v0, %v0, 15, 0
	vfene	%v0, %v0, %v0, 0, 12
	vfene	%v0, %v0, %v15, 0
	vfene	%v0, %v0, %v31, 0
	vfene	%v0, %v15, %v0, 0
	vfene	%v0, %v31, %v0, 0
	vfene	%v15, %v0, %v0, 0
	vfene	%v31, %v0, %v0, 0
	vfene	%v18, %v3, %v20, 11, 4
	vfene	%v18, %v3, %v20, 0, 15

#CHECK: vfeneb   %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x81]
#CHECK: vfeneb   %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x81]
#CHECK: vfeneb   %v0, %v0, %v0, 12      # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x81]
#CHECK: vfeneb   %v0, %v0, %v15, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x81]
#CHECK: vfeneb   %v0, %v0, %v31, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x81]
#CHECK: vfeneb   %v0, %v15, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x81]
#CHECK: vfeneb   %v0, %v31, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x81]
#CHECK: vfeneb   %v15, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x81]
#CHECK: vfeneb   %v31, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x81]
#CHECK: vfeneb   %v18, %v3, %v20, 0     # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x81]
#CHECK: vfenebs  %v5, %v22, %v7         # encoding: [0xe7,0x56,0x70,0x10,0x04,0x81]
#CHECK: vfenezb  %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x20,0x0a,0x81]
#CHECK: vfenezbs %v5, %v22, %v7         # encoding: [0xe7,0x56,0x70,0x30,0x04,0x81]

	vfeneb   %v0, %v0, %v0
	vfeneb   %v0, %v0, %v0, 0
	vfeneb   %v0, %v0, %v0, 12
	vfeneb   %v0, %v0, %v15
	vfeneb   %v0, %v0, %v31
	vfeneb   %v0, %v15, %v0
	vfeneb   %v0, %v31, %v0
	vfeneb   %v15, %v0, %v0
	vfeneb   %v31, %v0, %v0
	vfeneb   %v18, %v3, %v20
	vfenebs  %v5, %v22, %v7
	vfenezb  %v18, %v3, %v20
	vfenezbs %v5, %v22, %v7

#CHECK: vfenef   %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x20,0x81]
#CHECK: vfenef   %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x20,0x81]
#CHECK: vfenef   %v0, %v0, %v0, 12      # encoding: [0xe7,0x00,0x00,0xc0,0x20,0x81]
#CHECK: vfenef   %v0, %v0, %v15, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x81]
#CHECK: vfenef   %v0, %v0, %v31, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x81]
#CHECK: vfenef   %v0, %v15, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x81]
#CHECK: vfenef   %v0, %v31, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x81]
#CHECK: vfenef   %v15, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x81]
#CHECK: vfenef   %v31, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x81]
#CHECK: vfenef   %v18, %v3, %v20, 0     # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x81]
#CHECK: vfenefs  %v5, %v22, %v7         # encoding: [0xe7,0x56,0x70,0x10,0x24,0x81]
#CHECK: vfenezf  %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x20,0x2a,0x81]
#CHECK: vfenezfs %v5, %v22, %v7         # encoding: [0xe7,0x56,0x70,0x30,0x24,0x81]

	vfenef   %v0, %v0, %v0
	vfenef   %v0, %v0, %v0, 0
	vfenef   %v0, %v0, %v0, 12
	vfenef   %v0, %v0, %v15
	vfenef   %v0, %v0, %v31
	vfenef   %v0, %v15, %v0
	vfenef   %v0, %v31, %v0
	vfenef   %v15, %v0, %v0
	vfenef   %v31, %v0, %v0
	vfenef   %v18, %v3, %v20
	vfenefs  %v5, %v22, %v7
	vfenezf  %v18, %v3, %v20
	vfenezfs %v5, %v22, %v7

#CHECK: vfeneh   %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x10,0x81]
#CHECK: vfeneh   %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x10,0x81]
#CHECK: vfeneh   %v0, %v0, %v0, 12      # encoding: [0xe7,0x00,0x00,0xc0,0x10,0x81]
#CHECK: vfeneh   %v0, %v0, %v15, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x81]
#CHECK: vfeneh   %v0, %v0, %v31, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x81]
#CHECK: vfeneh   %v0, %v15, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x81]
#CHECK: vfeneh   %v0, %v31, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x81]
#CHECK: vfeneh   %v15, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x81]
#CHECK: vfeneh   %v31, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x81]
#CHECK: vfeneh   %v18, %v3, %v20, 0     # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x81]
#CHECK: vfenehs  %v5, %v22, %v7         # encoding: [0xe7,0x56,0x70,0x10,0x14,0x81]
#CHECK: vfenezh  %v18, %v3, %v20        # encoding: [0xe7,0x23,0x40,0x20,0x1a,0x81]
#CHECK: vfenezhs %v5, %v22, %v7         # encoding: [0xe7,0x56,0x70,0x30,0x14,0x81]

	vfeneh   %v0, %v0, %v0
	vfeneh   %v0, %v0, %v0, 0
	vfeneh   %v0, %v0, %v0, 12
	vfeneh   %v0, %v0, %v15
	vfeneh   %v0, %v0, %v31
	vfeneh   %v0, %v15, %v0
	vfeneh   %v0, %v31, %v0
	vfeneh   %v15, %v0, %v0
	vfeneh   %v31, %v0, %v0
	vfeneh   %v18, %v3, %v20
	vfenehs  %v5, %v22, %v7
	vfenezh  %v18, %v3, %v20
	vfenezhs %v5, %v22, %v7

#CHECK: vfi     %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc7]
#CHECK: vfi     %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc7]
#CHECK: vfi     %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc7]
#CHECK: vfi     %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc7]
#CHECK: vfi     %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc7]
#CHECK: vfi     %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc7]
#CHECK: vfi     %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc7]
#CHECK: vfi     %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc7]

	vfi	%v0, %v0, 0, 0, 0
	vfi	%v0, %v0, 15, 0, 0
	vfi	%v0, %v0, 0, 0, 15
	vfi	%v0, %v0, 0, 4, 0
	vfi	%v0, %v0, 0, 12, 0
	vfi	%v0, %v31, 0, 0, 0
	vfi	%v31, %v0, 0, 0, 0
	vfi	%v14, %v17, 11, 4, 10

#CHECK: vfidb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x30,0xc7]
#CHECK: vfidb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xc7]
#CHECK: vfidb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x30,0xc7]
#CHECK: vfidb   %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc7]
#CHECK: vfidb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xc7]
#CHECK: vfidb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xc7]
#CHECK: vfidb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x34,0xc7]

	vfidb	%v0, %v0, 0, 0
	vfidb	%v0, %v0, 0, 15
	vfidb	%v0, %v0, 4, 0
	vfidb	%v0, %v0, 12, 0
	vfidb	%v0, %v31, 0, 0
	vfidb	%v31, %v0, 0, 0
	vfidb	%v14, %v17, 4, 10

#CHECK: vflcdb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xcc]
#CHECK: vflcdb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xcc]
#CHECK: vflcdb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xcc]
#CHECK: vflcdb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xcc]
#CHECK: vflcdb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xcc]
#CHECK: vflcdb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xcc]

	vflcdb	%v0, %v0
	vflcdb	%v0, %v15
	vflcdb	%v0, %v31
	vflcdb	%v15, %v0
	vflcdb	%v31, %v0
	vflcdb	%v14, %v17

#CHECK: vflndb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x10,0x30,0xcc]
#CHECK: vflndb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x10,0x30,0xcc]
#CHECK: vflndb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x10,0x34,0xcc]
#CHECK: vflndb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x10,0x30,0xcc]
#CHECK: vflndb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x10,0x38,0xcc]
#CHECK: vflndb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x10,0x34,0xcc]

	vflndb	%v0, %v0
	vflndb	%v0, %v15
	vflndb	%v0, %v31
	vflndb	%v15, %v0
	vflndb	%v31, %v0
	vflndb	%v14, %v17

#CHECK: vflpdb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x20,0x30,0xcc]
#CHECK: vflpdb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x20,0x30,0xcc]
#CHECK: vflpdb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x20,0x34,0xcc]
#CHECK: vflpdb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x20,0x30,0xcc]
#CHECK: vflpdb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x20,0x38,0xcc]
#CHECK: vflpdb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x20,0x34,0xcc]

	vflpdb	%v0, %v0
	vflpdb	%v0, %v15
	vflpdb	%v0, %v31
	vflpdb	%v15, %v0
	vflpdb	%v31, %v0
	vflpdb	%v14, %v17

#CHECK: vfm     %v0, %v0, %v0, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xe7]
#CHECK: vfm     %v0, %v0, %v0, 15, 0     # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xe7]
#CHECK: vfm     %v0, %v0, %v0, 0, 15     # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xe7]
#CHECK: vfm     %v0, %v0, %v31, 0, 0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xe7]
#CHECK: vfm     %v0, %v31, %v0, 0, 0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xe7]
#CHECK: vfm     %v31, %v0, %v0, 0, 0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xe7]
#CHECK: vfm     %v18, %v3, %v20, 11, 9   # encoding: [0xe7,0x23,0x40,0x09,0xba,0xe7]

	vfm	%v0, %v0, %v0, 0, 0
	vfm	%v0, %v0, %v0, 15, 0
	vfm	%v0, %v0, %v0, 0, 15
	vfm	%v0, %v0, %v31, 0, 0
	vfm	%v0, %v31, %v0, 0, 0
	vfm	%v31, %v0, %v0, 0, 0
	vfm	%v18, %v3, %v20, 11, 9

#CHECK: vfma    %v0, %v0, %v0, %v0, 0, 0  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8f]
#CHECK: vfma    %v0, %v0, %v0, %v0, 0, 15 # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x8f]
#CHECK: vfma    %v0, %v0, %v0, %v0, 15, 0 # encoding: [0xe7,0x00,0x00,0x0f,0x00,0x8f]
#CHECK: vfma    %v0, %v0, %v0, %v31, 0, 0 # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8f]
#CHECK: vfma    %v0, %v0, %v31, %v0, 0, 0 # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8f]
#CHECK: vfma    %v0, %v31, %v0, %v0, 0, 0 # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8f]
#CHECK: vfma    %v31, %v0, %v0, %v0, 0, 0 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8f]
#CHECK: vfma    %v13, %v17, %v21, %v25, 9, 11 # encoding: [0xe7,0xd1,0x5b,0x09,0x97,0x8f]

	vfma	%v0, %v0, %v0, %v0, 0, 0
	vfma	%v0, %v0, %v0, %v0, 0, 15
	vfma	%v0, %v0, %v0, %v0, 15, 0
	vfma	%v0, %v0, %v0, %v31, 0, 0
	vfma	%v0, %v0, %v31, %v0, 0, 0
	vfma	%v0, %v31, %v0, %v0, 0, 0
	vfma	%v31, %v0, %v0, %v0, 0, 0
	vfma	%v13, %v17, %v21, %v25, 9, 11

#CHECK: vfmadb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0x8f]
#CHECK: vfmadb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0x8f]
#CHECK: vfmadb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0x8f]
#CHECK: vfmadb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0x8f]
#CHECK: vfmadb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0x8f]
#CHECK: vfmadb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0x8f]

	vfmadb	%v0, %v0, %v0, %v0
	vfmadb	%v0, %v0, %v0, %v31
	vfmadb	%v0, %v0, %v31, %v0
	vfmadb	%v0, %v31, %v0, %v0
	vfmadb	%v31, %v0, %v0, %v0
	vfmadb	%v13, %v17, %v21, %v25

#CHECK: vfmdb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xe7]
#CHECK: vfmdb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xe7]
#CHECK: vfmdb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xe7]
#CHECK: vfmdb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xe7]
#CHECK: vfmdb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xe7]

	vfmdb	%v0, %v0, %v0
	vfmdb	%v0, %v0, %v31
	vfmdb	%v0, %v31, %v0
	vfmdb	%v31, %v0, %v0
	vfmdb	%v18, %v3, %v20

#CHECK: vfms    %v0, %v0, %v0, %v0, 0, 0  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8e]
#CHECK: vfms    %v0, %v0, %v0, %v0, 0, 15 # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x8e]
#CHECK: vfms    %v0, %v0, %v0, %v0, 15, 0 # encoding: [0xe7,0x00,0x00,0x0f,0x00,0x8e]
#CHECK: vfms    %v0, %v0, %v0, %v31, 0, 0 # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8e]
#CHECK: vfms    %v0, %v0, %v31, %v0, 0, 0 # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8e]
#CHECK: vfms    %v0, %v31, %v0, %v0, 0, 0 # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8e]
#CHECK: vfms    %v31, %v0, %v0, %v0, 0, 0 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8e]
#CHECK: vfms    %v13, %v17, %v21, %v25, 9, 11 # encoding: [0xe7,0xd1,0x5b,0x09,0x97,0x8e]

	vfms	%v0, %v0, %v0, %v0, 0, 0
	vfms	%v0, %v0, %v0, %v0, 0, 15
	vfms	%v0, %v0, %v0, %v0, 15, 0
	vfms	%v0, %v0, %v0, %v31, 0, 0
	vfms	%v0, %v0, %v31, %v0, 0, 0
	vfms	%v0, %v31, %v0, %v0, 0, 0
	vfms	%v31, %v0, %v0, %v0, 0, 0
	vfms	%v13, %v17, %v21, %v25, 9, 11

#CHECK: vfmsdb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0x8e]
#CHECK: vfmsdb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0x8e]
#CHECK: vfmsdb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0x8e]
#CHECK: vfmsdb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0x8e]
#CHECK: vfmsdb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0x8e]
#CHECK: vfmsdb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0x8e]

	vfmsdb	%v0, %v0, %v0, %v0
	vfmsdb	%v0, %v0, %v0, %v31
	vfmsdb	%v0, %v0, %v31, %v0
	vfmsdb	%v0, %v31, %v0, %v0
	vfmsdb	%v31, %v0, %v0, %v0
	vfmsdb	%v13, %v17, %v21, %v25

#CHECK: vfpso   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xcc]
#CHECK: vfpso   %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xcc]
#CHECK: vfpso   %v0, %v0, 0, 15, 0      # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xcc]
#CHECK: vfpso   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xcc]
#CHECK: vfpso   %v0, %v15, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xcc]
#CHECK: vfpso   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xcc]
#CHECK: vfpso   %v15, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xcc]
#CHECK: vfpso   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xcc]
#CHECK: vfpso   %v14, %v17, 11, 9, 7    # encoding: [0xe7,0xe1,0x00,0x79,0xb4,0xcc]

	vfpso	%v0, %v0, 0, 0, 0
	vfpso	%v0, %v0, 15, 0, 0
	vfpso	%v0, %v0, 0, 15, 0
	vfpso	%v0, %v0, 0, 0, 15
	vfpso	%v0, %v15, 0, 0, 0
	vfpso	%v0, %v31, 0, 0, 0
	vfpso	%v15, %v0, 0, 0, 0
	vfpso	%v31, %v0, 0, 0, 0
	vfpso	%v14, %v17, 11, 9, 7

#CHECK: vfpsodb %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xcc]
#CHECK: vfpsodb %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xcc]
#CHECK: vfpsodb %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xcc]
#CHECK: vfpsodb %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xcc]
#CHECK: vfpsodb %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xcc]
#CHECK: vfpsodb %v14, %v17, 7           # encoding: [0xe7,0xe1,0x00,0x70,0x34,0xcc]

	vfpsodb	%v0, %v0, 0
	vfpsodb	%v0, %v0, 15
	vfpsodb	%v0, %v15, 0
	vfpsodb	%v0, %v31, 0
	vfpsodb	%v15, %v0, 0
	vfpsodb	%v31, %v0, 0
	vfpsodb	%v14, %v17, 7

#CHECK: vfs     %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0xe2]
#CHECK: vfs     %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xe2]
#CHECK: vfs     %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xe2]
#CHECK: vfs     %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xe2]
#CHECK: vfs     %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xe2]
#CHECK: vfs     %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xe2]
#CHECK: vfs     %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x09,0xba,0xe2]

	vfs	%v0, %v0, %v0, 0, 0
	vfs	%v0, %v0, %v0, 15, 0
	vfs	%v0, %v0, %v0, 0, 15
	vfs	%v0, %v0, %v31, 0, 0
	vfs	%v0, %v31, %v0, 0, 0
	vfs	%v31, %v0, %v0, 0, 0
	vfs	%v18, %v3, %v20, 11, 9

#CHECK: vfsdb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xe2]
#CHECK: vfsdb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xe2]
#CHECK: vfsdb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xe2]
#CHECK: vfsdb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xe2]
#CHECK: vfsdb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xe2]

	vfsdb	%v0, %v0, %v0
	vfsdb	%v0, %v0, %v31
	vfsdb	%v0, %v31, %v0
	vfsdb	%v31, %v0, %v0
	vfsdb	%v18, %v3, %v20

#CHECK: vfsq    %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0xce]
#CHECK: vfsq    %v0, %v0, 15, 0         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xce]
#CHECK: vfsq    %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xce]
#CHECK: vfsq    %v0, %v15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xce]
#CHECK: vfsq    %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xce]
#CHECK: vfsq    %v15, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xce]
#CHECK: vfsq    %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xce]
#CHECK: vfsq    %v14, %v17, 11, 9       # encoding: [0xe7,0xe1,0x00,0x09,0xb4,0xce]

	vfsq	%v0, %v0, 0, 0
	vfsq	%v0, %v0, 15, 0
	vfsq	%v0, %v0, 0, 15
	vfsq	%v0, %v15, 0, 0
	vfsq	%v0, %v31, 0, 0
	vfsq	%v15, %v0, 0, 0
	vfsq	%v31, %v0, 0, 0
	vfsq	%v14, %v17, 11, 9

#CHECK: vfsqdb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xce]
#CHECK: vfsqdb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xce]
#CHECK: vfsqdb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xce]
#CHECK: vfsqdb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xce]
#CHECK: vfsqdb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xce]
#CHECK: vfsqdb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xce]

	vfsqdb	%v0, %v0
	vfsqdb	%v0, %v15
	vfsqdb	%v0, %v31
	vfsqdb	%v15, %v0
	vfsqdb	%v31, %v0
	vfsqdb	%v14, %v17

#CHECK: vftci   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x4a]
#CHECK: vftci   %v0, %v0, 0, 15, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x4a]
#CHECK: vftci   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0x0f,0x00,0x4a]
#CHECK: vftci   %v0, %v0, 4095, 0, 0    # encoding: [0xe7,0x00,0xff,0xf0,0x00,0x4a]
#CHECK: vftci   %v0, %v15, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x4a]
#CHECK: vftci   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x4a]
#CHECK: vftci   %v15, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x4a]
#CHECK: vftci   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x4a]
#CHECK: vftci   %v4, %v21, 1656, 11, 9  # encoding: [0xe7,0x45,0x67,0x89,0xb4,0x4a]

	vftci	%v0, %v0, 0, 0, 0
	vftci	%v0, %v0, 0, 15, 0
	vftci	%v0, %v0, 0, 0, 15
	vftci	%v0, %v0, 4095, 0, 0
	vftci	%v0, %v15, 0, 0, 0
	vftci	%v0, %v31, 0, 0, 0
	vftci	%v15, %v0, 0, 0, 0
	vftci	%v31, %v0, 0, 0, 0
	vftci	%v4, %v21, 0x678, 11, 9

#CHECK: vftcidb %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x4a]
#CHECK: vftcidb %v0, %v0, 4095          # encoding: [0xe7,0x00,0xff,0xf0,0x30,0x4a]
#CHECK: vftcidb %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x4a]
#CHECK: vftcidb %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x4a]
#CHECK: vftcidb %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x4a]
#CHECK: vftcidb %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x4a]
#CHECK: vftcidb %v4, %v21, 1656         # encoding: [0xe7,0x45,0x67,0x80,0x34,0x4a]

	vftcidb	%v0, %v0, 0
	vftcidb	%v0, %v0, 4095
	vftcidb	%v0, %v15, 0
	vftcidb	%v0, %v31, 0
	vftcidb	%v15, %v0, 0
	vftcidb	%v31, %v0, 0
	vftcidb	%v4, %v21, 0x678

#CHECK: vgbm    %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x44]
#CHECK: vgbm    %v0, 65535              # encoding: [0xe7,0x00,0xff,0xff,0x00,0x44]
#CHECK: vgbm    %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x44]
#CHECK: vgbm    %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x44]
#CHECK: vgbm    %v17, 4660              # encoding: [0xe7,0x10,0x12,0x34,0x08,0x44]

	vgbm	%v0, 0
	vgbm	%v0, 0xffff
	vgbm	%v15, 0
	vgbm	%v31, 0
	vgbm	%v17, 0x1234

#CHECK: vgef    %v0, 0(%v0,0), 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v0,%r1), 3      # encoding: [0xe7,0x00,0x10,0x00,0x30,0x13]
#CHECK: vgef    %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v31,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x04,0x13]
#CHECK: vgef    %v0, 4095(%v0,%r1), 0   # encoding: [0xe7,0x00,0x1f,0xff,0x00,0x13]
#CHECK: vgef    %v15, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v31, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x08,0x13]
#CHECK: vgef    %v10, 1000(%v19,%r7), 1 # encoding: [0xe7,0xa3,0x73,0xe8,0x14,0x13]
#CHECK: vgef    %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v0,%r1), 3      # encoding: [0xe7,0x00,0x10,0x00,0x30,0x13]
#CHECK: vgef    %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v0,0), 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v0,%r1), 3      # encoding: [0xe7,0x00,0x10,0x00,0x30,0x13]
#CHECK: vgef    %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v0, 0(%v31,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x04,0x13]
#CHECK: vgef    %v0, 4095(%v0,%r1), 0   # encoding: [0xe7,0x00,0x1f,0xff,0x00,0x13]
#CHECK: vgef    %v15, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x00,0x13]
#CHECK: vgef    %v31, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x08,0x13]
#CHECK: vgef    %v10, 1000(%v19,%r7), 1 # encoding: [0xe7,0xa3,0x73,0xe8,0x14,0x13]

	vgef	%v0, 0(%v0), 0
	vgef	%v0, 0(%v0,%r1), 0
	vgef	%v0, 0(%v0,%r1), 3
	vgef	%v0, 0(%v0,%r15), 0
	vgef	%v0, 0(%v15,%r1), 0
	vgef	%v0, 0(%v31,%r1), 0
	vgef	%v0, 4095(%v0, %r1), 0
	vgef	%v15, 0(%v0,%r1), 0
	vgef	%v31, 0(%v0,%r1), 0
	vgef	%v10, 1000(%v19,%r7), 1
	vgef	%v0, 0(0,%r1), 0
	vgef	%v0, 0(%v0,1), 3
	vgef	%v0, 0(0,%r15), 0
	vgef	%v0, 0(%v15,1), 0
	vgef	0, 0(0), 0
	vgef	0, 0(0,1), 0
	vgef	0, 0(0,1), 3
	vgef	0, 0(0,15), 0
	vgef	0, 0(15,1), 0
	vgef	0, 0(31,1), 0
	vgef	0, 4095(0, 1), 0
	vgef	15, 0(0,1), 0
	vgef	31, 0(0,1), 0
	vgef	10, 1000(19,7), 1

#CHECK: vgeg    %v0, 0(%v0,0), 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r1), 1      # encoding: [0xe7,0x00,0x10,0x00,0x10,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v31,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x04,0x12]
#CHECK: vgeg    %v0, 4095(%v0,%r1), 0   # encoding: [0xe7,0x00,0x1f,0xff,0x00,0x12]
#CHECK: vgeg    %v15, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v31, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x08,0x12]
#CHECK: vgeg    %v10, 1000(%v19,%r7), 1 # encoding: [0xe7,0xa3,0x73,0xe8,0x14,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r1), 1      # encoding: [0xe7,0x00,0x10,0x00,0x10,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v0,0), 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r1), 1      # encoding: [0xe7,0x00,0x10,0x00,0x10,0x12]
#CHECK: vgeg    %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v0, 0(%v31,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x04,0x12]
#CHECK: vgeg    %v0, 4095(%v0,%r1), 0   # encoding: [0xe7,0x00,0x1f,0xff,0x00,0x12]
#CHECK: vgeg    %v15, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x00,0x12]
#CHECK: vgeg    %v31, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x08,0x12]
#CHECK: vgeg    %v10, 1000(%v19,%r7), 1 # encoding: [0xe7,0xa3,0x73,0xe8,0x14,0x12]

	vgeg	%v0, 0(%v0), 0
	vgeg	%v0, 0(%v0,%r1), 0
	vgeg	%v0, 0(%v0,%r1), 1
	vgeg	%v0, 0(%v0,%r15), 0
	vgeg	%v0, 0(%v15,%r1), 0
	vgeg	%v0, 0(%v31,%r1), 0
	vgeg	%v0, 4095(%v0,%r1), 0
	vgeg	%v15, 0(%v0,%r1), 0
	vgeg	%v31, 0(%v0,%r1), 0
	vgeg	%v10, 1000(%v19,%r7), 1
	vgeg	%v0, 0(0,%r1), 0
	vgeg	%v0, 0(%v0,1), 1
	vgeg	%v0, 0(0,%r15), 0
	vgeg	%v0, 0(%v15,1), 0
	vgeg	0, 0(0), 0
	vgeg	0, 0(0,1), 0
	vgeg	0, 0(0,1), 1
	vgeg	0, 0(0,15), 0
	vgeg	0, 0(15,1), 0
	vgeg	0, 0(31,1), 0
	vgeg	0, 4095(0,1), 0
	vgeg	15, 0(0,1), 0
	vgeg	31, 0(0,1), 0
	vgeg	10, 1000(19,7), 1


#CHECK: vgfm    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb4]
#CHECK: vgfm    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xb4]
#CHECK: vgfm    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb4]
#CHECK: vgfm    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb4]
#CHECK: vgfm    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb4]
#CHECK: vgfm    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xb4]

	vgfm	%v0, %v0, %v0, 0
	vgfm	%v0, %v0, %v0, 15
	vgfm	%v0, %v0, %v31, 0
	vgfm	%v0, %v31, %v0, 0
	vgfm	%v31, %v0, %v0, 0
	vgfm	%v18, %v3, %v20, 11

#CHECK: vgfma   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xbc]
#CHECK: vgfma   %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xbc]
#CHECK: vgfma   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xbc]
#CHECK: vgfma   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xbc]
#CHECK: vgfma   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xbc]
#CHECK: vgfma   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xbc]
#CHECK: vgfma   %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xbc]

	vgfma	%v0, %v0, %v0, %v0, 0
	vgfma	%v0, %v0, %v0, %v0, 15
	vgfma	%v0, %v0, %v0, %v31, 0
	vgfma	%v0, %v0, %v31, %v0, 0
	vgfma	%v0, %v31, %v0, %v0, 0
	vgfma	%v31, %v0, %v0, %v0, 0
	vgfma	%v13, %v17, %v21, %v25, 11

#CHECK: vgfmab  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xbc]
#CHECK: vgfmab  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xbc]
#CHECK: vgfmab  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xbc]
#CHECK: vgfmab  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xbc]
#CHECK: vgfmab  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xbc]
#CHECK: vgfmab  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xbc]

	vgfmab	%v0, %v0, %v0, %v0
	vgfmab	%v0, %v0, %v0, %v31
	vgfmab	%v0, %v0, %v31, %v0
	vgfmab	%v0, %v31, %v0, %v0
	vgfmab	%v31, %v0, %v0, %v0
	vgfmab	%v13, %v17, %v21, %v25

#CHECK: vgfmaf  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xbc]
#CHECK: vgfmaf  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xbc]
#CHECK: vgfmaf  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xbc]
#CHECK: vgfmaf  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xbc]
#CHECK: vgfmaf  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xbc]
#CHECK: vgfmaf  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xbc]

	vgfmaf	%v0, %v0, %v0, %v0
	vgfmaf	%v0, %v0, %v0, %v31
	vgfmaf	%v0, %v0, %v31, %v0
	vgfmaf	%v0, %v31, %v0, %v0
	vgfmaf	%v31, %v0, %v0, %v0
	vgfmaf	%v13, %v17, %v21, %v25

#CHECK: vgfmag  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x03,0x00,0x00,0xbc]
#CHECK: vgfmag  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x03,0x00,0xf1,0xbc]
#CHECK: vgfmag  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf3,0x00,0x02,0xbc]
#CHECK: vgfmag  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x03,0x00,0x04,0xbc]
#CHECK: vgfmag  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x03,0x00,0x08,0xbc]
#CHECK: vgfmag  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x00,0x97,0xbc]

	vgfmag	%v0, %v0, %v0, %v0
	vgfmag	%v0, %v0, %v0, %v31
	vgfmag	%v0, %v0, %v31, %v0
	vgfmag	%v0, %v31, %v0, %v0
	vgfmag	%v31, %v0, %v0, %v0
	vgfmag	%v13, %v17, %v21, %v25

#CHECK: vgfmah  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xbc]
#CHECK: vgfmah  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xbc]
#CHECK: vgfmah  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xbc]
#CHECK: vgfmah  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xbc]
#CHECK: vgfmah  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xbc]
#CHECK: vgfmah  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xbc]

	vgfmah	%v0, %v0, %v0, %v0
	vgfmah	%v0, %v0, %v0, %v31
	vgfmah	%v0, %v0, %v31, %v0
	vgfmah	%v0, %v31, %v0, %v0
	vgfmah	%v31, %v0, %v0, %v0
	vgfmah	%v13, %v17, %v21, %v25

#CHECK: vgfmb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xb4]
#CHECK: vgfmb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xb4]
#CHECK: vgfmb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xb4]
#CHECK: vgfmb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xb4]
#CHECK: vgfmb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xb4]

	vgfmb	%v0, %v0, %v0
	vgfmb	%v0, %v0, %v31
	vgfmb	%v0, %v31, %v0
	vgfmb	%v31, %v0, %v0
	vgfmb	%v18, %v3, %v20

#CHECK: vgfmf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xb4]
#CHECK: vgfmf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xb4]
#CHECK: vgfmf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xb4]
#CHECK: vgfmf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xb4]
#CHECK: vgfmf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xb4]

	vgfmf	%v0, %v0, %v0
	vgfmf	%v0, %v0, %v31
	vgfmf	%v0, %v31, %v0
	vgfmf	%v31, %v0, %v0
	vgfmf	%v18, %v3, %v20

#CHECK: vgfmg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xb4]
#CHECK: vgfmg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xb4]
#CHECK: vgfmg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xb4]
#CHECK: vgfmg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xb4]
#CHECK: vgfmg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xb4]

	vgfmg	%v0, %v0, %v0
	vgfmg	%v0, %v0, %v31
	vgfmg	%v0, %v31, %v0
	vgfmg	%v31, %v0, %v0
	vgfmg	%v18, %v3, %v20

#CHECK: vgfmh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xb4]
#CHECK: vgfmh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xb4]
#CHECK: vgfmh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xb4]
#CHECK: vgfmh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xb4]
#CHECK: vgfmh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xb4]

	vgfmh	%v0, %v0, %v0
	vgfmh	%v0, %v0, %v31
	vgfmh	%v0, %v31, %v0
	vgfmh	%v31, %v0, %v0
	vgfmh	%v18, %v3, %v20

#CHECK: vgm     %v0, 0, 0, 0            # encoding: [0xe7,0x00,0x00,0x00,0x00,0x46]
#CHECK: vgm     %v0, 0, 0, 15           # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x46]
#CHECK: vgm     %v0, 0, 255, 0          # encoding: [0xe7,0x00,0x00,0xff,0x00,0x46]
#CHECK: vgm     %v0, 255, 0, 0          # encoding: [0xe7,0x00,0xff,0x00,0x00,0x46]
#CHECK: vgm     %v15, 0, 0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x46]
#CHECK: vgm     %v31, 0, 0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x46]
#CHECK: vgm     %v21, 2, 3, 11          # encoding: [0xe7,0x50,0x02,0x03,0xb8,0x46]

	vgm	%v0, 0, 0, 0
	vgm	%v0, 0, 0, 15
	vgm	%v0, 0, 255, 0
	vgm	%v0, 255, 0, 0
	vgm	%v15, 0, 0, 0
	vgm	%v31, 0, 0, 0
	vgm	%v21, 2, 3, 11

#CHECK: vgmb    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x46]
#CHECK: vgmb    %v0, 0, 255             # encoding: [0xe7,0x00,0x00,0xff,0x00,0x46]
#CHECK: vgmb    %v0, 255, 0             # encoding: [0xe7,0x00,0xff,0x00,0x00,0x46]
#CHECK: vgmb    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x46]
#CHECK: vgmb    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x46]
#CHECK: vgmb    %v21, 2, 3              # encoding: [0xe7,0x50,0x02,0x03,0x08,0x46]

	vgmb	%v0, 0, 0
	vgmb	%v0, 0, 255
	vgmb	%v0, 255, 0
	vgmb	%v15, 0, 0
	vgmb	%v31, 0, 0
	vgmb	%v21, 2, 3

#CHECK: vgmf    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x20,0x46]
#CHECK: vgmf    %v0, 0, 255             # encoding: [0xe7,0x00,0x00,0xff,0x20,0x46]
#CHECK: vgmf    %v0, 255, 0             # encoding: [0xe7,0x00,0xff,0x00,0x20,0x46]
#CHECK: vgmf    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x46]
#CHECK: vgmf    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x46]
#CHECK: vgmf    %v21, 2, 3              # encoding: [0xe7,0x50,0x02,0x03,0x28,0x46]

	vgmf	%v0, 0, 0
	vgmf	%v0, 0, 255
	vgmf	%v0, 255, 0
	vgmf	%v15, 0, 0
	vgmf	%v31, 0, 0
	vgmf	%v21, 2, 3

#CHECK: vgmg    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x30,0x46]
#CHECK: vgmg    %v0, 0, 255             # encoding: [0xe7,0x00,0x00,0xff,0x30,0x46]
#CHECK: vgmg    %v0, 255, 0             # encoding: [0xe7,0x00,0xff,0x00,0x30,0x46]
#CHECK: vgmg    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x46]
#CHECK: vgmg    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x46]
#CHECK: vgmg    %v21, 2, 3              # encoding: [0xe7,0x50,0x02,0x03,0x38,0x46]

	vgmg	%v0, 0, 0
	vgmg	%v0, 0, 255
	vgmg	%v0, 255, 0
	vgmg	%v15, 0, 0
	vgmg	%v31, 0, 0
	vgmg	%v21, 2, 3

#CHECK: vgmh    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x10,0x46]
#CHECK: vgmh    %v0, 0, 255             # encoding: [0xe7,0x00,0x00,0xff,0x10,0x46]
#CHECK: vgmh    %v0, 255, 0             # encoding: [0xe7,0x00,0xff,0x00,0x10,0x46]
#CHECK: vgmh    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x46]
#CHECK: vgmh    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x46]
#CHECK: vgmh    %v21, 2, 3              # encoding: [0xe7,0x50,0x02,0x03,0x18,0x46]

	vgmh	%v0, 0, 0
	vgmh	%v0, 0, 255
	vgmh	%v0, 255, 0
	vgmh	%v15, 0, 0
	vgmh	%v31, 0, 0
	vgmh	%v21, 2, 3

#CHECK: vistr    %v0, %v0, 0, 0         # encoding: [0xe7,0x00,0x00,0x00,0x00,0x5c]
#CHECK: vistr    %v0, %v0, 15, 0        # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x5c]
#CHECK: vistr    %v0, %v0, 0, 0         # encoding: [0xe7,0x00,0x00,0x00,0x00,0x5c]
#CHECK: vistr    %v0, %v0, 15, 0        # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x5c]
#CHECK: vistr    %v0, %v0, 0, 12        # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x5c]
#CHECK: vistr    %v0, %v15, 0, 0        # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x5c]
#CHECK: vistr    %v0, %v31, 0, 0        # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x5c]
#CHECK: vistr    %v15, %v0, 0, 0        # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x5c]
#CHECK: vistr    %v31, %v0, 0, 0        # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x5c]
#CHECK: vistr    %v18, %v3, 11, 9       # encoding: [0xe7,0x23,0x00,0x90,0xb8,0x5c]

	vistr    %v0, %v0, 0
	vistr    %v0, %v0, 15
	vistr    %v0, %v0, 0, 0
	vistr    %v0, %v0, 15, 0
	vistr    %v0, %v0, 0, 12
	vistr    %v0, %v15, 0
	vistr    %v0, %v31, 0
	vistr    %v15, %v0, 0
	vistr    %v31, %v0, 0
	vistr    %v18, %v3, 11, 9

#CHECK: vistrb   %v0, %v0, 0            # encoding: [0xe7,0x00,0x00,0x00,0x00,0x5c]
#CHECK: vistrb   %v0, %v0, 0            # encoding: [0xe7,0x00,0x00,0x00,0x00,0x5c]
#CHECK: vistrb   %v0, %v0, 12           # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x5c]
#CHECK: vistrb   %v0, %v15, 0           # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x5c]
#CHECK: vistrb   %v0, %v31, 0           # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x5c]
#CHECK: vistrb   %v15, %v0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x5c]
#CHECK: vistrb   %v31, %v0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x5c]
#CHECK: vistrb   %v18, %v3, 0           # encoding: [0xe7,0x23,0x00,0x00,0x08,0x5c]
#CHECK: vistrbs  %v5, %v22              # encoding: [0xe7,0x56,0x00,0x10,0x04,0x5c]

	vistrb   %v0, %v0
	vistrb   %v0, %v0, 0
	vistrb   %v0, %v0, 12
	vistrb   %v0, %v15
	vistrb   %v0, %v31
	vistrb   %v15, %v0
	vistrb   %v31, %v0
	vistrb   %v18, %v3
	vistrbs  %v5, %v22

#CHECK: vistrf   %v0, %v0, 0            # encoding: [0xe7,0x00,0x00,0x00,0x20,0x5c]
#CHECK: vistrf   %v0, %v0, 0            # encoding: [0xe7,0x00,0x00,0x00,0x20,0x5c]
#CHECK: vistrf   %v0, %v0, 12           # encoding: [0xe7,0x00,0x00,0xc0,0x20,0x5c]
#CHECK: vistrf   %v0, %v15, 0           # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x5c]
#CHECK: vistrf   %v0, %v31, 0           # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x5c]
#CHECK: vistrf   %v15, %v0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x5c]
#CHECK: vistrf   %v31, %v0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x5c]
#CHECK: vistrf   %v18, %v3, 0           # encoding: [0xe7,0x23,0x00,0x00,0x28,0x5c]
#CHECK: vistrfs  %v5, %v22              # encoding: [0xe7,0x56,0x00,0x10,0x24,0x5c]

	vistrf   %v0, %v0
	vistrf   %v0, %v0, 0
	vistrf   %v0, %v0, 12
	vistrf   %v0, %v15
	vistrf   %v0, %v31
	vistrf   %v15, %v0
	vistrf   %v31, %v0
	vistrf   %v18, %v3
	vistrfs  %v5, %v22

#CHECK: vistrh   %v0, %v0, 0            # encoding: [0xe7,0x00,0x00,0x00,0x10,0x5c]
#CHECK: vistrh   %v0, %v0, 0            # encoding: [0xe7,0x00,0x00,0x00,0x10,0x5c]
#CHECK: vistrh   %v0, %v0, 12           # encoding: [0xe7,0x00,0x00,0xc0,0x10,0x5c]
#CHECK: vistrh   %v0, %v15, 0           # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x5c]
#CHECK: vistrh   %v0, %v31, 0           # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x5c]
#CHECK: vistrh   %v15, %v0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x5c]
#CHECK: vistrh   %v31, %v0, 0           # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x5c]
#CHECK: vistrh   %v18, %v3, 0           # encoding: [0xe7,0x23,0x00,0x00,0x18,0x5c]
#CHECK: vistrhs  %v5, %v22              # encoding: [0xe7,0x56,0x00,0x10,0x14,0x5c]

	vistrh   %v0, %v0
	vistrh   %v0, %v0, 0
	vistrh   %v0, %v0, 12
	vistrh   %v0, %v15
	vistrh   %v0, %v31
	vistrh   %v15, %v0
	vistrh   %v31, %v0
	vistrh   %v18, %v3
	vistrhs  %v5, %v22

#CHECK: vl      %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x06]
#CHECK: vl      %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x06]
#CHECK: vl      %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x06]
#CHECK: vl      %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x06]
#CHECK: vl      %v0, 0(%r15,%r1), 4     # encoding: [0xe7,0x0f,0x10,0x00,0x40,0x06]
#CHECK: vl      %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x06]
#CHECK: vl      %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x06]
#CHECK: vl      %v18, 1383(%r3,%r4), 3  # encoding: [0xe7,0x23,0x45,0x67,0x38,0x06]

	vl	%v0, 0
	vl	%v0, 4095
	vl	%v0, 0(%r15)
	vl	%v0, 0(%r15,%r1)
	vl	%v0, 0(%r15,%r1), 4
	vl	%v15, 0
	vl	%v31, 0
	vl	%v18, 0x567(%r3,%r4), 3

#CHECK: vlbb    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x07]
#CHECK: vlbb    %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x07]
#CHECK: vlbb    %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x07]
#CHECK: vlbb    %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x07]
#CHECK: vlbb    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x07]
#CHECK: vlbb    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x07]
#CHECK: vlbb    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x07]
#CHECK: vlbb    %v18, 1383(%r3,%r4), 8  # encoding: [0xe7,0x23,0x45,0x67,0x88,0x07]
#CHECK: vlbb    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x07]
#CHECK: vlbb    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x07]
#CHECK: vlbb    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x07]
#CHECK: vlbb    %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x07]
#CHECK: vlbb    %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x07]
#CHECK: vlbb    %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x07]
#CHECK: vlbb    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x07]
#CHECK: vlbb    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x07]
#CHECK: vlbb    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x07]
#CHECK: vlbb    %v18, 1383(%r3,%r4), 8  # encoding: [0xe7,0x23,0x45,0x67,0x88,0x07]

	vlbb	%v0, 0, 0
	vlbb	%v0, 0, 15
	vlbb	%v0, 4095, 0
	vlbb	%v0, 0(%r15), 0
	vlbb	%v0, 0(%r15,%r1), 0
	vlbb	%v15, 0, 0
	vlbb	%v31, 0, 0
	vlbb	%v18, 1383(%r3,%r4), 8
	vlbb	%v18, 1383(%r3, 4), 8
	vlbb	%v0, 0(15,%r1), 0
	vlbb	%v0, 0(%r15,1), 0
	vlbb	0, 0, 0
	vlbb	0, 0, 15
	vlbb	0, 4095, 0
	vlbb	0, 0(15), 0
	vlbb	0, 0(15,1), 0
	vlbb	15, 0, 0
	vlbb	31, 0, 0
	vlbb	18, 1383(3,4), 8

#CHECK: vlc     %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xde]
#CHECK: vlc     %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xde]
#CHECK: vlc     %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xde]
#CHECK: vlc     %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xde]
#CHECK: vlc     %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xde]
#CHECK: vlc     %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xde]
#CHECK: vlc     %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xde]

	vlc	%v0, %v0, 0
	vlc	%v0, %v0, 15
	vlc	%v0, %v15, 0
	vlc	%v0, %v31, 0
	vlc	%v15, %v0, 0
	vlc	%v31, %v0, 0
	vlc	%v14, %v17, 11

#CHECK: vlcb    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xde]
#CHECK: vlcb    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xde]
#CHECK: vlcb    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xde]
#CHECK: vlcb    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xde]
#CHECK: vlcb    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xde]
#CHECK: vlcb    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xde]

	vlcb	%v0, %v0
	vlcb	%v0, %v15
	vlcb	%v0, %v31
	vlcb	%v15, %v0
	vlcb	%v31, %v0
	vlcb	%v14, %v17

#CHECK: vlcf    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xde]
#CHECK: vlcf    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xde]
#CHECK: vlcf    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xde]
#CHECK: vlcf    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xde]
#CHECK: vlcf    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xde]
#CHECK: vlcf    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xde]

	vlcf	%v0, %v0
	vlcf	%v0, %v15
	vlcf	%v0, %v31
	vlcf	%v15, %v0
	vlcf	%v31, %v0
	vlcf	%v14, %v17

#CHECK: vlcg    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xde]
#CHECK: vlcg    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xde]
#CHECK: vlcg    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xde]
#CHECK: vlcg    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xde]
#CHECK: vlcg    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xde]
#CHECK: vlcg    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xde]

	vlcg	%v0, %v0
	vlcg	%v0, %v15
	vlcg	%v0, %v31
	vlcg	%v15, %v0
	vlcg	%v31, %v0
	vlcg	%v14, %v17

#CHECK: vlch    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xde]
#CHECK: vlch    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xde]
#CHECK: vlch    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xde]
#CHECK: vlch    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xde]
#CHECK: vlch    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xde]
#CHECK: vlch    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xde]

	vlch	%v0, %v0
	vlch	%v0, %v15
	vlch	%v0, %v31
	vlch	%v15, %v0
	vlch	%v31, %v0
	vlch	%v14, %v17

#CHECK: vlde    %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc4]
#CHECK: vlde    %v0, %v0, 15, 0         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc4]
#CHECK: vlde    %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xc4]
#CHECK: vlde    %v0, %v15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xc4]
#CHECK: vlde    %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc4]
#CHECK: vlde    %v15, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xc4]
#CHECK: vlde    %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc4]
#CHECK: vlde    %v14, %v17, 11, 9       # encoding: [0xe7,0xe1,0x00,0x09,0xb4,0xc4]

	vlde	%v0, %v0, 0, 0
	vlde	%v0, %v0, 15, 0
	vlde	%v0, %v0, 0, 15
	vlde	%v0, %v15, 0, 0
	vlde	%v0, %v31, 0, 0
	vlde	%v15, %v0, 0, 0
	vlde	%v31, %v0, 0, 0
	vlde	%v14, %v17, 11, 9

#CHECK: vldeb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xc4]
#CHECK: vldeb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xc4]
#CHECK: vldeb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xc4]
#CHECK: vldeb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xc4]
#CHECK: vldeb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xc4]
#CHECK: vldeb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xc4]

	vldeb	%v0, %v0
	vldeb	%v0, %v15
	vldeb	%v0, %v31
	vldeb	%v15, %v0
	vldeb	%v31, %v0
	vldeb	%v14, %v17

#CHECK: vleb    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x00]
#CHECK: vleb    %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x00]
#CHECK: vleb    %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x00]
#CHECK: vleb    %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x00]
#CHECK: vleb    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x00]
#CHECK: vleb    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x00]
#CHECK: vleb    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x00]
#CHECK: vleb    %v18, 1383(%r3,%r4), 8  # encoding: [0xe7,0x23,0x45,0x67,0x88,0x00]

	vleb	%v0, 0, 0
	vleb	%v0, 0, 15
	vleb	%v0, 4095, 0
	vleb	%v0, 0(%r15), 0
	vleb	%v0, 0(%r15,%r1), 0
	vleb	%v15, 0, 0
	vleb	%v31, 0, 0
	vleb	%v18, 1383(%r3,%r4), 8

#CHECK: vled    %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc5]
#CHECK: vled    %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc5]
#CHECK: vled    %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc5]
#CHECK: vled    %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc5]
#CHECK: vled    %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc5]
#CHECK: vled    %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc5]
#CHECK: vled    %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc5]
#CHECK: vled    %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc5]

	vled	%v0, %v0, 0, 0, 0
	vled	%v0, %v0, 15, 0, 0
	vled	%v0, %v0, 0, 0, 15
	vled	%v0, %v0, 0, 4, 0
	vled	%v0, %v0, 0, 12, 0
	vled	%v0, %v31, 0, 0, 0
	vled	%v31, %v0, 0, 0, 0
	vled	%v14, %v17, 11, 4, 10

#CHECK: vledb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x30,0xc5]
#CHECK: vledb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x30,0xc5]
#CHECK: vledb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x30,0xc5]
#CHECK: vledb   %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc5]
#CHECK: vledb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xc5]
#CHECK: vledb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xc5]
#CHECK: vledb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x34,0xc5]

	vledb	%v0, %v0, 0, 0
	vledb	%v0, %v0, 0, 15
	vledb	%v0, %v0, 4, 0
	vledb	%v0, %v0, 12, 0
	vledb	%v0, %v31, 0, 0
	vledb	%v31, %v0, 0, 0
	vledb	%v14, %v17, 4, 10

#CHECK: vlef    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x03]
#CHECK: vlef    %v0, 0, 3               # encoding: [0xe7,0x00,0x00,0x00,0x30,0x03]
#CHECK: vlef    %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x03]
#CHECK: vlef    %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x03]
#CHECK: vlef    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x03]
#CHECK: vlef    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x03]
#CHECK: vlef    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x03]
#CHECK: vlef    %v18, 1383(%r3,%r4), 2  # encoding: [0xe7,0x23,0x45,0x67,0x28,0x03]

	vlef	%v0, 0, 0
	vlef	%v0, 0, 3
	vlef	%v0, 4095, 0
	vlef	%v0, 0(%r15), 0
	vlef	%v0, 0(%r15,%r1), 0
	vlef	%v15, 0, 0
	vlef	%v31, 0, 0
	vlef	%v18, 1383(%r3,%r4), 2

#CHECK: vleg    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x02]
#CHECK: vleg    %v0, 0, 1               # encoding: [0xe7,0x00,0x00,0x00,0x10,0x02]
#CHECK: vleg    %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x02]
#CHECK: vleg    %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x02]
#CHECK: vleg    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x02]
#CHECK: vleg    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x02]
#CHECK: vleg    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x02]
#CHECK: vleg    %v18, 1383(%r3,%r4), 1  # encoding: [0xe7,0x23,0x45,0x67,0x18,0x02]

	vleg	%v0, 0, 0
	vleg	%v0, 0, 1
	vleg	%v0, 4095, 0
	vleg	%v0, 0(%r15), 0
	vleg	%v0, 0(%r15,%r1), 0
	vleg	%v15, 0, 0
	vleg	%v31, 0, 0
	vleg	%v18, 1383(%r3,%r4), 1

#CHECK: vleh    %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x01]
#CHECK: vleh    %v0, 0, 7               # encoding: [0xe7,0x00,0x00,0x00,0x70,0x01]
#CHECK: vleh    %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x01]
#CHECK: vleh    %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x01]
#CHECK: vleh    %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x01]
#CHECK: vleh    %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x01]
#CHECK: vleh    %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x01]
#CHECK: vleh    %v18, 1383(%r3,%r4), 4  # encoding: [0xe7,0x23,0x45,0x67,0x48,0x01]

	vleh	%v0, 0, 0
	vleh	%v0, 0, 7
	vleh	%v0, 4095, 0
	vleh	%v0, 0(%r15), 0
	vleh	%v0, 0(%r15,%r1), 0
	vleh	%v15, 0, 0
	vleh	%v31, 0, 0
	vleh	%v18, 1383(%r3,%r4), 4

#CHECK: vleib   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x40]
#CHECK: vleib   %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x40]
#CHECK: vleib   %v0, -32768, 0          # encoding: [0xe7,0x00,0x80,0x00,0x00,0x40]
#CHECK: vleib   %v0, 32767, 0           # encoding: [0xe7,0x00,0x7f,0xff,0x00,0x40]
#CHECK: vleib   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x40]
#CHECK: vleib   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x40]
#CHECK: vleib   %v18, 13398, 11         # encoding: [0xe7,0x20,0x34,0x56,0xb8,0x40]

	vleib	%v0, 0, 0
	vleib	%v0, 0, 15
	vleib	%v0, -32768, 0
	vleib	%v0, 32767, 0
	vleib	%v15, 0, 0
	vleib	%v31, 0, 0
	vleib	%v18, 0x3456, 11

#CHECK: vleif   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x43]
#CHECK: vleif   %v0, 0, 3               # encoding: [0xe7,0x00,0x00,0x00,0x30,0x43]
#CHECK: vleif   %v0, -32768, 0          # encoding: [0xe7,0x00,0x80,0x00,0x00,0x43]
#CHECK: vleif   %v0, 32767, 0           # encoding: [0xe7,0x00,0x7f,0xff,0x00,0x43]
#CHECK: vleif   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x43]
#CHECK: vleif   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x43]
#CHECK: vleif   %v18, 13398, 3          # encoding: [0xe7,0x20,0x34,0x56,0x38,0x43]

	vleif	%v0, 0, 0
	vleif	%v0, 0, 3
	vleif	%v0, -32768, 0
	vleif	%v0, 32767, 0
	vleif	%v15, 0, 0
	vleif	%v31, 0, 0
	vleif	%v18, 0x3456, 3

#CHECK: vleig   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x42]
#CHECK: vleig   %v0, 0, 1               # encoding: [0xe7,0x00,0x00,0x00,0x10,0x42]
#CHECK: vleig   %v0, -32768, 0          # encoding: [0xe7,0x00,0x80,0x00,0x00,0x42]
#CHECK: vleig   %v0, 32767, 0           # encoding: [0xe7,0x00,0x7f,0xff,0x00,0x42]
#CHECK: vleig   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x42]
#CHECK: vleig   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x42]
#CHECK: vleig   %v18, 13398, 1          # encoding: [0xe7,0x20,0x34,0x56,0x18,0x42]

	vleig	%v0, 0, 0
	vleig	%v0, 0, 1
	vleig	%v0, -32768, 0
	vleig	%v0, 32767, 0
	vleig	%v15, 0, 0
	vleig	%v31, 0, 0
	vleig	%v18, 0x3456, 1

#CHECK: vleih   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x41]
#CHECK: vleih   %v0, 0, 7               # encoding: [0xe7,0x00,0x00,0x00,0x70,0x41]
#CHECK: vleih   %v0, -32768, 0          # encoding: [0xe7,0x00,0x80,0x00,0x00,0x41]
#CHECK: vleih   %v0, 32767, 0           # encoding: [0xe7,0x00,0x7f,0xff,0x00,0x41]
#CHECK: vleih   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x41]
#CHECK: vleih   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x41]
#CHECK: vleih   %v18, 13398, 7          # encoding: [0xe7,0x20,0x34,0x56,0x78,0x41]

	vleih	%v0, 0, 0
	vleih	%v0, 0, 7
	vleih	%v0, -32768, 0
	vleih	%v0, 32767, 0
	vleih	%v15, 0, 0
	vleih	%v31, 0, 0
	vleih	%v18, 0x3456, 7

#CHECK: vlgv    %r0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0x21]
#CHECK: vlgv    %r0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x21]
#CHECK: vlgv    %r0, %v0, 4095, 0       # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x21]
#CHECK: vlgv    %r0, %v0, 0(%r15), 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x21]
#CHECK: vlgv    %r0, %v15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x21]
#CHECK: vlgv    %r0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x21]
#CHECK: vlgv    %r15, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x21]
#CHECK: vlgv    %r2, %v19, 1383(%r4), 11 # encoding: [0xe7,0x23,0x45,0x67,0xb4,0x21]

	vlgv	%r0, %v0, 0, 0
	vlgv	%r0, %v0, 0, 15
	vlgv	%r0, %v0, 4095, 0
	vlgv	%r0, %v0, 0(%r15), 0
	vlgv	%r0, %v15, 0, 0
	vlgv	%r0, %v31, 0, 0
	vlgv	%r15, %v0, 0, 0
	vlgv	%r2, %v19, 1383(%r4), 11

#CHECK: vlgvb   %r0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x21]
#CHECK: vlgvb   %r0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x21]
#CHECK: vlgvb   %r0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x21]
#CHECK: vlgvb   %r0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x21]
#CHECK: vlgvb   %r0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x21]
#CHECK: vlgvb   %r15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x21]
#CHECK: vlgvb   %r2, %v19, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x04,0x21]

	vlgvb	%r0, %v0, 0
	vlgvb	%r0, %v0, 4095
	vlgvb	%r0, %v0, 0(%r15)
	vlgvb	%r0, %v15, 0
	vlgvb	%r0, %v31, 0
	vlgvb	%r15, %v0, 0
	vlgvb	%r2, %v19, 1383(%r4)

#CHECK: vlgvf   %r0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x21]
#CHECK: vlgvf   %r0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x21]
#CHECK: vlgvf   %r0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x21]
#CHECK: vlgvf   %r0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x21]
#CHECK: vlgvf   %r0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x21]
#CHECK: vlgvf   %r15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x21]
#CHECK: vlgvf   %r2, %v19, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x24,0x21]

	vlgvf	%r0, %v0, 0
	vlgvf	%r0, %v0, 4095
	vlgvf	%r0, %v0, 0(%r15)
	vlgvf	%r0, %v15, 0
	vlgvf	%r0, %v31, 0
	vlgvf	%r15, %v0, 0
	vlgvf	%r2, %v19, 1383(%r4)

#CHECK: vlgvg   %r0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x21]
#CHECK: vlgvg   %r0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x21]
#CHECK: vlgvg   %r0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x21]
#CHECK: vlgvg   %r0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x21]
#CHECK: vlgvg   %r0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x21]
#CHECK: vlgvg   %r15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x21]
#CHECK: vlgvg   %r2, %v19, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x34,0x21]

	vlgvg	%r0, %v0, 0
	vlgvg	%r0, %v0, 4095
	vlgvg	%r0, %v0, 0(%r15)
	vlgvg	%r0, %v15, 0
	vlgvg	%r0, %v31, 0
	vlgvg	%r15, %v0, 0
	vlgvg	%r2, %v19, 1383(%r4)

#CHECK: vlgvh   %r0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x10,0x21]
#CHECK: vlgvh   %r0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x21]
#CHECK: vlgvh   %r0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x21]
#CHECK: vlgvh   %r0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x21]
#CHECK: vlgvh   %r0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x21]
#CHECK: vlgvh   %r15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x21]
#CHECK: vlgvh   %r2, %v19, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x14,0x21]

	vlgvh	%r0, %v0, 0
	vlgvh	%r0, %v0, 4095
	vlgvh	%r0, %v0, 0(%r15)
	vlgvh	%r0, %v15, 0
	vlgvh	%r0, %v31, 0
	vlgvh	%r15, %v0, 0
	vlgvh	%r2, %v19, 1383(%r4)

#CHECK: vll     %v0, %r0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x37]
#CHECK: vll     %v0, %r0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x37]
#CHECK: vll     %v0, %r0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x37]
#CHECK: vll     %v0, %r15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x37]
#CHECK: vll     %v15, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x37]
#CHECK: vll     %v31, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x37]
#CHECK: vll     %v18, %r3, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x08,0x37]

	vll	%v0, %r0, 0
	vll	%v0, %r0, 4095
	vll	%v0, %r0, 0(%r15)
	vll	%v0, %r15, 0
	vll	%v15, %r0, 0
	vll	%v31, %r0, 0
	vll	%v18, %r3, 1383(%r4)

#CHECK: vllez   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x04]
#CHECK: vllez   %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x04]
#CHECK: vllez   %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x04]
#CHECK: vllez   %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x04]
#CHECK: vllez   %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x04]
#CHECK: vllez   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x04]
#CHECK: vllez   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x04]
#CHECK: vllez   %v18, 1383(%r3,%r4), 11 # encoding: [0xe7,0x23,0x45,0x67,0xb8,0x04]

	vllez	%v0, 0, 0
	vllez	%v0, 0, 15
	vllez	%v0, 4095, 0
	vllez	%v0, 0(%r15), 0
	vllez	%v0, 0(%r15,%r1), 0
	vllez	%v15, 0, 0
	vllez	%v31, 0, 0
	vllez	%v18, 0x567(%r3,%r4), 11

#CHECK: vllezb  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x04]
#CHECK: vllezb  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x04]
#CHECK: vllezb  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x04]
#CHECK: vllezb  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x04]
#CHECK: vllezb  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x04]
#CHECK: vllezb  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x04]
#CHECK: vllezb  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x08,0x04]

	vllezb	%v0, 0
	vllezb	%v0, 4095
	vllezb	%v0, 0(%r15)
	vllezb	%v0, 0(%r15,%r1)
	vllezb	%v15, 0
	vllezb	%v31, 0
	vllezb	%v18, 0x567(%r3,%r4)

#CHECK: vllezf  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x20,0x04]
#CHECK: vllezf  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x04]
#CHECK: vllezf  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x04]
#CHECK: vllezf  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x20,0x04]
#CHECK: vllezf  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x04]
#CHECK: vllezf  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x04]
#CHECK: vllezf  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x28,0x04]

	vllezf	%v0, 0
	vllezf	%v0, 4095
	vllezf	%v0, 0(%r15)
	vllezf	%v0, 0(%r15,%r1)
	vllezf	%v15, 0
	vllezf	%v31, 0
	vllezf	%v18, 0x567(%r3,%r4)

#CHECK: vllezg  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x30,0x04]
#CHECK: vllezg  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x04]
#CHECK: vllezg  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x04]
#CHECK: vllezg  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x30,0x04]
#CHECK: vllezg  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x04]
#CHECK: vllezg  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x04]
#CHECK: vllezg  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x38,0x04]

	vllezg	%v0, 0
	vllezg	%v0, 4095
	vllezg	%v0, 0(%r15)
	vllezg	%v0, 0(%r15,%r1)
	vllezg	%v15, 0
	vllezg	%v31, 0
	vllezg	%v18, 0x567(%r3,%r4)

#CHECK: vllezh  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x10,0x04]
#CHECK: vllezh  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x04]
#CHECK: vllezh  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x04]
#CHECK: vllezh  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x10,0x04]
#CHECK: vllezh  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x04]
#CHECK: vllezh  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x04]
#CHECK: vllezh  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x18,0x04]

	vllezh	%v0, 0
	vllezh	%v0, 4095
	vllezh	%v0, 0(%r15)
	vllezh	%v0, 0(%r15,%r1)
	vllezh	%v15, 0
	vllezh	%v31, 0
	vllezh	%v18, 0x567(%r3,%r4)

#CHECK: vlm     %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x36]
#CHECK: vlm     %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x36]
#CHECK: vlm     %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x36]
#CHECK: vlm     %v0, %v0, 0(%r15), 4    # encoding: [0xe7,0x00,0xf0,0x00,0x40,0x36]
#CHECK: vlm     %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x36]
#CHECK: vlm     %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x36]
#CHECK: vlm     %v14, %v17, 1074(%r5), 3 # encoding: [0xe7,0xe1,0x54,0x32,0x34,0x36]

	vlm	%v0, %v0, 0
	vlm	%v0, %v0, 4095
	vlm	%v0, %v0, 0(%r15)
	vlm	%v0, %v0, 0(%r15), 4
	vlm	%v0, %v31, 0
	vlm	%v31, %v0, 0
	vlm	%v14, %v17, 1074(%r5), 3

#CHECK: vlp     %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xdf]
#CHECK: vlp     %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xdf]
#CHECK: vlp     %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xdf]
#CHECK: vlp     %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xdf]
#CHECK: vlp     %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xdf]
#CHECK: vlp     %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xdf]
#CHECK: vlp     %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xdf]

	vlp	%v0, %v0, 0
	vlp	%v0, %v0, 15
	vlp	%v0, %v15, 0
	vlp	%v0, %v31, 0
	vlp	%v15, %v0, 0
	vlp	%v31, %v0, 0
	vlp	%v14, %v17, 11

#CHECK: vlpb    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xdf]
#CHECK: vlpb    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xdf]
#CHECK: vlpb    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xdf]
#CHECK: vlpb    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xdf]
#CHECK: vlpb    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xdf]
#CHECK: vlpb    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xdf]

	vlpb	%v0, %v0
	vlpb	%v0, %v15
	vlpb	%v0, %v31
	vlpb	%v15, %v0
	vlpb	%v31, %v0
	vlpb	%v14, %v17

#CHECK: vlpf    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xdf]
#CHECK: vlpf    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xdf]
#CHECK: vlpf    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xdf]
#CHECK: vlpf    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xdf]
#CHECK: vlpf    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xdf]
#CHECK: vlpf    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xdf]

	vlpf	%v0, %v0
	vlpf	%v0, %v15
	vlpf	%v0, %v31
	vlpf	%v15, %v0
	vlpf	%v31, %v0
	vlpf	%v14, %v17

#CHECK: vlpg    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xdf]
#CHECK: vlpg    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xdf]
#CHECK: vlpg    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xdf]
#CHECK: vlpg    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xdf]
#CHECK: vlpg    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xdf]
#CHECK: vlpg    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xdf]

	vlpg	%v0, %v0
	vlpg	%v0, %v15
	vlpg	%v0, %v31
	vlpg	%v15, %v0
	vlpg	%v31, %v0
	vlpg	%v14, %v17

#CHECK: vlph    %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xdf]
#CHECK: vlph    %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xdf]
#CHECK: vlph    %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xdf]
#CHECK: vlph    %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xdf]
#CHECK: vlph    %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xdf]
#CHECK: vlph    %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xdf]

	vlph	%v0, %v0
	vlph	%v0, %v15
	vlph	%v0, %v31
	vlph	%v15, %v0
	vlph	%v31, %v0
	vlph	%v14, %v17

#CHECK: vlr     %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0x56]
#CHECK: vlr     %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x56]
#CHECK: vlr     %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x56]
#CHECK: vlr     %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x56]
#CHECK: vlr     %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x56]
#CHECK: vlr     %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0x56]

	vlr	%v0, %v0
	vlr	%v0, %v15
	vlr	%v0, %v31
	vlr	%v15, %v0
	vlr	%v31, %v0
	vlr	%v14, %v17

#CHECK: vlrep   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x05]
#CHECK: vlrep   %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x05]
#CHECK: vlrep   %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x05]
#CHECK: vlrep   %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x05]
#CHECK: vlrep   %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x05]
#CHECK: vlrep   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x05]
#CHECK: vlrep   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x05]
#CHECK: vlrep   %v18, 1383(%r3,%r4), 11 # encoding: [0xe7,0x23,0x45,0x67,0xb8,0x05]

	vlrep	%v0, 0, 0
	vlrep	%v0, 0, 15
	vlrep	%v0, 4095, 0
	vlrep	%v0, 0(%r15), 0
	vlrep	%v0, 0(%r15,%r1), 0
	vlrep	%v15, 0, 0
	vlrep	%v31, 0, 0
	vlrep	%v18, 0x567(%r3,%r4), 11

#CHECK: vlrepb  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x05]
#CHECK: vlrepb  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x05]
#CHECK: vlrepb  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x05]
#CHECK: vlrepb  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x05]
#CHECK: vlrepb  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x05]
#CHECK: vlrepb  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x05]
#CHECK: vlrepb  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x08,0x05]

	vlrepb	%v0, 0
	vlrepb	%v0, 4095
	vlrepb	%v0, 0(%r15)
	vlrepb	%v0, 0(%r15,%r1)
	vlrepb	%v15, 0
	vlrepb	%v31, 0
	vlrepb	%v18, 0x567(%r3,%r4)

#CHECK: vlrepf  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x20,0x05]
#CHECK: vlrepf  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x05]
#CHECK: vlrepf  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x05]
#CHECK: vlrepf  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x20,0x05]
#CHECK: vlrepf  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x05]
#CHECK: vlrepf  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x05]
#CHECK: vlrepf  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x28,0x05]

	vlrepf	%v0, 0
	vlrepf	%v0, 4095
	vlrepf	%v0, 0(%r15)
	vlrepf	%v0, 0(%r15,%r1)
	vlrepf	%v15, 0
	vlrepf	%v31, 0
	vlrepf	%v18, 0x567(%r3,%r4)

#CHECK: vlrepg  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x30,0x05]
#CHECK: vlrepg  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x05]
#CHECK: vlrepg  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x05]
#CHECK: vlrepg  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x30,0x05]
#CHECK: vlrepg  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x05]
#CHECK: vlrepg  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x05]
#CHECK: vlrepg  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x38,0x05]

	vlrepg	%v0, 0
	vlrepg	%v0, 4095
	vlrepg	%v0, 0(%r15)
	vlrepg	%v0, 0(%r15,%r1)
	vlrepg	%v15, 0
	vlrepg	%v31, 0
	vlrepg	%v18, 0x567(%r3,%r4)

#CHECK: vlreph  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x10,0x05]
#CHECK: vlreph  %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x05]
#CHECK: vlreph  %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x05]
#CHECK: vlreph  %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x10,0x05]
#CHECK: vlreph  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x05]
#CHECK: vlreph  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x05]
#CHECK: vlreph  %v18, 1383(%r3,%r4)     # encoding: [0xe7,0x23,0x45,0x67,0x18,0x05]

	vlreph	%v0, 0
	vlreph	%v0, 4095
	vlreph	%v0, 0(%r15)
	vlreph	%v0, 0(%r15,%r1)
	vlreph	%v15, 0
	vlreph	%v31, 0
	vlreph	%v18, 0x567(%r3,%r4)

#CHECK: vlvg    %v0, %r0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0x22]
#CHECK: vlvg    %v0, %r0, 0, 15         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x22]
#CHECK: vlvg    %v0, %r0, 4095, 0       # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x22]
#CHECK: vlvg    %v0, %r0, 0(%r15), 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x22]
#CHECK: vlvg    %v0, %r15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x22]
#CHECK: vlvg    %v15, %r0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x22]
#CHECK: vlvg    %v31, %r0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x22]
#CHECK: vlvg    %v18, %r3, 1383(%r4), 11 # encoding: [0xe7,0x23,0x45,0x67,0xb8,0x22]

	vlvg	%v0, %r0, 0, 0
	vlvg	%v0, %r0, 0, 15
	vlvg	%v0, %r0, 4095, 0
	vlvg	%v0, %r0, 0(%r15), 0
	vlvg	%v0, %r15, 0, 0
	vlvg	%v15, %r0, 0, 0
	vlvg	%v31, %r0, 0, 0
	vlvg	%v18, %r3, 1383(%r4), 11

#CHECK: vlvgb   %v0, %r0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x22]
#CHECK: vlvgb   %v0, %r0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x22]
#CHECK: vlvgb   %v0, %r0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x22]
#CHECK: vlvgb   %v0, %r15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x22]
#CHECK: vlvgb   %v15, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x22]
#CHECK: vlvgb   %v31, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x22]
#CHECK: vlvgb   %v18, %r3, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x08,0x22]

	vlvgb	%v0, %r0, 0
	vlvgb	%v0, %r0, 4095
	vlvgb	%v0, %r0, 0(%r15)
	vlvgb	%v0, %r15, 0
	vlvgb	%v15, %r0, 0
	vlvgb	%v31, %r0, 0
	vlvgb	%v18, %r3, 1383(%r4)

#CHECK: vlvgf   %v0, %r0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x22]
#CHECK: vlvgf   %v0, %r0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x20,0x22]
#CHECK: vlvgf   %v0, %r0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x22]
#CHECK: vlvgf   %v0, %r0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x22]
#CHECK: vlvgf   %v0, %r15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x22]
#CHECK: vlvgf   %v15, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x22]
#CHECK: vlvgf   %v31, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x22]
#CHECK: vlvgf   %v18, %r3, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x28,0x22]

	vlvgf	%v0, %r0, 0
	vlvgf	%v0, %r0, 4095
	vlvgf	%v0, %r0, 0(%r15)
	vlvgf	%v0, %r0, 0(15)
	vlvgf	%v0, %r15, 0
	vlvgf	%v15, %r0, 0
	vlvgf	%v31, %r0, 0
	vlvgf	%v18, %r3, 1383(%r4)

#CHECK: vlvgg   %v0, %r0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x22]
#CHECK: vlvgg   %v0, %r0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x30,0x22]
#CHECK: vlvgg   %v0, %r0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x22]
#CHECK: vlvgg   %v0, %r15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x22]
#CHECK: vlvgg   %v15, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x22]
#CHECK: vlvgg   %v31, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x22]
#CHECK: vlvgg   %v18, %r3, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x38,0x22]

	vlvgg	%v0, %r0, 0
	vlvgg	%v0, %r0, 4095
	vlvgg	%v0, %r0, 0(%r15)
	vlvgg	%v0, %r15, 0
	vlvgg	%v15, %r0, 0
	vlvgg	%v31, %r0, 0
	vlvgg	%v18, %r3, 1383(%r4)

#CHECK: vlvgh   %v0, %r0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x10,0x22]
#CHECK: vlvgh   %v0, %r0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x10,0x22]
#CHECK: vlvgh   %v0, %r0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x22]
#CHECK: vlvgh   %v0, %r15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x22]
#CHECK: vlvgh   %v15, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x22]
#CHECK: vlvgh   %v31, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x22]
#CHECK: vlvgh   %v18, %r3, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x18,0x22]

	vlvgh	%v0, %r0, 0
	vlvgh	%v0, %r0, 4095
	vlvgh	%v0, %r0, 0(%r15)
	vlvgh	%v0, %r15, 0
	vlvgh	%v15, %r0, 0
	vlvgh	%v31, %r0, 0
	vlvgh	%v18, %r3, 1383(%r4)

#CHECK: vlvgp   %v0, %r0, %r0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x62]
#CHECK: vlvgp   %v0, %r0, %r15          # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x62]
#CHECK: vlvgp   %v0, %r15, %r0          # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x62]
#CHECK: vlvgp   %v15, %r0, %r0          # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x62]
#CHECK: vlvgp   %v31, %r0, %r0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x62]
#CHECK: vlvgp   %v18, %r3, %r4          # encoding: [0xe7,0x23,0x40,0x00,0x08,0x62]

	vlvgp	%v0, %r0, %r0
	vlvgp	%v0, %r0, %r15
	vlvgp	%v0, %r15, %r0
	vlvgp	%v15, %r0, %r0
	vlvgp	%v31, %r0, %r0
	vlvgp	%v18, %r3, %r4

#CHECK: vmae    %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xae]
#CHECK: vmae    %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xae]
#CHECK: vmae    %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xae]
#CHECK: vmae    %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xae]
#CHECK: vmae    %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xae]
#CHECK: vmae    %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xae]
#CHECK: vmae    %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xae]

	vmae	%v0, %v0, %v0, %v0, 0
	vmae	%v0, %v0, %v0, %v0, 15
	vmae	%v0, %v0, %v0, %v31, 0
	vmae	%v0, %v0, %v31, %v0, 0
	vmae	%v0, %v31, %v0, %v0, 0
	vmae	%v31, %v0, %v0, %v0, 0
	vmae	%v13, %v17, %v21, %v25, 11

#CHECK: vmaeb   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xae]
#CHECK: vmaeb   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xae]
#CHECK: vmaeb   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xae]
#CHECK: vmaeb   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xae]
#CHECK: vmaeb   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xae]
#CHECK: vmaeb   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xae]

	vmaeb	%v0, %v0, %v0, %v0
	vmaeb	%v0, %v0, %v0, %v31
	vmaeb	%v0, %v0, %v31, %v0
	vmaeb	%v0, %v31, %v0, %v0
	vmaeb	%v31, %v0, %v0, %v0
	vmaeb	%v13, %v17, %v21, %v25

#CHECK: vmaef   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xae]
#CHECK: vmaef   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xae]
#CHECK: vmaef   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xae]
#CHECK: vmaef   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xae]
#CHECK: vmaef   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xae]
#CHECK: vmaef   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xae]

	vmaef	%v0, %v0, %v0, %v0
	vmaef	%v0, %v0, %v0, %v31
	vmaef	%v0, %v0, %v31, %v0
	vmaef	%v0, %v31, %v0, %v0
	vmaef	%v31, %v0, %v0, %v0
	vmaef	%v13, %v17, %v21, %v25

#CHECK: vmaeh   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xae]
#CHECK: vmaeh   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xae]
#CHECK: vmaeh   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xae]
#CHECK: vmaeh   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xae]
#CHECK: vmaeh   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xae]
#CHECK: vmaeh   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xae]

	vmaeh	%v0, %v0, %v0, %v0
	vmaeh	%v0, %v0, %v0, %v31
	vmaeh	%v0, %v0, %v31, %v0
	vmaeh	%v0, %v31, %v0, %v0
	vmaeh	%v31, %v0, %v0, %v0
	vmaeh	%v13, %v17, %v21, %v25

#CHECK: vmah    %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xab]
#CHECK: vmah    %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xab]
#CHECK: vmah    %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xab]
#CHECK: vmah    %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xab]
#CHECK: vmah    %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xab]
#CHECK: vmah    %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xab]
#CHECK: vmah    %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xab]

	vmah	%v0, %v0, %v0, %v0, 0
	vmah	%v0, %v0, %v0, %v0, 15
	vmah	%v0, %v0, %v0, %v31, 0
	vmah	%v0, %v0, %v31, %v0, 0
	vmah	%v0, %v31, %v0, %v0, 0
	vmah	%v31, %v0, %v0, %v0, 0
	vmah	%v13, %v17, %v21, %v25, 11

#CHECK: vmahb   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xab]
#CHECK: vmahb   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xab]
#CHECK: vmahb   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xab]
#CHECK: vmahb   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xab]
#CHECK: vmahb   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xab]
#CHECK: vmahb   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xab]

	vmahb	%v0, %v0, %v0, %v0
	vmahb	%v0, %v0, %v0, %v31
	vmahb	%v0, %v0, %v31, %v0
	vmahb	%v0, %v31, %v0, %v0
	vmahb	%v31, %v0, %v0, %v0
	vmahb	%v13, %v17, %v21, %v25

#CHECK: vmahf   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xab]
#CHECK: vmahf   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xab]
#CHECK: vmahf   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xab]
#CHECK: vmahf   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xab]
#CHECK: vmahf   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xab]
#CHECK: vmahf   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xab]

	vmahf	%v0, %v0, %v0, %v0
	vmahf	%v0, %v0, %v0, %v31
	vmahf	%v0, %v0, %v31, %v0
	vmahf	%v0, %v31, %v0, %v0
	vmahf	%v31, %v0, %v0, %v0
	vmahf	%v13, %v17, %v21, %v25

#CHECK: vmahh   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xab]
#CHECK: vmahh   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xab]
#CHECK: vmahh   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xab]
#CHECK: vmahh   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xab]
#CHECK: vmahh   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xab]
#CHECK: vmahh   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xab]

	vmahh	%v0, %v0, %v0, %v0
	vmahh	%v0, %v0, %v0, %v31
	vmahh	%v0, %v0, %v31, %v0
	vmahh	%v0, %v31, %v0, %v0
	vmahh	%v31, %v0, %v0, %v0
	vmahh	%v13, %v17, %v21, %v25

#CHECK: vmal    %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xaa]
#CHECK: vmal    %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xaa]
#CHECK: vmal    %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xaa]
#CHECK: vmal    %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xaa]
#CHECK: vmal    %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xaa]
#CHECK: vmal    %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xaa]
#CHECK: vmal    %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xaa]

	vmal	%v0, %v0, %v0, %v0, 0
	vmal	%v0, %v0, %v0, %v0, 15
	vmal	%v0, %v0, %v0, %v31, 0
	vmal	%v0, %v0, %v31, %v0, 0
	vmal	%v0, %v31, %v0, %v0, 0
	vmal	%v31, %v0, %v0, %v0, 0
	vmal	%v13, %v17, %v21, %v25, 11

#CHECK: vmalb   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xaa]
#CHECK: vmalb   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xaa]
#CHECK: vmalb   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xaa]
#CHECK: vmalb   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xaa]
#CHECK: vmalb   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xaa]
#CHECK: vmalb   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xaa]

	vmalb	%v0, %v0, %v0, %v0
	vmalb	%v0, %v0, %v0, %v31
	vmalb	%v0, %v0, %v31, %v0
	vmalb	%v0, %v31, %v0, %v0
	vmalb	%v31, %v0, %v0, %v0
	vmalb	%v13, %v17, %v21, %v25

#CHECK: vmale   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xac]
#CHECK: vmale   %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xac]
#CHECK: vmale   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xac]
#CHECK: vmale   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xac]
#CHECK: vmale   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xac]
#CHECK: vmale   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xac]
#CHECK: vmale   %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xac]

	vmale	%v0, %v0, %v0, %v0, 0
	vmale	%v0, %v0, %v0, %v0, 15
	vmale	%v0, %v0, %v0, %v31, 0
	vmale	%v0, %v0, %v31, %v0, 0
	vmale	%v0, %v31, %v0, %v0, 0
	vmale	%v31, %v0, %v0, %v0, 0
	vmale	%v13, %v17, %v21, %v25, 11

#CHECK: vmaleb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xac]
#CHECK: vmaleb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xac]
#CHECK: vmaleb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xac]
#CHECK: vmaleb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xac]
#CHECK: vmaleb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xac]
#CHECK: vmaleb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xac]

	vmaleb	%v0, %v0, %v0, %v0
	vmaleb	%v0, %v0, %v0, %v31
	vmaleb	%v0, %v0, %v31, %v0
	vmaleb	%v0, %v31, %v0, %v0
	vmaleb	%v31, %v0, %v0, %v0
	vmaleb	%v13, %v17, %v21, %v25

#CHECK: vmalef  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xac]
#CHECK: vmalef  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xac]
#CHECK: vmalef  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xac]
#CHECK: vmalef  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xac]
#CHECK: vmalef  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xac]
#CHECK: vmalef  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xac]

	vmalef	%v0, %v0, %v0, %v0
	vmalef	%v0, %v0, %v0, %v31
	vmalef	%v0, %v0, %v31, %v0
	vmalef	%v0, %v31, %v0, %v0
	vmalef	%v31, %v0, %v0, %v0
	vmalef	%v13, %v17, %v21, %v25

#CHECK: vmaleh  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xac]
#CHECK: vmaleh  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xac]
#CHECK: vmaleh  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xac]
#CHECK: vmaleh  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xac]
#CHECK: vmaleh  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xac]
#CHECK: vmaleh  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xac]

	vmaleh	%v0, %v0, %v0, %v0
	vmaleh	%v0, %v0, %v0, %v31
	vmaleh	%v0, %v0, %v31, %v0
	vmaleh	%v0, %v31, %v0, %v0
	vmaleh	%v31, %v0, %v0, %v0
	vmaleh	%v13, %v17, %v21, %v25

#CHECK: vmalf   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xaa]
#CHECK: vmalf   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xaa]
#CHECK: vmalf   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xaa]
#CHECK: vmalf   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xaa]
#CHECK: vmalf   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xaa]
#CHECK: vmalf   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xaa]

	vmalf	%v0, %v0, %v0, %v0
	vmalf	%v0, %v0, %v0, %v31
	vmalf	%v0, %v0, %v31, %v0
	vmalf	%v0, %v31, %v0, %v0
	vmalf	%v31, %v0, %v0, %v0
	vmalf	%v13, %v17, %v21, %v25

#CHECK: vmalh   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa9]
#CHECK: vmalh   %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xa9]
#CHECK: vmalh   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xa9]
#CHECK: vmalh   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa9]
#CHECK: vmalh   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa9]
#CHECK: vmalh   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa9]
#CHECK: vmalh   %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xa9]

	vmalh	%v0, %v0, %v0, %v0, 0
	vmalh	%v0, %v0, %v0, %v0, 15
	vmalh	%v0, %v0, %v0, %v31, 0
	vmalh	%v0, %v0, %v31, %v0, 0
	vmalh	%v0, %v31, %v0, %v0, 0
	vmalh	%v31, %v0, %v0, %v0, 0
	vmalh	%v13, %v17, %v21, %v25, 11

#CHECK: vmalhb  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa9]
#CHECK: vmalhb  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xa9]
#CHECK: vmalhb  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa9]
#CHECK: vmalhb  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa9]
#CHECK: vmalhb  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa9]
#CHECK: vmalhb  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xa9]

	vmalhb	%v0, %v0, %v0, %v0
	vmalhb	%v0, %v0, %v0, %v31
	vmalhb	%v0, %v0, %v31, %v0
	vmalhb	%v0, %v31, %v0, %v0
	vmalhb	%v31, %v0, %v0, %v0
	vmalhb	%v13, %v17, %v21, %v25

#CHECK: vmalhf  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xa9]
#CHECK: vmalhf  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xa9]
#CHECK: vmalhf  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xa9]
#CHECK: vmalhf  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xa9]
#CHECK: vmalhf  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xa9]
#CHECK: vmalhf  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xa9]

	vmalhf	%v0, %v0, %v0, %v0
	vmalhf	%v0, %v0, %v0, %v31
	vmalhf	%v0, %v0, %v31, %v0
	vmalhf	%v0, %v31, %v0, %v0
	vmalhf	%v31, %v0, %v0, %v0
	vmalhf	%v13, %v17, %v21, %v25

#CHECK: vmalhh  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xa9]
#CHECK: vmalhh  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xa9]
#CHECK: vmalhh  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xa9]
#CHECK: vmalhh  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xa9]
#CHECK: vmalhh  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xa9]
#CHECK: vmalhh  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xa9]

	vmalhh	%v0, %v0, %v0, %v0
	vmalhh	%v0, %v0, %v0, %v31
	vmalhh	%v0, %v0, %v31, %v0
	vmalhh	%v0, %v31, %v0, %v0
	vmalhh	%v31, %v0, %v0, %v0
	vmalhh	%v13, %v17, %v21, %v25

#CHECK: vmalhw  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xaa]
#CHECK: vmalhw  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xaa]
#CHECK: vmalhw  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xaa]
#CHECK: vmalhw  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xaa]
#CHECK: vmalhw  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xaa]
#CHECK: vmalhw  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xaa]

	vmalhw	%v0, %v0, %v0, %v0
	vmalhw	%v0, %v0, %v0, %v31
	vmalhw	%v0, %v0, %v31, %v0
	vmalhw	%v0, %v31, %v0, %v0
	vmalhw	%v31, %v0, %v0, %v0
	vmalhw	%v13, %v17, %v21, %v25

#CHECK: vmalo   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xad]
#CHECK: vmalo   %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xad]
#CHECK: vmalo   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xad]
#CHECK: vmalo   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xad]
#CHECK: vmalo   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xad]
#CHECK: vmalo   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xad]
#CHECK: vmalo   %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xad]

	vmalo	%v0, %v0, %v0, %v0, 0
	vmalo	%v0, %v0, %v0, %v0, 15
	vmalo	%v0, %v0, %v0, %v31, 0
	vmalo	%v0, %v0, %v31, %v0, 0
	vmalo	%v0, %v31, %v0, %v0, 0
	vmalo	%v31, %v0, %v0, %v0, 0
	vmalo	%v13, %v17, %v21, %v25, 11

#CHECK: vmalob  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xad]
#CHECK: vmalob  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xad]
#CHECK: vmalob  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xad]
#CHECK: vmalob  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xad]
#CHECK: vmalob  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xad]
#CHECK: vmalob  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xad]

	vmalob	%v0, %v0, %v0, %v0
	vmalob	%v0, %v0, %v0, %v31
	vmalob	%v0, %v0, %v31, %v0
	vmalob	%v0, %v31, %v0, %v0
	vmalob	%v31, %v0, %v0, %v0
	vmalob	%v13, %v17, %v21, %v25

#CHECK: vmalof  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xad]
#CHECK: vmalof  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xad]
#CHECK: vmalof  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xad]
#CHECK: vmalof  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xad]
#CHECK: vmalof  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xad]
#CHECK: vmalof  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xad]

	vmalof	%v0, %v0, %v0, %v0
	vmalof	%v0, %v0, %v0, %v31
	vmalof	%v0, %v0, %v31, %v0
	vmalof	%v0, %v31, %v0, %v0
	vmalof	%v31, %v0, %v0, %v0
	vmalof	%v13, %v17, %v21, %v25

#CHECK: vmaloh  %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xad]
#CHECK: vmaloh  %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xad]
#CHECK: vmaloh  %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xad]
#CHECK: vmaloh  %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xad]
#CHECK: vmaloh  %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xad]
#CHECK: vmaloh  %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xad]

	vmaloh	%v0, %v0, %v0, %v0
	vmaloh	%v0, %v0, %v0, %v31
	vmaloh	%v0, %v0, %v31, %v0
	vmaloh	%v0, %v31, %v0, %v0
	vmaloh	%v31, %v0, %v0, %v0
	vmaloh	%v13, %v17, %v21, %v25

#CHECK: vmao    %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xaf]
#CHECK: vmao    %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xaf]
#CHECK: vmao    %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xaf]
#CHECK: vmao    %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xaf]
#CHECK: vmao    %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xaf]
#CHECK: vmao    %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xaf]
#CHECK: vmao    %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xaf]

	vmao	%v0, %v0, %v0, %v0, 0
	vmao	%v0, %v0, %v0, %v0, 15
	vmao	%v0, %v0, %v0, %v31, 0
	vmao	%v0, %v0, %v31, %v0, 0
	vmao	%v0, %v31, %v0, %v0, 0
	vmao	%v31, %v0, %v0, %v0, 0
	vmao	%v13, %v17, %v21, %v25, 11

#CHECK: vmaob   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0xaf]
#CHECK: vmaob   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xaf]
#CHECK: vmaob   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xaf]
#CHECK: vmaob   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xaf]
#CHECK: vmaob   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xaf]
#CHECK: vmaob   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0xaf]

	vmaob	%v0, %v0, %v0, %v0
	vmaob	%v0, %v0, %v0, %v31
	vmaob	%v0, %v0, %v31, %v0
	vmaob	%v0, %v31, %v0, %v0
	vmaob	%v31, %v0, %v0, %v0
	vmaob	%v13, %v17, %v21, %v25

#CHECK: vmaof   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x02,0x00,0x00,0xaf]
#CHECK: vmaof   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x02,0x00,0xf1,0xaf]
#CHECK: vmaof   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf2,0x00,0x02,0xaf]
#CHECK: vmaof   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x02,0x00,0x04,0xaf]
#CHECK: vmaof   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x02,0x00,0x08,0xaf]
#CHECK: vmaof   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x52,0x00,0x97,0xaf]

	vmaof	%v0, %v0, %v0, %v0
	vmaof	%v0, %v0, %v0, %v31
	vmaof	%v0, %v0, %v31, %v0
	vmaof	%v0, %v31, %v0, %v0
	vmaof	%v31, %v0, %v0, %v0
	vmaof	%v13, %v17, %v21, %v25

#CHECK: vmaoh   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x01,0x00,0x00,0xaf]
#CHECK: vmaoh   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x01,0x00,0xf1,0xaf]
#CHECK: vmaoh   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf1,0x00,0x02,0xaf]
#CHECK: vmaoh   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x01,0x00,0x04,0xaf]
#CHECK: vmaoh   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x01,0x00,0x08,0xaf]
#CHECK: vmaoh   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x51,0x00,0x97,0xaf]

	vmaoh	%v0, %v0, %v0, %v0
	vmaoh	%v0, %v0, %v0, %v31
	vmaoh	%v0, %v0, %v31, %v0
	vmaoh	%v0, %v31, %v0, %v0
	vmaoh	%v31, %v0, %v0, %v0
	vmaoh	%v13, %v17, %v21, %v25

#CHECK: vme     %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa6]
#CHECK: vme     %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xa6]
#CHECK: vme     %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa6]
#CHECK: vme     %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa6]
#CHECK: vme     %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa6]
#CHECK: vme     %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xa6]

	vme	%v0, %v0, %v0, 0
	vme	%v0, %v0, %v0, 15
	vme	%v0, %v0, %v31, 0
	vme	%v0, %v31, %v0, 0
	vme	%v31, %v0, %v0, 0
	vme	%v18, %v3, %v20, 11

#CHECK: vmeb    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa6]
#CHECK: vmeb    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa6]
#CHECK: vmeb    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa6]
#CHECK: vmeb    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa6]
#CHECK: vmeb    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xa6]

	vmeb	%v0, %v0, %v0
	vmeb	%v0, %v0, %v31
	vmeb	%v0, %v31, %v0
	vmeb	%v31, %v0, %v0
	vmeb	%v18, %v3, %v20

#CHECK: vmef    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xa6]
#CHECK: vmef    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xa6]
#CHECK: vmef    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xa6]
#CHECK: vmef    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xa6]
#CHECK: vmef    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xa6]

	vmef	%v0, %v0, %v0
	vmef	%v0, %v0, %v31
	vmef	%v0, %v31, %v0
	vmef	%v31, %v0, %v0
	vmef	%v18, %v3, %v20

#CHECK: vmeh    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xa6]
#CHECK: vmeh    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xa6]
#CHECK: vmeh    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xa6]
#CHECK: vmeh    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xa6]
#CHECK: vmeh    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xa6]

	vmeh	%v0, %v0, %v0
	vmeh	%v0, %v0, %v31
	vmeh	%v0, %v31, %v0
	vmeh	%v31, %v0, %v0
	vmeh	%v18, %v3, %v20

#CHECK: vmh     %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa3]
#CHECK: vmh     %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xa3]
#CHECK: vmh     %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa3]
#CHECK: vmh     %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa3]
#CHECK: vmh     %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa3]
#CHECK: vmh     %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xa3]

	vmh	%v0, %v0, %v0, 0
	vmh	%v0, %v0, %v0, 15
	vmh	%v0, %v0, %v31, 0
	vmh	%v0, %v31, %v0, 0
	vmh	%v31, %v0, %v0, 0
	vmh	%v18, %v3, %v20, 11

#CHECK: vmhb    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa3]
#CHECK: vmhb    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa3]
#CHECK: vmhb    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa3]
#CHECK: vmhb    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa3]
#CHECK: vmhb    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xa3]

	vmhb	%v0, %v0, %v0
	vmhb	%v0, %v0, %v31
	vmhb	%v0, %v31, %v0
	vmhb	%v31, %v0, %v0
	vmhb	%v18, %v3, %v20

#CHECK: vmhf    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xa3]
#CHECK: vmhf    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xa3]
#CHECK: vmhf    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xa3]
#CHECK: vmhf    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xa3]
#CHECK: vmhf    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xa3]

	vmhf	%v0, %v0, %v0
	vmhf	%v0, %v0, %v31
	vmhf	%v0, %v31, %v0
	vmhf	%v31, %v0, %v0
	vmhf	%v18, %v3, %v20

#CHECK: vmhh    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xa3]
#CHECK: vmhh    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xa3]
#CHECK: vmhh    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xa3]
#CHECK: vmhh    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xa3]
#CHECK: vmhh    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xa3]

	vmhh	%v0, %v0, %v0
	vmhh	%v0, %v0, %v31
	vmhh	%v0, %v31, %v0
	vmhh	%v31, %v0, %v0
	vmhh	%v18, %v3, %v20

#CHECK: vml     %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa2]
#CHECK: vml     %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xa2]
#CHECK: vml     %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa2]
#CHECK: vml     %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa2]
#CHECK: vml     %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa2]
#CHECK: vml     %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xa2]

	vml	%v0, %v0, %v0, 0
	vml	%v0, %v0, %v0, 15
	vml	%v0, %v0, %v31, 0
	vml	%v0, %v31, %v0, 0
	vml	%v31, %v0, %v0, 0
	vml	%v18, %v3, %v20, 11

#CHECK: vmlb    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa2]
#CHECK: vmlb    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa2]
#CHECK: vmlb    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa2]
#CHECK: vmlb    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa2]
#CHECK: vmlb    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xa2]

	vmlb	%v0, %v0, %v0
	vmlb	%v0, %v0, %v31
	vmlb	%v0, %v31, %v0
	vmlb	%v31, %v0, %v0
	vmlb	%v18, %v3, %v20

#CHECK: vmle    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa4]
#CHECK: vmle    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xa4]
#CHECK: vmle    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa4]
#CHECK: vmle    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa4]
#CHECK: vmle    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa4]
#CHECK: vmle    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xa4]

	vmle	%v0, %v0, %v0, 0
	vmle	%v0, %v0, %v0, 15
	vmle	%v0, %v0, %v31, 0
	vmle	%v0, %v31, %v0, 0
	vmle	%v31, %v0, %v0, 0
	vmle	%v18, %v3, %v20, 11

#CHECK: vmleb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa4]
#CHECK: vmleb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa4]
#CHECK: vmleb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa4]
#CHECK: vmleb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa4]
#CHECK: vmleb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xa4]

	vmleb	%v0, %v0, %v0
	vmleb	%v0, %v0, %v31
	vmleb	%v0, %v31, %v0
	vmleb	%v31, %v0, %v0
	vmleb	%v18, %v3, %v20

#CHECK: vmlef   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xa4]
#CHECK: vmlef   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xa4]
#CHECK: vmlef   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xa4]
#CHECK: vmlef   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xa4]
#CHECK: vmlef   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xa4]

	vmlef	%v0, %v0, %v0
	vmlef	%v0, %v0, %v31
	vmlef	%v0, %v31, %v0
	vmlef	%v31, %v0, %v0
	vmlef	%v18, %v3, %v20

#CHECK: vmleh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xa4]
#CHECK: vmleh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xa4]
#CHECK: vmleh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xa4]
#CHECK: vmleh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xa4]
#CHECK: vmleh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xa4]

	vmleh	%v0, %v0, %v0
	vmleh	%v0, %v0, %v31
	vmleh	%v0, %v31, %v0
	vmleh	%v31, %v0, %v0
	vmleh	%v18, %v3, %v20

#CHECK: vmlf    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xa2]
#CHECK: vmlf    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xa2]
#CHECK: vmlf    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xa2]
#CHECK: vmlf    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xa2]
#CHECK: vmlf    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xa2]

	vmlf	%v0, %v0, %v0
	vmlf	%v0, %v0, %v31
	vmlf	%v0, %v31, %v0
	vmlf	%v31, %v0, %v0
	vmlf	%v18, %v3, %v20

#CHECK: vmlh    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa1]
#CHECK: vmlh    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xa1]
#CHECK: vmlh    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa1]
#CHECK: vmlh    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa1]
#CHECK: vmlh    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa1]
#CHECK: vmlh    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xa1]

	vmlh	%v0, %v0, %v0, 0
	vmlh	%v0, %v0, %v0, 15
	vmlh	%v0, %v0, %v31, 0
	vmlh	%v0, %v31, %v0, 0
	vmlh	%v31, %v0, %v0, 0
	vmlh	%v18, %v3, %v20, 11

#CHECK: vmlhb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa1]
#CHECK: vmlhb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa1]
#CHECK: vmlhb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa1]
#CHECK: vmlhb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa1]
#CHECK: vmlhb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xa1]

	vmlhb	%v0, %v0, %v0
	vmlhb	%v0, %v0, %v31
	vmlhb	%v0, %v31, %v0
	vmlhb	%v31, %v0, %v0
	vmlhb	%v18, %v3, %v20

#CHECK: vmlhf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xa1]
#CHECK: vmlhf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xa1]
#CHECK: vmlhf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xa1]
#CHECK: vmlhf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xa1]
#CHECK: vmlhf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xa1]

	vmlhf	%v0, %v0, %v0
	vmlhf	%v0, %v0, %v31
	vmlhf	%v0, %v31, %v0
	vmlhf	%v31, %v0, %v0
	vmlhf	%v18, %v3, %v20

#CHECK: vmlhh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xa1]
#CHECK: vmlhh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xa1]
#CHECK: vmlhh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xa1]
#CHECK: vmlhh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xa1]
#CHECK: vmlhh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xa1]

	vmlhh	%v0, %v0, %v0
	vmlhh	%v0, %v0, %v31
	vmlhh	%v0, %v31, %v0
	vmlhh	%v31, %v0, %v0
	vmlhh	%v18, %v3, %v20

#CHECK: vmlhw   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xa2]
#CHECK: vmlhw   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xa2]
#CHECK: vmlhw   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xa2]
#CHECK: vmlhw   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xa2]
#CHECK: vmlhw   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xa2]

	vmlhw	%v0, %v0, %v0
	vmlhw	%v0, %v0, %v31
	vmlhw	%v0, %v31, %v0
	vmlhw	%v31, %v0, %v0
	vmlhw	%v18, %v3, %v20

#CHECK: vmlo    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa5]
#CHECK: vmlo    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xa5]
#CHECK: vmlo    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa5]
#CHECK: vmlo    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa5]
#CHECK: vmlo    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa5]
#CHECK: vmlo    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xa5]

	vmlo	%v0, %v0, %v0, 0
	vmlo	%v0, %v0, %v0, 15
	vmlo	%v0, %v0, %v31, 0
	vmlo	%v0, %v31, %v0, 0
	vmlo	%v31, %v0, %v0, 0
	vmlo	%v18, %v3, %v20, 11

#CHECK: vmlob   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa5]
#CHECK: vmlob   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa5]
#CHECK: vmlob   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa5]
#CHECK: vmlob   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa5]
#CHECK: vmlob   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xa5]

	vmlob	%v0, %v0, %v0
	vmlob	%v0, %v0, %v31
	vmlob	%v0, %v31, %v0
	vmlob	%v31, %v0, %v0
	vmlob	%v18, %v3, %v20

#CHECK: vmlof   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xa5]
#CHECK: vmlof   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xa5]
#CHECK: vmlof   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xa5]
#CHECK: vmlof   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xa5]
#CHECK: vmlof   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xa5]

	vmlof	%v0, %v0, %v0
	vmlof	%v0, %v0, %v31
	vmlof	%v0, %v31, %v0
	vmlof	%v31, %v0, %v0
	vmlof	%v18, %v3, %v20

#CHECK: vmloh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xa5]
#CHECK: vmloh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xa5]
#CHECK: vmloh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xa5]
#CHECK: vmloh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xa5]
#CHECK: vmloh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xa5]

	vmloh	%v0, %v0, %v0
	vmloh	%v0, %v0, %v31
	vmloh	%v0, %v31, %v0
	vmloh	%v31, %v0, %v0
	vmloh	%v18, %v3, %v20

#CHECK: vmn     %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfe]
#CHECK: vmn     %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xfe]
#CHECK: vmn     %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfe]
#CHECK: vmn     %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfe]
#CHECK: vmn     %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfe]
#CHECK: vmn     %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xfe]

	vmn	%v0, %v0, %v0, 0
	vmn	%v0, %v0, %v0, 15
	vmn	%v0, %v0, %v31, 0
	vmn	%v0, %v31, %v0, 0
	vmn	%v31, %v0, %v0, 0
	vmn	%v18, %v3, %v20, 11

#CHECK: vmnb    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfe]
#CHECK: vmnb    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfe]
#CHECK: vmnb    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfe]
#CHECK: vmnb    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfe]
#CHECK: vmnb    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xfe]

	vmnb	%v0, %v0, %v0
	vmnb	%v0, %v0, %v31
	vmnb	%v0, %v31, %v0
	vmnb	%v31, %v0, %v0
	vmnb	%v18, %v3, %v20

#CHECK: vmnf    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xfe]
#CHECK: vmnf    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xfe]
#CHECK: vmnf    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xfe]
#CHECK: vmnf    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xfe]
#CHECK: vmnf    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xfe]

	vmnf	%v0, %v0, %v0
	vmnf	%v0, %v0, %v31
	vmnf	%v0, %v31, %v0
	vmnf	%v31, %v0, %v0
	vmnf	%v18, %v3, %v20

#CHECK: vmng    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xfe]
#CHECK: vmng    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xfe]
#CHECK: vmng    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xfe]
#CHECK: vmng    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xfe]
#CHECK: vmng    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xfe]

	vmng	%v0, %v0, %v0
	vmng	%v0, %v0, %v31
	vmng	%v0, %v31, %v0
	vmng	%v31, %v0, %v0
	vmng	%v18, %v3, %v20

#CHECK: vmnh    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xfe]
#CHECK: vmnh    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xfe]
#CHECK: vmnh    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xfe]
#CHECK: vmnh    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xfe]
#CHECK: vmnh    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xfe]

	vmnh	%v0, %v0, %v0
	vmnh	%v0, %v0, %v31
	vmnh	%v0, %v31, %v0
	vmnh	%v31, %v0, %v0
	vmnh	%v18, %v3, %v20

#CHECK: vmnl    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfc]
#CHECK: vmnl    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xfc]
#CHECK: vmnl    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfc]
#CHECK: vmnl    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfc]
#CHECK: vmnl    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfc]
#CHECK: vmnl    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xfc]

	vmnl	%v0, %v0, %v0, 0
	vmnl	%v0, %v0, %v0, 15
	vmnl	%v0, %v0, %v31, 0
	vmnl	%v0, %v31, %v0, 0
	vmnl	%v31, %v0, %v0, 0
	vmnl	%v18, %v3, %v20, 11

#CHECK: vmnlb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfc]
#CHECK: vmnlb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfc]
#CHECK: vmnlb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfc]
#CHECK: vmnlb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfc]
#CHECK: vmnlb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xfc]

	vmnlb	%v0, %v0, %v0
	vmnlb	%v0, %v0, %v31
	vmnlb	%v0, %v31, %v0
	vmnlb	%v31, %v0, %v0
	vmnlb	%v18, %v3, %v20

#CHECK: vmnlf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xfc]
#CHECK: vmnlf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xfc]
#CHECK: vmnlf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xfc]
#CHECK: vmnlf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xfc]
#CHECK: vmnlf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xfc]

	vmnlf	%v0, %v0, %v0
	vmnlf	%v0, %v0, %v31
	vmnlf	%v0, %v31, %v0
	vmnlf	%v31, %v0, %v0
	vmnlf	%v18, %v3, %v20

#CHECK: vmnlg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xfc]
#CHECK: vmnlg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xfc]
#CHECK: vmnlg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xfc]
#CHECK: vmnlg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xfc]
#CHECK: vmnlg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xfc]

	vmnlg	%v0, %v0, %v0
	vmnlg	%v0, %v0, %v31
	vmnlg	%v0, %v31, %v0
	vmnlg	%v31, %v0, %v0
	vmnlg	%v18, %v3, %v20

#CHECK: vmnlh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xfc]
#CHECK: vmnlh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xfc]
#CHECK: vmnlh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xfc]
#CHECK: vmnlh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xfc]
#CHECK: vmnlh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xfc]

	vmnlh	%v0, %v0, %v0
	vmnlh	%v0, %v0, %v31
	vmnlh	%v0, %v31, %v0
	vmnlh	%v31, %v0, %v0
	vmnlh	%v18, %v3, %v20

#CHECK: vmo     %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa7]
#CHECK: vmo     %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xa7]
#CHECK: vmo     %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa7]
#CHECK: vmo     %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa7]
#CHECK: vmo     %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa7]
#CHECK: vmo     %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xa7]

	vmo	%v0, %v0, %v0, 0
	vmo	%v0, %v0, %v0, 15
	vmo	%v0, %v0, %v31, 0
	vmo	%v0, %v31, %v0, 0
	vmo	%v31, %v0, %v0, 0
	vmo	%v18, %v3, %v20, 11

#CHECK: vmob    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xa7]
#CHECK: vmob    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xa7]
#CHECK: vmob    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xa7]
#CHECK: vmob    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xa7]
#CHECK: vmob    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xa7]

	vmob	%v0, %v0, %v0
	vmob	%v0, %v0, %v31
	vmob	%v0, %v31, %v0
	vmob	%v31, %v0, %v0
	vmob	%v18, %v3, %v20

#CHECK: vmof    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xa7]
#CHECK: vmof    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xa7]
#CHECK: vmof    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xa7]
#CHECK: vmof    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xa7]
#CHECK: vmof    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xa7]

	vmof	%v0, %v0, %v0
	vmof	%v0, %v0, %v31
	vmof	%v0, %v31, %v0
	vmof	%v31, %v0, %v0
	vmof	%v18, %v3, %v20

#CHECK: vmoh    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xa7]
#CHECK: vmoh    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xa7]
#CHECK: vmoh    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xa7]
#CHECK: vmoh    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xa7]
#CHECK: vmoh    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xa7]

	vmoh	%v0, %v0, %v0
	vmoh	%v0, %v0, %v31
	vmoh	%v0, %v31, %v0
	vmoh	%v31, %v0, %v0
	vmoh	%v18, %v3, %v20

#CHECK: vmrh    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x61]
#CHECK: vmrh    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x61]
#CHECK: vmrh    %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x61]
#CHECK: vmrh    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x61]
#CHECK: vmrh    %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x61]
#CHECK: vmrh    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x61]
#CHECK: vmrh    %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x61]
#CHECK: vmrh    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x61]
#CHECK: vmrh    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x61]

	vmrh	%v0, %v0, %v0, 0
	vmrh	%v0, %v0, %v0, 15
	vmrh	%v0, %v0, %v15, 0
	vmrh	%v0, %v0, %v31, 0
	vmrh	%v0, %v15, %v0, 0
	vmrh	%v0, %v31, %v0, 0
	vmrh	%v15, %v0, %v0, 0
	vmrh	%v31, %v0, %v0, 0
	vmrh	%v18, %v3, %v20, 11

#CHECK: vmrhb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x61]
#CHECK: vmrhb   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x61]
#CHECK: vmrhb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x61]
#CHECK: vmrhb   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x61]
#CHECK: vmrhb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x61]
#CHECK: vmrhb   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x61]
#CHECK: vmrhb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x61]
#CHECK: vmrhb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x61]

	vmrhb	%v0, %v0, %v0
	vmrhb	%v0, %v0, %v15
	vmrhb	%v0, %v0, %v31
	vmrhb	%v0, %v15, %v0
	vmrhb	%v0, %v31, %v0
	vmrhb	%v15, %v0, %v0
	vmrhb	%v31, %v0, %v0
	vmrhb	%v18, %v3, %v20

#CHECK: vmrhf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x61]
#CHECK: vmrhf   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x61]
#CHECK: vmrhf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x61]
#CHECK: vmrhf   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x61]
#CHECK: vmrhf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x61]
#CHECK: vmrhf   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x61]
#CHECK: vmrhf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x61]
#CHECK: vmrhf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x61]

	vmrhf	%v0, %v0, %v0
	vmrhf	%v0, %v0, %v15
	vmrhf	%v0, %v0, %v31
	vmrhf	%v0, %v15, %v0
	vmrhf	%v0, %v31, %v0
	vmrhf	%v15, %v0, %v0
	vmrhf	%v31, %v0, %v0
	vmrhf	%v18, %v3, %v20

#CHECK: vmrhg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x61]
#CHECK: vmrhg   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x61]
#CHECK: vmrhg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x61]
#CHECK: vmrhg   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x61]
#CHECK: vmrhg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x61]
#CHECK: vmrhg   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x61]
#CHECK: vmrhg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x61]
#CHECK: vmrhg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x61]

	vmrhg	%v0, %v0, %v0
	vmrhg	%v0, %v0, %v15
	vmrhg	%v0, %v0, %v31
	vmrhg	%v0, %v15, %v0
	vmrhg	%v0, %v31, %v0
	vmrhg	%v15, %v0, %v0
	vmrhg	%v31, %v0, %v0
	vmrhg	%v18, %v3, %v20

#CHECK: vmrhh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x61]
#CHECK: vmrhh   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x61]
#CHECK: vmrhh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x61]
#CHECK: vmrhh   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x61]
#CHECK: vmrhh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x61]
#CHECK: vmrhh   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x61]
#CHECK: vmrhh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x61]
#CHECK: vmrhh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x61]

	vmrhh	%v0, %v0, %v0
	vmrhh	%v0, %v0, %v15
	vmrhh	%v0, %v0, %v31
	vmrhh	%v0, %v15, %v0
	vmrhh	%v0, %v31, %v0
	vmrhh	%v15, %v0, %v0
	vmrhh	%v31, %v0, %v0
	vmrhh	%v18, %v3, %v20

#CHECK: vmrl    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x60]
#CHECK: vmrl    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x60]
#CHECK: vmrl    %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x60]
#CHECK: vmrl    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x60]
#CHECK: vmrl    %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x60]
#CHECK: vmrl    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x60]
#CHECK: vmrl    %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x60]
#CHECK: vmrl    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x60]
#CHECK: vmrl    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x60]

	vmrl	%v0, %v0, %v0, 0
	vmrl	%v0, %v0, %v0, 15
	vmrl	%v0, %v0, %v15, 0
	vmrl	%v0, %v0, %v31, 0
	vmrl	%v0, %v15, %v0, 0
	vmrl	%v0, %v31, %v0, 0
	vmrl	%v15, %v0, %v0, 0
	vmrl	%v31, %v0, %v0, 0
	vmrl	%v18, %v3, %v20, 11

#CHECK: vmrlb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x60]
#CHECK: vmrlb   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x60]
#CHECK: vmrlb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x60]
#CHECK: vmrlb   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x60]
#CHECK: vmrlb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x60]
#CHECK: vmrlb   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x60]
#CHECK: vmrlb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x60]
#CHECK: vmrlb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x60]

	vmrlb	%v0, %v0, %v0
	vmrlb	%v0, %v0, %v15
	vmrlb	%v0, %v0, %v31
	vmrlb	%v0, %v15, %v0
	vmrlb	%v0, %v31, %v0
	vmrlb	%v15, %v0, %v0
	vmrlb	%v31, %v0, %v0
	vmrlb	%v18, %v3, %v20

#CHECK: vmrlf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x60]
#CHECK: vmrlf   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x60]
#CHECK: vmrlf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x60]
#CHECK: vmrlf   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x60]
#CHECK: vmrlf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x60]
#CHECK: vmrlf   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x60]
#CHECK: vmrlf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x60]
#CHECK: vmrlf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x60]

	vmrlf	%v0, %v0, %v0
	vmrlf	%v0, %v0, %v15
	vmrlf	%v0, %v0, %v31
	vmrlf	%v0, %v15, %v0
	vmrlf	%v0, %v31, %v0
	vmrlf	%v15, %v0, %v0
	vmrlf	%v31, %v0, %v0
	vmrlf	%v18, %v3, %v20

#CHECK: vmrlg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x60]
#CHECK: vmrlg   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x60]
#CHECK: vmrlg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x60]
#CHECK: vmrlg   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x60]
#CHECK: vmrlg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x60]
#CHECK: vmrlg   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x60]
#CHECK: vmrlg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x60]
#CHECK: vmrlg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x60]

	vmrlg	%v0, %v0, %v0
	vmrlg	%v0, %v0, %v15
	vmrlg	%v0, %v0, %v31
	vmrlg	%v0, %v15, %v0
	vmrlg	%v0, %v31, %v0
	vmrlg	%v15, %v0, %v0
	vmrlg	%v31, %v0, %v0
	vmrlg	%v18, %v3, %v20

#CHECK: vmrlh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x60]
#CHECK: vmrlh   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x60]
#CHECK: vmrlh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x60]
#CHECK: vmrlh   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x60]
#CHECK: vmrlh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x60]
#CHECK: vmrlh   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x60]
#CHECK: vmrlh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x60]
#CHECK: vmrlh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x60]

	vmrlh	%v0, %v0, %v0
	vmrlh	%v0, %v0, %v15
	vmrlh	%v0, %v0, %v31
	vmrlh	%v0, %v15, %v0
	vmrlh	%v0, %v31, %v0
	vmrlh	%v15, %v0, %v0
	vmrlh	%v31, %v0, %v0
	vmrlh	%v18, %v3, %v20

#CHECK: vmx     %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xff]
#CHECK: vmx     %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xff]
#CHECK: vmx     %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xff]
#CHECK: vmx     %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xff]
#CHECK: vmx     %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xff]
#CHECK: vmx     %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xff]

	vmx	%v0, %v0, %v0, 0
	vmx	%v0, %v0, %v0, 15
	vmx	%v0, %v0, %v31, 0
	vmx	%v0, %v31, %v0, 0
	vmx	%v31, %v0, %v0, 0
	vmx	%v18, %v3, %v20, 11

#CHECK: vmxb    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xff]
#CHECK: vmxb    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xff]
#CHECK: vmxb    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xff]
#CHECK: vmxb    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xff]
#CHECK: vmxb    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xff]

	vmxb	%v0, %v0, %v0
	vmxb	%v0, %v0, %v31
	vmxb	%v0, %v31, %v0
	vmxb	%v31, %v0, %v0
	vmxb	%v18, %v3, %v20

#CHECK: vmxf    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xff]
#CHECK: vmxf    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xff]
#CHECK: vmxf    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xff]
#CHECK: vmxf    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xff]
#CHECK: vmxf    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xff]

	vmxf	%v0, %v0, %v0
	vmxf	%v0, %v0, %v31
	vmxf	%v0, %v31, %v0
	vmxf	%v31, %v0, %v0
	vmxf	%v18, %v3, %v20

#CHECK: vmxg    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xff]
#CHECK: vmxg    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xff]
#CHECK: vmxg    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xff]
#CHECK: vmxg    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xff]
#CHECK: vmxg    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xff]

	vmxg	%v0, %v0, %v0
	vmxg	%v0, %v0, %v31
	vmxg	%v0, %v31, %v0
	vmxg	%v31, %v0, %v0
	vmxg	%v18, %v3, %v20

#CHECK: vmxh    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xff]
#CHECK: vmxh    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xff]
#CHECK: vmxh    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xff]
#CHECK: vmxh    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xff]
#CHECK: vmxh    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xff]

	vmxh	%v0, %v0, %v0
	vmxh	%v0, %v0, %v31
	vmxh	%v0, %v31, %v0
	vmxh	%v31, %v0, %v0
	vmxh	%v18, %v3, %v20

#CHECK: vmxl    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfd]
#CHECK: vmxl    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xfd]
#CHECK: vmxl    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfd]
#CHECK: vmxl    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfd]
#CHECK: vmxl    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfd]
#CHECK: vmxl    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xfd]

	vmxl	%v0, %v0, %v0, 0
	vmxl	%v0, %v0, %v0, 15
	vmxl	%v0, %v0, %v31, 0
	vmxl	%v0, %v31, %v0, 0
	vmxl	%v31, %v0, %v0, 0
	vmxl	%v18, %v3, %v20, 11

#CHECK: vmxlb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xfd]
#CHECK: vmxlb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xfd]
#CHECK: vmxlb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xfd]
#CHECK: vmxlb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xfd]
#CHECK: vmxlb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xfd]

	vmxlb	%v0, %v0, %v0
	vmxlb	%v0, %v0, %v31
	vmxlb	%v0, %v31, %v0
	vmxlb	%v31, %v0, %v0
	vmxlb	%v18, %v3, %v20

#CHECK: vmxlf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xfd]
#CHECK: vmxlf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xfd]
#CHECK: vmxlf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xfd]
#CHECK: vmxlf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xfd]
#CHECK: vmxlf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xfd]

	vmxlf	%v0, %v0, %v0
	vmxlf	%v0, %v0, %v31
	vmxlf	%v0, %v31, %v0
	vmxlf	%v31, %v0, %v0
	vmxlf	%v18, %v3, %v20

#CHECK: vmxlg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xfd]
#CHECK: vmxlg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xfd]
#CHECK: vmxlg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xfd]
#CHECK: vmxlg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xfd]
#CHECK: vmxlg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xfd]

	vmxlg	%v0, %v0, %v0
	vmxlg	%v0, %v0, %v31
	vmxlg	%v0, %v31, %v0
	vmxlg	%v31, %v0, %v0
	vmxlg	%v18, %v3, %v20

#CHECK: vmxlh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xfd]
#CHECK: vmxlh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xfd]
#CHECK: vmxlh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xfd]
#CHECK: vmxlh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xfd]
#CHECK: vmxlh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xfd]

	vmxlh	%v0, %v0, %v0
	vmxlh	%v0, %v0, %v31
	vmxlh	%v0, %v31, %v0
	vmxlh	%v31, %v0, %v0
	vmxlh	%v18, %v3, %v20

#CHECK: vn      %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x68]
#CHECK: vn      %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x68]
#CHECK: vn      %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x68]
#CHECK: vn      %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x68]
#CHECK: vn      %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x68]

	vn	%v0, %v0, %v0
	vn	%v0, %v0, %v31
	vn	%v0, %v31, %v0
	vn	%v31, %v0, %v0
	vn	%v18, %v3, %v20

#CHECK: vnc     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x69]
#CHECK: vnc     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x69]
#CHECK: vnc     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x69]
#CHECK: vnc     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x69]
#CHECK: vnc     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x69]

	vnc	%v0, %v0, %v0
	vnc	%v0, %v0, %v31
	vnc	%v0, %v31, %v0
	vnc	%v31, %v0, %v0
	vnc	%v18, %v3, %v20

#CHECK: vno     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x6b]
#CHECK: vno     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x6b]
#CHECK: vno     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x6b]
#CHECK: vno     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x6b]
#CHECK: vno     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x6b]

	vno	%v0, %v0, %v0
	vno	%v0, %v0, %v31
	vno	%v0, %v31, %v0
	vno	%v31, %v0, %v0
	vno	%v18, %v3, %v20

#CHECK: vno     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x6b]
#CHECK: vno     %v0, %v31, %v31         # encoding: [0xe7,0x0f,0xf0,0x00,0x06,0x6b]
#CHECK: vno     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x6b]
#CHECK: vno     %v3, %v20, %v20         # encoding: [0xe7,0x34,0x40,0x00,0x06,0x6b]

	vnot	%v0, %v0
	vnot	%v0, %v31
	vnot	%v31, %v0
	vnot	%v3, %v20

#CHECK: vo      %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x6a]
#CHECK: vo      %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x6a]
#CHECK: vo      %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x6a]
#CHECK: vo      %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x6a]
#CHECK: vo      %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x6a]

	vo	%v0, %v0, %v0
	vo	%v0, %v0, %v31
	vo	%v0, %v31, %v0
	vo	%v31, %v0, %v0
	vo	%v18, %v3, %v20

#CHECK: vone    %v0                     # encoding: [0xe7,0x00,0xff,0xff,0x00,0x44]
#CHECK: vone    %v15                    # encoding: [0xe7,0xf0,0xff,0xff,0x00,0x44]
#CHECK: vone    %v22                    # encoding: [0xe7,0x60,0xff,0xff,0x08,0x44]
#CHECK: vone    %v31                    # encoding: [0xe7,0xf0,0xff,0xff,0x08,0x44]

	vone	%v0
	vone	%v15
	vone	%v22
	vone	%v31

#CHECK: vpdi    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x84]
#CHECK: vpdi    %v0, %v0, %v0, 5        # encoding: [0xe7,0x00,0x00,0x00,0x50,0x84]
#CHECK: vpdi    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x84]
#CHECK: vpdi    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x84]
#CHECK: vpdi    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x84]
#CHECK: vpdi    %v13, %v17, %v21, 4     # encoding: [0xe7,0xd1,0x50,0x00,0x46,0x84]

	vpdi	%v0, %v0, %v0, 0
	vpdi	%v0, %v0, %v0, 5
	vpdi	%v0, %v0, %v31, 0
	vpdi	%v0, %v31, %v0, 0
	vpdi	%v31, %v0, %v0, 0
	vpdi	%v13, %v17, %v21, 4

#CHECK: vperm   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8c]
#CHECK: vperm   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8c]
#CHECK: vperm   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8c]
#CHECK: vperm   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8c]
#CHECK: vperm   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8c]
#CHECK: vperm   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0x8c]

	vperm	%v0, %v0, %v0, %v0
	vperm	%v0, %v0, %v0, %v31
	vperm	%v0, %v0, %v31, %v0
	vperm	%v0, %v31, %v0, %v0
	vperm	%v31, %v0, %v0, %v0
	vperm	%v13, %v17, %v21, %v25

#CHECK: vpk     %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x94]
#CHECK: vpk     %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x94]
#CHECK: vpk     %v0, %v0, %v15, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x94]
#CHECK: vpk     %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x94]
#CHECK: vpk     %v0, %v15, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x94]
#CHECK: vpk     %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x94]
#CHECK: vpk     %v15, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x94]
#CHECK: vpk     %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x94]
#CHECK: vpk     %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x94]

	vpk	%v0, %v0, %v0, 0
	vpk	%v0, %v0, %v0, 15
	vpk	%v0, %v0, %v15, 0
	vpk	%v0, %v0, %v31, 0
	vpk	%v0, %v15, %v0, 0
	vpk	%v0, %v31, %v0, 0
	vpk	%v15, %v0, %v0, 0
	vpk	%v31, %v0, %v0, 0
	vpk	%v18, %v3, %v20, 11

#CHECK: vpkf    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x94]
#CHECK: vpkf    %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x94]
#CHECK: vpkf    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x94]
#CHECK: vpkf    %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x94]
#CHECK: vpkf    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x94]
#CHECK: vpkf    %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x94]
#CHECK: vpkf    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x94]
#CHECK: vpkf    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x94]

	vpkf	%v0, %v0, %v0
	vpkf	%v0, %v0, %v15
	vpkf	%v0, %v0, %v31
	vpkf	%v0, %v15, %v0
	vpkf	%v0, %v31, %v0
	vpkf	%v15, %v0, %v0
	vpkf	%v31, %v0, %v0
	vpkf	%v18, %v3, %v20

#CHECK: vpkg    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x94]
#CHECK: vpkg    %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x94]
#CHECK: vpkg    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x94]
#CHECK: vpkg    %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x94]
#CHECK: vpkg    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x94]
#CHECK: vpkg    %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x94]
#CHECK: vpkg    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x94]
#CHECK: vpkg    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x94]

	vpkg	%v0, %v0, %v0
	vpkg	%v0, %v0, %v15
	vpkg	%v0, %v0, %v31
	vpkg	%v0, %v15, %v0
	vpkg	%v0, %v31, %v0
	vpkg	%v15, %v0, %v0
	vpkg	%v31, %v0, %v0
	vpkg	%v18, %v3, %v20

#CHECK: vpkh    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x94]
#CHECK: vpkh    %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x94]
#CHECK: vpkh    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x94]
#CHECK: vpkh    %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x94]
#CHECK: vpkh    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x94]
#CHECK: vpkh    %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x94]
#CHECK: vpkh    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x94]
#CHECK: vpkh    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x94]

	vpkh	%v0, %v0, %v0
	vpkh	%v0, %v0, %v15
	vpkh	%v0, %v0, %v31
	vpkh	%v0, %v15, %v0
	vpkh	%v0, %v31, %v0
	vpkh	%v15, %v0, %v0
	vpkh	%v31, %v0, %v0
	vpkh	%v18, %v3, %v20

#CHECK: vpkls   %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x95]
#CHECK: vpkls   %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x95]
#CHECK: vpkls   %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0xf0,0x00,0x95]
#CHECK: vpkls   %v0, %v0, %v15, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x95]
#CHECK: vpkls   %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x95]
#CHECK: vpkls   %v0, %v15, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x95]
#CHECK: vpkls   %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x95]
#CHECK: vpkls   %v15, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x95]
#CHECK: vpkls   %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x95]
#CHECK: vpkls   %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x90,0xba,0x95]

	vpkls	%v0, %v0, %v0, 0, 0
	vpkls	%v0, %v0, %v0, 15, 0
	vpkls	%v0, %v0, %v0, 0, 15
	vpkls	%v0, %v0, %v15, 0, 0
	vpkls	%v0, %v0, %v31, 0, 0
	vpkls	%v0, %v15, %v0, 0, 0
	vpkls	%v0, %v31, %v0, 0, 0
	vpkls	%v15, %v0, %v0, 0, 0
	vpkls	%v31, %v0, %v0, 0, 0
	vpkls	%v18, %v3, %v20, 11, 9

#CHECK: vpklsf  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x95]
#CHECK: vpklsf  %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x95]
#CHECK: vpklsf  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x95]
#CHECK: vpklsf  %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x95]
#CHECK: vpklsf  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x95]
#CHECK: vpklsf  %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x95]
#CHECK: vpklsf  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x95]
#CHECK: vpklsf  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x95]
#CHECK: vpklsfs %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x24,0x95]

	vpklsf	%v0, %v0, %v0
	vpklsf	%v0, %v0, %v15
	vpklsf	%v0, %v0, %v31
	vpklsf	%v0, %v15, %v0
	vpklsf	%v0, %v31, %v0
	vpklsf	%v15, %v0, %v0
	vpklsf	%v31, %v0, %v0
	vpklsf	%v18, %v3, %v20
	vpklsfs	%v5, %v22, %v7

#CHECK: vpklsg  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x95]
#CHECK: vpklsg  %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x95]
#CHECK: vpklsg  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x95]
#CHECK: vpklsg  %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x95]
#CHECK: vpklsg  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x95]
#CHECK: vpklsg  %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x95]
#CHECK: vpklsg  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x95]
#CHECK: vpklsg  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x95]
#CHECK: vpklsgs %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x34,0x95]

	vpklsg	%v0, %v0, %v0
	vpklsg	%v0, %v0, %v15
	vpklsg	%v0, %v0, %v31
	vpklsg	%v0, %v15, %v0
	vpklsg	%v0, %v31, %v0
	vpklsg	%v15, %v0, %v0
	vpklsg	%v31, %v0, %v0
	vpklsg	%v18, %v3, %v20
	vpklsgs	%v5, %v22, %v7

#CHECK: vpklsh  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x95]
#CHECK: vpklsh  %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x95]
#CHECK: vpklsh  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x95]
#CHECK: vpklsh  %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x95]
#CHECK: vpklsh  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x95]
#CHECK: vpklsh  %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x95]
#CHECK: vpklsh  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x95]
#CHECK: vpklsh  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x95]
#CHECK: vpklshs %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x14,0x95]

	vpklsh	%v0, %v0, %v0
	vpklsh	%v0, %v0, %v15
	vpklsh	%v0, %v0, %v31
	vpklsh	%v0, %v15, %v0
	vpklsh	%v0, %v31, %v0
	vpklsh	%v15, %v0, %v0
	vpklsh	%v31, %v0, %v0
	vpklsh	%v18, %v3, %v20
	vpklshs	%v5, %v22, %v7

#CHECK: vpks    %v0, %v0, %v0, 0, 0     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x97]
#CHECK: vpks    %v0, %v0, %v0, 15, 0    # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x97]
#CHECK: vpks    %v0, %v0, %v0, 0, 15    # encoding: [0xe7,0x00,0x00,0xf0,0x00,0x97]
#CHECK: vpks    %v0, %v0, %v15, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x97]
#CHECK: vpks    %v0, %v0, %v31, 0, 0    # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x97]
#CHECK: vpks    %v0, %v15, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x97]
#CHECK: vpks    %v0, %v31, %v0, 0, 0    # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x97]
#CHECK: vpks    %v15, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x97]
#CHECK: vpks    %v31, %v0, %v0, 0, 0    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x97]
#CHECK: vpks    %v18, %v3, %v20, 11, 9  # encoding: [0xe7,0x23,0x40,0x90,0xba,0x97]

	vpks	%v0, %v0, %v0, 0, 0
	vpks	%v0, %v0, %v0, 15, 0
	vpks	%v0, %v0, %v0, 0, 15
	vpks	%v0, %v0, %v15, 0, 0
	vpks	%v0, %v0, %v31, 0, 0
	vpks	%v0, %v15, %v0, 0, 0
	vpks	%v0, %v31, %v0, 0, 0
	vpks	%v15, %v0, %v0, 0, 0
	vpks	%v31, %v0, %v0, 0, 0
	vpks	%v18, %v3, %v20, 11, 9

#CHECK: vpksf   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x97]
#CHECK: vpksf   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x20,0x97]
#CHECK: vpksf   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x97]
#CHECK: vpksf   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x97]
#CHECK: vpksf   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x97]
#CHECK: vpksf   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x97]
#CHECK: vpksf   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x97]
#CHECK: vpksf   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x97]
#CHECK: vpksfs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x24,0x97]

	vpksf	%v0, %v0, %v0
	vpksf	%v0, %v0, %v15
	vpksf	%v0, %v0, %v31
	vpksf	%v0, %v15, %v0
	vpksf	%v0, %v31, %v0
	vpksf	%v15, %v0, %v0
	vpksf	%v31, %v0, %v0
	vpksf	%v18, %v3, %v20
	vpksfs	%v5, %v22, %v7

#CHECK: vpksg   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x97]
#CHECK: vpksg   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x30,0x97]
#CHECK: vpksg   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x97]
#CHECK: vpksg   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x97]
#CHECK: vpksg   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x97]
#CHECK: vpksg   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x97]
#CHECK: vpksg   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x97]
#CHECK: vpksg   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x97]
#CHECK: vpksgs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x34,0x97]

	vpksg	%v0, %v0, %v0
	vpksg	%v0, %v0, %v15
	vpksg	%v0, %v0, %v31
	vpksg	%v0, %v15, %v0
	vpksg	%v0, %v31, %v0
	vpksg	%v15, %v0, %v0
	vpksg	%v31, %v0, %v0
	vpksg	%v18, %v3, %v20
	vpksgs	%v5, %v22, %v7

#CHECK: vpksh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x97]
#CHECK: vpksh   %v0, %v0, %v15          # encoding: [0xe7,0x00,0xf0,0x00,0x10,0x97]
#CHECK: vpksh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x97]
#CHECK: vpksh   %v0, %v15, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x97]
#CHECK: vpksh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x97]
#CHECK: vpksh   %v15, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x97]
#CHECK: vpksh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x97]
#CHECK: vpksh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x97]
#CHECK: vpkshs  %v5, %v22, %v7          # encoding: [0xe7,0x56,0x70,0x10,0x14,0x97]

	vpksh	%v0, %v0, %v0
	vpksh	%v0, %v0, %v15
	vpksh	%v0, %v0, %v31
	vpksh	%v0, %v15, %v0
	vpksh	%v0, %v31, %v0
	vpksh	%v15, %v0, %v0
	vpksh	%v31, %v0, %v0
	vpksh	%v18, %v3, %v20
	vpkshs	%v5, %v22, %v7

#CHECK: vpopct  %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x50]
#CHECK: vpopct  %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x50]
#CHECK: vpopct  %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x50]
#CHECK: vpopct  %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x50]
#CHECK: vpopct  %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x50]
#CHECK: vpopct  %v14, %v17, 0           # encoding: [0xe7,0xe1,0x00,0x00,0x04,0x50]

	vpopct	%v0, %v0, 0
	vpopct	%v0, %v15, 0
	vpopct	%v0, %v31, 0
	vpopct	%v15, %v0, 0
	vpopct	%v31, %v0, 0
	vpopct	%v14, %v17, 0

#CHECK: vrep    %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0x4d]
#CHECK: vrep    %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x4d]
#CHECK: vrep    %v0, %v0, 65535, 0      # encoding: [0xe7,0x00,0xff,0xff,0x00,0x4d]
#CHECK: vrep    %v0, %v15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x4d]
#CHECK: vrep    %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x4d]
#CHECK: vrep    %v15, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x4d]
#CHECK: vrep    %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x4d]
#CHECK: vrep    %v4, %v21, 26505, 11    # encoding: [0xe7,0x45,0x67,0x89,0xb4,0x4d]

	vrep	%v0, %v0, 0, 0
	vrep	%v0, %v0, 0, 15
	vrep	%v0, %v0, 65535, 0
	vrep	%v0, %v15, 0, 0
	vrep	%v0, %v31, 0, 0
	vrep	%v15, %v0, 0, 0
	vrep	%v31, %v0, 0, 0
	vrep	%v4, %v21, 0x6789, 11

#CHECK: vrepb   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x4d]
#CHECK: vrepb   %v0, %v0, 65535         # encoding: [0xe7,0x00,0xff,0xff,0x00,0x4d]
#CHECK: vrepb   %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x4d]
#CHECK: vrepb   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x4d]
#CHECK: vrepb   %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x4d]
#CHECK: vrepb   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x4d]
#CHECK: vrepb   %v4, %v21, 26505        # encoding: [0xe7,0x45,0x67,0x89,0x04,0x4d]

	vrepb	%v0, %v0, 0
	vrepb	%v0, %v0, 65535
	vrepb	%v0, %v15, 0
	vrepb	%v0, %v31, 0
	vrepb	%v15, %v0, 0
	vrepb	%v31, %v0, 0
	vrepb	%v4, %v21, 0x6789

#CHECK: vrepf   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x20,0x4d]
#CHECK: vrepf   %v0, %v0, 65535         # encoding: [0xe7,0x00,0xff,0xff,0x20,0x4d]
#CHECK: vrepf   %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x4d]
#CHECK: vrepf   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x4d]
#CHECK: vrepf   %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x4d]
#CHECK: vrepf   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x4d]
#CHECK: vrepf   %v4, %v21, 26505        # encoding: [0xe7,0x45,0x67,0x89,0x24,0x4d]

	vrepf	%v0, %v0, 0
	vrepf	%v0, %v0, 65535
	vrepf	%v0, %v15, 0
	vrepf	%v0, %v31, 0
	vrepf	%v15, %v0, 0
	vrepf	%v31, %v0, 0
	vrepf	%v4, %v21, 0x6789

#CHECK: vrepg   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x30,0x4d]
#CHECK: vrepg   %v0, %v0, 65535         # encoding: [0xe7,0x00,0xff,0xff,0x30,0x4d]
#CHECK: vrepg   %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x30,0x4d]
#CHECK: vrepg   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x4d]
#CHECK: vrepg   %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x4d]
#CHECK: vrepg   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x4d]
#CHECK: vrepg   %v4, %v21, 26505        # encoding: [0xe7,0x45,0x67,0x89,0x34,0x4d]

	vrepg	%v0, %v0, 0
	vrepg	%v0, %v0, 65535
	vrepg	%v0, %v15, 0
	vrepg	%v0, %v31, 0
	vrepg	%v15, %v0, 0
	vrepg	%v31, %v0, 0
	vrepg	%v4, %v21, 0x6789

#CHECK: vreph   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x10,0x4d]
#CHECK: vreph   %v0, %v0, 65535         # encoding: [0xe7,0x00,0xff,0xff,0x10,0x4d]
#CHECK: vreph   %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x4d]
#CHECK: vreph   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x4d]
#CHECK: vreph   %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x4d]
#CHECK: vreph   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x4d]
#CHECK: vreph   %v4, %v21, 26505        # encoding: [0xe7,0x45,0x67,0x89,0x14,0x4d]

	vreph	%v0, %v0, 0
	vreph	%v0, %v0, 65535
	vreph	%v0, %v15, 0
	vreph	%v0, %v31, 0
	vreph	%v15, %v0, 0
	vreph	%v31, %v0, 0
	vreph	%v4, %v21, 0x6789

#CHECK: vrepi   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x45]
#CHECK: vrepi   %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x45]
#CHECK: vrepi   %v0, -32768, 0          # encoding: [0xe7,0x00,0x80,0x00,0x00,0x45]
#CHECK: vrepi   %v0, 32767, 0           # encoding: [0xe7,0x00,0x7f,0xff,0x00,0x45]
#CHECK: vrepi   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x45]
#CHECK: vrepi   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x45]
#CHECK: vrepi   %v18, 13398, 11         # encoding: [0xe7,0x20,0x34,0x56,0xb8,0x45]

	vrepi	%v0, 0, 0
	vrepi	%v0, 0, 15
	vrepi	%v0, -32768, 0
	vrepi	%v0, 32767, 0
	vrepi	%v15, 0, 0
	vrepi	%v31, 0, 0
	vrepi	%v18, 0x3456, 11

#CHECK: vrepib  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x45]
#CHECK: vrepib  %v0, -32768             # encoding: [0xe7,0x00,0x80,0x00,0x00,0x45]
#CHECK: vrepib  %v0, 32767              # encoding: [0xe7,0x00,0x7f,0xff,0x00,0x45]
#CHECK: vrepib  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x45]
#CHECK: vrepib  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x45]
#CHECK: vrepib  %v18, 13398             # encoding: [0xe7,0x20,0x34,0x56,0x08,0x45]

	vrepib	%v0, 0
	vrepib	%v0, -32768
	vrepib	%v0, 32767
	vrepib	%v15, 0
	vrepib	%v31, 0
	vrepib	%v18, 0x3456

#CHECK: vrepif  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x20,0x45]
#CHECK: vrepif  %v0, -32768             # encoding: [0xe7,0x00,0x80,0x00,0x20,0x45]
#CHECK: vrepif  %v0, 32767              # encoding: [0xe7,0x00,0x7f,0xff,0x20,0x45]
#CHECK: vrepif  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x45]
#CHECK: vrepif  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x45]
#CHECK: vrepif  %v18, 13398             # encoding: [0xe7,0x20,0x34,0x56,0x28,0x45]

	vrepif	%v0, 0
	vrepif	%v0, -32768
	vrepif	%v0, 32767
	vrepif	%v15, 0
	vrepif	%v31, 0
	vrepif	%v18, 0x3456

#CHECK: vrepig  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x30,0x45]
#CHECK: vrepig  %v0, -32768             # encoding: [0xe7,0x00,0x80,0x00,0x30,0x45]
#CHECK: vrepig  %v0, 32767              # encoding: [0xe7,0x00,0x7f,0xff,0x30,0x45]
#CHECK: vrepig  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x30,0x45]
#CHECK: vrepig  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x45]
#CHECK: vrepig  %v18, 13398             # encoding: [0xe7,0x20,0x34,0x56,0x38,0x45]

	vrepig	%v0, 0
	vrepig	%v0, -32768
	vrepig	%v0, 32767
	vrepig	%v15, 0
	vrepig	%v31, 0
	vrepig	%v18, 0x3456

#CHECK: vrepih  %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x10,0x45]
#CHECK: vrepih  %v0, -32768             # encoding: [0xe7,0x00,0x80,0x00,0x10,0x45]
#CHECK: vrepih  %v0, 32767              # encoding: [0xe7,0x00,0x7f,0xff,0x10,0x45]
#CHECK: vrepih  %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x45]
#CHECK: vrepih  %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x45]
#CHECK: vrepih  %v18, 13398             # encoding: [0xe7,0x20,0x34,0x56,0x18,0x45]

	vrepih	%v0, 0
	vrepih	%v0, -32768
	vrepih	%v0, 32767
	vrepih	%v15, 0
	vrepih	%v31, 0
	vrepih	%v18, 0x3456

#CHECK: vs      %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf7]
#CHECK: vs      %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf7]
#CHECK: vs      %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf7]
#CHECK: vs      %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf7]
#CHECK: vs      %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf7]
#CHECK: vs      %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xf7]

	vs	%v0, %v0, %v0, 0
	vs	%v0, %v0, %v0, 15
	vs	%v0, %v0, %v31, 0
	vs	%v0, %v31, %v0, 0
	vs	%v31, %v0, %v0, 0
	vs	%v18, %v3, %v20, 11

#CHECK: vsb     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf7]
#CHECK: vsb     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf7]
#CHECK: vsb     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf7]
#CHECK: vsb     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf7]
#CHECK: vsb     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf7]

	vsb	%v0, %v0, %v0
	vsb	%v0, %v0, %v31
	vsb	%v0, %v31, %v0
	vsb	%v31, %v0, %v0
	vsb	%v18, %v3, %v20

#CHECK: vsbcbi  %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xbd]
#CHECK: vsbcbi  %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xbd]
#CHECK: vsbcbi  %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xbd]
#CHECK: vsbcbi  %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xbd]
#CHECK: vsbcbi  %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xbd]
#CHECK: vsbcbi  %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xbd]
#CHECK: vsbcbi  %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xbd]

	vsbcbi	%v0, %v0, %v0, %v0, 0
	vsbcbi	%v0, %v0, %v0, %v0, 15
	vsbcbi	%v0, %v0, %v0, %v31, 0
	vsbcbi	%v0, %v0, %v31, %v0, 0
	vsbcbi	%v0, %v31, %v0, %v0, 0
	vsbcbi	%v31, %v0, %v0, %v0, 0
	vsbcbi	%v13, %v17, %v21, %v25, 11

#CHECK: vsbcbiq %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0xbd]
#CHECK: vsbcbiq %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0xbd]
#CHECK: vsbcbiq %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0xbd]
#CHECK: vsbcbiq %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0xbd]
#CHECK: vsbcbiq %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0xbd]
#CHECK: vsbcbiq %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0xbd]

	vsbcbiq	%v0, %v0, %v0, %v0
	vsbcbiq	%v0, %v0, %v0, %v31
	vsbcbiq	%v0, %v0, %v31, %v0
	vsbcbiq	%v0, %v31, %v0, %v0
	vsbcbiq	%v31, %v0, %v0, %v0
	vsbcbiq	%v13, %v17, %v21, %v25

#CHECK: vsbi    %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0xbf]
#CHECK: vsbi    %v0, %v0, %v0, %v0, 15  # encoding: [0xe7,0x00,0x0f,0x00,0x00,0xbf]
#CHECK: vsbi    %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0xbf]
#CHECK: vsbi    %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xbf]
#CHECK: vsbi    %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xbf]
#CHECK: vsbi    %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xbf]
#CHECK: vsbi    %v13, %v17, %v21, %v25, 11 # encoding: [0xe7,0xd1,0x5b,0x00,0x97,0xbf]

	vsbi	%v0, %v0, %v0, %v0, 0
	vsbi	%v0, %v0, %v0, %v0, 15
	vsbi	%v0, %v0, %v0, %v31, 0
	vsbi	%v0, %v0, %v31, %v0, 0
	vsbi	%v0, %v31, %v0, %v0, 0
	vsbi	%v31, %v0, %v0, %v0, 0
	vsbi	%v13, %v17, %v21, %v25, 11

#CHECK: vsbiq   %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x04,0x00,0x00,0xbf]
#CHECK: vsbiq   %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x04,0x00,0xf1,0xbf]
#CHECK: vsbiq   %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf4,0x00,0x02,0xbf]
#CHECK: vsbiq   %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x04,0x00,0x04,0xbf]
#CHECK: vsbiq   %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x04,0x00,0x08,0xbf]
#CHECK: vsbiq   %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x54,0x00,0x97,0xbf]

	vsbiq	%v0, %v0, %v0, %v0
	vsbiq	%v0, %v0, %v0, %v31
	vsbiq	%v0, %v0, %v31, %v0
	vsbiq	%v0, %v31, %v0, %v0
	vsbiq	%v31, %v0, %v0, %v0
	vsbiq	%v13, %v17, %v21, %v25

#CHECK: vscbi   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf5]
#CHECK: vscbi   %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xf5]
#CHECK: vscbi   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf5]
#CHECK: vscbi   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf5]
#CHECK: vscbi   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf5]
#CHECK: vscbi   %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0xf5]

	vscbi	%v0, %v0, %v0, 0
	vscbi	%v0, %v0, %v0, 15
	vscbi	%v0, %v0, %v31, 0
	vscbi	%v0, %v31, %v0, 0
	vscbi	%v31, %v0, %v0, 0
	vscbi	%v18, %v3, %v20, 11

#CHECK: vscbib  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0xf5]
#CHECK: vscbib  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0xf5]
#CHECK: vscbib  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xf5]
#CHECK: vscbib  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xf5]
#CHECK: vscbib  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0xf5]

	vscbib	%v0, %v0, %v0
	vscbib	%v0, %v0, %v31
	vscbib	%v0, %v31, %v0
	vscbib	%v31, %v0, %v0
	vscbib	%v18, %v3, %v20

#CHECK: vscbif  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf5]
#CHECK: vscbif  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf5]
#CHECK: vscbif  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf5]
#CHECK: vscbif  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf5]
#CHECK: vscbif  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf5]

	vscbif	%v0, %v0, %v0
	vscbif	%v0, %v0, %v31
	vscbif	%v0, %v31, %v0
	vscbif	%v31, %v0, %v0
	vscbif	%v18, %v3, %v20

#CHECK: vscbig  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf5]
#CHECK: vscbig  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf5]
#CHECK: vscbig  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf5]
#CHECK: vscbig  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf5]
#CHECK: vscbig  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf5]

	vscbig	%v0, %v0, %v0
	vscbig	%v0, %v0, %v31
	vscbig	%v0, %v31, %v0
	vscbig	%v31, %v0, %v0
	vscbig	%v18, %v3, %v20

#CHECK: vscbih  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf5]
#CHECK: vscbih  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf5]
#CHECK: vscbih  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf5]
#CHECK: vscbih  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf5]
#CHECK: vscbih  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf5]

	vscbih	%v0, %v0, %v0
	vscbih	%v0, %v0, %v31
	vscbih	%v0, %v31, %v0
	vscbih	%v31, %v0, %v0
	vscbih	%v18, %v3, %v20

#CHECK: vscbiq  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf5]
#CHECK: vscbiq  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf5]
#CHECK: vscbiq  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf5]
#CHECK: vscbiq  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf5]
#CHECK: vscbiq  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf5]

	vscbiq	%v0, %v0, %v0
	vscbiq	%v0, %v0, %v31
	vscbiq	%v0, %v31, %v0
	vscbiq	%v31, %v0, %v0
	vscbiq	%v18, %v3, %v20

#CHECK: vscef   %v0, 0(%v0,0), 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x1b]
#CHECK: vscef   %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x1b]
#CHECK: vscef   %v0, 0(%v0,%r1), 3      # encoding: [0xe7,0x00,0x10,0x00,0x30,0x1b]
#CHECK: vscef   %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x1b]
#CHECK: vscef   %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x1b]
#CHECK: vscef   %v0, 0(%v31,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x04,0x1b]
#CHECK: vscef   %v0, 4095(%v0,%r1), 0   # encoding: [0xe7,0x00,0x1f,0xff,0x00,0x1b]
#CHECK: vscef   %v15, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x00,0x1b]
#CHECK: vscef   %v31, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x08,0x1b]
#CHECK: vscef   %v10, 1000(%v19,%r7), 1 # encoding: [0xe7,0xa3,0x73,0xe8,0x14,0x1b]

	vscef	%v0, 0(%v0), 0
	vscef	%v0, 0(%v0,%r1), 0
	vscef	%v0, 0(%v0,%r1), 3
	vscef	%v0, 0(%v0,%r15), 0
	vscef	%v0, 0(%v15,%r1), 0
	vscef	%v0, 0(%v31,%r1), 0
	vscef	%v0, 4095(%v0, %r1), 0
	vscef	%v15, 0(%v0,%r1), 0
	vscef	%v31, 0(%v0,%r1), 0
	vscef	%v10, 1000(%v19,%r7), 1

#CHECK: vsceg   %v0, 0(%v0,0), 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x1a]
#CHECK: vsceg   %v0, 0(%v0,%r1), 0      # encoding: [0xe7,0x00,0x10,0x00,0x00,0x1a]
#CHECK: vsceg   %v0, 0(%v0,%r1), 1      # encoding: [0xe7,0x00,0x10,0x00,0x10,0x1a]
#CHECK: vsceg   %v0, 0(%v0,%r15), 0     # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x1a]
#CHECK: vsceg   %v0, 0(%v15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x1a]
#CHECK: vsceg   %v0, 0(%v31,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x04,0x1a]
#CHECK: vsceg   %v0, 4095(%v0,%r1), 0   # encoding: [0xe7,0x00,0x1f,0xff,0x00,0x1a]
#CHECK: vsceg   %v15, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x00,0x1a]
#CHECK: vsceg   %v31, 0(%v0,%r1), 0     # encoding: [0xe7,0xf0,0x10,0x00,0x08,0x1a]
#CHECK: vsceg   %v10, 1000(%v19,%r7), 1 # encoding: [0xe7,0xa3,0x73,0xe8,0x14,0x1a]

	vsceg	%v0, 0(%v0), 0
	vsceg	%v0, 0(%v0,%r1), 0
	vsceg	%v0, 0(%v0,%r1), 1
	vsceg	%v0, 0(%v0,%r15), 0
	vsceg	%v0, 0(%v15,%r1), 0
	vsceg	%v0, 0(%v31,%r1), 0
	vsceg	%v0, 4095(%v0,%r1), 0
	vsceg	%v15, 0(%v0,%r1), 0
	vsceg	%v31, 0(%v0,%r1), 0
	vsceg	%v10, 1000(%v19,%r7), 1

#CHECK: vseg    %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x5f]
#CHECK: vseg    %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x5f]
#CHECK: vseg    %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x5f]
#CHECK: vseg    %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x5f]
#CHECK: vseg    %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x5f]
#CHECK: vseg    %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x5f]
#CHECK: vseg    %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0x5f]

	vseg	%v0, %v0, 0
	vseg	%v0, %v0, 15
	vseg	%v0, %v15, 0
	vseg	%v0, %v31, 0
	vseg	%v15, %v0, 0
	vseg	%v31, %v0, 0
	vseg	%v14, %v17, 11

#CHECK: vsegb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0x5f]
#CHECK: vsegb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x5f]
#CHECK: vsegb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x5f]
#CHECK: vsegb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x5f]
#CHECK: vsegb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x5f]
#CHECK: vsegb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0x5f]

	vsegb	%v0, %v0
	vsegb	%v0, %v15
	vsegb	%v0, %v31
	vsegb	%v15, %v0
	vsegb	%v31, %v0
	vsegb	%v14, %v17

#CHECK: vsegf   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0x5f]
#CHECK: vsegf   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0x5f]
#CHECK: vsegf   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x5f]
#CHECK: vsegf   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0x5f]
#CHECK: vsegf   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x5f]
#CHECK: vsegf   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0x5f]

	vsegf	%v0, %v0
	vsegf	%v0, %v15
	vsegf	%v0, %v31
	vsegf	%v15, %v0
	vsegf	%v31, %v0
	vsegf	%v14, %v17

#CHECK: vsegh   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0x5f]
#CHECK: vsegh   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0x5f]
#CHECK: vsegh   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x5f]
#CHECK: vsegh   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0x5f]
#CHECK: vsegh   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x5f]
#CHECK: vsegh   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0x5f]

	vsegh	%v0, %v0
	vsegh	%v0, %v15
	vsegh	%v0, %v31
	vsegh	%v15, %v0
	vsegh	%v31, %v0
	vsegh	%v14, %v17

#CHECK: vsel    %v0, %v0, %v0, %v0      # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8d]
#CHECK: vsel    %v0, %v0, %v0, %v31     # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8d]
#CHECK: vsel    %v0, %v0, %v31, %v0     # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8d]
#CHECK: vsel    %v0, %v31, %v0, %v0     # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8d]
#CHECK: vsel    %v31, %v0, %v0, %v0     # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8d]
#CHECK: vsel    %v13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x50,0x00,0x97,0x8d]

	vsel	%v0, %v0, %v0, %v0
	vsel	%v0, %v0, %v0, %v31
	vsel	%v0, %v0, %v31, %v0
	vsel	%v0, %v31, %v0, %v0
	vsel	%v31, %v0, %v0, %v0
	vsel 	%v13, %v17, %v21, %v25

#CHECK: vsf     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0xf7]
#CHECK: vsf     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0xf7]
#CHECK: vsf     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xf7]
#CHECK: vsf     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xf7]
#CHECK: vsf     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0xf7]

	vsf	%v0, %v0, %v0
	vsf	%v0, %v0, %v31
	vsf	%v0, %v31, %v0
	vsf	%v31, %v0, %v0
	vsf	%v18, %v3, %v20

#CHECK: vsg     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0xf7]
#CHECK: vsg     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0xf7]
#CHECK: vsg     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xf7]
#CHECK: vsg     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xf7]
#CHECK: vsg     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0xf7]

	vsg	%v0, %v0, %v0
	vsg	%v0, %v0, %v31
	vsg	%v0, %v31, %v0
	vsg	%v31, %v0, %v0
	vsg	%v18, %v3, %v20

#CHECK: vsh     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0xf7]
#CHECK: vsh     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0xf7]
#CHECK: vsh     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xf7]
#CHECK: vsh     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xf7]
#CHECK: vsh     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0xf7]

	vsh	%v0, %v0, %v0
	vsh	%v0, %v0, %v31
	vsh	%v0, %v31, %v0
	vsh	%v31, %v0, %v0
	vsh	%v18, %v3, %v20

#CHECK: vsl     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x74]
#CHECK: vsl     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x74]
#CHECK: vsl     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x74]
#CHECK: vsl     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x74]
#CHECK: vsl     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x74]

	vsl	%v0, %v0, %v0
	vsl	%v0, %v0, %v31
	vsl	%v0, %v31, %v0
	vsl	%v31, %v0, %v0
	vsl	%v18, %v3, %v20

#CHECK: vslb    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x75]
#CHECK: vslb    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x75]
#CHECK: vslb    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x75]
#CHECK: vslb    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x75]
#CHECK: vslb    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x75]

	vslb	%v0, %v0, %v0
	vslb	%v0, %v0, %v31
	vslb	%v0, %v31, %v0
	vslb	%v31, %v0, %v0
	vslb	%v18, %v3, %v20

#CHECK: vsldb   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x77]
#CHECK: vsldb   %v0, %v0, %v0, 255      # encoding: [0xe7,0x00,0x00,0xff,0x00,0x77]
#CHECK: vsldb   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x77]
#CHECK: vsldb   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x77]
#CHECK: vsldb   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x77]
#CHECK: vsldb   %v13, %v17, %v21, 121   # encoding: [0xe7,0xd1,0x50,0x79,0x06,0x77]

	vsldb	%v0, %v0, %v0, 0
	vsldb	%v0, %v0, %v0, 255
	vsldb	%v0, %v0, %v31, 0
	vsldb	%v0, %v31, %v0, 0
	vsldb	%v31, %v0, %v0, 0
	vsldb 	%v13, %v17, %v21, 0x79

#CHECK: vsq     %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x40,0xf7]
#CHECK: vsq     %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x42,0xf7]
#CHECK: vsq     %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x44,0xf7]
#CHECK: vsq     %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x48,0xf7]
#CHECK: vsq     %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x4a,0xf7]

	vsq	%v0, %v0, %v0
	vsq	%v0, %v0, %v31
	vsq	%v0, %v31, %v0
	vsq	%v31, %v0, %v0
	vsq	%v18, %v3, %v20

#CHECK: vsra    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x7e]
#CHECK: vsra    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x7e]
#CHECK: vsra    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x7e]
#CHECK: vsra    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x7e]
#CHECK: vsra    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x7e]

	vsra	%v0, %v0, %v0
	vsra	%v0, %v0, %v31
	vsra	%v0, %v31, %v0
	vsra	%v31, %v0, %v0
	vsra	%v18, %v3, %v20

#CHECK: vsrab   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x7f]
#CHECK: vsrab   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x7f]
#CHECK: vsrab   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x7f]
#CHECK: vsrab   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x7f]
#CHECK: vsrab   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x7f]

	vsrab	%v0, %v0, %v0
	vsrab	%v0, %v0, %v31
	vsrab	%v0, %v31, %v0
	vsrab	%v31, %v0, %v0
	vsrab	%v18, %v3, %v20

#CHECK: vsrl    %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x7c]
#CHECK: vsrl    %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x7c]
#CHECK: vsrl    %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x7c]
#CHECK: vsrl    %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x7c]
#CHECK: vsrl    %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x7c]

	vsrl	%v0, %v0, %v0
	vsrl	%v0, %v0, %v31
	vsrl	%v0, %v31, %v0
	vsrl	%v31, %v0, %v0
	vsrl	%v18, %v3, %v20

#CHECK: vsrlb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x7d]
#CHECK: vsrlb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x7d]
#CHECK: vsrlb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x7d]
#CHECK: vsrlb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x7d]
#CHECK: vsrlb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x7d]

	vsrlb	%v0, %v0, %v0
	vsrlb	%v0, %v0, %v31
	vsrlb	%v0, %v31, %v0
	vsrlb	%v31, %v0, %v0
	vsrlb	%v18, %v3, %v20

#CHECK: vst     %v0, 0                  # encoding: [0xe7,0x00,0x00,0x00,0x00,0x0e]
#CHECK: vst     %v0, 4095               # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x0e]
#CHECK: vst     %v0, 0(%r15)            # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x0e]
#CHECK: vst     %v0, 0(%r15,%r1)        # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x0e]
#CHECK: vst     %v0, 0(%r15,%r1), 4     # encoding: [0xe7,0x0f,0x10,0x00,0x40,0x0e]
#CHECK: vst     %v15, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x0e]
#CHECK: vst     %v31, 0                 # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x0e]
#CHECK: vst     %v18, 1383(%r3,%r4), 3  # encoding: [0xe7,0x23,0x45,0x67,0x38,0x0e]

	vst	%v0, 0
	vst	%v0, 4095
	vst	%v0, 0(%r15)
	vst	%v0, 0(%r15,%r1)
	vst	%v0, 0(%r15,%r1), 4
	vst	%v15, 0
	vst	%v31, 0
	vst	%v18, 0x567(%r3,%r4), 3

#CHECK: vsteb   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x08]
#CHECK: vsteb   %v0, 0, 15              # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x08]
#CHECK: vsteb   %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x08]
#CHECK: vsteb   %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x08]
#CHECK: vsteb   %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x08]
#CHECK: vsteb   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x08]
#CHECK: vsteb   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x08]
#CHECK: vsteb   %v18, 1383(%r3,%r4), 8  # encoding: [0xe7,0x23,0x45,0x67,0x88,0x08]

	vsteb	%v0, 0, 0
	vsteb	%v0, 0, 15
	vsteb	%v0, 4095, 0
	vsteb	%v0, 0(%r15), 0
	vsteb	%v0, 0(%r15,%r1), 0
	vsteb	%v15, 0, 0
	vsteb	%v31, 0, 0
	vsteb	%v18, 1383(%r3,%r4), 8

#CHECK: vstef   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x0b]
#CHECK: vstef   %v0, 0, 3               # encoding: [0xe7,0x00,0x00,0x00,0x30,0x0b]
#CHECK: vstef   %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x0b]
#CHECK: vstef   %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x0b]
#CHECK: vstef   %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x0b]
#CHECK: vstef   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x0b]
#CHECK: vstef   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x0b]
#CHECK: vstef   %v18, 1383(%r3,%r4), 2  # encoding: [0xe7,0x23,0x45,0x67,0x28,0x0b]

	vstef	%v0, 0, 0
	vstef	%v0, 0, 3
	vstef	%v0, 4095, 0
	vstef	%v0, 0(%r15), 0
	vstef	%v0, 0(%r15,%r1), 0
	vstef	%v15, 0, 0
	vstef	%v31, 0, 0
	vstef	%v18, 1383(%r3,%r4), 2

#CHECK: vsteg   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x0a]
#CHECK: vsteg   %v0, 0, 1               # encoding: [0xe7,0x00,0x00,0x00,0x10,0x0a]
#CHECK: vsteg   %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x0a]
#CHECK: vsteg   %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x0a]
#CHECK: vsteg   %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x0a]
#CHECK: vsteg   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x0a]
#CHECK: vsteg   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x0a]
#CHECK: vsteg   %v18, 1383(%r3,%r4), 1  # encoding: [0xe7,0x23,0x45,0x67,0x18,0x0a]

	vsteg	%v0, 0, 0
	vsteg	%v0, 0, 1
	vsteg	%v0, 4095, 0
	vsteg	%v0, 0(%r15), 0
	vsteg	%v0, 0(%r15,%r1), 0
	vsteg	%v15, 0, 0
	vsteg	%v31, 0, 0
	vsteg	%v18, 1383(%r3,%r4), 1

#CHECK: vsteh   %v0, 0, 0               # encoding: [0xe7,0x00,0x00,0x00,0x00,0x09]
#CHECK: vsteh   %v0, 0, 7               # encoding: [0xe7,0x00,0x00,0x00,0x70,0x09]
#CHECK: vsteh   %v0, 4095, 0            # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x09]
#CHECK: vsteh   %v0, 0(%r15), 0         # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x09]
#CHECK: vsteh   %v0, 0(%r15,%r1), 0     # encoding: [0xe7,0x0f,0x10,0x00,0x00,0x09]
#CHECK: vsteh   %v15, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x09]
#CHECK: vsteh   %v31, 0, 0              # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x09]
#CHECK: vsteh   %v18, 1383(%r3,%r4), 4  # encoding: [0xe7,0x23,0x45,0x67,0x48,0x09]

	vsteh	%v0, 0, 0
	vsteh	%v0, 0, 7
	vsteh	%v0, 4095, 0
	vsteh	%v0, 0(%r15), 0
	vsteh	%v0, 0(%r15,%r1), 0
	vsteh	%v15, 0, 0
	vsteh	%v31, 0, 0
	vsteh	%v18, 1383(%r3,%r4), 4

#CHECK: vstl    %v0, %r0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x3f]
#CHECK: vstl    %v0, %r0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x3f]
#CHECK: vstl    %v0, %r0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x3f]
#CHECK: vstl    %v0, %r15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x3f]
#CHECK: vstl    %v15, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x3f]
#CHECK: vstl    %v31, %r0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x3f]
#CHECK: vstl    %v18, %r3, 1383(%r4)    # encoding: [0xe7,0x23,0x45,0x67,0x08,0x3f]

	vstl	%v0, %r0, 0
	vstl	%v0, %r0, 4095
	vstl	%v0, %r0, 0(%r15)
	vstl	%v0, %r15, 0
	vstl	%v15, %r0, 0
	vstl	%v31, %r0, 0
	vstl	%v18, %r3, 1383(%r4)

#CHECK: vstm    %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0x3e]
#CHECK: vstm    %v0, %v0, 4095          # encoding: [0xe7,0x00,0x0f,0xff,0x00,0x3e]
#CHECK: vstm    %v0, %v0, 0(%r15)       # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x3e]
#CHECK: vstm    %v0, %v0, 0(%r15), 4    # encoding: [0xe7,0x00,0xf0,0x00,0x40,0x3e]
#CHECK: vstm    %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x3e]
#CHECK: vstm    %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x3e]
#CHECK: vstm    %v14, %v17, 1074(%r5), 3 # encoding: [0xe7,0xe1,0x54,0x32,0x34,0x3e]

	vstm	%v0, %v0, 0
	vstm	%v0, %v0, 4095
	vstm	%v0, %v0, 0(%r15)
	vstm	%v0, %v0, 0(%r15), 4
	vstm	%v0, %v31, 0
	vstm	%v31, %v0, 0
	vstm	%v14, %v17, 1074(%r5), 3

#CHECK: vstrc    %v0, %v0, %v0, %v0, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8a]
#CHECK: vstrc    %v0, %v0, %v0, %v0, 15, 0   # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x8a]
#CHECK: vstrc    %v0, %v0, %v0, %v0, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8a]
#CHECK: vstrc    %v0, %v0, %v0, %v0, 15, 0   # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x8a]
#CHECK: vstrc    %v0, %v0, %v0, %v0, 0, 12   # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x8a]
#CHECK: vstrc    %v0, %v0, %v0, %v15, 0, 0   # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x8a]
#CHECK: vstrc    %v0, %v0, %v0, %v31, 0, 0   # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8a]
#CHECK: vstrc    %v0, %v0, %v15, %v0, 0, 0   # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x8a]
#CHECK: vstrc    %v0, %v0, %v31, %v0, 0, 0   # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8a]
#CHECK: vstrc    %v0, %v15, %v0, %v0, 0, 0   # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x8a]
#CHECK: vstrc    %v0, %v31, %v0, %v0, 0, 0   # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8a]
#CHECK: vstrc    %v15, %v0, %v0, %v0, 0, 0   # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x8a]
#CHECK: vstrc    %v31, %v0, %v0, %v0, 0, 0   # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8a]
#CHECK: vstrc    %v18, %v3, %v20, %v5, 11, 4 # encoding: [0xe7,0x23,0x4b,0x40,0x5a,0x8a]
#CHECK: vstrc    %v18, %v3, %v20, %v5, 0, 15 # encoding: [0xe7,0x23,0x40,0xf0,0x5a,0x8a]

        vstrc    %v0, %v0, %v0, %v0, 0
        vstrc    %v0, %v0, %v0, %v0, 15
        vstrc    %v0, %v0, %v0, %v0, 0, 0
        vstrc    %v0, %v0, %v0, %v0, 15, 0
        vstrc    %v0, %v0, %v0, %v0, 0, 12
        vstrc    %v0, %v0, %v0, %v15, 0
        vstrc    %v0, %v0, %v0, %v31, 0
        vstrc    %v0, %v0, %v15, %v0, 0
        vstrc    %v0, %v0, %v31, %v0, 0
        vstrc    %v0, %v15, %v0, %v0, 0
        vstrc    %v0, %v31, %v0, %v0, 0
        vstrc    %v15, %v0, %v0, %v0, 0
        vstrc    %v31, %v0, %v0, %v0, 0
        vstrc    %v18, %v3, %v20, %v5, 11, 4
        vstrc    %v18, %v3, %v20, %v5, 0, 15

#CHECK: vstrcb   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8a]
#CHECK: vstrcb   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8a]
#CHECK: vstrcb   %v0, %v0, %v0, %v0, 12  # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x8a]
#CHECK: vstrcb   %v0, %v0, %v0, %v15, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x8a]
#CHECK: vstrcb   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8a]
#CHECK: vstrcb   %v0, %v0, %v15, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x8a]
#CHECK: vstrcb   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8a]
#CHECK: vstrcb   %v0, %v15, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x8a]
#CHECK: vstrcb   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8a]
#CHECK: vstrcb   %v15, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x8a]
#CHECK: vstrcb   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8a]
#CHECK: vstrcb   %v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x40,0x40,0x5a,0x8a]
#CHECK: vstrcb   %v18, %v3, %v20, %v5, 15 # encoding: [0xe7,0x23,0x40,0xf0,0x5a,0x8a]
#CHECK: vstrcbs  %v18, %v3, %v20, %v5, 8 # encoding: [0xe7,0x23,0x40,0x90,0x5a,0x8a]
#CHECK: vstrczb  %v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x40,0x60,0x5a,0x8a]
#CHECK: vstrczbs %v18, %v3, %v20, %v5, 8 # encoding: [0xe7,0x23,0x40,0xb0,0x5a,0x8a]
#CHECK: vstrczbs %v18, %v3, %v20, %v5, 15 # encoding: [0xe7,0x23,0x40,0xf0,0x5a,0x8a]

        vstrcb   %v0, %v0, %v0, %v0
        vstrcb   %v0, %v0, %v0, %v0, 0
        vstrcb   %v0, %v0, %v0, %v0, 12
        vstrcb   %v0, %v0, %v0, %v15
        vstrcb   %v0, %v0, %v0, %v31
        vstrcb   %v0, %v0, %v15, %v0
        vstrcb   %v0, %v0, %v31, %v0
        vstrcb   %v0, %v15, %v0, %v0
        vstrcb   %v0, %v31, %v0, %v0
        vstrcb   %v15, %v0, %v0, %v0
        vstrcb   %v31, %v0, %v0, %v0
        vstrcb   %v18, %v3, %v20, %v5, 4
        vstrcb   %v18, %v3, %v20, %v5, 15
        vstrcbs  %v18, %v3, %v20, %v5, 8
        vstrczb  %v18, %v3, %v20, %v5, 4
        vstrczbs %v18, %v3, %v20, %v5, 8
        vstrczbs %v18, %v3, %v20, %v5, 15

#CHECK: vstrcf   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x02,0x00,0x00,0x8a]
#CHECK: vstrcf   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x02,0x00,0x00,0x8a]
#CHECK: vstrcf   %v0, %v0, %v0, %v0, 12  # encoding: [0xe7,0x00,0x02,0xc0,0x00,0x8a]
#CHECK: vstrcf   %v0, %v0, %v0, %v15, 0  # encoding: [0xe7,0x00,0x02,0x00,0xf0,0x8a]
#CHECK: vstrcf   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x02,0x00,0xf1,0x8a]
#CHECK: vstrcf   %v0, %v0, %v15, %v0, 0  # encoding: [0xe7,0x00,0xf2,0x00,0x00,0x8a]
#CHECK: vstrcf   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf2,0x00,0x02,0x8a]
#CHECK: vstrcf   %v0, %v15, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x02,0x00,0x00,0x8a]
#CHECK: vstrcf   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x02,0x00,0x04,0x8a]
#CHECK: vstrcf   %v15, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x02,0x00,0x00,0x8a]
#CHECK: vstrcf   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x02,0x00,0x08,0x8a]
#CHECK: vstrcf   %v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x42,0x40,0x5a,0x8a]
#CHECK: vstrcf   %v18, %v3, %v20, %v5, 15 # encoding: [0xe7,0x23,0x42,0xf0,0x5a,0x8a]
#CHECK: vstrcfs  %v18, %v3, %v20, %v5, 8 # encoding: [0xe7,0x23,0x42,0x90,0x5a,0x8a]
#CHECK: vstrczf  %v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x42,0x60,0x5a,0x8a]
#CHECK: vstrczfs %v18, %v3, %v20, %v5, 8 # encoding: [0xe7,0x23,0x42,0xb0,0x5a,0x8a]
#CHECK: vstrczfs %v18, %v3, %v20, %v5, 15 # encoding: [0xe7,0x23,0x42,0xf0,0x5a,0x8a]

        vstrcf   %v0, %v0, %v0, %v0
        vstrcf   %v0, %v0, %v0, %v0, 0
        vstrcf   %v0, %v0, %v0, %v0, 12
        vstrcf   %v0, %v0, %v0, %v15
        vstrcf   %v0, %v0, %v0, %v31
        vstrcf   %v0, %v0, %v15, %v0
        vstrcf   %v0, %v0, %v31, %v0
        vstrcf   %v0, %v15, %v0, %v0
        vstrcf   %v0, %v31, %v0, %v0
        vstrcf   %v15, %v0, %v0, %v0
        vstrcf   %v31, %v0, %v0, %v0
        vstrcf   %v18, %v3, %v20, %v5, 4
        vstrcf   %v18, %v3, %v20, %v5, 15
        vstrcfs  %v18, %v3, %v20, %v5, 8
        vstrczf  %v18, %v3, %v20, %v5, 4
        vstrczfs %v18, %v3, %v20, %v5, 8
        vstrczfs %v18, %v3, %v20, %v5, 15

#CHECK: vstrch   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x01,0x00,0x00,0x8a]
#CHECK: vstrch   %v0, %v0, %v0, %v0, 0   # encoding: [0xe7,0x00,0x01,0x00,0x00,0x8a]
#CHECK: vstrch   %v0, %v0, %v0, %v0, 12  # encoding: [0xe7,0x00,0x01,0xc0,0x00,0x8a]
#CHECK: vstrch   %v0, %v0, %v0, %v15, 0  # encoding: [0xe7,0x00,0x01,0x00,0xf0,0x8a]
#CHECK: vstrch   %v0, %v0, %v0, %v31, 0  # encoding: [0xe7,0x00,0x01,0x00,0xf1,0x8a]
#CHECK: vstrch   %v0, %v0, %v15, %v0, 0  # encoding: [0xe7,0x00,0xf1,0x00,0x00,0x8a]
#CHECK: vstrch   %v0, %v0, %v31, %v0, 0  # encoding: [0xe7,0x00,0xf1,0x00,0x02,0x8a]
#CHECK: vstrch   %v0, %v15, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x01,0x00,0x00,0x8a]
#CHECK: vstrch   %v0, %v31, %v0, %v0, 0  # encoding: [0xe7,0x0f,0x01,0x00,0x04,0x8a]
#CHECK: vstrch   %v15, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x01,0x00,0x00,0x8a]
#CHECK: vstrch   %v31, %v0, %v0, %v0, 0  # encoding: [0xe7,0xf0,0x01,0x00,0x08,0x8a]
#CHECK: vstrch   %v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x41,0x40,0x5a,0x8a]
#CHECK: vstrch   %v18, %v3, %v20, %v5, 15 # encoding: [0xe7,0x23,0x41,0xf0,0x5a,0x8a]
#CHECK: vstrchs  %v18, %v3, %v20, %v5, 8 # encoding: [0xe7,0x23,0x41,0x90,0x5a,0x8a]
#CHECK: vstrczh  %v18, %v3, %v20, %v5, 4 # encoding: [0xe7,0x23,0x41,0x60,0x5a,0x8a]
#CHECK: vstrczhs %v18, %v3, %v20, %v5, 8 # encoding: [0xe7,0x23,0x41,0xb0,0x5a,0x8a]
#CHECK: vstrczhs %v18, %v3, %v20, %v5, 15 # encoding: [0xe7,0x23,0x41,0xf0,0x5a,0x8a]

        vstrch   %v0, %v0, %v0, %v0
        vstrch   %v0, %v0, %v0, %v0, 0
        vstrch   %v0, %v0, %v0, %v0, 12
        vstrch   %v0, %v0, %v0, %v15
        vstrch   %v0, %v0, %v0, %v31
        vstrch   %v0, %v0, %v15, %v0
        vstrch   %v0, %v0, %v31, %v0
        vstrch   %v0, %v15, %v0, %v0
        vstrch   %v0, %v31, %v0, %v0
        vstrch   %v15, %v0, %v0, %v0
        vstrch   %v31, %v0, %v0, %v0
        vstrch   %v18, %v3, %v20, %v5, 4
        vstrch   %v18, %v3, %v20, %v5, 15
        vstrchs  %v18, %v3, %v20, %v5, 8
        vstrczh  %v18, %v3, %v20, %v5, 4
        vstrczhs %v18, %v3, %v20, %v5, 8
        vstrczhs %v18, %v3, %v20, %v5, 15

#CHECK: vsum    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x64]
#CHECK: vsum    %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x64]
#CHECK: vsum    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x64]
#CHECK: vsum    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x64]
#CHECK: vsum    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x64]
#CHECK: vsum    %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x64]

	vsum	%v0, %v0, %v0, 0
	vsum	%v0, %v0, %v0, 15
	vsum	%v0, %v0, %v31, 0
	vsum	%v0, %v31, %v0, 0
	vsum	%v31, %v0, %v0, 0
	vsum	%v18, %v3, %v20, 11

#CHECK: vsumb   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x64]
#CHECK: vsumb   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x64]
#CHECK: vsumb   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x64]
#CHECK: vsumb   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x64]
#CHECK: vsumb   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x64]

	vsumb	%v0, %v0, %v0
	vsumb	%v0, %v0, %v31
	vsumb	%v0, %v31, %v0
	vsumb	%v31, %v0, %v0
	vsumb	%v18, %v3, %v20

#CHECK: vsumg   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x65]
#CHECK: vsumg   %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x65]
#CHECK: vsumg   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x65]
#CHECK: vsumg   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x65]
#CHECK: vsumg   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x65]
#CHECK: vsumg   %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x65]

	vsumg	%v0, %v0, %v0, 0
	vsumg	%v0, %v0, %v0, 15
	vsumg	%v0, %v0, %v31, 0
	vsumg	%v0, %v31, %v0, 0
	vsumg	%v31, %v0, %v0, 0
	vsumg	%v18, %v3, %v20, 11

#CHECK: vsumgf  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x65]
#CHECK: vsumgf  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x65]
#CHECK: vsumgf  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x65]
#CHECK: vsumgf  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x65]
#CHECK: vsumgf  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x65]

	vsumgf	%v0, %v0, %v0
	vsumgf	%v0, %v0, %v31
	vsumgf	%v0, %v31, %v0
	vsumgf	%v31, %v0, %v0
	vsumgf	%v18, %v3, %v20

#CHECK: vsumgh  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x65]
#CHECK: vsumgh  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x65]
#CHECK: vsumgh  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x65]
#CHECK: vsumgh  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x65]
#CHECK: vsumgh  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x65]

	vsumgh	%v0, %v0, %v0
	vsumgh	%v0, %v0, %v31
	vsumgh	%v0, %v31, %v0
	vsumgh	%v31, %v0, %v0
	vsumgh	%v18, %v3, %v20

#CHECK: vsumh   %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x10,0x64]
#CHECK: vsumh   %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x12,0x64]
#CHECK: vsumh   %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x14,0x64]
#CHECK: vsumh   %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x18,0x64]
#CHECK: vsumh   %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x1a,0x64]

	vsumh	%v0, %v0, %v0
	vsumh	%v0, %v0, %v31
	vsumh	%v0, %v31, %v0
	vsumh	%v31, %v0, %v0
	vsumh	%v18, %v3, %v20

#CHECK: vsumq   %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x67]
#CHECK: vsumq   %v0, %v0, %v0, 15       # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x67]
#CHECK: vsumq   %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x67]
#CHECK: vsumq   %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x67]
#CHECK: vsumq   %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x67]
#CHECK: vsumq   %v18, %v3, %v20, 11     # encoding: [0xe7,0x23,0x40,0x00,0xba,0x67]

	vsumq	%v0, %v0, %v0, 0
	vsumq	%v0, %v0, %v0, 15
	vsumq	%v0, %v0, %v31, 0
	vsumq	%v0, %v31, %v0, 0
	vsumq	%v31, %v0, %v0, 0
	vsumq	%v18, %v3, %v20, 11

#CHECK: vsumqf  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x20,0x67]
#CHECK: vsumqf  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x22,0x67]
#CHECK: vsumqf  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x24,0x67]
#CHECK: vsumqf  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x28,0x67]
#CHECK: vsumqf  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x2a,0x67]

	vsumqf	%v0, %v0, %v0
	vsumqf	%v0, %v0, %v31
	vsumqf	%v0, %v31, %v0
	vsumqf	%v31, %v0, %v0
	vsumqf	%v18, %v3, %v20

#CHECK: vsumqg  %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x30,0x67]
#CHECK: vsumqg  %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x32,0x67]
#CHECK: vsumqg  %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x34,0x67]
#CHECK: vsumqg  %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x38,0x67]
#CHECK: vsumqg  %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x3a,0x67]

	vsumqg	%v0, %v0, %v0
	vsumqg	%v0, %v0, %v31
	vsumqg	%v0, %v31, %v0
	vsumqg	%v31, %v0, %v0
	vsumqg	%v18, %v3, %v20

#CHECK: vtm     %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd8]
#CHECK: vtm     %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd8]
#CHECK: vtm     %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd8]
#CHECK: vtm     %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd8]
#CHECK: vtm     %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd8]
#CHECK: vtm     %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xd8]

	vtm	%v0, %v0
	vtm	%v0, %v15
	vtm	%v0, %v31
	vtm	%v15, %v0
	vtm	%v31, %v0
	vtm	%v14, %v17

#CHECK: vuph    %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd7]
#CHECK: vuph    %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xd7]
#CHECK: vuph    %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd7]
#CHECK: vuph    %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd7]
#CHECK: vuph    %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd7]
#CHECK: vuph    %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd7]
#CHECK: vuph    %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xd7]

	vuph	%v0, %v0, 0
	vuph	%v0, %v0, 15
	vuph	%v0, %v15, 0
	vuph	%v0, %v31, 0
	vuph	%v15, %v0, 0
	vuph	%v31, %v0, 0
	vuph	%v14, %v17, 11

#CHECK: vuphb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd7]
#CHECK: vuphb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd7]
#CHECK: vuphb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd7]
#CHECK: vuphb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd7]
#CHECK: vuphb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd7]
#CHECK: vuphb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xd7]

	vuphb	%v0, %v0
	vuphb	%v0, %v15
	vuphb	%v0, %v31
	vuphb	%v15, %v0
	vuphb	%v31, %v0
	vuphb	%v14, %v17

#CHECK: vuphf   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xd7]
#CHECK: vuphf   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xd7]
#CHECK: vuphf   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xd7]
#CHECK: vuphf   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xd7]
#CHECK: vuphf   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xd7]
#CHECK: vuphf   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xd7]

	vuphf	%v0, %v0
	vuphf	%v0, %v15
	vuphf	%v0, %v31
	vuphf	%v15, %v0
	vuphf	%v31, %v0
	vuphf	%v14, %v17

#CHECK: vuphh   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xd7]
#CHECK: vuphh   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xd7]
#CHECK: vuphh   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xd7]
#CHECK: vuphh   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xd7]
#CHECK: vuphh   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xd7]
#CHECK: vuphh   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xd7]

	vuphh	%v0, %v0
	vuphh	%v0, %v15
	vuphh	%v0, %v31
	vuphh	%v15, %v0
	vuphh	%v31, %v0
	vuphh	%v14, %v17

#CHECK: vupl    %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd6]
#CHECK: vupl    %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xd6]
#CHECK: vupl    %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd6]
#CHECK: vupl    %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd6]
#CHECK: vupl    %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd6]
#CHECK: vupl    %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd6]
#CHECK: vupl    %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xd6]

	vupl	%v0, %v0, 0
	vupl	%v0, %v0, 15
	vupl	%v0, %v15, 0
	vupl	%v0, %v31, 0
	vupl	%v15, %v0, 0
	vupl	%v31, %v0, 0
	vupl	%v14, %v17, 11

#CHECK: vuplb   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd6]
#CHECK: vuplb   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd6]
#CHECK: vuplb   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd6]
#CHECK: vuplb   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd6]
#CHECK: vuplb   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd6]
#CHECK: vuplb   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xd6]

	vuplb	%v0, %v0
	vuplb	%v0, %v15
	vuplb	%v0, %v31
	vuplb	%v15, %v0
	vuplb	%v31, %v0
	vuplb	%v14, %v17

#CHECK: vuplf   %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xd6]
#CHECK: vuplf   %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xd6]
#CHECK: vuplf   %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xd6]
#CHECK: vuplf   %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xd6]
#CHECK: vuplf   %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xd6]
#CHECK: vuplf   %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xd6]

	vuplf	%v0, %v0
	vuplf	%v0, %v15
	vuplf	%v0, %v31
	vuplf	%v15, %v0
	vuplf	%v31, %v0
	vuplf	%v14, %v17

#CHECK: vuplh   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd5]
#CHECK: vuplh   %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xd5]
#CHECK: vuplh   %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd5]
#CHECK: vuplh   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd5]
#CHECK: vuplh   %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd5]
#CHECK: vuplh   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd5]
#CHECK: vuplh   %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xd5]

	vuplh	%v0, %v0, 0
	vuplh	%v0, %v0, 15
	vuplh	%v0, %v15, 0
	vuplh	%v0, %v31, 0
	vuplh	%v15, %v0, 0
	vuplh	%v31, %v0, 0
	vuplh	%v14, %v17, 11

#CHECK: vuplhb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd5]
#CHECK: vuplhb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd5]
#CHECK: vuplhb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd5]
#CHECK: vuplhb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd5]
#CHECK: vuplhb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd5]
#CHECK: vuplhb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xd5]

	vuplhb	%v0, %v0
	vuplhb	%v0, %v15
	vuplhb	%v0, %v31
	vuplhb	%v15, %v0
	vuplhb	%v31, %v0
	vuplhb	%v14, %v17

#CHECK: vuplhf  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xd5]
#CHECK: vuplhf  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xd5]
#CHECK: vuplhf  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xd5]
#CHECK: vuplhf  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xd5]
#CHECK: vuplhf  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xd5]
#CHECK: vuplhf  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xd5]

	vuplhf	%v0, %v0
	vuplhf	%v0, %v15
	vuplhf	%v0, %v31
	vuplhf	%v15, %v0
	vuplhf	%v31, %v0
	vuplhf	%v14, %v17

#CHECK: vuplhh  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xd5]
#CHECK: vuplhh  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xd5]
#CHECK: vuplhh  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xd5]
#CHECK: vuplhh  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xd5]
#CHECK: vuplhh  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xd5]
#CHECK: vuplhh  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xd5]

	vuplhh	%v0, %v0
	vuplhh	%v0, %v15
	vuplhh	%v0, %v31
	vuplhh	%v15, %v0
	vuplhh	%v31, %v0
	vuplhh	%v14, %v17

#CHECK: vuplhw  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xd6]
#CHECK: vuplhw  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xd6]
#CHECK: vuplhw  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xd6]
#CHECK: vuplhw  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xd6]
#CHECK: vuplhw  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xd6]
#CHECK: vuplhw  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xd6]

	vuplhw	%v0, %v0
	vuplhw	%v0, %v15
	vuplhw	%v0, %v31
	vuplhw	%v15, %v0
	vuplhw	%v31, %v0
	vuplhw	%v14, %v17

#CHECK: vupll   %v0, %v0, 0             # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd4]
#CHECK: vupll   %v0, %v0, 15            # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xd4]
#CHECK: vupll   %v0, %v15, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd4]
#CHECK: vupll   %v0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd4]
#CHECK: vupll   %v15, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd4]
#CHECK: vupll   %v31, %v0, 0            # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd4]
#CHECK: vupll   %v14, %v17, 11          # encoding: [0xe7,0xe1,0x00,0x00,0xb4,0xd4]

	vupll	%v0, %v0, 0
	vupll	%v0, %v0, 15
	vupll	%v0, %v15, 0
	vupll	%v0, %v31, 0
	vupll	%v15, %v0, 0
	vupll	%v31, %v0, 0
	vupll	%v14, %v17, 11

#CHECK: vupllb  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x00,0xd4]
#CHECK: vupllb  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xd4]
#CHECK: vupllb  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xd4]
#CHECK: vupllb  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xd4]
#CHECK: vupllb  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xd4]
#CHECK: vupllb  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x04,0xd4]

	vupllb	%v0, %v0
	vupllb	%v0, %v15
	vupllb	%v0, %v31
	vupllb	%v15, %v0
	vupllb	%v31, %v0
	vupllb	%v14, %v17

#CHECK: vupllf  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x20,0xd4]
#CHECK: vupllf  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x20,0xd4]
#CHECK: vupllf  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xd4]
#CHECK: vupllf  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x20,0xd4]
#CHECK: vupllf  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xd4]
#CHECK: vupllf  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x24,0xd4]

	vupllf	%v0, %v0
	vupllf	%v0, %v15
	vupllf	%v0, %v31
	vupllf	%v15, %v0
	vupllf	%v31, %v0
	vupllf	%v14, %v17

#CHECK: vupllh  %v0, %v0                # encoding: [0xe7,0x00,0x00,0x00,0x10,0xd4]
#CHECK: vupllh  %v0, %v15               # encoding: [0xe7,0x0f,0x00,0x00,0x10,0xd4]
#CHECK: vupllh  %v0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x14,0xd4]
#CHECK: vupllh  %v15, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x10,0xd4]
#CHECK: vupllh  %v31, %v0               # encoding: [0xe7,0xf0,0x00,0x00,0x18,0xd4]
#CHECK: vupllh  %v14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x14,0xd4]

	vupllh	%v0, %v0
	vupllh	%v0, %v15
	vupllh	%v0, %v31
	vupllh	%v15, %v0
	vupllh	%v31, %v0
	vupllh	%v14, %v17

#CHECK: vx      %v0, %v0, %v0           # encoding: [0xe7,0x00,0x00,0x00,0x00,0x6d]
#CHECK: vx      %v0, %v0, %v31          # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x6d]
#CHECK: vx      %v0, %v31, %v0          # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x6d]
#CHECK: vx      %v31, %v0, %v0          # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x6d]
#CHECK: vx      %v18, %v3, %v20         # encoding: [0xe7,0x23,0x40,0x00,0x0a,0x6d]

	vx	%v0, %v0, %v0
	vx	%v0, %v0, %v31
	vx	%v0, %v31, %v0
	vx	%v31, %v0, %v0
	vx	%v18, %v3, %v20

#CHECK: vzero   %v0                     # encoding: [0xe7,0x00,0x00,0x00,0x00,0x44]
#CHECK: vzero   %v11                    # encoding: [0xe7,0xb0,0x00,0x00,0x00,0x44]
#CHECK: vzero   %v15                    # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x44]
#CHECK: vzero   %v31                    # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x44]

	vzero	%v0
	vzero	%v11
	vzero	%v15
	vzero	%v31

#CHECK: wcdgb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc3]
#CHECK: wcdgb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc3]
#CHECK: wcdgb   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xc3]
#CHECK: wcdgb   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc3]
#CHECK: wcdgb   %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc3]
#CHECK: wcdgb   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc3]
#CHECK: wcdgb   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc3]
#CHECK: wcdgb   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x34,0xc3]

	wcdgb	%v0, %v0, 0, 0
	wcdgb   %f0, %f0, 0, 0
 	wcdgb	%v0, %v0, 0, 15
	wcdgb	%v0, %v0, 4, 0
	wcdgb	%v0, %v0, 12, 0
	wcdgb	%v0, %v31, 0, 0
	wcdgb	%v31, %v0, 0, 0
	wcdgb	%v14, %v17, 4, 10

#CHECK: wcdlgb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc1]
#CHECK: wcdlgb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc1]
#CHECK: wcdlgb  %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xc1]
#CHECK: wcdlgb  %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc1]
#CHECK: wcdlgb  %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc1]
#CHECK: wcdlgb  %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc1]
#CHECK: wcdlgb  %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc1]
#CHECK: wcdlgb  %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x34,0xc1]

	wcdlgb	%v0, %v0, 0, 0
	wcdlgb  %f0, %f0, 0, 0
 	wcdlgb	%v0, %v0, 0, 15
	wcdlgb	%v0, %v0, 4, 0
	wcdlgb	%v0, %v0, 12, 0
	wcdlgb	%v0, %v31, 0, 0
	wcdlgb	%v31, %v0, 0, 0
	wcdlgb	%v14, %v17, 4, 10

#CHECK: wcgdb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc2]
#CHECK: wcgdb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc2]
#CHECK: wcgdb   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xc2]
#CHECK: wcgdb   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc2]
#CHECK: wcgdb   %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc2]
#CHECK: wcgdb   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc2]
#CHECK: wcgdb   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc2]
#CHECK: wcgdb   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x34,0xc2]

	wcgdb	%v0, %v0, 0, 0
	wcgdb  	%f0, %f0, 0, 0
 	wcgdb	%v0, %v0, 0, 15
	wcgdb	%v0, %v0, 4, 0
	wcgdb	%v0, %v0, 12, 0
	wcgdb	%v0, %v31, 0, 0
	wcgdb	%v31, %v0, 0, 0
	wcgdb	%v14, %v17, 4, 10

#CHECK: wclgdb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc0]
#CHECK: wclgdb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc0]
#CHECK: wclgdb  %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xc0]
#CHECK: wclgdb  %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc0]
#CHECK: wclgdb  %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc0]
#CHECK: wclgdb  %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc0]
#CHECK: wclgdb  %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc0]
#CHECK: wclgdb  %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x34,0xc0]

	wclgdb	%v0, %v0, 0, 0
	wclgdb  %f0, %f0, 0, 0
 	wclgdb	%v0, %v0, 0, 15
	wclgdb	%v0, %v0, 4, 0
	wclgdb	%v0, %v0, 12, 0
	wclgdb	%v0, %v31, 0, 0
	wclgdb	%v31, %v0, 0, 0
	wclgdb	%v14, %v17, 4, 10

#CHECK: wfadb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe3]
#CHECK: wfadb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe3]
#CHECK: wfadb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xe3]
#CHECK: wfadb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xe3]
#CHECK: wfadb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xe3]
#CHECK: wfadb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x3a,0xe3]

	wfadb	%v0, %v0, %v0
	wfadb   %f0, %f0, %f0
	wfadb	%v0, %v0, %v31
	wfadb	%v0, %v31, %v0
	wfadb	%v31, %v0, %v0
	wfadb	%v18, %v3, %v20

#CHECK: wfc     %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0xcb]
#CHECK: wfc     %f0, %f0, 15, 0         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xcb]
#CHECK: wfc     %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xcb]
#CHECK: wfc     %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0xcb]
#CHECK: wfc     %f0, %f15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xcb]
#CHECK: wfc     %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xcb]
#CHECK: wfc     %f15, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xcb]
#CHECK: wfc     %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xcb]
#CHECK: wfc     %f14, %v17, 11, 9       # encoding: [0xe7,0xe1,0x00,0x09,0xb4,0xcb]

	wfc	%v0, %v0, 0, 0
	wfc	%v0, %v0, 15, 0
	wfc	%v0, %v0, 0, 15
	wfc	%f0, %f0, 0, 0
	wfc	%v0, %v15, 0, 0
	wfc	%v0, %v31, 0, 0
	wfc	%v15, %v0, 0, 0
	wfc	%v31, %v0, 0, 0
	wfc	%v14, %v17, 11, 9

#CHECK: wfcdb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xcb]
#CHECK: wfcdb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xcb]
#CHECK: wfcdb   %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xcb]
#CHECK: wfcdb   %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xcb]
#CHECK: wfcdb   %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xcb]
#CHECK: wfcdb   %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xcb]
#CHECK: wfcdb   %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xcb]

	wfcdb	%v0, %v0
	wfcdb	%f0, %f0
	wfcdb	%v0, %v15
	wfcdb	%v0, %v31
	wfcdb	%v15, %v0
	wfcdb	%v31, %v0
	wfcdb	%v14, %v17

#CHECK: wfcedb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe8]
#CHECK: wfcedb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe8]
#CHECK: wfcedb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xe8]
#CHECK: wfcedb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xe8]
#CHECK: wfcedb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xe8]
#CHECK: wfcedb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x3a,0xe8]

	wfcedb	%v0, %v0, %v0
	wfcedb	%f0, %f0, %f0
	wfcedb	%v0, %v0, %v31
	wfcedb	%v0, %v31, %v0
	wfcedb	%v31, %v0, %v0
	wfcedb	%v18, %v3, %v20

#CHECK: wfcedbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x30,0xe8]
#CHECK: wfcedbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x30,0xe8]
#CHECK: wfcedbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x18,0x32,0xe8]
#CHECK: wfcedbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x18,0x34,0xe8]
#CHECK: wfcedbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x18,0x38,0xe8]
#CHECK: wfcedbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x18,0x3a,0xe8]

	wfcedbs	%v0, %v0, %v0
	wfcedbs	%f0, %f0, %f0
	wfcedbs	%v0, %v0, %v31
	wfcedbs	%v0, %v31, %v0
	wfcedbs	%v31, %v0, %v0
	wfcedbs	%v18, %v3, %v20

#CHECK: wfchdb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xeb]
#CHECK: wfchdb  %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xeb]
#CHECK: wfchdb  %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xeb]
#CHECK: wfchdb  %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xeb]
#CHECK: wfchdb  %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xeb]
#CHECK: wfchdb  %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x3a,0xeb]

	wfchdb	%v0, %v0, %v0
	wfchdb	%f0, %f0, %f0
	wfchdb	%v0, %v0, %v31
	wfchdb	%v0, %v31, %v0
	wfchdb	%v31, %v0, %v0
	wfchdb	%v18, %v3, %v20

#CHECK: wfchdbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x30,0xeb]
#CHECK: wfchdbs %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x18,0x30,0xeb]
#CHECK: wfchdbs %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x18,0x32,0xeb]
#CHECK: wfchdbs %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x18,0x34,0xeb]
#CHECK: wfchdbs %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x18,0x38,0xeb]
#CHECK: wfchdbs %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x18,0x3a,0xeb]

	wfchdbs	%v0, %v0, %v0
	wfchdbs	%f0, %f0, %f0
	wfchdbs	%v0, %v0, %v31
	wfchdbs	%v0, %v31, %v0
	wfchdbs	%v31, %v0, %v0
	wfchdbs	%v18, %v3, %v20

#CHECK: wfchedb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xea]
#CHECK: wfchedb %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xea]
#CHECK: wfchedb %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xea]
#CHECK: wfchedb %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xea]
#CHECK: wfchedb %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xea]
#CHECK: wfchedb %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x3a,0xea]

	wfchedb	%v0, %v0, %v0
	wfchedb	%f0, %f0, %f0
	wfchedb	%v0, %v0, %v31
	wfchedb	%v0, %v31, %v0
	wfchedb	%v31, %v0, %v0
	wfchedb	%v18, %v3, %v20

#CHECK: wfchedbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x18,0x30,0xea]
#CHECK: wfchedbs %f0, %f0, %f0          # encoding: [0xe7,0x00,0x00,0x18,0x30,0xea]
#CHECK: wfchedbs %f0, %f0, %v31         # encoding: [0xe7,0x00,0xf0,0x18,0x32,0xea]
#CHECK: wfchedbs %f0, %v31, %f0         # encoding: [0xe7,0x0f,0x00,0x18,0x34,0xea]
#CHECK: wfchedbs %v31, %f0, %f0         # encoding: [0xe7,0xf0,0x00,0x18,0x38,0xea]
#CHECK: wfchedbs %v18, %f3, %v20        # encoding: [0xe7,0x23,0x40,0x18,0x3a,0xea]

	wfchedbs %v0, %v0, %v0
	wfchedbs %f0, %f0, %f0
	wfchedbs %v0, %v0, %v31
	wfchedbs %v0, %v31, %v0
	wfchedbs %v31, %v0, %v0
	wfchedbs %v18, %v3, %v20

#CHECK: wfddb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe5]
#CHECK: wfddb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe5]
#CHECK: wfddb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xe5]
#CHECK: wfddb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xe5]
#CHECK: wfddb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xe5]
#CHECK: wfddb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x3a,0xe5]

	wfddb	%v0, %v0, %v0
	wfddb	%f0, %f0, %f0
	wfddb	%v0, %v0, %v31
	wfddb	%v0, %v31, %v0
	wfddb	%v31, %v0, %v0
	wfddb	%v18, %v3, %v20

#CHECK: wfidb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc7]
#CHECK: wfidb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc7]
#CHECK: wfidb   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xc7]
#CHECK: wfidb   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc7]
#CHECK: wfidb   %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc7]
#CHECK: wfidb   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc7]
#CHECK: wfidb   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc7]
#CHECK: wfidb   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x34,0xc7]

	wfidb	%v0, %v0, 0, 0
	wfidb	%f0, %f0, 0, 0
 	wfidb	%v0, %v0, 0, 15
	wfidb	%v0, %v0, 4, 0
	wfidb	%v0, %v0, 12, 0
	wfidb	%v0, %v31, 0, 0
	wfidb	%v31, %v0, 0, 0
	wfidb	%v14, %v17, 4, 10

#CHECK: wfk     %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0xca]
#CHECK: wfk     %f0, %f0, 15, 0         # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xca]
#CHECK: wfk     %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0x0f,0x00,0xca]
#CHECK: wfk     %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x00,0xca]
#CHECK: wfk     %f0, %f15, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x00,0xca]
#CHECK: wfk     %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xca]
#CHECK: wfk     %f15, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x00,0xca]
#CHECK: wfk     %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xca]
#CHECK: wfk     %f14, %v17, 11, 9       # encoding: [0xe7,0xe1,0x00,0x09,0xb4,0xca]

	wfk	%v0, %v0, 0, 0
	wfk	%v0, %v0, 15, 0
	wfk	%v0, %v0, 0, 15
	wfk	%f0, %f0, 0, 0
	wfk	%v0, %v15, 0, 0
	wfk	%v0, %v31, 0, 0
	wfk	%v15, %v0, 0, 0
	wfk	%v31, %v0, 0, 0
	wfk	%v14, %v17, 11, 9

#CHECK: wfkdb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xca]
#CHECK: wfkdb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x00,0x30,0xca]
#CHECK: wfkdb   %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x00,0x30,0xca]
#CHECK: wfkdb   %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x00,0x34,0xca]
#CHECK: wfkdb   %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x30,0xca]
#CHECK: wfkdb   %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x00,0x38,0xca]
#CHECK: wfkdb   %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x00,0x34,0xca]

	wfkdb	%v0, %v0
	wfkdb	%f0, %f0
	wfkdb	%v0, %v15
	wfkdb	%v0, %v31
	wfkdb	%v15, %v0
	wfkdb	%v31, %v0
	wfkdb	%v14, %v17

#CHECK: wflcdb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x30,0xcc]
#CHECK: wflcdb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x30,0xcc]
#CHECK: wflcdb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x08,0x30,0xcc]
#CHECK: wflcdb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xcc]
#CHECK: wflcdb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x30,0xcc]
#CHECK: wflcdb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xcc]
#CHECK: wflcdb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x34,0xcc]

	wflcdb	%v0, %v0
	wflcdb  %f0, %f0
	wflcdb	%v0, %v15
	wflcdb	%v0, %v31
	wflcdb	%v15, %v0
	wflcdb	%v31, %v0
	wflcdb	%v14, %v17

#CHECK: wflndb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x18,0x30,0xcc]
#CHECK: wflndb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x18,0x30,0xcc]
#CHECK: wflndb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x18,0x30,0xcc]
#CHECK: wflndb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x18,0x34,0xcc]
#CHECK: wflndb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x18,0x30,0xcc]
#CHECK: wflndb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x18,0x38,0xcc]
#CHECK: wflndb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x18,0x34,0xcc]

	wflndb	%v0, %v0
	wflndb	%f0, %f0
	wflndb	%v0, %v15
	wflndb	%v0, %v31
	wflndb	%v15, %v0
	wflndb	%v31, %v0
	wflndb	%v14, %v17

#CHECK: wflpdb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x28,0x30,0xcc]
#CHECK: wflpdb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x28,0x30,0xcc]
#CHECK: wflpdb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x28,0x30,0xcc]
#CHECK: wflpdb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x28,0x34,0xcc]
#CHECK: wflpdb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x28,0x30,0xcc]
#CHECK: wflpdb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x28,0x38,0xcc]
#CHECK: wflpdb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x28,0x34,0xcc]

	wflpdb	%v0, %v0
	wflpdb	%f0, %f0
	wflpdb	%v0, %v15
	wflpdb	%v0, %v31
	wflpdb	%v15, %v0
	wflpdb	%v31, %v0
	wflpdb	%v14, %v17

#CHECK: wfmadb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x8f]
#CHECK: wfmadb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x8f]
#CHECK: wfmadb  %f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x03,0x08,0xf1,0x8f]
#CHECK: wfmadb  %f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf3,0x08,0x02,0x8f]
#CHECK: wfmadb  %f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x03,0x08,0x04,0x8f]
#CHECK: wfmadb  %v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x03,0x08,0x08,0x8f]
#CHECK: wfmadb  %f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x08,0x97,0x8f]

	wfmadb	%v0, %v0, %v0, %v0
	wfmadb	%f0, %f0, %f0, %f0
	wfmadb	%v0, %v0, %v0, %v31
	wfmadb	%v0, %v0, %v31, %v0
	wfmadb	%v0, %v31, %v0, %v0
	wfmadb	%v31, %v0, %v0, %v0
	wfmadb	%v13, %v17, %v21, %v25

#CHECK: wfmdb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe7]
#CHECK: wfmdb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe7]
#CHECK: wfmdb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xe7]
#CHECK: wfmdb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xe7]
#CHECK: wfmdb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xe7]
#CHECK: wfmdb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x3a,0xe7]

	wfmdb	%v0, %v0, %v0
	wfmdb	%f0, %f0, %f0
	wfmdb	%v0, %v0, %v31
	wfmdb	%v0, %v31, %v0
	wfmdb	%v31, %v0, %v0
	wfmdb	%v18, %v3, %v20

#CHECK: wfmsdb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x8e]
#CHECK: wfmsdb  %f0, %f0, %f0, %f0      # encoding: [0xe7,0x00,0x03,0x08,0x00,0x8e]
#CHECK: wfmsdb  %f0, %f0, %f0, %v31     # encoding: [0xe7,0x00,0x03,0x08,0xf1,0x8e]
#CHECK: wfmsdb  %f0, %f0, %v31, %f0     # encoding: [0xe7,0x00,0xf3,0x08,0x02,0x8e]
#CHECK: wfmsdb  %f0, %v31, %f0, %f0     # encoding: [0xe7,0x0f,0x03,0x08,0x04,0x8e]
#CHECK: wfmsdb  %v31, %f0, %f0, %f0     # encoding: [0xe7,0xf0,0x03,0x08,0x08,0x8e]
#CHECK: wfmsdb  %f13, %v17, %v21, %v25  # encoding: [0xe7,0xd1,0x53,0x08,0x97,0x8e]

	wfmsdb	%v0, %v0, %v0, %v0
	wfmsdb	%f0, %f0, %f0, %f0
	wfmsdb	%v0, %v0, %v0, %v31
	wfmsdb	%v0, %v0, %v31, %v0
	wfmsdb	%v0, %v31, %v0, %v0
	wfmsdb	%v31, %v0, %v0, %v0
	wfmsdb	%v13, %v17, %v21, %v25

#CHECK: wfpsodb %f0, %f0, 0             # encoding: [0xe7,0x00,0x00,0x08,0x30,0xcc]
#CHECK: wfpsodb %f0, %f0, 0             # encoding: [0xe7,0x00,0x00,0x08,0x30,0xcc]
#CHECK: wfpsodb %f0, %f0, 15            # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xcc]
#CHECK: wfpsodb %f0, %f15, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x30,0xcc]
#CHECK: wfpsodb %f0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xcc]
#CHECK: wfpsodb %f15, %f0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x30,0xcc]
#CHECK: wfpsodb %v31, %f0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xcc]
#CHECK: wfpsodb %f14, %v17, 7           # encoding: [0xe7,0xe1,0x00,0x78,0x34,0xcc]

	wfpsodb	%v0, %v0, 0
	wfpsodb	%f0, %f0, 0
	wfpsodb	%v0, %v0, 15
	wfpsodb	%v0, %v15, 0
	wfpsodb	%v0, %v31, 0
	wfpsodb	%v15, %v0, 0
	wfpsodb	%v31, %v0, 0
	wfpsodb	%v14, %v17, 7

#CHECK: wfsdb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe2]
#CHECK: wfsdb   %f0, %f0, %f0           # encoding: [0xe7,0x00,0x00,0x08,0x30,0xe2]
#CHECK: wfsdb   %f0, %f0, %v31          # encoding: [0xe7,0x00,0xf0,0x08,0x32,0xe2]
#CHECK: wfsdb   %f0, %v31, %f0          # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xe2]
#CHECK: wfsdb   %v31, %f0, %f0          # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xe2]
#CHECK: wfsdb   %v18, %f3, %v20         # encoding: [0xe7,0x23,0x40,0x08,0x3a,0xe2]

	wfsdb	%v0, %v0, %v0
	wfsdb	%f0, %f0, %f0
	wfsdb	%v0, %v0, %v31
	wfsdb	%v0, %v31, %v0
	wfsdb	%v31, %v0, %v0
	wfsdb	%v18, %v3, %v20

#CHECK: wfsqdb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x30,0xce]
#CHECK: wfsqdb  %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x30,0xce]
#CHECK: wfsqdb  %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x08,0x30,0xce]
#CHECK: wfsqdb  %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xce]
#CHECK: wfsqdb  %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x30,0xce]
#CHECK: wfsqdb  %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xce]
#CHECK: wfsqdb  %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x34,0xce]

	wfsqdb	%v0, %v0
	wfsqdb	%f0, %f0
	wfsqdb	%v0, %v15
	wfsqdb	%v0, %v31
	wfsqdb	%v15, %v0
	wfsqdb	%v31, %v0
	wfsqdb	%v14, %v17

#CHECK: wftcidb %f0, %f0, 0             # encoding: [0xe7,0x00,0x00,0x08,0x30,0x4a]
#CHECK: wftcidb %f0, %f0, 0             # encoding: [0xe7,0x00,0x00,0x08,0x30,0x4a]
#CHECK: wftcidb %f0, %f0, 4095          # encoding: [0xe7,0x00,0xff,0xf8,0x30,0x4a]
#CHECK: wftcidb %f0, %f15, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x30,0x4a]
#CHECK: wftcidb %f0, %v31, 0            # encoding: [0xe7,0x0f,0x00,0x08,0x34,0x4a]
#CHECK: wftcidb %f15, %f0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x30,0x4a]
#CHECK: wftcidb %v31, %f0, 0            # encoding: [0xe7,0xf0,0x00,0x08,0x38,0x4a]
#CHECK: wftcidb %f4, %v21, 1656         # encoding: [0xe7,0x45,0x67,0x88,0x34,0x4a]

	wftcidb	%v0, %v0, 0
	wftcidb	%f0, %f0, 0
	wftcidb	%v0, %v0, 4095
	wftcidb	%v0, %v15, 0
	wftcidb	%v0, %v31, 0
	wftcidb	%v15, %v0, 0
	wftcidb	%v31, %v0, 0
	wftcidb	%v4, %v21, 0x678

#CHECK: wldeb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc4]
#CHECK: wldeb   %f0, %f0                # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc4]
#CHECK: wldeb   %f0, %f15               # encoding: [0xe7,0x0f,0x00,0x08,0x20,0xc4]
#CHECK: wldeb   %f0, %v31               # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xc4]
#CHECK: wldeb   %f15, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x20,0xc4]
#CHECK: wldeb   %v31, %f0               # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xc4]
#CHECK: wldeb   %f14, %v17              # encoding: [0xe7,0xe1,0x00,0x08,0x24,0xc4]

	wldeb	%v0, %v0
	wldeb	%f0, %f0
	wldeb	%v0, %v15
	wldeb	%v0, %v31
	wldeb	%v15, %v0
	wldeb	%v31, %v0
	wldeb	%v14, %v17

#CHECK: wledb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc5]
#CHECK: wledb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x30,0xc5]
#CHECK: wledb   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x30,0xc5]
#CHECK: wledb   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc5]
#CHECK: wledb   %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x30,0xc5]
#CHECK: wledb   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x34,0xc5]
#CHECK: wledb   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x38,0xc5]
#CHECK: wledb   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x34,0xc5]

	wledb	%v0, %v0, 0, 0
	wledb	%f0, %f0, 0, 0
	wledb	%v0, %v0, 0, 15
	wledb	%v0, %v0, 4, 0
	wledb	%v0, %v0, 12, 0
	wledb	%v0, %v31, 0, 0
	wledb	%v31, %v0, 0, 0
	wledb	%v14, %v17, 4, 10

