; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -x86-cmov-converter=false -show-mc-encoding -verify-machineinstrs | FileCheck %s

define i8 @cmov8(i8 %a, i8 %b, i8 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpb %sil, %dil # encoding: [0x40,0x38,0xf7]
; CHECK-NEXT:    cmoval %edi, %edx, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x47,0xd7]
; CHECK-NEXT:    movzbl (%rcx), %ecx # encoding: [0x0f,0xb6,0x09]
; CHECK-NEXT:    cmovbel %edx, %ecx # EVEX TO LEGACY Compression encoding: [0x0f,0x46,0xca]
; CHECK-NEXT:    addb %cl, %al # EVEX TO LEGACY Compression encoding: [0x00,0xc8]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %cond = icmp ugt i8 %a, %b
  %y = load i8, ptr %y.ptr
  %z2 = select i1 %cond, i8 %a, i8 %x
  %z1 = select i1 %cond, i8 %y, i8 %x
  %s1 = add i8 %z1, %z2
  ret i8 %s1
}

define i16 @cmov16(i16 %a, i16 %b, i16 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpw %si, %di # encoding: [0x66,0x39,0xf7]
; CHECK-NEXT:    cmoval %edi, %edx, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x47,0xd7]
; CHECK-NEXT:    cmovaw (%rcx), %dx, %cx # encoding: [0x62,0xf4,0x75,0x18,0x47,0x11]
; CHECK-NEXT:    addw %cx, %ax # EVEX TO LEGACY Compression encoding: [0x66,0x01,0xc8]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %cond = icmp ugt i16 %a, %b
  %y = load i16, ptr %y.ptr
  %z2 = select i1 %cond, i16 %a, i16 %x
  %z1 = select i1 %cond, i16 %y, i16 %x
  %s1 = add i16 %z1, %z2
  ret i16 %s1
}

define i32 @cmov32(i32 %a, i32 %b, i32 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpl %esi, %edi # encoding: [0x39,0xf7]
; CHECK-NEXT:    cmoval %edi, %edx, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x47,0xd7]
; CHECK-NEXT:    cmoval (%rcx), %edx, %ecx # encoding: [0x62,0xf4,0x74,0x18,0x47,0x11]
; CHECK-NEXT:    addl %ecx, %eax # EVEX TO LEGACY Compression encoding: [0x01,0xc8]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %cond = icmp ugt i32 %a, %b
  %y = load i32, ptr %y.ptr
  %z2 = select i1 %cond, i32 %a, i32 %x
  %z1 = select i1 %cond, i32 %y, i32 %x
  %s1 = add i32 %z1, %z2
  ret i32 %s1
}

define i64 @cmov64(i64 %a, i64 %b, i64 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpq %rsi, %rdi # encoding: [0x48,0x39,0xf7]
; CHECK-NEXT:    cmovaq %rdi, %rdx, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x47,0xd7]
; CHECK-NEXT:    cmovaq (%rcx), %rdx, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x47,0x11]
; CHECK-NEXT:    addq %rcx, %rax # EVEX TO LEGACY Compression encoding: [0x48,0x01,0xc8]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %cond = icmp ugt i64 %a, %b
  %y = load i64, ptr %y.ptr
  %z2 = select i1 %cond, i64 %a, i64 %x
  %z1 = select i1 %cond, i64 %y, i64 %x
  %s1 = add i64 %z1, %z2
  ret i64 %s1
}

define i8 @cmov8rm_inv(i8 %a, i8 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov8rm_inv:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testb %dil, %dil # encoding: [0x40,0x84,0xff]
; CHECK-NEXT:    movzbl (%rdx), %eax # encoding: [0x0f,0xb6,0x02]
; CHECK-NEXT:    cmovsl %esi, %eax # EVEX TO LEGACY Compression encoding: [0x0f,0x48,0xc6]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %y = load i8, ptr %y.ptr
  %cmp = icmp slt i8 %a, 0
  %cmov = select i1 %cmp, i8 %x, i8 %y
  ret i8 %cmov
}

define i16 @cmov16rm_inv(i16 %a, i16 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov16rm_inv:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testw %di, %di # encoding: [0x66,0x85,0xff]
; CHECK-NEXT:    cmovnsw (%rdx), %si, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x49,0x32]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %y = load i16, ptr %y.ptr
  %cmp = icmp slt i16 %a, 0
  %cmov = select i1 %cmp, i16 %x, i16 %y
  ret i16 %cmov
}

define i32 @cmov32rm_inv(i32 %a, i32 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov32rm_inv:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testl %edi, %edi # encoding: [0x85,0xff]
; CHECK-NEXT:    cmovnsl (%rdx), %esi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x49,0x32]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %y = load i32, ptr %y.ptr
  %cmp = icmp slt i32 %a, 0
  %cmov = select i1 %cmp, i32 %x, i32 %y
  ret i32 %cmov
}

define i64 @cmov64rm_inv(i64 %a, i64 %x, ptr %y.ptr) {
; CHECK-LABEL: cmov64rm_inv:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    testq %rdi, %rdi # encoding: [0x48,0x85,0xff]
; CHECK-NEXT:    cmovnsq (%rdx), %rsi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x49,0x32]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %y = load i64, ptr %y.ptr
  %cmp = icmp slt i64 %a, 0
  %cmov = select i1 %cmp, i64 %x, i64 %y
  ret i64 %cmov
}
