; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv6m-none-unknown-eabi -mcpu=cortex-m0 | FileCheck %s --check-prefix=ARM

declare  i4  @llvm.smul.fix.sat.i4   (i4,  i4, i32)
declare  i32 @llvm.smul.fix.sat.i32  (i32, i32, i32)
declare  i64 @llvm.smul.fix.sat.i64  (i64, i64, i32)

define i32 @func(i32 %x, i32 %y) nounwind {
; ARM-LABEL: func:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r7, lr}
; ARM-NEXT:    push {r7, lr}
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    asrs r1, r0, #31
; ARM-NEXT:    asrs r3, r2, #31
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #1
; ARM-NEXT:    bgt .LBB0_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    lsrs r0, r0, #2
; ARM-NEXT:    lsls r2, r1, #30
; ARM-NEXT:    adds r0, r2, r0
; ARM-NEXT:    b .LBB0_3
; ARM-NEXT:  .LBB0_2:
; ARM-NEXT:    ldr r0, .LCPI0_0
; ARM-NEXT:  .LBB0_3:
; ARM-NEXT:    movs r2, #1
; ARM-NEXT:    mvns r3, r2
; ARM-NEXT:    cmp r1, r3
; ARM-NEXT:    bge .LBB0_5
; ARM-NEXT:  @ %bb.4:
; ARM-NEXT:    lsls r0, r2, #31
; ARM-NEXT:  .LBB0_5:
; ARM-NEXT:    pop {r7, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.6:
; ARM-NEXT:  .LCPI0_0:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i32 @llvm.smul.fix.sat.i32(i32 %x, i32 %y, i32 2)
  ret i32 %tmp
}

define i64 @func2(i64 %x, i64 %y) nounwind {
; ARM-LABEL: func2:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #36
; ARM-NEXT:    sub sp, #36
; ARM-NEXT:    str r3, [sp, #28] @ 4-byte Spill
; ARM-NEXT:    mov r6, r1
; ARM-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    movs r4, #0
; ARM-NEXT:    str r4, [sp, #32] @ 4-byte Spill
; ARM-NEXT:    mov r5, r0
; ARM-NEXT:    str r0, [sp, #20] @ 4-byte Spill
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r7, r2
; ARM-NEXT:    str r2, [sp, #16] @ 4-byte Spill
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    str r1, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r7
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r6, r1
; ARM-NEXT:    ldr r1, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    adds r7, r0, r1
; ARM-NEXT:    adcs r6, r4
; ARM-NEXT:    mov r0, r5
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    ldr r5, [sp, #28] @ 4-byte Reload
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r7
; ARM-NEXT:    str r0, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    adcs r1, r4
; ARM-NEXT:    adds r0, r6, r1
; ARM-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    mov r6, r4
; ARM-NEXT:    adcs r6, r4
; ARM-NEXT:    ldr r7, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    mov r0, r7
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    ldr r1, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r1
; ARM-NEXT:    str r0, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    adcs r5, r6
; ARM-NEXT:    asrs r2, r7, #31
; ARM-NEXT:    ldr r0, [sp, #16] @ 4-byte Reload
; ARM-NEXT:    ldr r4, [sp, #28] @ 4-byte Reload
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r2
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r6, r0
; ARM-NEXT:    str r1, [sp, #16] @ 4-byte Spill
; ARM-NEXT:    asrs r0, r4, #31
; ARM-NEXT:    mov r1, r0
; ARM-NEXT:    ldr r2, [sp, #20] @ 4-byte Reload
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r6
; ARM-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; ARM-NEXT:    adcs r1, r2
; ARM-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    adds r0, r2, r0
; ARM-NEXT:    adcs r1, r5
; ARM-NEXT:    rsbs r5, r1, #0
; ARM-NEXT:    adcs r5, r1
; ARM-NEXT:    movs r2, #1
; ARM-NEXT:    str r0, [sp, #28] @ 4-byte Spill
; ARM-NEXT:    cmp r0, #1
; ARM-NEXT:    mov r3, r2
; ARM-NEXT:    bhi .LBB1_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    ldr r3, [sp, #32] @ 4-byte Reload
; ARM-NEXT:  .LBB1_2:
; ARM-NEXT:    ands r5, r3
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    mov r3, r2
; ARM-NEXT:    bgt .LBB1_4
; ARM-NEXT:  @ %bb.3:
; ARM-NEXT:    ldr r3, [sp, #32] @ 4-byte Reload
; ARM-NEXT:  .LBB1_4:
; ARM-NEXT:    orrs r3, r5
; ARM-NEXT:    ldr r0, [sp, #32] @ 4-byte Reload
; ARM-NEXT:    mvns r6, r0
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    str r6, [sp, #20] @ 4-byte Spill
; ARM-NEXT:    bne .LBB1_6
; ARM-NEXT:  @ %bb.5:
; ARM-NEXT:    ldr r0, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    lsls r0, r0, #30
; ARM-NEXT:    ldr r4, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    lsrs r4, r4, #2
; ARM-NEXT:    adds r0, r0, r4
; ARM-NEXT:    str r0, [sp, #20] @ 4-byte Spill
; ARM-NEXT:  .LBB1_6:
; ARM-NEXT:    adds r0, r1, #1
; ARM-NEXT:    rsbs r7, r0, #0
; ARM-NEXT:    adcs r7, r0
; ARM-NEXT:    mvns r0, r2
; ARM-NEXT:    ldr r5, [sp, #28] @ 4-byte Reload
; ARM-NEXT:    cmp r5, r0
; ARM-NEXT:    mov r0, r2
; ARM-NEXT:    blo .LBB1_8
; ARM-NEXT:  @ %bb.7:
; ARM-NEXT:    ldr r0, [sp, #32] @ 4-byte Reload
; ARM-NEXT:  .LBB1_8:
; ARM-NEXT:    ands r7, r0
; ARM-NEXT:    cmp r1, r6
; ARM-NEXT:    mov r6, r2
; ARM-NEXT:    bge .LBB1_12
; ARM-NEXT:  @ %bb.9:
; ARM-NEXT:    orrs r6, r7
; ARM-NEXT:    beq .LBB1_13
; ARM-NEXT:  .LBB1_10:
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    bne .LBB1_14
; ARM-NEXT:  .LBB1_11:
; ARM-NEXT:    ldr r0, [sp, #28] @ 4-byte Reload
; ARM-NEXT:    lsls r0, r0, #30
; ARM-NEXT:    ldr r1, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    lsrs r1, r1, #2
; ARM-NEXT:    adds r1, r0, r1
; ARM-NEXT:    cmp r6, #0
; ARM-NEXT:    bne .LBB1_15
; ARM-NEXT:    b .LBB1_16
; ARM-NEXT:  .LBB1_12:
; ARM-NEXT:    ldr r6, [sp, #32] @ 4-byte Reload
; ARM-NEXT:    orrs r6, r7
; ARM-NEXT:    bne .LBB1_10
; ARM-NEXT:  .LBB1_13:
; ARM-NEXT:    ldr r0, [sp, #20] @ 4-byte Reload
; ARM-NEXT:    str r0, [sp, #32] @ 4-byte Spill
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    beq .LBB1_11
; ARM-NEXT:  .LBB1_14:
; ARM-NEXT:    ldr r1, .LCPI1_0
; ARM-NEXT:    cmp r6, #0
; ARM-NEXT:    beq .LBB1_16
; ARM-NEXT:  .LBB1_15:
; ARM-NEXT:    lsls r1, r2, #31
; ARM-NEXT:  .LBB1_16:
; ARM-NEXT:    ldr r0, [sp, #32] @ 4-byte Reload
; ARM-NEXT:    add sp, #36
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.17:
; ARM-NEXT:  .LCPI1_0:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i64 @llvm.smul.fix.sat.i64(i64 %x, i64 %y, i32 2)
  ret i64 %tmp
}

define i4 @func3(i4 %x, i4 %y) nounwind {
; ARM-LABEL: func3:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, lr}
; ARM-NEXT:    push {r4, lr}
; ARM-NEXT:    lsls r0, r0, #28
; ARM-NEXT:    asrs r4, r0, #31
; ARM-NEXT:    lsls r1, r1, #28
; ARM-NEXT:    asrs r2, r1, #28
; ARM-NEXT:    asrs r3, r1, #31
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #1
; ARM-NEXT:    bgt .LBB2_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    lsrs r0, r0, #2
; ARM-NEXT:    lsls r2, r1, #30
; ARM-NEXT:    adds r0, r2, r0
; ARM-NEXT:    b .LBB2_3
; ARM-NEXT:  .LBB2_2:
; ARM-NEXT:    ldr r0, .LCPI2_0
; ARM-NEXT:  .LBB2_3:
; ARM-NEXT:    movs r2, #1
; ARM-NEXT:    mvns r3, r2
; ARM-NEXT:    cmp r1, r3
; ARM-NEXT:    bge .LBB2_5
; ARM-NEXT:  @ %bb.4:
; ARM-NEXT:    lsls r0, r2, #31
; ARM-NEXT:  .LBB2_5:
; ARM-NEXT:    asrs r0, r0, #28
; ARM-NEXT:    pop {r4, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.6:
; ARM-NEXT:  .LCPI2_0:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i4 @llvm.smul.fix.sat.i4(i4 %x, i4 %y, i32 2)
  ret i4 %tmp
}

;; These result in regular integer multiplication with a saturation check.
define i32 @func4(i32 %x, i32 %y) nounwind {
; ARM-LABEL: func4:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r7, lr}
; ARM-NEXT:    push {r7, lr}
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    asrs r1, r0, #31
; ARM-NEXT:    asrs r3, r2, #31
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    bmi .LBB3_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    ldr r2, .LCPI3_0
; ARM-NEXT:    b .LBB3_3
; ARM-NEXT:  .LBB3_2:
; ARM-NEXT:    movs r2, #1
; ARM-NEXT:    lsls r2, r2, #31
; ARM-NEXT:  .LBB3_3:
; ARM-NEXT:    asrs r3, r0, #31
; ARM-NEXT:    cmp r1, r3
; ARM-NEXT:    bne .LBB3_5
; ARM-NEXT:  @ %bb.4:
; ARM-NEXT:    mov r2, r0
; ARM-NEXT:  .LBB3_5:
; ARM-NEXT:    mov r0, r2
; ARM-NEXT:    pop {r7, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.6:
; ARM-NEXT:  .LCPI3_0:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i32 @llvm.smul.fix.sat.i32(i32 %x, i32 %y, i32 0)
  ret i32 %tmp
}

define i64 @func5(i64 %x, i64 %y) {
; ARM-LABEL: func5:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #28
; ARM-NEXT:    sub sp, #28
; ARM-NEXT:    str r3, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    mov r5, r2
; ARM-NEXT:    str r2, [sp, #16] @ 4-byte Spill
; ARM-NEXT:    mov r6, r1
; ARM-NEXT:    movs r7, #0
; ARM-NEXT:    mov r4, r0
; ARM-NEXT:    str r0, [sp, #20] @ 4-byte Spill
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    str r1, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    ldr r1, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r1
; ARM-NEXT:    str r0, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    adcs r5, r7
; ARM-NEXT:    mov r0, r4
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    ldr r4, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    mov r2, r4
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    ldr r2, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r2
; ARM-NEXT:    str r0, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    adcs r1, r7
; ARM-NEXT:    adds r0, r5, r1
; ARM-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r5, r7
; ARM-NEXT:    adcs r5, r7
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    mov r2, r4
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r7, r1
; ARM-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r1
; ARM-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    adcs r7, r5
; ARM-NEXT:    asrs r2, r6, #31
; ARM-NEXT:    ldr r0, [sp, #16] @ 4-byte Reload
; ARM-NEXT:    mov r5, r4
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r2
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r4, r0
; ARM-NEXT:    str r1, [sp, #16] @ 4-byte Spill
; ARM-NEXT:    asrs r0, r5, #31
; ARM-NEXT:    mov r1, r0
; ARM-NEXT:    ldr r2, [sp, #20] @ 4-byte Reload
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r4
; ARM-NEXT:    ldr r4, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; ARM-NEXT:    adcs r1, r2
; ARM-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r3, r2, r0
; ARM-NEXT:    adcs r1, r7
; ARM-NEXT:    asrs r2, r4, #31
; ARM-NEXT:    eors r1, r2
; ARM-NEXT:    eors r3, r2
; ARM-NEXT:    orrs r3, r1
; ARM-NEXT:    eors r6, r5
; ARM-NEXT:    asrs r1, r6, #31
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    bne .LBB4_3
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    beq .LBB4_4
; ARM-NEXT:  .LBB4_2:
; ARM-NEXT:    ldr r2, .LCPI4_0
; ARM-NEXT:    eors r1, r2
; ARM-NEXT:    add sp, #28
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:  .LBB4_3:
; ARM-NEXT:    mvns r0, r1
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    bne .LBB4_2
; ARM-NEXT:  .LBB4_4:
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    add sp, #28
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.5:
; ARM-NEXT:  .LCPI4_0:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i64 @llvm.smul.fix.sat.i64(i64 %x, i64 %y, i32 0)
  ret i64 %tmp
}

define i4 @func6(i4 %x, i4 %y) nounwind {
; ARM-LABEL: func6:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, lr}
; ARM-NEXT:    push {r4, lr}
; ARM-NEXT:    lsls r0, r0, #28
; ARM-NEXT:    asrs r4, r0, #31
; ARM-NEXT:    lsls r1, r1, #28
; ARM-NEXT:    asrs r2, r1, #28
; ARM-NEXT:    asrs r3, r1, #31
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    cmp r1, #0
; ARM-NEXT:    bmi .LBB5_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    ldr r2, .LCPI5_0
; ARM-NEXT:    b .LBB5_3
; ARM-NEXT:  .LBB5_2:
; ARM-NEXT:    movs r2, #1
; ARM-NEXT:    lsls r2, r2, #31
; ARM-NEXT:  .LBB5_3:
; ARM-NEXT:    asrs r3, r0, #31
; ARM-NEXT:    cmp r1, r3
; ARM-NEXT:    bne .LBB5_5
; ARM-NEXT:  @ %bb.4:
; ARM-NEXT:    mov r2, r0
; ARM-NEXT:  .LBB5_5:
; ARM-NEXT:    asrs r0, r2, #28
; ARM-NEXT:    pop {r4, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.6:
; ARM-NEXT:  .LCPI5_0:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i4 @llvm.smul.fix.sat.i4(i4 %x, i4 %y, i32 0)
  ret i4 %tmp
}

define i64 @func7(i64 %x, i64 %y) nounwind {
; ARM-LABEL: func7:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #28
; ARM-NEXT:    sub sp, #28
; ARM-NEXT:    str r3, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    str r1, [sp, #20] @ 4-byte Spill
; ARM-NEXT:    movs r6, #0
; ARM-NEXT:    mov r7, r0
; ARM-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    mov r4, r2
; ARM-NEXT:    str r2, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r0, r5
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    mov r2, r4
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r4, r0, r1
; ARM-NEXT:    adcs r5, r6
; ARM-NEXT:    mov r0, r7
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    ldr r7, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    mov r2, r7
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r4
; ARM-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    adcs r1, r6
; ARM-NEXT:    adds r0, r5, r1
; ARM-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r4, r6
; ARM-NEXT:    adcs r4, r6
; ARM-NEXT:    ldr r5, [sp, #20] @ 4-byte Reload
; ARM-NEXT:    mov r0, r5
; ARM-NEXT:    mov r1, r6
; ARM-NEXT:    mov r2, r7
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r7, r1
; ARM-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r1
; ARM-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    adcs r7, r4
; ARM-NEXT:    asrs r2, r5, #31
; ARM-NEXT:    ldr r0, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    ldr r5, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    mov r1, r5
; ARM-NEXT:    mov r3, r2
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r4, r0
; ARM-NEXT:    str r1, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    asrs r0, r5, #31
; ARM-NEXT:    mov r1, r0
; ARM-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; ARM-NEXT:    ldr r3, [sp, #20] @ 4-byte Reload
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    adds r0, r0, r4
; ARM-NEXT:    ldr r1, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    adcs r2, r1
; ARM-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r0, r1, r0
; ARM-NEXT:    adcs r2, r7
; ARM-NEXT:    rsbs r5, r2, #0
; ARM-NEXT:    adcs r5, r2
; ARM-NEXT:    movs r4, #1
; ARM-NEXT:    str r0, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    cmp r0, #0
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bmi .LBB6_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:  .LBB6_2:
; ARM-NEXT:    ands r5, r3
; ARM-NEXT:    cmp r2, #0
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r4
; ARM-NEXT:    bgt .LBB6_4
; ARM-NEXT:  @ %bb.3:
; ARM-NEXT:    mov r3, r6
; ARM-NEXT:  .LBB6_4:
; ARM-NEXT:    orrs r3, r5
; ARM-NEXT:    mvns r4, r6
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    mov r5, r4
; ARM-NEXT:    bne .LBB6_6
; ARM-NEXT:  @ %bb.5:
; ARM-NEXT:    ldr r5, [sp, #4] @ 4-byte Reload
; ARM-NEXT:  .LBB6_6:
; ARM-NEXT:    adds r0, r2, #1
; ARM-NEXT:    rsbs r7, r0, #0
; ARM-NEXT:    adcs r7, r0
; ARM-NEXT:    ldr r0, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    cmp r0, #0
; ARM-NEXT:    mov r0, r1
; ARM-NEXT:    bge .LBB6_8
; ARM-NEXT:  @ %bb.7:
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:  .LBB6_8:
; ARM-NEXT:    ands r7, r0
; ARM-NEXT:    cmp r2, r4
; ARM-NEXT:    mov r0, r1
; ARM-NEXT:    mov r2, r1
; ARM-NEXT:    bge .LBB6_12
; ARM-NEXT:  @ %bb.9:
; ARM-NEXT:    orrs r2, r7
; ARM-NEXT:    beq .LBB6_13
; ARM-NEXT:  .LBB6_10:
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    bne .LBB6_14
; ARM-NEXT:  .LBB6_11:
; ARM-NEXT:    ldr r1, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    cmp r2, #0
; ARM-NEXT:    bne .LBB6_15
; ARM-NEXT:    b .LBB6_16
; ARM-NEXT:  .LBB6_12:
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    orrs r2, r7
; ARM-NEXT:    bne .LBB6_10
; ARM-NEXT:  .LBB6_13:
; ARM-NEXT:    mov r6, r5
; ARM-NEXT:    cmp r3, #0
; ARM-NEXT:    beq .LBB6_11
; ARM-NEXT:  .LBB6_14:
; ARM-NEXT:    ldr r1, .LCPI6_0
; ARM-NEXT:    cmp r2, #0
; ARM-NEXT:    beq .LBB6_16
; ARM-NEXT:  .LBB6_15:
; ARM-NEXT:    lsls r1, r0, #31
; ARM-NEXT:  .LBB6_16:
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:    add sp, #28
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.17:
; ARM-NEXT:  .LCPI6_0:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i64 @llvm.smul.fix.sat.i64(i64 %x, i64 %y, i32 32)
  ret i64 %tmp
}

define i64 @func8(i64 %x, i64 %y) nounwind {
; ARM-LABEL: func8:
; ARM:       @ %bb.0:
; ARM-NEXT:    .save {r4, r5, r6, r7, lr}
; ARM-NEXT:    push {r4, r5, r6, r7, lr}
; ARM-NEXT:    .pad #28
; ARM-NEXT:    sub sp, #28
; ARM-NEXT:    str r3, [sp, #24] @ 4-byte Spill
; ARM-NEXT:    mov r5, r2
; ARM-NEXT:    str r2, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    mov r4, r1
; ARM-NEXT:    str r1, [sp, #20] @ 4-byte Spill
; ARM-NEXT:    movs r7, #0
; ARM-NEXT:    mov r6, r0
; ARM-NEXT:    str r0, [sp, #16] @ 4-byte Spill
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    str r1, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r0, r4
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    mov r2, r5
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r5, r1
; ARM-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r4, r0, r1
; ARM-NEXT:    adcs r5, r7
; ARM-NEXT:    mov r0, r6
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    ldr r6, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r4
; ARM-NEXT:    str r0, [sp, #4] @ 4-byte Spill
; ARM-NEXT:    adcs r1, r7
; ARM-NEXT:    adds r0, r5, r1
; ARM-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    mov r4, r7
; ARM-NEXT:    adcs r4, r7
; ARM-NEXT:    ldr r5, [sp, #20] @ 4-byte Reload
; ARM-NEXT:    mov r0, r5
; ARM-NEXT:    mov r1, r7
; ARM-NEXT:    mov r2, r6
; ARM-NEXT:    mov r3, r7
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r6, r1
; ARM-NEXT:    ldr r1, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r0, r0, r1
; ARM-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; ARM-NEXT:    adcs r6, r4
; ARM-NEXT:    asrs r2, r5, #31
; ARM-NEXT:    ldr r0, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    ldr r4, [sp, #24] @ 4-byte Reload
; ARM-NEXT:    mov r1, r4
; ARM-NEXT:    mov r3, r2
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    mov r5, r0
; ARM-NEXT:    str r1, [sp, #12] @ 4-byte Spill
; ARM-NEXT:    asrs r0, r4, #31
; ARM-NEXT:    mov r1, r0
; ARM-NEXT:    ldr r2, [sp, #16] @ 4-byte Reload
; ARM-NEXT:    ldr r3, [sp, #20] @ 4-byte Reload
; ARM-NEXT:    bl __aeabi_lmul
; ARM-NEXT:    adds r0, r0, r5
; ARM-NEXT:    ldr r2, [sp, #12] @ 4-byte Reload
; ARM-NEXT:    adcs r1, r2
; ARM-NEXT:    ldr r2, [sp, #8] @ 4-byte Reload
; ARM-NEXT:    adds r0, r2, r0
; ARM-NEXT:    adcs r1, r6
; ARM-NEXT:    ldr r2, .LCPI7_0
; ARM-NEXT:    cmp r1, r2
; ARM-NEXT:    bgt .LBB7_2
; ARM-NEXT:  @ %bb.1:
; ARM-NEXT:    lsls r3, r0, #1
; ARM-NEXT:    ldr r4, [sp, #4] @ 4-byte Reload
; ARM-NEXT:    lsrs r4, r4, #31
; ARM-NEXT:    adds r5, r3, r4
; ARM-NEXT:    b .LBB7_3
; ARM-NEXT:  .LBB7_2:
; ARM-NEXT:    mvns r5, r7
; ARM-NEXT:  .LBB7_3:
; ARM-NEXT:    movs r3, #3
; ARM-NEXT:    lsls r3, r3, #30
; ARM-NEXT:    cmp r1, r3
; ARM-NEXT:    blt .LBB7_5
; ARM-NEXT:  @ %bb.4:
; ARM-NEXT:    mov r7, r5
; ARM-NEXT:  .LBB7_5:
; ARM-NEXT:    cmp r1, r2
; ARM-NEXT:    bgt .LBB7_7
; ARM-NEXT:  @ %bb.6:
; ARM-NEXT:    lsls r2, r1, #1
; ARM-NEXT:    lsrs r0, r0, #31
; ARM-NEXT:    adds r2, r2, r0
; ARM-NEXT:    cmp r1, r3
; ARM-NEXT:    blt .LBB7_8
; ARM-NEXT:    b .LBB7_9
; ARM-NEXT:  .LBB7_7:
; ARM-NEXT:    ldr r2, .LCPI7_1
; ARM-NEXT:    cmp r1, r3
; ARM-NEXT:    bge .LBB7_9
; ARM-NEXT:  .LBB7_8:
; ARM-NEXT:    movs r0, #1
; ARM-NEXT:    lsls r2, r0, #31
; ARM-NEXT:  .LBB7_9:
; ARM-NEXT:    mov r0, r7
; ARM-NEXT:    mov r1, r2
; ARM-NEXT:    add sp, #28
; ARM-NEXT:    pop {r4, r5, r6, r7, pc}
; ARM-NEXT:    .p2align 2
; ARM-NEXT:  @ %bb.10:
; ARM-NEXT:  .LCPI7_0:
; ARM-NEXT:    .long 1073741823 @ 0x3fffffff
; ARM-NEXT:  .LCPI7_1:
; ARM-NEXT:    .long 2147483647 @ 0x7fffffff
  %tmp = call i64 @llvm.smul.fix.sat.i64(i64 %x, i64 %y, i32 63)
  ret i64 %tmp
}
