; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+m,+zfh,+zvfh -target-abi=ilp32d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s \
; RUN:   --check-prefixes=CHECK,ZVFH,ZVFH32
; RUN: llc -mtriple=riscv64 -mattr=+v,+m,+zfh,+zvfh -target-abi=lp64d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s \
; RUN:   --check-prefixes=CHECK,ZVFH,ZVFH64
; RUN: llc -mtriple=riscv32 -mattr=+v,+m,+zfh,+zvfhmin -target-abi=ilp32d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,ZVFHMIN,ZVFHMIN32
; RUN: llc -mtriple=riscv64 -mattr=+v,+m,+zfh,+zvfhmin -target-abi=lp64d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s \
; RUN:   --check-prefixes=CHECK,ZVFHMIN,ZVFHMIN64

declare <7 x i1> @llvm.vp.fcmp.v7f16(<7 x half>, <7 x half>, metadata, <7 x i1>, i32)

define <7 x i1> @fcmp_oeq_vv_v7f16(<7 x half> %va, <7 x half> %vb, <7 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vv_v7f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_v7f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <7 x i1> @llvm.vp.fcmp.v7f16(<7 x half> %va, <7 x half> %vb, metadata !"oeq", <7 x i1> %m, i32 %evl)
  ret <7 x i1> %v
}

declare <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half>, <8 x half>, metadata, <8 x i1>, i32)

define <8 x i1> @fcmp_oeq_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oeq_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ogt_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ogt_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v9, v8, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oge_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_oge_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_olt_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfgt.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_olt_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ole_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfge.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ole_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vv v10, v8, v9, v0.t
; ZVFH-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_one_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_one_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vv v9, v9, v9, v0.t
; ZVFH-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ord_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfeq.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfeq.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmand.mm v0, v9, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ord_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfeq.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmand.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vv v10, v8, v9, v0.t
; ZVFH-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v8, v10
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ueq_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfgt.vf v9, v8, fa0, v0.t
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ueq_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmflt.vv v9, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmnor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vv v8, v8, v9, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ugt_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ugt_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vv v8, v8, v9, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uge_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uge_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfge.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ult_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfle.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ult_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfle.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vv v8, v9, v8, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfgt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_ule_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmflt.vf v8, v8, fa0, v0.t
; ZVFH-NEXT:    vmnot.m v0, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_ule_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmflt.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmnot.m v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vv v0, v8, v9, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v12, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_une_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vf v0, v8, fa0, v0.t
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_une_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v12, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v12, v10, v0.t
; ZVFHMIN-NEXT:    vmv1r.v v0, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vv_v8f16(<8 x half> %va, <8 x half> %vb, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vv_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vv v9, v9, v9, v0.t
; ZVFH-NEXT:    vmfne.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vv_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vf_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfne.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v8, v9
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v8, v9
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_swap_v8f16(<8 x half> %va, half %b, <8 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_uno_vf_swap_v8f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFH-NEXT:    vfmv.v.f v9, fa0
; ZVFH-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; ZVFH-NEXT:    vmfne.vf v9, v9, fa0, v0.t
; ZVFH-NEXT:    vmfne.vv v8, v8, v8, v0.t
; ZVFH-NEXT:    vmor.mm v0, v9, v8
; ZVFH-NEXT:    ret
;
; ZVFHMIN-LABEL: fcmp_uno_vf_swap_v8f16:
; ZVFHMIN:       # %bb.0:
; ZVFHMIN-NEXT:    fcvt.s.h fa5, fa0
; ZVFHMIN-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vfmv.v.f v10, fa5
; ZVFHMIN-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfncvt.f.f.w v9, v10
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v8
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v8, v10, v10, v0.t
; ZVFHMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFHMIN-NEXT:    vfwcvt.f.f.v v10, v9
; ZVFHMIN-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; ZVFHMIN-NEXT:    vmfne.vv v9, v10, v10, v0.t
; ZVFHMIN-NEXT:    vmor.mm v0, v9, v8
; ZVFHMIN-NEXT:    ret
  %elt.head = insertelement <8 x half> poison, half %b, i32 0
  %vb = shufflevector <8 x half> %elt.head, <8 x half> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f16(<8 x half> %vb, <8 x half> %va, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

declare <128 x i1> @llvm.vp.fcmp.v128f16(<128 x half>, <128 x half>, metadata, <128 x i1>, i32)

define <128 x i1> @fcmp_oeq_vv_v128f16(<128 x half> %va, <128 x half> %vb, <128 x i1> %m, i32 zeroext %evl) {
; ZVFH-LABEL: fcmp_oeq_vv_v128f16:
; ZVFH:       # %bb.0:
; ZVFH-NEXT:    addi sp, sp, -16
; ZVFH-NEXT:    .cfi_def_cfa_offset 16
; ZVFH-NEXT:    csrr a1, vlenb
; ZVFH-NEXT:    slli a1, a1, 4
; ZVFH-NEXT:    sub sp, sp, a1
; ZVFH-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; ZVFH-NEXT:    addi a1, a0, 128
; ZVFH-NEXT:    li a3, 64
; ZVFH-NEXT:    vsetvli zero, a3, e16, m8, ta, ma
; ZVFH-NEXT:    vle16.v v24, (a1)
; ZVFH-NEXT:    csrr a1, vlenb
; ZVFH-NEXT:    slli a1, a1, 3
; ZVFH-NEXT:    add a1, sp, a1
; ZVFH-NEXT:    addi a1, a1, 16
; ZVFH-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; ZVFH-NEXT:    vle16.v v24, (a0)
; ZVFH-NEXT:    addi a0, sp, 16
; ZVFH-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; ZVFH-NEXT:    vsetivli zero, 8, e8, m1, ta, ma
; ZVFH-NEXT:    vslidedown.vi v6, v0, 8
; ZVFH-NEXT:    mv a0, a2
; ZVFH-NEXT:    bltu a2, a3, .LBB43_2
; ZVFH-NEXT:  # %bb.1:
; ZVFH-NEXT:    li a0, 64
; ZVFH-NEXT:  .LBB43_2:
; ZVFH-NEXT:    addi a1, sp, 16
; ZVFH-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; ZVFH-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; ZVFH-NEXT:    vmfeq.vv v7, v8, v24, v0.t
; ZVFH-NEXT:    addi a0, a2, -64
; ZVFH-NEXT:    sltu a1, a2, a0
; ZVFH-NEXT:    addi a1, a1, -1
; ZVFH-NEXT:    and a0, a1, a0
; ZVFH-NEXT:    vmv1r.v v0, v6
; ZVFH-NEXT:    csrr a1, vlenb
; ZVFH-NEXT:    slli a1, a1, 3
; ZVFH-NEXT:    add a1, sp, a1
; ZVFH-NEXT:    addi a1, a1, 16
; ZVFH-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; ZVFH-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; ZVFH-NEXT:    vmfeq.vv v8, v16, v24, v0.t
; ZVFH-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; ZVFH-NEXT:    vslideup.vi v7, v8, 8
; ZVFH-NEXT:    vmv.v.v v0, v7
; ZVFH-NEXT:    csrr a0, vlenb
; ZVFH-NEXT:    slli a0, a0, 4
; ZVFH-NEXT:    add sp, sp, a0
; ZVFH-NEXT:    addi sp, sp, 16
; ZVFH-NEXT:    ret
;
; ZVFHMIN32-LABEL: fcmp_oeq_vv_v128f16:
; ZVFHMIN32:       # %bb.0:
; ZVFHMIN32-NEXT:    addi sp, sp, -768
; ZVFHMIN32-NEXT:    .cfi_def_cfa_offset 768
; ZVFHMIN32-NEXT:    sw ra, 764(sp) # 4-byte Folded Spill
; ZVFHMIN32-NEXT:    sw s0, 760(sp) # 4-byte Folded Spill
; ZVFHMIN32-NEXT:    .cfi_offset ra, -4
; ZVFHMIN32-NEXT:    .cfi_offset s0, -8
; ZVFHMIN32-NEXT:    addi s0, sp, 768
; ZVFHMIN32-NEXT:    .cfi_def_cfa s0, 0
; ZVFHMIN32-NEXT:    andi sp, sp, -128
; ZVFHMIN32-NEXT:    addi a1, a0, 128
; ZVFHMIN32-NEXT:    li a2, 64
; ZVFHMIN32-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; ZVFHMIN32-NEXT:    vle16.v v24, (a1)
; ZVFHMIN32-NEXT:    vle16.v v0, (a0)
; ZVFHMIN32-NEXT:    addi a0, sp, 128
; ZVFHMIN32-NEXT:    vse16.v v8, (a0)
; ZVFHMIN32-NEXT:    addi a0, sp, 384
; ZVFHMIN32-NEXT:    vse16.v v0, (a0)
; ZVFHMIN32-NEXT:    addi a0, sp, 256
; ZVFHMIN32-NEXT:    vse16.v v16, (a0)
; ZVFHMIN32-NEXT:    addi a0, sp, 512
; ZVFHMIN32-NEXT:    vse16.v v24, (a0)
; ZVFHMIN32-NEXT:    flh fa5, 254(sp)
; ZVFHMIN32-NEXT:    flh fa4, 510(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 63(sp)
; ZVFHMIN32-NEXT:    flh fa5, 252(sp)
; ZVFHMIN32-NEXT:    flh fa4, 508(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 62(sp)
; ZVFHMIN32-NEXT:    flh fa5, 250(sp)
; ZVFHMIN32-NEXT:    flh fa4, 506(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 61(sp)
; ZVFHMIN32-NEXT:    flh fa5, 248(sp)
; ZVFHMIN32-NEXT:    flh fa4, 504(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 60(sp)
; ZVFHMIN32-NEXT:    flh fa5, 246(sp)
; ZVFHMIN32-NEXT:    flh fa4, 502(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 59(sp)
; ZVFHMIN32-NEXT:    flh fa5, 244(sp)
; ZVFHMIN32-NEXT:    flh fa4, 500(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 58(sp)
; ZVFHMIN32-NEXT:    flh fa5, 242(sp)
; ZVFHMIN32-NEXT:    flh fa4, 498(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 57(sp)
; ZVFHMIN32-NEXT:    flh fa5, 240(sp)
; ZVFHMIN32-NEXT:    flh fa4, 496(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 56(sp)
; ZVFHMIN32-NEXT:    flh fa5, 238(sp)
; ZVFHMIN32-NEXT:    flh fa4, 494(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 55(sp)
; ZVFHMIN32-NEXT:    flh fa5, 236(sp)
; ZVFHMIN32-NEXT:    flh fa4, 492(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 54(sp)
; ZVFHMIN32-NEXT:    flh fa5, 234(sp)
; ZVFHMIN32-NEXT:    flh fa4, 490(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 53(sp)
; ZVFHMIN32-NEXT:    flh fa5, 232(sp)
; ZVFHMIN32-NEXT:    flh fa4, 488(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 52(sp)
; ZVFHMIN32-NEXT:    flh fa5, 230(sp)
; ZVFHMIN32-NEXT:    flh fa4, 486(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 51(sp)
; ZVFHMIN32-NEXT:    flh fa5, 228(sp)
; ZVFHMIN32-NEXT:    flh fa4, 484(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 50(sp)
; ZVFHMIN32-NEXT:    flh fa5, 226(sp)
; ZVFHMIN32-NEXT:    flh fa4, 482(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 49(sp)
; ZVFHMIN32-NEXT:    flh fa5, 224(sp)
; ZVFHMIN32-NEXT:    flh fa4, 480(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 48(sp)
; ZVFHMIN32-NEXT:    flh fa5, 222(sp)
; ZVFHMIN32-NEXT:    flh fa4, 478(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 47(sp)
; ZVFHMIN32-NEXT:    flh fa5, 382(sp)
; ZVFHMIN32-NEXT:    flh fa4, 638(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 127(sp)
; ZVFHMIN32-NEXT:    flh fa5, 380(sp)
; ZVFHMIN32-NEXT:    flh fa4, 636(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 126(sp)
; ZVFHMIN32-NEXT:    flh fa5, 378(sp)
; ZVFHMIN32-NEXT:    flh fa4, 634(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 125(sp)
; ZVFHMIN32-NEXT:    flh fa5, 376(sp)
; ZVFHMIN32-NEXT:    flh fa4, 632(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 124(sp)
; ZVFHMIN32-NEXT:    flh fa5, 374(sp)
; ZVFHMIN32-NEXT:    flh fa4, 630(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 123(sp)
; ZVFHMIN32-NEXT:    flh fa5, 372(sp)
; ZVFHMIN32-NEXT:    flh fa4, 628(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 122(sp)
; ZVFHMIN32-NEXT:    flh fa5, 370(sp)
; ZVFHMIN32-NEXT:    flh fa4, 626(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 121(sp)
; ZVFHMIN32-NEXT:    flh fa5, 368(sp)
; ZVFHMIN32-NEXT:    flh fa4, 624(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 120(sp)
; ZVFHMIN32-NEXT:    flh fa5, 366(sp)
; ZVFHMIN32-NEXT:    flh fa4, 622(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 119(sp)
; ZVFHMIN32-NEXT:    flh fa5, 364(sp)
; ZVFHMIN32-NEXT:    flh fa4, 620(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 118(sp)
; ZVFHMIN32-NEXT:    flh fa5, 362(sp)
; ZVFHMIN32-NEXT:    flh fa4, 618(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 117(sp)
; ZVFHMIN32-NEXT:    flh fa5, 360(sp)
; ZVFHMIN32-NEXT:    flh fa4, 616(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 116(sp)
; ZVFHMIN32-NEXT:    flh fa5, 358(sp)
; ZVFHMIN32-NEXT:    flh fa4, 614(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 115(sp)
; ZVFHMIN32-NEXT:    flh fa5, 356(sp)
; ZVFHMIN32-NEXT:    flh fa4, 612(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 114(sp)
; ZVFHMIN32-NEXT:    flh fa5, 354(sp)
; ZVFHMIN32-NEXT:    flh fa4, 610(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 113(sp)
; ZVFHMIN32-NEXT:    flh fa5, 352(sp)
; ZVFHMIN32-NEXT:    flh fa4, 608(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 112(sp)
; ZVFHMIN32-NEXT:    flh fa5, 350(sp)
; ZVFHMIN32-NEXT:    flh fa4, 606(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 111(sp)
; ZVFHMIN32-NEXT:    flh fa5, 220(sp)
; ZVFHMIN32-NEXT:    flh fa4, 476(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 46(sp)
; ZVFHMIN32-NEXT:    flh fa5, 218(sp)
; ZVFHMIN32-NEXT:    flh fa4, 474(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 45(sp)
; ZVFHMIN32-NEXT:    flh fa5, 216(sp)
; ZVFHMIN32-NEXT:    flh fa4, 472(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 44(sp)
; ZVFHMIN32-NEXT:    flh fa5, 214(sp)
; ZVFHMIN32-NEXT:    flh fa4, 470(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 43(sp)
; ZVFHMIN32-NEXT:    flh fa5, 212(sp)
; ZVFHMIN32-NEXT:    flh fa4, 468(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 42(sp)
; ZVFHMIN32-NEXT:    flh fa5, 210(sp)
; ZVFHMIN32-NEXT:    flh fa4, 466(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 41(sp)
; ZVFHMIN32-NEXT:    flh fa5, 208(sp)
; ZVFHMIN32-NEXT:    flh fa4, 464(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 40(sp)
; ZVFHMIN32-NEXT:    flh fa5, 206(sp)
; ZVFHMIN32-NEXT:    flh fa4, 462(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 39(sp)
; ZVFHMIN32-NEXT:    flh fa5, 204(sp)
; ZVFHMIN32-NEXT:    flh fa4, 460(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 38(sp)
; ZVFHMIN32-NEXT:    flh fa5, 202(sp)
; ZVFHMIN32-NEXT:    flh fa4, 458(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 37(sp)
; ZVFHMIN32-NEXT:    flh fa5, 200(sp)
; ZVFHMIN32-NEXT:    flh fa4, 456(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 36(sp)
; ZVFHMIN32-NEXT:    flh fa5, 198(sp)
; ZVFHMIN32-NEXT:    flh fa4, 454(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 35(sp)
; ZVFHMIN32-NEXT:    flh fa5, 196(sp)
; ZVFHMIN32-NEXT:    flh fa4, 452(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 34(sp)
; ZVFHMIN32-NEXT:    flh fa5, 194(sp)
; ZVFHMIN32-NEXT:    flh fa4, 450(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 33(sp)
; ZVFHMIN32-NEXT:    flh fa5, 192(sp)
; ZVFHMIN32-NEXT:    flh fa4, 448(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 32(sp)
; ZVFHMIN32-NEXT:    flh fa5, 190(sp)
; ZVFHMIN32-NEXT:    flh fa4, 446(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 31(sp)
; ZVFHMIN32-NEXT:    flh fa5, 188(sp)
; ZVFHMIN32-NEXT:    flh fa4, 444(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 30(sp)
; ZVFHMIN32-NEXT:    flh fa5, 348(sp)
; ZVFHMIN32-NEXT:    flh fa4, 604(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 110(sp)
; ZVFHMIN32-NEXT:    flh fa5, 346(sp)
; ZVFHMIN32-NEXT:    flh fa4, 602(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 109(sp)
; ZVFHMIN32-NEXT:    flh fa5, 344(sp)
; ZVFHMIN32-NEXT:    flh fa4, 600(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 108(sp)
; ZVFHMIN32-NEXT:    flh fa5, 342(sp)
; ZVFHMIN32-NEXT:    flh fa4, 598(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 107(sp)
; ZVFHMIN32-NEXT:    flh fa5, 340(sp)
; ZVFHMIN32-NEXT:    flh fa4, 596(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 106(sp)
; ZVFHMIN32-NEXT:    flh fa5, 338(sp)
; ZVFHMIN32-NEXT:    flh fa4, 594(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 105(sp)
; ZVFHMIN32-NEXT:    flh fa5, 336(sp)
; ZVFHMIN32-NEXT:    flh fa4, 592(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 104(sp)
; ZVFHMIN32-NEXT:    flh fa5, 334(sp)
; ZVFHMIN32-NEXT:    flh fa4, 590(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 103(sp)
; ZVFHMIN32-NEXT:    flh fa5, 332(sp)
; ZVFHMIN32-NEXT:    flh fa4, 588(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 102(sp)
; ZVFHMIN32-NEXT:    flh fa5, 330(sp)
; ZVFHMIN32-NEXT:    flh fa4, 586(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 101(sp)
; ZVFHMIN32-NEXT:    flh fa5, 328(sp)
; ZVFHMIN32-NEXT:    flh fa4, 584(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 100(sp)
; ZVFHMIN32-NEXT:    flh fa5, 326(sp)
; ZVFHMIN32-NEXT:    flh fa4, 582(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 99(sp)
; ZVFHMIN32-NEXT:    flh fa5, 324(sp)
; ZVFHMIN32-NEXT:    flh fa4, 580(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 98(sp)
; ZVFHMIN32-NEXT:    flh fa5, 322(sp)
; ZVFHMIN32-NEXT:    flh fa4, 578(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 97(sp)
; ZVFHMIN32-NEXT:    flh fa5, 320(sp)
; ZVFHMIN32-NEXT:    flh fa4, 576(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 96(sp)
; ZVFHMIN32-NEXT:    flh fa5, 318(sp)
; ZVFHMIN32-NEXT:    flh fa4, 574(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 95(sp)
; ZVFHMIN32-NEXT:    flh fa5, 316(sp)
; ZVFHMIN32-NEXT:    flh fa4, 572(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 94(sp)
; ZVFHMIN32-NEXT:    flh fa5, 186(sp)
; ZVFHMIN32-NEXT:    flh fa4, 442(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 29(sp)
; ZVFHMIN32-NEXT:    flh fa5, 184(sp)
; ZVFHMIN32-NEXT:    flh fa4, 440(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 28(sp)
; ZVFHMIN32-NEXT:    flh fa5, 182(sp)
; ZVFHMIN32-NEXT:    flh fa4, 438(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 27(sp)
; ZVFHMIN32-NEXT:    flh fa5, 180(sp)
; ZVFHMIN32-NEXT:    flh fa4, 436(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 26(sp)
; ZVFHMIN32-NEXT:    flh fa5, 178(sp)
; ZVFHMIN32-NEXT:    flh fa4, 434(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 25(sp)
; ZVFHMIN32-NEXT:    flh fa5, 176(sp)
; ZVFHMIN32-NEXT:    flh fa4, 432(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 24(sp)
; ZVFHMIN32-NEXT:    flh fa5, 174(sp)
; ZVFHMIN32-NEXT:    flh fa4, 430(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 23(sp)
; ZVFHMIN32-NEXT:    flh fa5, 172(sp)
; ZVFHMIN32-NEXT:    flh fa4, 428(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 22(sp)
; ZVFHMIN32-NEXT:    flh fa5, 170(sp)
; ZVFHMIN32-NEXT:    flh fa4, 426(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 21(sp)
; ZVFHMIN32-NEXT:    flh fa5, 168(sp)
; ZVFHMIN32-NEXT:    flh fa4, 424(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 20(sp)
; ZVFHMIN32-NEXT:    flh fa5, 166(sp)
; ZVFHMIN32-NEXT:    flh fa4, 422(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 19(sp)
; ZVFHMIN32-NEXT:    flh fa5, 164(sp)
; ZVFHMIN32-NEXT:    flh fa4, 420(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 18(sp)
; ZVFHMIN32-NEXT:    flh fa5, 162(sp)
; ZVFHMIN32-NEXT:    flh fa4, 418(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 17(sp)
; ZVFHMIN32-NEXT:    flh fa5, 160(sp)
; ZVFHMIN32-NEXT:    flh fa4, 416(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 16(sp)
; ZVFHMIN32-NEXT:    flh fa5, 158(sp)
; ZVFHMIN32-NEXT:    flh fa4, 414(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 15(sp)
; ZVFHMIN32-NEXT:    flh fa5, 156(sp)
; ZVFHMIN32-NEXT:    flh fa4, 412(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 14(sp)
; ZVFHMIN32-NEXT:    flh fa5, 154(sp)
; ZVFHMIN32-NEXT:    flh fa4, 410(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 13(sp)
; ZVFHMIN32-NEXT:    flh fa5, 314(sp)
; ZVFHMIN32-NEXT:    flh fa4, 570(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 93(sp)
; ZVFHMIN32-NEXT:    flh fa5, 312(sp)
; ZVFHMIN32-NEXT:    flh fa4, 568(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 92(sp)
; ZVFHMIN32-NEXT:    flh fa5, 310(sp)
; ZVFHMIN32-NEXT:    flh fa4, 566(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 91(sp)
; ZVFHMIN32-NEXT:    flh fa5, 308(sp)
; ZVFHMIN32-NEXT:    flh fa4, 564(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 90(sp)
; ZVFHMIN32-NEXT:    flh fa5, 306(sp)
; ZVFHMIN32-NEXT:    flh fa4, 562(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 89(sp)
; ZVFHMIN32-NEXT:    flh fa5, 304(sp)
; ZVFHMIN32-NEXT:    flh fa4, 560(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 88(sp)
; ZVFHMIN32-NEXT:    flh fa5, 302(sp)
; ZVFHMIN32-NEXT:    flh fa4, 558(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 87(sp)
; ZVFHMIN32-NEXT:    flh fa5, 300(sp)
; ZVFHMIN32-NEXT:    flh fa4, 556(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 86(sp)
; ZVFHMIN32-NEXT:    flh fa5, 298(sp)
; ZVFHMIN32-NEXT:    flh fa4, 554(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 85(sp)
; ZVFHMIN32-NEXT:    flh fa5, 296(sp)
; ZVFHMIN32-NEXT:    flh fa4, 552(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 84(sp)
; ZVFHMIN32-NEXT:    flh fa5, 294(sp)
; ZVFHMIN32-NEXT:    flh fa4, 550(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 83(sp)
; ZVFHMIN32-NEXT:    flh fa5, 292(sp)
; ZVFHMIN32-NEXT:    flh fa4, 548(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 82(sp)
; ZVFHMIN32-NEXT:    flh fa5, 290(sp)
; ZVFHMIN32-NEXT:    flh fa4, 546(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 81(sp)
; ZVFHMIN32-NEXT:    flh fa5, 288(sp)
; ZVFHMIN32-NEXT:    flh fa4, 544(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 80(sp)
; ZVFHMIN32-NEXT:    flh fa5, 286(sp)
; ZVFHMIN32-NEXT:    flh fa4, 542(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 79(sp)
; ZVFHMIN32-NEXT:    flh fa5, 284(sp)
; ZVFHMIN32-NEXT:    flh fa4, 540(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 78(sp)
; ZVFHMIN32-NEXT:    flh fa5, 282(sp)
; ZVFHMIN32-NEXT:    flh fa4, 538(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 77(sp)
; ZVFHMIN32-NEXT:    flh fa5, 152(sp)
; ZVFHMIN32-NEXT:    flh fa4, 408(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 12(sp)
; ZVFHMIN32-NEXT:    flh fa5, 150(sp)
; ZVFHMIN32-NEXT:    flh fa4, 406(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 11(sp)
; ZVFHMIN32-NEXT:    flh fa5, 148(sp)
; ZVFHMIN32-NEXT:    flh fa4, 404(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 10(sp)
; ZVFHMIN32-NEXT:    flh fa5, 146(sp)
; ZVFHMIN32-NEXT:    flh fa4, 402(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 9(sp)
; ZVFHMIN32-NEXT:    flh fa5, 144(sp)
; ZVFHMIN32-NEXT:    flh fa4, 400(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 8(sp)
; ZVFHMIN32-NEXT:    flh fa5, 142(sp)
; ZVFHMIN32-NEXT:    flh fa4, 398(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 7(sp)
; ZVFHMIN32-NEXT:    flh fa5, 140(sp)
; ZVFHMIN32-NEXT:    flh fa4, 396(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 6(sp)
; ZVFHMIN32-NEXT:    flh fa5, 138(sp)
; ZVFHMIN32-NEXT:    flh fa4, 394(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 5(sp)
; ZVFHMIN32-NEXT:    flh fa5, 136(sp)
; ZVFHMIN32-NEXT:    flh fa4, 392(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 4(sp)
; ZVFHMIN32-NEXT:    flh fa5, 134(sp)
; ZVFHMIN32-NEXT:    flh fa4, 390(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 3(sp)
; ZVFHMIN32-NEXT:    flh fa5, 132(sp)
; ZVFHMIN32-NEXT:    flh fa4, 388(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 2(sp)
; ZVFHMIN32-NEXT:    flh fa5, 130(sp)
; ZVFHMIN32-NEXT:    flh fa4, 386(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 1(sp)
; ZVFHMIN32-NEXT:    flh fa5, 128(sp)
; ZVFHMIN32-NEXT:    flh fa4, 384(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 0(sp)
; ZVFHMIN32-NEXT:    flh fa5, 280(sp)
; ZVFHMIN32-NEXT:    flh fa4, 536(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 76(sp)
; ZVFHMIN32-NEXT:    flh fa5, 278(sp)
; ZVFHMIN32-NEXT:    flh fa4, 534(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 75(sp)
; ZVFHMIN32-NEXT:    flh fa5, 276(sp)
; ZVFHMIN32-NEXT:    flh fa4, 532(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 74(sp)
; ZVFHMIN32-NEXT:    flh fa5, 274(sp)
; ZVFHMIN32-NEXT:    flh fa4, 530(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 73(sp)
; ZVFHMIN32-NEXT:    flh fa5, 272(sp)
; ZVFHMIN32-NEXT:    flh fa4, 528(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 72(sp)
; ZVFHMIN32-NEXT:    flh fa5, 270(sp)
; ZVFHMIN32-NEXT:    flh fa4, 526(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 71(sp)
; ZVFHMIN32-NEXT:    flh fa5, 268(sp)
; ZVFHMIN32-NEXT:    flh fa4, 524(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 70(sp)
; ZVFHMIN32-NEXT:    flh fa5, 266(sp)
; ZVFHMIN32-NEXT:    flh fa4, 522(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 69(sp)
; ZVFHMIN32-NEXT:    flh fa5, 264(sp)
; ZVFHMIN32-NEXT:    flh fa4, 520(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 68(sp)
; ZVFHMIN32-NEXT:    flh fa5, 262(sp)
; ZVFHMIN32-NEXT:    flh fa4, 518(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 67(sp)
; ZVFHMIN32-NEXT:    flh fa5, 260(sp)
; ZVFHMIN32-NEXT:    flh fa4, 516(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 66(sp)
; ZVFHMIN32-NEXT:    flh fa5, 258(sp)
; ZVFHMIN32-NEXT:    flh fa4, 514(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 65(sp)
; ZVFHMIN32-NEXT:    flh fa5, 256(sp)
; ZVFHMIN32-NEXT:    flh fa4, 512(sp)
; ZVFHMIN32-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN32-NEXT:    sb a0, 64(sp)
; ZVFHMIN32-NEXT:    li a0, 128
; ZVFHMIN32-NEXT:    mv a1, sp
; ZVFHMIN32-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; ZVFHMIN32-NEXT:    vle8.v v8, (a1)
; ZVFHMIN32-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN32-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN32-NEXT:    addi sp, s0, -768
; ZVFHMIN32-NEXT:    lw ra, 764(sp) # 4-byte Folded Reload
; ZVFHMIN32-NEXT:    lw s0, 760(sp) # 4-byte Folded Reload
; ZVFHMIN32-NEXT:    addi sp, sp, 768
; ZVFHMIN32-NEXT:    ret
;
; ZVFHMIN64-LABEL: fcmp_oeq_vv_v128f16:
; ZVFHMIN64:       # %bb.0:
; ZVFHMIN64-NEXT:    addi sp, sp, -768
; ZVFHMIN64-NEXT:    .cfi_def_cfa_offset 768
; ZVFHMIN64-NEXT:    sd ra, 760(sp) # 8-byte Folded Spill
; ZVFHMIN64-NEXT:    sd s0, 752(sp) # 8-byte Folded Spill
; ZVFHMIN64-NEXT:    .cfi_offset ra, -8
; ZVFHMIN64-NEXT:    .cfi_offset s0, -16
; ZVFHMIN64-NEXT:    addi s0, sp, 768
; ZVFHMIN64-NEXT:    .cfi_def_cfa s0, 0
; ZVFHMIN64-NEXT:    andi sp, sp, -128
; ZVFHMIN64-NEXT:    addi a1, a0, 128
; ZVFHMIN64-NEXT:    li a2, 64
; ZVFHMIN64-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; ZVFHMIN64-NEXT:    vle16.v v24, (a1)
; ZVFHMIN64-NEXT:    vle16.v v0, (a0)
; ZVFHMIN64-NEXT:    addi a0, sp, 128
; ZVFHMIN64-NEXT:    vse16.v v8, (a0)
; ZVFHMIN64-NEXT:    addi a0, sp, 384
; ZVFHMIN64-NEXT:    vse16.v v0, (a0)
; ZVFHMIN64-NEXT:    addi a0, sp, 256
; ZVFHMIN64-NEXT:    vse16.v v16, (a0)
; ZVFHMIN64-NEXT:    addi a0, sp, 512
; ZVFHMIN64-NEXT:    vse16.v v24, (a0)
; ZVFHMIN64-NEXT:    flh fa5, 254(sp)
; ZVFHMIN64-NEXT:    flh fa4, 510(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 63(sp)
; ZVFHMIN64-NEXT:    flh fa5, 252(sp)
; ZVFHMIN64-NEXT:    flh fa4, 508(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 62(sp)
; ZVFHMIN64-NEXT:    flh fa5, 250(sp)
; ZVFHMIN64-NEXT:    flh fa4, 506(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 61(sp)
; ZVFHMIN64-NEXT:    flh fa5, 248(sp)
; ZVFHMIN64-NEXT:    flh fa4, 504(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 60(sp)
; ZVFHMIN64-NEXT:    flh fa5, 246(sp)
; ZVFHMIN64-NEXT:    flh fa4, 502(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 59(sp)
; ZVFHMIN64-NEXT:    flh fa5, 244(sp)
; ZVFHMIN64-NEXT:    flh fa4, 500(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 58(sp)
; ZVFHMIN64-NEXT:    flh fa5, 242(sp)
; ZVFHMIN64-NEXT:    flh fa4, 498(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 57(sp)
; ZVFHMIN64-NEXT:    flh fa5, 240(sp)
; ZVFHMIN64-NEXT:    flh fa4, 496(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 56(sp)
; ZVFHMIN64-NEXT:    flh fa5, 238(sp)
; ZVFHMIN64-NEXT:    flh fa4, 494(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 55(sp)
; ZVFHMIN64-NEXT:    flh fa5, 236(sp)
; ZVFHMIN64-NEXT:    flh fa4, 492(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 54(sp)
; ZVFHMIN64-NEXT:    flh fa5, 234(sp)
; ZVFHMIN64-NEXT:    flh fa4, 490(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 53(sp)
; ZVFHMIN64-NEXT:    flh fa5, 232(sp)
; ZVFHMIN64-NEXT:    flh fa4, 488(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 52(sp)
; ZVFHMIN64-NEXT:    flh fa5, 230(sp)
; ZVFHMIN64-NEXT:    flh fa4, 486(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 51(sp)
; ZVFHMIN64-NEXT:    flh fa5, 228(sp)
; ZVFHMIN64-NEXT:    flh fa4, 484(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 50(sp)
; ZVFHMIN64-NEXT:    flh fa5, 226(sp)
; ZVFHMIN64-NEXT:    flh fa4, 482(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 49(sp)
; ZVFHMIN64-NEXT:    flh fa5, 224(sp)
; ZVFHMIN64-NEXT:    flh fa4, 480(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 48(sp)
; ZVFHMIN64-NEXT:    flh fa5, 222(sp)
; ZVFHMIN64-NEXT:    flh fa4, 478(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 47(sp)
; ZVFHMIN64-NEXT:    flh fa5, 382(sp)
; ZVFHMIN64-NEXT:    flh fa4, 638(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 127(sp)
; ZVFHMIN64-NEXT:    flh fa5, 380(sp)
; ZVFHMIN64-NEXT:    flh fa4, 636(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 126(sp)
; ZVFHMIN64-NEXT:    flh fa5, 378(sp)
; ZVFHMIN64-NEXT:    flh fa4, 634(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 125(sp)
; ZVFHMIN64-NEXT:    flh fa5, 376(sp)
; ZVFHMIN64-NEXT:    flh fa4, 632(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 124(sp)
; ZVFHMIN64-NEXT:    flh fa5, 374(sp)
; ZVFHMIN64-NEXT:    flh fa4, 630(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 123(sp)
; ZVFHMIN64-NEXT:    flh fa5, 372(sp)
; ZVFHMIN64-NEXT:    flh fa4, 628(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 122(sp)
; ZVFHMIN64-NEXT:    flh fa5, 370(sp)
; ZVFHMIN64-NEXT:    flh fa4, 626(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 121(sp)
; ZVFHMIN64-NEXT:    flh fa5, 368(sp)
; ZVFHMIN64-NEXT:    flh fa4, 624(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 120(sp)
; ZVFHMIN64-NEXT:    flh fa5, 366(sp)
; ZVFHMIN64-NEXT:    flh fa4, 622(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 119(sp)
; ZVFHMIN64-NEXT:    flh fa5, 364(sp)
; ZVFHMIN64-NEXT:    flh fa4, 620(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 118(sp)
; ZVFHMIN64-NEXT:    flh fa5, 362(sp)
; ZVFHMIN64-NEXT:    flh fa4, 618(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 117(sp)
; ZVFHMIN64-NEXT:    flh fa5, 360(sp)
; ZVFHMIN64-NEXT:    flh fa4, 616(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 116(sp)
; ZVFHMIN64-NEXT:    flh fa5, 358(sp)
; ZVFHMIN64-NEXT:    flh fa4, 614(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 115(sp)
; ZVFHMIN64-NEXT:    flh fa5, 356(sp)
; ZVFHMIN64-NEXT:    flh fa4, 612(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 114(sp)
; ZVFHMIN64-NEXT:    flh fa5, 354(sp)
; ZVFHMIN64-NEXT:    flh fa4, 610(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 113(sp)
; ZVFHMIN64-NEXT:    flh fa5, 352(sp)
; ZVFHMIN64-NEXT:    flh fa4, 608(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 112(sp)
; ZVFHMIN64-NEXT:    flh fa5, 350(sp)
; ZVFHMIN64-NEXT:    flh fa4, 606(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 111(sp)
; ZVFHMIN64-NEXT:    flh fa5, 220(sp)
; ZVFHMIN64-NEXT:    flh fa4, 476(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 46(sp)
; ZVFHMIN64-NEXT:    flh fa5, 218(sp)
; ZVFHMIN64-NEXT:    flh fa4, 474(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 45(sp)
; ZVFHMIN64-NEXT:    flh fa5, 216(sp)
; ZVFHMIN64-NEXT:    flh fa4, 472(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 44(sp)
; ZVFHMIN64-NEXT:    flh fa5, 214(sp)
; ZVFHMIN64-NEXT:    flh fa4, 470(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 43(sp)
; ZVFHMIN64-NEXT:    flh fa5, 212(sp)
; ZVFHMIN64-NEXT:    flh fa4, 468(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 42(sp)
; ZVFHMIN64-NEXT:    flh fa5, 210(sp)
; ZVFHMIN64-NEXT:    flh fa4, 466(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 41(sp)
; ZVFHMIN64-NEXT:    flh fa5, 208(sp)
; ZVFHMIN64-NEXT:    flh fa4, 464(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 40(sp)
; ZVFHMIN64-NEXT:    flh fa5, 206(sp)
; ZVFHMIN64-NEXT:    flh fa4, 462(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 39(sp)
; ZVFHMIN64-NEXT:    flh fa5, 204(sp)
; ZVFHMIN64-NEXT:    flh fa4, 460(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 38(sp)
; ZVFHMIN64-NEXT:    flh fa5, 202(sp)
; ZVFHMIN64-NEXT:    flh fa4, 458(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 37(sp)
; ZVFHMIN64-NEXT:    flh fa5, 200(sp)
; ZVFHMIN64-NEXT:    flh fa4, 456(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 36(sp)
; ZVFHMIN64-NEXT:    flh fa5, 198(sp)
; ZVFHMIN64-NEXT:    flh fa4, 454(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 35(sp)
; ZVFHMIN64-NEXT:    flh fa5, 196(sp)
; ZVFHMIN64-NEXT:    flh fa4, 452(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 34(sp)
; ZVFHMIN64-NEXT:    flh fa5, 194(sp)
; ZVFHMIN64-NEXT:    flh fa4, 450(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 33(sp)
; ZVFHMIN64-NEXT:    flh fa5, 192(sp)
; ZVFHMIN64-NEXT:    flh fa4, 448(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 32(sp)
; ZVFHMIN64-NEXT:    flh fa5, 190(sp)
; ZVFHMIN64-NEXT:    flh fa4, 446(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 31(sp)
; ZVFHMIN64-NEXT:    flh fa5, 188(sp)
; ZVFHMIN64-NEXT:    flh fa4, 444(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 30(sp)
; ZVFHMIN64-NEXT:    flh fa5, 348(sp)
; ZVFHMIN64-NEXT:    flh fa4, 604(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 110(sp)
; ZVFHMIN64-NEXT:    flh fa5, 346(sp)
; ZVFHMIN64-NEXT:    flh fa4, 602(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 109(sp)
; ZVFHMIN64-NEXT:    flh fa5, 344(sp)
; ZVFHMIN64-NEXT:    flh fa4, 600(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 108(sp)
; ZVFHMIN64-NEXT:    flh fa5, 342(sp)
; ZVFHMIN64-NEXT:    flh fa4, 598(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 107(sp)
; ZVFHMIN64-NEXT:    flh fa5, 340(sp)
; ZVFHMIN64-NEXT:    flh fa4, 596(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 106(sp)
; ZVFHMIN64-NEXT:    flh fa5, 338(sp)
; ZVFHMIN64-NEXT:    flh fa4, 594(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 105(sp)
; ZVFHMIN64-NEXT:    flh fa5, 336(sp)
; ZVFHMIN64-NEXT:    flh fa4, 592(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 104(sp)
; ZVFHMIN64-NEXT:    flh fa5, 334(sp)
; ZVFHMIN64-NEXT:    flh fa4, 590(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 103(sp)
; ZVFHMIN64-NEXT:    flh fa5, 332(sp)
; ZVFHMIN64-NEXT:    flh fa4, 588(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 102(sp)
; ZVFHMIN64-NEXT:    flh fa5, 330(sp)
; ZVFHMIN64-NEXT:    flh fa4, 586(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 101(sp)
; ZVFHMIN64-NEXT:    flh fa5, 328(sp)
; ZVFHMIN64-NEXT:    flh fa4, 584(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 100(sp)
; ZVFHMIN64-NEXT:    flh fa5, 326(sp)
; ZVFHMIN64-NEXT:    flh fa4, 582(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 99(sp)
; ZVFHMIN64-NEXT:    flh fa5, 324(sp)
; ZVFHMIN64-NEXT:    flh fa4, 580(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 98(sp)
; ZVFHMIN64-NEXT:    flh fa5, 322(sp)
; ZVFHMIN64-NEXT:    flh fa4, 578(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 97(sp)
; ZVFHMIN64-NEXT:    flh fa5, 320(sp)
; ZVFHMIN64-NEXT:    flh fa4, 576(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 96(sp)
; ZVFHMIN64-NEXT:    flh fa5, 318(sp)
; ZVFHMIN64-NEXT:    flh fa4, 574(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 95(sp)
; ZVFHMIN64-NEXT:    flh fa5, 316(sp)
; ZVFHMIN64-NEXT:    flh fa4, 572(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 94(sp)
; ZVFHMIN64-NEXT:    flh fa5, 186(sp)
; ZVFHMIN64-NEXT:    flh fa4, 442(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 29(sp)
; ZVFHMIN64-NEXT:    flh fa5, 184(sp)
; ZVFHMIN64-NEXT:    flh fa4, 440(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 28(sp)
; ZVFHMIN64-NEXT:    flh fa5, 182(sp)
; ZVFHMIN64-NEXT:    flh fa4, 438(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 27(sp)
; ZVFHMIN64-NEXT:    flh fa5, 180(sp)
; ZVFHMIN64-NEXT:    flh fa4, 436(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 26(sp)
; ZVFHMIN64-NEXT:    flh fa5, 178(sp)
; ZVFHMIN64-NEXT:    flh fa4, 434(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 25(sp)
; ZVFHMIN64-NEXT:    flh fa5, 176(sp)
; ZVFHMIN64-NEXT:    flh fa4, 432(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 24(sp)
; ZVFHMIN64-NEXT:    flh fa5, 174(sp)
; ZVFHMIN64-NEXT:    flh fa4, 430(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 23(sp)
; ZVFHMIN64-NEXT:    flh fa5, 172(sp)
; ZVFHMIN64-NEXT:    flh fa4, 428(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 22(sp)
; ZVFHMIN64-NEXT:    flh fa5, 170(sp)
; ZVFHMIN64-NEXT:    flh fa4, 426(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 21(sp)
; ZVFHMIN64-NEXT:    flh fa5, 168(sp)
; ZVFHMIN64-NEXT:    flh fa4, 424(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 20(sp)
; ZVFHMIN64-NEXT:    flh fa5, 166(sp)
; ZVFHMIN64-NEXT:    flh fa4, 422(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 19(sp)
; ZVFHMIN64-NEXT:    flh fa5, 164(sp)
; ZVFHMIN64-NEXT:    flh fa4, 420(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 18(sp)
; ZVFHMIN64-NEXT:    flh fa5, 162(sp)
; ZVFHMIN64-NEXT:    flh fa4, 418(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 17(sp)
; ZVFHMIN64-NEXT:    flh fa5, 160(sp)
; ZVFHMIN64-NEXT:    flh fa4, 416(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 16(sp)
; ZVFHMIN64-NEXT:    flh fa5, 158(sp)
; ZVFHMIN64-NEXT:    flh fa4, 414(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 15(sp)
; ZVFHMIN64-NEXT:    flh fa5, 156(sp)
; ZVFHMIN64-NEXT:    flh fa4, 412(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 14(sp)
; ZVFHMIN64-NEXT:    flh fa5, 154(sp)
; ZVFHMIN64-NEXT:    flh fa4, 410(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 13(sp)
; ZVFHMIN64-NEXT:    flh fa5, 314(sp)
; ZVFHMIN64-NEXT:    flh fa4, 570(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 93(sp)
; ZVFHMIN64-NEXT:    flh fa5, 312(sp)
; ZVFHMIN64-NEXT:    flh fa4, 568(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 92(sp)
; ZVFHMIN64-NEXT:    flh fa5, 310(sp)
; ZVFHMIN64-NEXT:    flh fa4, 566(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 91(sp)
; ZVFHMIN64-NEXT:    flh fa5, 308(sp)
; ZVFHMIN64-NEXT:    flh fa4, 564(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 90(sp)
; ZVFHMIN64-NEXT:    flh fa5, 306(sp)
; ZVFHMIN64-NEXT:    flh fa4, 562(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 89(sp)
; ZVFHMIN64-NEXT:    flh fa5, 304(sp)
; ZVFHMIN64-NEXT:    flh fa4, 560(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 88(sp)
; ZVFHMIN64-NEXT:    flh fa5, 302(sp)
; ZVFHMIN64-NEXT:    flh fa4, 558(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 87(sp)
; ZVFHMIN64-NEXT:    flh fa5, 300(sp)
; ZVFHMIN64-NEXT:    flh fa4, 556(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 86(sp)
; ZVFHMIN64-NEXT:    flh fa5, 298(sp)
; ZVFHMIN64-NEXT:    flh fa4, 554(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 85(sp)
; ZVFHMIN64-NEXT:    flh fa5, 296(sp)
; ZVFHMIN64-NEXT:    flh fa4, 552(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 84(sp)
; ZVFHMIN64-NEXT:    flh fa5, 294(sp)
; ZVFHMIN64-NEXT:    flh fa4, 550(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 83(sp)
; ZVFHMIN64-NEXT:    flh fa5, 292(sp)
; ZVFHMIN64-NEXT:    flh fa4, 548(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 82(sp)
; ZVFHMIN64-NEXT:    flh fa5, 290(sp)
; ZVFHMIN64-NEXT:    flh fa4, 546(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 81(sp)
; ZVFHMIN64-NEXT:    flh fa5, 288(sp)
; ZVFHMIN64-NEXT:    flh fa4, 544(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 80(sp)
; ZVFHMIN64-NEXT:    flh fa5, 286(sp)
; ZVFHMIN64-NEXT:    flh fa4, 542(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 79(sp)
; ZVFHMIN64-NEXT:    flh fa5, 284(sp)
; ZVFHMIN64-NEXT:    flh fa4, 540(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 78(sp)
; ZVFHMIN64-NEXT:    flh fa5, 282(sp)
; ZVFHMIN64-NEXT:    flh fa4, 538(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 77(sp)
; ZVFHMIN64-NEXT:    flh fa5, 152(sp)
; ZVFHMIN64-NEXT:    flh fa4, 408(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 12(sp)
; ZVFHMIN64-NEXT:    flh fa5, 150(sp)
; ZVFHMIN64-NEXT:    flh fa4, 406(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 11(sp)
; ZVFHMIN64-NEXT:    flh fa5, 148(sp)
; ZVFHMIN64-NEXT:    flh fa4, 404(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 10(sp)
; ZVFHMIN64-NEXT:    flh fa5, 146(sp)
; ZVFHMIN64-NEXT:    flh fa4, 402(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 9(sp)
; ZVFHMIN64-NEXT:    flh fa5, 144(sp)
; ZVFHMIN64-NEXT:    flh fa4, 400(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 8(sp)
; ZVFHMIN64-NEXT:    flh fa5, 142(sp)
; ZVFHMIN64-NEXT:    flh fa4, 398(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 7(sp)
; ZVFHMIN64-NEXT:    flh fa5, 140(sp)
; ZVFHMIN64-NEXT:    flh fa4, 396(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 6(sp)
; ZVFHMIN64-NEXT:    flh fa5, 138(sp)
; ZVFHMIN64-NEXT:    flh fa4, 394(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 5(sp)
; ZVFHMIN64-NEXT:    flh fa5, 136(sp)
; ZVFHMIN64-NEXT:    flh fa4, 392(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 4(sp)
; ZVFHMIN64-NEXT:    flh fa5, 134(sp)
; ZVFHMIN64-NEXT:    flh fa4, 390(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 3(sp)
; ZVFHMIN64-NEXT:    flh fa5, 132(sp)
; ZVFHMIN64-NEXT:    flh fa4, 388(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 2(sp)
; ZVFHMIN64-NEXT:    flh fa5, 130(sp)
; ZVFHMIN64-NEXT:    flh fa4, 386(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 1(sp)
; ZVFHMIN64-NEXT:    flh fa5, 128(sp)
; ZVFHMIN64-NEXT:    flh fa4, 384(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 0(sp)
; ZVFHMIN64-NEXT:    flh fa5, 280(sp)
; ZVFHMIN64-NEXT:    flh fa4, 536(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 76(sp)
; ZVFHMIN64-NEXT:    flh fa5, 278(sp)
; ZVFHMIN64-NEXT:    flh fa4, 534(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 75(sp)
; ZVFHMIN64-NEXT:    flh fa5, 276(sp)
; ZVFHMIN64-NEXT:    flh fa4, 532(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 74(sp)
; ZVFHMIN64-NEXT:    flh fa5, 274(sp)
; ZVFHMIN64-NEXT:    flh fa4, 530(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 73(sp)
; ZVFHMIN64-NEXT:    flh fa5, 272(sp)
; ZVFHMIN64-NEXT:    flh fa4, 528(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 72(sp)
; ZVFHMIN64-NEXT:    flh fa5, 270(sp)
; ZVFHMIN64-NEXT:    flh fa4, 526(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 71(sp)
; ZVFHMIN64-NEXT:    flh fa5, 268(sp)
; ZVFHMIN64-NEXT:    flh fa4, 524(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 70(sp)
; ZVFHMIN64-NEXT:    flh fa5, 266(sp)
; ZVFHMIN64-NEXT:    flh fa4, 522(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 69(sp)
; ZVFHMIN64-NEXT:    flh fa5, 264(sp)
; ZVFHMIN64-NEXT:    flh fa4, 520(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 68(sp)
; ZVFHMIN64-NEXT:    flh fa5, 262(sp)
; ZVFHMIN64-NEXT:    flh fa4, 518(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 67(sp)
; ZVFHMIN64-NEXT:    flh fa5, 260(sp)
; ZVFHMIN64-NEXT:    flh fa4, 516(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 66(sp)
; ZVFHMIN64-NEXT:    flh fa5, 258(sp)
; ZVFHMIN64-NEXT:    flh fa4, 514(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 65(sp)
; ZVFHMIN64-NEXT:    flh fa5, 256(sp)
; ZVFHMIN64-NEXT:    flh fa4, 512(sp)
; ZVFHMIN64-NEXT:    feq.h a0, fa5, fa4
; ZVFHMIN64-NEXT:    sb a0, 64(sp)
; ZVFHMIN64-NEXT:    li a0, 128
; ZVFHMIN64-NEXT:    mv a1, sp
; ZVFHMIN64-NEXT:    vsetvli zero, a0, e8, m8, ta, ma
; ZVFHMIN64-NEXT:    vle8.v v8, (a1)
; ZVFHMIN64-NEXT:    vand.vi v8, v8, 1
; ZVFHMIN64-NEXT:    vmsne.vi v0, v8, 0
; ZVFHMIN64-NEXT:    addi sp, s0, -768
; ZVFHMIN64-NEXT:    ld ra, 760(sp) # 8-byte Folded Reload
; ZVFHMIN64-NEXT:    ld s0, 752(sp) # 8-byte Folded Reload
; ZVFHMIN64-NEXT:    addi sp, sp, 768
; ZVFHMIN64-NEXT:    ret
  %v = call <128 x i1> @llvm.vp.fcmp.v128f16(<128 x half> %va, <128 x half> %vb, metadata !"oeq", <128 x i1> %m, i32 %evl)
  ret <128 x i1> %v
}

declare <7 x i1> @llvm.vp.fcmp.v7f64(<7 x double>, <7 x double>, metadata, <7 x i1>, i32)

define <7 x i1> @fcmp_oeq_vv_v7f64(<7 x double> %va, <7 x double> %vb, <7 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v7f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <7 x i1> @llvm.vp.fcmp.v7f64(<7 x double> %va, <7 x double> %vb, metadata !"oeq", <7 x i1> %m, i32 %evl)
  ret <7 x i1> %v
}

declare <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double>, <8 x double>, metadata, <8 x i1>, i32)

define <8 x i1> @fcmp_oeq_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oeq_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"oeq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ogt_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ogt_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ogt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_oge_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oge_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"oge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_olt_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_olt_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"olt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ole_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ole_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ole", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_one_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_one_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"one", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vv v16, v12, v12, v0.t
; CHECK-NEXT:    vmfeq.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0, v0.t
; CHECK-NEXT:    vmfeq.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v12, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ord_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ord_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfeq.vf v16, v12, fa0, v0.t
; CHECK-NEXT:    vmfeq.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmand.mm v0, v16, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ord", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmflt.vv v17, v12, v8, v0.t
; CHECK-NEXT:    vmnor.mm v0, v17, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmfgt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ueq_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ueq_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmflt.vf v13, v8, fa0, v0.t
; CHECK-NEXT:    vmnor.mm v0, v13, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ueq", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ugt_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ugt_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ugt", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uge_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uge_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"uge", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfge.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ult_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ult_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfle.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ult", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vv v16, v12, v8, v0.t
; CHECK-NEXT:    vmnot.m v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfgt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_ule_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_ule_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmflt.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"ule", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v8, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_une_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_une_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v12, v8, fa0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"une", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vv_v8f64(<8 x double> %va, <8 x double> %vb, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vv_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vv v16, v12, v12, v0.t
; CHECK-NEXT:    vmfne.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v16, v12, fa0, v0.t
; CHECK-NEXT:    vmfne.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v12, v16
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

define <8 x i1> @fcmp_uno_vf_swap_v8f64(<8 x double> %va, double %b, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_uno_vf_swap_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.v.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmfne.vf v16, v12, fa0, v0.t
; CHECK-NEXT:    vmfne.vv v12, v8, v8, v0.t
; CHECK-NEXT:    vmor.mm v0, v16, v12
; CHECK-NEXT:    ret
  %elt.head = insertelement <8 x double> poison, double %b, i32 0
  %vb = shufflevector <8 x double> %elt.head, <8 x double> poison, <8 x i32> zeroinitializer
  %v = call <8 x i1> @llvm.vp.fcmp.v8f64(<8 x double> %vb, <8 x double> %va, metadata !"uno", <8 x i1> %m, i32 %evl)
  ret <8 x i1> %v
}

declare <32 x i1> @llvm.vp.fcmp.v32f64(<32 x double>, <32 x double>, metadata, <32 x i1>, i32)

define <32 x i1> @fcmp_oeq_vv_v32f64(<32 x double> %va, <32 x double> %vb, <32 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: fcmp_oeq_vv_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v24, (a1)
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v24, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    vle64.v v24, (a0)
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    li a1, 16
; CHECK-NEXT:    vsetivli zero, 2, e8, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vi v6, v0, 2
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    bltu a2, a1, .LBB87_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:  .LBB87_2:
; CHECK-NEXT:    addi a1, sp, 16
; CHECK-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v7, v8, v24, v0.t
; CHECK-NEXT:    addi a0, a2, -16
; CHECK-NEXT:    sltu a1, a2, a0
; CHECK-NEXT:    addi a1, a1, -1
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    vmv1r.v v0, v6
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; CHECK-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; CHECK-NEXT:    vmfeq.vv v8, v16, v24, v0.t
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vslideup.vi v7, v8, 2
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = call <32 x i1> @llvm.vp.fcmp.v32f64(<32 x double> %va, <32 x double> %vb, metadata !"oeq", <32 x i1> %m, i32 %evl)
  ret <32 x i1> %v
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; ZVFH32: {{.*}}
; ZVFH64: {{.*}}
