; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+m -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=NO-PREFER-W-INST %s
; RUN: llc -mtriple=riscv64 -mattr=+m -riscv-disable-strip-w-suffix -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=NO-STRIP %s
; RUN: llc -mtriple=riscv64 -mattr=+m,+prefer-w-inst -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=PREFER-W-INST %s

define i32 @addiw(i32 %a) {
; NO-PREFER-W-INST-LABEL: addiw:
; NO-PREFER-W-INST:       # %bb.0:
; NO-PREFER-W-INST-NEXT:    lui a1, 1
; NO-PREFER-W-INST-NEXT:    addi a1, a1, -1
; NO-PREFER-W-INST-NEXT:    addw a0, a0, a1
; NO-PREFER-W-INST-NEXT:    ret
;
; NO-STRIP-LABEL: addiw:
; NO-STRIP:       # %bb.0:
; NO-STRIP-NEXT:    lui a1, 1
; NO-STRIP-NEXT:    addiw a1, a1, -1
; NO-STRIP-NEXT:    addw a0, a0, a1
; NO-STRIP-NEXT:    ret
;
; PREFER-W-INST-LABEL: addiw:
; PREFER-W-INST:       # %bb.0:
; PREFER-W-INST-NEXT:    lui a1, 1
; PREFER-W-INST-NEXT:    addiw a1, a1, -1
; PREFER-W-INST-NEXT:    addw a0, a0, a1
; PREFER-W-INST-NEXT:    ret
  %ret = add i32 %a, 4095
  ret i32 %ret
}

define i32 @addw(i32 %a, i32 %b) {
; NO-PREFER-W-INST-LABEL: addw:
; NO-PREFER-W-INST:       # %bb.0:
; NO-PREFER-W-INST-NEXT:    add a0, a0, a1
; NO-PREFER-W-INST-NEXT:    addiw a0, a0, 1024
; NO-PREFER-W-INST-NEXT:    ret
;
; NO-STRIP-LABEL: addw:
; NO-STRIP:       # %bb.0:
; NO-STRIP-NEXT:    addw a0, a0, a1
; NO-STRIP-NEXT:    addiw a0, a0, 1024
; NO-STRIP-NEXT:    ret
;
; PREFER-W-INST-LABEL: addw:
; PREFER-W-INST:       # %bb.0:
; PREFER-W-INST-NEXT:    addw a0, a0, a1
; PREFER-W-INST-NEXT:    addiw a0, a0, 1024
; PREFER-W-INST-NEXT:    ret
  %add = add i32 %a, %b
  %ret = add i32 %add, 1024
  ret i32 %ret
}

define i32 @mulw(i32 %a, i32 %b) {
; NO-PREFER-W-INST-LABEL: mulw:
; NO-PREFER-W-INST:       # %bb.0:
; NO-PREFER-W-INST-NEXT:    mul a1, a0, a1
; NO-PREFER-W-INST-NEXT:    mul a0, a0, a1
; NO-PREFER-W-INST-NEXT:    addiw a0, a0, 1024
; NO-PREFER-W-INST-NEXT:    ret
;
; NO-STRIP-LABEL: mulw:
; NO-STRIP:       # %bb.0:
; NO-STRIP-NEXT:    mulw a1, a0, a1
; NO-STRIP-NEXT:    mulw a0, a0, a1
; NO-STRIP-NEXT:    addiw a0, a0, 1024
; NO-STRIP-NEXT:    ret
;
; PREFER-W-INST-LABEL: mulw:
; PREFER-W-INST:       # %bb.0:
; PREFER-W-INST-NEXT:    mulw a1, a0, a1
; PREFER-W-INST-NEXT:    mulw a0, a0, a1
; PREFER-W-INST-NEXT:    addiw a0, a0, 1024
; PREFER-W-INST-NEXT:    ret
  %mul1 = mul i32 %a, %b
  %mul = mul i32 %a, %mul1
  %ret = add i32 %mul, 1024
  ret i32 %ret
}

define i32 @slliw(i32 %a) {
; NO-PREFER-W-INST-LABEL: slliw:
; NO-PREFER-W-INST:       # %bb.0:
; NO-PREFER-W-INST-NEXT:    slli a0, a0, 1
; NO-PREFER-W-INST-NEXT:    addiw a0, a0, 1024
; NO-PREFER-W-INST-NEXT:    ret
;
; NO-STRIP-LABEL: slliw:
; NO-STRIP:       # %bb.0:
; NO-STRIP-NEXT:    slliw a0, a0, 1
; NO-STRIP-NEXT:    addiw a0, a0, 1024
; NO-STRIP-NEXT:    ret
;
; PREFER-W-INST-LABEL: slliw:
; PREFER-W-INST:       # %bb.0:
; PREFER-W-INST-NEXT:    slliw a0, a0, 1
; PREFER-W-INST-NEXT:    addiw a0, a0, 1024
; PREFER-W-INST-NEXT:    ret
  %shl = shl i32 %a, 1
  %ret = add i32 %shl, 1024
  ret i32 %ret
}
