; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -relocation-model=static < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 -relocation-model=pic < %s | FileCheck %s --check-prefix=RV64

@var = external dso_local global i32, align 4
@a = external global [2 x [2 x i32]], align 4

define dso_local void @test() {
; RV32-LABEL: test:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    #APP
; RV32-NEXT:    # var a+12 test
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    #APP
; RV32-NEXT:    # var a+12 test
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    ret
;
; RV64-LABEL: test:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    #APP
; RV64-NEXT:    # var a+12 .Ltest$local
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    #APP
; RV64-NEXT:    # var a+12 .Ltest$local
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    ret
entry:
  call void asm sideeffect "// $0 $1 $2", "s,s,s,~{dirflag},~{fpsr},~{flags}"(ptr @var, ptr getelementptr inbounds ([2 x [2 x i32]], ptr @a, i64 0, i64 1, i64 1), ptr @test)

  ;; Implement "S" as an alias for "s".
  call void asm sideeffect "// $0 $1 $2", "S,S,S,~{dirflag},~{fpsr},~{flags}"(ptr @var, ptr getelementptr inbounds ([2 x [2 x i32]], ptr @a, i64 0, i64 1, i64 1), ptr @test)
  ret void
}

; Function Attrs: nofree nosync nounwind readnone
define dso_local ptr @test_label() {
; RV32-LABEL: test_label:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:  .Ltmp0: # Block address taken
; RV32-NEXT:  # %bb.1: # %L1
; RV32-NEXT:    #APP
; RV32-NEXT:    # .Ltmp0
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    #APP
; RV32-NEXT:    lui a0, %hi(.Ltmp0)
; RV32-NEXT:    addi a0, a0, %lo(.Ltmp0)
; RV32-NEXT:    #NO_APP
; RV32-NEXT:    ret
;
; RV64-LABEL: test_label:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:  .Ltmp0: # Block address taken
; RV64-NEXT:  # %bb.1: # %L1
; RV64-NEXT:    #APP
; RV64-NEXT:    # .Ltmp0
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    #APP
; RV64-NEXT:    lui a0, %hi(.Ltmp0)
; RV64-NEXT:    addi a0, a0, %lo(.Ltmp0)
; RV64-NEXT:    #NO_APP
; RV64-NEXT:    ret
entry:
  br label %L1

L1:
  call void asm sideeffect "// $0", "s,~{dirflag},~{fpsr},~{flags}"(ptr blockaddress(@test_label, %L1))
  %ret = tail call ptr asm "lui $0, %hi($1)\0Aaddi $0, $0, %lo($1)", "=r,S"(ptr blockaddress(@test_label, %L1))
  ret ptr %ret
}
