; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32d | FileCheck %s --check-prefix=CHECK32D
; RUN: llc -mtriple=riscv64 -mattr=+d -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64d | FileCheck %s --check-prefix=CHECK64D
; RUN: llc -mtriple=riscv32 -mattr=+zdinx -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32 | FileCheck --check-prefix=CHECKRV32ZDINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zdinx -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64 | FileCheck --check-prefix=CHECKRV64ZDINX %s

define double @double_imm() nounwind {
; CHECK32D-LABEL: double_imm:
; CHECK32D:       # %bb.0:
; CHECK32D-NEXT:    lui a0, %hi(.LCPI0_0)
; CHECK32D-NEXT:    fld fa0, %lo(.LCPI0_0)(a0)
; CHECK32D-NEXT:    ret
;
; CHECK64D-LABEL: double_imm:
; CHECK64D:       # %bb.0:
; CHECK64D-NEXT:    lui a0, %hi(.LCPI0_0)
; CHECK64D-NEXT:    fld fa0, %lo(.LCPI0_0)(a0)
; CHECK64D-NEXT:    ret
;
; CHECKRV32ZDINX-LABEL: double_imm:
; CHECKRV32ZDINX:       # %bb.0:
; CHECKRV32ZDINX-NEXT:    lui a0, 345155
; CHECKRV32ZDINX-NEXT:    addi a0, a0, -744
; CHECKRV32ZDINX-NEXT:    lui a1, 262290
; CHECKRV32ZDINX-NEXT:    addi a1, a1, 507
; CHECKRV32ZDINX-NEXT:    ret
;
; CHECKRV64ZDINX-LABEL: double_imm:
; CHECKRV64ZDINX:       # %bb.0:
; CHECKRV64ZDINX-NEXT:    lui a0, %hi(.LCPI0_0)
; CHECKRV64ZDINX-NEXT:    ld a0, %lo(.LCPI0_0)(a0)
; CHECKRV64ZDINX-NEXT:    ret
  ret double 3.1415926535897931159979634685441851615905761718750
}

define double @double_imm_op(double %a) nounwind {
; CHECK32D-LABEL: double_imm_op:
; CHECK32D:       # %bb.0:
; CHECK32D-NEXT:    lui a0, %hi(.LCPI1_0)
; CHECK32D-NEXT:    fld fa5, %lo(.LCPI1_0)(a0)
; CHECK32D-NEXT:    fadd.d fa0, fa0, fa5
; CHECK32D-NEXT:    ret
;
; CHECK64D-LABEL: double_imm_op:
; CHECK64D:       # %bb.0:
; CHECK64D-NEXT:    lui a0, %hi(.LCPI1_0)
; CHECK64D-NEXT:    fld fa5, %lo(.LCPI1_0)(a0)
; CHECK64D-NEXT:    fadd.d fa0, fa0, fa5
; CHECK64D-NEXT:    ret
;
; CHECKRV32ZDINX-LABEL: double_imm_op:
; CHECKRV32ZDINX:       # %bb.0:
; CHECKRV32ZDINX-NEXT:    lui a2, %hi(.LCPI1_0)
; CHECKRV32ZDINX-NEXT:    lw a3, %lo(.LCPI1_0+4)(a2)
; CHECKRV32ZDINX-NEXT:    lw a2, %lo(.LCPI1_0)(a2)
; CHECKRV32ZDINX-NEXT:    fadd.d a0, a0, a2
; CHECKRV32ZDINX-NEXT:    ret
;
; CHECKRV64ZDINX-LABEL: double_imm_op:
; CHECKRV64ZDINX:       # %bb.0:
; CHECKRV64ZDINX-NEXT:    lui a1, %hi(.LCPI1_0)
; CHECKRV64ZDINX-NEXT:    ld a1, %lo(.LCPI1_0)(a1)
; CHECKRV64ZDINX-NEXT:    fadd.d a0, a0, a1
; CHECKRV64ZDINX-NEXT:    ret
  %1 = fadd double %a, 1.0
  ret double %1
}

define double @double_positive_zero(ptr %pd) nounwind {
; CHECK32D-LABEL: double_positive_zero:
; CHECK32D:       # %bb.0:
; CHECK32D-NEXT:    fcvt.d.w fa0, zero
; CHECK32D-NEXT:    ret
;
; CHECK64D-LABEL: double_positive_zero:
; CHECK64D:       # %bb.0:
; CHECK64D-NEXT:    fmv.d.x fa0, zero
; CHECK64D-NEXT:    ret
;
; CHECKRV32ZDINX-LABEL: double_positive_zero:
; CHECKRV32ZDINX:       # %bb.0:
; CHECKRV32ZDINX-NEXT:    li a0, 0
; CHECKRV32ZDINX-NEXT:    li a1, 0
; CHECKRV32ZDINX-NEXT:    ret
;
; CHECKRV64ZDINX-LABEL: double_positive_zero:
; CHECKRV64ZDINX:       # %bb.0:
; CHECKRV64ZDINX-NEXT:    li a0, 0
; CHECKRV64ZDINX-NEXT:    ret
  ret double 0.0
}

define double @double_negative_zero(ptr %pd) nounwind {
; CHECK32D-LABEL: double_negative_zero:
; CHECK32D:       # %bb.0:
; CHECK32D-NEXT:    fcvt.d.w fa5, zero
; CHECK32D-NEXT:    fneg.d fa0, fa5
; CHECK32D-NEXT:    ret
;
; CHECK64D-LABEL: double_negative_zero:
; CHECK64D:       # %bb.0:
; CHECK64D-NEXT:    fmv.d.x fa5, zero
; CHECK64D-NEXT:    fneg.d fa0, fa5
; CHECK64D-NEXT:    ret
;
; CHECKRV32ZDINX-LABEL: double_negative_zero:
; CHECKRV32ZDINX:       # %bb.0:
; CHECKRV32ZDINX-NEXT:    lui a1, 524288
; CHECKRV32ZDINX-NEXT:    li a0, 0
; CHECKRV32ZDINX-NEXT:    ret
;
; CHECKRV64ZDINX-LABEL: double_negative_zero:
; CHECKRV64ZDINX:       # %bb.0:
; CHECKRV64ZDINX-NEXT:    li a0, -1
; CHECKRV64ZDINX-NEXT:    slli a0, a0, 63
; CHECKRV64ZDINX-NEXT:    ret
  ret double -0.0
}
define dso_local double @negzero_sel(i16 noundef %a, double noundef %d) nounwind {
; CHECK32D-LABEL: negzero_sel:
; CHECK32D:       # %bb.0: # %entry
; CHECK32D-NEXT:    slli a0, a0, 16
; CHECK32D-NEXT:    fcvt.d.w fa5, zero
; CHECK32D-NEXT:    beqz a0, .LBB4_2
; CHECK32D-NEXT:  # %bb.1: # %entry
; CHECK32D-NEXT:    fneg.d fa0, fa5
; CHECK32D-NEXT:  .LBB4_2: # %entry
; CHECK32D-NEXT:    ret
;
; CHECK64D-LABEL: negzero_sel:
; CHECK64D:       # %bb.0: # %entry
; CHECK64D-NEXT:    slli a0, a0, 48
; CHECK64D-NEXT:    beqz a0, .LBB4_2
; CHECK64D-NEXT:  # %bb.1: # %entry
; CHECK64D-NEXT:    fmv.d.x fa5, zero
; CHECK64D-NEXT:    fneg.d fa0, fa5
; CHECK64D-NEXT:  .LBB4_2: # %entry
; CHECK64D-NEXT:    ret
;
; CHECKRV32ZDINX-LABEL: negzero_sel:
; CHECKRV32ZDINX:       # %bb.0: # %entry
; CHECKRV32ZDINX-NEXT:    slli a0, a0, 16
; CHECKRV32ZDINX-NEXT:    fcvt.d.w a4, zero
; CHECKRV32ZDINX-NEXT:    beqz a0, .LBB4_2
; CHECKRV32ZDINX-NEXT:  # %bb.1: # %entry
; CHECKRV32ZDINX-NEXT:    fneg.d a2, a4
; CHECKRV32ZDINX-NEXT:    j .LBB4_3
; CHECKRV32ZDINX-NEXT:  .LBB4_2:
; CHECKRV32ZDINX-NEXT:    mv a3, a2
; CHECKRV32ZDINX-NEXT:    mv a2, a1
; CHECKRV32ZDINX-NEXT:  .LBB4_3: # %entry
; CHECKRV32ZDINX-NEXT:    mv a0, a2
; CHECKRV32ZDINX-NEXT:    mv a1, a3
; CHECKRV32ZDINX-NEXT:    ret
;
; CHECKRV64ZDINX-LABEL: negzero_sel:
; CHECKRV64ZDINX:       # %bb.0: # %entry
; CHECKRV64ZDINX-NEXT:    slli a2, a0, 48
; CHECKRV64ZDINX-NEXT:    beqz a2, .LBB4_2
; CHECKRV64ZDINX-NEXT:  # %bb.1: # %entry
; CHECKRV64ZDINX-NEXT:    fneg.d a0, zero
; CHECKRV64ZDINX-NEXT:    ret
; CHECKRV64ZDINX-NEXT:  .LBB4_2:
; CHECKRV64ZDINX-NEXT:    mv a0, a1
; CHECKRV64ZDINX-NEXT:    ret
entry:
  %tobool.not = icmp eq i16 %a, 0
  %d. = select i1 %tobool.not, double %d, double -0.000000e+00
  ret double %d.
}
