; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

; Round towards minus infinity (fcvtms).

define i32 @testmswbf(bfloat %a) {
; CHECK-LABEL: testmswbf:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-NEXT:    lsl w9, w9, #16
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    frintm s0, s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    ubfx w10, w9, #16, #1
; CHECK-NEXT:    add w8, w9, w8
; CHECK-NEXT:    add w8, w10, w8
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    lsl w8, w8, #16
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call bfloat @llvm.floor.bf16(bfloat %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.bf16(bfloat %r)
  ret i32 %i
}

define i64 @testmsxbf(bfloat %a) {
; CHECK-LABEL: testmsxbf:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-NEXT:    lsl w9, w9, #16
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    frintm s0, s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    ubfx w10, w9, #16, #1
; CHECK-NEXT:    add w8, w9, w8
; CHECK-NEXT:    add w8, w10, w8
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    lsl w8, w8, #16
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call bfloat @llvm.floor.bf16(bfloat %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.bf16(bfloat %r)
  ret i64 %i
}

define i32 @testmswh(half %a) {
; CHECK-CVT-LABEL: testmswh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintm s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testmswh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtms w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.floor.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testmsxh(half %a) {
; CHECK-CVT-LABEL: testmsxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintm s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testmsxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtms x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.floor.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testmsws(float %a) {
; CHECK-LABEL: testmsws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtms w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @floorf(float %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testmsxs(float %a) {
; CHECK-LABEL: testmsxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtms x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @floorf(float %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testmswd(double %a) {
; CHECK-LABEL: testmswd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtms w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @floor(double %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testmsxd(double %a) {
; CHECK-LABEL: testmsxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtms x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @floor(double %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f64(double %r)
  ret i64 %i
}

; Round towards plus infinity (fcvtps).

define i32 @testpswbf(bfloat %a) {
; CHECK-LABEL: testpswbf:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-NEXT:    lsl w9, w9, #16
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    frintp s0, s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    ubfx w10, w9, #16, #1
; CHECK-NEXT:    add w8, w9, w8
; CHECK-NEXT:    add w8, w10, w8
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    lsl w8, w8, #16
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call bfloat @llvm.ceil.bf16(bfloat %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.bf16(bfloat %r)
  ret i32 %i
}

define i64 @testpsxbf(bfloat %a) {
; CHECK-LABEL: testpsxbf:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    mov w8, #32767 // =0x7fff
; CHECK-NEXT:    lsl w9, w9, #16
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    frintp s0, s0
; CHECK-NEXT:    fmov w9, s0
; CHECK-NEXT:    ubfx w10, w9, #16, #1
; CHECK-NEXT:    add w8, w9, w8
; CHECK-NEXT:    add w8, w10, w8
; CHECK-NEXT:    lsr w8, w8, #16
; CHECK-NEXT:    lsl w8, w8, #16
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call bfloat @llvm.ceil.bf16(bfloat %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.bf16(bfloat %r)
  ret i64 %i
}

define i32 @testpswh(half %a) {
; CHECK-CVT-LABEL: testpswh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintp s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testpswh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtps w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.ceil.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testpsxh(half %a) {
; CHECK-CVT-LABEL: testpsxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintp s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testpsxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtps x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.ceil.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testpsws(float %a) {
; CHECK-LABEL: testpsws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtps w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @ceilf(float %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testpsxs(float %a) {
; CHECK-LABEL: testpsxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtps x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @ceilf(float %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testpswd(double %a) {
; CHECK-LABEL: testpswd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtps w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @ceil(double %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testpsxd(double %a) {
; CHECK-LABEL: testpsxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtps x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @ceil(double %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f64(double %r)
  ret i64 %i
}

; Round towards zero (fcvtzs).

define i32 @testzswh(half %a) {
; CHECK-CVT-LABEL: testzswh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintz s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testzswh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzs w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.trunc.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testzsxh(half %a) {
; CHECK-CVT-LABEL: testzsxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintz s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testzsxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzs x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.trunc.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testzsws(float %a) {
; CHECK-LABEL: testzsws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @truncf(float %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testzsxs(float %a) {
; CHECK-LABEL: testzsxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @truncf(float %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testzswd(double %a) {
; CHECK-LABEL: testzswd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @trunc(double %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testzsxd(double %a) {
; CHECK-LABEL: testzsxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzs x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @trunc(double %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f64(double %r)
  ret i64 %i
}

; Round to nearest, ties away from zero (fcvtas).

define i32 @testaswh(half %a) {
; CHECK-CVT-LABEL: testaswh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frinta s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testaswh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtas w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.round.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testasxh(half %a) {
; CHECK-CVT-LABEL: testasxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frinta s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzs x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testasxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtas x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.round.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testasws(float %a) {
; CHECK-LABEL: testasws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtas w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @roundf(float %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testasxs(float %a) {
; CHECK-LABEL: testasxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtas x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @roundf(float %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testaswd(double %a) {
; CHECK-LABEL: testaswd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtas w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @round(double %a) nounwind readnone
  %i = call i32 @llvm.fptosi.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testasxd(double %a) {
; CHECK-LABEL: testasxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtas x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @round(double %a) nounwind readnone
  %i = call i64 @llvm.fptosi.sat.i64.f64(double %r)
  ret i64 %i
}

declare i32 @llvm.fptosi.sat.i32.bf16 (bfloat)
declare i64 @llvm.fptosi.sat.i64.bf16 (bfloat)
declare i32 @llvm.fptosi.sat.i32.f16 (half)
declare i64 @llvm.fptosi.sat.i64.f16 (half)
declare i32 @llvm.fptosi.sat.i32.f32 (float)
declare i64 @llvm.fptosi.sat.i64.f32 (float)
declare i32 @llvm.fptosi.sat.i32.f64 (double)
declare i64 @llvm.fptosi.sat.i64.f64 (double)

declare bfloat @llvm.floor.bf16(bfloat) nounwind readnone
declare bfloat @llvm.ceil.bf16(bfloat) nounwind readnone
declare bfloat @llvm.trunc.bf16(bfloat) nounwind readnone
declare bfloat @llvm.round.bf16(bfloat) nounwind readnone
declare half @llvm.floor.f16(half) nounwind readnone
declare half @llvm.ceil.f16(half) nounwind readnone
declare half @llvm.trunc.f16(half) nounwind readnone
declare half @llvm.round.f16(half) nounwind readnone
declare float @floorf(float) nounwind readnone
declare float @ceilf(float) nounwind readnone
declare float @truncf(float) nounwind readnone
declare float @roundf(float) nounwind readnone
declare double @floor(double) nounwind readnone
declare double @ceil(double) nounwind readnone
declare double @trunc(double) nounwind readnone
declare double @round(double) nounwind readnone
