; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 < %s | FileCheck %s

define <16 x i8> @fn1_vector(<16 x i8> %arg) {
; CHECK-LABEL: fn1_vector:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI0_0]
; CHECK-NEXT:    mul v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %shl = shl <16 x i8> %arg, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %mul = mul <16 x i8> %shl, <i8 0, i8 1, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
  ret <16 x i8> %mul
}

define <16 x i8> @fn2_vector(<16 x i8> %arg) {
; CHECK-LABEL: fn2_vector:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI1_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI1_0]
; CHECK-NEXT:    mul v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %mul = mul <16 x i8> %arg, <i8 0, i8 1, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
  %shl = shl <16 x i8> %mul, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <16 x i8> %shl
}

define <16 x i8> @fn1_vector_undef(<16 x i8> %arg) {
; CHECK-LABEL: fn1_vector_undef:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI2_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI2_0]
; CHECK-NEXT:    mul v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %shl = shl <16 x i8> %arg, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %mul = mul <16 x i8> %shl, <i8 undef, i8 1, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
  ret <16 x i8> %mul
}

define <16 x i8> @fn2_vector_undef(<16 x i8> %arg) {
; CHECK-LABEL: fn2_vector_undef:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, .LCPI3_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI3_0]
; CHECK-NEXT:    mul v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
entry:
  %mul = mul <16 x i8> %arg, <i8 undef, i8 1, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>
  %shl = shl <16 x i8> %mul, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <16 x i8> %shl
}

define i32 @fn1_scalar(i32 %arg) {
; CHECK-LABEL: fn1_scalar:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #1664
; CHECK-NEXT:    mul w0, w0, w8
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %arg, 7
  %mul = mul i32 %shl, 13
  ret i32 %mul
}

define i32 @fn2_scalar(i32 %arg) {
; CHECK-LABEL: fn2_scalar:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #1664
; CHECK-NEXT:    mul w0, w0, w8
; CHECK-NEXT:    ret
entry:
  %mul = mul i32 %arg, 13
  %shl = shl i32 %mul, 7
  ret i32 %shl
}

define i32 @fn1_scalar_undef(i32 %arg) {
; CHECK-LABEL: fn1_scalar_undef:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
entry:
  %shl = shl i32 %arg, 7
  %mul = mul i32 %shl, undef
  ret i32 %mul
}

define i32 @fn2_scalar_undef(i32 %arg) {
; CHECK-LABEL: fn2_scalar_undef:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
entry:
  %mul = mul i32 %arg, undef
  %shl = shl i32 %mul, 7
  ret i32 %shl
}

define i32 @fn1_scalar_opaque(i32 %arg) {
; CHECK-LABEL: fn1_scalar_opaque:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #13
; CHECK-NEXT:    mul w8, w0, w8
; CHECK-NEXT:    lsl w0, w8, #7
; CHECK-NEXT:    ret
entry:
  %bitcast = bitcast i32 13 to i32
  %shl = shl i32 %arg, 7
  %mul = mul i32 %shl, %bitcast
  ret i32 %mul
}

define i32 @fn2_scalar_opaque(i32 %arg) {
; CHECK-LABEL: fn2_scalar_opaque:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #13
; CHECK-NEXT:    mul w8, w0, w8
; CHECK-NEXT:    lsl w0, w8, #7
; CHECK-NEXT:    ret
entry:
  %bitcast = bitcast i32 13 to i32
  %mul = mul i32 %arg, %bitcast
  %shl = shl i32 %mul, 7
  ret i32 %shl
}
