/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/forklift/v1beta1"
)

// OvirtVolumePopulatorLister helps list OvirtVolumePopulators.
// All objects returned here must be treated as read-only.
type OvirtVolumePopulatorLister interface {
	// List lists all OvirtVolumePopulators in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.OvirtVolumePopulator, err error)
	// OvirtVolumePopulators returns an object that can list and get OvirtVolumePopulators.
	OvirtVolumePopulators(namespace string) OvirtVolumePopulatorNamespaceLister
	OvirtVolumePopulatorListerExpansion
}

// ovirtVolumePopulatorLister implements the OvirtVolumePopulatorLister interface.
type ovirtVolumePopulatorLister struct {
	listers.ResourceIndexer[*v1beta1.OvirtVolumePopulator]
}

// NewOvirtVolumePopulatorLister returns a new OvirtVolumePopulatorLister.
func NewOvirtVolumePopulatorLister(indexer cache.Indexer) OvirtVolumePopulatorLister {
	return &ovirtVolumePopulatorLister{listers.New[*v1beta1.OvirtVolumePopulator](indexer, v1beta1.Resource("ovirtvolumepopulator"))}
}

// OvirtVolumePopulators returns an object that can list and get OvirtVolumePopulators.
func (s *ovirtVolumePopulatorLister) OvirtVolumePopulators(namespace string) OvirtVolumePopulatorNamespaceLister {
	return ovirtVolumePopulatorNamespaceLister{listers.NewNamespaced[*v1beta1.OvirtVolumePopulator](s.ResourceIndexer, namespace)}
}

// OvirtVolumePopulatorNamespaceLister helps list and get OvirtVolumePopulators.
// All objects returned here must be treated as read-only.
type OvirtVolumePopulatorNamespaceLister interface {
	// List lists all OvirtVolumePopulators in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.OvirtVolumePopulator, err error)
	// Get retrieves the OvirtVolumePopulator from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.OvirtVolumePopulator, error)
	OvirtVolumePopulatorNamespaceListerExpansion
}

// ovirtVolumePopulatorNamespaceLister implements the OvirtVolumePopulatorNamespaceLister
// interface.
type ovirtVolumePopulatorNamespaceLister struct {
	listers.ResourceIndexer[*v1beta1.OvirtVolumePopulator]
}
