/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/upload/v1beta1"
	scheme "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned/scheme"
)

// UploadTokenRequestsGetter has a method to return a UploadTokenRequestInterface.
// A group's client should implement this interface.
type UploadTokenRequestsGetter interface {
	UploadTokenRequests(namespace string) UploadTokenRequestInterface
}

// UploadTokenRequestInterface has methods to work with UploadTokenRequest resources.
type UploadTokenRequestInterface interface {
	Create(ctx context.Context, uploadTokenRequest *v1beta1.UploadTokenRequest, opts v1.CreateOptions) (*v1beta1.UploadTokenRequest, error)
	Update(ctx context.Context, uploadTokenRequest *v1beta1.UploadTokenRequest, opts v1.UpdateOptions) (*v1beta1.UploadTokenRequest, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, uploadTokenRequest *v1beta1.UploadTokenRequest, opts v1.UpdateOptions) (*v1beta1.UploadTokenRequest, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.UploadTokenRequest, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.UploadTokenRequestList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.UploadTokenRequest, err error)
	UploadTokenRequestExpansion
}

// uploadTokenRequests implements UploadTokenRequestInterface
type uploadTokenRequests struct {
	*gentype.ClientWithList[*v1beta1.UploadTokenRequest, *v1beta1.UploadTokenRequestList]
}

// newUploadTokenRequests returns a UploadTokenRequests
func newUploadTokenRequests(c *UploadV1beta1Client, namespace string) *uploadTokenRequests {
	return &uploadTokenRequests{
		gentype.NewClientWithList[*v1beta1.UploadTokenRequest, *v1beta1.UploadTokenRequestList](
			"uploadtokenrequests",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1beta1.UploadTokenRequest { return &v1beta1.UploadTokenRequest{} },
			func() *v1beta1.UploadTokenRequestList { return &v1beta1.UploadTokenRequestList{} }),
	}
}
