# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest

class UntagResourcesRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'cloudphone', '2020-12-30', 'UntagResources')
		self.set_method('POST')

	def get_All(self): # Boolean
		return self.get_query_params().get('All')

	def set_All(self, All):  # Boolean
		self.add_query_param('All', All)
	def get_ResourceIds(self): # RepeatList
		return self.get_query_params().get('ResourceId')

	def set_ResourceIds(self, ResourceId):  # RepeatList
		for depth1 in range(len(ResourceId)):
			self.add_query_param('ResourceId.' + str(depth1 + 1), ResourceId[depth1])
	def get_ResourceOwnerAccount(self): # String
		return self.get_query_params().get('ResourceOwnerAccount')

	def set_ResourceOwnerAccount(self, ResourceOwnerAccount):  # String
		self.add_query_param('ResourceOwnerAccount', ResourceOwnerAccount)
	def get_OwnerAccount(self): # String
		return self.get_query_params().get('OwnerAccount')

	def set_OwnerAccount(self, OwnerAccount):  # String
		self.add_query_param('OwnerAccount', OwnerAccount)
	def get_OwnerId(self): # Long
		return self.get_query_params().get('OwnerId')

	def set_OwnerId(self, OwnerId):  # Long
		self.add_query_param('OwnerId', OwnerId)
	def get_ResourceType(self): # String
		return self.get_query_params().get('ResourceType')

	def set_ResourceType(self, ResourceType):  # String
		self.add_query_param('ResourceType', ResourceType)
	def get_TagKeys(self): # RepeatList
		return self.get_query_params().get('TagKey')

	def set_TagKeys(self, TagKey):  # RepeatList
		for depth1 in range(len(TagKey)):
			self.add_query_param('TagKey.' + str(depth1 + 1), TagKey[depth1])
