/**
 * Copyright (c) 2008, SnakeYAML
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.yaml.snakeyaml.issues.issue203;

import junit.framework.TestCase;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.YamlCreator;

public class GenericTest extends TestCase {

  public void testGenericInterface() {
    Yaml yaml = YamlCreator.allowClassPrefix("org.yaml.snakeyaml");
    String uuu = "!!org.yaml.snakeyaml.issues.issue203.DataBean\n"
        + "content: !!org.yaml.snakeyaml.issues.issue203.ContentIdentifierImpl 33\n" + "id: 555";
    DataBean obj = yaml.load(uuu);
    assertEquals(33, obj.getContent().getId().intValue());
  }
}
