/**********************************************************************
 * $func_72bit example -- PLI application using ACC routines
 *
 * C source to return an 72-bit vector value to a system function.
 *
 * Usage: result = $func_72bit();
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_Func72bit_sizetf(),
 *              PLIbook_Func72bit_calltf();
 *  /* table entries -/
 *   {userfunction,                   /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     0,                             /* checktf routine -/
 *     PLIbook_Func72bit_sizetf,      /* sizetf routine -/
 *     PLIbook_Func72bit_calltf,      /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$func_72bit",                 /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * Sizetf application
 *********************************************************************/
int PLIbook_Func72bit_sizetf()
{
  return(72);   /* $pow returns 32-bit values */
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_Func72bit_calltf()
{
  handle systf_handle;
  s_setval_value value;
  s_setval_delay delay;
  p_acc_vecval   val_array;
  int array_size, i;
  
  /* declare an array of aval/bval pairs for the vector size */
  #define VEC_SIZE 72  /* hard coded 72-bit vector for this example */
  array_size = ((VEC_SIZE-1)/32)+1;
  val_array = (p_acc_vecval)malloc(sizeof(s_acc_vecval) * array_size);

  /* set value of vector aval/bval pairs */
  for (i=0; i<array_size; i++) {  
    val_array[i].aval = 0xAAAAAAAA; /* aval bits encode logic 0 & 1 */
    val_array[i].bval = 0x00000000; /* bval bits encode logic Z & X */
  }

  systf_handle = acc_handle_tfinst();
  value.format = accVectorVal;
  value.value.vector = val_array;
  delay.model = accNoDelay;

  acc_set_value(systf_handle, &value, &delay); /* set sysfunc return */

  return(0);
}

/*********************************************************************/
