/**********************************************************************
 * Example veriusertfs table that is used by many Verilog simulators
 * to register PLI applications that use the TF and ACC libraries of
 * the IEEE 1364 PLI.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

/* prototypes of the PLI application routines */
extern int PLIbook_ShowNets_checktf(),
           PLIbook_ShowNets_calltf();
extern int PLIbook_ShowSignals1_checktf(),
           PLIbook_ShowSignals1_calltf();
extern int PLIbook_ShowSignals2_checktf(),
           PLIbook_ShowSignals2_calltf();
extern int PLIbook_ShowSignals3_checktf(),
           PLIbook_ShowSignals3_calltf();

/* the veriusertfs table */
s_tfcell veriusertfs[] =
{
    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ShowNets_checktf,      /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ShowNets_calltf,       /* calltf routine */
      0,                             /* misctf routine */
      "$show_all_nets",              /* system task/function name */
      1                              /* forward reference = true */
    },                               /* */

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ShowSignals1_checktf,  /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ShowSignals1_calltf,   /* calltf routine */
      0,                             /* misctf routine */
      "$show_all_signals1",          /* system task/function name */
      1                              /* forward reference = true */
    },                               /* */

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ShowSignals2_checktf,  /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ShowSignals2_calltf,   /* calltf routine */
      0,                             /* misctf routine */
      "$show_all_signals2",          /* system task/function name */
      1                              /* forward reference = true */
    },                               /* */

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ShowSignals3_checktf,  /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ShowSignals3_calltf,   /* calltf routine */
      0,                             /* misctf routine */
      "$show_all_signals3",          /* system task/function name */
      1                              /* forward reference = true */
    },                               /* */

    {0} /*** final entry must be 0 ***/
};

