# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CanaryFlag(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Canary flag."""

    TRUE = "True"
    FALSE = "False"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class IsExpired(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if the certificate is expired."""

    TRUE = "True"
    FALSE = "False"


class IsSelfSigned(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates if the certificate was self-signed."""

    TRUE = "True"
    FALSE = "False"


class IsShortKeySize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the key size is considered too small to be secure for the algorithm."""

    TRUE = "True"
    FALSE = "False"


class IsUpdateAvailable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag if new update is available for the component."""

    TRUE = "True"
    FALSE = "False"


class IsWeakSignature(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the signature algorithm used is insecure."""

    TRUE = "True"
    FALSE = "False"


class NxFlag(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NX flag."""

    TRUE = "True"
    FALSE = "False"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PieFlag(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """PIE flag."""

    TRUE = "True"
    FALSE = "False"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the resource."""

    ACCEPTED = "Accepted"
    SUCCEEDED = "Succeeded"
    CANCELED = "Canceled"
    FAILED = "Failed"


class RelroFlag(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """RELRO flag."""

    TRUE = "True"
    FALSE = "False"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of firmware scan."""

    PENDING = "Pending"
    EXTRACTING = "Extracting"
    ANALYZING = "Analyzing"
    READY = "Ready"
    ERROR = "Error"


class StrippedFlag(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Stripped flag."""

    TRUE = "True"
    FALSE = "False"
