# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class ProxyOnlyResource(msrest.serialization.Model):
    """A proxy only azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DiagnosticSettingsCategoryResource(ProxyOnlyResource):
    """The diagnostic settings category resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar category_type: The type of the diagnostic settings category. Possible values include:
     "Metrics", "Logs".
    :vartype category_type: str or
     ~$(python-base-namespace).v2017_05_01_preview.models.CategoryType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'category_type': {'key': 'properties.categoryType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        category_type: Optional[Union[str, "CategoryType"]] = None,
        **kwargs
    ):
        """
        :keyword category_type: The type of the diagnostic settings category. Possible values include:
         "Metrics", "Logs".
        :paramtype category_type: str or
         ~$(python-base-namespace).v2017_05_01_preview.models.CategoryType
        """
        super(DiagnosticSettingsCategoryResource, self).__init__(**kwargs)
        self.category_type = category_type


class DiagnosticSettingsCategoryResourceCollection(msrest.serialization.Model):
    """Represents a collection of diagnostic setting category resources.

    :ivar value: The collection of diagnostic settings category resources.
    :vartype value:
     list[~$(python-base-namespace).v2017_05_01_preview.models.DiagnosticSettingsCategoryResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticSettingsCategoryResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DiagnosticSettingsCategoryResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of diagnostic settings category resources.
        :paramtype value:
         list[~$(python-base-namespace).v2017_05_01_preview.models.DiagnosticSettingsCategoryResource]
        """
        super(DiagnosticSettingsCategoryResourceCollection, self).__init__(**kwargs)
        self.value = value


class DiagnosticSettingsResource(ProxyOnlyResource):
    """The diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :vartype service_bus_rule_id: str
    :ivar event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :vartype event_hub_authorization_rule_id: str
    :ivar event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :vartype event_hub_name: str
    :ivar metrics: The list of metric settings.
    :vartype metrics: list[~$(python-base-namespace).v2017_05_01_preview.models.MetricSettings]
    :ivar logs: The list of logs settings.
    :vartype logs: list[~$(python-base-namespace).v2017_05_01_preview.models.LogSettings]
    :ivar workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    :ivar log_analytics_destination_type: A string indicating whether the export to Log Analytics
     should use the default destination type, i.e. AzureDiagnostics, or use a destination type
     constructed as follows: :code:`<normalized service identity>`_:code:`<normalized category
     name>`. Possible values are: Dedicated and null (null is default.).
    :vartype log_analytics_destination_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'metrics': {'key': 'properties.metrics', 'type': '[MetricSettings]'},
        'logs': {'key': 'properties.logs', 'type': '[LogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'log_analytics_destination_type': {'key': 'properties.logAnalyticsDestinationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        event_hub_authorization_rule_id: Optional[str] = None,
        event_hub_name: Optional[str] = None,
        metrics: Optional[List["MetricSettings"]] = None,
        logs: Optional[List["LogSettings"]] = None,
        workspace_id: Optional[str] = None,
        log_analytics_destination_type: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here
         to maintain backwards compatibility.
        :paramtype service_bus_rule_id: str
        :keyword event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
        :paramtype event_hub_authorization_rule_id: str
        :keyword event_hub_name: The name of the event hub. If none is specified, the default event hub
         will be selected.
        :paramtype event_hub_name: str
        :keyword metrics: The list of metric settings.
        :paramtype metrics: list[~$(python-base-namespace).v2017_05_01_preview.models.MetricSettings]
        :keyword logs: The list of logs settings.
        :paramtype logs: list[~$(python-base-namespace).v2017_05_01_preview.models.LogSettings]
        :keyword workspace_id: The full ARM resource ID of the Log Analytics workspace to which you
         would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        :keyword log_analytics_destination_type: A string indicating whether the export to Log
         Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination
         type constructed as follows: :code:`<normalized service identity>`_:code:`<normalized category
         name>`. Possible values are: Dedicated and null (null is default.).
        :paramtype log_analytics_destination_type: str
        """
        super(DiagnosticSettingsResource, self).__init__(**kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.event_hub_authorization_rule_id = event_hub_authorization_rule_id
        self.event_hub_name = event_hub_name
        self.metrics = metrics
        self.logs = logs
        self.workspace_id = workspace_id
        self.log_analytics_destination_type = log_analytics_destination_type


class DiagnosticSettingsResourceCollection(msrest.serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: The collection of diagnostic settings resources;.
    :vartype value:
     list[~$(python-base-namespace).v2017_05_01_preview.models.DiagnosticSettingsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticSettingsResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DiagnosticSettingsResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of diagnostic settings resources;.
        :paramtype value:
         list[~$(python-base-namespace).v2017_05_01_preview.models.DiagnosticSettingsResource]
        """
        super(DiagnosticSettingsResourceCollection, self).__init__(**kwargs)
        self.value = value


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the invariant value.
    :vartype value: str
    :ivar localized_value: the locale specific value.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. the invariant value.
        :paramtype value: str
        :keyword localized_value: the locale specific value.
        :paramtype localized_value: str
        """
        super(LocalizableString, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogSettings(msrest.serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Name of a Diagnostic Log category for a resource type this setting is applied
     to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
     diagnostic settings operation.
    :vartype category: str
    :ivar enabled: Required. a value indicating whether this log is enabled.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this log.
    :vartype retention_policy: ~$(python-base-namespace).v2017_05_01_preview.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        category: Optional[str] = None,
        retention_policy: Optional["RetentionPolicy"] = None,
        **kwargs
    ):
        """
        :keyword category: Name of a Diagnostic Log category for a resource type this setting is
         applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
         diagnostic settings operation.
        :paramtype category: str
        :keyword enabled: Required. a value indicating whether this log is enabled.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this log.
        :paramtype retention_policy:
         ~$(python-base-namespace).v2017_05_01_preview.models.RetentionPolicy
        """
        super(LogSettings, self).__init__(**kwargs)
        self.category = category
        self.enabled = enabled
        self.retention_policy = retention_policy


class MetadataValue(msrest.serialization.Model):
    """Represents a metric metadata value.

    :ivar name: the name of the metadata.
    :vartype name: ~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString
    :ivar value: the value of the metadata.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional["LocalizableString"] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: the name of the metadata.
        :paramtype name: ~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString
        :keyword value: the value of the metadata.
        :paramtype value: str
        """
        super(MetadataValue, self).__init__(**kwargs)
        self.name = name
        self.value = value


class Metric(msrest.serialization.Model):
    """The result data of a query.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. the metric Id.
    :vartype id: str
    :ivar type: Required. the resource type of the metric resource.
    :vartype type: str
    :ivar name: Required. the name and the display name of the metric, i.e. it is localizable
     string.
    :vartype name: ~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar error_code: 'Success' or the error details on query failures for this metric.
    :vartype error_code: str
    :ivar error_message: Error message encountered querying this specific metric.
    :vartype error_message: str
    :ivar unit: Required. the unit of the metric. Possible values include: "Count", "Bytes",
     "Seconds", "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds",
     "Unspecified", "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
    :vartype unit: str or ~$(python-base-namespace).v2017_05_01_preview.models.Unit
    :ivar timeseries: Required. the time series returned when a data query is performed.
    :vartype timeseries:
     list[~$(python-base-namespace).v2017_05_01_preview.models.TimeSeriesElement]
    """

    _validation = {
        'id': {'required': True},
        'type': {'required': True},
        'name': {'required': True},
        'unit': {'required': True},
        'timeseries': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'timeseries': {'key': 'timeseries', 'type': '[TimeSeriesElement]'},
    }

    def __init__(
        self,
        *,
        id: str,
        type: str,
        name: "LocalizableString",
        unit: Union[str, "Unit"],
        timeseries: List["TimeSeriesElement"],
        display_description: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Required. the metric Id.
        :paramtype id: str
        :keyword type: Required. the resource type of the metric resource.
        :paramtype type: str
        :keyword name: Required. the name and the display name of the metric, i.e. it is localizable
         string.
        :paramtype name: ~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword error_code: 'Success' or the error details on query failures for this metric.
        :paramtype error_code: str
        :keyword error_message: Error message encountered querying this specific metric.
        :paramtype error_message: str
        :keyword unit: Required. the unit of the metric. Possible values include: "Count", "Bytes",
         "Seconds", "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds",
         "Unspecified", "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
        :paramtype unit: str or ~$(python-base-namespace).v2017_05_01_preview.models.Unit
        :keyword timeseries: Required. the time series returned when a data query is performed.
        :paramtype timeseries:
         list[~$(python-base-namespace).v2017_05_01_preview.models.TimeSeriesElement]
        """
        super(Metric, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.display_description = display_description
        self.error_code = error_code
        self.error_message = error_message
        self.unit = unit
        self.timeseries = timeseries


class MetricAvailability(msrest.serialization.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency) and the retention period for that time grain.

    :ivar time_grain: the time grain specifies the aggregation interval for the metric. Expressed
     as a duration 'PT1M', 'P1D', etc.
    :vartype time_grain: ~datetime.timedelta
    :ivar retention: the retention period for the metric at the specified timegrain.  Expressed as
     a duration 'PT1M', 'P1D', etc.
    :vartype retention: ~datetime.timedelta
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'retention': {'key': 'retention', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        time_grain: Optional[datetime.timedelta] = None,
        retention: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword time_grain: the time grain specifies the aggregation interval for the metric.
         Expressed as a duration 'PT1M', 'P1D', etc.
        :paramtype time_grain: ~datetime.timedelta
        :keyword retention: the retention period for the metric at the specified timegrain.  Expressed
         as a duration 'PT1M', 'P1D', etc.
        :paramtype retention: ~datetime.timedelta
        """
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.retention = retention


class MetricDefinition(msrest.serialization.Model):
    """Metric definition class specifies the metadata for a metric.

    :ivar is_dimension_required: Flag to indicate whether the dimension is required.
    :vartype is_dimension_required: bool
    :ivar resource_id: the resource identifier of the resource that emitted the metric.
    :vartype resource_id: str
    :ivar name: the name and the display name of the metric, i.e. it is a localizable string.
    :vartype name: ~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString
    :ivar display_description: Detailed description of this metric.
    :vartype display_description: str
    :ivar category: Custom category name for this metric.
    :vartype category: str
    :ivar unit: the unit of the metric. Possible values include: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
     "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
    :vartype unit: str or ~$(python-base-namespace).v2017_05_01_preview.models.Unit
    :ivar primary_aggregation_type: the primary aggregation type value defining how to use the
     values for display. Possible values include: "None", "Average", "Count", "Minimum", "Maximum",
     "Total".
    :vartype primary_aggregation_type: str or
     ~$(python-base-namespace).v2017_05_01_preview.models.AggregationType
    :ivar metric_availabilities: the collection of what aggregation intervals are available to be
     queried.
    :vartype metric_availabilities:
     list[~$(python-base-namespace).v2017_05_01_preview.models.MetricAvailability]
    :ivar id: the resource identifier of the metric definition.
    :vartype id: str
    :ivar dimensions: the name and the display name of the dimension, i.e. it is a localizable
     string.
    :vartype dimensions:
     list[~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString]
    """

    _attribute_map = {
        'is_dimension_required': {'key': 'isDimensionRequired', 'type': 'bool'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
        'id': {'key': 'id', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[LocalizableString]'},
    }

    def __init__(
        self,
        *,
        is_dimension_required: Optional[bool] = None,
        resource_id: Optional[str] = None,
        name: Optional["LocalizableString"] = None,
        display_description: Optional[str] = None,
        category: Optional[str] = None,
        unit: Optional[Union[str, "Unit"]] = None,
        primary_aggregation_type: Optional[Union[str, "AggregationType"]] = None,
        metric_availabilities: Optional[List["MetricAvailability"]] = None,
        id: Optional[str] = None,
        dimensions: Optional[List["LocalizableString"]] = None,
        **kwargs
    ):
        """
        :keyword is_dimension_required: Flag to indicate whether the dimension is required.
        :paramtype is_dimension_required: bool
        :keyword resource_id: the resource identifier of the resource that emitted the metric.
        :paramtype resource_id: str
        :keyword name: the name and the display name of the metric, i.e. it is a localizable string.
        :paramtype name: ~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString
        :keyword display_description: Detailed description of this metric.
        :paramtype display_description: str
        :keyword category: Custom category name for this metric.
        :paramtype category: str
        :keyword unit: the unit of the metric. Possible values include: "Count", "Bytes", "Seconds",
         "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds", "ByteSeconds", "Unspecified",
         "Cores", "MilliCores", "NanoCores", "BitsPerSecond".
        :paramtype unit: str or ~$(python-base-namespace).v2017_05_01_preview.models.Unit
        :keyword primary_aggregation_type: the primary aggregation type value defining how to use the
         values for display. Possible values include: "None", "Average", "Count", "Minimum", "Maximum",
         "Total".
        :paramtype primary_aggregation_type: str or
         ~$(python-base-namespace).v2017_05_01_preview.models.AggregationType
        :keyword metric_availabilities: the collection of what aggregation intervals are available to
         be queried.
        :paramtype metric_availabilities:
         list[~$(python-base-namespace).v2017_05_01_preview.models.MetricAvailability]
        :keyword id: the resource identifier of the metric definition.
        :paramtype id: str
        :keyword dimensions: the name and the display name of the dimension, i.e. it is a localizable
         string.
        :paramtype dimensions:
         list[~$(python-base-namespace).v2017_05_01_preview.models.LocalizableString]
        """
        super(MetricDefinition, self).__init__(**kwargs)
        self.is_dimension_required = is_dimension_required
        self.resource_id = resource_id
        self.name = name
        self.display_description = display_description
        self.category = category
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.metric_availabilities = metric_availabilities
        self.id = id
        self.dimensions = dimensions


class MetricDefinitionCollection(msrest.serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. the values for the metric definitions.
    :vartype value: list[~$(python-base-namespace).v2017_05_01_preview.models.MetricDefinition]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricDefinition]'},
    }

    def __init__(
        self,
        *,
        value: List["MetricDefinition"],
        **kwargs
    ):
        """
        :keyword value: Required. the values for the metric definitions.
        :paramtype value: list[~$(python-base-namespace).v2017_05_01_preview.models.MetricDefinition]
        """
        super(MetricDefinitionCollection, self).__init__(**kwargs)
        self.value = value


class MetricSettings(msrest.serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.

    All required parameters must be populated in order to send to Azure.

    :ivar time_grain: the timegrain of the metric in ISO8601 format.
    :vartype time_grain: ~datetime.timedelta
    :ivar category: Name of a Diagnostic Metric category for a resource type this setting is
     applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a
     GET diagnostic settings operation.
    :vartype category: str
    :ivar enabled: Required. a value indicating whether this category is enabled.
    :vartype enabled: bool
    :ivar retention_policy: the retention policy for this category.
    :vartype retention_policy: ~$(python-base-namespace).v2017_05_01_preview.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'category': {'key': 'category', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        time_grain: Optional[datetime.timedelta] = None,
        category: Optional[str] = None,
        retention_policy: Optional["RetentionPolicy"] = None,
        **kwargs
    ):
        """
        :keyword time_grain: the timegrain of the metric in ISO8601 format.
        :paramtype time_grain: ~datetime.timedelta
        :keyword category: Name of a Diagnostic Metric category for a resource type this setting is
         applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a
         GET diagnostic settings operation.
        :paramtype category: str
        :keyword enabled: Required. a value indicating whether this category is enabled.
        :paramtype enabled: bool
        :keyword retention_policy: the retention policy for this category.
        :paramtype retention_policy:
         ~$(python-base-namespace).v2017_05_01_preview.models.RetentionPolicy
        """
        super(MetricSettings, self).__init__(**kwargs)
        self.time_grain = time_grain
        self.category = category
        self.enabled = enabled
        self.retention_policy = retention_policy


class MetricValue(msrest.serialization.Model):
    """Represents a metric value.

    All required parameters must be populated in order to send to Azure.

    :ivar time_stamp: Required. the timestamp for the metric value in ISO 8601 format.
    :vartype time_stamp: ~datetime.datetime
    :ivar average: the average value in the time range.
    :vartype average: float
    :ivar minimum: the least value in the time range.
    :vartype minimum: float
    :ivar maximum: the greatest value in the time range.
    :vartype maximum: float
    :ivar total: the sum of all of the values in the time range.
    :vartype total: float
    :ivar count: the number of samples in the time range. Can be used to determine the number of
     values that contributed to the average value.
    :vartype count: long
    """

    _validation = {
        'time_stamp': {'required': True},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'average': {'key': 'average', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'total': {'key': 'total', 'type': 'float'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        time_stamp: datetime.datetime,
        average: Optional[float] = None,
        minimum: Optional[float] = None,
        maximum: Optional[float] = None,
        total: Optional[float] = None,
        count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword time_stamp: Required. the timestamp for the metric value in ISO 8601 format.
        :paramtype time_stamp: ~datetime.datetime
        :keyword average: the average value in the time range.
        :paramtype average: float
        :keyword minimum: the least value in the time range.
        :paramtype minimum: float
        :keyword maximum: the greatest value in the time range.
        :paramtype maximum: float
        :keyword total: the sum of all of the values in the time range.
        :paramtype total: float
        :keyword count: the number of samples in the time range. Can be used to determine the number of
         values that contributed to the average value.
        :paramtype count: long
        """
        super(MetricValue, self).__init__(**kwargs)
        self.time_stamp = time_stamp
        self.average = average
        self.minimum = minimum
        self.maximum = maximum
        self.total = total
        self.count = count


class Response(msrest.serialization.Model):
    """The response to a metrics query.

    All required parameters must be populated in order to send to Azure.

    :ivar cost: The integer value representing the relative cost of the query.
    :vartype cost: int
    :ivar timespan: Required. The timespan for which the data was retrieved. Its value consists of
     two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned
     back from what was originally requested.
    :vartype timespan: str
    :ivar interval: The interval (window size) for which the metric data was returned in.  This may
     be adjusted in the future and returned back from what was originally requested.  This is not
     present if a metadata request was made.
    :vartype interval: ~datetime.timedelta
    :ivar value: Required. the value of the collection.
    :vartype value: list[~$(python-base-namespace).v2017_05_01_preview.models.Metric]
    """

    _validation = {
        'cost': {'minimum': 0},
        'timespan': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'cost': {'key': 'cost', 'type': 'int'},
        'timespan': {'key': 'timespan', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'duration'},
        'value': {'key': 'value', 'type': '[Metric]'},
    }

    def __init__(
        self,
        *,
        timespan: str,
        value: List["Metric"],
        cost: Optional[int] = None,
        interval: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword cost: The integer value representing the relative cost of the query.
        :paramtype cost: int
        :keyword timespan: Required. The timespan for which the data was retrieved. Its value consists
         of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and
         returned back from what was originally requested.
        :paramtype timespan: str
        :keyword interval: The interval (window size) for which the metric data was returned in.  This
         may be adjusted in the future and returned back from what was originally requested.  This is
         not present if a metadata request was made.
        :paramtype interval: ~datetime.timedelta
        :keyword value: Required. the value of the collection.
        :paramtype value: list[~$(python-base-namespace).v2017_05_01_preview.models.Metric]
        """
        super(Response, self).__init__(**kwargs)
        self.cost = cost
        self.timespan = timespan
        self.interval = interval
        self.value = value


class RetentionPolicy(msrest.serialization.Model):
    """Specifies the retention policy for the log.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. a value indicating whether the retention policy is enabled.
    :vartype enabled: bool
    :ivar days: Required. the number of days for the retention in days. A value of 0 will retain
     the events indefinitely.
    :vartype days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        days: int,
        **kwargs
    ):
        """
        :keyword enabled: Required. a value indicating whether the retention policy is enabled.
        :paramtype enabled: bool
        :keyword days: Required. the number of days for the retention in days. A value of 0 will retain
         the events indefinitely.
        :paramtype days: int
        """
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class SubscriptionProxyOnlyResource(msrest.serialization.Model):
    """A proxy only azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        """
        super(SubscriptionProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location


class SubscriptionDiagnosticSettingsResource(SubscriptionProxyOnlyResource):
    """The subscription diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Location of the resource.
    :vartype location: str
    :ivar storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :vartype storage_account_id: str
    :ivar service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :vartype service_bus_rule_id: str
    :ivar event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :vartype event_hub_authorization_rule_id: str
    :ivar event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :vartype event_hub_name: str
    :ivar logs: The list of logs settings.
    :vartype logs:
     list[~$(python-base-namespace).v2017_05_01_preview.models.SubscriptionLogSettings]
    :ivar workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :vartype workspace_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'logs': {'key': 'properties.logs', 'type': '[SubscriptionLogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        service_bus_rule_id: Optional[str] = None,
        event_hub_authorization_rule_id: Optional[str] = None,
        event_hub_name: Optional[str] = None,
        logs: Optional[List["SubscriptionLogSettings"]] = None,
        workspace_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the resource.
        :paramtype location: str
        :keyword storage_account_id: The resource ID of the storage account to which you would like to
         send Diagnostic Logs.
        :paramtype storage_account_id: str
        :keyword service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here
         to maintain backwards compatibility.
        :paramtype service_bus_rule_id: str
        :keyword event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
        :paramtype event_hub_authorization_rule_id: str
        :keyword event_hub_name: The name of the event hub. If none is specified, the default event hub
         will be selected.
        :paramtype event_hub_name: str
        :keyword logs: The list of logs settings.
        :paramtype logs:
         list[~$(python-base-namespace).v2017_05_01_preview.models.SubscriptionLogSettings]
        :keyword workspace_id: The full ARM resource ID of the Log Analytics workspace to which you
         would like to send Diagnostic Logs. Example:
         /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
        :paramtype workspace_id: str
        """
        super(SubscriptionDiagnosticSettingsResource, self).__init__(location=location, **kwargs)
        self.storage_account_id = storage_account_id
        self.service_bus_rule_id = service_bus_rule_id
        self.event_hub_authorization_rule_id = event_hub_authorization_rule_id
        self.event_hub_name = event_hub_name
        self.logs = logs
        self.workspace_id = workspace_id


class SubscriptionDiagnosticSettingsResourceCollection(msrest.serialization.Model):
    """Represents a collection of subscription diagnostic settings resources.

    :ivar value: The collection of subscription diagnostic settings resources.
    :vartype value:
     list[~$(python-base-namespace).v2017_05_01_preview.models.SubscriptionDiagnosticSettingsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionDiagnosticSettingsResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SubscriptionDiagnosticSettingsResource"]] = None,
        **kwargs
    ):
        """
        :keyword value: The collection of subscription diagnostic settings resources.
        :paramtype value:
         list[~$(python-base-namespace).v2017_05_01_preview.models.SubscriptionDiagnosticSettingsResource]
        """
        super(SubscriptionDiagnosticSettingsResourceCollection, self).__init__(**kwargs)
        self.value = value


class SubscriptionLogSettings(msrest.serialization.Model):
    """Part of Subscription diagnostic setting. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Name of a Subscription Diagnostic Log category for a resource type this setting
     is applied to.
    :vartype category: str
    :ivar enabled: Required. a value indicating whether this log is enabled.
    :vartype enabled: bool
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        category: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword category: Name of a Subscription Diagnostic Log category for a resource type this
         setting is applied to.
        :paramtype category: str
        :keyword enabled: Required. a value indicating whether this log is enabled.
        :paramtype enabled: bool
        """
        super(SubscriptionLogSettings, self).__init__(**kwargs)
        self.category = category
        self.enabled = enabled


class TimeSeriesElement(msrest.serialization.Model):
    """A time series result type. The discriminator value is always TimeSeries in this case.

    :ivar metadatavalues: the metadata values returned if $filter was specified in the call.
    :vartype metadatavalues:
     list[~$(python-base-namespace).v2017_05_01_preview.models.MetadataValue]
    :ivar data: An array of data points representing the metric values.  This is only returned if a
     result type of data is specified.
    :vartype data: list[~$(python-base-namespace).v2017_05_01_preview.models.MetricValue]
    """

    _attribute_map = {
        'metadatavalues': {'key': 'metadatavalues', 'type': '[MetadataValue]'},
        'data': {'key': 'data', 'type': '[MetricValue]'},
    }

    def __init__(
        self,
        *,
        metadatavalues: Optional[List["MetadataValue"]] = None,
        data: Optional[List["MetricValue"]] = None,
        **kwargs
    ):
        """
        :keyword metadatavalues: the metadata values returned if $filter was specified in the call.
        :paramtype metadatavalues:
         list[~$(python-base-namespace).v2017_05_01_preview.models.MetadataValue]
        :keyword data: An array of data points representing the metric values.  This is only returned
         if a result type of data is specified.
        :paramtype data: list[~$(python-base-namespace).v2017_05_01_preview.models.MetricValue]
        """
        super(TimeSeriesElement, self).__init__(**kwargs)
        self.metadatavalues = metadatavalues
        self.data = data
