/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.net.URL;
import org.w3c.dom.Node;

class WebFrame
extends HTMLElementBase {
    private Node _element;
    private URL _baseURL;
    private String _name;

    protected ScriptableDelegate newScriptable() {
        return null;
    }

    protected ScriptableDelegate getParentDelegate() {
        return null;
    }

    WebFrame(URL baseURL, Node frameNode, String parentFrameName) {
        super(frameNode);
        this._element = frameNode;
        this._baseURL = baseURL;
        this._name = this.getFrameName(parentFrameName);
    }

    String getFrameName() {
        return this._name;
    }

    private String getFrameName(String parentFrameName) {
        String relativeName = super.getName();
        if (relativeName.length() == 0) {
            return this.toString();
        }
        return WebFrame.getNestedFrameName(parentFrameName, relativeName);
    }

    static String getNestedFrameName(String parentFrameName, String relativeName) {
        if (parentFrameName.equalsIgnoreCase("_top")) {
            return relativeName;
        }
        return parentFrameName + ':' + relativeName;
    }

    static String getParentFrameName(String parentFrameName) {
        if (parentFrameName.indexOf(58) < 0) {
            return "_top";
        }
        return parentFrameName.substring(0, parentFrameName.lastIndexOf(58));
    }

    WebRequest getInitialRequest() {
        return new GetMethodWebRequest(this._baseURL, NodeUtils.getNodeAttribute(this._element, "src"), this.getFrameName());
    }

    boolean hasInitialRequest() {
        return NodeUtils.getNodeAttribute(this._element, "src").length() > 0;
    }
}

