/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import org.w3c.dom.Node;

abstract class HTMLElementBase
implements HTMLElement {
    private Node _node;
    private ScriptableDelegate _scriptable;

    public String getID() {
        return this.getAttribute("id");
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public ScriptableDelegate getScriptableDelegate() {
        if (this._scriptable == null) {
            this._scriptable = this.newScriptable();
            this._scriptable.setScriptEngine(this.getParentDelegate().getScriptEngine(this._scriptable));
        }
        return this._scriptable;
    }

    protected HTMLElementBase(Node node) {
        this._node = node;
    }

    protected String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this.getNode(), name);
    }

    protected String getAttribute(String name, String defaultValue) {
        return NodeUtils.getNodeAttribute(this.getNode(), name, defaultValue);
    }

    protected Node getNode() {
        return this._node;
    }

    protected abstract ScriptableDelegate newScriptable();

    protected abstract ScriptableDelegate getParentDelegate();
}

