/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AnyType;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.XMLType;

public class Schema
extends Annotated {
    public static final String DEFAULT_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NULL_ARGUMENT = "A null argument was passed to " + (class$org$exolab$castor$xml$schema$Schema == null ? (class$org$exolab$castor$xml$schema$Schema = Schema.class$("org.exolab.castor.xml.schema.Schema")) : class$org$exolab$castor$xml$schema$Schema).getName() + "#";
    private static SimpleTypesFactory simpleTypesFactory = new SimpleTypesFactory();
    private Form _attributeFormDefault = null;
    private Hashtable _attributeGroups = null;
    private Hashtable _attributes = new Hashtable();
    private BlockList _block = null;
    private Hashtable _complexTypes = null;
    private Form _elementFormDefault = null;
    private Hashtable _elements = null;
    private FinalList _final = null;
    private Hashtable _groups = null;
    private String _id = null;
    private Hashtable _importedSchemas = null;
    private Vector _includedSchemas = null;
    private Namespaces _namespaces = null;
    private String _schemaLocation = null;
    private String _schemaNamespace = null;
    private Hashtable _simpleTypes = null;
    private String _targetNamespace = null;
    private String _version = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$Schema;

    public Schema() {
        this(null, DEFAULT_SCHEMA_NS);
    }

    public Schema(String schemaNS) {
        this(null, schemaNS);
    }

    public Schema(String prefix, String schemaNS) {
        this._attributeGroups = new Hashtable();
        this._complexTypes = new Hashtable();
        this._simpleTypes = new Hashtable();
        this._elements = new Hashtable();
        this._groups = new Hashtable();
        this._importedSchemas = new Hashtable();
        this._includedSchemas = new Vector();
        this._namespaces = new Namespaces();
        this._schemaNamespace = schemaNS;
        if (this._schemaNamespace == null) {
            this._schemaNamespace = DEFAULT_SCHEMA_NS;
        }
        if (prefix == null) {
            prefix = "";
        }
        this.addNamespace(prefix, this._schemaNamespace);
        this.init();
    }

    private void init() {
    }

    public void addAttribute(AttributeDecl attribute) throws SchemaException {
        if (attribute == null) {
            return;
        }
        String name = attribute.getName();
        if (attribute.getSchema() != this) {
            String err = "invalid attempt to add an AttributeDecl which ";
            err = err + "belongs to a different Schema; " + name;
            throw new SchemaException(err);
        }
        if (name == null && attribute.isReference()) {
            String err = "Error attempting to add a top-level AttributeDecl that is a reference. Top-level attributes can only be attribute declarations: " + attribute.getName(false);
            throw new SchemaException(err);
        }
        Object obj = this._attributes.get(name);
        if (obj == attribute) {
            return;
        }
        if (obj != null) {
            String err = "Error attempting to add an AttributeDecl to this Schema definition, an AttributeDecl already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._attributes.put(name, attribute);
        attribute.setParent(this);
    }

    public void addAttributeGroup(AttributeGroupDecl attrGroup) throws SchemaException {
        if (attrGroup == null) {
            return;
        }
        String name = attrGroup.getName();
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            String ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "addAttributeGroup: ";
                err = err + "Namespace prefix not recognized '" + nsPrefix + "'";
                throw new IllegalArgumentException(err);
            }
            if (!ns.equals(this._targetNamespace)) {
                String err = "AttributeGroup has different namespace than this Schema definition.";
                throw new IllegalArgumentException(err);
            }
        }
        if (attrGroup.getSchema() != this) {
            String err = "invalid attempt to add an AttributeGroup which ";
            err = err + "belongs to a different Schema; " + name;
            throw new SchemaException(err);
        }
        Object obj = this._attributeGroups.get(name);
        if (obj == attrGroup) {
            return;
        }
        if (obj != null) {
            String err = "Error attempting to add an AttributeGroup to this Schema definition, an AttributeGroup already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._attributeGroups.put(name, attrGroup);
    }

    public synchronized void addComplexType(ComplexType complexType) throws SchemaException {
        String name = complexType.getName();
        if (name == null) {
            String err = "a global ComplexType must contain a name.";
            throw new SchemaException(err);
        }
        if (complexType.getSchema() != this) {
            String err = "invalid attempt to add an ComplexType which ";
            err = err + "belongs to a different Schema; type name: " + name;
            throw new SchemaException(err);
        }
        if (this._complexTypes.get(name) != null) {
            String err = "a ComplexType already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._complexTypes.put(name, complexType);
        complexType.setParent(this);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        String name = elementDecl.getName(true);
        if (name == null && elementDecl.isReference()) {
            String err = "Error attempting to add a top-level Element that is a reference. Top-level elements can only be element declarations: " + elementDecl.getName(false);
            throw new SchemaException(err);
        }
        if (name == null) {
            String err = "an element declaration must contain a name.";
            throw new SchemaException(err);
        }
        if (this._elements.get(name) != null) {
            String err = "an element declaration already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._elements.put(name, elementDecl);
        elementDecl.setParent(this);
    }

    public void addModelGroup(ModelGroup group) throws SchemaException {
        String name = group.getName();
        if (name == null) {
            String err = "a group declaration must contain a name.";
            throw new SchemaException(err);
        }
        if (this._groups.get(name) != null) {
            String err = "an group declaration already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        this._groups.put(name, group);
        group.setParent(this);
    }

    public synchronized void addImportedSchema(Schema schema) throws SchemaException {
        String targetNamespace = schema.getTargetNamespace();
        if (targetNamespace == null) {
            targetNamespace = "";
        }
        if (this._importedSchemas.get(targetNamespace) != null) {
            String err = "a Schema has already been imported with the given namespace: ";
            throw new SchemaException(err + targetNamespace);
        }
        this._importedSchemas.put(targetNamespace, schema);
    }

    public void addNamespace(String prefix, String ns) {
        this._namespaces.addNamespace(prefix, ns);
    }

    public synchronized void addSimpleType(SimpleType simpleType) throws SchemaException {
        String name = simpleType.getName();
        if (name == null || name.length() == 0) {
            String err = "No name found for top-level SimpleType.  A top-level SimpleType must have a name.";
            throw new SchemaException(err);
        }
        if (simpleType.getSchema() != this) {
            String err = "invalid attempt to add a SimpleType which ";
            err = err + "belongs to a different Schema; type name: " + name;
            throw new SchemaException(err);
        }
        if (this._simpleTypes.get(name) != null) {
            String err = "a SimpleType already exists with the given name: ";
            throw new SchemaException(err + name);
        }
        simpleType.setParent(this);
        this._simpleTypes.put(name, simpleType);
    }

    public ComplexType createComplexType() {
        return new ComplexType(this);
    }

    public ComplexType createComplexType(String name) {
        return new ComplexType(this, name);
    }

    public SimpleType createSimpleType(String name, String baseName, String derivation) {
        return simpleTypesFactory.createUserSimpleType(this, name, baseName, derivation, true);
    }

    public SimpleType createSimpleType(String name, SimpleType baseType) {
        return simpleTypesFactory.createUserSimpleType(this, name, baseType, "restriction");
    }

    public Form getAttributeFormDefault() {
        return this._attributeFormDefault;
    }

    public Enumeration getAttributes() {
        return this._attributes.elements();
    }

    public AttributeDecl getAttribute(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getAttribute: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        String canonicalName = name;
        String nsprefix = "";
        String ns = this._targetNamespace;
        int colon = name.indexOf(58);
        if (colon != -1) {
            canonicalName = name.substring(colon + 1);
            nsprefix = name.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(nsprefix);
            if (ns == null) {
                String err = "getAttribute: ";
                err = err + "Namespace prefix not recognized '" + name + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            return (AttributeDecl)this._attributes.get(canonicalName);
        }
        Schema schema = this.getImportedSchema(ns);
        if (schema != null) {
            AttributeDecl att = schema.getAttribute(canonicalName);
            return att;
        }
        return null;
    }

    public Enumeration getAttributeGroups() {
        return this._attributeGroups.elements();
    }

    public AttributeGroup getAttributeGroup(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getAttributeGroup: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        String canonicalName = name;
        String nsprefix = "";
        String ns = this._targetNamespace;
        int colon = name.indexOf(58);
        if (colon != -1) {
            canonicalName = name.substring(colon + 1);
            nsprefix = name.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(nsprefix);
            if (ns == null) {
                String err = "getAttributeGroup: ";
                err = err + "Namespace prefix not recognized '" + name + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            return (AttributeGroup)this._attributeGroups.get(canonicalName);
        }
        Schema schema = this.getImportedSchema(ns);
        if (schema != null) {
            return schema.getAttributeGroup(canonicalName);
        }
        return null;
    }

    public BlockList getBlockDefault() {
        return this._block;
    }

    public String getBuiltInTypeName(int builtInTypeCode) {
        return simpleTypesFactory.getBuiltInTypeName(builtInTypeCode);
    }

    public ComplexType getComplexType(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getComplexType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        String canonicalName = name;
        String nsprefix = "";
        String ns = this._targetNamespace;
        int colon = name.indexOf(58);
        if (colon != -1) {
            canonicalName = name.substring(colon + 1);
            nsprefix = name.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(nsprefix);
            if (ns == null) {
                String err = "getComplexType: ";
                err = err + "Namespace prefix not recognized '" + name + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            return (ComplexType)this._complexTypes.get(canonicalName);
        }
        Schema schema = this.getImportedSchema(ns);
        if (schema != null) {
            return schema.getComplexType(canonicalName);
        }
        return null;
    }

    public Enumeration getComplexTypes() {
        return this._complexTypes.elements();
    }

    public ElementDecl getElementDecl(String name) {
        String ns = null;
        if (name == null) {
            String err = NULL_ARGUMENT + "getElementDecl: ";
            err = err + " 'name' can not be null";
            throw new IllegalArgumentException(err);
        }
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "getElementDecl: ";
                err = err + "Namespace prefix not recognized '" + nsPrefix + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            return (ElementDecl)this._elements.get(name);
        }
        Schema schema = this.getImportedSchema(ns);
        if (schema != null) {
            return schema.getElementDecl(name);
        }
        return null;
    }

    public Enumeration getElementDecls() {
        return this._elements.elements();
    }

    public Form getElementFormDefault() {
        return this._elementFormDefault;
    }

    public FinalList getFinalDefault() {
        return this._final;
    }

    public SimpleType getSimpleType(String name) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getSimpleType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        String nsPrefix = "";
        String ns = null;
        int colon = name.indexOf(58);
        if (colon >= 0) {
            nsPrefix = name.substring(0, colon);
            name = name.substring(colon + 1);
            ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "getSimpleType: ";
                err = err + "Namespace prefix not recognised '" + nsPrefix + "'";
                err = err + "for simpleType:" + name;
                throw new IllegalArgumentException(err);
            }
        } else {
            ns = this._namespaces.getNamespaceURI(nsPrefix);
        }
        if (ns == null) {
            ns = this._targetNamespace;
        }
        return this.getSimpleType(name, ns);
    }

    public SimpleType getSimpleType(String name, String namespace) {
        if (name == null) {
            String err = NULL_ARGUMENT + "getSimpleType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        boolean isDefaultNS = false;
        if (namespace == null) {
            namespace = this._namespaces.getNamespaceURI("");
            isDefaultNS = true;
        }
        SimpleType result = null;
        if (namespace == null || isDefaultNS) {
            result = (SimpleType)this._simpleTypes.get(name);
            if (result != null) {
                if (result.getType() != result && result.getType() != null) {
                    result = (SimpleType)result.getType();
                    result.setParent(this);
                    this._simpleTypes.put(name, result);
                }
            } else {
                result = simpleTypesFactory.getBuiltInType(name);
                if (result != null && !this._schemaNamespace.equals(namespace)) {
                    String err = "getSimpleType: the simple type '" + name + "' has not been declared in XML Schema namespace.";
                    throw new IllegalArgumentException(err);
                }
            }
        } else if (namespace.equals(this._schemaNamespace)) {
            result = simpleTypesFactory.getBuiltInType(name);
            if (result == null) {
                String err = "getSimpleType: the simple type '" + name + "' is not a built-in type as defined in XML Schema specification.";
                throw new IllegalArgumentException(err);
            }
        } else if (namespace.equals(this._targetNamespace)) {
            result = (SimpleType)this._simpleTypes.get(name);
            if (result != null && result.getType() != result && result.getType() != null) {
                result = (SimpleType)result.getType();
                result.setParent(this);
                this._simpleTypes.put(name, result);
            }
        } else {
            Schema schema = this.getImportedSchema(namespace);
            if (schema != null) {
                result = schema.getSimpleType(name, namespace);
            }
        }
        if (result != null) {
            result = (SimpleType)result.getType();
        }
        return result;
    }

    public Enumeration getSimpleTypes() {
        Enumeration enumeration = this._simpleTypes.elements();
        while (enumeration.hasMoreElements()) {
            SimpleType type = (SimpleType)enumeration.nextElement();
            if (type == type.getType() || type.getType() == null) continue;
            String name = type.getName();
            type = (SimpleType)type.getType();
            type.setParent(this);
            this._simpleTypes.put(name, type);
        }
        return this._simpleTypes.elements();
    }

    public String getSchemaLocation() {
        return this._schemaLocation;
    }

    public ModelGroup getModelGroup(String name) {
        String ns = null;
        if (name == null) {
            String err = NULL_ARGUMENT + "getModelGroup: ";
            err = err + " 'name' can not be null";
            throw new IllegalArgumentException(err);
        }
        int idx = name.indexOf(58);
        if (idx >= 0) {
            String nsPrefix = name.substring(0, idx);
            name = name.substring(idx + 1);
            ns = this._namespaces.getNamespaceURI(nsPrefix);
            if (ns == null) {
                String err = "getModelGroup: ";
                err = err + "Namespace prefix not recognized '" + nsPrefix + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null || ns.equals(this._targetNamespace)) {
            return (ModelGroup)this._groups.get(name);
        }
        Schema schema = this.getImportedSchema(ns);
        if (schema != null) {
            return schema.getModelGroup(name);
        }
        return null;
    }

    public Enumeration getModelGroups() {
        return this._groups.elements();
    }

    public String getId() {
        return this._id;
    }

    public Enumeration getImportedSchema() {
        return this._importedSchemas.elements();
    }

    public Schema getImportedSchema(String ns) {
        Schema result = (Schema)this._importedSchemas.get(ns);
        if (result == null) {
            Enumeration schemas = this._importedSchemas.elements();
            boolean found = false;
            while (schemas.hasMoreElements() && !found) {
                Schema temp = (Schema)schemas.nextElement();
                result = temp.getImportedSchema(ns);
                if (result == null) continue;
                found = true;
            }
        }
        return result;
    }

    public final String getNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return this._namespaces.getNamespaceURI(prefix);
    }

    public Namespaces getNamespaces() {
        return this._namespaces;
    }

    public void addInclude(String include) {
        this._includedSchemas.addElement(include);
    }

    public boolean includeProcessed(String includeFile) {
        return this._includedSchemas.contains(includeFile);
    }

    public String getSchemaNamespace() {
        return this._schemaNamespace;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isKnownNamespace(String namespaceURL) {
        return this._namespaces.getNamespacePrefix(namespaceURL) != null;
    }

    public boolean removeComplexType(ComplexType complexType) {
        if (complexType.isTopLevel() && this._complexTypes.contains(complexType)) {
            this._complexTypes.remove(complexType.getName());
            complexType.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeElement(ElementDecl element) {
        if (this._elements.contains(element)) {
            this._elements.remove(element.getName());
            return true;
        }
        return false;
    }

    public boolean removeAttribute(AttributeDecl attribute) {
        if (this._attributes.contains(attribute)) {
            this._attributes.remove(attribute.getName());
            return true;
        }
        return false;
    }

    public boolean removeGroup(ModelGroup group) {
        if (this._groups.contains(group)) {
            this._groups.remove(group.getName());
            return true;
        }
        return false;
    }

    public boolean removeNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return this._namespaces.removeNamespace(prefix);
    }

    public boolean removeSimpleType(SimpleType simpleType) {
        if (this._simpleTypes.contains(simpleType)) {
            this._simpleTypes.remove(simpleType.getName());
            return true;
        }
        return false;
    }

    public void setAttributeFormDefault(Form attributeFormDefault) {
        this._attributeFormDefault = attributeFormDefault;
    }

    public void setBlockDefault(BlockList block) {
        this._block = block;
    }

    public void setBlockDefault(String block) {
        this._block = new BlockList(block);
    }

    public void setElementFormDefault(Form elementFormDefault) {
        this._elementFormDefault = elementFormDefault;
    }

    public void setFinalDefault(FinalList finalList) {
        this._final = finalList;
    }

    public void setFinalDefault(String finalValues) {
        this._final = new FinalList(finalValues);
    }

    public void setSchemaLocation(String schemaLocation) {
        this._schemaLocation = schemaLocation;
    }

    public XMLType getType(String typeName) {
        if (typeName == null) {
            String err = NULL_ARGUMENT + "Schema#getType: ";
            err = err + "'name' cannot be null.";
            throw new IllegalArgumentException(err);
        }
        XMLType result = null;
        String localName = typeName;
        String prefix = "";
        String ns = null;
        int colon = typeName.indexOf(58);
        if (colon >= 0) {
            localName = typeName.substring(colon + 1);
            prefix = typeName.substring(0, colon);
            ns = this._namespaces.getNamespaceURI(prefix);
            if (ns == null) {
                String err = "Schema#getType: ";
                err = err + "Namespace prefix not recognised '" + typeName + "'";
                throw new IllegalArgumentException(err);
            }
        }
        if (ns == null) {
            ns = this._namespaces.getNamespaceURI(prefix);
        }
        if (ns == null) {
            ns = this._targetNamespace;
        }
        if (localName.equals("anyType") && ns.equals(DEFAULT_SCHEMA_NS)) {
            result = new AnyType(this);
        }
        IllegalArgumentException exception = null;
        if (result == null) {
            try {
                result = this.getSimpleType(localName, ns);
            }
            catch (IllegalArgumentException iox) {
                exception = iox;
            }
        }
        if (result == null) {
            try {
                result = this.getComplexType(typeName);
            }
            catch (IllegalArgumentException iox) {
                exception = iox;
            }
        }
        if (result == null && exception != null) {
            throw exception;
        }
        return result;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setTargetNamespace(String targetNamespace) {
        if (targetNamespace != null && (targetNamespace = targetNamespace.trim()).length() == 0) {
            throw new IllegalStateException("an empty string is not a valid namespace.");
        }
        this._targetNamespace = targetNamespace;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    static SimpleTypesFactory getTypeFactory() {
        return simpleTypesFactory;
    }

    public short getStructureType() {
        return 19;
    }

    public void validate() throws ValidationException {
        XMLType type;
        Enumeration enumeration = this._complexTypes.elements();
        while (enumeration.hasMoreElements()) {
            type = (ComplexType)enumeration.nextElement();
            ((ComplexType)type).validate();
        }
        enumeration = this._simpleTypes.elements();
        while (enumeration.hasMoreElements()) {
            type = (SimpleType)enumeration.nextElement();
            ((SimpleType)type).validate();
        }
        enumeration = this._elements.elements();
        while (enumeration.hasMoreElements()) {
            ((ElementDecl)enumeration.nextElement()).validate();
        }
        enumeration = this._attributes.elements();
        while (enumeration.hasMoreElements()) {
            ((AttributeDecl)enumeration.nextElement()).validate();
        }
        enumeration = this._groups.elements();
        while (enumeration.hasMoreElements()) {
            ((Group)enumeration.nextElement()).validate();
        }
    }

    protected String getNamespacePrefix(String namespace) {
        return this._namespaces.getNamespacePrefix(namespace);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

