.\"
.\" accept/reject man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cupsaccept 8 "CUPS" "10 June 2014" "Apple Inc."
.SH NAME
cupsaccept/cupsreject \- accept/reject jobs sent to a destination
.SH SYNOPSIS
.B cupsaccept
[
.B \-E
] [
.B \-U
.I username
] [
.B \-h
.I hostname[:port]
]
.I destination(s)
.br
.B cupsreject
[
.B \-E
] [
.B \-U
.I username
] [
.B \-h
.I hostname[:port]
] [
.B \-r
.I reason
]
.I destination(s)
.SH DESCRIPTION
The
.B cupsaccept
command instructs the printing system to accept print jobs to the specified destinations.
.LP
The
.B cupsreject
command instructs the printing system to reject print jobs to the
specified destinations.
The \fI-r\fR option sets the reason for rejecting print jobs. If not specified, the reason defaults to "Reason Unknown".
.SH OPTIONS
The following options are supported by both
.B cupsaccept
and
.BR cupsreject :
.TP 5
.B \-E
Forces encryption when connecting to the server.
.TP 5
\fB-U \fIusername\fR
Sets the username that is sent when connecting to the server.
.TP 5
\fB-h \fIhostname[:port]\fR
Chooses an alternate server.
.TP 5
\fB-r \fR"\fIreason\fR"
Sets the reason string that is shown for a printer that is rejecting jobs.
.SH CONFORMING TO
The
.B cupsaccept
and
.B cupsreject
commands correspond to the System V printing system commands "accept" and "reject", respectively.
Unlike the System V printing system, CUPS allows printer names to contain any printable character except SPACE, TAB, "/", or "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
Finally, the CUPS versions may ask the user for an access password depending on the printing system configuration.
.SH SEE ALSO
.BR cancel (1),
.BR cupsenable (8),
.BR lp (1),
.BR lpadmin (8),
.BR lpstat (1),
.br
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2017 by Apple Inc.
