/*
 * FILE : swig_wrap.c
 *
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 *
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 *
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : TCL 8.0 */

#define INCLUDE_TCL    <tcl.h>
#define INCLUDE_TK     <tk.h>
#include INCLUDE_TCL
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
#define SWIGTCL8
/*
 * $Header: /b2/dmb/SWIG/SWIG1.0b3/swig_lib/tcl/RCS/swigtcl.cfg,v 1.1 1996/05/22 19:47:45 beazley Exp $
 *
 * swigtcl.cfg
 *
 * This file is modified from a platform independent file provided
 * by Sun.   With any luck this will allow SWIG generated wrapper
 * files to work on Unix, Windows, and Macintosh.
 *
 * Revision History
 * $Log: swigtcl.cfg,v $
 * Revision 1.1  1996/05/22 19:47:45  beazley
 * Initial revision
 *
 *
 * -- Dave Beazley, May 2, 1996.
 *
 *	This file is an example of a Tcl dynamically loadable extension.
 *
 * Copyright (c) 1996 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

/*
 *----------------------------------------------------------------------
 *
 * DllEntryPoint --
 *
 *	This wrapper function is used by Windows to invoke the
 *	initialization code for the DLL.  If we are compiling
 *	with Visual C++, this routine will be renamed to DllMain.
 *	routine.
 *
 * Results:
 *	Returns TRUE;
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

#ifdef __WIN32__
BOOL APIENTRY
DllEntryPoint(HINSTANCE hInst, DWORD reason, LPVOID reserved)
{
    return TRUE;
}
#endif

/**************************************************************************
 * $Header:$
 *
 * tcl8ptr.swg
 *
 * This file provides type-checked pointer support to Tcl 8.0.
 * Pointers are installed as new kinds of Tcl 8.0 objects consisting
 * of the following structure
 *
 * typedef struct {
 *         char     *name;            Name of the datatype
 *         void     *value;           Value of the pointer
 * } Tcl_SwigPtr;
 *
 * While we still need to perform string comparisons on the
 * type-name, this function no longer needs to convert pointer
 * values to hex so it should be a little faster.
 *
 * New Tcl datatypes are defined by the following data structure.
 *
 * typedef struct Tcl_ObjType {
 *              char *name;
 *              Tcl_FreeInternalRepProc *freeIntRepProc;
 *              Tcl_DupInternalRepProc *dupIntRepProc;
 *              Tcl_UpdateStringProc *updateStringProc;
 *              Tcl_SetFromAnyProc *setFromAnyProc;
 *             } Tcl_ObjType;
 *
 * Functions for manipulating SWIG pointers in wrapper code are:
 *
 *     void *SWIG_SetPointerObj(objPtr, ptr, type)
 *     char *SWIG_GetPointerFromObj(objPtr, *ptr, type)
 *
 **********************************************************************/

#ifdef SWIG_GLOBAL
#include <tcl.h>
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Array containing start locations (for searching) */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}


/*---------------------------------------------------------------------
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *))
 *
 * Register a new type-mapping with the type-checking system.
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(origtype);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(newtype);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}


/*---------------------------------------------------------------------
 * void SWIG_SetPointerObj(Tcl_Obj *objPtr, void *ptr, char *type)
 *
 * Sets a Tcl object to a pointer value.
 *           ptr = void pointer value
 *           type = string representing type
 *
 *---------------------------------------------------------------------*/



/* This is for backwards compatibility */



/*---------------------------------------------------------------------
 * char *SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *type)
 *
 * Attempts to extract a pointer value from our pointer type.
 * Upon failure, returns a string corresponding to the actual datatype.
 * Upon success, returns NULL and sets the pointer value in ptr.
 *---------------------------------------------------------------------*/



/*---------------------------------------------------------------------
 * void SWIG_RegisterType()
 *
 * Registers our new datatype with an interpreter.
 *---------------------------------------------------------------------*/

SWIGSTATIC
void SWIG_RegisterType() {
  /* Does nothing at the moment */
}
#define SWIG_init    Ibdm_Init
#define SWIG_name    "ibdm"
#define SWIG_prefix  ""
#define SWIG_namespace ""

#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int,Ibdm_Init)(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <inttypes.h>
#include <sstream>
#include "Fabric.h"
#include "SubnMgt.h"
#include "CredLoops.h"
#include "TraceRoute.h"
#include "TopoMatch.h"
#include "Congestion.h"

# if __WORDSIZE == 64
#  define __PRI64_PREFIX   "l"
#  define __PRIPTR_PREFIX  "l"
# else
#  define __PRI64_PREFIX   "ll"
#  define __PRIPTR_PREFIX
# endif
#ifndef PRIx64
# define PRIx64         __PRI64_PREFIX "x"
#endif

  /* GLOBALS */
  static char ibdm_tcl_error_msg[1024];
  static int  ibdm_tcl_error;
  static vector< IBFabric *> ibdm_fabrics;
  static IBLinkWidth UnknownLinkWidth = IB_UNKNOWN_LINK_WIDTH;
  static IBLinkSpeed UnknownLinkSpeed = IB_UNKNOWN_LINK_SPEED;
  static IBLinkWidth DefaultLinkWidth = IB_LINK_WIDTH_4X;
  static IBLinkSpeed DefaultLinkSpeed = IB_LINK_SPEED_2_5;

  /*
	  MAPPING IBDM OBJECTS TO TCL and BACK:
	  The idea is that we have specifc rules for naming
	  Node, Port, System and SystemPort for a specific Fabric.

	  All Fabrics are stored by id in a global vector.

	  So the object names will follow:
	  <type>:<fabricIdx>/<name>

  */

  /* Given a fabric pointer return its idx (starting w 1) or 0 */
  int ibdmGetFabricIdxByPtr(IBFabric *p_fabric) {
	 /* go over all fabrics and find it's index: */
	 for (unsigned int i = 0; i < ibdm_fabrics.size(); i++) {
		if (ibdm_fabrics[i] == p_fabric) {
		  return(i+1);
		}
	 }
	 return(0);
  }

  /* Given a fabric idx return it's pointer */
  /* Note the index is 1-N and thus we need to -1 it before access */
  IBFabric *ibdmGetFabricPtrByIdx(unsigned int idx) {
	 if ((idx > ibdm_fabrics.size()) || (idx < 1)) {
		return NULL;
	 }
	 return ibdm_fabrics[idx - 1];
  }

  /*
	 we provide our own constructor such that all IBFabrics are
	 registered in the global vector;
  */
  IBFabric *new_IBFabric(void) {
	 IBFabric *p_fabric = new IBFabric();
    unsigned int i;
	 if (p_fabric) {
      /* look for an open index in the vector of fabrics */
      for (i = 0; i < ibdm_fabrics.size(); i++)
      {
        if (ibdm_fabrics[i] == NULL)
        {
          ibdm_fabrics[i] = p_fabric;
          return p_fabric;
        }
      }
      ibdm_fabrics.push_back(p_fabric);
	 }
	 return p_fabric;
  }

  /*
	 we provide our own destructor such that the deleted fabric is
    de-registered from the global fabrics vector
  */
  void delete_IBFabric(IBFabric *p_fabric) {
    int idx = ibdmGetFabricIdxByPtr(p_fabric);
    if (! idx) {
      printf("ERROR: Fabric idx:%p does not exist in the global vector!\n",
             p_fabric);
    } else {
      ibdm_fabrics[idx-1] = NULL;
    }
    delete p_fabric;
  }

  /* Given the Object Pointer and Type provide it's TCL name */
  int ibdmGetObjTclNameByPtr(Tcl_Obj *objPtr, void *ptr, char *type) {
	 char tclName[128];
	 char name[128];
	 IBFabric *p_fabric;
	 string uiType;

	 if (!strcmp(type, "IBNode *")) {
		IBNode *p_node = (IBNode *)ptr;
		p_fabric = p_node->p_fabric;
		sprintf(name, ":%s", p_node->name.c_str());
		uiType = "node";
	 } else if (!strcmp(type, "IBPort *")) {
		IBPort *p_port = (IBPort *)ptr;
		sprintf(name,":%s/%u", p_port->p_node->name.c_str(), p_port->num);
		p_fabric = p_port->p_node->p_fabric;
		uiType = "port";
	 } else if (!strcmp(type, "IBSystem *")) {
		IBSystem *p_system = (IBSystem *)ptr;
		sprintf(name, ":%s", p_system->name.c_str());
		uiType = "system";
		p_fabric = p_system->p_fabric;
	 } else if (!strcmp(type, "IBSysPort *")) {
		IBSysPort *p_sysPort = (IBSysPort *)ptr;
		sprintf(name, ":%s:%s",  p_sysPort->p_system->name.c_str(),
				  p_sysPort->name.c_str());
		uiType = "sysport";
		p_fabric = p_sysPort->p_system->p_fabric;
	 } else if (!strcmp(type, "IBFabric *")) {
		p_fabric = (IBFabric *)ptr;
		uiType = "fabric";
		name[0] = '\0';
	 } else {
		sprintf(tclName, "-E- Unrecognized Object Type:%s", type);
		Tcl_SetStringObj(objPtr, tclName, -1);
		return TCL_ERROR;
	 }

	 /* get the fabric index */
	 int idx = ibdmGetFabricIdxByPtr(p_fabric);
	 if (idx == 0) {
		Tcl_SetStringObj(objPtr, "-E- Fail to find fabric by ptr", -1);
		return TCL_ERROR;
	 }

	 sprintf(tclName, "%s:%u%s", uiType.c_str(), idx, name);
	 Tcl_SetStringObj(objPtr, tclName, -1);
	 return TCL_OK;
  }

  /* Given the Object TCL Name Get it's pointer */
  int ibdmGetObjPtrByTclName(Tcl_Obj *objPtr, void **ptr) {
	 /* we need to parse the name and get the type etc. */
	 char buf[256];
	 char *type, *name=0, *fabIdxStr;
	 char *colonIdx, *slashIdx;
	 int fabricIdx;
	 *ptr = NULL;

	 strcpy(buf, Tcl_GetStringFromObj(objPtr,0));

	 /* the format is always: <type>:<idx>[:<name>] */

	 /* first separate the type */
	 colonIdx = index(buf,':');
	 if (!colonIdx) {
		printf("-E- Bad formatted (no :) ibdm object:%s\n", buf);
		return TCL_ERROR;
	 }
	 *colonIdx = '\0';

	 type = buf;
	 fabIdxStr = ++colonIdx;

	 /* now separate the fabric section if tyep is not fabric */
	 if (strcmp(type, "fabric")) {
		slashIdx = index(fabIdxStr,':');
		if (!slashIdx) {
		  printf( "-E- Bad formatted ibdm fabric object:%s\n",
					 Tcl_GetStringFromObj(objPtr,0));
		  return TCL_ERROR;
		}
		*slashIdx = '\0';
		name = ++slashIdx;
	 }

	 /* Ok so now get the fabic pointer */
	 fabricIdx = atoi(fabIdxStr);

	 IBFabric *p_fabric = ibdmGetFabricPtrByIdx(fabricIdx);
	 if (! p_fabric) {
		*ptr = NULL;
		return TCL_ERROR;
	 }

	 if (!strcmp(type, "fabric")) {
		*ptr = p_fabric;
	 } else if (!strcmp(type, "node")) {
		IBNode *p_node = p_fabric->getNode(string(name));
		if (! p_node) {
		  printf("-E- Fail to get node:%s\n", name);
		  return TCL_ERROR;
		}
		*ptr = p_node;
	 } else if (!strcmp(type, "port")) {
		slashIdx = rindex(name,'/');
		if (!slashIdx) {
		  printf("-E- Bad formatted ibdm node object:%s\n",
					Tcl_GetStringFromObj(objPtr,0));
		  return TCL_ERROR;
		}
		*slashIdx = '\0';
		int portNum = atoi(++slashIdx);
		IBNode *p_node = p_fabric->getNode(string(name));
		if (! p_node) {
		  printf("-E- Fail to get node:%s\n", name);
		  return TCL_ERROR;
		}
		IBPort *p_port = p_node->getPort(portNum);
		if (! p_port) {
		  printf("-E- Fail to get node:%s port:%u\n",
					 name, portNum);
		  return TCL_ERROR;
		}
		*ptr = p_port;
	 } else if (!strcmp(type, "system")) {
		IBSystem *p_system = p_fabric->getSystem(string(name));
		if (! p_system) {
		  printf("-E- Fail to get system:%s\n", name);
		  return TCL_ERROR;
		}
		*ptr = p_system;
	 } else if (!strcmp(type, "sysport")) {
		/* the format of system port is:  <type>:<idx>:<sys>:<port> */
		colonIdx = index(name,':');
		if (!colonIdx) {
		  printf("-E- Bad formatted ibdm sysport object:%s\n",
					Tcl_GetStringFromObj(objPtr,0) );
		  return TCL_ERROR;
		}
		*colonIdx = '\0';
		IBSystem *p_system = p_fabric->getSystem(string(name));
		if (! p_system) {
		  printf("-E- Fail to get system:%s\n", name);
		  return TCL_ERROR;
		}
		IBSysPort *p_sysPort = p_system->getSysPort(string(++colonIdx));
		if (! p_sysPort) {
		  printf("-E- Fail to get system:%s port:%s\n", name, colonIdx);
		  return TCL_ERROR;
		}
		*ptr = p_sysPort;
	 } else {
		printf("-E- Unrecognized Object Type:%s\n", type);
		return TCL_ERROR;
	 }
	 return TCL_OK;
  }

  int ibdmReportNonUpDownCa2CaPaths(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return( SubnReportNonUpDownCa2CaPaths(p_fabric, nodesRank));
  }

  int ibdmFatTreeRoute(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return( SubnMgtFatTreeRoute(p_fabric));
  }

  int ibdmCheckFabricMCGrpsForCreditLoopPotential(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return( SubnMgtCheckFabricMCGrpsForCreditLoopPotential(p_fabric, nodesRank));
  }

  int ibdmRankFabricByRoots(IBFabric *p_fabric, list_pnode rootNodes) {
    map_pnode_int nodesRank;
    if (SubnRankFabricNodesByRootNodes(p_fabric, rootNodes, nodesRank))
    {
      printf("-E- fail to rank the fabric by the given root nodes.\n");
      return(1);
    }
    return(0);
  }


#define new_string string

#define new_uint64_t uint64_t
static int  _wrap_const_IB_UNKNOWN_NODE_TYPE = IB_UNKNOWN_NODE_TYPE;
static int  _wrap_const_IB_CA_NODE = IB_CA_NODE;
static int  _wrap_const_IB_SW_NODE = IB_SW_NODE;
static int  _wrap_const_FABU_LOG_NONE = 0x0;
static int  _wrap_const_FABU_LOG_ERROR = 0x1;
static int  _wrap_const_FABU_LOG_INFO = 0x2;
static int  _wrap_const_FABU_LOG_VERBOSE = 0x4;

#define list_pnode_arg_name list_pnode

#define unsigned_int_arg_name unsigned int

#include "swig_alternate_mangling.cpp"
extern char * ibdmSourceVersion;

#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <inttypes.h>
#include <ibdm/Fabric.h>
#include <errno.h>
#include "sim.h"
#include "node.h"
#include "randmgr.h"

# if __WORDSIZE == 64
#  define __PRI64_PREFIX   "l"
#  define __PRIPTR_PREFIX  "l"
# else
#  define __PRI64_PREFIX   "ll"
#  define __PRIPTR_PREFIX
# endif
#ifndef PRIx64
# define PRIx64         __PRI64_PREFIX "x"
#endif

  /* GLOBALS */
  static char ibms_tcl_error_msg[1024];
  static int  ibms_tcl_error;

  static IBMgtSim Simulator;

  /*
     As we do not want to expose our own objects we
     rely on ibdm objects mapping. All IBMSNode calls are
     then mapped to their Nodes.
  */

  /* forward declarations for ibdm functions */
  int ibdmGetFabricIdxByPtr(IBFabric *p_fabric);
  IBFabric *ibdmGetFabricPtrByIdx(unsigned int idx);
  int ibdmGetObjTclNameByPtr(Tcl_Obj *objPtr, void *ptr, char *type);
  int ibdmGetObjPtrByTclName(Tcl_Obj *objPtr, void **ptr);

  /* Given the Object Pointer and Type provide it's TCL name */
  int ibmsGetSimNodeTclNameByPtr(Tcl_Obj *objPtr, void *ptr, char *type) {
	 char tclName[128];
	 char name[128];
	 IBFabric *p_fabric;
	 string uiType;

	 if (!strcmp(type, "IBMSNode *")) {
		IBNode *p_node = ((IBMSNode *)ptr)->getIBNode();
		p_fabric = p_node->p_fabric;
		sprintf(name, ":%s", p_node->name.c_str());
		uiType = "simnode";
	 } else {
		sprintf(tclName, "-E- Unrecognized Object Type:%s", type);
		Tcl_SetStringObj(objPtr, tclName, -1);
		return TCL_ERROR;
	 }

	 /* get the fabric index */
	 int idx = ibdmGetFabricIdxByPtr(p_fabric);
	 if (idx == 0) {
		Tcl_SetStringObj(objPtr, "-E- Fail to find fabric by ptr", -1);
		return TCL_ERROR;
	 }

	 sprintf(tclName, "%s:%u%s", uiType.c_str(), idx, name);
	 Tcl_SetStringObj(objPtr, tclName, -1);
	 return TCL_OK;
  }

  /* Given the Object TCL Name Get it's pointer */
  int ibmsGetSimNodePtrByTclName(Tcl_Obj *objPtr, void **ptr) {
	 /* we need to parse the name and get the type etc. */
	 char buf[256];
	 char *type, *name = 0, *fabIdxStr;
	 char *colonIdx, *slashIdx;
	 int fabricIdx;
	 *ptr = NULL;

	 strcpy(buf, Tcl_GetStringFromObj(objPtr,0));

	 /* the format is always: <type>:<idx>[:<name>] */

	 /* first separate the type */
	 colonIdx = index(buf,':');
	 if (!colonIdx) {
		printf("-E- Bad formatted (no :) ibdm object:%s\n", buf);
		return TCL_ERROR;
	 }
	 *colonIdx = '\0';

	 type = buf;
	 fabIdxStr = ++colonIdx;

	 /* now separate the fabric section if type is not fabric */
	 if (strcmp(type, "fabric")) {
		slashIdx = index(fabIdxStr,':');
		if (!slashIdx) {
		  printf( "-E- Bad formatted ibdm fabric object:%s\n",
					 Tcl_GetStringFromObj(objPtr,0));
		  return TCL_ERROR;
		}
		*slashIdx = '\0';
		name = ++slashIdx;
	 }

	 /* OK so now get the fabric pointer */
	 fabricIdx = atoi(fabIdxStr);

	 IBFabric *p_fabric = ibdmGetFabricPtrByIdx(fabricIdx);
	 if (! p_fabric) {
		*ptr = NULL;
		return TCL_ERROR;
	 }

    if (!strcmp(type, "simnode")) {
		IBNode *p_node = p_fabric->getNode(string(name));
      if (!p_node) {
		  printf("-E- Fail to get node:%s\n", name);
		  return TCL_ERROR;
		}
      IBMSNode *pSimNode = ibmsGetIBNodeSimNode(p_node);
		if (! pSimNode) {
		  printf("-E- Fail to get node:%s\n", name);
		  return TCL_ERROR;
		}
		*ptr = pSimNode;
	 } else {
		printf("-E- Unrecognized Object Type:%s\n", type);
		return TCL_ERROR;
	 }
	 return TCL_OK;
  }

#define uint8_array_t uint8_t

#define uint16_array_t uint16_t

#define uint32_array_t uint32_t

#define uint64_array_t uint64_t

#define ib_net16_array_t ib_net16_t

#define ib_net32_array_t ib_net32_t

#define ib_net64_array_t ib_net64_t


  /* for IB structs we use the format: <type>:<ptr> */

  /* Given the Object Pointer and Type provide it's TCL name */
  int ibmsGetIBStructObjNameByPtr(Tcl_Obj *objPtr, void *ptr, char *type) {
	 char tclName[128];
	 string uiType;
	 char name[128];

    /* check that the string starts with _ib_ and ends with _t_p */
    if (strncmp(type, "_ib_", 4)) {
		sprintf(tclName, "-E- Unrecognized Object Type:%s (should start with _ib_)", type);
		Tcl_SetStringObj(objPtr, tclName, -1);
		return TCL_ERROR;
	 }

    if (strncmp(type+strlen(type) - 4, "_t_p", 4)) {
		sprintf(tclName, "-E- Unrecognized Object Type:%s (should end with _t_p %s)",
              type, type+strlen(type) - 4);
		Tcl_SetStringObj(objPtr, tclName, -1);
		return TCL_ERROR;
	 }

    strncpy(name, type+4, strlen(type) - 8);
    name[strlen(type) - 8] = '\0';
    sprintf(tclName, "%s:%p", name, ptr);
    Tcl_SetStringObj(objPtr, tclName, -1);
    return TCL_OK;
  }

  /* Given the Object TCL Name Get it's pointer */
  int ibmsGetIBStructObjPtrByTclName(Tcl_Obj *objPtr, void **ptr) {
	 /* we need to parse the name and get the type etc. */
	 char *colonIdx;
	 *ptr = NULL;
    char buf[256];

	 strcpy(buf, Tcl_GetStringFromObj(objPtr,0));

	 /* the format is always: <type>:<idx>[:<name>] */

	 /* first separate the type */
	 colonIdx = index(buf,':');
	 if (!colonIdx) {
		printf("-E- Bad formatted (no :) ibdm object:%s\n", buf);
		return TCL_ERROR;
	 }
	 *colonIdx = '\0';
    colonIdx++;

    /* now all we need is to extract the pointer value from the
       rest of the string */
    if (sscanf(colonIdx,"%p", ptr) != 1) {
		printf("-E- Bad formatted pointer value:%s\n", colonIdx);
		return TCL_ERROR;
    }
	 return TCL_OK;
  }

#define uint8_array_t uint8_t

#define uint32_array_t uint32_t
static int  _wrap_const_MsgShowFatal = 0x01;
static int  _wrap_const_MsgShowError = 0x02;
static int  _wrap_const_MsgShowWarning = 0x04;
static int  _wrap_const_MsgShowInfo = 0x08;
static int  _wrap_const_MsgShowVerbose = 0x10;
static int  _wrap_const_MsgShowContext = 0x20;
static int  _wrap_const_MsgShowSource = 0x40;
static int  _wrap_const_MsgShowTime = 0x80;
static int  _wrap_const_MsgShowModule = 0x100;
static int  _wrap_const_MsgShowMads = 0x200;
static int  _wrap_const_MsgShowFrames = 0x400;
static int  _wrap_const_MsgShowAll = 0xffff;
static int  _wrap_const_MsgDefault = 0x62f;

static string MsgAllModules("");


  float rmRand() {
    return RandMgr()->random();
  }

  int rmSeed(int seed) {
    return RandMgr()->setRandomSeed(seed);
  }

  /* the following code will place the mad into the dispatcher */
  int
    send_mad(
      IBMSNode *pFromNode,
      uint8_t   fromPort,
      uint16_t  destLid,
      uint8_t   mgmt_class,
      uint8_t   method,
      uint16_t  attr,
      uint32_t  attr_mod,
      uint8_t  *data,
      size_t    size)
    {
      ibms_mad_msg_t msg;
      IBPort *pPort;
      static uint64_t tid = 19927;

      /* initialize the message address vector */
      msg.addr.sl = 0;
      msg.addr.pkey_index = 0;
      msg.addr.dlid = destLid;
      msg.addr.sqpn = 0;
      msg.addr.dqpn = 0;

      pPort = pFromNode->getIBNode()->getPort(fromPort);
      if (! pPort)
      {
        cout << "-E- Given port:" << fromPort << " is down." << endl;
        return 1;
      }
      msg.addr.slid = pPort->base_lid;

      /* initialize the mad header */
      msg.header.base_ver = 1;
      msg.header.mgmt_class = mgmt_class;
      msg.header.class_ver = 1;
      msg.header.method = method;
      msg.header.status = 0;
      msg.header.class_spec = 0;
      msg.header.trans_id = tid++;
      msg.header.attr_id = cl_hton16(attr);
      msg.header.attr_mod = cl_hton32(attr_mod);

      memcpy(msg.payload, data, size);
      IBMSDispatcher *pDispatcher = Simulator.getDispatcher();
      if (! pDispatcher )
        return TCL_ERROR;

      return pDispatcher->dispatchMad(pFromNode, fromPort, msg);
    }

  int send_sa_mad(
    IBMSNode *pFromNode,
    uint8_t   fromPort,
    uint16_t  destLid,
    uint8_t   mgmt_class,
    uint8_t   method,
    uint16_t  attr,
    uint64_t  comp_mask,
    uint8_t  *sa_data,
    size_t    sa_data_size)
    {
      ib_sa_mad_t mad = {0}; /* includes std header and rmpp header */

      mad.attr_offset = ib_get_attr_offset(sa_data_size);
      mad.comp_mask = cl_hton64(comp_mask);
      memcpy(mad.data, sa_data, sa_data_size);

      return send_mad(
        pFromNode,
        fromPort,
        destLid,
        mgmt_class,
        method,
        attr,
        0,
        &mad.rmpp_version,
        MAD_RMPP_DATA_SIZE + 12);
    }


#define madMcMemberRec ib_member_rec_t

#define madPathRec ib_path_rec_t

#define madGuidRec ib_guidinfo_record_t
#define guidRecGuidInfoBlock ib_guid_info_t

#define madServiceRec ib_service_record_t

#include <complib/cl_packon.h>
typedef struct _ib_mad_notice_attr128
{
  uint8_t	        generic_type;
  uint8_t		prod_type_msb;
  ib_net16_t	        prod_type_lsb;
  ib_net16_t	        trap_num;
  ib_net16_t		issuer_lid;
  ib_net16_t		toggle_count;
  ib_net16_t            sw_lid; // the sw lid of which link state changed - for 128 only
  ib_gid_t		issuer_gid;
}	PACK_SUFFIX ib_mad_notice_attr128_t;
#include <complib/cl_packoff.h>

#define madNotice128 ib_mad_notice_attr128_t

#include <complib/cl_packon.h>
typedef struct _ib_mad_notice_attr129
{
  uint8_t	        generic_type;
  uint8_t		prod_type_msb;
  ib_net16_t	        prod_type_lsb;
  ib_net16_t	        trap_num;
  ib_net16_t		issuer_lid;
  ib_net16_t		toggle_count;
  ib_net16_t            pad;      //129
  ib_net16_t            lid;	  // 129 lid and port number of the violation
  uint8_t               port_num; //129
  ib_gid_t		issuer_gid;
}	PACK_SUFFIX ib_mad_notice_attr129_t;
#include <complib/cl_packoff.h>

#define madNotice129 ib_mad_notice_attr129_t

#include <complib/cl_packon.h>
typedef struct _ib_mad_notice_attr144
{
  uint8_t	        generic_type;
  uint8_t		prod_type_msb;
  ib_net16_t	        prod_type_lsb;
  ib_net16_t	        trap_num;
  ib_net16_t		issuer_lid;
  ib_net16_t		toggle_count;
  ib_net16_t            pad1;         // 144
  ib_net16_t            lid;	      // 144 lid where capability mask changed
  ib_net16_t            pad2;         // 144
  ib_net32_t            new_cap_mask; // 144 new capability mask
  ib_gid_t		issuer_gid;
}	PACK_SUFFIX ib_mad_notice_attr144_t;
#include <complib/cl_packoff.h>

#define madNotice144 ib_mad_notice_attr144_t

#include <complib/cl_packon.h>
typedef struct _ib_generic_inform_info
{
	ib_gid_t			gid;
	ib_net16_t		lid_range_begin;
	ib_net16_t		lid_range_end;
	ib_net16_t		reserved1;
	uint8_t			is_generic;
	uint8_t			subscribe;
	ib_net16_t		trap_type;
	ib_net16_t		trap_num;
	ib_net32_t		qpn_resp_time_val;
	uint8_t        reserved2;
	uint8_t			node_type_msb;
	ib_net16_t		node_type_lsb;
}	PACK_SUFFIX ib_generic_inform_info_t;
#include <complib/cl_packoff.h>

#define madGenericInform ib_generic_inform_info_t
static int  _wrap_const_IB_INFORM_INFO_COMP_GID = 0x1;
static int  _wrap_const_IB_INFORM_INFO_COMP_LID_BEGIN = 0x2;
static int  _wrap_const_IB_INFORM_INFO_COMP_LID_END = 0x4;
static int  _wrap_const_IB_INFORM_INFO_COMP_IS_GENERIC = 0x10;
static int  _wrap_const_IB_INFORM_INFO_COMP_TRAP_TYPE = 0x40;
static int  _wrap_const_IB_INFORM_INFO_COMP_TRAP_NUM = 0x80;
static int  _wrap_const_IB_INFORM_INFO_COMP_QPN = 0x100;
static int  _wrap_const_IB_INFORM_INFO_COMP_RESP_TIME = 0x200;
static int  _wrap_const_IB_INFORM_INFO_COMP_NODE_TYPE = 0x800;

  void ibmssh_exit(ClientData clientData ) {

  }
extern char * ibmsSourceVersion;


/* A TCL_AppInit() function that lets you build a new copy
 * of tclsh.
 *
 * The macro SWIG_init contains the name of the initialization
 * function in the wrapper file.
 */

#ifndef SWIG_RcFileName
char *SWIG_RcFileName = "~/.myapprc";
#endif


#ifdef MAC_TCL
extern int		MacintoshInit _ANSI_ARGS_((void));
#endif

int Tcl_AppInit(Tcl_Interp *interp){

  if (Tcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;

  /* Now initialize our functions */

  if (SWIG_init(interp) == TCL_ERROR)
    return TCL_ERROR;
#if TCL_MAJOR_VERSION > 7 || TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION >= 5
   Tcl_SetVar(interp,"tcl_rcFileName",SWIG_RcFileName,TCL_GLOBAL_ONLY);
#else
   tcl_RcFileName = SWIG_RcFileName;
#endif
#ifdef SWIG_RcRsrcName
  Tcl_SetVar(interp,"tcl_rcRsrcName",SWIG_RcRsrcName,TCL_GLOBAL);
#endif

  return TCL_OK;
}

#if TCL_MAJOR_VERSION > 7 || TCL_MAJOR_VERSION == 7 && TCL_MINOR_VERSION >= 4
int main(int argc, char **argv) {
#ifdef MAC_TCL
    char *newArgv[2];

    if (MacintoshInit()  != TCL_OK) {
	Tcl_Exit(1);
    }

    argc = 1;
    newArgv[0] = "tclsh";
    newArgv[1] = NULL;
    argv = newArgv;
#endif

  Tcl_Main(argc, argv, Tcl_AppInit);
  return(0);

}
#else
extern int main();
#endif

static int _wrap_ibdmUseInternalLog(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmUseInternalLog ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmUseInternalLog();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmUseCoutLog(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmUseCoutLog ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmUseCoutLog();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmGetAndClearInternalLog(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmGetAndClearInternalLog ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (char *)ibdmGetAndClearInternalLog();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
delete [] _result;

    return TCL_OK;
}
static int _wrap_new_IBFabric(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBFabric ",-1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)new_IBFabric();
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
static int _wrap_delete_IBFabric(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBFabric p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBFabric(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_ibdmAssignLids(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    unsigned int  _arg1 = 0;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmAssignLids p_smNodePort ?lmc? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (objc >2) {
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtAssignLids(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCalcMinHopTables(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCalcMinHopTables p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtCalcMinHopTables(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCalcUpDnMinHopTbls(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCalcUpDnMinHopTbls p_fabric rootNodesNameRex ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtCalcUpDnMinHopTblsByRootNodesRex(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmOsmRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmOsmRoute p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtOsmRoute(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmEnhancedRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmEnhancedRoute p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtOsmEnhancedRoute(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFatTreeRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFatTreeRoute p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmFatTreeRoute(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFatTreeAnalysis(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFatTreeAnalysis p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )FatTreeAnalysis(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFatTreeRouteByPermutation(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    char * _arg2;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFatTreeRouteByPermutation p_fabric srcs dsts ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )FatTreeRouteByPermutation(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmVerifyCAtoCARoutes(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmVerifyCAtoCARoutes p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtVerifyAllCaToCaRoutes(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmVerifyAllPaths(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmVerifyAllPaths p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtVerifyAllRoutes(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmAnalyzeLoops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmAnalyzeLoops p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CrdLoopAnalyze(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmSetCreditLoopAnalysisMode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    int  _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmSetCreditLoopAnalysisMode include_switch_to_switch_paths include_multicast ",-1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[1],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg0 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )CredLoopMode(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmFindSymmetricalTreeRoots(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    list_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFindSymmetricalTreeRoots p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new list_pnode (SubnMgtFindTreeRootNodes(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
static int _wrap_ibdmFindRootNodesByMinHop(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    list_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmFindRootNodesByMinHop p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new list_pnode (SubnMgtFindRootNodesByMinHop(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
static int _wrap_ibdmRankFabricByRoots(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmRankFabricByRoots p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmRankFabricByRoots(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmReportNonUpDownCa2CaPaths(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmReportNonUpDownCa2CaPaths p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmReportNonUpDownCa2CaPaths(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmReportCA2CAPathsThroughSWPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmReportCA2CAPathsThroughSWPort p_port ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnReportCA2CAPathsThroughSWPort(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCheckMulticastGroups(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCheckMulticastGroups p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )SubnMgtCheckFabricMCGrps(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCheckFabricMCGrpsForCreditLoopPotential(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCheckFabricMCGrpsForCreditLoopPotential p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )ibdmCheckFabricMCGrpsForCreditLoopPotential(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmLinkCoverageAnalysis(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    list_pnode * _arg1;
    Tcl_Obj * tcl_result;
    list_pnode  tmpNodeList;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmLinkCoverageAnalysis p_fabric rootNodes ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
#if TCL_MINOR_VERSION > 3
  const char **sub_lists;
#else
  char **sub_lists;
#endif
  int num_sub_lists;
  int idx;

  /* we will use the TCL split list to split into elements */
  if (Tcl_SplitList(interp,
                    Tcl_GetStringFromObj(objv[2],0),
                    &num_sub_lists, &sub_lists) != TCL_OK) {
    printf("-E- Bad formatted list :%s\n",
           Tcl_GetStringFromObj(objv[2],0));
    return TCL_ERROR;
  }

  for (idx = 0; (idx < num_sub_lists); idx++)
  {
    /* we need to double copy since TCL 8.4 requires split res to be const */
    Tcl_Obj *p_tclObj;
    void *ptr;
    char buf[128];
    strcpy(buf, sub_lists[idx]);

    if (strncmp("node:", buf, 5)) {
      printf("-E- Bad formatted node (%u) object:%s\n", idx, buf);
      return TCL_ERROR;
    }

	 p_tclObj = Tcl_NewObj();
    Tcl_SetStringObj(p_tclObj, buf, -1);
    if (ibdmGetObjPtrByTclName(p_tclObj, &ptr) != TCL_OK) {
      printf("-E- fail to find ibdm obj by id:%s", buf );
      Tcl_DecrRefCount(p_tclObj);
      return TCL_ERROR;
    }
    Tcl_DecrRefCount(p_tclObj);
    tmpNodeList.push_back((IBNode *)ptr);
  }

  _arg1 = &tmpNodeList;
}
{
  ibdm_tcl_error = 0;
      _result = (int )LinkCoverageAnalysis(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmTraceDRPathRoute(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    list_int * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmTraceDRPathRoute p_smNodePort drPathPortNums ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_list_int_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of ibdmTraceDRPathRoute. Expected _list_int_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibdm_tcl_error = 0;
      _result = (int )TraceDRPathRoute(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmTraceRouteByMinHops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmTraceRouteByMinHops p_fabric slid dlid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )TraceRouteByMinHops(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmTraceRouteByLFT(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    unsigned_int_arg_name * _arg3;
    list_pnode_arg_name * _arg4;
    Tcl_Obj * tcl_result;
    int tempint;
    unsigned int  tmp;
    list_pnode  tmp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmTraceRouteByLFT p_fabric slid dlid hops p_nodesList ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
	_arg3 = &tmp;
}
{
	_arg4 = &tmp0;
}
{
  ibdm_tcl_error = 0;
      _result = (int )TraceRouteByLFT(_arg0,_arg1,_arg2,_arg3,_arg4);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
   char buf[16];
	sprintf(buf, "%u", tmp);
   Tcl_SetVar(interp, Tcl_GetString(objv[4]), buf, 0);
}
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _arg4->begin();
  Tcl_Obj *p_tclObj;
  Tcl_SetVar(interp, Tcl_GetString(objv[5]),"",0);
  while (I != _arg4->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_SetVar(interp, Tcl_GetString(objv[5]), buf,
					  TCL_LIST_ELEMENT|TCL_APPEND_VALUE);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
static int _wrap_ibdmMatchFabrics(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    IBFabric * _arg1;
    char * _arg2;
    int  _arg3;
    uint64_t * _arg4;
    char ** _arg5;
    char * p_c;
    Tcl_Obj * tcl_result;
    int templength;
    int tempint;
    uint64_t  temp;

    clientData = clientData; objv = objv;
{
  _arg5 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmMatchFabrics p_spec_fabric p_discovered_fabric anchorNodeName anchorPortNum anchorPortGuid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
{
  temp = strtoull(Tcl_GetStringFromObj(objv[5],NULL), NULL,16);
  _arg4 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )TopoMatchFabrics(_arg0,_arg1,_arg2,_arg3,*_arg4,_arg5);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (*_arg5) {
     Tcl_SetStringObj(tcl_result,*_arg5,strlen(*_arg5));
      free(*_arg5);
  } else {
     Tcl_SetStringObj(tcl_result,"",-1);
  }
}
    return TCL_OK;
}
static int _wrap_ibdmBuildMergedFabric(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    IBFabric * _arg1;
    IBFabric * _arg2;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmBuildMergedFabric p_spec_fabric p_discovered_fabric p_merged_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )TopoMergeDiscAndSpecFabrics(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmMatchFabricsFromEdge(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    IBFabric * _arg1;
    char ** _arg2;
    char * p_c;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
{
  _arg2 = &p_c;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmMatchFabricsFromEdge p_sFabric p_dFabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )TopoMatchFabricsFromEdge(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  if (*_arg2) {
     Tcl_SetStringObj(tcl_result,*_arg2,strlen(*_arg2));
      free(*_arg2);
  } else {
     Tcl_SetStringObj(tcl_result,"",-1);
  }
}
    return TCL_OK;
}
static int _wrap_ibdmCongInit(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongInit p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongInit(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongCleanup(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongCleanup p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongCleanup(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongClear(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongClear p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongZero(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongTrace(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    uint16_t * _arg1;
    uint16_t * _arg2;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongTrace p_fabric srcLid dstLid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongTrackPath(_arg0,*_arg1,*_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
static int _wrap_ibdmCongReport(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    ostringstream * _arg1;
    ostringstream  tempStream;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
{
  _arg1 = &tempStream;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongReport p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongReport(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result, (char*)_arg1->str().c_str(),
                   _arg1->str().size() + 1);
}
    return TCL_OK;
}
static int _wrap_ibdmCongDump(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    ostringstream * _arg1;
    ostringstream  tempStream;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
{
  _arg1 = &tempStream;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ibdmCongDump p_fabric ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )CongDump(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  Tcl_SetStringObj(tcl_result, (char*)_arg1->str().c_str(),
                   _arg1->str().size() + 1);
}
    return TCL_OK;
}
static int _wrap_rmRand(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    float  _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. rmRand ",-1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (float )rmRand();
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetDoubleObj(tcl_result,(double) _result);
    return TCL_OK;
}
static int _wrap_rmSeed(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    int  _arg0;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. rmSeed seed ",-1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[1],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg0 = (int ) tempint;
{
  ibms_tcl_error = 0;
      _result = (int )rmSeed(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_p_remotePort_set(_swigobj,_swigval) (_swigobj->p_remotePort = _swigval,_swigval)
static int _wrap_IBPort_p_remotePort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBPort * _arg0;
    IBPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_remotePort_set { IBPort * } { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBPort_p_remotePort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBPort_p_remotePort_get(_swigobj) ((IBPort *) _swigobj->p_remotePort)
static int _wrap_IBPort_p_remotePort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_remotePort_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBPort_p_remotePort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBPort_p_sysPort_set(_swigobj,_swigval) (_swigobj->p_sysPort = _swigval,_swigval)
static int _wrap_IBPort_p_sysPort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBPort * _arg0;
    IBSysPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_sysPort_set { IBPort * } { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBPort_p_sysPort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBPort_p_sysPort_get(_swigobj) ((IBSysPort *) _swigobj->p_sysPort)
static int _wrap_IBPort_p_sysPort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_sysPort_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBPort_p_sysPort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBPort_p_node_set(_swigobj,_swigval) (_swigobj->p_node = _swigval,_swigval)
static int _wrap_IBPort_p_node_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBPort * _arg0;
    IBNode * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_node_set { IBPort * } { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBPort_p_node_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBPort_p_node_get(_swigobj) ((IBNode *) _swigobj->p_node)
static int _wrap_IBPort_p_node_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_p_node_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBPort_p_node_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBPort_num_set(_swigobj,_swigval) (_swigobj->num = _swigval,_swigval)
static int _wrap_IBPort_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_num_set { IBPort * } { int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )IBPort_num_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_num_get(_swigobj) ((int ) _swigobj->num)
static int _wrap_IBPort_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_num_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBPort_num_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_base_lid_set(_swigobj,_swigval) (_swigobj->base_lid = _swigval,_swigval)
static int _wrap_IBPort_base_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_base_lid_set { IBPort * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_base_lid_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_base_lid_get(_swigobj) ((unsigned int ) _swigobj->base_lid)
static int _wrap_IBPort_base_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_base_lid_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_base_lid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_width_set(_swigobj,_swigval) (_swigobj->width = *(_swigval),_swigval)
static int _wrap_IBPort_width_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkWidth * _result;
    IBPort * _arg0;
    IBLinkWidth * _arg1;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_width_set { IBPort * } { IBLinkWidth * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[2],NULL));
  _arg1 = &temp1;
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkWidth *)IBPort_width_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,width2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_width_get(_swigobj) (&_swigobj->width)
static int _wrap_IBPort_width_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkWidth * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_width_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkWidth *)IBPort_width_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,width2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_speed_set(_swigobj,_swigval) (_swigobj->speed = *(_swigval),_swigval)
static int _wrap_IBPort_speed_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkSpeed * _result;
    IBPort * _arg0;
    IBLinkSpeed * _arg1;
    Tcl_Obj * tcl_result;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_speed_set { IBPort * } { IBLinkSpeed * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[2],NULL));
  _arg1 = &temp2;
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkSpeed *)IBPort_speed_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,speed2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_speed_get(_swigobj) (&_swigobj->speed)
static int _wrap_IBPort_speed_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBLinkSpeed * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_speed_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBLinkSpeed *)IBPort_speed_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_SetStringObj(tcl_result,speed2char(*_result), -1);
}
    return TCL_OK;
}
#define IBPort_counter1_set(_swigobj,_swigval) (_swigobj->counter1 = _swigval,_swigval)
static int _wrap_IBPort_counter1_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_counter1_set { IBPort * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_counter1_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBPort_counter1_get(_swigobj) ((unsigned int ) _swigobj->counter1)
static int _wrap_IBPort_counter1_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_counter1_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBPort_counter1_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define new_IBPort(_swigarg0,_swigarg1) (new IBPort(_swigarg0,_swigarg1))
static int _wrap_new_IBPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBPort p_nodePtr number ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)new_IBPort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBPort_guid_get(_swigobj)  (_swigobj->guid_get())
static int _wrap_IBPort_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_uint64_t * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_guid_get { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_uint64_t (IBPort_guid_get(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  /* new_uint64_t tcl8 out */
  sprintf(buff, "0x%016" PRIx64, *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
  delete _result;
}
    return TCL_OK;
}
#define IBPort_guid_set(_swigobj,_swigarg0)  (_swigobj->guid_set(_swigarg0))
static int _wrap_IBPort_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_guid_set { IBPort * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      IBPort_guid_set(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBPort_getName(_swigobj)  (_swigobj->getName())
static int _wrap_IBPort_getName(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_string * _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_getName { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_string (IBPort_getName(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
   delete _result;
}
    return TCL_OK;
}
#define IBPort_connect(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->connect(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBPort_connect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _arg0;
    IBPort * _arg1;
    IBLinkWidth * _arg2 = &DefaultLinkWidth;
    IBLinkSpeed * _arg3 = &DefaultLinkSpeed;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_connect { IBPort * } p_otherPort ?w? ?s? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (objc >3) {
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[3],NULL));
  _arg2 = &temp1;
}
    }
    if (objc >4) {
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[4],NULL));
  _arg3 = &temp2;
}
    }
{
  ibdm_tcl_error = 0;
      IBPort_connect(_arg0,_arg1,*_arg2,*_arg3);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBPort_disconnect(_swigobj)  (_swigobj->disconnect())
static int _wrap_IBPort_disconnect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBPort_disconnect { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBPort_disconnect(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBPortMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBPort methods : { dump cget configure guid_get guid_set getName connect disconnect  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBPort_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"guid_get") == 0) {
        cmd = _wrap_IBPort_guid_get;
    }    else if (strcmp(_str,"guid_set") == 0) {
        cmd = _wrap_IBPort_guid_set;
    }    else if (strcmp(_str,"getName") == 0) {
        cmd = _wrap_IBPort_getName;
    }    else if (strcmp(_str,"connect") == 0) {
        cmd = _wrap_IBPort_connect;
    }    else if (strcmp(_str,"disconnect") == 0) {
        cmd = _wrap_IBPort_disconnect;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-p_remotePort") == 0) {
                    cmd = _wrap_IBPort_p_remotePort_set;
                }  else if (strcmp(_str,"-p_sysPort") == 0) {
                    cmd = _wrap_IBPort_p_sysPort_set;
                }  else if (strcmp(_str,"-p_node") == 0) {
                    cmd = _wrap_IBPort_p_node_set;
                }  else if (strcmp(_str,"-num") == 0) {
                    cmd = _wrap_IBPort_num_set;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_IBPort_base_lid_set;
                }  else if (strcmp(_str,"-width") == 0) {
                    cmd = _wrap_IBPort_width_set;
                }  else if (strcmp(_str,"-speed") == 0) {
                    cmd = _wrap_IBPort_speed_set;
                }  else if (strcmp(_str,"-counter1") == 0) {
                    cmd = _wrap_IBPort_counter1_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-p_remotePort") == 0) {
                    cmd = _wrap_IBPort_p_remotePort_get;
                }  else if (strcmp(_str,"-p_sysPort") == 0) {
                    cmd = _wrap_IBPort_p_sysPort_get;
                }  else if (strcmp(_str,"-p_node") == 0) {
                    cmd = _wrap_IBPort_p_node_get;
                }  else if (strcmp(_str,"-num") == 0) {
                    cmd = _wrap_IBPort_num_get;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_IBPort_base_lid_get;
                }  else if (strcmp(_str,"-width") == 0) {
                    cmd = _wrap_IBPort_width_get;
                }  else if (strcmp(_str,"-speed") == 0) {
                    cmd = _wrap_IBPort_speed_get;
                }  else if (strcmp(_str,"-counter1") == 0) {
                    cmd = _wrap_IBPort_counter1_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBPort_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -p_remotePort -p_sysPort -p_node -num -base_lid -width -speed -counter1  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBPort_p_remotePort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_remotePort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_p_sysPort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_sysPort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_p_node_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_node ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_base_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-base_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_width_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-width ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_speed_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-speed ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBPort_counter1_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-counter1 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure guid_get guid_set getName connect disconnect }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBPortCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBPort * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBPort;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBPort;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBPort;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBPort;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBPort_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBPort_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBPort object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBPortMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBNode_name_set(_swigobj,_swigval) (_swigobj->name = *(_swigval),_swigval)
static int _wrap_IBNode_name_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_name_set { IBNode * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_name_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_name_get(_swigobj) (&_swigobj->name)
static int _wrap_IBNode_name_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_name_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_name_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static int _wrap_IBNode_type_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNodeType  _result;
    IBNode * _arg0;
    IBNodeType  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_type_set { IBNode * } { IBNodeType  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (IBNodeType ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBNodeType )IBNode_type_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_type_get(_swigobj) ((IBNodeType ) _swigobj->type)
static int _wrap_IBNode_type_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNodeType  _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_type_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBNodeType )IBNode_type_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_devId_set(_swigobj,_swigval) (_swigobj->devId = *(_swigval),_swigval)
static int _wrap_IBNode_devId_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_devId_set { IBNode * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_devId_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_devId_get(_swigobj) (&_swigobj->devId)
static int _wrap_IBNode_devId_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_devId_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_devId_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_revId_set(_swigobj,_swigval) (_swigobj->revId = *(_swigval),_swigval)
static int _wrap_IBNode_revId_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_revId_set { IBNode * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_revId_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_revId_get(_swigobj) (&_swigobj->revId)
static int _wrap_IBNode_revId_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_revId_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_revId_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_vendId_set(_swigobj,_swigval) (_swigobj->vendId = *(_swigval),_swigval)
static int _wrap_IBNode_vendId_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_vendId_set { IBNode * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_vendId_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_vendId_get(_swigobj) (&_swigobj->vendId)
static int _wrap_IBNode_vendId_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_vendId_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint32_t *)IBNode_vendId_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_attributes_set(_swigobj,_swigval) (_swigobj->attributes = *(_swigval),_swigval)
static int _wrap_IBNode_attributes_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_attributes_set { IBNode * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_attributes_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_attributes_get(_swigobj) (&_swigobj->attributes)
static int _wrap_IBNode_attributes_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_attributes_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBNode_attributes_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBNode_rank_set(_swigobj,_swigval) (_swigobj->rank = *(_swigval),_swigval)
static int _wrap_IBNode_rank_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    IBNode * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_rank_set { IBNode * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (uint8_t *)IBNode_rank_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_rank_get(_swigobj) (&_swigobj->rank)
static int _wrap_IBNode_rank_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_rank_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (uint8_t *)IBNode_rank_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define IBNode_p_system_get(_swigobj) ((IBSystem *) _swigobj->p_system)
static int _wrap_IBNode_p_system_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_p_system_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBNode_p_system_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBNode_p_fabric_get(_swigobj) ((IBFabric *) _swigobj->p_fabric)
static int _wrap_IBNode_p_fabric_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_p_fabric_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)IBNode_p_fabric_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
#define IBNode_numPorts_get(_swigobj) ((unsigned int ) _swigobj->numPorts)
static int _wrap_IBNode_numPorts_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_numPorts_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBNode_numPorts_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_Ports_get(_swigobj) (&_swigobj->Ports)
static int _wrap_IBNode_Ports_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_pport * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_Ports_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_pport *)IBNode_Ports_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_Obj *p_tclObj;

  for (unsigned int i = 0; i < _result->size(); i++) {
	 IBPort *p_port = (*_result)[i];
	 if (p_port) {
		p_tclObj = Tcl_NewObj();
		if (ibdmGetObjTclNameByPtr(p_tclObj, p_port, "IBPort *")
			 != TCL_OK) {
		  printf("-E- Fail to map Port Object (a Vector element)\n");
		} else {
		  Tcl_AppendElement(interp, Tcl_GetString(p_tclObj));
		}
		Tcl_DecrRefCount(p_tclObj);
	 }
  }
}
    return TCL_OK;
}
#define IBNode_MinHopsTable_get(_swigobj) (&_swigobj->MinHopsTable)
static int _wrap_IBNode_MinHopsTable_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_vec_byte * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_MinHopsTable_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_vec_byte *)IBNode_MinHopsTable_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  for (unsigned int i = 0; i < _result->size(); i++) {
	 Tcl_AppendResult(interp,"{", NULL);
	 for (unsigned int j = 0; j < (*_result)[i].size(); j++) {
		char buf[32];
		sprintf(buf,"%u ", (*_result)[i][j]);
		Tcl_AppendResult(interp, buf, NULL);
	 }
	 Tcl_AppendResult(interp,"} ", NULL);
  }
}
    return TCL_OK;
}
#define IBNode_LFT_get(_swigobj) (&_swigobj->LFT)
static int _wrap_IBNode_LFT_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_byte * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_LFT_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_byte *)IBNode_LFT_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  for (unsigned int i = 0; i < _result->size(); i++) {
	 char buf[32];
	 sprintf(buf,"%u ", (*_result)[i]);
	 Tcl_AppendResult(interp, buf, NULL);
  }
}
    return TCL_OK;
}
#define IBNode_guid_get(_swigobj)  (_swigobj->guid_get())
static int _wrap_IBNode_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_uint64_t * _result;
    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_guid_get { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_uint64_t (IBNode_guid_get(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  /* new_uint64_t tcl8 out */
  sprintf(buff, "0x%016" PRIx64, *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
  delete _result;
}
    return TCL_OK;
}
#define IBNode_guid_set(_swigobj,_swigarg0)  (_swigobj->guid_set(_swigarg0))
static int _wrap_IBNode_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_guid_set { IBNode * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      IBNode_guid_set(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define new_IBNode(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4) (new IBNode(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4))
static int _wrap_new_IBNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    string * _arg0;
    IBFabric * _arg1;
    IBSystem * _arg2;
    IBNodeType  _arg3;
    int  _arg4;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBNode n p_fab p_sys t np ",-1);
        return TCL_ERROR;
    }
{
  int len;
  static string _arg0_tmp;
  _arg0_tmp = string(Tcl_GetStringFromObj(objv[1],&len));
  _arg0 = &_arg0_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (IBNodeType ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[5],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg4 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)new_IBNode(*_arg0,_arg1,_arg2,_arg3,_arg4);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define delete_IBNode(_swigobj) (delete _swigobj)
static int _wrap_delete_IBNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBNode { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBNode(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBNode_makePort(_swigobj,_swigarg0)  (_swigobj->makePort(_swigarg0))
static int _wrap_IBNode_makePort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_makePort { IBNode * } num ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBNode_makePort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBNode_getPort(_swigobj,_swigarg0)  (_swigobj->getPort(_swigarg0))
static int _wrap_IBNode_getPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getPort { IBNode * } num ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBNode_getPort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBNode_setHops(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setHops(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBNode_setHops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    IBPort * _arg1;
    unsigned int  _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_setHops { IBNode * } p_port lid hops ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
{
  ibdm_tcl_error = 0;
      IBNode_setHops(_arg0,_arg1,_arg2,_arg3);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBNode_getHops(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getHops(_swigarg0,_swigarg1))
static int _wrap_IBNode_getHops(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBNode * _arg0;
    IBPort * _arg1;
    unsigned int  _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getHops { IBNode * } p_port lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )IBNode_getHops(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_getFirstMinHopPort(_swigobj,_swigarg0)  (_swigobj->getFirstMinHopPort(_swigarg0))
static int _wrap_IBNode_getFirstMinHopPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getFirstMinHopPort { IBNode * } lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBNode_getFirstMinHopPort(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBNode_setLFTPortForLid(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setLFTPortForLid(_swigarg0,_swigarg1))
static int _wrap_IBNode_setLFTPortForLid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_setLFTPortForLid { IBNode * } lid portNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      IBNode_setLFTPortForLid(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBNode_getLFTPortForLid(_swigobj,_swigarg0)  (_swigobj->getLFTPortForLid(_swigarg0))
static int _wrap_IBNode_getLFTPortForLid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBNode * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_getLFTPortForLid { IBNode * } lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (int )IBNode_getLFTPortForLid(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBNode_repHopTable(_swigobj)  (_swigobj->repHopTable())
static int _wrap_IBNode_repHopTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBNode_repHopTable { IBNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBNode ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBNode ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBNode  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      IBNode_repHopTable(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteIBNode(ClientData clientData) {
    delete_IBNode((IBNode *) clientData);
}

/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBNodeMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBNode methods : { dump cget configure guid_get guid_set makePort getPort setHops getHops getFirstMinHopPort setLFTPortForLid getLFTPortForLid repHopTable  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBNode_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"guid_get") == 0) {
        cmd = _wrap_IBNode_guid_get;
    }    else if (strcmp(_str,"guid_set") == 0) {
        cmd = _wrap_IBNode_guid_set;
    }    else if (strcmp(_str,"makePort") == 0) {
        cmd = _wrap_IBNode_makePort;
    }    else if (strcmp(_str,"getPort") == 0) {
        cmd = _wrap_IBNode_getPort;
    }    else if (strcmp(_str,"setHops") == 0) {
        cmd = _wrap_IBNode_setHops;
    }    else if (strcmp(_str,"getHops") == 0) {
        cmd = _wrap_IBNode_getHops;
    }    else if (strcmp(_str,"getFirstMinHopPort") == 0) {
        cmd = _wrap_IBNode_getFirstMinHopPort;
    }    else if (strcmp(_str,"setLFTPortForLid") == 0) {
        cmd = _wrap_IBNode_setLFTPortForLid;
    }    else if (strcmp(_str,"getLFTPortForLid") == 0) {
        cmd = _wrap_IBNode_getLFTPortForLid;
    }    else if (strcmp(_str,"repHopTable") == 0) {
        cmd = _wrap_IBNode_repHopTable;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBNode_name_set;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBNode_type_set;
                }  else if (strcmp(_str,"-devId") == 0) {
                    cmd = _wrap_IBNode_devId_set;
                }  else if (strcmp(_str,"-revId") == 0) {
                    cmd = _wrap_IBNode_revId_set;
                }  else if (strcmp(_str,"-vendId") == 0) {
                    cmd = _wrap_IBNode_vendId_set;
                }  else if (strcmp(_str,"-attributes") == 0) {
                    cmd = _wrap_IBNode_attributes_set;
                }  else if (strcmp(_str,"-rank") == 0) {
                    cmd = _wrap_IBNode_rank_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -name -type -devId -revId -vendId -attributes -rank  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -name -type -devId -revId -vendId -attributes -rank  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBNode_name_get;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBNode_type_get;
                }  else if (strcmp(_str,"-devId") == 0) {
                    cmd = _wrap_IBNode_devId_get;
                }  else if (strcmp(_str,"-revId") == 0) {
                    cmd = _wrap_IBNode_revId_get;
                }  else if (strcmp(_str,"-vendId") == 0) {
                    cmd = _wrap_IBNode_vendId_get;
                }  else if (strcmp(_str,"-attributes") == 0) {
                    cmd = _wrap_IBNode_attributes_get;
                }  else if (strcmp(_str,"-rank") == 0) {
                    cmd = _wrap_IBNode_rank_get;
                }  else if (strcmp(_str,"-p_system") == 0) {
                    cmd = _wrap_IBNode_p_system_get;
                }  else if (strcmp(_str,"-p_fabric") == 0) {
                    cmd = _wrap_IBNode_p_fabric_get;
                }  else if (strcmp(_str,"-numPorts") == 0) {
                    cmd = _wrap_IBNode_numPorts_get;
                }  else if (strcmp(_str,"-Ports") == 0) {
                    cmd = _wrap_IBNode_Ports_get;
                }  else if (strcmp(_str,"-MinHopsTable") == 0) {
                    cmd = _wrap_IBNode_MinHopsTable_get;
                }  else if (strcmp(_str,"-LFT") == 0) {
                    cmd = _wrap_IBNode_LFT_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBNode_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -name -type -devId -revId -vendId -attributes -rank -p_system -p_fabric -numPorts -Ports -MinHopsTable -LFT  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -name -type -devId -revId -vendId -attributes -rank -p_system -p_fabric -numPorts -Ports -MinHopsTable -LFT  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBNode_name_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-name ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_type_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-type ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_devId_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-devId ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_revId_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-revId ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_vendId_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vendId ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_attributes_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-attributes ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_rank_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-rank ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_p_system_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_system ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_p_fabric_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_fabric ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_numPorts_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-numPorts ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_Ports_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-Ports ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_MinHopsTable_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-MinHopsTable ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBNode_LFT_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-LFT ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure guid_get guid_set makePort getPort setHops getHops getFirstMinHopPort setLFTPortForLid getLFTPortForLid repHopTable }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBNodeCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBNode * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBNode;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBNode;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBNode;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBNode;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBNode_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = TclDeleteIBNode;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBNode_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBNode object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBNodeMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBSysPort_name_set(_swigobj,_swigval) (_swigobj->name = *(_swigval),_swigval)
static int _wrap_IBSysPort_name_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSysPort * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_name_set { IBSysPort * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSysPort_name_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSysPort_name_get(_swigobj) (&_swigobj->name)
static int _wrap_IBSysPort_name_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_name_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSysPort_name_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSysPort_p_remoteSysPort_set(_swigobj,_swigval) (_swigobj->p_remoteSysPort = _swigval,_swigval)
static int _wrap_IBSysPort_p_remoteSysPort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSysPort * _arg0;
    IBSysPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_remoteSysPort_set { IBSysPort * } { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSysPort_p_remoteSysPort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBSysPort_p_remoteSysPort_get(_swigobj) ((IBSysPort *) _swigobj->p_remoteSysPort)
static int _wrap_IBSysPort_p_remoteSysPort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_remoteSysPort_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSysPort_p_remoteSysPort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBSysPort_p_system_set(_swigobj,_swigval) (_swigobj->p_system = _swigval,_swigval)
static int _wrap_IBSysPort_p_system_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBSysPort * _arg0;
    IBSystem * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_system_set { IBSysPort * } { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBSysPort_p_system_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBSysPort_p_system_get(_swigobj) ((IBSystem *) _swigobj->p_system)
static int _wrap_IBSysPort_p_system_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_system_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBSysPort_p_system_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBSysPort_p_nodePort_set(_swigobj,_swigval) (_swigobj->p_nodePort = _swigval,_swigval)
static int _wrap_IBSysPort_p_nodePort_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBSysPort * _arg0;
    IBPort * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_nodePort_set { IBSysPort * } { IBPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBSysPort_p_nodePort_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBSysPort_p_nodePort_get(_swigobj) ((IBPort *) _swigobj->p_nodePort)
static int _wrap_IBSysPort_p_nodePort_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_p_nodePort_get { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBSysPort_p_nodePort_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define new_IBSysPort(_swigarg0,_swigarg1) (new IBSysPort(_swigarg0,_swigarg1))
static int _wrap_new_IBSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    string * _arg0;
    IBSystem * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBSysPort n p_sys ",-1);
        return TCL_ERROR;
    }
{
  int len;
  static string _arg0_tmp;
  _arg0_tmp = string(Tcl_GetStringFromObj(objv[1],&len));
  _arg0 = &_arg0_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)new_IBSysPort(*_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define delete_IBSysPort(_swigobj) (delete _swigobj)
static int _wrap_delete_IBSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBSysPort { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBSysPort(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSysPort_connect(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->connect(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBSysPort_connect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _arg0;
    IBSysPort * _arg1;
    IBLinkWidth * _arg2 = &UnknownLinkWidth;
    IBLinkSpeed * _arg3 = &UnknownLinkSpeed;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_connect { IBSysPort * } p_otherSysPort ?width? ?speed? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (objc >3) {
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[3],NULL));
  _arg2 = &temp1;
}
    }
    if (objc >4) {
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[4],NULL));
  _arg3 = &temp2;
}
    }
{
  ibdm_tcl_error = 0;
      IBSysPort_connect(_arg0,_arg1,*_arg2,*_arg3);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSysPort_disconnect(_swigobj)  (_swigobj->disconnect())
static int _wrap_IBSysPort_disconnect(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBSysPort * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSysPort_disconnect { IBSysPort * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSysPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSysPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSysPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSysPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSysPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBSysPort_disconnect(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteIBSysPort(ClientData clientData) {
    delete_IBSysPort((IBSysPort *) clientData);
}

/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBSysPortMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBSysPort methods : { dump cget configure connect disconnect  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBSysPort_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"connect") == 0) {
        cmd = _wrap_IBSysPort_connect;
    }    else if (strcmp(_str,"disconnect") == 0) {
        cmd = _wrap_IBSysPort_disconnect;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSysPort_name_set;
                }  else if (strcmp(_str,"-p_remoteSysPort") == 0) {
                    cmd = _wrap_IBSysPort_p_remoteSysPort_set;
                }  else if (strcmp(_str,"-p_system") == 0) {
                    cmd = _wrap_IBSysPort_p_system_set;
                }  else if (strcmp(_str,"-p_nodePort") == 0) {
                    cmd = _wrap_IBSysPort_p_nodePort_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -name -p_remoteSysPort -p_system -p_nodePort  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -name -p_remoteSysPort -p_system -p_nodePort  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSysPort_name_get;
                }  else if (strcmp(_str,"-p_remoteSysPort") == 0) {
                    cmd = _wrap_IBSysPort_p_remoteSysPort_get;
                }  else if (strcmp(_str,"-p_system") == 0) {
                    cmd = _wrap_IBSysPort_p_system_get;
                }  else if (strcmp(_str,"-p_nodePort") == 0) {
                    cmd = _wrap_IBSysPort_p_nodePort_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBSysPort_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -name -p_remoteSysPort -p_system -p_nodePort  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -name -p_remoteSysPort -p_system -p_nodePort  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBSysPort_name_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-name ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSysPort_p_remoteSysPort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_remoteSysPort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSysPort_p_system_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_system ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSysPort_p_nodePort_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_nodePort ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure connect disconnect }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBSysPortCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBSysPort * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBSysPort;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBSysPort;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBSysPort;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBSysPort;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBSysPort_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = TclDeleteIBSysPort;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBSysPort_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBSysPort object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBSysPortMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBSystem_name_set(_swigobj,_swigval) (_swigobj->name = *(_swigval),_swigval)
static int _wrap_IBSystem_name_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_name_set { IBSystem * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_name_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_name_get(_swigobj) (&_swigobj->name)
static int _wrap_IBSystem_name_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_name_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_name_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_type_set(_swigobj,_swigval) (_swigobj->type = *(_swigval),_swigval)
static int _wrap_IBSystem_type_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_type_set { IBSystem * } { string * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_type_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_type_get(_swigobj) (&_swigobj->type)
static int _wrap_IBSystem_type_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_type_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (string *)IBSystem_type_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define IBSystem_p_fabric_set(_swigobj,_swigval) (_swigobj->p_fabric = _swigval,_swigval)
static int _wrap_IBSystem_p_fabric_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    IBSystem * _arg0;
    IBFabric * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_p_fabric_set { IBSystem * } { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)IBSystem_p_fabric_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
#define IBSystem_p_fabric_get(_swigobj) ((IBFabric *) _swigobj->p_fabric)
static int _wrap_IBSystem_p_fabric_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_p_fabric_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (IBFabric *)IBSystem_p_fabric_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
#define IBSystem_NodeByName_get(_swigobj) (&_swigobj->NodeByName)
static int _wrap_IBSystem_NodeByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_pnode * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_NodeByName_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_pnode *)IBSystem_NodeByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBSystem_PortByName_get(_swigobj) (&_swigobj->PortByName)
static int _wrap_IBSystem_PortByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_psysport * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_PortByName_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_psysport *)IBSystem_PortByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_psysport::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBSysPort *") != TCL_OK) {
		printf("-E- Fail to map SysPort Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define new_IBSystem(_swigarg0,_swigarg1,_swigarg2) (new IBSystem(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_new_IBSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    string * _arg0;
    IBFabric * _arg1;
    string * _arg2;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_IBSystem n p_fab t ",-1);
        return TCL_ERROR;
    }
{
  int len;
  static string _arg0_tmp;
  _arg0_tmp = string(Tcl_GetStringFromObj(objv[1],&len));
  _arg0 = &_arg0_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[2], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[2]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg1 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[2],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg2_tmp;
  _arg2_tmp = string(Tcl_GetStringFromObj(objv[3],&len));
  _arg2 = &_arg2_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)new_IBSystem(*_arg0,_arg1,*_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define delete_IBSystem(_swigobj) (delete _swigobj)
static int _wrap_delete_IBSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_IBSystem { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      delete_IBSystem(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSystem_guid_get(_swigobj)  (_swigobj->guid_get())
static int _wrap_IBSystem_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    new_uint64_t * _result;
    IBSystem * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_guid_get { IBSystem * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = new new_uint64_t (IBSystem_guid_get(_arg0));
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  /* new_uint64_t tcl8 out */
  sprintf(buff, "0x%016" PRIx64, *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
  delete _result;
}
    return TCL_OK;
}
#define IBSystem_guid_set(_swigobj,_swigarg0)  (_swigobj->guid_set(_swigarg0))
static int _wrap_IBSystem_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_guid_set { IBSystem * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      IBSystem_guid_set(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBSystem_makeSysPort(_swigobj,_swigarg0)  (_swigobj->makeSysPort(_swigarg0))
static int _wrap_IBSystem_makeSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_makeSysPort { IBSystem * } pName ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSystem_makeSysPort(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
#define IBSystem_getSysPortNodePortByName(_swigobj,_swigarg0)  (_swigobj->getSysPortNodePortByName(_swigarg0))
static int _wrap_IBSystem_getSysPortNodePortByName(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_getSysPortNodePortByName { IBSystem * } sysPortName ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBSystem_getSysPortNodePortByName(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBSystem_getSysPort(_swigobj,_swigarg0)  (_swigobj->getSysPort(_swigarg0))
static int _wrap_IBSystem_getSysPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSysPort * _result;
    IBSystem * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBSystem_getSysPort { IBSystem * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSysPort *)IBSystem_getSysPort(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSysPort *");
}
    return TCL_OK;
}
/* delcmd.swg : Tcl object deletion method */

static void TclDeleteIBSystem(ClientData clientData) {
    delete_IBSystem((IBSystem *) clientData);
}

/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBSystemMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBSystem methods : { dump cget configure guid_get guid_set makeSysPort getSysPortNodePortByName getSysPort  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBSystem_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"guid_get") == 0) {
        cmd = _wrap_IBSystem_guid_get;
    }    else if (strcmp(_str,"guid_set") == 0) {
        cmd = _wrap_IBSystem_guid_set;
    }    else if (strcmp(_str,"makeSysPort") == 0) {
        cmd = _wrap_IBSystem_makeSysPort;
    }    else if (strcmp(_str,"getSysPortNodePortByName") == 0) {
        cmd = _wrap_IBSystem_getSysPortNodePortByName;
    }    else if (strcmp(_str,"getSysPort") == 0) {
        cmd = _wrap_IBSystem_getSysPort;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSystem_name_set;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBSystem_type_set;
                }  else if (strcmp(_str,"-p_fabric") == 0) {
                    cmd = _wrap_IBSystem_p_fabric_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -name -type -p_fabric  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -name -type -p_fabric  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-name") == 0) {
                    cmd = _wrap_IBSystem_name_get;
                }  else if (strcmp(_str,"-type") == 0) {
                    cmd = _wrap_IBSystem_type_get;
                }  else if (strcmp(_str,"-p_fabric") == 0) {
                    cmd = _wrap_IBSystem_p_fabric_get;
                }  else if (strcmp(_str,"-NodeByName") == 0) {
                    cmd = _wrap_IBSystem_NodeByName_get;
                }  else if (strcmp(_str,"-PortByName") == 0) {
                    cmd = _wrap_IBSystem_PortByName_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBSystem_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -name -type -p_fabric -NodeByName -PortByName  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -name -type -p_fabric -NodeByName -PortByName  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBSystem_name_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-name ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_type_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-type ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_p_fabric_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_fabric ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_NodeByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-NodeByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBSystem_PortByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-PortByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure guid_get guid_set makeSysPort getSysPortNodePortByName getSysPort }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBSystemCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBSystem * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = _wrap_new_IBSystem;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = _wrap_new_IBSystem;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = _wrap_new_IBSystem;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = _wrap_new_IBSystem;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBSystem_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = TclDeleteIBSystem;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBSystem_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBSystem object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBSystemMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBFabric_NodeByName_get(_swigobj) (&_swigobj->NodeByName)
static int _wrap_IBFabric_NodeByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_NodeByName_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_pnode *)IBFabric_NodeByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_SystemByName_get(_swigobj) (&_swigobj->SystemByName)
static int _wrap_IBFabric_SystemByName_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_str_psys * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_SystemByName_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_str_psys *)IBFabric_SystemByName_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_str_psys::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBSystem *") != TCL_OK) {
		printf("-E- Fail to map System Object (a Vector element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s %s", (*I).first.c_str(), Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_PortByLid_get(_swigobj) (&_swigobj->PortByLid)
static int _wrap_IBFabric_PortByLid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    vec_pport * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_PortByLid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (vec_pport *)IBFabric_PortByLid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  Tcl_Obj *p_tclObj;

  for (unsigned int i = 0; i < _result->size(); i++) {
	 IBPort *p_port = (*_result)[i];
	 if (p_port) {
		p_tclObj = Tcl_NewObj();
		if (ibdmGetObjTclNameByPtr(p_tclObj, p_port, "IBPort *")
			 != TCL_OK) {
		  printf("-E- Fail to map Port Object (a Vector element)\n");
		} else {
		  Tcl_AppendElement(interp, Tcl_GetString(p_tclObj));
		}
		Tcl_DecrRefCount(p_tclObj);
	 }
  }
}
    return TCL_OK;
}
#define IBFabric_NodeByGuid_get(_swigobj) (&_swigobj->NodeByGuid)
static int _wrap_IBFabric_NodeByGuid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_guid_pnode * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_NodeByGuid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_guid_pnode *)IBFabric_NodeByGuid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_guid_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "0x%016" PRIx64 " %s",
              (*I).first, Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_SystemByGuid_get(_swigobj) (&_swigobj->SystemByGuid)
static int _wrap_IBFabric_SystemByGuid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_guid_psys * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_SystemByGuid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_guid_psys *)IBFabric_SystemByGuid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_guid_psys::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBSystem *") != TCL_OK) {
		printf("-E- Fail to map System Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "0x%016" PRIx64 " %s",
              (*I).first, Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_PortByGuid_get(_swigobj) (&_swigobj->PortByGuid)
static int _wrap_IBFabric_PortByGuid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    map_guid_pport * _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_PortByGuid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (map_guid_pport *)IBFabric_PortByGuid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  map_guid_pport::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I).second, "IBPort *") != TCL_OK) {
		printf("-E- Fail to map Port Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "0x%016" PRIx64 " %s",
              (*I).first, Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_minLid_set(_swigobj,_swigval) (_swigobj->minLid = _swigval,_swigval)
static int _wrap_IBFabric_minLid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_minLid_set { IBFabric * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_minLid_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_minLid_get(_swigobj) ((unsigned int ) _swigobj->minLid)
static int _wrap_IBFabric_minLid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_minLid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_minLid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_maxLid_set(_swigobj,_swigval) (_swigobj->maxLid = _swigval,_swigval)
static int _wrap_IBFabric_maxLid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_maxLid_set { IBFabric * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_maxLid_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_maxLid_get(_swigobj) ((unsigned int ) _swigobj->maxLid)
static int _wrap_IBFabric_maxLid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_maxLid_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_maxLid_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_lmc_set(_swigobj,_swigval) (_swigobj->lmc = _swigval,_swigval)
static int _wrap_IBFabric_lmc_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_lmc_set { IBFabric * } { unsigned int  } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_lmc_set(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_lmc_get(_swigobj) ((unsigned int ) _swigobj->lmc)
static int _wrap_IBFabric_lmc_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    unsigned int  _result;
    IBFabric * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_lmc_get { IBFabric * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      _result = (unsigned int )IBFabric_lmc_get(_arg0);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_makeNode(_swigobj,_swigarg0,_swigarg1,_swigarg2,_swigarg3)  (_swigobj->makeNode(_swigarg0,_swigarg1,_swigarg2,_swigarg3))
static int _wrap_IBFabric_makeNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBFabric * _arg0;
    string * _arg1;
    IBSystem * _arg2;
    IBNodeType  _arg3;
    unsigned int  _arg4;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 6) || (objc > 6)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_makeNode { IBFabric * } n p_sys type numPorts ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBSystem *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBSystem ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBSystem ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBSystem  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBSystem ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (IBNodeType ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[5],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg4 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBFabric_makeNode(_arg0,*_arg1,_arg2,_arg3,_arg4);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBFabric_getNode(_swigobj,_swigarg0)  (_swigobj->getNode(_swigarg0))
static int _wrap_IBFabric_getNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getNode { IBFabric * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBFabric_getNode(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBFabric_getNodesByType(_swigobj,_swigarg0)  (_swigobj->getNodesByType(_swigarg0))
static int _wrap_IBFabric_getNodesByType(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    list_pnode * _result;
    IBFabric * _arg0;
    IBNodeType  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getNodesByType { IBFabric * } type ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (IBNodeType ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (list_pnode *)IBFabric_getNodesByType(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  // build a TCL list out of the Objec ID's of the ibdm objects in it.
  list_pnode::const_iterator I = _result->begin();
  Tcl_Obj *p_tclObj;

  while (I != _result->end()) {
	 p_tclObj = Tcl_NewObj();
	 if (ibdmGetObjTclNameByPtr(p_tclObj, (*I), "IBNode *") != TCL_OK) {
		printf("-E- Fail to map Node Object (a guid map element)\n");
	 } else {
		char buf[128];
		sprintf(buf, "%s", Tcl_GetString(p_tclObj));
		Tcl_AppendElement(interp, buf);
	 }
	 Tcl_DecrRefCount(p_tclObj);
	 I++;
  }
}
    return TCL_OK;
}
#define IBFabric_makeGenericSystem(_swigobj,_swigarg0)  (_swigobj->makeGenericSystem(_swigarg0))
static int _wrap_IBFabric_makeGenericSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_makeGenericSystem { IBFabric * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_makeGenericSystem(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_makeSystem(_swigobj,_swigarg0,_swigarg1)  (_swigobj->makeSystem(_swigarg0,_swigarg1))
static int _wrap_IBFabric_makeSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    string * _arg1;
    string * _arg2;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_makeSystem { IBFabric * } name type ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  int len;
  static string _arg2_tmp;
  _arg2_tmp = string(Tcl_GetStringFromObj(objv[3],&len));
  _arg2 = &_arg2_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_makeSystem(_arg0,*_arg1,*_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_getSystem(_swigobj,_swigarg0)  (_swigobj->getSystem(_swigarg0))
static int _wrap_IBFabric_getSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getSystem { IBFabric * } name ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_getSystem(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_getSystemByGuid(_swigobj,_swigarg0)  (_swigobj->getSystemByGuid(_swigarg0))
static int _wrap_IBFabric_getSystemByGuid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBSystem * _result;
    IBFabric * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getSystemByGuid { IBFabric * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBSystem *)IBFabric_getSystemByGuid(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBSystem *");
}
    return TCL_OK;
}
#define IBFabric_getNodeByGuid(_swigobj,_swigarg0)  (_swigobj->getNodeByGuid(_swigarg0))
static int _wrap_IBFabric_getNodeByGuid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBFabric * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getNodeByGuid { IBFabric * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBNode *)IBFabric_getNodeByGuid(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBFabric_getPortByGuid(_swigobj,_swigarg0)  (_swigobj->getPortByGuid(_swigarg0))
static int _wrap_IBFabric_getPortByGuid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBFabric * _arg0;
    uint64_t * _arg1;
    Tcl_Obj * tcl_result;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getPortByGuid { IBFabric * } guid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL,16);
  _arg1 = &temp;
}
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBFabric_getPortByGuid(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBFabric_addCable(_swigobj,_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7)  (_swigobj->addCable(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7))
static int _wrap_IBFabric_addCable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _arg0;
    string * _arg1;
    string * _arg2;
    string * _arg3;
    string * _arg4;
    string * _arg5;
    string * _arg6;
    IBLinkWidth * _arg7 = &DefaultLinkWidth;
    IBLinkSpeed * _arg8 = &DefaultLinkSpeed;
    Tcl_Obj * tcl_result;
    IBLinkWidth  temp1;
    IBLinkSpeed  temp2;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 8) || (objc > 10)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_addCable { IBFabric * } t1 n1 p1 t2 n2 p2 ?width? ?speed? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  int len;
  static string _arg2_tmp;
  _arg2_tmp = string(Tcl_GetStringFromObj(objv[3],&len));
  _arg2 = &_arg2_tmp;
}
{
  int len;
  static string _arg3_tmp;
  _arg3_tmp = string(Tcl_GetStringFromObj(objv[4],&len));
  _arg3 = &_arg3_tmp;
}
{
  int len;
  static string _arg4_tmp;
  _arg4_tmp = string(Tcl_GetStringFromObj(objv[5],&len));
  _arg4 = &_arg4_tmp;
}
{
  int len;
  static string _arg5_tmp;
  _arg5_tmp = string(Tcl_GetStringFromObj(objv[6],&len));
  _arg5 = &_arg5_tmp;
}
{
  int len;
  static string _arg6_tmp;
  _arg6_tmp = string(Tcl_GetStringFromObj(objv[7],&len));
  _arg6 = &_arg6_tmp;
}
    if (objc >8) {
{
  temp1 = char2width(Tcl_GetStringFromObj(objv[8],NULL));
  _arg7 = &temp1;
}
    }
    if (objc >9) {
{
  temp2 = char2speed(Tcl_GetStringFromObj(objv[9],NULL));
  _arg8 = &temp2;
}
    }
{
  ibdm_tcl_error = 0;
      IBFabric_addCable(_arg0,*_arg1,*_arg2,*_arg3,*_arg4,*_arg5,*_arg6,*_arg7,*_arg8);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBFabric_parseCables(_swigobj,_swigarg0)  (_swigobj->parseCables(_swigarg0))
static int _wrap_IBFabric_parseCables(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseCables { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseCables(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseTopology(_swigobj,_swigarg0)  (_swigobj->parseTopology(_swigarg0))
static int _wrap_IBFabric_parseTopology(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseTopology { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseTopology(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_addLink(_swigobj,_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7,_swigarg8,_swigarg9,_swigarg10,_swigarg11,_swigarg12,_swigarg13,_swigarg14,_swigarg15,_swigarg16,_swigarg17,_swigarg18,_swigarg19,_swigarg20,_swigarg21,_swigarg22,_swigarg23,_swigarg24,_swigarg25)  (_swigobj->addLink(_swigarg0,_swigarg1,_swigarg2,_swigarg3,_swigarg4,_swigarg5,_swigarg6,_swigarg7,_swigarg8,_swigarg9,_swigarg10,_swigarg11,_swigarg12,_swigarg13,_swigarg14,_swigarg15,_swigarg16,_swigarg17,_swigarg18,_swigarg19,_swigarg20,_swigarg21,_swigarg22,_swigarg23,_swigarg24,_swigarg25))
static int _wrap_IBFabric_addLink(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    int  _arg2;
    uint64_t * _arg3;
    uint64_t * _arg4;
    uint64_t * _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    string * _arg9;
    int  _arg10;
    int  _arg11;
    int  _arg12;
    string * _arg13;
    int  _arg14;
    uint64_t * _arg15;
    uint64_t * _arg16;
    uint64_t * _arg17;
    int  _arg18;
    int  _arg19;
    int  _arg20;
    string * _arg21;
    int  _arg22;
    int  _arg23;
    int  _arg24;
    IBLinkWidth * _arg25 = &DefaultLinkWidth;
    IBLinkSpeed * _arg26 = &DefaultLinkSpeed;
    Tcl_Obj * tcl_result;
    int tempint;
    uint64_t  temp;
    uint64_t  temp0;
    uint64_t  temp1;
    uint64_t  temp2;
    uint64_t  temp3;
    uint64_t  temp4;
    IBLinkWidth  temp10;
    IBLinkSpeed  temp20;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 26) || (objc > 28)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_addLink { IBFabric * } type1 numPorts1 sysGuid1 nodeGuid1 portGuid1 vend1 devId1 rev1 desc1 hcaIdx1 lid1 portNum1 type2 numPorts2 sysGuid2 nodeGuid2 portGuid2 vend2 devId2 rev2 desc2 hcaIdx2 lid2 portNum2 ?width? ?speed? ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
{
  temp = strtoull(Tcl_GetStringFromObj(objv[4],NULL), NULL,16);
  _arg3 = &temp;
}
{
  temp0 = strtoull(Tcl_GetStringFromObj(objv[5],NULL), NULL,16);
  _arg4 = &temp0;
}
{
  temp1 = strtoull(Tcl_GetStringFromObj(objv[6],NULL), NULL,16);
  _arg5 = &temp1;
}
    if (Tcl_GetIntFromObj(interp,objv[7],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg6 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[8],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg7 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[9],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg8 = (int ) tempint;
{
  int len;
  static string _arg9_tmp;
  _arg9_tmp = string(Tcl_GetStringFromObj(objv[10],&len));
  _arg9 = &_arg9_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[11],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg10 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[12],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg11 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[13],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg12 = (int ) tempint;
{
  int len;
  static string _arg13_tmp;
  _arg13_tmp = string(Tcl_GetStringFromObj(objv[14],&len));
  _arg13 = &_arg13_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[15],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg14 = (int ) tempint;
{
  temp2 = strtoull(Tcl_GetStringFromObj(objv[16],NULL), NULL,16);
  _arg15 = &temp2;
}
{
  temp3 = strtoull(Tcl_GetStringFromObj(objv[17],NULL), NULL,16);
  _arg16 = &temp3;
}
{
  temp4 = strtoull(Tcl_GetStringFromObj(objv[18],NULL), NULL,16);
  _arg17 = &temp4;
}
    if (Tcl_GetIntFromObj(interp,objv[19],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg18 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[20],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg19 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[21],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg20 = (int ) tempint;
{
  int len;
  static string _arg21_tmp;
  _arg21_tmp = string(Tcl_GetStringFromObj(objv[22],&len));
  _arg21 = &_arg21_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[23],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg22 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[24],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg23 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[25],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg24 = (int ) tempint;
    if (objc >26) {
{
  temp10 = char2width(Tcl_GetStringFromObj(objv[26],NULL));
  _arg25 = &temp10;
}
    }
    if (objc >27) {
{
  temp20 = char2speed(Tcl_GetStringFromObj(objv[27],NULL));
  _arg26 = &temp20;
}
    }
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_addLink(_arg0,*_arg1,_arg2,*_arg3,*_arg4,*_arg5,_arg6,_arg7,_arg8,*_arg9,_arg10,_arg11,_arg12,*_arg13,_arg14,*_arg15,*_arg16,*_arg17,_arg18,_arg19,_arg20,*_arg21,_arg22,_arg23,_arg24,*_arg25,*_arg26);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseSubnetLinks(_swigobj,_swigarg0)  (_swigobj->parseSubnetLinks(_swigarg0))
static int _wrap_IBFabric_parseSubnetLinks(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseSubnetLinks { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseSubnetLinks(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseFdbFile(_swigobj,_swigarg0)  (_swigobj->parseFdbFile(_swigarg0))
static int _wrap_IBFabric_parseFdbFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseFdbFile { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseFdbFile(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseMCFdbFile(_swigobj,_swigarg0)  (_swigobj->parseMCFdbFile(_swigarg0))
static int _wrap_IBFabric_parseMCFdbFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseMCFdbFile { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseMCFdbFile(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parsePSLFile(_swigobj,_swigarg0)  (_swigobj->parsePSLFile(_swigarg0))
static int _wrap_IBFabric_parsePSLFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parsePSLFile { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parsePSLFile(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_parseSLVLFile(_swigobj,_swigarg0)  (_swigobj->parseSLVLFile(_swigarg0))
static int _wrap_IBFabric_parseSLVLFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    string * _arg1;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_parseSLVLFile { IBFabric * } fn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_parseSLVLFile(_arg0,*_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_setLidPort(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setLidPort(_swigarg0,_swigarg1))
static int _wrap_IBFabric_setLidPort(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _arg0;
    unsigned int  _arg1;
    IBPort * _arg2;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_setLidPort { IBFabric * } lid p_port ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[3], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[3]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg2 = (IBPort *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[3],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBPort ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBPort ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBPort  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBPort ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibdm_tcl_error = 0;
      IBFabric_setLidPort(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define IBFabric_getPortByLid(_swigobj,_swigarg0)  (_swigobj->getPortByLid(_swigarg0))
static int _wrap_IBFabric_getPortByLid(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBPort * _result;
    IBFabric * _arg0;
    unsigned int  _arg1;
    Tcl_Obj * tcl_result;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_getPortByLid { IBFabric * } lid ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (unsigned int ) tempint;
{
  ibdm_tcl_error = 0;
      _result = (IBPort *)IBFabric_getPortByLid(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBPort *");
}
    return TCL_OK;
}
#define IBFabric_dumpTopology(_swigobj,_swigarg0,_swigarg1)  (_swigobj->dumpTopology(_swigarg0,_swigarg1))
static int _wrap_IBFabric_dumpTopology(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    char * _arg2;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_dumpTopology { IBFabric * } fileName ibnlDir ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
    if ((_arg2 = Tcl_GetStringFromObj(objv[3], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_dumpTopology(_arg0,_arg1,_arg2);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_dumpNameMap(_swigobj,_swigarg0)  (_swigobj->dumpNameMap(_swigarg0))
static int _wrap_IBFabric_dumpNameMap(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_dumpNameMap { IBFabric * } fileName ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_dumpNameMap(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBFabric_setNodeGuidsByNameMapFile(_swigobj,_swigarg0)  (_swigobj->setNodeGuidsByNameMapFile(_swigarg0))
static int _wrap_IBFabric_setNodeGuidsByNameMapFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBFabric * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBFabric_setNodeGuidsByNameMapFile { IBFabric * } fileName ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibdmGetObjPtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBFabric *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBFabric ", "IBFabric ")) {
	if (strcmp(buf, "fabric")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSystem ")) {
	if (strcmp(buf, "system")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBSysPort ")) {
	if (strcmp(buf, "sysport")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBNode ")) {
	if (strcmp(buf, "node")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else if (!strcmp("IBFabric ", "IBPort ")) {
	if (strcmp(buf, "port")) {
	 char err[256];
	 sprintf(err, "-E- basetype is IBFabric  but received obj of type %s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
	}
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBFabric ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  ibdm_tcl_error = 0;
      _result = (int )IBFabric_setNodeGuidsByNameMapFile(_arg0,_arg1);
;
  if (ibdm_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibdm_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBFabricMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBFabric methods : { dump cget configure makeNode getNode getNodesByType makeGenericSystem makeSystem getSystem getSystemByGuid getNodeByGuid getPortByGuid addCable parseCables parseTopology addLink parseSubnetLinks parseFdbFile parseMCFdbFile parsePSLFile parseSLVLFile setLidPort getPortByLid dumpTopology dumpNameMap setNodeGuidsByNameMapFile  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBFabric_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"makeNode") == 0) {
        cmd = _wrap_IBFabric_makeNode;
    }    else if (strcmp(_str,"getNode") == 0) {
        cmd = _wrap_IBFabric_getNode;
    }    else if (strcmp(_str,"getNodesByType") == 0) {
        cmd = _wrap_IBFabric_getNodesByType;
    }    else if (strcmp(_str,"makeGenericSystem") == 0) {
        cmd = _wrap_IBFabric_makeGenericSystem;
    }    else if (strcmp(_str,"makeSystem") == 0) {
        cmd = _wrap_IBFabric_makeSystem;
    }    else if (strcmp(_str,"getSystem") == 0) {
        cmd = _wrap_IBFabric_getSystem;
    }    else if (strcmp(_str,"getSystemByGuid") == 0) {
        cmd = _wrap_IBFabric_getSystemByGuid;
    }    else if (strcmp(_str,"getNodeByGuid") == 0) {
        cmd = _wrap_IBFabric_getNodeByGuid;
    }    else if (strcmp(_str,"getPortByGuid") == 0) {
        cmd = _wrap_IBFabric_getPortByGuid;
    }    else if (strcmp(_str,"addCable") == 0) {
        cmd = _wrap_IBFabric_addCable;
    }    else if (strcmp(_str,"parseCables") == 0) {
        cmd = _wrap_IBFabric_parseCables;
    }    else if (strcmp(_str,"parseTopology") == 0) {
        cmd = _wrap_IBFabric_parseTopology;
    }    else if (strcmp(_str,"addLink") == 0) {
        cmd = _wrap_IBFabric_addLink;
    }    else if (strcmp(_str,"parseSubnetLinks") == 0) {
        cmd = _wrap_IBFabric_parseSubnetLinks;
    }    else if (strcmp(_str,"parseFdbFile") == 0) {
        cmd = _wrap_IBFabric_parseFdbFile;
    }    else if (strcmp(_str,"parseMCFdbFile") == 0) {
        cmd = _wrap_IBFabric_parseMCFdbFile;
    }    else if (strcmp(_str,"parsePSLFile") == 0) {
        cmd = _wrap_IBFabric_parsePSLFile;
    }    else if (strcmp(_str,"parseSLVLFile") == 0) {
        cmd = _wrap_IBFabric_parseSLVLFile;
    }    else if (strcmp(_str,"setLidPort") == 0) {
        cmd = _wrap_IBFabric_setLidPort;
    }    else if (strcmp(_str,"getPortByLid") == 0) {
        cmd = _wrap_IBFabric_getPortByLid;
    }    else if (strcmp(_str,"dumpTopology") == 0) {
        cmd = _wrap_IBFabric_dumpTopology;
    }    else if (strcmp(_str,"dumpNameMap") == 0) {
        cmd = _wrap_IBFabric_dumpNameMap;
    }    else if (strcmp(_str,"setNodeGuidsByNameMapFile") == 0) {
        cmd = _wrap_IBFabric_setNodeGuidsByNameMapFile;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-minLid") == 0) {
                    cmd = _wrap_IBFabric_minLid_set;
                }  else if (strcmp(_str,"-maxLid") == 0) {
                    cmd = _wrap_IBFabric_maxLid_set;
                }  else if (strcmp(_str,"-lmc") == 0) {
                    cmd = _wrap_IBFabric_lmc_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -minLid -maxLid -lmc  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -minLid -maxLid -lmc  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-NodeByName") == 0) {
                    cmd = _wrap_IBFabric_NodeByName_get;
                }  else if (strcmp(_str,"-SystemByName") == 0) {
                    cmd = _wrap_IBFabric_SystemByName_get;
                }  else if (strcmp(_str,"-PortByLid") == 0) {
                    cmd = _wrap_IBFabric_PortByLid_get;
                }  else if (strcmp(_str,"-NodeByGuid") == 0) {
                    cmd = _wrap_IBFabric_NodeByGuid_get;
                }  else if (strcmp(_str,"-SystemByGuid") == 0) {
                    cmd = _wrap_IBFabric_SystemByGuid_get;
                }  else if (strcmp(_str,"-PortByGuid") == 0) {
                    cmd = _wrap_IBFabric_PortByGuid_get;
                }  else if (strcmp(_str,"-minLid") == 0) {
                    cmd = _wrap_IBFabric_minLid_get;
                }  else if (strcmp(_str,"-maxLid") == 0) {
                    cmd = _wrap_IBFabric_maxLid_get;
                }  else if (strcmp(_str,"-lmc") == 0) {
                    cmd = _wrap_IBFabric_lmc_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBFabric_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -NodeByName -SystemByName -PortByLid -NodeByGuid -SystemByGuid -PortByGuid -minLid -maxLid -lmc  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -NodeByName -SystemByName -PortByLid -NodeByGuid -SystemByGuid -PortByGuid -minLid -maxLid -lmc  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_IBFabric_NodeByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-NodeByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_SystemByName_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-SystemByName ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_PortByLid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-PortByLid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_NodeByGuid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-NodeByGuid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_SystemByGuid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-SystemByGuid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_PortByGuid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-PortByGuid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_minLid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-minLid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_maxLid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-maxLid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_IBFabric_lmc_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lmc ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure makeNode getNode getNodesByType makeGenericSystem makeSystem getSystem getSystemByGuid getNodeByGuid getPortByGuid addCable parseCables parseTopology addLink parseSubnetLinks parseFdbFile parseMCFdbFile parsePSLFile parseSLVLFile setLidPort getPortByLid dumpTopology dumpNameMap setNodeGuidsByNameMapFile }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBFabricCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBFabric * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBFabric_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBFabric_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBFabric object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBFabricMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_node_info_base_version_set(_swigobj,_swigval) (_swigobj->base_version = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_base_version_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_base_version_set { ib_node_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_base_version_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_base_version_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_base_version_get(_swigobj) (&_swigobj->base_version)
static int _wrap_ib_node_info_t_base_version_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_base_version_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_base_version_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_base_version_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_class_version_set(_swigobj,_swigval) (_swigobj->class_version = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_class_version_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_class_version_set { ib_node_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_class_version_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_class_version_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_class_version_get(_swigobj) (&_swigobj->class_version)
static int _wrap_ib_node_info_t_class_version_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_class_version_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_class_version_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_class_version_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_type_set(_swigobj,_swigval) (_swigobj->node_type = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_node_type_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_node_type_set { ib_node_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_node_type_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_node_type_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_type_get(_swigobj) (&_swigobj->node_type)
static int _wrap_ib_node_info_t_node_type_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_node_type_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_node_type_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_node_type_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_num_ports_set(_swigobj,_swigval) (_swigobj->num_ports = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_num_ports_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_num_ports_set { ib_node_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_num_ports_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_num_ports_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_num_ports_get(_swigobj) (&_swigobj->num_ports)
static int _wrap_ib_node_info_t_num_ports_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_num_ports_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_num_ports_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_node_info_num_ports_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_sys_guid_set(_swigobj,_swigval) (_swigobj->sys_guid = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_sys_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_node_info_t * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_sys_guid_set { ib_node_info_t * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_sys_guid_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_sys_guid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_sys_guid_get(_swigobj) (&_swigobj->sys_guid)
static int _wrap_ib_node_info_t_sys_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_sys_guid_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_sys_guid_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_sys_guid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_guid_set(_swigobj,_swigval) (_swigobj->node_guid = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_node_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_node_info_t * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_node_guid_set { ib_node_info_t * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_node_guid_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_node_guid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_node_guid_get(_swigobj) (&_swigobj->node_guid)
static int _wrap_ib_node_info_t_node_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_node_guid_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_node_guid_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_node_guid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_guid_set(_swigobj,_swigval) (_swigobj->port_guid = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_port_guid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_node_info_t * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_port_guid_set { ib_node_info_t * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_port_guid_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_port_guid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_guid_get(_swigobj) (&_swigobj->port_guid)
static int _wrap_ib_node_info_t_port_guid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_port_guid_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_port_guid_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_node_info_port_guid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_partition_cap_set(_swigobj,_swigval) (_swigobj->partition_cap = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_partition_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_node_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_partition_cap_set { ib_node_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_partition_cap_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_partition_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_partition_cap_get(_swigobj) (&_swigobj->partition_cap)
static int _wrap_ib_node_info_t_partition_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_partition_cap_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_partition_cap_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_partition_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_device_id_set(_swigobj,_swigval) (_swigobj->device_id = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_device_id_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_node_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_device_id_set { ib_node_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_device_id_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_device_id_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_device_id_get(_swigobj) (&_swigobj->device_id)
static int _wrap_ib_node_info_t_device_id_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_device_id_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_device_id_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_node_info_device_id_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_revision_set(_swigobj,_swigval) (_swigobj->revision = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_revision_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_node_info_t * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_revision_set { ib_node_info_t * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_revision_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_revision_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_revision_get(_swigobj) (&_swigobj->revision)
static int _wrap_ib_node_info_t_revision_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_revision_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_revision_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_revision_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_num_vendor_id_set(_swigobj,_swigval) (_swigobj->port_num_vendor_id = *(_swigval),_swigval)
static int _wrap_ib_node_info_t_port_num_vendor_id_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_node_info_t * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_port_num_vendor_id_set { ib_node_info_t * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_port_num_vendor_id_set. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_port_num_vendor_id_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_node_info_port_num_vendor_id_get(_swigobj) (&_swigobj->port_num_vendor_id)
static int _wrap_ib_node_info_t_port_num_vendor_id_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_node_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_info_t_port_num_vendor_id_get { ib_node_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_info_t_port_num_vendor_id_get. Expected _ib_node_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_node_info_port_num_vendor_id_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int Tclib_node_info_tMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"ib_node_info_t methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_ib_node_info_t_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-base_version") == 0) {
                    cmd = _wrap_ib_node_info_t_base_version_set;
                }  else if (strcmp(_str,"-class_version") == 0) {
                    cmd = _wrap_ib_node_info_t_class_version_set;
                }  else if (strcmp(_str,"-node_type") == 0) {
                    cmd = _wrap_ib_node_info_t_node_type_set;
                }  else if (strcmp(_str,"-num_ports") == 0) {
                    cmd = _wrap_ib_node_info_t_num_ports_set;
                }  else if (strcmp(_str,"-sys_guid") == 0) {
                    cmd = _wrap_ib_node_info_t_sys_guid_set;
                }  else if (strcmp(_str,"-node_guid") == 0) {
                    cmd = _wrap_ib_node_info_t_node_guid_set;
                }  else if (strcmp(_str,"-port_guid") == 0) {
                    cmd = _wrap_ib_node_info_t_port_guid_set;
                }  else if (strcmp(_str,"-partition_cap") == 0) {
                    cmd = _wrap_ib_node_info_t_partition_cap_set;
                }  else if (strcmp(_str,"-device_id") == 0) {
                    cmd = _wrap_ib_node_info_t_device_id_set;
                }  else if (strcmp(_str,"-revision") == 0) {
                    cmd = _wrap_ib_node_info_t_revision_set;
                }  else if (strcmp(_str,"-port_num_vendor_id") == 0) {
                    cmd = _wrap_ib_node_info_t_port_num_vendor_id_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-base_version") == 0) {
                    cmd = _wrap_ib_node_info_t_base_version_get;
                }  else if (strcmp(_str,"-class_version") == 0) {
                    cmd = _wrap_ib_node_info_t_class_version_get;
                }  else if (strcmp(_str,"-node_type") == 0) {
                    cmd = _wrap_ib_node_info_t_node_type_get;
                }  else if (strcmp(_str,"-num_ports") == 0) {
                    cmd = _wrap_ib_node_info_t_num_ports_get;
                }  else if (strcmp(_str,"-sys_guid") == 0) {
                    cmd = _wrap_ib_node_info_t_sys_guid_get;
                }  else if (strcmp(_str,"-node_guid") == 0) {
                    cmd = _wrap_ib_node_info_t_node_guid_get;
                }  else if (strcmp(_str,"-port_guid") == 0) {
                    cmd = _wrap_ib_node_info_t_port_guid_get;
                }  else if (strcmp(_str,"-partition_cap") == 0) {
                    cmd = _wrap_ib_node_info_t_partition_cap_get;
                }  else if (strcmp(_str,"-device_id") == 0) {
                    cmd = _wrap_ib_node_info_t_device_id_get;
                }  else if (strcmp(_str,"-revision") == 0) {
                    cmd = _wrap_ib_node_info_t_revision_get;
                }  else if (strcmp(_str,"-port_num_vendor_id") == 0) {
                    cmd = _wrap_ib_node_info_t_port_num_vendor_id_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_ib_node_info_t_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -base_version -class_version -node_type -num_ports -sys_guid -node_guid -port_guid -partition_cap -device_id -revision -port_num_vendor_id  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_ib_node_info_t_base_version_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-base_version ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_class_version_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-class_version ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_node_type_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_type ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_num_ports_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-num_ports ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_sys_guid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-sys_guid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_node_guid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-node_guid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_port_guid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_guid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_partition_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-partition_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_device_id_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-device_id ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_revision_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-revision ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_node_info_t_port_num_vendor_id_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_num_vendor_id ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int Tclib_node_info_tCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    ib_node_info_t * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_ib_node_info_t_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_ib_node_info_t_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a ib_node_info_t object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, Tclib_node_info_tMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_switch_info_lin_cap_set(_swigobj,_swigval) (_swigobj->lin_cap = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_lin_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_lin_cap_set { ib_switch_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_lin_cap_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lin_cap_get(_swigobj) (&_swigobj->lin_cap)
static int _wrap_ib_switch_info_t_lin_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_lin_cap_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_lin_cap_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_rand_cap_set(_swigobj,_swigval) (_swigobj->rand_cap = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_rand_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_rand_cap_set { ib_switch_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_rand_cap_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_rand_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_rand_cap_get(_swigobj) (&_swigobj->rand_cap)
static int _wrap_ib_switch_info_t_rand_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_rand_cap_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_rand_cap_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_rand_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_mcast_cap_set(_swigobj,_swigval) (_swigobj->mcast_cap = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_mcast_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_mcast_cap_set { ib_switch_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_mcast_cap_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_mcast_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_mcast_cap_get(_swigobj) (&_swigobj->mcast_cap)
static int _wrap_ib_switch_info_t_mcast_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_mcast_cap_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_mcast_cap_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_mcast_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lin_top_set(_swigobj,_swigval) (_swigobj->lin_top = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_lin_top_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_lin_top_set { ib_switch_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_lin_top_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_top_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lin_top_get(_swigobj) (&_swigobj->lin_top)
static int _wrap_ib_switch_info_t_lin_top_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_lin_top_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_lin_top_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lin_top_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_port_set(_swigobj,_swigval) (_swigobj->def_port = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_def_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_def_port_set { ib_switch_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_def_port_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_port_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_port_get(_swigobj) (&_swigobj->def_port)
static int _wrap_ib_switch_info_t_def_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_def_port_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_def_port_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_port_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_pri_port_set(_swigobj,_swigval) (_swigobj->def_mcast_pri_port = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_def_mcast_pri_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_def_mcast_pri_port_set { ib_switch_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_def_mcast_pri_port_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_pri_port_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_pri_port_get(_swigobj) (&_swigobj->def_mcast_pri_port)
static int _wrap_ib_switch_info_t_def_mcast_pri_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_def_mcast_pri_port_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_def_mcast_pri_port_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_pri_port_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_not_port_set(_swigobj,_swigval) (_swigobj->def_mcast_not_port = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_def_mcast_not_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_def_mcast_not_port_set { ib_switch_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_def_mcast_not_port_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_not_port_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_def_mcast_not_port_get(_swigobj) (&_swigobj->def_mcast_not_port)
static int _wrap_ib_switch_info_t_def_mcast_not_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_def_mcast_not_port_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_def_mcast_not_port_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_def_mcast_not_port_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_life_state_set(_swigobj,_swigval) (_swigobj->life_state = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_life_state_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_life_state_set { ib_switch_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_life_state_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_life_state_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_life_state_get(_swigobj) (&_swigobj->life_state)
static int _wrap_ib_switch_info_t_life_state_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_life_state_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_life_state_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_life_state_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lids_per_port_set(_swigobj,_swigval) (_swigobj->lids_per_port = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_lids_per_port_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_lids_per_port_set { ib_switch_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_lids_per_port_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lids_per_port_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_lids_per_port_get(_swigobj) (&_swigobj->lids_per_port)
static int _wrap_ib_switch_info_t_lids_per_port_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_lids_per_port_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_lids_per_port_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_lids_per_port_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_enforce_cap_set(_swigobj,_swigval) (_swigobj->enforce_cap = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_enforce_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_enforce_cap_set { ib_switch_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_enforce_cap_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_enforce_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_enforce_cap_get(_swigobj) (&_swigobj->enforce_cap)
static int _wrap_ib_switch_info_t_enforce_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_enforce_cap_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_enforce_cap_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_switch_info_enforce_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_flags_set(_swigobj,_swigval) (_swigobj->flags = *(_swigval),_swigval)
static int _wrap_ib_switch_info_t_flags_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_flags_set { ib_switch_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_flags_set. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_flags_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_switch_info_flags_get(_swigobj) (&_swigobj->flags)
static int _wrap_ib_switch_info_t_flags_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_switch_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_switch_info_t_flags_get { ib_switch_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_switch_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_switch_info_t_flags_get. Expected _ib_switch_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_switch_info_flags_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int Tclib_switch_info_tMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"ib_switch_info_t methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_ib_switch_info_t_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lin_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_lin_cap_set;
                }  else if (strcmp(_str,"-rand_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_rand_cap_set;
                }  else if (strcmp(_str,"-mcast_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_mcast_cap_set;
                }  else if (strcmp(_str,"-lin_top") == 0) {
                    cmd = _wrap_ib_switch_info_t_lin_top_set;
                }  else if (strcmp(_str,"-def_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_def_port_set;
                }  else if (strcmp(_str,"-def_mcast_pri_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_def_mcast_pri_port_set;
                }  else if (strcmp(_str,"-def_mcast_not_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_def_mcast_not_port_set;
                }  else if (strcmp(_str,"-life_state") == 0) {
                    cmd = _wrap_ib_switch_info_t_life_state_set;
                }  else if (strcmp(_str,"-lids_per_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_lids_per_port_set;
                }  else if (strcmp(_str,"-enforce_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_enforce_cap_set;
                }  else if (strcmp(_str,"-flags") == 0) {
                    cmd = _wrap_ib_switch_info_t_flags_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lin_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_lin_cap_get;
                }  else if (strcmp(_str,"-rand_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_rand_cap_get;
                }  else if (strcmp(_str,"-mcast_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_mcast_cap_get;
                }  else if (strcmp(_str,"-lin_top") == 0) {
                    cmd = _wrap_ib_switch_info_t_lin_top_get;
                }  else if (strcmp(_str,"-def_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_def_port_get;
                }  else if (strcmp(_str,"-def_mcast_pri_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_def_mcast_pri_port_get;
                }  else if (strcmp(_str,"-def_mcast_not_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_def_mcast_not_port_get;
                }  else if (strcmp(_str,"-life_state") == 0) {
                    cmd = _wrap_ib_switch_info_t_life_state_get;
                }  else if (strcmp(_str,"-lids_per_port") == 0) {
                    cmd = _wrap_ib_switch_info_t_lids_per_port_get;
                }  else if (strcmp(_str,"-enforce_cap") == 0) {
                    cmd = _wrap_ib_switch_info_t_enforce_cap_get;
                }  else if (strcmp(_str,"-flags") == 0) {
                    cmd = _wrap_ib_switch_info_t_flags_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_ib_switch_info_t_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lin_cap -rand_cap -mcast_cap -lin_top -def_port -def_mcast_pri_port -def_mcast_not_port -life_state -lids_per_port -enforce_cap -flags  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_ib_switch_info_t_lin_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lin_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_rand_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-rand_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_mcast_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mcast_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_lin_top_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lin_top ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_def_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-def_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_def_mcast_pri_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-def_mcast_pri_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_def_mcast_not_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-def_mcast_not_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_life_state_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-life_state ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_lids_per_port_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lids_per_port ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_enforce_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-enforce_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_switch_info_t_flags_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-flags ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int Tclib_switch_info_tCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    ib_switch_info_t * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_ib_switch_info_t_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_ib_switch_info_t_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a ib_switch_info_t object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, Tclib_switch_info_tMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_port_info_m_key_set(_swigobj,_swigval) (_swigobj->m_key = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_m_key_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_port_info_t * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_m_key_set { ib_port_info_t * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_m_key_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_m_key_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_get(_swigobj) (&_swigobj->m_key)
static int _wrap_ib_port_info_t_m_key_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_m_key_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_m_key_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_m_key_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_prefix_set(_swigobj,_swigval) (_swigobj->subnet_prefix = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_subnet_prefix_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_port_info_t * _arg0;
    ib_net64_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint64_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_subnet_prefix_set { ib_port_info_t * } { ib_net64_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_subnet_prefix_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton64(strtoull(Tcl_GetStringFromObj(objv[2],NULL), NULL, 16));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_subnet_prefix_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_prefix_get(_swigobj) (&_swigobj->subnet_prefix)
static int _wrap_ib_port_info_t_subnet_prefix_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net64_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_subnet_prefix_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_subnet_prefix_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net64_t *)_ib_port_info_subnet_prefix_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "0x%016" PRIx64, cl_ntoh64(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_base_lid_set(_swigobj,_swigval) (_swigobj->base_lid = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_base_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_base_lid_set { ib_port_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_base_lid_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_base_lid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_base_lid_get(_swigobj) (&_swigobj->base_lid)
static int _wrap_ib_port_info_t_base_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_base_lid_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_base_lid_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_base_lid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_master_sm_base_lid_set(_swigobj,_swigval) (_swigobj->master_sm_base_lid = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_master_sm_base_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_master_sm_base_lid_set { ib_port_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_master_sm_base_lid_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_master_sm_base_lid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_master_sm_base_lid_get(_swigobj) (&_swigobj->master_sm_base_lid)
static int _wrap_ib_port_info_t_master_sm_base_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_master_sm_base_lid_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_master_sm_base_lid_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_master_sm_base_lid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_capability_mask_set(_swigobj,_swigval) (_swigobj->capability_mask = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_capability_mask_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_port_info_t * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_capability_mask_set { ib_port_info_t * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_capability_mask_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_port_info_capability_mask_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_capability_mask_get(_swigobj) (&_swigobj->capability_mask)
static int _wrap_ib_port_info_t_capability_mask_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_capability_mask_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_capability_mask_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_port_info_capability_mask_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_diag_code_set(_swigobj,_swigval) (_swigobj->diag_code = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_diag_code_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_diag_code_set { ib_port_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_diag_code_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_diag_code_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_diag_code_get(_swigobj) (&_swigobj->diag_code)
static int _wrap_ib_port_info_t_diag_code_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_diag_code_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_diag_code_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_diag_code_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_lease_period_set(_swigobj,_swigval) (_swigobj->m_key_lease_period = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_m_key_lease_period_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_m_key_lease_period_set { ib_port_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_m_key_lease_period_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_lease_period_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_lease_period_get(_swigobj) (&_swigobj->m_key_lease_period)
static int _wrap_ib_port_info_t_m_key_lease_period_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_m_key_lease_period_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_m_key_lease_period_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_lease_period_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_local_port_num_set(_swigobj,_swigval) (_swigobj->local_port_num = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_local_port_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_local_port_num_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_local_port_num_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_local_port_num_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_local_port_num_get(_swigobj) (&_swigobj->local_port_num)
static int _wrap_ib_port_info_t_local_port_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_local_port_num_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_local_port_num_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_local_port_num_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_enabled_set(_swigobj,_swigval) (_swigobj->link_width_enabled = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_link_width_enabled_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_width_enabled_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_width_enabled_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_enabled_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_enabled_get(_swigobj) (&_swigobj->link_width_enabled)
static int _wrap_ib_port_info_t_link_width_enabled_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_width_enabled_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_width_enabled_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_enabled_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_supported_set(_swigobj,_swigval) (_swigobj->link_width_supported = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_link_width_supported_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_width_supported_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_width_supported_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_supported_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_supported_get(_swigobj) (&_swigobj->link_width_supported)
static int _wrap_ib_port_info_t_link_width_supported_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_width_supported_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_width_supported_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_supported_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_active_set(_swigobj,_swigval) (_swigobj->link_width_active = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_link_width_active_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_width_active_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_width_active_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_active_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_width_active_get(_swigobj) (&_swigobj->link_width_active)
static int _wrap_ib_port_info_t_link_width_active_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_width_active_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_width_active_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_width_active_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info1_set(_swigobj,_swigval) (_swigobj->state_info1 = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_state_info1_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_state_info1_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_state_info1_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info1_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info1_get(_swigobj) (&_swigobj->state_info1)
static int _wrap_ib_port_info_t_state_info1_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_state_info1_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_state_info1_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info1_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info2_set(_swigobj,_swigval) (_swigobj->state_info2 = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_state_info2_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_state_info2_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_state_info2_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info2_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_state_info2_get(_swigobj) (&_swigobj->state_info2)
static int _wrap_ib_port_info_t_state_info2_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_state_info2_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_state_info2_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_state_info2_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mkey_lmc_set(_swigobj,_swigval) (_swigobj->mkey_lmc = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_mkey_lmc_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_mkey_lmc_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_mkey_lmc_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mkey_lmc_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mkey_lmc_get(_swigobj) (&_swigobj->mkey_lmc)
static int _wrap_ib_port_info_t_mkey_lmc_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_mkey_lmc_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_mkey_lmc_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mkey_lmc_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_speed_set(_swigobj,_swigval) (_swigobj->link_speed = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_link_speed_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_speed_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_speed_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_speed_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_link_speed_get(_swigobj) (&_swigobj->link_speed)
static int _wrap_ib_port_info_t_link_speed_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_link_speed_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_link_speed_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_link_speed_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_smsl_set(_swigobj,_swigval) (_swigobj->mtu_smsl = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_mtu_smsl_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_mtu_smsl_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_mtu_smsl_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_smsl_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_smsl_get(_swigobj) (&_swigobj->mtu_smsl)
static int _wrap_ib_port_info_t_mtu_smsl_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_mtu_smsl_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_mtu_smsl_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_smsl_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_cap_set(_swigobj,_swigval) (_swigobj->vl_cap = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_vl_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_cap_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_cap_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_cap_get(_swigobj) (&_swigobj->vl_cap)
static int _wrap_ib_port_info_t_vl_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_cap_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_cap_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_high_limit_set(_swigobj,_swigval) (_swigobj->vl_high_limit = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_vl_high_limit_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_high_limit_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_high_limit_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_high_limit_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_high_limit_get(_swigobj) (&_swigobj->vl_high_limit)
static int _wrap_ib_port_info_t_vl_high_limit_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_high_limit_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_high_limit_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_high_limit_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_high_cap_set(_swigobj,_swigval) (_swigobj->vl_arb_high_cap = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_vl_arb_high_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_arb_high_cap_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_arb_high_cap_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_high_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_high_cap_get(_swigobj) (&_swigobj->vl_arb_high_cap)
static int _wrap_ib_port_info_t_vl_arb_high_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_arb_high_cap_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_arb_high_cap_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_high_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_low_cap_set(_swigobj,_swigval) (_swigobj->vl_arb_low_cap = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_vl_arb_low_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_arb_low_cap_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_arb_low_cap_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_low_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_arb_low_cap_get(_swigobj) (&_swigobj->vl_arb_low_cap)
static int _wrap_ib_port_info_t_vl_arb_low_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_arb_low_cap_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_arb_low_cap_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_arb_low_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_cap_set(_swigobj,_swigval) (_swigobj->mtu_cap = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_mtu_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_mtu_cap_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_mtu_cap_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_mtu_cap_get(_swigobj) (&_swigobj->mtu_cap)
static int _wrap_ib_port_info_t_mtu_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_mtu_cap_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_mtu_cap_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_mtu_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_stall_life_set(_swigobj,_swigval) (_swigobj->vl_stall_life = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_vl_stall_life_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_stall_life_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_stall_life_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_stall_life_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_stall_life_get(_swigobj) (&_swigobj->vl_stall_life)
static int _wrap_ib_port_info_t_vl_stall_life_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_stall_life_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_stall_life_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_stall_life_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_enforce_set(_swigobj,_swigval) (_swigobj->vl_enforce = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_vl_enforce_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_enforce_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_enforce_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_enforce_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_vl_enforce_get(_swigobj) (&_swigobj->vl_enforce)
static int _wrap_ib_port_info_t_vl_enforce_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_vl_enforce_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_vl_enforce_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_vl_enforce_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_violations_set(_swigobj,_swigval) (_swigobj->m_key_violations = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_m_key_violations_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_m_key_violations_set { ib_port_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_m_key_violations_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_violations_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_m_key_violations_get(_swigobj) (&_swigobj->m_key_violations)
static int _wrap_ib_port_info_t_m_key_violations_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_m_key_violations_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_m_key_violations_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_m_key_violations_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_p_key_violations_set(_swigobj,_swigval) (_swigobj->p_key_violations = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_p_key_violations_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_p_key_violations_set { ib_port_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_p_key_violations_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_p_key_violations_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_p_key_violations_get(_swigobj) (&_swigobj->p_key_violations)
static int _wrap_ib_port_info_t_p_key_violations_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_p_key_violations_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_p_key_violations_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_p_key_violations_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_q_key_violations_set(_swigobj,_swigval) (_swigobj->q_key_violations = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_q_key_violations_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_q_key_violations_set { ib_port_info_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_q_key_violations_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_q_key_violations_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_q_key_violations_get(_swigobj) (&_swigobj->q_key_violations)
static int _wrap_ib_port_info_t_q_key_violations_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_q_key_violations_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_q_key_violations_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_port_info_q_key_violations_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_guid_cap_set(_swigobj,_swigval) (_swigobj->guid_cap = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_guid_cap_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_guid_cap_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_guid_cap_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_guid_cap_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_guid_cap_get(_swigobj) (&_swigobj->guid_cap)
static int _wrap_ib_port_info_t_guid_cap_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_guid_cap_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_guid_cap_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_guid_cap_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_timeout_set(_swigobj,_swigval) (_swigobj->subnet_timeout = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_subnet_timeout_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_subnet_timeout_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_subnet_timeout_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_subnet_timeout_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_subnet_timeout_get(_swigobj) (&_swigobj->subnet_timeout)
static int _wrap_ib_port_info_t_subnet_timeout_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_subnet_timeout_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_subnet_timeout_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_subnet_timeout_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_resp_time_value_set(_swigobj,_swigval) (_swigobj->resp_time_value = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_resp_time_value_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_resp_time_value_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_resp_time_value_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_resp_time_value_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_resp_time_value_get(_swigobj) (&_swigobj->resp_time_value)
static int _wrap_ib_port_info_t_resp_time_value_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_resp_time_value_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_resp_time_value_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_resp_time_value_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_error_threshold_set(_swigobj,_swigval) (_swigobj->error_threshold = *(_swigval),_swigval)
static int _wrap_ib_port_info_t_error_threshold_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_error_threshold_set { ib_port_info_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_error_threshold_set. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_error_threshold_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_port_info_error_threshold_get(_swigobj) (&_swigobj->error_threshold)
static int _wrap_ib_port_info_t_error_threshold_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_port_info_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_port_info_t_error_threshold_get { ib_port_info_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_port_info_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_port_info_t_error_threshold_get. Expected _ib_port_info_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_port_info_error_threshold_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int Tclib_port_info_tMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"ib_port_info_t methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_ib_port_info_t_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-m_key") == 0) {
                    cmd = _wrap_ib_port_info_t_m_key_set;
                }  else if (strcmp(_str,"-subnet_prefix") == 0) {
                    cmd = _wrap_ib_port_info_t_subnet_prefix_set;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_ib_port_info_t_base_lid_set;
                }  else if (strcmp(_str,"-master_sm_base_lid") == 0) {
                    cmd = _wrap_ib_port_info_t_master_sm_base_lid_set;
                }  else if (strcmp(_str,"-capability_mask") == 0) {
                    cmd = _wrap_ib_port_info_t_capability_mask_set;
                }  else if (strcmp(_str,"-diag_code") == 0) {
                    cmd = _wrap_ib_port_info_t_diag_code_set;
                }  else if (strcmp(_str,"-m_key_lease_period") == 0) {
                    cmd = _wrap_ib_port_info_t_m_key_lease_period_set;
                }  else if (strcmp(_str,"-local_port_num") == 0) {
                    cmd = _wrap_ib_port_info_t_local_port_num_set;
                }  else if (strcmp(_str,"-link_width_enabled") == 0) {
                    cmd = _wrap_ib_port_info_t_link_width_enabled_set;
                }  else if (strcmp(_str,"-link_width_supported") == 0) {
                    cmd = _wrap_ib_port_info_t_link_width_supported_set;
                }  else if (strcmp(_str,"-link_width_active") == 0) {
                    cmd = _wrap_ib_port_info_t_link_width_active_set;
                }  else if (strcmp(_str,"-state_info1") == 0) {
                    cmd = _wrap_ib_port_info_t_state_info1_set;
                }  else if (strcmp(_str,"-state_info2") == 0) {
                    cmd = _wrap_ib_port_info_t_state_info2_set;
                }  else if (strcmp(_str,"-mkey_lmc") == 0) {
                    cmd = _wrap_ib_port_info_t_mkey_lmc_set;
                }  else if (strcmp(_str,"-link_speed") == 0) {
                    cmd = _wrap_ib_port_info_t_link_speed_set;
                }  else if (strcmp(_str,"-mtu_smsl") == 0) {
                    cmd = _wrap_ib_port_info_t_mtu_smsl_set;
                }  else if (strcmp(_str,"-vl_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_cap_set;
                }  else if (strcmp(_str,"-vl_high_limit") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_high_limit_set;
                }  else if (strcmp(_str,"-vl_arb_high_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_arb_high_cap_set;
                }  else if (strcmp(_str,"-vl_arb_low_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_arb_low_cap_set;
                }  else if (strcmp(_str,"-mtu_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_mtu_cap_set;
                }  else if (strcmp(_str,"-vl_stall_life") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_stall_life_set;
                }  else if (strcmp(_str,"-vl_enforce") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_enforce_set;
                }  else if (strcmp(_str,"-m_key_violations") == 0) {
                    cmd = _wrap_ib_port_info_t_m_key_violations_set;
                }  else if (strcmp(_str,"-p_key_violations") == 0) {
                    cmd = _wrap_ib_port_info_t_p_key_violations_set;
                }  else if (strcmp(_str,"-q_key_violations") == 0) {
                    cmd = _wrap_ib_port_info_t_q_key_violations_set;
                }  else if (strcmp(_str,"-guid_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_guid_cap_set;
                }  else if (strcmp(_str,"-subnet_timeout") == 0) {
                    cmd = _wrap_ib_port_info_t_subnet_timeout_set;
                }  else if (strcmp(_str,"-resp_time_value") == 0) {
                    cmd = _wrap_ib_port_info_t_resp_time_value_set;
                }  else if (strcmp(_str,"-error_threshold") == 0) {
                    cmd = _wrap_ib_port_info_t_error_threshold_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-m_key") == 0) {
                    cmd = _wrap_ib_port_info_t_m_key_get;
                }  else if (strcmp(_str,"-subnet_prefix") == 0) {
                    cmd = _wrap_ib_port_info_t_subnet_prefix_get;
                }  else if (strcmp(_str,"-base_lid") == 0) {
                    cmd = _wrap_ib_port_info_t_base_lid_get;
                }  else if (strcmp(_str,"-master_sm_base_lid") == 0) {
                    cmd = _wrap_ib_port_info_t_master_sm_base_lid_get;
                }  else if (strcmp(_str,"-capability_mask") == 0) {
                    cmd = _wrap_ib_port_info_t_capability_mask_get;
                }  else if (strcmp(_str,"-diag_code") == 0) {
                    cmd = _wrap_ib_port_info_t_diag_code_get;
                }  else if (strcmp(_str,"-m_key_lease_period") == 0) {
                    cmd = _wrap_ib_port_info_t_m_key_lease_period_get;
                }  else if (strcmp(_str,"-local_port_num") == 0) {
                    cmd = _wrap_ib_port_info_t_local_port_num_get;
                }  else if (strcmp(_str,"-link_width_enabled") == 0) {
                    cmd = _wrap_ib_port_info_t_link_width_enabled_get;
                }  else if (strcmp(_str,"-link_width_supported") == 0) {
                    cmd = _wrap_ib_port_info_t_link_width_supported_get;
                }  else if (strcmp(_str,"-link_width_active") == 0) {
                    cmd = _wrap_ib_port_info_t_link_width_active_get;
                }  else if (strcmp(_str,"-state_info1") == 0) {
                    cmd = _wrap_ib_port_info_t_state_info1_get;
                }  else if (strcmp(_str,"-state_info2") == 0) {
                    cmd = _wrap_ib_port_info_t_state_info2_get;
                }  else if (strcmp(_str,"-mkey_lmc") == 0) {
                    cmd = _wrap_ib_port_info_t_mkey_lmc_get;
                }  else if (strcmp(_str,"-link_speed") == 0) {
                    cmd = _wrap_ib_port_info_t_link_speed_get;
                }  else if (strcmp(_str,"-mtu_smsl") == 0) {
                    cmd = _wrap_ib_port_info_t_mtu_smsl_get;
                }  else if (strcmp(_str,"-vl_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_cap_get;
                }  else if (strcmp(_str,"-vl_high_limit") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_high_limit_get;
                }  else if (strcmp(_str,"-vl_arb_high_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_arb_high_cap_get;
                }  else if (strcmp(_str,"-vl_arb_low_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_arb_low_cap_get;
                }  else if (strcmp(_str,"-mtu_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_mtu_cap_get;
                }  else if (strcmp(_str,"-vl_stall_life") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_stall_life_get;
                }  else if (strcmp(_str,"-vl_enforce") == 0) {
                    cmd = _wrap_ib_port_info_t_vl_enforce_get;
                }  else if (strcmp(_str,"-m_key_violations") == 0) {
                    cmd = _wrap_ib_port_info_t_m_key_violations_get;
                }  else if (strcmp(_str,"-p_key_violations") == 0) {
                    cmd = _wrap_ib_port_info_t_p_key_violations_get;
                }  else if (strcmp(_str,"-q_key_violations") == 0) {
                    cmd = _wrap_ib_port_info_t_q_key_violations_get;
                }  else if (strcmp(_str,"-guid_cap") == 0) {
                    cmd = _wrap_ib_port_info_t_guid_cap_get;
                }  else if (strcmp(_str,"-subnet_timeout") == 0) {
                    cmd = _wrap_ib_port_info_t_subnet_timeout_get;
                }  else if (strcmp(_str,"-resp_time_value") == 0) {
                    cmd = _wrap_ib_port_info_t_resp_time_value_get;
                }  else if (strcmp(_str,"-error_threshold") == 0) {
                    cmd = _wrap_ib_port_info_t_error_threshold_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_ib_port_info_t_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -m_key -subnet_prefix -base_lid -master_sm_base_lid -capability_mask -diag_code -m_key_lease_period -local_port_num -link_width_enabled -link_width_supported -link_width_active -state_info1 -state_info2 -mkey_lmc -link_speed -mtu_smsl -vl_cap -vl_high_limit -vl_arb_high_cap -vl_arb_low_cap -mtu_cap -vl_stall_life -vl_enforce -m_key_violations -p_key_violations -q_key_violations -guid_cap -subnet_timeout -resp_time_value -error_threshold  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_ib_port_info_t_m_key_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-m_key ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_subnet_prefix_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-subnet_prefix ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_base_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-base_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_master_sm_base_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-master_sm_base_lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_capability_mask_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-capability_mask ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_diag_code_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-diag_code ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_m_key_lease_period_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-m_key_lease_period ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_local_port_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-local_port_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_link_width_enabled_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_width_enabled ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_link_width_supported_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_width_supported ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_link_width_active_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_width_active ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_state_info1_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-state_info1 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_state_info2_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-state_info2 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_mkey_lmc_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mkey_lmc ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_link_speed_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_speed ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_mtu_smsl_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mtu_smsl ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_vl_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_vl_high_limit_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_high_limit ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_vl_arb_high_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_arb_high_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_vl_arb_low_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_arb_low_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_mtu_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mtu_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_vl_stall_life_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_stall_life ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_vl_enforce_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl_enforce ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_m_key_violations_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-m_key_violations ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_p_key_violations_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-p_key_violations ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_q_key_violations_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-q_key_violations ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_guid_cap_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-guid_cap ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_subnet_timeout_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-subnet_timeout ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_resp_time_value_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-resp_time_value ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_port_info_t_error_threshold_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-error_threshold ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int Tclib_port_info_tCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    ib_port_info_t * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_ib_port_info_t_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_ib_port_info_t_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a ib_port_info_t object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, Tclib_port_info_tMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


static uint8_array_t * _ib_node_desc_description_set(ib_node_desc_t *obj, uint8_array_t val[IB_NODE_DESCRIPTION_SIZE]) {
{
	int i;
	for (i=0; i <IB_NODE_DESCRIPTION_SIZE ; i++) {
		obj->description[i] = *(val+i);
	}
}
    return (uint8_array_t *) val;
}
static int _wrap_ib_node_desc_t_description_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    ib_node_desc_t * _arg0;
    uint8_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  entrys[IB_NODE_DESCRIPTION_SIZE];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_desc_t_description_set { ib_node_desc_t * } { uint8_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_desc_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_desc_t_description_set. Expected _ib_node_desc_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < IB_NODE_DESCRIPTION_SIZE))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > 0xff)
    {
      printf("Error: wrong format or out of range value for expected uint8_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = entry;
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < IB_NODE_DESCRIPTION_SIZE; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_array_t *)_ib_node_desc_description_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <IB_NODE_DESCRIPTION_SIZE ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_node_desc_description_get(_swigobj) ((uint8_array_t *) _swigobj->description)
static int _wrap_ib_node_desc_t_description_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    ib_node_desc_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_node_desc_t_description_get { ib_node_desc_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_node_desc_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_node_desc_t_description_get. Expected _ib_node_desc_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_array_t *)_ib_node_desc_description_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <IB_NODE_DESCRIPTION_SIZE ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int Tclib_node_desc_tMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"ib_node_desc_t methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_ib_node_desc_t_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-description") == 0) {
                    cmd = _wrap_ib_node_desc_t_description_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -description  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -description  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-description") == 0) {
                    cmd = _wrap_ib_node_desc_t_description_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_ib_node_desc_t_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -description  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -description  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_ib_node_desc_t_description_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-description ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int Tclib_node_desc_tCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    ib_node_desc_t * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_ib_node_desc_t_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_ib_node_desc_t_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a ib_node_desc_t object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, Tclib_node_desc_tMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_lft_record_lid_set(_swigobj,_swigval) (_swigobj->lid = *(_swigval),_swigval)
static int _wrap_ib_lft_record_t_lid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_lft_record_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_lid_set { ib_lft_record_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_lid_set. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_lid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_lid_get(_swigobj) (&_swigobj->lid)
static int _wrap_ib_lft_record_t_lid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_lft_record_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_lid_get { ib_lft_record_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_lid_get. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_lid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_block_num_set(_swigobj,_swigval) (_swigobj->block_num = *(_swigval),_swigval)
static int _wrap_ib_lft_record_t_block_num_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_lft_record_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_block_num_set { ib_lft_record_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_block_num_set. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_block_num_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_block_num_get(_swigobj) (&_swigobj->block_num)
static int _wrap_ib_lft_record_t_block_num_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_lft_record_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_block_num_get { ib_lft_record_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_block_num_get. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_lft_record_block_num_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_resv0_set(_swigobj,_swigval) (_swigobj->resv0 = *(_swigval),_swigval)
static int _wrap_ib_lft_record_t_resv0_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    ib_lft_record_t * _arg0;
    uint32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_resv0_set { ib_lft_record_t * } { uint32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_resv0_set. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint32_t *)_ib_lft_record_resv0_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_lft_record_resv0_get(_swigobj) (&_swigobj->resv0)
static int _wrap_ib_lft_record_t_resv0_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_t * _result;
    ib_lft_record_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_resv0_get { ib_lft_record_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_resv0_get. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint32_t *)_ib_lft_record_resv0_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static uint8_array_t * _ib_lft_record_lft_set(ib_lft_record_t *obj, uint8_array_t val[64]) {
{
	int i;
	for (i=0; i <64 ; i++) {
		obj->lft[i] = *(val+i);
	}
}
    return (uint8_array_t *) val;
}
static int _wrap_ib_lft_record_t_lft_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    ib_lft_record_t * _arg0;
    uint8_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  entrys[64];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_lft_set { ib_lft_record_t * } { uint8_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_lft_set. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 64))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > 0xff)
    {
      printf("Error: wrong format or out of range value for expected uint8_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = entry;
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 64; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_array_t *)_ib_lft_record_lft_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <64 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_lft_record_lft_get(_swigobj) ((uint8_array_t *) _swigobj->lft)
static int _wrap_ib_lft_record_t_lft_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_array_t * _result;
    ib_lft_record_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_lft_record_t_lft_get { ib_lft_record_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_lft_record_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_lft_record_t_lft_get. Expected _ib_lft_record_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_array_t *)_ib_lft_record_lft_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[8];
  for (i=0; i <64 ; i++) {
    sprintf(buff, "0x%02x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int Tclib_lft_record_tMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"ib_lft_record_t methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_ib_lft_record_t_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_ib_lft_record_t_lid_set;
                }  else if (strcmp(_str,"-block_num") == 0) {
                    cmd = _wrap_ib_lft_record_t_block_num_set;
                }  else if (strcmp(_str,"-resv0") == 0) {
                    cmd = _wrap_ib_lft_record_t_resv0_set;
                }  else if (strcmp(_str,"-lft") == 0) {
                    cmd = _wrap_ib_lft_record_t_lft_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -lid -block_num -resv0 -lft  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -lid -block_num -resv0 -lft  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-lid") == 0) {
                    cmd = _wrap_ib_lft_record_t_lid_get;
                }  else if (strcmp(_str,"-block_num") == 0) {
                    cmd = _wrap_ib_lft_record_t_block_num_get;
                }  else if (strcmp(_str,"-resv0") == 0) {
                    cmd = _wrap_ib_lft_record_t_resv0_get;
                }  else if (strcmp(_str,"-lft") == 0) {
                    cmd = _wrap_ib_lft_record_t_lft_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_ib_lft_record_t_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -lid -block_num -resv0 -lft  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -lid -block_num -resv0 -lft  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_ib_lft_record_t_lid_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lid ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_lft_record_t_block_num_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-block_num ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_lft_record_t_resv0_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-resv0 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_lft_record_t_lft_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lft ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int Tclib_lft_record_tCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    ib_lft_record_t * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_ib_lft_record_t_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_ib_lft_record_t_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a ib_lft_record_t object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, Tclib_lft_record_tMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define _ib_pm_counters_mad_header_set(_swigobj,_swigval) (_swigobj->mad_header = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_mad_header_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_mad_t * _result;
    ib_pm_counters_t * _arg0;
    ib_mad_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_mad_header_set { ib_pm_counters_t * } { ib_mad_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_mad_header_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[2],(void **) &_arg1,"_ib_mad_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 2 of ib_pm_counters_t_mad_header_set. Expected _ib_mad_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_mad_t *)_ib_pm_counters_mad_header_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_ib_mad_t_p");
    return TCL_OK;
}
#define _ib_pm_counters_mad_header_get(_swigobj) (&_swigobj->mad_header)
static int _wrap_ib_pm_counters_t_mad_header_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_mad_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_mad_header_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_mad_header_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_mad_t *)_ib_pm_counters_mad_header_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_ib_mad_t_p");
    return TCL_OK;
}
static uint32_array_t * _ib_pm_counters_reserved0_set(ib_pm_counters_t *obj, uint32_array_t val[10]) {
{
	int i;
	for (i=0; i <10 ; i++) {
		obj->reserved0[i] = *(val+i);
	}
}
    return (uint32_array_t *) val;
}
static int _wrap_ib_pm_counters_t_reserved0_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_array_t * _result;
    ib_pm_counters_t * _arg0;
    uint32_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint32_t  entrys[10];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved0_set { ib_pm_counters_t * } { uint32_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved0_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 10))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > (long int)0xffffffff)
    {
      printf("Error: wrong format or out of range value for expected uint32_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = entry;
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 10; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  ibms_tcl_error = 0;
      _result = (uint32_array_t *)_ib_pm_counters_reserved0_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[12];
  for (i=0; i <10 ; i++) {
    sprintf(buff, "0x%08x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved0_get(_swigobj) ((uint32_array_t *) _swigobj->reserved0)
static int _wrap_ib_pm_counters_t_reserved0_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_array_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved0_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved0_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint32_array_t *)_ib_pm_counters_reserved0_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[12];
  for (i=0; i <10 ; i++) {
    sprintf(buff, "0x%08x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved1_set(_swigobj,_swigval) (_swigobj->reserved1 = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_reserved1_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved1_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved1_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_reserved1_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved1_get(_swigobj) (&_swigobj->reserved1)
static int _wrap_ib_pm_counters_t_reserved1_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved1_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved1_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_reserved1_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_select_set(_swigobj,_swigval) (_swigobj->port_select = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_select_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_select_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_select_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_port_select_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_select_get(_swigobj) (&_swigobj->port_select)
static int _wrap_ib_pm_counters_t_port_select_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_select_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_select_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_port_select_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_counter_select_set(_swigobj,_swigval) (_swigobj->counter_select = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_counter_select_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_counter_select_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_counter_select_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_counter_select_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_counter_select_get(_swigobj) (&_swigobj->counter_select)
static int _wrap_ib_pm_counters_t_counter_select_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_counter_select_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_counter_select_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_counter_select_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_symbol_error_counter_set(_swigobj,_swigval) (_swigobj->symbol_error_counter = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_symbol_error_counter_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_symbol_error_counter_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_symbol_error_counter_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_symbol_error_counter_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_symbol_error_counter_get(_swigobj) (&_swigobj->symbol_error_counter)
static int _wrap_ib_pm_counters_t_symbol_error_counter_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_symbol_error_counter_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_symbol_error_counter_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_symbol_error_counter_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_link_error_recovery_counter_set(_swigobj,_swigval) (_swigobj->link_error_recovery_counter = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_link_error_recovery_counter_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_link_error_recovery_counter_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_link_error_recovery_counter_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_link_error_recovery_counter_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_link_error_recovery_counter_get(_swigobj) (&_swigobj->link_error_recovery_counter)
static int _wrap_ib_pm_counters_t_link_error_recovery_counter_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_link_error_recovery_counter_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_link_error_recovery_counter_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_link_error_recovery_counter_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_link_down_counter_set(_swigobj,_swigval) (_swigobj->link_down_counter = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_link_down_counter_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_link_down_counter_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_link_down_counter_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_link_down_counter_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_link_down_counter_get(_swigobj) (&_swigobj->link_down_counter)
static int _wrap_ib_pm_counters_t_link_down_counter_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_link_down_counter_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_link_down_counter_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_link_down_counter_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_errors_set(_swigobj,_swigval) (_swigobj->port_rcv_errors = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_rcv_errors_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_errors_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_errors_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_rcv_errors_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_errors_get(_swigobj) (&_swigobj->port_rcv_errors)
static int _wrap_ib_pm_counters_t_port_rcv_errors_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_errors_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_errors_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_rcv_errors_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_remote_physical_errors_set(_swigobj,_swigval) (_swigobj->port_rcv_remote_physical_errors = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_rcv_remote_physical_errors_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_remote_physical_errors_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_remote_physical_errors_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_rcv_remote_physical_errors_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_remote_physical_errors_get(_swigobj) (&_swigobj->port_rcv_remote_physical_errors)
static int _wrap_ib_pm_counters_t_port_rcv_remote_physical_errors_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_remote_physical_errors_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_remote_physical_errors_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_rcv_remote_physical_errors_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_switch_relay_errors_set(_swigobj,_swigval) (_swigobj->port_rcv_switch_relay_errors = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_rcv_switch_relay_errors_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_switch_relay_errors_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_switch_relay_errors_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_rcv_switch_relay_errors_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_switch_relay_errors_get(_swigobj) (&_swigobj->port_rcv_switch_relay_errors)
static int _wrap_ib_pm_counters_t_port_rcv_switch_relay_errors_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_switch_relay_errors_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_switch_relay_errors_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_rcv_switch_relay_errors_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_discard_set(_swigobj,_swigval) (_swigobj->port_xmit_discard = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_xmit_discard_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_discard_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_discard_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_xmit_discard_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_discard_get(_swigobj) (&_swigobj->port_xmit_discard)
static int _wrap_ib_pm_counters_t_port_xmit_discard_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_discard_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_discard_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_port_xmit_discard_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_constraint_errors_set(_swigobj,_swigval) (_swigobj->port_xmit_constraint_errors = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_xmit_constraint_errors_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_constraint_errors_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_constraint_errors_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_port_xmit_constraint_errors_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_constraint_errors_get(_swigobj) (&_swigobj->port_xmit_constraint_errors)
static int _wrap_ib_pm_counters_t_port_xmit_constraint_errors_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_constraint_errors_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_constraint_errors_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_port_xmit_constraint_errors_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_constraint_errors_set(_swigobj,_swigval) (_swigobj->port_rcv_constraint_errors = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_rcv_constraint_errors_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_constraint_errors_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_constraint_errors_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_port_rcv_constraint_errors_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_constraint_errors_get(_swigobj) (&_swigobj->port_rcv_constraint_errors)
static int _wrap_ib_pm_counters_t_port_rcv_constraint_errors_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_constraint_errors_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_constraint_errors_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_port_rcv_constraint_errors_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved2_set(_swigobj,_swigval) (_swigobj->reserved2 = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_reserved2_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved2_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved2_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_reserved2_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved2_get(_swigobj) (&_swigobj->reserved2)
static int _wrap_ib_pm_counters_t_reserved2_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved2_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved2_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_reserved2_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_lli_errors_exc_buf_errors_set(_swigobj,_swigval) (_swigobj->lli_errors_exc_buf_errors = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_lli_errors_exc_buf_errors_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_lli_errors_exc_buf_errors_set { ib_pm_counters_t * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_lli_errors_exc_buf_errors_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_lli_errors_exc_buf_errors_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_lli_errors_exc_buf_errors_get(_swigobj) (&_swigobj->lli_errors_exc_buf_errors)
static int _wrap_ib_pm_counters_t_lli_errors_exc_buf_errors_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_lli_errors_exc_buf_errors_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_lli_errors_exc_buf_errors_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)_ib_pm_counters_lli_errors_exc_buf_errors_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved3_set(_swigobj,_swigval) (_swigobj->reserved3 = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_reserved3_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved3_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved3_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_reserved3_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved3_get(_swigobj) (&_swigobj->reserved3)
static int _wrap_ib_pm_counters_t_reserved3_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved3_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved3_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_reserved3_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_vl15_dropped_set(_swigobj,_swigval) (_swigobj->vl15_dropped = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_vl15_dropped_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_vl15_dropped_set { ib_pm_counters_t * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_vl15_dropped_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_vl15_dropped_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_vl15_dropped_get(_swigobj) (&_swigobj->vl15_dropped)
static int _wrap_ib_pm_counters_t_vl15_dropped_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_vl15_dropped_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_vl15_dropped_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)_ib_pm_counters_vl15_dropped_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_data_set(_swigobj,_swigval) (_swigobj->port_xmit_data = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_xmit_data_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_data_set { ib_pm_counters_t * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_data_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_xmit_data_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_data_get(_swigobj) (&_swigobj->port_xmit_data)
static int _wrap_ib_pm_counters_t_port_xmit_data_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_data_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_data_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_xmit_data_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_data_set(_swigobj,_swigval) (_swigobj->port_rcv_data = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_rcv_data_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_data_set { ib_pm_counters_t * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_data_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_rcv_data_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_data_get(_swigobj) (&_swigobj->port_rcv_data)
static int _wrap_ib_pm_counters_t_port_rcv_data_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_data_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_data_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_rcv_data_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_pkts_set(_swigobj,_swigval) (_swigobj->port_xmit_pkts = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_xmit_pkts_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_pkts_set { ib_pm_counters_t * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_pkts_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_xmit_pkts_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_xmit_pkts_get(_swigobj) (&_swigobj->port_xmit_pkts)
static int _wrap_ib_pm_counters_t_port_xmit_pkts_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_xmit_pkts_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_xmit_pkts_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_xmit_pkts_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_pkts_set(_swigobj,_swigval) (_swigobj->port_rcv_pkts = *(_swigval),_swigval)
static int _wrap_ib_pm_counters_t_port_rcv_pkts_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_pkts_set { ib_pm_counters_t * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_pkts_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_rcv_pkts_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define _ib_pm_counters_port_rcv_pkts_get(_swigobj) (&_swigobj->port_rcv_pkts)
static int _wrap_ib_pm_counters_t_port_rcv_pkts_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_port_rcv_pkts_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_port_rcv_pkts_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)_ib_pm_counters_port_rcv_pkts_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
static uint32_array_t * _ib_pm_counters_reserved5_set(ib_pm_counters_t *obj, uint32_array_t val[38]) {
{
	int i;
	for (i=0; i <38 ; i++) {
		obj->reserved5[i] = *(val+i);
	}
}
    return (uint32_array_t *) val;
}
static int _wrap_ib_pm_counters_t_reserved5_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_array_t * _result;
    ib_pm_counters_t * _arg0;
    uint32_array_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint32_t  entrys[38];

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved5_set { ib_pm_counters_t * } { uint32_array_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved5_set. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char *buff;
  char *p_ch;
  char *last;
  long int entry;

  int i = 0;
  buff = (char *)malloc((strlen(Tcl_GetStringFromObj(objv[2],NULL))+1)*sizeof(char));
  strcpy(buff, Tcl_GetStringFromObj(objv[2],NULL));
  p_ch = strtok_r(buff, " \t",&last);
  while (p_ch && (i < 38))
  {
    entry = strtol(p_ch, NULL, 0);
    if (entry > (long int)0xffffffff)
    {
      printf("Error: wrong format or out of range value for expected uint32_t entry: %s\n", p_ch);
      return TCL_ERROR;
    }
    entrys[i++] = entry;
    p_ch = strtok_r(NULL, " \t", &last);
  }
  for (; i < 38; i++) entrys[i] = 0;

  free(buff);
  _arg1 = entrys;
}
{
  ibms_tcl_error = 0;
      _result = (uint32_array_t *)_ib_pm_counters_reserved5_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[12];
  for (i=0; i <38 ; i++) {
    sprintf(buff, "0x%08x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
#define _ib_pm_counters_reserved5_get(_swigobj) ((uint32_array_t *) _swigobj->reserved5)
static int _wrap_ib_pm_counters_t_reserved5_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint32_array_t * _result;
    ib_pm_counters_t * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. ib_pm_counters_t_reserved5_get { ib_pm_counters_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of ib_pm_counters_t_reserved5_get. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (uint32_array_t *)_ib_pm_counters_reserved5_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  int i;
  char buff[12];
  for (i=0; i <38 ; i++) {
    sprintf(buff, "0x%08x ", *(_result+i));
    Tcl_AppendResult(interp, buff, NULL);
  }
}
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int Tclib_pm_counters_tMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"ib_pm_counters_t methods : { dump cget configure  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_ib_pm_counters_t_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);

    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);
                        if (strcmp(_str,"-mad_header") == 0) {
                    cmd = _wrap_ib_pm_counters_t_mad_header_set;
                }  else if (strcmp(_str,"-reserved0") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved0_set;
                }  else if (strcmp(_str,"-reserved1") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved1_set;
                }  else if (strcmp(_str,"-port_select") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_select_set;
                }  else if (strcmp(_str,"-counter_select") == 0) {
                    cmd = _wrap_ib_pm_counters_t_counter_select_set;
                }  else if (strcmp(_str,"-symbol_error_counter") == 0) {
                    cmd = _wrap_ib_pm_counters_t_symbol_error_counter_set;
                }  else if (strcmp(_str,"-link_error_recovery_counter") == 0) {
                    cmd = _wrap_ib_pm_counters_t_link_error_recovery_counter_set;
                }  else if (strcmp(_str,"-link_down_counter") == 0) {
                    cmd = _wrap_ib_pm_counters_t_link_down_counter_set;
                }  else if (strcmp(_str,"-port_rcv_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_errors_set;
                }  else if (strcmp(_str,"-port_rcv_remote_physical_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_remote_physical_errors_set;
                }  else if (strcmp(_str,"-port_rcv_switch_relay_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_switch_relay_errors_set;
                }  else if (strcmp(_str,"-port_xmit_discard") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_discard_set;
                }  else if (strcmp(_str,"-port_xmit_constraint_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_constraint_errors_set;
                }  else if (strcmp(_str,"-port_rcv_constraint_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_constraint_errors_set;
                }  else if (strcmp(_str,"-reserved2") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved2_set;
                }  else if (strcmp(_str,"-lli_errors_exc_buf_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_lli_errors_exc_buf_errors_set;
                }  else if (strcmp(_str,"-reserved3") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved3_set;
                }  else if (strcmp(_str,"-vl15_dropped") == 0) {
                    cmd = _wrap_ib_pm_counters_t_vl15_dropped_set;
                }  else if (strcmp(_str,"-port_xmit_data") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_data_set;
                }  else if (strcmp(_str,"-port_rcv_data") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_data_set;
                }  else if (strcmp(_str,"-port_xmit_pkts") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_pkts_set;
                }  else if (strcmp(_str,"-port_rcv_pkts") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_pkts_set;
                }  else if (strcmp(_str,"-reserved5") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved5_set;
                }
          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be { -mad_header -reserved0 -reserved1 -port_select -counter_select -symbol_error_counter -link_error_recovery_counter -link_down_counter -port_rcv_errors -port_rcv_remote_physical_errors -port_rcv_switch_relay_errors -port_xmit_discard -port_xmit_constraint_errors -port_rcv_constraint_errors -reserved2 -lli_errors_exc_buf_errors -reserved3 -vl15_dropped -port_xmit_data -port_rcv_data -port_xmit_pkts -port_rcv_pkts -reserved5  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{ -mad_header -reserved0 -reserved1 -port_select -counter_select -symbol_error_counter -link_error_recovery_counter -link_down_counter -port_rcv_errors -port_rcv_remote_physical_errors -port_rcv_switch_relay_errors -port_xmit_discard -port_xmit_constraint_errors -port_rcv_constraint_errors -reserved2 -lli_errors_exc_buf_errors -reserved3 -vl15_dropped -port_xmit_data -port_rcv_data -port_xmit_pkts -port_rcv_pkts -reserved5  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}
                        if (strcmp(_str,"-mad_header") == 0) {
                    cmd = _wrap_ib_pm_counters_t_mad_header_get;
                }  else if (strcmp(_str,"-reserved0") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved0_get;
                }  else if (strcmp(_str,"-reserved1") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved1_get;
                }  else if (strcmp(_str,"-port_select") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_select_get;
                }  else if (strcmp(_str,"-counter_select") == 0) {
                    cmd = _wrap_ib_pm_counters_t_counter_select_get;
                }  else if (strcmp(_str,"-symbol_error_counter") == 0) {
                    cmd = _wrap_ib_pm_counters_t_symbol_error_counter_get;
                }  else if (strcmp(_str,"-link_error_recovery_counter") == 0) {
                    cmd = _wrap_ib_pm_counters_t_link_error_recovery_counter_get;
                }  else if (strcmp(_str,"-link_down_counter") == 0) {
                    cmd = _wrap_ib_pm_counters_t_link_down_counter_get;
                }  else if (strcmp(_str,"-port_rcv_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_errors_get;
                }  else if (strcmp(_str,"-port_rcv_remote_physical_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_remote_physical_errors_get;
                }  else if (strcmp(_str,"-port_rcv_switch_relay_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_switch_relay_errors_get;
                }  else if (strcmp(_str,"-port_xmit_discard") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_discard_get;
                }  else if (strcmp(_str,"-port_xmit_constraint_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_constraint_errors_get;
                }  else if (strcmp(_str,"-port_rcv_constraint_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_constraint_errors_get;
                }  else if (strcmp(_str,"-reserved2") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved2_get;
                }  else if (strcmp(_str,"-lli_errors_exc_buf_errors") == 0) {
                    cmd = _wrap_ib_pm_counters_t_lli_errors_exc_buf_errors_get;
                }  else if (strcmp(_str,"-reserved3") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved3_get;
                }  else if (strcmp(_str,"-vl15_dropped") == 0) {
                    cmd = _wrap_ib_pm_counters_t_vl15_dropped_get;
                }  else if (strcmp(_str,"-port_xmit_data") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_data_get;
                }  else if (strcmp(_str,"-port_rcv_data") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_data_get;
                }  else if (strcmp(_str,"-port_xmit_pkts") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_xmit_pkts_get;
                }  else if (strcmp(_str,"-port_rcv_pkts") == 0) {
                    cmd = _wrap_ib_pm_counters_t_port_rcv_pkts_get;
                }  else if (strcmp(_str,"-reserved5") == 0) {
                    cmd = _wrap_ib_pm_counters_t_reserved5_get;
                }
          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_ib_pm_counters_t_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this -mad_header -reserved0 -reserved1 -port_select -counter_select -symbol_error_counter -link_error_recovery_counter -link_down_counter -port_rcv_errors -port_rcv_remote_physical_errors -port_rcv_switch_relay_errors -port_xmit_discard -port_xmit_constraint_errors -port_rcv_constraint_errors -reserved2 -lli_errors_exc_buf_errors -reserved3 -vl15_dropped -port_xmit_data -port_rcv_data -port_xmit_pkts -port_rcv_pkts -reserved5  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this -mad_header -reserved0 -reserved1 -port_select -counter_select -symbol_error_counter -link_error_recovery_counter -link_down_counter -port_rcv_errors -port_rcv_remote_physical_errors -port_rcv_switch_relay_errors -port_xmit_discard -port_xmit_constraint_errors -port_rcv_constraint_errors -reserved2 -lli_errors_exc_buf_errors -reserved3 -vl15_dropped -port_xmit_data -port_rcv_data -port_xmit_pkts -port_rcv_pkts -reserved5  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);
                cmd = _wrap_ib_pm_counters_t_mad_header_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-mad_header ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_reserved0_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved0 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_reserved1_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved1 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_select_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_select ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_counter_select_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-counter_select ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_symbol_error_counter_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-symbol_error_counter ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_link_error_recovery_counter_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_error_recovery_counter ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_link_down_counter_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-link_down_counter ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_rcv_errors_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_rcv_errors ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_rcv_remote_physical_errors_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_rcv_remote_physical_errors ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_rcv_switch_relay_errors_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_rcv_switch_relay_errors ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_xmit_discard_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_xmit_discard ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_xmit_constraint_errors_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_xmit_constraint_errors ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_rcv_constraint_errors_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_rcv_constraint_errors ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_reserved2_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved2 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_lli_errors_exc_buf_errors_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-lli_errors_exc_buf_errors ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_reserved3_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved3 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_vl15_dropped_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-vl15_dropped ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_xmit_data_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_xmit_data ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_rcv_data_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_rcv_data ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_xmit_pkts_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_xmit_pkts ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_port_rcv_pkts_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-port_rcv_pkts ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);
        cmd = _wrap_ib_pm_counters_t_reserved5_get;
        oldarg = objv[2];
        objv[2] = obj;
        rcode = (*cmd)(clientData,interp,objc,&objv[1]);
        objv[2] = oldarg;
        Tcl_AppendStringsToObj(pDumpObj, "-reserved5 ", Tcl_GetStringFromObj(tcl_result, NULL), " ", NULL);
        Tcl_SetStringObj(tcl_result, Tcl_GetStringFromObj(pDumpObj, NULL), -1);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int Tclib_pm_counters_tCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    ib_pm_counters_t * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_ib_pm_counters_t_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_ib_pm_counters_t_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a ib_pm_counters_t object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, Tclib_pm_counters_tMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define msgManager_getVerbLevel(_swigobj,_swigarg0)  (_swigobj->getVerbLevel(_swigarg0))
static int _wrap_msgManager_getVerbLevel(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    msgManager * _arg0;
    string * _arg1 = &MsgAllModules;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_getVerbLevel { msgManager * } ?module? ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_getVerbLevel. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (objc >2) {
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
    }
{
  ibms_tcl_error = 0;
      _result = (int )msgManager_getVerbLevel(_arg0,*_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define msgManager_clrVerbLevel(_swigobj,_swigarg0)  (_swigobj->clrVerbLevel(_swigarg0))
static int _wrap_msgManager_clrVerbLevel(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    msgManager * _arg0;
    string * _arg1 = &MsgAllModules;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_clrVerbLevel { msgManager * } ?module? ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_clrVerbLevel. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (objc >2) {
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
    }
{
  ibms_tcl_error = 0;
      _result = (int )msgManager_clrVerbLevel(_arg0,*_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define msgManager_setVerbLevel(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setVerbLevel(_swigarg0,_swigarg1))
static int _wrap_msgManager_setVerbLevel(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    msgManager * _arg0;
    int  _arg1;
    string * _arg2 = &MsgAllModules;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_setVerbLevel { msgManager * } vl ?module? ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_setVerbLevel. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    if (objc >3) {
{
  int len;
  static string _arg2_tmp;
  _arg2_tmp = string(Tcl_GetStringFromObj(objv[3],&len));
  _arg2 = &_arg2_tmp;
}
    }
{
  ibms_tcl_error = 0;
      msgManager_setVerbLevel(_arg0,_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define msgManager_outstandingMsgCount(_swigobj,_swigarg0)  (_swigobj->outstandingMsgCount(_swigarg0))
static int _wrap_msgManager_outstandingMsgCount(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    msgManager * _arg0;
    int  _arg1 = (0x01)|(0x02);
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_outstandingMsgCount { msgManager * } ?vl? ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_outstandingMsgCount. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (objc >2) {
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    }
{
  ibms_tcl_error = 0;
      _result = (int )msgManager_outstandingMsgCount(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define msgManager_outstandingMsgs(_swigobj,_swigarg0)  (_swigobj->outstandingMsgs(_swigarg0))
static int _wrap_msgManager_outstandingMsgs(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    msgManager * _arg0;
    int  _arg1 = (0x01)|(0x02);
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_outstandingMsgs { msgManager * } ?vl? ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_outstandingMsgs. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if (objc >2) {
    if (Tcl_GetIntFromObj(interp,objv[2],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg1 = (int ) tempint;
    }
{
  ibms_tcl_error = 0;
      _result = new string (msgManager_outstandingMsgs(_arg0,_arg1));
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define msgManager_getNextMessage(_swigobj)  (_swigobj->getNextMessage())
static int _wrap_msgManager_getNextMessage(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    string * _result;
    msgManager * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_getNextMessage { msgManager * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_getNextMessage. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = new string (msgManager_getNextMessage(_arg0));
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
	char ezTmp[1024];
	strcpy(ezTmp, _result->c_str());
	Tcl_SetStringObj(tcl_result, ezTmp, strlen(ezTmp));
}
    return TCL_OK;
}
#define msgManager_nullOutstandingMsgs(_swigobj)  (_swigobj->nullOutstandingMsgs())
static int _wrap_msgManager_nullOutstandingMsgs(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    msgManager * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_nullOutstandingMsgs { msgManager * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_nullOutstandingMsgs. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      msgManager_nullOutstandingMsgs(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int  msgManager_setLogFile(msgManager *self,char * fileName) {
    std::ofstream *pos = new ofstream(fileName);
    if (pos)
    {
      self->setOutStream(pos);
      return 0;
    }
    else
      return 1;
  }
static int _wrap_msgManager_setLogFile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    msgManager * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. msgManager_setLogFile { msgManager * } fileName ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_msgManager_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of msgManager_setLogFile. Expected _msgManager_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  ibms_tcl_error = 0;
      _result = (int )msgManager_setLogFile(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclmsgManagerMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"msgManager methods : { dump cget configure getVerbLevel clrVerbLevel setVerbLevel outstandingMsgCount outstandingMsgs getNextMessage nullOutstandingMsgs setLogFile  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_msgManager_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"getVerbLevel") == 0) {
        cmd = _wrap_msgManager_getVerbLevel;
    }    else if (strcmp(_str,"clrVerbLevel") == 0) {
        cmd = _wrap_msgManager_clrVerbLevel;
    }    else if (strcmp(_str,"setVerbLevel") == 0) {
        cmd = _wrap_msgManager_setVerbLevel;
    }    else if (strcmp(_str,"outstandingMsgCount") == 0) {
        cmd = _wrap_msgManager_outstandingMsgCount;
    }    else if (strcmp(_str,"outstandingMsgs") == 0) {
        cmd = _wrap_msgManager_outstandingMsgs;
    }    else if (strcmp(_str,"getNextMessage") == 0) {
        cmd = _wrap_msgManager_getNextMessage;
    }    else if (strcmp(_str,"nullOutstandingMsgs") == 0) {
        cmd = _wrap_msgManager_nullOutstandingMsgs;
    }    else if (strcmp(_str,"setLogFile") == 0) {
        cmd = _wrap_msgManager_setLogFile;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);

          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be {  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}

          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_msgManager_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure getVerbLevel clrVerbLevel setVerbLevel outstandingMsgCount outstandingMsgs getNextMessage nullOutstandingMsgs setLogFile }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclmsgManagerCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    msgManager * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_msgManager_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_msgManager_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a msgManager object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclmsgManagerMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBMgtSim_getFabric(_swigobj)  (_swigobj->getFabric())
static int _wrap_IBMgtSim_getFabric(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBFabric * _result;
    IBMgtSim * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMgtSim_getFabric { IBMgtSim * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_IBMgtSim_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of IBMgtSim_getFabric. Expected _IBMgtSim_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (IBFabric *)IBMgtSim_getFabric(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBFabric *");
}
    return TCL_OK;
}
#define IBMgtSim_getServer(_swigobj)  (_swigobj->getServer())
static int _wrap_IBMgtSim_getServer(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBMSServer * _result;
    IBMgtSim * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMgtSim_getServer { IBMgtSim * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_IBMgtSim_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of IBMgtSim_getServer. Expected _IBMgtSim_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (IBMSServer *)IBMgtSim_getServer(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_IBMSServer_p");
    return TCL_OK;
}
#define IBMgtSim_getDispatcher(_swigobj)  (_swigobj->getDispatcher())
static int _wrap_IBMgtSim_getDispatcher(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBMSDispatcher * _result;
    IBMgtSim * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMgtSim_getDispatcher { IBMgtSim * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_IBMgtSim_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of IBMgtSim_getDispatcher. Expected _IBMgtSim_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (IBMSDispatcher *)IBMgtSim_getDispatcher(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_IBMSDispatcher_p");
    return TCL_OK;
}
static int  IBMgtSim_init(IBMgtSim *self,string  topoFileName,int  serverPortNum,int  numWorkers) {
    int res =
      self->init(topoFileName, serverPortNum, numWorkers);
    if (! res)
      ibdm_fabrics.push_back(self->getFabric());
    return res;
  }
static int _wrap_IBMgtSim_init(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMgtSim * _arg0;
    string * _arg1;
    int  _arg2;
    int  _arg3;
    Tcl_Obj * tcl_result;
    char * rettype;
    int tempint;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMgtSim_init { IBMgtSim * } topoFileName serverPortNum numWorkers ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_IBMgtSim_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of IBMgtSim_init. Expected _IBMgtSim_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  int len;
  static string _arg1_tmp;
  _arg1_tmp = string(Tcl_GetStringFromObj(objv[2],&len));
  _arg1 = &_arg1_tmp;
}
    if (Tcl_GetIntFromObj(interp,objv[3],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg2 = (int ) tempint;
    if (Tcl_GetIntFromObj(interp,objv[4],&tempint) == TCL_ERROR) return TCL_ERROR;
    _arg3 = (int ) tempint;
{
  ibms_tcl_error = 0;
      _result = (int )IBMgtSim_init(_arg0,*_arg1,_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBMgtSimMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBMgtSim methods : { dump cget configure getFabric getServer getDispatcher init  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBMgtSim_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"getFabric") == 0) {
        cmd = _wrap_IBMgtSim_getFabric;
    }    else if (strcmp(_str,"getServer") == 0) {
        cmd = _wrap_IBMgtSim_getServer;
    }    else if (strcmp(_str,"getDispatcher") == 0) {
        cmd = _wrap_IBMgtSim_getDispatcher;
    }    else if (strcmp(_str,"init") == 0) {
        cmd = _wrap_IBMgtSim_init;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);

          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be {  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}

          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBMgtSim_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure getFabric getServer getDispatcher init }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBMgtSimCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBMgtSim * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBMgtSim_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBMgtSim_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBMgtSim object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBMgtSimMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define IBMSNode_getIBNode(_swigobj)  (_swigobj->getIBNode())
static int _wrap_IBMSNode_getIBNode(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    IBNode * _result;
    IBMSNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getIBNode { IBMSNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibms_tcl_error = 0;
      _result = (IBNode *)IBMSNode_getIBNode(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  if (_result)
	 ibdmGetObjTclNameByPtr(tcl_result, _result, "IBNode *");
}
    return TCL_OK;
}
#define IBMSNode_getLinkStatus(_swigobj,_swigarg0)  (_swigobj->getLinkStatus(_swigarg0))
static int _wrap_IBMSNode_getLinkStatus(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getLinkStatus { IBMSNode * } outPortNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_getLinkStatus(_arg0,*_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_setPhyPortErrProfile(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setPhyPortErrProfile(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_setPhyPortErrProfile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    IBMSPortErrProfile * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    IBMSPortErrProfile  tmp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setPhyPortErrProfile { IBMSNode * } portNum errProfileIn ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  if (sscanf(Tcl_GetStringFromObj(objv[3],0),
             "-drop-rate-avg %g -drop-rate-var %g",
             &tmp.packetDropRate,
             &tmp.packetDropRateVar) != 2)
  {
	 char err[256];
	 sprintf(err, "-E- bad format for IBMSPortErrProfile:%s",
            Tcl_GetStringFromObj(objv[3],0));
    Tcl_SetStringObj(tcl_result, err, strlen(err));
    return TCL_ERROR;
  }

  _arg2 = &tmp;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setPhyPortErrProfile(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getPhyPortErrProfile(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getPhyPortErrProfile(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_getPhyPortErrProfile(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    IBMSPortErrProfile * _arg2;
    IBMSPortErrProfile  temp;
    Tcl_Obj * tcl_result;
    uint8_t  temp0;

    clientData = clientData; objv = objv;
{
  _arg2 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getPhyPortErrProfile { IBMSNode * } portNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_getPhyPortErrProfile(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
    /* argout */
  char buff[128];
  if (_arg2) {
    sprintf(buff, "-drop-rate-avg %g -drop-rate-var %g",
            _arg2->packetDropRate,
            _arg2->packetDropRateVar);
    Tcl_SetStringObj(tcl_result, buff, strlen(buff));
  }
}
    return TCL_OK;
}
#define IBMSNode_setPhyPortPMCounter(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setPhyPortPMCounter(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_setPhyPortPMCounter(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint32_t * _arg2;
    ib_pm_counters_t * _arg3;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint32_t  temp0;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setPhyPortPMCounter { IBMSNode * } portNum counterSelect countersVal ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
    if ((rettype = SWIG_GetPointerObj(interp,objv[4],(void **) &_arg3,"_ib_pm_counters_t_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 4 of IBMSNode_setPhyPortPMCounter. Expected _ib_pm_counters_t_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setPhyPortPMCounter(_arg0,*_arg1,*_arg2,*_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getPhyPortPMCounter(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getPhyPortPMCounter(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_getPhyPortPMCounter(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_pm_counters_t * _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint32_t * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint32_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getPhyPortPMCounter { IBMSNode * } portNum counterSelect ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibms_tcl_error = 0;
      _result = (ib_pm_counters_t *)IBMSNode_getPhyPortPMCounter(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_ib_pm_counters_t_p");
    return TCL_OK;
}
#define IBMSNode_getPortInfo(_swigobj,_swigarg0)  (_swigobj->getPortInfo(_swigarg0))
static int _wrap_IBMSNode_getPortInfo(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_port_info_t * _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getPortInfo { IBMSNode * } portNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_port_info_t *)IBMSNode_getPortInfo(_arg0,*_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_ib_port_info_t_p");
    return TCL_OK;
}
#define IBMSNode_setLinkStatus(_swigobj,_swigarg0,_swigarg1)  (_swigobj->setLinkStatus(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_setLinkStatus(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint8_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setLinkStatus { IBMSNode * } portNum newState ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setLinkStatus(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getNodeInfo(_swigobj)  (_swigobj->getNodeInfo())
static int _wrap_IBMSNode_getNodeInfo(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_node_info_t * _result;
    IBMSNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getNodeInfo { IBMSNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibms_tcl_error = 0;
      _result = (ib_node_info_t *)IBMSNode_getNodeInfo(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_ib_node_info_t_p");
    return TCL_OK;
}
#define IBMSNode_getSwitchInfo(_swigobj)  (_swigobj->getSwitchInfo())
static int _wrap_IBMSNode_getSwitchInfo(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_switch_info_t * _result;
    IBMSNode * _arg0;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getSwitchInfo { IBMSNode * } ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  ibms_tcl_error = 0;
      _result = (ib_switch_info_t *)IBMSNode_getSwitchInfo(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_ib_switch_info_t_p");
    return TCL_OK;
}
#define IBMSNode_getGuidInfoBlock(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getGuidInfoBlock(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_getGuidInfoBlock(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_guid_info_t * _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint16_t * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getGuidInfoBlock { IBMSNode * } portNum blockNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibms_tcl_error = 0;
      _result = (ib_guid_info_t *)IBMSNode_getGuidInfoBlock(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[36];
  int i;
  if (_result != NULL)
  {
    for (i = 0; i < 8; i++)
    {
      sprintf(buff, "0x%016" PRIx64, cl_ntoh64(_result->guid[i]));
      Tcl_AppendToObj(tcl_result,buff,strlen(buff));
    }
  }
  else
  {
    Tcl_SetStringObj(tcl_result, "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0", 64);
  }
}
    return TCL_OK;
}
#define IBMSNode_setGuidInfoBlock(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setGuidInfoBlock(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_setGuidInfoBlock(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint16_t * _arg2;
    ib_guid_info_t * _arg3;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0;
    ib_guid_info_t  tmp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setGuidInfoBlock { IBMSNode * } portNum blockNum tbl ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  char buf[256];
  char *p_guid;
  char *str_token = NULL;
  int i = 0;
  memset(&tmp, 0, sizeof(ib_guid_info_t));

  strncpy(buf, Tcl_GetStringFromObj(objv[4],NULL), 255);
  buf[255] = '\0';
  p_guid = strtok_r(buf," ", &str_token);
  while (p_guid && (i < 8))
  {
    errno = 0;
    tmp.guid[i++] = cl_hton64(strtoul(p_guid, NULL, 0));
    if (errno) {
      printf("Wrong format for guid:%s\n", p_guid);
      return TCL_ERROR;
    }

    p_guid = strtok_r(NULL," ", &str_token);
  }
  _arg3 = &tmp;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setGuidInfoBlock(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getPKeyTblBlock(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getPKeyTblBlock(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_getPKeyTblBlock(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_pkey_table_t * _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint16_t * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getPKeyTblBlock { IBMSNode * } portNum blockNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibms_tcl_error = 0;
      _result = (ib_pkey_table_t *)IBMSNode_getPKeyTblBlock(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[36];
  int i;
  if (_result != NULL)
  {
    for (i = 0; i < 32; i++)
    {
      sprintf(buff, "0x%04x ", cl_ntoh16(_result->pkey_entry[i]));
      Tcl_AppendToObj(tcl_result,buff,strlen(buff));
    }
  }
  else
  {
    Tcl_SetStringObj(tcl_result, "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0", 64);
  }
}
    return TCL_OK;
}
#define IBMSNode_setPKeyTblBlock(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setPKeyTblBlock(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_setPKeyTblBlock(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint16_t * _arg2;
    ib_pkey_table_t * _arg3;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint16_t  temp0;
    ib_pkey_table_t  tmp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setPKeyTblBlock { IBMSNode * } portNum blockNum tbl ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  char buf[256];
  char *p_pkey;
  char *str_token = NULL;
  int i = 0;
  memset(&tmp, 0, sizeof(ib_pkey_table_t));

  strncpy(buf, Tcl_GetStringFromObj(objv[4],NULL), 255);
  buf[255] = '\0';
  p_pkey = strtok_r(buf," ", &str_token);
  while (p_pkey && (i < 32))
  {
    errno = 0;
    tmp.pkey_entry[i++] = cl_hton16(strtoul(p_pkey, NULL, 0));
    if (errno) {
      printf("Wrong format for pkey:%s\n", p_pkey);
      return TCL_ERROR;
    }

    p_pkey = strtok_r(NULL," ", &str_token);
  }
  _arg3 = &tmp;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setPKeyTblBlock(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getVLArbLTable(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getVLArbLTable(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_getVLArbLTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_vl_arb_table_t * _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint8_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getVLArbLTable { IBMSNode * } portNum blockIndex ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibms_tcl_error = 0;
      _result = (ib_vl_arb_table_t *)IBMSNode_getVLArbLTable(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[256];
  int i;
  if (_result != NULL)
  {
    for (i = 0; i < 32; i++)
    {
      sprintf(buff, "{0x%02x 0x%02x} ", _result->vl_entry[i].vl, _result->vl_entry[i].weight);
      Tcl_AppendToObj(tcl_result,buff,strlen(buff));
    }
  }
  else
  {
    Tcl_SetStringObj(tcl_result, "{0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0} {0 0}", -1);
  }
}
    return TCL_OK;
}
#define IBMSNode_setVLArbLTable(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setVLArbLTable(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_setVLArbLTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    ib_vl_arb_table_t * _arg3;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint8_t  temp0;
    ib_vl_arb_table_t  tmp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setVLArbLTable { IBMSNode * } portNum blockIndex tbl ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  int i;

  int numEntries, numElements, code;
  const char **subListStrings, **elements;

  code = Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[4],NULL),
							  &numEntries, &subListStrings);
  if (code != TCL_OK) {
	 printf("Wrong format for vl_arb_table should be list of lists:%s\n",
			  Tcl_GetStringFromObj(objv[4],NULL));
	 return TCL_ERROR;
  }

  memset(&tmp, 0, sizeof(ib_vl_arb_table_t));
  for (i = 0; i < numEntries; i++) {
	 code = Tcl_SplitList(interp, subListStrings[i], &numElements, &elements);
	 if (code != TCL_OK) {
		printf("Wrong format for vl_arb_table sublist:%s\n", subListStrings[i]);
		Tcl_Free((char *) subListStrings);
		return TCL_ERROR;
	 }
	 if (numElements != 2) {
		printf("Wrong format for vl_arb_table sublist:%s num elements:%d != 2\n",
				 subListStrings[i], numElements);
		Tcl_Free((char *) elements);
		Tcl_Free((char *) subListStrings);
		return TCL_ERROR;
	 }
	 errno = 0;
	 tmp.vl_entry[i].vl = strtoul(elements[0],NULL,0);
	 if (errno) {
		printf("Wrong format for vl_arb_table sublist %d vl:%s\n",
				 i, elements[0]);
		Tcl_Free((char *) elements);
		Tcl_Free((char *) subListStrings);
		return TCL_ERROR;
	 }
	 tmp.vl_entry[i].weight =  strtoul(elements[1],NULL,0);
	 if (errno) {
		 printf("Wrong format for vl_arb_table sublist %d weight:%s\n",
				  i, elements[1]);
		Tcl_Free((char *) elements);
		Tcl_Free((char *) subListStrings);
		return TCL_ERROR;
	 }
	 Tcl_Free((char *) elements);
  }
  Tcl_Free((char *) subListStrings);

  _arg3 = &tmp;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setVLArbLTable(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getSL2VLTable(_swigobj,_swigarg0,_swigarg1)  (_swigobj->getSL2VLTable(_swigarg0,_swigarg1))
static int _wrap_IBMSNode_getSL2VLTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_slvl_table_t * _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint8_t  temp0;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getSL2VLTable { IBMSNode * } inPortNum outPortNum ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  ibms_tcl_error = 0;
      _result = (ib_slvl_table_t *)IBMSNode_getSL2VLTable(_arg0,*_arg1,*_arg2);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[64];
  int i;
  int entry;
  if (_result != NULL)
  {
    for (i = 0; i < 8; i++)
	 {
		 entry = _result->raw_vl_by_sl[i];
		 sprintf(buff, "0x%02x 0x%02x ", ((entry & 0xf0) >> 4), (entry & 0xf));
		 Tcl_AppendToObj(tcl_result,buff,strlen(buff));
	 }
  }
  else
  {
    Tcl_SetStringObj(tcl_result, "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ", -1);
  }
}
    return TCL_OK;
}
#define IBMSNode_setSL2VLTable(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setSL2VLTable(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_setSL2VLTable(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint8_t * _arg1;
    uint8_t * _arg2;
    ib_slvl_table_t * _arg3;
    Tcl_Obj * tcl_result;
    uint8_t  temp;
    uint8_t  temp0;
    ib_slvl_table_t  tmp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setSL2VLTable { IBMSNode * } inPortNum outPortNum tbl ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  int i;
  int entry, value;
  int numEntries, code;
  const char **subListStrings;

  code = Tcl_SplitList(interp, Tcl_GetStringFromObj(objv[4],NULL),
							  &numEntries, &subListStrings);
  if (code != TCL_OK) {
	 printf("Wrong format for ib_slvl_table_t should be list:%s\n",
			  Tcl_GetStringFromObj(objv[4],NULL));
	 return TCL_ERROR;
  }
  if (numEntries > 16) {
	 printf("Maximal number of SL2VL entries is 16:%s\n",
			  Tcl_GetStringFromObj(objv[4],NULL));
	 Tcl_Free((char *) subListStrings);
	 return TCL_ERROR;
  }
  memset(&tmp, 0, sizeof(ib_slvl_table_t));
  for (i = 0; i < numEntries; i++) {
	  errno = 0;
	  value = strtoul(subListStrings[i],NULL,0);
	  if (errno) {
		  printf("Wrong format for vl_arb_table sublist %d vl:%s\n",
					i, subListStrings[i]);
		  Tcl_Free((char *) subListStrings);
		  return TCL_ERROR;
	  }
	  if (value > 15) {
		  printf("Given VL at index %d is %d > 15\n", i, value);
		  Tcl_Free((char *) subListStrings);
		  return TCL_ERROR;
	  }
	  entry = tmp.raw_vl_by_sl[i/2];
	  if (i % 2) {
		  entry = (value & 0xf) | (entry & 0xf0) ;
	  } else {
		  entry = ((value & 0xf) << 4) | (entry & 0xf);
	  }
	  tmp.raw_vl_by_sl[i/2] = entry;
  }
  Tcl_Free((char *) subListStrings);

  _arg3 = &tmp;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setSL2VLTable(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_setCrSpace(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setCrSpace(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_setCrSpace(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint32_t * _arg1;
    uint32_t * _arg2;
    uint32_t * _arg3;
    Tcl_Obj * tcl_result;
    uint32_t  temp;
    uint32_t  temp0;
    uint32_t  temp1;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setCrSpace { IBMSNode * } startAddr length data ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp1;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setCrSpace(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getCrSpace(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->getCrSpace(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_getCrSpace(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint32_t * _arg1;
    uint32_t * _arg2;
    uint32_t * _arg3;
    Tcl_Obj * tcl_result;
    uint32_t  temp;
    uint32_t  temp0;
    uint32_t  temp1;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getCrSpace { IBMSNode * } startAddr length data ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[4],NULL), NULL, 0);
  _arg3 = &temp1;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_getCrSpace(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
#define IBMSNode_getMFTBlock(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->getMFTBlock(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_getMFTBlock(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint16_t * _arg1;
    uint8_t * _arg2;
    ib_mft_table_t * _arg3;
    ib_mft_table_t  temp;
    Tcl_Obj * tcl_result;
    uint16_t  temp0;
    uint8_t  temp1;

    clientData = clientData; objv = objv;
{
  _arg3 = &temp;
}
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 4) || (objc > 4)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_getMFTBlock { IBMSNode * } blockIdx portIdx ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp0;
}
{
  temp1 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp1;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_getMFTBlock(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
{
  /* Argout ib_mft_table_t */
  char buff[36];
  int i;
  /* HACK if we did not have the result show an error ... */
  if (!_result)
  {
    /* we need to cleanup the result 0 ... */
    Tcl_ResetResult(interp);
    for (i = 0; i < IB_MCAST_BLOCK_SIZE; i++)
    {
      sprintf(buff, "0x%04x ", cl_ntoh16(_arg3->mft_entry[i]));
      Tcl_AppendToObj(tcl_result,buff,strlen(buff));
    }
  }
}
    return TCL_OK;
}
#define IBMSNode_setMFTBlock(_swigobj,_swigarg0,_swigarg1,_swigarg2)  (_swigobj->setMFTBlock(_swigarg0,_swigarg1,_swigarg2))
static int _wrap_IBMSNode_setMFTBlock(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    int  _result;
    IBMSNode * _arg0;
    uint16_t * _arg1;
    uint8_t * _arg2;
    ib_mft_table_t * _arg3;
    Tcl_Obj * tcl_result;
    uint16_t  temp;
    uint8_t  temp0;
    ib_mft_table_t  tmp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 5) || (objc > 5)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. IBMSNode_setMFTBlock { IBMSNode * } blockIdx portIdx inMftBlock ",-1);
        return TCL_ERROR;
    }
{

  void *ptr;
  if (ibmsGetSimNodePtrByTclName(objv[1], &ptr) != TCL_OK) {
	 char err[128];
	 sprintf(err, "-E- fail to find ibdm obj by id:%s",Tcl_GetString(objv[1]) );
	 // Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }

  _arg0 = (IBMSNode *)ptr;
}
{
  /* the format is always: <type>:<idx>[:<name>] */

  // get the type from the given source
  char buf[128];
  strcpy(buf, Tcl_GetStringFromObj(objv[1],0));
  char *colonIdx = index(buf,':');
  if (!colonIdx) {
	 char err[128];
	 sprintf(err, "-E- Bad formatted ibdm object:%s", buf);
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
  *colonIdx = '\0';

  if (!strcmp("IBMSNode ", "IBMSNode ")) {
    if (strcmp(buf, "simnode")) {
      char err[256];
      sprintf(err, "-E- basetype is IBMSNode  but received obj of type %s", buf);
      Tcl_SetStringObj(tcl_result, err, strlen(err));
      return TCL_ERROR;
    }
  } else {
	 char err[256];
	 sprintf(err, "-E- basetype 'IBMSNode ' is unknown");
	 Tcl_SetStringObj(tcl_result, err, strlen(err));
	 return TCL_ERROR;
  }
}
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  temp0 = strtoul(Tcl_GetStringFromObj(objv[3],NULL), NULL, 0);
  _arg2 = &temp0;
}
{
  char buf[256];
  char *p_mftEntry;
  char *str_token = NULL;
  int i = 0;

  strncpy(buf, Tcl_GetStringFromObj(objv[4],NULL), 255);
  buf[255] = '\0';
  p_mftEntry = strtok_r(buf," ", &str_token);
  while (p_mftEntry && (i < IB_MCAST_BLOCK_SIZE))
  {
    errno = 0;
    tmp.mft_entry[i++] = cl_hton16(strtoul(p_mftEntry, NULL, 0));
    if (errno) {
      printf("Wrong format for MFT Entry:%s\n", p_mftEntry);
      return TCL_ERROR;
    }

    p_mftEntry = strtok_r(NULL," ", &str_token);
  }
  while (i < IB_MCAST_BLOCK_SIZE)
  {
    tmp.mft_entry[i++] = 0;
  }
  _arg3 = &tmp;
}
{
  ibms_tcl_error = 0;
      _result = (int )IBMSNode_setMFTBlock(_arg0,*_arg1,*_arg2,_arg3);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetIntObj(tcl_result,(long) _result);
    return TCL_OK;
}
/* methodcmd8.swg : Tcl8.x method invocation */

static int TclIBMSNodeMethodCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
  char *_str;
  int rcode;
  Tcl_Obj **objv;
  Tcl_Obj *oldarg,*tcl_result,*obj;
  int length;
  char c;

  tcl_result = Tcl_GetObjResult(interp);
  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetStringObj(tcl_result,"IBMSNode methods : { dump cget configure getIBNode getLinkStatus setPhyPortErrProfile getPhyPortErrProfile setPhyPortPMCounter getPhyPortPMCounter getPortInfo setLinkStatus getNodeInfo getSwitchInfo getGuidInfoBlock setGuidInfoBlock getPKeyTblBlock setPKeyTblBlock getVLArbLTable setVLArbLTable getSL2VLTable setSL2VLTable setCrSpace getCrSpace getMFTBlock setMFTBlock  }",-1);
    return TCL_ERROR;
  }
  obj = Tcl_NewObj();
  SWIG_SetPointerObj(obj,(void *) clientData,"_IBMSNode_p");
  _str = Tcl_GetStringFromObj(objv[1],&length);
  c = *_str;
  if (0);
      if (strcmp(_str,"getIBNode") == 0) {
        cmd = _wrap_IBMSNode_getIBNode;
    }    else if (strcmp(_str,"getLinkStatus") == 0) {
        cmd = _wrap_IBMSNode_getLinkStatus;
    }    else if (strcmp(_str,"setPhyPortErrProfile") == 0) {
        cmd = _wrap_IBMSNode_setPhyPortErrProfile;
    }    else if (strcmp(_str,"getPhyPortErrProfile") == 0) {
        cmd = _wrap_IBMSNode_getPhyPortErrProfile;
    }    else if (strcmp(_str,"setPhyPortPMCounter") == 0) {
        cmd = _wrap_IBMSNode_setPhyPortPMCounter;
    }    else if (strcmp(_str,"getPhyPortPMCounter") == 0) {
        cmd = _wrap_IBMSNode_getPhyPortPMCounter;
    }    else if (strcmp(_str,"getPortInfo") == 0) {
        cmd = _wrap_IBMSNode_getPortInfo;
    }    else if (strcmp(_str,"setLinkStatus") == 0) {
        cmd = _wrap_IBMSNode_setLinkStatus;
    }    else if (strcmp(_str,"getNodeInfo") == 0) {
        cmd = _wrap_IBMSNode_getNodeInfo;
    }    else if (strcmp(_str,"getSwitchInfo") == 0) {
        cmd = _wrap_IBMSNode_getSwitchInfo;
    }    else if (strcmp(_str,"getGuidInfoBlock") == 0) {
        cmd = _wrap_IBMSNode_getGuidInfoBlock;
    }    else if (strcmp(_str,"setGuidInfoBlock") == 0) {
        cmd = _wrap_IBMSNode_setGuidInfoBlock;
    }    else if (strcmp(_str,"getPKeyTblBlock") == 0) {
        cmd = _wrap_IBMSNode_getPKeyTblBlock;
    }    else if (strcmp(_str,"setPKeyTblBlock") == 0) {
        cmd = _wrap_IBMSNode_setPKeyTblBlock;
    }    else if (strcmp(_str,"getVLArbLTable") == 0) {
        cmd = _wrap_IBMSNode_getVLArbLTable;
    }    else if (strcmp(_str,"setVLArbLTable") == 0) {
        cmd = _wrap_IBMSNode_setVLArbLTable;
    }    else if (strcmp(_str,"getSL2VLTable") == 0) {
        cmd = _wrap_IBMSNode_getSL2VLTable;
    }    else if (strcmp(_str,"setSL2VLTable") == 0) {
        cmd = _wrap_IBMSNode_setSL2VLTable;
    }    else if (strcmp(_str,"setCrSpace") == 0) {
        cmd = _wrap_IBMSNode_setCrSpace;
    }    else if (strcmp(_str,"getCrSpace") == 0) {
        cmd = _wrap_IBMSNode_getCrSpace;
    }    else if (strcmp(_str,"getMFTBlock") == 0) {
        cmd = _wrap_IBMSNode_getMFTBlock;
    }    else if (strcmp(_str,"setMFTBlock") == 0) {
        cmd = _wrap_IBMSNode_setMFTBlock;
    }
    else if ((c == 'c') && (strncmp(_str,"configure",length) == 0) && (length >= 2)) {
      int i = 2;
      cmd = 0;
      while (i+1 < objc) {
        _str = Tcl_GetStringFromObj(objv[i],&length);

          if (cmd) {
            oldarg = objv[i];
            objv[i] = obj;
            rcode = (*cmd)(clientData,interp,3,&objv[i-1]);
            objv[i] = oldarg;
            if (rcode == TCL_ERROR) return rcode;
            cmd = 0;
          } else {
            Tcl_SetStringObj(tcl_result,"Invalid configure option. Must be {  }",-1);
            return TCL_ERROR;
          }
        i+=2;
      }
      if ((i < objc) || (i == 2)) {
        Tcl_SetStringObj(tcl_result,"{  }",-1);
        return TCL_ERROR;
      }
      return TCL_OK;
    } else if ((c == 'c') && (strncmp(_str,"cget",length) == 0) && (length >= 2)) {
      if (objc == 3) {
        _str = Tcl_GetStringFromObj(objv[2],&length);
        if (0) {}

          else if (strcmp(_str,"-this") == 0) {
            SWIG_SetPointerObj(tcl_result,(void *) clientData, "_IBMSNode_p");
            return TCL_OK;
          }
        if (cmd) {
          oldarg = objv[2];
          objv[2] = obj;
          rcode = (*cmd)(clientData,interp,objc-1,&objv[1]);
          objv[2] = oldarg;
          return rcode;
        } else {
          Tcl_SetStringObj(tcl_result,"Invalid cget option. Must be { -this  }",-1);
          return TCL_ERROR;
        }
      } else {
        Tcl_SetStringObj(tcl_result,"{ -this  }", -1);
        return TCL_ERROR;
      }
    } else if ((c == 'd') && (strncmp(_str,"dump",length) == 0) && (length >= 2)) {
      if (objc == 2) {
        Tcl_Obj *pDumpObj;
        pDumpObj = Tcl_NewStringObj("",-1);
        Tcl_IncrRefCount(pDumpObj);

        Tcl_DecrRefCount(pDumpObj);
        return TCL_OK;
      } else {
        Tcl_SetStringObj(tcl_result,"no parameters are allowed for dump", -1);
        return TCL_ERROR;
      }
    }
  if (!cmd) {
    Tcl_SetStringObj(tcl_result,"Invalid Method. Must be { dump cget configure getIBNode getLinkStatus setPhyPortErrProfile getPhyPortErrProfile setPhyPortPMCounter getPhyPortPMCounter getPortInfo setLinkStatus getNodeInfo getSwitchInfo getGuidInfoBlock setGuidInfoBlock getPKeyTblBlock setPKeyTblBlock getVLArbLTable setVLArbLTable getSL2VLTable setSL2VLTable setCrSpace getCrSpace getMFTBlock setMFTBlock }",-1);
    return TCL_ERROR;
  }
  oldarg = objv[1];
  objv[1] = obj;
  rcode = (*cmd)(clientData,interp,objc,objv);
  objv[1] = oldarg;
  return rcode;
}



/* objcmd8.swg : Tcl 8.x object creation */

static int TclIBMSNodeCmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    void (*del)(ClientData) = 0;
    char *name = 0;
    int (*cmd)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST*) = 0;
    IBMSNode * newObj = 0;
    int firstarg = 0;
    int thisarg = 0;
    int length;
    char *_str;
    Tcl_Obj *tcl_result;

    tcl_result = Tcl_GetObjResult(interp);
    if (objc == 1) {
        cmd = 0;
    } else {
      _str = Tcl_GetStringFromObj(objv[1],&length);
      if (strcmp(_str,"-this") == 0) thisarg = 2;
      else if (strcmp(_str,"-args") == 0) {
	firstarg = 1;
	cmd = 0;
      } else if (objc == 2) {
	firstarg = 1;
	name = _str;
	cmd = 0;
      } else if (objc >= 3) {
	name = _str;
	_str = Tcl_GetStringFromObj(objv[2],&length);
	if (strcmp(_str,"-this") == 0) thisarg = 3;
	else {
	  firstarg = 1;
	  cmd = 0;
	}
      }
    }
    if (cmd) {
        int result;
        result = (*cmd)(clientData,interp,objc-firstarg,&objv[firstarg]);
        if (result == TCL_OK) {
            SWIG_GetPointerObj(interp,tcl_result,(void **) &newObj,"_IBMSNode_p");
        } else { return result; }
        if (!name) name = Tcl_GetStringFromObj(tcl_result,&length);
        del = 0;
    } else if (thisarg > 0) {
        if (thisarg < objc) {
            char *r;
            r = SWIG_GetPointerObj(interp,objv[thisarg],(void **) &newObj,"_IBMSNode_p");
            if (r) {
	      Tcl_SetStringObj(tcl_result,"Type error. not a IBMSNode object.",-1);
	      return TCL_ERROR;
            }
        if (!name) name = Tcl_GetStringFromObj(objv[thisarg],&length);
	Tcl_SetStringObj(tcl_result,name,-1);
        } else {
            Tcl_SetStringObj(tcl_result,"wrong # args.",-1);
            return TCL_ERROR;
        }
    } else {
        Tcl_SetStringObj(tcl_result,"No constructor available.",-1);
        return TCL_ERROR;
    }
    {
      Tcl_CmdInfo dummy;
      if (!Tcl_GetCommandInfo(interp,name,&dummy)) {
	Tcl_CreateObjCommand(interp,name, TclIBMSNodeMethodCmd, (ClientData) newObj, del);
	return TCL_OK;
      } else {
	Tcl_SetStringObj(tcl_result,"Object name already exists!",-1);
	return TCL_ERROR;
      }
    }
}


#define new_madMcMemberRec() (new madMcMemberRec())
static int _wrap_new_madMcMemberRec(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    madMcMemberRec * _result;
    Tcl_Obj * tcl_result;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 1) || (objc > 1)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. new_madMcMemberRec ",-1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (madMcMemberRec *)new_madMcMemberRec();
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    SWIG_SetPointerObj(tcl_result,(void *) _result,"_madMcMemberRec_p");
    return TCL_OK;
}
#define delete_madMcMemberRec(_swigobj) (delete _swigobj)
static int _wrap_delete_madMcMemberRec(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    madMcMemberRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. delete_madMcMemberRec { madMcMemberRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of delete_madMcMemberRec. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      delete_madMcMemberRec(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
#define madMcMemberRec_mgid_set(_swigobj,_swigval) (_swigobj->mgid = *(_swigval),_swigval)
static int _wrap_madMcMemberRec_mgid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    madMcMemberRec * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_mgid_set { madMcMemberRec * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_mgid_set. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[36];
  char *p_prefix, *p_guid;
  char *str_token = NULL;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  p_guid = strtok_r(NULL, " ", &str_token);
  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_gid_t *)madMcMemberRec_mgid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[36];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_mgid_get(_swigobj) (&_swigobj->mgid)
static int _wrap_madMcMemberRec_mgid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    madMcMemberRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_mgid_get { madMcMemberRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_mgid_get. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_gid_t *)madMcMemberRec_mgid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[36];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_port_gid_set(_swigobj,_swigval) (_swigobj->port_gid = *(_swigval),_swigval)
static int _wrap_madMcMemberRec_port_gid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    madMcMemberRec * _arg0;
    ib_gid_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_gid_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_port_gid_set { madMcMemberRec * } { ib_gid_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_port_gid_set. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  char buf[36];
  char *p_prefix, *p_guid;
  char *str_token = NULL;

  strcpy(buf, Tcl_GetStringFromObj(objv[2],NULL));
  p_prefix = strtok_r(buf,":", &str_token);
  p_guid = strtok_r(NULL, " ", &str_token);
  errno = 0;
  temp.unicast.prefix = cl_hton64(strtoull(p_prefix, NULL, 16));
  if (errno) {
    printf("Wrong format for gid prefix:%s\n", p_prefix);
    return TCL_ERROR;
  }

  temp.unicast.interface_id = cl_hton64(strtoull(p_guid, NULL, 16));
  if (errno) {
    printf("Wrong format for gid guid:%s\n", p_guid);
    return TCL_ERROR;
  }

  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_gid_t *)madMcMemberRec_port_gid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[36];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_port_gid_get(_swigobj) (&_swigobj->port_gid)
static int _wrap_madMcMemberRec_port_gid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_gid_t * _result;
    madMcMemberRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_port_gid_get { madMcMemberRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_port_gid_get. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_gid_t *)madMcMemberRec_port_gid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[36];
  sprintf(buff, "0x%016" PRIx64 ":0x%016" PRIx64,
          cl_ntoh64(_result->unicast.prefix),
          cl_ntoh64(_result->unicast.interface_id)
          );
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_qkey_set(_swigobj,_swigval) (_swigobj->qkey = *(_swigval),_swigval)
static int _wrap_madMcMemberRec_qkey_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    madMcMemberRec * _arg0;
    ib_net32_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net32_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_qkey_set { madMcMemberRec * } { ib_net32_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_qkey_set. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton32(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)madMcMemberRec_qkey_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_qkey_get(_swigobj) (&_swigobj->qkey)
static int _wrap_madMcMemberRec_qkey_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net32_t * _result;
    madMcMemberRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_qkey_get { madMcMemberRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_qkey_get. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net32_t *)madMcMemberRec_qkey_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_ntoh32(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_mlid_set(_swigobj,_swigval) (_swigobj->mlid = *(_swigval),_swigval)
static int _wrap_madMcMemberRec_mlid_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    madMcMemberRec * _arg0;
    ib_net16_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    ib_net16_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_mlid_set { madMcMemberRec * } { ib_net16_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_mlid_set. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = cl_hton16(strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0));
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)madMcMemberRec_mlid_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_mlid_get(_swigobj) (&_swigobj->mlid)
static int _wrap_madMcMemberRec_mlid_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    ib_net16_t * _result;
    madMcMemberRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_mlid_get { madMcMemberRec * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_mlid_get. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  ibms_tcl_error = 0;
      _result = (ib_net16_t *)madMcMemberRec_mlid_get(_arg0);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", cl_hton16(*_result));
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_mtu_set(_swigobj,_swigval) (_swigobj->mtu = *(_swigval),_swigval)
static int _wrap_madMcMemberRec_mtu_set(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    madMcMemberRec * _arg0;
    uint8_t * _arg1;
    Tcl_Obj * tcl_result;
    char * rettype;
    uint8_t  temp;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. madMcMemberRec_mtu_set { madMcMemberRec * } { uint8_t * } ",-1);
        return TCL_ERROR;
    }
    if ((rettype = SWIG_GetPointerObj(interp,objv[1],(void **) &_arg0,"_madMcMemberRec_p"))) {
        Tcl_SetStringObj(tcl_result, "Type error in argument 1 of madMcMemberRec_mtu_set. Expected _madMcMemberRec_p, received ", -1);
        Tcl_AppendToObj(tcl_result, rettype, -1);
        return TCL_ERROR;
    }
{
  temp = strtoul(Tcl_GetStringFromObj(objv[2],NULL), NULL, 0);
  _arg1 = &temp;
}
{
  ibms_tcl_error = 0;
      _result = (uint8_t *)madMcMemberRec_mtu_set(_arg0,_arg1);
;
  if (ibms_tcl_error) {
	 Tcl_SetStringObj(Tcl_GetObjResult(interp), ibms_tcl_error_msg, -1);
 	 return TCL_ERROR;
  }
}    tcl_result = Tcl_GetObjResult(interp);
{
  char buff[20];
  sprintf(buff, "%u", *_result);
  Tcl_SetStringObj(tcl_result,buff,strlen(buff));
}
    return TCL_OK;
}
#define madMcMemberRec_mtu_get(_swigobj) (&_swigobj->mtu)
static int _wrap_madMcMemberRec_mtu_get(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    uint8_t * _result;
    madMcMemberRec * _arg0;
    Tcl_Obj * tcl_result;
    char * rettype;

    clientData = clientData; objv = objv;
   