// Code generated by "mkasm_amd64.py", DO NOT EDIT.

package x86_64

// ADCB performs "Add with Carry".
//
// Mnemonic        : ADC
// Supported forms : (6 forms)
//
//    * ADCB imm8, al
//    * ADCB imm8, r8
//    * ADCB r8, r8
//    * ADCB m8, r8
//    * ADCB imm8, m8
//    * ADCB r8, m8
//
func (self *Program) ADCB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADCB", 2, Operands { v0, v1 })
    // ADCB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x14)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0x80)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x12)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADCB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x12)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADCB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x80)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x10)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADCB")
    }
    return p
}

// ADCL performs "Add with Carry".
//
// Mnemonic        : ADC
// Supported forms : (8 forms)
//
//    * ADCL imm32, eax
//    * ADCL imm8, r32
//    * ADCL imm32, r32
//    * ADCL r32, r32
//    * ADCL m32, r32
//    * ADCL imm8, m32
//    * ADCL imm32, m32
//    * ADCL r32, m32
//
func (self *Program) ADCL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADCL", 2, Operands { v0, v1 })
    // ADCL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x15)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADCL imm8, r32
    if isImm8Ext(v0, 4) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xd0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADCL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x11)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x13)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADCL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x13)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADCL imm8, m32
    if isImm8Ext(v0, 4) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(2, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADCL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x11)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADCL")
    }
    return p
}

// ADCQ performs "Add with Carry".
//
// Mnemonic        : ADC
// Supported forms : (8 forms)
//
//    * ADCQ imm32, rax
//    * ADCQ imm8, r64
//    * ADCQ imm32, r64
//    * ADCQ r64, r64
//    * ADCQ m64, r64
//    * ADCQ imm8, m64
//    * ADCQ imm32, m64
//    * ADCQ r64, m64
//
func (self *Program) ADCQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADCQ", 2, Operands { v0, v1 })
    // ADCQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0x15)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADCQ imm8, r64
    if isImm8Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x83)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x81)
            m.emit(0xd0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADCQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x11)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x13)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADCQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x13)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADCQ imm8, m64
    if isImm8Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x83)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x81)
            m.mrsd(2, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADCQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x11)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADCQ")
    }
    return p
}

// ADCW performs "Add with Carry".
//
// Mnemonic        : ADC
// Supported forms : (8 forms)
//
//    * ADCW imm16, ax
//    * ADCW imm8, r16
//    * ADCW imm16, r16
//    * ADCW r16, r16
//    * ADCW m16, r16
//    * ADCW imm8, m16
//    * ADCW imm16, m16
//    * ADCW r16, m16
//
func (self *Program) ADCW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADCW", 2, Operands { v0, v1 })
    // ADCW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x15)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ADCW imm8, r16
    if isImm8Ext(v0, 2) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xd0 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // ADCW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x11)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x13)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADCW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x13)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADCW imm8, m16
    if isImm8Ext(v0, 2) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADCW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(2, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ADCW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x11)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADCW")
    }
    return p
}

// ADCXL performs "Unsigned Integer Addition of Two Operands with Carry Flag".
//
// Mnemonic        : ADCX
// Supported forms : (2 forms)
//
//    * ADCXL r32, r32    [ADX]
//    * ADCXL m32, r32    [ADX]
//
func (self *Program) ADCXL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADCXL", 2, Operands { v0, v1 })
    // ADCXL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADCXL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADCXL")
    }
    return p
}

// ADCXQ performs "Unsigned Integer Addition of Two Operands with Carry Flag".
//
// Mnemonic        : ADCX
// Supported forms : (2 forms)
//
//    * ADCXQ r64, r64    [ADX]
//    * ADCXQ m64, r64    [ADX]
//
func (self *Program) ADCXQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADCXQ", 2, Operands { v0, v1 })
    // ADCXQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADCXQ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADCXQ")
    }
    return p
}

// ADDB performs "Add".
//
// Mnemonic        : ADD
// Supported forms : (6 forms)
//
//    * ADDB imm8, al
//    * ADDB imm8, r8
//    * ADDB r8, r8
//    * ADDB m8, r8
//    * ADDB imm8, m8
//    * ADDB r8, m8
//
func (self *Program) ADDB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDB", 2, Operands { v0, v1 })
    // ADDB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x04)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0x80)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x00)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x02)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x02)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADDB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x80)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x00)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDB")
    }
    return p
}

// ADDL performs "Add".
//
// Mnemonic        : ADD
// Supported forms : (8 forms)
//
//    * ADDL imm32, eax
//    * ADDL imm8, r32
//    * ADDL imm32, r32
//    * ADDL r32, r32
//    * ADDL m32, r32
//    * ADDL imm8, m32
//    * ADDL imm32, m32
//    * ADDL r32, m32
//
func (self *Program) ADDL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDL", 2, Operands { v0, v1 })
    // ADDL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x05)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADDL imm8, r32
    if isImm8Ext(v0, 4) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xc0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADDL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x01)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x03)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADDL imm8, m32
    if isImm8Ext(v0, 4) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(0, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADDL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x01)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDL")
    }
    return p
}

// ADDPD performs "Add Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : ADDPD
// Supported forms : (2 forms)
//
//    * ADDPD xmm, xmm     [SSE2]
//    * ADDPD m128, xmm    [SSE2]
//
func (self *Program) ADDPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDPD", 2, Operands { v0, v1 })
    // ADDPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x58)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDPD")
    }
    return p
}

// ADDPS performs "Add Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : ADDPS
// Supported forms : (2 forms)
//
//    * ADDPS xmm, xmm     [SSE]
//    * ADDPS m128, xmm    [SSE]
//
func (self *Program) ADDPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDPS", 2, Operands { v0, v1 })
    // ADDPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x58)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDPS")
    }
    return p
}

// ADDQ performs "Add".
//
// Mnemonic        : ADD
// Supported forms : (8 forms)
//
//    * ADDQ imm32, rax
//    * ADDQ imm8, r64
//    * ADDQ imm32, r64
//    * ADDQ r64, r64
//    * ADDQ m64, r64
//    * ADDQ imm8, m64
//    * ADDQ imm32, m64
//    * ADDQ r64, m64
//
func (self *Program) ADDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDQ", 2, Operands { v0, v1 })
    // ADDQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0x05)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADDQ imm8, r64
    if isImm8Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x83)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x81)
            m.emit(0xc0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADDQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x01)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x03)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADDQ imm8, m64
    if isImm8Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x83)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x81)
            m.mrsd(0, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ADDQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x01)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDQ")
    }
    return p
}

// ADDSD performs "Add Scalar Double-Precision Floating-Point Values".
//
// Mnemonic        : ADDSD
// Supported forms : (2 forms)
//
//    * ADDSD xmm, xmm    [SSE2]
//    * ADDSD m64, xmm    [SSE2]
//
func (self *Program) ADDSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDSD", 2, Operands { v0, v1 })
    // ADDSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x58)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDSD")
    }
    return p
}

// ADDSS performs "Add Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : ADDSS
// Supported forms : (2 forms)
//
//    * ADDSS xmm, xmm    [SSE]
//    * ADDSS m32, xmm    [SSE]
//
func (self *Program) ADDSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDSS", 2, Operands { v0, v1 })
    // ADDSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x58)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDSS")
    }
    return p
}

// ADDSUBPD performs "Packed Double-FP Add/Subtract".
//
// Mnemonic        : ADDSUBPD
// Supported forms : (2 forms)
//
//    * ADDSUBPD xmm, xmm     [SSE3]
//    * ADDSUBPD m128, xmm    [SSE3]
//
func (self *Program) ADDSUBPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDSUBPD", 2, Operands { v0, v1 })
    // ADDSUBPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd0)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDSUBPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDSUBPD")
    }
    return p
}

// ADDSUBPS performs "Packed Single-FP Add/Subtract".
//
// Mnemonic        : ADDSUBPS
// Supported forms : (2 forms)
//
//    * ADDSUBPS xmm, xmm     [SSE3]
//    * ADDSUBPS m128, xmm    [SSE3]
//
func (self *Program) ADDSUBPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDSUBPS", 2, Operands { v0, v1 })
    // ADDSUBPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd0)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDSUBPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDSUBPS")
    }
    return p
}

// ADDW performs "Add".
//
// Mnemonic        : ADD
// Supported forms : (8 forms)
//
//    * ADDW imm16, ax
//    * ADDW imm8, r16
//    * ADDW imm16, r16
//    * ADDW r16, r16
//    * ADDW m16, r16
//    * ADDW imm8, m16
//    * ADDW imm16, m16
//    * ADDW r16, m16
//
func (self *Program) ADDW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADDW", 2, Operands { v0, v1 })
    // ADDW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x05)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ADDW imm8, r16
    if isImm8Ext(v0, 2) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xc0 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // ADDW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x01)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADDW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x03)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ADDW imm8, m16
    if isImm8Ext(v0, 2) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ADDW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(0, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ADDW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x01)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADDW")
    }
    return p
}

// ADOXL performs "Unsigned Integer Addition of Two Operands with Overflow Flag".
//
// Mnemonic        : ADOX
// Supported forms : (2 forms)
//
//    * ADOXL r32, r32    [ADX]
//    * ADOXL m32, r32    [ADX]
//
func (self *Program) ADOXL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADOXL", 2, Operands { v0, v1 })
    // ADOXL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADOXL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADOXL")
    }
    return p
}

// ADOXQ performs "Unsigned Integer Addition of Two Operands with Overflow Flag".
//
// Mnemonic        : ADOX
// Supported forms : (2 forms)
//
//    * ADOXQ r64, r64    [ADX]
//    * ADOXQ m64, r64    [ADX]
//
func (self *Program) ADOXQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ADOXQ", 2, Operands { v0, v1 })
    // ADOXQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ADOXQ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_ADX)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ADOXQ")
    }
    return p
}

// AESDEC performs "Perform One Round of an AES Decryption Flow".
//
// Mnemonic        : AESDEC
// Supported forms : (2 forms)
//
//    * AESDEC xmm, xmm     [AES]
//    * AESDEC m128, xmm    [AES]
//
func (self *Program) AESDEC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("AESDEC", 2, Operands { v0, v1 })
    // AESDEC xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xde)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // AESDEC m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xde)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for AESDEC")
    }
    return p
}

// AESDECLAST performs "Perform Last Round of an AES Decryption Flow".
//
// Mnemonic        : AESDECLAST
// Supported forms : (2 forms)
//
//    * AESDECLAST xmm, xmm     [AES]
//    * AESDECLAST m128, xmm    [AES]
//
func (self *Program) AESDECLAST(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("AESDECLAST", 2, Operands { v0, v1 })
    // AESDECLAST xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // AESDECLAST m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for AESDECLAST")
    }
    return p
}

// AESENC performs "Perform One Round of an AES Encryption Flow".
//
// Mnemonic        : AESENC
// Supported forms : (2 forms)
//
//    * AESENC xmm, xmm     [AES]
//    * AESENC m128, xmm    [AES]
//
func (self *Program) AESENC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("AESENC", 2, Operands { v0, v1 })
    // AESENC xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // AESENC m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for AESENC")
    }
    return p
}

// AESENCLAST performs "Perform Last Round of an AES Encryption Flow".
//
// Mnemonic        : AESENCLAST
// Supported forms : (2 forms)
//
//    * AESENCLAST xmm, xmm     [AES]
//    * AESENCLAST m128, xmm    [AES]
//
func (self *Program) AESENCLAST(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("AESENCLAST", 2, Operands { v0, v1 })
    // AESENCLAST xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // AESENCLAST m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for AESENCLAST")
    }
    return p
}

// AESIMC performs "Perform the AES InvMixColumn Transformation".
//
// Mnemonic        : AESIMC
// Supported forms : (2 forms)
//
//    * AESIMC xmm, xmm     [AES]
//    * AESIMC m128, xmm    [AES]
//
func (self *Program) AESIMC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("AESIMC", 2, Operands { v0, v1 })
    // AESIMC xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // AESIMC m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xdb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for AESIMC")
    }
    return p
}

// AESKEYGENASSIST performs "AES Round Key Generation Assist".
//
// Mnemonic        : AESKEYGENASSIST
// Supported forms : (2 forms)
//
//    * AESKEYGENASSIST imm8, xmm, xmm     [AES]
//    * AESKEYGENASSIST imm8, m128, xmm    [AES]
//
func (self *Program) AESKEYGENASSIST(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("AESKEYGENASSIST", 3, Operands { v0, v1, v2 })
    // AESKEYGENASSIST imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0xdf)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // AESKEYGENASSIST imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0xdf)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for AESKEYGENASSIST")
    }
    return p
}

// ANDB performs "Logical AND".
//
// Mnemonic        : AND
// Supported forms : (6 forms)
//
//    * ANDB imm8, al
//    * ANDB imm8, r8
//    * ANDB r8, r8
//    * ANDB m8, r8
//    * ANDB imm8, m8
//    * ANDB r8, m8
//
func (self *Program) ANDB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDB", 2, Operands { v0, v1 })
    // ANDB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x24)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0x80)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x20)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x22)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x22)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ANDB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x80)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x20)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDB")
    }
    return p
}

// ANDL performs "Logical AND".
//
// Mnemonic        : AND
// Supported forms : (8 forms)
//
//    * ANDL imm32, eax
//    * ANDL imm8, r32
//    * ANDL imm32, r32
//    * ANDL r32, r32
//    * ANDL m32, r32
//    * ANDL imm8, m32
//    * ANDL imm32, m32
//    * ANDL r32, m32
//
func (self *Program) ANDL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDL", 2, Operands { v0, v1 })
    // ANDL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x25)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ANDL imm8, r32
    if isImm8Ext(v0, 4) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xe0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ANDL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x21)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x23)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x23)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ANDL imm8, m32
    if isImm8Ext(v0, 4) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(4, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ANDL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x21)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDL")
    }
    return p
}

// ANDNL performs "Logical AND NOT".
//
// Mnemonic        : ANDN
// Supported forms : (2 forms)
//
//    * ANDNL r32, r32, r32    [BMI]
//    * ANDNL m32, r32, r32    [BMI]
//
func (self *Program) ANDNL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("ANDNL", 3, Operands { v0, v1, v2 })
    // ANDNL r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0xf2)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // ANDNL m32, r32, r32
    if isM32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x00, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf2)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDNL")
    }
    return p
}

// ANDNPD performs "Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : ANDNPD
// Supported forms : (2 forms)
//
//    * ANDNPD xmm, xmm     [SSE2]
//    * ANDNPD m128, xmm    [SSE2]
//
func (self *Program) ANDNPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDNPD", 2, Operands { v0, v1 })
    // ANDNPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x55)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDNPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x55)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDNPD")
    }
    return p
}

// ANDNPS performs "Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : ANDNPS
// Supported forms : (2 forms)
//
//    * ANDNPS xmm, xmm     [SSE]
//    * ANDNPS m128, xmm    [SSE]
//
func (self *Program) ANDNPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDNPS", 2, Operands { v0, v1 })
    // ANDNPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x55)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDNPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x55)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDNPS")
    }
    return p
}

// ANDNQ performs "Logical AND NOT".
//
// Mnemonic        : ANDN
// Supported forms : (2 forms)
//
//    * ANDNQ r64, r64, r64    [BMI]
//    * ANDNQ m64, r64, r64    [BMI]
//
func (self *Program) ANDNQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("ANDNQ", 3, Operands { v0, v1, v2 })
    // ANDNQ r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0xf2)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // ANDNQ m64, r64, r64
    if isM64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x80, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf2)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDNQ")
    }
    return p
}

// ANDPD performs "Bitwise Logical AND of Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : ANDPD
// Supported forms : (2 forms)
//
//    * ANDPD xmm, xmm     [SSE2]
//    * ANDPD m128, xmm    [SSE2]
//
func (self *Program) ANDPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDPD", 2, Operands { v0, v1 })
    // ANDPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x54)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x54)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDPD")
    }
    return p
}

// ANDPS performs "Bitwise Logical AND of Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : ANDPS
// Supported forms : (2 forms)
//
//    * ANDPS xmm, xmm     [SSE]
//    * ANDPS m128, xmm    [SSE]
//
func (self *Program) ANDPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDPS", 2, Operands { v0, v1 })
    // ANDPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x54)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x54)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDPS")
    }
    return p
}

// ANDQ performs "Logical AND".
//
// Mnemonic        : AND
// Supported forms : (8 forms)
//
//    * ANDQ imm32, rax
//    * ANDQ imm8, r64
//    * ANDQ imm32, r64
//    * ANDQ r64, r64
//    * ANDQ m64, r64
//    * ANDQ imm8, m64
//    * ANDQ imm32, m64
//    * ANDQ r64, m64
//
func (self *Program) ANDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDQ", 2, Operands { v0, v1 })
    // ANDQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0x25)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ANDQ imm8, r64
    if isImm8Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x83)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x81)
            m.emit(0xe0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ANDQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x21)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x23)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x23)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ANDQ imm8, m64
    if isImm8Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x83)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x81)
            m.mrsd(4, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ANDQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x21)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDQ")
    }
    return p
}

// ANDW performs "Logical AND".
//
// Mnemonic        : AND
// Supported forms : (8 forms)
//
//    * ANDW imm16, ax
//    * ANDW imm8, r16
//    * ANDW imm16, r16
//    * ANDW r16, r16
//    * ANDW m16, r16
//    * ANDW imm8, m16
//    * ANDW imm16, m16
//    * ANDW r16, m16
//
func (self *Program) ANDW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ANDW", 2, Operands { v0, v1 })
    // ANDW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x25)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ANDW imm8, r16
    if isImm8Ext(v0, 2) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xe0 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // ANDW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x21)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x23)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ANDW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x23)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ANDW imm8, m16
    if isImm8Ext(v0, 2) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ANDW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(4, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ANDW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x21)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ANDW")
    }
    return p
}

// BEXTR performs "Bit Field Extract".
//
// Mnemonic        : BEXTR
// Supported forms : (8 forms)
//
//    * BEXTR imm32, r32, r32    [TBM]
//    * BEXTR imm32, m32, r32    [TBM]
//    * BEXTR imm32, r64, r64    [TBM]
//    * BEXTR imm32, m64, r64    [TBM]
//    * BEXTR r32, r32, r32      [BMI]
//    * BEXTR r32, m32, r32      [BMI]
//    * BEXTR r64, r64, r64      [BMI]
//    * BEXTR r64, m64, r64      [BMI]
//
func (self *Program) BEXTR(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("BEXTR", 3, Operands { v0, v1, v2 })
    // BEXTR imm32, r32, r32
    if isImm32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xea ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x78)
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // BEXTR imm32, m32, r32
    if isImm32(v0) && isM32(v1) && isReg32(v2) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1010, 0x00, hcode(v[2]), addr(v[1]), 0)
            m.emit(0x10)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // BEXTR imm32, r64, r64
    if isImm32(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xea ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0xf8)
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // BEXTR imm32, m64, r64
    if isImm32(v0) && isM64(v1) && isReg64(v2) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1010, 0x80, hcode(v[2]), addr(v[1]), 0)
            m.emit(0x10)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // BEXTR r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x78 ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // BEXTR r32, m32, r32
    if isReg32(v0) && isM32(v1) && isReg32(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x00, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    // BEXTR r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0xf8 ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // BEXTR r64, m64, r64
    if isReg64(v0) && isM64(v1) && isReg64(v2) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x80, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BEXTR")
    }
    return p
}

// BLCFILL performs "Fill From Lowest Clear Bit".
//
// Mnemonic        : BLCFILL
// Supported forms : (4 forms)
//
//    * BLCFILL r32, r32    [TBM]
//    * BLCFILL m32, r32    [TBM]
//    * BLCFILL r64, r64    [TBM]
//    * BLCFILL m64, r64    [TBM]
//
func (self *Program) BLCFILL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLCFILL", 2, Operands { v0, v1 })
    // BLCFILL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // BLCFILL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    // BLCFILL r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // BLCFILL m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLCFILL")
    }
    return p
}

// BLCI performs "Isolate Lowest Clear Bit".
//
// Mnemonic        : BLCI
// Supported forms : (4 forms)
//
//    * BLCI r32, r32    [TBM]
//    * BLCI m32, r32    [TBM]
//    * BLCI r64, r64    [TBM]
//    * BLCI m64, r64    [TBM]
//
func (self *Program) BLCI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLCI", 2, Operands { v0, v1 })
    // BLCI r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x02)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // BLCI m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x02)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    // BLCI r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x02)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // BLCI m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x02)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLCI")
    }
    return p
}

// BLCIC performs "Isolate Lowest Set Bit and Complement".
//
// Mnemonic        : BLCIC
// Supported forms : (4 forms)
//
//    * BLCIC r32, r32    [TBM]
//    * BLCIC m32, r32    [TBM]
//    * BLCIC r64, r64    [TBM]
//    * BLCIC m64, r64    [TBM]
//
func (self *Program) BLCIC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLCIC", 2, Operands { v0, v1 })
    // BLCIC r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xe8 | lcode(v[0]))
        })
    }
    // BLCIC m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(5, addr(v[0]), 1)
        })
    }
    // BLCIC r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xe8 | lcode(v[0]))
        })
    }
    // BLCIC m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(5, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLCIC")
    }
    return p
}

// BLCMSK performs "Mask From Lowest Clear Bit".
//
// Mnemonic        : BLCMSK
// Supported forms : (4 forms)
//
//    * BLCMSK r32, r32    [TBM]
//    * BLCMSK m32, r32    [TBM]
//    * BLCMSK r64, r64    [TBM]
//    * BLCMSK m64, r64    [TBM]
//
func (self *Program) BLCMSK(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLCMSK", 2, Operands { v0, v1 })
    // BLCMSK r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x02)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // BLCMSK m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x02)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    // BLCMSK r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x02)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // BLCMSK m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x02)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLCMSK")
    }
    return p
}

// BLCS performs "Set Lowest Clear Bit".
//
// Mnemonic        : BLCS
// Supported forms : (4 forms)
//
//    * BLCS r32, r32    [TBM]
//    * BLCS m32, r32    [TBM]
//    * BLCS r64, r64    [TBM]
//    * BLCS m64, r64    [TBM]
//
func (self *Program) BLCS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLCS", 2, Operands { v0, v1 })
    // BLCS r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // BLCS m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    // BLCS r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // BLCS m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLCS")
    }
    return p
}

// BLENDPD performs "Blend Packed Double Precision Floating-Point Values".
//
// Mnemonic        : BLENDPD
// Supported forms : (2 forms)
//
//    * BLENDPD imm8, xmm, xmm     [SSE4.1]
//    * BLENDPD imm8, m128, xmm    [SSE4.1]
//
func (self *Program) BLENDPD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("BLENDPD", 3, Operands { v0, v1, v2 })
    // BLENDPD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0d)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BLENDPD imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0d)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLENDPD")
    }
    return p
}

// BLENDPS performs " Blend Packed Single Precision Floating-Point Values".
//
// Mnemonic        : BLENDPS
// Supported forms : (2 forms)
//
//    * BLENDPS imm8, xmm, xmm     [SSE4.1]
//    * BLENDPS imm8, m128, xmm    [SSE4.1]
//
func (self *Program) BLENDPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("BLENDPS", 3, Operands { v0, v1, v2 })
    // BLENDPS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0c)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BLENDPS imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0c)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLENDPS")
    }
    return p
}

// BLENDVPD performs " Variable Blend Packed Double Precision Floating-Point Values".
//
// Mnemonic        : BLENDVPD
// Supported forms : (2 forms)
//
//    * BLENDVPD xmm0, xmm, xmm     [SSE4.1]
//    * BLENDVPD xmm0, m128, xmm    [SSE4.1]
//
func (self *Program) BLENDVPD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("BLENDVPD", 3, Operands { v0, v1, v2 })
    // BLENDVPD xmm0, xmm, xmm
    if v0 == XMM0 && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x15)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // BLENDVPD xmm0, m128, xmm
    if v0 == XMM0 && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x15)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLENDVPD")
    }
    return p
}

// BLENDVPS performs " Variable Blend Packed Single Precision Floating-Point Values".
//
// Mnemonic        : BLENDVPS
// Supported forms : (2 forms)
//
//    * BLENDVPS xmm0, xmm, xmm     [SSE4.1]
//    * BLENDVPS xmm0, m128, xmm    [SSE4.1]
//
func (self *Program) BLENDVPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("BLENDVPS", 3, Operands { v0, v1, v2 })
    // BLENDVPS xmm0, xmm, xmm
    if v0 == XMM0 && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x14)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // BLENDVPS xmm0, m128, xmm
    if v0 == XMM0 && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x14)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLENDVPS")
    }
    return p
}

// BLSFILL performs "Fill From Lowest Set Bit".
//
// Mnemonic        : BLSFILL
// Supported forms : (4 forms)
//
//    * BLSFILL r32, r32    [TBM]
//    * BLSFILL m32, r32    [TBM]
//    * BLSFILL r64, r64    [TBM]
//    * BLSFILL m64, r64    [TBM]
//
func (self *Program) BLSFILL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLSFILL", 2, Operands { v0, v1 })
    // BLSFILL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // BLSFILL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    // BLSFILL r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // BLSFILL m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLSFILL")
    }
    return p
}

// BLSI performs "Isolate Lowest Set Bit".
//
// Mnemonic        : BLSI
// Supported forms : (4 forms)
//
//    * BLSI r32, r32    [BMI]
//    * BLSI m32, r32    [BMI]
//    * BLSI r64, r64    [BMI]
//    * BLSI m64, r64    [BMI]
//
func (self *Program) BLSI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLSI", 2, Operands { v0, v1 })
    // BLSI r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0xf3)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // BLSI m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0xf3)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    // BLSI r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0xf3)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // BLSI m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0xf3)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLSI")
    }
    return p
}

// BLSIC performs "Isolate Lowest Set Bit and Complement".
//
// Mnemonic        : BLSIC
// Supported forms : (4 forms)
//
//    * BLSIC r32, r32    [TBM]
//    * BLSIC m32, r32    [TBM]
//    * BLSIC r64, r64    [TBM]
//    * BLSIC m64, r64    [TBM]
//
func (self *Program) BLSIC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLSIC", 2, Operands { v0, v1 })
    // BLSIC r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // BLSIC m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    // BLSIC r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // BLSIC m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLSIC")
    }
    return p
}

// BLSMSK performs "Mask From Lowest Set Bit".
//
// Mnemonic        : BLSMSK
// Supported forms : (4 forms)
//
//    * BLSMSK r32, r32    [BMI]
//    * BLSMSK m32, r32    [BMI]
//    * BLSMSK r64, r64    [BMI]
//    * BLSMSK m64, r64    [BMI]
//
func (self *Program) BLSMSK(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLSMSK", 2, Operands { v0, v1 })
    // BLSMSK r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0xf3)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // BLSMSK m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0xf3)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    // BLSMSK r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0xf3)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // BLSMSK m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0xf3)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLSMSK")
    }
    return p
}

// BLSR performs "Reset Lowest Set Bit".
//
// Mnemonic        : BLSR
// Supported forms : (4 forms)
//
//    * BLSR r32, r32    [BMI]
//    * BLSR m32, r32    [BMI]
//    * BLSR r64, r64    [BMI]
//    * BLSR m64, r64    [BMI]
//
func (self *Program) BLSR(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BLSR", 2, Operands { v0, v1 })
    // BLSR r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0xf3)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // BLSR m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0xf3)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    // BLSR r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0xf3)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // BLSR m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0xf3)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BLSR")
    }
    return p
}

// BSFL performs "Bit Scan Forward".
//
// Mnemonic        : BSF
// Supported forms : (2 forms)
//
//    * BSFL r32, r32
//    * BSFL m32, r32
//
func (self *Program) BSFL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BSFL", 2, Operands { v0, v1 })
    // BSFL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // BSFL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSFL")
    }
    return p
}

// BSFQ performs "Bit Scan Forward".
//
// Mnemonic        : BSF
// Supported forms : (2 forms)
//
//    * BSFQ r64, r64
//    * BSFQ m64, r64
//
func (self *Program) BSFQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BSFQ", 2, Operands { v0, v1 })
    // BSFQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xbc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // BSFQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xbc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSFQ")
    }
    return p
}

// BSFW performs "Bit Scan Forward".
//
// Mnemonic        : BSF
// Supported forms : (2 forms)
//
//    * BSFW r16, r16
//    * BSFW m16, r16
//
func (self *Program) BSFW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BSFW", 2, Operands { v0, v1 })
    // BSFW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // BSFW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSFW")
    }
    return p
}

// BSRL performs "Bit Scan Reverse".
//
// Mnemonic        : BSR
// Supported forms : (2 forms)
//
//    * BSRL r32, r32
//    * BSRL m32, r32
//
func (self *Program) BSRL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BSRL", 2, Operands { v0, v1 })
    // BSRL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // BSRL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSRL")
    }
    return p
}

// BSRQ performs "Bit Scan Reverse".
//
// Mnemonic        : BSR
// Supported forms : (2 forms)
//
//    * BSRQ r64, r64
//    * BSRQ m64, r64
//
func (self *Program) BSRQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BSRQ", 2, Operands { v0, v1 })
    // BSRQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xbd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // BSRQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xbd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSRQ")
    }
    return p
}

// BSRW performs "Bit Scan Reverse".
//
// Mnemonic        : BSR
// Supported forms : (2 forms)
//
//    * BSRW r16, r16
//    * BSRW m16, r16
//
func (self *Program) BSRW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BSRW", 2, Operands { v0, v1 })
    // BSRW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // BSRW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSRW")
    }
    return p
}

// BSWAPL performs "Byte Swap".
//
// Mnemonic        : BSWAP
// Supported forms : (1 form)
//
//    * BSWAPL r32
//
func (self *Program) BSWAPL(v0 interface{}) *Instruction {
    p := self.alloc("BSWAPL", 1, Operands { v0 })
    // BSWAPL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0x0f)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSWAPL")
    }
    return p
}

// BSWAPQ performs "Byte Swap".
//
// Mnemonic        : BSWAP
// Supported forms : (1 form)
//
//    * BSWAPQ r64
//
func (self *Program) BSWAPQ(v0 interface{}) *Instruction {
    p := self.alloc("BSWAPQ", 1, Operands { v0 })
    // BSWAPQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for BSWAPQ")
    }
    return p
}

// BTCL performs "Bit Test and Complement".
//
// Mnemonic        : BTC
// Supported forms : (4 forms)
//
//    * BTCL imm8, r32
//    * BTCL r32, r32
//    * BTCL imm8, m32
//    * BTCL r32, m32
//
func (self *Program) BTCL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTCL", 2, Operands { v0, v1 })
    // BTCL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTCL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xbb)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTCL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTCL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xbb)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTCL")
    }
    return p
}

// BTCQ performs "Bit Test and Complement".
//
// Mnemonic        : BTC
// Supported forms : (4 forms)
//
//    * BTCQ imm8, r64
//    * BTCQ r64, r64
//    * BTCQ imm8, m64
//    * BTCQ r64, m64
//
func (self *Program) BTCQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTCQ", 2, Operands { v0, v1 })
    // BTCQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTCQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xbb)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTCQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTCQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0xbb)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTCQ")
    }
    return p
}

// BTCW performs "Bit Test and Complement".
//
// Mnemonic        : BTC
// Supported forms : (4 forms)
//
//    * BTCW imm8, r16
//    * BTCW r16, r16
//    * BTCW imm8, m16
//    * BTCW r16, m16
//
func (self *Program) BTCW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTCW", 2, Operands { v0, v1 })
    // BTCW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTCW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xbb)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTCW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTCW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xbb)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTCW")
    }
    return p
}

// BTL performs "Bit Test".
//
// Mnemonic        : BT
// Supported forms : (4 forms)
//
//    * BTL imm8, r32
//    * BTL r32, r32
//    * BTL imm8, m32
//    * BTL r32, m32
//
func (self *Program) BTL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTL", 2, Operands { v0, v1 })
    // BTL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xa3)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xa3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTL")
    }
    return p
}

// BTQ performs "Bit Test".
//
// Mnemonic        : BT
// Supported forms : (4 forms)
//
//    * BTQ imm8, r64
//    * BTQ r64, r64
//    * BTQ imm8, m64
//    * BTQ r64, m64
//
func (self *Program) BTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTQ", 2, Operands { v0, v1 })
    // BTQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xa3)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0xa3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTQ")
    }
    return p
}

// BTRL performs "Bit Test and Reset".
//
// Mnemonic        : BTR
// Supported forms : (4 forms)
//
//    * BTRL imm8, r32
//    * BTRL r32, r32
//    * BTRL imm8, m32
//    * BTRL r32, m32
//
func (self *Program) BTRL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTRL", 2, Operands { v0, v1 })
    // BTRL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTRL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xb3)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTRL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(6, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTRL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xb3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTRL")
    }
    return p
}

// BTRQ performs "Bit Test and Reset".
//
// Mnemonic        : BTR
// Supported forms : (4 forms)
//
//    * BTRQ imm8, r64
//    * BTRQ r64, r64
//    * BTRQ imm8, m64
//    * BTRQ r64, m64
//
func (self *Program) BTRQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTRQ", 2, Operands { v0, v1 })
    // BTRQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTRQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xb3)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTRQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(6, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTRQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0xb3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTRQ")
    }
    return p
}

// BTRW performs "Bit Test and Reset".
//
// Mnemonic        : BTR
// Supported forms : (4 forms)
//
//    * BTRW imm8, r16
//    * BTRW r16, r16
//    * BTRW imm8, m16
//    * BTRW r16, m16
//
func (self *Program) BTRW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTRW", 2, Operands { v0, v1 })
    // BTRW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTRW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xb3)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTRW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(6, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTRW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xb3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTRW")
    }
    return p
}

// BTSL performs "Bit Test and Set".
//
// Mnemonic        : BTS
// Supported forms : (4 forms)
//
//    * BTSL imm8, r32
//    * BTSL r32, r32
//    * BTSL imm8, m32
//    * BTSL r32, m32
//
func (self *Program) BTSL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTSL", 2, Operands { v0, v1 })
    // BTSL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTSL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xab)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTSL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTSL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xab)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTSL")
    }
    return p
}

// BTSQ performs "Bit Test and Set".
//
// Mnemonic        : BTS
// Supported forms : (4 forms)
//
//    * BTSQ imm8, r64
//    * BTSQ r64, r64
//    * BTSQ imm8, m64
//    * BTSQ r64, m64
//
func (self *Program) BTSQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTSQ", 2, Operands { v0, v1 })
    // BTSQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTSQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xab)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTSQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTSQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0xab)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTSQ")
    }
    return p
}

// BTSW performs "Bit Test and Set".
//
// Mnemonic        : BTS
// Supported forms : (4 forms)
//
//    * BTSW imm8, r16
//    * BTSW r16, r16
//    * BTSW imm8, m16
//    * BTSW r16, m16
//
func (self *Program) BTSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTSW", 2, Operands { v0, v1 })
    // BTSW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTSW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xab)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTSW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTSW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xab)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTSW")
    }
    return p
}

// BTW performs "Bit Test".
//
// Mnemonic        : BT
// Supported forms : (4 forms)
//
//    * BTW imm8, r16
//    * BTW r16, r16
//    * BTW imm8, m16
//    * BTW r16, m16
//
func (self *Program) BTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("BTW", 2, Operands { v0, v1 })
    // BTW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0xba)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xa3)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // BTW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xba)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // BTW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xa3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BTW")
    }
    return p
}

// BZHI performs "Zero High Bits Starting with Specified Bit Position".
//
// Mnemonic        : BZHI
// Supported forms : (4 forms)
//
//    * BZHI r32, r32, r32    [BMI2]
//    * BZHI r32, m32, r32    [BMI2]
//    * BZHI r64, r64, r64    [BMI2]
//    * BZHI r64, m64, r64    [BMI2]
//
func (self *Program) BZHI(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("BZHI", 3, Operands { v0, v1, v2 })
    // BZHI r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x78 ^ (hlcode(v[0]) << 3))
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // BZHI r32, m32, r32
    if isReg32(v0) && isM32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x00, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf5)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    // BZHI r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0xf8 ^ (hlcode(v[0]) << 3))
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // BZHI r64, m64, r64
    if isReg64(v0) && isM64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x80, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf5)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for BZHI")
    }
    return p
}

// CALL performs "Call Procedure".
//
// Mnemonic        : CALL
// Supported forms : (1 form)
//
//    * CALL rel32
//
func (self *Program) CALL(v0 interface{}) *Instruction {
    p := self.alloc("CALL", 1, Operands { v0 })
    // CALL rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xe8)
            m.imm4(relv(v[0]))
        })
    }
    // CALL label
    if isLabel(v0) {
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0xe8)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for CALL")
    }
    return p
}

// CALLQ performs "Call Procedure".
//
// Mnemonic        : CALL
// Supported forms : (2 forms)
//
//    * CALLQ r64
//    * CALLQ m64
//
func (self *Program) CALLQ(v0 interface{}) *Instruction {
    p := self.alloc("CALLQ", 1, Operands { v0 })
    // CALLQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // CALLQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CALLQ")
    }
    return p
}

// CBTW performs "Convert Byte to Word".
//
// Mnemonic        : CBW
// Supported forms : (1 form)
//
//    * CBTW
//
func (self *Program) CBTW() *Instruction {
    p := self.alloc("CBTW", 0, Operands {  })
    // CBTW
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x66)
        m.emit(0x98)
    })
    return p
}

// CLC performs "Clear Carry Flag".
//
// Mnemonic        : CLC
// Supported forms : (1 form)
//
//    * CLC
//
func (self *Program) CLC() *Instruction {
    p := self.alloc("CLC", 0, Operands {  })
    // CLC
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0xf8)
    })
    return p
}

// CLD performs "Clear Direction Flag".
//
// Mnemonic        : CLD
// Supported forms : (1 form)
//
//    * CLD
//
func (self *Program) CLD() *Instruction {
    p := self.alloc("CLD", 0, Operands {  })
    // CLD
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0xfc)
    })
    return p
}

// CLFLUSH performs "Flush Cache Line".
//
// Mnemonic        : CLFLUSH
// Supported forms : (1 form)
//
//    * CLFLUSH m8    [CLFLUSH]
//
func (self *Program) CLFLUSH(v0 interface{}) *Instruction {
    p := self.alloc("CLFLUSH", 1, Operands { v0 })
    // CLFLUSH m8
    if isM8(v0) {
        self.require(ISA_CLFLUSH)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xae)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CLFLUSH")
    }
    return p
}

// CLFLUSHOPT performs "Flush Cache Line Optimized".
//
// Mnemonic        : CLFLUSHOPT
// Supported forms : (1 form)
//
//    * CLFLUSHOPT m8    [CLFLUSHOPT]
//
func (self *Program) CLFLUSHOPT(v0 interface{}) *Instruction {
    p := self.alloc("CLFLUSHOPT", 1, Operands { v0 })
    // CLFLUSHOPT m8
    if isM8(v0) {
        self.require(ISA_CLFLUSHOPT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xae)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CLFLUSHOPT")
    }
    return p
}

// CLTD performs "Convert Doubleword to Quadword".
//
// Mnemonic        : CDQ
// Supported forms : (1 form)
//
//    * CLTD
//
func (self *Program) CLTD() *Instruction {
    p := self.alloc("CLTD", 0, Operands {  })
    // CLTD
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x99)
    })
    return p
}

// CLTQ performs "Convert Doubleword to Quadword".
//
// Mnemonic        : CDQE
// Supported forms : (1 form)
//
//    * CLTQ
//
func (self *Program) CLTQ() *Instruction {
    p := self.alloc("CLTQ", 0, Operands {  })
    // CLTQ
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x48)
        m.emit(0x98)
    })
    return p
}

// CLWB performs "Cache Line Write Back".
//
// Mnemonic        : CLWB
// Supported forms : (1 form)
//
//    * CLWB m8    [CLWB]
//
func (self *Program) CLWB(v0 interface{}) *Instruction {
    p := self.alloc("CLWB", 1, Operands { v0 })
    // CLWB m8
    if isM8(v0) {
        self.require(ISA_CLWB)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xae)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CLWB")
    }
    return p
}

// CLZERO performs "Zero-out 64-bit Cache Line".
//
// Mnemonic        : CLZERO
// Supported forms : (1 form)
//
//    * CLZERO    [CLZERO]
//
func (self *Program) CLZERO() *Instruction {
    p := self.alloc("CLZERO", 0, Operands {  })
    // CLZERO
    self.require(ISA_CLZERO)
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x01)
        m.emit(0xfc)
    })
    return p
}

// CMC performs "Complement Carry Flag".
//
// Mnemonic        : CMC
// Supported forms : (1 form)
//
//    * CMC
//
func (self *Program) CMC() *Instruction {
    p := self.alloc("CMC", 0, Operands {  })
    // CMC
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0xf5)
    })
    return p
}

// CMOVA performs "Move if above (CF == 0 and ZF == 0)".
//
// Mnemonic        : CMOVA
// Supported forms : (6 forms)
//
//    * CMOVA r16, r16    [CMOV]
//    * CMOVA m16, r16    [CMOV]
//    * CMOVA r32, r32    [CMOV]
//    * CMOVA m32, r32    [CMOV]
//    * CMOVA r64, r64    [CMOV]
//    * CMOVA m64, r64    [CMOV]
//
func (self *Program) CMOVA(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVA", 2, Operands { v0, v1 })
    // CMOVA r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVA m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x47)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVA r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVA m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x47)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVA r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVA m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x47)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVA")
    }
    return p
}

// CMOVAE performs "Move if above or equal (CF == 0)".
//
// Mnemonic        : CMOVAE
// Supported forms : (6 forms)
//
//    * CMOVAE r16, r16    [CMOV]
//    * CMOVAE m16, r16    [CMOV]
//    * CMOVAE r32, r32    [CMOV]
//    * CMOVAE m32, r32    [CMOV]
//    * CMOVAE r64, r64    [CMOV]
//    * CMOVAE m64, r64    [CMOV]
//
func (self *Program) CMOVAE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVAE", 2, Operands { v0, v1 })
    // CMOVAE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVAE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVAE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVAE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVAE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVAE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVAE")
    }
    return p
}

// CMOVB performs "Move if below (CF == 1)".
//
// Mnemonic        : CMOVB
// Supported forms : (6 forms)
//
//    * CMOVB r16, r16    [CMOV]
//    * CMOVB m16, r16    [CMOV]
//    * CMOVB r32, r32    [CMOV]
//    * CMOVB m32, r32    [CMOV]
//    * CMOVB r64, r64    [CMOV]
//    * CMOVB m64, r64    [CMOV]
//
func (self *Program) CMOVB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVB", 2, Operands { v0, v1 })
    // CMOVB r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVB m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVB r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVB m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVB r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVB m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVB")
    }
    return p
}

// CMOVBE performs "Move if below or equal (CF == 1 or ZF == 1)".
//
// Mnemonic        : CMOVBE
// Supported forms : (6 forms)
//
//    * CMOVBE r16, r16    [CMOV]
//    * CMOVBE m16, r16    [CMOV]
//    * CMOVBE r32, r32    [CMOV]
//    * CMOVBE m32, r32    [CMOV]
//    * CMOVBE r64, r64    [CMOV]
//    * CMOVBE m64, r64    [CMOV]
//
func (self *Program) CMOVBE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVBE", 2, Operands { v0, v1 })
    // CMOVBE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVBE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x46)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVBE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVBE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x46)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVBE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVBE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x46)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVBE")
    }
    return p
}

// CMOVC performs "Move if carry (CF == 1)".
//
// Mnemonic        : CMOVC
// Supported forms : (6 forms)
//
//    * CMOVC r16, r16    [CMOV]
//    * CMOVC m16, r16    [CMOV]
//    * CMOVC r32, r32    [CMOV]
//    * CMOVC m32, r32    [CMOV]
//    * CMOVC r64, r64    [CMOV]
//    * CMOVC m64, r64    [CMOV]
//
func (self *Program) CMOVC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVC", 2, Operands { v0, v1 })
    // CMOVC r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVC m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVC r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVC m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVC r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVC m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVC")
    }
    return p
}

// CMOVE performs "Move if equal (ZF == 1)".
//
// Mnemonic        : CMOVE
// Supported forms : (6 forms)
//
//    * CMOVE r16, r16    [CMOV]
//    * CMOVE m16, r16    [CMOV]
//    * CMOVE r32, r32    [CMOV]
//    * CMOVE m32, r32    [CMOV]
//    * CMOVE r64, r64    [CMOV]
//    * CMOVE m64, r64    [CMOV]
//
func (self *Program) CMOVE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVE", 2, Operands { v0, v1 })
    // CMOVE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x44)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x44)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x44)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVE")
    }
    return p
}

// CMOVG performs "Move if greater (ZF == 0 and SF == OF)".
//
// Mnemonic        : CMOVG
// Supported forms : (6 forms)
//
//    * CMOVG r16, r16    [CMOV]
//    * CMOVG m16, r16    [CMOV]
//    * CMOVG r32, r32    [CMOV]
//    * CMOVG m32, r32    [CMOV]
//    * CMOVG r64, r64    [CMOV]
//    * CMOVG m64, r64    [CMOV]
//
func (self *Program) CMOVG(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVG", 2, Operands { v0, v1 })
    // CMOVG r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVG m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVG r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVG m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVG r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVG m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVG")
    }
    return p
}

// CMOVGE performs "Move if greater or equal (SF == OF)".
//
// Mnemonic        : CMOVGE
// Supported forms : (6 forms)
//
//    * CMOVGE r16, r16    [CMOV]
//    * CMOVGE m16, r16    [CMOV]
//    * CMOVGE r32, r32    [CMOV]
//    * CMOVGE m32, r32    [CMOV]
//    * CMOVGE r64, r64    [CMOV]
//    * CMOVGE m64, r64    [CMOV]
//
func (self *Program) CMOVGE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVGE", 2, Operands { v0, v1 })
    // CMOVGE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVGE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVGE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVGE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVGE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVGE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVGE")
    }
    return p
}

// CMOVL performs "Move if less (SF != OF)".
//
// Mnemonic        : CMOVL
// Supported forms : (6 forms)
//
//    * CMOVL r16, r16    [CMOV]
//    * CMOVL m16, r16    [CMOV]
//    * CMOVL r32, r32    [CMOV]
//    * CMOVL m32, r32    [CMOV]
//    * CMOVL r64, r64    [CMOV]
//    * CMOVL m64, r64    [CMOV]
//
func (self *Program) CMOVL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVL", 2, Operands { v0, v1 })
    // CMOVL r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVL m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVL r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVL m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVL")
    }
    return p
}

// CMOVLE performs "Move if less or equal (ZF == 1 or SF != OF)".
//
// Mnemonic        : CMOVLE
// Supported forms : (6 forms)
//
//    * CMOVLE r16, r16    [CMOV]
//    * CMOVLE m16, r16    [CMOV]
//    * CMOVLE r32, r32    [CMOV]
//    * CMOVLE m32, r32    [CMOV]
//    * CMOVLE r64, r64    [CMOV]
//    * CMOVLE m64, r64    [CMOV]
//
func (self *Program) CMOVLE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVLE", 2, Operands { v0, v1 })
    // CMOVLE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVLE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVLE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVLE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVLE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVLE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVLE")
    }
    return p
}

// CMOVNA performs "Move if not above (CF == 1 or ZF == 1)".
//
// Mnemonic        : CMOVNA
// Supported forms : (6 forms)
//
//    * CMOVNA r16, r16    [CMOV]
//    * CMOVNA m16, r16    [CMOV]
//    * CMOVNA r32, r32    [CMOV]
//    * CMOVNA m32, r32    [CMOV]
//    * CMOVNA r64, r64    [CMOV]
//    * CMOVNA m64, r64    [CMOV]
//
func (self *Program) CMOVNA(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNA", 2, Operands { v0, v1 })
    // CMOVNA r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNA m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x46)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNA r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNA m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x46)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNA r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNA m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x46)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNA")
    }
    return p
}

// CMOVNAE performs "Move if not above or equal (CF == 1)".
//
// Mnemonic        : CMOVNAE
// Supported forms : (6 forms)
//
//    * CMOVNAE r16, r16    [CMOV]
//    * CMOVNAE m16, r16    [CMOV]
//    * CMOVNAE r32, r32    [CMOV]
//    * CMOVNAE m32, r32    [CMOV]
//    * CMOVNAE r64, r64    [CMOV]
//    * CMOVNAE m64, r64    [CMOV]
//
func (self *Program) CMOVNAE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNAE", 2, Operands { v0, v1 })
    // CMOVNAE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNAE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNAE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNAE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNAE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNAE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x42)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNAE")
    }
    return p
}

// CMOVNB performs "Move if not below (CF == 0)".
//
// Mnemonic        : CMOVNB
// Supported forms : (6 forms)
//
//    * CMOVNB r16, r16    [CMOV]
//    * CMOVNB m16, r16    [CMOV]
//    * CMOVNB r32, r32    [CMOV]
//    * CMOVNB m32, r32    [CMOV]
//    * CMOVNB r64, r64    [CMOV]
//    * CMOVNB m64, r64    [CMOV]
//
func (self *Program) CMOVNB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNB", 2, Operands { v0, v1 })
    // CMOVNB r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNB m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNB r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNB m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNB r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNB m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNB")
    }
    return p
}

// CMOVNBE performs "Move if not below or equal (CF == 0 and ZF == 0)".
//
// Mnemonic        : CMOVNBE
// Supported forms : (6 forms)
//
//    * CMOVNBE r16, r16    [CMOV]
//    * CMOVNBE m16, r16    [CMOV]
//    * CMOVNBE r32, r32    [CMOV]
//    * CMOVNBE m32, r32    [CMOV]
//    * CMOVNBE r64, r64    [CMOV]
//    * CMOVNBE m64, r64    [CMOV]
//
func (self *Program) CMOVNBE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNBE", 2, Operands { v0, v1 })
    // CMOVNBE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNBE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x47)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNBE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNBE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x47)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNBE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNBE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x47)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNBE")
    }
    return p
}

// CMOVNC performs "Move if not carry (CF == 0)".
//
// Mnemonic        : CMOVNC
// Supported forms : (6 forms)
//
//    * CMOVNC r16, r16    [CMOV]
//    * CMOVNC m16, r16    [CMOV]
//    * CMOVNC r32, r32    [CMOV]
//    * CMOVNC m32, r32    [CMOV]
//    * CMOVNC r64, r64    [CMOV]
//    * CMOVNC m64, r64    [CMOV]
//
func (self *Program) CMOVNC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNC", 2, Operands { v0, v1 })
    // CMOVNC r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNC m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNC r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNC m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNC r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x43)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNC m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x43)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNC")
    }
    return p
}

// CMOVNE performs "Move if not equal (ZF == 0)".
//
// Mnemonic        : CMOVNE
// Supported forms : (6 forms)
//
//    * CMOVNE r16, r16    [CMOV]
//    * CMOVNE m16, r16    [CMOV]
//    * CMOVNE r32, r32    [CMOV]
//    * CMOVNE m32, r32    [CMOV]
//    * CMOVNE r64, r64    [CMOV]
//    * CMOVNE m64, r64    [CMOV]
//
func (self *Program) CMOVNE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNE", 2, Operands { v0, v1 })
    // CMOVNE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x45)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x45)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x45)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNE")
    }
    return p
}

// CMOVNG performs "Move if not greater (ZF == 1 or SF != OF)".
//
// Mnemonic        : CMOVNG
// Supported forms : (6 forms)
//
//    * CMOVNG r16, r16    [CMOV]
//    * CMOVNG m16, r16    [CMOV]
//    * CMOVNG r32, r32    [CMOV]
//    * CMOVNG m32, r32    [CMOV]
//    * CMOVNG r64, r64    [CMOV]
//    * CMOVNG m64, r64    [CMOV]
//
func (self *Program) CMOVNG(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNG", 2, Operands { v0, v1 })
    // CMOVNG r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNG m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNG r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNG m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNG r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNG m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNG")
    }
    return p
}

// CMOVNGE performs "Move if not greater or equal (SF != OF)".
//
// Mnemonic        : CMOVNGE
// Supported forms : (6 forms)
//
//    * CMOVNGE r16, r16    [CMOV]
//    * CMOVNGE m16, r16    [CMOV]
//    * CMOVNGE r32, r32    [CMOV]
//    * CMOVNGE m32, r32    [CMOV]
//    * CMOVNGE r64, r64    [CMOV]
//    * CMOVNGE m64, r64    [CMOV]
//
func (self *Program) CMOVNGE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNGE", 2, Operands { v0, v1 })
    // CMOVNGE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNGE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNGE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNGE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNGE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNGE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNGE")
    }
    return p
}

// CMOVNL performs "Move if not less (SF == OF)".
//
// Mnemonic        : CMOVNL
// Supported forms : (6 forms)
//
//    * CMOVNL r16, r16    [CMOV]
//    * CMOVNL m16, r16    [CMOV]
//    * CMOVNL r32, r32    [CMOV]
//    * CMOVNL m32, r32    [CMOV]
//    * CMOVNL r64, r64    [CMOV]
//    * CMOVNL m64, r64    [CMOV]
//
func (self *Program) CMOVNL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNL", 2, Operands { v0, v1 })
    // CMOVNL r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNL m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNL r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNL m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNL")
    }
    return p
}

// CMOVNLE performs "Move if not less or equal (ZF == 0 and SF == OF)".
//
// Mnemonic        : CMOVNLE
// Supported forms : (6 forms)
//
//    * CMOVNLE r16, r16    [CMOV]
//    * CMOVNLE m16, r16    [CMOV]
//    * CMOVNLE r32, r32    [CMOV]
//    * CMOVNLE m32, r32    [CMOV]
//    * CMOVNLE r64, r64    [CMOV]
//    * CMOVNLE m64, r64    [CMOV]
//
func (self *Program) CMOVNLE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNLE", 2, Operands { v0, v1 })
    // CMOVNLE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNLE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNLE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNLE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNLE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNLE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNLE")
    }
    return p
}

// CMOVNO performs "Move if not overflow (OF == 0)".
//
// Mnemonic        : CMOVNO
// Supported forms : (6 forms)
//
//    * CMOVNO r16, r16    [CMOV]
//    * CMOVNO m16, r16    [CMOV]
//    * CMOVNO r32, r32    [CMOV]
//    * CMOVNO m32, r32    [CMOV]
//    * CMOVNO r64, r64    [CMOV]
//    * CMOVNO m64, r64    [CMOV]
//
func (self *Program) CMOVNO(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNO", 2, Operands { v0, v1 })
    // CMOVNO r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNO m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x41)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNO r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNO m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x41)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNO r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNO m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x41)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNO")
    }
    return p
}

// CMOVNP performs "Move if not parity (PF == 0)".
//
// Mnemonic        : CMOVNP
// Supported forms : (6 forms)
//
//    * CMOVNP r16, r16    [CMOV]
//    * CMOVNP m16, r16    [CMOV]
//    * CMOVNP r32, r32    [CMOV]
//    * CMOVNP m32, r32    [CMOV]
//    * CMOVNP r64, r64    [CMOV]
//    * CMOVNP m64, r64    [CMOV]
//
func (self *Program) CMOVNP(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNP", 2, Operands { v0, v1 })
    // CMOVNP r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNP m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNP r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNP m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNP r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNP m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNP")
    }
    return p
}

// CMOVNS performs "Move if not sign (SF == 0)".
//
// Mnemonic        : CMOVNS
// Supported forms : (6 forms)
//
//    * CMOVNS r16, r16    [CMOV]
//    * CMOVNS m16, r16    [CMOV]
//    * CMOVNS r32, r32    [CMOV]
//    * CMOVNS m32, r32    [CMOV]
//    * CMOVNS r64, r64    [CMOV]
//    * CMOVNS m64, r64    [CMOV]
//
func (self *Program) CMOVNS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNS", 2, Operands { v0, v1 })
    // CMOVNS r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x49)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNS m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x49)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNS r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x49)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNS m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x49)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNS r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x49)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNS m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x49)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNS")
    }
    return p
}

// CMOVNZ performs "Move if not zero (ZF == 0)".
//
// Mnemonic        : CMOVNZ
// Supported forms : (6 forms)
//
//    * CMOVNZ r16, r16    [CMOV]
//    * CMOVNZ m16, r16    [CMOV]
//    * CMOVNZ r32, r32    [CMOV]
//    * CMOVNZ m32, r32    [CMOV]
//    * CMOVNZ r64, r64    [CMOV]
//    * CMOVNZ m64, r64    [CMOV]
//
func (self *Program) CMOVNZ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVNZ", 2, Operands { v0, v1 })
    // CMOVNZ r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNZ m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x45)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNZ r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNZ m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x45)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVNZ r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVNZ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x45)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVNZ")
    }
    return p
}

// CMOVO performs "Move if overflow (OF == 1)".
//
// Mnemonic        : CMOVO
// Supported forms : (6 forms)
//
//    * CMOVO r16, r16    [CMOV]
//    * CMOVO m16, r16    [CMOV]
//    * CMOVO r32, r32    [CMOV]
//    * CMOVO m32, r32    [CMOV]
//    * CMOVO r64, r64    [CMOV]
//    * CMOVO m64, r64    [CMOV]
//
func (self *Program) CMOVO(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVO", 2, Operands { v0, v1 })
    // CMOVO r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x40)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVO m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x40)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVO r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x40)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVO m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x40)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVO r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x40)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVO m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x40)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVO")
    }
    return p
}

// CMOVP performs "Move if parity (PF == 1)".
//
// Mnemonic        : CMOVP
// Supported forms : (6 forms)
//
//    * CMOVP r16, r16    [CMOV]
//    * CMOVP m16, r16    [CMOV]
//    * CMOVP r32, r32    [CMOV]
//    * CMOVP m32, r32    [CMOV]
//    * CMOVP r64, r64    [CMOV]
//    * CMOVP m64, r64    [CMOV]
//
func (self *Program) CMOVP(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVP", 2, Operands { v0, v1 })
    // CMOVP r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVP m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVP r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVP m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVP r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVP m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVP")
    }
    return p
}

// CMOVPE performs "Move if parity even (PF == 1)".
//
// Mnemonic        : CMOVPE
// Supported forms : (6 forms)
//
//    * CMOVPE r16, r16    [CMOV]
//    * CMOVPE m16, r16    [CMOV]
//    * CMOVPE r32, r32    [CMOV]
//    * CMOVPE m32, r32    [CMOV]
//    * CMOVPE r64, r64    [CMOV]
//    * CMOVPE m64, r64    [CMOV]
//
func (self *Program) CMOVPE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVPE", 2, Operands { v0, v1 })
    // CMOVPE r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVPE m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVPE r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVPE m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVPE r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVPE m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVPE")
    }
    return p
}

// CMOVPO performs "Move if parity odd (PF == 0)".
//
// Mnemonic        : CMOVPO
// Supported forms : (6 forms)
//
//    * CMOVPO r16, r16    [CMOV]
//    * CMOVPO m16, r16    [CMOV]
//    * CMOVPO r32, r32    [CMOV]
//    * CMOVPO m32, r32    [CMOV]
//    * CMOVPO r64, r64    [CMOV]
//    * CMOVPO m64, r64    [CMOV]
//
func (self *Program) CMOVPO(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVPO", 2, Operands { v0, v1 })
    // CMOVPO r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVPO m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVPO r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVPO m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x4b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVPO r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVPO m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x4b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVPO")
    }
    return p
}

// CMOVS performs "Move if sign (SF == 1)".
//
// Mnemonic        : CMOVS
// Supported forms : (6 forms)
//
//    * CMOVS r16, r16    [CMOV]
//    * CMOVS m16, r16    [CMOV]
//    * CMOVS r32, r32    [CMOV]
//    * CMOVS m32, r32    [CMOV]
//    * CMOVS r64, r64    [CMOV]
//    * CMOVS m64, r64    [CMOV]
//
func (self *Program) CMOVS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVS", 2, Operands { v0, v1 })
    // CMOVS r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x48)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVS m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x48)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVS r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x48)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVS m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x48)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVS r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x48)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVS m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x48)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVS")
    }
    return p
}

// CMOVZ performs "Move if zero (ZF == 1)".
//
// Mnemonic        : CMOVZ
// Supported forms : (6 forms)
//
//    * CMOVZ r16, r16    [CMOV]
//    * CMOVZ m16, r16    [CMOV]
//    * CMOVZ r32, r32    [CMOV]
//    * CMOVZ m32, r32    [CMOV]
//    * CMOVZ r64, r64    [CMOV]
//    * CMOVZ m64, r64    [CMOV]
//
func (self *Program) CMOVZ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMOVZ", 2, Operands { v0, v1 })
    // CMOVZ r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVZ m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x44)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVZ r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVZ m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x44)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMOVZ r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMOVZ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_CMOV)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x44)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMOVZ")
    }
    return p
}

// CMPB performs "Compare Two Operands".
//
// Mnemonic        : CMP
// Supported forms : (6 forms)
//
//    * CMPB imm8, al
//    * CMPB imm8, r8
//    * CMPB r8, r8
//    * CMPB m8, r8
//    * CMPB imm8, m8
//    * CMPB r8, m8
//
func (self *Program) CMPB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPB", 2, Operands { v0, v1 })
    // CMPB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x3c)
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0x80)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x38)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x3a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMPB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x3a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMPB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x80)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x38)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPB")
    }
    return p
}

// CMPL performs "Compare Two Operands".
//
// Mnemonic        : CMP
// Supported forms : (8 forms)
//
//    * CMPL imm32, eax
//    * CMPL imm8, r32
//    * CMPL imm32, r32
//    * CMPL r32, r32
//    * CMPL m32, r32
//    * CMPL imm8, m32
//    * CMPL imm32, m32
//    * CMPL r32, m32
//
func (self *Program) CMPL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPL", 2, Operands { v0, v1 })
    // CMPL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x3d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // CMPL imm8, r32
    if isImm8Ext(v0, 4) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xf8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // CMPL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x39)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x3b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMPL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x3b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMPL imm8, m32
    if isImm8Ext(v0, 4) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(7, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // CMPL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x39)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPL")
    }
    return p
}

// CMPPD performs "Compare Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : CMPPD
// Supported forms : (2 forms)
//
//    * CMPPD imm8, xmm, xmm     [SSE2]
//    * CMPPD imm8, m128, xmm    [SSE2]
//
func (self *Program) CMPPD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("CMPPD", 3, Operands { v0, v1, v2 })
    // CMPPD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPPD imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPPD")
    }
    return p
}

// CMPPS performs "Compare Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : CMPPS
// Supported forms : (2 forms)
//
//    * CMPPS imm8, xmm, xmm     [SSE]
//    * CMPPS imm8, m128, xmm    [SSE]
//
func (self *Program) CMPPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("CMPPS", 3, Operands { v0, v1, v2 })
    // CMPPS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPPS imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPPS")
    }
    return p
}

// CMPQ performs "Compare Two Operands".
//
// Mnemonic        : CMP
// Supported forms : (8 forms)
//
//    * CMPQ imm32, rax
//    * CMPQ imm8, r64
//    * CMPQ imm32, r64
//    * CMPQ r64, r64
//    * CMPQ m64, r64
//    * CMPQ imm8, m64
//    * CMPQ imm32, m64
//    * CMPQ r64, m64
//
func (self *Program) CMPQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPQ", 2, Operands { v0, v1 })
    // CMPQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0x3d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // CMPQ imm8, r64
    if isImm8Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x83)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x81)
            m.emit(0xf8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // CMPQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x39)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x3b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMPQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x3b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMPQ imm8, m64
    if isImm8Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x83)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x81)
            m.mrsd(7, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // CMPQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x39)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPQ")
    }
    return p
}

// CMPSD performs "Compare Scalar Double-Precision Floating-Point Values".
//
// Mnemonic        : CMPSD
// Supported forms : (2 forms)
//
//    * CMPSD imm8, xmm, xmm    [SSE2]
//    * CMPSD imm8, m64, xmm    [SSE2]
//
func (self *Program) CMPSD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("CMPSD", 3, Operands { v0, v1, v2 })
    // CMPSD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPSD imm8, m64, xmm
    if isImm8(v0) && isM64(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPSD")
    }
    return p
}

// CMPSS performs "Compare Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : CMPSS
// Supported forms : (2 forms)
//
//    * CMPSS imm8, xmm, xmm    [SSE]
//    * CMPSS imm8, m32, xmm    [SSE]
//
func (self *Program) CMPSS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("CMPSS", 3, Operands { v0, v1, v2 })
    // CMPSS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPSS imm8, m32, xmm
    if isImm8(v0) && isM32(v1) && isXMM(v2) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc2)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPSS")
    }
    return p
}

// CMPW performs "Compare Two Operands".
//
// Mnemonic        : CMP
// Supported forms : (8 forms)
//
//    * CMPW imm16, ax
//    * CMPW imm8, r16
//    * CMPW imm16, r16
//    * CMPW r16, r16
//    * CMPW m16, r16
//    * CMPW imm8, m16
//    * CMPW imm16, m16
//    * CMPW r16, m16
//
func (self *Program) CMPW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPW", 2, Operands { v0, v1 })
    // CMPW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x3d)
            m.imm2(toImmAny(v[0]))
        })
    }
    // CMPW imm8, r16
    if isImm8Ext(v0, 2) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xf8 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // CMPW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x39)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x3b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CMPW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x3b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CMPW imm8, m16
    if isImm8Ext(v0, 2) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // CMPW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(7, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // CMPW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x39)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPW")
    }
    return p
}

// CMPXCHG16B performs "Compare and Exchange 16 Bytes".
//
// Mnemonic        : CMPXCHG16B
// Supported forms : (1 form)
//
//    * CMPXCHG16B m128
//
func (self *Program) CMPXCHG16B(v0 interface{}) *Instruction {
    p := self.alloc("CMPXCHG16B", 1, Operands { v0 })
    // CMPXCHG16B m128
    if isM128(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0x0f)
            m.emit(0xc7)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPXCHG16B")
    }
    return p
}

// CMPXCHG8B performs "Compare and Exchange 8 Bytes".
//
// Mnemonic        : CMPXCHG8B
// Supported forms : (1 form)
//
//    * CMPXCHG8B m64
//
func (self *Program) CMPXCHG8B(v0 interface{}) *Instruction {
    p := self.alloc("CMPXCHG8B", 1, Operands { v0 })
    // CMPXCHG8B m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xc7)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPXCHG8B")
    }
    return p
}

// CMPXCHGB performs "Compare and Exchange".
//
// Mnemonic        : CMPXCHG
// Supported forms : (2 forms)
//
//    * CMPXCHGB r8, r8
//    * CMPXCHGB r8, m8
//
func (self *Program) CMPXCHGB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPXCHGB", 2, Operands { v0, v1 })
    // CMPXCHGB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x0f)
            m.emit(0xb0)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // CMPXCHGB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0xb0)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPXCHGB")
    }
    return p
}

// CMPXCHGL performs "Compare and Exchange".
//
// Mnemonic        : CMPXCHG
// Supported forms : (2 forms)
//
//    * CMPXCHGL r32, r32
//    * CMPXCHGL r32, m32
//
func (self *Program) CMPXCHGL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPXCHGL", 2, Operands { v0, v1 })
    // CMPXCHGL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xb1)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // CMPXCHGL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xb1)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPXCHGL")
    }
    return p
}

// CMPXCHGQ performs "Compare and Exchange".
//
// Mnemonic        : CMPXCHG
// Supported forms : (2 forms)
//
//    * CMPXCHGQ r64, r64
//    * CMPXCHGQ r64, m64
//
func (self *Program) CMPXCHGQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPXCHGQ", 2, Operands { v0, v1 })
    // CMPXCHGQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0xb1)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // CMPXCHGQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0xb1)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPXCHGQ")
    }
    return p
}

// CMPXCHGW performs "Compare and Exchange".
//
// Mnemonic        : CMPXCHG
// Supported forms : (2 forms)
//
//    * CMPXCHGW r16, r16
//    * CMPXCHGW r16, m16
//
func (self *Program) CMPXCHGW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CMPXCHGW", 2, Operands { v0, v1 })
    // CMPXCHGW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xb1)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // CMPXCHGW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xb1)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CMPXCHGW")
    }
    return p
}

// COMISD performs "Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS".
//
// Mnemonic        : COMISD
// Supported forms : (2 forms)
//
//    * COMISD xmm, xmm    [SSE2]
//    * COMISD m64, xmm    [SSE2]
//
func (self *Program) COMISD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("COMISD", 2, Operands { v0, v1 })
    // COMISD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // COMISD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for COMISD")
    }
    return p
}

// COMISS performs "Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS".
//
// Mnemonic        : COMISS
// Supported forms : (2 forms)
//
//    * COMISS xmm, xmm    [SSE]
//    * COMISS m32, xmm    [SSE]
//
func (self *Program) COMISS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("COMISS", 2, Operands { v0, v1 })
    // COMISS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // COMISS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for COMISS")
    }
    return p
}

// CPUID performs "CPU Identification".
//
// Mnemonic        : CPUID
// Supported forms : (1 form)
//
//    * CPUID    [CPUID]
//
func (self *Program) CPUID() *Instruction {
    p := self.alloc("CPUID", 0, Operands {  })
    // CPUID
    self.require(ISA_CPUID)
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0xa2)
    })
    return p
}

// CQTO performs "Convert Quadword to Octaword".
//
// Mnemonic        : CQO
// Supported forms : (1 form)
//
//    * CQTO
//
func (self *Program) CQTO() *Instruction {
    p := self.alloc("CQTO", 0, Operands {  })
    // CQTO
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x48)
        m.emit(0x99)
    })
    return p
}

// CRC32B performs "Accumulate CRC32 Value".
//
// Mnemonic        : CRC32
// Supported forms : (4 forms)
//
//    * CRC32B r8, r32    [SSE4.2]
//    * CRC32B m8, r32    [SSE4.2]
//    * CRC32B r8, r64    [SSE4.2]
//    * CRC32B m8, r64    [SSE4.2]
//
func (self *Program) CRC32B(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CRC32B", 2, Operands { v0, v1 })
    // CRC32B r8, r32
    if isReg8(v0) && isReg32(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf0)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CRC32B m8, r32
    if isM8(v0) && isReg32(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CRC32B r8, r64
    if isReg8(v0) && isReg64(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf0)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CRC32B m8, r64
    if isM8(v0) && isReg64(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CRC32B")
    }
    return p
}

// CRC32L performs "Accumulate CRC32 Value".
//
// Mnemonic        : CRC32
// Supported forms : (2 forms)
//
//    * CRC32L r32, r32    [SSE4.2]
//    * CRC32L m32, r32    [SSE4.2]
//
func (self *Program) CRC32L(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CRC32L", 2, Operands { v0, v1 })
    // CRC32L r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CRC32L m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CRC32L")
    }
    return p
}

// CRC32Q performs "Accumulate CRC32 Value".
//
// Mnemonic        : CRC32
// Supported forms : (2 forms)
//
//    * CRC32Q r64, r64    [SSE4.2]
//    * CRC32Q m64, r64    [SSE4.2]
//
func (self *Program) CRC32Q(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CRC32Q", 2, Operands { v0, v1 })
    // CRC32Q r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CRC32Q m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CRC32Q")
    }
    return p
}

// CRC32W performs "Accumulate CRC32 Value".
//
// Mnemonic        : CRC32
// Supported forms : (2 forms)
//
//    * CRC32W r16, r32    [SSE4.2]
//    * CRC32W m16, r32    [SSE4.2]
//
func (self *Program) CRC32W(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CRC32W", 2, Operands { v0, v1 })
    // CRC32W r16, r32
    if isReg16(v0) && isReg32(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CRC32W m16, r32
    if isM16(v0) && isReg32(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CRC32W")
    }
    return p
}

// CVTDQ2PD performs "Convert Packed Dword Integers to Packed Double-Precision FP Values".
//
// Mnemonic        : CVTDQ2PD
// Supported forms : (2 forms)
//
//    * CVTDQ2PD xmm, xmm    [SSE2]
//    * CVTDQ2PD m64, xmm    [SSE2]
//
func (self *Program) CVTDQ2PD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTDQ2PD", 2, Operands { v0, v1 })
    // CVTDQ2PD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTDQ2PD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTDQ2PD")
    }
    return p
}

// CVTDQ2PS performs "Convert Packed Dword Integers to Packed Single-Precision FP Values".
//
// Mnemonic        : CVTDQ2PS
// Supported forms : (2 forms)
//
//    * CVTDQ2PS xmm, xmm     [SSE2]
//    * CVTDQ2PS m128, xmm    [SSE2]
//
func (self *Program) CVTDQ2PS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTDQ2PS", 2, Operands { v0, v1 })
    // CVTDQ2PS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTDQ2PS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTDQ2PS")
    }
    return p
}

// CVTPD2DQ performs "Convert Packed Double-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTPD2DQ
// Supported forms : (2 forms)
//
//    * CVTPD2DQ xmm, xmm     [SSE2]
//    * CVTPD2DQ m128, xmm    [SSE2]
//
func (self *Program) CVTPD2DQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPD2DQ", 2, Operands { v0, v1 })
    // CVTPD2DQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPD2DQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPD2DQ")
    }
    return p
}

// CVTPD2PI performs "Convert Packed Double-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTPD2PI
// Supported forms : (2 forms)
//
//    * CVTPD2PI xmm, mm     [SSE]
//    * CVTPD2PI m128, mm    [SSE]
//
func (self *Program) CVTPD2PI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPD2PI", 2, Operands { v0, v1 })
    // CVTPD2PI xmm, mm
    if isXMM(v0) && isMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPD2PI m128, mm
    if isM128(v0) && isMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPD2PI")
    }
    return p
}

// CVTPD2PS performs "Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values".
//
// Mnemonic        : CVTPD2PS
// Supported forms : (2 forms)
//
//    * CVTPD2PS xmm, xmm     [SSE2]
//    * CVTPD2PS m128, xmm    [SSE2]
//
func (self *Program) CVTPD2PS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPD2PS", 2, Operands { v0, v1 })
    // CVTPD2PS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPD2PS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPD2PS")
    }
    return p
}

// CVTPI2PD performs "Convert Packed Dword Integers to Packed Double-Precision FP Values".
//
// Mnemonic        : CVTPI2PD
// Supported forms : (2 forms)
//
//    * CVTPI2PD mm, xmm     [SSE2]
//    * CVTPI2PD m64, xmm    [SSE2]
//
func (self *Program) CVTPI2PD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPI2PD", 2, Operands { v0, v1 })
    // CVTPI2PD mm, xmm
    if isMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPI2PD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPI2PD")
    }
    return p
}

// CVTPI2PS performs "Convert Packed Dword Integers to Packed Single-Precision FP Values".
//
// Mnemonic        : CVTPI2PS
// Supported forms : (2 forms)
//
//    * CVTPI2PS mm, xmm     [SSE]
//    * CVTPI2PS m64, xmm    [SSE]
//
func (self *Program) CVTPI2PS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPI2PS", 2, Operands { v0, v1 })
    // CVTPI2PS mm, xmm
    if isMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPI2PS m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPI2PS")
    }
    return p
}

// CVTPS2DQ performs "Convert Packed Single-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTPS2DQ
// Supported forms : (2 forms)
//
//    * CVTPS2DQ xmm, xmm     [SSE2]
//    * CVTPS2DQ m128, xmm    [SSE2]
//
func (self *Program) CVTPS2DQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPS2DQ", 2, Operands { v0, v1 })
    // CVTPS2DQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPS2DQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPS2DQ")
    }
    return p
}

// CVTPS2PD performs "Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values".
//
// Mnemonic        : CVTPS2PD
// Supported forms : (2 forms)
//
//    * CVTPS2PD xmm, xmm    [SSE2]
//    * CVTPS2PD m64, xmm    [SSE2]
//
func (self *Program) CVTPS2PD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPS2PD", 2, Operands { v0, v1 })
    // CVTPS2PD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPS2PD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPS2PD")
    }
    return p
}

// CVTPS2PI performs "Convert Packed Single-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTPS2PI
// Supported forms : (2 forms)
//
//    * CVTPS2PI xmm, mm    [SSE]
//    * CVTPS2PI m64, mm    [SSE]
//
func (self *Program) CVTPS2PI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTPS2PI", 2, Operands { v0, v1 })
    // CVTPS2PI xmm, mm
    if isXMM(v0) && isMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTPS2PI m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTPS2PI")
    }
    return p
}

// CVTSD2SI performs "Convert Scalar Double-Precision FP Value to Integer".
//
// Mnemonic        : CVTSD2SI
// Supported forms : (4 forms)
//
//    * CVTSD2SI xmm, r32    [SSE2]
//    * CVTSD2SI m64, r32    [SSE2]
//    * CVTSD2SI xmm, r64    [SSE2]
//    * CVTSD2SI m64, r64    [SSE2]
//
func (self *Program) CVTSD2SI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTSD2SI", 2, Operands { v0, v1 })
    // CVTSD2SI xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSD2SI m64, r32
    if isM64(v0) && isReg32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CVTSD2SI xmm, r64
    if isXMM(v0) && isReg64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x2d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSD2SI m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x2d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTSD2SI")
    }
    return p
}

// CVTSD2SS performs "Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value".
//
// Mnemonic        : CVTSD2SS
// Supported forms : (2 forms)
//
//    * CVTSD2SS xmm, xmm    [SSE2]
//    * CVTSD2SS m64, xmm    [SSE2]
//
func (self *Program) CVTSD2SS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTSD2SS", 2, Operands { v0, v1 })
    // CVTSD2SS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSD2SS m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTSD2SS")
    }
    return p
}

// CVTSI2SD performs "Convert Dword Integer to Scalar Double-Precision FP Value".
//
// Mnemonic        : CVTSI2SD
// Supported forms : (4 forms)
//
//    * CVTSI2SD r32, xmm    [SSE2]
//    * CVTSI2SD r64, xmm    [SSE2]
//    * CVTSI2SD m32, xmm    [SSE2]
//    * CVTSI2SD m64, xmm    [SSE2]
//
func (self *Program) CVTSI2SD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTSI2SD", 2, Operands { v0, v1 })
    // CVTSI2SD r32, xmm
    if isReg32(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSI2SD r64, xmm
    if isReg64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x2a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSI2SD m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CVTSI2SD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTSI2SD")
    }
    return p
}

// CVTSI2SS performs "Convert Dword Integer to Scalar Single-Precision FP Value".
//
// Mnemonic        : CVTSI2SS
// Supported forms : (4 forms)
//
//    * CVTSI2SS r32, xmm    [SSE]
//    * CVTSI2SS r64, xmm    [SSE]
//    * CVTSI2SS m32, xmm    [SSE]
//    * CVTSI2SS m64, xmm    [SSE]
//
func (self *Program) CVTSI2SS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTSI2SS", 2, Operands { v0, v1 })
    // CVTSI2SS r32, xmm
    if isReg32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSI2SS r64, xmm
    if isReg64(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x2a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSI2SS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CVTSI2SS m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTSI2SS")
    }
    return p
}

// CVTSS2SD performs "Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value".
//
// Mnemonic        : CVTSS2SD
// Supported forms : (2 forms)
//
//    * CVTSS2SD xmm, xmm    [SSE2]
//    * CVTSS2SD m32, xmm    [SSE2]
//
func (self *Program) CVTSS2SD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTSS2SD", 2, Operands { v0, v1 })
    // CVTSS2SD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSS2SD m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTSS2SD")
    }
    return p
}

// CVTSS2SI performs "Convert Scalar Single-Precision FP Value to Dword Integer".
//
// Mnemonic        : CVTSS2SI
// Supported forms : (4 forms)
//
//    * CVTSS2SI xmm, r32    [SSE]
//    * CVTSS2SI m32, r32    [SSE]
//    * CVTSS2SI xmm, r64    [SSE]
//    * CVTSS2SI m32, r64    [SSE]
//
func (self *Program) CVTSS2SI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTSS2SI", 2, Operands { v0, v1 })
    // CVTSS2SI xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSS2SI m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CVTSS2SI xmm, r64
    if isXMM(v0) && isReg64(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x2d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTSS2SI m32, r64
    if isM32(v0) && isReg64(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x2d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTSS2SI")
    }
    return p
}

// CVTTPD2DQ performs "Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTTPD2DQ
// Supported forms : (2 forms)
//
//    * CVTTPD2DQ xmm, xmm     [SSE2]
//    * CVTTPD2DQ m128, xmm    [SSE2]
//
func (self *Program) CVTTPD2DQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTTPD2DQ", 2, Operands { v0, v1 })
    // CVTTPD2DQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTPD2DQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTTPD2DQ")
    }
    return p
}

// CVTTPD2PI performs "Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTTPD2PI
// Supported forms : (2 forms)
//
//    * CVTTPD2PI xmm, mm     [SSE2]
//    * CVTTPD2PI m128, mm    [SSE2]
//
func (self *Program) CVTTPD2PI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTTPD2PI", 2, Operands { v0, v1 })
    // CVTTPD2PI xmm, mm
    if isXMM(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTPD2PI m128, mm
    if isM128(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTTPD2PI")
    }
    return p
}

// CVTTPS2DQ performs "Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTTPS2DQ
// Supported forms : (2 forms)
//
//    * CVTTPS2DQ xmm, xmm     [SSE2]
//    * CVTTPS2DQ m128, xmm    [SSE2]
//
func (self *Program) CVTTPS2DQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTTPS2DQ", 2, Operands { v0, v1 })
    // CVTTPS2DQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTPS2DQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTTPS2DQ")
    }
    return p
}

// CVTTPS2PI performs "Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers".
//
// Mnemonic        : CVTTPS2PI
// Supported forms : (2 forms)
//
//    * CVTTPS2PI xmm, mm    [SSE]
//    * CVTTPS2PI m64, mm    [SSE]
//
func (self *Program) CVTTPS2PI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTTPS2PI", 2, Operands { v0, v1 })
    // CVTTPS2PI xmm, mm
    if isXMM(v0) && isMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTPS2PI m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTTPS2PI")
    }
    return p
}

// CVTTSD2SI performs "Convert with Truncation Scalar Double-Precision FP Value to Signed Integer".
//
// Mnemonic        : CVTTSD2SI
// Supported forms : (4 forms)
//
//    * CVTTSD2SI xmm, r32    [SSE2]
//    * CVTTSD2SI m64, r32    [SSE2]
//    * CVTTSD2SI xmm, r64    [SSE2]
//    * CVTTSD2SI m64, r64    [SSE2]
//
func (self *Program) CVTTSD2SI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTTSD2SI", 2, Operands { v0, v1 })
    // CVTTSD2SI xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTSD2SI m64, r32
    if isM64(v0) && isReg32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CVTTSD2SI xmm, r64
    if isXMM(v0) && isReg64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x2c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTSD2SI m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x2c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTTSD2SI")
    }
    return p
}

// CVTTSS2SI performs "Convert with Truncation Scalar Single-Precision FP Value to Dword Integer".
//
// Mnemonic        : CVTTSS2SI
// Supported forms : (4 forms)
//
//    * CVTTSS2SI xmm, r32    [SSE]
//    * CVTTSS2SI m32, r32    [SSE]
//    * CVTTSS2SI xmm, r64    [SSE]
//    * CVTTSS2SI m32, r64    [SSE]
//
func (self *Program) CVTTSS2SI(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("CVTTSS2SI", 2, Operands { v0, v1 })
    // CVTTSS2SI xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTSS2SI m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // CVTTSS2SI xmm, r64
    if isXMM(v0) && isReg64(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x2c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // CVTTSS2SI m32, r64
    if isM32(v0) && isReg64(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x2c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for CVTTSS2SI")
    }
    return p
}

// CWTD performs "Convert Word to Doubleword".
//
// Mnemonic        : CWD
// Supported forms : (1 form)
//
//    * CWTD
//
func (self *Program) CWTD() *Instruction {
    p := self.alloc("CWTD", 0, Operands {  })
    // CWTD
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x66)
        m.emit(0x99)
    })
    return p
}

// CWTL performs "Convert Word to Doubleword".
//
// Mnemonic        : CWDE
// Supported forms : (1 form)
//
//    * CWTL
//
func (self *Program) CWTL() *Instruction {
    p := self.alloc("CWTL", 0, Operands {  })
    // CWTL
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x98)
    })
    return p
}

// DECB performs "Decrement by 1".
//
// Mnemonic        : DEC
// Supported forms : (2 forms)
//
//    * DECB r8
//    * DECB m8
//
func (self *Program) DECB(v0 interface{}) *Instruction {
    p := self.alloc("DECB", 1, Operands { v0 })
    // DECB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xfe)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // DECB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xfe)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DECB")
    }
    return p
}

// DECL performs "Decrement by 1".
//
// Mnemonic        : DEC
// Supported forms : (2 forms)
//
//    * DECL r32
//    * DECL m32
//
func (self *Program) DECL(v0 interface{}) *Instruction {
    p := self.alloc("DECL", 1, Operands { v0 })
    // DECL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // DECL m32
    if isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DECL")
    }
    return p
}

// DECQ performs "Decrement by 1".
//
// Mnemonic        : DEC
// Supported forms : (2 forms)
//
//    * DECQ r64
//    * DECQ m64
//
func (self *Program) DECQ(v0 interface{}) *Instruction {
    p := self.alloc("DECQ", 1, Operands { v0 })
    // DECQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xff)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // DECQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xff)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DECQ")
    }
    return p
}

// DECW performs "Decrement by 1".
//
// Mnemonic        : DEC
// Supported forms : (2 forms)
//
//    * DECW r16
//    * DECW m16
//
func (self *Program) DECW(v0 interface{}) *Instruction {
    p := self.alloc("DECW", 1, Operands { v0 })
    // DECW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xc8 | lcode(v[0]))
        })
    }
    // DECW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DECW")
    }
    return p
}

// DIVB performs "Unsigned Divide".
//
// Mnemonic        : DIV
// Supported forms : (2 forms)
//
//    * DIVB r8
//    * DIVB m8
//
func (self *Program) DIVB(v0 interface{}) *Instruction {
    p := self.alloc("DIVB", 1, Operands { v0 })
    // DIVB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xf6)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // DIVB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf6)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVB")
    }
    return p
}

// DIVL performs "Unsigned Divide".
//
// Mnemonic        : DIV
// Supported forms : (2 forms)
//
//    * DIVL r32
//    * DIVL m32
//
func (self *Program) DIVL(v0 interface{}) *Instruction {
    p := self.alloc("DIVL", 1, Operands { v0 })
    // DIVL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // DIVL m32
    if isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVL")
    }
    return p
}

// DIVPD performs "Divide Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : DIVPD
// Supported forms : (2 forms)
//
//    * DIVPD xmm, xmm     [SSE2]
//    * DIVPD m128, xmm    [SSE2]
//
func (self *Program) DIVPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("DIVPD", 2, Operands { v0, v1 })
    // DIVPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // DIVPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVPD")
    }
    return p
}

// DIVPS performs "Divide Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : DIVPS
// Supported forms : (2 forms)
//
//    * DIVPS xmm, xmm     [SSE]
//    * DIVPS m128, xmm    [SSE]
//
func (self *Program) DIVPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("DIVPS", 2, Operands { v0, v1 })
    // DIVPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // DIVPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVPS")
    }
    return p
}

// DIVQ performs "Unsigned Divide".
//
// Mnemonic        : DIV
// Supported forms : (2 forms)
//
//    * DIVQ r64
//    * DIVQ m64
//
func (self *Program) DIVQ(v0 interface{}) *Instruction {
    p := self.alloc("DIVQ", 1, Operands { v0 })
    // DIVQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xf7)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // DIVQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xf7)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVQ")
    }
    return p
}

// DIVSD performs "Divide Scalar Double-Precision Floating-Point Values".
//
// Mnemonic        : DIVSD
// Supported forms : (2 forms)
//
//    * DIVSD xmm, xmm    [SSE2]
//    * DIVSD m64, xmm    [SSE2]
//
func (self *Program) DIVSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("DIVSD", 2, Operands { v0, v1 })
    // DIVSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // DIVSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVSD")
    }
    return p
}

// DIVSS performs "Divide Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : DIVSS
// Supported forms : (2 forms)
//
//    * DIVSS xmm, xmm    [SSE]
//    * DIVSS m32, xmm    [SSE]
//
func (self *Program) DIVSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("DIVSS", 2, Operands { v0, v1 })
    // DIVSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // DIVSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVSS")
    }
    return p
}

// DIVW performs "Unsigned Divide".
//
// Mnemonic        : DIV
// Supported forms : (2 forms)
//
//    * DIVW r16
//    * DIVW m16
//
func (self *Program) DIVW(v0 interface{}) *Instruction {
    p := self.alloc("DIVW", 1, Operands { v0 })
    // DIVW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // DIVW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for DIVW")
    }
    return p
}

// DPPD performs "Dot Product of Packed Double Precision Floating-Point Values".
//
// Mnemonic        : DPPD
// Supported forms : (2 forms)
//
//    * DPPD imm8, xmm, xmm     [SSE4.1]
//    * DPPD imm8, m128, xmm    [SSE4.1]
//
func (self *Program) DPPD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("DPPD", 3, Operands { v0, v1, v2 })
    // DPPD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // DPPD imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x41)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for DPPD")
    }
    return p
}

// DPPS performs "Dot Product of Packed Single Precision Floating-Point Values".
//
// Mnemonic        : DPPS
// Supported forms : (2 forms)
//
//    * DPPS imm8, xmm, xmm     [SSE4.1]
//    * DPPS imm8, m128, xmm    [SSE4.1]
//
func (self *Program) DPPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("DPPS", 3, Operands { v0, v1, v2 })
    // DPPS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x40)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // DPPS imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x40)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for DPPS")
    }
    return p
}

// EMMS performs "Exit MMX State".
//
// Mnemonic        : EMMS
// Supported forms : (1 form)
//
//    * EMMS    [MMX]
//
func (self *Program) EMMS() *Instruction {
    p := self.alloc("EMMS", 0, Operands {  })
    // EMMS
    self.require(ISA_MMX)
    p.domain = DomainMMXSSE
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x77)
    })
    return p
}

// EXTRACTPS performs "Extract Packed Single Precision Floating-Point Value".
//
// Mnemonic        : EXTRACTPS
// Supported forms : (2 forms)
//
//    * EXTRACTPS imm8, xmm, r32    [SSE4.1]
//    * EXTRACTPS imm8, xmm, m32    [SSE4.1]
//
func (self *Program) EXTRACTPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("EXTRACTPS", 3, Operands { v0, v1, v2 })
    // EXTRACTPS imm8, xmm, r32
    if isImm8(v0) && isXMM(v1) && isReg32(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x17)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // EXTRACTPS imm8, xmm, m32
    if isImm8(v0) && isXMM(v1) && isM32(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x17)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for EXTRACTPS")
    }
    return p
}

// EXTRQ performs "Extract Field".
//
// Mnemonic        : EXTRQ
// Supported forms : (2 forms)
//
//    * EXTRQ xmm, xmm           [SSE4A]
//    * EXTRQ imm8, imm8, xmm    [SSE4A]
//
func (self *Program) EXTRQ(v0 interface{}, v1 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("EXTRQ", 2, Operands { v0, v1 })
        case 1  : p = self.alloc("EXTRQ", 3, Operands { v0, v1, vv[0] })
        default : panic("instruction EXTRQ takes 2 or 3 operands")
    }
    // EXTRQ xmm, xmm
    if len(vv) == 0 && isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4A)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x79)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // EXTRQ imm8, imm8, xmm
    if len(vv) == 1 && isImm8(v0) && isImm8(v1) && isXMM(vv[0]) {
        self.require(ISA_SSE4A)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[2], false)
            m.emit(0x0f)
            m.emit(0x78)
            m.emit(0xc0 | lcode(v[2]))
            m.imm1(toImmAny(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for EXTRQ")
    }
    return p
}

// FEMMS performs "Fast Exit Multimedia State".
//
// Mnemonic        : FEMMS
// Supported forms : (1 form)
//
//    * FEMMS    [FEMMS]
//
func (self *Program) FEMMS() *Instruction {
    p := self.alloc("FEMMS", 0, Operands {  })
    // FEMMS
    self.require(ISA_FEMMS)
    p.domain = DomainAMDSpecific
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x0e)
    })
    return p
}

// HADDPD performs "Packed Double-FP Horizontal Add".
//
// Mnemonic        : HADDPD
// Supported forms : (2 forms)
//
//    * HADDPD xmm, xmm     [SSE3]
//    * HADDPD m128, xmm    [SSE3]
//
func (self *Program) HADDPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("HADDPD", 2, Operands { v0, v1 })
    // HADDPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x7c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // HADDPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x7c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for HADDPD")
    }
    return p
}

// HADDPS performs "Packed Single-FP Horizontal Add".
//
// Mnemonic        : HADDPS
// Supported forms : (2 forms)
//
//    * HADDPS xmm, xmm     [SSE3]
//    * HADDPS m128, xmm    [SSE3]
//
func (self *Program) HADDPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("HADDPS", 2, Operands { v0, v1 })
    // HADDPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x7c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // HADDPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x7c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for HADDPS")
    }
    return p
}

// HSUBPD performs "Packed Double-FP Horizontal Subtract".
//
// Mnemonic        : HSUBPD
// Supported forms : (2 forms)
//
//    * HSUBPD xmm, xmm     [SSE3]
//    * HSUBPD m128, xmm    [SSE3]
//
func (self *Program) HSUBPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("HSUBPD", 2, Operands { v0, v1 })
    // HSUBPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x7d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // HSUBPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x7d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for HSUBPD")
    }
    return p
}

// HSUBPS performs "Packed Single-FP Horizontal Subtract".
//
// Mnemonic        : HSUBPS
// Supported forms : (2 forms)
//
//    * HSUBPS xmm, xmm     [SSE3]
//    * HSUBPS m128, xmm    [SSE3]
//
func (self *Program) HSUBPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("HSUBPS", 2, Operands { v0, v1 })
    // HSUBPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x7d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // HSUBPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x7d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for HSUBPS")
    }
    return p
}

// IDIVB performs "Signed Divide".
//
// Mnemonic        : IDIV
// Supported forms : (2 forms)
//
//    * IDIVB r8
//    * IDIVB m8
//
func (self *Program) IDIVB(v0 interface{}) *Instruction {
    p := self.alloc("IDIVB", 1, Operands { v0 })
    // IDIVB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xf6)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // IDIVB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf6)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for IDIVB")
    }
    return p
}

// IDIVL performs "Signed Divide".
//
// Mnemonic        : IDIV
// Supported forms : (2 forms)
//
//    * IDIVL r32
//    * IDIVL m32
//
func (self *Program) IDIVL(v0 interface{}) *Instruction {
    p := self.alloc("IDIVL", 1, Operands { v0 })
    // IDIVL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // IDIVL m32
    if isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for IDIVL")
    }
    return p
}

// IDIVQ performs "Signed Divide".
//
// Mnemonic        : IDIV
// Supported forms : (2 forms)
//
//    * IDIVQ r64
//    * IDIVQ m64
//
func (self *Program) IDIVQ(v0 interface{}) *Instruction {
    p := self.alloc("IDIVQ", 1, Operands { v0 })
    // IDIVQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xf7)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // IDIVQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xf7)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for IDIVQ")
    }
    return p
}

// IDIVW performs "Signed Divide".
//
// Mnemonic        : IDIV
// Supported forms : (2 forms)
//
//    * IDIVW r16
//    * IDIVW m16
//
func (self *Program) IDIVW(v0 interface{}) *Instruction {
    p := self.alloc("IDIVW", 1, Operands { v0 })
    // IDIVW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // IDIVW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for IDIVW")
    }
    return p
}

// IMULB performs "Signed Multiply".
//
// Mnemonic        : IMUL
// Supported forms : (2 forms)
//
//    * IMULB r8
//    * IMULB m8
//
func (self *Program) IMULB(v0 interface{}) *Instruction {
    p := self.alloc("IMULB", 1, Operands { v0 })
    // IMULB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xf6)
            m.emit(0xe8 | lcode(v[0]))
        })
    }
    // IMULB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf6)
            m.mrsd(5, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for IMULB")
    }
    return p
}

// IMULL performs "Signed Multiply".
//
// Mnemonic        : IMUL
// Supported forms : (8 forms)
//
//    * IMULL r32
//    * IMULL m32
//    * IMULL r32, r32
//    * IMULL m32, r32
//    * IMULL imm8, r32, r32
//    * IMULL imm32, r32, r32
//    * IMULL imm8, m32, r32
//    * IMULL imm32, m32, r32
//
func (self *Program) IMULL(v0 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("IMULL", 1, Operands { v0 })
        case 1  : p = self.alloc("IMULL", 2, Operands { v0, vv[0] })
        case 2  : p = self.alloc("IMULL", 3, Operands { v0, vv[0], vv[1] })
        default : panic("instruction IMULL takes 1 or 2 or 3 operands")
    }
    // IMULL r32
    if len(vv) == 0 && isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xe8 | lcode(v[0]))
        })
    }
    // IMULL m32
    if len(vv) == 0 && isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(5, addr(v[0]), 1)
        })
    }
    // IMULL r32, r32
    if len(vv) == 1 && isReg32(v0) && isReg32(vv[0]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xaf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // IMULL m32, r32
    if len(vv) == 1 && isM32(v0) && isReg32(vv[0]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xaf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // IMULL imm8, r32, r32
    if len(vv) == 2 && isImm8(v0) && isReg32(vv[0]) && isReg32(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x6b)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // IMULL imm32, r32, r32
    if len(vv) == 2 && isImm32(v0) && isReg32(vv[0]) && isReg32(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x69)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // IMULL imm8, m32, r32
    if len(vv) == 2 && isImm8(v0) && isM32(vv[0]) && isReg32(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x6b)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // IMULL imm32, m32, r32
    if len(vv) == 2 && isImm32(v0) && isM32(vv[0]) && isReg32(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x69)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for IMULL")
    }
    return p
}

// IMULQ performs "Signed Multiply".
//
// Mnemonic        : IMUL
// Supported forms : (8 forms)
//
//    * IMULQ r64
//    * IMULQ m64
//    * IMULQ r64, r64
//    * IMULQ m64, r64
//    * IMULQ imm8, r64, r64
//    * IMULQ imm32, r64, r64
//    * IMULQ imm8, m64, r64
//    * IMULQ imm32, m64, r64
//
func (self *Program) IMULQ(v0 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("IMULQ", 1, Operands { v0 })
        case 1  : p = self.alloc("IMULQ", 2, Operands { v0, vv[0] })
        case 2  : p = self.alloc("IMULQ", 3, Operands { v0, vv[0], vv[1] })
        default : panic("instruction IMULQ takes 1 or 2 or 3 operands")
    }
    // IMULQ r64
    if len(vv) == 0 && isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xf7)
            m.emit(0xe8 | lcode(v[0]))
        })
    }
    // IMULQ m64
    if len(vv) == 0 && isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xf7)
            m.mrsd(5, addr(v[0]), 1)
        })
    }
    // IMULQ r64, r64
    if len(vv) == 1 && isReg64(v0) && isReg64(vv[0]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xaf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // IMULQ m64, r64
    if len(vv) == 1 && isM64(v0) && isReg64(vv[0]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xaf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // IMULQ imm8, r64, r64
    if len(vv) == 2 && isImm8(v0) && isReg64(vv[0]) && isReg64(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[2]) << 2 | hcode(v[1]))
            m.emit(0x6b)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // IMULQ imm32, r64, r64
    if len(vv) == 2 && isImm32(v0) && isReg64(vv[0]) && isReg64(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[2]) << 2 | hcode(v[1]))
            m.emit(0x69)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // IMULQ imm8, m64, r64
    if len(vv) == 2 && isImm8(v0) && isM64(vv[0]) && isReg64(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[2]), addr(v[1]))
            m.emit(0x6b)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // IMULQ imm32, m64, r64
    if len(vv) == 2 && isImm32(v0) && isM64(vv[0]) && isReg64(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[2]), addr(v[1]))
            m.emit(0x69)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for IMULQ")
    }
    return p
}

// IMULW performs "Signed Multiply".
//
// Mnemonic        : IMUL
// Supported forms : (8 forms)
//
//    * IMULW r16
//    * IMULW m16
//    * IMULW r16, r16
//    * IMULW m16, r16
//    * IMULW imm8, r16, r16
//    * IMULW imm16, r16, r16
//    * IMULW imm8, m16, r16
//    * IMULW imm16, m16, r16
//
func (self *Program) IMULW(v0 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("IMULW", 1, Operands { v0 })
        case 1  : p = self.alloc("IMULW", 2, Operands { v0, vv[0] })
        case 2  : p = self.alloc("IMULW", 3, Operands { v0, vv[0], vv[1] })
        default : panic("instruction IMULW takes 1 or 2 or 3 operands")
    }
    // IMULW r16
    if len(vv) == 0 && isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xe8 | lcode(v[0]))
        })
    }
    // IMULW m16
    if len(vv) == 0 && isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(5, addr(v[0]), 1)
        })
    }
    // IMULW r16, r16
    if len(vv) == 1 && isReg16(v0) && isReg16(vv[0]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xaf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // IMULW m16, r16
    if len(vv) == 1 && isM16(v0) && isReg16(vv[0]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xaf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // IMULW imm8, r16, r16
    if len(vv) == 2 && isImm8(v0) && isReg16(vv[0]) && isReg16(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x6b)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // IMULW imm16, r16, r16
    if len(vv) == 2 && isImm16(v0) && isReg16(vv[0]) && isReg16(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x69)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // IMULW imm8, m16, r16
    if len(vv) == 2 && isImm8(v0) && isM16(vv[0]) && isReg16(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x6b)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // IMULW imm16, m16, r16
    if len(vv) == 2 && isImm16(v0) && isM16(vv[0]) && isReg16(vv[1]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x69)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for IMULW")
    }
    return p
}

// INCB performs "Increment by 1".
//
// Mnemonic        : INC
// Supported forms : (2 forms)
//
//    * INCB r8
//    * INCB m8
//
func (self *Program) INCB(v0 interface{}) *Instruction {
    p := self.alloc("INCB", 1, Operands { v0 })
    // INCB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xfe)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // INCB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xfe)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for INCB")
    }
    return p
}

// INCL performs "Increment by 1".
//
// Mnemonic        : INC
// Supported forms : (2 forms)
//
//    * INCL r32
//    * INCL m32
//
func (self *Program) INCL(v0 interface{}) *Instruction {
    p := self.alloc("INCL", 1, Operands { v0 })
    // INCL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // INCL m32
    if isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for INCL")
    }
    return p
}

// INCQ performs "Increment by 1".
//
// Mnemonic        : INC
// Supported forms : (2 forms)
//
//    * INCQ r64
//    * INCQ m64
//
func (self *Program) INCQ(v0 interface{}) *Instruction {
    p := self.alloc("INCQ", 1, Operands { v0 })
    // INCQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xff)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // INCQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xff)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for INCQ")
    }
    return p
}

// INCW performs "Increment by 1".
//
// Mnemonic        : INC
// Supported forms : (2 forms)
//
//    * INCW r16
//    * INCW m16
//
func (self *Program) INCW(v0 interface{}) *Instruction {
    p := self.alloc("INCW", 1, Operands { v0 })
    // INCW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // INCW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for INCW")
    }
    return p
}

// INSERTPS performs "Insert Packed Single Precision Floating-Point Value".
//
// Mnemonic        : INSERTPS
// Supported forms : (2 forms)
//
//    * INSERTPS imm8, xmm, xmm    [SSE4.1]
//    * INSERTPS imm8, m32, xmm    [SSE4.1]
//
func (self *Program) INSERTPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("INSERTPS", 3, Operands { v0, v1, v2 })
    // INSERTPS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x21)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // INSERTPS imm8, m32, xmm
    if isImm8(v0) && isM32(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x21)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for INSERTPS")
    }
    return p
}

// INSERTQ performs "Insert Field".
//
// Mnemonic        : INSERTQ
// Supported forms : (2 forms)
//
//    * INSERTQ xmm, xmm                [SSE4A]
//    * INSERTQ imm8, imm8, xmm, xmm    [SSE4A]
//
func (self *Program) INSERTQ(v0 interface{}, v1 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("INSERTQ", 2, Operands { v0, v1 })
        case 2  : p = self.alloc("INSERTQ", 4, Operands { v0, v1, vv[0], vv[1] })
        default : panic("instruction INSERTQ takes 2 or 4 operands")
    }
    // INSERTQ xmm, xmm
    if len(vv) == 0 && isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4A)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x79)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // INSERTQ imm8, imm8, xmm, xmm
    if len(vv) == 2 && isImm8(v0) && isImm8(v1) && isXMM(vv[0]) && isXMM(vv[1]) {
        self.require(ISA_SSE4A)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[3]), v[2], false)
            m.emit(0x0f)
            m.emit(0x78)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for INSERTQ")
    }
    return p
}

// INT performs "Call to Interrupt Procedure".
//
// Mnemonic        : INT
// Supported forms : (2 forms)
//
//    * INT 3
//    * INT imm8
//
func (self *Program) INT(v0 interface{}) *Instruction {
    p := self.alloc("INT", 1, Operands { v0 })
    // INT 3
    if isConst3(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xcc)
        })
    }
    // INT imm8
    if isImm8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xcd)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for INT")
    }
    return p
}

// JA performs "Jump if above (CF == 0 and ZF == 0)".
//
// Mnemonic        : JA
// Supported forms : (2 forms)
//
//    * JA rel8
//    * JA rel32
//
func (self *Program) JA(v0 interface{}) *Instruction {
    p := self.alloc("JA", 1, Operands { v0 })
    p.branch = _B_conditional
    // JA rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x77)
            m.imm1(relv(v[0]))
        })
    }
    // JA rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x87)
            m.imm4(relv(v[0]))
        })
    }
    // JA label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x77)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x87)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JA")
    }
    return p
}

// JAE performs "Jump if above or equal (CF == 0)".
//
// Mnemonic        : JAE
// Supported forms : (2 forms)
//
//    * JAE rel8
//    * JAE rel32
//
func (self *Program) JAE(v0 interface{}) *Instruction {
    p := self.alloc("JAE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JAE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x73)
            m.imm1(relv(v[0]))
        })
    }
    // JAE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x83)
            m.imm4(relv(v[0]))
        })
    }
    // JAE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x73)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x83)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JAE")
    }
    return p
}

// JB performs "Jump if below (CF == 1)".
//
// Mnemonic        : JB
// Supported forms : (2 forms)
//
//    * JB rel8
//    * JB rel32
//
func (self *Program) JB(v0 interface{}) *Instruction {
    p := self.alloc("JB", 1, Operands { v0 })
    p.branch = _B_conditional
    // JB rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x72)
            m.imm1(relv(v[0]))
        })
    }
    // JB rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x82)
            m.imm4(relv(v[0]))
        })
    }
    // JB label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x72)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x82)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JB")
    }
    return p
}

// JBE performs "Jump if below or equal (CF == 1 or ZF == 1)".
//
// Mnemonic        : JBE
// Supported forms : (2 forms)
//
//    * JBE rel8
//    * JBE rel32
//
func (self *Program) JBE(v0 interface{}) *Instruction {
    p := self.alloc("JBE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JBE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x76)
            m.imm1(relv(v[0]))
        })
    }
    // JBE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x86)
            m.imm4(relv(v[0]))
        })
    }
    // JBE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x76)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x86)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JBE")
    }
    return p
}

// JC performs "Jump if carry (CF == 1)".
//
// Mnemonic        : JC
// Supported forms : (2 forms)
//
//    * JC rel8
//    * JC rel32
//
func (self *Program) JC(v0 interface{}) *Instruction {
    p := self.alloc("JC", 1, Operands { v0 })
    p.branch = _B_conditional
    // JC rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x72)
            m.imm1(relv(v[0]))
        })
    }
    // JC rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x82)
            m.imm4(relv(v[0]))
        })
    }
    // JC label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x72)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x82)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JC")
    }
    return p
}

// JE performs "Jump if equal (ZF == 1)".
//
// Mnemonic        : JE
// Supported forms : (2 forms)
//
//    * JE rel8
//    * JE rel32
//
func (self *Program) JE(v0 interface{}) *Instruction {
    p := self.alloc("JE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x74)
            m.imm1(relv(v[0]))
        })
    }
    // JE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x84)
            m.imm4(relv(v[0]))
        })
    }
    // JE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x74)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x84)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JE")
    }
    return p
}

// JECXZ performs "Jump if ECX register is 0".
//
// Mnemonic        : JECXZ
// Supported forms : (1 form)
//
//    * JECXZ rel8
//
func (self *Program) JECXZ(v0 interface{}) *Instruction {
    p := self.alloc("JECXZ", 1, Operands { v0 })
    p.branch = _B_conditional
    // JECXZ rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xe3)
            m.imm1(relv(v[0]))
        })
    }
    // JECXZ label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0xe3)
            m.imm1(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JECXZ")
    }
    return p
}

// JG performs "Jump if greater (ZF == 0 and SF == OF)".
//
// Mnemonic        : JG
// Supported forms : (2 forms)
//
//    * JG rel8
//    * JG rel32
//
func (self *Program) JG(v0 interface{}) *Instruction {
    p := self.alloc("JG", 1, Operands { v0 })
    p.branch = _B_conditional
    // JG rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7f)
            m.imm1(relv(v[0]))
        })
    }
    // JG rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8f)
            m.imm4(relv(v[0]))
        })
    }
    // JG label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7f)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8f)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JG")
    }
    return p
}

// JGE performs "Jump if greater or equal (SF == OF)".
//
// Mnemonic        : JGE
// Supported forms : (2 forms)
//
//    * JGE rel8
//    * JGE rel32
//
func (self *Program) JGE(v0 interface{}) *Instruction {
    p := self.alloc("JGE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JGE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7d)
            m.imm1(relv(v[0]))
        })
    }
    // JGE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8d)
            m.imm4(relv(v[0]))
        })
    }
    // JGE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7d)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8d)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JGE")
    }
    return p
}

// JL performs "Jump if less (SF != OF)".
//
// Mnemonic        : JL
// Supported forms : (2 forms)
//
//    * JL rel8
//    * JL rel32
//
func (self *Program) JL(v0 interface{}) *Instruction {
    p := self.alloc("JL", 1, Operands { v0 })
    p.branch = _B_conditional
    // JL rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7c)
            m.imm1(relv(v[0]))
        })
    }
    // JL rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8c)
            m.imm4(relv(v[0]))
        })
    }
    // JL label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7c)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8c)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JL")
    }
    return p
}

// JLE performs "Jump if less or equal (ZF == 1 or SF != OF)".
//
// Mnemonic        : JLE
// Supported forms : (2 forms)
//
//    * JLE rel8
//    * JLE rel32
//
func (self *Program) JLE(v0 interface{}) *Instruction {
    p := self.alloc("JLE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JLE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7e)
            m.imm1(relv(v[0]))
        })
    }
    // JLE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8e)
            m.imm4(relv(v[0]))
        })
    }
    // JLE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7e)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8e)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JLE")
    }
    return p
}

// JMP performs "Jump Unconditionally".
//
// Mnemonic        : JMP
// Supported forms : (2 forms)
//
//    * JMP rel8
//    * JMP rel32
//
func (self *Program) JMP(v0 interface{}) *Instruction {
    p := self.alloc("JMP", 1, Operands { v0 })
    p.branch = _B_unconditional
    // JMP rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xeb)
            m.imm1(relv(v[0]))
        })
    }
    // JMP rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xe9)
            m.imm4(relv(v[0]))
        })
    }
    // JMP label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0xeb)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0xe9)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JMP")
    }
    return p
}

// JMPQ performs "Jump Unconditionally".
//
// Mnemonic        : JMP
// Supported forms : (2 forms)
//
//    * JMPQ r64
//    * JMPQ m64
//
func (self *Program) JMPQ(v0 interface{}) *Instruction {
    p := self.alloc("JMPQ", 1, Operands { v0 })
    // JMPQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xe0 | lcode(v[0]))
        })
    }
    // JMPQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(4, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for JMPQ")
    }
    return p
}

// JNA performs "Jump if not above (CF == 1 or ZF == 1)".
//
// Mnemonic        : JNA
// Supported forms : (2 forms)
//
//    * JNA rel8
//    * JNA rel32
//
func (self *Program) JNA(v0 interface{}) *Instruction {
    p := self.alloc("JNA", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNA rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x76)
            m.imm1(relv(v[0]))
        })
    }
    // JNA rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x86)
            m.imm4(relv(v[0]))
        })
    }
    // JNA label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x76)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x86)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNA")
    }
    return p
}

// JNAE performs "Jump if not above or equal (CF == 1)".
//
// Mnemonic        : JNAE
// Supported forms : (2 forms)
//
//    * JNAE rel8
//    * JNAE rel32
//
func (self *Program) JNAE(v0 interface{}) *Instruction {
    p := self.alloc("JNAE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNAE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x72)
            m.imm1(relv(v[0]))
        })
    }
    // JNAE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x82)
            m.imm4(relv(v[0]))
        })
    }
    // JNAE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x72)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x82)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNAE")
    }
    return p
}

// JNB performs "Jump if not below (CF == 0)".
//
// Mnemonic        : JNB
// Supported forms : (2 forms)
//
//    * JNB rel8
//    * JNB rel32
//
func (self *Program) JNB(v0 interface{}) *Instruction {
    p := self.alloc("JNB", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNB rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x73)
            m.imm1(relv(v[0]))
        })
    }
    // JNB rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x83)
            m.imm4(relv(v[0]))
        })
    }
    // JNB label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x73)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x83)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNB")
    }
    return p
}

// JNBE performs "Jump if not below or equal (CF == 0 and ZF == 0)".
//
// Mnemonic        : JNBE
// Supported forms : (2 forms)
//
//    * JNBE rel8
//    * JNBE rel32
//
func (self *Program) JNBE(v0 interface{}) *Instruction {
    p := self.alloc("JNBE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNBE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x77)
            m.imm1(relv(v[0]))
        })
    }
    // JNBE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x87)
            m.imm4(relv(v[0]))
        })
    }
    // JNBE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x77)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x87)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNBE")
    }
    return p
}

// JNC performs "Jump if not carry (CF == 0)".
//
// Mnemonic        : JNC
// Supported forms : (2 forms)
//
//    * JNC rel8
//    * JNC rel32
//
func (self *Program) JNC(v0 interface{}) *Instruction {
    p := self.alloc("JNC", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNC rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x73)
            m.imm1(relv(v[0]))
        })
    }
    // JNC rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x83)
            m.imm4(relv(v[0]))
        })
    }
    // JNC label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x73)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x83)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNC")
    }
    return p
}

// JNE performs "Jump if not equal (ZF == 0)".
//
// Mnemonic        : JNE
// Supported forms : (2 forms)
//
//    * JNE rel8
//    * JNE rel32
//
func (self *Program) JNE(v0 interface{}) *Instruction {
    p := self.alloc("JNE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x75)
            m.imm1(relv(v[0]))
        })
    }
    // JNE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x85)
            m.imm4(relv(v[0]))
        })
    }
    // JNE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x75)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x85)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNE")
    }
    return p
}

// JNG performs "Jump if not greater (ZF == 1 or SF != OF)".
//
// Mnemonic        : JNG
// Supported forms : (2 forms)
//
//    * JNG rel8
//    * JNG rel32
//
func (self *Program) JNG(v0 interface{}) *Instruction {
    p := self.alloc("JNG", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNG rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7e)
            m.imm1(relv(v[0]))
        })
    }
    // JNG rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8e)
            m.imm4(relv(v[0]))
        })
    }
    // JNG label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7e)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8e)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNG")
    }
    return p
}

// JNGE performs "Jump if not greater or equal (SF != OF)".
//
// Mnemonic        : JNGE
// Supported forms : (2 forms)
//
//    * JNGE rel8
//    * JNGE rel32
//
func (self *Program) JNGE(v0 interface{}) *Instruction {
    p := self.alloc("JNGE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNGE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7c)
            m.imm1(relv(v[0]))
        })
    }
    // JNGE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8c)
            m.imm4(relv(v[0]))
        })
    }
    // JNGE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7c)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8c)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNGE")
    }
    return p
}

// JNL performs "Jump if not less (SF == OF)".
//
// Mnemonic        : JNL
// Supported forms : (2 forms)
//
//    * JNL rel8
//    * JNL rel32
//
func (self *Program) JNL(v0 interface{}) *Instruction {
    p := self.alloc("JNL", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNL rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7d)
            m.imm1(relv(v[0]))
        })
    }
    // JNL rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8d)
            m.imm4(relv(v[0]))
        })
    }
    // JNL label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7d)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8d)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNL")
    }
    return p
}

// JNLE performs "Jump if not less or equal (ZF == 0 and SF == OF)".
//
// Mnemonic        : JNLE
// Supported forms : (2 forms)
//
//    * JNLE rel8
//    * JNLE rel32
//
func (self *Program) JNLE(v0 interface{}) *Instruction {
    p := self.alloc("JNLE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNLE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7f)
            m.imm1(relv(v[0]))
        })
    }
    // JNLE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8f)
            m.imm4(relv(v[0]))
        })
    }
    // JNLE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7f)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8f)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNLE")
    }
    return p
}

// JNO performs "Jump if not overflow (OF == 0)".
//
// Mnemonic        : JNO
// Supported forms : (2 forms)
//
//    * JNO rel8
//    * JNO rel32
//
func (self *Program) JNO(v0 interface{}) *Instruction {
    p := self.alloc("JNO", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNO rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x71)
            m.imm1(relv(v[0]))
        })
    }
    // JNO rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x81)
            m.imm4(relv(v[0]))
        })
    }
    // JNO label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x71)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x81)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNO")
    }
    return p
}

// JNP performs "Jump if not parity (PF == 0)".
//
// Mnemonic        : JNP
// Supported forms : (2 forms)
//
//    * JNP rel8
//    * JNP rel32
//
func (self *Program) JNP(v0 interface{}) *Instruction {
    p := self.alloc("JNP", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNP rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7b)
            m.imm1(relv(v[0]))
        })
    }
    // JNP rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8b)
            m.imm4(relv(v[0]))
        })
    }
    // JNP label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7b)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8b)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNP")
    }
    return p
}

// JNS performs "Jump if not sign (SF == 0)".
//
// Mnemonic        : JNS
// Supported forms : (2 forms)
//
//    * JNS rel8
//    * JNS rel32
//
func (self *Program) JNS(v0 interface{}) *Instruction {
    p := self.alloc("JNS", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNS rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x79)
            m.imm1(relv(v[0]))
        })
    }
    // JNS rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x89)
            m.imm4(relv(v[0]))
        })
    }
    // JNS label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x79)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x89)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNS")
    }
    return p
}

// JNZ performs "Jump if not zero (ZF == 0)".
//
// Mnemonic        : JNZ
// Supported forms : (2 forms)
//
//    * JNZ rel8
//    * JNZ rel32
//
func (self *Program) JNZ(v0 interface{}) *Instruction {
    p := self.alloc("JNZ", 1, Operands { v0 })
    p.branch = _B_conditional
    // JNZ rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x75)
            m.imm1(relv(v[0]))
        })
    }
    // JNZ rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x85)
            m.imm4(relv(v[0]))
        })
    }
    // JNZ label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x75)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x85)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JNZ")
    }
    return p
}

// JO performs "Jump if overflow (OF == 1)".
//
// Mnemonic        : JO
// Supported forms : (2 forms)
//
//    * JO rel8
//    * JO rel32
//
func (self *Program) JO(v0 interface{}) *Instruction {
    p := self.alloc("JO", 1, Operands { v0 })
    p.branch = _B_conditional
    // JO rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x70)
            m.imm1(relv(v[0]))
        })
    }
    // JO rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x80)
            m.imm4(relv(v[0]))
        })
    }
    // JO label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x70)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x80)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JO")
    }
    return p
}

// JP performs "Jump if parity (PF == 1)".
//
// Mnemonic        : JP
// Supported forms : (2 forms)
//
//    * JP rel8
//    * JP rel32
//
func (self *Program) JP(v0 interface{}) *Instruction {
    p := self.alloc("JP", 1, Operands { v0 })
    p.branch = _B_conditional
    // JP rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7a)
            m.imm1(relv(v[0]))
        })
    }
    // JP rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8a)
            m.imm4(relv(v[0]))
        })
    }
    // JP label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7a)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8a)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JP")
    }
    return p
}

// JPE performs "Jump if parity even (PF == 1)".
//
// Mnemonic        : JPE
// Supported forms : (2 forms)
//
//    * JPE rel8
//    * JPE rel32
//
func (self *Program) JPE(v0 interface{}) *Instruction {
    p := self.alloc("JPE", 1, Operands { v0 })
    p.branch = _B_conditional
    // JPE rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7a)
            m.imm1(relv(v[0]))
        })
    }
    // JPE rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8a)
            m.imm4(relv(v[0]))
        })
    }
    // JPE label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7a)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8a)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JPE")
    }
    return p
}

// JPO performs "Jump if parity odd (PF == 0)".
//
// Mnemonic        : JPO
// Supported forms : (2 forms)
//
//    * JPO rel8
//    * JPO rel32
//
func (self *Program) JPO(v0 interface{}) *Instruction {
    p := self.alloc("JPO", 1, Operands { v0 })
    p.branch = _B_conditional
    // JPO rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x7b)
            m.imm1(relv(v[0]))
        })
    }
    // JPO rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8b)
            m.imm4(relv(v[0]))
        })
    }
    // JPO label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x7b)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x8b)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JPO")
    }
    return p
}

// JRCXZ performs "Jump if RCX register is 0".
//
// Mnemonic        : JRCXZ
// Supported forms : (1 form)
//
//    * JRCXZ rel8
//
func (self *Program) JRCXZ(v0 interface{}) *Instruction {
    p := self.alloc("JRCXZ", 1, Operands { v0 })
    p.branch = _B_conditional
    // JRCXZ rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xe3)
            m.imm1(relv(v[0]))
        })
    }
    // JRCXZ label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0xe3)
            m.imm1(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JRCXZ")
    }
    return p
}

// JS performs "Jump if sign (SF == 1)".
//
// Mnemonic        : JS
// Supported forms : (2 forms)
//
//    * JS rel8
//    * JS rel32
//
func (self *Program) JS(v0 interface{}) *Instruction {
    p := self.alloc("JS", 1, Operands { v0 })
    p.branch = _B_conditional
    // JS rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x78)
            m.imm1(relv(v[0]))
        })
    }
    // JS rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x88)
            m.imm4(relv(v[0]))
        })
    }
    // JS label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x78)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x88)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JS")
    }
    return p
}

// JZ performs "Jump if zero (ZF == 1)".
//
// Mnemonic        : JZ
// Supported forms : (2 forms)
//
//    * JZ rel8
//    * JZ rel32
//
func (self *Program) JZ(v0 interface{}) *Instruction {
    p := self.alloc("JZ", 1, Operands { v0 })
    p.branch = _B_conditional
    // JZ rel8
    if isRel8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x74)
            m.imm1(relv(v[0]))
        })
    }
    // JZ rel32
    if isRel32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x84)
            m.imm4(relv(v[0]))
        })
    }
    // JZ label
    if isLabel(v0) {
        p.add(_F_rel1, func(m *_Encoding, v []interface{}) {
            m.emit(0x74)
            m.imm1(relv(v[0]))
        })
        p.add(_F_rel4, func(m *_Encoding, v []interface{}) {
            m.emit(0x0f)
            m.emit(0x84)
            m.imm4(relv(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for JZ")
    }
    return p
}

// KADDB performs "ADD Two 8-bit Masks".
//
// Mnemonic        : KADDB
// Supported forms : (1 form)
//
//    * KADDB k, k, k    [AVX512DQ]
//
func (self *Program) KADDB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KADDB", 3, Operands { v0, v1, v2 })
    // KADDB k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, 0, nil, hlcode(v[1]))
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KADDB")
    }
    return p
}

// KADDD performs "ADD Two 32-bit Masks".
//
// Mnemonic        : KADDD
// Supported forms : (1 form)
//
//    * KADDD k, k, k    [AVX512BW]
//
func (self *Program) KADDD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KADDD", 3, Operands { v0, v1, v2 })
    // KADDD k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KADDD")
    }
    return p
}

// KADDQ performs "ADD Two 64-bit Masks".
//
// Mnemonic        : KADDQ
// Supported forms : (1 form)
//
//    * KADDQ k, k, k    [AVX512BW]
//
func (self *Program) KADDQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KADDQ", 3, Operands { v0, v1, v2 })
    // KADDQ k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfc ^ (hlcode(v[1]) << 3))
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KADDQ")
    }
    return p
}

// KADDW performs "ADD Two 16-bit Masks".
//
// Mnemonic        : KADDW
// Supported forms : (1 form)
//
//    * KADDW k, k, k    [AVX512DQ]
//
func (self *Program) KADDW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KADDW", 3, Operands { v0, v1, v2 })
    // KADDW k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, 0, nil, hlcode(v[1]))
            m.emit(0x4a)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KADDW")
    }
    return p
}

// KANDB performs "Bitwise Logical AND 8-bit Masks".
//
// Mnemonic        : KANDB
// Supported forms : (1 form)
//
//    * KANDB k, k, k    [AVX512DQ]
//
func (self *Program) KANDB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDB", 3, Operands { v0, v1, v2 })
    // KANDB k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, 0, nil, hlcode(v[1]))
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDB")
    }
    return p
}

// KANDD performs "Bitwise Logical AND 32-bit Masks".
//
// Mnemonic        : KANDD
// Supported forms : (1 form)
//
//    * KANDD k, k, k    [AVX512BW]
//
func (self *Program) KANDD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDD", 3, Operands { v0, v1, v2 })
    // KANDD k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDD")
    }
    return p
}

// KANDNB performs "Bitwise Logical AND NOT 8-bit Masks".
//
// Mnemonic        : KANDNB
// Supported forms : (1 form)
//
//    * KANDNB k, k, k    [AVX512DQ]
//
func (self *Program) KANDNB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDNB", 3, Operands { v0, v1, v2 })
    // KANDNB k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, 0, nil, hlcode(v[1]))
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDNB")
    }
    return p
}

// KANDND performs "Bitwise Logical AND NOT 32-bit Masks".
//
// Mnemonic        : KANDND
// Supported forms : (1 form)
//
//    * KANDND k, k, k    [AVX512BW]
//
func (self *Program) KANDND(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDND", 3, Operands { v0, v1, v2 })
    // KANDND k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDND")
    }
    return p
}

// KANDNQ performs "Bitwise Logical AND NOT 64-bit Masks".
//
// Mnemonic        : KANDNQ
// Supported forms : (1 form)
//
//    * KANDNQ k, k, k    [AVX512BW]
//
func (self *Program) KANDNQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDNQ", 3, Operands { v0, v1, v2 })
    // KANDNQ k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfc ^ (hlcode(v[1]) << 3))
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDNQ")
    }
    return p
}

// KANDNW performs "Bitwise Logical AND NOT 16-bit Masks".
//
// Mnemonic        : KANDNW
// Supported forms : (1 form)
//
//    * KANDNW k, k, k    [AVX512F]
//
func (self *Program) KANDNW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDNW", 3, Operands { v0, v1, v2 })
    // KANDNW k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, 0, nil, hlcode(v[1]))
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDNW")
    }
    return p
}

// KANDQ performs "Bitwise Logical AND 64-bit Masks".
//
// Mnemonic        : KANDQ
// Supported forms : (1 form)
//
//    * KANDQ k, k, k    [AVX512BW]
//
func (self *Program) KANDQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDQ", 3, Operands { v0, v1, v2 })
    // KANDQ k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfc ^ (hlcode(v[1]) << 3))
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDQ")
    }
    return p
}

// KANDW performs "Bitwise Logical AND 16-bit Masks".
//
// Mnemonic        : KANDW
// Supported forms : (1 form)
//
//    * KANDW k, k, k    [AVX512F]
//
func (self *Program) KANDW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KANDW", 3, Operands { v0, v1, v2 })
    // KANDW k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, 0, nil, hlcode(v[1]))
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KANDW")
    }
    return p
}

// KMOVB performs "Move 8-bit Mask".
//
// Mnemonic        : KMOVB
// Supported forms : (5 forms)
//
//    * KMOVB k, k      [AVX512DQ]
//    * KMOVB r32, k    [AVX512DQ]
//    * KMOVB m8, k     [AVX512DQ]
//    * KMOVB k, r32    [AVX512DQ]
//    * KMOVB k, m8     [AVX512DQ]
//
func (self *Program) KMOVB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KMOVB", 2, Operands { v0, v1 })
    // KMOVB k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, 0, nil, 0)
            m.emit(0x90)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVB r32, k
    if isReg32(v0) && isK(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, 0, v[0], 0)
            m.emit(0x92)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVB m8, k
    if isM8(v0) && isK(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, 0, addr(v[0]), 0)
            m.emit(0x90)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // KMOVB k, r32
    if isK(v0) && isReg32(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, hcode(v[1]), nil, 0)
            m.emit(0x93)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVB k, m8
    if isK(v0) && isM8(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, 0, addr(v[1]), 0)
            m.emit(0x91)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for KMOVB")
    }
    return p
}

// KMOVD performs "Move 32-bit Mask".
//
// Mnemonic        : KMOVD
// Supported forms : (5 forms)
//
//    * KMOVD k, k      [AVX512BW]
//    * KMOVD r32, k    [AVX512BW]
//    * KMOVD m32, k    [AVX512BW]
//    * KMOVD k, r32    [AVX512BW]
//    * KMOVD k, m32    [AVX512BW]
//
func (self *Program) KMOVD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KMOVD", 2, Operands { v0, v1 })
    // KMOVD k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf9)
            m.emit(0x90)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVD r32, k
    if isReg32(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(3, 0, v[0], 0)
            m.emit(0x92)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVD m32, k
    if isM32(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b1, 0x81, 0, addr(v[0]), 0)
            m.emit(0x90)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // KMOVD k, r32
    if isK(v0) && isReg32(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(3, hcode(v[1]), nil, 0)
            m.emit(0x93)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVD k, m32
    if isK(v0) && isM32(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b1, 0x81, 0, addr(v[1]), 0)
            m.emit(0x91)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for KMOVD")
    }
    return p
}

// KMOVQ performs "Move 64-bit Mask".
//
// Mnemonic        : KMOVQ
// Supported forms : (5 forms)
//
//    * KMOVQ k, k      [AVX512BW]
//    * KMOVQ r64, k    [AVX512BW]
//    * KMOVQ m64, k    [AVX512BW]
//    * KMOVQ k, r64    [AVX512BW]
//    * KMOVQ k, m64    [AVX512BW]
//
func (self *Program) KMOVQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KMOVQ", 2, Operands { v0, v1 })
    // KMOVQ k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf8)
            m.emit(0x90)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVQ r64, k
    if isReg64(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1 ^ (hcode(v[0]) << 5))
            m.emit(0xfb)
            m.emit(0x92)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVQ m64, k
    if isM64(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b1, 0x80, 0, addr(v[0]), 0)
            m.emit(0x90)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // KMOVQ k, r64
    if isK(v0) && isReg64(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1 ^ (hcode(v[1]) << 7))
            m.emit(0xfb)
            m.emit(0x93)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVQ k, m64
    if isK(v0) && isM64(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b1, 0x80, 0, addr(v[1]), 0)
            m.emit(0x91)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for KMOVQ")
    }
    return p
}

// KMOVW performs "Move 16-bit Mask".
//
// Mnemonic        : KMOVW
// Supported forms : (5 forms)
//
//    * KMOVW k, k      [AVX512F]
//    * KMOVW r32, k    [AVX512F]
//    * KMOVW m16, k    [AVX512F]
//    * KMOVW k, r32    [AVX512F]
//    * KMOVW k, m16    [AVX512F]
//
func (self *Program) KMOVW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KMOVW", 2, Operands { v0, v1 })
    // KMOVW k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, 0, nil, 0)
            m.emit(0x90)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVW r32, k
    if isReg32(v0) && isK(v1) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, 0, v[0], 0)
            m.emit(0x92)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVW m16, k
    if isM16(v0) && isK(v1) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, 0, addr(v[0]), 0)
            m.emit(0x90)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // KMOVW k, r32
    if isK(v0) && isReg32(v1) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, hcode(v[1]), nil, 0)
            m.emit(0x93)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // KMOVW k, m16
    if isK(v0) && isM16(v1) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, 0, addr(v[1]), 0)
            m.emit(0x91)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for KMOVW")
    }
    return p
}

// KNOTB performs "NOT 8-bit Mask Register".
//
// Mnemonic        : KNOTB
// Supported forms : (1 form)
//
//    * KNOTB k, k    [AVX512DQ]
//
func (self *Program) KNOTB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KNOTB", 2, Operands { v0, v1 })
    // KNOTB k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, 0, nil, 0)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KNOTB")
    }
    return p
}

// KNOTD performs "NOT 32-bit Mask Register".
//
// Mnemonic        : KNOTD
// Supported forms : (1 form)
//
//    * KNOTD k, k    [AVX512BW]
//
func (self *Program) KNOTD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KNOTD", 2, Operands { v0, v1 })
    // KNOTD k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf9)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KNOTD")
    }
    return p
}

// KNOTQ performs "NOT 64-bit Mask Register".
//
// Mnemonic        : KNOTQ
// Supported forms : (1 form)
//
//    * KNOTQ k, k    [AVX512BW]
//
func (self *Program) KNOTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KNOTQ", 2, Operands { v0, v1 })
    // KNOTQ k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf8)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KNOTQ")
    }
    return p
}

// KNOTW performs "NOT 16-bit Mask Register".
//
// Mnemonic        : KNOTW
// Supported forms : (1 form)
//
//    * KNOTW k, k    [AVX512F]
//
func (self *Program) KNOTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KNOTW", 2, Operands { v0, v1 })
    // KNOTW k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, 0, nil, 0)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KNOTW")
    }
    return p
}

// KORB performs "Bitwise Logical OR 8-bit Masks".
//
// Mnemonic        : KORB
// Supported forms : (1 form)
//
//    * KORB k, k, k    [AVX512DQ]
//
func (self *Program) KORB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KORB", 3, Operands { v0, v1, v2 })
    // KORB k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, 0, nil, hlcode(v[1]))
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORB")
    }
    return p
}

// KORD performs "Bitwise Logical OR 32-bit Masks".
//
// Mnemonic        : KORD
// Supported forms : (1 form)
//
//    * KORD k, k, k    [AVX512BW]
//
func (self *Program) KORD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KORD", 3, Operands { v0, v1, v2 })
    // KORD k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORD")
    }
    return p
}

// KORQ performs "Bitwise Logical OR 64-bit Masks".
//
// Mnemonic        : KORQ
// Supported forms : (1 form)
//
//    * KORQ k, k, k    [AVX512BW]
//
func (self *Program) KORQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KORQ", 3, Operands { v0, v1, v2 })
    // KORQ k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfc ^ (hlcode(v[1]) << 3))
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORQ")
    }
    return p
}

// KORTESTB performs "OR 8-bit Masks and Set Flags".
//
// Mnemonic        : KORTESTB
// Supported forms : (1 form)
//
//    * KORTESTB k, k    [AVX512DQ]
//
func (self *Program) KORTESTB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KORTESTB", 2, Operands { v0, v1 })
    // KORTESTB k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, 0, nil, 0)
            m.emit(0x98)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORTESTB")
    }
    return p
}

// KORTESTD performs "OR 32-bit Masks and Set Flags".
//
// Mnemonic        : KORTESTD
// Supported forms : (1 form)
//
//    * KORTESTD k, k    [AVX512BW]
//
func (self *Program) KORTESTD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KORTESTD", 2, Operands { v0, v1 })
    // KORTESTD k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf9)
            m.emit(0x98)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORTESTD")
    }
    return p
}

// KORTESTQ performs "OR 64-bit Masks and Set Flags".
//
// Mnemonic        : KORTESTQ
// Supported forms : (1 form)
//
//    * KORTESTQ k, k    [AVX512BW]
//
func (self *Program) KORTESTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KORTESTQ", 2, Operands { v0, v1 })
    // KORTESTQ k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf8)
            m.emit(0x98)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORTESTQ")
    }
    return p
}

// KORTESTW performs "OR 16-bit Masks and Set Flags".
//
// Mnemonic        : KORTESTW
// Supported forms : (1 form)
//
//    * KORTESTW k, k    [AVX512F]
//
func (self *Program) KORTESTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KORTESTW", 2, Operands { v0, v1 })
    // KORTESTW k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, 0, nil, 0)
            m.emit(0x98)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORTESTW")
    }
    return p
}

// KORW performs "Bitwise Logical OR 16-bit Masks".
//
// Mnemonic        : KORW
// Supported forms : (1 form)
//
//    * KORW k, k, k    [AVX512F]
//
func (self *Program) KORW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KORW", 3, Operands { v0, v1, v2 })
    // KORW k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, 0, nil, hlcode(v[1]))
            m.emit(0x45)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KORW")
    }
    return p
}

// KSHIFTLB performs "Shift Left 8-bit Masks".
//
// Mnemonic        : KSHIFTLB
// Supported forms : (1 form)
//
//    * KSHIFTLB imm8, k, k    [AVX512DQ]
//
func (self *Program) KSHIFTLB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTLB", 3, Operands { v0, v1, v2 })
    // KSHIFTLB imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0x79)
            m.emit(0x32)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTLB")
    }
    return p
}

// KSHIFTLD performs "Shift Left 32-bit Masks".
//
// Mnemonic        : KSHIFTLD
// Supported forms : (1 form)
//
//    * KSHIFTLD imm8, k, k    [AVX512BW]
//
func (self *Program) KSHIFTLD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTLD", 3, Operands { v0, v1, v2 })
    // KSHIFTLD imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0x79)
            m.emit(0x33)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTLD")
    }
    return p
}

// KSHIFTLQ performs "Shift Left 64-bit Masks".
//
// Mnemonic        : KSHIFTLQ
// Supported forms : (1 form)
//
//    * KSHIFTLQ imm8, k, k    [AVX512BW]
//
func (self *Program) KSHIFTLQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTLQ", 3, Operands { v0, v1, v2 })
    // KSHIFTLQ imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0xf9)
            m.emit(0x33)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTLQ")
    }
    return p
}

// KSHIFTLW performs "Shift Left 16-bit Masks".
//
// Mnemonic        : KSHIFTLW
// Supported forms : (1 form)
//
//    * KSHIFTLW imm8, k, k    [AVX512F]
//
func (self *Program) KSHIFTLW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTLW", 3, Operands { v0, v1, v2 })
    // KSHIFTLW imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0xf9)
            m.emit(0x32)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTLW")
    }
    return p
}

// KSHIFTRB performs "Shift Right 8-bit Masks".
//
// Mnemonic        : KSHIFTRB
// Supported forms : (1 form)
//
//    * KSHIFTRB imm8, k, k    [AVX512DQ]
//
func (self *Program) KSHIFTRB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTRB", 3, Operands { v0, v1, v2 })
    // KSHIFTRB imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0x79)
            m.emit(0x30)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTRB")
    }
    return p
}

// KSHIFTRD performs "Shift Right 32-bit Masks".
//
// Mnemonic        : KSHIFTRD
// Supported forms : (1 form)
//
//    * KSHIFTRD imm8, k, k    [AVX512BW]
//
func (self *Program) KSHIFTRD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTRD", 3, Operands { v0, v1, v2 })
    // KSHIFTRD imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0x79)
            m.emit(0x31)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTRD")
    }
    return p
}

// KSHIFTRQ performs "Shift Right 64-bit Masks".
//
// Mnemonic        : KSHIFTRQ
// Supported forms : (1 form)
//
//    * KSHIFTRQ imm8, k, k    [AVX512BW]
//
func (self *Program) KSHIFTRQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTRQ", 3, Operands { v0, v1, v2 })
    // KSHIFTRQ imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0xf9)
            m.emit(0x31)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTRQ")
    }
    return p
}

// KSHIFTRW performs "Shift Right 16-bit Masks".
//
// Mnemonic        : KSHIFTRW
// Supported forms : (1 form)
//
//    * KSHIFTRW imm8, k, k    [AVX512F]
//
func (self *Program) KSHIFTRW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KSHIFTRW", 3, Operands { v0, v1, v2 })
    // KSHIFTRW imm8, k, k
    if isImm8(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3)
            m.emit(0xf9)
            m.emit(0x30)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KSHIFTRW")
    }
    return p
}

// KTESTB performs "Bit Test 8-bit Masks and Set Flags".
//
// Mnemonic        : KTESTB
// Supported forms : (1 form)
//
//    * KTESTB k, k    [AVX512DQ]
//
func (self *Program) KTESTB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KTESTB", 2, Operands { v0, v1 })
    // KTESTB k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, 0, nil, 0)
            m.emit(0x99)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KTESTB")
    }
    return p
}

// KTESTD performs "Bit Test 32-bit Masks and Set Flags".
//
// Mnemonic        : KTESTD
// Supported forms : (1 form)
//
//    * KTESTD k, k    [AVX512BW]
//
func (self *Program) KTESTD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KTESTD", 2, Operands { v0, v1 })
    // KTESTD k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf9)
            m.emit(0x99)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KTESTD")
    }
    return p
}

// KTESTQ performs "Bit Test 64-bit Masks and Set Flags".
//
// Mnemonic        : KTESTQ
// Supported forms : (1 form)
//
//    * KTESTQ k, k    [AVX512BW]
//
func (self *Program) KTESTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KTESTQ", 2, Operands { v0, v1 })
    // KTESTQ k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xf8)
            m.emit(0x99)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KTESTQ")
    }
    return p
}

// KTESTW performs "Bit Test 16-bit Masks and Set Flags".
//
// Mnemonic        : KTESTW
// Supported forms : (1 form)
//
//    * KTESTW k, k    [AVX512DQ]
//
func (self *Program) KTESTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("KTESTW", 2, Operands { v0, v1 })
    // KTESTW k, k
    if isK(v0) && isK(v1) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, 0, nil, 0)
            m.emit(0x99)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KTESTW")
    }
    return p
}

// KUNPCKBW performs "Unpack and Interleave 8-bit Masks".
//
// Mnemonic        : KUNPCKBW
// Supported forms : (1 form)
//
//    * KUNPCKBW k, k, k    [AVX512F]
//
func (self *Program) KUNPCKBW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KUNPCKBW", 3, Operands { v0, v1, v2 })
    // KUNPCKBW k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, 0, nil, hlcode(v[1]))
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KUNPCKBW")
    }
    return p
}

// KUNPCKDQ performs "Unpack and Interleave 32-bit Masks".
//
// Mnemonic        : KUNPCKDQ
// Supported forms : (1 form)
//
//    * KUNPCKDQ k, k, k    [AVX512BW]
//
func (self *Program) KUNPCKDQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KUNPCKDQ", 3, Operands { v0, v1, v2 })
    // KUNPCKDQ k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfc ^ (hlcode(v[1]) << 3))
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KUNPCKDQ")
    }
    return p
}

// KUNPCKWD performs "Unpack and Interleave 16-bit Masks".
//
// Mnemonic        : KUNPCKWD
// Supported forms : (1 form)
//
//    * KUNPCKWD k, k, k    [AVX512BW]
//
func (self *Program) KUNPCKWD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KUNPCKWD", 3, Operands { v0, v1, v2 })
    // KUNPCKWD k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, 0, nil, hlcode(v[1]))
            m.emit(0x4b)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KUNPCKWD")
    }
    return p
}

// KXNORB performs "Bitwise Logical XNOR 8-bit Masks".
//
// Mnemonic        : KXNORB
// Supported forms : (1 form)
//
//    * KXNORB k, k, k    [AVX512DQ]
//
func (self *Program) KXNORB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXNORB", 3, Operands { v0, v1, v2 })
    // KXNORB k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, 0, nil, hlcode(v[1]))
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXNORB")
    }
    return p
}

// KXNORD performs "Bitwise Logical XNOR 32-bit Masks".
//
// Mnemonic        : KXNORD
// Supported forms : (1 form)
//
//    * KXNORD k, k, k    [AVX512BW]
//
func (self *Program) KXNORD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXNORD", 3, Operands { v0, v1, v2 })
    // KXNORD k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXNORD")
    }
    return p
}

// KXNORQ performs "Bitwise Logical XNOR 64-bit Masks".
//
// Mnemonic        : KXNORQ
// Supported forms : (1 form)
//
//    * KXNORQ k, k, k    [AVX512BW]
//
func (self *Program) KXNORQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXNORQ", 3, Operands { v0, v1, v2 })
    // KXNORQ k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfc ^ (hlcode(v[1]) << 3))
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXNORQ")
    }
    return p
}

// KXNORW performs "Bitwise Logical XNOR 16-bit Masks".
//
// Mnemonic        : KXNORW
// Supported forms : (1 form)
//
//    * KXNORW k, k, k    [AVX512F]
//
func (self *Program) KXNORW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXNORW", 3, Operands { v0, v1, v2 })
    // KXNORW k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, 0, nil, hlcode(v[1]))
            m.emit(0x46)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXNORW")
    }
    return p
}

// KXORB performs "Bitwise Logical XOR 8-bit Masks".
//
// Mnemonic        : KXORB
// Supported forms : (1 form)
//
//    * KXORB k, k, k    [AVX512DQ]
//
func (self *Program) KXORB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXORB", 3, Operands { v0, v1, v2 })
    // KXORB k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512DQ)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, 0, nil, hlcode(v[1]))
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXORB")
    }
    return p
}

// KXORD performs "Bitwise Logical XOR 32-bit Masks".
//
// Mnemonic        : KXORD
// Supported forms : (1 form)
//
//    * KXORD k, k, k    [AVX512BW]
//
func (self *Program) KXORD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXORD", 3, Operands { v0, v1, v2 })
    // KXORD k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXORD")
    }
    return p
}

// KXORQ performs "Bitwise Logical XOR 64-bit Masks".
//
// Mnemonic        : KXORQ
// Supported forms : (1 form)
//
//    * KXORQ k, k, k    [AVX512BW]
//
func (self *Program) KXORQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXORQ", 3, Operands { v0, v1, v2 })
    // KXORQ k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512BW)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe1)
            m.emit(0xfc ^ (hlcode(v[1]) << 3))
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXORQ")
    }
    return p
}

// KXORW performs "Bitwise Logical XOR 16-bit Masks".
//
// Mnemonic        : KXORW
// Supported forms : (1 form)
//
//    * KXORW k, k, k    [AVX512F]
//
func (self *Program) KXORW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("KXORW", 3, Operands { v0, v1, v2 })
    // KXORW k, k, k
    if isK(v0) && isK(v1) && isK(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainMask
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, 0, nil, hlcode(v[1]))
            m.emit(0x47)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for KXORW")
    }
    return p
}

// LDDQU performs "Load Unaligned Integer 128 Bits".
//
// Mnemonic        : LDDQU
// Supported forms : (1 form)
//
//    * LDDQU m128, xmm    [SSE3]
//
func (self *Program) LDDQU(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("LDDQU", 2, Operands { v0, v1 })
    // LDDQU m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LDDQU")
    }
    return p
}

// LDMXCSR performs "Load MXCSR Register".
//
// Mnemonic        : LDMXCSR
// Supported forms : (1 form)
//
//    * LDMXCSR m32    [SSE]
//
func (self *Program) LDMXCSR(v0 interface{}) *Instruction {
    p := self.alloc("LDMXCSR", 1, Operands { v0 })
    // LDMXCSR m32
    if isM32(v0) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xae)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LDMXCSR")
    }
    return p
}

// LEAL performs "Load Effective Address".
//
// Mnemonic        : LEA
// Supported forms : (1 form)
//
//    * LEAL m, r32
//
func (self *Program) LEAL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("LEAL", 2, Operands { v0, v1 })
    // LEAL m, r32
    if isM(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x8d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LEAL")
    }
    return p
}

// LEAQ performs "Load Effective Address".
//
// Mnemonic        : LEA
// Supported forms : (1 form)
//
//    * LEAQ m, r64
//
func (self *Program) LEAQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("LEAQ", 2, Operands { v0, v1 })
    // LEAQ m, r64
    if isM(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x8d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LEAQ")
    }
    return p
}

// LEAW performs "Load Effective Address".
//
// Mnemonic        : LEA
// Supported forms : (1 form)
//
//    * LEAW m, r16
//
func (self *Program) LEAW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("LEAW", 2, Operands { v0, v1 })
    // LEAW m, r16
    if isM(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x8d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LEAW")
    }
    return p
}

// LFENCE performs "Load Fence".
//
// Mnemonic        : LFENCE
// Supported forms : (1 form)
//
//    * LFENCE    [SSE2]
//
func (self *Program) LFENCE() *Instruction {
    p := self.alloc("LFENCE", 0, Operands {  })
    // LFENCE
    self.require(ISA_SSE2)
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0xae)
        m.emit(0xe8)
    })
    return p
}

// LZCNTL performs "Count the Number of Leading Zero Bits".
//
// Mnemonic        : LZCNT
// Supported forms : (2 forms)
//
//    * LZCNTL r32, r32    [LZCNT]
//    * LZCNTL m32, r32    [LZCNT]
//
func (self *Program) LZCNTL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("LZCNTL", 2, Operands { v0, v1 })
    // LZCNTL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_LZCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // LZCNTL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_LZCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LZCNTL")
    }
    return p
}

// LZCNTQ performs "Count the Number of Leading Zero Bits".
//
// Mnemonic        : LZCNT
// Supported forms : (2 forms)
//
//    * LZCNTQ r64, r64    [LZCNT]
//    * LZCNTQ m64, r64    [LZCNT]
//
func (self *Program) LZCNTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("LZCNTQ", 2, Operands { v0, v1 })
    // LZCNTQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_LZCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xbd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // LZCNTQ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_LZCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xbd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LZCNTQ")
    }
    return p
}

// LZCNTW performs "Count the Number of Leading Zero Bits".
//
// Mnemonic        : LZCNT
// Supported forms : (2 forms)
//
//    * LZCNTW r16, r16    [LZCNT]
//    * LZCNTW m16, r16    [LZCNT]
//
func (self *Program) LZCNTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("LZCNTW", 2, Operands { v0, v1 })
    // LZCNTW r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_LZCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // LZCNTW m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_LZCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for LZCNTW")
    }
    return p
}

// MASKMOVDQU performs "Store Selected Bytes of Double Quadword".
//
// Mnemonic        : MASKMOVDQU
// Supported forms : (1 form)
//
//    * MASKMOVDQU xmm, xmm    [SSE2]
//
func (self *Program) MASKMOVDQU(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MASKMOVDQU", 2, Operands { v0, v1 })
    // MASKMOVDQU xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MASKMOVDQU")
    }
    return p
}

// MASKMOVQ performs "Store Selected Bytes of Quadword".
//
// Mnemonic        : MASKMOVQ
// Supported forms : (1 form)
//
//    * MASKMOVQ mm, mm    [MMX+]
//
func (self *Program) MASKMOVQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MASKMOVQ", 2, Operands { v0, v1 })
    // MASKMOVQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MASKMOVQ")
    }
    return p
}

// MAXPD performs "Return Maximum Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : MAXPD
// Supported forms : (2 forms)
//
//    * MAXPD xmm, xmm     [SSE2]
//    * MAXPD m128, xmm    [SSE2]
//
func (self *Program) MAXPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MAXPD", 2, Operands { v0, v1 })
    // MAXPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MAXPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MAXPD")
    }
    return p
}

// MAXPS performs "Return Maximum Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : MAXPS
// Supported forms : (2 forms)
//
//    * MAXPS xmm, xmm     [SSE]
//    * MAXPS m128, xmm    [SSE]
//
func (self *Program) MAXPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MAXPS", 2, Operands { v0, v1 })
    // MAXPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MAXPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MAXPS")
    }
    return p
}

// MAXSD performs "Return Maximum Scalar Double-Precision Floating-Point Value".
//
// Mnemonic        : MAXSD
// Supported forms : (2 forms)
//
//    * MAXSD xmm, xmm    [SSE2]
//    * MAXSD m64, xmm    [SSE2]
//
func (self *Program) MAXSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MAXSD", 2, Operands { v0, v1 })
    // MAXSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MAXSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MAXSD")
    }
    return p
}

// MAXSS performs "Return Maximum Scalar Single-Precision Floating-Point Value".
//
// Mnemonic        : MAXSS
// Supported forms : (2 forms)
//
//    * MAXSS xmm, xmm    [SSE]
//    * MAXSS m32, xmm    [SSE]
//
func (self *Program) MAXSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MAXSS", 2, Operands { v0, v1 })
    // MAXSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MAXSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MAXSS")
    }
    return p
}

// MFENCE performs "Memory Fence".
//
// Mnemonic        : MFENCE
// Supported forms : (1 form)
//
//    * MFENCE    [SSE2]
//
func (self *Program) MFENCE() *Instruction {
    p := self.alloc("MFENCE", 0, Operands {  })
    // MFENCE
    self.require(ISA_SSE2)
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0xae)
        m.emit(0xf0)
    })
    return p
}

// MINPD performs "Return Minimum Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : MINPD
// Supported forms : (2 forms)
//
//    * MINPD xmm, xmm     [SSE2]
//    * MINPD m128, xmm    [SSE2]
//
func (self *Program) MINPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MINPD", 2, Operands { v0, v1 })
    // MINPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MINPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MINPD")
    }
    return p
}

// MINPS performs "Return Minimum Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : MINPS
// Supported forms : (2 forms)
//
//    * MINPS xmm, xmm     [SSE]
//    * MINPS m128, xmm    [SSE]
//
func (self *Program) MINPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MINPS", 2, Operands { v0, v1 })
    // MINPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MINPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MINPS")
    }
    return p
}

// MINSD performs "Return Minimum Scalar Double-Precision Floating-Point Value".
//
// Mnemonic        : MINSD
// Supported forms : (2 forms)
//
//    * MINSD xmm, xmm    [SSE2]
//    * MINSD m64, xmm    [SSE2]
//
func (self *Program) MINSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MINSD", 2, Operands { v0, v1 })
    // MINSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MINSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MINSD")
    }
    return p
}

// MINSS performs "Return Minimum Scalar Single-Precision Floating-Point Value".
//
// Mnemonic        : MINSS
// Supported forms : (2 forms)
//
//    * MINSS xmm, xmm    [SSE]
//    * MINSS m32, xmm    [SSE]
//
func (self *Program) MINSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MINSS", 2, Operands { v0, v1 })
    // MINSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MINSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MINSS")
    }
    return p
}

// MONITOR performs "Monitor a Linear Address Range".
//
// Mnemonic        : MONITOR
// Supported forms : (1 form)
//
//    * MONITOR    [MONITOR]
//
func (self *Program) MONITOR() *Instruction {
    p := self.alloc("MONITOR", 0, Operands {  })
    // MONITOR
    self.require(ISA_MONITOR)
    p.domain = DomainMisc
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x01)
        m.emit(0xc8)
    })
    return p
}

// MONITORX performs "Monitor a Linear Address Range with Timeout".
//
// Mnemonic        : MONITORX
// Supported forms : (1 form)
//
//    * MONITORX    [MONITORX]
//
func (self *Program) MONITORX() *Instruction {
    p := self.alloc("MONITORX", 0, Operands {  })
    // MONITORX
    self.require(ISA_MONITORX)
    p.domain = DomainMisc
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x01)
        m.emit(0xfa)
    })
    return p
}

// MOVAPD performs "Move Aligned Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : MOVAPD
// Supported forms : (3 forms)
//
//    * MOVAPD xmm, xmm     [SSE2]
//    * MOVAPD m128, xmm    [SSE2]
//    * MOVAPD xmm, m128    [SSE2]
//
func (self *Program) MOVAPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVAPD", 2, Operands { v0, v1 })
    // MOVAPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x28)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x29)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVAPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x28)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVAPD xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x29)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVAPD")
    }
    return p
}

// MOVAPS performs "Move Aligned Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : MOVAPS
// Supported forms : (3 forms)
//
//    * MOVAPS xmm, xmm     [SSE]
//    * MOVAPS m128, xmm    [SSE]
//    * MOVAPS xmm, m128    [SSE]
//
func (self *Program) MOVAPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVAPS", 2, Operands { v0, v1 })
    // MOVAPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x28)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x29)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVAPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x28)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVAPS xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x29)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVAPS")
    }
    return p
}

// MOVB performs "Move".
//
// Mnemonic        : MOV
// Supported forms : (5 forms)
//
//    * MOVB imm8, r8
//    * MOVB r8, r8
//    * MOVB m8, r8
//    * MOVB imm8, m8
//    * MOVB r8, m8
//
func (self *Program) MOVB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVB", 2, Operands { v0, v1 })
    // MOVB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc6)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xb0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // MOVB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x88)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x8a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x8a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc6)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // MOVB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x88)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVB")
    }
    return p
}

// MOVBEL performs "Move Data After Swapping Bytes".
//
// Mnemonic        : MOVBE
// Supported forms : (2 forms)
//
//    * MOVBEL m32, r32    [MOVBE]
//    * MOVBEL r32, m32    [MOVBE]
//
func (self *Program) MOVBEL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVBEL", 2, Operands { v0, v1 })
    // MOVBEL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_MOVBE)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVBEL r32, m32
    if isReg32(v0) && isM32(v1) {
        self.require(ISA_MOVBE)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVBEL")
    }
    return p
}

// MOVBEQ performs "Move Data After Swapping Bytes".
//
// Mnemonic        : MOVBE
// Supported forms : (2 forms)
//
//    * MOVBEQ m64, r64    [MOVBE]
//    * MOVBEQ r64, m64    [MOVBE]
//
func (self *Program) MOVBEQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVBEQ", 2, Operands { v0, v1 })
    // MOVBEQ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_MOVBE)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVBEQ r64, m64
    if isReg64(v0) && isM64(v1) {
        self.require(ISA_MOVBE)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVBEQ")
    }
    return p
}

// MOVBEW performs "Move Data After Swapping Bytes".
//
// Mnemonic        : MOVBE
// Supported forms : (2 forms)
//
//    * MOVBEW m16, r16    [MOVBE]
//    * MOVBEW r16, m16    [MOVBE]
//
func (self *Program) MOVBEW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVBEW", 2, Operands { v0, v1 })
    // MOVBEW m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_MOVBE)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVBEW r16, m16
    if isReg16(v0) && isM16(v1) {
        self.require(ISA_MOVBE)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xf1)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVBEW")
    }
    return p
}

// MOVD performs "Move Doubleword".
//
// Mnemonic        : MOVD
// Supported forms : (8 forms)
//
//    * MOVD mm, r32     [MMX]
//    * MOVD r32, mm     [MMX]
//    * MOVD m32, mm     [MMX]
//    * MOVD mm, m32     [MMX]
//    * MOVD xmm, r32    [SSE2]
//    * MOVD r32, xmm    [SSE2]
//    * MOVD m32, xmm    [SSE2]
//    * MOVD xmm, m32    [SSE2]
//
func (self *Program) MOVD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVD", 2, Operands { v0, v1 })
    // MOVD mm, r32
    if isMM(v0) && isReg32(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x7e)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVD r32, mm
    if isReg32(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVD m32, mm
    if isM32(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVD mm, m32
    if isMM(v0) && isM32(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x7e)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    // MOVD xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x7e)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVD r32, xmm
    if isReg32(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVD m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVD xmm, m32
    if isXMM(v0) && isM32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x7e)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVD")
    }
    return p
}

// MOVDDUP performs "Move One Double-FP and Duplicate".
//
// Mnemonic        : MOVDDUP
// Supported forms : (2 forms)
//
//    * MOVDDUP xmm, xmm    [SSE3]
//    * MOVDDUP m64, xmm    [SSE3]
//
func (self *Program) MOVDDUP(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVDDUP", 2, Operands { v0, v1 })
    // MOVDDUP xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x12)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVDDUP m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x12)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVDDUP")
    }
    return p
}

// MOVDQ2Q performs "Move Quadword from XMM to MMX Technology Register".
//
// Mnemonic        : MOVDQ2Q
// Supported forms : (1 form)
//
//    * MOVDQ2Q xmm, mm    [SSE2]
//
func (self *Program) MOVDQ2Q(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVDQ2Q", 2, Operands { v0, v1 })
    // MOVDQ2Q xmm, mm
    if isXMM(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVDQ2Q")
    }
    return p
}

// MOVDQA performs "Move Aligned Double Quadword".
//
// Mnemonic        : MOVDQA
// Supported forms : (3 forms)
//
//    * MOVDQA xmm, xmm     [SSE2]
//    * MOVDQA m128, xmm    [SSE2]
//    * MOVDQA xmm, m128    [SSE2]
//
func (self *Program) MOVDQA(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVDQA", 2, Operands { v0, v1 })
    // MOVDQA xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x7f)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVDQA m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVDQA xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x7f)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVDQA")
    }
    return p
}

// MOVDQU performs "Move Unaligned Double Quadword".
//
// Mnemonic        : MOVDQU
// Supported forms : (3 forms)
//
//    * MOVDQU xmm, xmm     [SSE2]
//    * MOVDQU m128, xmm    [SSE2]
//    * MOVDQU xmm, m128    [SSE2]
//
func (self *Program) MOVDQU(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVDQU", 2, Operands { v0, v1 })
    // MOVDQU xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x7f)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVDQU m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVDQU xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x7f)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVDQU")
    }
    return p
}

// MOVHLPS performs "Move Packed Single-Precision Floating-Point Values High to Low".
//
// Mnemonic        : MOVHLPS
// Supported forms : (1 form)
//
//    * MOVHLPS xmm, xmm    [SSE]
//
func (self *Program) MOVHLPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVHLPS", 2, Operands { v0, v1 })
    // MOVHLPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x12)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVHLPS")
    }
    return p
}

// MOVHPD performs "Move High Packed Double-Precision Floating-Point Value".
//
// Mnemonic        : MOVHPD
// Supported forms : (2 forms)
//
//    * MOVHPD m64, xmm    [SSE2]
//    * MOVHPD xmm, m64    [SSE2]
//
func (self *Program) MOVHPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVHPD", 2, Operands { v0, v1 })
    // MOVHPD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x16)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVHPD xmm, m64
    if isXMM(v0) && isM64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x17)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVHPD")
    }
    return p
}

// MOVHPS performs "Move High Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : MOVHPS
// Supported forms : (2 forms)
//
//    * MOVHPS m64, xmm    [SSE]
//    * MOVHPS xmm, m64    [SSE]
//
func (self *Program) MOVHPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVHPS", 2, Operands { v0, v1 })
    // MOVHPS m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x16)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVHPS xmm, m64
    if isXMM(v0) && isM64(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x17)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVHPS")
    }
    return p
}

// MOVL performs "Move".
//
// Mnemonic        : MOV
// Supported forms : (5 forms)
//
//    * MOVL imm32, r32
//    * MOVL r32, r32
//    * MOVL m32, r32
//    * MOVL imm32, m32
//    * MOVL r32, m32
//
func (self *Program) MOVL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVL", 2, Operands { v0, v1 })
    // MOVL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc7)
            m.emit(0xc0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xb8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // MOVL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x89)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x8b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x8b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc7)
            m.mrsd(0, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // MOVL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x89)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVL")
    }
    return p
}

// MOVLHPS performs "Move Packed Single-Precision Floating-Point Values Low to High".
//
// Mnemonic        : MOVLHPS
// Supported forms : (1 form)
//
//    * MOVLHPS xmm, xmm    [SSE]
//
func (self *Program) MOVLHPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVLHPS", 2, Operands { v0, v1 })
    // MOVLHPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x16)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVLHPS")
    }
    return p
}

// MOVLPD performs "Move Low Packed Double-Precision Floating-Point Value".
//
// Mnemonic        : MOVLPD
// Supported forms : (2 forms)
//
//    * MOVLPD m64, xmm    [SSE2]
//    * MOVLPD xmm, m64    [SSE2]
//
func (self *Program) MOVLPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVLPD", 2, Operands { v0, v1 })
    // MOVLPD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x12)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVLPD xmm, m64
    if isXMM(v0) && isM64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x13)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVLPD")
    }
    return p
}

// MOVLPS performs "Move Low Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : MOVLPS
// Supported forms : (2 forms)
//
//    * MOVLPS m64, xmm    [SSE]
//    * MOVLPS xmm, m64    [SSE]
//
func (self *Program) MOVLPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVLPS", 2, Operands { v0, v1 })
    // MOVLPS m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x12)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVLPS xmm, m64
    if isXMM(v0) && isM64(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x13)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVLPS")
    }
    return p
}

// MOVMSKPD performs "Extract Packed Double-Precision Floating-Point Sign Mask".
//
// Mnemonic        : MOVMSKPD
// Supported forms : (1 form)
//
//    * MOVMSKPD xmm, r32    [SSE2]
//
func (self *Program) MOVMSKPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVMSKPD", 2, Operands { v0, v1 })
    // MOVMSKPD xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x50)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVMSKPD")
    }
    return p
}

// MOVMSKPS performs "Extract Packed Single-Precision Floating-Point Sign Mask".
//
// Mnemonic        : MOVMSKPS
// Supported forms : (1 form)
//
//    * MOVMSKPS xmm, r32    [SSE]
//
func (self *Program) MOVMSKPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVMSKPS", 2, Operands { v0, v1 })
    // MOVMSKPS xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x50)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVMSKPS")
    }
    return p
}

// MOVNTDQ performs "Store Double Quadword Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTDQ
// Supported forms : (1 form)
//
//    * MOVNTDQ xmm, m128    [SSE2]
//
func (self *Program) MOVNTDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTDQ", 2, Operands { v0, v1 })
    // MOVNTDQ xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xe7)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTDQ")
    }
    return p
}

// MOVNTDQA performs "Load Double Quadword Non-Temporal Aligned Hint".
//
// Mnemonic        : MOVNTDQA
// Supported forms : (1 form)
//
//    * MOVNTDQA m128, xmm    [SSE4.1]
//
func (self *Program) MOVNTDQA(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTDQA", 2, Operands { v0, v1 })
    // MOVNTDQA m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTDQA")
    }
    return p
}

// MOVNTIL performs "Store Doubleword Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTI
// Supported forms : (1 form)
//
//    * MOVNTIL r32, m32    [SSE2]
//
func (self *Program) MOVNTIL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTIL", 2, Operands { v0, v1 })
    // MOVNTIL r32, m32
    if isReg32(v0) && isM32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTIL")
    }
    return p
}

// MOVNTIQ performs "Store Doubleword Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTI
// Supported forms : (1 form)
//
//    * MOVNTIQ r64, m64    [SSE2]
//
func (self *Program) MOVNTIQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTIQ", 2, Operands { v0, v1 })
    // MOVNTIQ r64, m64
    if isReg64(v0) && isM64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0xc3)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTIQ")
    }
    return p
}

// MOVNTPD performs "Store Packed Double-Precision Floating-Point Values Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTPD
// Supported forms : (1 form)
//
//    * MOVNTPD xmm, m128    [SSE2]
//
func (self *Program) MOVNTPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTPD", 2, Operands { v0, v1 })
    // MOVNTPD xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x2b)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTPD")
    }
    return p
}

// MOVNTPS performs "Store Packed Single-Precision Floating-Point Values Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTPS
// Supported forms : (1 form)
//
//    * MOVNTPS xmm, m128    [SSE]
//
func (self *Program) MOVNTPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTPS", 2, Operands { v0, v1 })
    // MOVNTPS xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x2b)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTPS")
    }
    return p
}

// MOVNTQ performs "Store of Quadword Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTQ
// Supported forms : (1 form)
//
//    * MOVNTQ mm, m64    [MMX+]
//
func (self *Program) MOVNTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTQ", 2, Operands { v0, v1 })
    // MOVNTQ mm, m64
    if isMM(v0) && isM64(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xe7)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTQ")
    }
    return p
}

// MOVNTSD performs "Store Scalar Double-Precision Floating-Point Values Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTSD
// Supported forms : (1 form)
//
//    * MOVNTSD xmm, m64    [SSE4A]
//
func (self *Program) MOVNTSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTSD", 2, Operands { v0, v1 })
    // MOVNTSD xmm, m64
    if isXMM(v0) && isM64(v1) {
        self.require(ISA_SSE4A)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x2b)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTSD")
    }
    return p
}

// MOVNTSS performs "Store Scalar Single-Precision Floating-Point Values Using Non-Temporal Hint".
//
// Mnemonic        : MOVNTSS
// Supported forms : (1 form)
//
//    * MOVNTSS xmm, m32    [SSE4A]
//
func (self *Program) MOVNTSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVNTSS", 2, Operands { v0, v1 })
    // MOVNTSS xmm, m32
    if isXMM(v0) && isM32(v1) {
        self.require(ISA_SSE4A)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x2b)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVNTSS")
    }
    return p
}

// MOVQ performs "Move".
//
// Mnemonic        : MOV
// Supported forms : (16 forms)
//
//    * MOVQ imm32, r64
//    * MOVQ imm64, r64
//    * MOVQ r64, r64
//    * MOVQ m64, r64
//    * MOVQ imm32, m64
//    * MOVQ r64, m64
//    * MOVQ mm, r64       [MMX]
//    * MOVQ r64, mm       [MMX]
//    * MOVQ mm, mm        [MMX]
//    * MOVQ m64, mm       [MMX]
//    * MOVQ mm, m64       [MMX]
//    * MOVQ xmm, r64      [SSE2]
//    * MOVQ r64, xmm      [SSE2]
//    * MOVQ xmm, xmm      [SSE2]
//    * MOVQ m64, xmm      [SSE2]
//    * MOVQ xmm, m64      [SSE2]
//
func (self *Program) MOVQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVQ", 2, Operands { v0, v1 })
    // MOVQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc7)
            m.emit(0xc0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // MOVQ imm64, r64
    if isImm64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xb8 | lcode(v[1]))
            m.imm8(toImmAny(v[0]))
        })
    }
    // MOVQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x89)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x8b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x8b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc7)
            m.mrsd(0, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // MOVQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x89)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    // MOVQ mm, r64
    if isMM(v0) && isReg64(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0x7e)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVQ r64, mm
    if isReg64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x6e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x7f)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x6e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVQ mm, m64
    if isMM(v0) && isM64(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x7f)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0x7e)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    // MOVQ xmm, r64
    if isXMM(v0) && isReg64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0x7e)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVQ r64, xmm
    if isReg64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0x6e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x7e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0xd6)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVQ m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x7e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0x6e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVQ xmm, m64
    if isXMM(v0) && isM64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xd6)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0x7e)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVQ")
    }
    return p
}

// MOVQ2DQ performs "Move Quadword from MMX Technology to XMM Register".
//
// Mnemonic        : MOVQ2DQ
// Supported forms : (1 form)
//
//    * MOVQ2DQ mm, xmm    [SSE2]
//
func (self *Program) MOVQ2DQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVQ2DQ", 2, Operands { v0, v1 })
    // MOVQ2DQ mm, xmm
    if isMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVQ2DQ")
    }
    return p
}

// MOVSBL performs "Move with Sign-Extension".
//
// Mnemonic        : MOVSX
// Supported forms : (2 forms)
//
//    * MOVSBL r8, r32
//    * MOVSBL m8, r32
//
func (self *Program) MOVSBL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSBL", 2, Operands { v0, v1 })
    // MOVSBL r8, r32
    if isReg8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0xbe)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSBL m8, r32
    if isM8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbe)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSBL")
    }
    return p
}

// MOVSBQ performs "Move with Sign-Extension".
//
// Mnemonic        : MOVSX
// Supported forms : (2 forms)
//
//    * MOVSBQ r8, r64
//    * MOVSBQ m8, r64
//
func (self *Program) MOVSBQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSBQ", 2, Operands { v0, v1 })
    // MOVSBQ r8, r64
    if isReg8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xbe)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSBQ m8, r64
    if isM8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xbe)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSBQ")
    }
    return p
}

// MOVSBW performs "Move with Sign-Extension".
//
// Mnemonic        : MOVSX
// Supported forms : (2 forms)
//
//    * MOVSBW r8, r16
//    * MOVSBW m8, r16
//
func (self *Program) MOVSBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSBW", 2, Operands { v0, v1 })
    // MOVSBW r8, r16
    if isReg8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0xbe)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSBW m8, r16
    if isM8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbe)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSBW")
    }
    return p
}

// MOVSD performs "Move Scalar Double-Precision Floating-Point Value".
//
// Mnemonic        : MOVSD
// Supported forms : (3 forms)
//
//    * MOVSD xmm, xmm    [SSE2]
//    * MOVSD m64, xmm    [SSE2]
//    * MOVSD xmm, m64    [SSE2]
//
func (self *Program) MOVSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSD", 2, Operands { v0, v1 })
    // MOVSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x11)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x10)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVSD xmm, m64
    if isXMM(v0) && isM64(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x11)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSD")
    }
    return p
}

// MOVSHDUP performs "Move Packed Single-FP High and Duplicate".
//
// Mnemonic        : MOVSHDUP
// Supported forms : (2 forms)
//
//    * MOVSHDUP xmm, xmm     [SSE3]
//    * MOVSHDUP m128, xmm    [SSE3]
//
func (self *Program) MOVSHDUP(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSHDUP", 2, Operands { v0, v1 })
    // MOVSHDUP xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x16)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSHDUP m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x16)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSHDUP")
    }
    return p
}

// MOVSLDUP performs "Move Packed Single-FP Low and Duplicate".
//
// Mnemonic        : MOVSLDUP
// Supported forms : (2 forms)
//
//    * MOVSLDUP xmm, xmm     [SSE3]
//    * MOVSLDUP m128, xmm    [SSE3]
//
func (self *Program) MOVSLDUP(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSLDUP", 2, Operands { v0, v1 })
    // MOVSLDUP xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x12)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSLDUP m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x12)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSLDUP")
    }
    return p
}

// MOVSLQ performs "Move Doubleword to Quadword with Sign-Extension".
//
// Mnemonic        : MOVSXD
// Supported forms : (2 forms)
//
//    * MOVSLQ r32, r64
//    * MOVSLQ m32, r64
//
func (self *Program) MOVSLQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSLQ", 2, Operands { v0, v1 })
    // MOVSLQ r32, r64
    if isReg32(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x63)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSLQ m32, r64
    if isM32(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x63)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSLQ")
    }
    return p
}

// MOVSS performs "Move Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : MOVSS
// Supported forms : (3 forms)
//
//    * MOVSS xmm, xmm    [SSE]
//    * MOVSS m32, xmm    [SSE]
//    * MOVSS xmm, m32    [SSE]
//
func (self *Program) MOVSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSS", 2, Operands { v0, v1 })
    // MOVSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x11)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x10)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVSS xmm, m32
    if isXMM(v0) && isM32(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x11)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSS")
    }
    return p
}

// MOVSWL performs "Move with Sign-Extension".
//
// Mnemonic        : MOVSX
// Supported forms : (2 forms)
//
//    * MOVSWL r16, r32
//    * MOVSWL m16, r32
//
func (self *Program) MOVSWL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSWL", 2, Operands { v0, v1 })
    // MOVSWL r16, r32
    if isReg16(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSWL m16, r32
    if isM16(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSWL")
    }
    return p
}

// MOVSWQ performs "Move with Sign-Extension".
//
// Mnemonic        : MOVSX
// Supported forms : (2 forms)
//
//    * MOVSWQ r16, r64
//    * MOVSWQ m16, r64
//
func (self *Program) MOVSWQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVSWQ", 2, Operands { v0, v1 })
    // MOVSWQ r16, r64
    if isReg16(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xbf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVSWQ m16, r64
    if isM16(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xbf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVSWQ")
    }
    return p
}

// MOVUPD performs "Move Unaligned Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : MOVUPD
// Supported forms : (3 forms)
//
//    * MOVUPD xmm, xmm     [SSE2]
//    * MOVUPD m128, xmm    [SSE2]
//    * MOVUPD xmm, m128    [SSE2]
//
func (self *Program) MOVUPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVUPD", 2, Operands { v0, v1 })
    // MOVUPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x11)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVUPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x10)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVUPD xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x11)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVUPD")
    }
    return p
}

// MOVUPS performs "Move Unaligned Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : MOVUPS
// Supported forms : (3 forms)
//
//    * MOVUPS xmm, xmm     [SSE]
//    * MOVUPS m128, xmm    [SSE]
//    * MOVUPS xmm, m128    [SSE]
//
func (self *Program) MOVUPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVUPS", 2, Operands { v0, v1 })
    // MOVUPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x0f)
            m.emit(0x11)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // MOVUPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x10)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVUPS xmm, m128
    if isXMM(v0) && isM128(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x11)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVUPS")
    }
    return p
}

// MOVW performs "Move".
//
// Mnemonic        : MOV
// Supported forms : (5 forms)
//
//    * MOVW imm16, r16
//    * MOVW r16, r16
//    * MOVW m16, r16
//    * MOVW imm16, m16
//    * MOVW r16, m16
//
func (self *Program) MOVW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVW", 2, Operands { v0, v1 })
    // MOVW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc7)
            m.emit(0xc0 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xb8 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // MOVW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x89)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x8b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x8b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // MOVW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc7)
            m.mrsd(0, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // MOVW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x89)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVW")
    }
    return p
}

// MOVZBL performs "Move with Zero-Extend".
//
// Mnemonic        : MOVZX
// Supported forms : (2 forms)
//
//    * MOVZBL r8, r32
//    * MOVZBL m8, r32
//
func (self *Program) MOVZBL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVZBL", 2, Operands { v0, v1 })
    // MOVZBL r8, r32
    if isReg8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0xb6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVZBL m8, r32
    if isM8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xb6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVZBL")
    }
    return p
}

// MOVZBQ performs "Move with Zero-Extend".
//
// Mnemonic        : MOVZX
// Supported forms : (2 forms)
//
//    * MOVZBQ r8, r64
//    * MOVZBQ m8, r64
//
func (self *Program) MOVZBQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVZBQ", 2, Operands { v0, v1 })
    // MOVZBQ r8, r64
    if isReg8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xb6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVZBQ m8, r64
    if isM8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xb6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVZBQ")
    }
    return p
}

// MOVZBW performs "Move with Zero-Extend".
//
// Mnemonic        : MOVZX
// Supported forms : (2 forms)
//
//    * MOVZBW r8, r16
//    * MOVZBW m8, r16
//
func (self *Program) MOVZBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVZBW", 2, Operands { v0, v1 })
    // MOVZBW r8, r16
    if isReg8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0xb6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVZBW m8, r16
    if isM8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xb6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVZBW")
    }
    return p
}

// MOVZWL performs "Move with Zero-Extend".
//
// Mnemonic        : MOVZX
// Supported forms : (2 forms)
//
//    * MOVZWL r16, r32
//    * MOVZWL m16, r32
//
func (self *Program) MOVZWL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVZWL", 2, Operands { v0, v1 })
    // MOVZWL r16, r32
    if isReg16(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xb7)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVZWL m16, r32
    if isM16(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xb7)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVZWL")
    }
    return p
}

// MOVZWQ performs "Move with Zero-Extend".
//
// Mnemonic        : MOVZX
// Supported forms : (2 forms)
//
//    * MOVZWQ r16, r64
//    * MOVZWQ m16, r64
//
func (self *Program) MOVZWQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MOVZWQ", 2, Operands { v0, v1 })
    // MOVZWQ r16, r64
    if isReg16(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xb7)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MOVZWQ m16, r64
    if isM16(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xb7)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MOVZWQ")
    }
    return p
}

// MPSADBW performs "Compute Multiple Packed Sums of Absolute Difference".
//
// Mnemonic        : MPSADBW
// Supported forms : (2 forms)
//
//    * MPSADBW imm8, xmm, xmm     [SSE4.1]
//    * MPSADBW imm8, m128, xmm    [SSE4.1]
//
func (self *Program) MPSADBW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("MPSADBW", 3, Operands { v0, v1, v2 })
    // MPSADBW imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x42)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // MPSADBW imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x42)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for MPSADBW")
    }
    return p
}

// MULB performs "Unsigned Multiply".
//
// Mnemonic        : MUL
// Supported forms : (2 forms)
//
//    * MULB r8
//    * MULB m8
//
func (self *Program) MULB(v0 interface{}) *Instruction {
    p := self.alloc("MULB", 1, Operands { v0 })
    // MULB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xf6)
            m.emit(0xe0 | lcode(v[0]))
        })
    }
    // MULB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf6)
            m.mrsd(4, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULB")
    }
    return p
}

// MULL performs "Unsigned Multiply".
//
// Mnemonic        : MUL
// Supported forms : (2 forms)
//
//    * MULL r32
//    * MULL m32
//
func (self *Program) MULL(v0 interface{}) *Instruction {
    p := self.alloc("MULL", 1, Operands { v0 })
    // MULL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xe0 | lcode(v[0]))
        })
    }
    // MULL m32
    if isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(4, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULL")
    }
    return p
}

// MULPD performs "Multiply Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : MULPD
// Supported forms : (2 forms)
//
//    * MULPD xmm, xmm     [SSE2]
//    * MULPD m128, xmm    [SSE2]
//
func (self *Program) MULPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MULPD", 2, Operands { v0, v1 })
    // MULPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x59)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MULPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x59)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULPD")
    }
    return p
}

// MULPS performs "Multiply Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : MULPS
// Supported forms : (2 forms)
//
//    * MULPS xmm, xmm     [SSE]
//    * MULPS m128, xmm    [SSE]
//
func (self *Program) MULPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MULPS", 2, Operands { v0, v1 })
    // MULPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x59)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MULPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x59)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULPS")
    }
    return p
}

// MULQ performs "Unsigned Multiply".
//
// Mnemonic        : MUL
// Supported forms : (2 forms)
//
//    * MULQ r64
//    * MULQ m64
//
func (self *Program) MULQ(v0 interface{}) *Instruction {
    p := self.alloc("MULQ", 1, Operands { v0 })
    // MULQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xf7)
            m.emit(0xe0 | lcode(v[0]))
        })
    }
    // MULQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xf7)
            m.mrsd(4, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULQ")
    }
    return p
}

// MULSD performs "Multiply Scalar Double-Precision Floating-Point Values".
//
// Mnemonic        : MULSD
// Supported forms : (2 forms)
//
//    * MULSD xmm, xmm    [SSE2]
//    * MULSD m64, xmm    [SSE2]
//
func (self *Program) MULSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MULSD", 2, Operands { v0, v1 })
    // MULSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x59)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MULSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x59)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULSD")
    }
    return p
}

// MULSS performs "Multiply Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : MULSS
// Supported forms : (2 forms)
//
//    * MULSS xmm, xmm    [SSE]
//    * MULSS m32, xmm    [SSE]
//
func (self *Program) MULSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("MULSS", 2, Operands { v0, v1 })
    // MULSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x59)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // MULSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x59)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULSS")
    }
    return p
}

// MULW performs "Unsigned Multiply".
//
// Mnemonic        : MUL
// Supported forms : (2 forms)
//
//    * MULW r16
//    * MULW m16
//
func (self *Program) MULW(v0 interface{}) *Instruction {
    p := self.alloc("MULW", 1, Operands { v0 })
    // MULW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xe0 | lcode(v[0]))
        })
    }
    // MULW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(4, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULW")
    }
    return p
}

// MULXL performs "Unsigned Multiply Without Affecting Flags".
//
// Mnemonic        : MULX
// Supported forms : (2 forms)
//
//    * MULXL r32, r32, r32    [BMI2]
//    * MULXL m32, r32, r32    [BMI2]
//
func (self *Program) MULXL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("MULXL", 3, Operands { v0, v1, v2 })
    // MULXL r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x7b ^ (hlcode(v[1]) << 3))
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // MULXL m32, r32, r32
    if isM32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x03, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf6)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULXL")
    }
    return p
}

// MULXQ performs "Unsigned Multiply Without Affecting Flags".
//
// Mnemonic        : MULX
// Supported forms : (2 forms)
//
//    * MULXQ r64, r64, r64    [BMI2]
//    * MULXQ m64, r64, r64    [BMI2]
//
func (self *Program) MULXQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("MULXQ", 3, Operands { v0, v1, v2 })
    // MULXQ r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0xfb ^ (hlcode(v[1]) << 3))
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // MULXQ m64, r64, r64
    if isM64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x83, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf6)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for MULXQ")
    }
    return p
}

// MWAIT performs "Monitor Wait".
//
// Mnemonic        : MWAIT
// Supported forms : (1 form)
//
//    * MWAIT    [MONITOR]
//
func (self *Program) MWAIT() *Instruction {
    p := self.alloc("MWAIT", 0, Operands {  })
    // MWAIT
    self.require(ISA_MONITOR)
    p.domain = DomainMisc
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x01)
        m.emit(0xc9)
    })
    return p
}

// MWAITX performs "Monitor Wait with Timeout".
//
// Mnemonic        : MWAITX
// Supported forms : (1 form)
//
//    * MWAITX    [MONITORX]
//
func (self *Program) MWAITX() *Instruction {
    p := self.alloc("MWAITX", 0, Operands {  })
    // MWAITX
    self.require(ISA_MONITORX)
    p.domain = DomainMisc
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x01)
        m.emit(0xfb)
    })
    return p
}

// NEGB performs "Two's Complement Negation".
//
// Mnemonic        : NEG
// Supported forms : (2 forms)
//
//    * NEGB r8
//    * NEGB m8
//
func (self *Program) NEGB(v0 interface{}) *Instruction {
    p := self.alloc("NEGB", 1, Operands { v0 })
    // NEGB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xf6)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // NEGB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf6)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NEGB")
    }
    return p
}

// NEGL performs "Two's Complement Negation".
//
// Mnemonic        : NEG
// Supported forms : (2 forms)
//
//    * NEGL r32
//    * NEGL m32
//
func (self *Program) NEGL(v0 interface{}) *Instruction {
    p := self.alloc("NEGL", 1, Operands { v0 })
    // NEGL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // NEGL m32
    if isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NEGL")
    }
    return p
}

// NEGQ performs "Two's Complement Negation".
//
// Mnemonic        : NEG
// Supported forms : (2 forms)
//
//    * NEGQ r64
//    * NEGQ m64
//
func (self *Program) NEGQ(v0 interface{}) *Instruction {
    p := self.alloc("NEGQ", 1, Operands { v0 })
    // NEGQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xf7)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // NEGQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xf7)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NEGQ")
    }
    return p
}

// NEGW performs "Two's Complement Negation".
//
// Mnemonic        : NEG
// Supported forms : (2 forms)
//
//    * NEGW r16
//    * NEGW m16
//
func (self *Program) NEGW(v0 interface{}) *Instruction {
    p := self.alloc("NEGW", 1, Operands { v0 })
    // NEGW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xd8 | lcode(v[0]))
        })
    }
    // NEGW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NEGW")
    }
    return p
}

// NOP performs "No Operation".
//
// Mnemonic        : NOP
// Supported forms : (1 form)
//
//    * NOP
//
func (self *Program) NOP() *Instruction {
    p := self.alloc("NOP", 0, Operands {  })
    // NOP
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x90)
    })
    return p
}

// NOTB performs "One's Complement Negation".
//
// Mnemonic        : NOT
// Supported forms : (2 forms)
//
//    * NOTB r8
//    * NOTB m8
//
func (self *Program) NOTB(v0 interface{}) *Instruction {
    p := self.alloc("NOTB", 1, Operands { v0 })
    // NOTB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0xf6)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // NOTB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf6)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NOTB")
    }
    return p
}

// NOTL performs "One's Complement Negation".
//
// Mnemonic        : NOT
// Supported forms : (2 forms)
//
//    * NOTL r32
//    * NOTL m32
//
func (self *Program) NOTL(v0 interface{}) *Instruction {
    p := self.alloc("NOTL", 1, Operands { v0 })
    // NOTL r32
    if isReg32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // NOTL m32
    if isM32(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NOTL")
    }
    return p
}

// NOTQ performs "One's Complement Negation".
//
// Mnemonic        : NOT
// Supported forms : (2 forms)
//
//    * NOTQ r64
//    * NOTQ m64
//
func (self *Program) NOTQ(v0 interface{}) *Instruction {
    p := self.alloc("NOTQ", 1, Operands { v0 })
    // NOTQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0xf7)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // NOTQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[0]))
            m.emit(0xf7)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NOTQ")
    }
    return p
}

// NOTW performs "One's Complement Negation".
//
// Mnemonic        : NOT
// Supported forms : (2 forms)
//
//    * NOTW r16
//    * NOTW m16
//
func (self *Program) NOTW(v0 interface{}) *Instruction {
    p := self.alloc("NOTW", 1, Operands { v0 })
    // NOTW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xf7)
            m.emit(0xd0 | lcode(v[0]))
        })
    }
    // NOTW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xf7)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for NOTW")
    }
    return p
}

// ORB performs "Logical Inclusive OR".
//
// Mnemonic        : OR
// Supported forms : (6 forms)
//
//    * ORB imm8, al
//    * ORB imm8, r8
//    * ORB r8, r8
//    * ORB m8, r8
//    * ORB imm8, m8
//    * ORB r8, m8
//
func (self *Program) ORB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ORB", 2, Operands { v0, v1 })
    // ORB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0c)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0x80)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x08)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x0a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ORB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x0a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ORB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x80)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x08)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ORB")
    }
    return p
}

// ORL performs "Logical Inclusive OR".
//
// Mnemonic        : OR
// Supported forms : (8 forms)
//
//    * ORL imm32, eax
//    * ORL imm8, r32
//    * ORL imm32, r32
//    * ORL r32, r32
//    * ORL m32, r32
//    * ORL imm8, m32
//    * ORL imm32, m32
//    * ORL r32, m32
//
func (self *Program) ORL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ORL", 2, Operands { v0, v1 })
    // ORL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x0d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ORL imm8, r32
    if isImm8Ext(v0, 4) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xc8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ORL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x09)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ORL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ORL imm8, m32
    if isImm8Ext(v0, 4) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(1, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ORL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x09)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ORL")
    }
    return p
}

// ORPD performs "Bitwise Logical OR of Double-Precision Floating-Point Values".
//
// Mnemonic        : ORPD
// Supported forms : (2 forms)
//
//    * ORPD xmm, xmm     [SSE2]
//    * ORPD m128, xmm    [SSE2]
//
func (self *Program) ORPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ORPD", 2, Operands { v0, v1 })
    // ORPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x56)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ORPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x56)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ORPD")
    }
    return p
}

// ORPS performs "Bitwise Logical OR of Single-Precision Floating-Point Values".
//
// Mnemonic        : ORPS
// Supported forms : (2 forms)
//
//    * ORPS xmm, xmm     [SSE]
//    * ORPS m128, xmm    [SSE]
//
func (self *Program) ORPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ORPS", 2, Operands { v0, v1 })
    // ORPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x56)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ORPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x56)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ORPS")
    }
    return p
}

// ORQ performs "Logical Inclusive OR".
//
// Mnemonic        : OR
// Supported forms : (8 forms)
//
//    * ORQ imm32, rax
//    * ORQ imm8, r64
//    * ORQ imm32, r64
//    * ORQ r64, r64
//    * ORQ m64, r64
//    * ORQ imm8, m64
//    * ORQ imm32, m64
//    * ORQ r64, m64
//
func (self *Program) ORQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ORQ", 2, Operands { v0, v1 })
    // ORQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0x0d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ORQ imm8, r64
    if isImm8Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x83)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x81)
            m.emit(0xc8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // ORQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x09)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ORQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ORQ imm8, m64
    if isImm8Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x83)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x81)
            m.mrsd(1, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // ORQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x09)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ORQ")
    }
    return p
}

// ORW performs "Logical Inclusive OR".
//
// Mnemonic        : OR
// Supported forms : (8 forms)
//
//    * ORW imm16, ax
//    * ORW imm8, r16
//    * ORW imm16, r16
//    * ORW r16, r16
//    * ORW m16, r16
//    * ORW imm8, m16
//    * ORW imm16, m16
//    * ORW r16, m16
//
func (self *Program) ORW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ORW", 2, Operands { v0, v1 })
    // ORW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x0d)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ORW imm8, r16
    if isImm8Ext(v0, 2) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xc8 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // ORW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x09)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // ORW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // ORW imm8, m16
    if isImm8Ext(v0, 2) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ORW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(1, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // ORW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x09)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ORW")
    }
    return p
}

// PABSB performs "Packed Absolute Value of Byte Integers".
//
// Mnemonic        : PABSB
// Supported forms : (4 forms)
//
//    * PABSB mm, mm       [SSSE3]
//    * PABSB m64, mm      [SSSE3]
//    * PABSB xmm, xmm     [SSSE3]
//    * PABSB m128, xmm    [SSSE3]
//
func (self *Program) PABSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PABSB", 2, Operands { v0, v1 })
    // PABSB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PABSB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PABSB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PABSB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PABSB")
    }
    return p
}

// PABSD performs "Packed Absolute Value of Doubleword Integers".
//
// Mnemonic        : PABSD
// Supported forms : (4 forms)
//
//    * PABSD mm, mm       [SSSE3]
//    * PABSD m64, mm      [SSSE3]
//    * PABSD xmm, xmm     [SSSE3]
//    * PABSD m128, xmm    [SSSE3]
//
func (self *Program) PABSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PABSD", 2, Operands { v0, v1 })
    // PABSD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PABSD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PABSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PABSD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PABSD")
    }
    return p
}

// PABSW performs "Packed Absolute Value of Word Integers".
//
// Mnemonic        : PABSW
// Supported forms : (4 forms)
//
//    * PABSW mm, mm       [SSSE3]
//    * PABSW m64, mm      [SSSE3]
//    * PABSW xmm, xmm     [SSSE3]
//    * PABSW m128, xmm    [SSSE3]
//
func (self *Program) PABSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PABSW", 2, Operands { v0, v1 })
    // PABSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PABSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PABSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PABSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x1d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PABSW")
    }
    return p
}

// PACKSSDW performs "Pack Doublewords into Words with Signed Saturation".
//
// Mnemonic        : PACKSSDW
// Supported forms : (4 forms)
//
//    * PACKSSDW mm, mm       [MMX]
//    * PACKSSDW m64, mm      [MMX]
//    * PACKSSDW xmm, xmm     [SSE2]
//    * PACKSSDW m128, xmm    [SSE2]
//
func (self *Program) PACKSSDW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PACKSSDW", 2, Operands { v0, v1 })
    // PACKSSDW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PACKSSDW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PACKSSDW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PACKSSDW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PACKSSDW")
    }
    return p
}

// PACKSSWB performs "Pack Words into Bytes with Signed Saturation".
//
// Mnemonic        : PACKSSWB
// Supported forms : (4 forms)
//
//    * PACKSSWB mm, mm       [MMX]
//    * PACKSSWB m64, mm      [MMX]
//    * PACKSSWB xmm, xmm     [SSE2]
//    * PACKSSWB m128, xmm    [SSE2]
//
func (self *Program) PACKSSWB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PACKSSWB", 2, Operands { v0, v1 })
    // PACKSSWB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x63)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PACKSSWB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x63)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PACKSSWB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x63)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PACKSSWB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x63)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PACKSSWB")
    }
    return p
}

// PACKUSDW performs "Pack Doublewords into Words with Unsigned Saturation".
//
// Mnemonic        : PACKUSDW
// Supported forms : (2 forms)
//
//    * PACKUSDW xmm, xmm     [SSE4.1]
//    * PACKUSDW m128, xmm    [SSE4.1]
//
func (self *Program) PACKUSDW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PACKUSDW", 2, Operands { v0, v1 })
    // PACKUSDW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x2b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PACKUSDW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x2b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PACKUSDW")
    }
    return p
}

// PACKUSWB performs "Pack Words into Bytes with Unsigned Saturation".
//
// Mnemonic        : PACKUSWB
// Supported forms : (4 forms)
//
//    * PACKUSWB mm, mm       [MMX]
//    * PACKUSWB m64, mm      [MMX]
//    * PACKUSWB xmm, xmm     [SSE2]
//    * PACKUSWB m128, xmm    [SSE2]
//
func (self *Program) PACKUSWB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PACKUSWB", 2, Operands { v0, v1 })
    // PACKUSWB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x67)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PACKUSWB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x67)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PACKUSWB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x67)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PACKUSWB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x67)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PACKUSWB")
    }
    return p
}

// PADDB performs "Add Packed Byte Integers".
//
// Mnemonic        : PADDB
// Supported forms : (4 forms)
//
//    * PADDB mm, mm       [MMX]
//    * PADDB m64, mm      [MMX]
//    * PADDB xmm, xmm     [SSE2]
//    * PADDB m128, xmm    [SSE2]
//
func (self *Program) PADDB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDB", 2, Operands { v0, v1 })
    // PADDB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDB")
    }
    return p
}

// PADDD performs "Add Packed Doubleword Integers".
//
// Mnemonic        : PADDD
// Supported forms : (4 forms)
//
//    * PADDD mm, mm       [MMX]
//    * PADDD m64, mm      [MMX]
//    * PADDD xmm, xmm     [SSE2]
//    * PADDD m128, xmm    [SSE2]
//
func (self *Program) PADDD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDD", 2, Operands { v0, v1 })
    // PADDD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfe)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfe)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfe)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfe)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDD")
    }
    return p
}

// PADDQ performs "Add Packed Quadword Integers".
//
// Mnemonic        : PADDQ
// Supported forms : (4 forms)
//
//    * PADDQ mm, mm       [SSE2]
//    * PADDQ m64, mm      [SSE2]
//    * PADDQ xmm, xmm     [SSE2]
//    * PADDQ m128, xmm    [SSE2]
//
func (self *Program) PADDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDQ", 2, Operands { v0, v1 })
    // PADDQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd4)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd4)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDQ")
    }
    return p
}

// PADDSB performs "Add Packed Signed Byte Integers with Signed Saturation".
//
// Mnemonic        : PADDSB
// Supported forms : (4 forms)
//
//    * PADDSB mm, mm       [MMX]
//    * PADDSB m64, mm      [MMX]
//    * PADDSB xmm, xmm     [SSE2]
//    * PADDSB m128, xmm    [SSE2]
//
func (self *Program) PADDSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDSB", 2, Operands { v0, v1 })
    // PADDSB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xec)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDSB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xec)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDSB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xec)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDSB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xec)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDSB")
    }
    return p
}

// PADDSW performs "Add Packed Signed Word Integers with Signed Saturation".
//
// Mnemonic        : PADDSW
// Supported forms : (4 forms)
//
//    * PADDSW mm, mm       [MMX]
//    * PADDSW m64, mm      [MMX]
//    * PADDSW xmm, xmm     [SSE2]
//    * PADDSW m128, xmm    [SSE2]
//
func (self *Program) PADDSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDSW", 2, Operands { v0, v1 })
    // PADDSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xed)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xed)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xed)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xed)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDSW")
    }
    return p
}

// PADDUSB performs "Add Packed Unsigned Byte Integers with Unsigned Saturation".
//
// Mnemonic        : PADDUSB
// Supported forms : (4 forms)
//
//    * PADDUSB mm, mm       [MMX]
//    * PADDUSB m64, mm      [MMX]
//    * PADDUSB xmm, xmm     [SSE2]
//    * PADDUSB m128, xmm    [SSE2]
//
func (self *Program) PADDUSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDUSB", 2, Operands { v0, v1 })
    // PADDUSB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDUSB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDUSB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDUSB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDUSB")
    }
    return p
}

// PADDUSW performs "Add Packed Unsigned Word Integers with Unsigned Saturation".
//
// Mnemonic        : PADDUSW
// Supported forms : (4 forms)
//
//    * PADDUSW mm, mm       [MMX]
//    * PADDUSW m64, mm      [MMX]
//    * PADDUSW xmm, xmm     [SSE2]
//    * PADDUSW m128, xmm    [SSE2]
//
func (self *Program) PADDUSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDUSW", 2, Operands { v0, v1 })
    // PADDUSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDUSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDUSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDUSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDUSW")
    }
    return p
}

// PADDW performs "Add Packed Word Integers".
//
// Mnemonic        : PADDW
// Supported forms : (4 forms)
//
//    * PADDW mm, mm       [MMX]
//    * PADDW m64, mm      [MMX]
//    * PADDW xmm, xmm     [SSE2]
//    * PADDW m128, xmm    [SSE2]
//
func (self *Program) PADDW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PADDW", 2, Operands { v0, v1 })
    // PADDW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PADDW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PADDW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PADDW")
    }
    return p
}

// PALIGNR performs "Packed Align Right".
//
// Mnemonic        : PALIGNR
// Supported forms : (4 forms)
//
//    * PALIGNR imm8, mm, mm       [SSSE3]
//    * PALIGNR imm8, m64, mm      [SSSE3]
//    * PALIGNR imm8, xmm, xmm     [SSSE3]
//    * PALIGNR imm8, m128, xmm    [SSSE3]
//
func (self *Program) PALIGNR(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PALIGNR", 3, Operands { v0, v1, v2 })
    // PALIGNR imm8, mm, mm
    if isImm8(v0) && isMM(v1) && isMM(v2) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PALIGNR imm8, m64, mm
    if isImm8(v0) && isM64(v1) && isMM(v2) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0f)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // PALIGNR imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PALIGNR imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0f)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PALIGNR")
    }
    return p
}

// PAND performs "Packed Bitwise Logical AND".
//
// Mnemonic        : PAND
// Supported forms : (4 forms)
//
//    * PAND mm, mm       [MMX]
//    * PAND m64, mm      [MMX]
//    * PAND xmm, xmm     [SSE2]
//    * PAND m128, xmm    [SSE2]
//
func (self *Program) PAND(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PAND", 2, Operands { v0, v1 })
    // PAND mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PAND m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PAND xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PAND m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PAND")
    }
    return p
}

// PANDN performs "Packed Bitwise Logical AND NOT".
//
// Mnemonic        : PANDN
// Supported forms : (4 forms)
//
//    * PANDN mm, mm       [MMX]
//    * PANDN m64, mm      [MMX]
//    * PANDN xmm, xmm     [SSE2]
//    * PANDN m128, xmm    [SSE2]
//
func (self *Program) PANDN(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PANDN", 2, Operands { v0, v1 })
    // PANDN mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PANDN m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PANDN xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xdf)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PANDN m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xdf)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PANDN")
    }
    return p
}

// PAUSE performs "Spin Loop Hint".
//
// Mnemonic        : PAUSE
// Supported forms : (1 form)
//
//    * PAUSE
//
func (self *Program) PAUSE() *Instruction {
    p := self.alloc("PAUSE", 0, Operands {  })
    // PAUSE
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0xf3)
        m.emit(0x90)
    })
    return p
}

// PAVGB performs "Average Packed Byte Integers".
//
// Mnemonic        : PAVGB
// Supported forms : (4 forms)
//
//    * PAVGB mm, mm       [MMX+]
//    * PAVGB m64, mm      [MMX+]
//    * PAVGB xmm, xmm     [SSE2]
//    * PAVGB m128, xmm    [SSE2]
//
func (self *Program) PAVGB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PAVGB", 2, Operands { v0, v1 })
    // PAVGB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe0)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PAVGB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PAVGB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe0)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PAVGB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe0)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PAVGB")
    }
    return p
}

// PAVGUSB performs "Average Packed Byte Integers".
//
// Mnemonic        : PAVGUSB
// Supported forms : (2 forms)
//
//    * PAVGUSB mm, mm     [3dnow!]
//    * PAVGUSB m64, mm    [3dnow!]
//
func (self *Program) PAVGUSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PAVGUSB", 2, Operands { v0, v1 })
    // PAVGUSB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xbf)
        })
    }
    // PAVGUSB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xbf)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PAVGUSB")
    }
    return p
}

// PAVGW performs "Average Packed Word Integers".
//
// Mnemonic        : PAVGW
// Supported forms : (4 forms)
//
//    * PAVGW mm, mm       [MMX+]
//    * PAVGW m64, mm      [MMX+]
//    * PAVGW xmm, xmm     [SSE2]
//    * PAVGW m128, xmm    [SSE2]
//
func (self *Program) PAVGW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PAVGW", 2, Operands { v0, v1 })
    // PAVGW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe3)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PAVGW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe3)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PAVGW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe3)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PAVGW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe3)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PAVGW")
    }
    return p
}

// PBLENDVB performs "Variable Blend Packed Bytes".
//
// Mnemonic        : PBLENDVB
// Supported forms : (2 forms)
//
//    * PBLENDVB xmm0, xmm, xmm     [SSE4.1]
//    * PBLENDVB xmm0, m128, xmm    [SSE4.1]
//
func (self *Program) PBLENDVB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PBLENDVB", 3, Operands { v0, v1, v2 })
    // PBLENDVB xmm0, xmm, xmm
    if v0 == XMM0 && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x10)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // PBLENDVB xmm0, m128, xmm
    if v0 == XMM0 && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x10)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PBLENDVB")
    }
    return p
}

// PBLENDW performs "Blend Packed Words".
//
// Mnemonic        : PBLENDW
// Supported forms : (2 forms)
//
//    * PBLENDW imm8, xmm, xmm     [SSE4.1]
//    * PBLENDW imm8, m128, xmm    [SSE4.1]
//
func (self *Program) PBLENDW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PBLENDW", 3, Operands { v0, v1, v2 })
    // PBLENDW imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0e)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PBLENDW imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0e)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PBLENDW")
    }
    return p
}

// PCLMULQDQ performs "Carry-Less Quadword Multiplication".
//
// Mnemonic        : PCLMULQDQ
// Supported forms : (2 forms)
//
//    * PCLMULQDQ imm8, xmm, xmm     [PCLMULQDQ]
//    * PCLMULQDQ imm8, m128, xmm    [PCLMULQDQ]
//
func (self *Program) PCLMULQDQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PCLMULQDQ", 3, Operands { v0, v1, v2 })
    // PCLMULQDQ imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_PCLMULQDQ)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x44)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PCLMULQDQ imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_PCLMULQDQ)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x44)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCLMULQDQ")
    }
    return p
}

// PCMPEQB performs "Compare Packed Byte Data for Equality".
//
// Mnemonic        : PCMPEQB
// Supported forms : (4 forms)
//
//    * PCMPEQB mm, mm       [MMX]
//    * PCMPEQB m64, mm      [MMX]
//    * PCMPEQB xmm, xmm     [SSE2]
//    * PCMPEQB m128, xmm    [SSE2]
//
func (self *Program) PCMPEQB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPEQB", 2, Operands { v0, v1 })
    // PCMPEQB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x74)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPEQB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x74)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PCMPEQB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x74)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPEQB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x74)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPEQB")
    }
    return p
}

// PCMPEQD performs "Compare Packed Doubleword Data for Equality".
//
// Mnemonic        : PCMPEQD
// Supported forms : (4 forms)
//
//    * PCMPEQD mm, mm       [MMX]
//    * PCMPEQD m64, mm      [MMX]
//    * PCMPEQD xmm, xmm     [SSE2]
//    * PCMPEQD m128, xmm    [SSE2]
//
func (self *Program) PCMPEQD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPEQD", 2, Operands { v0, v1 })
    // PCMPEQD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x76)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPEQD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x76)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PCMPEQD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x76)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPEQD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x76)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPEQD")
    }
    return p
}

// PCMPEQQ performs "Compare Packed Quadword Data for Equality".
//
// Mnemonic        : PCMPEQQ
// Supported forms : (2 forms)
//
//    * PCMPEQQ xmm, xmm     [SSE4.1]
//    * PCMPEQQ m128, xmm    [SSE4.1]
//
func (self *Program) PCMPEQQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPEQQ", 2, Operands { v0, v1 })
    // PCMPEQQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x29)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPEQQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x29)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPEQQ")
    }
    return p
}

// PCMPEQW performs "Compare Packed Word Data for Equality".
//
// Mnemonic        : PCMPEQW
// Supported forms : (4 forms)
//
//    * PCMPEQW mm, mm       [MMX]
//    * PCMPEQW m64, mm      [MMX]
//    * PCMPEQW xmm, xmm     [SSE2]
//    * PCMPEQW m128, xmm    [SSE2]
//
func (self *Program) PCMPEQW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPEQW", 2, Operands { v0, v1 })
    // PCMPEQW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x75)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPEQW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x75)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PCMPEQW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x75)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPEQW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x75)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPEQW")
    }
    return p
}

// PCMPESTRI performs "Packed Compare Explicit Length Strings, Return Index".
//
// Mnemonic        : PCMPESTRI
// Supported forms : (2 forms)
//
//    * PCMPESTRI imm8, xmm, xmm     [SSE4.2]
//    * PCMPESTRI imm8, m128, xmm    [SSE4.2]
//
func (self *Program) PCMPESTRI(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PCMPESTRI", 3, Operands { v0, v1, v2 })
    // PCMPESTRI imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x61)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PCMPESTRI imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x61)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPESTRI")
    }
    return p
}

// PCMPESTRM performs "Packed Compare Explicit Length Strings, Return Mask".
//
// Mnemonic        : PCMPESTRM
// Supported forms : (2 forms)
//
//    * PCMPESTRM imm8, xmm, xmm     [SSE4.2]
//    * PCMPESTRM imm8, m128, xmm    [SSE4.2]
//
func (self *Program) PCMPESTRM(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PCMPESTRM", 3, Operands { v0, v1, v2 })
    // PCMPESTRM imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x60)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PCMPESTRM imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x60)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPESTRM")
    }
    return p
}

// PCMPGTB performs "Compare Packed Signed Byte Integers for Greater Than".
//
// Mnemonic        : PCMPGTB
// Supported forms : (4 forms)
//
//    * PCMPGTB mm, mm       [MMX]
//    * PCMPGTB m64, mm      [MMX]
//    * PCMPGTB xmm, xmm     [SSE2]
//    * PCMPGTB m128, xmm    [SSE2]
//
func (self *Program) PCMPGTB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPGTB", 2, Operands { v0, v1 })
    // PCMPGTB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x64)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPGTB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x64)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PCMPGTB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x64)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPGTB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x64)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPGTB")
    }
    return p
}

// PCMPGTD performs "Compare Packed Signed Doubleword Integers for Greater Than".
//
// Mnemonic        : PCMPGTD
// Supported forms : (4 forms)
//
//    * PCMPGTD mm, mm       [MMX]
//    * PCMPGTD m64, mm      [MMX]
//    * PCMPGTD xmm, xmm     [SSE2]
//    * PCMPGTD m128, xmm    [SSE2]
//
func (self *Program) PCMPGTD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPGTD", 2, Operands { v0, v1 })
    // PCMPGTD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x66)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPGTD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x66)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PCMPGTD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x66)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPGTD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x66)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPGTD")
    }
    return p
}

// PCMPGTQ performs "Compare Packed Data for Greater Than".
//
// Mnemonic        : PCMPGTQ
// Supported forms : (2 forms)
//
//    * PCMPGTQ xmm, xmm     [SSE4.2]
//    * PCMPGTQ m128, xmm    [SSE4.2]
//
func (self *Program) PCMPGTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPGTQ", 2, Operands { v0, v1 })
    // PCMPGTQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x37)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPGTQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x37)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPGTQ")
    }
    return p
}

// PCMPGTW performs "Compare Packed Signed Word Integers for Greater Than".
//
// Mnemonic        : PCMPGTW
// Supported forms : (4 forms)
//
//    * PCMPGTW mm, mm       [MMX]
//    * PCMPGTW m64, mm      [MMX]
//    * PCMPGTW xmm, xmm     [SSE2]
//    * PCMPGTW m128, xmm    [SSE2]
//
func (self *Program) PCMPGTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PCMPGTW", 2, Operands { v0, v1 })
    // PCMPGTW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x65)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPGTW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x65)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PCMPGTW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x65)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PCMPGTW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x65)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPGTW")
    }
    return p
}

// PCMPISTRI performs "Packed Compare Implicit Length Strings, Return Index".
//
// Mnemonic        : PCMPISTRI
// Supported forms : (2 forms)
//
//    * PCMPISTRI imm8, xmm, xmm     [SSE4.2]
//    * PCMPISTRI imm8, m128, xmm    [SSE4.2]
//
func (self *Program) PCMPISTRI(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PCMPISTRI", 3, Operands { v0, v1, v2 })
    // PCMPISTRI imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x63)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PCMPISTRI imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x63)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPISTRI")
    }
    return p
}

// PCMPISTRM performs "Packed Compare Implicit Length Strings, Return Mask".
//
// Mnemonic        : PCMPISTRM
// Supported forms : (2 forms)
//
//    * PCMPISTRM imm8, xmm, xmm     [SSE4.2]
//    * PCMPISTRM imm8, m128, xmm    [SSE4.2]
//
func (self *Program) PCMPISTRM(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PCMPISTRM", 3, Operands { v0, v1, v2 })
    // PCMPISTRM imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x62)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PCMPISTRM imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x62)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PCMPISTRM")
    }
    return p
}

// PDEP performs "Parallel Bits Deposit".
//
// Mnemonic        : PDEP
// Supported forms : (4 forms)
//
//    * PDEP r32, r32, r32    [BMI2]
//    * PDEP m32, r32, r32    [BMI2]
//    * PDEP r64, r64, r64    [BMI2]
//    * PDEP m64, r64, r64    [BMI2]
//
func (self *Program) PDEP(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PDEP", 3, Operands { v0, v1, v2 })
    // PDEP r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x7b ^ (hlcode(v[1]) << 3))
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // PDEP m32, r32, r32
    if isM32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x03, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf5)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // PDEP r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0xfb ^ (hlcode(v[1]) << 3))
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // PDEP m64, r64, r64
    if isM64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x83, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf5)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PDEP")
    }
    return p
}

// PEXT performs "Parallel Bits Extract".
//
// Mnemonic        : PEXT
// Supported forms : (4 forms)
//
//    * PEXT r32, r32, r32    [BMI2]
//    * PEXT m32, r32, r32    [BMI2]
//    * PEXT r64, r64, r64    [BMI2]
//    * PEXT m64, r64, r64    [BMI2]
//
func (self *Program) PEXT(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PEXT", 3, Operands { v0, v1, v2 })
    // PEXT r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x7a ^ (hlcode(v[1]) << 3))
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // PEXT m32, r32, r32
    if isM32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x02, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf5)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // PEXT r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0xfa ^ (hlcode(v[1]) << 3))
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // PEXT m64, r64, r64
    if isM64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x82, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xf5)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PEXT")
    }
    return p
}

// PEXTRB performs "Extract Byte".
//
// Mnemonic        : PEXTRB
// Supported forms : (2 forms)
//
//    * PEXTRB imm8, xmm, r32    [SSE4.1]
//    * PEXTRB imm8, xmm, m8     [SSE4.1]
//
func (self *Program) PEXTRB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PEXTRB", 3, Operands { v0, v1, v2 })
    // PEXTRB imm8, xmm, r32
    if isImm8(v0) && isXMM(v1) && isReg32(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x14)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PEXTRB imm8, xmm, m8
    if isImm8(v0) && isXMM(v1) && isM8(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x14)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PEXTRB")
    }
    return p
}

// PEXTRD performs "Extract Doubleword".
//
// Mnemonic        : PEXTRD
// Supported forms : (2 forms)
//
//    * PEXTRD imm8, xmm, r32    [SSE4.1]
//    * PEXTRD imm8, xmm, m32    [SSE4.1]
//
func (self *Program) PEXTRD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PEXTRD", 3, Operands { v0, v1, v2 })
    // PEXTRD imm8, xmm, r32
    if isImm8(v0) && isXMM(v1) && isReg32(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x16)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PEXTRD imm8, xmm, m32
    if isImm8(v0) && isXMM(v1) && isM32(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x16)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PEXTRD")
    }
    return p
}

// PEXTRQ performs "Extract Quadword".
//
// Mnemonic        : PEXTRQ
// Supported forms : (2 forms)
//
//    * PEXTRQ imm8, xmm, r64    [SSE4.1]
//    * PEXTRQ imm8, xmm, m64    [SSE4.1]
//
func (self *Program) PEXTRQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PEXTRQ", 3, Operands { v0, v1, v2 })
    // PEXTRQ imm8, xmm, r64
    if isImm8(v0) && isXMM(v1) && isReg64(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[2]))
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x16)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PEXTRQ imm8, xmm, m64
    if isImm8(v0) && isXMM(v1) && isM64(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexm(1, hcode(v[1]), addr(v[2]))
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x16)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PEXTRQ")
    }
    return p
}

// PEXTRW performs "Extract Word".
//
// Mnemonic        : PEXTRW
// Supported forms : (3 forms)
//
//    * PEXTRW imm8, mm, r32     [MMX+]
//    * PEXTRW imm8, xmm, r32    [SSE4.1]
//    * PEXTRW imm8, xmm, m16    [SSE4.1]
//
func (self *Program) PEXTRW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PEXTRW", 3, Operands { v0, v1, v2 })
    // PEXTRW imm8, mm, r32
    if isImm8(v0) && isMM(v1) && isReg32(v2) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PEXTRW imm8, xmm, r32
    if isImm8(v0) && isXMM(v1) && isReg32(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x15)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc5)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PEXTRW imm8, xmm, m16
    if isImm8(v0) && isXMM(v1) && isM16(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x15)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PEXTRW")
    }
    return p
}

// PF2ID performs "Packed Floating-Point to Integer Doubleword Converson".
//
// Mnemonic        : PF2ID
// Supported forms : (2 forms)
//
//    * PF2ID mm, mm     [3dnow!]
//    * PF2ID m64, mm    [3dnow!]
//
func (self *Program) PF2ID(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PF2ID", 2, Operands { v0, v1 })
    // PF2ID mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x1d)
        })
    }
    // PF2ID m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x1d)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PF2ID")
    }
    return p
}

// PF2IW performs "Packed Floating-Point to Integer Word Conversion".
//
// Mnemonic        : PF2IW
// Supported forms : (2 forms)
//
//    * PF2IW mm, mm     [3dnow!+]
//    * PF2IW m64, mm    [3dnow!+]
//
func (self *Program) PF2IW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PF2IW", 2, Operands { v0, v1 })
    // PF2IW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x1c)
        })
    }
    // PF2IW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x1c)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PF2IW")
    }
    return p
}

// PFACC performs "Packed Floating-Point Accumulate".
//
// Mnemonic        : PFACC
// Supported forms : (2 forms)
//
//    * PFACC mm, mm     [3dnow!]
//    * PFACC m64, mm    [3dnow!]
//
func (self *Program) PFACC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFACC", 2, Operands { v0, v1 })
    // PFACC mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xae)
        })
    }
    // PFACC m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xae)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFACC")
    }
    return p
}

// PFADD performs "Packed Floating-Point Add".
//
// Mnemonic        : PFADD
// Supported forms : (2 forms)
//
//    * PFADD mm, mm     [3dnow!]
//    * PFADD m64, mm    [3dnow!]
//
func (self *Program) PFADD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFADD", 2, Operands { v0, v1 })
    // PFADD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x9e)
        })
    }
    // PFADD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x9e)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFADD")
    }
    return p
}

// PFCMPEQ performs "Packed Floating-Point Compare for Equal".
//
// Mnemonic        : PFCMPEQ
// Supported forms : (2 forms)
//
//    * PFCMPEQ mm, mm     [3dnow!]
//    * PFCMPEQ m64, mm    [3dnow!]
//
func (self *Program) PFCMPEQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFCMPEQ", 2, Operands { v0, v1 })
    // PFCMPEQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xb0)
        })
    }
    // PFCMPEQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xb0)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFCMPEQ")
    }
    return p
}

// PFCMPGE performs "Packed Floating-Point Compare for Greater or Equal".
//
// Mnemonic        : PFCMPGE
// Supported forms : (2 forms)
//
//    * PFCMPGE mm, mm     [3dnow!]
//    * PFCMPGE m64, mm    [3dnow!]
//
func (self *Program) PFCMPGE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFCMPGE", 2, Operands { v0, v1 })
    // PFCMPGE mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x90)
        })
    }
    // PFCMPGE m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x90)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFCMPGE")
    }
    return p
}

// PFCMPGT performs "Packed Floating-Point Compare for Greater Than".
//
// Mnemonic        : PFCMPGT
// Supported forms : (2 forms)
//
//    * PFCMPGT mm, mm     [3dnow!]
//    * PFCMPGT m64, mm    [3dnow!]
//
func (self *Program) PFCMPGT(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFCMPGT", 2, Operands { v0, v1 })
    // PFCMPGT mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xa0)
        })
    }
    // PFCMPGT m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xa0)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFCMPGT")
    }
    return p
}

// PFMAX performs "Packed Floating-Point Maximum".
//
// Mnemonic        : PFMAX
// Supported forms : (2 forms)
//
//    * PFMAX mm, mm     [3dnow!]
//    * PFMAX m64, mm    [3dnow!]
//
func (self *Program) PFMAX(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFMAX", 2, Operands { v0, v1 })
    // PFMAX mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xa4)
        })
    }
    // PFMAX m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xa4)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFMAX")
    }
    return p
}

// PFMIN performs "Packed Floating-Point Minimum".
//
// Mnemonic        : PFMIN
// Supported forms : (2 forms)
//
//    * PFMIN mm, mm     [3dnow!]
//    * PFMIN m64, mm    [3dnow!]
//
func (self *Program) PFMIN(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFMIN", 2, Operands { v0, v1 })
    // PFMIN mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x94)
        })
    }
    // PFMIN m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x94)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFMIN")
    }
    return p
}

// PFMUL performs "Packed Floating-Point Multiply".
//
// Mnemonic        : PFMUL
// Supported forms : (2 forms)
//
//    * PFMUL mm, mm     [3dnow!]
//    * PFMUL m64, mm    [3dnow!]
//
func (self *Program) PFMUL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFMUL", 2, Operands { v0, v1 })
    // PFMUL mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xb4)
        })
    }
    // PFMUL m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xb4)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFMUL")
    }
    return p
}

// PFNACC performs "Packed Floating-Point Negative Accumulate".
//
// Mnemonic        : PFNACC
// Supported forms : (2 forms)
//
//    * PFNACC mm, mm     [3dnow!+]
//    * PFNACC m64, mm    [3dnow!+]
//
func (self *Program) PFNACC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFNACC", 2, Operands { v0, v1 })
    // PFNACC mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x8a)
        })
    }
    // PFNACC m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x8a)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFNACC")
    }
    return p
}

// PFPNACC performs "Packed Floating-Point Positive-Negative Accumulate".
//
// Mnemonic        : PFPNACC
// Supported forms : (2 forms)
//
//    * PFPNACC mm, mm     [3dnow!+]
//    * PFPNACC m64, mm    [3dnow!+]
//
func (self *Program) PFPNACC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFPNACC", 2, Operands { v0, v1 })
    // PFPNACC mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x8e)
        })
    }
    // PFPNACC m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x8e)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFPNACC")
    }
    return p
}

// PFRCP performs "Packed Floating-Point Reciprocal Approximation".
//
// Mnemonic        : PFRCP
// Supported forms : (2 forms)
//
//    * PFRCP mm, mm     [3dnow!]
//    * PFRCP m64, mm    [3dnow!]
//
func (self *Program) PFRCP(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFRCP", 2, Operands { v0, v1 })
    // PFRCP mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x96)
        })
    }
    // PFRCP m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x96)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFRCP")
    }
    return p
}

// PFRCPIT1 performs "Packed Floating-Point Reciprocal Iteration 1".
//
// Mnemonic        : PFRCPIT1
// Supported forms : (2 forms)
//
//    * PFRCPIT1 mm, mm     [3dnow!]
//    * PFRCPIT1 m64, mm    [3dnow!]
//
func (self *Program) PFRCPIT1(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFRCPIT1", 2, Operands { v0, v1 })
    // PFRCPIT1 mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xa6)
        })
    }
    // PFRCPIT1 m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xa6)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFRCPIT1")
    }
    return p
}

// PFRCPIT2 performs "Packed Floating-Point Reciprocal Iteration 2".
//
// Mnemonic        : PFRCPIT2
// Supported forms : (2 forms)
//
//    * PFRCPIT2 mm, mm     [3dnow!]
//    * PFRCPIT2 m64, mm    [3dnow!]
//
func (self *Program) PFRCPIT2(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFRCPIT2", 2, Operands { v0, v1 })
    // PFRCPIT2 mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xb6)
        })
    }
    // PFRCPIT2 m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xb6)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFRCPIT2")
    }
    return p
}

// PFRSQIT1 performs "Packed Floating-Point Reciprocal Square Root Iteration 1".
//
// Mnemonic        : PFRSQIT1
// Supported forms : (2 forms)
//
//    * PFRSQIT1 mm, mm     [3dnow!]
//    * PFRSQIT1 m64, mm    [3dnow!]
//
func (self *Program) PFRSQIT1(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFRSQIT1", 2, Operands { v0, v1 })
    // PFRSQIT1 mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xa7)
        })
    }
    // PFRSQIT1 m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xa7)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFRSQIT1")
    }
    return p
}

// PFRSQRT performs "Packed Floating-Point Reciprocal Square Root Approximation".
//
// Mnemonic        : PFRSQRT
// Supported forms : (2 forms)
//
//    * PFRSQRT mm, mm     [3dnow!]
//    * PFRSQRT m64, mm    [3dnow!]
//
func (self *Program) PFRSQRT(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFRSQRT", 2, Operands { v0, v1 })
    // PFRSQRT mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x97)
        })
    }
    // PFRSQRT m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x97)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFRSQRT")
    }
    return p
}

// PFSUB performs "Packed Floating-Point Subtract".
//
// Mnemonic        : PFSUB
// Supported forms : (2 forms)
//
//    * PFSUB mm, mm     [3dnow!]
//    * PFSUB m64, mm    [3dnow!]
//
func (self *Program) PFSUB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFSUB", 2, Operands { v0, v1 })
    // PFSUB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x9a)
        })
    }
    // PFSUB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x9a)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFSUB")
    }
    return p
}

// PFSUBR performs "Packed Floating-Point Subtract Reverse".
//
// Mnemonic        : PFSUBR
// Supported forms : (2 forms)
//
//    * PFSUBR mm, mm     [3dnow!]
//    * PFSUBR m64, mm    [3dnow!]
//
func (self *Program) PFSUBR(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PFSUBR", 2, Operands { v0, v1 })
    // PFSUBR mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xaa)
        })
    }
    // PFSUBR m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xaa)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PFSUBR")
    }
    return p
}

// PHADDD performs "Packed Horizontal Add Doubleword Integer".
//
// Mnemonic        : PHADDD
// Supported forms : (4 forms)
//
//    * PHADDD mm, mm       [SSSE3]
//    * PHADDD m64, mm      [SSSE3]
//    * PHADDD xmm, xmm     [SSSE3]
//    * PHADDD m128, xmm    [SSSE3]
//
func (self *Program) PHADDD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PHADDD", 2, Operands { v0, v1 })
    // PHADDD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x02)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHADDD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x02)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PHADDD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x02)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHADDD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x02)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PHADDD")
    }
    return p
}

// PHADDSW performs "Packed Horizontal Add Signed Word Integers with Signed Saturation".
//
// Mnemonic        : PHADDSW
// Supported forms : (4 forms)
//
//    * PHADDSW mm, mm       [SSSE3]
//    * PHADDSW m64, mm      [SSSE3]
//    * PHADDSW xmm, xmm     [SSSE3]
//    * PHADDSW m128, xmm    [SSSE3]
//
func (self *Program) PHADDSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PHADDSW", 2, Operands { v0, v1 })
    // PHADDSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHADDSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x03)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PHADDSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHADDSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x03)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PHADDSW")
    }
    return p
}

// PHADDW performs "Packed Horizontal Add Word Integers".
//
// Mnemonic        : PHADDW
// Supported forms : (4 forms)
//
//    * PHADDW mm, mm       [SSSE3]
//    * PHADDW m64, mm      [SSSE3]
//    * PHADDW xmm, xmm     [SSSE3]
//    * PHADDW m128, xmm    [SSSE3]
//
func (self *Program) PHADDW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PHADDW", 2, Operands { v0, v1 })
    // PHADDW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x01)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHADDW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x01)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PHADDW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x01)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHADDW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x01)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PHADDW")
    }
    return p
}

// PHMINPOSUW performs "Packed Horizontal Minimum of Unsigned Word Integers".
//
// Mnemonic        : PHMINPOSUW
// Supported forms : (2 forms)
//
//    * PHMINPOSUW xmm, xmm     [SSE4.1]
//    * PHMINPOSUW m128, xmm    [SSE4.1]
//
func (self *Program) PHMINPOSUW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PHMINPOSUW", 2, Operands { v0, v1 })
    // PHMINPOSUW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x41)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHMINPOSUW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x41)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PHMINPOSUW")
    }
    return p
}

// PHSUBD performs "Packed Horizontal Subtract Doubleword Integers".
//
// Mnemonic        : PHSUBD
// Supported forms : (4 forms)
//
//    * PHSUBD mm, mm       [SSSE3]
//    * PHSUBD m64, mm      [SSSE3]
//    * PHSUBD xmm, xmm     [SSSE3]
//    * PHSUBD m128, xmm    [SSSE3]
//
func (self *Program) PHSUBD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PHSUBD", 2, Operands { v0, v1 })
    // PHSUBD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x06)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHSUBD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x06)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PHSUBD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x06)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHSUBD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x06)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PHSUBD")
    }
    return p
}

// PHSUBSW performs "Packed Horizontal Subtract Signed Word Integers with Signed Saturation".
//
// Mnemonic        : PHSUBSW
// Supported forms : (4 forms)
//
//    * PHSUBSW mm, mm       [SSSE3]
//    * PHSUBSW m64, mm      [SSSE3]
//    * PHSUBSW xmm, xmm     [SSSE3]
//    * PHSUBSW m128, xmm    [SSSE3]
//
func (self *Program) PHSUBSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PHSUBSW", 2, Operands { v0, v1 })
    // PHSUBSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x07)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHSUBSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x07)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PHSUBSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x07)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHSUBSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x07)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PHSUBSW")
    }
    return p
}

// PHSUBW performs "Packed Horizontal Subtract Word Integers".
//
// Mnemonic        : PHSUBW
// Supported forms : (4 forms)
//
//    * PHSUBW mm, mm       [SSSE3]
//    * PHSUBW m64, mm      [SSSE3]
//    * PHSUBW xmm, xmm     [SSSE3]
//    * PHSUBW m128, xmm    [SSSE3]
//
func (self *Program) PHSUBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PHSUBW", 2, Operands { v0, v1 })
    // PHSUBW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x05)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHSUBW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x05)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PHSUBW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x05)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PHSUBW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x05)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PHSUBW")
    }
    return p
}

// PI2FD performs "Packed Integer to Floating-Point Doubleword Conversion".
//
// Mnemonic        : PI2FD
// Supported forms : (2 forms)
//
//    * PI2FD mm, mm     [3dnow!]
//    * PI2FD m64, mm    [3dnow!]
//
func (self *Program) PI2FD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PI2FD", 2, Operands { v0, v1 })
    // PI2FD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x0d)
        })
    }
    // PI2FD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x0d)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PI2FD")
    }
    return p
}

// PI2FW performs "Packed Integer to Floating-Point Word Conversion".
//
// Mnemonic        : PI2FW
// Supported forms : (2 forms)
//
//    * PI2FW mm, mm     [3dnow!+]
//    * PI2FW m64, mm    [3dnow!+]
//
func (self *Program) PI2FW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PI2FW", 2, Operands { v0, v1 })
    // PI2FW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0x0c)
        })
    }
    // PI2FW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0x0c)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PI2FW")
    }
    return p
}

// PINSRB performs "Insert Byte".
//
// Mnemonic        : PINSRB
// Supported forms : (2 forms)
//
//    * PINSRB imm8, r32, xmm    [SSE4.1]
//    * PINSRB imm8, m8, xmm     [SSE4.1]
//
func (self *Program) PINSRB(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PINSRB", 3, Operands { v0, v1, v2 })
    // PINSRB imm8, r32, xmm
    if isImm8(v0) && isReg32(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x20)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PINSRB imm8, m8, xmm
    if isImm8(v0) && isM8(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x20)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PINSRB")
    }
    return p
}

// PINSRD performs "Insert Doubleword".
//
// Mnemonic        : PINSRD
// Supported forms : (2 forms)
//
//    * PINSRD imm8, r32, xmm    [SSE4.1]
//    * PINSRD imm8, m32, xmm    [SSE4.1]
//
func (self *Program) PINSRD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PINSRD", 3, Operands { v0, v1, v2 })
    // PINSRD imm8, r32, xmm
    if isImm8(v0) && isReg32(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x22)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PINSRD imm8, m32, xmm
    if isImm8(v0) && isM32(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x22)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PINSRD")
    }
    return p
}

// PINSRQ performs "Insert Quadword".
//
// Mnemonic        : PINSRQ
// Supported forms : (2 forms)
//
//    * PINSRQ imm8, r64, xmm    [SSE4.1]
//    * PINSRQ imm8, m64, xmm    [SSE4.1]
//
func (self *Program) PINSRQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PINSRQ", 3, Operands { v0, v1, v2 })
    // PINSRQ imm8, r64, xmm
    if isImm8(v0) && isReg64(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x48 | hcode(v[2]) << 2 | hcode(v[1]))
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x22)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PINSRQ imm8, m64, xmm
    if isImm8(v0) && isM64(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexm(1, hcode(v[2]), addr(v[1]))
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x22)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PINSRQ")
    }
    return p
}

// PINSRW performs "Insert Word".
//
// Mnemonic        : PINSRW
// Supported forms : (4 forms)
//
//    * PINSRW imm8, r32, mm     [MMX+]
//    * PINSRW imm8, m16, mm     [MMX+]
//    * PINSRW imm8, r32, xmm    [SSE2]
//    * PINSRW imm8, m16, xmm    [SSE2]
//
func (self *Program) PINSRW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PINSRW", 3, Operands { v0, v1, v2 })
    // PINSRW imm8, r32, mm
    if isImm8(v0) && isReg32(v1) && isMM(v2) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc4)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PINSRW imm8, m16, mm
    if isImm8(v0) && isM16(v1) && isMM(v2) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc4)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // PINSRW imm8, r32, xmm
    if isImm8(v0) && isReg32(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc4)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PINSRW imm8, m16, xmm
    if isImm8(v0) && isM16(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc4)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PINSRW")
    }
    return p
}

// PMADDUBSW performs "Multiply and Add Packed Signed and Unsigned Byte Integers".
//
// Mnemonic        : PMADDUBSW
// Supported forms : (4 forms)
//
//    * PMADDUBSW mm, mm       [SSSE3]
//    * PMADDUBSW m64, mm      [SSSE3]
//    * PMADDUBSW xmm, xmm     [SSSE3]
//    * PMADDUBSW m128, xmm    [SSSE3]
//
func (self *Program) PMADDUBSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMADDUBSW", 2, Operands { v0, v1 })
    // PMADDUBSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x04)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMADDUBSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x04)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMADDUBSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x04)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMADDUBSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x04)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMADDUBSW")
    }
    return p
}

// PMADDWD performs "Multiply and Add Packed Signed Word Integers".
//
// Mnemonic        : PMADDWD
// Supported forms : (4 forms)
//
//    * PMADDWD mm, mm       [MMX]
//    * PMADDWD m64, mm      [MMX]
//    * PMADDWD xmm, xmm     [SSE2]
//    * PMADDWD m128, xmm    [SSE2]
//
func (self *Program) PMADDWD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMADDWD", 2, Operands { v0, v1 })
    // PMADDWD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMADDWD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf5)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMADDWD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMADDWD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf5)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMADDWD")
    }
    return p
}

// PMAXSB performs "Maximum of Packed Signed Byte Integers".
//
// Mnemonic        : PMAXSB
// Supported forms : (2 forms)
//
//    * PMAXSB xmm, xmm     [SSE4.1]
//    * PMAXSB m128, xmm    [SSE4.1]
//
func (self *Program) PMAXSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMAXSB", 2, Operands { v0, v1 })
    // PMAXSB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXSB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMAXSB")
    }
    return p
}

// PMAXSD performs "Maximum of Packed Signed Doubleword Integers".
//
// Mnemonic        : PMAXSD
// Supported forms : (2 forms)
//
//    * PMAXSD xmm, xmm     [SSE4.1]
//    * PMAXSD m128, xmm    [SSE4.1]
//
func (self *Program) PMAXSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMAXSD", 2, Operands { v0, v1 })
    // PMAXSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXSD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMAXSD")
    }
    return p
}

// PMAXSW performs "Maximum of Packed Signed Word Integers".
//
// Mnemonic        : PMAXSW
// Supported forms : (4 forms)
//
//    * PMAXSW mm, mm       [MMX+]
//    * PMAXSW m64, mm      [MMX+]
//    * PMAXSW xmm, xmm     [SSE2]
//    * PMAXSW m128, xmm    [SSE2]
//
func (self *Program) PMAXSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMAXSW", 2, Operands { v0, v1 })
    // PMAXSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xee)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xee)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMAXSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xee)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xee)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMAXSW")
    }
    return p
}

// PMAXUB performs "Maximum of Packed Unsigned Byte Integers".
//
// Mnemonic        : PMAXUB
// Supported forms : (4 forms)
//
//    * PMAXUB mm, mm       [MMX+]
//    * PMAXUB m64, mm      [MMX+]
//    * PMAXUB xmm, xmm     [SSE2]
//    * PMAXUB m128, xmm    [SSE2]
//
func (self *Program) PMAXUB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMAXUB", 2, Operands { v0, v1 })
    // PMAXUB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xde)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXUB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xde)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMAXUB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xde)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXUB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xde)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMAXUB")
    }
    return p
}

// PMAXUD performs "Maximum of Packed Unsigned Doubleword Integers".
//
// Mnemonic        : PMAXUD
// Supported forms : (2 forms)
//
//    * PMAXUD xmm, xmm     [SSE4.1]
//    * PMAXUD m128, xmm    [SSE4.1]
//
func (self *Program) PMAXUD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMAXUD", 2, Operands { v0, v1 })
    // PMAXUD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXUD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMAXUD")
    }
    return p
}

// PMAXUW performs "Maximum of Packed Unsigned Word Integers".
//
// Mnemonic        : PMAXUW
// Supported forms : (2 forms)
//
//    * PMAXUW xmm, xmm     [SSE4.1]
//    * PMAXUW m128, xmm    [SSE4.1]
//
func (self *Program) PMAXUW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMAXUW", 2, Operands { v0, v1 })
    // PMAXUW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMAXUW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMAXUW")
    }
    return p
}

// PMINSB performs "Minimum of Packed Signed Byte Integers".
//
// Mnemonic        : PMINSB
// Supported forms : (2 forms)
//
//    * PMINSB xmm, xmm     [SSE4.1]
//    * PMINSB m128, xmm    [SSE4.1]
//
func (self *Program) PMINSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMINSB", 2, Operands { v0, v1 })
    // PMINSB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x38)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINSB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x38)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMINSB")
    }
    return p
}

// PMINSD performs "Minimum of Packed Signed Doubleword Integers".
//
// Mnemonic        : PMINSD
// Supported forms : (2 forms)
//
//    * PMINSD xmm, xmm     [SSE4.1]
//    * PMINSD m128, xmm    [SSE4.1]
//
func (self *Program) PMINSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMINSD", 2, Operands { v0, v1 })
    // PMINSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x39)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINSD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x39)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMINSD")
    }
    return p
}

// PMINSW performs "Minimum of Packed Signed Word Integers".
//
// Mnemonic        : PMINSW
// Supported forms : (4 forms)
//
//    * PMINSW mm, mm       [MMX+]
//    * PMINSW m64, mm      [MMX+]
//    * PMINSW xmm, xmm     [SSE2]
//    * PMINSW m128, xmm    [SSE2]
//
func (self *Program) PMINSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMINSW", 2, Operands { v0, v1 })
    // PMINSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xea)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xea)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMINSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xea)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xea)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMINSW")
    }
    return p
}

// PMINUB performs "Minimum of Packed Unsigned Byte Integers".
//
// Mnemonic        : PMINUB
// Supported forms : (4 forms)
//
//    * PMINUB mm, mm       [MMX+]
//    * PMINUB m64, mm      [MMX+]
//    * PMINUB xmm, xmm     [SSE2]
//    * PMINUB m128, xmm    [SSE2]
//
func (self *Program) PMINUB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMINUB", 2, Operands { v0, v1 })
    // PMINUB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xda)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINUB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xda)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMINUB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xda)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINUB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xda)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMINUB")
    }
    return p
}

// PMINUD performs "Minimum of Packed Unsigned Doubleword Integers".
//
// Mnemonic        : PMINUD
// Supported forms : (2 forms)
//
//    * PMINUD xmm, xmm     [SSE4.1]
//    * PMINUD m128, xmm    [SSE4.1]
//
func (self *Program) PMINUD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMINUD", 2, Operands { v0, v1 })
    // PMINUD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINUD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMINUD")
    }
    return p
}

// PMINUW performs "Minimum of Packed Unsigned Word Integers".
//
// Mnemonic        : PMINUW
// Supported forms : (2 forms)
//
//    * PMINUW xmm, xmm     [SSE4.1]
//    * PMINUW m128, xmm    [SSE4.1]
//
func (self *Program) PMINUW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMINUW", 2, Operands { v0, v1 })
    // PMINUW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMINUW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x3a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMINUW")
    }
    return p
}

// PMOVMSKB performs "Move Byte Mask".
//
// Mnemonic        : PMOVMSKB
// Supported forms : (2 forms)
//
//    * PMOVMSKB mm, r32     [MMX+]
//    * PMOVMSKB xmm, r32    [SSE2]
//
func (self *Program) PMOVMSKB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVMSKB", 2, Operands { v0, v1 })
    // PMOVMSKB mm, r32
    if isMM(v0) && isReg32(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd7)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVMSKB xmm, r32
    if isXMM(v0) && isReg32(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd7)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVMSKB")
    }
    return p
}

// PMOVSXBD performs "Move Packed Byte Integers to Doubleword Integers with Sign Extension".
//
// Mnemonic        : PMOVSXBD
// Supported forms : (2 forms)
//
//    * PMOVSXBD xmm, xmm    [SSE4.1]
//    * PMOVSXBD m32, xmm    [SSE4.1]
//
func (self *Program) PMOVSXBD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVSXBD", 2, Operands { v0, v1 })
    // PMOVSXBD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x21)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVSXBD m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x21)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVSXBD")
    }
    return p
}

// PMOVSXBQ performs "Move Packed Byte Integers to Quadword Integers with Sign Extension".
//
// Mnemonic        : PMOVSXBQ
// Supported forms : (2 forms)
//
//    * PMOVSXBQ xmm, xmm    [SSE4.1]
//    * PMOVSXBQ m16, xmm    [SSE4.1]
//
func (self *Program) PMOVSXBQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVSXBQ", 2, Operands { v0, v1 })
    // PMOVSXBQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x22)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVSXBQ m16, xmm
    if isM16(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x22)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVSXBQ")
    }
    return p
}

// PMOVSXBW performs "Move Packed Byte Integers to Word Integers with Sign Extension".
//
// Mnemonic        : PMOVSXBW
// Supported forms : (2 forms)
//
//    * PMOVSXBW xmm, xmm    [SSE4.1]
//    * PMOVSXBW m64, xmm    [SSE4.1]
//
func (self *Program) PMOVSXBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVSXBW", 2, Operands { v0, v1 })
    // PMOVSXBW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x20)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVSXBW m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x20)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVSXBW")
    }
    return p
}

// PMOVSXDQ performs "Move Packed Doubleword Integers to Quadword Integers with Sign Extension".
//
// Mnemonic        : PMOVSXDQ
// Supported forms : (2 forms)
//
//    * PMOVSXDQ xmm, xmm    [SSE4.1]
//    * PMOVSXDQ m64, xmm    [SSE4.1]
//
func (self *Program) PMOVSXDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVSXDQ", 2, Operands { v0, v1 })
    // PMOVSXDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x25)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVSXDQ m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x25)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVSXDQ")
    }
    return p
}

// PMOVSXWD performs "Move Packed Word Integers to Doubleword Integers with Sign Extension".
//
// Mnemonic        : PMOVSXWD
// Supported forms : (2 forms)
//
//    * PMOVSXWD xmm, xmm    [SSE4.1]
//    * PMOVSXWD m64, xmm    [SSE4.1]
//
func (self *Program) PMOVSXWD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVSXWD", 2, Operands { v0, v1 })
    // PMOVSXWD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x23)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVSXWD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x23)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVSXWD")
    }
    return p
}

// PMOVSXWQ performs "Move Packed Word Integers to Quadword Integers with Sign Extension".
//
// Mnemonic        : PMOVSXWQ
// Supported forms : (2 forms)
//
//    * PMOVSXWQ xmm, xmm    [SSE4.1]
//    * PMOVSXWQ m32, xmm    [SSE4.1]
//
func (self *Program) PMOVSXWQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVSXWQ", 2, Operands { v0, v1 })
    // PMOVSXWQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x24)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVSXWQ m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x24)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVSXWQ")
    }
    return p
}

// PMOVZXBD performs "Move Packed Byte Integers to Doubleword Integers with Zero Extension".
//
// Mnemonic        : PMOVZXBD
// Supported forms : (2 forms)
//
//    * PMOVZXBD xmm, xmm    [SSE4.1]
//    * PMOVZXBD m32, xmm    [SSE4.1]
//
func (self *Program) PMOVZXBD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVZXBD", 2, Operands { v0, v1 })
    // PMOVZXBD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x31)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVZXBD m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x31)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVZXBD")
    }
    return p
}

// PMOVZXBQ performs "Move Packed Byte Integers to Quadword Integers with Zero Extension".
//
// Mnemonic        : PMOVZXBQ
// Supported forms : (2 forms)
//
//    * PMOVZXBQ xmm, xmm    [SSE4.1]
//    * PMOVZXBQ m16, xmm    [SSE4.1]
//
func (self *Program) PMOVZXBQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVZXBQ", 2, Operands { v0, v1 })
    // PMOVZXBQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x32)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVZXBQ m16, xmm
    if isM16(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x32)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVZXBQ")
    }
    return p
}

// PMOVZXBW performs "Move Packed Byte Integers to Word Integers with Zero Extension".
//
// Mnemonic        : PMOVZXBW
// Supported forms : (2 forms)
//
//    * PMOVZXBW xmm, xmm    [SSE4.1]
//    * PMOVZXBW m64, xmm    [SSE4.1]
//
func (self *Program) PMOVZXBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVZXBW", 2, Operands { v0, v1 })
    // PMOVZXBW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x30)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVZXBW m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x30)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVZXBW")
    }
    return p
}

// PMOVZXDQ performs "Move Packed Doubleword Integers to Quadword Integers with Zero Extension".
//
// Mnemonic        : PMOVZXDQ
// Supported forms : (2 forms)
//
//    * PMOVZXDQ xmm, xmm    [SSE4.1]
//    * PMOVZXDQ m64, xmm    [SSE4.1]
//
func (self *Program) PMOVZXDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVZXDQ", 2, Operands { v0, v1 })
    // PMOVZXDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x35)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVZXDQ m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x35)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVZXDQ")
    }
    return p
}

// PMOVZXWD performs "Move Packed Word Integers to Doubleword Integers with Zero Extension".
//
// Mnemonic        : PMOVZXWD
// Supported forms : (2 forms)
//
//    * PMOVZXWD xmm, xmm    [SSE4.1]
//    * PMOVZXWD m64, xmm    [SSE4.1]
//
func (self *Program) PMOVZXWD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVZXWD", 2, Operands { v0, v1 })
    // PMOVZXWD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x33)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVZXWD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x33)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVZXWD")
    }
    return p
}

// PMOVZXWQ performs "Move Packed Word Integers to Quadword Integers with Zero Extension".
//
// Mnemonic        : PMOVZXWQ
// Supported forms : (2 forms)
//
//    * PMOVZXWQ xmm, xmm    [SSE4.1]
//    * PMOVZXWQ m32, xmm    [SSE4.1]
//
func (self *Program) PMOVZXWQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMOVZXWQ", 2, Operands { v0, v1 })
    // PMOVZXWQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x34)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMOVZXWQ m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x34)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMOVZXWQ")
    }
    return p
}

// PMULDQ performs "Multiply Packed Signed Doubleword Integers and Store Quadword Result".
//
// Mnemonic        : PMULDQ
// Supported forms : (2 forms)
//
//    * PMULDQ xmm, xmm     [SSE4.1]
//    * PMULDQ m128, xmm    [SSE4.1]
//
func (self *Program) PMULDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULDQ", 2, Operands { v0, v1 })
    // PMULDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x28)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULDQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x28)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULDQ")
    }
    return p
}

// PMULHRSW performs "Packed Multiply Signed Word Integers and Store High Result with Round and Scale".
//
// Mnemonic        : PMULHRSW
// Supported forms : (4 forms)
//
//    * PMULHRSW mm, mm       [SSSE3]
//    * PMULHRSW m64, mm      [SSSE3]
//    * PMULHRSW xmm, xmm     [SSSE3]
//    * PMULHRSW m128, xmm    [SSSE3]
//
func (self *Program) PMULHRSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULHRSW", 2, Operands { v0, v1 })
    // PMULHRSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULHRSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMULHRSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULHRSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULHRSW")
    }
    return p
}

// PMULHRW performs "Packed Multiply High Rounded Word".
//
// Mnemonic        : PMULHRW
// Supported forms : (2 forms)
//
//    * PMULHRW mm, mm     [3dnow!]
//    * PMULHRW m64, mm    [3dnow!]
//
func (self *Program) PMULHRW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULHRW", 2, Operands { v0, v1 })
    // PMULHRW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xb7)
        })
    }
    // PMULHRW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xb7)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULHRW")
    }
    return p
}

// PMULHUW performs "Multiply Packed Unsigned Word Integers and Store High Result".
//
// Mnemonic        : PMULHUW
// Supported forms : (4 forms)
//
//    * PMULHUW mm, mm       [MMX+]
//    * PMULHUW m64, mm      [MMX+]
//    * PMULHUW xmm, xmm     [SSE2]
//    * PMULHUW m128, xmm    [SSE2]
//
func (self *Program) PMULHUW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULHUW", 2, Operands { v0, v1 })
    // PMULHUW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULHUW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe4)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMULHUW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULHUW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe4)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULHUW")
    }
    return p
}

// PMULHW performs "Multiply Packed Signed Word Integers and Store High Result".
//
// Mnemonic        : PMULHW
// Supported forms : (4 forms)
//
//    * PMULHW mm, mm       [MMX]
//    * PMULHW m64, mm      [MMX]
//    * PMULHW xmm, xmm     [SSE2]
//    * PMULHW m128, xmm    [SSE2]
//
func (self *Program) PMULHW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULHW", 2, Operands { v0, v1 })
    // PMULHW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULHW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe5)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMULHW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULHW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe5)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULHW")
    }
    return p
}

// PMULLD performs "Multiply Packed Signed Doubleword Integers and Store Low Result".
//
// Mnemonic        : PMULLD
// Supported forms : (2 forms)
//
//    * PMULLD xmm, xmm     [SSE4.1]
//    * PMULLD m128, xmm    [SSE4.1]
//
func (self *Program) PMULLD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULLD", 2, Operands { v0, v1 })
    // PMULLD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x40)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULLD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x40)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULLD")
    }
    return p
}

// PMULLW performs "Multiply Packed Signed Word Integers and Store Low Result".
//
// Mnemonic        : PMULLW
// Supported forms : (4 forms)
//
//    * PMULLW mm, mm       [MMX]
//    * PMULLW m64, mm      [MMX]
//    * PMULLW xmm, xmm     [SSE2]
//    * PMULLW m128, xmm    [SSE2]
//
func (self *Program) PMULLW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULLW", 2, Operands { v0, v1 })
    // PMULLW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULLW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd5)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMULLW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULLW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd5)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULLW")
    }
    return p
}

// PMULUDQ performs "Multiply Packed Unsigned Doubleword Integers".
//
// Mnemonic        : PMULUDQ
// Supported forms : (4 forms)
//
//    * PMULUDQ mm, mm       [SSE2]
//    * PMULUDQ m64, mm      [SSE2]
//    * PMULUDQ xmm, xmm     [SSE2]
//    * PMULUDQ m128, xmm    [SSE2]
//
func (self *Program) PMULUDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PMULUDQ", 2, Operands { v0, v1 })
    // PMULUDQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULUDQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf4)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PMULUDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PMULUDQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf4)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PMULUDQ")
    }
    return p
}

// POPCNTL performs "Count of Number of Bits Set to 1".
//
// Mnemonic        : POPCNT
// Supported forms : (2 forms)
//
//    * POPCNTL r32, r32    [POPCNT]
//    * POPCNTL m32, r32    [POPCNT]
//
func (self *Program) POPCNTL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("POPCNTL", 2, Operands { v0, v1 })
    // POPCNTL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_POPCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xb8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // POPCNTL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_POPCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xb8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for POPCNTL")
    }
    return p
}

// POPCNTQ performs "Count of Number of Bits Set to 1".
//
// Mnemonic        : POPCNT
// Supported forms : (2 forms)
//
//    * POPCNTQ r64, r64    [POPCNT]
//    * POPCNTQ m64, r64    [POPCNT]
//
func (self *Program) POPCNTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("POPCNTQ", 2, Operands { v0, v1 })
    // POPCNTQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_POPCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xb8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // POPCNTQ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_POPCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xb8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for POPCNTQ")
    }
    return p
}

// POPCNTW performs "Count of Number of Bits Set to 1".
//
// Mnemonic        : POPCNT
// Supported forms : (2 forms)
//
//    * POPCNTW r16, r16    [POPCNT]
//    * POPCNTW m16, r16    [POPCNT]
//
func (self *Program) POPCNTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("POPCNTW", 2, Operands { v0, v1 })
    // POPCNTW r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_POPCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xb8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // POPCNTW m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_POPCNT)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xb8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for POPCNTW")
    }
    return p
}

// POPQ performs "Pop a Value from the Stack".
//
// Mnemonic        : POP
// Supported forms : (2 forms)
//
//    * POPQ r64
//    * POPQ m64
//
func (self *Program) POPQ(v0 interface{}) *Instruction {
    p := self.alloc("POPQ", 1, Operands { v0 })
    // POPQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0x58 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0x8f)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // POPQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x8f)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for POPQ")
    }
    return p
}

// POPW performs "Pop a Value from the Stack".
//
// Mnemonic        : POP
// Supported forms : (2 forms)
//
//    * POPW r16
//    * POPW m16
//
func (self *Program) POPW(v0 interface{}) *Instruction {
    p := self.alloc("POPW", 1, Operands { v0 })
    // POPW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0x58 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0x8f)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // POPW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0x8f)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for POPW")
    }
    return p
}

// POR performs "Packed Bitwise Logical OR".
//
// Mnemonic        : POR
// Supported forms : (4 forms)
//
//    * POR mm, mm       [MMX]
//    * POR m64, mm      [MMX]
//    * POR xmm, xmm     [SSE2]
//    * POR m128, xmm    [SSE2]
//
func (self *Program) POR(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("POR", 2, Operands { v0, v1 })
    // POR mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xeb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // POR m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xeb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // POR xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xeb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // POR m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xeb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for POR")
    }
    return p
}

// PREFETCH performs "Prefetch Data into Caches".
//
// Mnemonic        : PREFETCH
// Supported forms : (1 form)
//
//    * PREFETCH m8    [PREFETCH]
//
func (self *Program) PREFETCH(v0 interface{}) *Instruction {
    p := self.alloc("PREFETCH", 1, Operands { v0 })
    // PREFETCH m8
    if isM8(v0) {
        self.require(ISA_PREFETCH)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0d)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PREFETCH")
    }
    return p
}

// PREFETCHNTA performs "Prefetch Data Into Caches using NTA Hint".
//
// Mnemonic        : PREFETCHNTA
// Supported forms : (1 form)
//
//    * PREFETCHNTA m8    [MMX+]
//
func (self *Program) PREFETCHNTA(v0 interface{}) *Instruction {
    p := self.alloc("PREFETCHNTA", 1, Operands { v0 })
    // PREFETCHNTA m8
    if isM8(v0) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x18)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PREFETCHNTA")
    }
    return p
}

// PREFETCHT0 performs "Prefetch Data Into Caches using T0 Hint".
//
// Mnemonic        : PREFETCHT0
// Supported forms : (1 form)
//
//    * PREFETCHT0 m8    [MMX+]
//
func (self *Program) PREFETCHT0(v0 interface{}) *Instruction {
    p := self.alloc("PREFETCHT0", 1, Operands { v0 })
    // PREFETCHT0 m8
    if isM8(v0) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x18)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PREFETCHT0")
    }
    return p
}

// PREFETCHT1 performs "Prefetch Data Into Caches using T1 Hint".
//
// Mnemonic        : PREFETCHT1
// Supported forms : (1 form)
//
//    * PREFETCHT1 m8    [MMX+]
//
func (self *Program) PREFETCHT1(v0 interface{}) *Instruction {
    p := self.alloc("PREFETCHT1", 1, Operands { v0 })
    // PREFETCHT1 m8
    if isM8(v0) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x18)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PREFETCHT1")
    }
    return p
}

// PREFETCHT2 performs "Prefetch Data Into Caches using T2 Hint".
//
// Mnemonic        : PREFETCHT2
// Supported forms : (1 form)
//
//    * PREFETCHT2 m8    [MMX+]
//
func (self *Program) PREFETCHT2(v0 interface{}) *Instruction {
    p := self.alloc("PREFETCHT2", 1, Operands { v0 })
    // PREFETCHT2 m8
    if isM8(v0) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x18)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PREFETCHT2")
    }
    return p
}

// PREFETCHW performs "Prefetch Data into Caches in Anticipation of a Write".
//
// Mnemonic        : PREFETCHW
// Supported forms : (1 form)
//
//    * PREFETCHW m8    [PREFETCHW]
//
func (self *Program) PREFETCHW(v0 interface{}) *Instruction {
    p := self.alloc("PREFETCHW", 1, Operands { v0 })
    // PREFETCHW m8
    if isM8(v0) {
        self.require(ISA_PREFETCHW)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0d)
            m.mrsd(1, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PREFETCHW")
    }
    return p
}

// PREFETCHWT1 performs "Prefetch Vector Data Into Caches with Intent to Write and T1 Hint".
//
// Mnemonic        : PREFETCHWT1
// Supported forms : (1 form)
//
//    * PREFETCHWT1 m8    [PREFETCHWT1]
//
func (self *Program) PREFETCHWT1(v0 interface{}) *Instruction {
    p := self.alloc("PREFETCHWT1", 1, Operands { v0 })
    // PREFETCHWT1 m8
    if isM8(v0) {
        self.require(ISA_PREFETCHWT1)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0d)
            m.mrsd(2, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PREFETCHWT1")
    }
    return p
}

// PSADBW performs "Compute Sum of Absolute Differences".
//
// Mnemonic        : PSADBW
// Supported forms : (4 forms)
//
//    * PSADBW mm, mm       [MMX+]
//    * PSADBW m64, mm      [MMX+]
//    * PSADBW xmm, xmm     [SSE2]
//    * PSADBW m128, xmm    [SSE2]
//
func (self *Program) PSADBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSADBW", 2, Operands { v0, v1 })
    // PSADBW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSADBW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSADBW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSADBW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf6)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSADBW")
    }
    return p
}

// PSHUFB performs "Packed Shuffle Bytes".
//
// Mnemonic        : PSHUFB
// Supported forms : (4 forms)
//
//    * PSHUFB mm, mm       [SSSE3]
//    * PSHUFB m64, mm      [SSSE3]
//    * PSHUFB xmm, xmm     [SSSE3]
//    * PSHUFB m128, xmm    [SSSE3]
//
func (self *Program) PSHUFB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSHUFB", 2, Operands { v0, v1 })
    // PSHUFB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x00)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSHUFB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x00)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSHUFB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x00)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSHUFB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x00)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSHUFB")
    }
    return p
}

// PSHUFD performs "Shuffle Packed Doublewords".
//
// Mnemonic        : PSHUFD
// Supported forms : (2 forms)
//
//    * PSHUFD imm8, xmm, xmm     [SSE2]
//    * PSHUFD imm8, m128, xmm    [SSE2]
//
func (self *Program) PSHUFD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PSHUFD", 3, Operands { v0, v1, v2 })
    // PSHUFD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x70)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSHUFD imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x70)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSHUFD")
    }
    return p
}

// PSHUFHW performs "Shuffle Packed High Words".
//
// Mnemonic        : PSHUFHW
// Supported forms : (2 forms)
//
//    * PSHUFHW imm8, xmm, xmm     [SSE2]
//    * PSHUFHW imm8, m128, xmm    [SSE2]
//
func (self *Program) PSHUFHW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PSHUFHW", 3, Operands { v0, v1, v2 })
    // PSHUFHW imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x70)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSHUFHW imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x70)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSHUFHW")
    }
    return p
}

// PSHUFLW performs "Shuffle Packed Low Words".
//
// Mnemonic        : PSHUFLW
// Supported forms : (2 forms)
//
//    * PSHUFLW imm8, xmm, xmm     [SSE2]
//    * PSHUFLW imm8, m128, xmm    [SSE2]
//
func (self *Program) PSHUFLW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PSHUFLW", 3, Operands { v0, v1, v2 })
    // PSHUFLW imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x70)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSHUFLW imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x70)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSHUFLW")
    }
    return p
}

// PSHUFW performs "Shuffle Packed Words".
//
// Mnemonic        : PSHUFW
// Supported forms : (2 forms)
//
//    * PSHUFW imm8, mm, mm     [MMX+]
//    * PSHUFW imm8, m64, mm    [MMX+]
//
func (self *Program) PSHUFW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("PSHUFW", 3, Operands { v0, v1, v2 })
    // PSHUFW imm8, mm, mm
    if isImm8(v0) && isMM(v1) && isMM(v2) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x70)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSHUFW imm8, m64, mm
    if isImm8(v0) && isM64(v1) && isMM(v2) {
        self.require(ISA_MMX_PLUS)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x70)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSHUFW")
    }
    return p
}

// PSIGNB performs "Packed Sign of Byte Integers".
//
// Mnemonic        : PSIGNB
// Supported forms : (4 forms)
//
//    * PSIGNB mm, mm       [SSSE3]
//    * PSIGNB m64, mm      [SSSE3]
//    * PSIGNB xmm, xmm     [SSSE3]
//    * PSIGNB m128, xmm    [SSSE3]
//
func (self *Program) PSIGNB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSIGNB", 2, Operands { v0, v1 })
    // PSIGNB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x08)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSIGNB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x08)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSIGNB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x08)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSIGNB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x08)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSIGNB")
    }
    return p
}

// PSIGND performs "Packed Sign of Doubleword Integers".
//
// Mnemonic        : PSIGND
// Supported forms : (4 forms)
//
//    * PSIGND mm, mm       [SSSE3]
//    * PSIGND m64, mm      [SSSE3]
//    * PSIGND xmm, xmm     [SSSE3]
//    * PSIGND m128, xmm    [SSSE3]
//
func (self *Program) PSIGND(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSIGND", 2, Operands { v0, v1 })
    // PSIGND mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSIGND m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSIGND xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSIGND m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x0a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSIGND")
    }
    return p
}

// PSIGNW performs "Packed Sign of Word Integers".
//
// Mnemonic        : PSIGNW
// Supported forms : (4 forms)
//
//    * PSIGNW mm, mm       [SSSE3]
//    * PSIGNW m64, mm      [SSSE3]
//    * PSIGNW xmm, xmm     [SSSE3]
//    * PSIGNW m128, xmm    [SSSE3]
//
func (self *Program) PSIGNW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSIGNW", 2, Operands { v0, v1 })
    // PSIGNW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x09)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSIGNW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x09)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSIGNW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x09)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSIGNW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSSE3)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x09)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSIGNW")
    }
    return p
}

// PSLLD performs "Shift Packed Doubleword Data Left Logical".
//
// Mnemonic        : PSLLD
// Supported forms : (6 forms)
//
//    * PSLLD imm8, mm     [MMX]
//    * PSLLD mm, mm       [MMX]
//    * PSLLD m64, mm      [MMX]
//    * PSLLD imm8, xmm    [SSE2]
//    * PSLLD xmm, xmm     [SSE2]
//    * PSLLD m128, xmm    [SSE2]
//
func (self *Program) PSLLD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSLLD", 2, Operands { v0, v1 })
    // PSLLD imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x72)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSLLD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf2)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSLLD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf2)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSLLD imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x72)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSLLD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf2)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSLLD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf2)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSLLD")
    }
    return p
}

// PSLLDQ performs "Shift Packed Double Quadword Left Logical".
//
// Mnemonic        : PSLLDQ
// Supported forms : (1 form)
//
//    * PSLLDQ imm8, xmm    [SSE2]
//
func (self *Program) PSLLDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSLLDQ", 2, Operands { v0, v1 })
    // PSLLDQ imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x73)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSLLDQ")
    }
    return p
}

// PSLLQ performs "Shift Packed Quadword Data Left Logical".
//
// Mnemonic        : PSLLQ
// Supported forms : (6 forms)
//
//    * PSLLQ imm8, mm     [MMX]
//    * PSLLQ mm, mm       [MMX]
//    * PSLLQ m64, mm      [MMX]
//    * PSLLQ imm8, xmm    [SSE2]
//    * PSLLQ xmm, xmm     [SSE2]
//    * PSLLQ m128, xmm    [SSE2]
//
func (self *Program) PSLLQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSLLQ", 2, Operands { v0, v1 })
    // PSLLQ imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x73)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSLLQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf3)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSLLQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf3)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSLLQ imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x73)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSLLQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf3)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSLLQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf3)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSLLQ")
    }
    return p
}

// PSLLW performs "Shift Packed Word Data Left Logical".
//
// Mnemonic        : PSLLW
// Supported forms : (6 forms)
//
//    * PSLLW imm8, mm     [MMX]
//    * PSLLW mm, mm       [MMX]
//    * PSLLW m64, mm      [MMX]
//    * PSLLW imm8, xmm    [SSE2]
//    * PSLLW xmm, xmm     [SSE2]
//    * PSLLW m128, xmm    [SSE2]
//
func (self *Program) PSLLW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSLLW", 2, Operands { v0, v1 })
    // PSLLW imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x71)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSLLW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSLLW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSLLW imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x71)
            m.emit(0xf0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSLLW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSLLW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSLLW")
    }
    return p
}

// PSRAD performs "Shift Packed Doubleword Data Right Arithmetic".
//
// Mnemonic        : PSRAD
// Supported forms : (6 forms)
//
//    * PSRAD imm8, mm     [MMX]
//    * PSRAD mm, mm       [MMX]
//    * PSRAD m64, mm      [MMX]
//    * PSRAD imm8, xmm    [SSE2]
//    * PSRAD xmm, xmm     [SSE2]
//    * PSRAD m128, xmm    [SSE2]
//
func (self *Program) PSRAD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSRAD", 2, Operands { v0, v1 })
    // PSRAD imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x72)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRAD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe2)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRAD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe2)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSRAD imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x72)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRAD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe2)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRAD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe2)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSRAD")
    }
    return p
}

// PSRAW performs "Shift Packed Word Data Right Arithmetic".
//
// Mnemonic        : PSRAW
// Supported forms : (6 forms)
//
//    * PSRAW imm8, mm     [MMX]
//    * PSRAW mm, mm       [MMX]
//    * PSRAW m64, mm      [MMX]
//    * PSRAW imm8, xmm    [SSE2]
//    * PSRAW xmm, xmm     [SSE2]
//    * PSRAW m128, xmm    [SSE2]
//
func (self *Program) PSRAW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSRAW", 2, Operands { v0, v1 })
    // PSRAW imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x71)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRAW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRAW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSRAW imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x71)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRAW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRAW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSRAW")
    }
    return p
}

// PSRLD performs "Shift Packed Doubleword Data Right Logical".
//
// Mnemonic        : PSRLD
// Supported forms : (6 forms)
//
//    * PSRLD imm8, mm     [MMX]
//    * PSRLD mm, mm       [MMX]
//    * PSRLD m64, mm      [MMX]
//    * PSRLD imm8, xmm    [SSE2]
//    * PSRLD xmm, xmm     [SSE2]
//    * PSRLD m128, xmm    [SSE2]
//
func (self *Program) PSRLD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSRLD", 2, Operands { v0, v1 })
    // PSRLD imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x72)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRLD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd2)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRLD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd2)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSRLD imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x72)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRLD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd2)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRLD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd2)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSRLD")
    }
    return p
}

// PSRLDQ performs "Shift Packed Double Quadword Right Logical".
//
// Mnemonic        : PSRLDQ
// Supported forms : (1 form)
//
//    * PSRLDQ imm8, xmm    [SSE2]
//
func (self *Program) PSRLDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSRLDQ", 2, Operands { v0, v1 })
    // PSRLDQ imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x73)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSRLDQ")
    }
    return p
}

// PSRLQ performs "Shift Packed Quadword Data Right Logical".
//
// Mnemonic        : PSRLQ
// Supported forms : (6 forms)
//
//    * PSRLQ imm8, mm     [MMX]
//    * PSRLQ mm, mm       [MMX]
//    * PSRLQ m64, mm      [MMX]
//    * PSRLQ imm8, xmm    [SSE2]
//    * PSRLQ xmm, xmm     [SSE2]
//    * PSRLQ m128, xmm    [SSE2]
//
func (self *Program) PSRLQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSRLQ", 2, Operands { v0, v1 })
    // PSRLQ imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x73)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRLQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd3)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRLQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd3)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSRLQ imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x73)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRLQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd3)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRLQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd3)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSRLQ")
    }
    return p
}

// PSRLW performs "Shift Packed Word Data Right Logical".
//
// Mnemonic        : PSRLW
// Supported forms : (6 forms)
//
//    * PSRLW imm8, mm     [MMX]
//    * PSRLW mm, mm       [MMX]
//    * PSRLW m64, mm      [MMX]
//    * PSRLW imm8, xmm    [SSE2]
//    * PSRLW xmm, xmm     [SSE2]
//    * PSRLW m128, xmm    [SSE2]
//
func (self *Program) PSRLW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSRLW", 2, Operands { v0, v1 })
    // PSRLW imm8, mm
    if isImm8(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x71)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRLW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRLW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSRLW imm8, xmm
    if isImm8(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x0f)
            m.emit(0x71)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // PSRLW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd1)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSRLW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd1)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSRLW")
    }
    return p
}

// PSUBB performs "Subtract Packed Byte Integers".
//
// Mnemonic        : PSUBB
// Supported forms : (4 forms)
//
//    * PSUBB mm, mm       [MMX]
//    * PSUBB m64, mm      [MMX]
//    * PSUBB xmm, xmm     [SSE2]
//    * PSUBB m128, xmm    [SSE2]
//
func (self *Program) PSUBB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBB", 2, Operands { v0, v1 })
    // PSUBB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBB")
    }
    return p
}

// PSUBD performs "Subtract Packed Doubleword Integers".
//
// Mnemonic        : PSUBD
// Supported forms : (4 forms)
//
//    * PSUBD mm, mm       [MMX]
//    * PSUBD m64, mm      [MMX]
//    * PSUBD xmm, xmm     [SSE2]
//    * PSUBD m128, xmm    [SSE2]
//
func (self *Program) PSUBD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBD", 2, Operands { v0, v1 })
    // PSUBD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfa)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfa)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfa)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfa)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBD")
    }
    return p
}

// PSUBQ performs "Subtract Packed Quadword Integers".
//
// Mnemonic        : PSUBQ
// Supported forms : (4 forms)
//
//    * PSUBQ mm, mm       [SSE2]
//    * PSUBQ m64, mm      [SSE2]
//    * PSUBQ xmm, xmm     [SSE2]
//    * PSUBQ m128, xmm    [SSE2]
//
func (self *Program) PSUBQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBQ", 2, Operands { v0, v1 })
    // PSUBQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xfb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xfb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBQ")
    }
    return p
}

// PSUBSB performs "Subtract Packed Signed Byte Integers with Signed Saturation".
//
// Mnemonic        : PSUBSB
// Supported forms : (4 forms)
//
//    * PSUBSB mm, mm       [MMX]
//    * PSUBSB m64, mm      [MMX]
//    * PSUBSB xmm, xmm     [SSE2]
//    * PSUBSB m128, xmm    [SSE2]
//
func (self *Program) PSUBSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBSB", 2, Operands { v0, v1 })
    // PSUBSB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBSB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBSB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBSB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBSB")
    }
    return p
}

// PSUBSW performs "Subtract Packed Signed Word Integers with Signed Saturation".
//
// Mnemonic        : PSUBSW
// Supported forms : (4 forms)
//
//    * PSUBSW mm, mm       [MMX]
//    * PSUBSW m64, mm      [MMX]
//    * PSUBSW xmm, xmm     [SSE2]
//    * PSUBSW m128, xmm    [SSE2]
//
func (self *Program) PSUBSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBSW", 2, Operands { v0, v1 })
    // PSUBSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe9)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe9)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xe9)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xe9)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBSW")
    }
    return p
}

// PSUBUSB performs "Subtract Packed Unsigned Byte Integers with Unsigned Saturation".
//
// Mnemonic        : PSUBUSB
// Supported forms : (4 forms)
//
//    * PSUBUSB mm, mm       [MMX]
//    * PSUBUSB m64, mm      [MMX]
//    * PSUBUSB xmm, xmm     [SSE2]
//    * PSUBUSB m128, xmm    [SSE2]
//
func (self *Program) PSUBUSB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBUSB", 2, Operands { v0, v1 })
    // PSUBUSB mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBUSB m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBUSB xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBUSB m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBUSB")
    }
    return p
}

// PSUBUSW performs "Subtract Packed Unsigned Word Integers with Unsigned Saturation".
//
// Mnemonic        : PSUBUSW
// Supported forms : (4 forms)
//
//    * PSUBUSW mm, mm       [MMX]
//    * PSUBUSW m64, mm      [MMX]
//    * PSUBUSW xmm, xmm     [SSE2]
//    * PSUBUSW m128, xmm    [SSE2]
//
func (self *Program) PSUBUSW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBUSW", 2, Operands { v0, v1 })
    // PSUBUSW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd9)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBUSW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd9)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBUSW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xd9)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBUSW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xd9)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBUSW")
    }
    return p
}

// PSUBW performs "Subtract Packed Word Integers".
//
// Mnemonic        : PSUBW
// Supported forms : (4 forms)
//
//    * PSUBW mm, mm       [MMX]
//    * PSUBW m64, mm      [MMX]
//    * PSUBW xmm, xmm     [SSE2]
//    * PSUBW m128, xmm    [SSE2]
//
func (self *Program) PSUBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSUBW", 2, Operands { v0, v1 })
    // PSUBW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf9)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf9)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PSUBW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xf9)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PSUBW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xf9)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSUBW")
    }
    return p
}

// PSWAPD performs "Packed Swap Doubleword".
//
// Mnemonic        : PSWAPD
// Supported forms : (2 forms)
//
//    * PSWAPD mm, mm     [3dnow!+]
//    * PSWAPD m64, mm    [3dnow!+]
//
func (self *Program) PSWAPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PSWAPD", 2, Operands { v0, v1 })
    // PSWAPD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
            m.emit(0xbb)
        })
    }
    // PSWAPD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_3DNOW_PLUS)
        p.domain = DomainAMDSpecific
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x0f)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
            m.emit(0xbb)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PSWAPD")
    }
    return p
}

// PTEST performs "Packed Logical Compare".
//
// Mnemonic        : PTEST
// Supported forms : (2 forms)
//
//    * PTEST xmm, xmm     [SSE4.1]
//    * PTEST m128, xmm    [SSE4.1]
//
func (self *Program) PTEST(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PTEST", 2, Operands { v0, v1 })
    // PTEST xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x17)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PTEST m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0x17)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PTEST")
    }
    return p
}

// PUNPCKHBW performs "Unpack and Interleave High-Order Bytes into Words".
//
// Mnemonic        : PUNPCKHBW
// Supported forms : (4 forms)
//
//    * PUNPCKHBW mm, mm       [MMX]
//    * PUNPCKHBW m64, mm      [MMX]
//    * PUNPCKHBW xmm, xmm     [SSE2]
//    * PUNPCKHBW m128, xmm    [SSE2]
//
func (self *Program) PUNPCKHBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKHBW", 2, Operands { v0, v1 })
    // PUNPCKHBW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x68)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKHBW m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x68)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PUNPCKHBW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x68)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKHBW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x68)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKHBW")
    }
    return p
}

// PUNPCKHDQ performs "Unpack and Interleave High-Order Doublewords into Quadwords".
//
// Mnemonic        : PUNPCKHDQ
// Supported forms : (4 forms)
//
//    * PUNPCKHDQ mm, mm       [MMX]
//    * PUNPCKHDQ m64, mm      [MMX]
//    * PUNPCKHDQ xmm, xmm     [SSE2]
//    * PUNPCKHDQ m128, xmm    [SSE2]
//
func (self *Program) PUNPCKHDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKHDQ", 2, Operands { v0, v1 })
    // PUNPCKHDQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKHDQ m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PUNPCKHDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKHDQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKHDQ")
    }
    return p
}

// PUNPCKHQDQ performs "Unpack and Interleave High-Order Quadwords into Double Quadwords".
//
// Mnemonic        : PUNPCKHQDQ
// Supported forms : (2 forms)
//
//    * PUNPCKHQDQ xmm, xmm     [SSE2]
//    * PUNPCKHQDQ m128, xmm    [SSE2]
//
func (self *Program) PUNPCKHQDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKHQDQ", 2, Operands { v0, v1 })
    // PUNPCKHQDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6d)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKHQDQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6d)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKHQDQ")
    }
    return p
}

// PUNPCKHWD performs "Unpack and Interleave High-Order Words into Doublewords".
//
// Mnemonic        : PUNPCKHWD
// Supported forms : (4 forms)
//
//    * PUNPCKHWD mm, mm       [MMX]
//    * PUNPCKHWD m64, mm      [MMX]
//    * PUNPCKHWD xmm, xmm     [SSE2]
//    * PUNPCKHWD m128, xmm    [SSE2]
//
func (self *Program) PUNPCKHWD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKHWD", 2, Operands { v0, v1 })
    // PUNPCKHWD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x69)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKHWD m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x69)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PUNPCKHWD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x69)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKHWD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x69)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKHWD")
    }
    return p
}

// PUNPCKLBW performs "Unpack and Interleave Low-Order Bytes into Words".
//
// Mnemonic        : PUNPCKLBW
// Supported forms : (4 forms)
//
//    * PUNPCKLBW mm, mm       [MMX]
//    * PUNPCKLBW m32, mm      [MMX]
//    * PUNPCKLBW xmm, xmm     [SSE2]
//    * PUNPCKLBW m128, xmm    [SSE2]
//
func (self *Program) PUNPCKLBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKLBW", 2, Operands { v0, v1 })
    // PUNPCKLBW mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x60)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKLBW m32, mm
    if isM32(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x60)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PUNPCKLBW xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x60)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKLBW m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x60)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKLBW")
    }
    return p
}

// PUNPCKLDQ performs "Unpack and Interleave Low-Order Doublewords into Quadwords".
//
// Mnemonic        : PUNPCKLDQ
// Supported forms : (4 forms)
//
//    * PUNPCKLDQ mm, mm       [MMX]
//    * PUNPCKLDQ m32, mm      [MMX]
//    * PUNPCKLDQ xmm, xmm     [SSE2]
//    * PUNPCKLDQ m128, xmm    [SSE2]
//
func (self *Program) PUNPCKLDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKLDQ", 2, Operands { v0, v1 })
    // PUNPCKLDQ mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x62)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKLDQ m32, mm
    if isM32(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x62)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PUNPCKLDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x62)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKLDQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x62)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKLDQ")
    }
    return p
}

// PUNPCKLQDQ performs "Unpack and Interleave Low-Order Quadwords into Double Quadwords".
//
// Mnemonic        : PUNPCKLQDQ
// Supported forms : (2 forms)
//
//    * PUNPCKLQDQ xmm, xmm     [SSE2]
//    * PUNPCKLQDQ m128, xmm    [SSE2]
//
func (self *Program) PUNPCKLQDQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKLQDQ", 2, Operands { v0, v1 })
    // PUNPCKLQDQ xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x6c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKLQDQ m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x6c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKLQDQ")
    }
    return p
}

// PUNPCKLWD performs "Unpack and Interleave Low-Order Words into Doublewords".
//
// Mnemonic        : PUNPCKLWD
// Supported forms : (4 forms)
//
//    * PUNPCKLWD mm, mm       [MMX]
//    * PUNPCKLWD m32, mm      [MMX]
//    * PUNPCKLWD xmm, xmm     [SSE2]
//    * PUNPCKLWD m128, xmm    [SSE2]
//
func (self *Program) PUNPCKLWD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PUNPCKLWD", 2, Operands { v0, v1 })
    // PUNPCKLWD mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x61)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKLWD m32, mm
    if isM32(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x61)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PUNPCKLWD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x61)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PUNPCKLWD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x61)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUNPCKLWD")
    }
    return p
}

// PUSHQ performs "Push Value Onto the Stack".
//
// Mnemonic        : PUSH
// Supported forms : (4 forms)
//
//    * PUSHQ imm8
//    * PUSHQ imm32
//    * PUSHQ r64
//    * PUSHQ m64
//
func (self *Program) PUSHQ(v0 interface{}) *Instruction {
    p := self.alloc("PUSHQ", 1, Operands { v0 })
    // PUSHQ imm8
    if isImm8Ext(v0, 8) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x6a)
            m.imm1(toImmAny(v[0]))
        })
    }
    // PUSHQ imm32
    if isImm32Ext(v0, 8) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x68)
            m.imm4(toImmAny(v[0]))
        })
    }
    // PUSHQ r64
    if isReg64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0x50 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // PUSHQ m64
    if isM64(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUSHQ")
    }
    return p
}

// PUSHW performs "Push Value Onto the Stack".
//
// Mnemonic        : PUSH
// Supported forms : (2 forms)
//
//    * PUSHW r16
//    * PUSHW m16
//
func (self *Program) PUSHW(v0 interface{}) *Instruction {
    p := self.alloc("PUSHW", 1, Operands { v0 })
    // PUSHW r16
    if isReg16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0x50 | lcode(v[0]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0xff)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // PUSHW m16
    if isM16(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[0]), false)
            m.emit(0xff)
            m.mrsd(6, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PUSHW")
    }
    return p
}

// PXOR performs "Packed Bitwise Logical Exclusive OR".
//
// Mnemonic        : PXOR
// Supported forms : (4 forms)
//
//    * PXOR mm, mm       [MMX]
//    * PXOR m64, mm      [MMX]
//    * PXOR xmm, xmm     [SSE2]
//    * PXOR m128, xmm    [SSE2]
//
func (self *Program) PXOR(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("PXOR", 2, Operands { v0, v1 })
    // PXOR mm, mm
    if isMM(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xef)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PXOR m64, mm
    if isM64(v0) && isMM(v1) {
        self.require(ISA_MMX)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xef)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // PXOR xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xef)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // PXOR m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xef)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for PXOR")
    }
    return p
}

// RCLB performs "Rotate Left through Carry Flag".
//
// Mnemonic        : RCL
// Supported forms : (6 forms)
//
//    * RCLB 1, r8
//    * RCLB imm8, r8
//    * RCLB cl, r8
//    * RCLB 1, m8
//    * RCLB imm8, m8
//    * RCLB cl, m8
//
func (self *Program) RCLB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCLB", 2, Operands { v0, v1 })
    // RCLB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    // RCLB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCLB")
    }
    return p
}

// RCLL performs "Rotate Left through Carry Flag".
//
// Mnemonic        : RCL
// Supported forms : (6 forms)
//
//    * RCLL 1, r32
//    * RCLL imm8, r32
//    * RCLL cl, r32
//    * RCLL 1, m32
//    * RCLL imm8, m32
//    * RCLL cl, m32
//
func (self *Program) RCLL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCLL", 2, Operands { v0, v1 })
    // RCLL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    // RCLL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCLL")
    }
    return p
}

// RCLQ performs "Rotate Left through Carry Flag".
//
// Mnemonic        : RCL
// Supported forms : (6 forms)
//
//    * RCLQ 1, r64
//    * RCLQ imm8, r64
//    * RCLQ cl, r64
//    * RCLQ 1, m64
//    * RCLQ imm8, m64
//    * RCLQ cl, m64
//
func (self *Program) RCLQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCLQ", 2, Operands { v0, v1 })
    // RCLQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    // RCLQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCLQ")
    }
    return p
}

// RCLW performs "Rotate Left through Carry Flag".
//
// Mnemonic        : RCL
// Supported forms : (6 forms)
//
//    * RCLW 1, r16
//    * RCLW imm8, r16
//    * RCLW cl, r16
//    * RCLW 1, m16
//    * RCLW imm8, m16
//    * RCLW cl, m16
//
func (self *Program) RCLW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCLW", 2, Operands { v0, v1 })
    // RCLW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xd0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xd0 | lcode(v[1]))
        })
    }
    // RCLW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    // RCLW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(2, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCLW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(2, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCLW")
    }
    return p
}

// RCPPS performs "Compute Approximate Reciprocals of Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : RCPPS
// Supported forms : (2 forms)
//
//    * RCPPS xmm, xmm     [SSE]
//    * RCPPS m128, xmm    [SSE]
//
func (self *Program) RCPPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCPPS", 2, Operands { v0, v1 })
    // RCPPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x53)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // RCPPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x53)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCPPS")
    }
    return p
}

// RCPSS performs "Compute Approximate Reciprocal of Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : RCPSS
// Supported forms : (2 forms)
//
//    * RCPSS xmm, xmm    [SSE]
//    * RCPSS m32, xmm    [SSE]
//
func (self *Program) RCPSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCPSS", 2, Operands { v0, v1 })
    // RCPSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x53)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // RCPSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x53)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCPSS")
    }
    return p
}

// RCRB performs "Rotate Right through Carry Flag".
//
// Mnemonic        : RCR
// Supported forms : (6 forms)
//
//    * RCRB 1, r8
//    * RCRB imm8, r8
//    * RCRB cl, r8
//    * RCRB 1, m8
//    * RCRB imm8, m8
//    * RCRB cl, m8
//
func (self *Program) RCRB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCRB", 2, Operands { v0, v1 })
    // RCRB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    // RCRB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCRB")
    }
    return p
}

// RCRL performs "Rotate Right through Carry Flag".
//
// Mnemonic        : RCR
// Supported forms : (6 forms)
//
//    * RCRL 1, r32
//    * RCRL imm8, r32
//    * RCRL cl, r32
//    * RCRL 1, m32
//    * RCRL imm8, m32
//    * RCRL cl, m32
//
func (self *Program) RCRL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCRL", 2, Operands { v0, v1 })
    // RCRL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    // RCRL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCRL")
    }
    return p
}

// RCRQ performs "Rotate Right through Carry Flag".
//
// Mnemonic        : RCR
// Supported forms : (6 forms)
//
//    * RCRQ 1, r64
//    * RCRQ imm8, r64
//    * RCRQ cl, r64
//    * RCRQ 1, m64
//    * RCRQ imm8, m64
//    * RCRQ cl, m64
//
func (self *Program) RCRQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCRQ", 2, Operands { v0, v1 })
    // RCRQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    // RCRQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCRQ")
    }
    return p
}

// RCRW performs "Rotate Right through Carry Flag".
//
// Mnemonic        : RCR
// Supported forms : (6 forms)
//
//    * RCRW 1, r16
//    * RCRW imm8, r16
//    * RCRW cl, r16
//    * RCRW 1, m16
//    * RCRW imm8, m16
//    * RCRW cl, m16
//
func (self *Program) RCRW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RCRW", 2, Operands { v0, v1 })
    // RCRW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xd8 | lcode(v[1]))
        })
    }
    // RCRW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    // RCRW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RCRW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(3, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RCRW")
    }
    return p
}

// RDRAND performs "Read Random Number".
//
// Mnemonic        : RDRAND
// Supported forms : (3 forms)
//
//    * RDRAND r16    [RDRAND]
//    * RDRAND r32    [RDRAND]
//    * RDRAND r64    [RDRAND]
//
func (self *Program) RDRAND(v0 interface{}) *Instruction {
    p := self.alloc("RDRAND", 1, Operands { v0 })
    // RDRAND r16
    if isReg16(v0) {
        self.require(ISA_RDRAND)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0x0f)
            m.emit(0xc7)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // RDRAND r32
    if isReg32(v0) {
        self.require(ISA_RDRAND)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0x0f)
            m.emit(0xc7)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    // RDRAND r64
    if isReg64(v0) {
        self.require(ISA_RDRAND)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xc7)
            m.emit(0xf0 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for RDRAND")
    }
    return p
}

// RDSEED performs "Read Random SEED".
//
// Mnemonic        : RDSEED
// Supported forms : (3 forms)
//
//    * RDSEED r16    [RDSEED]
//    * RDSEED r32    [RDSEED]
//    * RDSEED r64    [RDSEED]
//
func (self *Program) RDSEED(v0 interface{}) *Instruction {
    p := self.alloc("RDSEED", 1, Operands { v0 })
    // RDSEED r16
    if isReg16(v0) {
        self.require(ISA_RDSEED)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[0], false)
            m.emit(0x0f)
            m.emit(0xc7)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // RDSEED r32
    if isReg32(v0) {
        self.require(ISA_RDSEED)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], false)
            m.emit(0x0f)
            m.emit(0xc7)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // RDSEED r64
    if isReg64(v0) {
        self.require(ISA_RDSEED)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xc7)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for RDSEED")
    }
    return p
}

// RDTSC performs "Read Time-Stamp Counter".
//
// Mnemonic        : RDTSC
// Supported forms : (1 form)
//
//    * RDTSC    [RDTSC]
//
func (self *Program) RDTSC() *Instruction {
    p := self.alloc("RDTSC", 0, Operands {  })
    // RDTSC
    self.require(ISA_RDTSC)
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x31)
    })
    return p
}

// RDTSCP performs "Read Time-Stamp Counter and Processor ID".
//
// Mnemonic        : RDTSCP
// Supported forms : (1 form)
//
//    * RDTSCP    [RDTSCP]
//
func (self *Program) RDTSCP() *Instruction {
    p := self.alloc("RDTSCP", 0, Operands {  })
    // RDTSCP
    self.require(ISA_RDTSCP)
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x01)
        m.emit(0xf9)
    })
    return p
}

// RET performs "Return from Procedure".
//
// Mnemonic        : RET
// Supported forms : (2 forms)
//
//    * RET
//    * RET imm16
//
func (self *Program) RET(vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("RET", 0, Operands {  })
        case 1  : p = self.alloc("RET", 1, Operands { vv[0] })
        default : panic("instruction RET takes 0 or 1 operands")
    }
    // RET
    if len(vv) == 0 {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc3)
        })
    }
    // RET imm16
    if len(vv) == 1 && isImm16(vv[0]) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc2)
            m.imm2(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for RET")
    }
    return p
}

// ROLB performs "Rotate Left".
//
// Mnemonic        : ROL
// Supported forms : (6 forms)
//
//    * ROLB 1, r8
//    * ROLB imm8, r8
//    * ROLB cl, r8
//    * ROLB 1, m8
//    * ROLB imm8, m8
//    * ROLB cl, m8
//
func (self *Program) ROLB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ROLB", 2, Operands { v0, v1 })
    // ROLB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    // ROLB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROLB")
    }
    return p
}

// ROLL performs "Rotate Left".
//
// Mnemonic        : ROL
// Supported forms : (6 forms)
//
//    * ROLL 1, r32
//    * ROLL imm8, r32
//    * ROLL cl, r32
//    * ROLL 1, m32
//    * ROLL imm8, m32
//    * ROLL cl, m32
//
func (self *Program) ROLL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ROLL", 2, Operands { v0, v1 })
    // ROLL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    // ROLL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROLL")
    }
    return p
}

// ROLQ performs "Rotate Left".
//
// Mnemonic        : ROL
// Supported forms : (6 forms)
//
//    * ROLQ 1, r64
//    * ROLQ imm8, r64
//    * ROLQ cl, r64
//    * ROLQ 1, m64
//    * ROLQ imm8, m64
//    * ROLQ cl, m64
//
func (self *Program) ROLQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ROLQ", 2, Operands { v0, v1 })
    // ROLQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    // ROLQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROLQ")
    }
    return p
}

// ROLW performs "Rotate Left".
//
// Mnemonic        : ROL
// Supported forms : (6 forms)
//
//    * ROLW 1, r16
//    * ROLW imm8, r16
//    * ROLW cl, r16
//    * ROLW 1, m16
//    * ROLW imm8, m16
//    * ROLW cl, m16
//
func (self *Program) ROLW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("ROLW", 2, Operands { v0, v1 })
    // ROLW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xc0 | lcode(v[1]))
        })
    }
    // ROLW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    // ROLW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROLW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(0, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROLW")
    }
    return p
}

// RORB performs "Rotate Right".
//
// Mnemonic        : ROR
// Supported forms : (6 forms)
//
//    * RORB 1, r8
//    * RORB imm8, r8
//    * RORB cl, r8
//    * RORB 1, m8
//    * RORB imm8, m8
//    * RORB cl, m8
//
func (self *Program) RORB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RORB", 2, Operands { v0, v1 })
    // RORB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    // RORB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RORB")
    }
    return p
}

// RORL performs "Rotate Right".
//
// Mnemonic        : ROR
// Supported forms : (6 forms)
//
//    * RORL 1, r32
//    * RORL imm8, r32
//    * RORL cl, r32
//    * RORL 1, m32
//    * RORL imm8, m32
//    * RORL cl, m32
//
func (self *Program) RORL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RORL", 2, Operands { v0, v1 })
    // RORL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    // RORL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RORL")
    }
    return p
}

// RORQ performs "Rotate Right".
//
// Mnemonic        : ROR
// Supported forms : (6 forms)
//
//    * RORQ 1, r64
//    * RORQ imm8, r64
//    * RORQ cl, r64
//    * RORQ 1, m64
//    * RORQ imm8, m64
//    * RORQ cl, m64
//
func (self *Program) RORQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RORQ", 2, Operands { v0, v1 })
    // RORQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    // RORQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RORQ")
    }
    return p
}

// RORW performs "Rotate Right".
//
// Mnemonic        : ROR
// Supported forms : (6 forms)
//
//    * RORW 1, r16
//    * RORW imm8, r16
//    * RORW cl, r16
//    * RORW 1, m16
//    * RORW imm8, m16
//    * RORW cl, m16
//
func (self *Program) RORW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RORW", 2, Operands { v0, v1 })
    // RORW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xc8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xc8 | lcode(v[1]))
        })
    }
    // RORW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    // RORW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(1, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(1, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RORW")
    }
    return p
}

// RORXL performs "Rotate Right Logical Without Affecting Flags".
//
// Mnemonic        : RORX
// Supported forms : (2 forms)
//
//    * RORXL imm8, r32, r32    [BMI2]
//    * RORXL imm8, m32, r32    [BMI2]
//
func (self *Program) RORXL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("RORXL", 3, Operands { v0, v1, v2 })
    // RORXL imm8, r32, r32
    if isImm8(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x7b)
            m.emit(0xf0)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORXL imm8, m32, r32
    if isImm8(v0) && isM32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b11, 0x03, hcode(v[2]), addr(v[1]), 0)
            m.emit(0xf0)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for RORXL")
    }
    return p
}

// RORXQ performs "Rotate Right Logical Without Affecting Flags".
//
// Mnemonic        : RORX
// Supported forms : (2 forms)
//
//    * RORXQ imm8, r64, r64    [BMI2]
//    * RORXQ imm8, m64, r64    [BMI2]
//
func (self *Program) RORXQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("RORXQ", 3, Operands { v0, v1, v2 })
    // RORXQ imm8, r64, r64
    if isImm8(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0xfb)
            m.emit(0xf0)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // RORXQ imm8, m64, r64
    if isImm8(v0) && isM64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b11, 0x83, hcode(v[2]), addr(v[1]), 0)
            m.emit(0xf0)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for RORXQ")
    }
    return p
}

// ROUNDPD performs "Round Packed Double Precision Floating-Point Values".
//
// Mnemonic        : ROUNDPD
// Supported forms : (2 forms)
//
//    * ROUNDPD imm8, xmm, xmm     [SSE4.1]
//    * ROUNDPD imm8, m128, xmm    [SSE4.1]
//
func (self *Program) ROUNDPD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("ROUNDPD", 3, Operands { v0, v1, v2 })
    // ROUNDPD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x09)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROUNDPD imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x09)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROUNDPD")
    }
    return p
}

// ROUNDPS performs "Round Packed Single Precision Floating-Point Values".
//
// Mnemonic        : ROUNDPS
// Supported forms : (2 forms)
//
//    * ROUNDPS imm8, xmm, xmm     [SSE4.1]
//    * ROUNDPS imm8, m128, xmm    [SSE4.1]
//
func (self *Program) ROUNDPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("ROUNDPS", 3, Operands { v0, v1, v2 })
    // ROUNDPS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x08)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROUNDPS imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x08)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROUNDPS")
    }
    return p
}

// ROUNDSD performs "Round Scalar Double Precision Floating-Point Values".
//
// Mnemonic        : ROUNDSD
// Supported forms : (2 forms)
//
//    * ROUNDSD imm8, xmm, xmm    [SSE4.1]
//    * ROUNDSD imm8, m64, xmm    [SSE4.1]
//
func (self *Program) ROUNDSD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("ROUNDSD", 3, Operands { v0, v1, v2 })
    // ROUNDSD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0b)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROUNDSD imm8, m64, xmm
    if isImm8(v0) && isM64(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0b)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROUNDSD")
    }
    return p
}

// ROUNDSS performs "Round Scalar Single Precision Floating-Point Values".
//
// Mnemonic        : ROUNDSS
// Supported forms : (2 forms)
//
//    * ROUNDSS imm8, xmm, xmm    [SSE4.1]
//    * ROUNDSS imm8, m32, xmm    [SSE4.1]
//
func (self *Program) ROUNDSS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("ROUNDSS", 3, Operands { v0, v1, v2 })
    // ROUNDSS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0a)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // ROUNDSS imm8, m32, xmm
    if isImm8(v0) && isM32(v1) && isXMM(v2) {
        self.require(ISA_SSE4_1)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0x0a)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for ROUNDSS")
    }
    return p
}

// RSQRTPS performs "Compute Reciprocals of Square Roots of Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : RSQRTPS
// Supported forms : (2 forms)
//
//    * RSQRTPS xmm, xmm     [SSE]
//    * RSQRTPS m128, xmm    [SSE]
//
func (self *Program) RSQRTPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RSQRTPS", 2, Operands { v0, v1 })
    // RSQRTPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x52)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // RSQRTPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x52)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RSQRTPS")
    }
    return p
}

// RSQRTSS performs "Compute Reciprocal of Square Root of Scalar Single-Precision Floating-Point Value".
//
// Mnemonic        : RSQRTSS
// Supported forms : (2 forms)
//
//    * RSQRTSS xmm, xmm    [SSE]
//    * RSQRTSS m32, xmm    [SSE]
//
func (self *Program) RSQRTSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("RSQRTSS", 2, Operands { v0, v1 })
    // RSQRTSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x52)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // RSQRTSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x52)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for RSQRTSS")
    }
    return p
}

// SALB performs "Arithmetic Shift Left".
//
// Mnemonic        : SAL
// Supported forms : (6 forms)
//
//    * SALB 1, r8
//    * SALB imm8, r8
//    * SALB cl, r8
//    * SALB 1, m8
//    * SALB imm8, m8
//    * SALB cl, m8
//
func (self *Program) SALB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SALB", 2, Operands { v0, v1 })
    // SALB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SALB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SALB")
    }
    return p
}

// SALL performs "Arithmetic Shift Left".
//
// Mnemonic        : SAL
// Supported forms : (6 forms)
//
//    * SALL 1, r32
//    * SALL imm8, r32
//    * SALL cl, r32
//    * SALL 1, m32
//    * SALL imm8, m32
//    * SALL cl, m32
//
func (self *Program) SALL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SALL", 2, Operands { v0, v1 })
    // SALL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SALL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SALL")
    }
    return p
}

// SALQ performs "Arithmetic Shift Left".
//
// Mnemonic        : SAL
// Supported forms : (6 forms)
//
//    * SALQ 1, r64
//    * SALQ imm8, r64
//    * SALQ cl, r64
//    * SALQ 1, m64
//    * SALQ imm8, m64
//    * SALQ cl, m64
//
func (self *Program) SALQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SALQ", 2, Operands { v0, v1 })
    // SALQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SALQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SALQ")
    }
    return p
}

// SALW performs "Arithmetic Shift Left".
//
// Mnemonic        : SAL
// Supported forms : (6 forms)
//
//    * SALW 1, r16
//    * SALW imm8, r16
//    * SALW cl, r16
//    * SALW 1, m16
//    * SALW imm8, m16
//    * SALW cl, m16
//
func (self *Program) SALW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SALW", 2, Operands { v0, v1 })
    // SALW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SALW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SALW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SALW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SALW")
    }
    return p
}

// SARB performs "Arithmetic Shift Right".
//
// Mnemonic        : SAR
// Supported forms : (6 forms)
//
//    * SARB 1, r8
//    * SARB imm8, r8
//    * SARB cl, r8
//    * SARB 1, m8
//    * SARB imm8, m8
//    * SARB cl, m8
//
func (self *Program) SARB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SARB", 2, Operands { v0, v1 })
    // SARB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    // SARB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SARB")
    }
    return p
}

// SARL performs "Arithmetic Shift Right".
//
// Mnemonic        : SAR
// Supported forms : (6 forms)
//
//    * SARL 1, r32
//    * SARL imm8, r32
//    * SARL cl, r32
//    * SARL 1, m32
//    * SARL imm8, m32
//    * SARL cl, m32
//
func (self *Program) SARL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SARL", 2, Operands { v0, v1 })
    // SARL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    // SARL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SARL")
    }
    return p
}

// SARQ performs "Arithmetic Shift Right".
//
// Mnemonic        : SAR
// Supported forms : (6 forms)
//
//    * SARQ 1, r64
//    * SARQ imm8, r64
//    * SARQ cl, r64
//    * SARQ 1, m64
//    * SARQ imm8, m64
//    * SARQ cl, m64
//
func (self *Program) SARQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SARQ", 2, Operands { v0, v1 })
    // SARQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    // SARQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SARQ")
    }
    return p
}

// SARW performs "Arithmetic Shift Right".
//
// Mnemonic        : SAR
// Supported forms : (6 forms)
//
//    * SARW 1, r16
//    * SARW imm8, r16
//    * SARW cl, r16
//    * SARW 1, m16
//    * SARW imm8, m16
//    * SARW cl, m16
//
func (self *Program) SARW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SARW", 2, Operands { v0, v1 })
    // SARW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xf8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xf8 | lcode(v[1]))
        })
    }
    // SARW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    // SARW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(7, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SARW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(7, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SARW")
    }
    return p
}

// SARXL performs "Arithmetic Shift Right Without Affecting Flags".
//
// Mnemonic        : SARX
// Supported forms : (2 forms)
//
//    * SARXL r32, r32, r32    [BMI2]
//    * SARXL r32, m32, r32    [BMI2]
//
func (self *Program) SARXL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SARXL", 3, Operands { v0, v1, v2 })
    // SARXL r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x7a ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // SARXL r32, m32, r32
    if isReg32(v0) && isM32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x02, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SARXL")
    }
    return p
}

// SARXQ performs "Arithmetic Shift Right Without Affecting Flags".
//
// Mnemonic        : SARX
// Supported forms : (2 forms)
//
//    * SARXQ r64, r64, r64    [BMI2]
//    * SARXQ r64, m64, r64    [BMI2]
//
func (self *Program) SARXQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SARXQ", 3, Operands { v0, v1, v2 })
    // SARXQ r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0xfa ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // SARXQ r64, m64, r64
    if isReg64(v0) && isM64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x82, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SARXQ")
    }
    return p
}

// SBBB performs "Subtract with Borrow".
//
// Mnemonic        : SBB
// Supported forms : (6 forms)
//
//    * SBBB imm8, al
//    * SBBB imm8, r8
//    * SBBB r8, r8
//    * SBBB m8, r8
//    * SBBB imm8, m8
//    * SBBB r8, m8
//
func (self *Program) SBBB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SBBB", 2, Operands { v0, v1 })
    // SBBB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x1c)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0x80)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x18)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x1a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SBBB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x1a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SBBB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x80)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x18)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SBBB")
    }
    return p
}

// SBBL performs "Subtract with Borrow".
//
// Mnemonic        : SBB
// Supported forms : (8 forms)
//
//    * SBBL imm32, eax
//    * SBBL imm8, r32
//    * SBBL imm32, r32
//    * SBBL r32, r32
//    * SBBL m32, r32
//    * SBBL imm8, m32
//    * SBBL imm32, m32
//    * SBBL r32, m32
//
func (self *Program) SBBL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SBBL", 2, Operands { v0, v1 })
    // SBBL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x1d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SBBL imm8, r32
    if isImm8Ext(v0, 4) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xd8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // SBBL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x19)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x1b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SBBL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x1b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SBBL imm8, m32
    if isImm8Ext(v0, 4) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(3, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SBBL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x19)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SBBL")
    }
    return p
}

// SBBQ performs "Subtract with Borrow".
//
// Mnemonic        : SBB
// Supported forms : (8 forms)
//
//    * SBBQ imm32, rax
//    * SBBQ imm8, r64
//    * SBBQ imm32, r64
//    * SBBQ r64, r64
//    * SBBQ m64, r64
//    * SBBQ imm8, m64
//    * SBBQ imm32, m64
//    * SBBQ r64, m64
//
func (self *Program) SBBQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SBBQ", 2, Operands { v0, v1 })
    // SBBQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0x1d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SBBQ imm8, r64
    if isImm8Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x83)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x81)
            m.emit(0xd8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // SBBQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x19)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x1b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SBBQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x1b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SBBQ imm8, m64
    if isImm8Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x83)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x81)
            m.mrsd(3, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SBBQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x19)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SBBQ")
    }
    return p
}

// SBBW performs "Subtract with Borrow".
//
// Mnemonic        : SBB
// Supported forms : (8 forms)
//
//    * SBBW imm16, ax
//    * SBBW imm8, r16
//    * SBBW imm16, r16
//    * SBBW r16, r16
//    * SBBW m16, r16
//    * SBBW imm8, m16
//    * SBBW imm16, m16
//    * SBBW r16, m16
//
func (self *Program) SBBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SBBW", 2, Operands { v0, v1 })
    // SBBW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x1d)
            m.imm2(toImmAny(v[0]))
        })
    }
    // SBBW imm8, r16
    if isImm8Ext(v0, 2) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xd8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xd8 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // SBBW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x19)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x1b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SBBW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x1b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SBBW imm8, m16
    if isImm8Ext(v0, 2) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(3, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SBBW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(3, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // SBBW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x19)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SBBW")
    }
    return p
}

// SETA performs "Set byte if above (CF == 0 and ZF == 0)".
//
// Mnemonic        : SETA
// Supported forms : (2 forms)
//
//    * SETA r8
//    * SETA m8
//
func (self *Program) SETA(v0 interface{}) *Instruction {
    p := self.alloc("SETA", 1, Operands { v0 })
    // SETA r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x97)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETA m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x97)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETA")
    }
    return p
}

// SETAE performs "Set byte if above or equal (CF == 0)".
//
// Mnemonic        : SETAE
// Supported forms : (2 forms)
//
//    * SETAE r8
//    * SETAE m8
//
func (self *Program) SETAE(v0 interface{}) *Instruction {
    p := self.alloc("SETAE", 1, Operands { v0 })
    // SETAE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x93)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETAE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x93)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETAE")
    }
    return p
}

// SETB performs "Set byte if below (CF == 1)".
//
// Mnemonic        : SETB
// Supported forms : (2 forms)
//
//    * SETB r8
//    * SETB m8
//
func (self *Program) SETB(v0 interface{}) *Instruction {
    p := self.alloc("SETB", 1, Operands { v0 })
    // SETB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x92)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x92)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETB")
    }
    return p
}

// SETBE performs "Set byte if below or equal (CF == 1 or ZF == 1)".
//
// Mnemonic        : SETBE
// Supported forms : (2 forms)
//
//    * SETBE r8
//    * SETBE m8
//
func (self *Program) SETBE(v0 interface{}) *Instruction {
    p := self.alloc("SETBE", 1, Operands { v0 })
    // SETBE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x96)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETBE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x96)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETBE")
    }
    return p
}

// SETC performs "Set byte if carry (CF == 1)".
//
// Mnemonic        : SETC
// Supported forms : (2 forms)
//
//    * SETC r8
//    * SETC m8
//
func (self *Program) SETC(v0 interface{}) *Instruction {
    p := self.alloc("SETC", 1, Operands { v0 })
    // SETC r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x92)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETC m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x92)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETC")
    }
    return p
}

// SETE performs "Set byte if equal (ZF == 1)".
//
// Mnemonic        : SETE
// Supported forms : (2 forms)
//
//    * SETE r8
//    * SETE m8
//
func (self *Program) SETE(v0 interface{}) *Instruction {
    p := self.alloc("SETE", 1, Operands { v0 })
    // SETE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x94)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x94)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETE")
    }
    return p
}

// SETG performs "Set byte if greater (ZF == 0 and SF == OF)".
//
// Mnemonic        : SETG
// Supported forms : (2 forms)
//
//    * SETG r8
//    * SETG m8
//
func (self *Program) SETG(v0 interface{}) *Instruction {
    p := self.alloc("SETG", 1, Operands { v0 })
    // SETG r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9f)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETG m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9f)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETG")
    }
    return p
}

// SETGE performs "Set byte if greater or equal (SF == OF)".
//
// Mnemonic        : SETGE
// Supported forms : (2 forms)
//
//    * SETGE r8
//    * SETGE m8
//
func (self *Program) SETGE(v0 interface{}) *Instruction {
    p := self.alloc("SETGE", 1, Operands { v0 })
    // SETGE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9d)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETGE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9d)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETGE")
    }
    return p
}

// SETL performs "Set byte if less (SF != OF)".
//
// Mnemonic        : SETL
// Supported forms : (2 forms)
//
//    * SETL r8
//    * SETL m8
//
func (self *Program) SETL(v0 interface{}) *Instruction {
    p := self.alloc("SETL", 1, Operands { v0 })
    // SETL r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9c)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETL m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9c)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETL")
    }
    return p
}

// SETLE performs "Set byte if less or equal (ZF == 1 or SF != OF)".
//
// Mnemonic        : SETLE
// Supported forms : (2 forms)
//
//    * SETLE r8
//    * SETLE m8
//
func (self *Program) SETLE(v0 interface{}) *Instruction {
    p := self.alloc("SETLE", 1, Operands { v0 })
    // SETLE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9e)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETLE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9e)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETLE")
    }
    return p
}

// SETNA performs "Set byte if not above (CF == 1 or ZF == 1)".
//
// Mnemonic        : SETNA
// Supported forms : (2 forms)
//
//    * SETNA r8
//    * SETNA m8
//
func (self *Program) SETNA(v0 interface{}) *Instruction {
    p := self.alloc("SETNA", 1, Operands { v0 })
    // SETNA r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x96)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNA m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x96)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNA")
    }
    return p
}

// SETNAE performs "Set byte if not above or equal (CF == 1)".
//
// Mnemonic        : SETNAE
// Supported forms : (2 forms)
//
//    * SETNAE r8
//    * SETNAE m8
//
func (self *Program) SETNAE(v0 interface{}) *Instruction {
    p := self.alloc("SETNAE", 1, Operands { v0 })
    // SETNAE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x92)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNAE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x92)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNAE")
    }
    return p
}

// SETNB performs "Set byte if not below (CF == 0)".
//
// Mnemonic        : SETNB
// Supported forms : (2 forms)
//
//    * SETNB r8
//    * SETNB m8
//
func (self *Program) SETNB(v0 interface{}) *Instruction {
    p := self.alloc("SETNB", 1, Operands { v0 })
    // SETNB r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x93)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNB m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x93)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNB")
    }
    return p
}

// SETNBE performs "Set byte if not below or equal (CF == 0 and ZF == 0)".
//
// Mnemonic        : SETNBE
// Supported forms : (2 forms)
//
//    * SETNBE r8
//    * SETNBE m8
//
func (self *Program) SETNBE(v0 interface{}) *Instruction {
    p := self.alloc("SETNBE", 1, Operands { v0 })
    // SETNBE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x97)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNBE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x97)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNBE")
    }
    return p
}

// SETNC performs "Set byte if not carry (CF == 0)".
//
// Mnemonic        : SETNC
// Supported forms : (2 forms)
//
//    * SETNC r8
//    * SETNC m8
//
func (self *Program) SETNC(v0 interface{}) *Instruction {
    p := self.alloc("SETNC", 1, Operands { v0 })
    // SETNC r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x93)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNC m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x93)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNC")
    }
    return p
}

// SETNE performs "Set byte if not equal (ZF == 0)".
//
// Mnemonic        : SETNE
// Supported forms : (2 forms)
//
//    * SETNE r8
//    * SETNE m8
//
func (self *Program) SETNE(v0 interface{}) *Instruction {
    p := self.alloc("SETNE", 1, Operands { v0 })
    // SETNE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x95)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x95)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNE")
    }
    return p
}

// SETNG performs "Set byte if not greater (ZF == 1 or SF != OF)".
//
// Mnemonic        : SETNG
// Supported forms : (2 forms)
//
//    * SETNG r8
//    * SETNG m8
//
func (self *Program) SETNG(v0 interface{}) *Instruction {
    p := self.alloc("SETNG", 1, Operands { v0 })
    // SETNG r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9e)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNG m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9e)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNG")
    }
    return p
}

// SETNGE performs "Set byte if not greater or equal (SF != OF)".
//
// Mnemonic        : SETNGE
// Supported forms : (2 forms)
//
//    * SETNGE r8
//    * SETNGE m8
//
func (self *Program) SETNGE(v0 interface{}) *Instruction {
    p := self.alloc("SETNGE", 1, Operands { v0 })
    // SETNGE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9c)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNGE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9c)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNGE")
    }
    return p
}

// SETNL performs "Set byte if not less (SF == OF)".
//
// Mnemonic        : SETNL
// Supported forms : (2 forms)
//
//    * SETNL r8
//    * SETNL m8
//
func (self *Program) SETNL(v0 interface{}) *Instruction {
    p := self.alloc("SETNL", 1, Operands { v0 })
    // SETNL r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9d)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNL m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9d)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNL")
    }
    return p
}

// SETNLE performs "Set byte if not less or equal (ZF == 0 and SF == OF)".
//
// Mnemonic        : SETNLE
// Supported forms : (2 forms)
//
//    * SETNLE r8
//    * SETNLE m8
//
func (self *Program) SETNLE(v0 interface{}) *Instruction {
    p := self.alloc("SETNLE", 1, Operands { v0 })
    // SETNLE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9f)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNLE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9f)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNLE")
    }
    return p
}

// SETNO performs "Set byte if not overflow (OF == 0)".
//
// Mnemonic        : SETNO
// Supported forms : (2 forms)
//
//    * SETNO r8
//    * SETNO m8
//
func (self *Program) SETNO(v0 interface{}) *Instruction {
    p := self.alloc("SETNO", 1, Operands { v0 })
    // SETNO r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x91)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNO m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x91)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNO")
    }
    return p
}

// SETNP performs "Set byte if not parity (PF == 0)".
//
// Mnemonic        : SETNP
// Supported forms : (2 forms)
//
//    * SETNP r8
//    * SETNP m8
//
func (self *Program) SETNP(v0 interface{}) *Instruction {
    p := self.alloc("SETNP", 1, Operands { v0 })
    // SETNP r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9b)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNP m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9b)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNP")
    }
    return p
}

// SETNS performs "Set byte if not sign (SF == 0)".
//
// Mnemonic        : SETNS
// Supported forms : (2 forms)
//
//    * SETNS r8
//    * SETNS m8
//
func (self *Program) SETNS(v0 interface{}) *Instruction {
    p := self.alloc("SETNS", 1, Operands { v0 })
    // SETNS r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x99)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNS m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x99)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNS")
    }
    return p
}

// SETNZ performs "Set byte if not zero (ZF == 0)".
//
// Mnemonic        : SETNZ
// Supported forms : (2 forms)
//
//    * SETNZ r8
//    * SETNZ m8
//
func (self *Program) SETNZ(v0 interface{}) *Instruction {
    p := self.alloc("SETNZ", 1, Operands { v0 })
    // SETNZ r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x95)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETNZ m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x95)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETNZ")
    }
    return p
}

// SETO performs "Set byte if overflow (OF == 1)".
//
// Mnemonic        : SETO
// Supported forms : (2 forms)
//
//    * SETO r8
//    * SETO m8
//
func (self *Program) SETO(v0 interface{}) *Instruction {
    p := self.alloc("SETO", 1, Operands { v0 })
    // SETO r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x90)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETO m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x90)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETO")
    }
    return p
}

// SETP performs "Set byte if parity (PF == 1)".
//
// Mnemonic        : SETP
// Supported forms : (2 forms)
//
//    * SETP r8
//    * SETP m8
//
func (self *Program) SETP(v0 interface{}) *Instruction {
    p := self.alloc("SETP", 1, Operands { v0 })
    // SETP r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9a)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETP m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9a)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETP")
    }
    return p
}

// SETPE performs "Set byte if parity even (PF == 1)".
//
// Mnemonic        : SETPE
// Supported forms : (2 forms)
//
//    * SETPE r8
//    * SETPE m8
//
func (self *Program) SETPE(v0 interface{}) *Instruction {
    p := self.alloc("SETPE", 1, Operands { v0 })
    // SETPE r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9a)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETPE m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9a)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETPE")
    }
    return p
}

// SETPO performs "Set byte if parity odd (PF == 0)".
//
// Mnemonic        : SETPO
// Supported forms : (2 forms)
//
//    * SETPO r8
//    * SETPO m8
//
func (self *Program) SETPO(v0 interface{}) *Instruction {
    p := self.alloc("SETPO", 1, Operands { v0 })
    // SETPO r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x9b)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETPO m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x9b)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETPO")
    }
    return p
}

// SETS performs "Set byte if sign (SF == 1)".
//
// Mnemonic        : SETS
// Supported forms : (2 forms)
//
//    * SETS r8
//    * SETS m8
//
func (self *Program) SETS(v0 interface{}) *Instruction {
    p := self.alloc("SETS", 1, Operands { v0 })
    // SETS r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x98)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETS m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x98)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETS")
    }
    return p
}

// SETZ performs "Set byte if zero (ZF == 1)".
//
// Mnemonic        : SETZ
// Supported forms : (2 forms)
//
//    * SETZ r8
//    * SETZ m8
//
func (self *Program) SETZ(v0 interface{}) *Instruction {
    p := self.alloc("SETZ", 1, Operands { v0 })
    // SETZ r8
    if isReg8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[0], isReg8REX(v[0]))
            m.emit(0x0f)
            m.emit(0x94)
            m.emit(0xc0 | lcode(v[0]))
        })
    }
    // SETZ m8
    if isM8(v0) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x94)
            m.mrsd(0, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SETZ")
    }
    return p
}

// SFENCE performs "Store Fence".
//
// Mnemonic        : SFENCE
// Supported forms : (1 form)
//
//    * SFENCE    [MMX+]
//
func (self *Program) SFENCE() *Instruction {
    p := self.alloc("SFENCE", 0, Operands {  })
    // SFENCE
    self.require(ISA_MMX_PLUS)
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0xae)
        m.emit(0xf8)
    })
    return p
}

// SHA1MSG1 performs "Perform an Intermediate Calculation for the Next Four SHA1 Message Doublewords".
//
// Mnemonic        : SHA1MSG1
// Supported forms : (2 forms)
//
//    * SHA1MSG1 xmm, xmm     [SHA]
//    * SHA1MSG1 m128, xmm    [SHA]
//
func (self *Program) SHA1MSG1(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHA1MSG1", 2, Operands { v0, v1 })
    // SHA1MSG1 xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xc9)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SHA1MSG1 m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xc9)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHA1MSG1")
    }
    return p
}

// SHA1MSG2 performs "Perform a Final Calculation for the Next Four SHA1 Message Doublewords".
//
// Mnemonic        : SHA1MSG2
// Supported forms : (2 forms)
//
//    * SHA1MSG2 xmm, xmm     [SHA]
//    * SHA1MSG2 m128, xmm    [SHA]
//
func (self *Program) SHA1MSG2(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHA1MSG2", 2, Operands { v0, v1 })
    // SHA1MSG2 xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xca)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SHA1MSG2 m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xca)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHA1MSG2")
    }
    return p
}

// SHA1NEXTE performs "Calculate SHA1 State Variable E after Four Rounds".
//
// Mnemonic        : SHA1NEXTE
// Supported forms : (2 forms)
//
//    * SHA1NEXTE xmm, xmm     [SHA]
//    * SHA1NEXTE m128, xmm    [SHA]
//
func (self *Program) SHA1NEXTE(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHA1NEXTE", 2, Operands { v0, v1 })
    // SHA1NEXTE xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xc8)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SHA1NEXTE m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xc8)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHA1NEXTE")
    }
    return p
}

// SHA1RNDS4 performs "Perform Four Rounds of SHA1 Operation".
//
// Mnemonic        : SHA1RNDS4
// Supported forms : (2 forms)
//
//    * SHA1RNDS4 imm8, xmm, xmm     [SHA]
//    * SHA1RNDS4 imm8, m128, xmm    [SHA]
//
func (self *Program) SHA1RNDS4(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHA1RNDS4", 3, Operands { v0, v1, v2 })
    // SHA1RNDS4 imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0xcc)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHA1RNDS4 imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x3a)
            m.emit(0xcc)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHA1RNDS4")
    }
    return p
}

// SHA256MSG1 performs "Perform an Intermediate Calculation for the Next Four SHA256 Message Doublewords".
//
// Mnemonic        : SHA256MSG1
// Supported forms : (2 forms)
//
//    * SHA256MSG1 xmm, xmm     [SHA]
//    * SHA256MSG1 m128, xmm    [SHA]
//
func (self *Program) SHA256MSG1(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHA256MSG1", 2, Operands { v0, v1 })
    // SHA256MSG1 xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xcc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SHA256MSG1 m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xcc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHA256MSG1")
    }
    return p
}

// SHA256MSG2 performs "Perform a Final Calculation for the Next Four SHA256 Message Doublewords".
//
// Mnemonic        : SHA256MSG2
// Supported forms : (2 forms)
//
//    * SHA256MSG2 xmm, xmm     [SHA]
//    * SHA256MSG2 m128, xmm    [SHA]
//
func (self *Program) SHA256MSG2(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHA256MSG2", 2, Operands { v0, v1 })
    // SHA256MSG2 xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xcd)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SHA256MSG2 m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xcd)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHA256MSG2")
    }
    return p
}

// SHA256RNDS2 performs "Perform Two Rounds of SHA256 Operation".
//
// Mnemonic        : SHA256RNDS2
// Supported forms : (2 forms)
//
//    * SHA256RNDS2 xmm0, xmm, xmm     [SHA]
//    * SHA256RNDS2 xmm0, m128, xmm    [SHA]
//
func (self *Program) SHA256RNDS2(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHA256RNDS2", 3, Operands { v0, v1, v2 })
    // SHA256RNDS2 xmm0, xmm, xmm
    if v0 == XMM0 && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xcb)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // SHA256RNDS2 xmm0, m128, xmm
    if v0 == XMM0 && isM128(v1) && isXMM(v2) {
        self.require(ISA_SHA)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0x38)
            m.emit(0xcb)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHA256RNDS2")
    }
    return p
}

// SHLB performs "Logical Shift Left".
//
// Mnemonic        : SHL
// Supported forms : (6 forms)
//
//    * SHLB 1, r8
//    * SHLB imm8, r8
//    * SHLB cl, r8
//    * SHLB 1, m8
//    * SHLB imm8, m8
//    * SHLB cl, m8
//
func (self *Program) SHLB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHLB", 2, Operands { v0, v1 })
    // SHLB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SHLB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLB")
    }
    return p
}

// SHLDL performs "Integer Double Precision Shift Left".
//
// Mnemonic        : SHLD
// Supported forms : (4 forms)
//
//    * SHLDL imm8, r32, r32
//    * SHLDL cl, r32, r32
//    * SHLDL imm8, r32, m32
//    * SHLDL cl, r32, m32
//
func (self *Program) SHLDL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHLDL", 3, Operands { v0, v1, v2 })
    // SHLDL imm8, r32, r32
    if isImm8(v0) && isReg32(v1) && isReg32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xa4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLDL cl, r32, r32
    if v0 == CL && isReg32(v1) && isReg32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xa5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
        })
    }
    // SHLDL imm8, r32, m32
    if isImm8(v0) && isReg32(v1) && isM32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xa4)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLDL cl, r32, m32
    if v0 == CL && isReg32(v1) && isM32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xa5)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLDL")
    }
    return p
}

// SHLDQ performs "Integer Double Precision Shift Left".
//
// Mnemonic        : SHLD
// Supported forms : (4 forms)
//
//    * SHLDQ imm8, r64, r64
//    * SHLDQ cl, r64, r64
//    * SHLDQ imm8, r64, m64
//    * SHLDQ cl, r64, m64
//
func (self *Program) SHLDQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHLDQ", 3, Operands { v0, v1, v2 })
    // SHLDQ imm8, r64, r64
    if isImm8(v0) && isReg64(v1) && isReg64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[2]))
            m.emit(0x0f)
            m.emit(0xa4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLDQ cl, r64, r64
    if v0 == CL && isReg64(v1) && isReg64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[2]))
            m.emit(0x0f)
            m.emit(0xa5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
        })
    }
    // SHLDQ imm8, r64, m64
    if isImm8(v0) && isReg64(v1) && isM64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[2]))
            m.emit(0x0f)
            m.emit(0xa4)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLDQ cl, r64, m64
    if v0 == CL && isReg64(v1) && isM64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[2]))
            m.emit(0x0f)
            m.emit(0xa5)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLDQ")
    }
    return p
}

// SHLDW performs "Integer Double Precision Shift Left".
//
// Mnemonic        : SHLD
// Supported forms : (4 forms)
//
//    * SHLDW imm8, r16, r16
//    * SHLDW cl, r16, r16
//    * SHLDW imm8, r16, m16
//    * SHLDW cl, r16, m16
//
func (self *Program) SHLDW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHLDW", 3, Operands { v0, v1, v2 })
    // SHLDW imm8, r16, r16
    if isImm8(v0) && isReg16(v1) && isReg16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xa4)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLDW cl, r16, r16
    if v0 == CL && isReg16(v1) && isReg16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xa5)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
        })
    }
    // SHLDW imm8, r16, m16
    if isImm8(v0) && isReg16(v1) && isM16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xa4)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLDW cl, r16, m16
    if v0 == CL && isReg16(v1) && isM16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xa5)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLDW")
    }
    return p
}

// SHLL performs "Logical Shift Left".
//
// Mnemonic        : SHL
// Supported forms : (6 forms)
//
//    * SHLL 1, r32
//    * SHLL imm8, r32
//    * SHLL cl, r32
//    * SHLL 1, m32
//    * SHLL imm8, m32
//    * SHLL cl, m32
//
func (self *Program) SHLL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHLL", 2, Operands { v0, v1 })
    // SHLL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SHLL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLL")
    }
    return p
}

// SHLQ performs "Logical Shift Left".
//
// Mnemonic        : SHL
// Supported forms : (6 forms)
//
//    * SHLQ 1, r64
//    * SHLQ imm8, r64
//    * SHLQ cl, r64
//    * SHLQ 1, m64
//    * SHLQ imm8, m64
//    * SHLQ cl, m64
//
func (self *Program) SHLQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHLQ", 2, Operands { v0, v1 })
    // SHLQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SHLQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLQ")
    }
    return p
}

// SHLW performs "Logical Shift Left".
//
// Mnemonic        : SHL
// Supported forms : (6 forms)
//
//    * SHLW 1, r16
//    * SHLW imm8, r16
//    * SHLW cl, r16
//    * SHLW 1, m16
//    * SHLW imm8, m16
//    * SHLW cl, m16
//
func (self *Program) SHLW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHLW", 2, Operands { v0, v1 })
    // SHLW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xe0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xe0 | lcode(v[1]))
        })
    }
    // SHLW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    // SHLW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(4, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHLW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(4, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLW")
    }
    return p
}

// SHLXL performs "Logical Shift Left Without Affecting Flags".
//
// Mnemonic        : SHLX
// Supported forms : (2 forms)
//
//    * SHLXL r32, r32, r32    [BMI2]
//    * SHLXL r32, m32, r32    [BMI2]
//
func (self *Program) SHLXL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHLXL", 3, Operands { v0, v1, v2 })
    // SHLXL r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x79 ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // SHLXL r32, m32, r32
    if isReg32(v0) && isM32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x01, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLXL")
    }
    return p
}

// SHLXQ performs "Logical Shift Left Without Affecting Flags".
//
// Mnemonic        : SHLX
// Supported forms : (2 forms)
//
//    * SHLXQ r64, r64, r64    [BMI2]
//    * SHLXQ r64, m64, r64    [BMI2]
//
func (self *Program) SHLXQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHLXQ", 3, Operands { v0, v1, v2 })
    // SHLXQ r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0xf9 ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // SHLXQ r64, m64, r64
    if isReg64(v0) && isM64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x81, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHLXQ")
    }
    return p
}

// SHRB performs "Logical Shift Right".
//
// Mnemonic        : SHR
// Supported forms : (6 forms)
//
//    * SHRB 1, r8
//    * SHRB imm8, r8
//    * SHRB cl, r8
//    * SHRB 1, m8
//    * SHRB imm8, m8
//    * SHRB cl, m8
//
func (self *Program) SHRB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHRB", 2, Operands { v0, v1 })
    // SHRB 1, r8
    if isConst1(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd0)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xc0)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRB cl, r8
    if v0 == CL && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xd2)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRB 1, m8
    if isConst1(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd0)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    // SHRB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc0)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRB cl, m8
    if v0 == CL && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd2)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRB")
    }
    return p
}

// SHRDL performs "Integer Double Precision Shift Right".
//
// Mnemonic        : SHRD
// Supported forms : (4 forms)
//
//    * SHRDL imm8, r32, r32
//    * SHRDL cl, r32, r32
//    * SHRDL imm8, r32, m32
//    * SHRDL cl, r32, m32
//
func (self *Program) SHRDL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHRDL", 3, Operands { v0, v1, v2 })
    // SHRDL imm8, r32, r32
    if isImm8(v0) && isReg32(v1) && isReg32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xac)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRDL cl, r32, r32
    if v0 == CL && isReg32(v1) && isReg32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xad)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
        })
    }
    // SHRDL imm8, r32, m32
    if isImm8(v0) && isReg32(v1) && isM32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xac)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRDL cl, r32, m32
    if v0 == CL && isReg32(v1) && isM32(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xad)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRDL")
    }
    return p
}

// SHRDQ performs "Integer Double Precision Shift Right".
//
// Mnemonic        : SHRD
// Supported forms : (4 forms)
//
//    * SHRDQ imm8, r64, r64
//    * SHRDQ cl, r64, r64
//    * SHRDQ imm8, r64, m64
//    * SHRDQ cl, r64, m64
//
func (self *Program) SHRDQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHRDQ", 3, Operands { v0, v1, v2 })
    // SHRDQ imm8, r64, r64
    if isImm8(v0) && isReg64(v1) && isReg64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[2]))
            m.emit(0x0f)
            m.emit(0xac)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRDQ cl, r64, r64
    if v0 == CL && isReg64(v1) && isReg64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[2]))
            m.emit(0x0f)
            m.emit(0xad)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
        })
    }
    // SHRDQ imm8, r64, m64
    if isImm8(v0) && isReg64(v1) && isM64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[2]))
            m.emit(0x0f)
            m.emit(0xac)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRDQ cl, r64, m64
    if v0 == CL && isReg64(v1) && isM64(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[2]))
            m.emit(0x0f)
            m.emit(0xad)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRDQ")
    }
    return p
}

// SHRDW performs "Integer Double Precision Shift Right".
//
// Mnemonic        : SHRD
// Supported forms : (4 forms)
//
//    * SHRDW imm8, r16, r16
//    * SHRDW cl, r16, r16
//    * SHRDW imm8, r16, m16
//    * SHRDW cl, r16, m16
//
func (self *Program) SHRDW(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHRDW", 3, Operands { v0, v1, v2 })
    // SHRDW imm8, r16, r16
    if isImm8(v0) && isReg16(v1) && isReg16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xac)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRDW cl, r16, r16
    if v0 == CL && isReg16(v1) && isReg16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[2], false)
            m.emit(0x0f)
            m.emit(0xad)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[2]))
        })
    }
    // SHRDW imm8, r16, m16
    if isImm8(v0) && isReg16(v1) && isM16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xac)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRDW cl, r16, m16
    if v0 == CL && isReg16(v1) && isM16(v2) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[2]), false)
            m.emit(0x0f)
            m.emit(0xad)
            m.mrsd(lcode(v[1]), addr(v[2]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRDW")
    }
    return p
}

// SHRL performs "Logical Shift Right".
//
// Mnemonic        : SHR
// Supported forms : (6 forms)
//
//    * SHRL 1, r32
//    * SHRL imm8, r32
//    * SHRL cl, r32
//    * SHRL 1, m32
//    * SHRL imm8, m32
//    * SHRL cl, m32
//
func (self *Program) SHRL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHRL", 2, Operands { v0, v1 })
    // SHRL 1, r32
    if isConst1(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRL imm8, r32
    if isImm8(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRL cl, r32
    if v0 == CL && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRL 1, m32
    if isConst1(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    // SHRL imm8, m32
    if isImm8(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRL cl, m32
    if v0 == CL && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRL")
    }
    return p
}

// SHRQ performs "Logical Shift Right".
//
// Mnemonic        : SHR
// Supported forms : (6 forms)
//
//    * SHRQ 1, r64
//    * SHRQ imm8, r64
//    * SHRQ cl, r64
//    * SHRQ 1, m64
//    * SHRQ imm8, m64
//    * SHRQ cl, m64
//
func (self *Program) SHRQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHRQ", 2, Operands { v0, v1 })
    // SHRQ 1, r64
    if isConst1(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd1)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRQ imm8, r64
    if isImm8(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xc1)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRQ cl, r64
    if v0 == CL && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xd3)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRQ 1, m64
    if isConst1(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd1)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    // SHRQ imm8, m64
    if isImm8(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xc1)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRQ cl, m64
    if v0 == CL && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xd3)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRQ")
    }
    return p
}

// SHRW performs "Logical Shift Right".
//
// Mnemonic        : SHR
// Supported forms : (6 forms)
//
//    * SHRW 1, r16
//    * SHRW imm8, r16
//    * SHRW cl, r16
//    * SHRW 1, m16
//    * SHRW imm8, m16
//    * SHRW cl, m16
//
func (self *Program) SHRW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SHRW", 2, Operands { v0, v1 })
    // SHRW 1, r16
    if isConst1(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd1)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRW imm8, r16
    if isImm8(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xc1)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRW cl, r16
    if v0 == CL && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xd3)
            m.emit(0xe8 | lcode(v[1]))
        })
    }
    // SHRW 1, m16
    if isConst1(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd1)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    // SHRW imm8, m16
    if isImm8(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xc1)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHRW cl, m16
    if v0 == CL && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xd3)
            m.mrsd(5, addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRW")
    }
    return p
}

// SHRXL performs "Logical Shift Right Without Affecting Flags".
//
// Mnemonic        : SHRX
// Supported forms : (2 forms)
//
//    * SHRXL r32, r32, r32    [BMI2]
//    * SHRXL r32, m32, r32    [BMI2]
//
func (self *Program) SHRXL(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHRXL", 3, Operands { v0, v1, v2 })
    // SHRXL r32, r32, r32
    if isReg32(v0) && isReg32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x7b ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // SHRXL r32, m32, r32
    if isReg32(v0) && isM32(v1) && isReg32(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x03, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRXL")
    }
    return p
}

// SHRXQ performs "Logical Shift Right Without Affecting Flags".
//
// Mnemonic        : SHRX
// Supported forms : (2 forms)
//
//    * SHRXQ r64, r64, r64    [BMI2]
//    * SHRXQ r64, m64, r64    [BMI2]
//
func (self *Program) SHRXQ(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHRXQ", 3, Operands { v0, v1, v2 })
    // SHRXQ r64, r64, r64
    if isReg64(v0) && isReg64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0xfb ^ (hlcode(v[0]) << 3))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
        })
    }
    // SHRXQ r64, m64, r64
    if isReg64(v0) && isM64(v1) && isReg64(v2) {
        self.require(ISA_BMI2)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x83, hcode(v[2]), addr(v[1]), hlcode(v[0]))
            m.emit(0xf7)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHRXQ")
    }
    return p
}

// SHUFPD performs "Shuffle Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : SHUFPD
// Supported forms : (2 forms)
//
//    * SHUFPD imm8, xmm, xmm     [SSE2]
//    * SHUFPD imm8, m128, xmm    [SSE2]
//
func (self *Program) SHUFPD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHUFPD", 3, Operands { v0, v1, v2 })
    // SHUFPD imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc6)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHUFPD imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc6)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHUFPD")
    }
    return p
}

// SHUFPS performs "Shuffle Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : SHUFPS
// Supported forms : (2 forms)
//
//    * SHUFPS imm8, xmm, xmm     [SSE]
//    * SHUFPS imm8, m128, xmm    [SSE]
//
func (self *Program) SHUFPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("SHUFPS", 3, Operands { v0, v1, v2 })
    // SHUFPS imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), v[1], false)
            m.emit(0x0f)
            m.emit(0xc6)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SHUFPS imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[2]), addr(v[1]), false)
            m.emit(0x0f)
            m.emit(0xc6)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for SHUFPS")
    }
    return p
}

// SQRTPD performs "Compute Square Roots of Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : SQRTPD
// Supported forms : (2 forms)
//
//    * SQRTPD xmm, xmm     [SSE2]
//    * SQRTPD m128, xmm    [SSE2]
//
func (self *Program) SQRTPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SQRTPD", 2, Operands { v0, v1 })
    // SQRTPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x51)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SQRTPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x51)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SQRTPD")
    }
    return p
}

// SQRTPS performs "Compute Square Roots of Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : SQRTPS
// Supported forms : (2 forms)
//
//    * SQRTPS xmm, xmm     [SSE]
//    * SQRTPS m128, xmm    [SSE]
//
func (self *Program) SQRTPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SQRTPS", 2, Operands { v0, v1 })
    // SQRTPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x51)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SQRTPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x51)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SQRTPS")
    }
    return p
}

// SQRTSD performs "Compute Square Root of Scalar Double-Precision Floating-Point Value".
//
// Mnemonic        : SQRTSD
// Supported forms : (2 forms)
//
//    * SQRTSD xmm, xmm    [SSE2]
//    * SQRTSD m64, xmm    [SSE2]
//
func (self *Program) SQRTSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SQRTSD", 2, Operands { v0, v1 })
    // SQRTSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x51)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SQRTSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x51)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SQRTSD")
    }
    return p
}

// SQRTSS performs "Compute Square Root of Scalar Single-Precision Floating-Point Value".
//
// Mnemonic        : SQRTSS
// Supported forms : (2 forms)
//
//    * SQRTSS xmm, xmm    [SSE]
//    * SQRTSS m32, xmm    [SSE]
//
func (self *Program) SQRTSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SQRTSS", 2, Operands { v0, v1 })
    // SQRTSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x51)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SQRTSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x51)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SQRTSS")
    }
    return p
}

// STC performs "Set Carry Flag".
//
// Mnemonic        : STC
// Supported forms : (1 form)
//
//    * STC
//
func (self *Program) STC() *Instruction {
    p := self.alloc("STC", 0, Operands {  })
    // STC
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0xf9)
    })
    return p
}

// STD performs "Set Direction Flag".
//
// Mnemonic        : STD
// Supported forms : (1 form)
//
//    * STD
//
func (self *Program) STD() *Instruction {
    p := self.alloc("STD", 0, Operands {  })
    // STD
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0xfd)
    })
    return p
}

// STMXCSR performs "Store MXCSR Register State".
//
// Mnemonic        : STMXCSR
// Supported forms : (1 form)
//
//    * STMXCSR m32    [SSE]
//
func (self *Program) STMXCSR(v0 interface{}) *Instruction {
    p := self.alloc("STMXCSR", 1, Operands { v0 })
    // STMXCSR m32
    if isM32(v0) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xae)
            m.mrsd(3, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for STMXCSR")
    }
    return p
}

// SUBB performs "Subtract".
//
// Mnemonic        : SUB
// Supported forms : (6 forms)
//
//    * SUBB imm8, al
//    * SUBB imm8, r8
//    * SUBB r8, r8
//    * SUBB m8, r8
//    * SUBB imm8, m8
//    * SUBB r8, m8
//
func (self *Program) SUBB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBB", 2, Operands { v0, v1 })
    // SUBB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x2c)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0x80)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x28)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x2a)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBB m8, r8
    if isM8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), isReg8REX(v[1]))
            m.emit(0x2a)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SUBB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x80)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x28)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBB")
    }
    return p
}

// SUBL performs "Subtract".
//
// Mnemonic        : SUB
// Supported forms : (8 forms)
//
//    * SUBL imm32, eax
//    * SUBL imm8, r32
//    * SUBL imm32, r32
//    * SUBL r32, r32
//    * SUBL m32, r32
//    * SUBL imm8, m32
//    * SUBL imm32, m32
//    * SUBL r32, m32
//
func (self *Program) SUBL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBL", 2, Operands { v0, v1 })
    // SUBL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x2d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SUBL imm8, r32
    if isImm8Ext(v0, 4) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xe8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // SUBL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x29)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x2b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBL m32, r32
    if isM32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x2b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SUBL imm8, m32
    if isImm8Ext(v0, 4) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(5, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SUBL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x29)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBL")
    }
    return p
}

// SUBPD performs "Subtract Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : SUBPD
// Supported forms : (2 forms)
//
//    * SUBPD xmm, xmm     [SSE2]
//    * SUBPD m128, xmm    [SSE2]
//
func (self *Program) SUBPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBPD", 2, Operands { v0, v1 })
    // SUBPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBPD")
    }
    return p
}

// SUBPS performs "Subtract Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : SUBPS
// Supported forms : (2 forms)
//
//    * SUBPS xmm, xmm     [SSE]
//    * SUBPS m128, xmm    [SSE]
//
func (self *Program) SUBPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBPS", 2, Operands { v0, v1 })
    // SUBPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBPS")
    }
    return p
}

// SUBQ performs "Subtract".
//
// Mnemonic        : SUB
// Supported forms : (8 forms)
//
//    * SUBQ imm32, rax
//    * SUBQ imm8, r64
//    * SUBQ imm32, r64
//    * SUBQ r64, r64
//    * SUBQ m64, r64
//    * SUBQ imm8, m64
//    * SUBQ imm32, m64
//    * SUBQ r64, m64
//
func (self *Program) SUBQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBQ", 2, Operands { v0, v1 })
    // SUBQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0x2d)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SUBQ imm8, r64
    if isImm8Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x83)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0x81)
            m.emit(0xe8 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // SUBQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x29)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x2b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBQ m64, r64
    if isM64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x2b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SUBQ imm8, m64
    if isImm8Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x83)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0x81)
            m.mrsd(5, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // SUBQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x29)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBQ")
    }
    return p
}

// SUBSD performs "Subtract Scalar Double-Precision Floating-Point Values".
//
// Mnemonic        : SUBSD
// Supported forms : (2 forms)
//
//    * SUBSD xmm, xmm    [SSE2]
//    * SUBSD m64, xmm    [SSE2]
//
func (self *Program) SUBSD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBSD", 2, Operands { v0, v1 })
    // SUBSD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBSD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf2)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBSD")
    }
    return p
}

// SUBSS performs "Subtract Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : SUBSS
// Supported forms : (2 forms)
//
//    * SUBSS xmm, xmm    [SSE]
//    * SUBSS m32, xmm    [SSE]
//
func (self *Program) SUBSS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBSS", 2, Operands { v0, v1 })
    // SUBSS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBSS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x5c)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBSS")
    }
    return p
}

// SUBW performs "Subtract".
//
// Mnemonic        : SUB
// Supported forms : (8 forms)
//
//    * SUBW imm16, ax
//    * SUBW imm8, r16
//    * SUBW imm16, r16
//    * SUBW r16, r16
//    * SUBW m16, r16
//    * SUBW imm8, m16
//    * SUBW imm16, m16
//    * SUBW r16, m16
//
func (self *Program) SUBW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("SUBW", 2, Operands { v0, v1 })
    // SUBW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0x2d)
            m.imm2(toImmAny(v[0]))
        })
    }
    // SUBW imm8, r16
    if isImm8Ext(v0, 2) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x83)
            m.emit(0xe8 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0x81)
            m.emit(0xe8 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // SUBW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x29)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x2b)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // SUBW m16, r16
    if isM16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x2b)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    // SUBW imm8, m16
    if isImm8Ext(v0, 2) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x83)
            m.mrsd(5, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // SUBW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0x81)
            m.mrsd(5, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // SUBW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x29)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for SUBW")
    }
    return p
}

// SYSCALL performs "Fast System Call".
//
// Mnemonic        : SYSCALL
// Supported forms : (1 form)
//
//    * SYSCALL
//
func (self *Program) SYSCALL() *Instruction {
    p := self.alloc("SYSCALL", 0, Operands {  })
    // SYSCALL
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x05)
    })
    return p
}

// T1MSKC performs "Inverse Mask From Trailing Ones".
//
// Mnemonic        : T1MSKC
// Supported forms : (4 forms)
//
//    * T1MSKC r32, r32    [TBM]
//    * T1MSKC m32, r32    [TBM]
//    * T1MSKC r64, r64    [TBM]
//    * T1MSKC m64, r64    [TBM]
//
func (self *Program) T1MSKC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("T1MSKC", 2, Operands { v0, v1 })
    // T1MSKC r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // T1MSKC m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    // T1MSKC r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xf8 | lcode(v[0]))
        })
    }
    // T1MSKC m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(7, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for T1MSKC")
    }
    return p
}

// TESTB performs "Logical Compare".
//
// Mnemonic        : TEST
// Supported forms : (5 forms)
//
//    * TESTB imm8, al
//    * TESTB imm8, r8
//    * TESTB r8, r8
//    * TESTB imm8, m8
//    * TESTB r8, m8
//
func (self *Program) TESTB(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TESTB", 2, Operands { v0, v1 })
    // TESTB imm8, al
    if isImm8(v0) && v1 == AL {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xa8)
            m.imm1(toImmAny(v[0]))
        })
    }
    // TESTB imm8, r8
    if isImm8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], isReg8REX(v[1]))
            m.emit(0xf6)
            m.emit(0xc0 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // TESTB r8, r8
    if isReg8(v0) && isReg8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], isReg8REX(v[0]) || isReg8REX(v[1]))
            m.emit(0x84)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // TESTB imm8, m8
    if isImm8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xf6)
            m.mrsd(0, addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    // TESTB r8, m8
    if isReg8(v0) && isM8(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), isReg8REX(v[0]))
            m.emit(0x84)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TESTB")
    }
    return p
}

// TESTL performs "Logical Compare".
//
// Mnemonic        : TEST
// Supported forms : (5 forms)
//
//    * TESTL imm32, eax
//    * TESTL imm32, r32
//    * TESTL r32, r32
//    * TESTL imm32, m32
//    * TESTL r32, m32
//
func (self *Program) TESTL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TESTL", 2, Operands { v0, v1 })
    // TESTL imm32, eax
    if isImm32(v0) && v1 == EAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xa9)
            m.imm4(toImmAny(v[0]))
        })
    }
    // TESTL imm32, r32
    if isImm32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, v[1], false)
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // TESTL r32, r32
    if isReg32(v0) && isReg32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x85)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // TESTL imm32, m32
    if isImm32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(0, addr(v[1]), false)
            m.emit(0xf7)
            m.mrsd(0, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // TESTL r32, m32
    if isReg32(v0) && isM32(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x85)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TESTL")
    }
    return p
}

// TESTQ performs "Logical Compare".
//
// Mnemonic        : TEST
// Supported forms : (5 forms)
//
//    * TESTQ imm32, rax
//    * TESTQ imm32, r64
//    * TESTQ r64, r64
//    * TESTQ imm32, m64
//    * TESTQ r64, m64
//
func (self *Program) TESTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TESTQ", 2, Operands { v0, v1 })
    // TESTQ imm32, rax
    if isImm32(v0) && v1 == RAX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48)
            m.emit(0xa9)
            m.imm4(toImmAny(v[0]))
        })
    }
    // TESTQ imm32, r64
    if isImm32Ext(v0, 8) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[1]))
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[1]))
            m.imm4(toImmAny(v[0]))
        })
    }
    // TESTQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x48 | hcode(v[0]) << 2 | hcode(v[1]))
            m.emit(0x85)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // TESTQ imm32, m64
    if isImm32Ext(v0, 8) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, 0, addr(v[1]))
            m.emit(0xf7)
            m.mrsd(0, addr(v[1]), 1)
            m.imm4(toImmAny(v[0]))
        })
    }
    // TESTQ r64, m64
    if isReg64(v0) && isM64(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexm(1, hcode(v[0]), addr(v[1]))
            m.emit(0x85)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TESTQ")
    }
    return p
}

// TESTW performs "Logical Compare".
//
// Mnemonic        : TEST
// Supported forms : (5 forms)
//
//    * TESTW imm16, ax
//    * TESTW imm16, r16
//    * TESTW r16, r16
//    * TESTW imm16, m16
//    * TESTW r16, m16
//
func (self *Program) TESTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TESTW", 2, Operands { v0, v1 })
    // TESTW imm16, ax
    if isImm16(v0) && v1 == AX {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xa9)
            m.imm2(toImmAny(v[0]))
        })
    }
    // TESTW imm16, r16
    if isImm16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, v[1], false)
            m.emit(0xf7)
            m.emit(0xc0 | lcode(v[1]))
            m.imm2(toImmAny(v[0]))
        })
    }
    // TESTW r16, r16
    if isReg16(v0) && isReg16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), v[1], false)
            m.emit(0x85)
            m.emit(0xc0 | lcode(v[0]) << 3 | lcode(v[1]))
        })
    }
    // TESTW imm16, m16
    if isImm16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(0, addr(v[1]), false)
            m.emit(0xf7)
            m.mrsd(0, addr(v[1]), 1)
            m.imm2(toImmAny(v[0]))
        })
    }
    // TESTW r16, m16
    if isReg16(v0) && isM16(v1) {
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[0]), addr(v[1]), false)
            m.emit(0x85)
            m.mrsd(lcode(v[0]), addr(v[1]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TESTW")
    }
    return p
}

// TZCNTL performs "Count the Number of Trailing Zero Bits".
//
// Mnemonic        : TZCNT
// Supported forms : (2 forms)
//
//    * TZCNTL r32, r32    [BMI]
//    * TZCNTL m32, r32    [BMI]
//
func (self *Program) TZCNTL(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TZCNTL", 2, Operands { v0, v1 })
    // TZCNTL r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // TZCNTL m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TZCNTL")
    }
    return p
}

// TZCNTQ performs "Count the Number of Trailing Zero Bits".
//
// Mnemonic        : TZCNT
// Supported forms : (2 forms)
//
//    * TZCNTQ r64, r64    [BMI]
//    * TZCNTQ m64, r64    [BMI]
//
func (self *Program) TZCNTQ(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TZCNTQ", 2, Operands { v0, v1 })
    // TZCNTQ r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.emit(0x48 | hcode(v[1]) << 2 | hcode(v[0]))
            m.emit(0x0f)
            m.emit(0xbc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // TZCNTQ m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xf3)
            m.rexm(1, hcode(v[1]), addr(v[0]))
            m.emit(0x0f)
            m.emit(0xbc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TZCNTQ")
    }
    return p
}

// TZCNTW performs "Count the Number of Trailing Zero Bits".
//
// Mnemonic        : TZCNT
// Supported forms : (2 forms)
//
//    * TZCNTW r16, r16    [BMI]
//    * TZCNTW m16, r16    [BMI]
//
func (self *Program) TZCNTW(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TZCNTW", 2, Operands { v0, v1 })
    // TZCNTW r16, r16
    if isReg16(v0) && isReg16(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf3)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // TZCNTW m16, r16
    if isM16(v0) && isReg16(v1) {
        self.require(ISA_BMI)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.emit(0xf3)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0xbc)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TZCNTW")
    }
    return p
}

// TZMSK performs "Mask From Trailing Zeros".
//
// Mnemonic        : TZMSK
// Supported forms : (4 forms)
//
//    * TZMSK r32, r32    [TBM]
//    * TZMSK m32, r32    [TBM]
//    * TZMSK r64, r64    [TBM]
//    * TZMSK m64, r64    [TBM]
//
func (self *Program) TZMSK(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("TZMSK", 2, Operands { v0, v1 })
    // TZMSK r32, r32
    if isReg32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0x78 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xe0 | lcode(v[0]))
        })
    }
    // TZMSK m32, r32
    if isM32(v0) && isReg32(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x00, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(4, addr(v[0]), 1)
        })
    }
    // TZMSK r64, r64
    if isReg64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x8f)
            m.emit(0xe9 ^ (hcode(v[0]) << 5))
            m.emit(0xf8 ^ (hlcode(v[1]) << 3))
            m.emit(0x01)
            m.emit(0xe0 | lcode(v[0]))
        })
    }
    // TZMSK m64, r64
    if isM64(v0) && isReg64(v1) {
        self.require(ISA_TBM)
        p.domain = DomainGeneric
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0x8f, 0b1001, 0x80, 0, addr(v[0]), hlcode(v[1]))
            m.emit(0x01)
            m.mrsd(4, addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for TZMSK")
    }
    return p
}

// UCOMISD performs "Unordered Compare Scalar Double-Precision Floating-Point Values and Set EFLAGS".
//
// Mnemonic        : UCOMISD
// Supported forms : (2 forms)
//
//    * UCOMISD xmm, xmm    [SSE2]
//    * UCOMISD m64, xmm    [SSE2]
//
func (self *Program) UCOMISD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("UCOMISD", 2, Operands { v0, v1 })
    // UCOMISD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // UCOMISD m64, xmm
    if isM64(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for UCOMISD")
    }
    return p
}

// UCOMISS performs "Unordered Compare Scalar Single-Precision Floating-Point Values and Set EFLAGS".
//
// Mnemonic        : UCOMISS
// Supported forms : (2 forms)
//
//    * UCOMISS xmm, xmm    [SSE]
//    * UCOMISS m32, xmm    [SSE]
//
func (self *Program) UCOMISS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("UCOMISS", 2, Operands { v0, v1 })
    // UCOMISS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x2e)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // UCOMISS m32, xmm
    if isM32(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x2e)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for UCOMISS")
    }
    return p
}

// UD2 performs "Undefined Instruction".
//
// Mnemonic        : UD2
// Supported forms : (1 form)
//
//    * UD2
//
func (self *Program) UD2() *Instruction {
    p := self.alloc("UD2", 0, Operands {  })
    // UD2
    p.domain = DomainGeneric
    p.add(0, func(m *_Encoding, v []interface{}) {
        m.emit(0x0f)
        m.emit(0x0b)
    })
    return p
}

// UNPCKHPD performs "Unpack and Interleave High Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : UNPCKHPD
// Supported forms : (2 forms)
//
//    * UNPCKHPD xmm, xmm     [SSE2]
//    * UNPCKHPD m128, xmm    [SSE2]
//
func (self *Program) UNPCKHPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("UNPCKHPD", 2, Operands { v0, v1 })
    // UNPCKHPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x15)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // UNPCKHPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x15)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for UNPCKHPD")
    }
    return p
}

// UNPCKHPS performs "Unpack and Interleave High Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : UNPCKHPS
// Supported forms : (2 forms)
//
//    * UNPCKHPS xmm, xmm     [SSE]
//    * UNPCKHPS m128, xmm    [SSE]
//
func (self *Program) UNPCKHPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("UNPCKHPS", 2, Operands { v0, v1 })
    // UNPCKHPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x15)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // UNPCKHPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x15)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for UNPCKHPS")
    }
    return p
}

// UNPCKLPD performs "Unpack and Interleave Low Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : UNPCKLPD
// Supported forms : (2 forms)
//
//    * UNPCKLPD xmm, xmm     [SSE2]
//    * UNPCKLPD m128, xmm    [SSE2]
//
func (self *Program) UNPCKLPD(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("UNPCKLPD", 2, Operands { v0, v1 })
    // UNPCKLPD xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x14)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // UNPCKLPD m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE2)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x66)
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x14)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for UNPCKLPD")
    }
    return p
}

// UNPCKLPS performs "Unpack and Interleave Low Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : UNPCKLPS
// Supported forms : (2 forms)
//
//    * UNPCKLPS xmm, xmm     [SSE]
//    * UNPCKLPS m128, xmm    [SSE]
//
func (self *Program) UNPCKLPS(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("UNPCKLPS", 2, Operands { v0, v1 })
    // UNPCKLPS xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), v[0], false)
            m.emit(0x0f)
            m.emit(0x14)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // UNPCKLPS m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_SSE)
        p.domain = DomainMMXSSE
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.rexo(hcode(v[1]), addr(v[0]), false)
            m.emit(0x0f)
            m.emit(0x14)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for UNPCKLPS")
    }
    return p
}

// VADDPD performs "Add Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : VADDPD
// Supported forms : (11 forms)
//
//    * VADDPD xmm, xmm, xmm                   [AVX]
//    * VADDPD m128, xmm, xmm                  [AVX]
//    * VADDPD ymm, ymm, ymm                   [AVX]
//    * VADDPD m256, ymm, ymm                  [AVX]
//    * VADDPD m512/m64bcst, zmm, zmm{k}{z}    [AVX512F]
//    * VADDPD {er}, zmm, zmm, zmm{k}{z}       [AVX512F]
//    * VADDPD zmm, zmm, zmm{k}{z}             [AVX512F]
//    * VADDPD m128/m64bcst, xmm, xmm{k}{z}    [AVX512F,AVX512VL]
//    * VADDPD xmm, xmm, xmm{k}{z}             [AVX512F,AVX512VL]
//    * VADDPD m256/m64bcst, ymm, ymm{k}{z}    [AVX512F,AVX512VL]
//    * VADDPD ymm, ymm, ymm{k}{z}             [AVX512F,AVX512VL]
//
func (self *Program) VADDPD(v0 interface{}, v1 interface{}, v2 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("VADDPD", 3, Operands { v0, v1, v2 })
        case 1  : p = self.alloc("VADDPD", 4, Operands { v0, v1, v2, vv[0] })
        default : panic("instruction VADDPD takes 3 or 4 operands")
    }
    // VADDPD xmm, xmm, xmm
    if len(vv) == 0 && isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPD m128, xmm, xmm
    if len(vv) == 0 && isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDPD ymm, ymm, ymm
    if len(vv) == 0 && isYMM(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPD m256, ymm, ymm
    if len(vv) == 0 && isM256(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDPD m512/m64bcst, zmm, zmm{k}{z}
    if len(vv) == 0 && isM512M64bcst(v0) && isZMM(v1) && isZMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x85, 0b10, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), bcode(v[0]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 64)
        })
    }
    // VADDPD {er}, zmm, zmm, zmm{k}{z}
    if len(vv) == 1 && isER(v0) && isZMM(v1) && isZMM(v2) && isZMMkz(vv[0]) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0xfd ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (vcode(v[0]) << 5) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x10)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
        })
    }
    // VADDPD zmm, zmm, zmm{k}{z}
    if len(vv) == 0 && isZMM(v0) && isZMM(v1) && isZMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x40)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPD m128/m64bcst, xmm, xmm{k}{z}
    if len(vv) == 0 && isM128M64bcst(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x85, 0b00, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), bcode(v[0]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 16)
        })
    }
    // VADDPD xmm, xmm, xmm{k}{z}
    if len(vv) == 0 && isEVEXXMM(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x00)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPD m256/m64bcst, ymm, ymm{k}{z}
    if len(vv) == 0 && isM256M64bcst(v0) && isEVEXYMM(v1) && isYMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x85, 0b01, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), bcode(v[0]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 32)
        })
    }
    // VADDPD ymm, ymm, ymm{k}{z}
    if len(vv) == 0 && isEVEXYMM(v0) && isEVEXYMM(v1) && isYMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0xfd ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x20)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for VADDPD")
    }
    return p
}

// VADDPS performs "Add Packed Single-Precision Floating-Point Values".
//
// Mnemonic        : VADDPS
// Supported forms : (11 forms)
//
//    * VADDPS xmm, xmm, xmm                   [AVX]
//    * VADDPS m128, xmm, xmm                  [AVX]
//    * VADDPS ymm, ymm, ymm                   [AVX]
//    * VADDPS m256, ymm, ymm                  [AVX]
//    * VADDPS m512/m32bcst, zmm, zmm{k}{z}    [AVX512F]
//    * VADDPS {er}, zmm, zmm, zmm{k}{z}       [AVX512F]
//    * VADDPS zmm, zmm, zmm{k}{z}             [AVX512F]
//    * VADDPS m128/m32bcst, xmm, xmm{k}{z}    [AVX512F,AVX512VL]
//    * VADDPS xmm, xmm, xmm{k}{z}             [AVX512F,AVX512VL]
//    * VADDPS m256/m32bcst, ymm, ymm{k}{z}    [AVX512F,AVX512VL]
//    * VADDPS ymm, ymm, ymm{k}{z}             [AVX512F,AVX512VL]
//
func (self *Program) VADDPS(v0 interface{}, v1 interface{}, v2 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("VADDPS", 3, Operands { v0, v1, v2 })
        case 1  : p = self.alloc("VADDPS", 4, Operands { v0, v1, v2, vv[0] })
        default : panic("instruction VADDPS takes 3 or 4 operands")
    }
    // VADDPS xmm, xmm, xmm
    if len(vv) == 0 && isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPS m128, xmm, xmm
    if len(vv) == 0 && isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(0, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDPS ymm, ymm, ymm
    if len(vv) == 0 && isYMM(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPS m256, ymm, ymm
    if len(vv) == 0 && isM256(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(4, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDPS m512/m32bcst, zmm, zmm{k}{z}
    if len(vv) == 0 && isM512M32bcst(v0) && isZMM(v1) && isZMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x04, 0b10, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), bcode(v[0]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 64)
        })
    }
    // VADDPS {er}, zmm, zmm, zmm{k}{z}
    if len(vv) == 1 && isER(v0) && isZMM(v1) && isZMM(v2) && isZMMkz(vv[0]) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0x7c ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (vcode(v[0]) << 5) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x10)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
        })
    }
    // VADDPS zmm, zmm, zmm{k}{z}
    if len(vv) == 0 && isZMM(v0) && isZMM(v1) && isZMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0x7c ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x40)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPS m128/m32bcst, xmm, xmm{k}{z}
    if len(vv) == 0 && isM128M32bcst(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x04, 0b00, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), bcode(v[0]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 16)
        })
    }
    // VADDPS xmm, xmm, xmm{k}{z}
    if len(vv) == 0 && isEVEXXMM(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0x7c ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x00)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDPS m256/m32bcst, ymm, ymm{k}{z}
    if len(vv) == 0 && isM256M32bcst(v0) && isEVEXYMM(v1) && isYMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x04, 0b01, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), bcode(v[0]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 32)
        })
    }
    // VADDPS ymm, ymm, ymm{k}{z}
    if len(vv) == 0 && isEVEXYMM(v0) && isEVEXYMM(v1) && isYMMkz(v2) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0x7c ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x20)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for VADDPS")
    }
    return p
}

// VADDSD performs "Add Scalar Double-Precision Floating-Point Values".
//
// Mnemonic        : VADDSD
// Supported forms : (5 forms)
//
//    * VADDSD xmm, xmm, xmm                [AVX]
//    * VADDSD m64, xmm, xmm                [AVX]
//    * VADDSD m64, xmm, xmm{k}{z}          [AVX512F]
//    * VADDSD {er}, xmm, xmm, xmm{k}{z}    [AVX512F]
//    * VADDSD xmm, xmm, xmm{k}{z}          [AVX512F]
//
func (self *Program) VADDSD(v0 interface{}, v1 interface{}, v2 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("VADDSD", 3, Operands { v0, v1, v2 })
        case 1  : p = self.alloc("VADDSD", 4, Operands { v0, v1, v2, vv[0] })
        default : panic("instruction VADDSD takes 3 or 4 operands")
    }
    // VADDSD xmm, xmm, xmm
    if len(vv) == 0 && isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(3, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDSD m64, xmm, xmm
    if len(vv) == 0 && isM64(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(3, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDSD m64, xmm, xmm{k}{z}
    if len(vv) == 0 && isM64(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x87, 0b00, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), 0)
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 8)
        })
    }
    // VADDSD {er}, xmm, xmm, xmm{k}{z}
    if len(vv) == 1 && isER(v0) && isEVEXXMM(v1) && isEVEXXMM(v2) && isXMMkz(vv[0]) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0xff ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (vcode(v[0]) << 5) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x10)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
        })
    }
    // VADDSD xmm, xmm, xmm{k}{z}
    if len(vv) == 0 && isEVEXXMM(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0xff ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x40)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for VADDSD")
    }
    return p
}

// VADDSS performs "Add Scalar Single-Precision Floating-Point Values".
//
// Mnemonic        : VADDSS
// Supported forms : (5 forms)
//
//    * VADDSS xmm, xmm, xmm                [AVX]
//    * VADDSS m32, xmm, xmm                [AVX]
//    * VADDSS m32, xmm, xmm{k}{z}          [AVX512F]
//    * VADDSS {er}, xmm, xmm, xmm{k}{z}    [AVX512F]
//    * VADDSS xmm, xmm, xmm{k}{z}          [AVX512F]
//
func (self *Program) VADDSS(v0 interface{}, v1 interface{}, v2 interface{}, vv ...interface{}) *Instruction {
    var p *Instruction
    switch len(vv) {
        case 0  : p = self.alloc("VADDSS", 3, Operands { v0, v1, v2 })
        case 1  : p = self.alloc("VADDSS", 4, Operands { v0, v1, v2, vv[0] })
        default : panic("instruction VADDSS takes 3 or 4 operands")
    }
    // VADDSS xmm, xmm, xmm
    if len(vv) == 0 && isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(2, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDSS m32, xmm, xmm
    if len(vv) == 0 && isM32(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(2, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDSS m32, xmm, xmm{k}{z}
    if len(vv) == 0 && isM32(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b01, 0x06, 0b00, ehcode(v[2]), addr(v[0]), vcode(v[1]), kcode(v[2]), zcode(v[2]), 0)
            m.emit(0x58)
            m.mrsd(lcode(v[2]), addr(v[0]), 4)
        })
    }
    // VADDSS {er}, xmm, xmm, xmm{k}{z}
    if len(vv) == 1 && isER(v0) && isEVEXXMM(v1) && isEVEXXMM(v2) && isXMMkz(vv[0]) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0x7e ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (vcode(v[0]) << 5) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x10)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
        })
    }
    // VADDSS xmm, xmm, xmm{k}{z}
    if len(vv) == 0 && isEVEXXMM(v0) && isEVEXXMM(v1) && isXMMkz(v2) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf1 ^ ((hcode(v[2]) << 7) | (ehcode(v[0]) << 5) | (ecode(v[2]) << 4)))
            m.emit(0x7e ^ (hlcode(v[1]) << 3))
            m.emit((zcode(v[2]) << 7) | (0x08 ^ (ecode(v[1]) << 3)) | kcode(v[2]) | 0x40)
            m.emit(0x58)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for VADDSS")
    }
    return p
}

// VADDSUBPD performs "Packed Double-FP Add/Subtract".
//
// Mnemonic        : VADDSUBPD
// Supported forms : (4 forms)
//
//    * VADDSUBPD xmm, xmm, xmm     [AVX]
//    * VADDSUBPD m128, xmm, xmm    [AVX]
//    * VADDSUBPD ymm, ymm, ymm     [AVX]
//    * VADDSUBPD m256, ymm, ymm    [AVX]
//
func (self *Program) VADDSUBPD(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("VADDSUBPD", 3, Operands { v0, v1, v2 })
    // VADDSUBPD xmm, xmm, xmm
    if isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0xd0)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDSUBPD m128, xmm, xmm
    if isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(1, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xd0)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDSUBPD ymm, ymm, ymm
    if isYMM(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0xd0)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDSUBPD m256, ymm, ymm
    if isM256(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(5, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xd0)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for VADDSUBPD")
    }
    return p
}

// VADDSUBPS performs "Packed Single-FP Add/Subtract".
//
// Mnemonic        : VADDSUBPS
// Supported forms : (4 forms)
//
//    * VADDSUBPS xmm, xmm, xmm     [AVX]
//    * VADDSUBPS m128, xmm, xmm    [AVX]
//    * VADDSUBPS ymm, ymm, ymm     [AVX]
//    * VADDSUBPS m256, ymm, ymm    [AVX]
//
func (self *Program) VADDSUBPS(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("VADDSUBPS", 3, Operands { v0, v1, v2 })
    // VADDSUBPS xmm, xmm, xmm
    if isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(3, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0xd0)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDSUBPS m128, xmm, xmm
    if isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(3, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xd0)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    // VADDSUBPS ymm, ymm, ymm
    if isYMM(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(7, hcode(v[2]), v[0], hlcode(v[1]))
            m.emit(0xd0)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VADDSUBPS m256, ymm, ymm
    if isM256(v0) && isYMM(v1) && isYMM(v2) {
        self.require(ISA_AVX)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex2(7, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xd0)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for VADDSUBPS")
    }
    return p
}

// VAESDEC performs "Perform One Round of an AES Decryption Flow".
//
// Mnemonic        : VAESDEC
// Supported forms : (2 forms)
//
//    * VAESDEC xmm, xmm, xmm     [AES,AVX]
//    * VAESDEC m128, xmm, xmm    [AES,AVX]
//
func (self *Program) VAESDEC(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("VAESDEC", 3, Operands { v0, v1, v2 })
    // VAESDEC xmm, xmm, xmm
    if isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x79 ^ (hlcode(v[1]) << 3))
            m.emit(0xde)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VAESDEC m128, xmm, xmm
    if isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x01, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xde)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for VAESDEC")
    }
    return p
}

// VAESDECLAST performs "Perform Last Round of an AES Decryption Flow".
//
// Mnemonic        : VAESDECLAST
// Supported forms : (2 forms)
//
//    * VAESDECLAST xmm, xmm, xmm     [AES,AVX]
//    * VAESDECLAST m128, xmm, xmm    [AES,AVX]
//
func (self *Program) VAESDECLAST(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("VAESDECLAST", 3, Operands { v0, v1, v2 })
    // VAESDECLAST xmm, xmm, xmm
    if isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x79 ^ (hlcode(v[1]) << 3))
            m.emit(0xdf)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VAESDECLAST m128, xmm, xmm
    if isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x01, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xdf)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for VAESDECLAST")
    }
    return p
}

// VAESENC performs "Perform One Round of an AES Encryption Flow".
//
// Mnemonic        : VAESENC
// Supported forms : (2 forms)
//
//    * VAESENC xmm, xmm, xmm     [AES,AVX]
//    * VAESENC m128, xmm, xmm    [AES,AVX]
//
func (self *Program) VAESENC(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("VAESENC", 3, Operands { v0, v1, v2 })
    // VAESENC xmm, xmm, xmm
    if isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x79 ^ (hlcode(v[1]) << 3))
            m.emit(0xdc)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VAESENC m128, xmm, xmm
    if isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x01, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xdc)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for VAESENC")
    }
    return p
}

// VAESENCLAST performs "Perform Last Round of an AES Encryption Flow".
//
// Mnemonic        : VAESENCLAST
// Supported forms : (2 forms)
//
//    * VAESENCLAST xmm, xmm, xmm     [AES,AVX]
//    * VAESENCLAST m128, xmm, xmm    [AES,AVX]
//
func (self *Program) VAESENCLAST(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("VAESENCLAST", 3, Operands { v0, v1, v2 })
    // VAESENCLAST xmm, xmm, xmm
    if isXMM(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[2]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x79 ^ (hlcode(v[1]) << 3))
            m.emit(0xdd)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[0]))
        })
    }
    // VAESENCLAST m128, xmm, xmm
    if isM128(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x01, hcode(v[2]), addr(v[0]), hlcode(v[1]))
            m.emit(0xdd)
            m.mrsd(lcode(v[2]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for VAESENCLAST")
    }
    return p
}

// VAESIMC performs "Perform the AES InvMixColumn Transformation".
//
// Mnemonic        : VAESIMC
// Supported forms : (2 forms)
//
//    * VAESIMC xmm, xmm     [AES,AVX]
//    * VAESIMC m128, xmm    [AES,AVX]
//
func (self *Program) VAESIMC(v0 interface{}, v1 interface{}) *Instruction {
    p := self.alloc("VAESIMC", 2, Operands { v0, v1 })
    // VAESIMC xmm, xmm
    if isXMM(v0) && isXMM(v1) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe2 ^ (hcode(v[1]) << 7) ^ (hcode(v[0]) << 5))
            m.emit(0x79)
            m.emit(0xdb)
            m.emit(0xc0 | lcode(v[1]) << 3 | lcode(v[0]))
        })
    }
    // VAESIMC m128, xmm
    if isM128(v0) && isXMM(v1) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b10, 0x01, hcode(v[1]), addr(v[0]), 0)
            m.emit(0xdb)
            m.mrsd(lcode(v[1]), addr(v[0]), 1)
        })
    }
    if p.len == 0 {
        panic("invalid operands for VAESIMC")
    }
    return p
}

// VAESKEYGENASSIST performs "AES Round Key Generation Assist".
//
// Mnemonic        : VAESKEYGENASSIST
// Supported forms : (2 forms)
//
//    * VAESKEYGENASSIST imm8, xmm, xmm     [AES,AVX]
//    * VAESKEYGENASSIST imm8, m128, xmm    [AES,AVX]
//
func (self *Program) VAESKEYGENASSIST(v0 interface{}, v1 interface{}, v2 interface{}) *Instruction {
    p := self.alloc("VAESKEYGENASSIST", 3, Operands { v0, v1, v2 })
    // VAESKEYGENASSIST imm8, xmm, xmm
    if isImm8(v0) && isXMM(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0xc4)
            m.emit(0xe3 ^ (hcode(v[2]) << 7) ^ (hcode(v[1]) << 5))
            m.emit(0x79)
            m.emit(0xdf)
            m.emit(0xc0 | lcode(v[2]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // VAESKEYGENASSIST imm8, m128, xmm
    if isImm8(v0) && isM128(v1) && isXMM(v2) {
        self.require(ISA_AVX | ISA_AES)
        p.domain = DomainCrypto
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.vex3(0xc4, 0b11, 0x01, hcode(v[2]), addr(v[1]), 0)
            m.emit(0xdf)
            m.mrsd(lcode(v[2]), addr(v[1]), 1)
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for VAESKEYGENASSIST")
    }
    return p
}

// VALIGND performs "Align Doubleword Vectors".
//
// Mnemonic        : VALIGND
// Supported forms : (6 forms)
//
//    * VALIGND imm8, m512/m32bcst, zmm, zmm{k}{z}    [AVX512F]
//    * VALIGND imm8, zmm, zmm, zmm{k}{z}             [AVX512F]
//    * VALIGND imm8, m128/m32bcst, xmm, xmm{k}{z}    [AVX512F,AVX512VL]
//    * VALIGND imm8, xmm, xmm, xmm{k}{z}             [AVX512F,AVX512VL]
//    * VALIGND imm8, m256/m32bcst, ymm, ymm{k}{z}    [AVX512F,AVX512VL]
//    * VALIGND imm8, ymm, ymm, ymm{k}{z}             [AVX512F,AVX512VL]
//
func (self *Program) VALIGND(v0 interface{}, v1 interface{}, v2 interface{}, v3 interface{}) *Instruction {
    p := self.alloc("VALIGND", 4, Operands { v0, v1, v2, v3 })
    // VALIGND imm8, m512/m32bcst, zmm, zmm{k}{z}
    if isImm8(v0) && isM512M32bcst(v1) && isZMM(v2) && isZMMkz(v3) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b11, 0x05, 0b10, ehcode(v[3]), addr(v[1]), vcode(v[2]), kcode(v[3]), zcode(v[3]), bcode(v[1]))
            m.emit(0x03)
            m.mrsd(lcode(v[3]), addr(v[1]), 64)
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGND imm8, zmm, zmm, zmm{k}{z}
    if isImm8(v0) && isZMM(v1) && isZMM(v2) && isZMMkz(v3) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf3 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0x7d ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x40)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGND imm8, m128/m32bcst, xmm, xmm{k}{z}
    if isImm8(v0) && isM128M32bcst(v1) && isEVEXXMM(v2) && isXMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b11, 0x05, 0b00, ehcode(v[3]), addr(v[1]), vcode(v[2]), kcode(v[3]), zcode(v[3]), bcode(v[1]))
            m.emit(0x03)
            m.mrsd(lcode(v[3]), addr(v[1]), 16)
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGND imm8, xmm, xmm, xmm{k}{z}
    if isImm8(v0) && isEVEXXMM(v1) && isEVEXXMM(v2) && isXMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf3 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0x7d ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x00)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGND imm8, m256/m32bcst, ymm, ymm{k}{z}
    if isImm8(v0) && isM256M32bcst(v1) && isEVEXYMM(v2) && isYMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b11, 0x05, 0b01, ehcode(v[3]), addr(v[1]), vcode(v[2]), kcode(v[3]), zcode(v[3]), bcode(v[1]))
            m.emit(0x03)
            m.mrsd(lcode(v[3]), addr(v[1]), 32)
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGND imm8, ymm, ymm, ymm{k}{z}
    if isImm8(v0) && isEVEXYMM(v1) && isEVEXYMM(v2) && isYMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf3 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0x7d ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x20)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for VALIGND")
    }
    return p
}

// VALIGNQ performs "Align Quadword Vectors".
//
// Mnemonic        : VALIGNQ
// Supported forms : (6 forms)
//
//    * VALIGNQ imm8, m512/m64bcst, zmm, zmm{k}{z}    [AVX512F]
//    * VALIGNQ imm8, zmm, zmm, zmm{k}{z}             [AVX512F]
//    * VALIGNQ imm8, m128/m64bcst, xmm, xmm{k}{z}    [AVX512F,AVX512VL]
//    * VALIGNQ imm8, xmm, xmm, xmm{k}{z}             [AVX512F,AVX512VL]
//    * VALIGNQ imm8, m256/m64bcst, ymm, ymm{k}{z}    [AVX512F,AVX512VL]
//    * VALIGNQ imm8, ymm, ymm, ymm{k}{z}             [AVX512F,AVX512VL]
//
func (self *Program) VALIGNQ(v0 interface{}, v1 interface{}, v2 interface{}, v3 interface{}) *Instruction {
    p := self.alloc("VALIGNQ", 4, Operands { v0, v1, v2, v3 })
    // VALIGNQ imm8, m512/m64bcst, zmm, zmm{k}{z}
    if isImm8(v0) && isM512M64bcst(v1) && isZMM(v2) && isZMMkz(v3) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b11, 0x85, 0b10, ehcode(v[3]), addr(v[1]), vcode(v[2]), kcode(v[3]), zcode(v[3]), bcode(v[1]))
            m.emit(0x03)
            m.mrsd(lcode(v[3]), addr(v[1]), 64)
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGNQ imm8, zmm, zmm, zmm{k}{z}
    if isImm8(v0) && isZMM(v1) && isZMM(v2) && isZMMkz(v3) {
        self.require(ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf3 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0xfd ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x40)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGNQ imm8, m128/m64bcst, xmm, xmm{k}{z}
    if isImm8(v0) && isM128M64bcst(v1) && isEVEXXMM(v2) && isXMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b11, 0x85, 0b00, ehcode(v[3]), addr(v[1]), vcode(v[2]), kcode(v[3]), zcode(v[3]), bcode(v[1]))
            m.emit(0x03)
            m.mrsd(lcode(v[3]), addr(v[1]), 16)
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGNQ imm8, xmm, xmm, xmm{k}{z}
    if isImm8(v0) && isEVEXXMM(v1) && isEVEXXMM(v2) && isXMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf3 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0xfd ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x00)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGNQ imm8, m256/m64bcst, ymm, ymm{k}{z}
    if isImm8(v0) && isM256M64bcst(v1) && isEVEXYMM(v2) && isYMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.evex(0b11, 0x85, 0b01, ehcode(v[3]), addr(v[1]), vcode(v[2]), kcode(v[3]), zcode(v[3]), bcode(v[1]))
            m.emit(0x03)
            m.mrsd(lcode(v[3]), addr(v[1]), 32)
            m.imm1(toImmAny(v[0]))
        })
    }
    // VALIGNQ imm8, ymm, ymm, ymm{k}{z}
    if isImm8(v0) && isEVEXYMM(v1) && isEVEXYMM(v2) && isYMMkz(v3) {
        self.require(ISA_AVX512VL | ISA_AVX512F)
        p.domain = DomainAVX
        p.add(0, func(m *_Encoding, v []interface{}) {
            m.emit(0x62)
            m.emit(0xf3 ^ ((hcode(v[3]) << 7) | (ehcode(v[1]) << 5) | (ecode(v[3]) << 4)))
            m.emit(0xfd ^ (hlcode(v[2]) << 3))
            m.emit((zcode(v[3]) << 7) | (0x08 ^ (ecode(v[2]) << 3)) | kcode(v[3]) | 0x20)
            m.emit(0x03)
            m.emit(0xc0 | lcode(v[3]) << 3 | lcode(v[1]))
            m.imm1(toImmAny(v[0]))
        })
    }
    if p.len == 0 {
        panic("invalid operands for VALIGNQ")
    }
    return p
}

// VANDNPD performs "Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values".
//
// Mnemonic        : VANDNPD
// Supported forms : (10 forms)
//
//    * VANDNPD xmm, xmm, xmm                   [AVX]
//    * VANDNPD m128, xmm, xmm                  [AVX]
//    * VANDNPD ymm, ymm, ymm                   [AVX]
//    * VANDNPD m256, ymm, ymm                  [AVX]
//    * VANDNPD m512/m64bcst, zmm, zmm{k}{z}    [AVX512DQ]
//    * VANDNPD zmm, zmm, zmm{k}{z}             [AVX512DQ]
//    * VANDNPD m128/m64bcst, xmm, xmm{k}{z}    [AVX512DQ,AVX512VL]
//    * VANDNPD xmm, xmm, xmm{k}{z}             [AVX512DQ,AVX512VL]
//    * VANDNPD m256/m64bcst, ymm, ymm{k}{z}    [AVX512DQ,AVX512VL]
//    * VANDNPD ymm, ymm, ymm{k}{z}       