; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mattr=+aix-small-local-dynamic-tls -mtriple powerpc64-ibm-aix-xcoff < %s \
; RUN:      | FileCheck %s --check-prefix=SMALL-LOCAL-DYNAMIC-SMALLCM64
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mattr=+aix-small-local-dynamic-tls -mtriple powerpc64-ibm-aix-xcoff --code-model=large \
; RUN:      < %s | FileCheck %s \
; RUN:      --check-prefix=SMALL-LOCAL-DYNAMIC-LARGECM64

; Test disassembly of object.
; RUN: llc -verify-machineinstrs -mcpu=pwr7 \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -xcoff-traceback-table=false \
; RUN:      --code-model=large -filetype=obj -o %t.o < %s
; RUN: llvm-objdump -D -r --symbol-description %t.o | FileCheck -D#NFA=2 --check-prefix=DIS %s

@ElementIntTLSv1 = thread_local(localdynamic) global [8187 x i32] zeroinitializer, align 4  ; Within 32K
@ElementIntTLS2 = thread_local(localdynamic) global [4000 x i32] zeroinitializer, align 4
@ElementIntTLS3 = thread_local(localdynamic) global [4000 x i32] zeroinitializer, align 4
@ElementIntTLS4 = thread_local(localdynamic) global [4000 x i32] zeroinitializer, align 4
@ElementIntTLS5 = thread_local(localdynamic) global [4000 x i32] zeroinitializer, align 4
@ElementIntTLSv2 = thread_local(localdynamic) global [9000 x i32] zeroinitializer, align 4  ; Beyond 32K

@ElementLongTLS6 = external thread_local(localdynamic) global [60 x i64], align 8
@ElementLongTLS2 = thread_local(localdynamic) global [3000 x i64] zeroinitializer, align 8  ; Within 32K
@MyTLSGDVar = thread_local global [800 x i64] zeroinitializer, align 8
@ElementLongTLS3 = thread_local(localdynamic) global [3000 x i64] zeroinitializer, align 8
@ElementLongTLS4 = thread_local(localdynamic) global [3000 x i64] zeroinitializer, align 8
@ElementLongTLS5 = thread_local(localdynamic) global [3000 x i64] zeroinitializer, align 8
@ElementLongTLS = thread_local(localdynamic) local_unnamed_addr global [7800 x i64] zeroinitializer, align 8  ; Beyond 32K

declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull) #1

; All accesses use a "faster" local-dynamic sequence directly off the module handle.
; Exercise PPCXCOFFObjectWriter::getRelocTypeAndSignSize/fixup_ppc_half16.
define signext i32 @test1() {
; SMALL-LOCAL-DYNAMIC-SMALLCM64-LABEL: test1:
; SMALL-LOCAL-DYNAMIC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    mflr r0
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tlsldm) @"_$TLSML"
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    bla .__tls_get_mod[PR]
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 1
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r5, 4
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r4, ElementIntTLSv1[TL]@ld(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 2
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r5, ElementIntTLSv1[TL]@ld+24(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r5, (ElementIntTLS4[TL]@ld+328)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r4, (ElementIntTLS2[TL]@ld+320)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 3
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r4, (ElementIntTLS3[TL]@ld+324)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 88
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r4, (ElementIntTLS5[TL]@ld+332)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r3, 102
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    mtlr r0
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-DYNAMIC-LARGECM64-LABEL: test1:
; SMALL-LOCAL-DYNAMIC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    mflr r0
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addis r3, L..C0@u(r2)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r3, L..C0@l(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    bla .__tls_get_mod[PR]
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r4, 1
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r5, 4
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r4, ElementIntTLSv1[TL]@ld(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r4, 2
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r5, ElementIntTLSv1[TL]@ld+24(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r5, (ElementIntTLS4[TL]@ld+328)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r4, (ElementIntTLS2[TL]@ld+320)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r4, 3
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r4, (ElementIntTLS3[TL]@ld+324)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r4, 88
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r4, (ElementIntTLS5[TL]@ld+332)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r3, 102
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    mtlr r0
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    blr
entry:
  %tls1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLSv1)
  store i32 1, ptr %tls1, align 4
  %arrayidx1 = getelementptr inbounds [8187 x i32], ptr %tls1, i64 0, i64 6
  store i32 4, ptr %arrayidx1, align 4
  %tls2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS2)
  %arrayidx2 = getelementptr inbounds [4000 x i32], ptr %tls2, i64 0, i64 80
  store i32 2, ptr %arrayidx2, align 4
  %tls3 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS3)
  %arrayidx3 = getelementptr inbounds [4000 x i32], ptr %tls3, i64 0, i64 81
  store i32 3, ptr %arrayidx3, align 4
  %tls4 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS4)
  %arrayidx4 = getelementptr inbounds [4000 x i32], ptr %tls4, i64 0, i64 82
  store i32 4, ptr %arrayidx4, align 4
  %tls5 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS5)
  %arrayidx5 = getelementptr inbounds [4000 x i32], ptr %tls5, i64 0, i64 83
  store i32 88, ptr %arrayidx5, align 4
  %load1 = load i32, ptr %tls1, align 4
  %load2 = load i32, ptr %arrayidx1, align 4
  %load3 = load i32, ptr %arrayidx2, align 4
  %load4 = load i32, ptr %arrayidx3, align 4
  %load5 = load i32, ptr %arrayidx4, align 4
  %add = add i32 %load1, 88
  %add6 = add i32 %add, %load2
  %add8 = add i32 %add6, %load3
  %add10 = add i32 %add8, %load4
  %add12 = add i32 %add10, %load5
  ret i32 %add12
}

; All accesses use a "faster" local-dynamic sequence directly off the module handle.
; Exercise PPCXCOFFObjectWriter::getRelocTypeAndSignSize/fixup_ppc_half16ds.
define i64 @test2() {
; SMALL-LOCAL-DYNAMIC-SMALLCM64-LABEL: test2:
; SMALL-LOCAL-DYNAMIC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    mflr r0
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tlsldm) @"_$TLSML"
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    bla .__tls_get_mod[PR]
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    mr r6, r3
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r3, 212
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 203
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r4, (ElementLongTLS2[TL]@ld+1200)-131072(r6)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r4, L..C1(r2) # target-flags(ppc-tlsgd) @MyTLSGDVar
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r3, ElementLongTLS6[UL]@ld+424(r6)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r3, L..C2(r2) # target-flags(ppc-tlsgdm) @MyTLSGDVar
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    bla .__tls_get_addr[PR]
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 44
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r4, 440(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r3, 6
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 100
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r3, (ElementLongTLS3[TL]@ld+2000)-196608(r6)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r3, 882
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r4, (ElementLongTLS4[TL]@ld+6800)-196608(r6)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r3, (ElementLongTLS5[TL]@ld+8400)-196608(r6)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r3, 1191
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    mtlr r0
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-DYNAMIC-LARGECM64-LABEL: test2:
; SMALL-LOCAL-DYNAMIC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    mflr r0
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addis r3, L..C0@u(r2)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r3, L..C0@l(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    bla .__tls_get_mod[PR]
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addis r4, L..C1@u(r2)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    mr r6, r3
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r3, 212
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r4, L..C1@l(r4)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r3, ElementLongTLS6[UL]@ld+424(r6)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r3, 203
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r3, (ElementLongTLS2[TL]@ld+1200)-131072(r6)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addis r3, L..C2@u(r2)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r3, L..C2@l(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    bla .__tls_get_addr[PR]
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r4, 44
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r4, 440(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r3, 6
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r4, 100
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r3, (ElementLongTLS3[TL]@ld+2000)-196608(r6)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r3, 882
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r4, (ElementLongTLS4[TL]@ld+6800)-196608(r6)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r3, (ElementLongTLS5[TL]@ld+8400)-196608(r6)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r3, 1191
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    mtlr r0
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    blr
entry:
  %tls1 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ElementLongTLS6)
  %arrayidx = getelementptr inbounds [60 x i64], ptr %tls1, i64 0, i64 53
  store i64 212, ptr %arrayidx, align 8
  %tls2 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ElementLongTLS2)
  %arrayidx1 = getelementptr inbounds [3000 x i64], ptr %tls2, i64 0, i64 150
  store i64 203, ptr %arrayidx1, align 8
  %tls3 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @MyTLSGDVar)
  %arrayidx2 = getelementptr inbounds [800 x i64], ptr %tls3, i64 0, i64 55
  store i64 44, ptr %arrayidx2, align 8
  %tls4 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ElementLongTLS3)
  %arrayidx3 = getelementptr inbounds [3000 x i64], ptr %tls4, i64 0, i64 250
  store i64 6, ptr %arrayidx3, align 8
  %tls5 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ElementLongTLS4)
  %arrayidx4 = getelementptr inbounds [3000 x i64], ptr %tls5, i64 0, i64 850
  store i64 100, ptr %arrayidx4, align 8
  %tls6 = tail call align 8 ptr @llvm.threadlocal.address.p0(ptr align 8 @ElementLongTLS5)
  %arrayidx5 = getelementptr inbounds [3000 x i64], ptr %tls6, i64 0, i64 1050
  store i64 882, ptr %arrayidx5, align 8
  %load1 = load i64, ptr %arrayidx1, align 8
  %load2 = load i64, ptr %arrayidx3, align 8
  %load3 = load i64, ptr %arrayidx4, align 8
  %add = add i64 %load1, 882
  %add9 = add i64 %add, %load2
  %add11 = add i64 %add9, %load3
  ret i64 %add11
}

; Example of one access using the regular local-dynamic access from the TOC.
define signext i32 @test3() {
; SMALL-LOCAL-DYNAMIC-SMALLCM64-LABEL: test3:
; SMALL-LOCAL-DYNAMIC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    mflr r0
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r3, L..C0(r2) # target-flags(ppc-tlsldm) @"_$TLSML"
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r6, 3
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    bla .__tls_get_mod[PR]
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r5, 2
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r4, 1
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r6, (ElementIntTLS3[TL]@ld+324)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r6, L..C3(r2) # target-flags(ppc-tlsld) @ElementIntTLSv2
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r5, (ElementIntTLS2[TL]@ld+320)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r5, 88
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r5, (ElementIntTLS5[TL]@ld+332)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r5, 4
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r5, (ElementIntTLS4[TL]@ld+328)-65536(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stwux r4, r3, r6
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    stw r5, 24(r3)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    li r3, 102
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    mtlr r0
; SMALL-LOCAL-DYNAMIC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-DYNAMIC-LARGECM64-LABEL: test3:
; SMALL-LOCAL-DYNAMIC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    mflr r0
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stdu r1, -48(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addis r3, L..C0@u(r2)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    std r0, 64(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addis r6, L..C3@u(r2)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r3, L..C0@l(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r6, L..C3@l(r6)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    bla .__tls_get_mod[PR]
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r5, 2
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r4, 1
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r5, (ElementIntTLS2[TL]@ld+320)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r5, 3
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r5, (ElementIntTLS3[TL]@ld+324)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r5, 88
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r5, (ElementIntTLS5[TL]@ld+332)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r5, 4
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r5, (ElementIntTLS4[TL]@ld+328)-65536(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stwux r4, r3, r6
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    stw r5, 24(r3)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    li r3, 102
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    addi r1, r1, 48
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    ld r0, 16(r1)
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    mtlr r0
; SMALL-LOCAL-DYNAMIC-LARGECM64-NEXT:    blr
entry:
  %tls1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLSv2)
  store i32 1, ptr %tls1, align 4
  %arrayidx1 = getelementptr inbounds [9000 x i32], ptr %tls1, i64 0, i64 6
  store i32 4, ptr %arrayidx1, align 4
  %tls2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS2)
  %arrayidx2 = getelementptr inbounds [4000 x i32], ptr %tls2, i64 0, i64 80
  store i32 2, ptr %arrayidx2, align 4
  %tls3 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS3)
  %arrayidx3 = getelementptr inbounds [4000 x i32], ptr %tls3, i64 0, i64 81
  store i32 3, ptr %arrayidx3, align 4
  %tls4 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS4)
  %arrayidx4 = getelementptr inbounds [4000 x i32], ptr %tls4, i64 0, i64 82
  store i32 4, ptr %arrayidx4, align 4
  %tls5 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @ElementIntTLS5)
  %arrayidx5 = getelementptr inbounds [4000 x i32], ptr %tls5, i64 0, i64 83
  store i32 88, ptr %arrayidx5, align 4
  %load1 = load i32, ptr %tls1, align 4
  %load2 = load i32, ptr %arrayidx1, align 4
  %load3 = load i32, ptr %arrayidx2, align 4
  %load4 = load i32, ptr %arrayidx3, align 4
  %load5 = load i32, ptr %arrayidx4, align 4
  %add = add i32 %load1, 88
  %add9 = add i32 %add, %load2
  %add11 = add i32 %add9, %load3
  %add13 = add i32 %add11, %load4
  %add15 = add i32 %add13, %load5
  ret i32 %add15
}

; DIS:      file format aix5coff64-rs6000
; DIS:      Disassembly of section .text:
; DIS:      0000000000000000 (idx: [[#NFA+9]]) .test1:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mflr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stdu 1, -48(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+23]]) _$TLSML[TC]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 6, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+25]]) ElementIntTLSv1[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 0, 64(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 7, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+27]]) ElementIntTLS3[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 0(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+23]]) _$TLSML[TC]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 8, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+29]]) ElementIntTLS4[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 9, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+31]]) ElementIntTLS5[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 7, 16(7)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+27]]) ElementIntTLS3[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 8, 24(8)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+29]]) ElementIntTLS4[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 9, 32(9)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+31]]) ElementIntTLS5[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                bla 0x0
; DIS-NEXT: {{0*}}[[#ADDR]]: R_RBA	(idx: [[#NFA+1]]) .__tls_get_mod[PR]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 5, 8(6)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+25]]) ElementIntTLSv1[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 6, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+33]]) ElementIntTLS2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 1
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 6, 40(6)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+33]]) ElementIntTLS2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 7, 3, 7
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 8, 3, 8
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 9, 3, 9
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 6, 3, 6
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stwux 4, 3, 5
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 2
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 320(6)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 324(7)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 4
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 24(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 88
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 328(8)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 332(9)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 102
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 1, 1, 48
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 0, 16(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mtlr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      0000000000000090 (idx: [[#NFA+11]]) .test2:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mflr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stdu 1, -48(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+23]]) _$TLSML[TC]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 0, 64(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 7, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+35]]) ElementLongTLS6[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 0(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+23]]) _$TLSML[TC]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                bla 0x0
; DIS-NEXT: {{0*}}[[#ADDR]]: R_RBA	(idx: [[#NFA+1]]) .__tls_get_mod[PR]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 212
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mr	6, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 48(7)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+35]]) ElementLongTLS6[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 3, 6, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, 424(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+37]]) ElementLongTLS2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 203
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 56(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+37]]) ElementLongTLS2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 3, 6, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, 1200(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+39]]) .MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 4, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+41]]) MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 64(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+39]]) .MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 4, 72(4)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+41]]) MyTLSGDVar[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                bla 0x0
; DIS-NEXT: {{0*}}[[#ADDR]]: R_RBA	(idx: [[#NFA+3]]) .__tls_get_addr[PR]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 44
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, 440(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+43]]) ElementLongTLS3[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 6
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 80(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+43]]) ElementLongTLS3[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 3, 6, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, 2000(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+45]]) ElementLongTLS4[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 100
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 88(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+45]]) ElementLongTLS4[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 3, 6, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, 6800(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+47]]) ElementLongTLS5[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 882
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 96(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+47]]) ElementLongTLS5[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 3, 6, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 4, 8400(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 1191
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 1, 1, 48
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 0, 16(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mtlr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      0000000000000140 (idx: [[#NFA+13]]) .test3:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mflr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stdu 1, -48(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+23]]) _$TLSML[TC]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 6, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+49]]) ElementIntTLSv2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                std 0, 64(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 7, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+27]]) ElementIntTLS3[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 0(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+23]]) _$TLSML[TC]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 8, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+29]]) ElementIntTLS4[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 9, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+31]]) ElementIntTLS5[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 7, 16(7)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+27]]) ElementIntTLS3[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 8, 24(8)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+29]]) ElementIntTLS4[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 9, 32(9)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+31]]) ElementIntTLS5[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                bla 0x0
; DIS-NEXT: {{0*}}[[#ADDR]]: R_RBA	(idx: [[#NFA+1]]) .__tls_get_mod[PR]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 5, 104(6)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+49]]) ElementIntTLSv2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 6, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+33]]) ElementIntTLS2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 1
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 6, 40(6)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+33]]) ElementIntTLS2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 7, 3, 7
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 8, 3, 8
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 9, 3, 9
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 6, 3, 6
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stwux 4, 3, 5
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 2
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 320(6)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 324(7)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 4
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 24(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 88
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 328(8)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 332(9)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 102
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addi 1, 1, 48
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 0, 16(1)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                mtlr 0
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      Disassembly of section .data:

; DIS:      00000000000001d0 (idx: 17) test1[DS]:
; DIS-NEXT:      1d0: 00 00 00 00
; DIS-NEXT: 00000000000001d0:  R_POS	(idx: [[#NFA+9]]) .test1
; DIS-NEXT:      1d4: 00 00 00 00
; DIS-NEXT:      1d8: 00 00 00 00
; DIS-NEXT: 00000000000001d8:  R_POS	(idx: [[#NFA+21]]) TOC[TC0]
; DIS-NEXT:      1dc: 00 00 02 18

; DIS:      00000000000001e8 (idx: 19) test2[DS]:
; DIS-NEXT:      1e8: 00 00 00 00
; DIS-NEXT: 00000000000001e8:  R_POS	(idx: [[#NFA+11]]) .test2
; DIS-NEXT:      1ec: 00 00 00 90
; DIS-NEXT:      1f0: 00 00 00 00
; DIS-NEXT: 00000000000001f0:  R_POS	(idx: [[#NFA+21]]) TOC[TC0]
; DIS-NEXT:      1f4: 00 00 02 18

; DIS:      0000000000000200 (idx: 21) test3[DS]:
; DIS-NEXT:      200: 00 00 00 00
; DIS-NEXT: 0000000000000200:  R_POS	(idx: [[#NFA+13]]) .test3
; DIS-NEXT:      204: 00 00 01 40
; DIS-NEXT:      208: 00 00 00 00
; DIS-NEXT: 0000000000000208:  R_POS	(idx: [[#NFA+21]]) TOC[TC0]
; DIS-NEXT:      20c: 00 00 02 18

; DIS:      0000000000000218 (idx: 25) _$TLSML[TC]:
; DIS-NEXT:      218: 00 00 00 00
; DIS-NEXT: 0000000000000218:  R_TLSML	(idx: [[#NFA+23]]) _$TLSML[TC]
; DIS-NEXT:      21c: 00 00 00 00

; DIS:      0000000000000220 (idx: 27) ElementIntTLSv1[TE]:
; DIS-NEXT:      220: 00 00 00 00
; DIS-NEXT: 0000000000000220:  R_TLS_LD	(idx: [[#NFA+51]]) ElementIntTLSv1[TL]
; DIS-NEXT:      224: 00 00 00 00

; DIS:      0000000000000228 (idx: 29) ElementIntTLS3[TE]:
; DIS-NEXT:      228: 00 00 00 00
; DIS-NEXT: 0000000000000228:  R_TLS_LD	(idx: [[#NFA+55]]) ElementIntTLS3[TL]
; DIS-NEXT:      22c: 00 00 be 6c

; DIS:      0000000000000230 (idx: 31) ElementIntTLS4[TE]:
; DIS-NEXT:      230: 00 00 00 00
; DIS-NEXT: 0000000000000230:  R_TLS_LD	(idx: [[#NFA+57]]) ElementIntTLS4[TL]
; DIS-NEXT:      234: 00 00 fc ec

; DIS:      0000000000000238 (idx: 33) ElementIntTLS5[TE]:
; DIS-NEXT:      238: 00 00 00 00
; DIS-NEXT: 0000000000000238:  R_TLS_LD	(idx: [[#NFA+59]]) ElementIntTLS5[TL]
; DIS-NEXT:      23c: 00 01 3b 6c

; DIS:      0000000000000240 (idx: 35) ElementIntTLS2[TE]:
; DIS-NEXT:      240: 00 00 00 00
; DIS-NEXT: 0000000000000240:  R_TLS_LD	(idx: [[#NFA+53]]) ElementIntTLS2[TL]
; DIS-NEXT:      244: 00 00 7f ec

; DIS:      0000000000000248 (idx: 37) ElementLongTLS6[TE]:
; DIS-NEXT:      248: 00 00 00 00
; DIS-NEXT: 0000000000000248:  R_TLS_LD	(idx: [[#NFA+5]]) ElementLongTLS6[UL]
; DIS-NEXT:      24c: 00 00 00 00

; DIS:      0000000000000250 (idx: 39) ElementLongTLS2[TE]:
; DIS-NEXT:      250: 00 00 00 00
; DIS-NEXT: 0000000000000250:  R_TLS_LD	(idx: [[#NFA+63]]) ElementLongTLS2[TL]
; DIS-NEXT:      254: 00 02 06 90

; DIS:      0000000000000258 (idx: 41) .MyTLSGDVar[TE]:
; DIS-NEXT:      258: 00 00 00 00
; DIS-NEXT: 0000000000000258:  R_TLSM	(idx: [[#NFA+65]]) MyTLSGDVar[TL]
; DIS-NEXT:      25c: 00 00 00 00

; DIS:      0000000000000260 (idx: 43) MyTLSGDVar[TE]:
; DIS-NEXT:      260: 00 00 00 00
; DIS-NEXT: 0000000000000260:  R_TLS	(idx: [[#NFA+65]]) MyTLSGDVar[TL]
; DIS-NEXT:      264: 00 02 64 50

; DIS:      0000000000000268 (idx: 45) ElementLongTLS3[TE]:
; DIS-NEXT:      268: 00 00 00 00
; DIS-NEXT: 0000000000000268:  R_TLS_LD	(idx: [[#NFA+67]]) ElementLongTLS3[TL]
; DIS-NEXT:      26c: 00 02 7d 50

; DIS:      0000000000000270 (idx: 47) ElementLongTLS4[TE]:
; DIS-NEXT:      270: 00 00 00 00
; DIS-NEXT: 0000000000000270:  R_TLS_LD	(idx: [[#NFA+69]]) ElementLongTLS4[TL]
; DIS-NEXT:      274: 00 02 db 10

; DIS:      0000000000000278 (idx: 49) ElementLongTLS5[TE]:
; DIS-NEXT:      278: 00 00 00 00
; DIS-NEXT: 0000000000000278:  R_TLS_LD	(idx: [[#NFA+71]]) ElementLongTLS5[TL]
; DIS-NEXT:      27c: 00 03 38 d0

; DIS:      0000000000000280 (idx: 51) ElementIntTLSv2[TE]:
; DIS-NEXT:      280: 00 00 00 00
; DIS-NEXT: 0000000000000280:  R_TLS_LD	(idx: [[#NFA+61]]) ElementIntTLSv2[TL]
; DIS-NEXT:      284: 00 01 79 ec

; DIS:      Disassembly of section .tdata:
; DIS:      0000000000000000 (idx: [[#NFA+51]]) ElementIntTLSv1[TL]:
; DIS:      0000000000007fec (idx: [[#NFA+53]]) ElementIntTLS2[TL]:
; DIS:      000000000000be6c (idx: [[#NFA+55]]) ElementIntTLS3[TL]:
; DIS:      000000000000fcec (idx: [[#NFA+57]]) ElementIntTLS4[TL]:
; DIS:      0000000000013b6c (idx: [[#NFA+59]]) ElementIntTLS5[TL]:
; DIS:      00000000000179ec (idx: [[#NFA+61]]) ElementIntTLSv2[TL]:
; DIS:      0000000000020690 (idx: [[#NFA+63]]) ElementLongTLS2[TL]:
; DIS:      0000000000026450 (idx: [[#NFA+65]]) MyTLSGDVar[TL]:
; DIS:      0000000000027d50 (idx: [[#NFA+67]]) ElementLongTLS3[TL]:
; DIS:      000000000002db10 (idx: [[#NFA+69]]) ElementLongTLS4[TL]:
; DIS:      00000000000338d0 (idx: [[#NFA+71]]) ElementLongTLS5[TL]:
; DIS:      0000000000039690 (idx: [[#NFA+73]]) ElementLongTLS[TL]:
