; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=arm-eabi -mcpu=cortex-a9 < %s | FileCheck %s

define i8 @atomicrmw_uinc_wrap_i8(ptr %ptr, i8 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    uxtb r12, r1
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB0_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldrexb r1, [r0]
; CHECK-NEXT:    cmp r1, r12
; CHECK-NEXT:    add r3, r1, #1
; CHECK-NEXT:    movwhs r3, #0
; CHECK-NEXT:    strexb r2, r3, [r0]
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    bne .LBB0_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    bx lr
  %result = atomicrmw uinc_wrap ptr %ptr, i8 %val seq_cst
  ret i8 %result
}

define i16 @atomicrmw_uinc_wrap_i16(ptr %ptr, i16 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    uxth r12, r1
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB1_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldrexh r1, [r0]
; CHECK-NEXT:    cmp r1, r12
; CHECK-NEXT:    add r3, r1, #1
; CHECK-NEXT:    movwhs r3, #0
; CHECK-NEXT:    strexh r2, r3, [r0]
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    bne .LBB1_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    bx lr
  %result = atomicrmw uinc_wrap ptr %ptr, i16 %val seq_cst
  ret i16 %result
}

define i32 @atomicrmw_uinc_wrap_i32(ptr %ptr, i32 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB2_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldrex r2, [r0]
; CHECK-NEXT:    cmp r2, r1
; CHECK-NEXT:    add r12, r2, #1
; CHECK-NEXT:    movwhs r12, #0
; CHECK-NEXT:    strex r3, r12, [r0]
; CHECK-NEXT:    cmp r3, #0
; CHECK-NEXT:    bne .LBB2_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r2
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    bx lr
  %result = atomicrmw uinc_wrap ptr %ptr, i32 %val seq_cst
  ret i32 %result
}

define i64 @atomicrmw_uinc_wrap_i64(ptr %ptr, i64 %val) {
; CHECK-LABEL: atomicrmw_uinc_wrap_i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; CHECK-NEXT:    push {r4, r5, r6, r7, r11, lr}
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB3_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldrexd r4, r5, [r0]
; CHECK-NEXT:    adds r6, r4, #1
; CHECK-NEXT:    adc r7, r5, #0
; CHECK-NEXT:    subs r1, r4, r2
; CHECK-NEXT:    sbcs r1, r5, r3
; CHECK-NEXT:    mov r1, #0
; CHECK-NEXT:    movwhs r1, #1
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    movwne r7, #0
; CHECK-NEXT:    movwne r6, #0
; CHECK-NEXT:    strexd r1, r6, r7, [r0]
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    bne .LBB3_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    mov r1, r5
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    pop {r4, r5, r6, r7, r11, pc}
  %result = atomicrmw uinc_wrap ptr %ptr, i64 %val seq_cst
  ret i64 %result
}

define i8 @atomicrmw_udec_wrap_i8(ptr %ptr, i8 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB4_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    uxtb r3, r1
; CHECK-NEXT:    ldrexb r12, [r0]
; CHECK-NEXT:    cmp r12, r3
; CHECK-NEXT:    mov r3, r1
; CHECK-NEXT:    subls r3, r12, #1
; CHECK-NEXT:    cmp r12, #0
; CHECK-NEXT:    moveq r3, r1
; CHECK-NEXT:    strexb r2, r3, [r0]
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    bne .LBB4_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r12
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    bx lr
  %result = atomicrmw udec_wrap ptr %ptr, i8 %val seq_cst
  ret i8 %result
}

define i16 @atomicrmw_udec_wrap_i16(ptr %ptr, i16 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB5_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    uxth r3, r1
; CHECK-NEXT:    ldrexh r12, [r0]
; CHECK-NEXT:    cmp r12, r3
; CHECK-NEXT:    mov r3, r1
; CHECK-NEXT:    subls r3, r12, #1
; CHECK-NEXT:    cmp r12, #0
; CHECK-NEXT:    moveq r3, r1
; CHECK-NEXT:    strexh r2, r3, [r0]
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    bne .LBB5_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r12
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    bx lr
  %result = atomicrmw udec_wrap ptr %ptr, i16 %val seq_cst
  ret i16 %result
}

define i32 @atomicrmw_udec_wrap_i32(ptr %ptr, i32 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB6_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldrex r12, [r0]
; CHECK-NEXT:    mov r3, r1
; CHECK-NEXT:    cmp r12, r1
; CHECK-NEXT:    subls r3, r12, #1
; CHECK-NEXT:    cmp r12, #0
; CHECK-NEXT:    moveq r3, r1
; CHECK-NEXT:    strex r2, r3, [r0]
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    bne .LBB6_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r12
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    bx lr
  %result = atomicrmw udec_wrap ptr %ptr, i32 %val seq_cst
  ret i32 %result
}

define i64 @atomicrmw_udec_wrap_i64(ptr %ptr, i64 %val) {
; CHECK-LABEL: atomicrmw_udec_wrap_i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, r5, r6, r7, r11, lr}
; CHECK-NEXT:    push {r4, r5, r6, r7, r11, lr}
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:  .LBB7_1: @ %atomicrmw.start
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldrexd r4, r5, [r0]
; CHECK-NEXT:    mov r12, #0
; CHECK-NEXT:    subs r1, r2, r4
; CHECK-NEXT:    sbcs r1, r3, r5
; CHECK-NEXT:    orr r1, r4, r5
; CHECK-NEXT:    clz r1, r1
; CHECK-NEXT:    movwlo r12, #1
; CHECK-NEXT:    lsr r1, r1, #5
; CHECK-NEXT:    subs r6, r4, #1
; CHECK-NEXT:    sbc r7, r5, #0
; CHECK-NEXT:    orr r1, r1, r12
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    movne r7, r3
; CHECK-NEXT:    movne r6, r2
; CHECK-NEXT:    strexd r1, r6, r7, [r0]
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    bne .LBB7_1
; CHECK-NEXT:  @ %bb.2: @ %atomicrmw.end
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    mov r1, r5
; CHECK-NEXT:    dmb ish
; CHECK-NEXT:    pop {r4, r5, r6, r7, r11, pc}
  %result = atomicrmw udec_wrap ptr %ptr, i64 %val seq_cst
  ret i64 %result
}
