/* automatically generated by rust-bindgen 0.65.1 */


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0


#![allow(unused_imports, non_camel_case_types)]

use libc::{iovec, FILE, off_t};


extern "C" {
    #[doc = " This function can be used instead of trying to resolve `s2n_errno` directly\n in runtimes where thread-local variables may not be easily accessible.\n\n @returns The address of the thread-local `s2n_errno` variable"]
    pub fn s2n_errno_location() -> *mut ::libc::c_int;
}
pub mod s2n_error_type {
    #[doc = " Used to help applications determine why an s2n-tls function failed.\n\n This enum is optimized for use in C switch statements. Each value in the enum represents\n an error \"category\".\n\n s2n-tls organizes errors into different \"types\" to allow applications to handle error\n values without catching all possibilities. Applications using non-blocking I/O should check\n the error type to determine if the I/O operation failed because it would block or for some other\n error. To retrieve the type for a given error use `s2n_error_get_type()`. Applications should\n perform any error handling logic using these high level types.\n\n See the [Error Handling](https://github.com/aws/s2n-tls/blob/main/docs/USAGE-GUIDE.md#error-handling) section for how the errors should be interpreted."]
    pub type Type = ::libc::c_uint;
    #[doc = " No error"]
    pub const OK: Type = 0;
    #[doc = " Underlying I/O operation failed, check system errno"]
    pub const IO: Type = 1;
    #[doc = " EOF"]
    pub const CLOSED: Type = 2;
    #[doc = " Underlying I/O operation would block"]
    pub const BLOCKED: Type = 3;
    #[doc = " Incoming Alert"]
    pub const ALERT: Type = 4;
    #[doc = " Failure in some part of the TLS protocol. Ex: CBC verification failure"]
    pub const PROTO: Type = 5;
    #[doc = " Error internal to s2n-tls. A precondition could have failed."]
    pub const INTERNAL: Type = 6;
    #[doc = " User input error. Ex: Providing an invalid cipher preference version"]
    pub const USAGE: Type = 7;
}
extern "C" {
    #[doc = " Gets the category of error from an error.\n\n s2n-tls organizes errors into different \"types\" to allow applications to do logic on error values without catching all possibilities.\n Applications using non-blocking I/O should check error type to determine if the I/O operation failed because\n it would block or for some other error.\n\n @param error The error from s2n. Usually this is `s2n_errno`.\n @returns An s2n_error_type"]
    pub fn s2n_error_get_type(error: ::libc::c_int) -> ::libc::c_int;
}
#[doc = " An opaque configuration object, used by clients and servers for holding cryptographic certificates, keys and preferences."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_config {
    _unused: [u8; 0],
}
#[doc = " An opaque connection. Used to track each s2n connection."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_connection {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Prevents S2N from calling `OPENSSL_init_crypto`/`OPENSSL_cleanup`/`EVP_cleanup` on OpenSSL versions\n prior to 1.1.x. This allows applications or languages that also init OpenSSL to interoperate\n with S2N.\n\n @warning This function must be called BEFORE s2n_init() to have any effect. It will return an error\n if s2n is already initialized.\n\n @note If you disable this and are using a version of OpenSSL/libcrypto < 1.1.x, you will\n be responsible for library init and cleanup (specifically `OPENSSL_add_all_algorithms()`\n or `OPENSSL_init_crypto()`, and EVP_* APIs will not be usable unless the library is initialized.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_crypto_disable_init() -> ::libc::c_int;
}
extern "C" {
    #[doc = " Prevents S2N from installing an atexit handler, which allows safe shutdown of S2N from within a\n re-entrant shared library\n\n @warning This function must be called BEFORE s2n_init() to have any effect. It will return an error\n if s2n is already initialized.\n\n @note This will cause `s2n_cleanup` to do complete cleanup of s2n-tls when called from the main\n thread (the thread `s2n_init` was called from).\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_disable_atexit() -> ::libc::c_int;
}
extern "C" {
    #[doc = " Fetches the OpenSSL version s2n-tls was compiled with. This can be used by applications to validate at runtime\n that the versions of s2n-tls and Openssl that they have loaded are correct.\n\n @returns the version number of OpenSSL that s2n-tls was compiled with"]
    pub fn s2n_get_openssl_version() -> ::libc::c_ulong;
}
extern "C" {
    #[doc = " Initializes the s2n-tls library and should be called once in your application, before any other s2n-tls\n functions are called. Failure to call s2n_init() will result in errors from other s2n-tls functions.\n\n @warning This function is not thread safe and should only be called once.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_init() -> ::libc::c_int;
}
extern "C" {
    #[doc = " Cleans up any internal resources used by s2n-tls. This function should be called from each thread or process\n that is created subsequent to calling `s2n_init` when that thread or process is done calling other s2n-tls functions.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cleanup() -> ::libc::c_int;
}
extern "C" {
    #[doc = " Creates a new s2n_config object. This object can (and should) be associated with many connection\n objects.\n\n The returned config will be initialized with default system certificates in its trust store.\n\n The returned config should be freed with `s2n_config_free()` after it's no longer in use by any\n connection.\n\n @returns A new configuration object suitable for configuring connections and associating certs\n and keys."]
    pub fn s2n_config_new() -> *mut s2n_config;
}
extern "C" {
    #[doc = " Creates a new s2n_config object with minimal default options.\n\n This function has better performance than `s2n_config_new()` because it does not load default\n system certificates into the trust store by default. To add system certificates to this config,\n call `s2n_config_load_system_certs()`.\n\n The returned config should be freed with `s2n_config_free()` after it's no longer in use by any\n connection.\n\n @returns A new configuration object suitable for configuring connections and associating certs\n and keys."]
    pub fn s2n_config_new_minimal() -> *mut s2n_config;
}
extern "C" {
    #[doc = " Frees the memory associated with an `s2n_config` object.\n\n @param config The configuration object being freed\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_free(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Frees the DH params associated with an `s2n_config` object.\n\n @param config The configuration object with DH params being freed\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_free_dhparams(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Frees the certificate chain and key associated with an `s2n_config` object.\n\n @param config The configuration object with DH params being freed\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_free_cert_chain_and_key(config: *mut s2n_config) -> ::libc::c_int;
}
#[doc = " Callback function type used to get the system time.\n\n @param void* A pointer to arbitrary data for use within the callback\n @param uint64_t* A pointer that the callback will set to the time in nanoseconds\n The function should return 0 on success and -1 on failure."]
pub type s2n_clock_time_nanoseconds = ::core::option::Option<
    unsafe extern "C" fn(arg1: *mut ::libc::c_void, arg2: *mut u64) -> ::libc::c_int,
>;
#[doc = " Cache callback function that allows the caller to retrieve SSL session data\n from a cache.\n\n The callback function takes six arguments:\n a pointer to the s2n_connection object,\n a pointer to arbitrary data for use within the callback,\n a pointer to a key which can be used to retrieve the cached entry,\n a 64 bit unsigned integer specifying the size of this key,\n a pointer to a memory location where the value should be stored,\n and a pointer to a 64 bit unsigned integer specifying the size of this value.\n\n Initially *value_size will be set to the amount of space allocated for the value,\n the callback should set *value_size to the actual size of the data returned.\n If there is insufficient space, -1 should be returned.\n If the cache is not ready to provide data for the request,\n S2N_CALLBACK_BLOCKED should be returned.\n\n This will cause s2n_negotiate() to return S2N_BLOCKED_ON_APPLICATION_INPUT."]
pub type s2n_cache_retrieve_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        arg1: *mut ::libc::c_void,
        key: *const ::libc::c_void,
        key_size: u64,
        value: *mut ::libc::c_void,
        value_size: *mut u64,
    ) -> ::libc::c_int,
>;
#[doc = " Cache callback function that allows the caller to store SSL session data in a\n cache.\n\n The callback function takes seven arguments:\n a pointer to the s2n_connection object,\n a pointer to arbitrary data for use within the callback,\n a 64-bit unsigned integer specifying the number of seconds the session data may be stored for,\n a pointer to a key which can be used to retrieve the cached entry,\n a 64 bit unsigned integer specifying the size of this key,\n a pointer to a value which should be stored,\n and a 64 bit unsigned integer specified the size of this value."]
pub type s2n_cache_store_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        arg1: *mut ::libc::c_void,
        ttl_in_seconds: u64,
        key: *const ::libc::c_void,
        key_size: u64,
        value: *const ::libc::c_void,
        value_size: u64,
    ) -> ::libc::c_int,
>;
#[doc = "  Cache callback function that allows the caller to set a callback function\n  that will be used to delete SSL session data from a cache.\n\n  The callback function takes four arguments:\n  a pointer to s2n_connection object,\n  a pointer to arbitrary data for use within the callback,\n  a pointer to a key which can be used to delete the cached entry,\n  and a 64 bit unsigned integer specifying the size of this key."]
pub type s2n_cache_delete_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        arg1: *mut ::libc::c_void,
        key: *const ::libc::c_void,
        key_size: u64,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Allows the caller to set a callback function that will be used to get the\n system time. The time returned should be the number of nanoseconds since the\n Unix epoch (Midnight, January 1st, 1970).\n\n s2n-tls uses this clock for timestamps.\n\n @param config The configuration object being updated\n @param clock_fn The wall clock time callback function\n @param ctx An opaque pointer that the callback will be invoked with\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_wall_clock(
        config: *mut s2n_config,
        clock_fn: s2n_clock_time_nanoseconds,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Allows the caller to set a callback function that will be used to get\n monotonic time. The monotonic time is the time since an arbitrary, unspecified\n point. Unlike wall clock time, it MUST never move backwards.\n\n s2n-tls uses this clock for timers.\n\n @param config The configuration object being updated\n @param clock_fn The monotonic time callback function\n @param ctx An opaque pointer that the callback will be invoked with\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_monotonic_clock(
        config: *mut s2n_config,
        clock_fn: s2n_clock_time_nanoseconds,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Translates an s2n_error code to a human readable string explaining the error.\n\n @param error The error code to explain. Usually this is s2n_errno\n @param lang The language to explain the error code. Pass \"EN\" or NULL for English.\n @returns The error string"]
    pub fn s2n_strerror(error: ::libc::c_int, lang: *const ::libc::c_char)
        -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Translates an s2n_error code to a human readable string containing internal debug\n information, including file name and line number. This function is useful when\n reporting issues to the s2n-tls development team.\n\n @param error The error code to explain. Usually this is s2n_errno\n @param lang The language to explain the error code. Pass \"EN\" or NULL for English.\n @returns The error string"]
    pub fn s2n_strerror_debug(
        error: ::libc::c_int,
        lang: *const ::libc::c_char,
    ) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Translates an s2n_error code to a human readable string.\n\n @param error The error code to explain. Usually this is s2n_errno\n @returns The error string"]
    pub fn s2n_strerror_name(error: ::libc::c_int) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Translates an s2n_error code to a filename and line number.\n\n @param error The error code to explain. Usually this is s2n_errno.\n @returns The error string."]
    pub fn s2n_strerror_source(error: ::libc::c_int) -> *const ::libc::c_char;
}
#[doc = " Opaque stack trace structure."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_stacktrace {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Checks if s2n stack trace captures are enabled.\n\n @returns True if stack traces are enabled. False if they are disabled."]
    pub fn s2n_stack_traces_enabled() -> bool;
}
extern "C" {
    #[doc = " Configures the s2n stack trace captures option.\n\n @param newval Boolean to determine if stack traces should be enabled. True to enable them. False to disable them.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_stack_traces_enabled_set(newval: bool) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Calculates the s2n stack trace.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_calculate_stacktrace() -> ::libc::c_int;
}
extern "C" {
    #[doc = " Prints the s2n stack trace to a file. The file descriptor is expected to be\n open and ready for writing.\n\n @param fptr A pointer to the file s2n-tls should write the stack trace to.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_print_stacktrace(fptr: *mut FILE) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Clean up the memory used to contain the stack trace.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_free_stacktrace() -> ::libc::c_int;
}
extern "C" {
    #[doc = " Export the s2n_stacktrace.\n\n @param trace A pointer to the s2n_stacktrace to fill.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_get_stacktrace(trace: *mut s2n_stacktrace) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Allows the caller to set a callback function that will be used to store SSL\n session data in a cache.\n\n @param config The configuration object being updated\n @param cache_store_callback The cache store callback function.\n @param data An opaque context pointer that the callback will be invoked with.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_cache_store_callback(
        config: *mut s2n_config,
        cache_store_callback: s2n_cache_store_callback,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Allows the caller to set a callback function that will be used to retrieve SSL\n session data from a cache.\n\n @param config The configuration object being updated\n @param cache_retrieve_callback The cache retrieve callback function.\n @param data An opaque context pointer that the callback will be invoked with.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_cache_retrieve_callback(
        config: *mut s2n_config,
        cache_retrieve_callback: s2n_cache_retrieve_callback,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Allows the caller to set a callback function that will be used to delete SSL\n session data from a cache.\n\n @param config The configuration object being updated\n @param cache_delete_callback The cache delete callback function.\n @param data An opaque context pointer that the callback will be invoked with.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_cache_delete_callback(
        config: *mut s2n_config,
        cache_delete_callback: s2n_cache_delete_callback,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
#[doc = " Called when `s2n_init` is executed."]
pub type s2n_mem_init_callback = ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
#[doc = " Will be called when `s2n_cleanup` is executed."]
pub type s2n_mem_cleanup_callback = ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
#[doc = " A function that can allocate at least `requested` bytes of memory.\n\n It stores the location of that memory in **\\*ptr** and the size of the allocated\n data in **\\*allocated**. The function may choose to allocate more memory\n than was requested. s2n-tls will consider all allocated memory available for\n use, and will attempt to free all allocated memory when able."]
pub type s2n_mem_malloc_callback = ::core::option::Option<
    unsafe extern "C" fn(
        ptr: *mut *mut ::libc::c_void,
        requested: u32,
        allocated: *mut u32,
    ) -> ::libc::c_int,
>;
#[doc = " Frees memory allocated by s2n_mem_malloc_callback."]
pub type s2n_mem_free_callback = ::core::option::Option<
    unsafe extern "C" fn(ptr: *mut ::libc::c_void, size: u32) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Allows the caller to override s2n-tls's internal memory handling functions.\n\n @warning This function must be called before s2n_init().\n\n @param mem_init_callback The s2n_mem_init_callback\n @param mem_cleanup_callback The s2n_mem_cleanup_callback\n @param mem_malloc_callback The s2n_mem_malloc_callback\n @param mem_free_callback The s2n_mem_free_callback\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_mem_set_callbacks(
        mem_init_callback: s2n_mem_init_callback,
        mem_cleanup_callback: s2n_mem_cleanup_callback,
        mem_malloc_callback: s2n_mem_malloc_callback,
        mem_free_callback: s2n_mem_free_callback,
    ) -> ::libc::c_int;
}
#[doc = " A callback function that will be called when s2n-tls is initialized."]
pub type s2n_rand_init_callback = ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
#[doc = " A callback function that will be called when `s2n_cleanup` is executed."]
pub type s2n_rand_cleanup_callback =
    ::core::option::Option<unsafe extern "C" fn() -> ::libc::c_int>;
#[doc = " A callback function that will be used to provide entropy to the s2n-tls\n random number generators."]
pub type s2n_rand_seed_callback = ::core::option::Option<
    unsafe extern "C" fn(data: *mut ::libc::c_void, size: u32) -> ::libc::c_int,
>;
#[doc = " A callback function that will be used to mix in entropy every time the RNG\n is invoked."]
pub type s2n_rand_mix_callback = ::core::option::Option<
    unsafe extern "C" fn(data: *mut ::libc::c_void, size: u32) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Allows the caller to override s2n-tls's entropy functions.\n\n @warning This function must be called before s2n_init().\n\n @note The overriden random callbacks will not be used when s2n-tls is operating in FIPS mode.\n\n @param rand_init_callback The s2n_rand_init_callback\n @param rand_cleanup_callback The s2n_rand_cleanup_callback\n @param rand_seed_callback The s2n_rand_seed_callback\n @param rand_mix_callback The s2n_rand_mix_callback\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_rand_set_callbacks(
        rand_init_callback: s2n_rand_init_callback,
        rand_cleanup_callback: s2n_rand_cleanup_callback,
        rand_seed_callback: s2n_rand_seed_callback,
        rand_mix_callback: s2n_rand_mix_callback,
    ) -> ::libc::c_int;
}
pub mod s2n_tls_extension_type {
    #[doc = " TLS extensions supported by s2n-tls"]
    pub type Type = ::libc::c_uint;
    pub const SERVER_NAME: Type = 0;
    pub const MAX_FRAG_LEN: Type = 1;
    pub const OCSP_STAPLING: Type = 5;
    pub const SUPPORTED_GROUPS: Type = 10;
    pub const EC_POINT_FORMATS: Type = 11;
    pub const SIGNATURE_ALGORITHMS: Type = 13;
    pub const ALPN: Type = 16;
    pub const CERTIFICATE_TRANSPARENCY: Type = 18;
    pub const SUPPORTED_VERSIONS: Type = 43;
    pub const RENEGOTIATION_INFO: Type = 65281;
}
pub mod s2n_max_frag_len {
    #[doc = " MFL configurations from https://datatracker.ietf.org/doc/html/rfc6066#section-4."]
    pub type Type = ::libc::c_uint;
    pub const LEN_512: Type = 1;
    pub const LEN_1024: Type = 2;
    pub const LEN_2048: Type = 3;
    pub const LEN_4096: Type = 4;
}
#[doc = " Opaque certificate type."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_cert {
    _unused: [u8; 0],
}
#[doc = " Opaque certificate chain and key type."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_cert_chain_and_key {
    _unused: [u8; 0],
}
#[doc = " Opaque key type."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_pkey {
    _unused: [u8; 0],
}
#[doc = " Opaque public key type."]
pub type s2n_cert_public_key = s2n_pkey;
#[doc = " Opaque private key type."]
pub type s2n_cert_private_key = s2n_pkey;
extern "C" {
    #[doc = " Creates a new s2n_cert_chain_and_key object. This object can be associated\n with many config objects. It is used to represent a certificate and key pair.\n\n @returns A new object used to represent a certificate-chain/key pair"]
    pub fn s2n_cert_chain_and_key_new() -> *mut s2n_cert_chain_and_key;
}
extern "C" {
    #[doc = " Associates a certificate chain and private key with an `s2n_cert_chain_and_key` object.\n\n `cert_chain_pem` should be a PEM encoded certificate chain, with the first\n certificate in the chain being your leaf certificate. `private_key_pem`\n should be a PEM encoded private key corresponding to the leaf certificate.\n\n @note Prefer using s2n_cert_chain_and_key_load_pem_bytes.\n\n @param chain_and_key The certificate chain and private key handle\n @param chain_pem A byte array of a PEM encoded certificate chain.\n @param private_key_pem A byte array of a PEM encoded key.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cert_chain_and_key_load_pem(
        chain_and_key: *mut s2n_cert_chain_and_key,
        chain_pem: *const ::libc::c_char,
        private_key_pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Associates a certificate chain and private key with an `s2n_cert_chain_and_key` object.\n\n `cert_chain_pem` should be a PEM encoded certificate chain, with the first\n certificate in the chain being your leaf certificate. `private_key_pem`\n should be a PEM encoded private key corresponding to the leaf certificate.\n\n @param chain_and_key The certificate chain and private key handle\n @param chain_pem A byte array of a PEM encoded certificate chain.\n @param chain_pem_len Size of `chain_pem`\n @param private_key_pem A byte array of a PEM encoded key.\n @param private_key_pem_len Size of `private_key_pem`\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cert_chain_and_key_load_pem_bytes(
        chain_and_key: *mut s2n_cert_chain_and_key,
        chain_pem: *mut u8,
        chain_pem_len: u32,
        private_key_pem: *mut u8,
        private_key_pem_len: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Associates a public certificate chain with a `s2n_cert_chain_and_key` object. It does\n NOT set a private key, so the connection will need to be configured to\n [offload private key operations](https://github.com/aws/s2n-tls/blob/main/docs/USAGE-GUIDE.md#offloading-asynchronous-private-key-operations).\n\n @param chain_and_key The certificate chain and private key handle\n @param chain_pem A byte array of a PEM encoded certificate chain.\n @param chain_pem_len Size of `chain_pem`\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cert_chain_and_key_load_public_pem_bytes(
        chain_and_key: *mut s2n_cert_chain_and_key,
        chain_pem: *mut u8,
        chain_pem_len: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Frees the memory associated with an `s2n_cert_chain_and_key` object.\n\n @param cert_and_key The certificate chain and private key handle\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cert_chain_and_key_free(cert_and_key: *mut s2n_cert_chain_and_key) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Adds a context to the `s2n_cert_chain_and_key` object.\n\n @param cert_and_key The certificate chain and private key handle\n @param ctx An opaque pointer to user supplied data.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cert_chain_and_key_set_ctx(
        cert_and_key: *mut s2n_cert_chain_and_key,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the user supplied context from the `s2n_cert_chain_and_key` object.\n\n @param cert_and_key The certificate chain and private key handle\n @returns The user supplied pointer from s2n_cert_chain_and_key_set_ctx()"]
    pub fn s2n_cert_chain_and_key_get_ctx(
        cert_and_key: *mut s2n_cert_chain_and_key,
    ) -> *mut ::libc::c_void;
}
extern "C" {
    #[doc = " Get the private key from the `s2n_cert_chain_and_key` object.\n\n @param cert_and_key The certificate chain and private key handle\n @returns A pointer to the `s2n_cert_private_key`"]
    pub fn s2n_cert_chain_and_key_get_private_key(
        cert_and_key: *mut s2n_cert_chain_and_key,
    ) -> *mut s2n_cert_private_key;
}
extern "C" {
    #[doc = " Set the raw OCSP stapling data for a certificate chain.\n\n @param chain_and_key The certificate chain handle\n @param data A pointer to the raw OCSP stapling data bytes. The data will be copied.\n @param length The length of the data bytes.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cert_chain_and_key_set_ocsp_data(
        chain_and_key: *mut s2n_cert_chain_and_key,
        data: *const u8,
        length: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Set the signed certificate timestamp (SCT) for a certificate chain.\n This is used for Certificate Transparency.\n\n @param chain_and_key The certificate chain handle\n @param data A pointer to the SCT data. The data will be copied.\n @param length The length of the data bytes.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_cert_chain_and_key_set_sct_list(
        chain_and_key: *mut s2n_cert_chain_and_key,
        data: *const u8,
        length: u32,
    ) -> ::libc::c_int;
}
#[doc = " A callback function that is invoked if s2n-tls cannot resolve a conflict between\n two certificates with the same domain name. This function is invoked while certificates\n are added to an `s2n_config`.\n\n Currently, the only builtin resolution for domain name conflicts is certificate type(RSA,\n ECDSA, etc). The callback should return a pointer to the `s2n_cert_chain_and_key` that\n should be used for dns name `name`.\n\n If NULL is returned, the first certificate will be used. Typically an application\n will use properties like trust and expiry to implement tiebreaking."]
pub type s2n_cert_tiebreak_callback = ::core::option::Option<
    unsafe extern "C" fn(
        cert1: *mut s2n_cert_chain_and_key,
        cert2: *mut s2n_cert_chain_and_key,
        name: *mut u8,
        name_len: u32,
    ) -> *mut s2n_cert_chain_and_key,
>;
extern "C" {
    #[doc = " Sets the `s2n_cert_tiebreak_callback` for resolving domain name conflicts.\n If no callback is set, the first certificate added for a domain name will always be preferred.\n\n @param config The configuration object being updated\n @param cert_tiebreak_cb The pointer to the certificate tiebreak function\n\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_cert_tiebreak_callback(
        config: *mut s2n_config,
        cert_tiebreak_cb: s2n_cert_tiebreak_callback,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Associates a certificate chain and private key with an `s2n_config` object.\n Using this API, only one cert chain of each type (like ECDSA or RSA) may be associated with a config.\n `cert_chain_pem` should be a PEM encoded certificate chain, with the first certificate\n in the chain being your server's certificate. `private_key_pem` should be a\n PEM encoded private key corresponding to the server certificate.\n\n @deprecated Use s2n_config_add_cert_chain_and_key_to_store instead.\n\n @param config The configuration object being updated\n @param cert_chain_pem A byte array of a PEM encoded certificate chain.\n @param private_key_pem A byte array of a PEM encoded key.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure."]
    pub fn s2n_config_add_cert_chain_and_key(
        config: *mut s2n_config,
        cert_chain_pem: *const ::libc::c_char,
        private_key_pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " The preferred method of associating a certificate chain and private key pair with an `s2n_config` object.\n This method may be called multiple times to support multiple key types(RSA, ECDSA) and multiple domains.\n On the server side, the certificate selected will be based on the incoming SNI value and the\n client's capabilities(supported ciphers).\n\n In the case of no certificate matching the client's SNI extension or if no SNI extension was sent by\n the client, the certificate from the `first` call to `s2n_config_add_cert_chain_and_key_to_store`\n will be selected.\n\n @warning It is not recommended to free or modify the `cert_key_pair` as any subsequent changes will be\n reflected in the config.\n\n @param config The configuration object being updated\n @param cert_key_pair The certificate chain and private key handle\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_add_cert_chain_and_key_to_store(
        config: *mut s2n_config,
        cert_key_pair: *mut s2n_cert_chain_and_key,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Explicitly sets certificate chain and private key pairs to be used as defaults for each auth\n method (key type). A \"default\" certificate is used when there is not an SNI match with any other\n configured certificate.\n\n Only one certificate can be set as the default per auth method (one RSA default, one ECDSA default,\n etc.). All previous default certificates will be cleared and re-set when this API is called.\n\n This API is called for a specific `s2n_config` object. s2n-tls will attempt to automatically choose\n default certificates for each auth method (key type) based on the order that `s2n_cert_chain_and_key`\n are added to the `s2n_config` using one of the APIs listed above.\n `s2n_config_set_cert_chain_and_key_defaults` can be called at any time; s2n-tls will clear defaults\n and no longer attempt to automatically choose any default certificates.\n\n @param config The configuration object being updated\n @param cert_key_pairs An array of certificate chain and private key handles\n @param num_cert_key_pairs The amount of handles in cert_key_pairs\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_cert_chain_and_key_defaults(
        config: *mut s2n_config,
        cert_key_pairs: *mut *mut s2n_cert_chain_and_key,
        num_cert_key_pairs: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Adds to the trust store from a CA file or directory containing trusted certificates.\n\n When configs are created with `s2n_config_new()`, the trust store is initialized with default\n system certificates. To completely override these certificates, call\n `s2n_config_wipe_trust_store()` before calling this function.\n\n @note The trust store will be initialized with the common locations for the host\n operating system by default.\n @param config The configuration object being updated\n @param ca_pem_filename A string for the file path of the CA PEM file.\n @param ca_dir A string for the directory of the CA PEM files.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_verification_ca_location(
        config: *mut s2n_config,
        ca_pem_filename: *const ::libc::c_char,
        ca_dir: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Adds a PEM to the trust store. This will allocate memory, and load `pem` into the trust store.\n\n When configs are created with `s2n_config_new()`, the trust store is initialized with default\n system certificates. To completely override these certificates, call\n `s2n_config_wipe_trust_store()` before calling this function.\n\n @param config The configuration object being updated\n @param pem The string value of the PEM certificate.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_add_pem_to_trust_store(
        config: *mut s2n_config,
        pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Clears the trust store of all certificates.\n\n When configs are created with `s2n_config_new()`, the trust store is initialized with default\n system certificates. To completely override these certificates, call this function before\n functions like `s2n_config_set_verification_ca_location()` or\n `s2n_config_add_pem_to_trust_store()`.\n\n @param config The configuration object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_wipe_trust_store(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Loads default system certificates into the trust store.\n\n `s2n_config_new_minimal()` doesn't load default system certificates into the config's trust\n store by default. If `config` was created with `s2n_config_new_minimal`, this function can be\n used to load system certificates into the trust store.\n\n @note This API will error if called on a config that has already loaded system certificates\n into its trust store, which includes all configs created with `s2n_config_new()`.\n\n @param config The configuration object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_load_system_certs(config: *mut s2n_config) -> ::libc::c_int;
}
pub mod s2n_verify_after_sign {
    pub type Type = ::libc::c_uint;
    pub const VERIFY_AFTER_SIGN_DISABLED: Type = 0;
    pub const VERIFY_AFTER_SIGN_ENABLED: Type = 1;
}
extern "C" {
    #[doc = " Toggle whether generated signatures are verified before being sent.\n\n Although signatures produced by the underlying libcrypto should always be valid,\n hardware faults, bugs in the signing implementation, or other uncommon factors\n can cause unexpected mistakes in the final signatures. Because these mistakes\n can leak information about the private key, applications with low trust in their\n hardware or libcrypto may want to verify signatures before sending them.\n\n However, this feature will significantly impact handshake latency.\n Additionally, most libcrypto implementations already check for common errors in signatures."]
    pub fn s2n_config_set_verify_after_sign(
        config: *mut s2n_config,
        mode: s2n_verify_after_sign::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Set a custom send buffer size.\n\n This buffer is used to stage records for sending. By default,\n enough memory is allocated to hold a single record of the maximum\n size configured for the connection. With the default fragment size,\n that is about 8K bytes.\n\n Less memory can be allocated for the send buffer, but this will result in\n smaller, more fragmented records and increased overhead. While the absolute\n minimum size required is 1034 bytes, at least 2K bytes is recommended for\n reasonable record sizes.\n\n More memory can be allocated for the send buffer. This will result in s2n-tls\n buffering multiple records before sending them, reducing system write calls.\n At least 17K bytes is recommended for this use case, or at least 35K bytes\n if larger fragment sizes are used via `s2n_connection_prefer_throughput()`.\n\n @param config The configuration object being updated\n @param size The desired custom buffer size.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_send_buffer_size(config: *mut s2n_config, size: u32) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Enable or disable receiving of multiple TLS records in a single s2n_recv call\n\n By default, s2n-tls returns from s2n_recv() after reading a single TLS record.\n Enabling receiving of multiple records will instead cause s2n_recv() to attempt\n to read until the application-provided output buffer is full. This may be more\n efficient, especially if larger receive buffers are used.\n\n @note If this option is enabled with blocking IO, the call to s2n_recv() will\n not return until either the application-provided output buffer is full or the\n peer closes the connection. This may lead to unintentionally long waits if the\n peer does not send enough data.\n\n @param config The configuration object being updated\n @param enabled Set to `true` if multiple record receive is to be enabled; `false` to disable.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_recv_multi_record(
        config: *mut s2n_config,
        enabled: bool,
    ) -> ::libc::c_int;
}
#[doc = " A callback function invoked (usually multiple times) during X.509 validation for each\n name encountered in the leaf certificate.\n\n Return 1 to trust that hostname or 0 to not trust the hostname.\n\n If this function returns 1, then the certificate is considered trusted and that portion\n of the X.509 validation will succeed.\n\n If no hostname results in a 1 being returned, the certificate will be untrusted and the\n validation will terminate immediately.\n\n Data is a opaque user context set in s2n_config_set_verify_host_callback() or s2n_connection_set_verify_host_callback()."]
pub type s2n_verify_host_fn = ::core::option::Option<
    unsafe extern "C" fn(
        host_name: *const ::libc::c_char,
        host_name_len: usize,
        data: *mut ::libc::c_void,
    ) -> u8,
>;
extern "C" {
    #[doc = " Sets the callback to use for verifying that a hostname from an X.509 certificate is trusted.\n\n The default behavior is to require that the hostname match the server name set with s2n_set_server_name().\n This will likely lead to all client certificates being rejected, so the callback will need to be overriden when using\n  client authentication.\n\n This change will be inherited by s2n_connections using this config. If a separate callback for different connections\n using the same config is desired, see s2n_connection_set_verify_host_callback().\n\n @param config The configuration object being updated\n @param data A user supplied opaque context to pass back to the callback\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_verify_host_callback(
        config: *mut s2n_config,
        arg1: s2n_verify_host_fn,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Toggles whether or not to validate stapled OCSP responses.\n\n 1 means OCSP responses will be validated when they are encountered, while 0 means this step will\n be skipped.\n\n The default value is 1 if the underlying libCrypto implementation supports OCSP.\n\n @param config The configuration object being updated\n @param check_ocsp The desired OCSP response check configuration\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_check_stapled_ocsp_response(
        config: *mut s2n_config,
        check_ocsp: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Disables timestamp validation for received certificates.\n\n By default, s2n-tls checks the notBefore and notAfter fields on the certificates it receives\n during the handshake. If the current date is not within the range of these fields for any\n certificate in the chain of trust, `s2n_negotiate()` will error. This validation is in\n accordance with RFC 5280, section 6.1.3 a.2:\n https://datatracker.ietf.org/doc/html/rfc5280#section-6.1.3.\n\n This API will disable this timestamp validation, permitting negotiation with peers that send\n expired certificates, or certificates that are not yet considered valid.\n\n @warning Applications calling this API should seriously consider the security implications of\n disabling this validation. The validity period of a certificate corresponds to the range of time\n in which the CA is guaranteed to maintain information regarding the certificate's revocation\n status. As such, it may not be possible to obtain accurate revocation information for\n certificates with invalid timestamps. Applications disabling this validation MUST implement\n some external method for limiting certificate lifetime.\n\n @param config The associated connection config.\n @returns S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_config_disable_x509_time_verification(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Turns off all X.509 validation during the negotiation phase of the connection. This should only\n be used for testing or debugging purposes.\n\n @param config The configuration object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_disable_x509_verification(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the maximum allowed depth of a cert chain used for X509 validation. The default value is\n 7. If this limit is exceeded, validation will fail if s2n_config_disable_x509_verification()\n has not been called. 0 is an illegal value and will return an error.\n 1 means only a root certificate will be used.\n\n @param config The configuration object being updated\n @param max_depth The number of allowed certificates in the certificate chain\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_max_cert_chain_depth(
        config: *mut s2n_config,
        max_depth: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Associates a set of Diffie-Hellman parameters with an `s2n_config` object.\n @note `dhparams_pem` should be PEM encoded DH parameters.\n\n @param config The configuration object being updated\n @param dhparams_pem A string containing the PEM encoded DH parameters.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_add_dhparams(
        config: *mut s2n_config,
        dhparams_pem: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the security policy that includes the cipher/kem/signature/ecc preferences and\n protocol version.\n\n See the [USAGE-GUIDE.md](https://github.com/aws/s2n-tls/blob/main/docs/USAGE-GUIDE.md) for how to use security policies."]
    pub fn s2n_config_set_cipher_preferences(
        config: *mut s2n_config,
        version: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Appends the provided application protocol to the preference list\n\n The data provided in `protocol` parameter will be copied into an internal buffer\n\n @param config The configuration object being updated\n @param protocol A pointer to a byte array value\n @param protocol_len The length of bytes that should be read from `protocol`. Note: this value cannot be 0, otherwise an error will be returned."]
    pub fn s2n_config_append_protocol_preference(
        config: *mut s2n_config,
        protocol: *const u8,
        protocol_len: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the application protocol preferences on an `s2n_config` object.\n `protocols` is a list in order of preference, with most preferred protocol first, and of\n length `protocol_count`.\n\n When acting as an `S2N_CLIENT` the protocol list is included in the Client Hello message\n as the ALPN extension.\n\n As an `S2N_SERVER`, the list is used to negotiate a mutual application protocol with the\n client. After the negotiation for the connection has completed, the agreed upon protocol\n can be retrieved with s2n_get_application_protocol()\n\n @param config The configuration object being updated\n @param protocols The list of preferred protocols, in order of preference\n @param protocol_count The size of the protocols list\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_protocol_preferences(
        config: *mut s2n_config,
        protocols: *const *const ::libc::c_char,
        protocol_count: ::libc::c_int,
    ) -> ::libc::c_int;
}
pub mod s2n_status_request_type {
    #[doc = " Enum used to define the type, if any, of certificate status request\n a connection should make during the handshake. The only supported status request type is\n OCSP, `S2N_STATUS_REQUEST_OCSP`."]
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const OCSP: Type = 1;
}
extern "C" {
    #[doc = " Sets up a connection to request the certificate status of a peer during an SSL handshake. If set\n to S2N_STATUS_REQUEST_NONE, no status request is made.\n\n @param config The configuration object being updated\n @param type The desired request status type\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_status_request_type(
        config: *mut s2n_config,
        type_: s2n_status_request_type::Type,
    ) -> ::libc::c_int;
}
pub mod s2n_ct_support_level {
    #[doc = " Enum to set Certificate Transparency Support level."]
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const REQUEST: Type = 1;
}
extern "C" {
    #[doc = " Set the Certificate Transparency Support level.\n\n @param config The configuration object being updated\n @param level The desired Certificate Transparency Support configuration\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_ct_support_level(
        config: *mut s2n_config,
        level: s2n_ct_support_level::Type,
    ) -> ::libc::c_int;
}
pub mod s2n_alert_behavior {
    #[doc = " Sets whether or not a connection should terminate on receiving a WARNING alert from its peer.\n\n `alert_behavior` can take the following values:\n - `S2N_ALERT_FAIL_ON_WARNINGS` default behavior: s2n-tls will terminate the connection if its peer sends a WARNING alert.\n - `S2N_ALERT_IGNORE_WARNINGS` - with the exception of `close_notify` s2n-tls will ignore all WARNING alerts and keep communicating with its peer. This setting is ignored in TLS1.3\n\n @note TLS1.3 terminates a connection for all alerts except user_canceled.\n @warning S2N_ALERT_FAIL_ON_WARNINGS is the recommended behavior. Past TLS protocol vulnerabilities have involved downgrading alerts to warnings."]
    pub type Type = ::libc::c_uint;
    pub const FAIL_ON_WARNINGS: Type = 0;
    pub const IGNORE_WARNINGS: Type = 1;
}
extern "C" {
    #[doc = " Sets the config's alert behavior based on the `s2n_alert_behavior` enum.\n\n @param config The configuration object being updated\n @param alert_behavior The desired alert behavior.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_alert_behavior(
        config: *mut s2n_config,
        alert_behavior: s2n_alert_behavior::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the extension data in the `s2n_config` object for the specified extension.\n This method will clear any existing data that is set. If the data and length\n parameters are set to NULL, no new data is set in the `s2n_config` object,\n effectively clearing existing data.\n\n @deprecated Use s2n_cert_chain_and_key_set_ocsp_data and s2n_cert_chain_and_key_set_sct_list instead.\n\n @param config The configuration object being updated\n @param type The extension type\n @param data Data for the extension\n @param length Length of the `data` buffer"]
    pub fn s2n_config_set_extension_data(
        config: *mut s2n_config,
        type_: s2n_tls_extension_type::Type,
        data: *const u8,
        length: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Allows the caller to set a TLS Maximum Fragment Length extension that will be used\n to fragment outgoing messages. s2n-tls currently does not reject fragments larger\n than the configured maximum when in server mode. The TLS negotiated maximum fragment\n length overrides the preference set by the `s2n_connection_prefer_throughput` and\n `s2n_connection_prefer_low_latency`.\n\n @note Some TLS implementations do not respect their peer's max fragment length extension.\n\n @param config The configuration object being updated\n @param mfl_code The selected MFL size\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_send_max_fragment_length(
        config: *mut s2n_config,
        mfl_code: s2n_max_frag_len::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Allows the server to opt-in to accept client's TLS maximum fragment length extension\n requests. If this API is not called, and client requests the extension, server will ignore\n the request and continue TLS handshake with default maximum fragment length of 8k bytes\n\n @note Some TLS implementations do not respect their peer's max fragment length extension.\n\n @param config The configuration object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_accept_max_fragment_length(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the lifetime of the cached session state. The default value is 15 hours.\n\n @param config The configuration object being updated\n @param lifetime_in_secs The desired lifetime of the session state in seconds\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_session_state_lifetime(
        config: *mut s2n_config,
        lifetime_in_secs: u64,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Enable or disable session resumption using session ticket.\n\n @param config The configuration object being updated\n @param enabled The configuration object being updated. Set to 1 to enable. Set to 0 to disable.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_session_tickets_onoff(
        config: *mut s2n_config,
        enabled: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Enable or disable session caching.\n\n @note Session caching will not be turned on unless all three session cache callbacks are set\n prior to calling this function.\n\n @param config The configuration object being updated\n @param enabled The configuration object being updated. Set to 1 to enable. Set to 0 to disable.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_session_cache_onoff(
        config: *mut s2n_config,
        enabled: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets how long a session ticket key will be in a state where it can be used for both encryption\n and decryption of tickets on the server side.\n\n @note The default value is 2 hours.\n @param config The configuration object being updated\n @param lifetime_in_secs The desired lifetime of decrypting and encrypting tickets in seconds\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_ticket_encrypt_decrypt_key_lifetime(
        config: *mut s2n_config,
        lifetime_in_secs: u64,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets how long a session ticket key will be in a state where it can used just for decryption of\n already assigned tickets on the server side. Once decrypted, the session will resume and the\n server will issue a new session ticket encrypted using a key in encrypt-decrypt state.\n\n @note The default value is 13 hours.\n @param config The configuration object being updated\n @param lifetime_in_secs The desired lifetime of decrypting and encrypting tickets in seconds\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_ticket_decrypt_key_lifetime(
        config: *mut s2n_config,
        lifetime_in_secs: u64,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Adds session ticket key on the server side. It would be ideal to add new keys after every\n (encrypt_decrypt_key_lifetime_in_nanos/2) nanos because this will allow for gradual and\n linear transition of a key from encrypt-decrypt state to decrypt-only state.\n\n @param config The configuration object being updated\n @param name Name of the session ticket key that should be randomly generated to avoid collisions\n @param name_len Length of session ticket key name\n @param key Key used to perform encryption/decryption of session ticket\n @param key_len Length of the session ticket key\n @param intro_time_in_seconds_from_epoch Time at which the session ticket key is introduced. If this is 0, then intro_time_in_seconds_from_epoch is set to now.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_add_ticket_crypto_key(
        config: *mut s2n_config,
        name: *const u8,
        name_len: u32,
        key: *mut u8,
        key_len: u32,
        intro_time_in_seconds_from_epoch: u64,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets user defined context on the `s2n_config` object.\n\n @param config The configuration object being updated\n @param ctx A pointer to the user defined ctx.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_ctx(config: *mut s2n_config, ctx: *mut ::libc::c_void) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the user defined context from the `s2n_config` object.\n The context is set by calling s2n_config_set_ctx()\n\n @param config The configuration object being accessed\n @param ctx A pointer to the user defined ctx.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_get_ctx(
        config: *mut s2n_config,
        ctx: *mut *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
pub mod s2n_mode {
    #[doc = " Used to declare connections as server or client type, respectively."]
    pub type Type = ::libc::c_uint;
    pub const SERVER: Type = 0;
    pub const CLIENT: Type = 1;
}
extern "C" {
    #[doc = " Creates a new connection object. Each s2n-tls SSL/TLS connection uses\n one of these objects. These connection objects can be operated on by up\n to two threads at a time, one sender and one receiver, but neither sending\n nor receiving are atomic, so if these objects are being called by multiple\n sender or receiver threads, you must perform your own locking to ensure\n that only one sender or receiver is active at a time.\n\n The `mode` parameters specifies if the caller is a server, or is a client.\n Connections objects are re-usable across many connections, and should be\n re-used (to avoid deallocating and allocating memory). You should wipe\n connections immediately after use.\n\n @param mode The desired connection type\n @returns A s2n_connection handle"]
    pub fn s2n_connection_new(mode: s2n_mode::Type) -> *mut s2n_connection;
}
extern "C" {
    #[doc = " Associates a configuration object with a connection.\n\n @param conn The connection object being associated\n @param config The configuration object being associated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_config(
        conn: *mut s2n_connection,
        config: *mut s2n_config,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets user defined context in `s2n_connection` object.\n\n @param conn The connection object being updated\n @param ctx A pointer to the user defined context\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_ctx(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets user defined context from a `s2n_connection` object.\n\n @param conn The connection object that contains the desired context"]
    pub fn s2n_connection_get_ctx(conn: *mut s2n_connection) -> *mut ::libc::c_void;
}
#[doc = " The callback function takes a s2n-tls connection as input, which receives the ClientHello\n and the context previously provided in `s2n_config_set_client_hello_cb`. The callback can\n access any ClientHello information from the connection and use the `s2n_connection_set_config`\n call to change the config of the connection."]
pub type s2n_client_hello_fn = ::core::option::Option<
    unsafe extern "C" fn(conn: *mut s2n_connection, ctx: *mut ::libc::c_void) -> ::libc::c_int,
>;
pub mod s2n_client_hello_cb_mode {
    #[doc = " Client Hello callback modes\n - `S2N_CLIENT_HELLO_CB_BLOCKING` (default):\n   - In this mode s2n-tls expects the callback to complete its work and return the appropriate response code before the handshake continues. If any of the connection properties were changed based on the server_name extension the callback must either return a value greater than 0 or invoke `s2n_connection_server_name_extension_used`, otherwise the callback returns 0 to continue the handshake.\n - `S2N_CLIENT_HELLO_CB_NONBLOCKING`:\n   - In non-blocking mode, s2n-tls expects the callback to not complete its work. If the callback returns a response code of 0, s2n-tls will return `S2N_FAILURE` with `S2N_ERR_T_BLOCKED` error type and `s2n_blocked_status` set to `S2N_BLOCKED_ON_APPLICATION_INPUT`. The handshake is paused and further calls to `s2n_negotiate` will continue to return the same error until `s2n_client_hello_cb_done` is invoked for the `s2n_connection` to resume the handshake. If any of the connection properties were changed on the basis of the server_name extension then `s2n_connection_server_name_extension_used` must be invoked before marking the callback done."]
    pub type Type = ::libc::c_uint;
    pub const BLOCKING: Type = 0;
    pub const NONBLOCKING: Type = 1;
}
extern "C" {
    #[doc = " Allows the caller to set a callback function that will be called after ClientHello was parsed.\n\n @param config The configuration object being updated\n @param client_hello_callback The client hello callback function\n @param ctx A pointer to a user defined context that the Client Hello callback will be invoked with.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_client_hello_cb(
        config: *mut s2n_config,
        client_hello_callback: s2n_client_hello_fn,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the callback execution mode.\n\n See s2n_client_hello_cb_mode for each mode's behavior.\n\n @param config The configuration object being updated\n @param cb_mode The desired callback mode\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_client_hello_cb_mode(
        config: *mut s2n_config,
        cb_mode: s2n_client_hello_cb_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Marks the non-blocking callback as complete. Can be invoked from within the callback when\n operating in non-blocking mode to continue the handshake.\n\n @param conn The connection object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_client_hello_cb_done(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Must be invoked if any of the connection properties were changed on the basis of the server_name\n extension. This must be invoked before marking the Client Hello callback done.\n\n @param conn The connection object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_server_name_extension_used(conn: *mut s2n_connection) -> ::libc::c_int;
}
#[doc = " Opaque client hello handle"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_client_hello {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Get the Client Hello from a s2n_connection.\n\n Earliest point during the handshake when this structure is available for use is in the\n client_hello_callback (see s2n_config_set_client_hello_cb()).\n\n @param conn The connection object containing the client hello\n @returns A handle to the s2n_client_hello structure holding the client hello message sent by the client during the handshake. NULL is returned if a Client Hello has not yet been received and parsed."]
    pub fn s2n_connection_get_client_hello(conn: *mut s2n_connection) -> *mut s2n_client_hello;
}
extern "C" {
    #[doc = " Function to determine the size of the raw Client Hello buffer.\n\n Can be used to determine the necessary size of the `out` buffer for\n s2n_client_hello_get_raw_message()\n\n @param ch The Client Hello handle\n @returns The size of the ClientHello message received by the server"]
    pub fn s2n_client_hello_get_raw_message_length(ch: *mut s2n_client_hello) -> isize;
}
extern "C" {
    #[doc = " Copies `max_length` bytes of the ClientHello message into the `out` buffer.\n The ClientHello instrumented using this function will have the Random bytes\n zero-ed out.\n\n Note: SSLv2 ClientHello messages follow a different structure than more modern\n ClientHello messages. See [RFC5246](https://tools.ietf.org/html/rfc5246#appendix-E.2).\n In addition, due to how s2n-tls parses SSLv2 ClientHellos, the raw message is\n missing the first three bytes (the msg_type and version) and instead begins with\n the cipher_specs. To determine whether a ClientHello is an SSLv2 ClientHello,\n you will need to use s2n_connection_get_client_hello_version(). To get the\n protocol version advertised in the SSLv2 ClientHello (which may be higher\n than SSLv2), you will need to use s2n_connection_get_client_protocol_version().\n\n @param ch The Client Hello handle\n @param out The destination buffer for the raw Client Hello\n @param max_length The size of out in bytes\n @returns The number of copied bytes"]
    pub fn s2n_client_hello_get_raw_message(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    #[doc = " Function to determine the size of the Client Hello cipher suites.\n This can be used to allocate the `out` buffer for s2n_client_hello_get_cipher_suites().\n\n @param ch The Client Hello handle\n @returns the number of bytes the cipher_suites takes on the ClientHello message received by the server"]
    pub fn s2n_client_hello_get_cipher_suites_length(ch: *mut s2n_client_hello) -> isize;
}
extern "C" {
    #[doc = " Copies into the `out` buffer `max_length` bytes of the cipher_suites on the ClientHello.\n\n Note: SSLv2 ClientHello cipher suites follow a different structure than modern\n ClientHello messages. See [RFC5246](https://tools.ietf.org/html/rfc5246#appendix-E.2).\n To determine whether a ClientHello is an SSLv2 ClientHello,\n you will need to use s2n_connection_get_client_hello_version().\n\n @param ch The Client Hello handle\n @param out The destination buffer for the raw Client Hello cipher suites\n @param max_length The size of out in bytes\n @returns The number of copied bytes"]
    pub fn s2n_client_hello_get_cipher_suites(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    #[doc = " Function to determine the size of the Client Hello extensions.\n This can be used to allocate the `out` buffer for s2n_client_hello_get_extensions().\n\n @param ch The Client Hello handle\n @returns the number of bytes the extensions take in the ClientHello message received by the server"]
    pub fn s2n_client_hello_get_extensions_length(ch: *mut s2n_client_hello) -> isize;
}
extern "C" {
    #[doc = " Copies into the `out` buffer `max_length` bytes of the extensions in the ClientHello.\n\n @param ch The Client Hello handle\n @param out The destination buffer for the raw Client Hello extensions\n @param max_length The size of out in bytes\n @returns The number of copied bytes"]
    pub fn s2n_client_hello_get_extensions(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    #[doc = " Query the ClientHello message received by the server. Use this function to allocate the `out` buffer for\n other client hello extension functions.\n\n @param ch A pointer to the Client Hello\n @param extension_type Indicates the desired extension\n @returns The number of bytes the given extension type takes"]
    pub fn s2n_client_hello_get_extension_length(
        ch: *mut s2n_client_hello,
        extension_type: s2n_tls_extension_type::Type,
    ) -> isize;
}
extern "C" {
    #[doc = " Copies into the `out` buffer `max_length` bytes of a given extension type on the ClientHello\n\n `ch` is a pointer to the `s2n_client_hello` of the `s2n_connection` which can be obtained using s2n_connection_get_client_hello().\n\n @param ch A pointer to the Client Hello\n @param extension_type Indicates the desired extension\n @param out A pointer to the buffer that s2n will write the client session id to. This buffer MUST be the size of `max_length`\n @param max_length The size of `out`.\n @returns The number of copied bytes"]
    pub fn s2n_client_hello_get_extension_by_id(
        ch: *mut s2n_client_hello,
        extension_type: s2n_tls_extension_type::Type,
        out: *mut u8,
        max_length: u32,
    ) -> isize;
}
extern "C" {
    #[doc = " Used to check if a particular extension exists in the client hello.\n\n `ch` is a pointer to the `s2n_client_hello` of the `s2n_connection` which can be obtained using s2n_connection_get_client_hello().\n\n @param ch A pointer to the client hello object\n @param extension_iana The iana value of the extension\n @param exists A pointer that will be set to whether or not the extension exists"]
    pub fn s2n_client_hello_has_extension(
        ch: *mut s2n_client_hello,
        extension_iana: u16,
        exists: *mut bool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the the ClientHello session id length in bytes\n\n `ch` is a pointer to the `s2n_client_hello` of the `s2n_connection` which can be obtained using s2n_connection_get_client_hello().\n\n @param ch A pointer to the Client Hello\n @param out_length An out pointer. s2n will set it's value to the size of the session_id in bytes.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_client_hello_get_session_id_length(
        ch: *mut s2n_client_hello,
        out_length: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Copies up to `max_length` bytes of the ClientHello session_id into the `out` buffer and stores the number of copied bytes in `out_length`.\n\n Retrieve the session id as sent by the client in the ClientHello message. The session id on the `s2n_connection` may change later\n when the server sends the ServerHello; see `s2n_connection_get_session_id` for how to get the final session id used for future session resumption.\n\n Use s2n_client_hello_get_session_id_length() to get the the ClientHello session id length in bytes. `ch` is a pointer to the `s2n_client_hello`\n of the `s2n_connection` which can be obtained using s2n_connection_get_client_hello().\n\n @param ch A pointer to the Client Hello\n @param out A pointer to the buffer that s2n will write the client session id to. This buffer MUST be the size of `max_length`\n @param out_length An out pointer. s2n will set it's value to the size of the session_id in bytes.\n @param max_length The size of `out`.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_client_hello_get_session_id(
        ch: *mut s2n_client_hello,
        out: *mut u8,
        out_length: *mut u32,
        max_length: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Retrieves the supported groups received from the client in the supported groups extension.\n\n IANA values for each of the received supported groups are written to the provided `groups`\n array, and `groups_count` is set to the number of received supported groups.\n\n `groups_count_max` should be set to the maximum capacity of the `groups` array. If\n `groups_count_max` is less than the number of received supported groups, this function will\n error. To determine how large `groups` should be in advance, use\n `s2n_client_hello_get_extension_length()` with the S2N_EXTENSION_SUPPORTED_GROUPS extension\n type, and divide the value by 2.\n\n If no supported groups extension was received from the peer, or the received supported groups\n extension is malformed, this function will error.\n\n @param ch A pointer to the ClientHello. Can be retrieved from a connection via\n `s2n_connection_get_client_hello()`.\n @param groups The array to populate with the received supported groups.\n @param groups_count_max The maximum number of supported groups that can fit in the `groups` array.\n @param groups_count Returns the number of received supported groups.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure."]
    pub fn s2n_client_hello_get_supported_groups(
        ch: *mut s2n_client_hello,
        groups: *mut u16,
        groups_count_max: u16,
        groups_count: *mut u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the file descriptor for a s2n connection.\n\n @warning If the read end of the pipe is closed unexpectedly, writing to the pipe will raise a SIGPIPE signal.\n **s2n-tls does NOT handle SIGPIPE.** A SIGPIPE signal will cause the process to terminate unless it is handled\n or ignored by the application.\n @note This file-descriptor should be active and connected\n @param conn A pointer to the s2n connection\n @param fd The new file descriptor\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_fd(conn: *mut s2n_connection, fd: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the file descriptor for the read channel of an s2n connection.\n\n @warning If the read end of the pipe is closed unexpectedly, writing to the pipe will raise a SIGPIPE signal.\n **s2n-tls does NOT handle SIGPIPE.** A SIGPIPE signal will cause the process to terminate unless it is handled\n or ignored by the application.\n @note This file-descriptor should be active and connected\n @param conn A pointer to the s2n connection\n @param readfd The new read file descriptor\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_read_fd(
        conn: *mut s2n_connection,
        readfd: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the assigned file descriptor for the write channel of an s2n connection.\n\n @note This file-descriptor should be active and connected\n @param conn A pointer to the s2n connection\n @param writefd The new write file descriptor\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_write_fd(
        conn: *mut s2n_connection,
        writefd: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the assigned file descriptor for the read channel of an s2n connection.\n\n @param conn A pointer to the s2n connection\n @param readfd pointer to place the used file descriptor.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_get_read_fd(
        conn: *mut s2n_connection,
        readfd: *mut ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the assigned file descriptor for the write channel of an s2n connection.\n\n @param conn A pointer to the s2n connection\n @param writefd pointer to place the used file descriptor.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_get_write_fd(
        conn: *mut s2n_connection,
        writefd: *mut ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Indicates to s2n that the connection is using corked IO.\n\n @warning This API should only be used when using managed send IO.\n\n @param conn The connection object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_use_corked_io(conn: *mut s2n_connection) -> ::libc::c_int;
}
#[doc = " Function pointer for a user provided send callback."]
pub type s2n_recv_fn = ::core::option::Option<
    unsafe extern "C" fn(io_context: *mut ::libc::c_void, buf: *mut u8, len: u32) -> ::libc::c_int,
>;
#[doc = " Function pointer for a user provided send callback."]
pub type s2n_send_fn = ::core::option::Option<
    unsafe extern "C" fn(
        io_context: *mut ::libc::c_void,
        buf: *const u8,
        len: u32,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Set a context containing anything needed in the recv callback function (for example,\n a file descriptor), the buffer holding data to be sent or received, and the length of the buffer.\n\n @note The `io_context` passed to the callbacks may be set separately using `s2n_connection_set_recv_ctx` and `s2n_connection_set_send_ctx`.\n\n @param conn The connection object being updated\n @param ctx A user provided context that the callback will be invoked with\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_recv_ctx(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Set a context containing anything needed in the send callback function (for example,\n a file descriptor), the buffer holding data to be sent or received, and the length of the buffer.\n\n @note The `io_context` passed to the callbacks may be set separately using `s2n_connection_set_recv_ctx` and `s2n_connection_set_send_ctx`.\n\n @param conn The connection object being updated\n @param ctx A user provided context that the callback will be invoked with\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_send_ctx(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Configure a connection to use a recv callback to receive data.\n\n @note This callback may be blocking or nonblocking.\n @note The callback may receive less than the requested length. The function should return the number\n of bytes received, or set errno and return an error code < 0.\n\n @param conn The connection object being updated\n @param recv A recv callback function pointer\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_recv_cb(
        conn: *mut s2n_connection,
        recv: s2n_recv_fn,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Configure a connection to use a send callback to send data.\n\n @note This callback may be blocking or nonblocking.\n @note The callback may send less than the requested length. The function should return the\n number of bytes sent or set errno and return an error code < 0.\n\n @param conn The connection object being updated\n @param send A send callback function pointer\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_send_cb(
        conn: *mut s2n_connection,
        send: s2n_send_fn,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Change the behavior of s2n-tls when sending data to prefer high throughput.\n\n Connections preferring throughput will use\n large record sizes that minimize overhead.\n\n @param conn The connection object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_prefer_throughput(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Change the behavior of s2n-tls when sending data to prefer low latency.\n\n Connections preferring low latency will be encrypted\n using small record sizes that can be decrypted sooner by the recipient.\n\n @param conn The connection object being updated\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_prefer_low_latency(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Configure the connection to free IO buffers when they are not currently in use.\n\n This configuration can be used to minimize connection memory footprint size, at the cost\n of more calls to alloc and free. Some of these costs can be mitigated by configuring s2n-tls\n to use an allocator that includes thread-local caches or lock-free allocation patterns.\n\n @param conn The connection object being update\n @param enabled Set to `true` if dynamic buffers are enabled; `false` if disabled\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_dynamic_buffers(
        conn: *mut s2n_connection,
        enabled: bool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Changes the behavior of s2n-tls when sending data to initially prefer records\n small enough to fit in single ethernet frames.\n\n When dynamic record sizing is active, the connection sends records small enough\n to fit in a single standard 1500 byte ethernet frame. Otherwise, the connection\n chooses record sizes according to the configured maximum fragment length.\n\n Dynamic record sizing is active for the first resize_threshold bytes of a connection,\n and is reactivated whenever timeout_threshold seconds pass without sending data.\n\n @param conn The connection object being updated\n @param resize_threshold The number of bytes to send before changing the record size. Maximum 8MiB.\n @param timeout_threshold Reset record size back to a single segment after threshold seconds of inactivity\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_dynamic_record_threshold(
        conn: *mut s2n_connection,
        resize_threshold: u32,
        timeout_threshold: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the callback to use for verifying that a hostname from an X.509 certificate is trusted.\n\n The default behavior is to require that the hostname match the server name set with s2n_set_server_name(). This will\n likely lead to all client certificates being rejected, so the callback will need to be overriden when using client authentication.\n\n If a single callback for different connections using the same config is desired, see s2n_config_set_verify_host_callback().\n\n @param conn A pointer to a s2n_connection object\n @param host_fn A pointer to a callback function that s2n will invoke in order to verify the hostname of an X.509 certificate\n @param data Opaque pointer to data that the verify host function will be invoked with\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_verify_host_callback(
        conn: *mut s2n_connection,
        host_fn: s2n_verify_host_fn,
        data: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
pub mod s2n_blinding {
    #[doc = " Used to opt-out of s2n-tls's built-in blinding. Blinding is a\n mitigation against timing side-channels which in some cases can leak information\n about encrypted data. By default s2n-tls will cause a thread to sleep between 10 and\n 30 seconds whenever tampering is detected.\n\n Setting the S2N_SELF_SERVICE_BLINDING option with s2n_connection_set_blinding()\n turns off this behavior. This is useful for applications that are handling many connections\n in a single thread. In that case, if s2n_recv() or s2n_negotiate() return an error,\n self-service applications should call s2n_connection_get_delay() and pause\n activity on the connection  for the specified number of nanoseconds before calling\n close() or shutdown()."]
    pub type Type = ::libc::c_uint;
    pub const BUILT_IN_BLINDING: Type = 0;
    pub const SELF_SERVICE_BLINDING: Type = 1;
}
extern "C" {
    #[doc = " Used to configure s2n-tls to either use built-in blinding (set blinding to S2N_BUILT_IN_BLINDING) or\n self-service blinding (set blinding to S2N_SELF_SERVICE_BLINDING).\n\n @param conn The connection object being updated\n @param blinding The desired blinding mode for the connection\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_blinding(
        conn: *mut s2n_connection,
        blinding: s2n_blinding::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Query the connection object for the configured blinding delay.\n @param conn The connection object being updated\n @returns the number of nanoseconds an application using self-service blinding should pause before calling close() or shutdown()."]
    pub fn s2n_connection_get_delay(conn: *mut s2n_connection) -> u64;
}
extern "C" {
    #[doc = " Sets the cipher preference override for the s2n_connection. Calling this function is not necessary\n unless you want to set the cipher preferences on the connection to something different than what is in the s2n_config.\n\n @param conn The connection object being updated\n @param version The human readable string representation of the security policy version.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_cipher_preferences(
        conn: *mut s2n_connection,
        version: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Appends the provided application protocol to the preference list\n\n The data provided in `protocol` parameter will be copied into an internal buffer\n\n @param conn The connection object being updated\n @param protocol A pointer to a slice of bytes\n @param protocol_len The length of bytes that should be read from `protocol`. Note: this value cannot be 0, otherwise an error will be returned.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_append_protocol_preference(
        conn: *mut s2n_connection,
        protocol: *const u8,
        protocol_len: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the protocol preference override for the s2n_connection. Calling this function is not necessary unless you want\n to set the protocol preferences on the connection to something different than what is in the s2n_config.\n\n @param conn The connection object being updated\n @param protocols A pointer to an array of protocol strings\n @param protocol_count The number of protocols contained in protocols\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_protocol_preferences(
        conn: *mut s2n_connection,
        protocols: *const *const ::libc::c_char,
        protocol_count: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the server name for the connection.\n\n The provided server name will be sent by the client to the server in the\n server_name ClientHello extension. It may be desirable for clients\n to provide this information to facilitate secure connections to\n servers that host multiple 'virtual' servers at a single underlying\n network address.\n\n s2n-tls does not place any restrictions on the provided server name. However,\n other TLS implementations might. Specifically, the TLS specification for the\n server_name extension requires that it be an ASCII-encoded DNS name without a\n trailing dot, and explicitly forbids literal IPv4 or IPv6 addresses.\n\n @param conn The connection object being queried\n @param server_name A pointer to a string containing the desired server name\n @warning `server_name` must be a NULL terminated string.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_set_server_name(
        conn: *mut s2n_connection,
        server_name: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Query the connection for the selected server name.\n\n This can be used by a server to determine which server name the client is using. This function returns the first ServerName entry\n in the ServerNameList sent by the client. Subsequent entries are not returned.\n\n @param conn The connection object being queried\n @returns The server name associated with a connection, or NULL if none is found."]
    pub fn s2n_get_server_name(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Query the connection for the selected application protocol.\n\n @param conn The connection object being queried\n @returns The negotiated application protocol for a `s2n_connection`.  In the event of no protocol being negotiated, NULL is returned."]
    pub fn s2n_get_application_protocol(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Query the connection for a buffer containing the OCSP response.\n\n @param conn The connection object being queried\n @param length A pointer that is set to the certificate transparency response buffer's size\n @returns A pointer to the OCSP response sent by a server during the handshake.  If no status response is received, NULL is returned."]
    pub fn s2n_connection_get_ocsp_response(
        conn: *mut s2n_connection,
        length: *mut u32,
    ) -> *const u8;
}
extern "C" {
    #[doc = " Query the connection for a buffer containing the Certificate Transparency response.\n\n @param conn The connection object being queried\n @param length A pointer that is set to the certificate transparency response buffer's size\n @returns A pointer to the certificate transparency response buffer."]
    pub fn s2n_connection_get_sct_list(conn: *mut s2n_connection, length: *mut u32) -> *const u8;
}
pub mod s2n_blocked_status {
    #[doc = " Used in non-blocking mode to indicate in which direction s2n-tls became blocked on I/O before it\n returned control to the caller. This allows an application to avoid retrying s2n-tls operations\n until I/O is possible in that direction."]
    pub type Type = ::libc::c_uint;
    pub const NOT_BLOCKED: Type = 0;
    pub const BLOCKED_ON_READ: Type = 1;
    pub const BLOCKED_ON_WRITE: Type = 2;
    pub const BLOCKED_ON_APPLICATION_INPUT: Type = 3;
    pub const BLOCKED_ON_EARLY_DATA: Type = 4;
}
extern "C" {
    #[doc = " Performs the initial \"handshake\" phase of a TLS connection and must be called before any s2n_recv() or s2n_send() calls.\n\n @note When using client authentication with TLS1.3, s2n_negotiate() will report a successful\n handshake to clients before the server validates the client certificate. If the server then\n rejects the client certificate, the client may later receive an alert while calling s2n_recv,\n potentially after already having sent application data with s2n_send.\n\n See the following example for guidance on calling `s2n_negotiate()`:\n https://github.com/aws/s2n-tls/blob/main/docs/examples/s2n_negotiate.c\n\n @param conn A pointer to the s2n_connection object\n @param blocked A pointer which will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns S2N_SUCCESS if the handshake completed. S2N_FAILURE if the handshake encountered an error or is blocked."]
    pub fn s2n_negotiate(
        conn: *mut s2n_connection,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Writes and encrypts `size` of `buf` data to the associated connection. s2n_send() will return the number of bytes\n written, and may indicate a partial write.\n\n @note Partial writes are possible not just for non-blocking I/O, but also for connections aborted while active.\n @note Unlike OpenSSL, repeated calls to s2n_send() should not duplicate the original parameters, but should\n update `buf` and `size` per the indication of size written.\n\n See the following example for guidance on calling `s2n_send()`:\n https://github.com/aws/s2n-tls/blob/main/docs/examples/s2n_send.c\n\n @param conn A pointer to the s2n_connection object\n @param buf A pointer to a buffer that s2n will write data from\n @param size The size of buf\n @param blocked A pointer which will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns The number of bytes written, and may indicate a partial write"]
    pub fn s2n_send(
        conn: *mut s2n_connection,
        buf: *const ::libc::c_void,
        size: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    #[doc = " Works in the same way as s2n_sendv_with_offset() but with the `offs` parameter implicitly assumed to be 0.\n Therefore in the partial write case, the caller would have to make sure that the `bufs` and `count` fields are modified in a way that takes\n the partial writes into account.\n\n @param conn A pointer to the s2n_connection object\n @param bufs A pointer to a vector of buffers that s2n will write data from.\n @param count The number of buffers in `bufs`\n @param blocked A pointer which will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns The number of bytes written, and may indicate a partial write."]
    pub fn s2n_sendv(
        conn: *mut s2n_connection,
        bufs: *const iovec,
        count: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    #[doc = " Works in the same way as s2n_send() except that it accepts vectorized buffers. Will return the number of bytes written, and may indicate a partial write. Partial writes are possible not just for non-blocking I/O, but also for connections aborted while active.\n\n @note Partial writes are possible not just for non-blocking I/O, but also for connections aborted while active.\n\n @note Unlike OpenSSL, repeated calls to s2n_sendv_with_offset() should not duplicate the original parameters, but should update `bufs` and `count` per the indication of size written.\n\n See the following example for guidance on calling `s2n_sendv_with_offset()`:\n https://github.com/aws/s2n-tls/blob/main/docs/examples/s2n_send.c\n\n @param conn A pointer to the s2n_connection object\n @param bufs A pointer to a vector of buffers that s2n will write data from.\n @param count The number of buffers in `bufs`\n @param offs The write cursor offset. This should be updated as data is written. See the example code.\n @param blocked A pointer which will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns The number of bytes written, and may indicate a partial write."]
    pub fn s2n_sendv_with_offset(
        conn: *mut s2n_connection,
        bufs: *const iovec,
        count: isize,
        offs: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    #[doc = " Decrypts and reads **size* to `buf` data from the associated\n connection.\n\n @note Unlike OpenSSL, repeated calls to `s2n_recv` should not duplicate the original parameters, but should update `buf` and `size` per the indication of size read.\n\n See the following example for guidance on calling `s2n_recv()`:\n https://github.com/aws/s2n-tls/blob/main/docs/examples/s2n_recv.c\n\n @param conn A pointer to the s2n_connection object\n @param buf A pointer to a buffer that s2n will place read data into.\n @param size Size of `buf`\n @param blocked A pointer which will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns number of bytes read. 0 if the connection was shutdown by peer."]
    pub fn s2n_recv(
        conn: *mut s2n_connection,
        buf: *mut ::libc::c_void,
        size: isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> isize;
}
extern "C" {
    #[doc = " Allows users of s2n-tls to peek inside the data buffer of an s2n-tls connection to see if there more data to be read without actually reading it.\n\n This is useful when using select() on the underlying s2n-tls file descriptor with a message based application layer protocol. As a single call\n to s2n_recv may read all data off the underlying file descriptor, select() will be unable to tell you there if there is more application data\n ready for processing already loaded into the s2n-tls buffer.\n\n @note can then be used to determine if s2n_recv() needs to be called before more data comes in on the raw fd\n @param conn A pointer to the s2n_connection object\n @returns The number of bytes that can be read from the connection"]
    pub fn s2n_peek(conn: *mut s2n_connection) -> u32;
}
extern "C" {
    #[doc = " Wipes and releases buffers and memory allocated during the TLS handshake.\n\n @note This function should be called after the handshake is successfully negotiated and logging or recording of handshake data is complete.\n\n @param conn A pointer to the s2n_connection object\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_free_handshake(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Wipes and free the `in` and `out` buffers associated with a connection.\n\n @note This function may be called when a connection is\n in keep-alive or idle state to reduce memory overhead of long lived connections.\n\n @param conn A pointer to the s2n_connection object\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_release_buffers(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Wipes an existing connection and allows it to be reused. Erases all data associated with a connection including\n pending reads.\n\n @note This function should be called after all I/O is completed and s2n_shutdown has been called.\n @note Reusing the same connection handle(s) is more performant than repeatedly calling s2n_connection_new() and s2n_connection_free().\n\n @param conn A pointer to the s2n_connection object\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_wipe(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Frees the memory associated with an s2n_connection\n handle. The handle is considered invalid after `s2n_connection_free` is used.\n s2n_connection_wipe() does not need to be called prior to this function. `s2n_connection_free` performs its own wipe\n of sensitive data.\n\n @param conn A pointer to the s2n_connection object\n @returns 0 on success. -1 on failure"]
    pub fn s2n_connection_free(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Attempts a closure at the TLS layer. Does not close the underlying transport. This call may block in either direction.\n\n Unlike other TLS implementations, `s2n_shutdown` attempts a graceful shutdown by default. It will not return with success unless a close_notify alert is successfully\n sent and received. As a result, `s2n_shutdown` may fail when interacting with a non-conformant TLS implementation.\n\n Once `s2n_shutdown` is complete:\n * The s2n_connection handle cannot be used for reading for writing.\n * The underlying transport can be closed. Most likely via `shutdown()` or `close()`.\n * The s2n_connection handle can be freed via s2n_connection_free() or reused via s2n_connection_wipe()\n\n @param conn A pointer to the s2n_connection object\n @param blocked A pointer which will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_shutdown(
        conn: *mut s2n_connection,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Attempts to close the write side of the TLS connection.\n\n TLS1.3 supports closing the write side of a TLS connection while leaving the read\n side unaffected. This feature is usually referred to as \"half-close\". We send\n a close_notify alert, but do not wait for the peer to respond.\n\n Like `s2n_shutdown()`, this method does not affect the underlying transport.\n\n `s2n_shutdown_send()` may still be called for earlier TLS versions, but most\n TLS implementations will react by immediately discarding any pending writes and\n closing the connection.\n\n Once `s2n_shutdown_send()` is complete:\n * The s2n_connection handle CANNOT be used for writing.\n * The s2n_connection handle CAN be used for reading.\n * The write side of the underlying transport can be closed. Most likely via `shutdown()`.\n\n The application should still call `s2n_shutdown()` or wait for `s2n_recv()` to\n return 0 to indicate end-of-data before cleaning up the connection or closing\n the read side of the underlying transport.\n\n @param conn A pointer to the s2n_connection object\n @param blocked A pointer which will be set to the blocked status if an `S2N_ERR_T_BLOCKED` error is returned.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_shutdown_send(
        conn: *mut s2n_connection,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
pub mod s2n_cert_auth_type {
    #[doc = " Used to declare what type of client certificate authentication to use.\n\n Currently the default for s2n-tls is for neither the server side or the client side to use Client (aka Mutual) authentication."]
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const REQUIRED: Type = 1;
    pub const OPTIONAL: Type = 2;
}
extern "C" {
    #[doc = " Gets Client Certificate authentication method the s2n_config object is using.\n\n @param config A pointer to a s2n_config object\n @param client_auth_type A pointer to a client auth policy. This will be updated to the s2n_config value.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_get_client_auth_type(
        config: *mut s2n_config,
        client_auth_type: *mut s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets whether or not a Client Certificate should be required to complete the TLS Connection.\n\n If this is set to `S2N_CERT_AUTH_OPTIONAL` the server will request a client certificate but allow the client to not provide one.\n Rejecting a client certificate when using `S2N_CERT_AUTH_OPTIONAL` will terminate the handshake.\n\n @param config A pointer to a s2n_config object\n @param client_auth_type The client auth policy for the connection\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_client_auth_type(
        config: *mut s2n_config,
        client_auth_type: s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets Client Certificate authentication method the s2n_connection object is using.\n\n @param conn A pointer to the s2n_connection object\n @param client_auth_type A pointer to a client auth policy. This will be updated to the s2n_connection value.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_get_client_auth_type(
        conn: *mut s2n_connection,
        client_auth_type: *mut s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets whether or not a Client Certificate should be required to complete the TLS Connection.\n\n If this is set to `S2N_CERT_AUTH_OPTIONAL` the server will request a client certificate but allow the client to not provide one.\n Rejecting a client certificate when using `S2N_CERT_AUTH_OPTIONAL` will terminate the handshake.\n\n @param conn A pointer to the s2n_connection object\n @param client_auth_type The client auth policy for the connection\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_client_auth_type(
        conn: *mut s2n_connection,
        client_auth_type: s2n_cert_auth_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the raw certificate chain received from the client.\n\n The retrieved certificate chain has the format described by the TLS 1.2 RFC:\n https://datatracker.ietf.org/doc/html/rfc5246#section-7.4.2. Each certificate is a DER-encoded ASN.1 X.509,\n prepended by a 3 byte network-endian length value. Note that this format is used regardless of the connection's\n protocol version.\n\n @warning The buffer pointed to by `cert_chain_out` shares its lifetime with the s2n_connection object.\n\n @param conn A pointer to the s2n_connection object\n @param cert_chain_out A pointer that's set to the client certificate chain.\n @param cert_chain_len A pointer that's set to the size of the `cert_chain_out` buffer.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_get_client_cert_chain(
        conn: *mut s2n_connection,
        der_cert_chain_out: *mut *mut u8,
        cert_chain_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the initial number of session tickets to send after a >=TLS1.3 handshake. The default value is one ticket.\n\n @param config A pointer to the config object.\n @param num The number of session tickets that will be sent.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_config_set_initial_ticket_count(config: *mut s2n_config, num: u8) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Increases the number of session tickets to send after a >=TLS1.3 handshake.\n\n @param conn A pointer to the connection object.\n @param num The number of additional session tickets to send.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_add_new_tickets_to_send(
        conn: *mut s2n_connection,
        num: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the number of session tickets issued by the server.\n\n In TLS1.3, this number can be up to the limit configured by s2n_config_set_initial_ticket_count\n and s2n_connection_add_new_tickets_to_send. In earlier versions of TLS, this number will be either 0 or 1.\n\n This method only works for server connections.\n\n @param conn A pointer to the connection object.\n @param num The number of additional session tickets sent.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_get_tickets_sent(
        conn: *mut s2n_connection,
        num: *mut u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the keying material lifetime for >=TLS1.3 session tickets so that one session doesn't get re-used ad infinitum.\n The default value is one week.\n\n @param conn A pointer to the connection object.\n @param lifetime_in_secs Lifetime of keying material in seconds.\n @returns S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_connection_set_server_keying_material_lifetime(
        conn: *mut s2n_connection,
        lifetime_in_secs: u32,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_session_ticket {
    _unused: [u8; 0],
}
#[doc = " Callback function for receiving a session ticket.\n\n This function will be called each time a session ticket is received, which may be multiple times for TLS1.3.\n\n # Safety\n\n `ctx` is a void pointer and the caller is responsible for ensuring it is cast to the correct type.\n `ticket` is valid only within the scope of this callback.\n\n @param conn A pointer to the connection object.\n @param ctx Context for the session ticket callback function.\n @param ticket Pointer to the received session ticket object."]
pub type s2n_session_ticket_fn = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        ctx: *mut ::libc::c_void,
        ticket: *mut s2n_session_ticket,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets a session ticket callback to be called when a client receives a new session ticket.\n\n # Safety\n\n `callback` MUST cast `ctx` into the same type of pointer that was originally created.\n `ctx` MUST be valid for the lifetime of the config, or until a different context is set.\n\n @param config A pointer to the config object.\n @param callback The function that should be called when the callback is triggered.\n @param ctx The context to be passed when the callback is called."]
    pub fn s2n_config_set_session_ticket_cb(
        config: *mut s2n_config,
        callback: s2n_session_ticket_fn,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the length of the session ticket from a session ticket object.\n\n @param ticket Pointer to the session ticket object.\n @param data_len Pointer to be set to the length of the session ticket on success."]
    pub fn s2n_session_ticket_get_data_len(
        ticket: *mut s2n_session_ticket,
        data_len: *mut usize,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the session ticket data from a session ticket object.\n\n # Safety\n The entire session ticket will be copied into `data` on success. Therefore, `data` MUST have enough\n memory to store the session ticket data.\n\n @param ticket Pointer to the session ticket object.\n @param max_data_len Maximum length of data that can be written to the 'data' pointer.\n @param data Pointer to where the session ticket data will be stored."]
    pub fn s2n_session_ticket_get_data(
        ticket: *mut s2n_session_ticket,
        max_data_len: usize,
        data: *mut u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the lifetime in seconds of the session ticket from a session ticket object.\n\n @param ticket Pointer to the session ticket object.\n @param session_lifetime Pointer to a variable where the lifetime of the session ticket will be stored."]
    pub fn s2n_session_ticket_get_lifetime(
        ticket: *mut s2n_session_ticket,
        session_lifetime: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " De-serializes the session state and updates the connection accordingly.\n\n If this method fails, the connection should not be affected: calling s2n_negotiate\n with the connection should simply result in a full handshake.\n\n @param conn A pointer to the s2n_connection object\n @param session A pointer to a buffer of size `length`\n @param length The size of the `session` buffer\n\n @returns The number of copied bytes"]
    pub fn s2n_connection_set_session(
        conn: *mut s2n_connection,
        session: *const u8,
        length: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Serializes the session state from connection and copies into the `session` buffer and returns the number of copied bytes\n\n @note This function is not recommended for > TLS 1.2 because in TLS1.3\n servers can send multiple session tickets and this function will only\n return the most recently received ticket.\n\n @param conn A pointer to the s2n_connection object\n @param session A pointer to a buffer of size `max_length`\n @param max_length The size of the `session` buffer\n\n @returns The number of copied bytes"]
    pub fn s2n_connection_get_session(
        conn: *mut s2n_connection,
        session: *mut u8,
        max_length: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Retrieves a hint from the server indicating how long this ticket's lifetime is.\n\n @note This function is not recommended for > TLS 1.2 because in TLS1.3\n servers can send multiple session tickets and this function will only\n return the most recently received ticket lifetime hint.\n\n @param conn A pointer to the s2n_connection object\n\n @returns The session ticket lifetime hint in seconds from the server or -1 when session ticket was not used for resumption."]
    pub fn s2n_connection_get_session_ticket_lifetime_hint(
        conn: *mut s2n_connection,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Use this to query the serialized session state size before copying it into a buffer.\n\n @param conn A pointer to the s2n_connection object\n\n @returns number of bytes needed to store serialized session state"]
    pub fn s2n_connection_get_session_length(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the latest session id's length from the connection.\n\n Use this to query the session id size before copying it into a buffer.\n\n @param conn A pointer to the s2n_connection object\n\n @returns The latest session id length from the connection. Session id length will be 0 for TLS versions >= TLS1.3 as stateful session resumption has not yet been implemented in TLS1.3."]
    pub fn s2n_connection_get_session_id_length(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the latest session id from the connection, copies it into the `session_id` buffer, and returns the number of copied bytes.\n\n The session id may change between s2n receiving the ClientHello and sending the ServerHello, but this function will always describe the latest session id.\n\n See s2n_client_hello_get_session_id() to get the session id as it was sent by the client in the ClientHello message.\n\n @param conn A pointer to the s2n_connection object\n @param session_id A pointer to a buffer of size `max_length`\n @param max_length The size of the `session_id` buffer\n\n @returns The number of copied bytes."]
    pub fn s2n_connection_get_session_id(
        conn: *mut s2n_connection,
        session_id: *mut u8,
        max_length: usize,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Check if the connection was resumed from an earlier handshake.\n\n @param conn A pointer to the s2n_connection object\n\n @returns returns 1 if the handshake was abbreviated, otherwise returns 0"]
    pub fn s2n_connection_is_session_resumed(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Check if the connection is OCSP stapled.\n\n @param conn A pointer to the s2n_connection object\n\n @returns 1 if OCSP response was sent (if connection is in S2N_SERVER mode) or received (if connection is in S2N_CLIENT mode) during handshake, otherwise it returns 0."]
    pub fn s2n_connection_is_ocsp_stapled(conn: *mut s2n_connection) -> ::libc::c_int;
}
pub mod s2n_tls_signature_algorithm {
    #[doc = " TLS Signature Algorithms - RFC 5246 7.4.1.4.1\n https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-16"]
    pub type Type = ::libc::c_uint;
    pub const ANONYMOUS: Type = 0;
    pub const RSA: Type = 1;
    pub const ECDSA: Type = 3;
    pub const RSA_PSS_RSAE: Type = 224;
    pub const RSA_PSS_PSS: Type = 225;
}
pub mod s2n_tls_hash_algorithm {
    #[doc = " TLS Hash Algorithms - https://tools.ietf.org/html/rfc5246#section-7.4.1.4.1\n https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-18"]
    pub type Type = ::libc::c_uint;
    pub const NONE: Type = 0;
    pub const MD5: Type = 1;
    pub const SHA1: Type = 2;
    pub const SHA224: Type = 3;
    pub const SHA256: Type = 4;
    pub const SHA384: Type = 5;
    pub const SHA512: Type = 6;
    pub const MD5_SHA1: Type = 224;
}
extern "C" {
    #[doc = " Get the connection's selected signature algorithm.\n\n @param conn A pointer to the s2n_connection object\n @param chosen_alg A pointer to a s2n_tls_signature_algorithm object. This is an output parameter.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE if bad parameters are received."]
    pub fn s2n_connection_get_selected_signature_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_signature_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the connection's selected digest algorithm.\n\n @param conn A pointer to the s2n_connection object\n @param chosen_alg A pointer to a s2n_tls_hash_algorithm object. This is an output parameter.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE if bad parameters are received."]
    pub fn s2n_connection_get_selected_digest_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_hash_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the client certificate's signature algorithm.\n\n @param conn A pointer to the s2n_connection object\n @param chosen_alg A pointer to a s2n_tls_signature_algorithm object. This is an output parameter.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE if bad parameters are received."]
    pub fn s2n_connection_get_selected_client_cert_signature_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_signature_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the client certificate's digest algorithm.\n\n @param conn A pointer to the s2n_connection object\n @param chosen_alg A pointer to a s2n_tls_hash_algorithm object. This is an output parameter.\n\n @returns S2N_SUCCESS on success. S2N_FAILURE if bad parameters are received."]
    pub fn s2n_connection_get_selected_client_cert_digest_algorithm(
        conn: *mut s2n_connection,
        chosen_alg: *mut s2n_tls_hash_algorithm::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the certificate used during the TLS handshake\n\n - If `conn` is a server connection, the certificate selected will depend on the\n   ServerName sent by the client and supported ciphers.\n - If `conn` is a client connection, the certificate sent in response to a CertificateRequest\n   message is returned. Currently s2n-tls supports loading only one certificate in client mode. Note that\n   not all TLS endpoints will request a certificate.\n\n @param conn A pointer to the s2n_connection object\n\n @returns NULL if the certificate selection phase of the handshake has not completed or if a certificate was not requested by the peer"]
    pub fn s2n_connection_get_selected_cert(
        conn: *mut s2n_connection,
    ) -> *mut s2n_cert_chain_and_key;
}
extern "C" {
    #[doc = " @param chain_and_key A pointer to the s2n_cert_chain_and_key object being read.\n @param cert_length This return value represents the length of the s2n certificate chain `chain_and_key`.\n @returns the length of the s2n certificate chain `chain_and_key`."]
    pub fn s2n_cert_chain_get_length(
        chain_and_key: *const s2n_cert_chain_and_key,
        cert_length: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the certificate `out_cert` present at the index `cert_idx` of the certificate chain `chain_and_key`.\n\n Note that the index of the leaf certificate is zero. If the certificate chain `chain_and_key` is NULL or the\n certificate index value is not in the acceptable range for the input certificate chain, an error is returned.\n\n # Safety\n\n There is no memory allocation required for `out_cert` buffer prior to calling the `s2n_cert_chain_get_cert` API.\n The `out_cert` will contain the pointer to the s2n_cert initialized within the input s2n_cert_chain_and_key `chain_and_key`.\n The pointer to the output s2n certificate `out_cert` is valid until `chain_and_key` is freed up.\n If a caller wishes to persist the `out_cert` beyond the lifetime of `chain_and_key`, the contents would need to be\n copied prior to freeing `chain_and_key`.\n\n @param chain_and_key A pointer to the s2n_cert_chain_and_key object being read.\n @param out_cert A pointer to the output s2n_cert `out_cert` present at the index `cert_idx` of the certificate chain `chain_and_key`.\n @param cert_idx The certificate index for the requested certificate within the s2n certificate chain."]
    pub fn s2n_cert_chain_get_cert(
        chain_and_key: *const s2n_cert_chain_and_key,
        out_cert: *mut *mut s2n_cert,
        cert_idx: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the s2n certificate in DER format along with its length.\n\n The API gets the s2n certificate `cert` in DER format. The certificate is returned in the `out_cert_der` buffer.\n Here, `cert_len` represents the length of the certificate.\n\n A caller can use certificate parsing tools such as the ones provided by OpenSSL to parse the DER encoded certificate chain returned.\n\n # Safety\n\n The memory for the `out_cert_der` buffer is allocated and owned by s2n-tls.\n Since the size of the certificate can potentially be very large, a pointer to internal connection data is returned instead of\n copying the contents into a caller-provided buffer.\n\n The pointer to the output buffer `out_cert_der` is valid only while the connection exists.\n The `s2n_connection_free` API frees the memory associated with the out_cert_der buffer and after the `s2n_connection_wipe` API is\n called the memory pointed by out_cert_der is invalid.\n\n If a caller wishes to persist the `out_cert_der` beyond the lifetime of the connection, the contents would need to be\n copied prior to the connection termination.\n\n @param cert A pointer to the s2n_cert object being read.\n @param out_cert_der A pointer to the output buffer which will hold the s2n certificate `cert` in DER format.\n @param cert_length This return value represents the length of the certificate."]
    pub fn s2n_cert_get_der(
        cert: *const s2n_cert,
        out_cert_der: *mut *const u8,
        cert_length: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the validated peer certificate chain as a `s2n_cert_chain_and_key` opaque object.\n\n The `s2n_cert_chain_and_key` parameter must be allocated by the caller using the `s2n_cert_chain_and_key_new` API\n prior to this function call and must be empty. To free the memory associated with the `s2n_cert_chain_and_key` object use the\n `s2n_cert_chain_and_key_free` API.\n\n @param conn A pointer to the s2n_connection object being read.\n @param cert_chain The returned validated peer certificate chain `cert_chain` retrieved from the s2n connection."]
    pub fn s2n_connection_get_peer_cert_chain(
        conn: *const s2n_connection,
        cert_chain: *mut s2n_cert_chain_and_key,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the length of the DER encoded extension value of the ASN.1 X.509 certificate extension.\n\n @param cert A pointer to the s2n_cert object being read.\n @param oid A null-terminated cstring that contains the OID of the X.509 certificate extension to be read.\n @param ext_value_len This return value contains the length of DER encoded extension value of the ASN.1 X.509 certificate extension."]
    pub fn s2n_cert_get_x509_extension_value_length(
        cert: *mut s2n_cert,
        oid: *const u8,
        ext_value_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the DER encoding of an ASN.1 X.509 certificate extension value, it's length and a boolean critical.\n\n @param cert A pointer to the s2n_cert object being read.\n @param oid A null-terminated cstring that contains the OID of the X.509 certificate extension to be read.\n @param ext_value A pointer to the output buffer which will hold the DER encoding of an ASN.1 X.509 certificate extension value returned.\n @param ext_value_len  This value is both an input and output parameter and represents the length of the output buffer `ext_value`.\n When used as an input parameter, the caller must use this parameter to convey the maximum length of `ext_value`.\n When used as an output parameter, `ext_value_len` holds the actual length of the DER encoding of the ASN.1 X.509 certificate extension value returned.\n @param critical This return value contains the boolean value for `critical`."]
    pub fn s2n_cert_get_x509_extension_value(
        cert: *mut s2n_cert,
        oid: *const u8,
        ext_value: *mut u8,
        ext_value_len: *mut u32,
        critical: *mut bool,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the UTF8 String length of the ASN.1 X.509 certificate extension data.\n\n @param extension_data A pointer to the DER encoded ASN.1 X.509 certificate extension value being read.\n @param extension_len represents the length of the input buffer `extension_data`.\n @param utf8_str_len This return value contains the UTF8 String length of the ASN.1 X.509 certificate extension data."]
    pub fn s2n_cert_get_utf8_string_from_extension_data_length(
        extension_data: *const u8,
        extension_len: u32,
        utf8_str_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the UTF8 String representation of the DER encoded ASN.1 X.509 certificate extension data.\n\n @param extension_data A pointer to the DER encoded ASN.1 X.509 certificate extension value being read.\n @param extension_len represents the length of the input buffer `extension_data`.\n @param out_data A pointer to the output buffer which will hold the UTF8 String representation of the DER encoded ASN.1 X.509\n certificate extension data returned.\n @param out_len This value is both an input and output parameter and represents the length of the output buffer `out_data`.\n When used as an input parameter, the caller must use this parameter to convey the maximum length of `out_data`.\n When used as an output parameter, `out_len` holds the actual length of UTF8 String returned."]
    pub fn s2n_cert_get_utf8_string_from_extension_data(
        extension_data: *const u8,
        extension_len: u32,
        out_data: *mut u8,
        out_len: *mut u32,
    ) -> ::libc::c_int;
}
pub mod s2n_psk_hmac {
    #[doc = " Pre-shared key (PSK) Hash Algorithm - RFC 8446 Section-2.2"]
    pub type Type = ::libc::c_uint;
    pub const SHA256: Type = 0;
    pub const SHA384: Type = 1;
}
#[doc = " Opaque pre shared key handle"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_psk {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Creates a new s2n external pre-shared key (PSK) object with `S2N_PSK_HMAC_SHA256` as the default\n PSK hash algorithm. An external PSK is a key established outside of TLS using a secure mutually agreed upon mechanism.\n\n Use `s2n_psk_free` to free the memory allocated to the s2n external PSK object created by this API.\n\n @returns struct s2n_psk* Returns a pointer to the newly created external PSK object."]
    pub fn s2n_external_psk_new() -> *mut s2n_psk;
}
extern "C" {
    #[doc = " Frees the memory associated with the external PSK object.\n\n @param psk Pointer to the PSK object to be freed."]
    pub fn s2n_psk_free(psk: *mut *mut s2n_psk) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the identity for a given external PSK object.\n The identity is a unique identifier for the pre-shared secret.\n It is a non-secret value represented by raw bytes.\n\n # Safety\n\n The identity is transmitted over the network unencrypted and is a non-secret value.\n Do not include confidential information in the identity.\n\n Note that the identity is copied into s2n-tls memory and the caller is responsible for\n freeing the memory associated with the identity input.\n\n @param psk A pointer to a PSK object to be updated with the identity.\n @param identity The identity in raw bytes format to be copied.\n @param identity_size The length of the PSK identity being set."]
    pub fn s2n_psk_set_identity(
        psk: *mut s2n_psk,
        identity: *const u8,
        identity_size: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the out-of-band/externally provisioned secret for a given external PSK object.\n\n # Safety\n\n Note that the secret is copied into s2n-tls memory and the caller is responsible for\n freeing the memory associated with the `secret` input.\n\n Deriving a shared secret from a password or other low-entropy source\n is not secure and is subject to dictionary attacks.\n See https://tools.ietf.org/rfc/rfc8446#section-2.2 for more information.\n\n @param psk A pointer to a PSK object to be updated with the secret.\n @param secret The secret in raw bytes format to be copied.\n @param secret_size The length of the pre-shared secret being set."]
    pub fn s2n_psk_set_secret(
        psk: *mut s2n_psk,
        secret: *const u8,
        secret_size: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the hash algorithm for a given external PSK object. The supported PSK hash\n algorithms are as listed in the enum `s2n_psk_hmac` above.\n\n @param psk A pointer to the external PSK object to be updated with the PSK hash algorithm.\n @param hmac The PSK hash algorithm being set."]
    pub fn s2n_psk_set_hmac(psk: *mut s2n_psk, hmac: s2n_psk_hmac::Type) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Appends a PSK object to the list of PSKs supported by the s2n connection.\n If a PSK with a duplicate identity is found, an error is returned and the PSK is not added to the list.\n Note that a copy of `psk` is stored on the connection. The user is still responsible for freeing the\n memory associated with `psk`.\n\n @param conn A pointer to the s2n_connection object that contains the list of PSKs supported.\n @param psk A pointer to the `s2n_psk` object to be appended to the list of PSKs on the s2n connection."]
    pub fn s2n_connection_append_psk(conn: *mut s2n_connection, psk: *mut s2n_psk)
        -> ::libc::c_int;
}
pub mod s2n_psk_mode {
    #[doc = " The list of PSK modes supported by s2n-tls for TLS versions >= TLS1.3.\n Currently s2n-tls supports two modes - `S2N_PSK_MODE_RESUMPTION`, which represents the PSKs established\n using the previous connection via session resumption, and `S2N_PSK_MODE_EXTERNAL`, which represents PSKs\n established out-of-band/externally using a secure mutually agreed upon mechanism."]
    pub type Type = ::libc::c_uint;
    pub const RESUMPTION: Type = 0;
    pub const EXTERNAL: Type = 1;
}
extern "C" {
    #[doc = " Sets the PSK mode on the s2n config object.\n The supported PSK modes are listed in the enum `s2n_psk_mode` above.\n\n @param config A pointer to the s2n_config object being updated.\n @param mode The PSK mode to be set."]
    pub fn s2n_config_set_psk_mode(
        config: *mut s2n_config,
        mode: s2n_psk_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the PSK mode on the s2n connection object.\n The supported PSK modes are listed in the enum `s2n_psk_mode` above.\n This API overrides the PSK mode set on config for this connection.\n\n @param conn A pointer to the s2n_connection object being updated.\n @param mode The PSK mode to be set."]
    pub fn s2n_connection_set_psk_mode(
        conn: *mut s2n_connection,
        mode: s2n_psk_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the negotiated PSK identity length from the s2n connection object. The negotiated PSK\n refers to the chosen PSK by the server to be used for the connection.\n\n This API can be used to determine if the negotiated PSK exists. If negotiated PSK exists a\n call to this API returns a value greater than zero. If the negotiated PSK does not exist, the\n value `0` is returned.\n\n @param conn A pointer to the s2n_connection object that successfully negotiated a PSK connection.\n @param identity_length The length of the negotiated PSK identity."]
    pub fn s2n_connection_get_negotiated_psk_identity_length(
        conn: *mut s2n_connection,
        identity_length: *mut u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the negotiated PSK identity from the s2n connection object.\n If the negotiated PSK does not exist, the PSK identity will not be obtained and no error will be returned.\n Prior to this API call, use `s2n_connection_get_negotiated_psk_identity_length` to determine if a\n negotiated PSK exists or not.\n\n # Safety\n\n The negotiated PSK identity will be copied into the identity buffer on success.\n Therefore, the identity buffer must have enough memory to fit the identity length.\n\n @param conn A pointer to the s2n_connection object.\n @param identity The negotiated PSK identity obtained from the s2n_connection object.\n @param max_identity_length The maximum length for the PSK identity. If the negotiated psk_identity length is\n greater than this `max_identity_length` value an error will be returned."]
    pub fn s2n_connection_get_negotiated_psk_identity(
        conn: *mut s2n_connection,
        identity: *mut u8,
        max_identity_length: u16,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_offered_psk {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Creates a new s2n offered PSK object.\n An offered PSK object represents a single PSK sent by the client.\n\n # Safety\n\n Use `s2n_offered_psk_free` to free the memory allocated to the s2n offered PSK object created by this API.\n\n @returns struct s2n_offered_psk* Returns a pointer to the newly created offered PSK object."]
    pub fn s2n_offered_psk_new() -> *mut s2n_offered_psk;
}
extern "C" {
    #[doc = " Frees the memory associated with the `s2n_offered_psk` object.\n\n @param psk A pointer to the `s2n_offered_psk` object to be freed."]
    pub fn s2n_offered_psk_free(psk: *mut *mut s2n_offered_psk) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Gets the PSK identity and PSK identity length for a given offered PSK object.\n\n @param psk A pointer to the offered PSK object being read.\n @param identity The PSK identity being obtained.\n @param size The length of the PSK identity being obtained."]
    pub fn s2n_offered_psk_get_identity(
        psk: *mut s2n_offered_psk,
        identity: *mut *mut u8,
        size: *mut u16,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_offered_psk_list {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Checks whether the offered PSK list has an offered psk object next in line in the list.\n An offered PSK list contains all the PSKs offered by the client for the server to select.\n\n # Safety\n\n This API returns a pointer to the s2n-tls internal memory with limited lifetime.\n After the completion of `s2n_psk_selection_callback` this pointer is invalid.\n\n @param psk_list A pointer to the offered PSK list being read.\n @returns bool A boolean value representing whether an offered psk object is present next in line in the offered PSK list."]
    pub fn s2n_offered_psk_list_has_next(psk_list: *mut s2n_offered_psk_list) -> bool;
}
extern "C" {
    #[doc = " Obtains the next offered PSK object from the list of offered PSKs. Use `s2n_offered_psk_list_has_next`\n prior to this API call to ensure we have not reached the end of the list.\n\n @param psk_list A pointer to the offered PSK list being read.\n @param psk A pointer to the next offered PSK object being obtained."]
    pub fn s2n_offered_psk_list_next(
        psk_list: *mut s2n_offered_psk_list,
        psk: *mut s2n_offered_psk,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the offered PSK list to its original read state.\n\n When `s2n_offered_psk_list_reread` is called, `s2n_offered_psk_list_next` will return the first PSK\n in the offered PSK list.\n\n @param psk_list A pointer to the offered PSK list being reread."]
    pub fn s2n_offered_psk_list_reread(psk_list: *mut s2n_offered_psk_list) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Chooses a PSK from the offered PSK list to be used for the connection.\n This API matches the PSK identity received from the client against the server's known PSK identities\n list, in order to choose the PSK to be used for the connection. If the PSK identity sent from the client\n is NULL, no PSK is chosen for the connection. If the client offered PSK identity has no matching PSK identity\n with the server, an error will be returned. Use this API along with the `s2n_psk_selection_callback` callback\n to select a PSK identity.\n\n @param psk_list A pointer to the server's known PSK list used to compare for a matching PSK with the client.\n @param psk A pointer to the client's PSK object used to compare with the server's known PSK identities."]
    pub fn s2n_offered_psk_list_choose_psk(
        psk_list: *mut s2n_offered_psk_list,
        psk: *mut s2n_offered_psk,
    ) -> ::libc::c_int;
}
#[doc = " Callback function to select a PSK from a list of offered PSKs.\n Use this callback to implement custom PSK selection logic. The s2n-tls default PSK selection logic\n chooses the first matching PSK from the list of offered PSKs sent by the client.\n\n # Safety\n\n `context` is a void pointer and the caller is responsible for ensuring it is cast to the correct type.\n After the completion of this callback, the pointer to `psk_list` is invalid.\n\n @param conn A pointer to the s2n_connection object.\n @param context A pointer to a context for the caller to pass state to the callback, if needed.\n @param psk_list A pointer to the offered PSK list being read."]
pub type s2n_psk_selection_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        context: *mut ::libc::c_void,
        psk_list: *mut s2n_offered_psk_list,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets the callback to select the matching PSK.\n If this callback is not set s2n-tls uses a default PSK selection logic that selects the first matching\n server PSK.\n\n @param config A pointer to the s2n_config object.\n @param cb The function that should be called when the callback is triggered.\n @param context A pointer to a context for the caller to pass state to the callback, if needed."]
    pub fn s2n_config_set_psk_selection_callback(
        config: *mut s2n_config,
        cb: s2n_psk_selection_callback,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the number of bytes the connection has received.\n\n @param conn A pointer to the connection\n @returns return the number of bytes received by s2n-tls \"on the wire\""]
    pub fn s2n_connection_get_wire_bytes_in(conn: *mut s2n_connection) -> u64;
}
extern "C" {
    #[doc = " Get the number of bytes the connection has transmitted out.\n\n @param conn A pointer to the connection\n @returns return the number of bytes transmitted out by s2n-tls \"on the wire\""]
    pub fn s2n_connection_get_wire_bytes_out(conn: *mut s2n_connection) -> u64;
}
extern "C" {
    #[doc = " Access the protocol version supported by the client.\n\n @note The return value corresponds to the macros defined as S2N_SSLv2,\n S2N_SSLv3, S2N_TLS10, S2N_TLS11, S2N_TLS12, and S2N_TLS13.\n\n @param conn A pointer to the connection\n @returns returns the highest protocol version supported by the client"]
    pub fn s2n_connection_get_client_protocol_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Access the protocol version supported by the server.\n\n @note The return value corresponds to the macros defined as S2N_SSLv2,\n S2N_SSLv3, S2N_TLS10, S2N_TLS11, S2N_TLS12, and S2N_TLS13.\n\n @param conn A pointer to the connection\n @returns Returns the highest protocol version supported by the server"]
    pub fn s2n_connection_get_server_protocol_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Access the protocol version selected for the connection.\n\n @note The return value corresponds to the macros defined as S2N_SSLv2,\n S2N_SSLv3, S2N_TLS10, S2N_TLS11, S2N_TLS12, and S2N_TLS13.\n\n @param conn A pointer to the connection\n @returns The protocol version actually negotiated by the handshake"]
    pub fn s2n_connection_get_actual_protocol_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Access the client hello protocol version for the connection.\n\n @note The return value corresponds to the macros defined as S2N_SSLv2,\n S2N_SSLv3, S2N_TLS10, S2N_TLS11, S2N_TLS12, and S2N_TLS13.\n\n @param conn A pointer to the connection\n @returns The protocol version used to send the initial client hello message."]
    pub fn s2n_connection_get_client_hello_version(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Check if Client Auth was used for a connection.\n\n @param conn A pointer to the connection\n @returns 1 if the handshake completed and Client Auth was negotiated during then\n handshake."]
    pub fn s2n_connection_client_cert_used(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " A function that provides a human readable string of the cipher suite that was chosen\n for a connection.\n\n @warning The string \"TLS_NULL_WITH_NULL_NULL\" is returned before the TLS handshake has been performed.\n This does not mean that the ciphersuite \"TLS_NULL_WITH_NULL_NULL\" will be used by the connection,\n it is merely being used as a placeholder.\n\n @note This function is only accurate after the TLS handshake.\n\n @param conn A pointer to the connection\n @returns A string indicating the cipher suite negotiated by s2n in OpenSSL format."]
    pub fn s2n_connection_get_cipher(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Provides access to the TLS-Exporter functionality.\n\n See https://datatracker.ietf.org/doc/html/rfc5705 and https://www.rfc-editor.org/rfc/rfc8446.\n\n @note This is currently only available with TLS 1.3 connections which have finished a handshake.\n\n @param conn A pointer to the connection\n @returns A POSIX error signal. If an error was returned, the value contained in `output` should be considered invalid."]
    pub fn s2n_connection_tls_exporter(
        conn: *mut s2n_connection,
        label: *const u8,
        label_length: u32,
        context: *const u8,
        context_length: u32,
        output: *mut u8,
        output_length: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the IANA value for the connection's negotiated cipher suite.\n\n The value is returned in the form of `first,second`, in order to closely match\n the values defined in the [IANA Registry](https://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#table-tls-parameters-4).\n For example if the connection's negotiated cipher suite is `TLS_AES_128_GCM_SHA256`,\n which is registered as `0x13,0x01`, then `first = 0x13` and `second = 0x01`.\n\n This method will only succeed after the cipher suite has been negotiated with the peer.\n\n @param conn A pointer to the connection being read\n @param first A pointer to a single byte, which will be updated with the first byte in the registered IANA value.\n @param second A pointer to a single byte, which will be updated with the second byte in the registered IANA value.\n @returns A POSIX error signal. If an error was returned, the values contained in `first` and `second` should be considered invalid."]
    pub fn s2n_connection_get_cipher_iana_value(
        conn: *mut s2n_connection,
        first: *mut u8,
        second: *mut u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Function to check if the cipher used by current connection is supported by the current\n cipher preferences.\n @param conn A pointer to the s2n connection\n @param version A string representing the security policy to check against.\n @returns 1 if the connection satisfies the cipher suite. 0 if the connection does not satisfy the cipher suite. -1 if there is an error."]
    pub fn s2n_connection_is_valid_for_cipher_preferences(
        conn: *mut s2n_connection,
        version: *const ::libc::c_char,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Function to get the human readable elliptic curve name for the connection.\n\n @param conn A pointer to the s2n connection\n @returns A string indicating the elliptic curve used during ECDHE key exchange. The string \"NONE\" is returned if no curve was used."]
    pub fn s2n_connection_get_curve(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Function to get the human readable KEM name for the connection.\n\n @param conn A pointer to the s2n connection\n @returns A human readable string for the KEM group. If there is no KEM configured returns \"NONE\""]
    pub fn s2n_connection_get_kem_name(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Function to get the human readable KEM group name for the connection.\n\n @param conn A pointer to the s2n connection\n @returns A human readable string for the KEM group. If the connection is < TLS1.3 or there is no KEM group configured returns \"NONE\""]
    pub fn s2n_connection_get_kem_group_name(conn: *mut s2n_connection) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Function to get the alert that caused a connection to close. s2n-tls considers all\n TLS alerts fatal and shuts down a connection whenever one is received.\n\n @param conn A pointer to the s2n connection\n @returns The TLS alert code that caused a connection to be shut down"]
    pub fn s2n_connection_get_alert(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Function to return the last TLS handshake type that was processed. The returned format is a human readable string.\n\n @param conn A pointer to the s2n connection\n @returns A human-readable handshake type name, e.g. \"NEGOTIATED|FULL_HANDSHAKE|PERFECT_FORWARD_SECRECY\""]
    pub fn s2n_connection_get_handshake_type_name(
        conn: *mut s2n_connection,
    ) -> *const ::libc::c_char;
}
extern "C" {
    #[doc = " Function to return the last TLS message that was processed. The returned format is a human readable string.\n @param conn A pointer to the s2n connection\n @returns The last message name in the TLS state machine, e.g. \"SERVER_HELLO\", \"APPLICATION_DATA\"."]
    pub fn s2n_connection_get_last_message_name(conn: *mut s2n_connection)
        -> *const ::libc::c_char;
}
#[doc = " Opaque async private key operation handle"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_async_pkey_op {
    _unused: [u8; 0],
}
pub mod s2n_async_pkey_validation_mode {
    #[doc = " Sets whether or not a connection should enforce strict signature validation during the\n `s2n_async_pkey_op_apply` call.\n\n `mode` can take the following values:\n - `S2N_ASYNC_PKEY_VALIDATION_FAST` - default behavior: s2n-tls will perform only the minimum validation required for safe use of the asyn pkey operation.\n - `S2N_ASYNC_PKEY_VALIDATION_STRICT` - in addition to the previous checks, s2n-tls will also ensure that the signature created as a result of the async private key sign operation matches the public key on the connection."]
    pub type Type = ::libc::c_uint;
    pub const FAST: Type = 0;
    pub const STRICT: Type = 1;
}
pub mod s2n_async_pkey_op_type {
    #[doc = " The type of private key operation"]
    pub type Type = ::libc::c_uint;
    pub const DECRYPT: Type = 0;
    pub const SIGN: Type = 1;
}
#[doc = " Callback function for handling private key operations\n\n Invoked every time an operation requiring the private key is encountered\n during the handshake.\n\n # Safety\n * `op` is owned by the application and MUST be freed.\n\n @param conn Connection which triggered the callback\n @param op An opaque object representing the private key operation"]
pub type s2n_async_pkey_fn = ::core::option::Option<
    unsafe extern "C" fn(conn: *mut s2n_connection, op: *mut s2n_async_pkey_op) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets up the callback to invoke when private key operations occur.\n\n @param config Config to set the callback\n @param fn The function that should be called for each private key operation"]
    pub fn s2n_config_set_async_pkey_callback(
        config: *mut s2n_config,
        fn_: s2n_async_pkey_fn,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Performs a private key operation using the given private key.\n\n # Safety\n * Can only be called once. Any subsequent calls will produce a `S2N_ERR_T_USAGE` error.\n * Safe to call from inside s2n_async_pkey_fn\n * Safe to call from a different thread, as long as no other thread is operating on `op`.\n\n @param op An opaque object representing the private key operation\n @param key The private key used for the operation. It can be extracted from\n `conn` through the `s2n_connection_get_selected_cert` and `s2n_cert_chain_and_key_get_private_key` calls"]
    pub fn s2n_async_pkey_op_perform(
        op: *mut s2n_async_pkey_op,
        key: *mut s2n_cert_private_key,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Finalizes a private key operation and unblocks the connection.\n\n # Safety\n * `conn` must match the connection that originally triggered the callback.\n * Must be called after the operation is performed.\n * Can only be called once. Any subsequent calls will produce a `S2N_ERR_T_USAGE` error.\n * Safe to call from inside s2n_async_pkey_fn\n * Safe to call from a different thread, as long as no other thread is operating on `op`.\n\n @param op An opaque object representing the private key operation\n @param conn The connection associated with the operation that should be unblocked"]
    pub fn s2n_async_pkey_op_apply(
        op: *mut s2n_async_pkey_op,
        conn: *mut s2n_connection,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Frees the opaque structure representing a private key operation.\n\n # Safety\n * MUST be called for every operation passed to s2n_async_pkey_fn\n * Safe to call before or after the connection that created the operation is freed\n\n @param op An opaque object representing the private key operation"]
    pub fn s2n_async_pkey_op_free(op: *mut s2n_async_pkey_op) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Configures whether or not s2n-tls will perform potentially expensive validation of\n the results of a private key operation.\n\n @param config Config to set the validation mode for\n @param mode What level of validation to perform"]
    pub fn s2n_config_set_async_pkey_validation_mode(
        config: *mut s2n_config,
        mode: s2n_async_pkey_validation_mode::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the type of the private key operation.\n\n @param op An opaque object representing the private key operation\n @param type A pointer to be set to the type"]
    pub fn s2n_async_pkey_op_get_op_type(
        op: *mut s2n_async_pkey_op,
        type_: *mut s2n_async_pkey_op_type::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the size of the input to the private key operation.\n\n @param op An opaque object representing the private key operation\n @param data_len A pointer to be set to the size"]
    pub fn s2n_async_pkey_op_get_input_size(
        op: *mut s2n_async_pkey_op,
        data_len: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Returns the input to the private key operation.\n\n When signing, the input is the digest to sign.\n When decrypting, the input is the data to decrypt.\n\n # Safety\n * `data` must be sufficiently large to contain the input.\n   `s2n_async_pkey_op_get_input_size` can be called to determine how much memory is required.\n * s2n-tls does not take ownership of `data`.\n   The application still owns the memory and must free it if necessary.\n\n @param op An opaque object representing the private key operation\n @param data A pointer to a buffer to copy the input into\n @param data_len The maximum size of the `data` buffer"]
    pub fn s2n_async_pkey_op_get_input(
        op: *mut s2n_async_pkey_op,
        data: *mut u8,
        data_len: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the output of the private key operation.\n\n # Safety\n * s2n-tls does not take ownership of `data`.\n   The application still owns the memory and must free it if necessary.\n\n @param op An opaque object representing the private key operation\n @param data A pointer to a buffer containing the output\n @param data_len The size of the `data` buffer"]
    pub fn s2n_async_pkey_op_set_output(
        op: *mut s2n_async_pkey_op,
        data: *const u8,
        data_len: u32,
    ) -> ::libc::c_int;
}
#[doc = " Callback function for handling key log events\n\n THIS SHOULD BE USED FOR DEBUGGING PURPOSES ONLY!\n\n Each log line is formatted with the\n [NSS Key Log Format](https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSS/Key_Log_Format)\n without a newline.\n\n # Safety\n\n * `ctx` MUST be cast into the same type of pointer that was originally created\n * `logline` bytes MUST be copied or discarded before this function returns\n\n @param ctx Context for the callback\n @param conn Connection for which the log line is being emitted\n @param logline Pointer to the log line data\n @param len Length of the log line data"]
pub type s2n_key_log_fn = ::core::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::libc::c_void,
        conn: *mut s2n_connection,
        logline: *mut u8,
        len: usize,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets a key logging callback on the provided config\n\n THIS SHOULD BE USED FOR DEBUGGING PURPOSES ONLY!\n\n Setting this function enables configurations to emit secrets in the\n [NSS Key Log Format](https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSS/Key_Log_Format)\n\n # Safety\n\n * `callback` MUST cast `ctx` into the same type of pointer that was originally created\n * `ctx` MUST live for at least as long as it is set on the config\n\n @param config Config to set the callback\n @param callback The function that should be called for each secret log entry\n @param ctx The context to be passed when the callback is called"]
    pub fn s2n_config_set_key_log_cb(
        config: *mut s2n_config,
        callback: s2n_key_log_fn,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " s2n_config_enable_cert_req_dss_legacy_compat adds a dss cert type in the server certificate request when being called.\n It only sends the dss cert type in the cert request but does not succeed the handshake if a dss cert is received.\n Please DO NOT call this api unless you know you actually need legacy DSS certificate type compatibility\n @param config Config to enable legacy DSS certificates for"]
    pub fn s2n_config_enable_cert_req_dss_legacy_compat(config: *mut s2n_config) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the maximum bytes of early data the server will accept.\n\n The default maximum is 0. If the maximum is 0, the server rejects all early data requests.\n The config maximum can be overridden by the connection maximum or the maximum on an external pre-shared key.\n\n @param config A pointer to the config\n @param max_early_data_size The maximum early data that the server will accept\n @returns A POSIX error signal. If successful, the maximum early data size was updated."]
    pub fn s2n_config_set_server_max_early_data_size(
        config: *mut s2n_config,
        max_early_data_size: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the maximum bytes of early data the server will accept.\n\n The default maximum is 0. If the maximum is 0, the server rejects all early data requests.\n The connection maximum can be overridden by the maximum on an external pre-shared key.\n\n @param conn A pointer to the connection\n @param max_early_data_size The maximum early data the server will accept\n @returns A POSIX error signal. If successful, the maximum early data size was updated."]
    pub fn s2n_connection_set_server_max_early_data_size(
        conn: *mut s2n_connection,
        max_early_data_size: u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the user context associated with early data on a server.\n\n This context is passed to the `s2n_early_data_cb` callback to help decide whether to accept or reject early data.\n\n Unlike most contexts, the early data context is a byte buffer instead of a void pointer.\n This is because we need to serialize the context into session tickets.\n\n This API is intended for use with session resumption, and will not affect pre-shared keys.\n\n @param conn A pointer to the connection\n @param context A pointer to the user context data. This data will be copied.\n @param context_size The size of the data to read from the `context` pointer.\n @returns A POSIX error signal. If successful, the context was updated."]
    pub fn s2n_connection_set_server_early_data_context(
        conn: *mut s2n_connection,
        context: *const u8,
        context_size: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Configures a particular pre-shared key to allow early data.\n\n `max_early_data_size` must be set to the maximum early data accepted by the server.\n\n In order to use early data, the cipher suite set on the pre-shared key must match the cipher suite\n ultimately negotiated by the TLS handshake. Additionally, the cipher suite must have the same\n hmac algorithm as the pre-shared key.\n\n @param psk A pointer to the pre-shared key, created with `s2n_external_psk_new`.\n @param max_early_data_size The maximum early data that can be sent or received using this key.\n @param cipher_suite_first_byte The first byte in the registered IANA value of the associated cipher suite.\n @param cipher_suite_second_byte The second byte in the registered IANA value of the associated cipher suite.\n @returns A POSIX error signal. If successful, `psk` was updated."]
    pub fn s2n_psk_configure_early_data(
        psk: *mut s2n_psk,
        max_early_data_size: u32,
        cipher_suite_first_byte: u8,
        cipher_suite_second_byte: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the optional `application_protocol` associated with the given pre-shared key.\n\n In order to use early data, the `application_protocol` set on the pre-shared key must match\n the `application_protocol` ultimately negotiated by the TLS handshake.\n\n @param psk A pointer to the pre-shared key, created with `s2n_external_psk_new`.\n @param application_protocol A pointer to the associated application protocol data. This data will be copied.\n @param size The size of the data to read from the `application_protocol` pointer.\n @returns A POSIX error signal. If successful, the application protocol was set."]
    pub fn s2n_psk_set_application_protocol(
        psk: *mut s2n_psk,
        application_protocol: *const u8,
        size: u8,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Sets the optional user early data context associated with the given pre-shared key.\n\n The early data context is passed to the `s2n_early_data_cb` callback to help decide whether\n to accept or reject early data.\n\n @param psk A pointer to the pre-shared key, created with `s2n_external_psk_new`.\n @param context A pointer to the associated user context data. This data will be copied.\n @param size The size of the data to read from the `context` pointer.\n @returns A POSIX error signal. If successful, the context was set."]
    pub fn s2n_psk_set_early_data_context(
        psk: *mut s2n_psk,
        context: *const u8,
        size: u16,
    ) -> ::libc::c_int;
}
pub mod s2n_early_data_status_t {
    #[doc = " The status of early data on a connection.\n\n S2N_EARLY_DATA_STATUS_OK: Early data is in progress.\n S2N_EARLY_DATA_STATUS_NOT_REQUESTED: The client did not request early data, so none was sent or received.\n S2N_EARLY_DATA_STATUS_REJECTED: The client requested early data, but the server rejected the request.\n                                 Early data may have been sent, but was not received.\n S2N_EARLY_DATA_STATUS_END: All early data was successfully sent and received."]
    pub type Type = ::libc::c_uint;
    pub const OK: Type = 0;
    pub const NOT_REQUESTED: Type = 1;
    pub const REJECTED: Type = 2;
    pub const END: Type = 3;
}
extern "C" {
    #[doc = " Reports the current state of early data for a connection.\n\n See `s2n_early_data_status_t` for all possible states.\n\n @param conn A pointer to the connection\n @param status A pointer which will be set to the current early data status\n @returns A POSIX error signal."]
    pub fn s2n_connection_get_early_data_status(
        conn: *mut s2n_connection,
        status: *mut s2n_early_data_status_t::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Reports the remaining size of the early data allowed by a connection.\n\n If early data was rejected or not requested, the remaining early data size is 0.\n Otherwise, the remaining early data size is the maximum early data allowed by the connection,\n minus the early data sent or received so far.\n\n @param conn A pointer to the connection\n @param allowed_early_data_size A pointer which will be set to the remaining early data currently allowed by `conn`\n @returns A POSIX error signal."]
    pub fn s2n_connection_get_remaining_early_data_size(
        conn: *mut s2n_connection,
        allowed_early_data_size: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Reports the maximum size of the early data allowed by a connection.\n\n This is the maximum amount of early data that can ever be sent and received for a connection.\n It is not affected by the actual status of the early data, so can be non-zero even if early data\n is rejected or not requested.\n\n @param conn A pointer to the connection\n @param max_early_data_size A pointer which will be set to the maximum early data allowed by `conn`\n @returns A POSIX error signal."]
    pub fn s2n_connection_get_max_early_data_size(
        conn: *mut s2n_connection,
        max_early_data_size: *mut u32,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Called by the client to begin negotiation and send early data.\n\n See https://github.com/aws/s2n-tls/blob/main/docs/USAGE-GUIDE.md#using-early-data--0rtt\n for usage and examples. DO NOT USE unless you have considered the security issues and\n implemented mitigation for anti-replay attacks.\n\n @param conn A pointer to the connection\n @param data A pointer to the early data to be sent\n @param data_len The size of the early data to send\n @param data_sent A pointer which will be set to the size of the early data sent\n @param blocked A pointer which will be set to the blocked status, as in `s2n_negotiate`.\n @returns A POSIX error signal. The error should be handled as in `s2n_negotiate`."]
    pub fn s2n_send_early_data(
        conn: *mut s2n_connection,
        data: *const u8,
        data_len: isize,
        data_sent: *mut isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Called by the server to begin negotiation and accept any early data the client sends.\n\n See https://github.com/aws/s2n-tls/blob/main/docs/USAGE-GUIDE.md#using-early-data--0rtt\n for usage and examples. DO NOT USE unless you have considered the security issues and\n implemented mitigation for anti-replay attacks.\n\n @param conn A pointer to the connection\n @param data A pointer to a buffer to store the early data received\n @param max_data_len The size of the early data buffer\n @param data_received A pointer which will be set to the size of the early data received\n @param blocked A pointer which will be set to the blocked status, as in `s2n_negotiate`.\n @returns A POSIX error signal. The error should be handled as in `s2n_negotiate`."]
    pub fn s2n_recv_early_data(
        conn: *mut s2n_connection,
        data: *mut u8,
        max_data_len: isize,
        data_received: *mut isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_offered_early_data {
    _unused: [u8; 0],
}
#[doc = " A callback which can be implemented to accept or reject early data.\n\n This callback is triggered only after the server has determined early data is otherwise acceptable according\n to the TLS early data specification. Implementations therefore only need to cover application-specific checks,\n not the standard TLS early data validation.\n\n This callback can be synchronous or asynchronous. For asynchronous behavior, return success without\n calling `s2n_offered_early_data_reject` or `s2n_offered_early_data_accept`. `early_data` will\n still be a valid reference, and the connection will block until `s2n_offered_early_data_reject` or\n `s2n_offered_early_data_accept` is called.\n\n @param conn A pointer to the connection\n @param early_data A pointer which can be used to access information about the proposed early data\n                   and then accept or reject it.\n @returns A POSIX error signal. If unsuccessful, the connection will be closed with an error."]
pub type s2n_early_data_cb = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        early_data: *mut s2n_offered_early_data,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Set a callback to accept or reject early data.\n\n @param config A pointer to the connection config\n @param cb A pointer to the implementation of the callback.\n @returns A POSIX error signal. If successful, the callback was set."]
    pub fn s2n_config_set_early_data_cb(
        config: *mut s2n_config,
        cb: s2n_early_data_cb,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the length of the early data context set by the user.\n\n @param early_data A pointer to the early data information\n @param context_len The length of the user context\n @returns A POSIX error signal."]
    pub fn s2n_offered_early_data_get_context_length(
        early_data: *mut s2n_offered_early_data,
        context_len: *mut u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Get the early data context set by the user.\n\n @param early_data A pointer to the early data information\n @param context A byte buffer to copy the user context into\n @param max_len The size of `context`. Must be >= to the result of `s2n_offered_early_data_get_context_length`.\n @returns A POSIX error signal."]
    pub fn s2n_offered_early_data_get_context(
        early_data: *mut s2n_offered_early_data,
        context: *mut u8,
        max_len: u16,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Reject early data offered by the client.\n\n @param early_data A pointer to the early data information\n @returns A POSIX error signal. If success, the client's early data will be rejected."]
    pub fn s2n_offered_early_data_reject(early_data: *mut s2n_offered_early_data) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Accept early data offered by the client.\n\n @param early_data A pointer to the early data information\n @returns A POSIX error signal. If success, the client's early data will be accepted."]
    pub fn s2n_offered_early_data_accept(early_data: *mut s2n_offered_early_data) -> ::libc::c_int;
}
