## RabbitMQ 3.8.12

RabbitMQ `3.8.12` is a maintenance release that contains bug fixes.

### Erlang/OTP Compatibility Notes

This release [requires Erlang 22](https://www.rabbitmq.com/which-erlang.html) or
[Erlang 23](http://blog.erlang.org/OTP-23-Highlights/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 22.x or Later Versions

When upgrading to this release from `3.7.15` or an older version, extra care has to be taken.

Because older RabbitMQ CLI tools can be incompatible with Erlang 22+ releases,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` on Erlang 21.3 first,
then Erlang 22.x or 23.x, then RabbitMQ to the most recent 3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * [Maintenance mode](https://www.rabbitmq.com/upgrade.html#maintenance-mode) no longer transfers leaders of classic mirrored queue.

   The original transfer implementation was not guaranteed to be safe when only a
   subset of cluster nodes hosted replicas. In addition, the process could take
   a lot of time in environments with a lot of classic mirrored queues, more
   than in case of node shutdown.

   Quorum queue leadership transfer is still performed as it is dramatically more
   efficient and never suffered from any downsides of leadership transfer of CMQs.

   GitHub issue: [#2749](https://github.com/rabbitmq/rabbitmq-server/issues/2749)

 * Exclusive queues that happen to be matched by classic queue mirroring policies
   will no longer be considered for rebalancing operations since they are not
   actually mirrored (the lifecycle is by design tied to a single client connection).

   GitHub issue: [#2795](https://github.com/rabbitmq/rabbitmq-server/issues/2795)

 * Default replica count for quorum queues was using an incorrect configuration key name.
   The default value is now `3`, so in a cluster of five or seven nodes, only three
   will host replicas for newly declared quorum queues. One replica is the node to which
   the declaring client is connected to, two others are selected randomly.

   Declaring connections can control the number of replicas using the `x-quorum-initial-group-size`
   optional queue argument at declaration time.

   GitHub issue: [#2759](https://github.com/rabbitmq/rabbitmq-server/pull/2759)

 * Default [runtime busy waiting](https://www.rabbitmq.com/runtime.html#cpu-reduce-idle-usage) settings were
   changed to `none` by default, which reduces CPU footprint on nodes that are mostly idle. The values
   can be overridden for workloads that benefit from different values.

   Contributed by @carlhoerberg (CloudAMQP)

   GitHub issue: [#2803](https://github.com/rabbitmq/rabbitmq-server/pull/2803)

 * Definition import now imports runtime parameters after exchanges, queues, and bindings
   to reduce the likelihood of starting dynamic Shovels from racing with topology
   imports.

   GitHub issue: [#2798](https://github.com/rabbitmq/rabbitmq-server/issues/2798)

 * Memory monitor could run into an exception if queried very early on node boot
   before it was fully initialized.

   Contributed by @tomyouyou.

   GitHub issue: [#2733](https://github.com/rabbitmq/rabbitmq-server/pull/2733)

#### Enhancements

 * `rabbitmq.conf` validation of TLS certificate and private key paths is now more thorough:
   it checks if the files have read or read/write permissions instead of checking if it can read
   the file's metadata.

   GitHub issue: [#2685](https://github.com/rabbitmq/rabbitmq-server/issues/2685)

### CLI Tools

#### Enhancements

 * `rabbitmqctl close_all_user_connections` is a new command that closes all connections that
   authenticated using a specific username:

   ```
   rabbitmqctl close_all_user_connections "user-99fc15d3f" "closed to force reconnection"
   ```

   GitHub issue: [#2715](https://github.com/rabbitmq/rabbitmq-server/issues/2715)


### Prometheus Plugin

#### Bug Fixes

 * AuthN authentication attempts metrics produced duplicate `TYPE` and `HELP` strings in
   the scraping API endpoint output.

   Some metrics were renamed to avoid duplication. The new names are `auth_attempts_detailed_total`,
   `auth_attempts_detailed_succeeded_total`, and `auth_attempts_detailed_failed_total`.

   This issue is specific to RabbitMQ `3.8.10` and `3.8.11`.

   GitHub issue: [#2740](https://github.com/rabbitmq/rabbitmq-server/issues/2740)


### LDAP Plugin

#### Enhancements

 * The plugin now supports two new configuration settings that control SNI and hostname verification
   behavior for TLS-enabled LDAP client connections:

   ``` ini
   # leave out to keep the default behavior (exact hostname matching)
   auth_ldap.ssl_options.hostname_verification = wildcard

   # set to none to disable SNI
   auth_ldap.ssl_options.sni = a.rabbitmq.hostname.dev
   ```

   These changes are based on the [research and suggestions](https://pcable.net/posts/2021-02-10-rmq-ldap/) from Patrick @patcable Cable.

   GitHub issue: [#2805](https://github.com/rabbitmq/rabbitmq-server/issues/2805)


## Shovel Plugin

#### Enhancements

 * Dynamic Shovels now can specify [optional queue arguments](https://www.rabbitmq.com/queues.html#optional-arguments) for
   the queues they declare. Note that these settings will not have any effects for cases where the plugin
   uses already existing queues.

   This allows for the Shovel-managed queues to be [quorum](https://www.rabbitmq.com/quorum-queues.html). For the arguments
   that must not be provided at queue declaration time, [policies](https://www.rabbitmq.com/parameters.html#policies)
   is the right approach.

   The arguments are specified using the `""` and `""` arguments for source and destination queues, respectively:

   ``` json
   {
     "src-protocol": "amqp091",
     "src-uri": ["amqp://localhost"],
     "src-queue": "src-queue",
     "dest-protocol": "amqp091",
     "dest-uri": ["amqp://localhost"],
     "dest-queue": "dest-queue",
     "src-queue-args": {
       "x-queue-type": "quorum"
       },
     "dest-queue-args": {
       "x-queue-type": "quorum"
       }
     }
   ```

   GitHub issue: [#2799](https://github.com/rabbitmq/rabbitmq-server/issues/2799)


## AuthN/AuthZ Cache Plugin

### Enhancement

 * Cache operation timeout has been increased to 15s (same as the channel operation timeout in the core).
   This prevents sporadic timeouts in heavily loaded systems.

   GitHub issue: [#2792](https://github.com/rabbitmq/rabbitmq-server/pull/2792)


## RabbitMQ Erlang Client

#### Bug Fixes

 * The client performed hostname resolution twice even if IP version preference was specified by the user.

   Contributed by Pawel @haljin Antemijczuk.

   GitHub issue: [#2748](https://github.com/rabbitmq/rabbitmq-server/issues/2748)

## Dependency Upgrades

No dependency changes.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.12.tar.xz`
instead of the source tarball produced by GitHub.
