## RabbitMQ 3.11.0

RabbitMQ 3.11 is a new feature release.

## Highlights

This release includes several new features and optimizations, graduates (makes mandatory) a number of feature flags,
bumps minimum required version to Erlang 25 for ARM64 CPU feature parity.

The areas that have seen the biggest improvements in this release are

 * Streams and the RabbitMQ stream protocol
 * OAuth 2 support

See Compatibility Notes below to learn about breaking or potentially breaking changes in this release.

## Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).


### Erlang/OTP Compatibility Notes

This release [requires Erlang 25.0](https://www.rabbitmq.com/which-erlang.html) or later.
This introduces feature parity for x86- and ARM64-based CPUs: Erlang 25 offers the JIT and
[modern Flame Graph profiling](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/) tooling
for both of those major CPU architectures.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang 25.x.


## Upgrading to 3.11

### Documentation guides on upgrades

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for documentation on upgrades and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html)
for release notes of other releases.

### Required

RabbitMQ 3.11.0 [will require all feature flags introduced in RabbitMQ 3.8 to be enabled](https://blog.rabbitmq.com/posts/2022/07/required-feature-flags-in-rabbitmq-3.11/)
before upgrading. If that is not the case, the upgrade process will not proceed.

### Mixed version cluster compatibility

RabbitMQ 3.11.0 nodes can run alongside `3.10.x` nodes. `3.11.x`-specific features can only be made available when all nodes in the cluster
upgrade to 3.11.0 or any other patch release in the series.

While operating in mixed version mode, some aspects of the system may not behave as expected. The list of known behavior changes is covered below.
Once all nodes are upgraded to 3.11.0, these irregularities will go away.

Mixed version clusters are a mechanism that allows rolling upgrade and are not meant to be run for extended
periods of time (no more than a few hours).



## Compatibility Notes

### Several Feature Flags Gratuate to Core Features ("Always Enabled")

RabbitMQ 3.11.0 will [require all feature flags from the 3.8.x release series to be enabled](https://blog.rabbitmq.com/posts/2022/07/required-feature-flags-in-rabbitmq-3.11/) before upgrading.
If the feature flags are not enabled, RabbitMQ 3.11 and later nodes will refuse to start.

### Minimum Supported Erlang Version

Starting with this release, RabbitMQ requires Erlang 25.0 or later versions. Nodes **will fail to start**
on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.

### Open File Handle Limit is Capped by Default on Linux, *BSD, macOS

Nodes now default to 65536 concurrent client connections instead of using the effective kernel open file handle limit.
Users who want to override this default, that is, have nodes that should support more concurrent connections and open files,
now have to perform an additional configuration step:

 * Pick a new limit value they would like to use, for instance, 100K
 * Set the maximum open file handle limit (for example, via `systemd` or similar tooling) for the OS user used by RabbitMQ to 100K
 * Set the [`ERL_MAX_PORTS` environment variable](https://www.rabbitmq.com/configure.html#customise-environment) to 100K

This change was introduced because of a change in several Linux distributions: they now use a default open file handle limit so high,
they cause a significant (say, 1.5 GiB) memory preallocated the Erlang runtime.

For example, [RHEL 9 and CentOS Stream 9](https://access.redhat.com/solutions/1479623) are examples of such distributions.
The new default [comes from modern systemd](https://github.com/systemd/systemd/commit/a8b627aaed409a15260c25988970c795bf963812).

See [rabbitmq/rabbitmq-server#5684](https://github.com/rabbitmq/rabbitmq-server/pull/5684) and [docker-library/rabbitmq#545](https://github.com/docker-library/rabbitmq/issues/545#issuecomment-1224977154)
for details.

### Client Library Compatibility

Client libraries that were compatible with RabbitMQ `3.10.x` will be compatible with `3.11.0`.



### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Enhancements

 * Some features flags have [graduated to always enabled](https://blog.rabbitmq.com/posts/2022/07/required-feature-flags-in-rabbitmq-3.11/).
   This means that they must be enabled before upgrading to 3.11. If that is not the case, the upgrade process will not proceed.

 * More efficient connection tracking. This means less CPU load in environments where high [connection churn](https://www.rabbitmq.com/connections.html#high-connection-churn)
   cannot be avoided.

   In part contributed by @gomoripeti.

   GitHub issue: [#5610](https://github.com/rabbitmq/rabbitmq-server/pull/5610)

 * 10% to 20% throughput gain for publishers that use the default exchange.

   GitHub issue: [#4606](https://github.com/rabbitmq/rabbitmq-server/pull/4606)

 * When a virtual host is added, it now can be configured with default queue type.

   In part contributed by @adamncasey.

   GitHub issues: [#5305](https://github.com/rabbitmq/rabbitmq-server/pull/5305), [#5769](https://github.com/rabbitmq/rabbitmq-server/pull/5769)

#### Bug Fixes

 * Durable classic queues could get "lost" under certain conditions when a node failed.

   GitHub issue: [#4563](https://github.com/rabbitmq/rabbitmq-server/pull/4563)

 * Nodes could get stuck when performing a rolling restart on Kubernetes where DNS hostname
   resolution was not available early on node boot.
   For example, this is the case with a [popular default caching setting of CoreDNS](https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#stable-network-id).

   GitHub issue: [#5438](https://github.com/rabbitmq/rabbitmq-server/pull/5438)

 * More robust free disk space monitoring implementation for Windows.

   GitHub issue: [#5738](https://github.com/rabbitmq/rabbitmq-server/pull/5738)


### Stream Plugin

#### Enhancement

 * RabbitMQ now supports [partitioned streams](https://blog.rabbitmq.com/posts/2022/07/rabbitmq-3-11-feature-preview-super-streams/) (super streams).
   Super streams are a way to scale out by partitioning a large stream into smaller streams.

 * Stream protocol clients and RabbitMQ nodes now have a mechanism of exchanging
   their capabilities (sets of supported commands).

   GitHub issue: [#5308](https://github.com/rabbitmq/rabbitmq-server/issues/5308)

 * New stream protocol command that allows certain stream metadata to be inspected by
   applications.

   GitHub issue: [#5412](https://github.com/rabbitmq/rabbitmq-server/issues/5412)

 * [Single Active Consumer support for streams](https://blog.rabbitmq.com/posts/2022/07/rabbitmq-3-11-feature-preview-single-active-consumer-for-streams/).

   GitHub issue: [#3754](https://github.com/rabbitmq/rabbitmq-server/pull/3754)

 * Consumers now have access to their committed offset information.

   GitHub issue: [#5307](https://github.com/rabbitmq/rabbitmq-server/issues/5307)


### OAuth 2 AuthN/AuthZ Backend Plugin

#### Enhancements

 * OAuth 2 plugin now [supports more identity providers and OpenID Connect](https://blog.rabbitmq.com/posts/2022/07/oidc-integration/).

   GitHub issue: [#4749](https://github.com/rabbitmq/rabbitmq-server/pull/4749)

 * OAuth 2 plugin now supports [Rich Authorization Requests](https://oauth.net/2/rich-authorization-requests/).

   GitHub issue: [#5234](https://github.com/rabbitmq/rabbitmq-server/pull/5234)


### Grafana Dashboards

#### Bug Fixes

 * Some counters on the Overview page have been moved to global counters introduced in RabbitMQ 3.9.

   GitHub issue: [#5463](https://github.com/rabbitmq/rabbitmq-server/pull/5463)


### Management Plugin

#### Enhancements

 * Management UI OAuth 2 integration supports more identity providers and [OpenID Connect](https://openid.net/connect/).

   GitHub issue: [#4749](https://github.com/rabbitmq/rabbitmq-server/pull/4749)

 * HTTP API responses that render a large rest sets are now more efficient thanks to a more efficient JSON serialiser library used internally.
   Peak memory footprint of such queries is also double digit percent lower compared to v3.10.x.

   GitHub issue: [#5356](https://github.com/rabbitmq/rabbitmq-server/pull/5356)

 * New endpoints that can list and close connections of a specific user.

   Contributed by @NuwanSameera.

   GitHub issue: [#5319](https://github.com/rabbitmq/rabbitmq-server/pull/5319)


### MQTT Plugin

#### Enhancements

 * A way to configure an authentication timeout, much like in some other protocols RabbitMQ supports.

   Contributed by @gomoripeti.

   GitHub issue: [#5755](https://github.com/rabbitmq/rabbitmq-server/pull/5755)


### STOMP Plugin

#### Enhancements

 * A way to configure an authentication timeout, much like in some other protocols RabbitMQ supports.

   Contributed by @gomoripeti.

   GitHub issue: [#5755](https://github.com/rabbitmq/rabbitmq-server/pull/5755)


### Shovel Plugin

#### Enhancements

 * Dynamic Shovels that use the "on publish" mode now use flow control internally to avoid balooning
   Shovel memory usage when the publishing side outpaces its target node.

   Contributed by @gomoripeti.

   GitHub issue: [#5715](https://github.com/rabbitmq/rabbitmq-server/pull/5715)


### Dependency Changes

 * `ra` upgraded to [`2.3.0`](https://github.com/rabbitmq/ra/releases)
 * `osiris` upgraded to [`1.3.0`](https://github.com/rabbitmq/osiris/tags)
 * `prometheus` upgraded to [`4.9.0`](https://github.com/deadtrickster/prometheus.erl/tags)
 * `jsx` was replaced with [`thoas`](https://github.com/lpil/thoas)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.0.tar.xz`
instead of the source tarball produced by GitHub.
