/*
 *	time related utilities
 *
 *	Copyright (C) 2021 SUSE LCC
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 *	Authors:
 *		Marius Tomaschewski
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	See the wicked project at <https://github.com/openSUSE/wicked>.
 *
 */
#ifndef NETCONTROL_TUTILS_H
#define NETCONTROL_TUTILS_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sys/time.h>

int		nc_get_time(struct timeval *now);
int		nc_get_time_delta(struct timeval *beg, struct timeval *end, struct timeval *delta);
int		nc_get_time_elapsed(struct timeval *started, struct timeval *elapsed);

#endif /* NETCONTROL_NUTILS_H */
